import { MockHealth } from "testHelpers/entities";
import type { StoryObj } from "@storybook/react-vite";
import { HEALTH_QUERY_KEY } from "api/queries/debug";
import type { HealthcheckReport } from "api/typesGenerated";
import { generateMeta } from "./storybook";
import WebsocketPage from "./WebsocketPage";

const meta = {
	title: "pages/Health/Websocket",
	...generateMeta({
		path: "/health/websocket",
		element: <WebsocketPage />,
	}),
};

export default meta;
type Story = StoryObj;

const Example: Story = {};

const settingsWithError: HealthcheckReport = {
	...MockHealth,
	severity: "error",
	websocket: {
		...MockHealth.websocket,
		severity: "error",
		error:
			'EACS03: get healthz endpoint: Get "https://localhost:7080/healthz": http: server gave HTTP response to HTTPS client',
	},
};

export const WithError: Story = {
	parameters: {
		queries: [
			...meta.parameters.queries,
			{
				key: HEALTH_QUERY_KEY,
				data: settingsWithError,
			},
		],
	},
};

export { Example as Websocket };
