import type { Template, UpdateTemplateMeta } from "api/typesGenerated";
import { PageHeader, PageHeaderTitle } from "components/PageHeader/PageHeader";
import type { ComponentProps, FC } from "react";
import { TemplateScheduleForm } from "./TemplateScheduleForm";

interface TemplateSchedulePageViewProps {
	template: Template;
	onSubmit: (data: UpdateTemplateMeta) => void;
	onCancel: () => void;
	isSubmitting: boolean;
	submitError?: unknown;
	initialTouched?: ComponentProps<
		typeof TemplateScheduleForm
	>["initialTouched"];
	allowAdvancedScheduling: boolean;
}

export const TemplateSchedulePageView: FC<TemplateSchedulePageViewProps> = ({
	template,
	onCancel,
	onSubmit,
	isSubmitting,
	allowAdvancedScheduling,
	submitError,
	initialTouched,
}) => {
	return (
		<>
			<PageHeader css={{ paddingTop: 0 }}>
				<PageHeaderTitle>Template schedule</PageHeaderTitle>
			</PageHeader>

			<TemplateScheduleForm
				allowAdvancedScheduling={allowAdvancedScheduling}
				initialTouched={initialTouched}
				isSubmitting={isSubmitting}
				template={template}
				onSubmit={onSubmit}
				onCancel={onCancel}
				error={submitError}
			/>
		</>
	);
};
