import { useTheme } from "@emotion/react";
import type { ProvisionerJobLog } from "api/typesGenerated";
import { Loader } from "components/Loader/Loader";
import { WorkspaceBuildLogs } from "modules/workspaces/WorkspaceBuildLogs/WorkspaceBuildLogs";
import type { FC } from "react";

interface WorkspaceBuildLogsSectionProps {
	logs?: ProvisionerJobLog[];
}

export const WorkspaceBuildLogsSection: FC<WorkspaceBuildLogsSectionProps> = ({
	logs,
}) => {
	const theme = useTheme();

	return (
		<div
			css={{
				borderRadius: 8,
				border: `1px solid ${theme.palette.divider}`,
				overflow: "hidden",
				background: theme.palette.background.default,
			}}
		>
			<header
				css={{
					background: theme.palette.background.paper,
					borderBottom: `1px solid ${theme.palette.divider}`,
					padding: "8px 8px 8px 24px",
					fontSize: 13,
					fontWeight: 600,
					display: "flex",
					alignItems: "center",
					borderRadius: "8px 8px 0 0",
				}}
			>
				Build logs
			</header>
			<div css={{ height: "400px", overflowY: "auto" }}>
				{logs ? (
					<WorkspaceBuildLogs
						sticky
						logs={logs}
						css={{ border: 0, borderRadius: 0 }}
					/>
				) : (
					<div
						css={{
							display: "flex",
							alignItems: "center",
							justifyContent: "center",
							width: "100%",
							height: "100%",
						}}
					>
						<Loader />
					</div>
				)}
			</div>
		</div>
	);
};
