// DO NOT EDIT.
// swift-format-ignore-file
// swiftlint:disable all
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: synchronization_configuration.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

//
// This file was taken from
// https://github.com/mutagen-io/mutagen/tree/v0.18.1/pkg/synchronization/configuration.proto
//
// MIT License
// 
// Copyright (c) 2016-present Docker, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// Configuration encodes session configuration parameters. It is used for create
/// commands to specify configuration options, for loading global configuration
/// options, and for storing a merged configuration inside sessions. It should be
/// considered immutable.
struct Synchronization_Configuration: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// SynchronizationMode specifies the synchronization mode that should be
  /// used in synchronization.
  var synchronizationMode: Core_SynchronizationMode {
    get {return _storage._synchronizationMode}
    set {_uniqueStorage()._synchronizationMode = newValue}
  }

  /// HashingAlgorithm specifies the content hashing algorithm used to track
  /// content and perform differential transfers.
  var hashingAlgorithm: Hashing_Algorithm {
    get {return _storage._hashingAlgorithm}
    set {_uniqueStorage()._hashingAlgorithm = newValue}
  }

  /// MaximumEntryCount specifies the maximum number of filesystem entries that
  /// endpoints will tolerate managing. A zero value indicates no limit.
  var maximumEntryCount: UInt64 {
    get {return _storage._maximumEntryCount}
    set {_uniqueStorage()._maximumEntryCount = newValue}
  }

  /// MaximumStagingFileSize is the maximum (individual) file size that
  /// endpoints will stage. A zero value indicates no limit.
  var maximumStagingFileSize: UInt64 {
    get {return _storage._maximumStagingFileSize}
    set {_uniqueStorage()._maximumStagingFileSize = newValue}
  }

  /// ProbeMode specifies the filesystem probing mode.
  var probeMode: Behavior_ProbeMode {
    get {return _storage._probeMode}
    set {_uniqueStorage()._probeMode = newValue}
  }

  /// ScanMode specifies the synchronization root scanning mode.
  var scanMode: Synchronization_ScanMode {
    get {return _storage._scanMode}
    set {_uniqueStorage()._scanMode = newValue}
  }

  /// StageMode specifies the file staging mode.
  var stageMode: Synchronization_StageMode {
    get {return _storage._stageMode}
    set {_uniqueStorage()._stageMode = newValue}
  }

  /// SymbolicLinkMode specifies the symbolic link mode.
  var symbolicLinkMode: Core_SymbolicLinkMode {
    get {return _storage._symbolicLinkMode}
    set {_uniqueStorage()._symbolicLinkMode = newValue}
  }

  /// WatchMode specifies the filesystem watching mode.
  var watchMode: Synchronization_WatchMode {
    get {return _storage._watchMode}
    set {_uniqueStorage()._watchMode = newValue}
  }

  /// WatchPollingInterval specifies the interval (in seconds) for poll-based
  /// file monitoring. A value of 0 specifies that the default interval should
  /// be used.
  var watchPollingInterval: UInt32 {
    get {return _storage._watchPollingInterval}
    set {_uniqueStorage()._watchPollingInterval = newValue}
  }

  /// IgnoreSyntax specifies the syntax and semantics to use for ignores.
  /// NOTE: This field is out of order due to the historical order in which it
  /// was added.
  var ignoreSyntax: Ignore_Syntax {
    get {return _storage._ignoreSyntax}
    set {_uniqueStorage()._ignoreSyntax = newValue}
  }

  /// DefaultIgnores specifies the ignore patterns brought in from the global
  /// configuration.
  /// DEPRECATED: This field is no longer used when loading from global
  /// configuration. Instead, ignores provided by global configuration are
  /// simply merged into the ignore list of the main configuration. However,
  /// older sessions still use this field.
  var defaultIgnores: [String] {
    get {return _storage._defaultIgnores}
    set {_uniqueStorage()._defaultIgnores = newValue}
  }

  /// Ignores specifies the ignore patterns brought in from the create request.
  var ignores: [String] {
    get {return _storage._ignores}
    set {_uniqueStorage()._ignores = newValue}
  }

  /// IgnoreVCSMode specifies the VCS ignore mode that should be used in
  /// synchronization.
  var ignoreVcsmode: Ignore_IgnoreVCSMode {
    get {return _storage._ignoreVcsmode}
    set {_uniqueStorage()._ignoreVcsmode = newValue}
  }

  /// PermissionsMode species the manner in which permissions should be
  /// propagated between endpoints.
  var permissionsMode: Core_PermissionsMode {
    get {return _storage._permissionsMode}
    set {_uniqueStorage()._permissionsMode = newValue}
  }

  /// DefaultFileMode specifies the default permission mode to use for new
  /// files in "portable" permission propagation mode.
  var defaultFileMode: UInt32 {
    get {return _storage._defaultFileMode}
    set {_uniqueStorage()._defaultFileMode = newValue}
  }

  /// DefaultDirectoryMode specifies the default permission mode to use for new
  /// files in "portable" permission propagation mode.
  var defaultDirectoryMode: UInt32 {
    get {return _storage._defaultDirectoryMode}
    set {_uniqueStorage()._defaultDirectoryMode = newValue}
  }

  /// DefaultOwner specifies the default owner identifier to use when setting
  /// ownership of new files and directories in "portable" permission
  /// propagation mode.
  var defaultOwner: String {
    get {return _storage._defaultOwner}
    set {_uniqueStorage()._defaultOwner = newValue}
  }

  /// DefaultGroup specifies the default group identifier to use when setting
  /// ownership of new files and directories in "portable" permission
  /// propagation mode.
  var defaultGroup: String {
    get {return _storage._defaultGroup}
    set {_uniqueStorage()._defaultGroup = newValue}
  }

  /// CompressionAlgorithm specifies the compression algorithm to use when
  /// communicating with the endpoint. This only applies to remote endpoints.
  var compressionAlgorithm: Compression_Algorithm {
    get {return _storage._compressionAlgorithm}
    set {_uniqueStorage()._compressionAlgorithm = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "synchronization"

extension Synchronization_Configuration: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Configuration"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    11: .same(proto: "synchronizationMode"),
    17: .same(proto: "hashingAlgorithm"),
    12: .same(proto: "maximumEntryCount"),
    13: .same(proto: "maximumStagingFileSize"),
    14: .same(proto: "probeMode"),
    15: .same(proto: "scanMode"),
    16: .same(proto: "stageMode"),
    1: .same(proto: "symbolicLinkMode"),
    21: .same(proto: "watchMode"),
    22: .same(proto: "watchPollingInterval"),
    34: .same(proto: "ignoreSyntax"),
    31: .same(proto: "defaultIgnores"),
    32: .same(proto: "ignores"),
    33: .same(proto: "ignoreVCSMode"),
    61: .same(proto: "permissionsMode"),
    63: .same(proto: "defaultFileMode"),
    64: .same(proto: "defaultDirectoryMode"),
    65: .same(proto: "defaultOwner"),
    66: .same(proto: "defaultGroup"),
    81: .same(proto: "compressionAlgorithm"),
  ]

  fileprivate class _StorageClass {
    var _synchronizationMode: Core_SynchronizationMode = .default
    var _hashingAlgorithm: Hashing_Algorithm = .default
    var _maximumEntryCount: UInt64 = 0
    var _maximumStagingFileSize: UInt64 = 0
    var _probeMode: Behavior_ProbeMode = .default
    var _scanMode: Synchronization_ScanMode = .default
    var _stageMode: Synchronization_StageMode = .default
    var _symbolicLinkMode: Core_SymbolicLinkMode = .default
    var _watchMode: Synchronization_WatchMode = .default
    var _watchPollingInterval: UInt32 = 0
    var _ignoreSyntax: Ignore_Syntax = .default
    var _defaultIgnores: [String] = []
    var _ignores: [String] = []
    var _ignoreVcsmode: Ignore_IgnoreVCSMode = .default
    var _permissionsMode: Core_PermissionsMode = .default
    var _defaultFileMode: UInt32 = 0
    var _defaultDirectoryMode: UInt32 = 0
    var _defaultOwner: String = String()
    var _defaultGroup: String = String()
    var _compressionAlgorithm: Compression_Algorithm = .default

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _synchronizationMode = source._synchronizationMode
      _hashingAlgorithm = source._hashingAlgorithm
      _maximumEntryCount = source._maximumEntryCount
      _maximumStagingFileSize = source._maximumStagingFileSize
      _probeMode = source._probeMode
      _scanMode = source._scanMode
      _stageMode = source._stageMode
      _symbolicLinkMode = source._symbolicLinkMode
      _watchMode = source._watchMode
      _watchPollingInterval = source._watchPollingInterval
      _ignoreSyntax = source._ignoreSyntax
      _defaultIgnores = source._defaultIgnores
      _ignores = source._ignores
      _ignoreVcsmode = source._ignoreVcsmode
      _permissionsMode = source._permissionsMode
      _defaultFileMode = source._defaultFileMode
      _defaultDirectoryMode = source._defaultDirectoryMode
      _defaultOwner = source._defaultOwner
      _defaultGroup = source._defaultGroup
      _compressionAlgorithm = source._compressionAlgorithm
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularEnumField(value: &_storage._symbolicLinkMode) }()
        case 11: try { try decoder.decodeSingularEnumField(value: &_storage._synchronizationMode) }()
        case 12: try { try decoder.decodeSingularUInt64Field(value: &_storage._maximumEntryCount) }()
        case 13: try { try decoder.decodeSingularUInt64Field(value: &_storage._maximumStagingFileSize) }()
        case 14: try { try decoder.decodeSingularEnumField(value: &_storage._probeMode) }()
        case 15: try { try decoder.decodeSingularEnumField(value: &_storage._scanMode) }()
        case 16: try { try decoder.decodeSingularEnumField(value: &_storage._stageMode) }()
        case 17: try { try decoder.decodeSingularEnumField(value: &_storage._hashingAlgorithm) }()
        case 21: try { try decoder.decodeSingularEnumField(value: &_storage._watchMode) }()
        case 22: try { try decoder.decodeSingularUInt32Field(value: &_storage._watchPollingInterval) }()
        case 31: try { try decoder.decodeRepeatedStringField(value: &_storage._defaultIgnores) }()
        case 32: try { try decoder.decodeRepeatedStringField(value: &_storage._ignores) }()
        case 33: try { try decoder.decodeSingularEnumField(value: &_storage._ignoreVcsmode) }()
        case 34: try { try decoder.decodeSingularEnumField(value: &_storage._ignoreSyntax) }()
        case 61: try { try decoder.decodeSingularEnumField(value: &_storage._permissionsMode) }()
        case 63: try { try decoder.decodeSingularUInt32Field(value: &_storage._defaultFileMode) }()
        case 64: try { try decoder.decodeSingularUInt32Field(value: &_storage._defaultDirectoryMode) }()
        case 65: try { try decoder.decodeSingularStringField(value: &_storage._defaultOwner) }()
        case 66: try { try decoder.decodeSingularStringField(value: &_storage._defaultGroup) }()
        case 81: try { try decoder.decodeSingularEnumField(value: &_storage._compressionAlgorithm) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      if _storage._symbolicLinkMode != .default {
        try visitor.visitSingularEnumField(value: _storage._symbolicLinkMode, fieldNumber: 1)
      }
      if _storage._synchronizationMode != .default {
        try visitor.visitSingularEnumField(value: _storage._synchronizationMode, fieldNumber: 11)
      }
      if _storage._maximumEntryCount != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._maximumEntryCount, fieldNumber: 12)
      }
      if _storage._maximumStagingFileSize != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._maximumStagingFileSize, fieldNumber: 13)
      }
      if _storage._probeMode != .default {
        try visitor.visitSingularEnumField(value: _storage._probeMode, fieldNumber: 14)
      }
      if _storage._scanMode != .default {
        try visitor.visitSingularEnumField(value: _storage._scanMode, fieldNumber: 15)
      }
      if _storage._stageMode != .default {
        try visitor.visitSingularEnumField(value: _storage._stageMode, fieldNumber: 16)
      }
      if _storage._hashingAlgorithm != .default {
        try visitor.visitSingularEnumField(value: _storage._hashingAlgorithm, fieldNumber: 17)
      }
      if _storage._watchMode != .default {
        try visitor.visitSingularEnumField(value: _storage._watchMode, fieldNumber: 21)
      }
      if _storage._watchPollingInterval != 0 {
        try visitor.visitSingularUInt32Field(value: _storage._watchPollingInterval, fieldNumber: 22)
      }
      if !_storage._defaultIgnores.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._defaultIgnores, fieldNumber: 31)
      }
      if !_storage._ignores.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._ignores, fieldNumber: 32)
      }
      if _storage._ignoreVcsmode != .default {
        try visitor.visitSingularEnumField(value: _storage._ignoreVcsmode, fieldNumber: 33)
      }
      if _storage._ignoreSyntax != .default {
        try visitor.visitSingularEnumField(value: _storage._ignoreSyntax, fieldNumber: 34)
      }
      if _storage._permissionsMode != .default {
        try visitor.visitSingularEnumField(value: _storage._permissionsMode, fieldNumber: 61)
      }
      if _storage._defaultFileMode != 0 {
        try visitor.visitSingularUInt32Field(value: _storage._defaultFileMode, fieldNumber: 63)
      }
      if _storage._defaultDirectoryMode != 0 {
        try visitor.visitSingularUInt32Field(value: _storage._defaultDirectoryMode, fieldNumber: 64)
      }
      if !_storage._defaultOwner.isEmpty {
        try visitor.visitSingularStringField(value: _storage._defaultOwner, fieldNumber: 65)
      }
      if !_storage._defaultGroup.isEmpty {
        try visitor.visitSingularStringField(value: _storage._defaultGroup, fieldNumber: 66)
      }
      if _storage._compressionAlgorithm != .default {
        try visitor.visitSingularEnumField(value: _storage._compressionAlgorithm, fieldNumber: 81)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Synchronization_Configuration, rhs: Synchronization_Configuration) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._synchronizationMode != rhs_storage._synchronizationMode {return false}
        if _storage._hashingAlgorithm != rhs_storage._hashingAlgorithm {return false}
        if _storage._maximumEntryCount != rhs_storage._maximumEntryCount {return false}
        if _storage._maximumStagingFileSize != rhs_storage._maximumStagingFileSize {return false}
        if _storage._probeMode != rhs_storage._probeMode {return false}
        if _storage._scanMode != rhs_storage._scanMode {return false}
        if _storage._stageMode != rhs_storage._stageMode {return false}
        if _storage._symbolicLinkMode != rhs_storage._symbolicLinkMode {return false}
        if _storage._watchMode != rhs_storage._watchMode {return false}
        if _storage._watchPollingInterval != rhs_storage._watchPollingInterval {return false}
        if _storage._ignoreSyntax != rhs_storage._ignoreSyntax {return false}
        if _storage._defaultIgnores != rhs_storage._defaultIgnores {return false}
        if _storage._ignores != rhs_storage._ignores {return false}
        if _storage._ignoreVcsmode != rhs_storage._ignoreVcsmode {return false}
        if _storage._permissionsMode != rhs_storage._permissionsMode {return false}
        if _storage._defaultFileMode != rhs_storage._defaultFileMode {return false}
        if _storage._defaultDirectoryMode != rhs_storage._defaultDirectoryMode {return false}
        if _storage._defaultOwner != rhs_storage._defaultOwner {return false}
        if _storage._defaultGroup != rhs_storage._defaultGroup {return false}
        if _storage._compressionAlgorithm != rhs_storage._compressionAlgorithm {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
