// DO NOT EDIT.
// swift-format-ignore-file
// swiftlint:disable all
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: synchronization_core_conflict.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

//
// This file was taken from
// https://github.com/mutagen-io/mutagen/tree/v0.18.1/pkg/synchronization/core/conflict.proto
//
// MIT License
// 
// Copyright (c) 2016-present Docker, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// Conflict encodes conflicting changes on alpha and beta that prevent
/// synchronization of a particular path. Conflict objects should be considered
/// immutable and must not be modified.
struct Core_Conflict: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Root is the root path for the conflict (relative to the synchronization
  /// root). While this can (in theory) be computed based on the change lists
  /// contained within the conflict, doing so relies on those change lists
  /// being constructed and ordered in a particular manner that's not possible
  /// to enforce. Additionally, conflicts are often sorted by their root path,
  /// and dynamically computing it on every sort comparison operation would be
  /// prohibitively expensive.
  var root: String = String()

  /// AlphaChanges are the relevant changes on alpha.
  var alphaChanges: [Core_Change] = []

  /// BetaChanges are the relevant changes on beta.
  var betaChanges: [Core_Change] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "core"

extension Core_Conflict: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Conflict"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "root"),
    2: .same(proto: "alphaChanges"),
    3: .same(proto: "betaChanges"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.root) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.alphaChanges) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.betaChanges) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.root.isEmpty {
      try visitor.visitSingularStringField(value: self.root, fieldNumber: 1)
    }
    if !self.alphaChanges.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.alphaChanges, fieldNumber: 2)
    }
    if !self.betaChanges.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.betaChanges, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Core_Conflict, rhs: Core_Conflict) -> Bool {
    if lhs.root != rhs.root {return false}
    if lhs.alphaChanges != rhs.alphaChanges {return false}
    if lhs.betaChanges != rhs.betaChanges {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
