// DO NOT EDIT.
// swift-format-ignore-file
// swiftlint:disable all
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: synchronization_core_entry.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

//
// This file was taken from
// https://github.com/mutagen-io/mutagen/tree/v0.18.1/pkg/synchronization/core/entry.proto
//
// MIT License
// 
// Copyright (c) 2016-present Docker, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

import Foundation
import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// EntryKind encodes the type of entry represented by an Entry object.
enum Core_EntryKind: SwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int

  /// EntryKind_Directory indicates a directory.
  case directory // = 0

  /// EntryKind_File indicates a regular file.
  case file // = 1

  /// EntryKind_SymbolicLink indicates a symbolic link.
  case symbolicLink // = 2

  /// EntryKind_Untracked indicates content (or the root of content) that is
  /// intentionally excluded from synchronization by Mutagen. This includes
  /// explicitly ignored content, content that is ignored due to settings (such
  /// as symbolic links in the "ignore" symbolic link mode), as well as content
  /// types that Mutagen doesn't understand and/or have a way to propagate
  /// (such as FIFOs and Unix domain sockets). This type of entry is not
  /// synchronizable.
  case untracked // = 100

  /// EntryKind_Problematic indicates content (or the root of content) that
  /// would normally be synchronized, but which is currently inaccessible to
  /// scanning. This includes (but is not limited to) content that is modified
  /// concurrently with scanning, content that is inaccessible due to
  /// permissions, content that can't be read due to filesystem errors, content
  /// that cannot be properly encoded given the current settings (such as
  /// absolute symbolic links found when using the "portable" symbolic link
  /// mode), and content that Mutagen cannot scan or watch reliably (such as
  /// directories that are also mount points). This type of entry is not
  /// synchronizable.
  case problematic // = 101

  /// EntryKind_PhantomDirectory indicates a directory that was recorded with
  /// an ignore mask. This type is used to support Docker-style ignore syntax
  /// and semantics, which allow directories to be unignored by child content
  /// that is explicitly unignored. This type is pseudo-synchronizable; entries
  /// containing phantom contents must have those contents reified (to tracked
  /// or ignored directories) using ReifyPhantomDirectories before Reconcile.
  case phantomDirectory // = 102
  case UNRECOGNIZED(Int)

  init() {
    self = .directory
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .directory
    case 1: self = .file
    case 2: self = .symbolicLink
    case 100: self = .untracked
    case 101: self = .problematic
    case 102: self = .phantomDirectory
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .directory: return 0
    case .file: return 1
    case .symbolicLink: return 2
    case .untracked: return 100
    case .problematic: return 101
    case .phantomDirectory: return 102
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [Core_EntryKind] = [
    .directory,
    .file,
    .symbolicLink,
    .untracked,
    .problematic,
    .phantomDirectory,
  ]

}

/// Entry encodes a filesystem entry (e.g. a directory, a file, or a symbolic
/// link). A nil Entry represents an absence of content. An zero-value Entry
/// represents an empty Directory. Entry objects should be considered immutable
/// and must not be modified.
struct Core_Entry: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Kind encodes the type of filesystem entry being represented.
  var kind: Core_EntryKind = .directory

  /// Contents represents a directory entry's contents. It must only be non-nil
  /// for directory entries.
  var contents: Dictionary<String,Core_Entry> = [:]

  /// Digest represents the hash of a file entry's contents. It must only be
  /// non-nil for file entries.
  var digest: Data = Data()

  /// Executable indicates whether or not a file entry is marked as executable.
  /// It must only be set (if appropriate) for file entries.
  var executable: Bool = false

  /// Target is the symbolic link target for symbolic link entries. It must be
  /// non-empty if and only if the entry is a symbolic link.
  var target: String = String()

  /// Problem indicates the relevant error for problematic content. It must be
  /// non-empty if and only if the entry represents problematic content.
  var problem: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "core"

extension Core_EntryKind: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "Directory"),
    1: .same(proto: "File"),
    2: .same(proto: "SymbolicLink"),
    100: .same(proto: "Untracked"),
    101: .same(proto: "Problematic"),
    102: .same(proto: "PhantomDirectory"),
  ]
}

extension Core_Entry: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Entry"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "kind"),
    5: .same(proto: "contents"),
    8: .same(proto: "digest"),
    9: .same(proto: "executable"),
    12: .same(proto: "target"),
    15: .same(proto: "problem"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.kind) }()
      case 5: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Core_Entry>.self, value: &self.contents) }()
      case 8: try { try decoder.decodeSingularBytesField(value: &self.digest) }()
      case 9: try { try decoder.decodeSingularBoolField(value: &self.executable) }()
      case 12: try { try decoder.decodeSingularStringField(value: &self.target) }()
      case 15: try { try decoder.decodeSingularStringField(value: &self.problem) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.kind != .directory {
      try visitor.visitSingularEnumField(value: self.kind, fieldNumber: 1)
    }
    if !self.contents.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Core_Entry>.self, value: self.contents, fieldNumber: 5)
    }
    if !self.digest.isEmpty {
      try visitor.visitSingularBytesField(value: self.digest, fieldNumber: 8)
    }
    if self.executable != false {
      try visitor.visitSingularBoolField(value: self.executable, fieldNumber: 9)
    }
    if !self.target.isEmpty {
      try visitor.visitSingularStringField(value: self.target, fieldNumber: 12)
    }
    if !self.problem.isEmpty {
      try visitor.visitSingularStringField(value: self.problem, fieldNumber: 15)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Core_Entry, rhs: Core_Entry) -> Bool {
    if lhs.kind != rhs.kind {return false}
    if lhs.contents != rhs.contents {return false}
    if lhs.digest != rhs.digest {return false}
    if lhs.executable != rhs.executable {return false}
    if lhs.target != rhs.target {return false}
    if lhs.problem != rhs.problem {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
