/**
 * myscript - The JavaScript library for the MyScript Cloud recognition service
 * @version 
 * @link https://myscript.github.io/MyScriptJS/
 * @license Apache-2.0
 */
!function(){function t(t,e){e=e||{bubbles:!1,cancelable:!1,detail:void 0};var n=document.createEvent("CustomEvent");return n.initCustomEvent(t,e.bubbles,e.cancelable,e.detail),n}t.prototype=window.Event.prototype,window.CustomEvent=t,Function.prototype.bind||(Function.prototype.bind=function(t){if("function"!=typeof this)throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");var e=Array.prototype.slice.call(arguments,1),n=this,o=function(){},i=function(){return n.apply(this instanceof o?this:t,e.concat(Array.prototype.slice.call(arguments)))};return o.prototype=this.prototype,i.prototype=new o,i})}(),MyScript={RecognitionType:{TEXT:"TEXT",MATH:"MATH",SHAPE:"SHAPE",MUSIC:"MUSIC",ANALYZER:"ANALYZER"},InputMode:{CURSIVE:"CURSIVE",ISOLATED:"ISOLATED",SUPERIMPOSED:"SUPERIMPOSED",VERTICAL:"VERTICAL"},InputType:{CHAR:"CHAR",WORD:"WORD",SINGLE_LINE_TEXT:"SINGLE_LINE_TEXT",MULTI_LINE_TEXT:"MULTI_LINE_TEXT"},ResultDetail:{TEXT:"TEXT",WORD:"WORD",CHARACTER:"CHARACTER"},ResultType:{Math:{LATEX:"LATEX",MATHML:"MATHML",SYMBOLTREE:"SYMBOLTREE",OFFICEOPENXMLMATH:"OFFICEOPENXMLMATH"},Music:{MUSICXML:"MUSICXML",SCORETREE:"SCORETREE"}},Protocol:{WS:"WebSocket",REST:"REST"}},function(t){function e(t){t&&(this.x=t.x,this.y=t.y)}e.prototype.getX=function(){return this.x},e.prototype.setX=function(t){this.x=t},e.prototype.getY=function(){return this.y},e.prototype.setY=function(t){this.y=t},t.Point=e}(MyScript),function(t){function e(t){t&&(this.x=t.x,this.y=t.y,this.width=t.width,this.height=t.height)}e.prototype.getX=function(){return this.x},e.prototype.setX=function(t){this.x=t},e.prototype.getY=function(){return this.y},e.prototype.setY=function(t){this.y=t},e.prototype.getTopLeftPoint=function(){var e=new t.Point;return e.setX(this.x),e.setY(this.y),e},e.prototype.setTopLeftPoint=function(t){this.x=t.getX(),this.y=t.getY()},e.prototype.getWidth=function(){return this.width},e.prototype.setWidth=function(t){this.width=t},e.prototype.getHeight=function(){return this.height},e.prototype.setHeight=function(t){this.height=t},t.Rectangle=e}(MyScript),function(t){function e(t){this.color="rgba(0, 0, 0, 0.9)",this.rectColor="rgba(0, 0, 0, 0.2)",this.font="Times New Roman",this.decoration="normal",this.width=4,this.pressureType="SIMULATED",this.alpha="1.0",t&&(this.color=t.color,this.rectColor=t.rectColor,this.font=t.font,this.decoration=t.decoration,this.width=t.width,this.pressureType=t.pressureType,this.alpha=t.alpha)}e.prototype.getColor=function(){return this.color},e.prototype.setColor=function(t){this.color=t},e.prototype.getRectColor=function(){return this.rectColor},e.prototype.setRectColor=function(t){this.rectColor=t},e.prototype.getFont=function(){return this.font},e.prototype.setFont=function(t){this.font=t},e.prototype.getDecoration=function(){return this.decoration},e.prototype.setDecoration=function(t){this.decoration=t},e.prototype.getWidth=function(){return this.width},e.prototype.setWidth=function(t){this.width=t},t.PenParameters=e}(MyScript),function(t){function e(){}e.getEllipseArcRect=function(e,n,o,i,r,s){var a,c,p,u,h,l,g,f,y,d,m,S,R,M,w,C,v,b,T=.02,I=function(t,e){return t-e};for(p=u=Math.cos(i),h=l=Math.sin(i),p*=n,u*=o,h*=n,l*=o,y=Math.abs(s)/T,d=[],m=[],S=0;y>=S;S++)a=r+S/y*s,c=Math.atan2(Math.sin(a)/o,Math.cos(a)/n),g=Math.cos(c),f=Math.sin(c),R=e.x+p*g-l*f,M=e.y+u*f+h*g,d.push(R),m.push(M);return d.sort(I),m.sort(I),w=d[0],C=d[d.length-1],v=m[0],b=m[m.length-1],new t.Rectangle({x:w,y:v,width:C-w,height:b-v})},e.getLineRect=function(e,n){var o=e.x,i=n.x,r=Math.min(o,i),s=Math.max(o,i),a=e.y,c=n.y,p=Math.min(a,c),u=Math.max(a,c);return new t.Rectangle({x:r,y:p,width:s-r,height:u-p})},e.getBoundingRect=function(e){var n=[],o=[];for(var i in e){var r=e[i];n.push(r.getX()),n.push(r.getX()+r.getWidth()),o.push(r.getY()),o.push(r.getY()+r.getHeight())}var s=Math.min.apply(Math,n),a=Math.max.apply(Math,n),c=Math.min.apply(Math,o),p=Math.max.apply(Math,o);return new t.Rectangle({x:s,y:c,width:a-s,height:p-c})},t.MathUtils=e}(MyScript),function(t){function e(t){t&&(this.type=t.type)}e.prototype.getType=function(){return this.type},t.AbstractWSMessage=e}(MyScript),function(t){function e(){}e.prototype.getType=function(){return this.type},e.prototype.setType=function(t){this.type=t},e.prototype.getBoundingBox=function(){throw new Error("not implemented")},e.prototype.setBoundingBox=function(t){throw new Error("not implemented")},t.AbstractComponent=e}(MyScript),function(t){function e(e){t.AbstractComponent.call(this),this.type="stroke",this.x=[],this.y=[],this.t=[],this.p=[],this.d=[],this.l=[],this.color=void 0,this.alpha=void 0,this.width=0,e&&(e.x&&(this.x=e.x),e.y&&(this.y=e.y),e.t&&(this.t=e.t),e.p&&(this.p=e.p),e.d&&(this.d=e.d),e.l&&(this.l=e.l),e.color&&(this.color=e.color),e.alpha&&(this.alpha=e.alpha),e.width&&(this.width=e.width))}function n(t,e,n,o,i){var r=Math.sqrt(Math.pow(e-o[i-1],2)+Math.pow(t-n[i-1],2));return isNaN(r)&&(r=0),r}function o(t,e,o,i,r,s){var a=r[s-1]+n(t,e,o,i,s);return isNaN(a)&&(a=0),a}function i(t,e,i,r,s,a){var c=1,p=n(t,e,i,r,a),u=o(t,e,i,r,s,a);0===u?c=.5:p==u?c=1:10>p?c=.2+Math.pow(.1*p,.4):p>u-10&&(c=.2+Math.pow(.1*(u-p),.4));var h=c*Math.max(.1,1-.1*Math.sqrt(p));return isNaN(parseFloat(h))&&(h=.5),h}function r(t,e,n,o,i,r,s){var a=2+r/4,c=!1;return(0===s||Math.abs(n[i]-t)>=a||Math.abs(o[i]-e)>=a)&&(c=!0),c}e.prototype=new t.AbstractComponent,e.prototype.constructor=e,e.prototype.toJSON=function(){return{type:this.type,x:this.x,y:this.y,t:this.t}},e.prototype.getX=function(){return this.x},e.prototype.setX=function(t){this.x=t},e.prototype.addX=function(t){null!==t&&void 0!==t&&this.x.push(t)},e.prototype.getY=function(){return this.y},e.prototype.setY=function(t){this.y=t},e.prototype.addY=function(t){null!==t&&void 0!==t&&this.y.push(t)},e.prototype.getT=function(){return this.t},e.prototype.setT=function(t){this.t=t},e.prototype.addT=function(t){null!==t&&void 0!==t&&this.t.push(t)},e.prototype.getLength=function(){return this.x.length},e.prototype.getBoundingBox=function(){var e=new t.Rectangle;return e.setX(Math.min.apply(Math,this.getX())),e.setY(Math.min.apply(Math,this.getY())),e.setWidth(Math.max.apply(Math,this.getX())-e.getX()),e.setHeight(Math.max.apply(Math,this.getY())-e.getY()),e},e.prototype.toFixed=function(t){if(void 0!==t)for(var e in this.x)this.x[e]=this.x[e].toFixed(t),this.y[e]=this.y[e].toFixed(t)},e.prototype.getP=function(){return this.p},e.prototype.setP=function(t){this.p=t},e.prototype.addP=function(t){null!==t&&void 0!==t&&this.p.push(t)},e.prototype.getD=function(){return this.d},e.prototype.setD=function(t){this.d=t},e.prototype.addD=function(t){null!==t&&void 0!==t&&this.d.push(t)},e.prototype.getL=function(){return this.l},e.prototype.setL=function(t){this.l=t},e.prototype.addL=function(t){null!==t&&void 0!==t&&this.l.push(t)},e.prototype.getColor=function(){return this.color},e.prototype.setColor=function(t){this.color=t},e.prototype.getWidth=function(){return this.width},e.prototype.setWidth=function(t){this.width=t},e.prototype.addPoint=function(t,e,s){r(t,e,this.getX(),this.getY(),this.getLastIndexPoint(),this.getWidth(),this.getLength())&&(this.addX(t),this.addY(e),this.addT(s),this.addP(i(t,e,this.getX(),this.getY(),this.getL(),this.getLastIndexPoint())),this.addD(n(t,e,this.getX(),this.getY(),this.getLastIndexPoint())),this.addL(o(t,e,this.getX(),this.getY(),this.getL(),this.getLastIndexPoint())))},e.prototype.getLastIndexPoint=function(){return this.x.length-1},e.prototype.getPointByIndex=function(t){var e;return void 0!==t&&t>=0&&t<this.getLength()&&(e={x:this.getX()[t],y:this.getY()[t],t:this.getT()[t],p:this.getP()[t],d:this.getD()[t],l:this.getL()[t]}),e},t.StrokeComponent=e}(MyScript),function(t){function e(e){if(t.AbstractComponent.call(this),this.type="inputCharacter",this.alternates=[],e){if(e.alternates)for(var n in e.alternates)this.alternates.push(new t.CharacterInputComponentAlternate(e.alternates[n]));e.boundingBox&&(this.boundingBox=new t.Rectangle(e.boundingBox))}}e.prototype=new t.AbstractComponent,e.prototype.constructor=e,e.prototype.getAlternates=function(){return this.alternates},e.prototype.setAlternates=function(t){this.alternates=t},e.prototype.addAlternate=function(t){this.alternates.push(t)},e.prototype.getBoundingBox=function(){return this.boundingBox},e.prototype.setBoundingBox=function(t){this.boundingBox=t},t.CharacterInputComponent=e}(MyScript),function(t){function e(t){t&&(t.alternate&&(this.alternate=t.alternate),t.probability&&(this.probability=t.probability))}e.prototype.getAlternate=function(){return this.alternate},e.prototype.setAlternate=function(t){this.alternate=t},e.prototype.getProbability=function(){return this.probability},e.prototype.setProbability=function(t){this.probability=t},t.CharacterInputComponentAlternate=e}(MyScript),function(t){function e(){}t.AbstractParameter=e}(MyScript),function(t){function e(){}t.AbstractRecognitionInput=e}(MyScript),function(t){function e(){}e.prototype.getApplicationKey=function(){return this.applicationKey},e.prototype.setApplicationKey=function(t){this.applicationKey=t},e.prototype.getInstanceId=function(){return this.instanceId},e.prototype.setInstanceId=function(t){this.instanceId=t},e.prototype.getHmac=function(){return this.hmac},e.prototype.setHmac=function(t){this.hmac=t},e.prototype.getRecognitionInput=function(){throw new Error("not implemented")},e.prototype.setRecognitionInput=function(t){throw new Error("not implemented")},t.AbstractRecognitionData=e}(MyScript),function(t){function e(){}e.prototype=new t.AbstractRecognitionData,e.prototype.constructor=e,e.prototype.getInputMode=function(){return this.inputMode},e.prototype.setInputMode=function(t){this.inputMode=t},t.RecognitionLanguagesData=e}(MyScript),function(t){function e(e){this.type="start",t.AbstractWSMessage.call(this,e)}e.prototype=new t.AbstractWSMessage,e.prototype.constructor=e,t.AbstractStartRequestWSMessage=e}(MyScript),function(t){function e(e){this.type="continue",t.AbstractWSMessage.call(this,e)}e.prototype=new t.AbstractWSMessage,e.prototype.constructor=e,e.prototype.getInstanceId=function(){return this.instanceId},e.prototype.setInstanceId=function(t){this.instanceId=t},t.AbstractContinueRequestWSMessage=e}(MyScript),function(t){function e(e){this.type="hmac",t.AbstractWSMessage.call(this,e)}e.prototype=new t.AbstractWSMessage,e.prototype.constructor=e,e.prototype.getChallenge=function(){return this.challenge},e.prototype.setChallenge=function(t){this.challenge=t},e.prototype.getApplicationKey=function(){return this.applicationKey},e.prototype.setApplicationKey=function(t){this.applicationKey=t},e.prototype.getHmacSignature=function(){return this.hmac},e.prototype.setHmacSignature=function(t){this.hmac=t},t.ChallengeRequestWSMessage=e}(MyScript),function(t){function e(e){this.type="applicationKey",t.AbstractWSMessage.call(this,e)}e.prototype=new t.AbstractWSMessage,e.prototype.constructor=e,e.prototype.getApplicationKey=function(){return this.applicationKey},e.prototype.setApplicationKey=function(t){this.applicationKey=t},t.InitRequestWSMessage=e}(MyScript),function(t){function e(e){this.type="reset",t.AbstractWSMessage.call(this,e)}e.prototype=new t.AbstractWSMessage,e.prototype.constructor=e,t.ResetRequestWSMessage=e}(MyScript),function(t){function e(e){t.AbstractComponent.call(this),e&&e.boundingBox&&(this.boundingBox=new t.Rectangle(e.boundingBox))}e.prototype=new t.AbstractComponent,e.prototype.constructor=e,e.prototype.getBoundingBox=function(){return this.boundingBox},e.prototype.setBoundingBox=function(t){this.boundingBox=t},t.AbstractTextInputComponent=e}(MyScript),function(t){function e(e){t.AbstractTextInputComponent.call(this,e),this.type="char",e&&e.character&&(this.character=e.character)}e.prototype=new t.AbstractTextInputComponent,e.prototype.constructor=e,e.prototype.getLabel=function(){return this.character},e.prototype.setLabel=function(t){this.character=t},t.CharInputComponent=e}(MyScript),function(t){function e(e){t.AbstractTextInputComponent.call(this,e),this.type="string",e&&e.string&&(this.string=e.string)}e.prototype=new t.AbstractTextInputComponent,e.prototype.constructor=e,e.prototype.getLabel=function(){return this.string},e.prototype.setLabel=function(t){this.string=t},t.StringInputComponent=e}(MyScript),function(t){function e(){this.textInputType="MULTI_LINE_TEXT",this.components=[]}e.prototype.getInputType=function(){return this.textInputType},e.prototype.setInputType=function(t){this.textInputType=t},e.prototype.getComponents=function(e){return e&&e instanceof t.TextInkRange?this.components.slice(e.getStartComponent(),e.getEndComponent()+1):this.components},e.prototype.setComponents=function(t){this.components=t},t.TextInputUnit=e}(MyScript),function(t){function e(e){t.AbstractParameter.call(this,e),this.textProperties=new t.TextProperties,e&&(e.language&&(this.language=e.language),e.textInputMode&&(this.textInputMode=e.textInputMode),e.contentTypes&&(this.contentTypes=e.contentTypes),e.subsetKnowledges&&(this.subsetKnowledges=e.subsetKnowledges),e.userResources&&(this.userResources=e.userResources),e.userLkWords&&(this.userLkWords=e.userLkWords),e.resultDetail&&(this.resultDetail=e.resultDetail),e.textProperties&&(this.textProperties=new t.TextProperties(e.textProperties)))}e.prototype=new t.AbstractParameter,e.prototype.constructor=e,e.prototype.getLanguage=function(){return this.language},e.prototype.setLanguage=function(t){this.language=t},e.prototype.getInputMode=function(){return this.textInputMode},e.prototype.setInputMode=function(t){this.textInputMode=t},e.prototype.getContentTypes=function(){return this.contentTypes},e.prototype.setContentTypes=function(t){this.contentTypes=t},e.prototype.getSubsetKnowledges=function(){return this.subsetKnowledges},e.prototype.setSubsetKnowledges=function(t){this.subsetKnowledges=t},e.prototype.getUserResources=function(){return this.userResources},e.prototype.setUserResources=function(t){this.userResources=t},e.prototype.getUserLkWords=function(){return this.userLkWords},e.prototype.setUserLkWords=function(t){this.userLkWords=t},e.prototype.getResultDetail=function(){return this.resultDetail},e.prototype.setResultDetail=function(t){this.resultDetail=t},e.prototype.getTextProperties=function(){return this.textProperties},e.prototype.setTextProperties=function(t){this.textProperties=t},t.TextParameter=e}(MyScript),function(t){function e(t){t&&(t.textCandidateListSize&&(this.textCandidateListSize=t.textCandidateListSize),t.wordCandidateListSize&&(this.wordCandidateListSize=t.wordCandidateListSize),t.wordPredictionListSize&&(this.wordPredictionListSize=t.wordPredictionListSize),t.wordCompletionListSize&&(this.wordCompletionListSize=t.wordCompletionListSize),t.characterCandidateListSize&&(this.characterCandidateListSize=t.characterCandidateListSize),t.discardCaseVariations&&(this.discardCaseVariations=t.discardCaseVariations),t.discardAccentuationVariations&&(this.discardAccentuationVariations=t.discardAccentuationVariations),t.disableSpatialOrdering&&(this.disableSpatialOrdering=t.disableSpatialOrdering),t.glyphDistortion&&(this.glyphDistortion=t.glyphDistortion),t.enableOutOfLexicon&&(this.enableOutOfLexicon=t.enableOutOfLexicon),t.spellingDistortion&&(this.spellingDistortion=t.spellingDistortion))}e.prototype.getTextCandidateListSize=function(){return this.textCandidateListSize},e.prototype.setTextCandidateListSize=function(t){this.textCandidateListSize=t},e.prototype.getWordCandidateListSize=function(){return this.wordCandidateListSize},e.prototype.setWordCandidateListSize=function(t){this.wordCandidateListSize=t},e.prototype.getWordPredictionListSize=function(){return this.wordPredictionListSize},e.prototype.setWordPredictionListSize=function(t){this.wordPredictionListSize=t},e.prototype.getWordCompletionListSize=function(){return this.wordCompletionListSize},e.prototype.setWordCompletionListSize=function(t){this.wordCompletionListSize=t},e.prototype.getCharacterCandidateListSize=function(){return this.characterCandidateListSize},e.prototype.setCharacterCandidateListSize=function(t){this.characterCandidateListSize=t},e.prototype.getDiscardCaseVariations=function(){return this.discardCaseVariations},e.prototype.setDiscardCaseVariations=function(t){this.discardCaseVariations=t},e.prototype.getDiscardAccentuationVariations=function(){return this.discardAccentuationVariations},e.prototype.setDiscardAccentuationVariations=function(t){this.discardAccentuationVariations=t},e.prototype.getDisableSpatialOrdering=function(){return this.disableSpatialOrdering},e.prototype.setDisableSpatialOrdering=function(t){this.disableSpatialOrdering=t},e.prototype.getGlyphDistortion=function(){return this.glyphDistortion},e.prototype.setGlyphDistortion=function(t){this.glyphDistortion=t},e.prototype.getEnableOutOfLexicon=function(){return this.enableOutOfLexicon},e.prototype.setEnableOutOfLexicon=function(t){this.enableOutOfLexicon=t},e.prototype.getSpellingDistortion=function(){return this.spellingDistortion},e.prototype.setSpellingDistortion=function(t){this.spellingDistortion=t},t.TextProperties=e}(MyScript),function(t){function e(){}e.prototype=new t.AbstractRecognitionInput,e.prototype.constructor=e,e.prototype.getParameters=function(){return this.textParameter},e.prototype.setParameters=function(t){this.textParameter=t},e.prototype.getInputUnits=function(e){return e&&e instanceof t.TextInkRange?this.inputUnits.slice(e.getStartUnit(),e.getEndUnit()+1):this.inputUnits},e.prototype.setInputUnits=function(t){this.inputUnits=t},t.TextRecognitionInput=e}(MyScript),function(t){function e(){}e.prototype=new t.AbstractRecognitionData,e.prototype.constructor=e,e.prototype.getRecognitionInput=function(){return this.textInput},e.prototype.setRecognitionInput=function(t){this.textInput=JSON.stringify(t)},t.TextRecognitionData=e}(MyScript),function(t){function e(e){t.AbstractStartRequestWSMessage.call(this,e)}e.prototype=new t.AbstractStartRequestWSMessage,e.prototype.constructor=e,e.prototype.getParameters=function(){return this.textParameter},e.prototype.setParameters=function(t){this.textParameter=t},e.prototype.getInputUnits=function(){return this.inputUnits},e.prototype.setInputUnits=function(t){this.inputUnits=t},t.TextStartRequestWSMessage=e}(MyScript),function(t){function e(e){t.AbstractContinueRequestWSMessage.call(this,e)}e.prototype=new t.AbstractContinueRequestWSMessage,e.prototype.constructor=e,e.prototype.getInputUnits=function(){return this.inputUnits},e.prototype.setInputUnits=function(t){this.inputUnits=t},t.TextContinueRequestWSMessage=e}(MyScript),function(t){function e(e){t.AbstractParameter.call(this,e),e&&(e.rejectDetectionSensitivity&&(this.rejectDetectionSensitivity=e.rejectDetectionSensitivity),e.doBeautification&&(this.doBeautification=e.doBeautification),e.userResources&&(this.userResources=e.userResources))}e.prototype=new t.AbstractParameter,e.prototype.constructor=e,e.prototype.getRejectDetectionSensitivity=function(){return this.rejectDetectionSensitivity},e.prototype.setRejectDetectionSensitivity=function(t){this.rejectDetectionSensitivity=t},e.prototype.hasBeautification=function(){return this.doBeautification},e.prototype.setBeautification=function(t){this.doBeautification=t},e.prototype.getUserResources=function(){return this.userResources},e.prototype.setUserResources=function(t){this.userResources=t},t.ShapeParameter=e}(MyScript),function(t){function e(){}e.prototype=new t.AbstractRecognitionInput,e.prototype.constructor=e,e.prototype.getParameters=function(){return new ShapeParameter({rejectDetectionSensitivity:this.rejectDetectionSensitivity,doBeautification:this.doBeautification,userResources:this.userResources})},e.prototype.setParameters=function(t){t&&(this.rejectDetectionSensitivity=t.getRejectDetectionSensitivity(),this.doBeautification=t.hasBeautification(),this.userResources=t.getUserResources())},e.prototype.getComponents=function(){return this.components},e.prototype.setComponents=function(t){this.components=t},t.ShapeRecognitionInput=e}(MyScript),function(t){function e(){}e.prototype=new t.AbstractRecognitionData,e.prototype.constructor=e,e.prototype.getRecognitionInput=function(){return this.shapeInput},e.prototype.setRecognitionInput=function(t){this.shapeInput=JSON.stringify(t)},t.ShapeRecognitionData=e}(MyScript),function(t){function e(e){t.AbstractParameter.call(this,e),this.resultTypes=[],this.userResources=[],e&&(e.resultTypes&&(this.resultTypes=e.resultTypes),e.columnarOperation&&(this.columnarOperation=e.columnarOperation),e.userResources&&(this.userResources=e.userResources),e.scratchOutDetectionSensitivity&&(this.scratchOutDetectionSensitivity=e.scratchOutDetectionSensitivity))}e.prototype=new t.AbstractParameter,e.prototype.constructor=e,e.prototype.getResultTypes=function(){return this.resultTypes},e.prototype.setResultTypes=function(t){this.resultTypes=t},e.prototype.isColumnar=function(){return this.columnarOperation},e.prototype.setColumnar=function(t){this.columnarOperation=t},e.prototype.getUserResources=function(){return this.userResources},e.prototype.setUserResources=function(t){this.userResources=t},e.prototype.getScratchOutDetectionSensitivity=function(){return this.scratchOutDetectionSensitivity},e.prototype.setScratchOutDetectionSensitivity=function(t){this.scratchOutDetectionSensitivity=t},t.MathParameter=e}(MyScript),function(t){function e(){}e.prototype=new t.AbstractRecognitionInput,e.prototype.constructor=e,e.prototype.getParameters=function(){return new MathParameter({resultTypes:this.resultTypes,columnarOperation:this.columnarOperation,userResources:this.userResources,scratchOutDetectionSensitivity:this.scratchOutDetectionSensitivity})},e.prototype.setParameters=function(t){t&&(this.resultTypes=t.getResultTypes(),this.columnarOperation=t.isColumnar(),this.userResources=t.getUserResources(),this.scratchOutDetectionSensitivity=t.getScratchOutDetectionSensitivity())},e.prototype.getComponents=function(){return this.components},e.prototype.setComponents=function(t){this.components=t},t.MathRecognitionInput=e}(MyScript),function(t){function e(){}e.prototype=new t.AbstractRecognitionData,e.prototype.constructor=e,e.prototype.getRecognitionInput=function(){return this.mathInput},e.prototype.setRecognitionInput=function(t){this.mathInput=JSON.stringify(t)},t.MathRecognitionData=e}(MyScript),function(t){function e(e){t.AbstractStartRequestWSMessage.call(this,e)}e.prototype=new t.AbstractStartRequestWSMessage,e.prototype.constructor=e,e.prototype.getParameters=function(){return this.parameters},e.prototype.setParameters=function(t){this.parameters=t},e.prototype.getComponents=function(){return this.components},e.prototype.setComponents=function(t){this.components=t},t.MathStartRequestWSMessage=e}(MyScript),function(t){function e(e){this.type="continue",t.AbstractContinueRequestWSMessage.call(this,e)}e.prototype=new t.AbstractContinueRequestWSMessage,e.prototype.constructor=e,e.prototype.getComponents=function(){return this.components},e.prototype.setComponents=function(t){this.components=t},t.MathContinueRequestWSMessage=e}(MyScript),function(t){function e(e){t.AbstractComponent.call(this),e&&e.boundingBox&&(this.boundingBox=new t.Rectangle(e.boundingBox))}e.prototype=new t.AbstractComponent,e.prototype.constructor=e,e.prototype.getBoundingBox=function(){return this.boundingBox},e.prototype.setBoundingBox=function(t){this.boundingBox=t},t.AbstractMusicInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="accidental",e&&e.value&&(this.value=e.value)}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicAccidentalInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="arpeggiate",e&&e.value&&(this.value=e.value)}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicArpeggiateInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="bar",this.value=new t.MusicBar,e&&e.value&&(this.value=new t.MusicBar(e.value))}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicBarInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="beam",this.value=new t.MusicBeam,e&&e.value&&(this.value=new t.MusicBeam(e.value))}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicBeamInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="clef",this.value=new t.MusicClef,e&&e.value&&(this.value=new t.MusicClef(e.value))}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicClefInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="decoration",this.value=new t.MusicDecoration,e&&e.value&&(this.value=new t.MusicDecoration(e.value))}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicDecorationInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="dots",e&&e.value&&(this.value=e.value)}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicDotsInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="head",e&&e.value&&(this.value=e.value)}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicHeadInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="ledgerLine"}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,t.MusicLedgerLineInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="rest",e&&e.value&&(this.value=e.value)}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicRestInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="stem",e&&e.value&&(this.value=e.value)}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicStemInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="tieOrSlur",e&&e.value&&(this.value=e.value)}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicTieOrSlurInputComponent=e}(MyScript),function(t){function e(e){t.AbstractMusicInputComponent.call(this,e),this.type="timeSignature",e&&e.value&&(this.value=e.value)}e.prototype=new t.AbstractMusicInputComponent,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},e.prototype.setValue=function(t){this.value=t},t.MusicTimeSignatureInputComponent=e}(MyScript),function(t){function e(t){this.count=5,this.gap=20,t&&(t.count&&(this.count=t.count),t.gap&&(this.gap=t.gap),t.top&&(this.top=t.top))}e.prototype.getCount=function(){return this.count},e.prototype.setCount=function(t){this.count=t},e.prototype.getTop=function(){return this.top},e.prototype.setTop=function(t){this.top=t},e.prototype.getGap=function(){return this.gap},e.prototype.setGap=function(t){this.gap=t},t.MusicStaff=e}(MyScript),function(t){function e(e){t.AbstractParameter.call(this,e),this.resultTypes=[],this.userResources=[],e&&(e.divisions&&(this.divisions=e.divisions),e.staff&&(this.staff=new t.MusicStaff(e.staff)),e.scratchOutDetectionSensitivity&&(this.scratchOutDetectionSensitivity=e.scratchOutDetectionSensitivity),e.userResources&&(this.userResources=e.userResources),e.resultTypes&&(this.resultTypes=e.resultTypes))}e.prototype=new t.AbstractParameter,e.prototype.constructor=e,e.prototype.getResultTypes=function(){return this.resultTypes},e.prototype.setResultTypes=function(t){this.resultTypes=t},e.prototype.getUserResources=function(){return this.userResources},e.prototype.setUserResources=function(t){this.userResources=t},e.prototype.getScratchOutDetectionSensitivity=function(){return this.scratchOutDetectionSensitivity},e.prototype.setScratchOutDetectionSensitivity=function(t){this.scratchOutDetectionSensitivity=t},e.prototype.getStaff=function(){return this.staff},e.prototype.setStaff=function(t){this.staff=t},e.prototype.getDivisions=function(){return this.divisions},e.prototype.setDivisions=function(t){this.divisions=t},t.MusicParameter=e}(MyScript),function(t){function e(){}e.prototype=new t.AbstractRecognitionInput,e.prototype.constructor=e,e.prototype.getParameters=function(){return new MusicParameter({divisions:this.divisions,staff:this.staff,scratchOutDetectionSensitivity:this.scratchOutDetectionSensitivity,resultTypes:this.resultTypes,userResources:this.userResources})},e.prototype.setParameters=function(t){t&&(this.divisions=t.getDivisions(),this.staff=t.getStaff(),this.scratchOutDetectionSensitivity=t.getScratchOutDetectionSensitivity(),this.resultTypes=t.getResultTypes(),this.userResources=t.getUserResources())},e.prototype.getComponents=function(){return this.components},e.prototype.setComponents=function(t){this.components=t},t.MusicRecognitionInput=e}(MyScript),function(t){function e(){}e.prototype=new t.AbstractRecognitionData,e.prototype.constructor=e,e.prototype.getRecognitionInput=function(){return this.musicInput},e.prototype.setRecognitionInput=function(t){this.musicInput=JSON.stringify(t)},t.MusicRecognitionData=e}(MyScript),function(t){function e(e){t.AbstractParameter.call(this,e),this.textParameter=new t.TextParameter,this.textParameter.setLanguage("en_US"),this.textParameter.setInputMode("CURSIVE"),e&&(e.coordinateResolution&&(this.coordinateResolution=e.coordinateResolution),e.textParameter&&(this.textParameter=new t.TextParameter(e.textParameter)))}e.prototype=new t.AbstractParameter,e.prototype.constructor=e,e.prototype.getTextParameters=function(){return this.textParameter},e.prototype.setTextParameters=function(t){this.textParameter=t},e.prototype.getCoordinateResolution=function(){return this.coordinateResolution},e.prototype.setCoordinateResolution=function(t){this.coordinateResolution=t},t.AnalyzerParameter=e}(MyScript),function(t){function e(){}e.prototype=new t.AbstractRecognitionInput,e.prototype.constructor=e,e.prototype.getParameters=function(){return this.parameter},e.prototype.setParameters=function(t){this.parameter=t},e.prototype.getComponents=function(){return this.components},e.prototype.setComponents=function(t){this.components=t},t.AnalyzerRecognitionInput=e}(MyScript),function(t){function e(){}e.prototype=new t.AbstractRecognitionData,e.prototype.constructor=e,e.prototype.getRecognitionInput=function(){return this.analyzerInput},e.prototype.setRecognitionInput=function(t){this.analyzerInput=JSON.stringify(t)},t.AnalyzerRecognitionData=e}(MyScript),function(t){function e(t){t&&(this.instanceId=t.instanceId)}e.prototype.getInstanceId=function(){return this.instanceId;
},e.prototype.getDocument=function(){return this.result},t.AbstractResult=e}(MyScript),function(t){function e(e){t.AbstractWSMessage.call(this,e),e&&(this.instanceId=e.instanceId)}e.prototype=new t.AbstractWSMessage,e.prototype.constructor=e,e.prototype.getInstanceId=function(){return this.instanceId},e.prototype.getDocument=function(){return this.result},t.AbstractRecoResponseWSMessage=e}(MyScript),function(t){function e(e){t.AbstractWSMessage.call(this,e),e&&(this.challenge=e.challenge)}e.prototype=new t.AbstractWSMessage,e.prototype.constructor=e,e.prototype.getChallenge=function(){return this.challenge},t.ChallengeResponseWSMessage=e}(MyScript),function(t){function e(e){t.AbstractWSMessage.call(this,e),e&&(this.error=e.error)}e.prototype=new t.AbstractWSMessage,e.prototype.constructor=e,e.prototype.getError=function(){return this.error},t.ErrorResponseWSMessage=e}(MyScript),function(t){function e(e){t.AbstractWSMessage.call(this,e)}e.prototype=new t.AbstractWSMessage,e.prototype.constructor=e,t.InitResponseWSMessage=e}(MyScript),function(t){function e(e){t.AbstractWSMessage.call(this,e)}e.prototype=new t.AbstractWSMessage,e.prototype.constructor=e,t.ResetResponseWSMessage=e}(MyScript),function(t){function e(t){if(t)if("string"==typeof t){var e=t.split(/[:-]+/);this.startUnit=Number(e[0]),this.startComponent=Number(e[1]),this.startPoint=Number(e[2]),this.endUnit=Number(e[3]),this.endComponent=Number(e[4]),this.endPoint=Number(e[5])}else this.startUnit=t.startUnit,this.startComponent=t.startComponent,this.startPoint=t.startPoint,this.endUnit=t.endUnit,this.endComponent=t.endComponent,this.endPoint=t.endPoint}e.prototype.getStartUnit=function(){return this.startUnit},e.prototype.getEndUnit=function(){return this.endUnit},e.prototype.getStartComponent=function(){return this.startComponent},e.prototype.getEndComponent=function(){return this.endComponent},e.prototype.getStartPoint=function(){return this.startPoint},e.prototype.getEndPoint=function(){return this.endPoint},t.TextInkRange=e}(MyScript),function(t){function e(e){if(this.flags=[],this.children=[],e){this.label=e.label,this.normalizedScore=e.normalizedScore,this.spellingDistortionRatio=e.spellingDistortionRatio;for(var n in e.flags)this.flags.push(e.flags[n]);for(var o in e.children)this.children.push(new t.TextSegment(e.children[o]))}}e.prototype.getLabel=function(){return this.label},e.prototype.getNormalizedScore=function(){return this.normalizedScore},e.prototype.getResemblanceScore=function(){return this.resemblanceScore},e.prototype.getSpellingDistortionRatio=function(){return this.spellingDistortionRatio},e.prototype.getFlags=function(){return this.flags},e.prototype.getChildren=function(){return this.children},t.TextCandidate=e}(MyScript),function(t){function e(e){if(this.tagItems=[],this.wordSegments=[],this.charSegments=[],e){e.textSegmentResult&&(this.textSegmentResult=new t.TextSegment(e.textSegmentResult));for(var n in e.tagItems)this.tagItems.push(new t.TextTagItem(e.tagItems[n]));for(var o in e.wordSegments)this.wordSegments.push(new t.TextSegment(e.wordSegments[o]));for(var i in e.charSegments)this.charSegments.push(new t.TextSegment(e.charSegments[i]));for(var r in e.wordCandidates)this.wordSegments.push(new t.TextSegment(e.wordCandidates[r]));for(var s in e.charCandidates)this.charSegments.push(new t.TextSegment(e.charCandidates[s]))}}e.prototype.getTagItems=function(){return this.tagItems},e.prototype.getWordSegments=function(){return this.wordSegments},e.prototype.getWordSegment=function(t){for(var e=0;e<this.getWordSegments().length;e++)if(JSON.stringify(this.getWordSegments()[e].getInkRanges())===JSON.stringify(t))return this.getWordSegments()[e]},e.prototype.getCharSegments=function(){return this.charSegments},e.prototype.getCharSegment=function(t){for(var e=0;e<this.getCharSegments().length;e++)if(JSON.stringify(this.getCharSegments()[e].getInkRanges())===JSON.stringify(t))return this.getCharSegments()[e]},e.prototype.getTextSegment=function(){return this.textSegmentResult},e.prototype.hasScratchOutResults=function(){return!1},t.TextDocument=e}(MyScript),function(t){function e(e){t.AbstractResult.call(this,e),e&&(this.result=new t.TextDocument(e.result))}e.prototype=new t.AbstractResult,e.prototype.constructor=e,t.TextResult=e}(MyScript),function(t){function e(e){if(this.candidates=[],this.inkRanges=[],e){if(this.selectedCandidateIdx=e.selectedCandidateIdx,e.inkRanges){var n=e.inkRanges;Array.isArray(n)||(n=n.split(/[\s]+/));for(var o in n)this.inkRanges.push(new t.TextInkRange(n[o]))}for(var i in e.candidates)this.candidates.push(new t.TextCandidate(e.candidates[i]))}}e.prototype.getCandidates=function(){return this.candidates},e.prototype.getSelectedCandidateIdx=function(){return this.selectedCandidateIdx},e.prototype.getSelectedCandidate=function(){return this.getCandidates().length>0&&void 0!==this.getSelectedCandidateIdx()?this.getCandidates()[this.getSelectedCandidateIdx()]:void 0},e.prototype.getInkRanges=function(){return this.inkRanges},t.TextSegment=e}(MyScript),function(t){function e(e){if(this.inkRanges=[],e&&(this.tagType=e.tagType,e.inkRanges)){var n=e.inkRanges;Array.isArray(n)||(n=n.split(/[\s]+/));for(var o in n)this.inkRanges.push(new t.TextInkRange(n[o]))}}e.prototype.getTagType=function(){return this.tagType},e.prototype.getInkRanges=function(){return this.inkRanges},t.TextTagItem=e}(MyScript),function(t){function e(e){t.AbstractRecoResponseWSMessage.call(this,e),e&&(this.result=new t.TextDocument(e.result))}e.prototype=new t.AbstractRecoResponseWSMessage,e.prototype.constructor=e,t.TextResponseWSMessage=e}(MyScript),function(t){function e(t){t&&(this.type=t.type,this.beginDecoration=t.beginDecoration,this.beginTangentAngle=t.beginTangentAngle,this.endDecoration=t.endDecoration,this.endTangentAngle=t.endTangentAngle)}e.prototype.getType=function(){return this.type},e.prototype.isLine=function(){return"line"===this.type},e.prototype.isEllipse=function(){return"ellipse"===this.type},e.prototype.hasBeginDecoration=function(){return"undefined"!=typeof this.beginDecoration},e.prototype.hasEndDecoration=function(){return"undefined"!=typeof this.endDecoration},e.prototype.getBeginDecoration=function(){return this.beginDecoration},e.prototype.getEndDecoration=function(){return this.endDecoration},e.prototype.getBeginTangentAngle=function(){return this.beginTangentAngle},e.prototype.getEndTangentAngle=function(){return this.endTangentAngle},t.AbstractShapePrimitive=e}(MyScript),function(t){function e(t){t&&(this.type=t.type)}e.prototype.getType=function(){return this.type},e.prototype.isErased=function(){return"erased"===this.type},e.prototype.isScratchOut=function(){return"scratchOut"===this.type},e.prototype.isNotRecognized=function(){return"notRecognized"===this.type},e.prototype.isRecognized=function(){return"recognizedShape"===this.type},t.ShapeCandidate=e}(MyScript),function(t){function e(e){if(this.segments=[],e)for(var n in e.segments)this.segments.push(new t.ShapeSegment(e.segments[n]))}e.prototype.getSegments=function(){return this.segments},e.prototype.getInkRanges=function(){var t=[];for(var e in this.segments)t=t.concat(this.segments[e].getInkRanges());return t},e.prototype.hasScratchOutResults=function(){for(var e in this.getSegments()){var n=this.getSegments()[e];for(var o in n.getCandidates()){var i=n.getCandidates()[o];if(i instanceof t.ShapeScratchOut)return!0}}return!1},t.ShapeDocument=e}(MyScript),function(t){function e(e){t.AbstractShapePrimitive.call(this,e),e&&(this.center=new t.Point(e.center),this.minRadius=e.minRadius,this.maxRadius=e.maxRadius,this.orientation=e.orientation,this.startAngle=e.startAngle,this.sweepAngle=e.sweepAngle)}e.prototype=new t.AbstractShapePrimitive,e.prototype.constructor=e,e.prototype.getCenter=function(){return this.center},e.prototype.getMinRadius=function(){return this.minRadius},e.prototype.getMaxRadius=function(){return this.maxRadius},e.prototype.getOrientation=function(){return this.orientation},e.prototype.getStartAngle=function(){return this.startAngle},e.prototype.getSweepAngle=function(){return this.sweepAngle},t.ShapeEllipse=e}(MyScript),function(t){function e(e){t.ShapeCandidate.call(this,e)}e.prototype=new t.ShapeCandidate,e.prototype.constructor=e,t.ShapeErased=e}(MyScript),function(t){function e(t){t&&(this.firstStroke=t.firstStroke,this.lastStroke=t.lastStroke,this.firstPoint=t.firstPoint,this.lastPoint=t.lastPoint)}e.prototype.getFirstStroke=function(){return this.firstStroke},e.prototype.getLastStroke=function(){return this.lastStroke},e.prototype.getFirstPoint=function(){return this.firstPoint},e.prototype.getLastPoint=function(){return this.lastPoint},t.ShapeInkRange=e}(MyScript),function(t){function e(e){t.AbstractShapePrimitive.call(this,e),e&&(this.firstPoint=new t.Point(e.firstPoint),this.lastPoint=new t.Point(e.lastPoint))}e.prototype=new t.AbstractShapePrimitive,e.prototype.constructor=e,e.prototype.getFirstPoint=function(){return this.firstPoint},e.prototype.getLastPoint=function(){return this.lastPoint},t.ShapeLine=e}(MyScript),function(t){function e(e){t.ShapeCandidate.call(this,e)}e.prototype=new t.ShapeCandidate,e.prototype.constructor=e,t.ShapeNotRecognized=e}(MyScript),function(t){function e(e){if(t.ShapeCandidate.call(this,e),this.primitives=[],e){this.label=e.label,this.normalizedRecognitionScore=e.normalizedRecognitionScore,this.resemblanceScore=e.resemblanceScore;for(var n in e.primitives)switch(e.primitives[n].type){case"line":this.primitives.push(new t.ShapeLine(e.primitives[n]));break;case"ellipse":this.primitives.push(new t.ShapeEllipse(e.primitives[n]));break;default:throw new Error("Unknown shape primitive")}}}e.prototype=new t.ShapeCandidate,e.prototype.constructor=e,e.prototype.getPrimitives=function(){return this.primitives},e.prototype.getLabel=function(){return this.label},e.prototype.getNormalizedRecognitionScore=function(){return this.normalizedRecognitionScore},e.prototype.getResemblanceScore=function(){return this.resemblanceScore},t.ShapeRecognized=e}(MyScript),function(t){function e(e){t.AbstractResult.call(this,e),e&&(this.result=new t.ShapeDocument(e.result))}e.prototype=new t.AbstractResult,e.prototype.constructor=e,t.ShapeResult=e}(MyScript),function(t){function e(e){if(t.ShapeCandidate.call(this,e),this.inkRanges=[],e)for(var n in e.inkRanges)this.inkRanges.push(new t.ShapeInkRange(e.inkRanges[n]))}e.prototype=new t.ShapeCandidate,e.prototype.constructor=e,e.prototype.getInkRanges=function(){return this.inkRanges},t.ShapeScratchOut=e}(MyScript),function(t){function e(e){if(this.inkRanges=[],this.candidates=[],e){this.elementType=e.elementType,this.uniqueID=e.uniqueID,this.selectedCandidateIndex=e.selectedCandidateIndex;for(var n in e.candidates)switch(e.candidates[n].type){case"erased":this.candidates.push(new t.ShapeErased(e.candidates[n]));break;case"scratchOut":this.candidates.push(new t.ShapeScratchOut(e.candidates[n]));break;case"recognizedShape":this.candidates.push(new t.ShapeRecognized(e.candidates[n]));break;default:this.candidates.push(new t.ShapeNotRecognized(e.candidates[n]))}for(var o in e.inkRanges)this.inkRanges.push(new t.ShapeInkRange(e.inkRanges[o]))}}e.prototype.getElementType=function(){return this.elementType},e.prototype.getUniqueId=function(){return this.uniqueID},e.prototype.getInkRanges=function(){return this.inkRanges},e.prototype.getSelectedCandidateIdx=function(){return this.selectedCandidateIndex},e.prototype.getCandidates=function(){return this.candidates},e.prototype.getSelectedCandidate=function(){return this.getCandidates().length>0&&void 0!==this.getSelectedCandidateIdx()?this.getCandidates()[this.getSelectedCandidateIdx()]:void 0},t.ShapeSegment=e}(MyScript),function(t){function e(t){t&&(this.name=t.name,this.type=t.type)}e.prototype.getName=function(){return this.name},e.prototype.getType=function(){return this.type},t.MathNode=e}(MyScript),function(t){function e(e){if(t.MathNode.call(this,e),this.candidates=[],e){this.selectedCandidate=e.selectedCandidate;for(var n in e.candidates)switch(e.candidates[n].type){case"nonTerminalNode":this.candidates.push(new t.MathNonTerminalNode(e.candidates[n]));break;case"terminalNode":this.candidates.push(new t.MathTerminalNode(e.candidates[n]));break;case"rule":this.candidates.push(new t.MathRuleNode(e.candidates[n]));break;case"cell":this.candidates.push(new t.MathCellNonTerminalNode(e.candidates[n]));break;case"border":this.candidates.push(new t.MathBorderNonTerminalNode(e.candidates[n]));break;case"table":this.candidates.push(new t.MathTableRuleNode(e.candidates[n]));break;default:throw new Error("Unknown math node type: "+e.candidates[n].type)}}}e.prototype=new t.MathNode,e.prototype.constructor=e,e.prototype.getCandidates=function(){return this.candidates},e.prototype.getSelectedCandidateIdx=function(){return this.selectedCandidate},e.prototype.getSelectedCandidate=function(){return this.getCandidates().length>0&&void 0!==this.getSelectedCandidateIdx()?this.getCandidates()[this.getSelectedCandidateIdx()]:void 0},e.prototype.getInkRanges=function(){if(this.getSelectedCandidate())return this.getSelectedCandidate().getInkRanges();throw new Error("No selected candidate")},t.MathNonTerminalNode=e}(MyScript),function(t){function e(t){t&&(this.type=t.type)}e.prototype.getType=function(){return this.type},e.prototype.isLaTex=function(){return"LATEX"===this.type},e.prototype.isMathMl=function(){return"MATHML"===this.type},e.prototype.isSymbolTree=function(){return"SYMBOLTREE"===this.type},t.MathResultElement=e}(MyScript),function(t){function e(e){if(t.MathNode.call(this,e),this.children=[],e){this.name=e.name;for(var n in e.children)switch(e.children[n].type){case"nonTerminalNode":this.children.push(new t.MathNonTerminalNode(e.children[n]));break;case"terminalNode":this.children.push(new t.MathTerminalNode(e.children[n]));break;case"rule":this.children.push(new t.MathRuleNode(e.children[n]));break;case"cell":this.children.push(new t.MathCellNonTerminalNode(e.children[n]));break;case"border":this.children.push(new t.MathBorderNonTerminalNode(e.children[n]));break;case"table":this.children.push(new t.MathTableRuleNode(e.children[n]));break;default:throw new Error("Unknown math node type: "+e.children[n].type)}}}e.prototype=new t.MathNode,e.prototype.constructor=e,e.prototype.getName=function(){return this.name},e.prototype.getChildren=function(){return this.children},e.prototype.getInkRanges=function(){var t=[];for(var e in this.getChildren()){var n=this.getChildren()[e].getInkRanges();for(var o in n)t.push(n[o])}return t},t.MathRuleNode=e}(MyScript),function(t){function e(e){if(this.results=[],this.scratchOutResults=[],e){for(var n in e.results){var o=e.results[n];switch(o.type){case"MATHML":this.results.push(new t.MathMathMLResultElement(o));break;case"LATEX":this.results.push(new t.MathLaTexResultElement(o));break;case"SYMBOLTREE":this.results.push(new t.MathSymbolTreeResultElement(o));break;case"OFFICEOPENXMLMATH":this.results.push(new t.MathOfficeOpenXmlMathResultElement(o));break;default:throw new Error("Unknown math result type: "+o.type)}}for(var i in e.scratchOutResults)this.scratchOutResults.push(new t.MathScratchOut(e.scratchOutResults[i]))}}e.prototype.getResultElements=function(){return this.results},e.prototype.getScratchOutResults=function(){return this.scratchOutResults},e.prototype.hasScratchOutResults=function(){return this.getScratchOutResults()&&this.getScratchOutResults().length>0?!0:!1},t.MathDocument=e}(MyScript),function(t){function e(t){t&&(this.component=t.component,this.firstItem=t.firstItem,this.lastItem=t.lastItem)}e.prototype.getComponent=function(){return this.component},e.prototype.getFirstItem=function(){return this.firstItem},e.prototype.getLastItem=function(){return this.lastItem},t.MathInkRange=e}(MyScript),function(t){function e(e){t.MathResultElement.call(this,e),e&&(this.value=e.value)}e.prototype=new t.MathResultElement,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},t.MathOfficeOpenXmlMathResultElement=e}(MyScript),function(t){function e(e){t.MathResultElement.call(this,e),e&&(this.value=e.value)}e.prototype=new t.MathResultElement,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},t.MathLaTexResultElement=e}(MyScript),function(t){function e(e){t.MathResultElement.call(this,e),e&&(this.value=e.value)}e.prototype=new t.MathResultElement,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},t.MathMathMLResultElement=e}(MyScript),function(t){function e(e){t.AbstractResult.call(this,e),e&&(this.result=new t.MathDocument(e.result))}e.prototype=new t.AbstractResult,e.prototype.constructor=e,t.MathResult=e}(MyScript),function(t){function e(e){if(this.inkRanges=[],this.erasedInkRanges=[],e){for(var n in e.inkRanges)this.inkRanges.push(new t.MathInkRange(e.inkRanges[n]));for(var o in e.erasedInkRanges)this.erasedInkRanges.push(new t.MathInkRange(e.erasedInkRanges[o]))}}e.prototype.getInkRanges=function(){return this.inkRanges},e.prototype.getErasedInkRanges=function(){return this.erasedInkRanges},t.MathScratchOut=e}(MyScript),function(t){function e(e){if(t.MathResultElement.call(this,e),e){if(!e.root)throw new Error("Missing root");switch(e.root.type){case"nonTerminalNode":this.root=new t.MathNonTerminalNode(e.root);break;case"terminalNode":this.root=new t.MathTerminalNode(e.root);break;case"rule":this.root=new t.MathRuleNode(e.root);break;case"cell":this.root=new t.MathCellNonTerminalNode(e.root);break;case"border":this.root=new t.MathBorderNonTerminalNode(e.root);break;case"table":this.root=new t.MathTableRuleNode(e.root);break;default:throw new Error("Unknown math node type: "+e.root.type)}this.value=JSON.stringify(e.root,null,"  ")}}e.prototype=new t.MathResultElement,e.prototype.constructor=e,e.prototype.getRoot=function(){return this.root},e.prototype.getInkRanges=function(){if(this.getRoot())return this.getRoot().getInkRanges();throw new Error("No selected candidate")},e.prototype.getValue=function(){return this.value},t.MathSymbolTreeResultElement=e}(MyScript),function(t){function e(e){if(t.MathNode.call(this,e),this.candidates=[],this.inkRanges=[],e){this.selectedCandidate=e.selectedCandidate;for(var n in e.candidates)this.candidates.push(new t.MathTerminalNodeCandidate(e.candidates[n]));for(var o in e.inkRanges)this.inkRanges.push(new t.MathInkRange(e.inkRanges[o]))}}e.prototype=new t.MathNode,e.prototype.constructor=e,e.prototype.getCandidates=function(){return this.candidates},e.prototype.getInkRanges=function(){return this.inkRanges},e.prototype.getSelectedCandidateIdx=function(){return this.selectedCandidate},e.prototype.getSelectedCandidate=function(){return this.getCandidates().length>0&&void 0!==this.getSelectedCandidateIdx()?this.getCandidates()[this.getSelectedCandidateIdx()]:void 0},t.MathTerminalNode=e}(MyScript),function(t){function e(t){t&&(this.label=t.label,this.normalizedRecognitionScore=t.normalizedRecognitionScore)}e.prototype.getLabel=function(){return this.label},e.prototype.getNormalizedRecognitionScore=function(){return this.normalizedRecognitionScore},t.MathTerminalNodeCandidate=e}(MyScript),function(t){function e(t){t&&(this.position=t.position,this.start=t.start,this.stop=t.stop,this.type=t.type)}e.prototype.getPosition=function(){return this.position},e.prototype.getStart=function(){return this.start},e.prototype.getStop=function(){return this.stop},e.prototype.getType=function(){return this.type},t.MathBorderData=e}(MyScript),function(t){function e(e){t.MathNonTerminalNode.call(this,e),e&&(this.data=new t.MathBorderData(e.data))}e.prototype=new t.MathNonTerminalNode,e.prototype.constructor=e,e.prototype.getData=function(){return this.data},t.MathBorderNonTerminalNode=e}(MyScript),function(t){function e(t){t&&(this.columnStart=t.columnStart,this.columnStop=t.columnStop,this.rowStart=t.rowStart,this.rowStop=t.rowStop)}e.prototype.getColumnStart=function(){return this.columnStart},e.prototype.getColumnStop=function(){return this.columnStop},e.prototype.getRowStart=function(){return this.rowStart},e.prototype.getRowStop=function(){return this.rowStop},t.MathCellData=e}(MyScript),function(t){function e(e){t.MathNonTerminalNode.call(this,e),e&&(this.data=new t.MathCellData(e.data))}e.prototype=new t.MathNonTerminalNode,e.prototype.constructor=e,e.prototype.getData=function(){return this.data},t.MathCellNonTerminalNode=e}(MyScript),function(t){function e(t){t&&(this.columnCount=t.columnCount,this.rowCount=t.rowCount)}e.prototype.getColumnCount=function(){return this.columnCount},e.prototype.getRowCount=function(){return this.rowCount},t.MathTableData=e}(MyScript),function(t){function e(e){t.MathRuleNode.call(this,e),e&&(this.data=new t.MathTableData(e.data))}e.prototype=new t.MathRuleNode,e.prototype.constructor=e,e.prototype.getData=function(){return this.data},t.MathTableRuleNode=e}(MyScript),function(t){function e(e){t.AbstractRecoResponseWSMessage.call(this,e),e&&(this.result=new t.MathDocument(e.result))}e.prototype=new t.AbstractRecoResponseWSMessage,e.prototype.constructor=e,t.MathResponseWSMessage=e}(MyScript),function(t){function e(t){t&&(this.inputRanges=[],this.elementType=t.elementType,this.inputRanges=t.inputRanges)}e.prototype.getElementType=function(){return this.elementType},e.prototype.getInputRanges=function(){return this.inputRanges},t.MusicElement=e}(MyScript),function(t){function e(t){t&&(this.type=t.type)}e.prototype.getType=function(){return this.type},e.prototype.isMusicXML=function(){return"MUSICXML"===this.type},e.prototype.isScoreTree=function(){return"SCORETREE"===this.type},t.MusicResultElement=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.type=e.type)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getType=function(){return this.type},t.MusicAccidental=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.label=e.label)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getLabel=function(){return this.label},t.MusicAnnotation=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.type=e.type)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getType=function(){return this.type},t.MusicArpeggiate=e}(MyScript),function(t){function e(e){if(t.MusicElement.call(this,e),this.decorations=[],e){this.repeatDirection=e.repeatDirection,this.style=e.style;for(var n in e.decorations)this.decorations.push(new t.MusicDecoration(e.decorations[n]))}}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getRepeatDirection=function(){return this.repeatDirection},e.prototype.setRepeatDirection=function(t){this.repeatDirection=t},e.prototype.getStyle=function(){return this.style},e.prototype.setStyle=function(t){this.style=t},e.prototype.getDecorations=function(){return this.decorations},e.prototype.setDecorations=function(t){this.decorations=t},t.MusicBar=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.gap=e.gap,this.slope=e.slope,this.placement=e.placement,this.leftCount=e.leftCount,this.rightCount=e.rightCount)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getGap=function(){return this.gap},e.prototype.setGap=function(t){this.gap=t},e.prototype.getSlope=function(){return this.slope},e.prototype.setSlope=function(t){this.slope=t},e.prototype.getPlacement=function(){return this.placement},e.prototype.setPlacement=function(t){this.placement=t},e.prototype.getLeftCount=function(){return this.leftCount},e.prototype.setLeftCount=function(t){this.leftCount=t},e.prototype.getRightCount=function(){return this.rightCount},e.prototype.setRightCount=function(t){this.rightCount=t},t.MusicBeam=e}(MyScript),function(t){function e(e){if(t.MusicElement.call(this,e),this.decorations=[],this.notes=[],this.beamTypes=[],this.ledgerLines=[],this.startSlurs=[],this.stopSlurs=[],e){this.duration=e.duration,this.arpeggiate=new t.MusicArpeggiate(e.arpeggiate),this.startBeam=new t.MusicBeam(e.startBeam),this.stopBeam=new t.MusicBeam(e.stopBeam),this.stem=new t.MusicStem(e.stem);for(var n in e.decorations)this.decorations.push(new t.MusicDecoration(e.decorations[n]));for(var o in e.notes)this.notes.push(new t.MusicNote(e.notes[o]));for(var i in e.beamTypes)this.beamTypes.push(e.beamTypes[i]);for(var r in e.ledgerLines)this.ledgerLines.push(new t.MusicLedgerLine(e.ledgerLines[r]));for(var s in e.startSlurs)this.startSlurs.push(new t.MusicSlur(e.startSlurs[s]));for(var a in e.stopSlurs)this.stopSlurs.push(new t.MusicSlur(e.stopSlurs[a]))}}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getDuration=function(){return this.duration},e.prototype.getArpeggiate=function(){return this.arpeggiate},e.prototype.getStartBeam=function(){return this.startBeam},e.prototype.getStopBeam=function(){return this.stopBeam},e.prototype.getStem=function(){return this.stem},e.prototype.getDecorations=function(){return this.decorations},e.prototype.getNotes=function(){return this.notes},e.prototype.getBeamTypes=function(){return this.beamTypes},e.prototype.getLedgerLines=function(){return this.ledgerLines},e.prototype.getStartSlurs=function(){return this.startSlurs},e.prototype.getStopSlurs=function(){return this.stopSlurs},t.MusicChord=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),this.symbol="G",this.octave=0,e&&(this.line=e.line,this.yAnchor=e.yAnchor,this.octave=e.octave,this.symbol=e.symbol)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getYAnchor=function(){return this.yAnchor},e.prototype.setYAnchor=function(t){this.yAnchor=t},e.prototype.getLine=function(){return this.line},e.prototype.setLine=function(t){this.line=t},e.prototype.getOctave=function(){return this.octave},e.prototype.setOctave=function(t){this.octave=t},e.prototype.getSymbol=function(){return this.symbol},e.prototype.setSymbol=function(t){this.symbol=t},t.MusicClef=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.symbol=e.symbol,this.placement=e.placement)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getSymbol=function(){return this.symbol},e.prototype.setSymbol=function(t){this.symbol=t},e.prototype.getPlacement=function(){return this.placement},e.prototype.setPlacement=function(t){this.placement=t},t.MusicDecoration=e}(MyScript),function(t){function e(e){if(this.results=[],this.scratchOutResults=[],e){for(var n in e.results)switch(e.results[n].type){case"MUSICXML":this.results.push(new t.MusicXMLResultElement(e.results[n]));break;default:this.results.push(new t.MusicScoreTreeResultElement(e.results[n]))}for(var o in e.scratchOutResults)this.scratchOutResults.push(new t.MusicScratchOut(e.scratchOutResults[o]))}}e.prototype.getResultElements=function(){return this.results},e.prototype.getScratchOutResults=function(){return this.scratchOutResults},e.prototype.hasScratchOutResults=function(){return this.getScratchOutResults()&&this.getScratchOutResults().length>0?!0:!1},t.MusicDocument=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.count=e.count)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getCount=function(){return this.count},t.MusicDots=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.type=e.type)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getType=function(){return this.type},t.MusicHead=e}(MyScript),function(t){function e(t){t&&(this.component=t.component,this.firstItem=t.firstItem,this.lastItem=t.lastItem)}e.prototype.getComponent=function(){return this.component},e.prototype.getFirstItem=function(){return this.firstItem},e.prototype.getLastItem=function(){return this.lastItem},t.MusicInputRange=e}(MyScript),function(t){function e(e){if(t.MusicElement.call(this,e),this.accidentals=[],e){this.signature=new t.MusicKeySignatureData(e.signature);for(var n in e.accidentals)this.accidentals.push(new t.MusicAccidental(e.accidentals[n]))}}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getSignature=function(){return this.signature},e.prototype.getAccidentals=function(){return this.accidentals},t.MusicKeySignature=e}(MyScript),function(t){function e(t){t&&(this.fifths=t.fifths,this.cancel=t.cancel)}e.prototype.getFifths=function(){return this.fifths},e.prototype.getCancel=function(){return this.cancel},t.MusicKeySignatureData=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e)}e.prototype=new t.MusicElement,e.prototype.constructor=e,t.MusicLedgerLine=e}(MyScript),function(t){function e(e){if(t.MusicElement.call(this,e),this.decorations=[],this.beamTypes=[],this.ledgerLines=[],this.startSlurs=[],this.stopSlurs=[],e){this.accidental=new t.MusicAccidental(e.accidental),this.dots=new t.MusicDots(e.dots),this.duration=e.duration,this.head=new t.MusicHead(e.head),this.line=e.line,this.pitch=new t.MusicPitchData(e.pitch),this.startBeam=new t.MusicBeam(e.startBeam),this.stopBeam=new t.MusicBeam(e.stopBeam),this.stem=new t.MusicStem(e.stem),this.startTie=new t.MusicTie(e.startTie),this.stopTie=new t.MusicTie(e.stopTie),this.startTuplet=new t.MusicTuplet(e.startTuplet),this.stopTuplet=new t.MusicTuplet(e.stopTuplet),this.timeModification=new t.MusicTimeModificationData(e.timeModification),this.type=e.type;for(var n in e.decorations)this.decorations.push(new t.MusicDecoration(e.decorations[n]));for(var o in e.beamTypes)this.beamTypes.push(e.beamTypes[o]);for(var i in e.ledgerLines)this.ledgerLines.push(new t.MusicLedgerLine(e.ledgerLines[i]));for(var r in e.startSlurs)this.startSlurs.push(new t.MusicSlur(e.startSlurs[r]));for(var s in e.stopSlurs)this.stopSlurs.push(new t.MusicSlur(e.stopSlurs[s]))}}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getAccidental=function(){return this.accidental},e.prototype.getDots=function(){return this.dots},e.prototype.getDuration=function(){return this.duration},e.prototype.getHead=function(){return this.head},e.prototype.getLine=function(){return this.line},e.prototype.getPitch=function(){return this.pitch},e.prototype.getStartBeam=function(){return this.startBeam},e.prototype.getStopBeam=function(){return this.stopBeam},e.prototype.getStem=function(){return this.stem},e.prototype.getStartTie=function(){return this.startTie},e.prototype.getStopTie=function(){return this.stopTie},e.prototype.getStartTuplet=function(){return this.startTuplet},e.prototype.getStopTuplet=function(){return this.stopTuplet},e.prototype.getTimeModification=function(){return this.timeModification},e.prototype.getType=function(){return this.type},e.prototype.getDecorations=function(){return this.decorations},e.prototype.getBeamTypes=function(){return this.beamTypes},e.prototype.getLedgerLines=function(){return this.ledgerLines},e.prototype.getStartSlurs=function(){return this.startSlurs},e.prototype.getStopSlurs=function(){return this.stopSlurs},t.MusicNote=e}(MyScript),function(t){function e(e){if(this.elements=[],e)for(var n in e.elements)switch(e.elements[n].elementType){case"accidental":this.elements.push(new t.MusicAccidental(e.elements[n]));break;case"annotation":this.elements.push(new t.MusicAnnotation(e.elements[n]));break;case"arpeggiate":this.elements.push(new t.MusicArpeggiate(e.elements[n]));break;case"bar":this.elements.push(new t.MusicBar(e.elements[n]));break;case"beam":this.elements.push(new t.MusicBeam(e.elements[n]));break;case"chord":this.elements.push(new t.MusicChord(e.elements[n]));break;case"clef":this.elements.push(new t.MusicClef(e.elements[n]));break;case"decoration":this.elements.push(new t.MusicDecoration(e.elements[n]));break;case"dots":this.elements.push(new t.MusicDots(e.elements[n]));break;case"head":this.elements.push(new t.MusicHead(e.elements[n]));break;case"keySignature":this.elements.push(new t.MusicKeySignature(e.elements[n]));break;case"ledgerLine":this.elements.push(new t.MusicLedgerLine(e.elements[n]));break;case"note":this.elements.push(new t.MusicNote(e.elements[n]));
break;case"rest":this.elements.push(new t.MusicRest(e.elements[n]));break;case"slur":this.elements.push(new t.MusicSlur(e.elements[n]));break;case"stem":this.elements.push(new t.MusicStem(e.elements[n]));break;case"tie":this.elements.push(new t.MusicTie(e.elements[n]));break;case"timeSignature":this.elements.push(new t.MusicTimeSignature(e.elements[n]));break;case"tuplet":this.elements.push(new t.MusicTuplet(e.elements[n]));break;case"tupletBracket":this.elements.push(new t.MusicTupletBracket(e.elements[n]));break;default:throw new Error("Unknown music element")}}e.prototype.getElements=function(){return this.elements},t.MusicPart=e}(MyScript),function(t){function e(t){t&&(this.alteration=t.alteration,this.octave=t.octave,this.step=t.step)}e.prototype.getAlteration=function(){return this.alteration},e.prototype.getOctave=function(){return this.octave},e.prototype.getStep=function(){return this.step},t.MusicPitchData=e}(MyScript),function(t){function e(e){if(t.MusicElement.call(this,e),this.decorations=[],this.startSlurs=[],this.stopSlurs=[],e){this.type=e.type,this.dots=new t.MusicDots(e.dots),this.startTuplet=new t.MusicTuplet(e.startTuplet),this.stopTuplet=new t.MusicTuplet(e.stopTuplet),this.timeModification=new t.MusicTimeModificationData(e.timeModification),this.duration=e.duration;for(var n in e.decorations)this.decorations.push(new t.MusicDecoration(e.decorations[n]));for(var o in e.startSlurs)this.startSlurs.push(new t.MusicSlur(e.startSlurs[o]));for(var i in e.stopSlurs)this.stopSlurs.push(new t.MusicSlur(e.stopSlurs[i]))}}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getType=function(){return this.type},e.prototype.getDots=function(){return this.dots},e.prototype.getStartTuplet=function(){return this.startTuplet},e.prototype.getStopTuplet=function(){return this.stopTuplet},e.prototype.getTimeModification=function(){return this.timeModification},e.prototype.getDuration=function(){return this.duration},e.prototype.getDecorations=function(){return this.decorations},e.prototype.getStartSlurs=function(){return this.startSlurs},e.prototype.getStopSlurs=function(){return this.stopSlurs},t.MusicRest=e}(MyScript),function(t){function e(e){t.AbstractResult.call(this,e),e&&(this.result=new t.MusicDocument(e.result))}e.prototype=new t.AbstractResult,e.prototype.constructor=e,t.MusicResult=e}(MyScript),function(t){function e(e){if(this.parts=[],e)for(var n in e.parts)this.parts.push(new t.MusicPart(e.parts[n]))}e.prototype.getParts=function(){return this.parts},t.MusicScore=e}(MyScript),function(t){function e(e){t.MusicResultElement.call(this,e),e&&(this.score=new t.MusicScore(e.score))}e.prototype=new t.MusicResultElement,e.prototype.constructor=e,e.prototype.getScore=function(){return this.score},t.MusicScoreTreeResultElement=e}(MyScript),function(t){function e(e){if(this.inputRanges=[],this.erasedInputRanges=[],e){for(var n in e.inputRanges)this.inputRanges.push(new t.MusicInputRange(e.inputRanges[n]));for(var o in e.erasedInputRanges)this.erasedInputRanges.push(new t.MusicInputRange(e.erasedInputRanges[o]))}}e.prototype.getInputRanges=function(){return this.inputRanges},e.prototype.getErasedInputRanges=function(){return this.erasedInputRanges},t.MusicScratchOut=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.placement=e.placement)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getPlacement=function(){return this.placement},t.MusicSlur=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.type=e.type)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getType=function(){return this.type},t.MusicStem=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.placement=e.placement)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getPlacement=function(){return this.placement},t.MusicTie=e}(MyScript),function(t){function e(t){t&&(this.actual=t.actual,this.dots=t.dots,this.normal=t.normal,this.type=t.type)}e.prototype.getActual=function(){return this.actual},e.prototype.getDots=function(){return this.dots},e.prototype.getNormal=function(){return this.normal},e.prototype.getType=function(){return this.type},t.MusicTimeModificationData=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.top=new t.MusicAnnotation(e.top),this.bottom=new t.MusicAnnotation(e.bottom),this.type=e.type)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getTop=function(){return this.top},e.prototype.getBottom=function(){return this.bottom},e.prototype.getType=function(){return this.type},t.MusicTimeSignature=e}(MyScript),function(t){function e(e){t.MusicElement.call(this,e),e&&(this.type=e.type)}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getType=function(){return this.type},t.MusicTupletBracket=e}(MyScript),function(t){function e(e){if(t.MusicElement.call(this,e),this.brackets=[],e){this.placement=e.placement,this.number=new t.MusicAnnotation(e.number);for(var n in e.brackets)this.brackets.push(new t.MusicTupletBracket(e.brackets[n]))}}e.prototype=new t.MusicElement,e.prototype.constructor=e,e.prototype.getPlacement=function(){return this.placement},e.prototype.getNumber=function(){return this.number},e.prototype.getBrackets=function(){return this.brackets},t.MusicTuplet=e}(MyScript),function(t){function e(e){t.MusicResultElement.call(this,e),e&&(this.value=e.value)}e.prototype=new t.MusicResultElement,e.prototype.constructor=e,e.prototype.getValue=function(){return this.value},t.MusicXMLResultElement=e}(MyScript),function(t){function e(t){t&&(this.elementType=t.elementType)}e.prototype.getElementType=function(){return this.elementType},t.AnalyzerElement=e}(MyScript),function(t){function e(e){t.AnalyzerElement.call(this,e),e&&(this.data=new t.AnalyzerCellData(e.data))}e.prototype=new t.AnalyzerElement,e.prototype.constructor=e,e.prototype.getData=function(){return this.data},t.AnalyzerCell=e}(MyScript),function(t){function e(e){e&&(this.firstColumn=e.firstColumn,this.lastColumn=e.lastColumn,this.firstRow=e.firstRow,this.lastRow=e.lastRow,this.height=e.height,this.width=e.width,this.orientation=e.orientation,this.topLeftPoint=new t.Point(e.topLeftPoint),this.topBorder=e.topBorder,this.bottomBorder=e.bottomBorder,this.leftBorder=e.leftBorder,this.rightBorder=e.rightBorder)}e.prototype.getFirstColumn=function(){return this.firstColumn},e.prototype.getLastColumn=function(){return this.lastColumn},e.prototype.getFirstRow=function(){return this.firstRow},e.prototype.getLastRow=function(){return this.lastRow},e.prototype.getHeight=function(){return this.height},e.prototype.getWidth=function(){return this.width},e.prototype.getOrientation=function(){return this.orientation},e.prototype.getTopLeftPoint=function(){return this.topLeftPoint},e.prototype.hasTopBorder=function(){return this.topBorder},e.prototype.hasBottomBorder=function(){return this.bottomBorder},e.prototype.hasLeftBorder=function(){return this.leftBorder},e.prototype.hasRightBorder=function(){return this.rightBorder},e.prototype.getBoundingBox=function(){var e=new t.Rectangle;return e.setTopLeftPoint(this.getTopLeftPoint()),e.setWidth(this.getWidth()),e.setHeight(this.getHeight()),e},t.AnalyzerCellData=e}(MyScript),function(t){function e(e){if(t.AnalyzerElement.call(this,e),this.textLines=[],this.shapes=[],this.tables=[],this.groups=[],e){for(var n in e.textLines)this.textLines.push(new t.AnalyzerTextLine(e.textLines[n]));for(var o in e.shapes)this.shapes.push(new t.ShapeSegment(e.shapes[o]));for(var i in e.tables)this.tables.push(new t.AnalyzerTable(e.tables[i]));for(var r in e.groups)this.groups.push(new t.AnalyzerGroup(e.groups[r]))}}e.prototype=new t.AnalyzerElement,e.prototype.constructor=e,e.prototype.getTextLines=function(){return this.textLines},e.prototype.getShapes=function(){return this.shapes},e.prototype.getTables=function(){return this.tables},e.prototype.getGroups=function(){return this.groups},e.prototype.hasScratchOutResults=function(){for(var e in this.getShapes()){var n=this.getShapes()[e];for(var o in n.getCandidates()){var i=n.getCandidates()[o];if(i instanceof t.ShapeScratchOut)return!0}}return!1},t.AnalyzerDocument=e}(MyScript),function(t){function e(t){t&&(this.uniqueID=t.uniqueID,this.type=t.type)}e.prototype.getUniqueId=function(){return this.uniqueID},e.prototype.getType=function(){return this.type},t.AnalyzerElementReference=e}(MyScript),function(t){function e(e){if(t.AnalyzerElement.call(this,e),this.elementReferences=[],e){this.type=e.type,this.uniqueID=e.uniqueID;for(var n in e.elementReferences)this.elementReferences.push(new t.AnalyzerElementReference(e.elementReferences[n]))}}e.prototype=new t.AnalyzerElement,e.prototype.constructor=e,e.prototype.getElementReferences=function(){return this.elementReferences},e.prototype.getType=function(){return this.type},e.prototype.getUniqueId=function(){return this.uniqueID},t.AnalyzerGroup=e}(MyScript),function(t){function e(e){e&&(this.firstPoint=new t.Point(e.firstPoint),this.lastPoint=new t.Point(e.lastPoint),this.stroke=new t.AnalyzerRecognizedStroke(e.stroke))}e.prototype.getFirstPoint=function(){return this.firstPoint},e.prototype.getLastPoint=function(){return this.lastPoint},e.prototype.getStroke=function(){return this.stroke},t.AnalyzerInkRange=e}(MyScript),function(t){function e(e){t.AnalyzerElement.call(this,e),e&&(this.data=new t.AnalyzerLineData(e.data))}e.prototype=new t.AnalyzerElement,e.prototype.constructor=e,e.prototype.getData=function(){return this.data},t.AnalyzerLine=e}(MyScript),function(t){function e(e){e&&(this.p1=new t.Point(e.p1),this.p2=new t.Point(e.p2))}e.prototype.getP1=function(){return this.p1},e.prototype.getP2=function(){return this.p2},t.AnalyzerLineData=e}(MyScript),function(t){function e(t){t&&(this.type=t.type,this.x=t.x,this.y=t.y)}e.prototype.getType=function(){return this.type},e.prototype.getX=function(){return this.x},e.prototype.getY=function(){return this.y},t.AnalyzerRecognizedStroke=e}(MyScript),function(t){function e(e){t.AbstractResult.call(this,e),e&&(this.result=new t.AnalyzerDocument(e.result))}e.prototype=new t.AbstractResult,e.prototype.constructor=e,t.AnalyzerResult=e}(MyScript),function(t){function e(e){e&&(this.inkRange=new t.AnalyzerInkRange(e.inkRange),this.type=e.type)}e.prototype.getInkRange=function(){return this.inkRange},e.prototype.getType=function(){return this.type},t.AnalyzerStrokeType=e}(MyScript),function(t){function e(e){if(t.AnalyzerElement.call(this,e),this.lines=[],this.cells=[],this.inkRanges=[],e){this.data=new t.AnalyzerTableData(e.data);for(var n in e.lines)this.lines.push(new t.AnalyzerLine(e.lines[n]));for(var o in e.cells)this.cells.push(new t.AnalyzerCell(e.cells[o]));for(var i in e.inkRanges)this.inkRanges.push(new t.AnalyzerInkRange(e.inkRanges[i]))}}e.prototype=new t.AnalyzerElement,e.prototype.constructor=e,e.prototype.getData=function(){return this.data},e.prototype.getLines=function(){return this.lines},e.prototype.getCells=function(){return this.cells},e.prototype.getInkRanges=function(){return this.inkRanges},t.AnalyzerTable=e}(MyScript),function(t){function e(t){t&&(this.columnCount=t.columnCount,this.rowCount=t.rowCount)}e.prototype.getColumnCount=function(){return this.columnCount},e.prototype.getRowCount=function(){return this.rowCount},t.AnalyzerTableData=e}(MyScript),function(t){function e(e){if(t.AnalyzerElement.call(this,e),this.inkRanges=[],this.underlineList=[],e){this.data=new t.AnalyzerTextLineData(e.data),this.result=new t.TextDocument(e.result);for(var n in e.inkRanges)this.inkRanges.push(new t.AnalyzerInkRange(e.inkRanges[n]));for(var o in e.underlineList)this.underlineList.push(new t.AnalyzerUnderline(e.underlineList[o]))}}e.prototype=new t.AnalyzerElement,e.prototype.constructor=e,e.prototype.getData=function(){return this.data},e.prototype.getTextDocument=function(){return this.result},e.prototype.getInkRanges=function(){return this.inkRanges},e.prototype.getUnderlineList=function(){return this.underlineList},t.AnalyzerTextLine=e}(MyScript),function(t){function e(e){e&&(this.baselinePos=e.baselinePos,this.toMidline=e.toMidline,this.orientation=e.orientation,this.topLeftPoint=new t.Point(e.topLeftPoint),this.textHeight=e.textHeight,this.justificationType=e.justificationType,this.height=e.height,this.width=e.width)}e.prototype.getBaselinePos=function(){return this.baselinePos},e.prototype.getToMidline=function(){return this.toMidline},e.prototype.getOrientation=function(){return this.orientation},e.prototype.getTopLeftPoint=function(){return this.topLeftPoint},e.prototype.getTextHeight=function(){return this.textHeight},e.prototype.getJustificationType=function(){return this.justificationType},e.prototype.getHeight=function(){return this.height},e.prototype.getWidth=function(){return this.width},e.prototype.getBoundingBox=function(){var e=new t.Rectangle;return(this.getTopLeftPoint()||this.getWidth()||this.getHeight())&&(e.setTopLeftPoint(this.getTopLeftPoint()),e.setWidth(this.getWidth()),e.setHeight(this.getHeight())),e},t.AnalyzerTextLineData=e}(MyScript),function(t){function e(e){if(t.AnalyzerElement.call(this,e),this.inkRanges=[],e){this.data=new t.AnalyzerUnderlineData(e.data);for(var n in e.inkRanges)this.inkRanges.push(new t.AnalyzerInkRange(e.inkRanges[n]))}}e.prototype=new t.AnalyzerElement,e.prototype.constructor=e,e.prototype.getData=function(){return this.data},e.prototype.getInkRanges=function(){return this.inkRanges},t.AnalyzerUnderline=e}(MyScript),function(t){function e(t){t&&(this.firstCharacter=t.firstCharacter,this.lastCharacter=t.lastCharacter)}e.prototype.getFirstCharacter=function(){return this.firstCharacter},e.prototype.getLastCharacter=function(){return this.lastCharacter},t.AnalyzerUnderlineData=e}(MyScript),function(t,e){function n(){}n.parseURL=function(t){var e,n,o,i=document.createElement("a"),r={};for(i.href=t,e=i.search.replace(/^\?/,"").split("&"),o=0;o<e.length;o++)n=e[o].split("="),r[n[0]]=n[1];return{protocol:i.protocol,host:i.host,hostname:i.hostname,port:i.port,pathname:i.pathname,search:i.search,searchObject:r,hash:i.hash}},n.parse=function(t){var e;try{e=JSON.parse(t.responseText)}catch(n){e=t.responseText}return e},n.transformRequest=function(t){var e=[];for(var n in t)"undefined"!=typeof t[n]&&"function"!=typeof t[n]&&e.push(encodeURIComponent(n)+"="+encodeURIComponent(t[n]));return e.join("&")},n.xhr=function(t,o,i){return e.Promise(function(e,r,s){function a(){4===h.readyState&&h.status>=200&&h.status<300&&e(n.parse(h))}function c(){h.status>=200&&h.status<300?e(n.parse(h)):r(new Error(h.responseText))}function p(){r(new Error("Can't XHR "+o))}function u(t){s(t.loaded/t.total)}var h=new XMLHttpRequest;h.open(t,o,!0),h.withCredentials=!0,h.setRequestHeader("Accept","application/json"),h.setRequestHeader("Content-Type","application/x-www-form-urlencoded;charset=UTF-8"),h.onerror=p,h.onprogress=u,h.onload=c,h.onreadystatechange=a,h.send(n.transformRequest(i))})},n.get=function(e,o){return o&&(e+="?"+n.transformRequest(o)),t.NetworkInterface.xhr("GET",e,void 0)},n.put=function(e,n){return t.NetworkInterface.xhr("PUT",e,n)},n.post=function(e,n){return t.NetworkInterface.xhr("POST",e,n)},n["delete"]=function(e,n){return t.NetworkInterface.xhr("DELETE",e,n)},t.NetworkInterface=n}(MyScript,Q),function(t,e){function n(){}n.prototype.setUrl=function(t){void 0!==t&&t!==this._url&&(this.close(),this._url=t)},n.prototype.getUrl=function(){return this._url},n.prototype.setCallback=function(t){void 0!==t&&(this.close(),this._callback=t)},n.prototype.getCallback=function(){return this._callback},n.prototype.getState=function(){return r(this._socket)},n.prototype.isClosed=function(){return 3===this.getState()},n.prototype.isClosing=function(){return 2===this.getState()},n.prototype.isOpen=function(){return 1===this.getState()},n.prototype.isConnecting=function(){return 0===this.getState()},n.prototype.open=function(){this.getUrl()&&this.getCallback()&&(this.getState()<0||this.isClosed())&&(this._socket=o(this.getUrl(),this.getCallback()))},n.prototype.close=function(t,e){this.getState()<2&&i(this._socket,t,e)},n.prototype.send=function(t){var e=r(this._socket);1===e?s(this._socket,t):this.open()};var o=function(t,e){function n(t){e(t)}function o(t){e(t)}function i(t){e(t)}function r(t){e({type:t.type,data:JSON.parse(t.data)})}var s=new WebSocket(t);return s.onopen=n,s.onclose=o,s.onerror=i,s.onmessage=r,s},i=function(t,e,n){t&&t.close(e,n)},r=function(t){return t?t.readyState:-1},s=function(t,e){t&&t.send(JSON.stringify(e))};t.NetworkWSInterface=n}(MyScript,Q),function(t,e){function n(t){this.setUrl(this.getProtocol()+"cloud.myscript.com"),t&&this.setUrl(this.getProtocol()+t),this.setSSL(!0)}n.prototype.getProtocol=function(){return this._ssl?"https://":"http://"},n.prototype.getSSL=function(){return this._ssl},n.prototype.setSSL=function(t){void 0!==t&&(this._ssl=t,this.setUrl(this.getProtocol()+this.getHost()))},n.prototype.getHost=function(){return t.NetworkInterface.parseURL(this.getUrl()).host},n.prototype.setHost=function(t){void 0!==t&&this.setUrl(this.getProtocol()+t)},n.prototype.getUrl=function(){return this.url},n.prototype.setUrl=function(t){void 0!==t&&(this.url=t)},n.prototype.getParameters=function(){return this.parameters},n.prototype.setParameters=function(t){this.parameters=t},n.prototype.getPrecision=function(){return this.precision},n.prototype.setPrecision=function(t){this.precision=t},n.prototype.getAvailableLanguageList=function(e,n){var o=new t.RecognitionLanguagesData;return o.setApplicationKey(e),o.setInputMode(n),t.NetworkInterface.get(this.getUrl()+"/api/v3.0/recognition/rest/text/languages.json",o).then(function(t){return t.result})},n.prototype.doRestRecognition=function(e,n,r,p){if(e.getComponents)u(e.getComponents(),this.getPrecision());else if(e.getInputUnits)for(var h in e.getInputUnits())u(e.getInputUnits()[h].getComponents(),this.getPrecision());if(e instanceof t.TextRecognitionInput)return o(this.getUrl(),e,n,r,p);if(e instanceof t.ShapeRecognitionInput)return i(this.getUrl(),e,n,r,p);if(e instanceof t.MathRecognitionInput)return s(this.getUrl(),e,n,r,p);if(e instanceof t.MusicRecognitionInput)return a(this.getUrl(),e,n,r,p);if(e instanceof t.AnalyzerRecognitionInput)return c(this.getUrl(),e,n,r,p);throw new Error("not implemented")},n.prototype.clearRestRecognition=function(t){var e={instanceSessionId:t};return r(this.getUrl(),e)};var o=function(e,n,o,i,r){var s=new t.TextRecognitionData;return h(s,n,r,o,i),t.NetworkInterface.post(e+"/api/v3.0/recognition/rest/text/doSimpleRecognition.json",s).then(function(e){return new t.TextResult(e)})},i=function(e,n,o,i,r){var s=new t.ShapeRecognitionData;return h(s,n,r,o,i),t.NetworkInterface.post(e+"/api/v3.0/recognition/rest/shape/doSimpleRecognition.json",s).then(function(e){return new t.ShapeResult(e)})},r=function(e,n){var o={instanceSessionId:n};return t.NetworkInterface.post(e+"/api/v3.0/recognition/rest/shape/clearSessionId.json",o).then(function(e){return new t.ShapeResult(e)})},s=function(e,n,o,i,r){var s=new t.MathRecognitionData;return h(s,n,r,o,i),t.NetworkInterface.post(e+"/api/v3.0/recognition/rest/math/doSimpleRecognition.json",s).then(function(e){return new t.MathResult(e)})},a=function(e,n,o,i,r){var s=new t.MusicRecognitionData;return h(s,n,r,o,i),t.NetworkInterface.post(e+"/api/v3.0/recognition/rest/music/doSimpleRecognition.json",s).then(function(e){return new t.MusicResult(e)})},c=function(e,n,o,i,r){var s=new t.AnalyzerRecognitionData;return h(s,n,r,o,i),t.NetworkInterface.post(e+"/api/v3.0/recognition/rest/analyzer/doSimpleRecognition.json",s).then(function(e){return new t.AnalyzerResult(e)})},p=function(t,n,o){var i="object"==typeof t?JSON.stringify(t):t;return e.HmacSHA512(i,n+o).toString(e.enc.Hex)},u=function(e,n){e.forEach(function(e){e instanceof t.StrokeComponent&&e.toFixed(n)})},h=function(t,e,n,o,i){t.setRecognitionInput(e),t.setApplicationKey(o),t.setInstanceId(n),i&&t.setHmac(p(t.getRecognitionInput(),o,i))};t.AbstractRecognizer=n}(MyScript,CryptoJS),function(t,e){function n(){this._wsInterface=new t.NetworkWSInterface}n.prototype.getProtocol=function(){return this._ssl?"wss://":"ws://"},n.prototype.getSSL=function(){return this._ssl},n.prototype.setSSL=function(t){void 0!==t&&(this._ssl=t,this.setUrl(this.getProtocol()+this.getHost()))},n.prototype.getHost=function(){return t.NetworkInterface.parseURL(this.getUrl()).host},n.prototype.setHost=function(t){void 0!==t&&t!=this.getHost()&&this.setUrl(this.getProtocol()+t)},n.prototype.setUrl=function(t){throw new Error("not implemented")},n.prototype.getUrl=function(){return this._wsInterface.getUrl()},n.prototype.setCallback=function(t){throw new Error("not implemented")},n.prototype.getParameters=function(){return this.parameters},n.prototype.setParameters=function(t){this.parameters=t},n.prototype.getPrecision=function(){return this.precision},n.prototype.setPrecision=function(t){this.precision=t},n.prototype.isClosed=function(){return this._wsInterface.isClosed()},n.prototype.isClosing=function(){return this._wsInterface.isClosing()},n.prototype.isOpen=function(){return this._wsInterface.isOpen()},n.prototype.isConnecting=function(){return this._wsInterface.isConnecting()},n.prototype.open=function(){this._wsInterface.open()},n.prototype.close=function(){this._wsInterface.close()},n.prototype.sendMessage=function(t){if(t.getComponents)i(t.getComponents(),this.getPrecision());else if(t.getInputUnits)for(var e in t.getInputUnits())i(t.getInputUnits()[e].getComponents(),this.getPrecision());this._wsInterface.send(t)},n.prototype.initWSRecognition=function(e){var n=new t.InitRequestWSMessage;n.setApplicationKey(e),this.sendMessage(n)},n.prototype.takeUpHmacChallenge=function(e,n,i){var r=new t.ChallengeRequestWSMessage;r.setApplicationKey(e),r.setChallenge(n),i&&r.setHmacSignature(o(n,e,i)),this.sendMessage(r)},n.prototype.resetWSRecognition=function(){var e=new t.ResetRequestWSMessage;this.sendMessage(e)};var o=function(t,n,o){var i="object"==typeof t?JSON.stringify(t):t;return e.HmacSHA512(i,n+o).toString(e.enc.Hex)},i=function(e,n){e.forEach(function(e){e instanceof t.StrokeComponent&&e.toFixed(n)})};t.AbstractWSRecognizer=n}(MyScript,CryptoJS),function(t){function e(e){t.AbstractRecognizer.call(this,e),this.parameters=new t.TextParameter,this.parameters.setLanguage("en_US"),this.parameters.setInputMode("CURSIVE")}e.prototype=new t.AbstractRecognizer,e.prototype.constructor=e,e.prototype.doSimpleRecognition=function(e,n,o,i,r){var s=this.getParameters();r&&(s=r);var a=[];if(o&&o.length>0)if(o[0]instanceof t.TextInputUnit)a=o;else{var c=new t.TextInputUnit;c.setComponents(o),a.push(c)}var p=new t.TextRecognitionInput;return p.setParameters(s),p.setInputUnits(a),t.AbstractRecognizer.prototype.doRestRecognition.call(this,p,e,i,n)},t.TextRecognizer=e}(MyScript),function(t){function e(e,n){t.AbstractWSRecognizer.call(this),this.parameters=new t.TextParameter,this.parameters.setLanguage("en_US"),this.parameters.setInputMode("CURSIVE"),this.setUrl(this.getProtocol()+"cloud.myscript.com"),n&&this.setUrl(this.getProtocol()+n),this.setSSL(!0),this.setCallback(e)}e.prototype=new t.AbstractWSRecognizer,e.prototype.constructor=e,e.prototype.getParameters=function(){return this.parameters},e.prototype.setParameters=function(t){this.parameters=t},e.prototype.setUrl=function(t){void 0!==t&&this._wsInterface.setUrl(t+"/api/v3.0/recognition/ws/text")},e.prototype.setCallback=function(e){void 0!==e&&this._wsInterface.setCallback(function(n){switch(n.type){case"open":e(n);break;case"close":e(n);break;case"error":e(void 0,n);break;default:switch(n.data.type){case"init":n.data=new t.InitResponseWSMessage(n.data),e(n.data);break;case"reset":n.data=new t.ResetResponseWSMessage(n.data),e(n.data);break;case"error":n.data=new t.ErrorResponseWSMessage(n.data),e(void 0,new Error(JSON.stringify(n.data.getError())));break;case"hmacChallenge":n.data=new t.ChallengeResponseWSMessage(n.data),e(n.data);break;default:n.data=new t.TextResponseWSMessage(n.data),e(n.data)}}})},e.prototype.startWSRecognition=function(e,n){var o=new t.TextStartRequestWSMessage,i=this.getParameters();n&&(i=n);var r=[];if(e&&e.length>0)if(e[0]instanceof t.TextInputUnit)r=e;else{var s=new t.TextInputUnit;s.setComponents(e),r.push(s)}o.setParameters(i),o.setInputUnits(r),this.sendMessage(o)},e.prototype.continueWSRecognition=function(e,n){var o=new t.TextContinueRequestWSMessage,i=[];if(e&&e.length>0)if(e[0]instanceof t.TextInputUnit)i=e;else{var r=new t.TextInputUnit;r.setComponents(e),i.push(r)}o.setInputUnits(i),o.setInstanceId(n),this.sendMessage(o)},t.TextWSRecognizer=e}(MyScript),function(t){function e(e){t.AbstractRecognizer.call(this,e),this.parameters=new t.ShapeParameter}e.prototype=new t.AbstractRecognizer,e.prototype.constructor=e,e.prototype.doSimpleRecognition=function(e,n,o,i,r){var s=this.getParameters();r&&(s=r);var a=new t.ShapeRecognitionInput;return a.setParameters(s),a.setComponents(o),t.AbstractRecognizer.prototype.doRestRecognition.call(this,a,e,i,n)},e.prototype.clearShapeRecognitionSession=function(e,n){return t.AbstractRecognizer.prototype.clearRestRecognition.call(this,n)},t.ShapeRecognizer=e}(MyScript),function(t){function e(e){t.AbstractRecognizer.call(this,e),this.parameters=new t.MathParameter}e.prototype=new t.AbstractRecognizer,e.prototype.constructor=e,e.prototype.doSimpleRecognition=function(e,n,o,i,r){var s=this.getParameters();r&&(s=r);var a=new t.MathRecognitionInput;return a.setParameters(s),a.setComponents(o),t.AbstractRecognizer.prototype.doRestRecognition.call(this,a,e,i,n)},t.MathRecognizer=e}(MyScript),function(t){function e(e,n){t.AbstractWSRecognizer.call(this),this.parameters=new t.MathParameter,this.setUrl(this.getProtocol()+"cloud.myscript.com"),n&&this.setUrl(this.getProtocol()+n),this.setSSL(!0),this.setCallback(e)}e.prototype=new t.AbstractWSRecognizer,e.prototype.constructor=e,e.prototype.getParameters=function(){return this.parameters},e.prototype.setParameters=function(t){this.parameters=t},e.prototype.setUrl=function(t){void 0!==t&&this._wsInterface.setUrl(t+"/api/v3.0/recognition/ws/math")},e.prototype.setCallback=function(e){void 0!==e&&this._wsInterface.setCallback(function(n){switch(n.type){case"open":e(n);break;case"close":e(n);break;case"error":e(void 0,n);break;default:switch(n.data.type){case"init":n.data=new t.InitResponseWSMessage(n.data),e(n.data);break;case"reset":n.data=new t.ResetResponseWSMessage(n.data),e(n.data);break;case"error":n.data=new t.ErrorResponseWSMessage(n.data),e(void 0,new Error(JSON.stringify(n.data.getError())));break;case"hmacChallenge":n.data=new t.ChallengeResponseWSMessage(n.data),e(n.data);break;default:n.data=new t.MathResponseWSMessage(n.data),e(n.data)}}})},e.prototype.startWSRecognition=function(e,n){var o=new t.MathStartRequestWSMessage,i=this.getParameters();n&&(i=n),o.setParameters(i),o.setComponents(e),this.sendMessage(o)},e.prototype.continueWSRecognition=function(e,n){var o=new t.MathContinueRequestWSMessage;o.setComponents(e),o.setInstanceId(n),this.sendMessage(o)},t.MathWSRecognizer=e}(MyScript),function(t){function e(e){t.AbstractRecognizer.call(this,e),this.parameters=new t.MusicParameter}e.prototype=new t.AbstractRecognizer,e.prototype.constructor=e,e.prototype.doSimpleRecognition=function(e,n,o,i,r){var s=this.getParameters();r&&(s=r);var a=new t.MusicRecognitionInput;return a.setParameters(s),a.setComponents(o),t.AbstractRecognizer.prototype.doRestRecognition.call(this,a,e,i,n)},t.MusicRecognizer=e}(MyScript),function(t){function e(e){t.AbstractRecognizer.call(this,e),this.parameters=new t.AnalyzerParameter}e.prototype=new t.AbstractRecognizer,e.prototype.constructor=e,e.prototype.doSimpleRecognition=function(e,n,o,i,r){var s=this.getParameters();r&&(s=r);var a=new t.AnalyzerRecognitionInput;return a.setParameters(s),a.setComponents(o),t.AbstractRecognizer.prototype.doRestRecognition.call(this,a,e,i,n)},t.AnalyzerRecognizer=e}(MyScript),function(t){function e(e){this.penParameters=new t.PenParameters,this.showBoundingBoxes=!1,this.typeset=!0,this.context=e}function n(t,e,n){var o=t.p*n;return[{x:t.x-Math.sin(e)*o,y:t.y+Math.cos(e)*o},{x:t.x+Math.sin(e)*o,y:t.y-Math.cos(e)*o}]}function o(t,e){return{x:(e.x+t.x)/2,y:(e.y+t.y)/2,p:(e.p+t.p)/2}}function i(t,e){return Math.atan2(e.y-t.y,e.x-t.x)}function r(t,e){void 0!==e&&(t.fillStyle=e,t.fill())}function s(t,e){e.beginPath();var n=t.getLength(),i=t.getWidth(),s=t.getPointByIndex(0);if(3>n)e.arc(s.x,s.y,.6*i,0,2*Math.PI,!0);else{e.arc(s.x,s.y,i*s.p,0,2*Math.PI,!0),c(e,s,o(s,t.getPointByIndex(1)),i);for(var u=n-2,h=0;u>h;h++)p(e,o(t.getPointByIndex(h),t.getPointByIndex(h+1)),o(t.getPointByIndex(h+1),t.getPointByIndex(h+2)),t.getPointByIndex(h+1),i);c(e,o(t.getPointByIndex(n-2),t.getPointByIndex(n-1)),t.getPointByIndex(n-1),i),a(e,t.getPointByIndex(n-2),t.getPointByIndex(n-1),i)}e.closePath(),r(e,t.getColor())}function a(t,e,o,r){var s=6,a=i(e,o),c=n(o,a,r);t.moveTo(c[0].x,c[0].y);for(var p=1;s>=p;p++){var u=a-p*Math.PI/s;t.lineTo(o.x-o.p*r*Math.sin(u),o.y+o.p*r*Math.cos(u))}}function c(t,e,o,r){var s=n(e,i(e,o),r),a=n(o,i(e,o),r);t.moveTo(s[0].x,s[0].y),t.lineTo(a[0].x,a[0].y),t.lineTo(a[1].x,a[1].y),t.lineTo(s[1].x,s[1].y)}function p(t,e,o,r,s){var a=n(e,i(e,r),s),c=n(o,i(r,o),s),p=n(r,i(e,o),s);t.moveTo(a[0].x,a[0].y),t.quadraticCurveTo(p[0].x,p[0].y,c[0].x,c[0].y),t.lineTo(c[1].x,c[1].y),t.quadraticCurveTo(p[1].x,p[1].y,a[1].x,a[1].y)}e.prototype.getContext=function(){return this.context},e.prototype.getShowBoundingBoxes=function(){return this.showBoundingBoxes},e.prototype.setShowBoundingBoxes=function(t){this.showBoundingBoxes=t},e.prototype.getParameters=function(){return this.penParameters},e.prototype.setParameters=function(t){this.penParameters=t},e.prototype.isTypesetting=function(){return this.typeset},e.prototype.setTypeset=function(t){this.typeset=t},e.prototype.clear=function(){this.getContext().clearRect(0,0,this.getContext().canvas.width,this.getContext().canvas.height)},e.prototype.drawRecognitionResult=function(t,e){throw new Error("not implemented")},e.prototype.drawComponents=function(t){throw new Error("not implemented")},e.prototype.drawComponent=function(e){if(e instanceof t.StrokeComponent)u(e,this.getContext(),this.getParameters());else{if(!(e instanceof t.CharacterInputComponent))throw new Error("Component not implemented: "+e.getType());h(e,this.getContext(),this.getParameters())}};var u=function(t,e,n){t&&t.getLength()>0&&s(t,e)},h=function(t,e,n){throw new Error("not implemented")};t.AbstractRenderer=e}(MyScript),function(t){function e(e){t.AbstractRenderer.call(this,e)}e.prototype=new t.AbstractRenderer,e.prototype.constructor=e,e.prototype.drawRecognitionResult=function(t,e){this.clear(),e?this.drawComponents(t):this.drawComponents(t)},e.prototype.drawComponents=function(e){for(var o in e){var i=e[o];if(i instanceof t.TextInputUnit)this.drawComponents(i.getComponents());else if(i instanceof t.AbstractTextInputComponent)n(i,this.getContext(),this.getParameters());else{if(!(i instanceof t.AbstractComponent))throw new Error("not implemented");t.AbstractRenderer.prototype.drawComponent.call(this,i)}}};var n=function(e,n,r){if(e instanceof t.CharInputComponent)o(e,n,r);else{if(!(e instanceof t.StringInputComponent))throw new Error("Component not implemented: "+e.getType());i(e,n,r)}},o=function(t,e,n){throw new Error("not implemented")},i=function(t,e,n){throw new Error("not implemented")};t.TextRenderer=e}(MyScript),function(t){function e(e){t.AbstractRenderer.call(this,e)}e.prototype=new t.AbstractRenderer,e.prototype.constructor=e,e.prototype.drawRecognitionResult=function(e,n){if(this.clear(),n&&n instanceof t.ShapeDocument){this.drawShapes(e,n.getSegments());var o=[],i=u(e,n.getInkRanges());for(var r in e){var s=e[r];-1!==i.indexOf(s)&&o.push(s)}this.drawComponents(o)}else this.drawComponents(e);return{components:e,document:n}},e.prototype.drawComponents=function(e){
for(var n in e){var i=e[n];if(i instanceof t.AbstractShapePrimitive)o(i,this.getContext(),this.getParameters());else{if(!(i instanceof t.AbstractComponent))throw new Error("not implemented");t.AbstractRenderer.prototype.drawComponent.call(this,i)}}},e.prototype.drawShapes=function(t,e){for(var n in e)this.drawShapeSegment(t,e[n])},e.prototype.drawShapeSegment=function(e,o){var i=o.getSelectedCandidate();if(i instanceof t.ShapeRecognized)n(i,this.getContext(),this.getParameters());else{if(!(i instanceof t.ShapeNotRecognized))throw new Error("not implemented");this.drawComponents(u(e,o.getInkRanges()))}},e.prototype.drawShapeNotRecognized=function(t,e){this.drawComponents(u(t,e))},e.prototype.drawShapePrimitive=function(t){o(t,this.getContext(),this.getParameters())};var n=function(t,e,n){for(var i in t.getPrimitives())o(t.getPrimitives()[i],e,n)},o=function(e,n,o){if(e instanceof t.ShapeEllipse)r(e,n,o);else{if(!(e instanceof t.ShapeLine))throw new Error("Primitive not implemented: "+e.getType());i(e,n,o)}},i=function(t,e,n){a(t.getFirstPoint(),t.getLastPoint(),e,n),t.hasBeginDecoration()&&"ARROW_HEAD"===t.getBeginDecoration()&&p(t.getFirstPoint(),t.getBeginTangentAngle(),12,e,n),t.hasEndDecoration()&&"ARROW_HEAD"===t.getEndDecoration()&&p(t.getLastPoint(),t.getEndTangentAngle(),12,e,n)},r=function(t,e,n){var o=s(t.getCenter(),t.getMaxRadius(),t.getMinRadius(),t.getOrientation(),t.getStartAngle(),t.getSweepAngle(),e,n);t.hasBeginDecoration()&&"ARROW_HEAD"===t.getBeginDecoration()&&p(o[0],t.getBeginTangentAngle(),12,e,n),t.hasEndDecoration()&&"ARROW_HEAD"===t.getEndDecoration()&&p(o[1],t.getEndTangentAngle(),12,e,n)},s=function(e,n,o,i,r,s,a,c){var p=.02,u=Math.cos(i),h=Math.sin(i),l=u,g=h;u*=n,l*=o,h*=n,g*=o;var f=Math.floor(Math.abs(s)/p),y=[];a.save();try{a.fillStyle=c.getColor(),a.strokeStyle=c.getColor(),a.lineWidth=.5*c.getWidth(),a.beginPath();for(var d=0;f>=d;d++){var m=r+d/f*s,S=Math.atan2(Math.sin(m)/o,Math.cos(m)/n),R=Math.cos(S),M=Math.sin(S),w=e.x+u*R-g*M,C=e.y+l*M+h*R;0===d?a.moveTo(w,C):a.lineTo(w,C),(0===d||d===f)&&y.push(new t.Point({x:w,y:C}))}a.stroke()}finally{a.restore()}return y},a=function(t,e,n,o){n.save();try{n.fillStyle=o.getColor(),n.strokeStyle=o.getColor(),n.lineWidth=.5*o.getWidth(),n.beginPath(),n.moveTo(t.getX(),t.getY()),n.lineTo(e.getX(),e.getY()),n.stroke()}finally{n.restore()}},c=function(t){return t=(t+Math.PI)%(2*Math.PI)-Math.PI,t<-Math.PI&&(t+=2*Math.PI),t},p=function(t,e,n,o,i){var r=c(e+Math.PI-Math.PI/8),s=c(e-Math.PI+Math.PI/8);o.save();try{o.fillStyle=i.getColor(),o.strokeStyle=i.getColor(),o.lineWidth=.5*i.getWidth(),o.moveTo(t.getX(),t.getY()),o.beginPath(),o.lineTo(t.getX()+n*Math.cos(r),t.getY()+n*Math.sin(r)),o.lineTo(t.getX()+n*Math.cos(s),t.getY()+n*Math.sin(s)),o.lineTo(t.getX(),t.getY()),o.fill()}finally{o.restore()}},u=function(e,n){var o=[];for(var i in n)for(var r=n[i],s=Math.floor(r.getFirstPoint()),a=Math.ceil(r.getLastPoint()),c=r.getFirstStroke();c<=r.getLastStroke();c++){var p=e[c],u=p.getX().length,h=new t.StrokeComponent;h.setColor(p.getColor()),h.setWidth(p.getWidth());for(var l=s;c===r.getLastStroke()&&a>=l&&u>l||c!==r.getLastStroke()&&u>l;l++)h.addPoint(p.getX()[l],p.getY()[l],p.getT()[l]);o.push(h)}return o};t.ShapeRenderer=e}(MyScript),function(t){function e(e){t.AbstractRenderer.call(this,e)}e.prototype=new t.AbstractRenderer,e.prototype.constructor=e,e.prototype.drawRecognitionResult=function(t,e){if(this.clear(),e){var o=n(t,e.getScratchOutResults());this.drawComponents(o)}else this.drawComponents(t)},e.prototype.drawComponents=function(e){for(var n in e){var o=e[n];if(!(o instanceof t.AbstractComponent))throw new Error("not implemented");o.scratchedStroke||t.AbstractRenderer.prototype.drawComponent.call(this,o)}};var n=function(t,e){if(!e||0===e.length)return t;for(var n in e){for(var o in e[n].getErasedInkRanges())t[e[n].getErasedInkRanges()[o].getComponent()].scratchedStroke=!0;for(var i in e[n].getInkRanges())t[e[n].getInkRanges()[i].getComponent()].scratchedStroke=!0}return t};t.MathRenderer=e}(MyScript),function(t){function e(e){t.AbstractRenderer.call(this,e)}e.prototype=new t.AbstractRenderer,e.prototype.constructor=e,e.prototype.drawRecognitionResult=function(t,e){if(this.clear(),e){var n=m(t,e.getScratchOutResults());this.drawComponents(n)}else this.drawComponents(t)},e.prototype.drawStaff=function(t){n(t,this.getContext(),this.getParameters())},e.prototype.drawComponents=function(e){for(var n in e){var i=e[n];if(i instanceof t.AbstractMusicInputComponent)o(i,this.getContext(),this.getParameters());else{if(!(i instanceof t.AbstractComponent))throw new Error("not implemented");t.AbstractRenderer.prototype.drawComponent.call(this,i)}}};var n=function(t,e,n){var o=t.getTop()+(t.getCount()-1)*t.getGap(),i=1;e.beginPath();for(var r=0;i>r;r++)for(var s=o*r,a=0;a<t.getCount();a++)e.moveTo(0,t.getTop()+s+a*t.getGap()),e.lineTo(e.canvas.clientWidth,t.getTop()+s+a*t.getGap());e.stroke()},o=function(e,n,o){if(e instanceof t.MusicAccidentalInputComponent)i(e,n,o);else if(e instanceof t.MusicArpeggiateInputComponent)r(e,n,o);else if(e instanceof t.MusicBarInputComponent)s(e,n,o);else if(e instanceof t.MusicBeamInputComponent)a(e,n,o);else if(e instanceof t.MusicClefInputComponent)c(e,n,o);else if(e instanceof t.MusicDecorationInputComponent)p(e,n,o);else if(e instanceof t.MusicDotsInputComponent)u(e,n,o);else if(e instanceof t.MusicHeadInputComponent)h(e,n,o);else if(e instanceof t.MusicLedgerLineInputComponent)l(e,n,o);else if(e instanceof t.MusicRestInputComponent)g(e,n,o);else if(e instanceof t.MusicStemInputComponent)f(e,n,o);else if(e instanceof t.MusicTieOrSlurInputComponent)y(e,n,o);else{if(!(e instanceof t.MusicTimeSignatureInputComponent))throw new Error("Node not implemented: "+e.getType());d(e,n,o)}},i=function(t,e,n){throw new Error("not implemented")},r=function(t,e,n){throw new Error("not implemented")},s=function(t,e,n){throw new Error("not implemented")},a=function(t,e,n){throw new Error("not implemented")},c=function(t,e,n){var o="data:image/svg+xml,";switch(t.getValue().getSymbol()){case"F":o+='<svg xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" version="1.0" x="0" y="0" width="18" height="20"><defs/><g transform="translate(6.600000e-3,3.125356e-3)"><g><path d="M17.3 3.1 C17.3 3.5 17.1 3.8 16.8 4.1 C16.5 4.4 15.9 4.5 15.5 4.3 C15 4.1 14.7 3.7 14.7 3.2 C14.6 2.8 14.8 2.5 15 2.2 C15.3 1.9 15.7 1.8 16 1.8 C16.4 1.8 16.8 2 17 2.3 C17.2 2.5 17.3 2.8 17.3 3.1 z"/></g><g><path d="M17.3 8.9 C17.3 9.3 17.1 9.7 16.8 9.9 C16.5 10.3 15.9 10.3 15.5 10.2 C15 10 14.7 9.5 14.7 9.1 C14.6 8.7 14.8 8.3 15 8 C15.3 7.8 15.7 7.6 16 7.6 C16.5 7.7 17 8 17.2 8.4 C17.2 8.6 17.3 8.8 17.3 8.9 z"/></g><g><path d="M13 7.2 C13 10 11.8 12.7 9.8 14.7 C7.3 17.2 4 18.8 0.7 19.8 C0.3 20.1 -0.4 19.8 0.3 19.4 C1.6 18.8 3 18.3 4.2 17.5 C7 15.8 9.3 13.1 9.8 9.9 C10.1 8 10.1 5.9 9.6 4 C9.2 2.6 8.2 1.1 6.7 0.9 C5.3 0.7 3.7 1.2 2.7 2.2 C2.5 2.4 2 3.2 2 4 C2.6 3.6 2.6 3.6 3.1 3.4 C4.2 2.9 5.7 3.6 6 4.9 C6.3 6 6.1 7.5 5 8.1 C3.8 8.7 2 8.5 1.4 7.2 C0.3 5.3 0.9 2.6 2.6 1.2 C4.4 -0.3 7.1 -0.3 9.2 0.4 C11.4 1.3 12.7 3.5 12.9 5.8 C13 6.2 13 6.7 13 7.2 z"/></g></g></svg>';break;case"C":o+='<svg xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" version="1.0" width="18" height="25"><defs/><g><g transform="matrix(1,0,0,1.030698,-309.364,-543.8647)"><path d="M 325.9 546.8 C 325.8 548.7 324.7 550.7 322.8 551.5 C 321.1 552.1 319.1 552.2 317.6 551 C 316.6 550.2 316.2 548.4 317.3 547.5 C 318.3 546.5 320.4 547.4 320.3 548.9 C 320.7 549.9 318.5 550.5 319.7 551.3 C 321 551.6 322.3 550.5 322.6 549.3 C 323.1 547.5 323.1 545.6 322.7 543.8 C 322.4 542.9 321.9 541.5 320.7 541.9 C 319.2 542.2 318.3 543.8 317.9 545.1 C 317.6 543.2 316.4 541.5 315 540.2 C 315 544.1 315 548 315 551.9 L 314.1 551.9 C 314.1 543.9 314.1 535.7 314.1 527.7 L 315 527.7 C 315 531.5 315 535.5 315 539.4 C 316.4 538.1 317.6 536.4 317.8 534.5 C 318.3 535.9 319.3 537.5 321 537.8 C 322.2 537.8 322.5 536.3 322.8 535.4 C 323.1 533.7 323.1 531.8 322.6 530.1 C 322.2 529 320.9 528 319.6 528.3 C 318.6 529 320.6 529.6 320.3 530.6 C 320.5 532 318.8 533 317.6 532.3 C 316.3 531.6 316.4 529.7 317.4 528.8 C 318 528.1 319.3 527.7 320.3 527.7 C 321.2 527.7 321.8 527.7 322.6 528 C 324.6 528.7 325.7 530.7 325.9 532.7 C 326.2 534.9 324.9 537.3 322.8 538.2 C 321.5 538.7 319.9 538.3 318.8 537.3 C 318.7 538.3 318.2 539.2 317.7 539.9 C 318.1 540.6 318.6 541.8 318.8 542.1 C 320.1 540.9 322.5 540.8 323.8 542 C 325.2 543.1 326.1 545 325.9 546.8 z "/></g><g transform="matrix(1,0,0,1.030928,-309.364,-543.9805)"><path d="M 312.2 551.9 L 309.4 551.9 L 309.4 527.7 L 312.2 527.7 L 312.2 551.9 z "/></g></g></svg>';break;case"G":o+='<svg xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" version="1.0" width="15" height="40"><defs/><path d="m 12 3.4 c 0.3 3.1 -2 5.6 -4.1 7.6 -0.9 0.9 -0.2 0.1 -0.6 0.6 -0.1 -0.5 -0.3 -1.7 -0.3 -2.1 0.1 -2.6 2.3 -6.5 4.2 -7.9 0.3 0.6 0.6 0.6 0.8 1.8 z m 0.7 15.9 c -1.2 -0.9 -2.8 -1.1 -4.3 -0.9 -0.2 -1.2 -0.4 -2.5 -0.6 -3.7 2.4 -2.3 4.9 -4.9 5 -8.4 0.1 -2.2 -0.3 -4.6 -1.7 -6.4 C 9.5 0.1 8.3 2.1 7.4 3.3 c -1.5 2.6 -1.1 5.8 -0.6 8.6 -0.8 0.9 -1.9 1.7 -2.7 2.7 -2.4 2.3 -4.4 5.3 -4 8.7 0.2 3.3 2.6 6.3 5.9 7.1 1.2 0.3 2.6 0.3 3.8 0.1 0.2 2.2 1 4.5 0.1 6.7 -0.7 1.6 -2.8 2.9 -4.3 2.2 -0.6 -0.3 -0.1 -0.1 -0.5 -0.2 1.1 -0.3 2 -1 2.3 -1.5 0.8 -1.4 -0.4 -3.6 -2.2 -3.3 -2.3 0 -3.2 3.1 -1.7 4.6 1.3 1.5 3.8 1.3 5.4 0.3 1.8 -1.2 2 -3.5 1.8 -5.5 -0.1 -0.7 -0.4 -2.6 -0.4 -3.3 0.7 -0.2 0.2 -0.1 1.2 -0.4 2.7 -1 4.4 -4.2 3.6 -7 -0.3 -1.4 -1 -2.9 -2.3 -3.7 z m 0.6 5.7 c 0.2 2 -1.1 4.2 -3.1 4.9 -0.1 -0.8 -0.2 -1 -0.3 -1.4 -0.5 -2.4 -0.7 -4.9 -1.1 -7.3 1.6 -0.2 3.5 0.5 4 2.1 0.2 0.6 0.3 1.2 0.4 1.8 z m -5.1 5.1 c -2.5 0.1 -5 -1.6 -5.6 -4 -0.7 -2.1 -0.5 -4.5 0.8 -6.4 1.1 -1.7 2.6 -3 4 -4.5 0.2 1.1 0.4 2.2 0.5 3.3 -3 0.8 -5 4.6 -3.2 7.3 0.5 0.8 2 2.2 2.8 1.6 -1.1 -0.7 -2 -1.8 -1.8 -3.2 -0.1 -1.3 1.4 -2.9 2.7 -3.1 0.4 2.8 0.9 6 1.4 8.8 -0.5 0.1 -1 0.1 -1.5 0.1 z"/></svg>';break;default:throw new Error("Unknown music clef symbol")}var i=new Image;i.onload=function(){var n=t.getBoundingBox().getHeight()/this.height;t.getBoundingBox().setWidth(this.width*n),e.drawImage(i,t.getBoundingBox().getX(),t.getBoundingBox().getY(),t.getBoundingBox().getWidth(),t.getBoundingBox().getHeight())},i.src=o},p=function(t,e,n){throw new Error("not implemented")},u=function(t,e,n){throw new Error("not implemented")},h=function(t,e,n){throw new Error("not implemented")},l=function(t,e,n){throw new Error("not implemented")},g=function(t,e,n){throw new Error("not implemented")},f=function(t,e,n){throw new Error("not implemented")},y=function(t,e,n){throw new Error("not implemented")},d=function(t,e,n){throw new Error("not implemented")},m=function(t,e){if(!e||0===e.length)return t;var n=t.slice(0),o=[];for(var i in e)if(e[i].getErasedInputRanges()){for(var r in e[i].getErasedInputRanges())o.push(e[i].getErasedInputRanges()[r].getComponent());for(var s in e[i].getInputRanges())o.push(e[i].getInputRanges()[s].getComponent())}o.sort(function(t,e){return e-t});for(var a in o)n.splice(o[a],1);return n};t.MusicRenderer=e}(MyScript),function(t){function e(e){t.AbstractRenderer.call(this,e),this.shapeRenderer=new t.ShapeRenderer(e)}e.prototype=new t.AbstractRenderer,e.prototype.constructor=e,e.prototype.getShapeRenderer=function(){return this.shapeRenderer},e.prototype.setShapeRenderer=function(t){this.shapeRenderer=t},e.prototype.drawRecognitionResult=function(t,e){this.clear(),e?(this.shapeRenderer.drawShapes(t,e.getShapes()),n(t,e.getTables(),this.getContext(),this.getParameters()),o(t,e.getTextLines(),this.getContext(),this.getParameters())):this.drawComponents(t)},e.prototype.drawComponents=function(e){for(var n in e){var o=e[n];if(o instanceof t.AbstractShapePrimitive)this.shapeRenderer.drawShapePrimitive(o);else{if(!(o instanceof t.AbstractComponent))throw new Error("not implemented");t.AbstractRenderer.prototype.drawComponent.call(this,o)}}};var n=function(t,e,n,o){for(var i in e)for(var r in e[i].getLines()){var a=e[i].getLines()[r].getData();s(a.getP1(),a.getP2(),n,o)}},o=function(t,e,n,o){for(var s in e){var a=e[s],c=a.getData();if(c){var p=a.getTextDocument().getTextSegment().getSelectedCandidate().getLabel();i(c.getBoundingBox(),p,c.getJustificationType(),c.getTextHeight(),c.getBaselinePos(),n,o);var u=a.getUnderlineList();for(var h in u)r(c.getBoundingBox(),u[h],p,c.getTextHeight(),c.getBaselinePos()+c.getTextHeight()/10,n,o)}}},i=function(t,e,n,o,i,r,s){r.save();try{r.fillStyle=s.getColor(),r.strokeStyle=s.getColor(),r.lineWidth=.5*s.getWidth(),r.font=s.getDecoration()+" "+o+"px "+s.getFont(),r.textAlign="CENTER"===n?"center":"left",r.fillText(e,t.getX(),i)}finally{r.restore()}},r=function(e,n,o,i,r,a,c){var p=e.getTopLeftPoint(),u=n.getData().getFirstCharacter(),h=n.getData().getLastCharacter();a.font=c.getDecoration()+" "+i+"px "+c.getFont();var l=a.measureText(o.substring(0,u)),g=p.x+l.width;l=a.measureText(o.substring(u,h+1));var f=g+l.width;s(new t.Point({x:g,y:r}),new t.Point({x:f,y:r}),a,c)},s=function(t,e,n,o){n.save();try{n.fillStyle=o.getColor(),n.strokeStyle=o.getColor(),n.lineWidth=.5*o.getWidth(),n.beginPath(),n.moveTo(t.getX(),t.getY()),n.lineTo(e.getX(),e.getY()),n.stroke()}finally{n.restore()}};t.AnalyzerRenderer=e}(MyScript),function(t){function e(e){t.AbstractRenderer.call(this,e)}e.prototype=new t.AbstractRenderer,e.prototype.constructor=e,e.prototype.drawComponents=function(e){for(var n in e){var o=e[n];if(!(o instanceof t.AbstractComponent))throw console.log(e),console.log(typeof o),new Error("not implemented");t.AbstractRenderer.prototype.drawComponent.call(this,o)}},t.ImageRenderer=e}(MyScript),function(t){function e(e){t.AbstractRenderer.call(this,e),this.stroke=void 0,this.writing=!1}e.prototype=new t.AbstractRenderer,e.prototype.constructor=e,e.prototype.isWriting=function(){return this.writing},e.prototype.getStroke=function(){return this.stroke},e.prototype.startCapture=function(e,n,o){if(this.writing)throw new Error("StrokeComponent capture already running");this.writing=!0,this.stroke=new t.StrokeComponent,this.stroke.setColor(this.penParameters.getColor()),this.stroke.setWidth(this.penParameters.getWidth()),this.stroke.addPoint(e,n,o),this.clear(),this.drawComponent(this.stroke)},e.prototype.continueCapture=function(t,e,n){if(!this.writing)throw new Error("Missing startInkCapture");this.stroke.addPoint(t,e,n),this.clear(),this.drawComponent(this.stroke)},e.prototype.endCapture=function(t,e,n){if(!this.writing)throw new Error("Missing startInkCapture");this.stroke.addPoint(t,e,n),this.clear(),this.drawComponent(this.stroke),this.writing=!1},t.InkGrabber=e}(MyScript),function(t){function e(e,i,r){this._element=e,this._instanceId=void 0,this._timerId=void 0,this._initialized=!1,this._lastSentComponentIndex=0,this._components=[],this._redoComponents=[],this.isStarted=!1,this.resultCallback=r,this.changeCallback=void 0;var s=n(e,"ms-temp-canvas");if(this.canvasRatio=o(s),e.removeChild(s),this._captureCanvas=n(e,"ms-capture-canvas"),this._inkGrabber=new t.InkGrabber(this._captureCanvas.getContext("2d")),this._renderingCanvas=n(e,"ms-rendering-canvas"),this._textRenderer=new t.TextRenderer(this._renderingCanvas.getContext("2d")),this._mathRenderer=new t.MathRenderer(this._renderingCanvas.getContext("2d")),this._shapeRenderer=new t.ShapeRenderer(this._renderingCanvas.getContext("2d")),this._musicRenderer=new t.MusicRenderer(this._renderingCanvas.getContext("2d")),this._analyzerRenderer=new t.AnalyzerRenderer(this._renderingCanvas.getContext("2d")),this._textRecognizer=new t.TextRecognizer,this._mathRecognizer=new t.MathRecognizer,this._shapeRecognizer=new t.ShapeRecognizer,this._musicRecognizer=new t.MusicRecognizer,this._analyzerRecognizer=new t.AnalyzerRecognizer,this._textWSRecognizer=new t.TextWSRecognizer(this._handleMessage.bind(this)),this._mathWSRecognizer=new t.MathWSRecognizer(this._handleMessage.bind(this)),this._attachListeners(e),this.options={type:t.RecognitionType.TEXT,protocol:t.Protocol.REST,ssl:!0,width:400,height:300,timeout:2e3,typeset:!1,components:[],textParameters:new t.TextParameter,mathParameters:new t.MathParameter,shapeParameters:new t.ShapeParameter,musicParameters:new t.MusicParameter,analyzerParameters:new t.AnalyzerParameter},i)for(var a in i)void 0!==i[a]&&(this.options[a]=i[a]);this.setType(this.options.type),this.setHost(this.options.host),this.setSSL(this.options.ssl),this.setTextParameters(this.options.textParameters),this.setMathParameters(this.options.mathParameters),this.setShapeParameters(this.options.shapeParameters),this.setMusicParameters(this.options.musicParameters),this.setAnalyzerParameters(this.options.analyzerParameters),this.setProtocol(this.options.protocol),this.setTimeout(this.options.timeout),this.setApplicationKey(this.options.applicationKey),this.setHmacKey(this.options.hmacKey),this.setPenParameters(this.options.penParameters),this.setPrecision(this.options.precision),this.setTypeset(this.options.typeset),this.setComponents(this.options.components),this.setWidth(this.options.width),this.setHeight(this.options.height)}function n(t,e){var n=document.querySelectorAll("canvas[id^="+e+"]").length,o=document.createElement("canvas");return o.id=e+"-"+n,t.appendChild(o),o}function o(t){if(t){var e=t.getContext("2d"),n=window.devicePixelRatio||1,o=e.webkitBackingStorePixelRatio||e.mozBackingStorePixelRatio||e.msBackingStorePixelRatio||e.oBackingStorePixelRatio||e.backingStorePixelRatio||1;return n/o}return 1}function i(t,e){t.changedTouches&&(t=t.changedTouches[0]);var n=e.getBoundingClientRect();return{x:t.clientX-n.left-e.clientLeft,y:t.clientY-n.top-e.clientTop,t:t.timeStamp}}e.prototype.setWidth=function(t){t>0&&(this._captureCanvas.width=t*this.canvasRatio,this._captureCanvas.style.width=t+"px",this._captureCanvas.getContext("2d").scale(this.canvasRatio,this.canvasRatio),this._renderingCanvas.width=t*this.canvasRatio,this._renderingCanvas.style.width=t+"px",this._renderingCanvas.getContext("2d").scale(this.canvasRatio,this.canvasRatio)),this._initRenderingCanvas()},e.prototype.setHeight=function(t){t>0&&(this._captureCanvas.height=t*this.canvasRatio,this._captureCanvas.style.height=t+"px",this._captureCanvas.getContext("2d").scale(this.canvasRatio,this.canvasRatio),this._renderingCanvas.height=t*this.canvasRatio,this._renderingCanvas.style.height=t+"px",this._renderingCanvas.getContext("2d").scale(this.canvasRatio,this.canvasRatio)),this._initRenderingCanvas()},e.prototype.setProtocol=function(e){switch(e){case t.Protocol.REST:this._selectedRecognizer=this._selectedRESTRecognizer;break;case t.Protocol.WS:this.setTimeout(-1),this._selectedRecognizer=this._selectedWSRecognizer;break;default:throw new Error("Unknown protocol: "+e)}this._instanceId=void 0,this._initialized=!1,this._lastSentComponentIndex=0},e.prototype.getProtocol=function(){return this._selectedRecognizer instanceof t.AbstractWSRecognizer?t.Protocol.WS:t.Protocol.REST},e.prototype.setType=function(e){switch(e){case t.RecognitionType.TEXT:this._selectedRenderer=this._textRenderer,this._selectedRESTRecognizer=this._textRecognizer,this._selectedWSRecognizer=this._textWSRecognizer;break;case t.RecognitionType.MATH:this._selectedRenderer=this._mathRenderer,this._selectedRESTRecognizer=this._mathRecognizer,this._selectedWSRecognizer=this._mathWSRecognizer;break;case t.RecognitionType.SHAPE:this._selectedRenderer=this._shapeRenderer,this._selectedRESTRecognizer=this._shapeRecognizer;break;case t.RecognitionType.MUSIC:this._selectedRenderer=this._musicRenderer,this._selectedRESTRecognizer=this._musicRecognizer;break;case t.RecognitionType.ANALYZER:this._selectedRenderer=this._analyzerRenderer,this._selectedRESTRecognizer=this._analyzerRecognizer;break;default:throw new Error("Unknown type: "+e)}this._instanceId=void 0,this._initialized=!1,this._lastSentComponentIndex=0},e.prototype.getType=function(){if(this._selectedRenderer instanceof t.TextRenderer)return t.RecognitionType.TEXT;if(this._selectedRenderer instanceof t.MathRenderer)return t.RecognitionType.MATH;if(this._selectedRenderer instanceof t.ShapeRenderer)return t.RecognitionType.SHAPE;if(this._selectedRenderer instanceof t.MusicRenderer)return t.RecognitionType.MUSIC;if(this._selectedRenderer instanceof t.AnalyzerRenderer)return t.RecognitionType.ANALYZER;throw new Error("Unknown type")},e.prototype.getTimeout=function(){return this.timeout},e.prototype.setTimeout=function(t){this.timeout=t},e.prototype.setPrecision=function(t){this._textRecognizer.setPrecision(t),this._textWSRecognizer.setPrecision(t),this._mathRecognizer.setPrecision(t),this._mathWSRecognizer.setPrecision(t),this._shapeRecognizer.setPrecision(t),this._musicRecognizer.setPrecision(t),this._analyzerRecognizer.setPrecision(t)},e.prototype.getComponents=function(){return this.options.components},e.prototype.setComponents=function(t){this.options.components=t,this._initRenderingCanvas()},e.prototype.getApplicationKey=function(){return this.applicationKey},e.prototype.setApplicationKey=function(t){this.applicationKey=t},e.prototype.getHmacKey=function(){return this.hmacKey},e.prototype.setHmacKey=function(t){this.hmacKey=t},e.prototype.setTextParameters=function(e){if(e){this._selectedRecognizer instanceof t.AbstractWSRecognizer&&(this.isStarted=!1,this._selectedRecognizer.resetWSRecognition());for(var n in e)void 0!==e[n]&&(this._textRecognizer.getParameters()[n]=e[n],this._textWSRecognizer.getParameters()[n]=e[n],this._analyzerRecognizer.getParameters().getTextParameters()[n]=e[n])}},e.prototype.getTextParameters=function(){return this._textRecognizer.getParameters()},e.prototype.setMathParameters=function(e){if(e){this._selectedRecognizer instanceof t.AbstractWSRecognizer&&(this.isStarted=!1,this._selectedRecognizer.resetWSRecognition());for(var n in e)void 0!==e[n]&&(this._mathRecognizer.getParameters()[n]=e[n],this._mathWSRecognizer.getParameters()[n]=e[n])}},e.prototype.getMathParameters=function(){return this._mathRecognizer.getParameters()},e.prototype.setShapeParameters=function(e){if(e){this._selectedRecognizer instanceof t.AbstractWSRecognizer&&(this.isStarted=!1,this._selectedRecognizer.resetWSRecognition());for(var n in e)void 0!==e[n]&&(this._shapeRecognizer.getParameters()[n]=e[n])}},e.prototype.getShapeParameters=function(){return this._shapeRecognizer.getParameters()},e.prototype.setMusicParameters=function(e){if(e){this._selectedRecognizer instanceof t.AbstractWSRecognizer&&(this.isStarted=!1,this._selectedRecognizer.resetWSRecognition());for(var n in e)void 0!==e[n]&&(this._musicRecognizer.getParameters()[n]=e[n]);this._initRenderingCanvas()}},e.prototype.getMusicParameters=function(){return this._musicRecognizer.getParameters()},e.prototype.setAnalyzerParameters=function(e){if(e){this._selectedRecognizer instanceof t.AbstractWSRecognizer&&(this.isStarted=!1,this._selectedRecognizer.resetWSRecognition());for(var n in e)void 0!==e[n]&&(this._analyzerRecognizer.getParameters()[n]=e[n])}},e.prototype.getAnalyzerParameters=function(){return this._analyzerRecognizer.getParameters()},e.prototype.setPenParameters=function(t){if(t){for(var e in t)void 0!==t[e]&&(this._selectedRenderer.getParameters()[e]=t[e]);var n=this._selectedRenderer.getParameters();this._inkGrabber.setParameters(n),this._textRenderer.setParameters(n),this._mathRenderer.setParameters(n),this._shapeRenderer.setParameters(n),this._musicRenderer.setParameters(n),this._analyzerRenderer.setParameters(n)}},e.prototype.getPenParameters=function(){return this._selectedRenderer.getParameters()},e.prototype.setTypeset=function(t){this._textRenderer.setTypeset(t),this._mathRenderer.setTypeset(t),this._shapeRenderer.setTypeset(t),this._musicRenderer.setTypeset(t),this._analyzerRenderer.setTypeset(t)},e.prototype.getAvailableLanguages=function(t){this._selectedRESTRecognizer.getAvailableLanguageList(this.getApplicationKey(),t?t:this._textRecognizer.getParameters().getInputMode()).then(function(t){this._onResult(t)}.bind(this),function(t){this._onResult(void 0,t)}.bind(this))},e.prototype.getRenderer=function(){return this._selectedRenderer},e.prototype.getInkGrabber=function(){return this._inkGrabber},e.prototype.getRecognizer=function(){return this._selectedRecognizer},e.prototype.setChangeCallback=function(t){this.changeCallback=t},e.prototype.setResultCallback=function(t){this.resultCallback=t},e.prototype.recognize=function(){var e=this.getComponents().concat(this._components);if(this._selectedRecognizer instanceof t.AbstractWSRecognizer){if(this._initialized){var n=e.slice(this._lastSentComponentIndex);n.length>0?(this._lastSentComponentIndex=e.length,this.isStarted?this._selectedRecognizer.continueWSRecognition(n,this._instanceId):(this.isStarted=!0,this._selectedRecognizer.startWSRecognition(n))):this._renderResult()}}else this._selectedRecognizer instanceof t.ShapeRecognizer&&(this._instanceId=void 0),e.length>0?this.isStarted?this._continueRESTRecognition(e,this._instanceId):this._startRESTRecognition(e):this._renderResult()},e.prototype._startRESTRecognition=function(t){this._instanceId=void 0,this._selectedRecognizer.doSimpleRecognition(this.getApplicationKey(),this._instanceId,t,this.getHmacKey()).then(function(e){this.isStarted||(this.isStarted=!0,this._lastSentComponentIndex=t.length,this._instanceId=e.getInstanceId(),this._renderResult(e))}.bind(this),function(t){this._onResult(void 0,t)}.bind(this))},e.prototype._continueRESTRecognition=function(t,e){this._selectedRecognizer.doSimpleRecognition(this.getApplicationKey(),e,t,this.getHmacKey()).then(function(e){this._lastSentComponentIndex=this._lastSentComponentIndex+t.length,this._renderResult(e)}.bind(this),function(t){this._onResult(void 0,t)}.bind(this))},e.prototype._clearRESTRecognition=function(e){this._selectedRecognizer instanceof t.ShapeRecognizer?(this.isStarted=!1,this._lastSentComponentIndex=0,this._selectedRecognizer.clearShapeRecognitionSession(this.getApplicationKey(),e).then(function(t){this._instanceId=void 0,this._onResult(t)}.bind(this),function(t){this._onResult(void 0,t)}.bind(this))):this._onResult()},e.prototype.canUndo=function(){return this._components.length>0},e.prototype.undo=function(){this.canUndo()&&(this._components.forEach(function(t){t.scratchedStroke=!1}),this.updatedModel=void 0,this._redoComponents.push(this._components.pop()),this._clearRESTRecognition(this._instanceId),this._initRenderingCanvas(),this._onChange(),this.isStarted=!1,this._selectedRecognizer instanceof t.AbstractWSRecognizer?this._selectedRecognizer.resetWSRecognition():(clearTimeout(this._timerId),this.getTimeout()>-1?this._timerId=setTimeout(this.recognize.bind(this),this.getTimeout()):this._onResult()))},e.prototype.canRedo=function(){return this._redoComponents.length>0},e.prototype.redo=function(){this.canRedo()&&(this._components.push(this._redoComponents.pop()),this._clearRESTRecognition(this._instanceId),this._initRenderingCanvas(),this._onChange(),this._selectedRecognizer instanceof t.AbstractWSRecognizer?this.recognize():(clearTimeout(this._timerId),this.isStarted=!1,this.getTimeout()>-1?this._timerId=setTimeout(this.recognize.bind(this),this.getTimeout()):this._onResult()))},e.prototype.clear=function(){this._components=[],this._redoComponents=[],this._clearRESTRecognition(this._instanceId),this._initRenderingCanvas(),this._onChange(),this._selectedRecognizer instanceof t.AbstractWSRecognizer?(this.isStarted=!1,this._selectedRecognizer.resetWSRecognition()):this._selectedRecognizer instanceof t.MusicRecognizer?(clearTimeout(this._timerId),this._onResult()):(clearTimeout(this._timerId),this.getTimeout()>-1?this._timerId=setTimeout(this.recognize.bind(this),this.getTimeout()):this._onResult())},e.event={addDomListener:function(t,e,n){t.addEventListener(e,n)}},e.prototype._down=function(t,e,n){clearTimeout(this._timerId);var o=!1;this._captureCanvas.clientHeight*this.canvasRatio!==this._captureCanvas.height&&(this._captureCanvas.height=this._captureCanvas.clientHeight*this.canvasRatio,this._renderingCanvas.height=this._renderingCanvas.clientHeight*this.canvasRatio,o=!0),this._captureCanvas.clientWidth*this.canvasRatio!==this._captureCanvas.width&&(this._captureCanvas.width=this._captureCanvas.clientWidth*this.canvasRatio,this._renderingCanvas.width=this._renderingCanvas.clientWidth*this.canvasRatio,o=!0),o&&(this._captureCanvas.getContext("2d").scale(this.canvasRatio,this.canvasRatio),this._renderingCanvas.getContext("2d").scale(this.canvasRatio,this.canvasRatio),this._initRenderingCanvas()),this.canRedo()&&(this._redoComponents=[],this._onChange()),this._inkGrabber.startCapture(t,e,n)},e.prototype._move=function(t,e,n){this._inkGrabber.continueCapture(t,e,n)},e.prototype._up=function(e,n,o){this._inkGrabber.endCapture(e,n,o);var i=this._inkGrabber.getStroke();this._inkGrabber.clear(),this._selectedRenderer.drawComponent(i),this._components.push(i),this._onChange(),this._selectedRecognizer instanceof t.AbstractWSRecognizer?this._selectedRecognizer.isOpen()||this._selectedRecognizer.isConnecting()?this.recognize():this._selectedRecognizer.open():(clearTimeout(this._timerId),this.getTimeout()>-1&&(this._timerId=setTimeout(this.recognize.bind(this),this.getTimeout())))},e.prototype._onResult=function(t,e){this.resultCallback&&this.resultCallback(t,e),e?this._element.dispatchEvent(new CustomEvent("error",{detail:e})):this._element.dispatchEvent(new CustomEvent("success",{detail:t}))},e.prototype._onChange=function(){var t={canUndo:this.canUndo(),undoLength:this._components.length,canRedo:this.canRedo(),redoLength:this._redoComponents.length};this.changeCallback&&this.changeCallback(t),this._element.dispatchEvent(new CustomEvent("changed",{detail:t}))},e.prototype._renderResult=function(e){return this.updatedModel=this._selectedRenderer.drawRecognitionResult(this.getComponents().concat(this._components),e?e.getDocument():void 0),this._selectedRecognizer instanceof t.MusicRecognizer&&this._selectedRecognizer.getParameters().getStaff()instanceof t.MusicStaff&&this._selectedRenderer.drawStaff(this._selectedRecognizer.getParameters().getStaff()),this._onResult(e),e},e.prototype.setHost=function(t){this._textRecognizer.setHost(t),this._textWSRecognizer.setHost(t),this._mathRecognizer.setHost(t),this._mathWSRecognizer.setHost(t),this._shapeRecognizer.setHost(t),this._musicRecognizer.setHost(t),this._analyzerRecognizer.setHost(t)},e.prototype.setSSL=function(t){this._textRecognizer.setSSL(t),this._textWSRecognizer.setSSL(t),this._mathRecognizer.setSSL(t),this._mathWSRecognizer.setSSL(t),this._shapeRecognizer.setSSL(t),this._musicRecognizer.setSSL(t),this._analyzerRecognizer.setSSL(t)},e.prototype._attachListeners=function(t){var e,n=this;t.addEventListener("contextmenu",function(t){return t.preventDefault(),t.stopPropagation(),!1}),t.addEventListener("pointerdown",function(o){if(!e){e=o.pointerId,o.preventDefault();var r=i(o,t);n._down(r.x,r.y,r.t)}},!1),t.addEventListener("pointermove",function(o){if(e===o.pointerId){o.preventDefault();var r=i(o,t);n._move(r.x,r.y,r.t)}},!1),t.addEventListener("pointerup",function(o){if(e===o.pointerId){o.preventDefault();var r=i(o,t);n._up(r.x,r.y,r.t),e=void 0}},!1),t.addEventListener("pointerleave",function(t){if(e===t.pointerId){t.preventDefault();var o=n._inkGrabber.getStroke().getPointByIndex(n._inkGrabber.getStroke().getLastIndexPoint());n._up(o.x,o.y,o.t),e=void 0}},!1),t.addEventListener("pointerout",function(t){if(e===t.pointerId){t.preventDefault();var o=n._inkGrabber.getStroke().getPointByIndex(n._inkGrabber.getStroke().getLastIndexPoint());n._up(o.x,o.y,o.t),e=void 0}},!1)},e.prototype._initRenderingCanvas=function(){this._selectedRenderer.clear(),this._selectedRecognizer instanceof t.MusicRecognizer&&this._selectedRecognizer.getParameters().getStaff()instanceof t.MusicStaff&&this._selectedRenderer.drawStaff(this._selectedRecognizer.getParameters().getStaff()),this._selectedRecognizer instanceof t.ShapeRecognizer&&this.updatedModel?this._selectedRenderer.drawRecognitionResult(this.updatedModel.components,this.updatedModel.document):this._selectedRenderer.drawComponents(this.getComponents().concat(this._components));
},e.prototype._handleMessage=function(t,e){var n=!1;if(e&&(n=!0,this._instanceId=void 0,this.isStarted=!1,this._lastSentComponentIndex=0,this._onResult(void 0,e)),t)switch(t.type){case"open":this._selectedWSRecognizer.initWSRecognition(this.getApplicationKey());break;case"hmacChallenge":this._selectedWSRecognizer.takeUpHmacChallenge(this.getApplicationKey(),t.getChallenge(),this.getHmacKey());break;case"init":this.isStarted=!1,this._initialized=!0,this._instanceId=void 0,this._lastSentComponentIndex=0,this.recognize();break;case"reset":this.isStarted=!1,this._instanceId=void 0,this._lastSentComponentIndex=0,this.recognize();break;case"close":this._initialized=!1,this._instanceId=void 0,this._lastSentComponentIndex=0;break;default:this.isStarted=!0,this._instanceId||(this._instanceId=t.getInstanceId()),this._renderResult(t)}return n},e.prototype.getStats=function(){var t={strokesCount:0,pointsCount:0,byteSize:0,humanSize:0,humanUnit:"BYTE"};if(this._components){t.strokesCount=this._components.length;for(var e=0,n=0;n<this._components.length;n++)e+=this._components[n].x.length;t.strokesCount=this._components.length,t.pointsCount=e;var o=270;o=JSON.stringify(this._components).length,t.byteSize=o,270>o?(t.humanUnit="BYTE",t.byteSize=0,t.humanSize=0):2048>o?(t.humanUnit="BYTES",t.humanSize=o):1048576>o?(t.humanUnit="KiB",t.humanSize=(o/1024).toFixed(2)):(t.humanUnit="MiB",t.humanSize=(o/1024/1024).toFixed(2))}return t},e.prototype.getInkAsImageData=function(e,n){var o=[];if(this._components.forEach(function(t){t.scratchedStroke!==!0&&o.push(t)}),e||(e=10),n||(n=10),o&&o.length>0){for(var i=(o.length,o[0].x[0]),r=o[0].x[0],s=o[0].y[0],a=o[0].y[0],c=0;c<o.length;c++)for(var p=o[c].x.length,u=0;p>u;u++){var h=o[c].x[u],l=o[c].y[u];i>h&&(i=h),h>r&&(r=h),s>l&&(s=l),l>a&&(a=l)}var g=document.createElement("canvas");g.width=r+2*e,g.height=a+2*n;var f=g.getContext("2d"),y=new t.ImageRenderer(f);return y.drawComponents(o,f),f.getImageData(i-e,s-n,r-i+2*e,a-s+2*n)}},e.prototype.getInkAsPng=function(t,e){var n=document.createElement("canvas");n.style.display="none";var o=this.getInkAsImageData();n.width=o.width,n.style.width=o.width+"px",n.height=o.height,n.style.height=o.height+"px";var i=n.getContext("2d");return i.putImageData(o,0,0),n.toDataURL("image/png")},t.InkPaper=e}(MyScript);
//# sourceMappingURL=myscript.min.js.map
