/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.requesthandlers;

import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.jstestdriver.requesthandlers.RequestDispatcher;
import com.google.jstestdriver.requesthandlers.RequestScope;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestHandlerServlet
extends HttpServlet {
    private static final long serialVersionUID = -186242854065156745L;
    private static ThreadLocal<Context> localContext = new ThreadLocal();
    private final RequestScope requestScope;
    private final Provider<RequestDispatcher> dispatcherProvider;

    @Inject
    public RequestHandlerServlet(RequestScope requestScope, Provider<RequestDispatcher> dispatcherProvider) {
        this.requestScope = requestScope;
        this.dispatcherProvider = dispatcherProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        localContext.set(new Context(request, response));
        this.requestScope.enter();
        try {
            this.requestScope.seed(HttpServletRequest.class, request);
            this.requestScope.seed(HttpServletResponse.class, response);
            this.dispatcherProvider.get().dispatch();
        }
        finally {
            localContext.remove();
            this.requestScope.exit();
        }
    }

    static HttpServletRequest getRequest() {
        return RequestHandlerServlet.getContext().request;
    }

    static HttpServletResponse getResponse() {
        return RequestHandlerServlet.getContext().response;
    }

    private static Context getContext() {
        Context context = localContext.get();
        if (context == null) {
            throw new OutOfScopeException("Cannot access scoped object.");
        }
        return context;
    }

    private static class Context {
        HttpServletRequest request;
        HttpServletResponse response;

        public Context(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }
    }
}

