/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.servlet.fileset;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.model.JstdTestCaseDelta;
import com.google.jstestdriver.server.JstdTestCaseStore;
import com.google.jstestdriver.servlet.fileset.FileSetRequestHandler;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaUpload
implements FileSetRequestHandler<String> {
    public static final String ACTION = "deltaUpdate";
    private final JstdTestCaseStore store;
    private final Gson gson;

    @Inject
    public DeltaUpload(JstdTestCaseStore store, Gson gson) {
        this.store = store;
        this.gson = gson;
    }

    @Override
    public String handle(SlaveBrowser browser, String data) {
        Collection<JstdTestCaseDelta> deltas = this.deserialize(data);
        for (JstdTestCaseDelta delta : deltas) {
            this.store.applyDelta(delta);
        }
        return "{\"ok\":1}";
    }

    private Collection<JstdTestCaseDelta> deserialize(String data) {
        return (Collection)this.gson.fromJson(data, new TypeToken<Collection<JstdTestCaseDelta>>(){}.getType());
    }

    @Override
    public boolean canHandle(String action) {
        return ACTION.equals(action);
    }
}

