// Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
//
// You are hereby granted a non-exclusive, worldwide, royalty-free license to use,
// copy, modify, and distribute this software in source code or binary form for use
// in connection with the web services and APIs provided by Facebook.
//
// As with any software that integrates with the Facebook platform, your use of
// this software is subject to the Facebook Developer Principles and Policies
// [http://developers.facebook.com/policy/]. This copyright notice shall be
// included in all copies or substantial portions of the software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
// FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
// COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#import "FBSDKShareMessengerOpenGraphMusicTemplateContent.h"

#ifdef FBSDKCOCOAPODS
#import <FBSDKCoreKit/FBSDKCoreKit+Internal.h>
#else
#import "FBSDKCoreKit+Internal.h"
#endif
#import "FBSDKShareMessengerContentUtility.h"
#import "FBSDKShareUtility.h"

static NSString *const kMusicTemplatePageIDKey = @"pageID";
static NSString *const kMusicTemplateURLKey = @"url";
static NSString *const kMusicTemplateButtonKey = @"button";
static NSString *const kMusicTemplateUUIDKey = @"uuid";

DEPRECATED_FOR_MESSENGER
static NSArray<NSDictionary<NSString *, id> *> *_SerializableOpenGraphMusicTemplateContentFromContent(FBSDKShareMessengerOpenGraphMusicTemplateContent *openGraphMusicTemplateContent)
{
  NSMutableArray<NSDictionary<NSString *, id> *> *serializableOpenGraphMusicTemplateContent = [NSMutableArray array];

  NSMutableDictionary<NSString *, id> *openGraphMusicTemplateContentDictionary = [NSMutableDictionary dictionary];
  [FBSDKBasicUtility dictionary:openGraphMusicTemplateContentDictionary setObject:openGraphMusicTemplateContent.url.absoluteString forKey:@"url"];
  [FBSDKBasicUtility dictionary:openGraphMusicTemplateContentDictionary setObject:SerializableButtonsFromButton(openGraphMusicTemplateContent.button) forKey:kFBSDKShareMessengerButtonsKey];
  [serializableOpenGraphMusicTemplateContent addObject:openGraphMusicTemplateContentDictionary];

  return serializableOpenGraphMusicTemplateContent;
}


#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-implementations"
@implementation FBSDKShareMessengerOpenGraphMusicTemplateContent
#pragma clang diagnostic pop

#pragma mark - Properties

@synthesize contentURL = _contentURL;
@synthesize hashtag = _hashtag;
@synthesize peopleIDs = _peopleIDs;
@synthesize placeID = _placeID;
@synthesize ref = _ref;
@synthesize pageID = _pageID;
@synthesize shareUUID = _shareUUID;

#pragma mark - Initializer

- (instancetype)init
{
  self = [super init];
  if (self) {
    _shareUUID = [NSUUID UUID].UUIDString;
  }
  return self;
}

#pragma mark - FBSDKSharingContent

- (NSDictionary<NSString *, id> *)addParameters:(NSDictionary<NSString *, id> *)existingParameters
                                  bridgeOptions:(FBSDKShareBridgeOptions)bridgeOptions
{
  NSMutableDictionary<NSString *, id> *updatedParameters = [NSMutableDictionary dictionaryWithDictionary:existingParameters];

  NSMutableDictionary<NSString *, id> *payload = [NSMutableDictionary dictionary];
  payload[kFBSDKShareMessengerTemplateTypeKey] = @"open_graph";
  payload[kFBSDKShareMessengerElementsKey] = _SerializableOpenGraphMusicTemplateContentFromContent(self);

  NSMutableDictionary<NSString *, id> *attachment = [NSMutableDictionary dictionary];
  attachment[kFBSDKShareMessengerTypeKey] = kFBSDKShareMessengerTemplateKey;
  attachment[kFBSDKShareMessengerPayloadKey] = payload;

  NSMutableDictionary<NSString *, id> *contentForShare = [NSMutableDictionary dictionary];
  contentForShare[kFBSDKShareMessengerAttachmentKey] = attachment;

  NSMutableDictionary<NSString *, id> *contentForPreview = [NSMutableDictionary dictionary];
  [FBSDKBasicUtility dictionary:contentForPreview setObject:@"OPEN_GRAPH" forKey:@"preview_type"];
  [FBSDKBasicUtility dictionary:contentForPreview setObject:_url.absoluteString forKey:@"open_graph_url"];
  AddToContentPreviewDictionaryForButton(contentForPreview, _button);

  [FBSDKShareMessengerContentUtility addToParameters:updatedParameters contentForShare:contentForShare contentForPreview:contentForPreview];

  return updatedParameters;
}

#pragma mark - FBSDKSharingValidation

- (BOOL)validateWithOptions:(FBSDKShareBridgeOptions)bridgeOptions error:(NSError *__autoreleasing *)errorRef
{
  return [FBSDKShareUtility validateRequiredValue:_url name:@"url" error:errorRef]
      && [FBSDKShareUtility validateRequiredValue:_pageID name:@"pageID" error:errorRef]
      && [FBSDKShareMessengerContentUtility validateMessengerActionButton:_button
                                                    isDefaultActionButton:NO
                                                                   pageID:_pageID
                                                                    error:errorRef];
}

#pragma mark - NSCoding

+ (BOOL)supportsSecureCoding
{
  return YES;
}

- (instancetype)initWithCoder:(NSCoder *)decoder
{
  if ((self = [self init])) {
    _pageID = [decoder decodeObjectOfClass:[NSString class] forKey:kMusicTemplatePageIDKey];
    _url = [decoder decodeObjectOfClass:[NSURL class] forKey:kMusicTemplateURLKey];
    _button = [decoder decodeObjectForKey:kMusicTemplateButtonKey];
    _shareUUID = [decoder decodeObjectOfClass:[NSString class] forKey:kMusicTemplateUUIDKey];
  }
  return self;
}

- (void)encodeWithCoder:(NSCoder *)encoder
{
  [encoder encodeObject:_pageID forKey:kMusicTemplatePageIDKey];
  [encoder encodeObject:_url forKey:kMusicTemplateURLKey];
  [encoder encodeObject:_button forKey:kMusicTemplateButtonKey];
  [encoder encodeObject:_shareUUID forKey:kMusicTemplateUUIDKey];
}

#pragma mark - NSCopying

- (id)copyWithZone:(NSZone *)zone
{
  FBSDKShareMessengerOpenGraphMusicTemplateContent *copy = [[FBSDKShareMessengerOpenGraphMusicTemplateContent alloc] init];
  copy->_pageID = [_pageID copy];
  copy->_url = [_url copy];
  copy->_button = [_button copy];
  copy->_shareUUID = [_shareUUID copy];
  return copy;
}

@end
