open class SVGConstants {

    public static let valueToColor = [
        0x000000: "black",
        0x000080: "navy",
        0x00008b: "darkblue",
        0x0000cd: "mediumblue",
        0x0000ff: "blue",
        0x006400: "darkgreen",
        0x008000: "green",
        0x008080: "teal",
        0x008b8b: "darkcyan",
        0x00bfff: "deepskyblue",
        0x00ced1: "darkturquoise",
        0x00fa9a: "mediumspringgreen",
        0x00ff00: "lime",
        0x00ff7f: "springgreen",
        0x00ffff: "cyan",
        0x191970: "midnightblue",
        0x1e90ff: "dodgerblue",
        0x20b2aa: "lightseagreen",
        0x228b22: "forestgreen",
        0x2e8b57: "seagreen",
        0x2f4f4f: "darkslategray",
        0x32cd32: "limegreen",
        0x3cb371: "mediumseagreen",
        0x40e0d0: "turquoise",
        0x4169e1: "royalblue",
        0x4682b4: "steelblue",
        0x483d8b: "darkslateblue",
        0x48d1cc: "mediumturquoise",
        0x4b0082: "indigo",
        0x556b2f: "darkolivegreen",
        0x5f9ea0: "cadetblue",
        0x6495ed: "cornflowerblue",
        0x663399: "rebeccapurple",
        0x66cdaa: "mediumaquamarine",
        0x696969: "dimgray",
        0x6a5acd: "slateblue",
        0x6b8e23: "olivedrab",
        0x708090: "slategray",
        0x778899: "lightslategray",
        0x7b68ee: "mediumslateblue",
        0x7cfc00: "lawngreen",
        0x7fff00: "chartreuse",
        0x7fffd4: "aquamarine",
        0x800000: "maroon",
        0x800080: "purple",
        0x808000: "olive",
        0x808080: "gray",
        0x87ceeb: "skyblue",
        0x87cefa: "lightskyblue",
        0x8a2be2: "blueviolet",
        0x8b0000: "darkred",
        0x8b008b: "darkmagenta",
        0x8b4513: "saddlebrown",
        0x8fbc8f: "darkseagreen",
        0x90ee90: "lightgreen",
        0x9370db: "mediumpurple",
        0x9400d3: "darkviolet",
        0x98fb98: "palegreen",
        0x9932cc: "darkorchid",
        0x9acd32: "yellowgreen",
        0xa0522d: "sienna",
        0xa52a2a: "brown",
        0xa9a9a9: "darkgray",
        0xadd8e6: "lightblue",
        0xadff2f: "greenyellow",
        0xafeeee: "paleturquoise",
        0xb0c4de: "lightsteelblue",
        0xb0e0e6: "powderblue",
        0xb22222: "firebrick",
        0xb8860b: "darkgoldenrod",
        0xba55d3: "mediumorchid",
        0xbc8f8f: "rosybrown",
        0xbdb76b: "darkkhaki",
        0xc0c0c0: "silver",
        0xc71585: "mediumvioletred",
        0xcd5c5c: "indianred",
        0xcd853f: "peru",
        0xd2691e: "chocolate",
        0xd2b48c: "tan",
        0xd3d3d3: "lightgray",
        0xd8bfd8: "thistle",
        0xda70d6: "orchid",
        0xdaa520: "goldenrod",
        0xdb7093: "palevioletred",
        0xdc143c: "crimson",
        0xdcdcdc: "gainsboro",
        0xdda0dd: "plum",
        0xdeb887: "burlywood",
        0xe0ffff: "lightcyan",
        0xe6e6fa: "lavender",
        0xe9967a: "darksalmon",
        0xee82ee: "violet",
        0xeee8aa: "palegoldenrod",
        0xf08080: "lightcoral",
        0xf0e68c: "khaki",
        0xf0fff0: "honeydew",
        0xf0ffff: "azure",
        0xf4a460: "sandybrown",
        0xf5deb3: "wheat",
        0xf5f5dc: "beige",
        0xf5f5f5: "whitesmoke",
        0xf5fffa: "mintcream",
        0xf8f8ff: "ghostwhite",
        0xfa8072: "salmon",
        0xfaebd7: "antiquewhite",
        0xfaf0e6: "linen",
        0xfafad2: "lightgoldenrodyellow",
        0xfdf5e6: "oldlace",
        0xff0000: "red",
        0xff00ff: "magenta",
        0xff1493: "deeppink",
        0xff4500: "orangered",
        0xff6347: "tomato",
        0xff69b4: "hotpink",
        0xff7f50: "coral",
        0xff8c00: "darkorange",
        0xffa07a: "lightsalmon",
        0xffa500: "orange",
        0xffb6c1: "lightpink",
        0xffc0cb: "pink",
        0xffd700: "gold",
        0xffdab9: "peachpuff",
        0xffdead: "navajowhite",
        0xffe4b5: "moccasin",
        0xffe4c4: "bisque",
        0xffe4e1: "mistyrose",
        0xffebcd: "blanchedalmond",
        0xffefd5: "papayawhip",
        0xfff0f5: "lavenderblush",
        0xfff5ee: "seashell",
        0xfff8dc: "cornsilk",
        0xfffacd: "lemonchiffon",
        0xfffaf0: "floralwhite",
        0xfffafa: "snow",
        0xffff00: "yellow",
        0xffffe0: "lightyellow",
        0xfffff0: "ivory",
        0xffffff: "white",
        0xf0f8ff: "aliceblue"
    ]

    public static let colorList = [
        "aliceblue": 0xf0f8ff,
        "antiquewhite": 0xfaebd7,
        "aqua": 0x00ffff,
        "aquamarine": 0x7fffd4,
        "azure": 0xf0ffff,
        "beige": 0xf5f5dc,
        "bisque": 0xffe4c4,
        "black": 0x000000,
        "blanchedalmond": 0xffebcd,
        "blue": 0x0000ff,
        "blueviolet": 0x8a2be2,
        "brown": 0xa52a2a,
        "burlywood": 0xdeb887,
        "cadetblue": 0x5f9ea0,
        "chartreuse": 0x7fff00,
        "chocolate": 0xd2691e,
        "coral": 0xff7f50,
        "cornflowerblue": 0x6495ed,
        "cornsilk": 0xfff8dc,
        "crimson": 0xdc143c,
        "cyan": 0x00ffff,
        "darkblue": 0x00008b,
        "darkcyan": 0x008b8b,
        "darkgoldenrod": 0xb8860b,
        "darkgray": 0xa9a9a9,
        "darkgreen": 0x006400,
        "darkgrey": 0xa9a9a9,
        "darkkhaki": 0xbdb76b,
        "darkmagenta": 0x8b008b,
        "darkolivegreen": 0x556b2f,
        "darkorange": 0xff8c00,
        "darkorchid": 0x9932cc,
        "darkred": 0x8b0000,
        "darksalmon": 0xe9967a,
        "darkseagreen": 0x8fbc8f,
        "darkslateblue": 0x483d8b,
        "darkslategray": 0x2f4f4f,
        "darkslategrey": 0x2f4f4f,
        "darkturquoise": 0x00ced1,
        "darkviolet": 0x9400d3,
        "deeppink": 0xff1493,
        "deepskyblue": 0x00bfff,
        "dimgray": 0x696969,
        "dimgrey": 0x696969,
        "dodgerblue": 0x1e90ff,
        "firebrick": 0xb22222,
        "floralwhite": 0xfffaf0,
        "forestgreen": 0x228b22,
        "fuchsia": 0xff00ff,
        "gainsboro": 0xdcdcdc,
        "ghostwhite": 0xf8f8ff,
        "gold": 0xffd700,
        "goldenrod": 0xdaa520,
        "gray": 0x808080,
        "green": 0x008000,
        "greenyellow": 0xadff2f,
        "grey": 0x808080,
        "honeydew": 0xf0fff0,
        "hotpink": 0xff69b4,
        "indianred": 0xcd5c5c,
        "indigo": 0x4b0082,
        "ivory": 0xfffff0,
        "khaki": 0xf0e68c,
        "lavender": 0xe6e6fa,
        "lavenderblush": 0xfff0f5,
        "lawngreen": 0x7cfc00,
        "lemonchiffon": 0xfffacd,
        "lightblue": 0xadd8e6,
        "lightcoral": 0xf08080,
        "lightcyan": 0xe0ffff,
        "lightgoldenrodyellow": 0xfafad2,
        "lightgray": 0xd3d3d3,
        "lightgreen": 0x90ee90,
        "lightgrey": 0xd3d3d3,
        "lightpink": 0xffb6c1,
        "lightsalmon": 0xffa07a,
        "lightseagreen": 0x20b2aa,
        "lightskyblue": 0x87cefa,
        "lightslategray": 0x778899,
        "lightslategrey": 0x778899,
        "lightsteelblue": 0xb0c4de,
        "lightyellow": 0xffffe0,
        "lime": 0x00ff00,
        "limegreen": 0x32cd32,
        "linen": 0xfaf0e6,
        "magenta": 0xff00ff,
        "maroon": 0x800000,
        "mediumaquamarine": 0x66cdaa,
        "mediumblue": 0x0000cd,
        "mediumorchid": 0xba55d3,
        "mediumpurple": 0x9370db,
        "mediumseagreen": 0x3cb371,
        "mediumslateblue": 0x7b68ee,
        "mediumspringgreen": 0x00fa9a,
        "mediumturquoise": 0x48d1cc,
        "mediumvioletred": 0xc71585,
        "midnightblue": 0x191970,
        "mintcream": 0xf5fffa,
        "mistyrose": 0xffe4e1,
        "moccasin": 0xffe4b5,
        "navajowhite": 0xffdead,
        "navy": 0x000080,
        "oldlace": 0xfdf5e6,
        "olive": 0x808000,
        "olivedrab": 0x6b8e23,
        "orange": 0xffa500,
        "orangered": 0xff4500,
        "orchid": 0xda70d6,
        "palegoldenrod": 0xeee8aa,
        "palegreen": 0x98fb98,
        "paleturquoise": 0xafeeee,
        "palevioletred": 0xdb7093,
        "papayawhip": 0xffefd5,
        "peachpuff": 0xffdab9,
        "peru": 0xcd853f,
        "pink": 0xffc0cb,
        "plum": 0xdda0dd,
        "powderblue": 0xb0e0e6,
        "purple": 0x800080,
        "rebeccapurple": 0x663399,
        "red": 0xff0000,
        "rosybrown": 0xbc8f8f,
        "royalblue": 0x4169e1,
        "saddlebrown": 0x8b4513,
        "salmon": 0xfa8072,
        "sandybrown": 0xf4a460,
        "seagreen": 0x2e8b57,
        "seashell": 0xfff5ee,
        "sienna": 0xa0522d,
        "silver": 0xc0c0c0,
        "skyblue": 0x87ceeb,
        "slateblue": 0x6a5acd,
        "slategray": 0x708090,
        "slategrey": 0x708090,
        "snow": 0xfffafa,
        "springgreen": 0x00ff7f,
        "steelblue": 0x4682b4,
        "tan": 0xd2b48c,
        "teal": 0x008080,
        "thistle": 0xd8bfd8,
        "tomato": 0xff6347,
        "turquoise": 0x40e0d0,
        "violet": 0xee82ee,
        "wheat": 0xf5deb3,
        "white": 0xffffff,
        "whitesmoke": 0xf5f5f5,
        "yellow": 0xffff00,
        "yellowgreen": 0x9acd32
    ]

    #if os(iOS)
    public static let systemColorList = [
        "AppWorkspace": 0xffffff,
        "ActiveBorder": 0xffffff,
        "ActiveCaption": 0xcccccc,
        "Background": 0x6363ce,
        "ButtonFace": 0xc0c0c0,
        "ButtonHighlight": 0xcccccc,
        "ButtonShadow": 0x888888,
        "CaptionText": 0x000000,
        "HighlightText": 0x000000,
        "Menu": 0xc0c0c0,
        "MenuText": 0x000000,
        "ThreeDFace": 0xc0c0c0,
        "ThreeDDarkShadow": 0x666666,
        "ThreeDLightShadow": 0xc0c0c0,
        "Window": 0xffffff,
        "WindowFrame": 0xcccccc,
        "WindowText": 0x000000
    ]
    #elseif os(OSX)
    public static let systemColorList = [
        "AppWorkspace": 0xaaaaaa,
        "ActiveBorder": 0x992a6ccd,
        "ActiveCaption": 0x242424,
        "Background": 0x6363ce,
        "ButtonFace": 0xc0c0c0,
        "ButtonHighlight": 0xffffff,
        "ButtonShadow": 0x8d8d8d,
        "CaptionText": 0x000000,
        "HighlightText": 0x000000,
        "Menu": 0xf6f6f6,
        "MenuText": 0xffffff,
        "ThreeDFace": 0xc0c0c0,
        "ThreeDDarkShadow": 0x000000,
        "ThreeDLightShadow": 0xffffff,
        "Window": 0xececec,
        "WindowFrame": 0xaaaaaa,
        "WindowText": 0x242424
    ]
    #endif

    public static func valueToColor(_ color: Int) -> String? {
        return SVGConstants.colorList.filter { _, v -> Bool in v == color }.map { k, _ -> String in k }.first
    }

    public static let defaultStrokeLineCap = LineCap.butt
    public static let defaultStrokeLineJoin = LineJoin.miter

}
