#if canImport(UIKit) && !os(watchOS)
import UIKit
import ReactiveSwift

@objc public protocol Reusable: AnyObject {
	func prepareForReuse()
}

extension Reactive where Base: NSObject, Base: Reusable {
	public var prepareForReuse: Signal<(), Never> {
		return trigger(for: #selector(base.prepareForReuse))
	}
}

extension UITableViewCell: Reusable {}
extension UITableViewHeaderFooterView: Reusable {}
extension UICollectionReusableView: Reusable {}
#endif
