
# Ryan May
UCAR/Unidata

## Employment
* Software Engineer, Unidata/University Corporation for Atmospheric Research, 2014-Current
* Software Engineer, Enterprise Electronics Corporation, 2009-2013
* Graduate Research Assistant, University of Oklahoma School of Meteorology, 2003-2010

## Open Source Work
* Maintainer for [MetPy](https://github.com/Unidata/MetPy) and [siphon](https://github.com/Unidata/siphon)
* Committer for @matplotlib
* Contributed to numpy, scipy, cartopy, pint

## Education
* School of Meteorology, University of Oklahoma, Norman, OK
  - Ph.D., Meteorology, 2014
    - Advisor: Dr. Michael Biggerstaff
  - M.S., Meteorology, 2005
    - Advisor: Dr. Michael Biggerstaff
  - B.S., Meteorology, 2003

## Peer-Reviewed Publications
* Ansari, S., S. Del Greco, E. Kearns, O. Brown, S. Wilkins, M. Ramamurthy, J. Weber, R. May, J. Sundwall, J. Layton, A. Gold, A. Pasch, and V. Lakshmanan, 2018: Unlocking the potential of NEXRAD data through NOAA's Big Data Partnership. Bull. Amer. Meteor. Soc., 99, 189-204 [doi:10.1175/BAMS-D-16-0021.1](https://doi.org/10.1175/BAMS-D-16-0021.1).
* Cao, Q., G. Zhang, R. D. Palmer, M. Knight, R. May, and R. J. Stafford, 2012: Spectrum-Time Estimation and Processing (STEP) for Improving Weather Radar Data Quality. IEEE Trans. Geo. Rem. Sens., 50, 4670-4683.[doi:10.1109/TGRS.2012.2190608](https://doi.org/10.1109/TGRS.2012.2190608)
* R. M. May, M. I. Biggerstaff, and M. Xue, 2007: A Doppler Radar Emulator with an Application to the Detectability of Tornadic Signatures, J. Atmos. Oceanic Tech., 24, 1973-1996, [doi:10.1175/2007JTECHA882.1](https://doi.org/10.1175/2007JTECHA882.1)

## Conference Presentations
* AMS Annual Meeting 2020
  - R. M. May, Z. S. Bruick, and K. H. Goebbert, [MetPy 1.0: An Upgrade from GEMPAK for Twenty-First Century Atmospheric Science Data Analysis and Visualization](https://ams.confex.com/ams/2020Annual/meetingapp.cgi/Paper/369011)
  - A. Sweeney, S. C. Arms, R. M. May, Z. Bruick, [Remote Access of National Hurricane Center Storm Tracks and Storm Prediction Center Storm Reports with Siphon](https://ams.confex.com/ams/2020Annual/meetingapp.cgi/Paper/365231)
  - K. H. Goebbert, R. M. May, Z. S. Bruick, [An Interactive Demonstration of MetPy's Declarative Language: Moving from GEMPAK to MetPy as the Primary Analysis and Visualization Tool of Atmospheric Scientists](https://ams.confex.com/ams/2020Annual/meetingapp.cgi/Paper/368147)
  - Z. S. Bruick, R. M. May, and K. H. Goebbert, [A One-Stop Shop for Atmospheric Science Python: The Unidata Python Training Site](https://ams.confex.com/ams/2020Annual/meetingapp.cgi/Paper/368299)
  - M. Grover, R. M. May, Z. Bruick, [Declarative Surface Station Plots: The Next Stop on the GEMPAK Replacement Roadmap for MetPy](https://ams.confex.com/ams/2020Annual/meetingapp.cgi/Paper/365917)
  - S. C. Arms, R. M. May, D. Dirks, [The Unidata Summer Internship Program—Seven Years of Providing Students with Software Carpentry Skills](https://ams.confex.com/ams/2020Annual/meetingapp.cgi/Paper/369041)
  - J. E. Thielen and R. M. May, [Bringing WRF into MetPy (and the Rest of the Atmospheric Sciences Python Ecosystem)](https://ams.confex.com/ams/2020Annual/meetingapp.cgi/Paper/369355)
* AMS Annual Meeting 2019
  - R. M. May, J. R. Leeman, and K. H. Goebbert, [Bringing GEMPAK-like Syntax to Python with MetPy's Declarative Plotting Interface](https://ams.confex.com/ams/2019Annual/meetingapp.cgi/Paper/352384)
  - K. H. Goebbert and R. M. May, [From GEMPAK to MetPy: An Updated tool for Teaching Synoptic Meteorology (and Much More)](https://ams.confex.com/ams/2019Annual/meetingapp.cgi/Paper/349856)
  - J. R. Leeman and R. M. May, [MetPy 2019: Building a Software Package and Community](https://ams.confex.com/ams/2019Annual/meetingapp.cgi/Paper/354058)
  - J. E. Theilen, R. M. May, and J. R. Leeman, [Cross-Section Analysis in MetPy](https://ams.confex.com/ams/2019Annual/meetingapp.cgi/Paper/352367)
  - R. M. May, [Python (presentation to Student Conference "Tools of the Trade")](https://ams.confex.com/ams/2019Annual/webprogram/Session50349.html)
* SciPy 2018
  - R. M. May and J. R. Leeman, [Development of MetPy's Declarative Plotting Interface](https://www.youtube.com/watch?v=OKQlUdPY0Jc)
  - J. R. Leeman and R. M. May, Building Communities Around Open-Source Geoscience Projects
* AMS Annual Meeting 2018
  - R. M. May and J. R. Leeman, [MetPy Advancement and Community-Driven Development](https://ams.confex.com/ams/98Annual/meetingapp.cgi/Paper/333578)
  - R. M. May, [Analyzing Soundings with MetPy and Siphon](https://ams.confex.com/ams/98Annual/meetingapp.cgi/Paper/341757)
  - S. C. Arms, R. M. May, and J. R. Leeman, [Siphon--Simplifying Data Access and Expanding Data Sources](https://ams.confex.com/ams/98Annual/meetingapp.cgi/Paper/336381)
  - J. R. Leeman and R. M. May, [The MetPy Roadmap: Replacing Legacy Meteorological Tools](https://ams.confex.com/ams/98Annual/meetingapp.cgi/Paper/335005)
  - M. B. Wilson, J. R. Leeman, and R. M. May, [Bulk Shear, Supercell Composite, Precipitable Water, and More: Exploring MetPy's New CAPE-abilities with an Interactive Sounding Plotter](https://ams.confex.com/ams/98Annual/meetingapp.cgi/Paper/333471)
  - T. J. Wixtrom, R. M. May, J. R. Leeman, and K. H. Goebbert, [Vertical Interpolation with MetPy](https://ams.confex.com/ams/98Annual/meetingapp.cgi/Paper/328761)
* SciPy 2017
  - R. M. May and J. R. Leeman, [MetPy’s Choice of Unit Support: A Descent into Madness](https://www.youtube.com/watch?v=qCo9bkT9sow)
* AMS Annual Meeting 2017
  - R. M. May, [MetPy's Recent Updates and the Road to 1.0](https://ams.confex.com/ams/97Annual/webprogram/Paper314057.html)
  - R. M. May, [Python: Its Past, Present, and Future in Meteorology (Core Science Keynote)](https://ams.confex.com/ams/97Annual/webprogram/Paper314111.html)
  - J. Chastang and R. M. May, [Unidata Online Python Training](https://ams.confex.com/ams/97Annual/webprogram/Paper315368.html)
  - A. M. Haberlie and R. M. May, [Implementation and Comparison of Interpolation Techniques for the Meteorological Python (MetPy) Package](https://ams.confex.com/ams/97Annual/webprogram/Paper304950.html)
  - J. Weber and R. M. May, [Unidata and the Big Data Project](https://ams.confex.com/ams/97Annual/webprogram/Paper313132.html)
  - R. M. May, [Python (presentation to Student Conference "Tools of the Trade")](https://ams.confex.com/ams/97Annual/webprogram/Paper317334.html)
* SciPy 2016
  - [Bootstrapping an Open Source Library: How MetPy Got Up & Running with Lazy Developers](https://www.youtube.com/watch?v=moLKGjbXvgE)
* AMS Annual Meeting 2016
  - R. M. May and S. C. Arms, [MetPy: An Open-Source Toolkit for Meteorology](https://ams.confex.com/ams/96Annual/webprogram/Paper286983.html)
  - R. M. May, K. H. Goebbert, and S. C. Arms, [Converting to Python: Roadblocks and Missing Functionality](https://ams.confex.com/ams/96Annual/webprogram/Paper286893.html)
  - J. Caron, S. C. Arms, E. R. Davis, D. Heimbigner, R. M. May, and C. Ward-Garrison, [THREDDS 5.0: The Good, The Bad, and The Awesome](https://ams.confex.com/ams/96Annual/webprogram/Paper283697.html)
  - S. C. Arms and R. M. May, [Siphon: Extracting Data from THREDDS Data Servers in Multiple Ways using Python](https://ams.confex.com/ams/96Annual/webprogram/Paper283678.html)
* AMS Annual Meeting 2015
  - R. M. May and S. C. Arms, [Exploring Client-Server Data Visualization using IPython and WebGL](https://ams.confex.com/ams/95Annual/webprogram/Paper268652.html)
* AMS Annual Meeting 2011
  - R. M. May, [Porting radar simulation software to Python: a case study in the benefits of Python](https://ams.confex.com/ams/91Annual/webprogram/Paper185405.html)

## Teaching
* 2019
  * [Regional Python Workshop at Valparaiso University](https://unidata.github.io/python-workshop/events/valpo2019.html), Valparaiso University, August 2019
  * [NetCDF and CF: The Basics](https://2019esipsummermeeting.sched.com/event/PtOv/netcdf-and-cf-the-basics), 2019 Earth Science Information Partners Summer Meeting Tacoma WA, July 2019
  * [Testing Your Python Code with PyTest](https://www.youtube.com/watch?v=LX2ksGYXJ80), 2019 SciPy Tutorial Austin TX, July 2019
  * [Regional Python Workshop at the University at Albany](https://unidata.github.io/python-workshop/events/albany2019.html), SUNY Albany, May 2019
  * [Python Workshop at Metropolitan State University](https://unidata.github.io/python-workshop/events/metro2019.html), Metropolitan State University, March 2019
  * [AMS Short Course: Python for Synoptic Meteorology Using Metpy](https://unidata.github.io/python-workshop/events/ams2019.html), 2019 AMS Annual Meeting Phoenix AZ, January 2019
* 2018
  * [Unidata Python Training Workshop](https://unidata.github.io/python-workshop/events/unidata2018.html), Boulder CO, October 2018
  * [Unidata Python Regional Workshop](https://unidata.github.io/python-workshop/events/sjsu2018.html), San Jose State University, October 2018
  * [Unidata Python Regional Workshop](https://unidata.github.io/python-workshop/events/jackson2018.html), Jackson State University, August 2018
  * [Setting Up Your Own Open Source Project](https://www.youtube.com/watch?v=hQq2Ayqb5d8), 2019 SciPy Tutorial Austin TX, July 2018
  * [CSU Python Workshop](https://unidata.github.io/python-workshop/events/csu2018.html), Colorado State University, May 2018
  * [Meteorological Data Analysis and Visualization with MetPy](https://unidata.github.io/python-workshop/events/sea2018.html), 2019 Software Engineering Assmembly Conference Boulder CO, April 2018
  * [AMS Short Course: Python for Dynamical Meteorology Using MetPy](https://unidata.github.io/python-workshop/events/ams2018.html), 2018 AMS Annual Meeting Austin TX, January 2018
* 2017
  * [Texas Tech Intermediate Python Workshop](https://unidata.github.io/python-workshop/events/ttu2017.html), Texas Tech University, November 2017
  * [University of Wisconsin Regional Workshop](https://unidata.github.io/unidata-python-workshop/events/madison2017.html), University of Wisconsin, June 2017
  * [University of Oklahoma Regional Python Workshop](https://unidata.github.io/unidata-python-workshop/events/oklahoma2017.html), University of Oklahoma, April 2017
  * [Millersville University Regional Workshop](https://unidata.github.io/unidata-python-workshop/events/millersville2017.html), Millersville University of Pennsylvania, April 2017
  * [Interacting with Radar Data in the Cloud](https://annual.ametsoc.org/2017/index.cfm/programs/short-courses-and-workshops/interacting-with-radar-data-in-the-cloud1/), AMS 2017 Annual Meeting, January 2017
* 2016
  * [Unidata Python Workshop](https://unidata.github.io/unidata-python-workshop/events/fall2016.html), October 2016
  * [Software Carpentry](https://jdcorless.github.io/2016-08-26-TTU/), Texas Tech University, August 2016
  * [Unidata Python Workshop](https://unidata.github.io/unidata-python-workshop/events/madison2016.html), University of Wisconsin/SSEC, June 2016
  * MetPy and Siphon, Software Engineering Assembly Conference, April 2016
* 2015
  * THREDDS Training Workshop, July 2015
  * Python with Unidata Technologies, July 2015
  * [MetPy: An open source Python toolkit for meteorology](https://www.youtube.com/watch?v=umwauHAL-0M), 2015 Unidata Users Workshop, June 2015
* 2014
  * THREDDS Training Workshop, October 2014
  * Python with Unidata Technologies, October 2014
* 2012
  * [Advanced Matplotlib Tutorial](https://github.com/dopplershift/Python-Tutorials), SciPy 2012, July 2012
* 2010
  * [Matplotlib: Beyond the Basics](https://conference.scipy.org/scipy2010/tutorials.html#matplotlib), SciPy 2010, June 2010

## Grants
* [NSF-1740315](https://www.nsf.gov/awardsearch/showAward?AWD_ID=1740315), SI2-SSE: MetPy - A Python GEMPAK Replacement for Meteorological Data Analysis, Principal Investigator, September 2017-August 2020.
* [NSF-1740633](https://www.nsf.gov/awardsearch/showAward?AWD_ID=1740633), Collaborative Proposal: EarthCube Integration: Pangeo: An Open Source Big Data Climate Science Platform, Co-Principal Investigator, September 2017-August 2020.

## Interests
My background and degrees are in meteorology, with a focus on weather radar
algorithms and signal processing. Much of my open source contributions have
been directed at making it easier to use the Python tools work better for
use in meteorological analysis. Besides this, I'm interested in data
visualization, signal processing, and machine learning--basically anything
to help extract additional useful information from data.

## Primary Languages
* Python
* C/C++
* Java
