var Grav;
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 64848:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ main)
});

// EXTERNAL MODULE: ./node_modules/@babel/polyfill/lib/index.js
var lib = __webpack_require__(27461);
// EXTERNAL MODULE: external "jQuery"
var external_jQuery_ = __webpack_require__(41669);
var external_jQuery_default = /*#__PURE__*/__webpack_require__.n(external_jQuery_);
;// CONCATENATED MODULE: ./app/utils/remodal.js
/* Remodal from https://github.com/vodkabears/Remodal
 * With Stackable option from https://github.com/antstorm/Remodal patch
 */


!function (root, factory) {
  return factory(root, (external_jQuery_default()));
}(undefined, function (global, $) {
  'use strict';

  /**
   * Name of the plugin
   * @private
   * @const
   * @type {String}
   */
  var PLUGIN_NAME = 'remodal';

  /**
   * Namespace for CSS and events
   * @private
   * @const
   * @type {String}
   */
  var NAMESPACE = window.REMODAL_GLOBALS && window.REMODAL_GLOBALS.NAMESPACE || PLUGIN_NAME;

  /**
   * Animationstart event with vendor prefixes
   * @private
   * @const
   * @type {String}
   */
  var ANIMATIONSTART_EVENTS = $.map(['animationstart', 'webkitAnimationStart', 'MSAnimationStart', 'oAnimationStart'], function (eventName) {
    return eventName + '.' + NAMESPACE;
  }).join(' ');

  /**
   * Animationend event with vendor prefixes
   * @private
   * @const
   * @type {String}
   */
  var ANIMATIONEND_EVENTS = $.map(['animationend', 'webkitAnimationEnd', 'MSAnimationEnd', 'oAnimationEnd'], function (eventName) {
    return eventName + '.' + NAMESPACE;
  }).join(' ');

  /**
   * Default settings
   * @private
   * @const
   * @type {Object}
   */
  var DEFAULTS = $.extend({
    hashTracking: true,
    closeOnConfirm: true,
    closeOnCancel: true,
    closeOnEscape: true,
    closeOnOutsideClick: true,
    modifier: '',
    stack: false,
    appendTo: null
  }, window.REMODAL_GLOBALS && window.REMODAL_GLOBALS.DEFAULTS);

  /**
   * States of the Remodal
   * @private
   * @const
   * @enum {String}
   */
  var STATES = {
    CLOSING: 'closing',
    CLOSED: 'closed',
    OPENING: 'opening',
    OPENED: 'opened'
  };

  /**
   * Reasons of the state change.
   * @private
   * @const
   * @enum {String}
   */
  var STATE_CHANGE_REASONS = {
    CONFIRMATION: 'confirmation',
    CANCELLATION: 'cancellation'
  };

  /**
   * Is animation supported?
   * @private
   * @const
   * @type {Boolean}
   */
  var IS_ANIMATION = function () {
    var style = document.createElement('div').style;
    return style.animationName !== undefined || style.WebkitAnimationName !== undefined || style.MozAnimationName !== undefined || style.msAnimationName !== undefined || style.OAnimationName !== undefined;
  }();

  /**
   * Is iOS?
   * @private
   * @const
   * @type {Boolean}
   */
  var IS_IOS = /iPad|iPhone|iPod/.test(navigator.platform);

  /**
   * Current modal
   * @private
   * @type {Remodal}
   */
  var openModals = [];

  /**
   * Scrollbar position
   * @private
   * @type {Number}
   */
  var scrollTop;

  /**
   * Returns an animation duration
   * @private
   * @param {jQuery} $elem
   * @returns {Number}
   */
  function getAnimationDuration($elem) {
    if (IS_ANIMATION && $elem.css('animation-name') === 'none' && $elem.css('-webkit-animation-name') === 'none' && $elem.css('-moz-animation-name') === 'none' && $elem.css('-o-animation-name') === 'none' && $elem.css('-ms-animation-name') === 'none') {
      return 0;
    }
    var duration = $elem.css('animation-duration') || $elem.css('-webkit-animation-duration') || $elem.css('-moz-animation-duration') || $elem.css('-o-animation-duration') || $elem.css('-ms-animation-duration') || '0s';
    var delay = $elem.css('animation-delay') || $elem.css('-webkit-animation-delay') || $elem.css('-moz-animation-delay') || $elem.css('-o-animation-delay') || $elem.css('-ms-animation-delay') || '0s';
    var iterationCount = $elem.css('animation-iteration-count') || $elem.css('-webkit-animation-iteration-count') || $elem.css('-moz-animation-iteration-count') || $elem.css('-o-animation-iteration-count') || $elem.css('-ms-animation-iteration-count') || '1';
    var max;
    var len;
    var num;
    var i;
    duration = duration.split(', ');
    delay = delay.split(', ');
    iterationCount = iterationCount.split(', ');

    // The 'duration' size is the same as the 'delay' size
    for (i = 0, len = duration.length, max = Number.NEGATIVE_INFINITY; i < len; i++) {
      num = parseFloat(duration[i]) * parseInt(iterationCount[i], 10) + parseFloat(delay[i]);
      if (num > max) {
        max = num;
      }
    }
    return max;
  }

  /**
   * Returns a scrollbar width
   * @private
   * @returns {Number}
   */
  function getScrollbarWidth() {
    if ($(document).height() <= $(window).height()) {
      return 0;
    }
    var outer = document.createElement('div');
    var inner = document.createElement('div');
    var widthNoScroll;
    var widthWithScroll;
    outer.style.visibility = 'hidden';
    outer.style.width = '100px';
    document.body.appendChild(outer);
    widthNoScroll = outer.offsetWidth;

    // Force scrollbars
    outer.style.overflow = 'scroll';

    // Add inner div
    inner.style.width = '100%';
    outer.appendChild(inner);
    widthWithScroll = inner.offsetWidth;

    // Remove divs
    outer.parentNode.removeChild(outer);
    return widthNoScroll - widthWithScroll;
  }

  /**
   * Locks the screen
   * @private
   */
  function lockScreen() {
    if (IS_IOS) {
      return;
    }
    var $html = $('html');
    var lockedClass = namespacify('is-locked');
    var paddingRight;
    var $body;
    if (!$html.hasClass(lockedClass)) {
      $body = $(document.body);

      // Zepto does not support '-=', '+=' in the `css` method
      paddingRight = parseInt($body.css('padding-right'), 10) + getScrollbarWidth();
      $body.css('padding-right', paddingRight + 'px');
      $html.addClass(lockedClass);
    }
  }

  /**
   * Unlocks the screen
   * @private
   */
  function unlockScreen() {
    if (IS_IOS) {
      return;
    }
    var $html = $('html');
    var lockedClass = namespacify('is-locked');
    var paddingRight;
    var $body;
    if ($html.hasClass(lockedClass)) {
      $body = $(document.body);

      // Zepto does not support '-=', '+=' in the `css` method
      paddingRight = parseInt($body.css('padding-right'), 10) - getScrollbarWidth();
      $body.css('padding-right', paddingRight + 'px');
      $html.removeClass(lockedClass);
    }
  }

  /**
   * Sets a state for an instance
   * @private
   * @param {Remodal} instance
   * @param {STATES} state
   * @param {Boolean} isSilent If true, Remodal does not trigger events
   * @param {String} Reason of a state change.
   */
  function setState(instance, state, isSilent, reason) {
    var newState = namespacify('is', state);
    var allStates = [namespacify('is', STATES.CLOSING), namespacify('is', STATES.OPENING), namespacify('is', STATES.CLOSED), namespacify('is', STATES.OPENED)].join(' ');
    instance.$bg.removeClass(allStates).addClass(newState);
    instance.$overlay.removeClass(allStates).addClass(newState);
    instance.$wrapper.removeClass(allStates).addClass(newState);
    instance.$modal.removeClass(allStates).addClass(newState);
    instance.state = state;
    !isSilent && instance.$modal.trigger({
      type: state,
      reason: reason
    }, [{
      reason: reason
    }]);
  }

  /**
   * Synchronizes with the animation
   * @param {Function} doBeforeAnimation
   * @param {Function} doAfterAnimation
   * @param {Remodal} instance
   */
  function syncWithAnimation(doBeforeAnimation, doAfterAnimation, instance) {
    var runningAnimationsCount = 0;
    var handleAnimationStart = function handleAnimationStart(e) {
      if (e.target !== this) {
        return;
      }
      runningAnimationsCount++;
    };
    var handleAnimationEnd = function handleAnimationEnd(e) {
      if (e.target !== this) {
        return;
      }
      if (--runningAnimationsCount === 0) {
        // Remove event listeners
        $.each(['$bg', '$overlay', '$wrapper', '$modal'], function (index, elemName) {
          instance[elemName].off(ANIMATIONSTART_EVENTS + ' ' + ANIMATIONEND_EVENTS);
        });
        doAfterAnimation();
      }
    };
    $.each(['$bg', '$overlay', '$wrapper', '$modal'], function (index, elemName) {
      instance[elemName].on(ANIMATIONSTART_EVENTS, handleAnimationStart).on(ANIMATIONEND_EVENTS, handleAnimationEnd);
    });
    doBeforeAnimation();

    // If the animation is not supported by a browser or its duration is 0
    if (getAnimationDuration(instance.$bg) === 0 && getAnimationDuration(instance.$overlay) === 0 && getAnimationDuration(instance.$wrapper) === 0 && getAnimationDuration(instance.$modal) === 0) {
      // Remove event listeners
      $.each(['$bg', '$overlay', '$wrapper', '$modal'], function (index, elemName) {
        instance[elemName].off(ANIMATIONSTART_EVENTS + ' ' + ANIMATIONEND_EVENTS);
      });
      doAfterAnimation();
    }
  }

  /**
   * Closes immediately
   * @private
   * @param {Remodal} instance
   */
  function halt(instance) {
    if (instance.state === STATES.CLOSED) {
      return;
    }
    $.each(['$bg', '$overlay', '$wrapper', '$modal'], function (index, elemName) {
      instance[elemName].off(ANIMATIONSTART_EVENTS + ' ' + ANIMATIONEND_EVENTS);
    });
    removeModal(instance);
    instance.$bg.removeClass(instance.settings.modifier);
    instance.$overlay.removeClass(instance.settings.modifier).hide();
    instance.$wrapper.hide();
    if (openModals.length === 0) {
      unlockScreen();
    }
    setState(instance, STATES.CLOSED, true);
  }

  /**
   * Parses a string with options
   * @private
   * @param str
   * @returns {Object}
   */
  function parseOptions(str) {
    var obj = {};
    var arr;
    var len;
    var val;
    var i;

    // Remove spaces before and after delimiters
    str = str.replace(/\s*:\s*/g, ':').replace(/\s*,\s*/g, ',');

    // Parse a string
    arr = str.split(',');
    for (i = 0, len = arr.length; i < len; i++) {
      arr[i] = arr[i].split(':');
      val = arr[i][1];

      // Convert a string value if it is like a boolean
      if (typeof val === 'string' || val instanceof String) {
        val = val === 'true' || (val === 'false' ? false : val);
      }

      // Convert a string value if it is like a number
      if (typeof val === 'string' || val instanceof String) {
        val = !isNaN(val) ? +val : val;
      }
      obj[arr[i][0]] = val;
    }
    return obj;
  }

  /**
   * Generates a string separated by dashes and prefixed with NAMESPACE
   * @private
   * @param {...String}
   * @returns {String}
   */
  function namespacify() {
    var result = NAMESPACE;
    for (var i = 0; i < arguments.length; ++i) {
      result += '-' + arguments[i];
    }
    return result;
  }

  /**
   * Handles the hashchange event
   * @private
   * @listens hashchange
   */
  function handleHashChangeEvent() {
    var id = location.hash.replace('#', '');
    var instance;
    var $elem;
    var current = currentModal();
    if (!id) {
      // Check if we have currently opened modal and animation was completed
      if (current && current.state === STATES.OPENED && current.settings.hashTracking) {
        current.close();
      }
    } else {
      if (!current || current.id !== id) {
        // Catch syntax error if your hash is bad
        try {
          $elem = $('[data-' + PLUGIN_NAME + '-id="' + id + '"]');
        } catch (err) {}
        if ($elem && $elem.length) {
          instance = $[PLUGIN_NAME].lookup[$elem.data(PLUGIN_NAME)];
          if (instance && instance.settings.hashTracking) {
            instance.open();
          }
        }
      }
    }
  }
  function currentModal() {
    return openModals[openModals.length - 1];
  }
  function removeModal(remodal) {
    var index = openModals.indexOf(remodal);
    if (index >= 0) {
      openModals.slice(index, 1);
    }
  }

  /**
   * Remodal constructor
   * @constructor
   * @param {jQuery} $modal
   * @param {Object} options
   */
  function Remodal($modal, options) {
    var $body = $(document.body);
    var $appendTo = $body;
    var remodal = this;
    remodal.id = $modal.attr('data-' + PLUGIN_NAME + '-id');
    remodal.settings = $.extend({}, DEFAULTS, options);
    remodal.index = $[PLUGIN_NAME].lookup.push(remodal) - 1;
    remodal.state = STATES.CLOSED;

    // remodal.$overlay = $('.' + namespacify('overlay'));

    if (remodal.settings.appendTo !== null && remodal.settings.appendTo.length) {
      $appendTo = $(remodal.settings.appendTo);
    }
    if (!remodal.$overlay) {
      remodal.$overlay = $('<div>').addClass(namespacify('overlay') + ' ' + namespacify('is', STATES.CLOSED)).hide();
      $appendTo.append(remodal.$overlay);
    }
    remodal.$bg = $('.' + namespacify('bg')).addClass(namespacify('is', STATES.CLOSED));
    remodal.$modal = $modal.addClass(NAMESPACE + ' ' + namespacify('is-initialized') + ' ' + remodal.settings.modifier + ' ' + namespacify('is', STATES.CLOSED)).attr('tabindex', '-1');
    remodal.$wrapper = $('<div>').addClass(namespacify('wrapper') + ' ' + remodal.settings.modifier + ' ' + namespacify('is', STATES.CLOSED)).hide().append(remodal.$modal);
    $appendTo.append(remodal.$wrapper);

    // Add the event listener for the close button
    remodal.$wrapper.on('click.' + NAMESPACE, '[data-' + PLUGIN_NAME + '-action="close"]', function (e) {
      e.preventDefault();
      remodal.close();
    });

    // Add the event listener for the cancel button
    remodal.$wrapper.on('click.' + NAMESPACE, '[data-' + PLUGIN_NAME + '-action="cancel"]', function (e) {
      e.preventDefault();
      remodal.$modal.trigger(STATE_CHANGE_REASONS.CANCELLATION);
      if (remodal.settings.closeOnCancel) {
        remodal.close(STATE_CHANGE_REASONS.CANCELLATION);
      }
    });

    // Add the event listener for the confirm button
    remodal.$wrapper.on('click.' + NAMESPACE, '[data-' + PLUGIN_NAME + '-action="confirm"]', function (e) {
      e.preventDefault();
      remodal.$modal.trigger(STATE_CHANGE_REASONS.CONFIRMATION);
      if (remodal.settings.closeOnConfirm) {
        remodal.close(STATE_CHANGE_REASONS.CONFIRMATION);
      }
    });

    // Add the event listener for the overlay
    remodal.$wrapper.on('click.' + NAMESPACE, function (e) {
      var $target = $(e.target);
      var isWrapper = $target.hasClass(namespacify('wrapper'));
      var isWithin = $target.closest('.' + namespacify('is', STATES.OPENED)).length;
      if (!isWrapper && isWithin) {
        return;
      }
      if (remodal.settings.closeOnOutsideClick) {
        remodal.close();
      }
    });
  }

  /**
   * Opens a modal window
   * @public
   */
  Remodal.prototype.open = function () {
    var remodal = this;
    var current;
    var modalCount;

    // Check if the animation was completed
    if (remodal.state === STATES.OPENING || remodal.state === STATES.CLOSING) {
      return;
    }

    // id = remodal.$modal.attr('data-' + PLUGIN_NAME + '-id');

    if (remodal.id && remodal.settings.hashTracking) {
      scrollTop = $(window).scrollTop();
      location.hash = remodal.id;
    }
    if (!remodal.settings.stack) {
      current = currentModal();
      if (current && current !== remodal) {
        halt(current);
      }
    }
    modalCount = openModals.push(remodal);
    remodal.$overlay.css('z-index', function (_, value) {
      return parseInt(value, 10) + modalCount;
    });
    remodal.$wrapper.css('z-index', function (_, value) {
      return parseInt(value, 10) + modalCount;
    });
    lockScreen();
    remodal.$bg.addClass(remodal.settings.modifier);
    remodal.$overlay.addClass(remodal.settings.modifier).show();
    remodal.$wrapper.show().scrollTop(0);
    remodal.$modal.focus();
    syncWithAnimation(function () {
      setState(remodal, STATES.OPENING);
    }, function () {
      setState(remodal, STATES.OPENED);
    }, remodal);
  };

  /**
   * Closes a modal window
   * @public
   * @param {String} reason
   */
  Remodal.prototype.close = function (reason) {
    var remodal = this;
    var current;

    // Check if the animation was completed
    if (remodal.state === STATES.OPENING || remodal.state === STATES.CLOSING || remodal.state === STATES.CLOSED) {
      return;
    }
    removeModal(remodal);
    if (remodal.settings.hashTracking && remodal.id === location.hash.substr(1)) {
      current = currentModal();
      if (current) {
        location.hash = current.id;
      } else {
        location.hash = '';
        $(window).scrollTop(scrollTop);
      }
    }
    syncWithAnimation(function () {
      setState(remodal, STATES.CLOSING, false, reason);
    }, function () {
      remodal.$bg.removeClass(remodal.settings.modifier);
      remodal.$overlay.removeClass(remodal.settings.modifier).hide();
      remodal.$wrapper.hide();
      if (openModals.length === 0) {
        unlockScreen();
      }
      setState(remodal, STATES.CLOSED, false, reason);
    }, remodal);
  };

  /**
   * Returns a current state of a modal
   * @public
   * @returns {STATES}
   */
  Remodal.prototype.getState = function () {
    return this.state;
  };

  /**
   * Destroys a modal
   * @public
   */
  Remodal.prototype.destroy = function () {
    var lookup = $[PLUGIN_NAME].lookup;
    var instanceCount;
    halt(this);
    this.$wrapper.remove();
    delete lookup[this.index];
    instanceCount = $.grep(lookup, function (instance) {
      return !!instance;
    }).length;
    if (instanceCount === 0) {
      this.$overlay.remove();
      this.$bg.removeClass(namespacify('is', STATES.CLOSING) + ' ' + namespacify('is', STATES.OPENING) + ' ' + namespacify('is', STATES.CLOSED) + ' ' + namespacify('is', STATES.OPENED));
    }
  };

  /**
   * Special plugin object for instances
   * @public
   * @type {Object}
   */
  $[PLUGIN_NAME] = {
    lookup: []
  };

  /**
   * Plugin constructor
   * @constructor
   * @param {Object} options
   * @returns {JQuery}
   */
  $.fn[PLUGIN_NAME] = function (opts) {
    var instance;
    var $elem;
    this.each(function (index, elem) {
      $elem = $(elem);
      if ($elem.data(PLUGIN_NAME) == null) {
        instance = new Remodal($elem, opts);
        $elem.data(PLUGIN_NAME, instance.index);
        if (instance.settings.hashTracking && instance.id === location.hash.substr(1)) {
          instance.open();
        }
      } else {
        instance = $[PLUGIN_NAME].lookup[$elem.data(PLUGIN_NAME)];
      }
    });
    return instance;
  };
  $(document).ready(function () {
    // data-remodal-target opens a modal window with the special Id
    $(document).on('click', '[data-' + PLUGIN_NAME + '-target]', function (e) {
      e.preventDefault();
      var elem = e.currentTarget;
      var id = elem.getAttribute('data-' + PLUGIN_NAME + '-target');
      var $target = $('[data-' + PLUGIN_NAME + '-id="' + id + '"]');
      $[PLUGIN_NAME].lookup[$target.data(PLUGIN_NAME)].open();
    });

    // Auto initialization of modal windows
    // They should have the 'remodal' class attribute
    // Also you can write the `data-remodal-options` attribute to pass params into the modal
    $(document).find('.' + NAMESPACE).each(function (i, container) {
      var $container = $(container);
      var options = $container.data(PLUGIN_NAME + '-options');
      if (!options) {
        options = {};
      } else if (typeof options === 'string' || options instanceof String) {
        options = parseOptions(options);
      }
      $container[PLUGIN_NAME](options);
    });

    // Handles the keydown event
    $(document).on('keydown.' + NAMESPACE, function (e) {
      var current = currentModal();
      if (current && current.settings.closeOnEscape && current.state === STATES.OPENED && e.keyCode === 27) {
        current.close();
      }
    });

    // Handles the hashchange event
    $(window).on('hashchange.' + NAMESPACE, handleHashChangeEvent);
  });
});
// EXTERNAL MODULE: ./node_modules/simplebar/dist/simplebar.min.js
var simplebar_min = __webpack_require__(88904);
// EXTERNAL MODULE: ./node_modules/dropzone/dist/dropzone.js
var dist_dropzone = __webpack_require__(62628);
var dropzone_default = /*#__PURE__*/__webpack_require__.n(dist_dropzone);
// EXTERNAL MODULE: ./node_modules/toastr/toastr.js
var toastr = __webpack_require__(47959);
var toastr_default = /*#__PURE__*/__webpack_require__.n(toastr);
;// CONCATENATED MODULE: ./app/utils/toastr.js

(toastr_default()).options.positionClass = 'toast-top-right';
(toastr_default()).options.preventDuplicates = true;
/* harmony default export */ const utils_toastr = ((toastr_default()));
;// CONCATENATED MODULE: ./app/utils/offline.js


var offlineElement = external_jQuery_default()('#offline-status');
external_jQuery_default()(window).on('offline', function () {
  offlineElement.slideDown();
});
external_jQuery_default()(window).on('online', function () {
  offlineElement.slideUp();
});
external_jQuery_default()(document).ready(function () {
  if (!offline) {
    offlineElement.slideDown();
  }
});

// assume online if can't check
/* harmony default export */ const offline = (typeof __webpack_require__.g.navigator.onLine !== 'undefined' ? __webpack_require__.g.navigator.onLine : true);
;// CONCATENATED MODULE: external "GravAdmin"
const external_GravAdmin_namespaceObject = GravAdmin;
// EXTERNAL MODULE: ./node_modules/mout/string/trim.js
var trim = __webpack_require__(35814);
var trim_default = /*#__PURE__*/__webpack_require__.n(trim);
;// CONCATENATED MODULE: ./app/utils/response.js
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }





var UNLOADING = false;
var error = function error(response) {
  var error = new Error(response.statusText || response || '');
  error.response = response;
  return error;
};
function parseStatus(response) {
  return response;

  /* Whoops can handle JSON responses so we don't need this for now.
      if (response.status >= 200 && response.status < 300) {
          return response;
      } else {
          throw error(response);
      }
  */
}
function parseJSON(response) {
  return response.text().then(function (text) {
    var parsed = text;
    try {
      parsed = JSON.parse(text);
    } catch (error) {
      var content = document.createElement('div');
      content.innerHTML = text;
      var the_error = new Error();
      the_error.stack = trim_default()(content.innerText);
      throw the_error;
    }
    return parsed;
  });
}
function userFeedback(response) {
  if (UNLOADING) {
    return true;
  }
  var status = response.status || (response.error ? 'error' : '');
  var message = response.message || (response.error ? response.error.message : null);
  var settings = response.toastr || null;
  var backup;
  switch (status) {
    case 'unauthenticated':
      document.location.href = external_GravAdmin_namespaceObject.config.base_url_relative;
      throw error('Logged out');
    case 'unauthorized':
      status = 'error';
      message = message || 'Unauthorized.';
      break;
    case 'error':
      status = 'error';
      message = message || 'Unknown error.';
      break;
    case 'success':
      status = 'success';
      message = message || '';
      break;
    default:
      status = 'error';
      message = message || 'Invalid AJAX response.';
      break;
  }
  if (settings && _typeof(settings) === 'object' && settings !== null) {
    backup = Object.assign({}, utils_toastr.options);
    Object.keys(settings).forEach(function (key) {
      utils_toastr.options[key] = settings[key];
    });
  }
  if (message && (offline || !offline && status !== 'error')) {
    utils_toastr[status === 'success' ? 'success' : 'error'](message);
  }
  if (settings) {
    utils_toastr.options = backup;
  }
  return response;
}
function userFeedbackError(error) {
  if (UNLOADING) {
    return true;
  }
  var stack = error.stack ? "<pre><code>".concat(error.stack, "</code></pre>") : '';
  utils_toastr.error("Fetch Failed: <br /> ".concat(error.message, " ").concat(stack));
  console.error("".concat(error.message, " at ").concat(error.stack));
}
external_jQuery_default()(__webpack_require__.g).on('beforeunload._ajax', function () {
  UNLOADING = true;
});
;// CONCATENATED MODULE: ./app/utils/request.js
function request_typeof(o) { "@babel/helpers - typeof"; return request_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, request_typeof(o); }


var raw;
var request = function request(url) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var callback = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : function () {
    return true;
  };
  if (typeof options === 'function') {
    callback = options;
    options = {};
  }
  if (options.method && options.method === 'post') {
    var data = new FormData();
    options.body = Object.assign({
      'admin-nonce': external_GravAdmin_namespaceObject.config.admin_nonce
    }, options.body || {});
    if (options.body && request_typeof(options.body) === 'object') {
      Object.keys(options.body).map(function (key) {
        return data.append(key, options.body[key]);
      });
    }
    options.body = data;
  }
  options = Object.assign({
    credentials: 'same-origin',
    headers: {
      'Accept': 'application/json'
    }
  }, options);
  return fetch(url, options).then(function (response) {
    raw = response;
    return response;
  }).then(parseStatus).then(parseJSON).then(userFeedback).then(function (response) {
    return callback(response, raw);
  })["catch"](userFeedbackError);
};
/* harmony default export */ const utils_request = (request);
;// CONCATENATED MODULE: ./app/forms/fields/files.js
function files_typeof(o) { "@babel/helpers - typeof"; return files_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, files_typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == files_typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != files_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != files_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


// import EXIF from 'exif-js';



// translations
var Dictionary = {
  dictCancelUpload: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DROPZONE_CANCEL_UPLOAD,
  dictCancelUploadConfirmation: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DROPZONE_CANCEL_UPLOAD_CONFIRMATION,
  dictDefaultMessage: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DROPZONE_DEFAULT_MESSAGE,
  dictFallbackMessage: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DROPZONE_FALLBACK_MESSAGE,
  dictFallbackText: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DROPZONE_FALLBACK_TEXT,
  dictFileTooBig: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DROPZONE_FILE_TOO_BIG,
  dictInvalidFileType: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DROPZONE_INVALID_FILE_TYPE,
  dictMaxFilesExceeded: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DROPZONE_MAX_FILES_EXCEEDED,
  dictRemoveFile: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DROPZONE_REMOVE_FILE,
  dictResponseError: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DROPZONE_RESPONSE_ERROR
};
(dropzone_default()).autoDiscover = false;
(dropzone_default()).options.gravPageDropzone = {};
(dropzone_default()).confirm = function (question, accepted, rejected) {
  var doc = external_jQuery_default()(document);
  var modalSelector = '[data-remodal-id="delete-media"]';
  var removeEvents = function removeEvents() {
    doc.off('confirmation', modalSelector, accept);
    doc.off('cancellation', modalSelector, reject);
    external_jQuery_default()(modalSelector).find('.remodal-confirm').removeClass('pointer-events-disabled');
  };
  var accept = function accept() {
    accepted && accepted();
    removeEvents();
  };
  var reject = function reject() {
    rejected && rejected();
    removeEvents();
  };
  (external_jQuery_default()).remodal.lookup[external_jQuery_default()(modalSelector).data('remodal')].open();
  doc.on('confirmation', modalSelector, accept);
  doc.on('cancellation', modalSelector, reject);
};
var DropzoneMediaConfig = {
  timeout: 0,
  thumbnailWidth: 200,
  thumbnailHeight: 150,
  addRemoveLinks: false,
  dictDefaultMessage: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DROP_FILES_HERE_TO_UPLOAD.replace(/&lt;/g, '<').replace(/&gt;/g, '>'),
  dictRemoveFileConfirmation: '[placeholder]',
  previewTemplate: "\n        <div class=\"dz-preview dz-file-preview dz-no-editor\">\n          <div class=\"dz-details\">\n            <div class=\"dz-filename\"><span data-dz-name></span></div>\n            <div class=\"dz-size\" data-dz-size></div>\n            <img data-dz-thumbnail />\n          </div>\n          <div class=\"dz-progress\"><span class=\"dz-upload\" data-dz-uploadprogress></span></div>\n          <div class=\"dz-success-mark\"><span>\u2714</span></div>\n          <div class=\"dz-error-mark\"><span>\u2718</span></div>\n          <div class=\"dz-error-message\"><span data-dz-errormessage></span></div>\n          <a class=\"dz-unset\" title=\"".concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.UNSET, "\" href=\"#\" data-dz-unset>").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.UNSET, "</a>\n          <a class=\"dz-remove\" title=\"").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DELETE, "\" href=\"javascript:undefined;\" data-dz-remove>").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DELETE, "</a>\n          <a class=\"dz-metadata\" title=\"").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.METADATA, "\" href=\"#\" target=\"_blank\" data-dz-metadata>").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.METADATA, "</a>\n          <a class=\"dz-view\" title=\"").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.VIEW, "\" href=\"#\" target=\"_blank\" data-dz-view>").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.VIEW, "</a>\n        </div>").trim()
};

// global.EXIF = EXIF;

var ACCEPT_FUNC = function ACCEPT_FUNC(file, done, settings) {
  var resolution = settings.resolution;
  if (!resolution) return done();
  var reader = new FileReader();
  var error = '';
  var hasMin = resolution.min && (resolution.min.width || resolution.min.height);
  var hasMax = resolution.max && (resolution.max.width || resolution.max.height);
  if (hasMin || !(settings.resizeWidth || settings.resizeHeight) && hasMax) {
    reader.onload = function (event) {
      if (!/image\//.test(file.type)) {
        done();
        return;
      }
      var image = new Image();
      image.src = event.target.result;
      image.onerror = function () {
        done(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.FILE_ERROR_UPLOAD);
      };
      image.onload = function () {
        var _this = this;
        if (resolution.min) {
          Object.keys(resolution.min).forEach(function (attr) {
            if (resolution.min[attr] && _this[attr] < resolution.min[attr]) {
              error += external_GravAdmin_namespaceObject.translations.PLUGIN_FORM.RESOLUTION_MIN.replace(/{{attr}}/g, attr).replace(/{{min}}/g, resolution.min[attr]);
            }
          });
        }
        if (!(settings.resizeWidth || settings.resizeHeight)) {
          if (resolution.max) {
            Object.keys(resolution.max).forEach(function (attr) {
              if (resolution.max[attr] && _this[attr] > resolution.max[attr]) {
                error += external_GravAdmin_namespaceObject.translations.PLUGIN_FORM.RESOLUTION_MAX.replace(/{{attr}}/g, attr).replace(/{{max}}/g, resolution.max[attr]);
              }
            });
          }
        }
        URL.revokeObjectURL(image.src); // release memory
        return error ? done(error) : done();
      };
    };
    reader.readAsDataURL(file);
  } else {
    return error ? done(error) : done();
  }
};
var FilesField = /*#__PURE__*/function () {
  function FilesField() {
    var _this2 = this;
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$container = _ref.container,
      container = _ref$container === void 0 ? '.dropzone.files-upload' : _ref$container,
      _ref$options = _ref.options,
      options = _ref$options === void 0 ? {} : _ref$options;
    _classCallCheck(this, FilesField);
    this.container = external_jQuery_default()(container);
    if (!this.container.length) {
      return;
    }
    this.urls = {};
    this.customPost = this.container.data('filePostAdd') || {};
    this.options = Object.assign({}, Dictionary, DropzoneMediaConfig, {
      klass: this,
      url: this.container.data('file-url-add') || external_GravAdmin_namespaceObject.config.current_url,
      acceptedFiles: this.container.data('media-types'),
      init: this.initDropzone
    }, this.container.data('dropzone-options'), options);
    this.options = Object.assign({}, this.options, {
      accept: function accept(file, done) {
        ACCEPT_FUNC(file, done, this.options);
      }
    });
    this.dropzone = new (dropzone_default())(container, this.options);
    this.dropzone.on('complete', this.onDropzoneComplete.bind(this));
    this.dropzone.on('success', this.onDropzoneSuccess.bind(this));
    this.dropzone.on('addedfile', this.onDropzoneAddedFile.bind(this));
    this.dropzone.on('removedfile', this.onDropzoneRemovedFile.bind(this));
    this.dropzone.on('sending', this.onDropzoneSending.bind(this));
    this.dropzone.on('error', this.onDropzoneError.bind(this));
    this.container.on('mouseenter', '[data-dz-view]', function (e) {
      var value = JSON.parse(_this2.container.find('[name][type="hidden"]').val() || '{}');
      var target = external_jQuery_default()(e.currentTarget);
      var file = target.parent('.dz-preview').find('.dz-filename');
      var filename = encodeURI(file.text());
      var URL = Object.keys(value).filter(function (key) {
        return value[key].name === filename;
      }).shift();
      target.attr('href', "".concat(external_GravAdmin_namespaceObject.config.base_url_simple, "/").concat(URL));
    });
  }
  return _createClass(FilesField, [{
    key: "initDropzone",
    value: function initDropzone() {
      var _this3 = this;
      var files = this.options.klass.container.find('[data-file]');
      var dropzone = this;
      if (!files.length) {
        return;
      }
      files.each(function (index, file) {
        file = external_jQuery_default()(file);
        var data = file.data('file');
        var mock = {
          name: data.name,
          size: data.size,
          type: data.type,
          status: (dropzone_default()).ADDED,
          accepted: true,
          url: _this3.options.url,
          removeUrl: data.remove
        };
        dropzone.files.push(mock);
        dropzone.options.addedfile.call(dropzone, mock);
        if (mock.type.match(/^image\//)) {
          dropzone.options.thumbnail.call(dropzone, mock, data.path);
          dropzone.createThumbnailFromUrl(mock, data.path);
        }
        file.remove();
      });
    }
  }, {
    key: "getURI",
    value: function getURI() {
      return this.container.data('mediaUri') || '';
    }
  }, {
    key: "onDropzoneSending",
    value: function onDropzoneSending(file, xhr, formData) {
      var _this4 = this;
      if (Object.keys(this.customPost).length) {
        Object.keys(this.customPost).forEach(function (key) {
          formData.append(key, _this4.customPost[key]);
        });
      } else {
        formData.append('name', this.options.dotNotation);
        formData.append('task', 'filesupload');
        formData.append('uri', this.getURI());
      }
      formData.append('admin-nonce', external_GravAdmin_namespaceObject.config.admin_nonce);
    }
  }, {
    key: "onDropzoneSuccess",
    value: function onDropzoneSuccess(file, response, xhr) {
      response = typeof response === 'string' ? JSON.parse(response) : response;
      if (this.options.reloadPage) {
        __webpack_require__.g.location.reload();
      }

      // store params for removing file from session before it gets saved
      if (response.session) {
        file.sessionParams = response.session;
        file.removeUrl = this.options.url;

        // Touch field value to force a mutation detection
        var input = this.container.find('[name][type="hidden"]');
        var value = input.val();
        input.val(value + ' ');
      }
      return this.handleError({
        file: file,
        data: response,
        mode: 'removeFile',
        msg: "<p>".concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.FILE_ERROR_UPLOAD, " <strong>{{fileName}}</strong></p>\n            <pre>").concat(response.message, "</pre>")
      });
    }
  }, {
    key: "onDropzoneComplete",
    value: function onDropzoneComplete(file) {
      if (!file.accepted && !file.rejected) {
        var data = {
          status: 'error',
          message: "".concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.FILE_UNSUPPORTED, ": ").concat(file.name.match(/\..+/).join(''))
        };
        return this.handleError({
          file: file,
          data: data,
          mode: 'removeFile',
          msg: "<p>".concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.FILE_ERROR_ADD, " <strong>{{fileName}}</strong></p>\n                <pre>").concat(data.message, "</pre>")
        });
      }
      if (this.options.reloadPage) {
        __webpack_require__.g.location.reload();
      }
    }
  }, {
    key: "b64_to_utf8",
    value: function b64_to_utf8(str) {
      str = str.replace(/\s/g, '');
      return decodeURIComponent(escape(window.atob(str)));
    }
  }, {
    key: "onDropzoneAddedFile",
    value: function onDropzoneAddedFile(file) {
      return this.dropzone.options.addedfile(file);
    }
  }, {
    key: "onDropzoneRemovedFile",
    value: function onDropzoneRemovedFile(file) {
      var _this5 = this;
      if (!file.accepted || file.rejected) {
        return;
      }
      var url = file.removeUrl || this.urls["delete"] || this.options.url;
      var path = (url || '').match(/path:(.*)\//);
      var body = {
        filename: file.name,
        uri: this.getURI()
      };
      if (file.sessionParams) {
        body.task = 'filessessionremove';
        body.session = file.sessionParams;
      }
      var customPost = this.container.data('filePostRemove') || {};
      if (Object.keys(customPost).length) {
        body = {};
        Object.keys(customPost).forEach(function (key) {
          body[key] = customPost[key];
        });
      }
      body['filename'] = file.name;
      body['admin-nonce'] = external_GravAdmin_namespaceObject.config.admin_nonce;
      utils_request(url, {
        method: 'post',
        body: body
      }, function () {
        if (!path) {
          return;
        }
        path = _this5.b64_to_utf8(path[1]);
        var input = _this5.container.find('[name][type="hidden"]');
        var data = JSON.parse(input.val() || '{}');
        delete data[path];
        input.val(JSON.stringify(data));
      });
    }
  }, {
    key: "onDropzoneError",
    value: function onDropzoneError(file, response, xhr) {
      var message = xhr ? response.error.message : response;
      external_jQuery_default()(file.previewElement).find('[data-dz-errormessage]').html(message);
      return this.handleError({
        file: file,
        data: {
          status: 'error'
        },
        msg: "<pre>".concat(message, "</pre>")
      });
    }
  }, {
    key: "handleError",
    value: function handleError(options) {
      var file = options.file,
        data = options.data,
        mode = options.mode,
        msg = options.msg;
      if (data.status !== 'error' && data.status !== 'unauthorized') {
        return;
      }
      switch (mode) {
        case 'addBack':
          if (file instanceof File) {
            this.dropzone.addFile.call(this.dropzone, file);
          } else {
            this.dropzone.files.push(file);
            this.dropzone.options.addedfile.call(this.dropzone, file);
            this.dropzone.options.thumbnail.call(this.dropzone, file, file.extras.url);
          }
          break;
        case 'removeFile':
        default:
          if (~this.dropzone.files.indexOf(file)) {
            file.rejected = true;
            this.dropzone.removeFile.call(this.dropzone, file, {
              silent: true
            });
          }
          break;
      }
      var modal = external_jQuery_default()('[data-remodal-id="generic"]');
      var cleanName = file.name.replace('<', '&lt;').replace('>', '&gt;');
      modal.find('.error-content').html(msg.replace('{{fileName}}', cleanName));
      (external_jQuery_default()).remodal.lookup[modal.data('remodal')].open();
    }
  }]);
}();

function UriToMarkdown(uri) {
  uri = uri.replace(/@3x|@2x|@1x/, '');
  uri = uri.replace(/\(/g, '%28');
  uri = uri.replace(/\)/g, '%29');
  var title = uri.split('.').slice(0, -1).join('.');
  return uri.match(/\.(jpe?g|png|gif|svg|webp|avif|mp4|webm|ogv|mov)$/i) ? "![".concat(title, "](").concat(uri, " \"").concat(title, "\")") : "[".concat(decodeURI(uri), "](").concat(uri, ")");
}
var instances = [];
var cache = external_jQuery_default()();
var onAddedNodes = function onAddedNodes(event, target /* , record, instance */) {
  var files = external_jQuery_default()(target).find('.dropzone.files-upload');
  if (!files.length) {
    return;
  }
  files.each(function (index, file) {
    file = external_jQuery_default()(file);
    if (!~cache.index(file)) {
      addNode(file);
    }
  });
};
var addNode = function addNode(container) {
  container = external_jQuery_default()(container);
  var input = container.find('input[type="file"]');
  var settings = container.data('grav-file-settings') || {};
  if (settings.accept && ~settings.accept.indexOf('*')) {
    settings.accept = [''];
  }
  var options = {
    url: container.data('file-url-add') || (container.closest('form').attr('action') || external_GravAdmin_namespaceObject.config.current_url) + '.json',
    paramName: settings.paramName || 'file',
    dotNotation: settings.name || 'file',
    acceptedFiles: settings.accept ? settings.accept.join(',') : input.attr('accept') || container.data('media-types'),
    maxFilesize: typeof settings.filesize !== 'undefined' ? settings.filesize : 256,
    maxFiles: settings.limit || null,
    resizeWidth: settings.resizeWidth || null,
    resizeHeight: settings.resizeHeight || null,
    resizeQuality: settings.resizeQuality || null,
    resolution: settings.resolution || null,
    accept: function accept(file, done) {
      ACCEPT_FUNC(file, done, settings);
    }
  };
  cache = cache.add(container);
  container = container[0];
  instances.push(new FilesField({
    container: container,
    options: options
  }));
};
var Instance = function () {
  external_jQuery_default()('.dropzone.files-upload').each(function (i, container) {
    return addNode(container);
  });
  external_jQuery_default()('body').on('mutation._grav', onAddedNodes);
  return instances;
}();
// EXTERNAL MODULE: ./node_modules/events/events.js
var events = __webpack_require__(37007);
var events_default = /*#__PURE__*/__webpack_require__.n(events);
;// CONCATENATED MODULE: ./app/utils/gpm.js
function gpm_typeof(o) { "@babel/helpers - typeof"; return gpm_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, gpm_typeof(o); }
function gpm_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function gpm_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, gpm_toPropertyKey(o.key), o); } }
function gpm_createClass(e, r, t) { return r && gpm_defineProperties(e.prototype, r), t && gpm_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function gpm_toPropertyKey(t) { var i = gpm_toPrimitive(t, "string"); return "symbol" == gpm_typeof(i) ? i : i + ""; }
function gpm_toPrimitive(t, r) { if ("object" != gpm_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != gpm_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == gpm_typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }



var GPM = /*#__PURE__*/function (_EventEmitter) {
  function GPM() {
    var _this;
    var action = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'getUpdates';
    gpm_classCallCheck(this, GPM);
    _this = _callSuper(this, GPM);
    _this.payload = {};
    _this.raw = {};
    _this.action = action;
    return _this;
  }
  _inherits(GPM, _EventEmitter);
  return gpm_createClass(GPM, [{
    key: "setPayload",
    value: function setPayload() {
      var payload = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.payload = payload;
      this.emit('payload', payload);
      return this;
    }
  }, {
    key: "setAction",
    value: function setAction() {
      var action = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'getUpdates';
      this.action = action;
      this.emit('action', action);
      return this;
    }
  }, {
    key: "fetch",
    value: function (_fetch) {
      function fetch() {
        return _fetch.apply(this, arguments);
      }
      fetch.toString = function () {
        return _fetch.toString();
      };
      return fetch;
    }(function () {
      var _this2 = this;
      var callback = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {
        return true;
      };
      var flush = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var data = new FormData();
      data.append('admin-nonce', external_GravAdmin_namespaceObject.config.admin_nonce);
      if (flush) {
        data.append('flush', true);
      }
      this.emit('fetching', this);
      fetch("".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/update.json/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "getUpdates"), {
        credentials: 'same-origin',
        method: 'post',
        body: data
      }).then(function (response) {
        _this2.raw = response;
        return response;
      }).then(parseStatus).then(parseJSON).then(function (response) {
        return _this2.response(response);
      }).then(function (response) {
        return callback(response, _this2.raw);
      }).then(function (response) {
        return _this2.emit('fetched', _this2.payload, _this2.raw, _this2);
      })["catch"](userFeedbackError);
    })
  }, {
    key: "response",
    value: function response(_response) {
      this.payload = _response;
      return _response;
    }
  }]);
}((events_default()));

var gpm_Instance = new GPM();
;// CONCATENATED MODULE: ./app/utils/keepalive.js
function keepalive_typeof(o) { "@babel/helpers - typeof"; return keepalive_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, keepalive_typeof(o); }
function keepalive_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function keepalive_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, keepalive_toPropertyKey(o.key), o); } }
function keepalive_createClass(e, r, t) { return r && keepalive_defineProperties(e.prototype, r), t && keepalive_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function keepalive_toPropertyKey(t) { var i = keepalive_toPrimitive(t, "string"); return "symbol" == keepalive_typeof(i) ? i : i + ""; }
function keepalive_toPrimitive(t, r) { if ("object" != keepalive_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != keepalive_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


var MAX_SAFE_DELAY = 2147483647;
var KeepAlive = /*#__PURE__*/function () {
  function KeepAlive() {
    keepalive_classCallCheck(this, KeepAlive);
    this.active = false;
  }
  return keepalive_createClass(KeepAlive, [{
    key: "start",
    value: function start() {
      var _this = this;
      var timeout = external_GravAdmin_namespaceObject.config.admin_timeout / 1.5 * 1000;
      this.timer = setInterval(function () {
        return _this.fetch();
      }, Math.min(timeout, MAX_SAFE_DELAY));
      this.active = true;
    }
  }, {
    key: "stop",
    value: function stop() {
      clearInterval(this.timer);
      this.active = false;
    }
  }, {
    key: "fetch",
    value: function (_fetch) {
      function fetch() {
        return _fetch.apply(this, arguments);
      }
      fetch.toString = function () {
        return _fetch.toString();
      };
      return fetch;
    }(function () {
      var data = new FormData();
      data.append('admin-nonce', external_GravAdmin_namespaceObject.config.admin_nonce);
      fetch("".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "keepAlive"), {
        credentials: 'same-origin',
        method: 'post',
        body: data
      })["catch"](userFeedbackError);
    })
  }]);
}();
/* harmony default export */ const keepalive = (new KeepAlive());
// EXTERNAL MODULE: ./node_modules/mout/array/unique.js
var unique = __webpack_require__(45195);
var unique_default = /*#__PURE__*/__webpack_require__.n(unique);
;// CONCATENATED MODULE: ./app/updates/notifications.js
function notifications_typeof(o) { "@babel/helpers - typeof"; return notifications_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, notifications_typeof(o); }
function notifications_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function notifications_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, notifications_toPropertyKey(o.key), o); } }
function notifications_createClass(e, r, t) { return r && notifications_defineProperties(e.prototype, r), t && notifications_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function notifications_toPropertyKey(t) { var i = notifications_toPrimitive(t, "string"); return "symbol" == notifications_typeof(i) ? i : i + ""; }
function notifications_toPrimitive(t, r) { if ("object" != notifications_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != notifications_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



var canFetchNotifications = function canFetchNotifications() {
  return external_GravAdmin_namespaceObject.config.notifications.enabled;
};
var notificationsFilters = function notificationsFilters() {
  return external_GravAdmin_namespaceObject.config.notifications.filters;
};
var Notifications = /*#__PURE__*/function () {
  function Notifications() {
    notifications_classCallCheck(this, Notifications);
  }
  return notifications_createClass(Notifications, [{
    key: "fetch",
    value:
    // Grav.default.Notifications.fetch()
    function fetch() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$filter = _ref.filter,
        filter = _ref$filter === void 0 ? notificationsFilters() : _ref$filter,
        _ref$refresh = _ref.refresh,
        refresh = _ref$refresh === void 0 ? false : _ref$refresh;
      if (!canFetchNotifications()) {
        return false;
      }
      var feed = external_jQuery_default()('#notifications');
      var loader = feed.find('.widget-loader');
      var content = feed.find('.widget-content > ul');
      loader.find('div').remove();
      loader.find('.fa-warning').removeClass('fa-warning').addClass('fa-refresh fa-spin');
      loader.show();
      content.hide();
      var processNotifications = function processNotifications(response) {
        var notifications = response.notifications;
        external_jQuery_default()('#notifications').find('.widget-content > ul').empty();
        if (notifications) {
          Object.keys(notifications).forEach(function (location) {
            return Notifications.processLocation(location, notifications[location]);
          });
        }
      };
      utils_request("".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "getNotifications"), {
        method: 'post',
        body: {
          refresh: refresh,
          filter: filter
        }
      }, function (response) {
        processNotifications(response);
      })["catch"](function () {
        var widget = external_jQuery_default()('#notifications .widget-content');
        widget.find('.widget-loader').find('div').remove();
        widget.find('.widget-loader').append('<div>Failed to retrieve notifications</div>').find('.fa-spin').removeClass('fa-spin fa-refresh').addClass('fa-warning');
      });
    }
  }], [{
    key: "addShowAllInFeed",
    value: function addShowAllInFeed() {
      external_jQuery_default()('#notifications ul').append('<li class="show-all" data-notification-action="show-all-notifications">Show all</li>');
    }
  }, {
    key: "showNotificationInFeed",
    value: function showNotificationInFeed(notification) {
      var notifications = external_jQuery_default()('#notifications').removeClass('hidden');
      var loader = notifications.find('.widget-loader').hide();
      var content = notifications.find('.widget-content > ul').show();
      loader.find('div').remove();
      loader.find('.fa-warning').removeClass('fa-warning').addClass('fa-refresh fa-spin');
      content.append(notification).find('li:nth-child(n+11)').addClass('hidden'); // hide all items > 10

      if (content.find('li.hidden').length) {
        Notifications.addShowAllInFeed();
      }
    }
  }, {
    key: "showNotificationInTop",
    value: function showNotificationInTop(notification) {
      var container = external_jQuery_default()('.top-notifications-container');
      var dummy = external_jQuery_default()('<div />').html(notification);
      container.removeClass('hidden').append(dummy.children());
      dummy.children().slideDown(150);
    }
  }, {
    key: "showNotificationInDashboard",
    value: function showNotificationInDashboard(notification) {
      var container = external_jQuery_default()('.dashboard-notifications-container');
      var dummy = external_jQuery_default()('<div />').html(notification);
      container.removeClass('hidden').append(dummy.children());
      dummy.children().slideDown(150);
    }
  }, {
    key: "showNotificationInPlugins",
    value: function showNotificationInPlugins(notification) {
      var container = external_jQuery_default()('.plugins-notifications-container');
      var dummy = external_jQuery_default()('<div />').html(notification);
      container.removeClass('hidden').append(dummy.children());
      dummy.children().slideDown(150);
    }
  }, {
    key: "showNotificationInThemes",
    value: function showNotificationInThemes(notification) {
      var container = external_jQuery_default()('.themes-notifications-container');
      var dummy = external_jQuery_default()('<div />').html(notification);
      container.removeClass('hidden').append(dummy.children());
      dummy.children().slideDown(150);
    }
  }, {
    key: "processLocation",
    value: function processLocation(location, notification) {
      switch (location) {
        case 'feed':
          Notifications.showNotificationInFeed(notification);
          break;
        case 'top':
          if (!notification.read) {
            Notifications.showNotificationInTop(notification);
          }
          break;
        case 'dashboard':
          if (!notification.read) {
            Notifications.showNotificationInDashboard(notification);
          }
          break;
        case 'plugins':
          if (!notification.read) {
            Notifications.showNotificationInPlugins(notification);
          }
          break;
        case 'themes':
          if (!notification.read) {
            Notifications.showNotificationInThemes(notification);
          }
          break;
      }
    }
  }]);
}();
var notifications = new Notifications();
/* harmony default export */ const updates_notifications = (notifications);
if (canFetchNotifications()) {
  notifications.fetch();

  /* Hide a notification and store it hidden */
  // <a href="#" data-notification-action="hide-notification" data-notification-id="${notification.id}" class="close hide-notification"><i class="fa fa-close"></i></a>
  external_jQuery_default()(document).on('click', '[data-notification-action="hide-notification"]', function (event) {
    var notification_id = external_jQuery_default()(event.target).parents('.hide-notification').data('notification-id');
    var url = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/notifications.json/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "hideNotification/notification_id").concat(external_GravAdmin_namespaceObject.config.param_sep).concat(notification_id);
    utils_request(url, {
      method: 'post'
    }, function () {});
    external_jQuery_default()(event.target).parents('.single-notification').hide();
  });
  external_jQuery_default()(document).on('click', '[data-notification-action="hide-notification"]', function (event) {
    var target = external_jQuery_default()(event.currentTarget);
    var notification = target.parent();
    notification.slideUp(function () {
      return notification.remove();
    });
  });
  external_jQuery_default()(document).on('click', '[data-notification-action="show-all-notifications"]', function (event) {
    external_jQuery_default()('#notifications .show-all').hide();
    external_jQuery_default()('#notifications .hidden').removeClass('hidden');
  });
  external_jQuery_default()(document).on('click', '[data-refresh="notifications"]', function (event) {
    event.preventDefault();
    notifications.fetch({
      filter: ['feed'],
      refresh: true
    });
  });
}
;// CONCATENATED MODULE: ./app/updates/feed.js
function feed_typeof(o) { "@babel/helpers - typeof"; return feed_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, feed_typeof(o); }
function feed_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function feed_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, feed_toPropertyKey(o.key), o); } }
function feed_createClass(e, r, t) { return r && feed_defineProperties(e.prototype, r), t && feed_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function feed_toPropertyKey(t) { var i = feed_toPrimitive(t, "string"); return "symbol" == feed_typeof(i) ? i : i + ""; }
function feed_toPrimitive(t, r) { if ("object" != feed_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != feed_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



var URI = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/ajax.json/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "getNewsFeed");
var Feed = /*#__PURE__*/function () {
  function Feed() {
    feed_classCallCheck(this, Feed);
    this.data = null;
  }
  return feed_createClass(Feed, [{
    key: "fetch",
    value: function fetch() {
      var _this = this;
      var refresh = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function () {};
      utils_request(URI, {
        method: 'post',
        body: {
          refresh: refresh
        }
      }, function (response) {
        _this.data = response;
        callback(response);
      });
    }
  }, {
    key: "refresh",
    value: function refresh() {
      var _refresh = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var feed = external_jQuery_default()('#news-feed .widget-content');
      if (!feed.length) {
        return;
      }
      var loader = feed.find('.widget-loader');
      loader.find('div').remove();
      loader.find('.fa-warning').removeClass('fa-warning').addClass('fa-refresh fa-spin');
      loader.show();
      feed.find('> ul').hide();
      if (!this.data || this.data.error || _refresh) {
        this.fetch(_refresh, this.updateContent.bind(this));
      } else {
        this.updateContent();
      }
    }
  }, {
    key: "updateContent",
    value: function updateContent() {
      var feed = external_jQuery_default()('#news-feed .widget-content');
      if (!feed.length) {
        return;
      }
      var loader = feed.find('.widget-loader').hide();
      var content = feed.find('> ul').empty().show();
      if (this.data.error || this.data.status === 'error') {
        loader.show().find('div').remove();
        loader.find('.fa-refresh').removeClass('fa-refresh fa-spin').addClass('fa-warning');
        loader.append("<div>".concat(this.data.error ? this.data.error.message : this.data.message || 'Unable to download news feed', "</div>"));
        return;
      }
      if (this.data && this.data.feed_data) {
        content.append(this.data.feed_data);
      }
    }
  }]);
}();
var feed = new Feed();
external_jQuery_default()(document).ready(function () {
  return feed.refresh();
});
external_jQuery_default()(document).on('click', '[data-refresh="feed"]', function (event) {
  event.preventDefault();
  feed.refresh(true);
});
/* harmony default export */ const updates_feed = (feed);
;// CONCATENATED MODULE: ./app/updates/check.js





// Check for updates trigger
external_jQuery_default()('[data-gpm-checkupdates]').on('click', function () {
  var element = external_jQuery_default()(this);
  element.find('i').addClass('fa-spin');
  gpm_Instance.fetch(function (response) {
    element.find('i').removeClass('fa-spin');
    var payload = response.payload;
    if (!payload) {
      return;
    }
    if (!payload.grav.isUpdatable && !payload.resources.total) {
      utils_toastr.success(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.EVERYTHING_UP_TO_DATE);
    } else {
      var grav = payload.grav.isUpdatable ? 'Grav v' + payload.grav.available : '';
      var resources = payload.resources.total ? payload.resources.total + ' ' + external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.UPDATES_ARE_AVAILABLE : '';
      if (!resources) {
        grav += ' ' + external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.IS_AVAILABLE_FOR_UPDATE;
      }
      utils_toastr.info(grav + (grav && resources ? ' ' + external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.AND + ' ' : '') + resources);
    }
  }, true);
});
;// CONCATENATED MODULE: ./app/utils/formatbytes.js
var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
function formatBytes(bytes, decimals) {
  if (bytes === 0) return '0 Byte';
  var k = 1000;
  var value = Math.floor(Math.log(bytes) / Math.log(k));
  var decimal = decimals + 1 || 3;
  return (bytes / Math.pow(k, value)).toPrecision(decimal) + ' ' + sizes[value];
}
;// CONCATENATED MODULE: ./app/updates/update.js






// Dashboard update and Grav update
external_jQuery_default()(document).on('click.remodal', '[data-remodal-id="update-grav"] [data-remodal-action="confirm"]', function () {
  var element = external_jQuery_default()('#grav-update-button');

  // Safely get the file size with fallback
  var sizeText = '';
  if (updates_Instance.payload && updates_Instance.payload.grav && updates_Instance.payload.grav.assets && updates_Instance.payload.grav.assets['grav-update'] && updates_Instance.payload.grav.assets['grav-update'].size) {
    sizeText = " ".concat(formatBytes(updates_Instance.payload.grav.assets['grav-update'].size));
  }
  element.html("".concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.UPDATING_PLEASE_WAIT).concat(sizeText, ".."));
  element.attr('disabled', 'disabled').find('> .fa').removeClass('fa-cloud-download').addClass('fa-refresh fa-spin');
  utils_request(updates_Instance.updateURL, function (response) {
    if (response.type === 'updategrav') {
      external_jQuery_default()('[data-gpm-grav]').remove();
      external_jQuery_default()('#footer .grav-version').html(response.version);
    }
    element.removeAttr('disabled').find('> .fa').removeClass('fa-refresh fa-spin').addClass('fa-cloud-download');
  });
});
;// CONCATENATED MODULE: ./app/updates/channel-switcher.js


var switcher = external_jQuery_default()('input[type="radio"][name="channel-switch"]');
if (switcher) {
  switcher.on('change', function (event) {
    var radio = external_jQuery_default()(event.target);
    var url = "".concat(radio.parent('[data-url]').data('url'));
    utils_request(url, {
      method: 'post',
      body: {
        task: 'gpmRelease',
        release: radio.val()
      }
    }, function (response) {
      if (response.reload) {
        __webpack_require__.g.location.reload();
      }
    });
  });
}
;// CONCATENATED MODULE: ./app/updates/index.js
function updates_typeof(o) { "@babel/helpers - typeof"; return updates_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, updates_typeof(o); }
function updates_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function updates_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, updates_toPropertyKey(o.key), o); } }
function updates_createClass(e, r, t) { return r && updates_defineProperties(e.prototype, r), t && updates_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function updates_toPropertyKey(t) { var i = updates_toPrimitive(t, "string"); return "symbol" == updates_typeof(i) ? i : i + ""; }
function updates_toPrimitive(t, r) { if ("object" != updates_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != updates_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }









var Updates = /*#__PURE__*/function () {
  function Updates() {
    var payload = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    updates_classCallCheck(this, Updates);
    this.setPayload(payload);
    this.task = "task".concat(external_GravAdmin_namespaceObject.config.param_sep);
    this.updateURL = '';
  }
  return updates_createClass(Updates, [{
    key: "setPayload",
    value: function setPayload() {
      var payload = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.payload = payload;
      return this;
    }
  }, {
    key: "fetch",
    value: function fetch() {
      var _this = this;
      var force = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      gpm_Instance.fetch(function (response) {
        return _this.setPayload(response);
      }, force);
      return this;
    }
  }, {
    key: "maintenance",
    value: function maintenance() {
      var mode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'hide';
      var element = external_jQuery_default()('#updates [data-update-packages]');
      element[mode === 'show' ? 'fadeIn' : 'fadeOut']();
      if (mode === 'hide') {
        external_jQuery_default()('.badges.with-updates').removeClass('with-updates').find('.badge.updates').remove();
      }
      return this;
    }
  }, {
    key: "grav",
    value: function grav() {
      var payload = this.payload.grav;
      if (payload && payload.isUpdatable) {
        var task = this.task;
        var bar = '';
        if (!payload.isSymlink) {
          this.updateURL = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/update.json/").concat(task, "updategrav/admin-nonce").concat(external_GravAdmin_namespaceObject.config.param_sep).concat(external_GravAdmin_namespaceObject.config.admin_nonce);
          bar += "<button data-remodal-target=\"update-grav\" class=\"button button-small secondary pointer-events-none\" id=\"grav-update-button\">".concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.UPDATE_GRAV_NOW, " <span class=\"cnt-down\">(5s)</span></button>");
        } else {
          bar += "<span class=\"hint--left\" style=\"float: right;\" data-hint=\"".concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.GRAV_SYMBOLICALLY_LINKED, "\"><i class=\"fa fa-fw fa-link\"></i></span>");
        }
        bar += "\n                Grav <b>v".concat(payload.available, "</b> ").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.IS_NOW_AVAILABLE, "! <span class=\"less\">(").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.CURRENT, " v").concat(payload.version, ")</span>\n            ");
        var element = external_jQuery_default()('[data-gpm-grav]').removeClass('hidden');
        if (element.is(':empty')) {
          element.hide();
        }
        element.addClass('grav').html("".concat(bar)).slideDown(150, function () {
          var c = 5;
          var x = setInterval(function () {
            c -= 1;
            element.find('.pointer-events-none .cnt-down').text('(' + c + 's)');
          }, 1000);
          setTimeout(function () {
            clearInterval(x);
            element.find('.pointer-events-none .cnt-down').remove();
            element.find('.pointer-events-none').removeClass('pointer-events-none');
          }, 5000);
        }).parent('#messages').addClass('default-box-shadow');
      }
      return this;
    }
  }, {
    key: "resources",
    value: function resources() {
      if (!this.payload || !this.payload.resources || !this.payload.resources.total) {
        return this.maintenance('hide');
      }
      var is_current_package_latest = true;
      var map = ['plugins', 'themes'];
      var singles = ['plugin', 'theme'];
      var _this$payload$resourc = this.payload.resources,
        plugins = _this$payload$resourc.plugins,
        themes = _this$payload$resourc.themes;
      if (!this.payload.resources.total) {
        return this;
      }
      [plugins, themes].forEach(function (resources, index) {
        if (!resources || Array.isArray(resources) || updates_typeof(resources) !== 'object') {
          return;
        }
        var length = Object.keys(resources).length;
        var type = map[index];

        // sidebar
        external_jQuery_default()("#admin-menu a[href$=\"/".concat(map[index], "\"]")).find('.badges').addClass('with-updates').find('.badge.updates').text(length);
        var type_translation = '';
        // update all

        if (type === 'plugins') {
          type_translation = external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.PLUGINS;
        } else {
          type_translation = external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.THEMES;
        }
        var updateAll = external_jQuery_default()(".grav-update.".concat(type));
        updateAll.css('display', 'block').html("\n            <p>\n                <a href=\"#\" class=\"button button-small secondary\" data-remodal-target=\"update-packages\" data-packages-slugs=\"".concat(Object.keys(resources).join(), "\" data-").concat(singles[index], "-action=\"start-packages-update\">").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.UPDATE, " ").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.ALL, " ").concat(type_translation, "</a>\n                <i class=\"fa fa-bullhorn\"></i>\n                ").concat(length, " ").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.OF_YOUR, " ").concat(type_translation.toLowerCase(), " ").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.HAVE_AN_UPDATE_AVAILABLE, "\n            </p>\n            "));
        var existing_slugs = external_jQuery_default()('[data-update-packages]').attr('data-packages-slugs') || '';
        if (existing_slugs) {
          existing_slugs = existing_slugs.split(',');
        } else {
          existing_slugs = [];
        }
        var slugs = unique_default()(existing_slugs.concat(Object.keys(resources))).join();
        external_jQuery_default()('[data-update-packages]').attr('data-packages-slugs', "".concat(slugs));
        Object.keys(resources).forEach(function (item) {
          // listing page
          var container = external_jQuery_default()("[data-gpm-".concat(singles[index], "=\"").concat(item, "\"]"));
          var element = container.find('.gpm-name');
          var url = element.find('a');
          var content_wrapper = container.parents('.content-wrapper');
          if (type === 'plugins' && !element.find('.badge.update').length) {
            element.append("<a class=\"plugin-update-button\" href=\"".concat(url.attr('href'), "\"><span class=\"badge update\">").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.UPDATE_AVAILABLE, "!</span></a>"));
            content_wrapper.addClass('has-updates');
          } else if (type === 'themes') {
            element.append("<div class=\"gpm-ribbon\"><a href=\"".concat(url.attr('href'), "\">").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.UPDATE.toUpperCase(), "</a></div>"));
            content_wrapper.addClass('has-updates');
          }

          // details page
          if (container.length) {
            var details = external_jQuery_default()(".grav-update.".concat(singles[index]));
            if (details.length) {
              var releaseType = resources[item].type === 'testing' ? '<span class="gpm-testing">test release</span>' : '';
              details.html("\n                            <p>\n                                <a href=\"#\" class=\"button button-small secondary\" data-remodal-target=\"update-packages\" data-packages-slugs=\"".concat(item, "\" data-").concat(singles[index], "-action=\"start-package-installation\">").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.UPDATE, " ").concat(singles[index].charAt(0).toUpperCase() + singles[index].substr(1).toLowerCase(), "</a>\n                                <i class=\"fa fa-bullhorn\"></i>\n                                <strong>v").concat(resources[item].available, "</strong> ").concat(releaseType, " ").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.OF_THIS, " ").concat(singles[index], " ").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.IS_NOW_AVAILABLE, "!\n                            </p>\n                        ")).css('display', 'block');
              is_current_package_latest = false;
            }
          }
        });
        external_jQuery_default()('[data-update-packages]').removeClass('hidden');
      });
      external_jQuery_default()('.content-wrapper').addClass('updates-checked');
      if (!is_current_package_latest) {
        external_jQuery_default()('.warning-reinstall-not-latest-release').removeClass('hidden');
      }
    }
  }]);
}();

var updates_Instance = new Updates();


// automatically refresh UI for updates (graph, sidebar, plugin/themes pages) after every fetch
gpm_Instance.on('fetched', function (response, raw) {
  updates_Instance.setPayload(response.payload || {});
  updates_Instance.grav().resources();
});
if (external_GravAdmin_namespaceObject.config.enable_auto_updates_check === '1') {
  gpm_Instance.fetch();
}
// EXTERNAL MODULE: ./node_modules/chartist/dist/chartist.js
var chartist = __webpack_require__(9592);
var chartist_default = /*#__PURE__*/__webpack_require__.n(chartist);
;// CONCATENATED MODULE: ./app/dashboard/chart.js
function chart_callSuper(t, o, e) { return o = chart_getPrototypeOf(o), chart_possibleConstructorReturn(t, chart_isNativeReflectConstruct() ? Reflect.construct(o, e || [], chart_getPrototypeOf(t).constructor) : o.apply(t, e)); }
function chart_possibleConstructorReturn(t, e) { if (e && ("object" == chart_typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return chart_assertThisInitialized(t); }
function chart_assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function chart_isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (chart_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = chart_getPrototypeOf(t));); return t; }
function chart_getPrototypeOf(t) { return chart_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, chart_getPrototypeOf(t); }
function chart_inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && chart_setPrototypeOf(t, e); }
function chart_setPrototypeOf(t, e) { return chart_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, chart_setPrototypeOf(t, e); }
function chart_typeof(o) { "@babel/helpers - typeof"; return chart_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, chart_typeof(o); }
function chart_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function chart_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, chart_toPropertyKey(o.key), o); } }
function chart_createClass(e, r, t) { return r && chart_defineProperties(e.prototype, r), t && chart_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function chart_toPropertyKey(t) { var i = chart_toPrimitive(t, "string"); return "symbol" == chart_typeof(i) ? i : i + ""; }
function chart_toPrimitive(t, r) { if ("object" != chart_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != chart_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }






// let isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;

var defaults = {
  data: {
    series: [100, 0]
  },
  options: {
    Pie: {
      donut: true,
      donutWidth: 10,
      startAngle: 0,
      total: 100,
      showLabel: false,
      height: 150,
      // chartPadding: !isFirefox ? 10 : 25 // workaround for older versions of firefox
      chartPadding: 5
    },
    Bar: {
      height: 164,
      chartPadding: 20,
      // workaround for older versions of firefox

      axisX: {
        showGrid: false,
        labelOffset: {
          x: 0,
          y: 0
        }
      },
      axisY: {
        offset: 15,
        showLabel: true,
        showGrid: true,
        labelOffset: {
          x: 5,
          y: 5
        },
        scaleMinSpace: 25
      }
    }
  }
};
var Chart = /*#__PURE__*/function () {
  function Chart(element) {
    var _this = this;
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    chart_classCallCheck(this, Chart);
    this.element = external_jQuery_default()(element) || [];
    if (!this.element[0]) {
      return;
    }
    var type = (this.element.data('chart-type') || 'pie').toLowerCase();
    this.type = type.charAt(0).toUpperCase() + type.substr(1).toLowerCase();
    options = Object.assign({}, defaults.options[this.type], options);
    data = Object.assign({}, defaults.data, data);
    Object.assign(this, {
      options: options,
      data: data
    });
    this.chart = (chartist_default())[this.type](this.element.find('.ct-chart').empty()[0], this.data, this.options);
    this.chart.on('created', function () {
      _this.element.find('.hidden').removeClass('hidden');

      // FIX: workaround for chartist issue not allowing HTML in labels anymore
      // https://github.com/gionkunz/chartist-js/issues/937
      _this.element.find('.ct-label').each(function (index, label) {
        label = external_jQuery_default()(label);
        var text = label.html().replace('&lt;', '<').replace('&gt;', '>');
        label.html(text);
      });
    });
  }
  return chart_createClass(Chart, [{
    key: "updateData",
    value: function updateData(data) {
      Object.assign(this.data, data);
      this.chart.update(this.data);
    }
  }]);
}();

;
var UpdatesChart = /*#__PURE__*/function (_Chart) {
  function UpdatesChart(element) {
    var _this2;
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    chart_classCallCheck(this, UpdatesChart);
    _this2 = chart_callSuper(this, UpdatesChart, [element, options, data]);
    _this2.chart.on('draw', function (data) {
      return _this2.draw(data);
    });
    gpm_Instance.on('fetched', function (response) {
      if (!response.payload) {
        return;
      }
      var payload = response.payload.grav;
      var missing = (response.payload.resources.total + (payload.isUpdatable ? 1 : 0)) * 100 / (response.payload.installed + (payload.isUpdatable ? 1 : 0));
      var updated = 100 - missing;
      _this2.updateData({
        series: [updated, missing]
      });
      if (response.payload.resources.total) {
        updates_Instance.maintenance('show');
      }
    });
    return _this2;
  }
  chart_inherits(UpdatesChart, _Chart);
  return chart_createClass(UpdatesChart, [{
    key: "draw",
    value: function draw(data) {
      if (data.index) {
        return;
      }
      var notice = external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN[data.value === 100 ? 'FULLY_UPDATED' : 'UPDATES_AVAILABLE'];
      this.element.find('.numeric span').text("".concat(Math.round(data.value), "%"));
      this.element.find('.js__updates-available-description').html(notice);
      this.element.find('.hidden').removeClass('hidden');
    }
  }, {
    key: "updateData",
    value: function updateData(data) {
      _get(chart_getPrototypeOf(UpdatesChart.prototype), "updateData", this).call(this, data);

      // missing updates
      if (this.data.series[0] < 100) {
        this.element.closest('#updates').find('[data-update-packages]').fadeIn();
      }
    }
  }]);
}(Chart);
var charts = {};
external_jQuery_default()('[data-chart-name]').each(function () {
  var element = external_jQuery_default()(this);
  var name = element.data('chart-name') || '';
  var options = element.data('chart-options') || {};
  var data = element.data('chart-data') || {};
  if (name === 'updates') {
    charts[name] = new UpdatesChart(element, options, data);
  } else {
    charts[name] = new Chart(element, options, data);
  }
});
var Instances = charts;
;// CONCATENATED MODULE: ./app/dashboard/cache.js
function cache_typeof(o) { "@babel/helpers - typeof"; return cache_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, cache_typeof(o); }
function cache_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function cache_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, cache_toPropertyKey(o.key), o); } }
function cache_createClass(e, r, t) { return r && cache_defineProperties(e.prototype, r), t && cache_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function cache_toPropertyKey(t) { var i = cache_toPrimitive(t, "string"); return "symbol" == cache_typeof(i) ? i : i + ""; }
function cache_toPrimitive(t, r) { if ("object" != cache_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != cache_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



var getUrl = function getUrl() {
  var type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  if (type) {
    type = "cleartype:".concat(type, "/");
  }
  return "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/cache.json/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "clearCache/").concat(type, "admin-nonce").concat(external_GravAdmin_namespaceObject.config.param_sep).concat(external_GravAdmin_namespaceObject.config.admin_nonce);
};
var Cache = /*#__PURE__*/function () {
  function Cache() {
    var _this = this;
    cache_classCallCheck(this, Cache);
    this.element = external_jQuery_default()('[data-clear-cache]');
    external_jQuery_default()('body').on('click', '[data-clear-cache]', function (event) {
      return _this.clear(event, event.target);
    });
  }
  return cache_createClass(Cache, [{
    key: "clear",
    value: function clear(event, element) {
      var _this2 = this;
      var type = '';
      if (event && event.preventDefault) {
        event.preventDefault();
      }
      if (typeof event === 'string') {
        type = event;
      }
      element = element ? external_jQuery_default()(element) : external_jQuery_default()("[data-clear-cache-type=\"".concat(type, "\"]"));
      type = type || external_jQuery_default()(element).data('clear-cache-type') || '';
      var url = element.data('clearCache') || getUrl(type);
      this.disable();
      utils_request(url, function () {
        return _this2.enable();
      });
    }
  }, {
    key: "enable",
    value: function enable() {
      this.element.removeAttr('disabled').find('> .fa').removeClass('fa-refresh fa-spin fa-retweet').addClass('fa-retweet');
    }
  }, {
    key: "disable",
    value: function disable() {
      this.element.attr('disabled', 'disabled').find('> .fa').removeClass('fa-retweet').addClass('fa-refresh fa-spin');
    }
  }]);
}();

var cache_Instance = new Cache();

;// CONCATENATED MODULE: ./app/dashboard/backup.js




external_jQuery_default()('[data-backup][data-ajax*="backup/"]').on('click', function () {
  var element = external_jQuery_default()(this);
  var url = element.data('ajax');
  var inDropdown = element.closest('.dropdown-menu');
  (inDropdown.length ? inDropdown : element).closest('.button-group').find('> button:first').attr('disabled', 'disabled').find('> .fa').removeClass('fa-life-ring').addClass('fa-spin fa-refresh');
  utils_request(url, function /* response */
  () {
    if (Instances && Instances.backups) {
      Instances.backups.updateData({
        series: [0, 100]
      });
      Instances.backups.element.find('.numeric').html("0 <em>".concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DAYS.toLowerCase(), "</em>"));
    }
    (inDropdown.length ? inDropdown : element).closest('.button-group').find('> button:first').removeAttr('disabled').find('> .fa').removeClass('fa-spin fa-refresh').addClass('fa-life-ring');
  });
});
external_jQuery_default()('[data-backup][data-ajax*="backupDelete"]').on('click', function () {
  var element = external_jQuery_default()(this);
  var url = element.data('ajax');
  var tr = element.closest('tr');
  tr.addClass('deleting');
  utils_request(url, function (response) {
    if (response.status === 'success') {
      tr.remove();
    } else {
      tr.removeClass('deleting');
    }
  });
});
;// CONCATENATED MODULE: ./app/dashboard/index.js



/* harmony default export */ const dashboard = ({
  Chart: {
    Chart: Chart,
    UpdatesChart: UpdatesChart,
    Instances: Instances
  },
  Cache: cache_Instance
});
// EXTERNAL MODULE: ./node_modules/sortablejs/modular/sortable.esm.js
var sortable_esm = __webpack_require__(10246);
// EXTERNAL MODULE: ./node_modules/debounce/index.js
var debounce = __webpack_require__(17334);
var debounce_default = /*#__PURE__*/__webpack_require__.n(debounce);
// EXTERNAL MODULE: ./app/utils/storage.js
var storage = __webpack_require__(95851);
;// CONCATENATED MODULE: ./app/pages/tree.js
function tree_typeof(o) { "@babel/helpers - typeof"; return tree_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, tree_typeof(o); }
function tree_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function tree_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, tree_toPropertyKey(o.key), o); } }
function tree_createClass(e, r, t) { return r && tree_defineProperties(e.prototype, r), t && tree_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function tree_toPropertyKey(t) { var i = tree_toPrimitive(t, "string"); return "symbol" == tree_typeof(i) ? i : i + ""; }
function tree_toPrimitive(t, r) { if ("object" != tree_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != tree_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


var sessionKey = 'grav:admin:pages';
if (!sessionStorage.getItem(sessionKey)) {
  sessionStorage.setItem(sessionKey, '{}');
}
var PagesTree = /*#__PURE__*/function () {
  function PagesTree(query) {
    var _this = this;
    var elements = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;
    tree_classCallCheck(this, PagesTree);
    this.query = query;
    this.elements = external_jQuery_default()(elements !== undefined ? elements : this.query);
    this.session = JSON.parse(sessionStorage.getItem(sessionKey) || '{}');
    if (!this.elements.length) {
      return;
    }
    this.restore();
    this.elements.find('.page-icon').on('click', function (event) {
      return _this.toggle(event.target);
    });
    this.elements.data('tree_init', 1);
    external_jQuery_default()('[data-page-toggleall]').on('click', function (event) {
      var element = external_jQuery_default()(event.target).closest('[data-page-toggleall]');
      var action = element.data('page-toggleall');
      _this[action]();
    });
  }
  return tree_createClass(PagesTree, [{
    key: "reload",
    value: function reload() {
      var elements = external_jQuery_default()(this.query).filter(function (index, element) {
        return !external_jQuery_default()(element).data('tree_init');
      });
      if (!elements.length) {
        return;
      }
      this.constructor(this.query, elements);
    }
  }, {
    key: "toggle",
    value: function toggle(elements) {
      var _this2 = this;
      var dontStore = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (typeof elements === 'string') {
        elements = external_jQuery_default()("[data-nav-id=\"".concat(elements, "\"]")).find('[data-toggle="children"]');
      }
      elements = external_jQuery_default()(elements || this.elements);
      elements.each(function (index, element) {
        element = external_jQuery_default()(element);
        var state = _this2.getState(element.closest('[data-toggle="children"]'));
        _this2[state.isOpen ? 'collapse' : 'expand'](state.id, dontStore);
      });
    }
  }, {
    key: "collapse",
    value: function collapse(elements) {
      var _this3 = this;
      var dontStore = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (typeof elements === 'string') {
        elements = external_jQuery_default()("[data-nav-id=\"".concat(elements, "\"]")).find('[data-toggle="children"]');
      }
      elements = external_jQuery_default()(elements || this.elements);
      elements.each(function (index, element) {
        element = external_jQuery_default()(element);
        var state = _this3.getState(element);
        if (state.isOpen) {
          state.children.hide();
          state.icon.removeClass('children-open').addClass('children-closed');
          if (!dontStore) {
            delete _this3.session[state.id];
          }
        }
      });
      if (!dontStore) {
        this.save();
      }
    }
  }, {
    key: "expand",
    value: function expand(elements) {
      var _this4 = this;
      var dontStore = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (typeof elements === 'string') {
        var element = external_jQuery_default()("[data-nav-id=\"".concat(elements, "\"]"));
        var parents = element.parents('[data-nav-id]');

        // loop back through parents, we don't want to expand an hidden child
        if (parents.length) {
          parents = parents.find('[data-toggle="children"]:first');
          parents = parents.add(element.find('[data-toggle="children"]:first'));
          return this.expand(parents, dontStore);
        }
        elements = element.find('[data-toggle="children"]:first');
      }
      elements = external_jQuery_default()(elements || this.elements);
      elements.each(function (index, element) {
        element = external_jQuery_default()(element);
        var state = _this4.getState(element);
        if (!state.isOpen) {
          state.children.show();
          state.icon.removeClass('children-closed').addClass('children-open');
          if (!dontStore) {
            _this4.session[state.id] = 1;
          }
        }
      });
      if (!dontStore) {
        this.save();
      }
    }
  }, {
    key: "restore",
    value: function restore() {
      var _this5 = this;
      this.collapse(null, true);
      Object.keys(this.session).forEach(function (key) {
        _this5.expand(key, 'no-store');
      });
    }
  }, {
    key: "save",
    value: function save() {
      return sessionStorage.setItem(sessionKey, JSON.stringify(this.session));
    }
  }, {
    key: "getState",
    value: function getState(element) {
      element = external_jQuery_default()(element);
      return {
        id: element.closest('[data-nav-id]').data('nav-id'),
        children: element.closest('li.page-item').find('ul:first'),
        icon: element.find('.page-icon'),
        get isOpen() {
          return this.icon.hasClass('children-open');
        }
      };
    }
  }]);
}();

var tree_Instance = new PagesTree('[data-toggle="children"]');

// EXTERNAL MODULE: ./node_modules/selectize/dist/js/selectize.js
var selectize = __webpack_require__(72890);
var selectize_default = /*#__PURE__*/__webpack_require__.n(selectize);
;// CONCATENATED MODULE: ./app/utils/selectize-required-fix.js
/**
 * This is a plugin to override the `.refreshValidityState` method of
 * the Selectize library (https://selectize.github.io/selectize.js/).
 * The library is not maintained anymore (as of 2017-09-13) and contains
 * a bug which causes Microsoft Edge to not work with selectized [required]
 * form fields. This plugin should be removed if
 * https://github.com/selectize/selectize.js/pull/1320 is ever merged
 * and a new version of Selectize gets released.
 */


selectize_default().define('required-fix', function (options) {
  var _this = this;
  this.refreshValidityState = function () {
    if (!_this.isRequired) return false;
    var invalid = !_this.items.length;
    _this.isInvalid = invalid;
    if (invalid) {
      _this.$control_input.attr('required', '');
      _this.$input.removeAttr('required');
    } else {
      _this.$control_input.removeAttr('required');
      _this.$input.attr('required');
    }
  };
});
;// CONCATENATED MODULE: ./app/pages/filter.js
function filter_typeof(o) { "@babel/helpers - typeof"; return filter_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, filter_typeof(o); }
function filter_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function filter_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, filter_toPropertyKey(o.key), o); } }
function filter_createClass(e, r, t) { return r && filter_defineProperties(e.prototype, r), t && filter_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function filter_toPropertyKey(t) { var i = filter_toPrimitive(t, "string"); return "symbol" == filter_typeof(i) ? i : i + ""; }
function filter_toPrimitive(t, r) { if ("object" != filter_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != filter_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }









/* @formatter:off */
/* eslint-disable */
var options = [{
  flag: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.MODULE,
  key: 'Module',
  cat: 'mode'
}, {
  flag: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.VISIBLE,
  key: 'Visible',
  cat: 'mode'
}, {
  flag: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.ROUTABLE,
  key: 'Routable',
  cat: 'mode'
}, {
  flag: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.PUBLISHED,
  key: 'Published',
  cat: 'mode'
}, {
  flag: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.NON_MODULE,
  key: 'NonModule',
  cat: 'mode'
}, {
  flag: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.NON_VISIBLE,
  key: 'NonVisible',
  cat: 'mode'
}, {
  flag: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.NON_ROUTABLE,
  key: 'NonRoutable',
  cat: 'mode'
}, {
  flag: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.NON_PUBLISHED,
  key: 'NonPublished',
  cat: 'mode'
}];
/* @formatter:on */
/* eslint-enable */
var PagesFilter = /*#__PURE__*/function () {
  function PagesFilter(filters, search) {
    var _this = this;
    filter_classCallCheck(this, PagesFilter);
    this.filters = external_jQuery_default()(filters);
    this.search = external_jQuery_default()(search);
    this.options = options;
    this.tree = tree_Instance;
    var storage = JSON.parse(localStorage.getItem('grav:admin:pages:filter') || '{}');
    if (!this.filters.length || !this.search.length) {
      return;
    }
    this.labels = this.filters.data('filter-labels');
    this.search.on('input', debounce_default()(function () {
      return _this.filter();
    }, 250));
    this.filters.on('change', function () {
      return _this.filter();
    });

    // restore state
    if (storage.flags || storage.query) {
      this.setValues(storage);
      this.filter();
    }
    this._initSelectize();
  }
  return filter_createClass(PagesFilter, [{
    key: "filter",
    value: function filter(value) {
      var _this2 = this;
      var data = {
        flags: '',
        query: ''
      };
      if (filter_typeof(value) === 'object') {
        Object.assign(data, value);
      }
      if (typeof value === 'string') {
        data.query = value;
      }
      if (typeof value === 'undefined') {
        data.flags = this.filters.val();
        data.query = this.search.val();
      }
      if (!Object.keys(data).filter(function (key) {
        return data[key] !== '';
      }).length) {
        this.resetValues();
        return;
      }
      data.flags = data.flags.replace(/(\s{1,})?,(\s{1,})?/g, ',');
      this.setValues({
        flags: data.flags,
        query: data.query
      }, 'silent');
      utils_request("".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/pages-filter.json/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "filterPages"), {
        method: 'post',
        body: data
      }, function (response) {
        _this2.refreshDOM(response);
      });
    }
  }, {
    key: "refreshDOM",
    value: function refreshDOM(response) {
      var _this3 = this;
      var items = external_jQuery_default()('[data-nav-id]');
      if (!response) {
        items.removeClass('search-match').show();
        this.tree.restore();
        return;
      }
      items.removeClass('search-match').hide();
      response.results.forEach(function (page) {
        var match = items.filter("[data-nav-id=\"".concat(page, "\"]")).addClass('search-match').show();
        match.parents('[data-nav-id]').addClass('search-match').show();
        _this3.tree.expand(page, 'no-store');
      });
    }
  }, {
    key: "setValues",
    value: function setValues(_ref, silent) {
      var _ref$flags = _ref.flags,
        flags = _ref$flags === void 0 ? '' : _ref$flags,
        _ref$query = _ref.query,
        query = _ref$query === void 0 ? '' : _ref$query;
      var flagsArray = flags.replace(/(\s{1,})?,(\s{1,})?/g, ',').split(',');
      if (this.filters.val() !== flags) {
        var selectize = this.filters.data('selectize');
        this.filters[selectize ? 'setValue' : 'val'](flagsArray, silent);
      }
      if (this.search.val() !== query) {
        this.search.val(query);
      }
      localStorage.setItem('grav:admin:pages:filter', JSON.stringify({
        flags: flags,
        query: query
      }));
    }
  }, {
    key: "resetValues",
    value: function resetValues() {
      this.setValues('', 'silent');
      this.refreshDOM();
    }
  }, {
    key: "_initSelectize",
    value: function _initSelectize() {
      var _this4 = this;
      var extras = {
        type: this.filters.data('filter-types') || {},
        access: this.filters.data('filter-access-levels') || {}
      };
      Object.keys(extras).forEach(function (cat) {
        Object.keys(extras[cat]).forEach(function (key) {
          _this4.options.push({
            cat: cat,
            key: key,
            flag: extras[cat][key]
          });
        });
      });
      this.filters.selectize({
        maxItems: null,
        valueField: 'key',
        labelField: 'flag',
        searchField: ['flag', 'key'],
        options: this.options,
        optgroups: this.labels,
        optgroupField: 'cat',
        optgroupLabelField: 'name',
        optgroupValueField: 'id',
        optgroupOrder: this.labels.map(function (item) {
          return item.id;
        }),
        plugins: ['optgroup_columns', 'required-fix']
      });
    }
  }]);
}();

var filter_Instance = new PagesFilter('input[name="page-filter"]', 'input[name="page-search"]');

// EXTERNAL MODULE: ./node_modules/speakingurl/index.js
var speakingurl = __webpack_require__(91264);
var speakingurl_default = /*#__PURE__*/__webpack_require__.n(speakingurl);
;// CONCATENATED MODULE: ./app/utils/jquery-utils.js
var _this = undefined;



// jQuery no parents filter
(external_jQuery_default()).expr[':']['noparents'] = external_jQuery_default().expr.createPseudo(function (text) {
  return function (element) {
    return external_jQuery_default()(element).parents(text).length < 1;
  };
});

// Slugify
// CommonJS and ES6 version of https://github.com/madflow/jquery-slugify
(external_jQuery_default()).fn.slugify = function (source, options) {
  return _this.each(function (element) {
    var target = external_jQuery_default()(element);
    var source = external_jQuery_default()(source);
    target.on('keyup change', function () {
      target.data('locked', target.val() !== '' && target.val() !== undefined);
    });
    source.on('keyup change', function () {
      if (target.data('locked') === true) {
        return true;
      }
      var isInput = target.is('input') || target.is('textarea');
      target[isInput ? 'val' : 'text'](external_jQuery_default().slugify(source.val(), options));
    });
  });
};

// Static method.
(external_jQuery_default()).slugify = function (sourceString, options) {
  options = external_jQuery_default().extend({}, (external_jQuery_default()).slugify.options, options);
  options.lang = options.lang || external_jQuery_default()('html').prop('lang');
  if (typeof options.preSlug === 'function') {
    sourceString = options.preSlug(sourceString);
  }
  sourceString = options.slugFunc(sourceString, options);
  if (typeof options.postSlug === 'function') {
    sourceString = options.postSlug(sourceString);
  }
  return sourceString;
};

// Default plugin options
(external_jQuery_default()).slugify.options = {
  preSlug: null,
  postSlug: null,
  slugFunc: function slugFunc(input, opts) {
    return speakingurl_default()(input, opts);
  }
};
;// CONCATENATED MODULE: ./app/pages/page/add.js




var custom = false;
var folder = external_jQuery_default()('[data-remodal-id="modal"] input[name="data[folder]"], [data-remodal-id="module"] input[name="data[folder]"], [data-remodal-id="modal-page-copy"] input[name="data[folder]"]');
var title = external_jQuery_default()('[data-remodal-id="modal"] input[name="data[title]"], [data-remodal-id="module"] input[name="data[title]"], [data-remodal-id="modal-page-copy"] input[name="data[title]"]');
var getFields = function getFields(type, target) {
  target = external_jQuery_default()(target);
  var query = "[data-remodal-id=\"".concat(target.closest('[data-remodal-id]').data('remodal-id'), "\"]");
  return {
    title: type === 'title' ? external_jQuery_default()(target) : external_jQuery_default()("".concat(query, " input[name=\"data[title]\"]")),
    folder: type === 'folder' ? external_jQuery_default()(target) : external_jQuery_default()("".concat(query, " input[name=\"data[folder]\"]"))
  };
};
title.on('input focus blur', function (event) {
  if (custom) {
    return true;
  }
  var elements = getFields('title', event.currentTarget);
  var slug = external_jQuery_default().slugify(elements.title.val(), {
    custom: {
      "'": '',
      '‘': '',
      '’': ''
    }
  });
  elements.folder.val(slug);
});
folder.on('input', function (event) {
  var elements = getFields('folder', event.currentTarget);
  var input = elements.folder.get(0);
  var value = elements.folder.val();
  var selection = {
    start: input.selectionStart,
    end: input.selectionEnd
  };
  value = value.toLowerCase().replace(/\s/g, '-').replace(/[^a-z0-9_\-]/g, '');
  elements.folder.val(value);
  custom = !!value;

  // restore cursor position
  input.setSelectionRange(selection.start, selection.end);
});
folder.on('focus blur', function (event) {
  getFields('title').title.trigger('input');
});
external_jQuery_default()(document).on('change', '[name="data[route]"]', function (event) {
  var rawroute = external_jQuery_default()(event.currentTarget).val();
  var pageTemplate = external_jQuery_default()('[name="data[name]"]');
  var URI = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/ajax.json/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "getChildTypes");
  if (pageTemplate.length === 0) {
    return;
  }
  utils_request(URI, {
    method: 'post',
    body: {
      rawroute: rawroute
    }
  }, function (response) {
    var type = response.child_type;
    if (type !== '' && type !== 'default') {
      pageTemplate.val(type);
      pageTemplate.data('selectize').setValue(type);
    }
  });
});
;// CONCATENATED MODULE: ./app/pages/page/move.js

external_jQuery_default()(document).on('click', '[data-page-move] button[name="task"][value="save"]', function (event) {
  /* let route = $('form#blueprints:first select[name="data[route]"]');
  let moveTo = $('[data-page-move] select').val();
   if (route.length && route.val() !== moveTo) {
      let selectize = route.data('selectize');
      route.val(moveTo);
       if (selectize) selectize.setValue(moveTo);
  }*/

  var modal = external_jQuery_default()(event.currentTarget).closest('[data-remodal-id]');
  var parents = modal.data('parents') || {};
  var finder = parents.finder;
  if (!parents || !finder) {
    return true;
  }
  var field = parents.field;
  var parentLabel = parents.parentLabel;
  var parentName = parents.parentName;
  var selection = finder.findLastActive().item[0];
  var value = selection._item[finder.config.valueKey];
  var name = selection._item[finder.config.labelKey];
  field.val(value);
  parentLabel.text(value);
  parentName.text(name);
  finder.config.defaultPath = value;
  external_jQuery_default()('<div />').css({
    backgroundColor: 'rgba(255, 255, 255, 0.1)',
    position: 'fixed',
    top: 0,
    left: 0,
    width: '100vw',
    height: '100vh',
    zIndex: 15000
  }).appendTo(external_jQuery_default()('body'));
});

/*
$(document).on('click', '[data-remodal-id="parents"] [data-parents-select]', (event) => {
    const modal = $(event.currentTarget).closest('[data-remodal-id]');
    const parents = modal.data('parents');
    const finder = parents.finder;
    const field = parents.field;
    const parentLabel = parents.parentLabel;
    const parentName = parents.parentName;
    const selection = finder.findLastActive().item[0];
    const value = selection._item[finder.config.valueKey];
    const name = selection._item[finder.config.labelKey];

    field.val(value);
    parentLabel.text(value);
    parentName.text(name);
    finder.config.defaultPath = value;

    const remodal = $.remodal.lookup[$(`[data-remodal-id="${modal.data('remodalId')}"]`).data('remodal')];
    remodal.close();
});
*/
;// CONCATENATED MODULE: ./app/pages/page/delete.js

external_jQuery_default()(document).on('click', '[data-remodal-target="delete"]', function () {
  var confirm = external_jQuery_default()('[data-remodal-id="delete"] [data-delete-action]');
  var link = external_jQuery_default()(this).data('delete-url');
  confirm.data('delete-action', link);
});
external_jQuery_default()(document).on('click', '[data-delete-action]', function () {
  var remodal = (external_jQuery_default()).remodal.lookup[external_jQuery_default()('[data-remodal-id="delete"]').data('remodal')];
  __webpack_require__.g.location.href = external_jQuery_default()(this).data('delete-action');
  remodal.close();
});
;// CONCATENATED MODULE: ./app/pages/page/unset.js

external_jQuery_default()(document).on('click', '.dz-unset', function () {
  var file_upload = external_jQuery_default()(this).closest('.files-upload');
  external_jQuery_default()(this).closest('.dz-image-preview').remove();
  var unset_image = external_jQuery_default()(this).closest('.dz-image-preview').find('[data-dz-name]').text().trim();
  var images = JSON.parse(file_upload.find('input[data-grav-field="hidden"]').val()) || {};
  var image_array = {};
  external_jQuery_default().each(images, function (ind, obj) {
    if (!ind.endsWith(unset_image)) {
      image_array[ind] = obj;
    }
  });
  file_upload.find('input[data-grav-field="hidden"]').val(JSON.stringify(image_array));
});
;// CONCATENATED MODULE: ./app/pages/page/disable-buttons.js

external_jQuery_default()('.disable-after-click').on('click', function () {
  external_jQuery_default()(this).addClass('pointer-events-disabled');
});
;// CONCATENATED MODULE: ./app/utils/cookies.js
function cookies_typeof(o) { "@babel/helpers - typeof"; return cookies_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, cookies_typeof(o); }
/*
 * Cookies.js - 1.2.3-grav
 * https://github.com/ScottHamper/Cookies
 *
 * With SameSite support by Grav
 *
 * This is free and unencumbered software released into the public domain.
 */

var factory = function factory(window) {
  var _arguments = arguments;
  if (cookies_typeof(window.document) !== 'object') {
    throw new Error('Cookies.js requires a `window` with a `document` object');
  }
  var Cookies = function Cookies(key, value, options) {
    return _arguments.length === 1 ? Cookies.get(key) : Cookies.set(key, value, options);
  };

  // Allows for setter injection in unit tests
  Cookies._document = window.document;

  // Used to ensure cookie keys do not collide with
  // built-in `Object` properties
  Cookies._cacheKeyPrefix = 'cookey.'; // Hurr hurr, :)

  Cookies._maxExpireDate = new Date('Fri, 31 Dec 9999 23:59:59 UTC');
  Cookies.defaults = {
    path: '/',
    secure: false,
    sameSite: 'Lax'
  };
  Cookies.get = function (key) {
    if (Cookies._cachedDocumentCookie !== Cookies._document.cookie) {
      Cookies._renewCache();
    }
    var value = Cookies._cache[Cookies._cacheKeyPrefix + key];
    return value === undefined ? undefined : decodeURIComponent(value);
  };
  Cookies.set = function (key, value, options) {
    options = Cookies._getExtendedOptions(options);
    options.expires = Cookies._getExpiresDate(value === undefined ? -1 : options.expires);
    Cookies._document.cookie = Cookies._generateCookieString(key, value, options);
    return Cookies;
  };
  Cookies.expire = function (key, options) {
    return Cookies.set(key, undefined, options);
  };
  Cookies._getExtendedOptions = function (options) {
    return {
      path: options && options.path || Cookies.defaults.path,
      domain: options && options.domain || Cookies.defaults.domain,
      expires: options && options.expires || Cookies.defaults.expires,
      secure: options && options.secure !== undefined ? options.secure : Cookies.defaults.secure,
      sameSite: options && options.sameSite || Cookies.defaults.sameSite
    };
  };
  Cookies._isValidDate = function (date) {
    return Object.prototype.toString.call(date) === '[object Date]' && !isNaN(date.getTime());
  };
  Cookies._getExpiresDate = function (expires, now) {
    now = now || new Date();
    if (typeof expires === 'number') {
      expires = expires === Infinity ? Cookies._maxExpireDate : new Date(now.getTime() + expires * 1000);
    } else if (typeof expires === 'string') {
      expires = new Date(expires);
    }
    if (expires && !Cookies._isValidDate(expires)) {
      throw new Error('`expires` parameter cannot be converted to a valid Date instance');
    }
    return expires;
  };
  Cookies._generateCookieString = function (key, value, options) {
    key = key.replace(/[^#$&+\^`|]/g, encodeURIComponent);
    key = key.replace(/\(/g, '%28').replace(/\)/g, '%29');
    value = (value + '').replace(/[^!#$&-+\--:<-\[\]-~]/g, encodeURIComponent);
    options = options || {};
    var cookieString = key + '=' + value;
    cookieString += options.path ? ';path=' + options.path : '';
    cookieString += options.domain ? ';domain=' + options.domain : '';
    cookieString += options.expires ? ';expires=' + options.expires.toUTCString() : '';
    cookieString += options.secure ? ';secure' : '';
    cookieString += options.sameSite ? ';SameSite=' + options.sameSite : '';
    return cookieString;
  };
  Cookies._getCacheFromString = function (documentCookie) {
    var cookieCache = {};
    var cookiesArray = documentCookie ? documentCookie.split('; ') : [];
    for (var i = 0; i < cookiesArray.length; i++) {
      var cookieKvp = Cookies._getKeyValuePairFromCookieString(cookiesArray[i]);
      if (cookieCache[Cookies._cacheKeyPrefix + cookieKvp.key] === undefined) {
        cookieCache[Cookies._cacheKeyPrefix + cookieKvp.key] = cookieKvp.value;
      }
    }
    return cookieCache;
  };
  Cookies._getKeyValuePairFromCookieString = function (cookieString) {
    // "=" is a valid character in a cookie value according to RFC6265, so cannot `split('=')`
    var separatorIndex = cookieString.indexOf('=');

    // IE omits the "=" when the cookie value is an empty string
    separatorIndex = separatorIndex < 0 ? cookieString.length : separatorIndex;
    var key = cookieString.substr(0, separatorIndex);
    var decodedKey;
    try {
      decodedKey = decodeURIComponent(key);
    } catch (e) {
      if (console && typeof console.error === 'function') {
        console.error('Could not decode cookie with key "' + key + '"', e);
      }
    }
    return {
      key: decodedKey,
      value: cookieString.substr(separatorIndex + 1) // Defer decoding value until accessed
    };
  };
  Cookies._renewCache = function () {
    Cookies._cache = Cookies._getCacheFromString(Cookies._document.cookie);
    Cookies._cachedDocumentCookie = Cookies._document.cookie;
  };
  Cookies._areEnabled = function () {
    var testKey = 'cookies.js';
    var areEnabled = Cookies.set(testKey, 1).get(testKey) === '1';
    Cookies.expire(testKey);
    return areEnabled;
  };
  Cookies.enabled = Cookies._areEnabled();
  return Cookies;
};
__webpack_require__.g.Cookies = __webpack_require__.g && cookies_typeof(__webpack_require__.g.document) === 'object' ? factory(__webpack_require__.g) : factory;
/* harmony default export */ const cookies = (__webpack_require__.g.Cookies);
;// CONCATENATED MODULE: ./app/forms/fields/editor/buttons.js



var replacer = function replacer(_ref) {
  var name = _ref.name,
    replace = _ref.replace,
    codemirror = _ref.codemirror,
    button = _ref.button,
    _ref$mode = _ref.mode,
    mode = _ref$mode === void 0 ? 'replaceSelections' : _ref$mode,
    runner = _ref.runner;
  button.on("click.editor.".concat(name), function () {
    strategies[mode]({
      token: '$1',
      template: replace,
      codemirror: codemirror,
      runner: runner
    });
  });
};
var strategies = {
  replaceSelections: function replaceSelections(_ref2) {
    var template = _ref2.template,
      token = _ref2.token,
      codemirror = _ref2.codemirror,
      runner = _ref2.runner;
    var replacements = [];
    var ranges = [];
    var selections = codemirror.getSelections();
    var list = codemirror.listSelections();
    var accumulator = {};
    selections.forEach(function (selection, index) {
      var markup = template.replace(token, selection);
      var cursor = markup.indexOf('$cur');
      var _list$index$anchor = list[index].anchor,
        line = _list$index$anchor.line,
        ch = _list$index$anchor.ch;
      markup = markup.replace('$cur', '');
      markup = runner ? runner(selection, markup, list) : markup;
      replacements.push(markup);
      if (!accumulator[line]) {
        accumulator[line] = 0;
      }
      ch += accumulator[line] + (cursor === -1 ? markup.length : cursor);
      var range = {
        ch: ch,
        line: line
      };
      ranges.push({
        anchor: range,
        head: range
      });
      accumulator[line] += markup.length - selection.length;
    });
    codemirror.replaceSelections(replacements);
    codemirror.setSelections(ranges);
    codemirror.focus();
  },
  replaceLine: function replaceLine(_ref3) {
    var template = _ref3.template,
      token = _ref3.token,
      codemirror = _ref3.codemirror,
      runner = _ref3.runner;
    var list = codemirror.listSelections();
    var range;
    list.forEach(function (selection) {
      var lines = {
        min: Math.min(selection.anchor.line, selection.head.line),
        max: Math.max(selection.anchor.line, selection.head.line)
      };
      codemirror.eachLine(lines.min, lines.max + 1, function (handler) {
        var markup = template.replace(token, handler.text);
        var line = codemirror.getLineNumber(handler);
        markup = runner ? runner(handler, markup) : markup;
        codemirror.replaceRange(markup, {
          line: line,
          ch: 0
        }, {
          line: line,
          ch: markup.length
        });
        range = {
          line: line,
          ch: markup.length
        };
      });
    });
    codemirror.setSelection(range, range, 'end');
    codemirror.focus();
  },
  replaceRange: function replaceRange() {}
};
var flipDisabled = function flipDisabled(codemirror, button, type) {
  var hasHistory = codemirror.historySize()[type];
  var element = button.find('a');
  button[hasHistory ? 'removeClass' : 'addClass']('button-disabled');
  if (!hasHistory) {
    element.attr('title-disabled', element.attr('title'));
    element.attr('data-hint-disabled', element.attr('data-hint'));
    element.removeAttr('title').removeAttr('data-hint');
  } else {
    element.attr('title', element.attr('title-disabled'));
    element.attr('data-hint', element.attr('data-hint-disabled'));
    element.removeAttr('title-disabled').removeAttr('data-hint-disabled');
  }
};
/* harmony default export */ const buttons = ({
  navigation: [{
    undo: {
      identifier: 'undo',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.UNDO,
      label: '<i class="fa fa-fw fa-undo"></i>',
      modes: [],
      action: function action(_ref4) {
        var codemirror = _ref4.codemirror,
          button = _ref4.button,
          textarea = _ref4.textarea;
        button.addClass('button-disabled');
        codemirror.on('change', function () {
          return flipDisabled(codemirror, button, 'undo');
        });
        button.on('click.editor.undo', function () {
          codemirror.undo();
        });
      }
    }
  }, {
    redo: {
      identifier: 'redo',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.REDO,
      label: '<i class="fa fa-fw fa-repeat"></i>',
      modes: [],
      action: function action(_ref5) {
        var codemirror = _ref5.codemirror,
          button = _ref5.button,
          textarea = _ref5.textarea;
        button.addClass('button-disabled');
        codemirror.on('change', function () {
          return flipDisabled(codemirror, button, 'redo');
        });
        button.on('click.editor.redo', function () {
          codemirror.redo();
        });
      }
    }
  }, {
    headers: {
      identifier: 'headers',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.HEADERS,
      label: '<i class="fa fa-fw fa-header"></i>',
      modes: ['gfm', 'markdown'],
      children: [{
        h1: {
          identifier: 'h1',
          label: '<i class="fa fa-fw fa-header"></i>1',
          modes: ['gfm', 'markdown'],
          action: function action(_ref6) {
            var codemirror = _ref6.codemirror,
              button = _ref6.button,
              textarea = _ref6.textarea;
            replacer({
              name: 'h1',
              replace: '# $1',
              codemirror: codemirror,
              button: button,
              mode: 'replaceLine'
            });
          }
        }
      }, {
        h2: {
          identifier: 'h2',
          label: '<i class="fa fa-fw fa-header"></i>2',
          modes: ['gfm', 'markdown'],
          action: function action(_ref7) {
            var codemirror = _ref7.codemirror,
              button = _ref7.button,
              textarea = _ref7.textarea;
            replacer({
              name: 'h2',
              replace: '## $1',
              codemirror: codemirror,
              button: button,
              mode: 'replaceLine'
            });
          }
        }
      }, {
        h3: {
          identifier: 'h3',
          label: '<i class="fa fa-fw fa-header"></i>3',
          modes: ['gfm', 'markdown'],
          action: function action(_ref8) {
            var codemirror = _ref8.codemirror,
              button = _ref8.button,
              textarea = _ref8.textarea;
            replacer({
              name: 'h3',
              replace: '### $1',
              codemirror: codemirror,
              button: button,
              mode: 'replaceLine'
            });
          }
        }
      }, {
        h4: {
          identifier: 'h4',
          label: '<i class="fa fa-fw fa-header"></i>4',
          modes: ['gfm', 'markdown'],
          action: function action(_ref9) {
            var codemirror = _ref9.codemirror,
              button = _ref9.button,
              textarea = _ref9.textarea;
            replacer({
              name: 'h4',
              replace: '#### $1',
              codemirror: codemirror,
              button: button,
              mode: 'replaceLine'
            });
          }
        }
      }, {
        h5: {
          identifier: 'h5',
          label: '<i class="fa fa-fw fa-header"></i>5',
          modes: ['gfm', 'markdown'],
          action: function action(_ref10) {
            var codemirror = _ref10.codemirror,
              button = _ref10.button,
              textarea = _ref10.textarea;
            replacer({
              name: 'h5',
              replace: '##### $1',
              codemirror: codemirror,
              button: button,
              mode: 'replaceLine'
            });
          }
        }
      }, {
        h6: {
          identifier: 'h6',
          label: '<i class="fa fa-fw fa-header"></i>6',
          modes: ['gfm', 'markdown'],
          action: function action(_ref11) {
            var codemirror = _ref11.codemirror,
              button = _ref11.button,
              textarea = _ref11.textarea;
            replacer({
              name: 'h6',
              replace: '###### $1',
              codemirror: codemirror,
              button: button,
              mode: 'replaceLine'
            });
          }
        }
      }]
    }
  }, {
    bold: {
      identifier: 'bold',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.BOLD,
      label: '<i class="fa fa-fw fa-bold"></i>',
      modes: ['gfm', 'markdown'],
      shortcut: ['Ctrl-B', 'Cmd-B'],
      action: function action(_ref12) {
        var codemirror = _ref12.codemirror,
          button = _ref12.button,
          textarea = _ref12.textarea;
        replacer({
          name: 'bold',
          replace: '**$1$cur**',
          codemirror: codemirror,
          button: button
        });
      }
    }
  }, {
    italic: {
      identifier: 'italic',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.ITALIC,
      label: '<i class="fa fa-fw fa-italic"></i>',
      modes: ['gfm', 'markdown'],
      shortcut: ['Ctrl-I', 'Cmd-I'],
      action: function action(_ref13) {
        var codemirror = _ref13.codemirror,
          button = _ref13.button,
          textarea = _ref13.textarea;
        replacer({
          name: 'italic',
          replace: '_$1$cur_',
          codemirror: codemirror,
          button: button
        });
      }
    }
  }, {
    strike: {
      identifier: 'strike',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.STRIKETHROUGH,
      label: '<i class="fa fa-fw fa-strikethrough"></i>',
      modes: ['gfm', 'markdown'],
      action: function action(_ref14) {
        var codemirror = _ref14.codemirror,
          button = _ref14.button,
          textarea = _ref14.textarea;
        replacer({
          name: 'strike',
          replace: '~~$1$cur~~',
          codemirror: codemirror,
          button: button
        });
      }
    }
  }, {
    delimiter: {
      identifier: 'delimiter',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.SUMMARY_DELIMITER,
      label: '<i class="fa fa-fw fa-minus"></i>',
      modes: ['gfm', 'markdown'],
      action: function action(_ref15) {
        var codemirror = _ref15.codemirror,
          button = _ref15.button,
          textarea = _ref15.textarea;
        replacer({
          name: 'delimiter',
          replace: "".concat(external_GravAdmin_namespaceObject.config.site.delimiter, "$1"),
          codemirror: codemirror,
          button: button,
          mode: 'replaceLine'
        });
      }
    }
  }, {
    link: {
      identifier: 'link',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.LINK,
      label: '<i class="fa fa-fw fa-link"></i>',
      modes: ['gfm', 'markdown'],
      shortcut: ['Ctrl-K', 'Cmd-K'],
      action: function action(_ref16) {
        var codemirror = _ref16.codemirror,
          button = _ref16.button,
          textarea = _ref16.textarea;
        replacer({
          name: 'link',
          replace: '[$1]($cur)',
          codemirror: codemirror,
          button: button
        });
      }
    }
  }, {
    image: {
      identifier: 'image',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.IMAGE,
      label: '<i class="fa fa-fw fa-picture-o"></i>',
      modes: ['gfm', 'markdown'],
      action: function action(_ref17) {
        var codemirror = _ref17.codemirror,
          button = _ref17.button,
          textarea = _ref17.textarea;
        replacer({
          name: 'image',
          replace: '![$1]($cur)',
          codemirror: codemirror,
          button: button
        });
      }
    }
  }, {
    blockquote: {
      identifier: 'blockquote',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.BLOCKQUOTE,
      label: '<i class="fa fa-fw fa-quote-right"></i>',
      modes: ['gfm', 'markdown'],
      action: function action(_ref18) {
        var codemirror = _ref18.codemirror,
          button = _ref18.button,
          textarea = _ref18.textarea;
        replacer({
          name: 'blockquote',
          replace: '> $1',
          codemirror: codemirror,
          button: button,
          mode: 'replaceLine'
        });
      }
    }
  }, {
    listUl: {
      identifier: 'listUl',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.UNORDERED_LIST,
      label: '<i class="fa fa-fw fa-list-ul"></i>',
      modes: ['gfm', 'markdown'],
      action: function action(_ref19) {
        var codemirror = _ref19.codemirror,
          button = _ref19.button,
          textarea = _ref19.textarea;
        replacer({
          name: 'listUl',
          replace: '* $1',
          codemirror: codemirror,
          button: button,
          mode: 'replaceLine'
        });
      }
    }
  }, {
    listOl: {
      identifier: 'listOl',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.ORDERED_LIST,
      label: '<i class="fa fa-fw fa-list-ol"></i>',
      modes: ['gfm', 'markdown'],
      action: function action(_ref20) {
        var codemirror = _ref20.codemirror,
          button = _ref20.button,
          textarea = _ref20.textarea;
        replacer({
          name: 'listOl',
          replace: '. $1',
          codemirror: codemirror,
          button: button,
          mode: 'replaceLine',
          runner: function runner(line, markup) {
            var lineNo = codemirror.getLineNumber(line);
            var previousLine = codemirror.getLine(lineNo - 1) || '';
            var match = previousLine.match(/^(\d+)\./);
            var prefix = 1 + (match ? Number(match[1]) : 0);
            return "".concat(prefix).concat(markup);
          }
        });
      }
    }
  }],
  states: [{
    code: {
      identifier: 'editor',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.EDITOR,
      label: '<i class="fa fa-fw fa-code"></i>',
      action: function action(_ref21) {
        var codemirror = _ref21.codemirror,
          button = _ref21.button,
          textarea = _ref21.textarea,
          ui = _ref21.ui;
        if (textarea.data('grav-editor-mode') === 'editor') {
          button.addClass('editor-active');
        }
        button.on('click.states.editor', function () {
          button.siblings().removeClass('editor-active');
          button.addClass('editor-active');
          textarea.data('grav-editor-mode', 'editor');
          var previewContainer = textarea.data('grav-editor-preview-container');
          var content = textarea.parent('.grav-editor-content');
          content.addClass('is-active');
          ui.navigation.find('.grav-editor-actions').css('visibility', 'visible');
          if (previewContainer) {
            previewContainer.removeClass('is-active');
          }
        });
      }
    }
  }, {
    preview: {
      identifier: 'preview',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.PREVIEW,
      label: '<i class="fa fa-fw fa-eye"></i>',
      modes: ['gfm', 'markdown'],
      action: function action(_ref22) {
        var codemirror = _ref22.codemirror,
          button = _ref22.button,
          textarea = _ref22.textarea,
          ui = _ref22.ui;
        if (textarea.data('grav-editor-mode') === 'preview') {
          button.addClass('editor-active');
        }
        button.on('click.states.preview', function () {
          var previewContainer = textarea.data('grav-editor-preview-container');
          var content = textarea.parent('.grav-editor-content');
          button.siblings().removeClass('editor-active');
          button.addClass('editor-active');
          textarea.data('grav-editor-mode', 'preview');
          if (!previewContainer) {
            previewContainer = external_jQuery_default()('<div class="grav-editor-preview" />');
            content.after(previewContainer);
            textarea.data('grav-editor-preview-container', previewContainer);
          }
          previewContainer.css({
            height: content.height()
          });
          previewContainer.addClass('is-active');
          content.removeClass('is-active');
          ui.navigation.find('.grav-editor-actions').css('visibility', 'hidden');
          var url = "".concat(textarea.data('grav-urlpreview'), "/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "processmarkdown");
          var params = textarea.closest('form').serializeArray();
          var body = {};
          params.map(function (obj) {
            body[obj.name] = obj.value;
          });
          utils_request(url, {
            method: 'post',
            body: body
          }, function (response) {
            return previewContainer.html(response.preview);
          });
        });
      }
    }
  }, {
    fullscreen: {
      identifier: 'fullscreen',
      title: external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.FULLSCREEN,
      label: '<i class="fa fa-fw fa-expand"></i>',
      action: function action(_ref23) {
        var codemirror = _ref23.codemirror,
          button = _ref23.button,
          textarea = _ref23.textarea;
        button.on('click.editor.fullscreen', function () {
          var container = textarea.closest('.grav-editor');
          var wrapper = codemirror.getWrapperElement();
          var contentWrapper = external_jQuery_default()('.content-wrapper');
          if (!container.hasClass('grav-editor-fullscreen')) {
            textarea.data('fullScreenRestore', {
              scrollTop: __webpack_require__.g.pageYOffset,
              scrollLeft: __webpack_require__.g.pageXOffset,
              width: wrapper.style.width,
              height: wrapper.style.height
            });
            wrapper.style.width = '';
            wrapper.style.height = textarea.parent('.grav-editor-content').height() + 'px';
            __webpack_require__.g.document.documentElement.style.overflow = 'hidden';
            var hints = container.find('.grav-editor-toolbar .hint--top');
            if (hints) {
              hints.removeClass('hint--top').addClass('hint--bottom');
              external_jQuery_default()(hints[hints.length - 1]).addClass('hint--bottom-left');
            }
            if (contentWrapper) {
              contentWrapper.css('overflow', 'visible');
            }
          } else {
            __webpack_require__.g.document.documentElement.style.overflow = '';
            var state = textarea.data('fullScreenRestore');
            wrapper.style.width = state.width;
            wrapper.style.height = state.height;
            __webpack_require__.g.scrollTo(state.scrollLeft, state.scrollTop);
            var _hints = container.find('.grav-editor-toolbar .hint--bottom');
            if (_hints) {
              _hints.removeClass('hint--bottom').addClass('hint--top');
              external_jQuery_default()(_hints[_hints.length - 1]).removeClass('hint--bottom-left');
            }
            if (contentWrapper) {
              contentWrapper.css('overflow', 'auto');
            }
          }
          container.toggleClass('grav-editor-fullscreen');
          setTimeout(function () {
            codemirror.refresh();
            // this.preview.parent().css('height', this.code.height());
            external_jQuery_default()(__webpack_require__.g).trigger('resize');
          }, 5);
        });
      }
    }
  }]
});
// EXTERNAL MODULE: ./node_modules/codemirror/lib/codemirror.js
var codemirror = __webpack_require__(15237);
var codemirror_default = /*#__PURE__*/__webpack_require__.n(codemirror);
// EXTERNAL MODULE: ./node_modules/watchjs/src/watch.js
var watch = __webpack_require__(72797);
// EXTERNAL MODULE: ./node_modules/js-yaml/dist/js-yaml.mjs
var js_yaml = __webpack_require__(20382);
// EXTERNAL MODULE: ./node_modules/codemirror/mode/css/css.js
var css = __webpack_require__(68656);
// EXTERNAL MODULE: ./node_modules/codemirror/mode/gfm/gfm.js
var gfm = __webpack_require__(21764);
// EXTERNAL MODULE: ./node_modules/codemirror/mode/htmlmixed/htmlmixed.js
var htmlmixed = __webpack_require__(12520);
// EXTERNAL MODULE: ./node_modules/codemirror/mode/javascript/javascript.js
var javascript = __webpack_require__(16792);
// EXTERNAL MODULE: ./node_modules/codemirror/mode/markdown/markdown.js
var markdown = __webpack_require__(47216);
// EXTERNAL MODULE: ./node_modules/codemirror/mode/php/php.js
var php = __webpack_require__(98000);
// EXTERNAL MODULE: ./node_modules/codemirror/mode/sass/sass.js
var sass = __webpack_require__(17246);
// EXTERNAL MODULE: ./node_modules/codemirror/mode/twig/twig.js
var twig = __webpack_require__(11956);
// EXTERNAL MODULE: ./node_modules/codemirror/mode/xml/xml.js
var xml = __webpack_require__(40576);
// EXTERNAL MODULE: ./node_modules/codemirror/mode/yaml/yaml.js
var yaml = __webpack_require__(20496);
// EXTERNAL MODULE: ./node_modules/codemirror/addon/edit/continuelist.js
var continuelist = __webpack_require__(97382);
// EXTERNAL MODULE: ./node_modules/codemirror/addon/mode/overlay.js
var overlay = __webpack_require__(32580);
// EXTERNAL MODULE: ./node_modules/codemirror/addon/selection/active-line.js
var active_line = __webpack_require__(50436);
// EXTERNAL MODULE: ./node_modules/codemirror/addon/lint/lint.js
var lint = __webpack_require__(71561);
// EXTERNAL MODULE: ./node_modules/codemirror/addon/lint/lint.css
var lint_lint = __webpack_require__(3419);
// EXTERNAL MODULE: ./node_modules/codemirror/addon/lint/css-lint.js
var css_lint = __webpack_require__(9279);
// EXTERNAL MODULE: ./node_modules/codemirror/addon/lint/javascript-lint.js
var javascript_lint = __webpack_require__(12089);
// EXTERNAL MODULE: ./node_modules/codemirror/addon/lint/json-lint.js
var json_lint = __webpack_require__(92154);
// EXTERNAL MODULE: ./node_modules/codemirror/addon/lint/yaml-lint.js
var yaml_lint = __webpack_require__(23857);
;// CONCATENATED MODULE: ./app/forms/fields/editor.js
function editor_typeof(o) { "@babel/helpers - typeof"; return editor_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, editor_typeof(o); }
function editor_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function editor_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, editor_toPropertyKey(o.key), o); } }
function editor_createClass(e, r, t) { return r && editor_defineProperties(e.prototype, r), t && editor_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function editor_toPropertyKey(t) { var i = editor_toPrimitive(t, "string"); return "symbol" == editor_typeof(i) ? i : i + ""; }
function editor_toPrimitive(t, r) { if ("object" != editor_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != editor_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }





__webpack_require__.g.jsyaml = js_yaml/* default */.Ay;

// Modes











// Add-ons









var IS_MOUSEDOWN = false;
var ThemesMap = ['paper'];
var Defaults = {
  codemirror: {
    mode: 'htmlmixed',
    theme: 'paper',
    lineWrapping: true,
    dragDrop: true,
    autoCloseTags: true,
    matchTags: true,
    autoCloseBrackets: true,
    matchBrackets: true,
    indentUnit: 4,
    indentWithTabs: false,
    tabSize: 4,
    hintOptions: {
      completionSingle: false
    },
    extraKeys: {
      'Enter': 'newlineAndIndentContinueMarkdownList'
    }
  }
};
var EditorField = /*#__PURE__*/function () {
  function EditorField(options) {
    var _this = this;
    editor_classCallCheck(this, EditorField);
    var body = external_jQuery_default()('body');
    this.editors = external_jQuery_default()();
    this.options = Object.assign({}, Defaults, options);
    this.buttons = buttons;
    this.buttonStrategies = strategies;
    (0,watch.watch)(buttons, function /* key, modifier, prev, next */
    () {
      _this.editors.each(function (index, editor) {
        return external_jQuery_default()(editor).data('toolbar').renderButtons();
      });
    });
    external_jQuery_default()('[data-grav-editor]').each(function (index, editor) {
      return _this.addEditor(editor);
    });
    external_jQuery_default()(function () {
      body.trigger('grav-editor-ready');
    });
    body.on('mutation._grav', this._onAddedNodes.bind(this));
    body.on('mouseup._grav', function () {
      if (!IS_MOUSEDOWN) {
        return true;
      }
      body.unbind('mousemove._grav');
      IS_MOUSEDOWN = false;
    });
    body.on('mousedown._grav', '.grav-editor-resizer', function (event) {
      event && event.preventDefault();
      IS_MOUSEDOWN = true;
      var target = external_jQuery_default()(event.currentTarget);
      var container = target.siblings('.grav-editor-content');
      var editor = container.find('.CodeMirror');
      var codemirror = container.find('textarea').data('codemirror');
      body.on('mousemove._grav', function (event) {
        editor.css('height', Math.max(100, event.pageY - container.offset().top));
        codemirror.refresh();
      });
    });
  }
  return editor_createClass(EditorField, [{
    key: "addButton",
    value: function addButton(button, options) {
      if (options && (options.before || options.after)) {
        var index = this.buttons.navigation.findIndex(function (obj) {
          var key = Object.keys(obj).shift();
          return obj[key].identifier === (options.before || options.after);
        });
        if (!~index) {
          options = 'end';
        } else {
          this.buttons.navigation.splice(options.before ? index : index + 1, 0, button);
        }
      }
      if (options === 'start') {
        this.buttons.navigation.splice(0, 0, button);
      }
      if (!options || options === 'end') {
        this.buttons.navigation.push(button);
      }
    }
  }, {
    key: "addEditor",
    value: function addEditor(textarea) {
      textarea = external_jQuery_default()(textarea);
      var options = Object.assign({}, this.options.codemirror, textarea.data('grav-editor').codemirror);
      var theme = options.theme || 'paper';
      this.editors = this.editors.add(textarea);
      if (theme && !~ThemesMap.indexOf(theme)) {
        ThemesMap.push(theme);
        // let themeCSS = `https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.12.0/theme/${theme}.min.css`;
        // $('head').append($('<link rel="stylesheet" type="text/css" />').attr('href', themeCSS));
      }
      if (options.mode === 'yaml') {
        Object.assign(options.extraKeys, {
          Tab: function Tab(cm) {
            cm.replaceSelection('    ', 'end');
          }
        });
      }
      var editor = codemirror_default().fromTextArea(textarea.get(0), options);
      textarea.data('codemirror', editor);
      textarea.data('toolbar', new Toolbar(textarea));
      textarea.addClass('code-mirrored');
      if (options.toolbar === false) {
        textarea.data('toolbar').ui.navigation.addClass('grav-editor-hide-toolbar');
      }
      editor.on('change', function () {
        return editor.save();
      });
    }
  }, {
    key: "_onAddedNodes",
    value: function _onAddedNodes(event, target /* , record, instance */) {
      var _this2 = this;
      var editors = external_jQuery_default()(target).find('[data-grav-editor]');
      if (!editors.length) {
        return;
      }
      editors.each(function (index, editor) {
        editor = external_jQuery_default()(editor);
        if (!~_this2.editors.index(editor)) {
          _this2.addEditor(editor);
        }
      });
    }
  }]);
}();

var Toolbar = /*#__PURE__*/function () {
  function Toolbar(editor) {
    editor_classCallCheck(this, Toolbar);
    this.editor = external_jQuery_default()(editor);
    this.codemirror = this.editor.data('codemirror');
    this.buttons = buttons.navigation;
    this.ui = {
      navigation: external_jQuery_default()(Toolbar.templates().navigation)
    };
    this.editor.parent('.grav-editor-content').before(this.ui.navigation).after(this.ui.states);
    this.renderButtons();
  }
  return editor_createClass(Toolbar, [{
    key: "renderButtons",
    value: function renderButtons() {
      var _this3 = this;
      var map = {
        'actions': 'navigation',
        'modes': 'states'
      };
      ['actions', 'modes'].forEach(function (type) {
        _this3.ui.navigation.find(".grav-editor-".concat(type)).empty().append('<ul />');
        buttons[map[type]].forEach(function (button) {
          return _this3.renderButton(button, type);
        });
      });
    }
  }, {
    key: "renderButton",
    value: function renderButton(button, type) {
      var _this4 = this;
      var location = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      Object.keys(button).forEach(function (key) {
        var obj = button[key];
        if (!obj.modes) {
          obj.modes = [];
        }
        if (!~_this4.codemirror.options.ignore.indexOf(key) && (!obj.modes.length || obj.modes.indexOf(_this4.codemirror.options.mode) > -1)) {
          var hint = obj.title ? "data-hint=\"".concat(obj.title, "\"") : '';
          var element = external_jQuery_default()("<li class=\"grav-editor-button-".concat(key, "\"><a class=\"hint--top\" ").concat(hint, ">").concat(obj.label, "</a></li>"));
          (location || _this4.ui.navigation.find(".grav-editor-".concat(type, " ul:not(.dropdown-menu)"))).append(element);
          if (obj.shortcut) {
            _this4.addShortcut(obj.identifier, obj.shortcut, element);
          }
          obj.action && obj.action.call(obj.action, {
            codemirror: _this4.codemirror,
            button: element,
            textarea: _this4.editor,
            ui: _this4.ui
          });
          if (obj.children) {
            var childrenContainer = external_jQuery_default()('<ul class="dropdown-menu" />');
            element.addClass('button-group').find('a').wrap('<div class="dropdown-toggle" data-toggle="dropdown"></div>');
            element.find('a').append(' <i class="fa fa-caret-down"></i>');
            element.append(childrenContainer);
            obj.children.forEach(function (child) {
              return _this4.renderButton(child, type, childrenContainer);
            });
          }
        }
      });
    }
  }, {
    key: "addShortcut",
    value: function addShortcut(identifier, shortcut, element) {
      var _this5 = this;
      var map = {};
      if (!Array.isArray(shortcut)) {
        shortcut = [shortcut];
      }
      shortcut.forEach(function (key) {
        map[key] = function () {
          element.trigger("click.editor.".concat(identifier), [_this5.codemirror]);
        };
      });
      this.codemirror.addKeyMap(map);
    }
  }], [{
    key: "templates",
    value: function templates() {
      return {
        navigation: "\n                <div class=\"grav-editor-toolbar\">\n                    <div class=\"grav-editor-actions\"></div>\n                    <div class=\"grav-editor-modes\"></div>\n                </div>\n            "
      };
    }
  }]);
}();
var editor_Instance = new EditorField();
;// CONCATENATED MODULE: ./app/pages/page/media.js
function media_typeof(o) { "@babel/helpers - typeof"; return media_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, media_typeof(o); }
function media_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function media_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, media_toPropertyKey(o.key), o); } }
function media_createClass(e, r, t) { return r && media_defineProperties(e.prototype, r), t && media_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function media_toPropertyKey(t) { var i = media_toPrimitive(t, "string"); return "symbol" == media_typeof(i) ? i : i + ""; }
function media_toPrimitive(t, r) { if ("object" != media_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != media_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function media_callSuper(t, o, e) { return o = media_getPrototypeOf(o), media_possibleConstructorReturn(t, media_isNativeReflectConstruct() ? Reflect.construct(o, e || [], media_getPrototypeOf(t).constructor) : o.apply(t, e)); }
function media_possibleConstructorReturn(t, e) { if (e && ("object" == media_typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return media_assertThisInitialized(t); }
function media_assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function media_isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (media_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function media_get() { return media_get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = media_superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, media_get.apply(null, arguments); }
function media_superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = media_getPrototypeOf(t));); return t; }
function media_getPrototypeOf(t) { return media_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, media_getPrototypeOf(t); }
function media_inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && media_setPrototypeOf(t, e); }
function media_setPrototypeOf(t, e) { return media_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, media_setPrototypeOf(t, e); }







var previewTemplate = "\n    <div class=\"dz-preview dz-file-preview\">\n      <div class=\"dz-details\">\n        <div class=\"dz-filename\"><span data-dz-name></span></div>\n        <div class=\"dz-size\" data-dz-size></div>\n        <img data-dz-thumbnail />\n      </div>\n      <div class=\"dz-progress\"><span class=\"dz-upload\" data-dz-uploadprogress></span></div>\n      <div class=\"dz-success-mark\"><span>\u2714</span></div>\n      <div class=\"dz-error-mark\"><span>\u2718</span></div>\n      <div class=\"dz-error-message\"><span data-dz-errormessage></span></div>\n      <a class=\"dz-remove\" title=\"".concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DELETE, "\" href=\"javascript:undefined;\" data-dz-remove>").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.DELETE, "</a>\n      <a class=\"dz-metadata\" title=\"").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.METADATA, "\" href=\"#\" target=\"_blank\" data-dz-metadata>").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.METADATA, "</a>\n      <a class=\"dz-view\" title=\"").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.VIEW, "\" href=\"#\" target=\"_blank\" data-dz-view>").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.VIEW, "</a>\n      <a class=\"dz-insert\" title=\"").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.INSERT, "\" href=\"javascript:undefined;\" data-dz-insert>").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.INSERT, "</a>\n    </div>").trim();
var PageMedia = /*#__PURE__*/function (_FilesField) {
  function PageMedia() {
    var _this;
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$container = _ref.container,
      container = _ref$container === void 0 ? '#grav-dropzone' : _ref$container,
      _ref$options = _ref.options,
      options = _ref$options === void 0 ? {} : _ref$options;
    media_classCallCheck(this, PageMedia);
    options = Object.assign(options, {
      previewTemplate: previewTemplate
    });
    _this = media_callSuper(this, PageMedia, [{
      container: container,
      options: options
    }]);
    if (!_this.container.length) {
      return media_possibleConstructorReturn(_this);
    }
    _this.urls = {
      fetch: "".concat(_this.container.data('media-url'), "/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "listmedia"),
      add: "".concat(_this.container.data('media-url'), "/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "addmedia"),
      "delete": "".concat(_this.container.data('media-url'), "/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "delmedia")
    };
    _this.dropzone.options.url = _this.urls.add;
    if (typeof _this.options.fetchMedia === 'undefined' || _this.options.fetchMedia) {
      _this.fetchMedia();
    }
    if (typeof _this.options.attachDragDrop === 'undefined' || _this.options.attachDragDrop) {
      _this.attachDragDrop();
    }
    var field = external_jQuery_default()("[name=\"".concat(_this.container.data('dropzone-field'), "\"]"));
    if (field.length) {
      _this.sortable = new sortable_esm/* default */.Ay(_this.container.get(0), {
        animation: 150,
        // forceFallback: true,
        setData: function setData(dataTransfer, target) {
          target = external_jQuery_default()(target);
          var uri = encodeURI(target.find('.dz-filename').text());
          var shortcode = UriToMarkdown(uri);
          _this.dropzone.disable();
          target.addClass('hide-backface');
          dataTransfer.effectAllowed = 'copy';
          dataTransfer.setData('text', shortcode);
        },
        onSort: function onSort() {
          var names = [];
          _this.container.find('[data-dz-name]').each(function (index, file) {
            file = external_jQuery_default()(file);
            var name = file.text().trim();
            names.push(name);
          });
          field.val(names.join(','));
        }
      });
    }
    return _this;
  }
  media_inherits(PageMedia, _FilesField);
  return media_createClass(PageMedia, [{
    key: "fetchMedia",
    value: function fetchMedia() {
      var _this2 = this;
      var order = this.container.closest('.form-field').find('[name="data[header][media_order]"]').val();
      var body = {
        uri: this.getURI(),
        order: order
      };
      var url = this.urls.fetch;
      utils_request(url, {
        method: 'post',
        body: body
      }, function (response) {
        var results = response.results;
        Object.keys(results).forEach(function (name) {
          var data = results[name];
          var mock = {
            name: name,
            size: data.size,
            accepted: true,
            extras: data
          };
          _this2.dropzone.files.push(mock);
          _this2.dropzone.options.addedfile.call(_this2.dropzone, mock);
          _this2.dropzone.options.thumbnail.call(_this2.dropzone, mock, data.url);
        });
        _this2.updateThumbsSize();
        _this2.container.find('.dz-preview').prop('draggable', 'true');
      });
    }
  }, {
    key: "onDropzoneSending",
    value: function onDropzoneSending(file, xhr, formData) {
      /*
      // Cannot call super because Safari and IE API don't implement `delete`
      super.onDropzoneSending(file, xhr, formData);
      formData.delete('task');
      */

      formData.append('name', this.options.dotNotation || file.name);
      formData.append('admin-nonce', external_GravAdmin_namespaceObject.config.admin_nonce);
      formData.append('uri', this.getURI());
    }
  }, {
    key: "onDropzoneComplete",
    value: function onDropzoneComplete(file) {
      media_get(media_getPrototypeOf(PageMedia.prototype), "onDropzoneComplete", this).call(this, file);
      if (this.sortable) {
        this.sortable.options.onSort();
      }

      // accepted
      this.updateThumbsSize();
      this.updateMediaCount();
      external_jQuery_default()('.dz-preview').prop('draggable', 'true');
    }
  }, {
    key: "onDropzoneAddedFile",
    value: function onDropzoneAddedFile(file) {
      for (var _len = arguments.length, extra = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        extra[_key - 1] = arguments[_key];
      }
      media_get(media_getPrototypeOf(PageMedia.prototype), "onDropzoneAddedFile", this).call(this, file, extra);
      this.updateThumbsSize();
    }
  }, {
    key: "onDropzoneRemovedFile",
    value: function onDropzoneRemovedFile(file) {
      var _get2;
      for (var _len2 = arguments.length, extra = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        extra[_key2 - 1] = arguments[_key2];
      }
      (_get2 = media_get(media_getPrototypeOf(PageMedia.prototype), "onDropzoneRemovedFile", this)).call.apply(_get2, [this, file].concat(extra));
      this.updateMediaCount();
      if (this.sortable) {
        this.sortable.options.onSort();
      }
    }
  }, {
    key: "updateThumbsSize",
    value: function updateThumbsSize() {
      var status = JSON.parse(cookies.get('grav-admin-pagemedia') || '{}');
      if (status.width) {
        var input = this.container.closest('.pagemedia-field').find('.media-resizer');
        updateMediaSizes(input[0], status.width, false);
      }
    }
  }, {
    key: "updateMediaCount",
    value: function updateMediaCount() {
      var element = this.container.closest('.pagemedia-field').find('[data-pagemedia-count]');
      element.text("(".concat(this.dropzone.files.length, ")"));
    }
  }, {
    key: "attachDragDrop",
    value: function attachDragDrop() {
      var _this3 = this;
      this.container.delegate('[data-dz-insert]', 'click', function (e) {
        var target = external_jQuery_default()(e.currentTarget).parent('.dz-preview').find('.dz-filename');
        var editor = editor_Instance.editors.filter(function (index, editor) {
          return external_jQuery_default()(editor).attr('name') === 'data[content]';
        });
        if (editor.length) {
          editor = editor.data('codemirror');
          editor.focus();
          var filename = encodeURI(target.text());
          var shortcode = UriToMarkdown(filename);
          editor.doc.replaceSelection(shortcode);
        }
      });
      this.container.delegate('[data-dz-view]', 'mouseenter', function (e) {
        var target = external_jQuery_default()(e.currentTarget);
        var file = target.parent('.dz-preview').find('.dz-filename');
        var filename = encodeURI(file.text());
        var URL = target.closest('[data-media-path]').data('media-path');
        var original = _this3.dropzone.files.filter(function (file) {
          return encodeURI(file.name) === filename;
        }).shift();
        original = original && (original.extras && original.extras.original || encodeURI(original.name));
        target.attr('href', "".concat(URL, "/").concat(original));
      });
      this.container.delegate('[data-dz-metadata]', 'click', function (e) {
        e.preventDefault();
        var target = external_jQuery_default()(e.currentTarget);
        var file = target.parent('.dz-preview').find('.dz-filename');
        var filename = encodeURI(file.text());
        var cleanName = file.text().replace('<', '&lt;').replace('>', '&gt;');
        var fileObj = _this3.dropzone.files.filter(function (file) {
          return file.name === __webpack_require__.g.decodeURI(filename);
        }).shift() || {};
        if (!fileObj.extras) {
          fileObj.extras = {
            metadata: []
          };
        }
        if (Array.isArray(fileObj.extras.metadata) && !fileObj.extras.metadata.length) {
          fileObj.extras.metadata = {
            '': "".concat(cleanName, ".meta.yaml doesn't exist")
          };
        }
        fileObj = fileObj.extras;
        var modal_element = external_jQuery_default()('body').find('[data-remodal-id="metadata"]');
        var modal = (external_jQuery_default()).remodal.lookup[modal_element.data('remodal')];
        modal_element.find('h1 strong').html(cleanName);
        if (fileObj.url) {
          modal_element.find('.meta-preview').html("<img src=\"".concat(fileObj.url, "\" />"));
        }
        var container = modal_element.find('.meta-content').html('<ul />').find('ul');
        Object.keys(fileObj.metadata).forEach(function (meta) {
          var cleanMeta = fileObj.metadata[meta].replace('<', '&lt;').replace('>', '&gt;');
          container.append("<li><strong>".concat(meta ? meta + ':' : '', "</strong> ").concat(cleanMeta, "</li>"));
        });
        modal.open();
      });
      this.container.delegate('.dz-preview', 'dragstart', function (e) {
        var target = external_jQuery_default()(e.currentTarget);
        var uri = encodeURI(target.find('.dz-filename').text());
        var shortcode = UriToMarkdown(uri);
        _this3.dropzone.disable();
        target.addClass('hide-backface');
        e.originalEvent.dataTransfer.effectAllowed = 'copy';
        e.originalEvent.dataTransfer.setData('text', shortcode);
      });
      this.container.delegate('.dz-preview', 'dragend', function (e) {
        var target = external_jQuery_default()(e.currentTarget);
        _this3.dropzone.enable();
        target.removeClass('hide-backface');
      });
    }
  }]);
}(FilesField);

var updateMediaSizes = function updateMediaSizes(input, width) {
  var store = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
  var storageLocation = input.dataset.storageLocation || 'grav-admin-pagemedia';
  var status = JSON.parse(cookies.get(storageLocation) || '{}');
  var height = 150 * width / 200;
  var media = external_jQuery_default()(input).closest('.pagemedia-field').find('.dz-details, [data-dz-thumbnail]');
  media.css({
    width: width,
    height: height
  });
  if (store) {
    var data = Object.assign({}, status, {
      width: width
    });
    cookies.set(storageLocation, JSON.stringify(data), {
      expires: Infinity
    });
  }
};
var updateMediaCollapseStatus = function updateMediaCollapseStatus(element) {
  var store = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  var storageLocation = element.dataset.storageLocation || 'grav-admin-pagemedia';
  var status = JSON.parse(cookies.get(storageLocation) || '{}');
  element = external_jQuery_default()(element);
  var icon = element.find('i.fa');
  var container = element.closest('.pagemedia-field');
  var panel = container.find('.form-data');
  var slider = container.find('.media-resizer').parent();
  var isCollapsed = !icon.hasClass('fa-chevron-down');
  var collapsed = !isCollapsed;
  icon.removeClass('fa-chevron-down fa-chevron-right').addClass(isCollapsed ? 'fa-chevron-down' : 'fa-chevron-right');
  slider[isCollapsed ? 'removeClass' : 'addClass']('hidden');
  panel[isCollapsed ? 'slideDown' : 'slideUp']();
  if (store) {
    var data = Object.assign({}, status, {
      collapsed: collapsed
    });
    cookies.set(storageLocation, JSON.stringify(data), {
      expires: Infinity
    });
  }
};
external_jQuery_default()(document).on('input', '.media-resizer', function (event) {
  var target = external_jQuery_default()(event.currentTarget);
  var width = target.val();
  updateMediaSizes(event.currentTarget, width);
});
external_jQuery_default()(document).on('click', '.media-collapser', function (event) {
  updateMediaCollapseStatus(event.currentTarget);
});
external_jQuery_default()(document).ready(function () {
  external_jQuery_default()('.media-resizer').each(function (index, input) {
    var storageLocation = input.dataset.storageLocation || 'grav-admin-pagemedia';
    var status = JSON.parse(cookies.get(storageLocation) || '{}');
    if (status.width) {
      updateMediaSizes(input, status.width, false);
    }
  });
});
var media_Instance = new PageMedia();
;// CONCATENATED MODULE: ./app/pages/page/multilang.js

external_jQuery_default()('[name="task"][value="saveas"], [name="task"][value="switchlanguage"]').on('mousedown touchstart', function (event) {
  var fields = ['lang', 'redirect'];
  var element = external_jQuery_default()(event.currentTarget);
  var form = external_jQuery_default()("#".concat(element.attr('form')));
  if (!form.length) {
    return;
  }
  fields.forEach(function (field) {
    var value = element.attr(field);
    if (!value) {
      return;
    }
    var input = form.find("[name=\"data[".concat(field, "]\"]"));
    if (!input.length) {
      input = external_jQuery_default()("<input type=\"hidden\" name=\"data[".concat(field, "]\" value=\"\" />"));
      form.append(input);
    }
    input.val(value);
  });
  return true;
});
;// CONCATENATED MODULE: ./app/pages/page/index.js








var page_switcher = external_jQuery_default()('input[type="radio"][name="mode-switch"]');
if (page_switcher) {
  var page_link = page_switcher.closest(':checked').data('leave-url');
  var fakeLink = external_jQuery_default()("<a href=\"".concat(page_link, "\" />"));
  page_switcher.parent().append(fakeLink);
  page_switcher.siblings('label').on('mousedown touchdown', function (event) {
    event.preventDefault();

    // let remodal = $.remodal.lookup[$('[data-remodal-id="changes"]').data('remodal')];
    var confirm = external_jQuery_default()('[data-remodal-id="changes"] [data-leave-action="continue"]');
    confirm.one('click', function () {
      external_jQuery_default()(__webpack_require__.g).on('beforeunload._grav');
      fakeLink.off('click._grav');
      external_jQuery_default()(event.target).trigger('click');
    });
    fakeLink.trigger('click._grav');
  });
  page_switcher.on('change', function (event) {
    var radio = external_jQuery_default()(event.target);
    page_link = radio.data('leave-url');
    setTimeout(function () {
      return fakeLink.attr('href', page_link).get(0).click();
    }, 5);
  });
}
/* harmony default export */ const page = ({
  Media: {
    PageMedia: PageMedia,
    PageMediaInstances: media_Instance
  }
});
;// CONCATENATED MODULE: ./app/pages/index.js




var pad = function pad(n, s) {
  return "000".concat(n).substr(-s);
};

// Pages Ordering
var Ordering = null;
var orderingElement = external_jQuery_default()('#ordering');
if (orderingElement.length) {
  Ordering = new sortable_esm/* default */.Ay(orderingElement.get(0), {
    filter: '.ignore',
    onUpdate: function onUpdate() {
      /* Old single page index behavior
       let item = $(event.item);
      let index = orderingElement.children().index(item) + 1;
      $('[data-order]').val(index);
      */

      var indexes = [];
      var children = orderingElement.children();
      var padZero = (children.length + '').split('').length;
      children.each(function (index, item) {
        item = external_jQuery_default()(item);
        indexes.push(item.data('id'));
        item.find('.page-order').text("".concat(pad(index + 1, padZero), "."));
      });
      external_jQuery_default()('[data-order]').val(indexes.join(','));
    }
  });
  external_jQuery_default()(document).on('input', '[name="data[folder]"]', function (event) {
    var target = external_jQuery_default()(event.currentTarget);
    var activeOrder = external_jQuery_default()('[data-id][data-active-id]');
    activeOrder.data('id', target.val());
    Ordering.options.onUpdate();
  });
}
/* harmony default export */ const pages = ({
  Ordering: Ordering,
  Page: page,
  PageFilters: {
    PageFilters: PagesFilter,
    Instance: filter_Instance
  }
});
// EXTERNAL MODULE: ./node_modules/immutable/dist/immutable.es.js
var immutable_es = __webpack_require__(49568);
// EXTERNAL MODULE: ./node_modules/immutablediff/src/diff.js
var src_diff = __webpack_require__(57038);
var diff_default = /*#__PURE__*/__webpack_require__.n(src_diff);
;// CONCATENATED MODULE: ./app/forms/state.js
function state_typeof(o) { "@babel/helpers - typeof"; return state_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, state_typeof(o); }
function state_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function state_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, state_toPropertyKey(o.key), o); } }
function state_createClass(e, r, t) { return r && state_defineProperties(e.prototype, r), t && state_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function state_toPropertyKey(t) { var i = state_toPrimitive(t, "string"); return "symbol" == state_typeof(i) ? i : i + ""; }
function state_toPrimitive(t, r) { if ("object" != state_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != state_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




var FormLoadState = {};
var DOMBehaviors = {
  attach: function attach() {
    this.preventUnload();
    this.preventClickAway();
  },
  preventUnload: function preventUnload() {
    var selector = '[name="task"][value^="save"], [data-delete-action], [data-flex-safe-action]';
    // jQuery 3.x removed $._data, use $._data only if available (jQuery < 3.0)
    // or check with jQuery's internal data store for jQuery >= 3.0
    try {
      var hasData = typeof (external_jQuery_default())._data === 'function';
      if (hasData && external_jQuery_default()._data(window, 'events') && (external_jQuery_default()._data(window, 'events').beforeunload || []).filter(function (event) {
        return event.namespace === '_grav';
      }).length) {
        return;
      }
    } catch (e) {
      // $._data not available in jQuery 3.x+, continue with adding event handler
    }

    // Allow some elements to leave the page without native confirmation
    external_jQuery_default()(selector).on('click._grav', function (event) {
      external_jQuery_default()(__webpack_require__.g).off('beforeunload');
    });

    // Catch browser uri change / refresh attempt and stop it if the form state is dirty
    external_jQuery_default()(__webpack_require__.g).on('beforeunload._grav', function () {
      if (state_Instance.equals() === false) {
        return 'You have made changes on this page that you have not yet confirmed. If you navigate away from this page you will lose your unsaved changes.';
      }
    });
  },
  preventClickAway: function preventClickAway() {
    var selector = 'a[href]:not([href^="#"]):not([target="_blank"]):not([href^="javascript:"])';

    // jQuery 3.x removed $._data, use $._data only if available (jQuery < 3.0)
    try {
      var hasData = typeof (external_jQuery_default())._data === 'function';
      var element = external_jQuery_default()(selector).get(0);
      if (element && hasData && external_jQuery_default()._data(element, 'events') && (external_jQuery_default()._data(element, 'events').click || []).filter(function (event) {
        return event.namespace === '_grav';
      })) {
        return;
      }
    } catch (e) {
      // $._data not available in jQuery 3.x+, continue with adding event handler
    }

    // Prevent clicking away if the form state is dirty
    // instead, display a confirmation before continuing
    external_jQuery_default()(selector).on('click._grav', function (event) {
      var isClean = state_Instance.equals();
      if (isClean === null || isClean) {
        return true;
      }
      event.preventDefault();
      var destination = external_jQuery_default()(this).attr('href');
      var modal = external_jQuery_default()('[data-remodal-id="changes"]');
      var lookup = (external_jQuery_default()).remodal.lookup[modal.data('remodal')];
      var buttons = external_jQuery_default()('a.button', modal);
      var handler = function handler(event) {
        event.preventDefault();
        var action = external_jQuery_default()(this).data('leave-action');
        buttons.off('click', handler);
        lookup.close();
        if (action === 'continue') {
          external_jQuery_default()(__webpack_require__.g).off('beforeunload');
          __webpack_require__.g.location.href = destination;
        }
      };
      buttons.on('click', handler);
      lookup.open();
    });
  }
};
var FormState = /*#__PURE__*/function () {
  function FormState() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
      ignore: [],
      form_id: 'blueprints'
    };
    state_classCallCheck(this, FormState);
    this.options = options;
    this.refresh();
    if (!this.form || !this.fields.length) {
      return;
    }
    FormLoadState = this.collect();
    this.loadState = FormLoadState;
    DOMBehaviors.attach();
  }
  return state_createClass(FormState, [{
    key: "refresh",
    value: function refresh() {
      this.form = external_jQuery_default()("form#".concat(this.options.form_id)).filter(':noparents(.remodal)');
      this.fields = external_jQuery_default()("form#".concat(this.options.form_id, " *, [form=\"").concat(this.options.form_id, "\"]")).filter(':input:not(.no-form)').filter(':noparents(.remodal)');
      return this;
    }
  }, {
    key: "collect",
    value: function collect() {
      var _this = this;
      if (!this.form || !this.fields.length) {
        return;
      }
      var values = {};
      this.refresh().fields.each(function (index, field) {
        field = external_jQuery_default()(field);
        var name = field.prop('name');
        var type = field.prop('type');
        var tag = field.prop('tagName').toLowerCase();
        var value;
        if (name.startsWith('toggleable_') || name === 'data[lang]' || name === 'data[redirect]') {
          return;
        }
        switch (type) {
          case 'checkbox':
            value = field.is(':checked');
            break;
          case 'radio':
            if (!field.is(':checked')) {
              return;
            }
            value = field.val();
            break;
          default:
            value = field.val();
        }
        if (tag === 'select' && value === null) {
          value = '';
        }
        if (Array.isArray(value)) {
          value = value.join('|');
        }
        if (name && !~_this.options.ignore.indexOf(name)) {
          values[name] = value;
        }
      });
      return immutable_es/* default.OrderedMap */.Ay.OrderedMap(values);
    }
  }, {
    key: "diff",
    value: function diff() {
      return diff_default()(FormLoadState, this.collect());
    }

    // When the form doesn't exist or there are no fields, `equals` returns `null`
    // for this reason, _NEVER_ check with !Instance.equals(), use Instance.equals() === false
  }, {
    key: "equals",
    value: function equals() {
      if (!this.form || !this.fields.length) {
        return null;
      }
      return immutable_es/* default.is */.Ay.is(FormLoadState, this.collect());
    }
  }]);
}();

;
var state_Instance = new FormState();

;// CONCATENATED MODULE: ./app/forms/form.js
function form_typeof(o) { "@babel/helpers - typeof"; return form_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, form_typeof(o); }
function form_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function form_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, form_toPropertyKey(o.key), o); } }
function form_createClass(e, r, t) { return r && form_defineProperties(e.prototype, r), t && form_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function form_toPropertyKey(t) { var i = form_toPrimitive(t, "string"); return "symbol" == form_typeof(i) ? i : i + ""; }
function form_toPrimitive(t, r) { if ("object" != form_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != form_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


/* Dependencies for checking if changes happened since load on a form
import toastr from '../utils/toastr';
import { translations } from 'grav-config';
import { Instance as FormState } from './state';
*/
var Form = /*#__PURE__*/function () {
  function Form(form) {
    var _this = this;
    form_classCallCheck(this, Form);
    this.form = external_jQuery_default()(form);
    if (!this.form.length || this.form.prop('tagName').toLowerCase() !== 'form') {
      return;
    }

    /* Option for not saving while nothing in a form has changed
     this.form.on('submit', (event) => {
        if (FormState.equals()) {
            event.preventDefault();
            toastr.info(translations.PLUGIN_ADMIN.NOTHING_TO_SAVE);
        }
    }); */

    this._attachShortcuts();
    this._attachToggleables();
    this._attachDisabledFields();
    this._submitUncheckedFields();
    this.observer = new MutationObserver(this.addedNodes);
    this.form.each(function (index, form) {
      return _this.observer.observe(form, {
        subtree: true,
        childList: true
      });
    });
  }
  return form_createClass(Form, [{
    key: "_attachShortcuts",
    value: function _attachShortcuts() {
      // CTRL + S / CMD + S - shortcut for [Save] when available
      var saveTask = external_jQuery_default()('#titlebar [name="task"][value="save"][form="blueprints"]');
      if (saveTask.length) {
        external_jQuery_default()(__webpack_require__.g).on('keydown', function (event) {
          var key = String.fromCharCode(event.which).toLowerCase();
          if (!event.shiftKey && (event.ctrlKey && !event.altKey || event.metaKey) && key === 's') {
            event.preventDefault();
            saveTask.click();
          }
        });
      }
    }
  }, {
    key: "_attachToggleables",
    value: function _attachToggleables() {
      var query = '[data-grav-field="toggleable"] input[type="checkbox"]';
      this.form.on('change', query, function (event) {
        var toggle = external_jQuery_default()(event.target);
        var enabled = toggle.is(':checked');
        var parent = toggle.closest('.form-field');
        var label = parent.find('label.toggleable');
        var fields = parent.find('.form-data');
        var inputs = fields.find('input, select, textarea, button');
        label.add(fields).css('opacity', enabled ? '' : 0.7);
        inputs.map(function (index, input) {
          var isSelectize = input.selectize;
          input = external_jQuery_default()(input);
          if (isSelectize) {
            isSelectize[enabled ? 'enable' : 'disable']();
          } else {
            input.prop('disabled', !enabled);
          }
        });
      });
      this.form.find(query).trigger('change');
    }
  }, {
    key: "_attachDisabledFields",
    value: function _attachDisabledFields() {
      var prefix = '.form-field-toggleable .form-data';
      var query = [];
      ['input', 'select', 'label[for]', 'textarea', '.selectize-control'].forEach(function (item) {
        query.push("".concat(prefix, " ").concat(item));
      });
      this.form.on('mousedown', query.join(', '), function (event) {
        var input = external_jQuery_default()(event.target);
        var isFor = input.prop('for');
        var isSelectize = (input.hasClass('selectize-control') || input.parents('.selectize-control')).length;
        if (isFor) {
          input = external_jQuery_default()("[id=\"".concat(isFor, "\"]"));
        }
        if (isSelectize) {
          input = input.closest('.selectize-control').siblings('select[name]');
        }
        if (!input.prop('disabled')) {
          return true;
        }
        var toggle = input.closest('.form-field').find('[data-grav-field="toggleable"] input[type="checkbox"]');
        toggle.trigger('click');
      });
    }
  }, {
    key: "_submitUncheckedFields",
    value: function _submitUncheckedFields() {
      var submitted = false;
      this.form.each(function (index, form) {
        form = external_jQuery_default()(form);
        form.on('submit', function () {
          // workaround for MS Edge, submitting multiple forms at the same time
          if (submitted) {
            return false;
          }
          var formId = form.attr('id');
          var unchecked = form.find('input[type="checkbox"]:not(:checked):not(:disabled)');
          var submit = form.find('[type="submit"]').add("[form=\"".concat(formId, "\"][type=\"submit\"]"));
          if (!unchecked.length) {
            return true;
          }
          submit.addClass('pointer-events-disabled');
          unchecked.each(function (index, element) {
            element = external_jQuery_default()(element);
            var name = element.prop('name');
            var fake = external_jQuery_default()("<input type=\"hidden\" name=\"".concat(name, "\" value=\"0\" />"));
            form.append(fake);
          });
          submitted = true;
          return true;
        });
      });
    }
  }, {
    key: "addedNodes",
    value: function addedNodes(mutations) {
      var _this2 = this;
      mutations.forEach(function (mutation) {
        if (mutation.type !== 'childList') {
          return;
        }
        if (mutation.addedNodes) {
          external_jQuery_default()('body').trigger('mutation._grav', mutation.target, mutation, _this2);
        }
        if (mutation.removedNodes) {
          external_jQuery_default()('body').trigger('mutation_removed._grav', {
            target: mutation.target,
            mutation: mutation
          }, _this2);
        }
      });
    }
  }]);
}();

var form_Instance = new Form('form#blueprints');
;// CONCATENATED MODULE: ./app/forms/fields/filepicker.js
function filepicker_typeof(o) { "@babel/helpers - typeof"; return filepicker_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, filepicker_typeof(o); }
function filepicker_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function filepicker_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, filepicker_toPropertyKey(o.key), o); } }
function filepicker_createClass(e, r, t) { return r && filepicker_defineProperties(e.prototype, r), t && filepicker_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function filepicker_toPropertyKey(t) { var i = filepicker_toPrimitive(t, "string"); return "symbol" == filepicker_typeof(i) ? i : i + ""; }
function filepicker_toPrimitive(t, r) { if ("object" != filepicker_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != filepicker_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




// const insertTextAt = (string, index, text) => [string.slice(0, index), text, string.slice(index)].join('');
var FilePickerField = /*#__PURE__*/function () {
  function FilePickerField(options) {
    var _this = this;
    filepicker_classCallCheck(this, FilePickerField);
    this.items = external_jQuery_default()();
    this.options = Object.assign({}, this.defaults, options);
    external_jQuery_default()('[data-grav-filepicker]').each(function (index, element) {
      return _this.addItem(element);
    });
    external_jQuery_default()('body').on('mutation._grav', this._onAddedNodes.bind(this));
  }
  return filepicker_createClass(FilePickerField, [{
    key: "_onAddedNodes",
    value: function _onAddedNodes(event, target /* , record, instance */) {
      var _this2 = this;
      var fields = external_jQuery_default()(target).find('[data-grav-filepicker]');
      if (!fields.length) {
        return;
      }
      fields.each(function (index, field) {
        field = external_jQuery_default()(field);
        if (!~_this2.items.index(field)) {
          _this2.addItem(field);
        }
      });
    }
  }, {
    key: "addItem",
    value: function addItem(element) {
      element = external_jQuery_default()(element);
      this.items = this.items.add(element);
      var tag = element.prop('tagName').toLowerCase();
      var isInput = tag === 'input' || tag === 'select';
      var field = isInput ? element : element.find('input, select');
      var folder = '';
      var thumbs = {};
      var onDemand = field.closest('[data-ondemand]').length > 0;
      if (!field.length || field.get(0).selectize) {
        return;
      }
      var getData = function getData(field, callback) {
        var mode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'all';
        var url = external_GravAdmin_namespaceObject.config.current_url + ".json/task".concat(external_GravAdmin_namespaceObject.config.param_sep, "getFilesInFolder");
        var parent = field.closest('[data-grav-filepicker]');
        var name = parent.data('name');
        var value = parent.data('value');
        var params = JSON.stringify(external_GravAdmin_namespaceObject.uri_params || '{}');
        utils_request(url, {
          method: 'post',
          body: {
            name: name,
            params: params
          }
        }, function (response) {
          if (typeof response.files === 'undefined') {
            return;
          }
          var data = [];
          thumbs = response.thumbs || {};
          for (var i = 0; i < response.files.length; i++) {
            if (mode === 'selected' && response.files[i] !== value) {
              continue;
            }
            data.push({
              'name': response.files[i],
              'status': 'available',
              thumb: thumbs[response.files[i]] || ''
            });
          }
          for (var _i = 0; _i < response.pending.length; _i++) {
            if (mode === 'selected' && response.pending[_i] !== value) {
              continue;
            }
            data.push({
              'name': response.pending[_i],
              'status': 'pending',
              thumb: thumbs[response.pending[_i]] || ''
            });
          }
          folder = response.folder;
          callback(data, value);
        });
      };
      var imagesPreview = field.closest('[data-preview-images]').length > 0;
      var selectedIsRendered = false;
      var renderOption = function renderOption(item, escape) {
        var image = '';
        if (imagesPreview && folder && (!item.status || item.status === 'available') && item.name.match(/\.(jpg|jpeg|png|gif|webp|avif)$/i)) {
          // const fallback2x = insertTextAt(`${config.base_url_relative}/../${folder}/${item.name}`, -4, '@2x');
          // const fallback3x = insertTextAt(`${config.base_url_relative}/../${folder}/${item.name}`, -4, '@3x');
          var source = thumbs[item.name] || "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/../").concat(folder, "/").concat(item.name);

          // onerror="if(this.src==='${fallback2x}'){this.src='${fallback3x}';}else{this.src='${fallback2x}'}"
          image = "<img class=\"filepicker-field-image\" src=\"".concat(source, "\" />");
        }
        return "<div>\n                        <span class=\"title\">\n                            ".concat(image, " <span class=\"name filepicker-field-name\">").concat(escape(item.name), "</span>\n                        </span>\n                    </div>");
      };
      field.selectize({
        plugins: ['required-fix'],
        valueField: 'name',
        labelField: 'name',
        searchField: 'name',
        optgroups: [{
          $order: 1,
          value: 'pending',
          label: 'Pending'
        }, {
          $order: 2,
          value: 'available',
          label: 'Available'
        }],
        optgroupField: 'status',
        // lockOptgroupOrder: true,
        create: false,
        preload: false,
        // 'focus',
        render: {
          option: function option(item, escape) {
            return renderOption(item, escape);
          },
          item: function item(_item, escape) {
            return renderOption(_item, escape);
          }
        },
        onInitialize: function onInitialize() {
          if (!onDemand) {
            this.load(function (callback) {
              return getData(field, function (data) {
                return callback(data);
              }, 'selected');
            });
          }
        },
        onLoad: function onLoad( /* data */
        ) {
          if (!selectedIsRendered) {
            var name = this.getValue();
            this.updateOption(name, {
              name: name
            });
            selectedIsRendered = true;
          }
        },
        onFocus: function onFocus() {
          this.load(function (callback) {
            return getData(field, function (data) {
              return callback(data);
            });
          });
        }
      });
    }
  }]);
}();

var filepicker_Instance = new FilePickerField();
;// CONCATENATED MODULE: ./app/utils/selectize-option-click.js


selectize_default().define('option_click', function (options) {
  var self = this;
  var setup = self.setup;
  this.setup = function () {
    setup.apply(self, arguments);
    var clicking = false;

    // Detect click on a .clickable
    self.$dropdown_content.on('mousedown click', function (e) {
      var target = external_jQuery_default()(e.target);
      if (target.hasClass('clickable') || target.closest('.clickable').length) {
        if (e.type === 'mousedown') {
          clicking = true;
          self.isFocused = false; // awful hack to defuse the document mousedown listener
        } else {
          self.isFocused = true;
          setTimeout(function () {
            clicking = false; // wait until blur has been preempted
          });
        }
      } else {
        // cleanup in case user right-clicked or dragged off the element
        clicking = false;
        self.isFocused = true;
      }
    });

    // Intercept default handlers
    self.$dropdown.off('mousedown click', '[data-selectable]').on('mousedown click', '[data-selectable]', function () {
      if (!clicking) {
        return self.onOptionSelect.apply(self, arguments);
      }
    });
    self.$control_input.off('blur').on('blur', function () {
      if (!clicking) {
        return self.onBlur.apply(self, arguments);
      }
    });
  };
});
;// CONCATENATED MODULE: ./app/forms/fields/selectize.js
function selectize_typeof(o) { "@babel/helpers - typeof"; return selectize_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, selectize_typeof(o); }
function selectize_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function selectize_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, selectize_toPropertyKey(o.key), o); } }
function selectize_createClass(e, r, t) { return r && selectize_defineProperties(e.prototype, r), t && selectize_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function selectize_toPropertyKey(t) { var i = selectize_toPrimitive(t, "string"); return "symbol" == selectize_typeof(i) ? i : i + ""; }
function selectize_toPrimitive(t, r) { if ("object" != selectize_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != selectize_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




var PagesRoute = {
  option: function option(item, escape) {
    var label = escape(item.text).split(' ');
    var arrows = label.shift();
    var slug = label.shift();
    return "<div class=\"selectize-route-option\">\n            <span class=\"text-grey\">".concat(arrows, "</span>\n            <span>\n                <span class=\"text-update\">").concat(slug.replace('(', '/').replace(')', ''), "</span>\n                <span>").concat(label.join(' '), "</span>\n            </span>\n        </div>");
  }
};
var SelectizeField = /*#__PURE__*/function () {
  function SelectizeField() {
    var _this = this;
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    selectize_classCallCheck(this, SelectizeField);
    this.options = Object.assign({}, options);
    this.elements = [];
    external_jQuery_default()('[data-grav-selectize]').each(function (index, element) {
      return _this.add(element);
    });
    external_jQuery_default()('body').on('mutation._grav', this._onAddedNodes.bind(this));
  }
  return selectize_createClass(SelectizeField, [{
    key: "add",
    value: function add(element) {
      element = external_jQuery_default()(element);
      if (element.closest('template').length) {
        return false;
      }
      var tag = element.prop('tagName').toLowerCase();
      var isInput = tag === 'input' || tag === 'select';
      var data = (isInput ? element.closest('[data-grav-selectize]') : element).data('grav-selectize') || {};
      var field = isInput ? element : element.find('input, select');
      if (field.attr('name') === 'data[route]') {
        data = external_jQuery_default().extend({}, data, {
          render: PagesRoute
        });
      }
      if (!field.length || field.get(0).selectize) {
        return;
      }
      var plugins = external_jQuery_default().merge(data.plugins ? data.plugins : [], ['required-fix']);
      field.selectize(external_jQuery_default().extend({}, data, {
        plugins: plugins
      }));
      this.elements.push(field.data('selectize'));
    }
  }, {
    key: "_onAddedNodes",
    value: function _onAddedNodes(event, target /* , record, instance */) {
      var _this2 = this;
      var fields = external_jQuery_default()(target).find('select.fancy, input.fancy, [data-grav-selectize]').filter(function (index, element) {
        return !external_jQuery_default()(element).closest('template').length;
      });
      if (!fields.length) {
        return;
      }
      fields.each(function (index, field) {
        return _this2.add(field);
      });
    }
  }]);
}();

var selectize_Instance = new SelectizeField();
;// CONCATENATED MODULE: ./app/forms/fields/array.js
function array_typeof(o) { "@babel/helpers - typeof"; return array_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, array_typeof(o); }
function array_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function array_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, array_toPropertyKey(o.key), o); } }
function array_createClass(e, r, t) { return r && array_defineProperties(e.prototype, r), t && array_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function array_toPropertyKey(t) { var i = array_toPrimitive(t, "string"); return "symbol" == array_typeof(i) ? i : i + ""; }
function array_toPrimitive(t, r) { if ("object" != array_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != array_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


var body = external_jQuery_default()('body');
var Template = /*#__PURE__*/function () {
  function Template(container) {
    array_classCallCheck(this, Template);
    this.container = external_jQuery_default()(container);
    if (this.getName() === undefined) {
      this.container = this.container.closest('[data-grav-array-name]');
    }
  }
  return array_createClass(Template, [{
    key: "getName",
    value: function getName() {
      return this.container.data('grav-array-name') || '';
    }
  }, {
    key: "getKeyPlaceholder",
    value: function getKeyPlaceholder() {
      return this.container.data('grav-array-keyname') || 'Key';
    }
  }, {
    key: "getValuePlaceholder",
    value: function getValuePlaceholder() {
      return this.container.data('grav-array-valuename') || 'Value';
    }
  }, {
    key: "isValueOnly",
    value: function isValueOnly() {
      return this.container.find('[data-grav-array-mode="value_only"]:first').length || false;
    }
  }, {
    key: "isTextArea",
    value: function isTextArea() {
      return this.container.data('grav-array-textarea') || false;
    }
  }, {
    key: "shouldBeDisabled",
    value: function shouldBeDisabled() {
      // check for toggleables, if field is toggleable and it's not enabled, render disabled
      var toggle = this.container.closest('.form-field').find('[data-grav-field="toggleable"] input[type="checkbox"]');
      return toggle.length && toggle.is(':not(:checked)');
    }
  }, {
    key: "getNewRow",
    value: function getNewRow() {
      var tpl = '';
      var value = this.isTextArea() ? "<textarea ".concat(this.shouldBeDisabled() ? 'disabled="disabled"' : '', " data-grav-array-type=\"value\" name=\"\" placeholder=\"").concat(this.getValuePlaceholder(), "\"></textarea>") : "<input ".concat(this.shouldBeDisabled() ? 'disabled="disabled"' : '', " data-grav-array-type=\"value\" type=\"text\" name=\"\" value=\"\"  placeholder=\"").concat(this.getValuePlaceholder(), "\" />");
      if (this.isValueOnly()) {
        tpl += "\n            <div class=\"form-row array-field-value_only\" data-grav-array-type=\"row\">\n                <span data-grav-array-action=\"sort\" class=\"fa fa-bars\"></span>\n                ".concat(value, "\n            ");
      } else {
        tpl += "\n            <div class=\"form-row\" data-grav-array-type=\"row\">\n                <span data-grav-array-action=\"sort\" class=\"fa fa-bars\"></span>\n                <input ".concat(this.shouldBeDisabled() ? 'disabled="disabled"' : '', " data-grav-array-type=\"key\" type=\"text\" value=\"\" placeholder=\"").concat(this.getKeyPlaceholder(), "\" />\n                ").concat(value, "\n            ");
      }
      tpl += "\n            <span data-grav-array-action=\"rem\" class=\"fa fa-minus\"></span>\n            <span data-grav-array-action=\"add\" class=\"fa fa-plus\"></span>\n        </div>";
      return tpl;
    }
  }]);
}();
var ArrayField = /*#__PURE__*/function () {
  function ArrayField() {
    var _this = this;
    array_classCallCheck(this, ArrayField);
    body.on('input', '[data-grav-array-type="key"], [data-grav-array-type="value"]', function (event) {
      return _this.actionInput(event);
    });
    body.on('click touch', '[data-grav-array-action]:not([data-grav-array-action="sort"])', function (event) {
      return _this.actionEvent(event);
    });
    this.arrays = external_jQuery_default()();
    external_jQuery_default()('[data-grav-field="array"]').each(function (index, list) {
      return _this.addArray(list);
    });
    external_jQuery_default()('body').on('mutation._grav', this._onAddedNodes.bind(this));
  }
  return array_createClass(ArrayField, [{
    key: "addArray",
    value: function addArray(list) {
      var _this2 = this;
      list = external_jQuery_default()(list);
      list.find('[data-grav-array-type="container"]').each(function (index, container) {
        container = external_jQuery_default()(container);
        if (container.data('array-sort') || container[0].hasAttribute('data-array-nosort')) {
          return;
        }
        container.data('array-sort', new sortable_esm/* default */.Ay(container.get(0), {
          handle: '.fa-bars',
          animation: 150,
          onUpdate: function onUpdate() {
            var item = container.find('[data-grav-array-type="row"]:first');
            _this2._setTemplate(item);
            var template = item.data('array-template');
            _this2.refreshNames(template);
          }
        }));
      });
    }
  }, {
    key: "actionInput",
    value: function actionInput(event) {
      var element = external_jQuery_default()(event.target);
      var type = element.data('grav-array-type');
      this._setTemplate(element);
      var template = element.data('array-template');
      var keyElement = type === 'key' ? element : element.siblings('[data-grav-array-type="key"]:first');
      var valueElement = type === 'value' ? element : element.siblings('[data-grav-array-type="value"]:first');
      var escaped_name = !template.isValueOnly() ? keyElement.val() : this.getIndexFor(element);
      escaped_name = escaped_name.toString().replace(/\[/g, '%5B').replace(/]/g, '%5D');
      var name = "".concat(template.getName(), "[").concat(escaped_name, "]");
      if (!template.isValueOnly() && !keyElement.val() && !valueElement.val()) {
        valueElement.attr('name', '');
      } else {
        // valueElement.attr('name', !valueElement.val() ? template.getName() : name);
        valueElement.attr('name', name);
      }
      this.refreshNames(template);
    }
  }, {
    key: "actionEvent",
    value: function actionEvent(event) {
      event && event.preventDefault();
      var element = external_jQuery_default()(event.target);
      var action = element.data('grav-array-action');
      var container = element.parents('[data-grav-array-type="container"]');
      this._setTemplate(element);
      this["".concat(action, "Action")](element);
      var siblings = container.find('> div');
      container[siblings.length > 1 ? 'removeClass' : 'addClass']('one-child');
    }
  }, {
    key: "addAction",
    value: function addAction(element) {
      var template = element.data('array-template');
      var row = element.closest('[data-grav-array-type="row"]');
      row.after(template.getNewRow());
    }
  }, {
    key: "remAction",
    value: function remAction(element) {
      var template = element.data('array-template');
      var row = element.closest('[data-grav-array-type="row"]');
      var isLast = !row.siblings().length;
      if (isLast) {
        var newRow = external_jQuery_default()(template.getNewRow());
        row.after(newRow);
        newRow.find('[data-grav-array-type="value"]:last').attr('name', template.getName());
      }
      row.remove();
      this.refreshNames(template);
    }
  }, {
    key: "refreshNames",
    value: function refreshNames(template) {
      if (!template.isValueOnly()) {
        return;
      }
      var row = template.container.find('> div > [data-grav-array-type="row"]');
      var inputs = row.find('[name]:not([name=""])');
      inputs.each(function (index, input) {
        input = external_jQuery_default()(input);
        var preserved_name = input.closest('[data-grav-array-name]');
        var name = "".concat(preserved_name.attr('data-grav-array-name'), "[").concat(index, "]");
        input.attr('name', name);
      });
      if (!inputs.length) {
        row.find('[data-grav-array-type="value"]').attr('name', template.getName());
      }
    }
  }, {
    key: "getIndexFor",
    value: function getIndexFor(element) {
      var template = element.data('array-template');
      var row = element.closest('[data-grav-array-type="row"]');
      return template.container.find("".concat(template.isValueOnly() ? '> div ' : '', " > [data-grav-array-type=\"row\"]")).index(row);
    }
  }, {
    key: "_setTemplate",
    value: function _setTemplate(element) {
      if (!element.data('array-template')) {
        element.data('array-template', new Template(element.closest('[data-grav-array-name]')));
      }
    }
  }, {
    key: "_onAddedNodes",
    value: function _onAddedNodes(event, target /* , record, instance */) {
      var _this3 = this;
      var arrays = external_jQuery_default()(target).find('[data-grav-field="array"]');
      if (!arrays.length) {
        return;
      }
      arrays.each(function (index, list) {
        list = external_jQuery_default()(list);
        if (!~_this3.arrays.index(list)) {
          _this3.addArray(list);
        }
      });
    }
  }]);
}();

var array_Instance = new ArrayField();
;// CONCATENATED MODULE: ./app/forms/fields/collections.js
function collections_typeof(o) { "@babel/helpers - typeof"; return collections_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, collections_typeof(o); }
function collections_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function collections_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, collections_toPropertyKey(o.key), o); } }
function collections_createClass(e, r, t) { return r && collections_defineProperties(e.prototype, r), t && collections_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function collections_toPropertyKey(t) { var i = collections_toPrimitive(t, "string"); return "symbol" == collections_typeof(i) ? i : i + ""; }
function collections_toPrimitive(t, r) { if ("object" != collections_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != collections_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



var CollectionsField = /*#__PURE__*/function () {
  function CollectionsField() {
    var _this = this;
    collections_classCallCheck(this, CollectionsField);
    this.lists = external_jQuery_default()();
    var body = external_jQuery_default()('body');
    external_jQuery_default()('[data-type="collection"]').each(function (index, list) {
      return _this.addList(list);
    });
    body.on('mutation._grav', this._onAddedNodes.bind(this));
    body.on('click', function (event) {
      var target = external_jQuery_default()(event.target);
      if (!(target.is('[data-action="confirm"], [data-action="delete"]') || target.closest('[data-action="confirm"], [data-action="delete"]').length)) {
        CollectionsField.closeConfirmations();
      }
    });
  }
  return collections_createClass(CollectionsField, [{
    key: "addList",
    value: function addList(list) {
      var _this2 = this;
      list = external_jQuery_default()(list);
      this.lists = this.lists.add(list);
      list.on('click', '> .collection-actions [data-action="add"]', function (event) {
        return _this2.addItem(event);
      });
      list.on('click', '> ul > li > .item-actions [data-action="confirm"]', function (event) {
        return _this2.confirmRemove(event);
      });
      list.on('click', '> ul > li > .item-actions [data-action="delete"]', function (event) {
        return _this2.removeItem(event);
      });
      list.on('click', '> ul > li > .item-actions [data-action="collapse"]', function (event) {
        return _this2.collapseItem(event);
      });
      list.on('click', '> ul > li > .item-actions [data-action="expand"]', function (event) {
        return _this2.expandItem(event);
      });
      list.on('click', '> .collection-actions [data-action-sort="date"]', function (event) {
        return _this2.sortItems(event);
      });
      list.on('click', '> .collection-actions [data-action="collapse_all"]', function (event) {
        return _this2.collapseItems(event);
      });
      list.on('click', '> .collection-actions [data-action="expand_all"]', function (event) {
        return _this2.expandItems(event);
      });
      list.on('input change', '[data-key-observe]', function (event) {
        return _this2.observeKey(event);
      });
      list.find('[data-collection-holder]').each(function (index, container) {
        container = external_jQuery_default()(container);
        if (container.data('collection-sort') || container[0].hasAttribute('data-collection-nosort')) {
          return;
        }
        container.data('collection-sort', new sortable_esm/* default */.Ay(container.get(0), {
          forceFallback: false,
          handle: '.collection-sort',
          animation: 150,
          onUpdate: function onUpdate() {
            return _this2.reindex(container);
          }
        }));
      });
      this._updateActionsStateBasedOnMinMax(list);
    }
  }, {
    key: "addItem",
    value: function addItem(event) {
      var button = external_jQuery_default()(event.currentTarget);
      var position = button.data('action-add') || 'bottom';
      var list = external_jQuery_default()(button.closest('[data-type="collection"]'));
      var template = external_jQuery_default()(list.find('> [data-collection-template="new"]').data('collection-template-html'));
      this._updateActionsStateBasedOnMinMax(list);
      var items = list.closest('[data-type="collection"]').find('> ul > [data-collection-item]');
      var maxItems = list.data('max');
      if (typeof maxItems !== 'undefined' && items.length >= maxItems) {
        return;
      }
      list.find('> [data-collection-holder]')[position === 'top' ? 'prepend' : 'append'](template);
      this.reindex(list);
      items = list.closest('[data-type="collection"]').find('> ul > [data-collection-item]');
      var topAction = list.closest('[data-type="collection"]').find('[data-action-add="top"]');
      var sortAction = list.closest('[data-type="collection"]').find('[data-action="sort"]');
      if (items.length) {
        if (topAction.length) {
          topAction.parent().removeClass('hidden');
        }
        if (sortAction.length && items.length > 1) {
          sortAction.removeClass('hidden');
        }
      }

      // refresh toggleables in a list
      external_jQuery_default()('[data-grav-field="toggleable"] input[type="checkbox"]').trigger('change');
    }
  }, {
    key: "confirmRemove",
    value: function confirmRemove(event) {
      var button = external_jQuery_default()(event.currentTarget);
      var list = external_jQuery_default()(button.closest('.item-actions'));
      var action = list.find('.list-confirm-deletion[data-action="delete"]');
      var isHidden = action.hasClass('hidden');
      CollectionsField.closeConfirmations();
      action[isHidden ? 'removeClass' : 'addClass']('hidden');
    }
  }, {
    key: "removeItem",
    value: function removeItem(event) {
      var button = external_jQuery_default()(event.currentTarget);
      var item = button.closest('[data-collection-item]');
      var list = external_jQuery_default()(button.closest('[data-type="collection"]'));
      var items = list.closest('[data-type="collection"]').find('> ul > [data-collection-item]');
      var minItems = list.data('min');
      if (typeof minItems !== 'undefined' && items.length <= minItems) {
        return;
      }
      item.remove();
      this.reindex(list);
      items = list.closest('[data-type="collection"]').find('> ul > [data-collection-item]');
      var topAction = list.closest('[data-type="collection"]').find('[data-action-add="top"]');
      var sortAction = list.closest('[data-type="collection"]').find('[data-action="sort"]');
      if (!items.length) {
        if (topAction.length) {
          topAction.parent().addClass('hidden');
        }
      }
      if (sortAction.length && items.length <= 1) {
        sortAction.addClass('hidden');
      }
      this._updateActionsStateBasedOnMinMax(list);
    }
  }, {
    key: "collapseItems",
    value: function collapseItems(event) {
      var button = external_jQuery_default()(event.currentTarget);
      var items = external_jQuery_default()(button.closest('[data-type="collection"]')).find('> ul > [data-collection-item] > .item-actions [data-action="collapse"]');
      items.click();
    }
  }, {
    key: "collapseItem",
    value: function collapseItem(event) {
      var button = external_jQuery_default()(event.currentTarget);
      var item = button.closest('[data-collection-item]');
      button.attr('data-action', 'expand').removeClass('fa-chevron-circle-down').addClass('fa-chevron-circle-right');
      item.addClass('collection-collapsed');
    }
  }, {
    key: "expandItems",
    value: function expandItems(event) {
      var button = external_jQuery_default()(event.currentTarget);
      var items = external_jQuery_default()(button.closest('[data-type="collection"]')).find('> ul > [data-collection-item] > .item-actions [data-action="expand"]');
      items.click();
    }
  }, {
    key: "expandItem",
    value: function expandItem(event) {
      var button = external_jQuery_default()(event.currentTarget);
      var item = button.closest('[data-collection-item]');
      button.attr('data-action', 'collapse').removeClass('fa-chevron-circle-right').addClass('fa-chevron-circle-down');
      item.removeClass('collection-collapsed');
    }
  }, {
    key: "sortItems",
    value: function sortItems(event) {
      var button = external_jQuery_default()(event.currentTarget);
      var sortby = button.data('action-sort');
      var sortby_dir = button.data('action-sort-dir') || 'asc';
      var list = external_jQuery_default()(button.closest('[data-type="collection"]'));
      var items = list.closest('[data-type="collection"]').find('> ul > [data-collection-item]');
      items.sort(function (a, b) {
        var A = external_jQuery_default()(a).find('[name$="[' + sortby + ']"]');
        var B = external_jQuery_default()(b).find('[name$="[' + sortby + ']"]');
        var sort;
        if (sortby_dir === 'asc') {
          sort = A.val() < B.val() ? -1 : A.val() > B.val() ? 1 : 0;
        } else {
          sort = A.val() > B.val() ? -1 : A.val() < B.val() ? 1 : 0;
        }
        return sort;
      }).each(function (_, container) {
        external_jQuery_default()(container).parent().append(container);
      });
      this.reindex(list);
    }
  }, {
    key: "observeKey",
    value: function observeKey(event) {
      var input = external_jQuery_default()(event.target);
      var value = input.val();
      var item = input.closest('[data-collection-key]');
      item.data('collection-key-backup', item.data('collection-key')).data('collection-key', value);
      this.reindex(null, item);
    }
  }, {
    key: "reindex",
    value: function reindex(list, items) {
      items = items || external_jQuery_default()(list).closest('[data-type="collection"]').find('> ul > [data-collection-item]');
      items.each(function (index, item) {
        item = external_jQuery_default()(item);
        var observed = item.find('[data-key-observe]');
        var observedValue = observed.val();
        var hasCustomKey = observed.length;
        var currentKey = item.data('collection-key-backup');
        item.attr('data-collection-key', hasCustomKey ? observedValue : index);
        ['name', 'data-grav-field-name', 'for', 'id', 'data-grav-file-settings', 'data-file-post-add', 'data-file-post-remove', 'data-grav-array-name', 'data-grav-elements'].forEach(function (prop) {
          item.find('[' + prop + '], [_' + prop + ']').each(function () {
            var element = external_jQuery_default()(this);
            var indexes = [];
            var array_index = null;
            var regexps = [new RegExp('\\[(\\d+|\\*|' + currentKey + ')\\]', 'g'), new RegExp('\\.(\\d+|\\*|' + currentKey + ')\\.', 'g')];

            // special case to preserve array field index keys
            if (prop === 'name' && element.data('gravArrayType')) {
              var match_index = element.attr(prop).match(/\[[0-9]{1,}\]$/);
              var pattern = element[0].closest('[data-grav-array-name]').dataset.gravArrayName;
              if (match_index && pattern) {
                array_index = match_index[0];
                element.attr(prop, "".concat(pattern).concat(match_index[0]));
                return;
              }
            }
            if (hasCustomKey && !observedValue) {
              element.attr("_".concat(prop), element.attr(prop));
              element.attr(prop, null);
              return;
            }
            if (element.attr("_".concat(prop))) {
              element.attr(prop, element.attr("_".concat(prop)));
              element.attr("_".concat(prop), null);
            }
            element.parents('[data-collection-key]').map(function (idx, parent) {
              return indexes.push(external_jQuery_default()(parent).attr('data-collection-key'));
            });
            indexes.reverse();
            var matchedKey = currentKey;
            var replaced = element.attr(prop).replace(regexps[0], function /* str, p1, offset */
            () {
              var extras = '';
              if (array_index) {
                extras = array_index;
                console.log(indexes, extras);
              }
              matchedKey = indexes.shift() || matchedKey;
              return "[".concat(matchedKey, "]").concat(extras);
            });
            replaced = replaced.replace(regexps[1], function /* str, p1, offset */
            () {
              matchedKey = indexes.shift() || matchedKey;
              return ".".concat(matchedKey, ".");
            });
            element.attr(prop, replaced);
          });
        });
      });
    }
  }, {
    key: "_onAddedNodes",
    value: function _onAddedNodes(event, target /* , record, instance */) {
      var _this3 = this;
      var collections = external_jQuery_default()(target).find('[data-type="collection"]');
      if (!collections.length) {
        return;
      }
      collections.each(function (index, collection) {
        collection = external_jQuery_default()(collection);
        if (!~_this3.lists.index(collection)) {
          _this3.addList(collection);
        }
      });
    }
  }, {
    key: "_updateActionsStateBasedOnMinMax",
    value: function _updateActionsStateBasedOnMinMax(list) {
      var items = list.closest('[data-type="collection"]').find('> ul > [data-collection-item]');
      var minItems = list.data('min');
      var maxItems = list.data('max');
      list.find('> .collection-actions [data-action="add"]').attr('disabled', false);
      list.find('> ul > li > .item-actions [data-action="delete"]').attr('disabled', false);
      if (typeof minItems !== 'undefined' && items.length <= minItems) {
        list.find('> ul > li > .item-actions [data-action="delete"]').attr('disabled', true);
      }
      if (typeof maxItems !== 'undefined' && items.length >= maxItems) {
        list.find('> .collection-actions [data-action="add"]').attr('disabled', true);
      }
    }
  }], [{
    key: "closeConfirmations",
    value: function closeConfirmations() {
      external_jQuery_default()('.list-confirm-deletion[data-action="delete"]').addClass('hidden');
    }
  }]);
}();

var collections_Instance = new CollectionsField();
// EXTERNAL MODULE: ./app/utils/bootstrap-datetimepicker.js
var bootstrap_datetimepicker = __webpack_require__(70086);
;// CONCATENATED MODULE: ./app/forms/fields/datetime.js
function datetime_typeof(o) { "@babel/helpers - typeof"; return datetime_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, datetime_typeof(o); }
function datetime_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function datetime_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, datetime_toPropertyKey(o.key), o); } }
function datetime_createClass(e, r, t) { return r && datetime_defineProperties(e.prototype, r), t && datetime_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function datetime_toPropertyKey(t) { var i = datetime_toPrimitive(t, "string"); return "symbol" == datetime_typeof(i) ? i : i + ""; }
function datetime_toPrimitive(t, r) { if ("object" != datetime_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != datetime_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



var DateTimeField = /*#__PURE__*/function () {
  function DateTimeField(options) {
    var _this = this;
    datetime_classCallCheck(this, DateTimeField);
    this.items = external_jQuery_default()();
    this.options = Object.assign({}, this.defaults, options);
    external_jQuery_default()('[data-grav-datetime]').each(function (index, field) {
      return _this.addItem(field);
    });
    external_jQuery_default()('body').on('mutation._grav', this._onAddedNodes.bind(this));
  }
  return datetime_createClass(DateTimeField, [{
    key: "defaults",
    get: function get() {
      return {
        showTodayButton: true,
        showClear: true,
        locale: external_GravAdmin_namespaceObject.config.language || 'en',
        icons: {
          time: 'fa fa-clock-o',
          date: 'fa fa-calendar-o',
          up: 'fa fa-chevron-up',
          down: 'fa fa-chevron-down',
          previous: 'fa fa-chevron-left',
          next: 'fa fa-chevron-right',
          today: 'fa fa-bullseye',
          clear: 'fa fa-trash-o',
          close: 'fa fa-remove'
        }
      };
    }
  }, {
    key: "addItem",
    value: function addItem(list) {
      list = external_jQuery_default()(list);
      this.items = this.items.add(list);
      if (list.data('DateTimePicker')) {
        return;
      }
      var options = Object.assign({}, this.options, list.data('grav-datetime') || {});
      list.datetimepicker(options).on('dp.show dp.update', this._disableDecades);
      list.siblings('.field-icons').on('click', function () {
        return list.mousedown().focus();
      });
    }
  }, {
    key: "_onAddedNodes",
    value: function _onAddedNodes(event, target /* , record, instance */) {
      var _this2 = this;
      var fields = external_jQuery_default()(target).find('[data-grav-datetime]');
      if (!fields.length) {
        return;
      }
      fields.each(function (index, field) {
        field = external_jQuery_default()(field);
        if (!~_this2.items.index(field)) {
          _this2.addItem(field);
        }
      });
    }
  }, {
    key: "_disableDecades",
    value: function _disableDecades() {
      external_jQuery_default()('.datepicker-years .picker-switch').removeAttr('title').on('click', function (e) {
        return e.stopPropagation();
      });
    }
  }]);
}();

var datetime_Instance = new DateTimeField();
// EXTERNAL MODULE: ./node_modules/mout/math/clamp.js
var clamp = __webpack_require__(14544);
var clamp_default = /*#__PURE__*/__webpack_require__.n(clamp);
// EXTERNAL MODULE: ./node_modules/mout/function/bind.js
var bind = __webpack_require__(91390);
var bind_default = /*#__PURE__*/__webpack_require__.n(bind);
;// CONCATENATED MODULE: ./app/utils/colors.js
// Parses a string and returns a valid hex string when possible
// parseHex('#fff') => '#ffffff'
var parseHex = function parseHex(string) {
  string = string.replace(/[^A-F0-9]/ig, '');
  if (string.length !== 3 && string.length !== 6) return '';
  if (string.length === 3) {
    string = string[0] + string[0] + string[1] + string[1] + string[2] + string[2];
  }
  return '#' + string.toLowerCase();
};

// Converts an HSB object to an RGB object
// hsb2rgb({h: 0, s: 0, b: 100}) => {r: 255, g: 255, b: 255}
var hsb2rgb = function hsb2rgb(hsb) {
  var rgb = {};
  var h = Math.round(hsb.h);
  var s = Math.round(hsb.s * 255 / 100);
  var v = Math.round(hsb.b * 255 / 100);
  if (s === 0) {
    rgb.r = rgb.g = rgb.b = v;
  } else {
    var t1 = v;
    var t2 = (255 - s) * v / 255;
    var t3 = (t1 - t2) * (h % 60) / 60;
    if (h === 360) h = 0;
    if (h < 60) {
      rgb.r = t1;
      rgb.b = t2;
      rgb.g = t2 + t3;
    } else if (h < 120) {
      rgb.g = t1;
      rgb.b = t2;
      rgb.r = t1 - t3;
    } else if (h < 180) {
      rgb.g = t1;
      rgb.r = t2;
      rgb.b = t2 + t3;
    } else if (h < 240) {
      rgb.b = t1;
      rgb.r = t2;
      rgb.g = t1 - t3;
    } else if (h < 300) {
      rgb.b = t1;
      rgb.g = t2;
      rgb.r = t2 + t3;
    } else if (h < 360) {
      rgb.r = t1;
      rgb.g = t2;
      rgb.b = t1 - t3;
    } else {
      rgb.r = 0;
      rgb.g = 0;
      rgb.b = 0;
    }
  }
  return {
    r: Math.round(rgb.r),
    g: Math.round(rgb.g),
    b: Math.round(rgb.b)
  };
};

// Converts an RGB object to a HEX string
// rgb2hex({r: 255, g: 255, b: 255}) => #ffffff
var rgb2hex = function rgb2hex(rgb) {
  var hex = [rgb.r.toString(16), rgb.g.toString(16), rgb.b.toString(16)];
  hex.forEach(function (val, nr) {
    if (val.length === 1) hex[nr] = '0' + val;
  });
  return '#' + hex.join('');
};

// Converts and RGB(a) string to a HEX string
// rgbstr2hex('rgba(255, 255, 255, 0.5)') => #ffffff
var rgbstr2hex = function rgbstr2hex(rgb) {
  rgb = rgb.match(/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i);
  return rgb && rgb.length === 4 ? '#' + ('0' + parseInt(rgb[1], 10).toString(16)).slice(-2) + ('0' + parseInt(rgb[2], 10).toString(16)).slice(-2) + ('0' + parseInt(rgb[3], 10).toString(16)).slice(-2) : '';
};

// Converts an HSB object to a HEX string
// hsb2hex({h: 0, s: 0, b: 100}) => #ffffff
var hsb2hex = function hsb2hex(hsb) {
  return rgb2hex(hsb2rgb(hsb));
};

// Converts a HEX string to an HSB object
// hex2hsb('#ffffff') => {h: 0, s: 0, b: 100}
var hex2hsb = function hex2hsb(hex) {
  var hsb = rgb2hsb(hex2rgb(hex));
  if (hsb.s === 0) hsb.h = 360;
  return hsb;
};

// Converts an RGB object to an HSB object
// rgb2hsb({r: 255, g: 255, b: 255}) => {h: 0, s: 0, b: 100}
var rgb2hsb = function rgb2hsb(rgb) {
  var hsb = {
    h: 0,
    s: 0,
    b: 0
  };
  var min = Math.min(rgb.r, rgb.g, rgb.b);
  var max = Math.max(rgb.r, rgb.g, rgb.b);
  var delta = max - min;
  hsb.b = max;
  hsb.s = max !== 0 ? 255 * delta / max : 0;
  if (hsb.s !== 0) {
    if (rgb.r === max) {
      hsb.h = (rgb.g - rgb.b) / delta;
    } else if (rgb.g === max) {
      hsb.h = 2 + (rgb.b - rgb.r) / delta;
    } else {
      hsb.h = 4 + (rgb.r - rgb.g) / delta;
    }
  } else {
    hsb.h = -1;
  }
  hsb.h *= 60;
  if (hsb.h < 0) {
    hsb.h += 360;
  }
  hsb.s *= 100 / 255;
  hsb.b *= 100 / 255;
  return hsb;
};

// Converts a HEX string to an RGB object
// hex2rgb('#ffffff') => {r: 255, g: 255, b: 255}
var hex2rgb = function hex2rgb(hex) {
  hex = parseInt(hex.indexOf('#') > -1 ? hex.substring(1) : hex, 16);
  return {
    /* jshint ignore:start */
    r: hex >> 16,
    g: (hex & 0x00FF00) >> 8,
    b: hex & 0x0000FF
    /* jshint ignore:end */
  };
};
;// CONCATENATED MODULE: ./app/forms/fields/colorpicker.js
function colorpicker_typeof(o) { "@babel/helpers - typeof"; return colorpicker_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, colorpicker_typeof(o); }
function colorpicker_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function colorpicker_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, colorpicker_toPropertyKey(o.key), o); } }
function colorpicker_createClass(e, r, t) { return r && colorpicker_defineProperties(e.prototype, r), t && colorpicker_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function colorpicker_toPropertyKey(t) { var i = colorpicker_toPrimitive(t, "string"); return "symbol" == colorpicker_typeof(i) ? i : i + ""; }
function colorpicker_toPrimitive(t, r) { if ("object" != colorpicker_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != colorpicker_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




var isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
var colorpicker_body = external_jQuery_default()('body');
var MOUSEDOWN = 'mousedown touchstart MSPointerDown pointerdown';
var MOUSEMOVE = 'mousemove touchmove MSPointerMove pointermove';
var MOUSEUP = 'mouseup touchend MSPointerUp pointerup';
var FOCUSIN = isFirefox ? 'focus' : 'focusin';
var ColorpickerField = /*#__PURE__*/function () {
  function ColorpickerField(selector) {
    var _this = this;
    colorpicker_classCallCheck(this, ColorpickerField);
    this.selector = selector;
    this.field = external_jQuery_default()(this.selector);
    this.options = Object.assign({}, this.field.data('grav-colorpicker'));
    this.built = false;
    this.attach();
    if (this.options.update) {
      this.field.on('change._grav_colorpicker', function (event, field, hex, opacity) {
        var backgroundColor = hex;
        var rgb = hex2rgb(hex);
        if (opacity < 1) {
          backgroundColor = 'rgba(' + rgb.r + ', ' + rgb.g + ', ' + rgb.b + ', ' + opacity + ')';
        }
        var target = field.closest(_this.options.update);
        if (!target.length) {
          target = field.siblings(_this.options.update);
        }
        if (!target.length) {
          target = field.parent('.g-colorpicker').find(_this.options.update);
        }
        target.css({
          backgroundColor: backgroundColor
        });
      });
    }
  }
  return colorpicker_createClass(ColorpickerField, [{
    key: "attach",
    value: function attach() {
      var _this2 = this;
      colorpicker_body.on(FOCUSIN, this.selector, function (event) {
        return _this2.show(event, event.currentTarget);
      });
      colorpicker_body.on(MOUSEDOWN, this.selector + ' .g-colorpicker, ' + this.selector + ' .g-colorpicker i', this.bound('iconClick'));
      colorpicker_body.on('keydown', this.selector, function (event) {
        switch (event.keyCode) {
          case 9:
            // tab
            _this2.hide();
            break;
          case 13: // enter
          case 27:
            // esc
            _this2.hide();
            event.currentTarget.blur();
            break;
        }
        return true;
      });

      // Update on keyup
      colorpicker_body.on('keyup', this.selector, function (event) {
        _this2.updateFromInput(true, event.currentTarget);
        return true;
      });

      // Update on paste
      colorpicker_body.on('paste', this.selector, function (event) {
        setTimeout(function () {
          return _this2.updateFromInput(true, event.currentTarget);
        }, 1);
      });
    }
  }, {
    key: "show",
    value: function show(event, target) {
      target = external_jQuery_default()(target);
      if (!this.built) {
        this.build();
      }
      this.element = target;
      this.reposition();
      this.wrapper.addClass('cp-visible');
      this.updateFromInput();
      this.wrapper.on(MOUSEDOWN, '.cp-grid, .cp-slider, .cp-opacity-slider', this.bound('bodyDown'));
      colorpicker_body.on(MOUSEMOVE, this.bound('bodyMove'));
      colorpicker_body.on(MOUSEDOWN, this.bound('bodyClick'));
      colorpicker_body.on(MOUSEUP, this.bound('targetReset'));
      external_jQuery_default()('#admin-main > .content-wrapper').on('scroll', this.bound('reposition'));
    }
  }, {
    key: "hide",
    value: function hide() {
      if (!this.built) {
        return;
      }
      this.wrapper.removeClass('cp-visible');
      this.wrapper.undelegate(MOUSEDOWN, '.cp-grid, .cp-slider, .cp-opacity-slider', this.bound('bodyDown'));
      colorpicker_body.off(MOUSEMOVE, this.bound('bodyMove'));
      colorpicker_body.off(MOUSEDOWN, this.bound('bodyClick'));
      colorpicker_body.off(MOUSEUP, this.bound('targetReset'));
      external_jQuery_default()('#admin-main > .content-wrapper').on('scroll', this.bound('reposition'));
    }
  }, {
    key: "build",
    value: function build() {
      var _this3 = this;
      this.wrapper = external_jQuery_default()('<div class="cp-wrapper cp-with-opacity cp-mode-hue" />');
      this.slider = external_jQuery_default()('<div class="cp-slider cp-sprite" />').appendTo(this.wrapper).append(external_jQuery_default()('<div class="cp-picker" />'));
      this.opacitySlider = external_jQuery_default()('<div class="cp-opacity-slider cp-sprite" />').appendTo(this.wrapper).append(external_jQuery_default()('<div class="cp-picker" />'));
      this.grid = external_jQuery_default()('<div class="cp-grid cp-sprite" />').appendTo(this.wrapper).append(external_jQuery_default()('<div class="cp-grid-inner" />')).append(external_jQuery_default()('<div class="cp-picker" />'));
      external_jQuery_default()('<div />').appendTo(this.grid.find('.cp-picker'));
      var tabs = external_jQuery_default()('<div class="cp-tabs" />').appendTo(this.wrapper);
      this.tabs = {
        hue: external_jQuery_default()('<div class="cp-tab-hue active" />').text('HUE').appendTo(tabs),
        brightness: external_jQuery_default()('<div class="cp-tab-brightness" />').text('BRI').appendTo(tabs),
        saturation: external_jQuery_default()('<div class="cp-tab-saturation" />').text('SAT').appendTo(tabs),
        wheel: external_jQuery_default()('<div class="cp-tab-wheel" />').text('WHEEL').appendTo(tabs),
        transparent: external_jQuery_default()('<div class="cp-tab-transp" />').text('TRANSPARENT').appendTo(tabs)
      };
      tabs.on(MOUSEDOWN, '> div', function (event) {
        var element = external_jQuery_default()(event.currentTarget);
        if (element.is(_this3.tabs.transparent)) {
          var sliderHeight = _this3.opacitySlider.height();
          _this3.opacity = 0;
          _this3.opacitySlider.find('.cp-picker').css({
            'top': clamp_default()(sliderHeight - sliderHeight * _this3.opacity, 0, sliderHeight)
          });
          _this3.move(_this3.opacitySlider, {
            manualOpacity: true
          });
          return;
        }
        var active = tabs.find('.active');
        var mode = active.attr('class').replace(/\s|active|cp-tab-/g, '');
        var newMode = element.attr('class').replace(/\s|active|cp-tab-/g, '');
        _this3.wrapper.removeClass('cp-mode-' + mode).addClass('cp-mode-' + newMode);
        active.removeClass('active');
        element.addClass('active');
        _this3.mode = newMode;
        _this3.updateFromInput();
      });
      this.wrapper.appendTo('.content-wrapper');
      this.built = true;
      this.mode = 'hue';
    }
  }, {
    key: "reposition",
    value: function reposition() {
      var ct = external_jQuery_default()('.content-wrapper')[0];
      var offset = this.element[0].getBoundingClientRect();
      var ctOffset = ct.getBoundingClientRect();
      var delta = {
        x: 0,
        y: 0
      };
      if (this.options.offset) {
        delta.x = this.options.offset.x || 0;
        delta.y = this.options.offset.y || 0;
      }
      this.wrapper.css({
        top: offset.top + offset.height + ct.scrollTop - ctOffset.top + delta.y,
        left: offset.left + ct.scrollLeft - ctOffset.left + delta.x
      });
    }
  }, {
    key: "iconClick",
    value: function iconClick(event) {
      if (this.wrapper && this.wrapper.hasClass('cp-visible')) {
        return true;
      }
      event && event.preventDefault();
      var input = external_jQuery_default()(event.currentTarget).find('input');
      setTimeout(function () {
        return input.focus();
      }, 50);
    }
  }, {
    key: "bodyMove",
    value: function bodyMove(event) {
      event && event.preventDefault();
      if (this.target) {
        this.move(this.target, event);
      }
    }
  }, {
    key: "bodyClick",
    value: function bodyClick(event) {
      var target = external_jQuery_default()(event.target);
      if (!target.closest('.cp-wrapper').length && !target.is(this.selector)) {
        this.hide();
      }
    }
  }, {
    key: "bodyDown",
    value: function bodyDown(event) {
      event && event.preventDefault();
      this.target = external_jQuery_default()(event.currentTarget);
      this.move(this.target, event, true);
    }
  }, {
    key: "targetReset",
    value: function targetReset(event) {
      event && event.preventDefault();
      this.target = null;
    }
  }, {
    key: "move",
    value: function move(target, event) {
      var input = this.element;
      var picker = target.find('.cp-picker');
      var clientRect = target[0].getBoundingClientRect();
      var offsetX = clientRect.left + window.scrollX;
      var offsetY = clientRect.top + window.scrollY;
      var x = Math.round((event ? event.pageX : 0) - offsetX);
      var y = Math.round((event ? event.pageY : 0) - offsetY);
      var wx;
      var wy;
      var r;
      var phi;

      // Touch support
      var touchEvents = event.changedTouches || event.originalEvent && event.originalEvent.changedTouches;
      if (event && touchEvents) {
        x = (touchEvents ? touchEvents[0].pageX : 0) - offsetX;
        y = (touchEvents ? touchEvents[0].pageY : 0) - offsetY;
      }
      if (event && event.manualOpacity) {
        y = clientRect.height;
      }

      // Constrain picker to its container
      if (x < 0) x = 0;
      if (y < 0) y = 0;
      if (x > clientRect.width) x = clientRect.width;
      if (y > clientRect.height) y = clientRect.height;

      // Constrain color wheel values to the wheel
      if (target.parent('.cp-mode-wheel').length && picker.parent('.cp-grid').length) {
        wx = 75 - x;
        wy = 75 - y;
        r = Math.sqrt(wx * wx + wy * wy);
        phi = Math.atan2(wy, wx);
        if (phi < 0) phi += Math.PI * 2;
        if (r > 75) {
          x = 75 - 75 * Math.cos(phi);
          y = 75 - 75 * Math.sin(phi);
        }
        x = Math.round(x);
        y = Math.round(y);
      }

      // Move the picker
      if (target.hasClass('cp-grid')) {
        picker.css({
          top: y,
          left: x
        });
        this.updateFromPicker(input, target);
      } else {
        picker.css({
          top: y
        });
        this.updateFromPicker(input, target);
      }
    }
  }, {
    key: "updateFromInput",
    value: function updateFromInput(dontFireEvent, element) {
      element = element ? external_jQuery_default()(element) : this.element;
      var value = element.val();
      var opacity = value.replace(/\s/g, '').match(/^rgba?\([0-9]{1,3},[0-9]{1,3},[0-9]{1,3},(.+)\)/);
      var hex;
      var hsb;
      value = rgbstr2hex(value) || value;
      opacity = opacity ? clamp_default()(opacity[1], 0, 1) : 1;
      if (!(hex = parseHex(value))) {
        hex = '#ffffff';
      }
      hsb = hex2hsb(hex);
      if (this.built) {
        // opacity
        this.opacity = opacity;
        var sliderHeight = this.opacitySlider.height();
        this.opacitySlider.find('.cp-picker').css({
          'top': clamp_default()(sliderHeight - sliderHeight * this.opacity, 0, sliderHeight)
        });

        // bg color
        var gridHeight = this.grid.height();
        var gridWidth = this.grid.width();
        var r;
        var phi;
        var x;
        var y;
        sliderHeight = this.slider.height();
        switch (this.mode) {
          case 'wheel':
            // Set grid position
            r = clamp_default()(Math.ceil(hsb.s * 0.75), 0, gridHeight / 2);
            phi = hsb.h * Math.PI / 180;
            x = clamp_default()(75 - Math.cos(phi) * r, 0, gridWidth);
            y = clamp_default()(75 - Math.sin(phi) * r, 0, gridHeight);
            this.grid.css({
              backgroundColor: 'transparent'
            }).find('.cp-picker').css({
              top: y,
              left: x
            });

            // Set slider position
            y = 150 - hsb.b / (100 / gridHeight);
            if (hex === '') y = 0;
            this.slider.find('.cp-picker').css({
              top: y
            });

            // Update panel color
            this.slider.css({
              backgroundColor: hsb2hex({
                h: hsb.h,
                s: hsb.s,
                b: 100
              })
            });
            break;
          case 'saturation':
            // Set grid position
            x = clamp_default()(5 * hsb.h / 12, 0, 150);
            y = clamp_default()(gridHeight - Math.ceil(hsb.b / (100 / gridHeight)), 0, gridHeight);
            this.grid.find('.cp-picker').css({
              top: y,
              left: x
            });

            // Set slider position
            y = clamp_default()(sliderHeight - hsb.s * (sliderHeight / 100), 0, sliderHeight);
            this.slider.find('.cp-picker').css({
              top: y
            });

            // Update UI
            this.slider.css({
              backgroundColor: hsb2hex({
                h: hsb.h,
                s: 100,
                b: hsb.b
              })
            });
            this.grid.find('.cp-grid-inner').css({
              opacity: hsb.s / 100
            });
            break;
          case 'brightness':
            // Set grid position
            x = clamp_default()(5 * hsb.h / 12, 0, 150);
            y = clamp_default()(gridHeight - Math.ceil(hsb.s / (100 / gridHeight)), 0, gridHeight);
            this.grid.find('.cp-picker').css({
              top: y,
              left: x
            });

            // Set slider position
            y = clamp_default()(sliderHeight - hsb.b * (sliderHeight / 100), 0, sliderHeight);
            this.slider.find('.cp-picker').css({
              top: y
            });

            // Update UI
            this.slider.css({
              backgroundColor: hsb2hex({
                h: hsb.h,
                s: hsb.s,
                b: 100
              })
            });
            this.grid.find('.cp-grid-inner').css({
              opacity: 1 - hsb.b / 100
            });
            break;
          case 'hue':
          default:
            // Set grid position
            x = clamp_default()(Math.ceil(hsb.s / (100 / gridWidth)), 0, gridWidth);
            y = clamp_default()(gridHeight - Math.ceil(hsb.b / (100 / gridHeight)), 0, gridHeight);
            this.grid.find('.cp-picker').css({
              top: y,
              left: x
            });

            // Set slider position
            y = clamp_default()(sliderHeight - hsb.h / (360 / sliderHeight), 0, sliderHeight);
            this.slider.find('.cp-picker').css({
              top: y
            });

            // Update panel color
            this.grid.css({
              backgroundColor: hsb2hex({
                h: hsb.h,
                s: 100,
                b: 100
              })
            });
            break;
        }
      }
      if (!dontFireEvent) {
        element.val(this.getValue(hex));
      }
      (this.element || element).trigger('change._grav_colorpicker', [element, hex, opacity]);
    }
  }, {
    key: "updateFromPicker",
    value: function updateFromPicker(input, target) {
      var getCoords = function getCoords(picker, container) {
        var left, top;
        if (!picker.length || !container) return null;
        left = picker[0].getBoundingClientRect().left;
        top = picker[0].getBoundingClientRect().top;
        return {
          x: left - container[0].getBoundingClientRect().left + picker[0].offsetWidth / 2,
          y: top - container[0].getBoundingClientRect().top + picker[0].offsetHeight / 2
        };
      };
      var hex;
      var hue;
      var saturation;
      var brightness;
      var x;
      var y;
      var r;
      var phi;

      // Panel objects
      var grid = this.wrapper.find('.cp-grid');
      var slider = this.wrapper.find('.cp-slider');
      var opacitySlider = this.wrapper.find('.cp-opacity-slider');

      // Picker objects
      var gridPicker = grid.find('.cp-picker');
      var sliderPicker = slider.find('.cp-picker');
      var opacityPicker = opacitySlider.find('.cp-picker');

      // Picker positions
      var gridPos = getCoords(gridPicker, grid);
      var sliderPos = getCoords(sliderPicker, slider);
      var opacityPos = getCoords(opacityPicker, opacitySlider);

      // Sizes
      var gridWidth = grid[0].getBoundingClientRect().width;
      var gridHeight = grid[0].getBoundingClientRect().height;
      var sliderHeight = slider[0].getBoundingClientRect().height;
      var opacitySliderHeight = opacitySlider[0].getBoundingClientRect().height;
      var value = this.element.val();
      value = rgbstr2hex(value) || value;
      if (!(hex = parseHex(value))) {
        hex = '#ffffff';
      }

      // Handle colors
      if (target.hasClass('cp-grid') || target.hasClass('cp-slider')) {
        // Determine HSB values
        switch (this.mode) {
          case 'wheel':
            // Calculate hue, saturation, and brightness
            x = gridWidth / 2 - gridPos.x;
            y = gridHeight / 2 - gridPos.y;
            r = Math.sqrt(x * x + y * y);
            phi = Math.atan2(y, x);
            if (phi < 0) phi += Math.PI * 2;
            if (r > 75) {
              r = 75;
              gridPos.x = 69 - 75 * Math.cos(phi);
              gridPos.y = 69 - 75 * Math.sin(phi);
            }
            saturation = clamp_default()(r / 0.75, 0, 100);
            hue = clamp_default()(phi * 180 / Math.PI, 0, 360);
            brightness = clamp_default()(100 - Math.floor(sliderPos.y * (100 / sliderHeight)), 0, 100);
            hex = hsb2hex({
              h: hue,
              s: saturation,
              b: brightness
            });

            // Update UI
            slider.css({
              backgroundColor: hsb2hex({
                h: hue,
                s: saturation,
                b: 100
              })
            });
            break;
          case 'saturation':
            // Calculate hue, saturation, and brightness
            hue = clamp_default()(parseInt(gridPos.x * (360 / gridWidth), 10), 0, 360);
            saturation = clamp_default()(100 - Math.floor(sliderPos.y * (100 / sliderHeight)), 0, 100);
            brightness = clamp_default()(100 - Math.floor(gridPos.y * (100 / gridHeight)), 0, 100);
            hex = hsb2hex({
              h: hue,
              s: saturation,
              b: brightness
            });

            // Update UI
            slider.css({
              backgroundColor: hsb2hex({
                h: hue,
                s: 100,
                b: brightness
              })
            });
            grid.find('.cp-grid-inner').css({
              opacity: saturation / 100
            });
            break;
          case 'brightness':
            // Calculate hue, saturation, and brightness
            hue = clamp_default()(parseInt(gridPos.x * (360 / gridWidth), 10), 0, 360);
            saturation = clamp_default()(100 - Math.floor(gridPos.y * (100 / gridHeight)), 0, 100);
            brightness = clamp_default()(100 - Math.floor(sliderPos.y * (100 / sliderHeight)), 0, 100);
            hex = hsb2hex({
              h: hue,
              s: saturation,
              b: brightness
            });

            // Update UI
            slider.css({
              backgroundColor: hsb2hex({
                h: hue,
                s: saturation,
                b: 100
              })
            });
            grid.find('.cp-grid-inner').css({
              opacity: 1 - brightness / 100
            });
            break;
          default:
            // Calculate hue, saturation, and brightness
            hue = clamp_default()(360 - parseInt(sliderPos.y * (360 / sliderHeight), 10), 0, 360);
            saturation = clamp_default()(Math.floor(gridPos.x * (100 / gridWidth)), 0, 100);
            brightness = clamp_default()(100 - Math.floor(gridPos.y * (100 / gridHeight)), 0, 100);
            hex = hsb2hex({
              h: hue,
              s: saturation,
              b: brightness
            });

            // Update UI
            grid.css({
              backgroundColor: hsb2hex({
                h: hue,
                s: 100,
                b: 100
              })
            });
            break;
        }
      }

      // Handle opacity
      if (target.hasClass('cp-opacity-slider')) {
        this.opacity = parseFloat(1 - opacityPos.y / opacitySliderHeight).toFixed(2);
      }

      // Adjust case
      input.val(this.getValue(hex));

      // Handle change event
      this.element.trigger('change._grav_colorpicker', [this.element, hex, this.opacity]);
    }
  }, {
    key: "getValue",
    value: function getValue(hex) {
      if (this.opacity === 1) {
        return hex;
      }
      var rgb = hex2rgb(hex);
      return 'rgba(' + rgb.r + ', ' + rgb.g + ', ' + rgb.b + ', ' + this.opacity + ')';
    }
  }, {
    key: "bound",
    value: function bound(name) {
      var bound = this._bound || (this._bound = {});
      return bound[name] || (bound[name] = bind_default()(this[name], this));
    }
  }]);
}();

var colorpicker_Instance = new ColorpickerField('[data-grav-colorpicker]');
;// CONCATENATED MODULE: ./app/forms/fields/folder.js

var Regenerate = function Regenerate() {
  var field = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '[name="data[folder]"]';
  var element = external_jQuery_default()(field);
  var title = external_jQuery_default()('[name="data[header][title]"]');
  var slug = external_jQuery_default().slugify(title.val(), {
    custom: {
      "'": ''
    }
  });
  element.addClass('highlight').val(slug);
  setTimeout(function () {
    return element.removeClass('highlight');
  }, 500);
};
external_jQuery_default()(document).on('click', '[data-regenerate]', function (event) {
  var target = external_jQuery_default()(event.currentTarget);
  var field = external_jQuery_default()(target.data('regenerate'));
  Regenerate(field);
});
/* harmony default export */ const fields_folder = (Regenerate);
// EXTERNAL MODULE: ./node_modules/mout/object/forIn.js
var forIn = __webpack_require__(29690);
var forIn_default = /*#__PURE__*/__webpack_require__.n(forIn);
;// CONCATENATED MODULE: ./app/forms/fields/selectunique.js
function selectunique_typeof(o) { "@babel/helpers - typeof"; return selectunique_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, selectunique_typeof(o); }
function selectunique_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function selectunique_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, selectunique_toPropertyKey(o.key), o); } }
function selectunique_createClass(e, r, t) { return r && selectunique_defineProperties(e.prototype, r), t && selectunique_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function selectunique_toPropertyKey(t) { var i = selectunique_toPrimitive(t, "string"); return "symbol" == selectunique_typeof(i) ? i : i + ""; }
function selectunique_toPrimitive(t, r) { if ("object" != selectunique_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != selectunique_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


// import { config } from 'grav-config';

var Data = {};
var SelectUniqueField = /*#__PURE__*/function () {
  function SelectUniqueField(options) {
    var _this = this;
    selectunique_classCallCheck(this, SelectUniqueField);
    var body = external_jQuery_default()('body');
    this.items = external_jQuery_default()();
    this.options = Object.assign({}, this.defaults, options);
    external_jQuery_default()('[data-select-observe]').each(function (index, element) {
      return _this.addSelect(element);
    }).last().trigger('change', {
      load: true
    });
    body.on('mutation._grav', this._onAddedNodes.bind(this));
    body.on('mutation_removed._grav', this._onRemovedNodes.bind(this));
  }
  return selectunique_createClass(SelectUniqueField, [{
    key: "_onAddedNodes",
    value: function _onAddedNodes(event, target, record, instance) {
      var _this2 = this;
      var fields = external_jQuery_default()(target).find('[data-select-observe]');
      if (!fields.length) {
        return;
      }
      fields.each(function (index, field) {
        field = external_jQuery_default()(field);
        if (!~_this2.items.index(field)) {
          _this2.addSelect(field);
        }
      });
    }
  }, {
    key: "_onRemovedNodes",
    value: function _onRemovedNodes(event, data /* , instance */) {
      var _this3 = this;
      var target = external_jQuery_default()(data.target);
      var holder = target.data('collectionHolder');
      if (!holder) {
        return false;
      }
      var node = external_jQuery_default()(data.mutation.removedNodes);
      var value = node.find('[data-select-observe]').val();
      if (value) {
        Data[holder].state[value] = value;
      }
      target.find('[data-select-observe]').each(function (index, field) {
        field = external_jQuery_default()(field);
        if (field.val() !== value) {
          _this3.updateOptions(field);
        }
      });
    }
  }, {
    key: "addSelect",
    value: function addSelect(element) {
      var _this4 = this;
      this.items = this.items.add(element);
      element = external_jQuery_default()(element);
      var value = element.attr('value');
      var holder = element.closest('[data-collection-holder]').data('collectionHolder');
      var options = element.closest('[data-select-unique]').data('selectUnique');
      if (!Data[holder]) {
        var data = {};
        if (Array.isArray(options)) {
          options.slice(0).map(function (item) {
            data[item] = item;
          });
        } else {
          data = Object.assign({}, options);
        }
        Data[holder] = {
          original: null,
          state: null
        };
        Data[holder].original = Object.assign({}, data);
        Data[holder].state = Object.assign({}, data);
      }
      this.updateOptions(element);
      element.data('originalValue', value);
      element.on('change', function (event, extras) {
        var target = external_jQuery_default()(event.currentTarget);
        if (target.data('dummyChange')) {
          target.data('dummyChange', false);
          return false;
        }
        _this4.refreshOptions(target, extras && extras.load ? null : element.data('originalValue'));
        element.data('originalValue', target.val());
      });
    }
  }, {
    key: "updateOptions",
    value: function updateOptions(element) {
      element = external_jQuery_default()(element);
      var value = element.attr('value');
      var holder = element.closest('[data-collection-holder]').data('collectionHolder');
      forIn_default()(Data[holder].state, function (v, k) {
        var selected = k === value ? 'selected="selected"' : '';
        if (element.get(0).selectize) {
          var selectize = element.data('selectize');
          selectize.removeOption(k);
          selectize.addOption({
            value: k,
            text: v
          });
        } else {
          element.append("<option value=\"".concat(k, "\" ").concat(selected, ">").concat(v, "</option>"));
        }
        if (selected) {
          if (element.get(0).selectize) {
            var _selectize = element.data('selectize');
            _selectize.setValue(k);
          }
          delete Data[holder].state[value];
        }
      });
    }
  }, {
    key: "refreshOptions",
    value: function refreshOptions(element, originalValue) {
      var value = element.val();
      var holder = element.closest('[data-collection-holder]').data('collectionHolder');
      delete Data[holder].state[value];
      if (originalValue && Data[holder].original[originalValue]) {
        Data[holder].state[originalValue] = Data[holder].original[originalValue];
      }
      this.items.each(function (index, select) {
        select = external_jQuery_default()(select);
        if (select[0] === element[0]) {
          return;
        }
        var selectedValue = select.val();
        select.data('dummyChange', true);
        if (select.get(0).selectize) {
          var selectize = select.data('selectize');
          if (selectize) {
            selectize.clearOptions();
            if (selectedValue) {
              selectize.addOption({
                value: selectedValue,
                text: Data[holder].original[selectedValue] || selectedValue
              });
            }
            forIn_default()(Data[holder].state, function (v, k) {
              selectize.addOption({
                value: k,
                text: v
              });
            });
            selectize.setValue(selectedValue, true);
          }
        } else {
          select.empty();
          forIn_default()(Data[holder].state, function (v, k) {
            var selected = k === selectedValue ? 'selected="selected"' : '';
            select.append("<option value=\"".concat(k, "\" ").concat(selected, ">").concat(v, "</option>"));
          });
        }
        select.data('dummyChange', false);
      });
    }
  }]);
}();

var selectunique_Instance = new SelectUniqueField();
;// CONCATENATED MODULE: ./app/forms/fields/iconpicker.js
function iconpicker_typeof(o) { "@babel/helpers - typeof"; return iconpicker_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, iconpicker_typeof(o); }
function iconpicker_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function iconpicker_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, iconpicker_toPropertyKey(o.key), o); } }
function iconpicker_createClass(e, r, t) { return r && iconpicker_defineProperties(e.prototype, r), t && iconpicker_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function iconpicker_toPropertyKey(t) { var i = iconpicker_toPrimitive(t, "string"); return "symbol" == iconpicker_typeof(i) ? i : i + ""; }
function iconpicker_toPrimitive(t, r) { if ("object" != iconpicker_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != iconpicker_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


/* Icon Picker by QueryLoop
 * Author: @eliorivero
 * URL: http://queryloop.com/
 * License: GPLv2
 */

var iconpicker_defaults = {
  'mode': 'dialog',
  // show overlay 'dialog' panel or slide down 'inline' panel
  'closeOnPick': true,
  // whether to close panel after picking or 'no'
  'save': 'class',
  // save icon 'class' or 'code'
  'size': '',
  'classes': {
    'launcher': '',
    // extra classes for launcher buttons
    'clear': 'remove-times',
    // extra classes for button that removes preview and clears field
    'highlight': '',
    // extra classes when highlighting an icon
    'close': '' // extra classes for close button
  },
  'iconSets': {
    // example data structure. Used to specify which launchers will be created
    'genericon': 'Genericon',
    // create a launcher to pick genericon icons
    'fa': 'FontAwesome' // create a launcher to pick fontawesome icons
  }
};
var QL_Icon_Picker = /*#__PURE__*/function () {
  function QL_Icon_Picker(element, options) {
    iconpicker_classCallCheck(this, QL_Icon_Picker);
    this.iconSet = '';
    this.iconSetName = '';
    this.$field = '';
    this.element = element;
    this.settings = external_jQuery_default().extend({}, iconpicker_defaults, options);
    this._defaults = iconpicker_defaults;
    this.init();
  }
  return iconpicker_createClass(QL_Icon_Picker, [{
    key: "init",
    value: function init() {
      var $brick = external_jQuery_default()(this.element);
      var pickerId = $brick.data('pickerid');
      var $preview = external_jQuery_default()('<div class="icon-preview icon-preview-' + pickerId + '" />');
      this.$field = $brick.find('input');

      // Add preview area
      this.makePreview($brick, pickerId, $preview);

      // Make button to clear field and remove preview
      this.makeClear(pickerId, $preview);

      // Make buttons that open the panel of icons
      this.makeLaunchers($brick, pickerId);

      // Prepare display styles, inline and dialog
      this.makeDisplay($brick);
    }
  }, {
    key: "makePreview",
    value: function makePreview($brick, pickerId, $preview) {
      var $icon = external_jQuery_default()('<i />');
      var iconValue = this.$field.val();
      $preview.prependTo($brick);
      $icon.prependTo($preview);
      if (iconValue !== '') {
        $preview.addClass('icon-preview-on');
        $icon.addClass(iconValue);
      }
    }
  }, {
    key: "makeClear",
    value: function makeClear(pickerId, $preview) {
      var base = this;
      var $clear = external_jQuery_default()('<a class="remove-icon ' + base.settings.classes.clear + '" />');

      // Hide button to remove icon and preview and append it to preview area
      $clear.hide().prependTo($preview);
      // If there's a icon saved in the field, show remove icon button
      if (base.$field.val() !== '') {
        $clear.show();
      }
      $preview.on('click', '.remove-icon', function (e) {
        e.preventDefault();
        base.$field.val('');
        $preview.removeClass('icon-preview-on').find('i').removeClass();
        external_jQuery_default()(this).hide();
      });
    }
  }, {
    key: "makeDisplay",
    value: function makeDisplay($brick) {
      var base = this;
      var close = base.settings.classes.close;
      var $body = external_jQuery_default()('body');
      var $close = external_jQuery_default()('<a href="#" class="icon-picker-close"/>');
      if (base.settings.mode === 'inline') {
        $brick.find('.icon-set').append($close).removeClass('dialog').addClass('ip-inline ' + base.settings.size).parent().addClass('icon-set-wrap');
      } else if (base.settings.mode === 'dialog') {
        external_jQuery_default()('.icon-set').addClass('dialog ' + base.settings.size);
        if (external_jQuery_default()('.icon-picker-overlay').length <= 0) {
          $body.append('<div class="icon-picker-overlay"/>').append($close);
        }
      }
      $body.on('click', '.icon-picker-close, .icon-picker-overlay', function (e) {
        e.preventDefault();
        base.closePicker($brick, external_jQuery_default()(base.iconSet), base.settings.mode);
      }).on('mouseenter mouseleave', '.icon-picker-close', function (e) {
        if (e.type === 'mouseenter') {
          external_jQuery_default()(this).addClass(close);
        } else {
          external_jQuery_default()(this).removeClass(close);
        }
      });
    }
  }, {
    key: "makeLaunchers",
    value: function makeLaunchers($brick) {
      var base = this;
      var dataIconSets = $brick.data('iconsets');
      var iconSet;
      if (typeof dataIconSets === 'undefined') {
        dataIconSets = base.settings.iconSets;
      }
      for (iconSet in dataIconSets) {
        if (dataIconSets.hasOwnProperty(iconSet)) {
          $brick.append('<a class="launch-icons button ' + base.settings.classes.launcher + '" data-icons="' + iconSet + '">' + dataIconSets[iconSet] + '</a>');
        }
      }
      $brick.find('.launch-icons').on('click', function (e) {
        e.preventDefault();
        var $self = external_jQuery_default()(this);
        var theseIcons = $self.data('icons');
        base.iconSetName = theseIcons;
        base.iconSet = '.' + theseIcons + '-set';

        // Initialize picker
        base.iconPick($brick);

        // Show icon picker
        base.showPicker($brick, external_jQuery_default()(base.iconSet), base.settings.mode);
      });
    }
  }, {
    key: "iconPick",
    value: function iconPick($brick) {
      var base = this;
      var highlight = 'icon-highlight ' + base.settings.classes.highlight;
      external_jQuery_default()(base.iconSet).on('click', 'li', function (e) {
        e.preventDefault();
        var $icon = external_jQuery_default()(this);
        var icon = $icon.data(base.settings.save);

        // Mark as selected
        external_jQuery_default()('.icon-selected').removeClass('icon-selected');
        $icon.addClass('icon-selected');
        if (base.$field.data('format') === 'short') {
          icon = icon.slice(6);
        }

        // Save icon value to field
        base.$field.val(icon);

        // Close icon picker
        if (base.settings.closeOnPick) {
          base.closePicker($brick, $icon.closest(base.iconSet), base.settings.mode);
        }

        // Set preview
        base.setPreview($icon.data('class'));

        // Broadcast event passing the selected icon.
        external_jQuery_default()('body').trigger('iconselected.queryloop', icon);
      });
      external_jQuery_default()(base.iconSet).on('mouseenter mouseleave', 'li', function (e) {
        if (e.type === 'mouseenter') {
          external_jQuery_default()(this).addClass(highlight);
        } else {
          external_jQuery_default()(this).removeClass(highlight);
        }
      });
    }
  }, {
    key: "showPicker",
    value: function showPicker($brick, $icons, mode) {
      if (mode === 'inline') {
        external_jQuery_default()('.icon-set').removeClass('ip-inline-open');
        $brick.find($icons).toggleClass('ip-inline-open');
      } else if (mode === 'dialog') {
        $brick.find('.icon-picker-close').addClass('make-visible');
        $brick.find('.icon-picker-overlay').addClass('make-visible');
        $icons.addClass('dialog-open');
      }
      $icons.find('.icon-selected').removeClass('icon-selected');
      var selectedIcon = this.$field.val().replace(' ', '.');
      if (selectedIcon !== '') {
        if (this.settings.save === 'class') {
          $icons.find('.' + selectedIcon).addClass('icon-selected');
        } else {
          $icons.find('[data-code="' + selectedIcon + '"]').addClass('icon-selected');
        }
      }
      // Broadcast event when the picker is shown passing the picker mode.
      external_jQuery_default()('body').trigger('iconpickershow.queryloop', mode);
    }
  }, {
    key: "closePicker",
    value: function closePicker($brick, $icons, mode) {
      // Remove event so they don't fire from a different picker
      external_jQuery_default()(this.iconSet).off('click', 'li');
      if (mode === 'inline') {
        $brick.find($icons).removeClass('ip-inline-open');
      } else if (mode === 'dialog') {
        external_jQuery_default()('.icon-picker-close, .icon-picker-overlay').removeClass('make-visible');
      }
      // Broadcast event when the picker is closed passing the picker mode.
      external_jQuery_default()('body').trigger('iconpickerclose.queryloop', mode);
      external_jQuery_default()('.icon-set').removeClass('dialog-open');
    }
  }, {
    key: "setPreview",
    value: function setPreview(preview) {
      var $preview = external_jQuery_default()(this.element).find('.icon-preview');
      $preview.addClass('icon-preview-on').find('i').removeClass().addClass(this.iconSetName).addClass(preview);
      $preview.find('a').show();
    }
  }]);
}();
/* Grav */
// extend $ with 3rd party QL Icon Picker
(external_jQuery_default()).fn.qlIconPicker = function (options) {
  this.each(function () {
    if (!external_jQuery_default().data(this, 'plugin_qlIconPicker')) {
      external_jQuery_default().data(this, 'plugin_qlIconPicker', new QL_Icon_Picker(this, options));
    }
  });
  return this;
};
var IconpickerField = /*#__PURE__*/function () {
  function IconpickerField(options) {
    var _this = this;
    iconpicker_classCallCheck(this, IconpickerField);
    this.items = external_jQuery_default()();
    this.options = Object.assign({}, this.defaults, options);
    external_jQuery_default()('[data-grav-iconpicker]').each(function (index, element) {
      return _this.addItem(element);
    });
    external_jQuery_default()('body').on('mutation._grav', this._onAddedNodes.bind(this));
  }
  return iconpicker_createClass(IconpickerField, [{
    key: "_onAddedNodes",
    value: function _onAddedNodes(event, target /* , record, instance */) {
      var _this2 = this;
      var fields = external_jQuery_default()(target).find('[data-grav-iconpicker]');
      if (!fields.length) {
        return;
      }
      fields.each(function (index, field) {
        field = external_jQuery_default()(field);
        if (!~_this2.items.index(field)) {
          _this2.addItem(field);
        }
      });
    }
  }, {
    key: "addItem",
    value: function addItem(element) {
      element = external_jQuery_default()(element);
      this.items = this.items.add(element);
      element.find('.icon-picker').qlIconPicker({
        'save': 'class'
      });

      // hack to remove extra icon sets that are just copies
      external_jQuery_default()('.icon-set:not(:first)').remove();
    }
  }]);
}();

var iconpicker_Instance = new IconpickerField();

// Fix to close the dialog when clicking outside
external_jQuery_default()(document).on('click', function (event) {
  var target = external_jQuery_default()(event.target);
  var match = '.icon-set.dialog-open, .launch-icons[data-icons]';
  if (!target.is(match) && !target.closest(match).length) {
    var dialogs = external_jQuery_default()('.icon-set.dialog-open');

    // skip if there's no dialog open
    if (dialogs.length) {
      dialogs.each(function (index, dialog) {
        var picker = external_jQuery_default()(dialog).siblings('.icon-picker');
        var data = picker.data('plugin_qlIconPicker');
        data.closePicker(picker, external_jQuery_default()(data.iconSet), data.settings.mode);
      });
    }
  }
});
;// CONCATENATED MODULE: ./app/utils/cron-ui.js
function cron_ui_typeof(o) { "@babel/helpers - typeof"; return cron_ui_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, cron_ui_typeof(o); }
/* eslint-disable */

/*
 * This file is part of the Arnapou jqCron package.
 *
 * (c) Arnaud Buathier <arnaud@arnapou.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Default settings
 */
var jqCronDefaultSettings = {
  texts: {},
  monthdays: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31],
  hours: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
  hour_labels: ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"],
  minutes: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59],
  lang: 'en',
  enabled_minute: false,
  enabled_hour: true,
  enabled_day: true,
  enabled_week: true,
  enabled_month: true,
  enabled_year: true,
  multiple_dom: false,
  multiple_month: false,
  multiple_mins: false,
  multiple_dow: false,
  multiple_time_hours: false,
  multiple_time_minutes: false,
  numeric_zero_pad: false,
  default_period: 'day',
  default_value: '',
  no_reset_button: true,
  disabled: false,
  bind_to: null,
  bind_method: {
    set: function set($element, value) {
      $element.is(':input') ? $element.val(value) : $element.data('jqCronValue', value);
    },
    get: function get($element) {
      return $element.is(':input') ? $element.val() : $element.data('jqCronValue');
    }
  }
};

/**
 * Custom extend of json for jqCron settings.
 * We don't use jQuery.extend because simple extend does not fit our needs, and deep extend has a bad
 * feature for us : it replaces keys of "Arrays" instead of replacing the full array.
 */
(function ($) {
  var extend = function extend(dst, src) {
    for (var i in src) {
      if ($.isPlainObject(src[i])) {
        dst[i] = extend(dst[i] && $.isPlainObject(dst[i]) ? dst[i] : {}, src[i]);
      } else if ($.isArray(src[i])) {
        dst[i] = src[i].slice(0);
      } else if (src[i] !== undefined) {
        dst[i] = src[i];
      }
    }
    return dst;
  };
  this.jqCronMergeSettings = function (obj) {
    return extend(extend({}, jqCronDefaultSettings), obj || {});
  };
}).call(window, (external_jQuery_default()));

/**
 * Shortcut to get the instance of jqCron instance from one jquery object
 */
(function ($) {
  $.fn.jqCronGetInstance = function () {
    return this.data('jqCron');
  };
}).call(window, (external_jQuery_default()));

/**
 * Main plugin
 */
(function ($) {
  $.fn.jqCron = function (settings) {
    var saved_settings = settings;
    return this.each(function () {
      var cron, saved;
      var $this = $(this);
      var settings = jqCronMergeSettings(saved_settings); // clone settings
      var translations = settings.texts[settings.lang];
      if (cron_ui_typeof(translations) !== 'object' || $.isEmptyObject(translations)) {
        console && console.error('Missing translations for language "' + settings.lang + '". ' + 'Please include jqCron.' + settings.lang + '.js or manually provide ' + 'the necessary translations when calling $.fn.jqCron().');
        return;
      }
      if (!settings.jquery_container) {
        if ($this.is(':container')) {
          settings.jquery_element = $this.uniqueId('jqCron');
        } else if ($this.is(':autoclose')) {
          // delete already generated dom if exists
          if ($this.next('.jqCron').length == 1) {
            $this.next('.jqCron').remove();
          }
          // generate new
          settings.jquery_element = $('<span class="jqCron"></span>').uniqueId('jqCron').insertAfter($this);
        } else {
          console && console.error(settings.texts[settings.lang].error1.replace('%s', this.tagName));
          return;
        }
      }

      // autoset bind_to if it is an input
      if ($this.is(':input')) {
        settings.bind_to = settings.bind_to || $this;
      }

      // init cron object
      if (settings.bind_to) {
        if (settings.bind_to.is(':input')) {
          // auto bind from input to object if an input, textarea ...
          settings.bind_to.blur(function () {
            var value = settings.bind_method.get(settings.bind_to);
            $this.jqCronGetInstance().setCron(value);
          });
        }
        saved = settings.bind_method.get(settings.bind_to);
        cron = new jqCron(settings);
        cron.setCron(saved);
      } else {
        cron = new jqCron(settings);
      }
      $(this).data('jqCron', cron);
    });
  };
}).call(window, (external_jQuery_default()));

/**
 * jqCron class
 */
(function ($) {
  var jqCronInstances = [];
  function jqCron(settings) {
    var _initialized = false;
    var _self = this;
    var _$elt = this;
    var _$obj = $('<span class="jqCron-container"></span>');
    var _$blocks = $('<span class="jqCron-blocks"></span>');
    var _$blockPERIOD = $('<span class="jqCron-period"></span>');
    var _$blockDOM = $('<span class="jqCron-dom"></span>');
    var _$blockMONTH = $('<span class="jqCron-month"></span>');
    var _$blockMINS = $('<span class="jqCron-mins"></span>');
    var _$blockDOW = $('<span class="jqCron-dow"></span>');
    var _$blockTIME = $('<span class="jqCron-time"></span>');
    var _$cross = $('<span class="jqCron-cross">&#10008;</span>');
    var _selectors = [];
    var _selectorPeriod, _selectorMins, _selectorTimeH, _selectorTimeM, _selectorDow, _selectorDom, _selectorMonth;

    // instanciate a new selector
    function newSelector($block, multiple, type) {
      var selector = new jqCronSelector(_self, $block, multiple, type);
      selector.$.bind('selector:open', function () {
        // we close all opened selectors of all other jqCron
        for (var n = jqCronInstances.length; n--;) {
          if (jqCronInstances[n] != _self) {
            jqCronInstances[n].closeSelectors();
          } else {
            // we close all other opened selectors of this jqCron
            for (var o = _selectors.length; o--;) {
              if (_selectors[o] != selector) {
                _selectors[o].close();
              }
            }
          }
        }
      });
      selector.$.bind('selector:change', function () {
        var boundChanged = false;
        // don't propagate if not initialized
        if (!_initialized) return;
        // bind data between two minute selectors (only if they have the same multiple settings)
        if (settings.multiple_mins == settings.multiple_time_minutes) {
          if (selector == _selectorMins) {
            boundChanged = _selectorTimeM.setValue(_selectorMins.getValue());
          } else if (selector == _selectorTimeM) {
            boundChanged = _selectorMins.setValue(_selectorTimeM.getValue());
          }
        }
        // we propagate the change event to the main object
        boundChanged || _$obj.trigger('cron:change', _self.getCron());
      });
      _selectors.push(selector);
      return selector;
    }

    // disable the selector
    this.disable = function () {
      _$obj.addClass('disable');
      settings.disable = true;
      _self.closeSelectors();
    };

    // return if the selector is disabled
    this.isDisabled = function () {
      return settings.disable == true;
    };

    // enable the selector
    this.enable = function () {
      _$obj.removeClass('disable');
      settings.disable = false;
    };

    // get cron value
    this.getCron = function () {
      var period = _selectorPeriod.getValue();
      var items = ['*', '*', '*', '*', '*'];
      if (period == 'hour') {
        items[0] = _selectorMins.getCronValue();
      }
      if (period == 'day' || period == 'week' || period == 'month' || period == 'year') {
        items[0] = _selectorTimeM.getCronValue();
        items[1] = _selectorTimeH.getCronValue();
      }
      if (period == 'month' || period == 'year') {
        items[2] = _selectorDom.getCronValue();
      }
      if (period == 'year') {
        items[3] = _selectorMonth.getCronValue();
      }
      if (period == 'week') {
        items[4] = _selectorDow.getCronValue();
      }
      return items.join(' ');
    };

    // set cron (string like * * * * *)
    this.setCron = function (str) {
      if (!str) return;
      try {
        str = str.replace(/\s+/g, ' ').replace(/^ +/, '').replace(/ +$/, ''); // sanitize
        var mask = str.replace(/[^\* ]/g, '-').replace(/-+/g, '-').replace(/ +/g, '');
        var items = str.split(' ');
        if (items.length != 5) _self.error(_self.getText('error2'));
        if (mask == '*****') {
          // 1 possibility
          _selectorPeriod.setValue('minute');
        } else if (mask == '-****') {
          // 1 possibility
          _selectorPeriod.setValue('hour');
          _selectorMins.setCronValue(items[0]);
          _selectorTimeM.setCronValue(items[0]);
        } else if (mask.substring(2, mask.length) == '***') {
          // 4 possibilities
          _selectorPeriod.setValue('day');
          _selectorMins.setCronValue(items[0]);
          _selectorTimeM.setCronValue(items[0]);
          _selectorTimeH.setCronValue(items[1]);
        } else if (mask.substring(2, mask.length) == '-**') {
          // 4 possibilities
          _selectorPeriod.setValue('month');
          _selectorMins.setCronValue(items[0]);
          _selectorTimeM.setCronValue(items[0]);
          _selectorTimeH.setCronValue(items[1]);
          _selectorDom.setCronValue(items[2]);
        } else if (mask.substring(2, mask.length) == '**-') {
          // 4 possibilities
          _selectorPeriod.setValue('week');
          _selectorMins.setCronValue(items[0]);
          _selectorTimeM.setCronValue(items[0]);
          _selectorTimeH.setCronValue(items[1]);
          _selectorDow.setCronValue(items[4]);
        } else if (mask.substring(3, mask.length) == '-*') {
          // 8 possibilities
          _selectorPeriod.setValue('year');
          _selectorMins.setCronValue(items[0]);
          _selectorTimeM.setCronValue(items[0]);
          _selectorTimeH.setCronValue(items[1]);
          _selectorDom.setCronValue(items[2]);
          _selectorMonth.setCronValue(items[3]);
        } else {
          _self.error(_self.getText('error4'));
        }
        _self.clearError();
      } catch (e) {}
    };

    // close all child selectors
    this.closeSelectors = function () {
      for (var n = _selectors.length; n--;) {
        _selectors[n].close();
      }
    };

    // get the main element id
    this.getId = function () {
      return _$elt.attr('id');
    };

    // get the translated text
    this.getText = function (key) {
      var text = settings.texts[settings.lang][key] || null;
      if (typeof text == "string" && text.match('<b')) {
        text = text.replace(/(<b *\/>)/gi, '</span><b /><span class="jqCron-text">');
        text = '<span class="jqCron-text">' + text + '</span>';
      }
      return text;
    };

    // get the human readable text
    this.getHumanText = function () {
      var texts = [];
      _$obj.find('> span > span:visible').find('.jqCron-text, .jqCron-selector > span').each(function () {
        var text = $(this).text().replace(/\s+$/g, '').replace(/^\s+/g, '');
        text && texts.push(text);
      });
      return texts.join(' ').replace(/\s:\s/g, ':');
    };

    // get settings
    this.getSettings = function () {
      return settings;
    };

    // display an error
    this.error = function (msg) {
      console && console.error('[jqCron Error] ' + msg);
      _$obj.addClass('jqCron-error').attr('title', msg);
      throw msg;
    };

    // clear error
    this.clearError = function () {
      _$obj.attr('title', '').removeClass('jqCron-error');
    };

    // clear
    this.clear = function () {
      _selectorDom.setValue([]);
      _selectorDow.setValue([]);
      _selectorMins.setValue([]);
      _selectorMonth.setValue([]);
      _selectorTimeH.setValue([]);
      _selectorTimeM.setValue([]);
      _self.triggerChange();
    };

    // init (called in constructor)
    this.init = function () {
      var n, i, labelsList, list;
      if (_initialized) return;
      settings = jqCronMergeSettings(settings);
      settings.jquery_element || _self.error(_self.getText('error3'));
      _$elt = settings.jquery_element;
      _$elt.append(_$obj);
      _$obj.data('id', settings.id);
      _$obj.data('jqCron', _self);
      _$obj.append(_$blocks);
      settings.no_reset_button || _$obj.append(_$cross);
      !settings.disable || _$obj.addClass('disable');
      _$blocks.append(_$blockPERIOD);
      if (/^(ko)$/i.test(settings.lang)) {
        _$blocks.append(_$blockMONTH, _$blockDOM);
      } else {
        _$blocks.append(_$blockDOM, _$blockMONTH);
      }
      _$blocks.append(_$blockMINS);
      _$blocks.append(_$blockDOW);
      _$blocks.append(_$blockTIME);

      // various binding
      _$cross.click(function () {
        _self.isDisabled() || _self.clear();
      });

      // binding from cron to target
      _$obj.bind('cron:change', function (evt, value) {
        if (!settings.bind_to) return;
        settings.bind_method.set && settings.bind_method.set(settings.bind_to, value);
        _self.clearError();
      });

      // PERIOD
      _$blockPERIOD.append(_self.getText('text_period'));
      _selectorPeriod = newSelector(_$blockPERIOD, false, 'period');
      settings.enabled_minute && _selectorPeriod.add('minute', _self.getText('name_minute'));
      settings.enabled_hour && _selectorPeriod.add('hour', _self.getText('name_hour'));
      settings.enabled_day && _selectorPeriod.add('day', _self.getText('name_day'));
      settings.enabled_week && _selectorPeriod.add('week', _self.getText('name_week'));
      settings.enabled_month && _selectorPeriod.add('month', _self.getText('name_month'));
      settings.enabled_year && _selectorPeriod.add('year', _self.getText('name_year'));
      _selectorPeriod.$.bind('selector:change', function (e, value) {
        _$blockDOM.hide();
        _$blockMONTH.hide();
        _$blockMINS.hide();
        _$blockDOW.hide();
        _$blockTIME.hide();
        if (value == 'hour') {
          _$blockMINS.show();
        } else if (value == 'day') {
          _$blockTIME.show();
        } else if (value == 'week') {
          _$blockDOW.show();
          _$blockTIME.show();
        } else if (value == 'month') {
          _$blockDOM.show();
          _$blockTIME.show();
        } else if (value == 'year') {
          _$blockDOM.show();
          _$blockMONTH.show();
          _$blockTIME.show();
        }
      });
      _selectorPeriod.setValue(settings.default_period);

      // MINS  (minutes)
      _$blockMINS.append(_self.getText('text_mins'));
      _selectorMins = newSelector(_$blockMINS, settings.multiple_mins, 'minutes');
      for (i = 0, list = settings.minutes; i < list.length; i++) {
        _selectorMins.add(list[i], list[i]);
      }

      // TIME  (hour:min)
      _$blockTIME.append(_self.getText('text_time'));
      _selectorTimeH = newSelector(_$blockTIME, settings.multiple_time_hours, 'time_hours');
      for (i = 0, list = settings.hours, labelsList = settings.hour_labels; i < list.length; i++) {
        _selectorTimeH.add(list[i], labelsList[i]);
      }
      _selectorTimeM = newSelector(_$blockTIME, settings.multiple_time_minutes, 'time_minutes');
      for (i = 0, list = settings.minutes; i < list.length; i++) {
        _selectorTimeM.add(list[i], list[i]);
      }

      // DOW  (day of week)
      _$blockDOW.append(_self.getText('text_dow'));
      _selectorDow = newSelector(_$blockDOW, settings.multiple_dow, 'day_of_week');
      for (i = 0, list = _self.getText('weekdays'); i < list.length; i++) {
        _selectorDow.add(i + 1, list[i]);
      }

      // DOM  (day of month)
      _$blockDOM.append(_self.getText('text_dom'));
      _selectorDom = newSelector(_$blockDOM, settings.multiple_dom, 'day_of_month');
      for (i = 0, list = settings.monthdays; i < list.length; i++) {
        _selectorDom.add(list[i], list[i]);
      }

      // MONTH  (day of week)
      _$blockMONTH.append(_self.getText('text_month'));
      _selectorMonth = newSelector(_$blockMONTH, settings.multiple_month, 'month');
      for (i = 0, list = _self.getText('months'); i < list.length; i++) {
        _selectorMonth.add(i + 1, list[i]);
      }

      // close all selectors when we click in body
      $('body').click(function () {
        var i,
          n = _selectors.length;
        for (i = 0; i < n; i++) {
          _selectors[i].close();
        }
      });
      _initialized = true;

      // default value
      if (settings.default_value) {
        _self.setCron(settings.default_value);
      }
    };

    // trigger a change event
    this.triggerChange = function () {
      _$obj.trigger('cron:change', _self.getCron());
    };

    // store instance in array
    jqCronInstances.push(this);

    // expose main jquery object
    this.$ = _$obj;

    // init
    try {
      this.init();
      _self.triggerChange();
    } catch (e) {}
  }
  this.jqCron = jqCron;
}).call(window, (external_jQuery_default()));

/**
 * jqCronSelector class
 */
(function ($) {
  function jqCronSelector(_cron, _$block, _multiple, _type) {
    var _self = this;
    var _$list = $('<ul class="jqCron-selector-list"></ul>');
    var _$title = $('<span class="jqCron-selector-title"></span>');
    var _$selector = $('<span class="jqCron-selector"></span>');
    var _values = {};
    var _value = [];
    var _hasNumericTexts = true;
    var _numeric_zero_pad = _cron.getSettings().numeric_zero_pad;

    // return an array without doublon
    function array_unique(l) {
      var i = 0,
        n = l.length,
        k = {},
        a = [];
      while (i < n) {
        k[l[i]] || (k[l[i]] =  true && a.push(l[i]));
        i++;
      }
      return a;
    }

    // get the value (an array if multiple, else a single value)
    this.getValue = function () {
      return _multiple ? _value : _value[0];
    };

    // get a correct string for cron
    this.getCronValue = function () {
      if (_value.length == 0) return '*';
      var cron = [_value[0]],
        i,
        s = _value[0],
        c = _value[0],
        n = _value.length;
      for (i = 1; i < n; i++) {
        if (_value[i] == c + 1) {
          c = _value[i];
          cron[cron.length - 1] = s + '-' + c;
        } else {
          s = c = _value[i];
          cron.push(c);
        }
      }
      return cron.join(',');
    };

    // set the cron value
    this.setCronValue = function (str) {
      var values = [],
        m,
        i,
        n;
      if (str !== '*') {
        while (str != '') {
          // test "*/n" expression
          m = str.match(/^\*\/([0-9]+),?/);
          if (m && m.length == 2) {
            for (i = 0; i <= 59; i += m[1] | 0) {
              values.push(i);
            }
            str = str.replace(m[0], '');
            continue;
          }
          // test "a-b/n" expression
          m = str.match(/^([0-9]+)-([0-9]+)\/([0-9]+),?/);
          if (m && m.length == 4) {
            for (i = m[1] | 0; i <= (m[2] | 0); i += m[3] | 0) {
              values.push(i);
            }
            str = str.replace(m[0], '');
            continue;
          }
          // test "a-b" expression
          m = str.match(/^([0-9]+)-([0-9]+),?/);
          if (m && m.length == 3) {
            for (i = m[1] | 0; i <= (m[2] | 0); i++) {
              values.push(i);
            }
            str = str.replace(m[0], '');
            continue;
          }
          // test "c" expression
          m = str.match(/^([0-9]+),?/);
          if (m && m.length == 2) {
            values.push(m[1] | 0);
            str = str.replace(m[0], '');
            continue;
          }
          // something goes wrong in the expression
          return;
        }
      }
      _self.setValue(values);
    };

    // close the selector
    this.close = function () {
      _$selector.trigger('selector:close');
    };

    // open the selector
    this.open = function () {
      _$selector.trigger('selector:open');
    };

    // whether the selector is open
    this.isOpened = function () {
      return _$list.is(':visible');
    };

    // add a selected value to the list
    this.addValue = function (key) {
      var values = _multiple ? _value.slice(0) : []; // clone array
      values.push(key);
      _self.setValue(values);
    };

    // remove a selected value from the list
    this.removeValue = function (key) {
      if (_multiple) {
        var i,
          newValue = [];
        for (i = 0; i < _value.length; i++) {
          if (key != [_value[i]]) {
            newValue.push(_value[i]);
          }
        }
        _self.setValue(newValue);
      } else {
        _self.clear();
      }
    };

    // set the selected value(s) of the list
    this.setValue = function (keys) {
      var i,
        newKeys = [],
        saved = _value.join(' ');
      if (!$.isArray(keys)) keys = [keys];
      _$list.find('li').removeClass('selected');
      keys = array_unique(keys);
      keys.sort(function (a, b) {
        var ta = cron_ui_typeof(a);
        var tb = cron_ui_typeof(b);
        if (ta == tb && ta == "number") return a - b;else return String(a) == String(b) ? 0 : String(a) < String(b) ? -1 : 1;
      });
      if (_multiple) {
        for (i = 0; i < keys.length; i++) {
          if (keys[i] in _values) {
            _values[keys[i]].addClass('selected');
            newKeys.push(keys[i]);
          }
        }
      } else {
        if (keys[0] in _values) {
          _values[keys[0]].addClass('selected');
          newKeys.push(keys[0]);
        }
      }
      // remove unallowed values
      _value = newKeys;
      if (saved != _value.join(' ')) {
        _$selector.trigger('selector:change', _multiple ? keys : keys[0]);
        return true;
      }
      return false;
    };

    // get the title text
    this.getTitleText = function () {
      var getValueText = function getValueText(key) {
        return key in _values ? _values[key].text() : key;
      };
      if (_value.length == 0) {
        return _cron.getText('empty_' + _type) || _cron.getText('empty');
      }
      var cron = [getValueText(_value[0])],
        i,
        s = _value[0],
        c = _value[0],
        n = _value.length;
      for (i = 1; i < n; i++) {
        if (_value[i] == c + 1) {
          c = _value[i];
          cron[cron.length - 1] = getValueText(s) + '-' + getValueText(c);
        } else {
          s = c = _value[i];
          cron.push(getValueText(c));
        }
      }
      return cron.join(',');
    };

    // clear list
    this.clear = function () {
      _values = {};
      _self.setValue([]);
      _$list.empty();
    };

    // add a (key, value) pair
    this.add = function (key, value) {
      if (!(value + '').match(/^[0-9]+$/)) _hasNumericTexts = false;
      if (_numeric_zero_pad && _hasNumericTexts && value < 10) {
        value = '0' + value;
      }
      var $item = $('<li>' + value + '</li>');
      _$list.append($item);
      _values[key] = $item;
      $item.click(function () {
        if (_multiple && $(this).hasClass('selected')) {
          _self.removeValue(key);
        } else {
          _self.addValue(key);
          if (!_multiple) _self.close();
        }
      });
    };

    // expose main jquery object
    this.$ = _$selector;

    // constructor
    _$block.find('b:eq(0)').after(_$selector).remove();
    _$selector.addClass('jqCron-selector-' + _$block.find('.jqCron-selector').length).append(_$title).append(_$list).bind('selector:open', function () {
      if (_hasNumericTexts) {
        var nbcols = 1,
          n = _$list.find('li').length;
        if (n > 5 && n <= 16) nbcols = 2;else if (n > 16 && n <= 23) nbcols = 3;else if (n > 23 && n <= 40) nbcols = 4;else if (n > 40) nbcols = 5;
        _$list.addClass('cols' + nbcols);
      }
      _$list.show();
    }).bind('selector:close', function () {
      _$list.hide();
    }).bind('selector:change', function () {
      _$title.html(_self.getTitleText());
    }).click(function (e) {
      e.stopPropagation();
    }).trigger('selector:change');
    $.fn.disableSelection && _$selector.disableSelection(); // only work with jQuery UI
    _$title.click(function (e) {
      _self.isOpened() || _cron.isDisabled() ? _self.close() : _self.open();
    });
    _self.close();
    _self.clear();
  }
  this.jqCronSelector = jqCronSelector;
}).call(window, (external_jQuery_default()));

/**
 * Generate unique id for each element.
 * Skip elements which have already an id.
 */
(function ($) {
  var jqUID = 0;
  var jqGetUID = function jqGetUID(prefix) {
    var id;
    while (1) {
      jqUID++;
      id = (prefix || 'JQUID') + '' + jqUID;
      if (!document.getElementById(id)) return id;
    }
  };
  $.fn.uniqueId = function (prefix) {
    return this.each(function () {
      if ($(this).attr('id')) return;
      var id = jqGetUID(prefix);
      $(this).attr('id', id);
    });
  };
}).call(window, (external_jQuery_default()));

/**
 * Extends jQuery selectors with new block selector
 */
(function ($) {
  $.extend($.expr[':'], {
    container: function container(a) {
      return (a.tagName + '').toLowerCase() in {
        a: 1,
        abbr: 1,
        acronym: 1,
        address: 1,
        b: 1,
        big: 1,
        blockquote: 1,
        button: 1,
        cite: 1,
        code: 1,
        dd: 1,
        del: 1,
        dfn: 1,
        div: 1,
        dt: 1,
        em: 1,
        fieldset: 1,
        form: 1,
        h1: 1,
        h2: 1,
        h3: 1,
        h4: 1,
        h5: 1,
        h6: 1,
        i: 1,
        ins: 1,
        kbd: 1,
        label: 1,
        li: 1,
        p: 1,
        pre: 1,
        q: 1,
        samp: 1,
        small: 1,
        span: 1,
        strong: 1,
        sub: 1,
        sup: 1,
        td: 1,
        tt: 1
      };
    },
    autoclose: function autoclose(a) {
      return (a.tagName + '').toLowerCase() in {
        area: 1,
        base: 1,
        basefont: 1,
        br: 1,
        col: 1,
        frame: 1,
        hr: 1,
        img: 1,
        input: 1,
        link: 1,
        meta: 1,
        param: 1
      };
    }
  });
}).call(window, (external_jQuery_default()));
;// CONCATENATED MODULE: ./app/forms/fields/cron.js
function cron_typeof(o) { "@babel/helpers - typeof"; return cron_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, cron_typeof(o); }
function cron_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function cron_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, cron_toPropertyKey(o.key), o); } }
function cron_createClass(e, r, t) { return r && cron_defineProperties(e.prototype, r), t && cron_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function cron_toPropertyKey(t) { var i = cron_toPrimitive(t, "string"); return "symbol" == cron_typeof(i) ? i : i + ""; }
function cron_toPrimitive(t, r) { if ("object" != cron_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != cron_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



var CronField = /*#__PURE__*/function () {
  function CronField() {
    var _this = this;
    cron_classCallCheck(this, CronField);
    this.items = external_jQuery_default()();
    external_jQuery_default()('[data-grav-field="cron"]').each(function (index, cron) {
      return _this.addCron(cron);
    });
    external_jQuery_default()('body').on('mutation._grav', this._onAddedNodes.bind(this));
  }
  return cron_createClass(CronField, [{
    key: "addCron",
    value: function addCron(cron) {
      cron = external_jQuery_default()(cron);
      this.items = this.items.add(cron);
      cron.find('.cron-selector').each(function (index, container) {
        container = external_jQuery_default()(container);
        var input = container.closest('[data-grav-field]').find('input');
        container.jqCron({
          numeric_zero_pad: true,
          enabled_minute: true,
          multiple_dom: true,
          multiple_month: true,
          multiple_mins: true,
          multiple_dow: true,
          multiple_time_hours: true,
          multiple_time_minutes: true,
          default_period: 'hour',
          default_value: input.val() || '* * * * *',
          no_reset_button: false,
          bind_to: input,
          bind_method: {
            set: function set($element, value) {
              $element.val(value);
            }
          },
          texts: {
            en: {
              empty: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.EVERY'],
              empty_minutes: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.EVERY'],
              empty_time_hours: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.EVERY_HOUR'],
              empty_time_minutes: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.EVERY_MINUTE'],
              empty_day_of_week: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.EVERY_DAY_OF_WEEK'],
              empty_day_of_month: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.EVERY_DAY_OF_MONTH'],
              empty_month: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.EVERY_MONTH'],
              name_minute: external_GravAdmin_namespaceObject.translations.GRAV_CORE['NICETIME.MINUTE'],
              name_hour: external_GravAdmin_namespaceObject.translations.GRAV_CORE['NICETIME.HOUR'],
              name_day: external_GravAdmin_namespaceObject.translations.GRAV_CORE['NICETIME.DAY'],
              name_week: external_GravAdmin_namespaceObject.translations.GRAV_CORE['NICETIME.WEEK'],
              name_month: external_GravAdmin_namespaceObject.translations.GRAV_CORE['NICETIME.MONTH'],
              name_year: external_GravAdmin_namespaceObject.translations.GRAV_CORE['NICETIME.YEAR'],
              text_period: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.TEXT_PERIOD'],
              text_mins: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.TEXT_MINS'],
              text_time: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.TEXT_TIME'],
              text_dow: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.TEXT_DOW'],
              text_month: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.TEXT_MONTH'],
              text_dom: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.TEXT_DOM'],
              error1: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.ERROR1'],
              error2: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.ERROR2'],
              error3: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.ERROR3'],
              error4: external_GravAdmin_namespaceObject.translations.GRAV_CORE['CRON.ERROR4'],
              weekdays: external_GravAdmin_namespaceObject.translations.GRAV_CORE['DAYS_OF_THE_WEEK'],
              months: external_GravAdmin_namespaceObject.translations.GRAV_CORE['MONTHS_OF_THE_YEAR']
            }
          }
        });
      });
    }
  }, {
    key: "_onAddedNodes",
    value: function _onAddedNodes(event, target /* , record, instance */) {
      var _this2 = this;
      var crons = external_jQuery_default()(target).find('[data-grav-field="cron"]');
      if (!crons.length) {
        return;
      }
      crons.each(function (index, list) {
        list = external_jQuery_default()(list);
        if (!~_this2.items.index(list)) {
          _this2.addCron(list);
        }
      });
    }
  }]);
}();

var cron_Instance = new CronField();
// EXTERNAL MODULE: ./node_modules/eventemitter3/index.js
var eventemitter3 = __webpack_require__(30228);
var eventemitter3_default = /*#__PURE__*/__webpack_require__.n(eventemitter3);
;// CONCATENATED MODULE: ./app/utils/finderjs.js
function finderjs_typeof(o) { "@babel/helpers - typeof"; return finderjs_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, finderjs_typeof(o); }
function finderjs_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function finderjs_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, finderjs_toPropertyKey(o.key), o); } }
function finderjs_createClass(e, r, t) { return r && finderjs_defineProperties(e.prototype, r), t && finderjs_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function finderjs_toPropertyKey(t) { var i = finderjs_toPrimitive(t, "string"); return "symbol" == finderjs_typeof(i) ? i : i + ""; }
function finderjs_toPrimitive(t, r) { if ("object" != finderjs_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != finderjs_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * (c) Trilby Media, LLC
 * Author Djamil Legato
 *
 * Based on Mark Matyas's Finderjs
 * MIT License
 */



var DEFAULTS = {
  labelKey: 'name',
  valueKey: 'value',
  // new
  childKey: 'children',
  iconKey: 'icon',
  // new
  itemKey: 'item-key',
  // new
  pathBar: true,
  className: {
    container: 'fjs-container',
    pathBar: 'fjs-path-bar',
    col: 'fjs-col',
    list: 'fjs-list',
    item: 'fjs-item',
    active: 'fjs-active',
    children: 'fjs-has-children',
    url: 'fjs-url',
    itemPrepend: 'fjs-item-prepend',
    itemContent: 'fjs-item-content',
    itemAppend: 'fjs-item-append'
  }
};
var Finder = /*#__PURE__*/function () {
  function Finder(container, data, options) {
    var _this = this;
    finderjs_classCallCheck(this, Finder);
    this.$emitter = new (eventemitter3_default())();
    this.container = external_jQuery_default()(container);
    this.data = data;
    this.config = external_jQuery_default().extend({}, DEFAULTS, options);

    // dom events
    this.container.on('click', this.clickEvent.bind(this));
    this.container.on('keydown', this.keydownEvent.bind(this));

    // internal events
    this.$emitter.on('item-selected', this.itemSelected.bind(this));
    this.$emitter.on('create-column', this.addColumn.bind(this));
    this.$emitter.on('navigate', this.navigate.bind(this));
    this.$emitter.on('go-to', this.goTo.bind(this, this.data));
    this.container.addClass(this.config.className.container).attr('tabindex', 0);
    this.createColumn(this.data);
    if (this.config.pathBar) {
      this.pathBar = this.createPathBar();
      this.pathBar.on('click', '[data-breadcrumb-node]', function (event) {
        event.preventDefault();
        var location = external_jQuery_default()(event.currentTarget).data('breadcrumbNode');
        _this.goTo(_this.data, location);
      });
    }

    // '' is <Root>
    if (this.config.defaultPath || this.config.defaultPath === '') {
      this.goTo(this.data, this.config.defaultPath);
    }
  }
  return finderjs_createClass(Finder, [{
    key: "reload",
    value: function reload() {
      var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.data;
      this.createColumn(data);

      // '' is <Root>
      if (this.config.defaultPath || this.config.defaultPath === '') {
        this.goTo(data, this.config.defaultPath);
      }
    }
  }, {
    key: "createColumn",
    value: function createColumn(data, parent) {
      var _this2 = this;
      var callback = function callback(data) {
        return _this2.createColumn(data, parent);
      };
      if (typeof data === 'function') {
        data.call(this, parent, callback);
      } else if (Array.isArray(data) || finderjs_typeof(data) === 'object') {
        if (finderjs_typeof(data) === 'object') {
          data = Array.from(data);
        }
        var list = this.createList(data);
        var div = external_jQuery_default()('<div />');
        div.append(list).addClass(this.config.className.col);
        this.$emitter.emit('create-column', div);
        return div;
      } else {
        throw new Error('Unknown data type');
      }
    }
  }, {
    key: "createPathBar",
    value: function createPathBar() {
      this.container.siblings(".".concat(this.config.className.pathBar)).remove();
      var pathBar = external_jQuery_default()("<div class=\"".concat(this.config.className.pathBar, "\" />"));
      pathBar.insertAfter(this.container);
      return pathBar;
    }
  }, {
    key: "clickEvent",
    value: function clickEvent(event) {
      event.stopPropagation();
      event.preventDefault();
      var target = external_jQuery_default()(event.target);
      var column = target.closest(".".concat(this.config.className.col));
      var item = target.closest(".".concat(this.config.className.item));
      if (item.length) {
        this.$emitter.emit('item-selected', {
          column: column,
          item: item
        });
      }
    }
  }, {
    key: "keydownEvent",
    value: function keydownEvent(event) {
      var codes = {
        37: 'left',
        38: 'up',
        39: 'right',
        40: 'down'
      };
      if (event.keyCode in codes) {
        event.stopPropagation();
        event.preventDefault();
        this.$emitter.emit('navigate', {
          direction: codes[event.keyCode]
        });
      }
    }
  }, {
    key: "itemSelected",
    value: function itemSelected(value) {
      var element = value.item;
      if (!element.length) {
        return false;
      }
      var item = element[0]._item;
      var column = value.column;
      var data = item[this.config.childKey] || this.data;
      var active = external_jQuery_default()(column).find(".".concat(this.config.className.active));
      if (active.length) {
        active.removeClass(this.config.className.active);
      }
      element.addClass(this.config.className.active);
      column.nextAll().remove(); // ?!?!?

      this.container[0].focus();
      window.scrollTo(window.pageXOffset, window.pageYOffset);
      this.updatePathBar();
      var newColumn;
      if (data) {
        newColumn = this.createColumn(data, item);
        this.$emitter.emit('interior-selected', item);
      } else {
        this.$emitter.emit('leaf-selected', item);
      }
      return newColumn;
    }
  }, {
    key: "addColumn",
    value: function addColumn(column) {
      this.container.append(column);
      this.$emitter.emit('column-created', column);
    }
  }, {
    key: "navigate",
    value: function navigate(value) {
      var active = this.findLastActive();
      var direction = value.direction;
      var column;
      var item;
      var target;
      if (active) {
        item = active.item;
        column = active.column;
        if (direction === 'up' && item.prev().length) {
          target = item.prev();
        } else if (direction === 'down' && item.next().length) {
          target = item.next();
        } else if (direction === 'right' && column.next().length) {
          column = column.next();
          target = column.find(".".concat(this.config.className.item)).first();
        } else if (direction === 'left' && column.prev().length) {
          column = column.prev();
          target = column.find(".".concat(this.config.className.active)).first() || column.find(".".concat(this.config.className.item));
        }
      } else {
        column = this.container.find(".".concat(this.config.className.col)).first();
        target = column.find(".".concat(this.config.className.item)).first();
      }
      if (target) {
        this.$emitter.emit('item-selected', {
          column: column,
          item: target
        });
      }
    }
  }, {
    key: "goTo",
    value: function goTo(data, path) {
      var _this3 = this;
      path = Array.isArray(path) ? path : path.split('/').map(function (bit) {
        return bit.trim();
      }).filter(Boolean);
      if (path.length) {
        this.container.children().remove();
      }
      if (typeof data === 'function') {
        data.call(this, null, function (data) {
          return _this3.selectPath(path, data);
        });
      } else {
        this.selectPath(path, data);
      }
    }
  }, {
    key: "selectPath",
    value: function selectPath(path, data, column) {
      var _this4 = this;
      column = column || (path.length ? this.createColumn(data) : this.container.find("> .".concat(this.config.className.col)));
      var current = path[0] || '';
      var children = data.find(function (item) {
        return item[_this4.config.itemKey] === current;
      });
      var newColumn = this.itemSelected({
        column: column,
        item: column.find("[data-fjs-item=\"".concat(current, "\"]")).first()
      });
      path.shift();
      if (path.length && children) {
        this.selectPath(path, children[this.config.childKey], newColumn);
      }
    }
  }, {
    key: "findLastActive",
    value: function findLastActive() {
      var active = this.container.find(".".concat(this.config.className.active));
      if (!active.length) {
        return null;
      }
      var item = active.last();
      var column = item.closest(".".concat(this.config.className.col));
      return {
        item: item,
        column: column
      };
    }
  }, {
    key: "createList",
    value: function createList(data) {
      var _this5 = this;
      var list = external_jQuery_default()('<ul />');
      var items = data.map(function (item) {
        return _this5.createItem(item);
      });
      var fragments = items.reduce(function (fragment, current) {
        fragment.appendChild(current[0] || current);
        return fragment;
      }, document.createDocumentFragment());
      list.append(fragments).addClass(this.config.className.list);
      return list;
    }
  }, {
    key: "createItem",
    value: function createItem(item) {
      var listItem = external_jQuery_default()('<li />');
      var listItemClasses = [this.config.className.item];
      var link = external_jQuery_default()('<a />');
      var createItemContent = this.config.createItemContent || this.createItemContent;
      var fragment = createItemContent.call(this, item);
      link.append(fragment).attr('href', '').attr('tabindex', -1);
      if (item.url) {
        link.attr('href', item.url);
        listItemClasses.push(item.className);
      }
      if (item[this.config.childKey]) {
        listItemClasses.push(this.config.className[this.config.childKey]);
      }
      listItemClasses.push("fjs-item-".concat(item.type));
      listItem.addClass(listItemClasses.join(' '));
      listItem.append(link).attr('data-fjs-item', item[this.config.itemKey]);
      listItem[0]._item = item;
      return listItem;
    }
  }, {
    key: "updatePathBar",
    value: function updatePathBar() {
      var _this6 = this;
      if (!this.config.pathBar) {
        return false;
      }
      var activeItems = this.container.find(".".concat(this.config.className.active));
      var itemKeys = '';
      this.pathBar.children().empty();
      activeItems.each(function (index, activeItem) {
        var item = activeItem._item;
        var isLast = index + 1 === activeItems.length;
        itemKeys += "/".concat(item[_this6.config.itemKey]);
        _this6.pathBar.append("\n                <span class=\"breadcrumb-node breadcrumb-node-".concat(item.type, "\" ").concat(item.type === 'dir' ? "data-breadcrumb-node=\"".concat(itemKeys, "\"") : '', ">\n                    <i class=\"fa fa-fw ").concat(_this6.getIcon(item.type), "\"></i>\n                    <span class=\"breadcrumb-node-name\">").concat(external_jQuery_default()('<div />').html(item[_this6.config.labelKey]).html(), "</span>\n                    ").concat(!isLast ? '<i class="fa fa-fw fa-chevron-right"></i>' : '', "\n                </span>\n            "));
      });
    }
  }, {
    key: "getIcon",
    value: function getIcon(type) {
      switch (type) {
        case 'root':
          return 'fa-sitemap';
        case 'file':
          return 'fa-file-o';
        case 'dir':
        default:
          return 'fa-folder';
      }
    }
  }]);
}();
/* harmony default export */ const finderjs = (Finder);
;// CONCATENATED MODULE: ./app/forms/fields/parents.js
function parents_typeof(o) { "@babel/helpers - typeof"; return parents_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, parents_typeof(o); }
function parents_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function parents_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, parents_toPropertyKey(o.key), o); } }
function parents_createClass(e, r, t) { return r && parents_defineProperties(e.prototype, r), t && parents_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function parents_toPropertyKey(t) { var i = parents_toPrimitive(t, "string"); return "symbol" == parents_typeof(i) ? i : i + ""; }
function parents_toPrimitive(t, r) { if ("object" != parents_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != parents_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



var XHRUUID = 0;
var parents_Instances = {};
var Parents = /*#__PURE__*/function () {
  function Parents(container, field, data) {
    var _this = this;
    parents_classCallCheck(this, Parents);
    this.container = external_jQuery_default()(container);
    this.fieldName = field.attr('name');
    this.field = external_jQuery_default()("[name=\"".concat(this.fieldName, "\"]"));
    this.data = data;
    this.parentLabel = external_jQuery_default()("[data-parents-field-label=\"".concat(this.fieldName, "\"]"));
    this.parentName = external_jQuery_default()("[data-parents-field-name=\"".concat(this.fieldName, "\"]"));
    var dataLoad = this.dataLoad;
    this.finder = new finderjs(this.container, function (parent, callback) {
      return dataLoad.call(_this, parent, callback);
    }, {
      labelKey: 'name',
      defaultPath: this.field.val(),
      createItemContent: function createItemContent(item) {
        return Parents.createItemContent(this.config, item);
      }
    });

    /*
    this.finder.$emitter.on('leaf-selected', (item) => {
        console.log('selected', item);
        this.finder.emit('create-column', () => this.createSimpleColumn(item));
    });
     this.finder.$emitter.on('item-selected', (selected) => {
        console.log('selected', selected);
        // for future use only - create column-card creation for file with details like in macOS finder
        // this.finder.$emitter('create-column', () => this.createSimpleColumn(selected));
    }); */

    this.finder.$emitter.on('column-created', function () {
      _this.container[0].scrollLeft = _this.container[0].scrollWidth - _this.container[0].clientWidth;
    });
  }
  return parents_createClass(Parents, [{
    key: "createSimpleColumn",
    value: function createSimpleColumn(item) {}
  }, {
    key: "dataLoad",
    value: function dataLoad(parent, callback) {
      var _this2 = this;
      if (!parent) {
        return callback(this.data);
      }
      if (parent.type !== 'dir' || !parent['has-children']) {
        return false;
      }
      var UUID = ++XHRUUID;
      this.startLoader();
      external_jQuery_default().ajax({
        url: "".concat(external_GravAdmin_namespaceObject.config.current_url),
        method: 'post',
        data: Object.assign({}, getExtraFormData(this.container), {
          route: b64_encode_unicode(parent.value),
          field: this.field.data('fieldName'),
          action: 'getLevelListing',
          'admin-nonce': external_GravAdmin_namespaceObject.config.admin_nonce
        }),
        success: function success(response) {
          _this2.stopLoader();
          if (response.status === 'error') {
            _this2.finder.$emitter.emit('create-column', Parents.createErrorColumn(response.message)[0]);
            return false;
          }
          // stale request
          if (UUID !== XHRUUID) {
            return false;
          }
          return callback(response.data);
        }
      });
    }
  }, {
    key: "startLoader",
    value: function startLoader() {
      this.loadingIndicator = Parents.createLoadingColumn();
      this.finder.$emitter.emit('create-column', this.loadingIndicator[0]);
      return this.loadingIndicator;
    }
  }, {
    key: "stopLoader",
    value: function stopLoader() {
      return this.loadingIndicator && this.loadingIndicator.remove();
    }
  }], [{
    key: "createItemContent",
    value: function createItemContent(config, item) {
      var frag = document.createDocumentFragment();
      var label = external_jQuery_default()("<span title=\"".concat(item[config.labelKey], "\" />"));
      var infoContainer = external_jQuery_default()('<span class="info-container" />');
      var iconPrepend = external_jQuery_default()('<i />');
      var iconAppend = external_jQuery_default()('<i />');
      var badge = external_jQuery_default()('<span class="badge" />');
      var prependClasses = ['fa'];
      var appendClasses = ['fa'];

      // prepend icon
      if (item.children || item.type === 'dir') {
        prependClasses.push('fa-folder');
      } else if (item.type === 'root') {
        prependClasses.push('fa-sitemap');
      } else if (item.type === 'file') {
        prependClasses.push('fa-file-o');
      }
      iconPrepend.addClass(prependClasses.join(' '));

      // text label
      label.text(item[config.labelKey]).prepend(iconPrepend);
      label.appendTo(frag);

      // append icon
      if (item.children || item['has-children']) {
        appendClasses.push('fa-caret-right');
        badge.text(item.size || item.count || 0);
        badge.appendTo(infoContainer);
      }
      iconAppend.addClass(appendClasses.join(' '));
      iconAppend.appendTo(infoContainer);
      infoContainer.appendTo(frag);
      return frag;
    }
  }, {
    key: "createLoadingColumn",
    value: function createLoadingColumn() {
      return external_jQuery_default()("\n            <div class=\"fjs-col leaf-col\" style=\"overflow: hidden;\">\n                <div class=\"leaf-row\">\n                    <div class=\"grav-loading\"><div class=\"grav-loader\">Loading...</div></div>\n                </div>\n            </div>\n        ");
    }
  }, {
    key: "createErrorColumn",
    value: function createErrorColumn(error) {
      return external_jQuery_default()("\n            <div class=\"fjs-col leaf-col\" style=\"overflow: hidden;\">\n                <div class=\"leaf-row error\">\n                    <i class=\"fa fa-fw fa-warning\"></i>\n                    <span>".concat(error, "</span>\n                </div>\n            </div>\n        "));
    }
  }]);
}();

var b64_encode_unicode = function b64_encode_unicode(str) {
  return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g, function toSolidBytes(match, p1) {
    return String.fromCharCode('0x' + p1);
  }));
};
var b64_decode_unicode = function b64_decode_unicode(str) {
  return decodeURIComponent(atob(str).split('').map(function (c) {
    return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
  }).join(''));
};
var getExtraFormData = function getExtraFormData(container) {
  var form = container.closest('form');
  if (container.closest('[data-remodal-id]').length) {
    form = external_jQuery_default()('form#blueprints');
  }
  var data = {};
  var unique_id = form.find('[name="__unique_form_id__"]');
  data['__form-name__'] = form.find('[name="__form-name__"]').val();
  data['form-nonce'] = form.find('[name="form-nonce"]').val();
  if (unique_id.length) {
    data['__unique_form_id__'] = unique_id.val();
  }
  return data;
};
external_jQuery_default()(document).on('click', '[data-parents]', function (event) {
  event.preventDefault();
  event.stopPropagation();
  var target = external_jQuery_default()(event.currentTarget);
  var field = target.closest('.parents-wrapper').find('input[name]');
  var fieldName = field.attr('name');
  if (!field.length) {
    fieldName = target.data('parents');
    field = external_jQuery_default()("[name=\"".concat(target.data('parents'), "\"]")).first();
  }
  var modal = external_jQuery_default()("[data-remodal-id=\"".concat(target.data('remodalTarget') || 'parents', "\"]"));
  var loader = modal.find('.grav-loading');
  var content = modal.find('.parents-content');
  loader.css('display', 'block');
  content.html('');
  external_jQuery_default().ajax({
    url: "".concat(external_GravAdmin_namespaceObject.config.current_url),
    method: 'post',
    data: Object.assign({}, getExtraFormData(target), {
      route: b64_encode_unicode(field.val()),
      field: field.data('fieldName'),
      action: 'getLevelListing',
      'admin-nonce': external_GravAdmin_namespaceObject.config.admin_nonce,
      initial: true
    }),
    success: function success(response) {
      loader.css('display', 'none');
      if (response.status === 'error') {
        content.html(response.message);
        return true;
      }
      if (!parents_Instances["".concat(fieldName, "-").concat(modal.data('remodalId'))]) {
        parents_Instances["".concat(fieldName, "-").concat(modal.data('remodalId'))] = new Parents(content, field, response.data);
      } else {
        parents_Instances["".concat(fieldName, "-").concat(modal.data('remodalId'))].finder.reload(response.data);
      }
      modal.data('parents', parents_Instances["".concat(fieldName, "-").concat(modal.data('remodalId'))]);
      modal.data('parents-selectedField', field);
    }
  });
});

// apply finder selection to field
external_jQuery_default()(document).on('click', '[data-remodal-id].parents-container [data-parents-select]', function (event) {
  var modal = external_jQuery_default()(event.currentTarget).closest('[data-remodal-id]');
  var parents = modal.data('parents');
  var selectedField = modal.data('parentsSelectedField');
  var finder = parents.finder;
  var field = parents.field;
  var parentLabel = parents.parentLabel;
  var parentName = parents.parentName;
  var selection = finder.findLastActive().item[0];
  var value = selection._item[finder.config.valueKey];
  var name = selection._item[finder.config.labelKey];
  if (selectedField.closest('.remodal').length) {
    var index = field.index(selectedField);
    selectedField.val(value);
    external_jQuery_default()(parentLabel[index]).text(value);
    external_jQuery_default()(parentName[index]).text(name);
  } else {
    field.val(value);
    parentLabel.text(value);
    parentName.text(name);
    finder.config.defaultPath = value;
  }
  var remodal = (external_jQuery_default()).remodal.lookup[external_jQuery_default()("[data-remodal-id=\"".concat(modal.data('remodalId'), "\"]")).data('remodal')];
  remodal.close();
});
;// CONCATENATED MODULE: ./app/forms/fields/acl-picker.js

var acl_picker_body = external_jQuery_default()('body');
acl_picker_body.on('change', '[data-acl_picker] select', function (event) {
  var target = external_jQuery_default()(event.currentTarget);
  var value = target.val();
  var item = target.closest('.permissions-item');
  var inputs = item.find('input[type="checkbox"], input[type="radio"]');
  var hidden = item.find('input[type="hidden"][name]');
  var wrapper = target.closest('[data-acl_picker_id]');
  var type = item.data('fieldType');
  if (type === 'access') {
    inputs.each(function (index, input) {
      input = external_jQuery_default()(input);
      var name = input.prop('name');
      input.prop('name', name.replace(/(.*)(\[[^\]]*\])/, "$1[".concat(value, "]")));
    });
  } else if (type === 'permissions') {
    var crudpContainer = item.find('[data-field-name]');
    inputs.each(function (index, input) {
      input = external_jQuery_default()(input);
      var rand = Math.round(Math.random() * 500);
      var name = crudpContainer.data('fieldName');
      var id = input.prop('id').split('_').slice(0, -1).join('_') + "_".concat(value, "+").concat(rand);
      // const key = input.data('crudpKey');
      hidden.prop('name', name.replace(/(.*)(\[[^\]]*\])/, "$1[".concat(value, "]")));
      input.prop('id', id);
      input.next('label').prop('for', id);
    });
  }
  wrapper.find('.permissions-item .button.add-item')[!value ? 'addClass' : 'removeClass']('disabled').prop('disabled', !value ? 'disabled' : null);
});
acl_picker_body.on('input', 'input[data-crudp-key]', function (event) {
  var target = external_jQuery_default()(event.currentTarget);
  var container = target.closest('.crudp-container');
  var hidden = container.find('input[type="hidden"][name]');
  var key = target.data('crudpKey');
  var json = JSON.parse(hidden.val() || '{}');
  json[key] = target.val();
  hidden.val(JSON.stringify(json));
});
acl_picker_body.on('click', '[data-acl_picker] .remove-item', function (event) {
  event.preventDefault();
  var target = external_jQuery_default()(event.currentTarget);
  var container = target.closest('.permissions-item');
  var wrapper = target.closest('[data-acl_picker_id]');
  container.remove();
  var empty = wrapper.find('.permissions-item').length === 1;

  // show the initial + button
  if (empty) {
    wrapper.find('.permissions-item.empty-list').removeClass('hidden');
  }
});
acl_picker_body.on('click', '[data-acl_picker] .add-item', function (event) {
  event.preventDefault();
  var target = external_jQuery_default()(event.currentTarget);
  var item = target.closest('.permissions-item');
  var wrapper = target.closest('[data-acl_picker_id]');
  var ID = wrapper.data('acl_picker_id');
  var template = document.querySelector("template[data-id=\"acl_picker-".concat(ID, "\"]"));
  var clone = external_jQuery_default()(template.content.firstElementChild).clone();
  clone.insertAfter(item);

  // randomize ids
  clone.find('.switch-toggle input[type="radio"]').each(function (index, input) {
    input = external_jQuery_default()(input);
    var id = input.prop('id');
    var label = input.next('label');
    var rand = (Date.now().toString(36) + Math.random().toString(36).substr(2, 5)).toLowerCase();
    input.prop('id', "".concat(id).concat(rand));
    label.prop('for', "".concat(id).concat(rand));
  });

  // hide the initial + button
  wrapper.find('.permissions-item.empty-list').addClass('hidden');

  // disable all + buttons until one is selected
  wrapper.find('.permissions-item .button.add-item').addClass('disabled').prop('disabled', 'disabled');
});
;// CONCATENATED MODULE: ./app/forms/fields/permissions.js

var permissions_body = external_jQuery_default()('body');
var radioSelector = '.permission-container.parent-section input[type="radio"]';
var handleParent = function handleParent(event) {
  var target = external_jQuery_default()(event.currentTarget);
  var value = target.val();
  var container = target.closest('.parent-section');
  var fieldset = container.next('fieldset');
  var radios = fieldset.find("input[type=\"radio\"][value=\"".concat(value, "\"]"));
  if (container.data('isLocked') !== false) {
    container.data('isUpdating', true);
    radios.each(function (index, radio) {
      var ID = radio.id;
      external_jQuery_default()(radio).siblings("[for=\"".concat(ID, "\"]")).trigger('click');
    });
    container.data('isUpdating', false);
  }
};
var boundHandleParent = handleParent.bind(handleParent);
permissions_body.on('click', '.permission-container.parent-section label', function (event) {
  var target = external_jQuery_default()(event.currentTarget);
  var container = target.closest('.parent-section');
  container.data('isLocked', true);
});
permissions_body.on('input', radioSelector, boundHandleParent);
permissions_body.on('input', '.permissions-container input[type="radio"][data-parent-id]', function (event) {
  var target = external_jQuery_default()(event.currentTarget);
  var parent = external_jQuery_default()("[for=\"".concat(target.data('parentId'), "\"]"));
  var container = target.closest('fieldset').prev('.permission-container.parent-section');
  if (container.data('isUpdating') === true) {
    return true;
  }
  permissions_body.off('input', radioSelector, boundHandleParent);
  container.data('isLocked', false);
  parent.trigger('click');
  permissions_body.on('input', radioSelector, boundHandleParent);
});
;// CONCATENATED MODULE: ./app/forms/fields/indeterminate.js

document.addEventListener('click', function (event) {
  if (document.querySelector('#pages-filters')) {
    return true;
  }
  var wrapper = event.target.closest('.checkboxes.indeterminate');
  if (wrapper) {
    event.preventDefault();
    var checkbox = wrapper.querySelector('input[type="checkbox"]:not([disabled])');
    var checkStatus = wrapper.dataset._checkStatus;
    wrapper.classList.remove('status-checked', 'status-unchecked', 'status-indeterminate');
    switch (checkStatus) {
      // checked, going indeterminate
      case '1':
        wrapper.dataset._checkStatus = '2';
        checkbox.indeterminate = true;
        checkbox.checked = false;
        checkbox.value = 0;
        wrapper.classList.add('status-indeterminate');
        break;

      // indeterminate, going unchecked
      case '2':
        wrapper.dataset._checkStatus = '0';
        checkbox.indeterminate = false;
        checkbox.checked = false;
        checkbox.value = '';
        wrapper.classList.add('status-unchecked');
        break;

      // unchecked, going checked
      case '0':
      default:
        wrapper.dataset._checkStatus = '1';
        checkbox.indeterminate = false;
        checkbox.checked = true;
        checkbox.value = 1;
        wrapper.classList.add('status-checked');
        break;
    }

    // const input = new CustomEvent('input', { detail: { target: checkbox }});
    // document.dispatchEvent(input);
    external_jQuery_default()(checkbox).trigger('input');
  }
});
(document.querySelectorAll('input[type="checkbox"][indeterminate="true"]') || []).forEach(function (input) {
  input.indeterminate = true;
});
;// CONCATENATED MODULE: ./app/forms/fields/mediapicker.js


external_jQuery_default()(function () {
  var modal = '';
  var body = external_jQuery_default()('body');

  // Thumb Resizer
  external_jQuery_default()(document).on('input change', '.media-container .media-range', function (event) {
    var target = external_jQuery_default()(event.currentTarget);
    var container = target.closest('.remodal');
    var cards = container.find('.media-container div.card-item');
    var width = target.val() + 'px';
    cards.each(function () {
      external_jQuery_default()(this).css('width', width);
    });
  });
  body.on('click', '[data-mediapicker-modal-trigger]', function (event) {
    var element = external_jQuery_default()(event.currentTarget);
    var modal_identifier = external_jQuery_default()(this).data('grav-mediapicker-unique-identifier');
    var modal_element = body.find("[data-remodal-unique-identifier=\"".concat(modal_identifier, "\"]"));
    modal = (external_jQuery_default()).remodal.lookup[modal_element.data('remodal')];
    if (!modal) {
      modal_element.remodal();
      modal = (external_jQuery_default()).remodal.lookup[modal_element.data('remodal')];
    }
    modal.open();
    modal.dataField = element.find('input');

    // load all media
    modal_element.find('.js__files').trigger('fillView');
    setTimeout(function () {
      return tree_Instance.reload();
    }, 100);
  });

  /* handle media modal click actions */
  body.on('click', '[data-remodal-mediapicker] .media-container.in-modal .admin-media-details a', function (event) {
    event.preventDefault();
    event.stopPropagation();
    var val = external_jQuery_default()(event.target).parents('.js__media-element').data('file-url');
    var string = val.replace(/ /g, '%20');
    modal.dataField.val(string);
    modal.close();
  });
});
;// CONCATENATED MODULE: ./app/forms/fields/multilevel.js

external_jQuery_default()(function () {
  var getField = function getField(level, name) {
    var levelMargin = level * 50;
    var top = level === 0 ? 'top' : '';
    var the_name = 'name="' + name + '"';
    if (level === 0) {
      // top
      the_name = 'data-attr-name="' + name + '"';
    }
    var marginDir = window.getComputedStyle(document.body).direction === 'ltr' ? 'margin-left' : 'margin-right';
    var field = "\n            <div class=\"element-wrapper\">\n                <div class=\"form-row array-field-value_only js__multilevel-field ".concat(top, "\"\n                    data-grav-array-type=\"row\">\n                    <input\n                        type=\"text\"\n                        ").concat(the_name, "\n                        placeholder=\"Enter value\"\n                        style=\"").concat(marginDir, ": ").concat(levelMargin, "px\"\n                        value=\"\" />\n\n                    <span class=\"fa fa-minus js__remove-item\"></span>\n                    <span class=\"fa fa-plus js__add-sibling hidden\" data-level=\"").concat(level, "\" ></span>\n                    <span class=\"fa fa-plus-circle js__add-children hidden\" data-level=\"").concat(level, "\"></span>\n                </div>\n            </div>\n        ");
    return field;
  };
  var hasChildInputs = function hasChildInputs($element) {
    if ($element.attr('name')) {
      return false;
    }
    return true;
  };
  var getTopItems = function getTopItems(element) {
    return external_jQuery_default()(element + ' .js__multilevel-field.top');
  };
  var refreshControls = function refreshControls(unique_identifier) {
    var element = '[data-grav-multilevel-field]';
    if (unique_identifier) {
      element = '[data-grav-multilevel-field][data-id="' + unique_identifier + '"]';
    }
    var hideButtons = function hideButtons() {
      external_jQuery_default()(element + ' .js__add-sibling').addClass('hidden');
      external_jQuery_default()(element + ' .js__add-children').addClass('hidden');
    };
    var restoreAddSiblingButtons = function restoreAddSiblingButtons() {
      external_jQuery_default()(element + ' .children-wrapper').each(function () {
        var elements = external_jQuery_default()(this).children();
        elements.last().each(function () {
          var field = external_jQuery_default()(this);
          if (!external_jQuery_default()(this).hasClass('js__multilevel-field')) {
            field = external_jQuery_default()(this).find('.js__multilevel-field').first();
          }
          field.find('.js__add-sibling').removeClass('hidden');
        });
      });

      // add sibling to the last top element
      external_jQuery_default()(element + ' .js__multilevel-field.top').last().find('.js__add-sibling').removeClass('hidden');
    };
    var restoreAddChildrenButtons = function restoreAddChildrenButtons() {
      external_jQuery_default()(element + ' .js__multilevel-field').each(function () {
        if (external_jQuery_default()(this).siblings('.children-wrapper').length === 0 || external_jQuery_default()(this).siblings('.children-wrapper').find('.js__multilevel-field').length === 0) {
          external_jQuery_default()(this).find('.js__add-children').removeClass('hidden');
        }
      });
    };
    var preventRemovingLastTopItem = function preventRemovingLastTopItem() {
      var top_items = getTopItems(element);
      if (top_items.length === 1) {
        top_items.first().find('.js__remove-item').addClass('hidden');
      }
    };
    hideButtons();
    restoreAddSiblingButtons();
    restoreAddChildrenButtons();
    preventRemovingLastTopItem();
  };
  var changeAllOccurrencesInTree = function changeAllOccurrencesInTree($el, current_name, new_name) {
    $el.parents('[data-grav-multilevel-field]').find('input').each(function () {
      var $input = external_jQuery_default()(this);
      if ($input.attr('name')) {
        $input.attr('name', $input.attr('name').replace(current_name, new_name));
      }
      if ($input.attr('data-attr-name')) {
        $input.attr('data-attr-name', $input.attr('data-attr-name').replace(current_name, new_name));
      }
    });
  };
  external_jQuery_default()(document).ready(function () {
    refreshControls();
  });
  external_jQuery_default()(document).on('mouseleave', '[data-grav-multilevel-field]', function (event) {
    var top_items = getTopItems('[data-id="' + external_jQuery_default()(this).data('id') + '"]');
    var has_top_items_without_children = false;
    var element_content = '';
    top_items.each(function () {
      var item = external_jQuery_default()(this);
      if (external_jQuery_default()(item).siblings('.children-wrapper').find('input').length === 0) {
        has_top_items_without_children = true;
        element_content = item.find('input').val();
      }
    });
    if (has_top_items_without_children) {
      if (element_content) {
        alert('Warning: if you save now, the element ' + element_content + ', without children, will be removed, because it\'s invalid YAML');
      } else {
        alert('Warning: if you save now, the top elements without children will be removed, because it\'s invalid YAML');
      }
    }
  });
  external_jQuery_default()(document).on('click', '[data-grav-multilevel-field] .js__add-children', function (event) {
    var element = external_jQuery_default()(this);
    var unique_container_id = element.closest('.js__multilevel-field').data('id');
    var level = element.data('level') + 1;
    var getParentOfElement = function getParentOfElement(element) {
      var parent = element.closest('.js__multilevel-field').parent().first();
      if (parent.find('.children-wrapper').length === 0) {
        external_jQuery_default()(parent).append('<div class="children-wrapper"></div>');
      }
      parent = parent.find('.children-wrapper').first();
      return parent;
    };
    var getNameFromParentInput = function getNameFromParentInput(parentInput, attr) {
      if (parentInput.hasClass('children-wrapper')) {
        parentInput = parentInput.siblings('.js__multilevel-field').first().find('input');
      }
      return parentInput.attr(attr) + '[' + parentInput.val() + ']';
    };
    var getInputFromChildrenWrapper = function getInputFromChildrenWrapper(parentChildrenWrapper) {
      return parentChildrenWrapper.siblings('.js__multilevel-field').first().find('input');
    };
    var parentChildrenWrapper = getParentOfElement(element);
    var parentInput = getInputFromChildrenWrapper(parentChildrenWrapper);
    var attr = 'name';
    if (parentInput.closest('.js__multilevel-field').hasClass('top')) {
      attr = 'data-attr-name';
    }
    parentInput.attr(attr, parentInput.attr(attr).replace('[]', ''));
    var name = getNameFromParentInput(parentInput, attr);
    var field = getField(level, name);
    external_jQuery_default()(parentChildrenWrapper).append(field);
    refreshControls(unique_container_id);
  });
  external_jQuery_default()(document).on('click', '[data-grav-multilevel-field] .js__add-sibling', function (event) {
    var element = external_jQuery_default()(this);
    var unique_container_id = element.closest('.js__multilevel-field').data('id');
    var level = element.data('level');
    element.closest('.children-wrapper').find('.js__add-sibling').addClass('hidden');
    var sibling = null;
    var is_top = false;
    if (element.closest('.js__multilevel-field').hasClass('top')) {
      is_top = true;
    }
    if (is_top) {
      sibling = element.closest('.js__multilevel-field').first().find('input').last();
    } else {
      sibling = element.siblings('input').first();
      if (!sibling) {
        sibling = element.closest('.children-wrapper').first().find('input').last();
      }
    }
    var getParentOfElement = function getParentOfElement(element) {
      var parent = element.closest('.js__multilevel-field').parent().first();
      if (!parent.hasClass('element-wrapper')) {
        if (parent.find('.element-wrapper').length === 0) {
          external_jQuery_default()(parent).append('<div class="element-wrapper"></div>');
        }
        parent = parent.find('.element-wrapper').first();
      }
      return parent;
    };
    var getNameFromSibling = function getNameFromSibling(parent, sibling) {
      var is_top = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var name = sibling.attr('name');
      if (hasChildInputs(sibling)) {
        var val = sibling.data('attr-name') + '[]';
        sibling.removeAttr('name');
        return val;
      }
      var last_index = name.lastIndexOf('[');
      var almost_there = name.substr(last_index + 1);
      var last_tag = almost_there.substr(0, almost_there.length - 1);
      if (external_jQuery_default().isNumeric(last_tag)) {
        name = name.replace('[' + last_tag + ']', '[' + (parseInt(last_tag, 10) + 1) + ']');
      } else {
        if (is_top) {
          name = name.replace('[' + last_tag + ']', '');
        } else {
          name = name + '[1]';

          // change sibling name attr if necessary
          if (sibling.attr('name').slice('-2') !== '[0]') {
            changeAllOccurrencesInTree(sibling, sibling.attr('name'), sibling.attr('name') + '[0]');
          }
        }
      }
      return name;
    };
    var parent = getParentOfElement(element);
    var name = getNameFromSibling(parent, sibling, is_top);
    var field = getField(level, name);
    external_jQuery_default()(field).insertAfter(parent);
    refreshControls(unique_container_id);
  });
  external_jQuery_default()(document).on('click', '[data-grav-multilevel-field] .js__remove-item', function (event) {
    external_jQuery_default()(this).parents('.element-wrapper').first().remove();
    var unique_container_id = external_jQuery_default()(this).closest('.js__multilevel-field').data('id');
    refreshControls(unique_container_id);
  });

  // Store old value before editing a field
  external_jQuery_default()(document).on('focusin', '[data-grav-multilevel-field] input', function (event) {
    external_jQuery_default()(this).data('current-value', external_jQuery_default()(this).val());
  });

  // Handle field edited event
  external_jQuery_default()(document).on('change', '[data-grav-multilevel-field] input', function (event) {
    var $el = external_jQuery_default()(this);
    var old_value = $el.data('current-value');
    var new_value = $el.val();
    var full_name = $el.attr('name') || $el.attr('data-attr-name'); // first-level items have `data-attr-name` instead of `name`

    var old_name_attr = full_name + '[' + old_value + ']';
    var new_name_attr = full_name + '[' + new_value + ']';
    changeAllOccurrencesInTree($el, old_name_attr, new_name_attr);
  });
});
;// CONCATENATED MODULE: ./app/forms/fields/text.js

external_jQuery_default()(document).ready(function () {
  external_jQuery_default()('.copy-to-clipboard').click(function (event) {
    var $tempElement = external_jQuery_default()('<input>');
    external_jQuery_default()('body').append($tempElement);
    $tempElement.val(external_jQuery_default()(this).prev('input').val()).select();
    document.execCommand('Copy');
    $tempElement.remove();
    external_jQuery_default()(this).attr('data-hint', 'Copied to clipboard!').addClass('hint--left');
  });
});
;// CONCATENATED MODULE: ./app/forms/fields/range.js

external_jQuery_default()(document).on('input', '[type="range"].rangefield, [type="number"].rangefield', function (event) {
  var target = external_jQuery_default()(event.currentTarget);
  var type = target.attr('type').toLowerCase();
  var sibling = type === 'range' ? 'number' : 'range';
  var feedback = target.siblings("[type=\"".concat(sibling, "\"].rangefield"));
  feedback.val(target.val());
});
;// CONCATENATED MODULE: ./app/forms/fields/elements.js

external_jQuery_default()(document).on('change', '[data-grav-elements] select', function (event) {
  var target = external_jQuery_default()(event.currentTarget);
  var value = target.val();
  var id = target.closest('[data-grav-elements]').data('gravElements');
  external_jQuery_default()("[id^=\"".concat(id, "_\"]")).css('display', 'none');
  external_jQuery_default()("[id=\"".concat(id, "__").concat(value, "\"]")).css('display', 'inherit');
});
external_jQuery_default()('[data-grav-elements] select').trigger('change');
;// CONCATENATED MODULE: ./app/forms/fields/index.js





















/* harmony default export */ const fields = ({
  FilepickerField: {
    FilepickerField: FilePickerField,
    Instance: filepicker_Instance
  },
  SelectizeField: {
    SelectizeField: SelectizeField,
    Instance: selectize_Instance
  },
  ArrayField: {
    ArrayField: ArrayField,
    Instance: array_Instance
  },
  CollectionsField: {
    CollectionsField: CollectionsField,
    Instance: collections_Instance
  },
  DateTimeField: {
    DateTimeField: DateTimeField,
    Instance: datetime_Instance
  },
  EditorField: {
    EditorField: EditorField,
    Instance: editor_Instance
  },
  ColorpickerField: {
    ColorpickerField: ColorpickerField,
    Instance: colorpicker_Instance
  },
  FilesField: {
    FilesField: FilesField,
    Instance: Instance
  },
  FolderField: {
    Regenerate: fields_folder
  },
  SelectUniqueField: {
    SelectUniqueField: SelectUniqueField,
    Instance: selectunique_Instance
  },
  IconpickerField: {
    IconpickerField: IconpickerField,
    Instance: iconpicker_Instance
  },
  CronField: {
    CronField: CronField,
    Instance: cron_Instance
  },
  ParentsField: {
    ParentsField: Parents,
    Instance: parents_Instances
  }
});
;// CONCATENATED MODULE: ./app/forms/index.js



/* harmony default export */ const app_forms = ({
  Form: {
    Form: Form,
    Instance: form_Instance
  },
  Fields: fields,
  FormState: {
    FormState: FormState,
    Instance: state_Instance
  }
});
;// CONCATENATED MODULE: ./app/utils/packages.js
function packages_typeof(o) { "@babel/helpers - typeof"; return packages_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, packages_typeof(o); }
function packages_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function packages_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, packages_toPropertyKey(o.key), o); } }
function packages_createClass(e, r, t) { return r && packages_defineProperties(e.prototype, r), t && packages_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function packages_toPropertyKey(t) { var i = packages_toPrimitive(t, "string"); return "symbol" == packages_typeof(i) ? i : i + ""; }
function packages_toPrimitive(t, r) { if ("object" != packages_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != packages_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




var Sorter = /*#__PURE__*/function () {
  function Sorter() {
    packages_classCallCheck(this, Sorter);
  }
  return packages_createClass(Sorter, [{
    key: "getElements",
    value: function getElements(elements, container) {
      this.elements = elements || document.querySelectorAll('[data-gpm-plugin], [data-gpm-theme]');
      this.container = container || document.querySelector('.gpm-plugins > table > tbody, .gpm-themes > .themes.card-row');
      return this.elements;
    }
  }, {
    key: "byCommon",
    value: function byCommon() {
      var _this = this;
      var direction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'asc';
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      var elements = this.getElements();
      this.removeGumroad();
      Array.from(elements).sort(function (a, b) {
        var A = a.dataset[data].toString().toLowerCase();
        var B = b.dataset[data].toString().toLowerCase();
        return Sorter.sort(A, B, direction);
      }).forEach(function (element) {
        _this.container.appendChild(element);
      });
      this.addGumroad();
      return this.container;
    }
  }, {
    key: "byName",
    value: function byName() {
      var direction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'asc';
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'gpmName';
      return this.byCommon(direction, data);
    }
  }, {
    key: "byAuthor",
    value: function byAuthor() {
      var direction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'asc';
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'gpmAuthor';
      return this.byCommon(direction, data);
    }
  }, {
    key: "byOfficial",
    value: function byOfficial() {
      var direction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'asc';
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'gpmOfficial';
      return this.byCommon(direction, data);
    }
  }, {
    key: "byPremium",
    value: function byPremium() {
      var direction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'asc';
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'gpmPremium';
      return this.byCommon(direction, data);
    }
  }, {
    key: "byReleaseDate",
    value: function byReleaseDate() {
      var _this2 = this;
      var direction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'asc';
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'gpmReleaseDate';
      var elements = this.getElements();
      this.removeGumroad();
      Array.from(elements).sort(function (a, b) {
        var A = new Date(a.dataset[data]).getTime();
        var B = new Date(b.dataset[data]).getTime();
        return Sorter.sort(A, B, direction === 'asc' ? 'desc' : 'asc');
      }).forEach(function (element) {
        _this2.container.appendChild(element);
      });
      this.addGumroad();
      return this.container;
    }
  }, {
    key: "byUpdatable",
    value: function byUpdatable() {
      var direction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'asc';
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'gpmUpdatable';
      return this.byCommon(direction, data);
    }
  }, {
    key: "byEnabled",
    value: function byEnabled() {
      var direction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'asc';
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'gpmEnabled';
      return this.byCommon(direction, data);
    }
  }, {
    key: "byTesting",
    value: function byTesting() {
      var direction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'asc';
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'gpmTesting';
      return this.byCommon(direction, data);
    }
  }, {
    key: "addGumroad",
    value: function addGumroad() {
      if (window.GumroadOverlay) {
        window.GumroadOverlay.startNodeAdditionObserver();
      }
    }
  }, {
    key: "removeGumroad",
    value: function removeGumroad() {
      if (window.GumroadOverlay) {
        window.GumroadOverlay.nodeAdditionObserver.disconnect();
      }
    }
  }], [{
    key: "sort",
    value: function sort(A, B) {
      var direction = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'asc';
      if (A > B) {
        return direction === 'asc' ? 1 : -1;
      }
      if (A < B) {
        return direction === 'asc' ? -1 : 1;
      }
      return 0;
    }
  }]);
}();
var Packages = /*#__PURE__*/function () {
  function Packages() {
    packages_classCallCheck(this, Packages);
    this.Sort = new Sorter();
  }
  return packages_createClass(Packages, [{
    key: "addDependenciesToList",
    value: function addDependenciesToList(dependencies) {
      var slug = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      dependencies.forEach(function (dependency) {
        Packages.addDependencyToList('plugin', dependency.name || dependency, slug);
      });
    }
  }, {
    key: "removePackage",
    value: function removePackage(type, slug) {
      var _this3 = this;
      var url = Packages.getRemovePackageUrl(type);
      utils_request(url, {
        method: 'post',
        body: {
          "package": slug
        }
      }, function (response) {
        if (response.status === 'success') {
          external_jQuery_default()('.remove-package-confirm').addClass('hidden');
          if (response.dependencies && response.dependencies.length > 0) {
            _this3.addDependenciesToList(response.dependencies);
            external_jQuery_default()('.remove-package-dependencies').removeClass('hidden');
          } else {
            external_jQuery_default()('.remove-package-done').removeClass('hidden');
          }

          // The package was removed. When the modal closes, move to the packages list
          external_jQuery_default()(document).on('closing', '[data-remodal-id="remove-package"]', function () {
            Packages.getBackToList(type);
          });
        } else {
          external_jQuery_default()('.remove-package-confirm').addClass('hidden');
          external_jQuery_default()('.remove-package-error').removeClass('hidden');
        }
      });
    }
  }, {
    key: "reinstallPackage",
    value: function reinstallPackage(type, slug, package_name, current_version) {
      external_jQuery_default()('.button-bar button').addClass('hidden');
      external_jQuery_default()('.button-bar .spinning-wheel').removeClass('hidden');
      var url = Packages.getReinstallPackageUrl(type);
      utils_request(url, {
        method: 'post',
        body: {
          slug: slug,
          type: type,
          package_name: package_name,
          current_version: current_version
        }
      }, function (response) {
        if (response.status === 'success') {
          external_jQuery_default()('.reinstall-package-confirm').addClass('hidden');
          external_jQuery_default()('.reinstall-package-done').removeClass('hidden');
        } else {
          external_jQuery_default()('.reinstall-package-confirm').addClass('hidden');
          external_jQuery_default()('.reinstall-package-error').removeClass('hidden');
        }
        window.location.reload();
      });
    }
  }, {
    key: "removeDependency",
    value: function removeDependency(type, slug, button) {
      var _this4 = this;
      var url = Packages.getRemovePackageUrl(type);
      utils_request(url, {
        method: 'post',
        body: {
          "package": slug
        }
      }, function (response) {
        if (response.status === 'success') {
          button.removeClass('button');
          button.replaceWith(external_jQuery_default()('<span>Removed successfully</span>'));
          if (response.dependencies && response.dependencies.length > 0) {
            _this4.addDependenciesToList(response.dependencies, slug);
          }
        }
      });
    }
  }, {
    key: "getPackagesDependencies",
    value: function getPackagesDependencies(type, slugs, finishedLoadingCallback) {
      var url = Packages.getGetPackagesDependenciesUrl(type);
      utils_request(url, {
        method: 'post',
        body: {
          packages: slugs
        }
      }, function (response) {
        finishedLoadingCallback();
        if (response.status === 'success') {
          if (response.dependencies) {
            var hasDependencies = false;
            for (var dependency in response.dependencies) {
              if (response.dependencies.hasOwnProperty(dependency)) {
                if (dependency === 'grav') {
                  continue;
                }
                hasDependencies = true;
                var dependencyName = dependency;
                var action = response.dependencies[dependency];
                Packages.addNeededDependencyToList(action, dependencyName);
              }
            }
            if (hasDependencies) {
              external_jQuery_default()('[data-packages-modal] .install-dependencies-package-container').removeClass('hidden');
            } else {
              external_jQuery_default()('[data-packages-modal] .install-package-container').removeClass('hidden');
            }
          } else {
            external_jQuery_default()('[data-packages-modal] .install-package-container').removeClass('hidden');
          }
        } else {
          external_jQuery_default()('[data-packages-modal] .install-package-error').removeClass('hidden');
        }
      });
    }
  }, {
    key: "installDependenciesOfPackages",
    value: function installDependenciesOfPackages(type, slugs, callbackSuccess, callbackError) {
      var url = Packages.getInstallDependenciesOfPackagesUrl(type);
      utils_request(url, {
        method: 'post',
        body: {
          packages: slugs
        }
      }, callbackSuccess);
    }
  }, {
    key: "installPackages",
    value: function installPackages(type, slugs, callbackSuccess) {
      var url = Packages.getInstallPackageUrl(type);
      __webpack_require__.g.Promise.all(slugs.map(function (slug) {
        return new __webpack_require__.g.Promise(function (resolve, reject) {
          utils_request(url, {
            method: 'post',
            body: {
              "package": slug,
              type: type
            }
          }, function (response) {
            resolve(response);
          });
        });
      })).then(callbackSuccess);
    }
  }, {
    key: "handleGettingPackageDependencies",
    value: function handleGettingPackageDependencies(type, event) {
      var action = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'update';
      var slugs = Packages.getSlugsFromEvent(event);
      if (!slugs) {
        alert('No slug set');
        return;
      }

      // Cleanup
      external_jQuery_default()('.packages-names-list').html('');
      external_jQuery_default()('.install-dependencies-package-container li').remove();
      slugs.forEach(function (slug) {
        if (action === 'update') {
          var current_version = '';
          var available_version = '';
          var _name = '';
          var resources = gpm_Instance.payload.payload.resources;
          if (resources.plugins[slug]) {
            available_version = resources.plugins[slug].available;
            current_version = resources.plugins[slug].version;
            _name = resources.plugins[slug].name;
          } else if (resources.themes[slug]) {
            available_version = resources.themes[slug].available;
            current_version = resources.themes[slug].version;
            _name = resources.themes[slug].name;
          }
          external_jQuery_default()('.packages-names-list').append("<li>".concat(_name ? _name : slug, ", ").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.FROM, " v<strong>").concat(current_version, "</strong> ").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.TO, " v<strong>").concat(available_version, "</strong></li>"));
        } else {
          external_jQuery_default()('.packages-names-list').append("<li>".concat(name ? name : slug, "</li>"));
        }
      });
      event.preventDefault();
      event.stopPropagation();

      // fix mismatching types when sharing install modal between plugins/themes
      var query = '[data-packages-modal] [data-theme-action], [data-packages-modal] [data-plugin-action]';
      var data = external_jQuery_default()(query).data('themeAction') || external_jQuery_default()(query).data('pluginAction');
      external_jQuery_default()(query).removeAttr('data-theme-action').removeAttr('data-plugin-action').attr("data-".concat(type, "-action"), data);

      // Restore original state
      external_jQuery_default()('[data-packages-modal] .loading').removeClass('hidden');
      external_jQuery_default()('[data-packages-modal] .install-dependencies-package-container').addClass('hidden');
      external_jQuery_default()('[data-packages-modal] .install-package-container').addClass('hidden');
      external_jQuery_default()('[data-packages-modal] .installing-dependencies').addClass('hidden');
      external_jQuery_default()('[data-packages-modal] .installing-package').addClass('hidden');
      external_jQuery_default()('[data-packages-modal] .installation-complete').addClass('hidden');
      external_jQuery_default()('[data-packages-modal] .install-package-error').addClass('hidden');
      this.getPackagesDependencies(type, slugs, function () {
        var slugs_string = slugs.join();
        external_jQuery_default()("[data-packages-modal] [data-".concat(type, "-action=\"install-dependencies-and-package\"]")).attr('data-packages-slugs', slugs_string);
        external_jQuery_default()("[data-packages-modal] [data-".concat(type, "-action=\"install-package\"]")).attr('data-packages-slugs', slugs_string);
        external_jQuery_default()('[data-packages-modal] .loading').addClass('hidden');
      });
    }
  }, {
    key: "handleInstallingDependenciesAndPackage",
    value: function handleInstallingDependenciesAndPackage(type, event) {
      var _this5 = this;
      var slugs = Packages.getSlugsFromEvent(event);
      event.preventDefault();
      event.stopPropagation();
      external_jQuery_default()('[data-packages-modal] .install-dependencies-package-container').addClass('hidden');
      external_jQuery_default()('[data-packages-modal] .install-package-container').addClass('hidden');
      external_jQuery_default()('[data-packages-modal] .installing-dependencies').removeClass('hidden');
      this.installDependenciesOfPackages(type, slugs, function (response) {
        external_jQuery_default()('[data-packages-modal] .installing-dependencies').addClass('hidden');
        external_jQuery_default()('[data-packages-modal] .installing-package').removeClass('hidden');
        _this5.installPackages(type, slugs, function () {
          external_jQuery_default()('[data-packages-modal] .installing-package').addClass('hidden');
          external_jQuery_default()('[data-packages-modal] .installation-complete').removeClass('hidden');
          if (response.status === 'error') {
            var remodal = (external_jQuery_default()).remodal.lookup[external_jQuery_default()('[data-packages-modal]').data('remodal')];
            remodal.close();
            return;
          }
          setTimeout(function () {
            if (slugs.length === 1) {
              __webpack_require__.g.location.href = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/").concat(type, "s/").concat(slugs[0]);
            } else {
              __webpack_require__.g.location.href = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/").concat(type, "s");
            }
          }, 1000);
        });
      });
    }
  }, {
    key: "handleInstallingPackage",
    value: function handleInstallingPackage(type, event) {
      var slugs = Packages.getSlugsFromEvent(event);
      event.preventDefault();
      event.stopPropagation();
      external_jQuery_default()('[data-packages-modal] .install-package-container').addClass('hidden');
      external_jQuery_default()('[data-packages-modal] .installing-package').removeClass('hidden');
      this.installPackages(type, slugs, function (response) {
        external_jQuery_default()('[data-packages-modal] .installing-package').addClass('hidden');
        external_jQuery_default()('[data-packages-modal] .installation-complete').removeClass('hidden');
        var errors = Array.from(response).filter(function (r) {
          return r.status === 'error';
        });
        if (errors && errors.length) {
          var remodal = (external_jQuery_default()).remodal.lookup[external_jQuery_default()('[data-packages-modal].remodal-is-opened').data('remodal')];
          remodal.close();
          return;
        }
        if (slugs.length === 1) {
          __webpack_require__.g.location.href = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/").concat(type, "s/").concat(slugs[0]);
        } else {
          __webpack_require__.g.location.href = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/").concat(type, "s");
        }
      });
    }
  }, {
    key: "handleRemovingPackage",
    value: function handleRemovingPackage(type, event) {
      var slug = external_jQuery_default()(event.target).attr('data-packages-slugs');
      event.preventDefault();
      event.stopPropagation();
      this.removePackage(type, slug);
    }
  }, {
    key: "handleReinstallPackage",
    value: function handleReinstallPackage(type, event) {
      var target = external_jQuery_default()(event.target);
      var slug = target.attr('data-package-slug');
      var package_name = target.attr('data-package-name');
      var current_version = target.attr('data-package-current-version');
      event.preventDefault();
      event.stopPropagation();
      this.reinstallPackage(type, slug, package_name, current_version);
    }
  }, {
    key: "handleRemovingDependency",
    value: function handleRemovingDependency(type, event) {
      var slug = external_jQuery_default()(event.target).attr('data-dependency-slug');
      var button = external_jQuery_default()(event.target);
      event.preventDefault();
      event.stopPropagation();
      this.removeDependency(type, slug, button);
    }
  }], [{
    key: "getBackToList",
    value: function getBackToList(type) {
      __webpack_require__.g.location.href = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/").concat(type, "s");
    }
  }, {
    key: "addDependencyToList",
    value: function addDependencyToList(type, dependency) {
      var slug = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
      if (['admin', 'form', 'login', 'email', 'grav'].indexOf(dependency) !== -1) {
        return;
      }
      var container = external_jQuery_default()('.package-dependencies-container');
      var text = "".concat(dependency, " <a href=\"#\" class=\"button\" data-dependency-slug=\"").concat(dependency, "\" data-").concat(type, "-action=\"remove-dependency-package\">Remove</a>");
      if (slug) {
        text += " (was needed by ".concat(slug, ")");
      }
      container.append("<li>".concat(text, "</li>"));
    }
  }, {
    key: "getTaskUrl",
    value: function getTaskUrl(type, task) {
      var url = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative);
      url += "/".concat(type, "s.json");
      url += "/task".concat(external_GravAdmin_namespaceObject.config.param_sep).concat(task);
      return url;
    }
  }, {
    key: "getRemovePackageUrl",
    value: function getRemovePackageUrl(type) {
      return "".concat(Packages.getTaskUrl(type, 'removePackage'));
    }
  }, {
    key: "getReinstallPackageUrl",
    value: function getReinstallPackageUrl(type) {
      return "".concat(Packages.getTaskUrl(type, 'reinstallPackage'));
    }
  }, {
    key: "getGetPackagesDependenciesUrl",
    value: function getGetPackagesDependenciesUrl(type) {
      return "".concat(Packages.getTaskUrl(type, 'getPackagesDependencies'));
    }
  }, {
    key: "getInstallDependenciesOfPackagesUrl",
    value: function getInstallDependenciesOfPackagesUrl(type) {
      return "".concat(Packages.getTaskUrl(type, 'installDependenciesOfPackages'));
    }
  }, {
    key: "getInstallPackageUrl",
    value: function getInstallPackageUrl(type) {
      return "".concat(Packages.getTaskUrl(type, 'installPackage'));
    }
  }, {
    key: "addNeededDependencyToList",
    value: function addNeededDependencyToList(action, slug) {
      external_jQuery_default()('.install-dependencies-package-container .type-' + action).removeClass('hidden');
      var list = external_jQuery_default()('.install-dependencies-package-container .type-' + action + ' ul');
      if (action !== 'install') {
        var current_version = '';
        var available_version = '';
        var _name2 = '';
        var resources = gpm_Instance.payload.payload.resources;
        if (resources.plugins[slug]) {
          available_version = resources.plugins[slug].available;
          current_version = resources.plugins[slug].version;
          _name2 = resources.plugins[slug].name;
        } else if (resources.themes[slug]) {
          available_version = resources.themes[slug].available;
          current_version = resources.themes[slug].version;
          _name2 = resources.themes[slug].name;
        }
        list.append("<li>".concat(_name2 ? _name2 : slug, ", ").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.FROM, " v<strong>").concat(current_version, "</strong> ").concat(external_GravAdmin_namespaceObject.translations.PLUGIN_ADMIN.TO, " v<strong>").concat(available_version, "</strong></li>"));
      } else {
        list.append("<li>".concat(name ? name : slug, "</li>"));
      }
    }
  }, {
    key: "getSlugsFromEvent",
    value: function getSlugsFromEvent(event) {
      var slugs = '';
      if (external_jQuery_default()(event.target).is('[data-packages-slugs]')) {
        slugs = external_jQuery_default()(event.target).attr('data-packages-slugs');
      } else {
        slugs = external_jQuery_default()(event.target).parent('[data-packages-slugs]').attr('data-packages-slugs');
      }
      if (typeof slugs === 'undefined') {
        return null;
      }
      slugs = slugs.split(',');
      return typeof slugs === 'string' ? [slugs] : slugs;
    }
  }]);
}();
/* harmony default export */ const utils_packages = (new Packages());
// EXTERNAL MODULE: ./node_modules/mout/string/camelCase.js
var camelCase = __webpack_require__(84958);
var camelCase_default = /*#__PURE__*/__webpack_require__.n(camelCase);
// EXTERNAL MODULE: ./node_modules/mout/string/contains.js
var contains = __webpack_require__(75019);
var contains_default = /*#__PURE__*/__webpack_require__.n(contains);
;// CONCATENATED MODULE: ./app/plugins/index.js






// Plugins sliders details
external_jQuery_default()('.gpm-name, .gpm-actions').on('click', function (e) {
  var element = external_jQuery_default()(this);
  var target = external_jQuery_default()(e.target);
  var tag = target.prop('tagName').toLowerCase();
  if (tag === 'a' || element.parent('a').length || target.parent('a').length) {
    return true;
  }
  var wrapper = element.siblings('.gpm-details').find('.table-wrapper');
  wrapper.slideToggle({
    duration: 350,
    complete: function complete() {
      var visible = wrapper.is(':visible');
      wrapper.closest('tr').find('.gpm-details-expand i').removeClass('fa-chevron-' + (visible ? 'down' : 'up')).addClass('fa-chevron-' + (visible ? 'up' : 'down'));
    }
  });
});

// Removing plugin
external_jQuery_default()(document).on('click', '[data-plugin-action="remove-package"]', function (event) {
  utils_packages.handleRemovingPackage('plugin', event);
});

// Reinstall plugin
external_jQuery_default()(document).on('click', '[data-plugin-action="reinstall-package"]', function (event) {
  utils_packages.handleReinstallPackage('plugin', event);
});
external_jQuery_default()(document).on('click', '[data-plugin-action="remove-dependency-package"]', function (event) {
  utils_packages.handleRemovingDependency('plugin', event);
});

// Trigger the add new plugin / update plugin modal
external_jQuery_default()(document).on('click', '[data-plugin-action="start-package-installation"]', function (event) {
  utils_packages.handleGettingPackageDependencies('plugin', event, 'install');
});

// Trigger the update all plugins modal
external_jQuery_default()(document).on('click', '[data-plugin-action="start-packages-update"]', function (event) {
  utils_packages.handleGettingPackageDependencies('plugin', event);
});

// Install a plugin dependencies and the plugin
external_jQuery_default()(document).on('click', '[data-plugin-action="install-dependencies-and-package"]', function (event) {
  utils_packages.handleInstallingDependenciesAndPackage('plugin', event);
});

// Install a plugin
external_jQuery_default()(document).on('click', '[data-plugin-action="install-package"]', function (event) {
  utils_packages.handleInstallingPackage('plugin', event);
});

// Sort plugins/themes dropdown
external_jQuery_default()(document).on('change', '.sort-actions select', function (event) {
  var direction = external_jQuery_default()('.sort-actions .sort-icon .fa').hasClass('fa-sort-amount-desc') ? 'desc' : 'asc';
  var sorting = external_jQuery_default()(event.currentTarget).val();
  utils_packages.Sort[camelCase_default()("by-".concat(sorting))](direction);
});

// Sort plugins/themes icon
external_jQuery_default()(document).on('click', '.sort-icon', function (event) {
  var icon = external_jQuery_default()(event.currentTarget).find('.fa');
  var current = icon.hasClass('fa-sort-amount-asc') ? 'asc' : 'desc';
  var opposite = current === 'asc' ? 'desc' : 'asc';
  icon.removeClass("fa-sort-amount-".concat(current)).addClass("fa-sort-amount-".concat(opposite));
  external_jQuery_default()('.sort-actions select').trigger('change');
});

// Filter plugin/theme
external_jQuery_default()(document).on('input', '[data-gpm-filter]', debounce_default()(function (event) {
  var value = external_jQuery_default()(external_jQuery_default()(event.currentTarget)).val();
  var items = external_jQuery_default()('[data-gpm-plugin], [data-gpm-theme]');
  items.hide().filter(function (index, item) {
    item = external_jQuery_default()(item);
    return contains_default()(item.data('gpm-plugin'), value) || contains_default()(item.data('gpm-theme'), value) || contains_default()(item.data('gpm-name').toLowerCase(), value.toLowerCase());
  }).show();
}, 250));
;// CONCATENATED MODULE: ./app/themes/index.js



// Themes Switcher Warning
external_jQuery_default()(document).on('mousedown', '[data-remodal-target="theme-switch-warn"]', function (event) {
  var name = external_jQuery_default()(event.target).closest('[data-gpm-theme]').find('.gpm-name a:first').text();
  var remodal = external_jQuery_default()('.remodal.theme-switcher');
  remodal.find('strong').text(name);
  remodal.find('.button.continue').attr('href', external_jQuery_default()(event.target).attr('href'));
});

// Removing theme
external_jQuery_default()(document).on('click', '[data-theme-action="remove-package"]', function (event) {
  utils_packages.handleRemovingPackage('theme', event);
});

// Reinstall theme
external_jQuery_default()(document).on('click', '[data-theme-action="reinstall-package"]', function (event) {
  utils_packages.handleReinstallPackage('theme', event);
});
external_jQuery_default()(document).on('click', '[data-theme-action="remove-dependency-package"]', function (event) {
  utils_packages.handleRemovingDependency('theme', event);
});

// Opened the add new theme / update theme modal
external_jQuery_default()(document).on('click', '[data-theme-action="start-package-installation"]', function (event) {
  utils_packages.handleGettingPackageDependencies('theme', event, 'install');
});

// Trigger the update all themes modal
external_jQuery_default()(document).on('click', '[data-theme-action="start-packages-update"]', function (event) {
  utils_packages.handleGettingPackageDependencies('theme', event);
});

// Install a theme dependencies and the theme
external_jQuery_default()(document).on('click', '[data-theme-action="install-dependencies-and-package"]', function (event) {
  utils_packages.handleInstallingDependenciesAndPackage('theme', event);
});

// Install a theme
external_jQuery_default()(document).on('click', '[data-theme-action="install-package"]', function (event) {
  utils_packages.handleInstallingPackage('theme', event);
});
;// CONCATENATED MODULE: ./app/media/index.js
function app_media_typeof(o) { "@babel/helpers - typeof"; return app_media_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, app_media_typeof(o); }
function app_media_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function app_media_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, app_media_toPropertyKey(o.key), o); } }
function app_media_createClass(e, r, t) { return r && app_media_defineProperties(e.prototype, r), t && app_media_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function app_media_toPropertyKey(t) { var i = app_media_toPrimitive(t, "string"); return "symbol" == app_media_typeof(i) ? i : i + ""; }
function app_media_toPrimitive(t, r) { if ("object" != app_media_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != app_media_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



var Filter = /*#__PURE__*/function () {
  function Filter() {
    app_media_classCallCheck(this, Filter);
    this.URI = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/media-manager/");
  }
  return app_media_createClass(Filter, [{
    key: "filter",
    value: function filter(name, value) {
      var filtered = [];
      var keys = Object.keys(external_GravAdmin_namespaceObject.uri_params);
      if (!~keys.indexOf(name)) {
        keys.push(name);
      }
      keys.forEach(function (key) {
        var filter = Filter.cleanValue(key === name ? value : external_GravAdmin_namespaceObject.uri_params[key]);
        if (filter !== '*') {
          filtered.push("".concat(key).concat(external_GravAdmin_namespaceObject.config.param_sep).concat(filter));
        }
      });
      __webpack_require__.g.location = this.URI + filtered.join('/');
    }
  }], [{
    key: "cleanValue",
    value: function cleanValue(value) {
      return encodeURIComponent(value.replace('/', '\\'));
    }
  }]);
}();

var app_media_Instance = new Filter();
var isLoading = false;
var filters = {};
var global_index = 1;
var files_ended = false;
var MEDIA_PAGINATION_INTERVAL = 20;

/* handle changing file type / date filter */
external_jQuery_default()('body').on('change', '.thumbs-list-container select.filter', function (event) {
  var target = external_jQuery_default()(event.currentTarget);
  var filterName = target.data('name');
  var filterValue = target.val();
  if (filterValue) {
    filters[filterName] = filterValue;
  } else {
    delete filters[filterName];
  }
  filterFiles();
});

/* initialize media uploader */
if (external_jQuery_default()('.thumbs-list-container .dropzone')[0]) {
  external_jQuery_default()('.thumbs-list-container .dropzone')[0].dropzone.on('queuecomplete', function () {
    var body = {};
    if (filters.page) {
      body.page = filters.page;
    }
    if (filters.date) {
      body.date = filters.date;
    }
    if (filters.type) {
      body.type = filters.type;
    }
    external_jQuery_default()('.dropzone')[0].dropzone.files.forEach(function (file) {
      file.previewElement.remove();
    });
    external_jQuery_default()('.dropzone').first().removeClass('dz-started');
    utils_request("".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/media-manager.json/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "clearMediaCache"), {
      method: 'post',
      body: body
    }, function () {
      filterFiles();
    });
  });
}

/* handle loading media */
var loadMedia = function loadMedia(filters, callback) {
  var url = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/media.json/tmpl").concat(external_GravAdmin_namespaceObject.config.param_sep, "media-list-content/index").concat(external_GravAdmin_namespaceObject.config.param_sep).concat(global_index);
  if (filters.page) {
    url += "/page".concat(external_GravAdmin_namespaceObject.config.param_sep).concat(filters.page.split('/').join('%5C'));
  }
  if (filters.type && filters.type !== '*') {
    url += "/type".concat(external_GravAdmin_namespaceObject.config.param_sep).concat(filters.type);
  }
  if (filters.date && filters.date !== '*') {
    url += "/date".concat(external_GravAdmin_namespaceObject.config.param_sep).concat(filters.date);
  }
  if (!isLoading) {
    isLoading = true;
    external_jQuery_default()('.spinning-wheel').show();
    external_jQuery_default().get(url, function (content) {
      external_jQuery_default()('.js__files').append(content);
      external_jQuery_default()('.spinning-wheel').hide();
      external_jQuery_default()('.media-container .media-range').trigger('change');
      isLoading = false;
      global_index++;
      callback(content);
    });
  }
};
var cleanFilesList = function cleanFilesList() {
  external_jQuery_default()('.js__files .card-item').remove();
};
var resetActiveStateInSidebar = function resetActiveStateInSidebar() {
  external_jQuery_default()('.pages-list-container .row').removeClass('active'); // clear active state in sidebar
};
var showEmptyState = function showEmptyState() {
  external_jQuery_default()('.thumbs-list-container').append('<p class="card-item empty-space">No media found</p>');
};
var filterFiles = function filterFiles() {
  cleanFilesList();
  global_index = 0;
  files_ended = false;
  external_jQuery_default()('.empty-space').remove();
  loadMedia(filters, function (content) {
    if (!content.trim().length) {
      showEmptyState();
    } else {
      if (!filters.page && (!filters.date || filters.date === '*') && (!filters.type || filters.type === '*')) {
        external_jQuery_default()('.js__files').trigger('fillView');
      }
    }
  });
};

/* handle changing page */
external_jQuery_default()('body').on('click', '.pages-list-container .js__page-link', function (event) {
  var page = external_jQuery_default()(event.target).data('page');
  filters['page'] = page;
  external_jQuery_default()('.media-list-title .page-indicator').html(page); // set indication
  external_jQuery_default()('.js__reset-pages-filter').removeClass('hidden'); // activate reset pages icon
  resetActiveStateInSidebar();
  external_jQuery_default()(event.target).parents('.row').addClass('active'); // set active state in sidebar
  external_jQuery_default()('.js__file-uploader').removeClass('hidden');

  // customize processing URL, as the page changes dynamically
  if (external_jQuery_default()('.dropzone')[0]) {
    external_jQuery_default()('.dropzone')[0].dropzone.on('processing', function (file) {
      this.options.url = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/media-manager").concat(page, ".json/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "addmedia");
    });
  }
  external_jQuery_default()('.js__button-clear-media-cache').addClass('hidden');
  filterFiles();
  disableInfiniteScrolling(); // only infinite scroll on main list, not inside single pages
});

/* handle clearing page filter */
external_jQuery_default()('body').on('click', '.js__reset-pages-filter', function (event) {
  external_jQuery_default()('.media-list-title .page-indicator').html('All Pages'); // set indication
  cleanFilesList();
  resetActiveStateInSidebar();
  external_jQuery_default()('.js__reset-pages-filter').addClass('hidden'); // remove reset pages icon
  external_jQuery_default()('.js__file-uploader').addClass('hidden');
  external_jQuery_default()('.js__button-clear-media-cache').removeClass('hidden');
  delete filters['page'];
  filterFiles();
});

/* handle infinite loading */
var enableInfiniteScrolling = function enableInfiniteScrolling() {
  external_jQuery_default()('.spinning-wheel').hide();
  var view = external_jQuery_default()('.mediapicker-scroll').last();
  if (!view.length) {
    return;
  }
  external_jQuery_default()(view).on('scroll', function () {
    if (external_jQuery_default()(this).scrollTop() + external_jQuery_default()(this).innerHeight() + 100 >= external_jQuery_default()(this)[0].scrollHeight) {
      fillView();
    }
  });
};
var loadNextBatch = function loadNextBatch(callback) {
  if (files_ended) {
    return;
  }
  loadMedia({}, function (content) {
    if (!external_jQuery_default()(content).length || content.split('card-item').length - 1 < MEDIA_PAGINATION_INTERVAL) {
      files_ended = true;
    } else {
      if (callback) {
        callback();
      }
    }
    external_jQuery_default()('.media-container .media-range').trigger('input');
  });
};
var fillView = function fillView() {
  if (!external_jQuery_default()('.js__files').find('.card-item').last().offset()) {
    setTimeout(function () {
      // retry later
      fillView();
    }, 300);
    return;
  }
  if (external_jQuery_default()('.js__files').find('.card-item').last().offset().top - 1 <= external_jQuery_default()('.media-container').height()) {
    loadNextBatch(function () {
      fillView();
    });
  }
};

/* disable infinite loading */
var disableInfiniteScrolling = function disableInfiniteScrolling() {
  external_jQuery_default()('.spinning-wheel').hide();
  external_jQuery_default()('.content-wrapper').unbind('scroll');
};
external_jQuery_default()('.js__files').on('fillView', function (event) {
  // the first batch got the max number of media files, try loading more
  if (external_jQuery_default()('.js__files')[0].innerHTML.split('card-item').length - 1 === MEDIA_PAGINATION_INTERVAL) {
    fillView();
    enableInfiniteScrolling();
  }
});
;// CONCATENATED MODULE: ./app/utils/2fa.js



var _2fa_body = external_jQuery_default()('body');

// Dashboard update and Grav update
_2fa_body.on('click', '[data-2fa-regenerate]', function (event) {
  event.preventDefault();
  var element = external_jQuery_default()(this);
  var url = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, "/ajax.json/task").concat(external_GravAdmin_namespaceObject.config.param_sep, "regenerate2FASecret");
  element.attr('disabled', 'disabled').find('> .fa').addClass('fa-spin');
  utils_request(url, {
    method: 'post'
  }, function (response) {
    external_jQuery_default()('[data-2fa-image]').attr('src', response.image);
    external_jQuery_default()('[data-2fa-secret]').text(response.secret);
    external_jQuery_default()('[data-2fa-value]').val(response.secret.replace(' ', ''));
    element.removeAttr('disabled').find('> .fa').removeClass('fa-spin');
  });
});
var toggleSecret = function toggleSecret() {
  var toggle = external_jQuery_default()('#toggle_twofa_enabled1');
  var secret = external_jQuery_default()('.twofa-secret');
  secret[toggle.is(':checked') ? 'addClass' : 'removeClass']('show');
};
_2fa_body.on('click', '.twofa-toggle input', toggleSecret);
toggleSecret();
// EXTERNAL MODULE: ./node_modules/mout/queryString.js
var queryString = __webpack_require__(66629);
;// CONCATENATED MODULE: ./app/tools/logs.js


var prepareQuery = function prepareQuery(key, value) {
  return (0,queryString.setParam)(__webpack_require__.g.location.href, key, value);
};
external_jQuery_default()(document).on('change', '.logs-content .block-select select[name]', function (event) {
  var target = external_jQuery_default()(event.currentTarget);
  var name = target.attr('name');
  var value = target.val();
  __webpack_require__.g.location.href = prepareQuery(name, value);
});
;// CONCATENATED MODULE: ./app/tools/index.js

;// CONCATENATED MODULE: ./app/whitelabel/compile.js


/* harmony default export */ const compile = (function () {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    _ref$preview = _ref.preview,
    preview = _ref$preview === void 0 ? false : _ref$preview,
    _ref$exportScss = _ref.exportScss,
    exportScss = _ref$exportScss === void 0 ? false : _ref$exportScss,
    _ref$color_scheme = _ref.color_scheme,
    color_scheme = _ref$color_scheme === void 0 ? {} : _ref$color_scheme,
    _ref$fonts = _ref.fonts,
    fonts = _ref$fonts === void 0 ? {} : _ref$fonts,
    _ref$callback = _ref.callback,
    callback = _ref$callback === void 0 ? function () {} : _ref$callback;
  var task = exportScss ? 'exportScss' : 'compileScss';
  // console.log(config);
  var URI = "".concat(external_GravAdmin_namespaceObject.config.base_url_relative, ".json/task:").concat(task);
  utils_request(URI, {
    method: 'post',
    body: Object.assign({}, preview ? {
      preview: preview
    } : null, color_scheme)
  }, callback);
});
var prepareElement = function prepareElement(element) {
  element.data('busy_right_now', true);
  if (!element.data('current_icon')) {
    element.data('current_icon', element.find('.fa').attr('class'));
  }
  element.find('.fa').attr('class', 'fa fa-fw fa-spin fa-refresh');
};
var resetElement = function resetElement(element) {
  element.data('busy_right_now', false);
  element.find('.fa').attr('class', element.data('current_icon'));
};
;// CONCATENATED MODULE: ./app/whitelabel/presets.js


var presets_body = external_jQuery_default()('body');
var presets_fields = [];
var presets_FormState = app_forms.FormState.Instance;
var setField = function setField(field, value) {
  var name = field.prop('name');
  var tag = field.prop('tagName').toLowerCase();
  var type = field.prop('type');
  presets_fields.push(name);
  switch (tag) {
    case 'select':
      field.val(value);
      field.data('selectize').setValue(value);
      field.trigger('change');
      break;
    case 'input':
      if (type === 'radio') {
        var strValue = value ? '1' : '0';
        field.filter(function (index, radio) {
          return external_jQuery_default()(radio).val() === strValue;
        }).prop('checked', true);
        break;
      }
      if (type === 'checkbox') {
        field.prop('checked', value);
        break;
      }
      field.val(value);
      field.trigger('keyup');
  }
};
presets_body.on('click', '[data-preset-values]', function (event) {
  var target = external_jQuery_default()(event.currentTarget);
  var data = target.data('preset-values');
  Object.keys(data).forEach(function (section) {
    if (typeof data[section] === 'string') {
      return;
    }
    Object.keys(data[section]).forEach(function (key) {
      var field = external_jQuery_default()("[name=\"data[whitelabel][color_scheme][".concat(section, "][").concat(key, "]\"], [name=\"data[").concat(section, "][").concat(key, "]\"]"));
      var value = data[section][key];
      setField(field, value);
    });
  });
});
presets_body.on('click', '[data-reset-scss]', function (event) {
  event && event.preventDefault();
  var element = external_jQuery_default()(event.currentTarget);
  var links = external_jQuery_default()('link[id^=admin-pro-preview-]');
  element.remove();
  links.remove();
  presets_fields.forEach(function (field) {
    var value = presets_FormState.loadState.get(field);
    setField(external_jQuery_default()("[name=\"".concat(field, "\"]")), value);
  });
  presets_fields = [];
});

// Horizontal Scroll Functionality
(external_jQuery_default()).fn.hscrollarrows = function () {
  return this.each(function () {
    var navNext = external_jQuery_default()('<a class="nav-next hide"></a>');
    var navPrev = external_jQuery_default()('<a class="nav-prev hide"></a>');
    var scrollTime = null;
    var resizeTime = null;
    var scrolling = false;
    var elm_w = 0;
    var elem_data_w = 0;
    var max_scroll = 0;
    var inc_scroll = 0;
    var calcData = function calcData() {
      elm_w = elem.width();
      elem_data_w = elem_data.get(0).scrollWidth;
      max_scroll = elem_data_w - elm_w;
      inc_scroll = elm_w * 0.3; // 20%
    };
    var revalidate = function revalidate() {
      calcData();
      stateNavs();
    };
    var run = function run() {
      calcData();
      setupNavs();
    };
    var setupNavs = function setupNavs() {
      elem.parent().prepend(navNext);
      elem.parent().prepend(navPrev);
      navNext.on('click', next);
      navPrev.on('click', prev);
      stateNavs();
      external_jQuery_default()(elem).scroll(function () {
        if (!scrolling) {
          clearTimeout(scrollTime);
          scrollTime = setTimeout(function () {
            stateNavs();
          }, 250);
        }
      });
      external_jQuery_default()(window).resize(function () {
        clearTimeout(resizeTime);
        resizeTime = setTimeout(function () {
          revalidate();
        }, 250);
      });
    };
    var stateNavs = function stateNavs() {
      var current_scroll = elem.scrollLeft();
      if (current_scroll < max_scroll) {
        navNext.removeClass('hide');
      } else {
        navNext.addClass('hide');
      }
      if (current_scroll > 0) {
        navPrev.removeClass('hide');
      } else {
        navPrev.addClass('hide');
      }
      scrolling = false;
    };
    var next = function next() {
      var current_scroll = elem.scrollLeft();
      if (current_scroll < max_scroll) {
        scrolling = true;
        elem.stop().animate({
          scrollLeft: current_scroll + inc_scroll
        }, stateNavs);
      }
    };
    var prev = function prev() {
      var current_scroll = elem.scrollLeft();
      if (current_scroll > 0) {
        scrolling = true;
        elem.stop().animate({
          scrollLeft: current_scroll - inc_scroll
        }, stateNavs);
      }
    };
    var elem = external_jQuery_default()(this);
    var elem_data = external_jQuery_default()(':first-child', elem);
    run();
  });
};
external_jQuery_default()(document).ready(function () {
  external_jQuery_default()('.jquery-horizontal-scroll').hscrollarrows();
});
;// CONCATENATED MODULE: ./app/whitelabel/index.js





var whitelabel_body = external_jQuery_default()('body');
var whitelabel_FormState = app_forms.FormState.Instance;
var compiler = function compiler(element) {
  var preview = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var exportScss = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var _callback = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : function () {};
  prepareElement(element);
  var fields = whitelabel_FormState.collect();
  compile({
    preview: preview,
    exportScss: exportScss,
    color_scheme: !fields ? [] : fields.filter(function (value, key) {
      return key.match(/^data\[whitelabel]\[color_scheme]/);
    }).toJS(),
    callback: function callback(response) {
      _callback.call(_callback, response);
      resetElement(element);
    }
  });
};
whitelabel_body.on('click', '[data-preview-scss]', function (event) {
  event && event.preventDefault();
  var element = external_jQuery_default()(event.currentTarget);
  if (element.data('busy_right_now')) {
    return false;
  }
  compiler(element, true, false, function (response) {
    if (response.files) {
      Object.keys(response.files).forEach(function (key) {
        var file = external_jQuery_default()("#admin-pro-preview-".concat(key));
        var timestamp = Date.now();
        if (!file.length) {
          file = external_jQuery_default()("<link id=\"admin-pro-preview-".concat(key, "\" type=\"text/css\" rel=\"stylesheet\" />"));
          external_jQuery_default()('head').append(file);
          if (!external_jQuery_default()('[data-reset-scss]').length) {
            var reset = external_jQuery_default()('<button class="button" data-reset-scss style="margin-left: 5px;"><i class="fa fa-fw fa-history"></i> Reset</button>');
            reset.insertAfter(element);
          }
        }
        file.attr('href', "".concat(response.files[key], "?").concat(timestamp));
      });
    }
  });
});
whitelabel_body.on('click', '[data-recompile-scss]', function (event) {
  event && event.preventDefault();
  var element = external_jQuery_default()(event.currentTarget);
  if (element.data('busy_right_now')) {
    return false;
  }
  compiler(element, true, false);
});
whitelabel_body.on('click', '[data-export-scss]', function (event) {
  event && event.preventDefault();
  var element = external_jQuery_default()(event.currentTarget);
  if (element.data('busy_right_now')) {
    return false;
  }
  compiler(element, true, true, function (response) {
    if (response.files) {
      Object.keys(response.files).forEach(function (key) {
        if (key === 'download') {
          var _element = document.createElement('a');
          _element.setAttribute('href', response.files[key]);
          _element.setAttribute('download', '');
          _element.style.display = 'none';
          document.body.appendChild(_element);
          _element.click();
          document.body.removeChild(_element);
        }
      });
    }
  });
});
whitelabel_body.on('change._grav_colorpicker', '[data-grav-colorpicker]', function (event, input, hex, opacity) {
  var RGB = hex2rgb(hex);
  var YIQ = (RGB.r * 299 + RGB.g * 587 + RGB.b * 114) / 1000;
  var contrast = YIQ >= 128 || opacity <= 0.50 ? 'dark' : 'light';
  input.parent().removeClass('dark-text light-text').addClass("".concat(contrast, "-text"));
});
whitelabel_body.ready(function () {
  external_jQuery_default()('[data-grav-colorpicker]').trigger('keyup');
});
;// CONCATENATED MODULE: ./app/utils/bootstrap-transition.js

+function ($) {
  'use strict';

  // CSS TRANSITION SUPPORT (Shoutout: http://www.modernizr.com/)
  // ============================================================
  function transitionEnd() {
    var el = document.createElement('bootstrap');
    var transEndEventNames = {
      WebkitTransition: 'webkitTransitionEnd',
      MozTransition: 'transitionend',
      OTransition: 'oTransitionEnd otransitionend',
      transition: 'transitionend'
    };
    for (var name in transEndEventNames) {
      if (el.style[name] !== undefined) {
        return {
          end: transEndEventNames[name]
        };
      }
    }
    return false; // explicit for ie8 (  ._.)
  }

  // http://blog.alexmaccaw.com/css-transitions
  $.fn.emulateTransitionEnd = function (duration) {
    var called = false;
    var $el = this;
    $(this).one('bsTransitionEnd', function () {
      called = true;
    });
    var callback = function callback() {
      if (!called) $($el).trigger($.support.transition.end);
    };
    setTimeout(callback, duration);
    return this;
  };
  $(function () {
    $.support.transition = transitionEnd();
    if (!$.support.transition) return;
    $.event.special.bsTransitionEnd = {
      bindType: $.support.transition.end,
      delegateType: $.support.transition.end,
      handle: function handle(e) {
        if ($(e.target).is(this)) return e.handleObj.handler.apply(this, arguments);
      }
    };
  });
}((external_jQuery_default()));
;// CONCATENATED MODULE: ./app/utils/bootstrap-collapse.js
function bootstrap_collapse_typeof(o) { "@babel/helpers - typeof"; return bootstrap_collapse_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, bootstrap_collapse_typeof(o); }


/* ========================================================================
 * Bootstrap: collapse.js v3.4.0
 * http://getbootstrap.com/javascript/#collapse
 * ========================================================================
 * Copyright 2011-2016 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

/* jshint latedef: false */

+function ($) {
  'use strict';

  // COLLAPSE PUBLIC CLASS DEFINITION
  // ================================
  var Collapse = function Collapse(element, options) {
    this.$element = $(element);
    this.options = $.extend({}, Collapse.DEFAULTS, options);
    this.$trigger = $('[data-toggle="collapse"][href="#' + element.id + '"],' + '[data-toggle="collapse"][data-target="#' + element.id + '"]');
    this.transitioning = null;
    if (this.options.parent) {
      this.$parent = this.getParent();
    } else {
      this.addAriaAndCollapsedClass(this.$element, this.$trigger);
    }
    if (this.options.toggle) this.toggle();
  };
  Collapse.VERSION = '3.4.0';
  Collapse.TRANSITION_DURATION = 350;
  Collapse.DEFAULTS = {
    toggle: true
  };
  Collapse.prototype.dimension = function () {
    var hasWidth = this.$element.hasClass('width');
    return hasWidth ? 'width' : 'height';
  };
  Collapse.prototype.show = function () {
    if (this.transitioning || this.$element.hasClass('in')) return;
    var activesData;
    var actives = this.$parent && this.$parent.children('.panel').children('.in, .collapsing');
    if (actives && actives.length) {
      activesData = actives.data('bs.collapse');
      if (activesData && activesData.transitioning) return;
    }
    var startEvent = $.Event('show.bs.collapse');
    this.$element.trigger(startEvent);
    if (startEvent.isDefaultPrevented()) return;
    if (actives && actives.length) {
      Plugin.call(actives, 'hide');
      activesData || actives.data('bs.collapse', null);
    }
    var dimension = this.dimension();
    this.$element.removeClass('collapse').addClass('collapsing')[dimension](0).attr('aria-expanded', true);
    this.$trigger.removeClass('collapsed').attr('aria-expanded', true);
    this.transitioning = 1;
    var complete = function complete() {
      this.$element.removeClass('collapsing').addClass('collapse in')[dimension]('');
      this.transitioning = 0;
      this.$element.trigger('shown.bs.collapse');
    };
    if (!$.support.transition) return complete.call(this);
    var scrollSize = $.camelCase(['scroll', dimension].join('-'));
    this.$element.one('bsTransitionEnd', $.proxy(complete, this)).emulateTransitionEnd(Collapse.TRANSITION_DURATION)[dimension](this.$element[0][scrollSize]);
  };
  Collapse.prototype.hide = function () {
    if (this.transitioning || !this.$element.hasClass('in')) return;
    var startEvent = $.Event('hide.bs.collapse');
    this.$element.trigger(startEvent);
    if (startEvent.isDefaultPrevented()) return;
    var dimension = this.dimension();
    this.$element[dimension](this.$element[dimension]())[0].offsetHeight;
    this.$element.addClass('collapsing').removeClass('collapse in').attr('aria-expanded', false);
    this.$trigger.addClass('collapsed').attr('aria-expanded', false);
    this.transitioning = 1;
    var complete = function complete() {
      this.transitioning = 0;
      this.$element.removeClass('collapsing').addClass('collapse').trigger('hidden.bs.collapse');
    };
    if (!$.support.transition) return complete.call(this);
    this.$element[dimension](0).one('bsTransitionEnd', $.proxy(complete, this)).emulateTransitionEnd(Collapse.TRANSITION_DURATION);
  };
  Collapse.prototype.toggle = function () {
    this[this.$element.hasClass('in') ? 'hide' : 'show']();
  };
  Collapse.prototype.getParent = function () {
    return $(this.options.parent).find('[data-toggle="collapse"][data-parent="' + this.options.parent + '"]').each($.proxy(function (i, element) {
      var $element = $(element);
      this.addAriaAndCollapsedClass(getTargetFromTrigger($element), $element);
    }, this)).end();
  };
  Collapse.prototype.addAriaAndCollapsedClass = function ($element, $trigger) {
    var isOpen = $element.hasClass('in');
    $element.attr('aria-expanded', isOpen);
    $trigger.toggleClass('collapsed', !isOpen).attr('aria-expanded', isOpen);
  };
  function getTargetFromTrigger($trigger) {
    var href;
    var target = $trigger.attr('data-target') || (href = $trigger.attr('href')) && href.replace(/.*(?=#[^\s]+$)/, ''); // strip for ie7

    return $(target);
  }

  // COLLAPSE PLUGIN DEFINITION
  // ==========================

  function Plugin(option) {
    return this.each(function () {
      var $this = $(this);
      var data = $this.data('bs.collapse');
      var options = $.extend({}, Collapse.DEFAULTS, $this.data(), bootstrap_collapse_typeof(option) === 'object' && option);
      if (!data && options.toggle && /show|hide/.test(option)) options.toggle = false;
      if (!data) $this.data('bs.collapse', data = new Collapse(this, options));
      if (typeof option === 'string') data[option]();
    });
  }
  var old = $.fn.collapse;
  $.fn.collapse = Plugin;
  $.fn.collapse.Constructor = Collapse;

  // COLLAPSE NO CONFLICT
  // ====================

  $.fn.collapse.noConflict = function () {
    $.fn.collapse = old;
    return this;
  };

  // COLLAPSE DATA-API
  // =================

  $(document).on('click.bs.collapse.data-api', '[data-toggle="collapse"]', function (e) {
    var $this = $(this);
    if (!$this.attr('data-target')) e.preventDefault();
    var $target = getTargetFromTrigger($this);
    var data = $target.data('bs.collapse');
    var option = data ? 'toggle' : $this.data();
    Plugin.call($target, option);
  });
}((external_jQuery_default()));
;// CONCATENATED MODULE: ./app/utils/bootstrap-dropdown.js


/* ========================================================================
 * Bootstrap: dropdown.js v3.4.1
 * https://getbootstrap.com/docs/3.4/javascript/#dropdowns
 * ========================================================================
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/v3-dev/LICENSE)
 * ======================================================================== */

+function ($) {
  'use strict';

  // DROPDOWN CLASS DEFINITION
  // =========================
  var backdrop = '.dropdown-backdrop';
  var toggle = '[data-toggle="dropdown"]';
  var Dropdown = function Dropdown(element) {
    $(element).on('click.bs.dropdown', this.toggle);
  };
  Dropdown.VERSION = '3.4.1';
  function getParent($this) {
    var selector = $this.attr('data-target');
    if (!selector) {
      selector = $this.attr('href');
      selector = selector && /#[A-Za-z]/.test(selector) && selector.replace(/.*(?=#[^\s]*$)/, ''); // strip for ie7
    }
    var $parent = selector !== '#' ? $(document).find(selector) : null;
    return $parent && $parent.length ? $parent : $this.parent();
  }
  function clearMenus(e) {
    if (e && e.which === 3) {
      return;
    }
    $(backdrop).remove();
    $(toggle).each(function () {
      var $this = $(this);
      var $parent = getParent($this);
      var relatedTarget = {
        relatedTarget: this
      };
      if (!$parent.hasClass('open')) {
        return;
      }
      if (e && e.type === 'click' && /input|textarea/i.test(e.target.tagName) && $.contains($parent[0], e.target)) {
        return;
      }
      $parent.trigger(e = $.Event('hide.bs.dropdown', relatedTarget));
      if (e.isDefaultPrevented()) {
        return;
      }
      $this.attr('aria-expanded', 'false');
      $parent.removeClass('open').trigger($.Event('hidden.bs.dropdown', relatedTarget));
    });
  }
  Dropdown.prototype.toggle = function (e) {
    var $this = $(this);
    if ($this.is('.disabled, :disabled')) {
      return;
    }
    var $parent = getParent($this);
    var isActive = $parent.hasClass('open');
    clearMenus();
    if (!isActive) {
      if ('ontouchstart' in document.documentElement && !$parent.closest('.navbar-nav').length) {
        // if mobile we use a backdrop because click events don't delegate
        $(document.createElement('div')).addClass('dropdown-backdrop').insertAfter($(this)).on('click', clearMenus);
      }
      var relatedTarget = {
        relatedTarget: this
      };
      $parent.trigger(e = $.Event('show.bs.dropdown', relatedTarget));
      if (e.isDefaultPrevented()) {
        return;
      }
      $this.trigger('focus').attr('aria-expanded', 'true');
      $parent.toggleClass('open').trigger($.Event('shown.bs.dropdown', relatedTarget));
    }
    return false;
  };
  Dropdown.prototype.keydown = function (e) {
    if (!/(38|40|27|32)/.test(e.which) || /input|textarea/i.test(e.target.tagName)) return;
    var $this = $(this);
    e.preventDefault();
    e.stopPropagation();
    if ($this.is('.disabled, :disabled')) {
      return;
    }
    var $parent = getParent($this);
    var isActive = $parent.hasClass('open');
    if (!isActive && e.which !== 27 || isActive && e.which === 27) {
      if (e.which === 27) {
        $parent.find(toggle).trigger('focus');
      }
      return $this.trigger('click');
    }
    var desc = ' li:not(.disabled):visible a';
    var $items = $parent.find('.dropdown-menu' + desc);
    if (!$items.length) {
      return;
    }
    var index = $items.index(e.target);
    if (e.which === 38 && index > 0) {
      index--;
    } // up
    if (e.which === 40 && index < $items.length - 1) {
      index++;
    } // down
    if (!~index) {
      index = 0;
    }
    $items.eq(index).trigger('focus');
  };

  // DROPDOWN PLUGIN DEFINITION
  // ==========================

  function Plugin(option) {
    return this.each(function () {
      var $this = $(this);
      var data = $this.data('bs.dropdown');
      if (!data) $this.data('bs.dropdown', data = new Dropdown(this));
      if (typeof option === 'string') data[option].call($this);
    });
  }
  var old = $.fn.dropdown;
  $.fn.dropdown = Plugin;
  $.fn.dropdown.Constructor = Dropdown;

  // DROPDOWN NO CONFLICT
  // ====================

  $.fn.dropdown.noConflict = function () {
    $.fn.dropdown = old;
    return this;
  };

  // APPLY TO STANDARD DROPDOWN ELEMENTS
  // ===================================

  $(document).on('click.bs.dropdown.data-api', clearMenus).on('click.bs.dropdown.data-api', '.dropdown form', function (e) {
    e.stopPropagation();
  }).on('click.bs.dropdown.data-api', toggle, Dropdown.prototype.toggle).on('keydown.bs.dropdown.data-api', toggle, Dropdown.prototype.keydown).on('keydown.bs.dropdown.data-api', '.dropdown-menu', Dropdown.prototype.keydown);
}((external_jQuery_default()));
;// CONCATENATED MODULE: ./app/utils/tabs-memory.js



var tabs_memory_Data = JSON.parse(cookies.get('grav-tabs-state') || '{}');
external_jQuery_default()('body').on('touchstart click', '[data-tabid]', function (event) {
  event && event.stopPropagation();
  var target = external_jQuery_default()(event.currentTarget);
  tabs_memory_Data[target.data('tabkey')] = target.data('scope');
  cookies.set('grav-tabs-state', JSON.stringify(tabs_memory_Data), {
    expires: Infinity
  });
  var panel = external_jQuery_default()("[id=\"".concat(target.data('tabid'), "\"]"));
  target.siblings('[data-tabid]').removeClass('active');
  target.addClass('active');
  panel.siblings('[id]').removeClass('active');
  panel.addClass('active');
  editor_Instance.editors.each(function (index, editor) {
    var codemirror = external_jQuery_default()(editor).data('codemirror');
    if (!codemirror) {
      return;
    }
    if (codemirror.display.lastWrapWidth === 0) {
      codemirror.refresh();
    }
  });
});
;// CONCATENATED MODULE: ./app/utils/changelog.js
/* eslint-disable */

var TRIGGER = null;
external_jQuery_default()(document).on('click', '[data-remodal-changelog]', function (event) {
  TRIGGER = event.currentTarget;
});
external_jQuery_default()(document).on('opened', '[data-remodal-id="changelog"]', function () {
  var instance = (external_jQuery_default()).remodal.lookup[external_jQuery_default()('[data-remodal-id=changelog]').data('remodal')];
  instance.$modal.html('<div class="changelog-overflow center" style="padding:5rem 0;text-align:center;"><i class="fa fa-spinner fa-spin fa-3x fa-fw"></i></div>');
  if (!TRIGGER) {
    return true;
  }
  var url = external_jQuery_default()(TRIGGER).data('remodalChangelog');
  external_jQuery_default().ajax({
    url: url
  }).done(function (data) {
    instance.$modal.html(data);
  });
});
external_jQuery_default()(document).on('closed', '[data-remodal-id="changelog"]', function () {
  var instance = (external_jQuery_default()).remodal.lookup[external_jQuery_default()('[data-remodal-id=changelog]').data('remodal')];
  instance.$modal.html('');
});
;// CONCATENATED MODULE: ./app/utils/sidebar.js
function sidebar_typeof(o) { "@babel/helpers - typeof"; return sidebar_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, sidebar_typeof(o); }
function sidebar_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function sidebar_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, sidebar_toPropertyKey(o.key), o); } }
function sidebar_createClass(e, r, t) { return r && sidebar_defineProperties(e.prototype, r), t && sidebar_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function sidebar_toPropertyKey(t) { var i = sidebar_toPrimitive(t, "string"); return "symbol" == sidebar_typeof(i) ? i : i + ""; }
function sidebar_toPrimitive(t, r) { if ("object" != sidebar_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != sidebar_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


var MOBILE_BREAKPOINT = 48 - 0.062;
var DESKTOP_BREAKPOINT = 75 + 0.063;
var EVENTS = 'touchstart._grav click._grav';
var TARGETS = '[data-sidebar-mobile-toggle], #overlay';
var MOBILE_QUERY = "(max-width: ".concat(MOBILE_BREAKPOINT, "em)");
var DESKTOP_QUERY = "(min-width: ".concat(DESKTOP_BREAKPOINT, "em)");
var map = new __webpack_require__.g.Map();
var Sidebar = /*#__PURE__*/function () {
  function Sidebar() {
    sidebar_classCallCheck(this, Sidebar);
    this.timeout = null;
    this.isOpen = false;
    this.body = external_jQuery_default()('body');
    this.matchMedia = __webpack_require__.g.matchMedia(MOBILE_QUERY);
    this.enable();
  }
  return sidebar_createClass(Sidebar, [{
    key: "enable",
    value: function enable() {
      var sidebar = external_jQuery_default()('#admin-sidebar');
      this.matchMedia.addListener(this._getBound('checkMatch'));
      this.checkMatch(this.matchMedia);
      this.body.on(EVENTS, '[data-sidebar-toggle]', this._getBound('toggleSidebarState'));
      if (sidebar.data('quickopen')) {
        sidebar.hover(this._getBound('quickOpenIn'), this._getBound('quickOpenOut'));
      }
    }
  }, {
    key: "disable",
    value: function disable() {
      var sidebar = external_jQuery_default()('#admin-sidebar');
      this.close();
      this.matchMedia.removeListener(this._getBound('checkMatch'));
      this.body.off(EVENTS, '[data-sidebar-toggle]', this._getBound('toggleSidebarState'));
      if (sidebar.data('quickopen')) {
        sidebar.off('mouseenter mouseleave');
      }
    }
  }, {
    key: "attach",
    value: function attach() {
      this.body.on(EVENTS, TARGETS, this._getBound('toggle'));
    }
  }, {
    key: "detach",
    value: function detach() {
      this.body.off(EVENTS, TARGETS, this._getBound('toggle'));
    }
  }, {
    key: "quickOpenIn",
    value: function quickOpenIn( /* event */
    ) {
      var _this = this;
      var isDesktop = __webpack_require__.g.matchMedia(DESKTOP_QUERY).matches;
      var delay = external_jQuery_default()('#admin-sidebar').data('quickopen-delay') || 500;
      if (this.body.hasClass('sidebar-mobile-open')) {
        return;
      }
      var shouldQuickOpen = isDesktop ? this.body.hasClass('sidebar-closed') : !this.body.hasClass('sidebar-open');
      if (!shouldQuickOpen && !this.body.hasClass('sidebar-quickopen')) {
        return this.quickOpenOut();
      }
      this.timeout = setTimeout(function () {
        _this.body.addClass('sidebar-open sidebar-quickopen');
        external_jQuery_default()(__webpack_require__.g).trigger('sidebar_state._grav', isDesktop);
      }, delay);
    }
  }, {
    key: "quickOpenOut",
    value: function quickOpenOut( /* event */
    ) {
      clearTimeout(this.timeout);
      if (this.body.hasClass('sidebar-quickopen')) {
        this.body.removeClass('sidebar-open sidebar-quickopen');
      }
      return true;
    }
  }, {
    key: "open",
    value: function open(event) {
      var _this2 = this;
      var quick = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (event) {
        event.preventDefault();
      }
      var overlay = external_jQuery_default()('#overlay');
      var sidebar = external_jQuery_default()('#admin-sidebar');
      this.body.addClass('sidebar-mobile-open');
      overlay.css('display', 'block');
      if (!quick) {
        sidebar.css('display', 'block').animate({
          opacity: 1
        }, 200, function () {
          _this2.isOpen = true;
        });
      } else {
        sidebar.css({
          display: 'block',
          opacity: 1
        });
        this.isOpen = true;
      }
    }
  }, {
    key: "close",
    value: function close(event) {
      var _this3 = this;
      var quick = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (event) {
        event.preventDefault();
      }
      var overlay = external_jQuery_default()('#overlay');
      var sidebar = external_jQuery_default()('#admin-sidebar');
      this.body.removeClass('sidebar-mobile-open');
      overlay.css('display', 'none');
      if (!quick) {
        sidebar.animate({
          opacity: 0
        }, 200, function () {
          sidebar.css('display', 'none');
          _this3.isOpen = false;
        });
      } else {
        sidebar.css({
          opacity: 0,
          display: 'none'
        });
        this.isOpen = false;
      }
    }
  }, {
    key: "toggle",
    value: function toggle(event) {
      if (event) {
        event.preventDefault();
      }
      return this[this.isOpen ? 'close' : 'open'](event);
    }
  }, {
    key: "toggleSidebarState",
    value: function toggleSidebarState(event) {
      if (event) {
        event.preventDefault();
      }
      clearTimeout(this.timeout);
      var isDesktop = __webpack_require__.g.matchMedia(DESKTOP_QUERY).matches;
      var cookie = null;
      if (isDesktop) {
        this.body.removeClass('sidebar-open');
      }
      if (!isDesktop) {
        this.body.removeClass('sidebar-closed');
        this.body.removeClass('sidebar-mobile-open');
      }
      this.body.toggleClass("sidebar-".concat(isDesktop ? 'closed' : 'open'));
      external_jQuery_default()(__webpack_require__.g).trigger('sidebar_state._grav', isDesktop);
      if (isDesktop) {
        cookie = !this.body.hasClass('sidebar-closed');
      } else {
        cookie = this.body.hasClass('sidebar-open');
      }
      cookies.set('grav-admin-sidebar', cookie, {
        expires: Infinity
      });
    }
  }, {
    key: "checkMatch",
    value: function checkMatch(data) {
      var sidebar = external_jQuery_default()('#admin-sidebar');
      var overlay = external_jQuery_default()('#overlay');
      this.isOpen = false;
      overlay.css('display', 'none');
      sidebar.css({
        display: data.matches ? 'none' : 'inherit',
        opacity: data.matches ? 0 : 1
      });
      if (data.matches) {
        this.body.removeClass('sidebar-open sidebar-closed');
      }
      this[data.matches ? 'attach' : 'detach']();
    }
  }, {
    key: "_resetMap",
    value: function _resetMap() {
      return map.clear();
    }
  }, {
    key: "_getBound",
    value: function _getBound(fn) {
      if (map.has(fn)) {
        return map.get(fn);
      }
      return map.set(fn, this[fn].bind(this)).get(fn);
    }
  }]);
}();

var sidebar_Instance = new Sidebar();
;// CONCATENATED MODULE: ./app/main.js
// polyfills





















// bootstrap jQuery extensions




// tabs memory


// changelog


// Main Sidebar


// starts the keep alive, auto runs every X seconds
keepalive.start();

// global event to catch sidebar_state changes
external_jQuery_default()(__webpack_require__.g).on('sidebar_state._grav', function () {
  Object.keys(dashboard.Chart.Instances).forEach(function (chart) {
    setTimeout(function () {
      return dashboard.Chart.Instances[chart].chart.update();
    }, 10);
  });
});
/* harmony default export */ const main = ({
  GPM: {
    GPM: GPM,
    Instance: gpm_Instance
  },
  KeepAlive: keepalive,
  Dashboard: dashboard,
  Pages: pages,
  Forms: app_forms,
  Updates: {
    Updates: Updates,
    Notifications: updates_notifications,
    Feed: updates_feed,
    Instance: updates_Instance
  },
  Sidebar: {
    Sidebar: Sidebar,
    Instance: sidebar_Instance
  },
  MediaFilter: {
    MediaFilter: Filter,
    Instance: app_media_Instance
  },
  Scrollbar: {
    Scrollbar: {
      deprecated: true
    },
    Instance: {
      deprecated: true
    }
  },
  Utils: {
    request: utils_request,
    toastr: utils_toastr,
    Cookies: cookies,
    UriToMarkdown: UriToMarkdown
  }
});

/***/ }),

/***/ 70086:
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/*! version : 4.17.47
 =========================================================
 bootstrap-datetimejs
 https://github.com/Eonasdan/bootstrap-datetimepicker
 Copyright (c) 2015 Jonathan Peterson
 =========================================================
 */
/*
 The MIT License (MIT)

 Copyright (c) 2015 Jonathan Peterson

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 */
/* global define:false */
/* global jQuery:false */
/* global moment:false */
(function (factory) {
  'use strict';

  if (true) {
    // AMD is used - Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(41669), __webpack_require__(95093)], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})(function ($, moment) {
  'use strict';

  if (!moment) {
    throw new Error('bootstrap-datetimepicker requires Moment.js to be loaded first');
  }
  var dateTimePicker = function dateTimePicker(element, options) {
    var picker = {};
    var date;
    var viewDate;
    var unset = true;
    var input;
    var component = false;
    var widget = false;
    var use24Hours;
    var minViewModeNumber = 0;
    var actualFormat;
    var parseFormats;
    var currentViewMode;
    var datePickerModes = [{
      clsName: 'days',
      navFnc: 'M',
      navStep: 1
    }, {
      clsName: 'months',
      navFnc: 'y',
      navStep: 1
    }, {
      clsName: 'years',
      navFnc: 'y',
      navStep: 10
    }, {
      clsName: 'decades',
      navFnc: 'y',
      navStep: 100
    }];
    var viewModes = ['days', 'months', 'years', 'decades'];
    var verticalModes = ['top', 'bottom', 'auto'];
    var horizontalModes = ['left', 'right', 'auto'];
    var toolbarPlacements = ['default', 'top', 'bottom'];
    var keyMap = {
      'up': 38,
      38: 'up',
      'down': 40,
      40: 'down',
      'left': 37,
      37: 'left',
      'right': 39,
      39: 'right',
      'tab': 9,
      9: 'tab',
      'escape': 27,
      27: 'escape',
      'enter': 13,
      13: 'enter',
      'pageUp': 33,
      33: 'pageUp',
      'pageDown': 34,
      34: 'pageDown',
      'shift': 16,
      16: 'shift',
      'control': 17,
      17: 'control',
      'space': 32,
      32: 'space',
      't': 84,
      84: 't',
      'delete': 46,
      46: 'delete'
    };
    var keyState = {};

    /** ******************************************************************************
         *
         * Private functions
         *
         ********************************************************************************/

    var hasTimeZone = function hasTimeZone() {
      return moment.tz !== undefined && options.timeZone !== undefined && options.timeZone !== null && options.timeZone !== '';
    };
    var getMoment = function getMoment(d) {
      var returnMoment;
      if (d === undefined || d === null) {
        returnMoment = moment(); // TODO should this use format? and locale?
      } else if (moment.isDate(d) || moment.isMoment(d)) {
        // If the date that is passed in is already a Date() or moment() object,
        // pass it directly to moment.
        returnMoment = moment(d);
      } else if (hasTimeZone()) {
        // There is a string to parse and a default time zone
        // parse with the tz function which takes a default time zone if it is not in the format string
        returnMoment = moment.tz(d, parseFormats, options.useStrict, options.timeZone);
      } else {
        returnMoment = moment(d, parseFormats, options.useStrict);
      }
      if (hasTimeZone()) {
        returnMoment.tz(options.timeZone);
      }
      return returnMoment;
    };
    var isEnabled = function isEnabled(granularity) {
      if (typeof granularity !== 'string' || granularity.length > 1) {
        throw new TypeError('isEnabled expects a single character string parameter');
      }
      switch (granularity) {
        case 'y':
          return actualFormat.indexOf('Y') !== -1;
        case 'M':
          return actualFormat.indexOf('M') !== -1;
        case 'd':
          return actualFormat.toLowerCase().indexOf('d') !== -1;
        case 'h':
        case 'H':
          return actualFormat.toLowerCase().indexOf('h') !== -1;
        case 'm':
          return actualFormat.indexOf('m') !== -1;
        case 's':
          return actualFormat.indexOf('s') !== -1;
        default:
          return false;
      }
    };
    var hasTime = function hasTime() {
      return isEnabled('h') || isEnabled('m') || isEnabled('s');
    };
    var hasDate = function hasDate() {
      return isEnabled('y') || isEnabled('M') || isEnabled('d');
    };
    var getDatePickerTemplate = function getDatePickerTemplate() {
      var headTemplate = $('<thead>').append($('<tr>').append($('<th>').addClass('prev').attr('data-action', 'previous').append($('<span>').addClass(options.icons.previous))).append($('<th>').addClass('picker-switch').attr('data-action', 'pickerSwitch').attr('colspan', options.calendarWeeks ? '6' : '5')).append($('<th>').addClass('next').attr('data-action', 'next').append($('<span>').addClass(options.icons.next))));
      var contTemplate = $('<tbody>').append($('<tr>').append($('<td>').attr('colspan', options.calendarWeeks ? '8' : '7')));
      return [$('<div>').addClass('datepicker-days').append($('<table>').addClass('table-condensed').append(headTemplate).append($('<tbody>'))), $('<div>').addClass('datepicker-months').append($('<table>').addClass('table-condensed').append(headTemplate.clone()).append(contTemplate.clone())), $('<div>').addClass('datepicker-years').append($('<table>').addClass('table-condensed').append(headTemplate.clone()).append(contTemplate.clone())), $('<div>').addClass('datepicker-decades').append($('<table>').addClass('table-condensed').append(headTemplate.clone()).append(contTemplate.clone()))];
    };
    var getTimePickerMainTemplate = function getTimePickerMainTemplate() {
      var topRow = $('<tr>');
      var middleRow = $('<tr>');
      var bottomRow = $('<tr>');
      if (isEnabled('h')) {
        topRow.append($('<td>').append($('<a>').attr({
          href: '#',
          tabindex: '-1',
          'title': options.tooltips.incrementHour
        }).addClass('btn').attr('data-action', 'incrementHours').append($('<span>').addClass(options.icons.up))));
        middleRow.append($('<td>').append($('<span>').addClass('timepicker-hour').attr({
          'data-time-component': 'hours',
          'title': options.tooltips.pickHour
        }).attr('data-action', 'showHours')));
        bottomRow.append($('<td>').append($('<a>').attr({
          href: '#',
          tabindex: '-1',
          'title': options.tooltips.decrementHour
        }).addClass('btn').attr('data-action', 'decrementHours').append($('<span>').addClass(options.icons.down))));
      }
      if (isEnabled('m')) {
        if (isEnabled('h')) {
          topRow.append($('<td>').addClass('separator'));
          middleRow.append($('<td>').addClass('separator').html(':'));
          bottomRow.append($('<td>').addClass('separator'));
        }
        topRow.append($('<td>').append($('<a>').attr({
          href: '#',
          tabindex: '-1',
          'title': options.tooltips.incrementMinute
        }).addClass('btn').attr('data-action', 'incrementMinutes').append($('<span>').addClass(options.icons.up))));
        middleRow.append($('<td>').append($('<span>').addClass('timepicker-minute').attr({
          'data-time-component': 'minutes',
          'title': options.tooltips.pickMinute
        }).attr('data-action', 'showMinutes')));
        bottomRow.append($('<td>').append($('<a>').attr({
          href: '#',
          tabindex: '-1',
          'title': options.tooltips.decrementMinute
        }).addClass('btn').attr('data-action', 'decrementMinutes').append($('<span>').addClass(options.icons.down))));
      }
      if (isEnabled('s')) {
        if (isEnabled('m')) {
          topRow.append($('<td>').addClass('separator'));
          middleRow.append($('<td>').addClass('separator').html(':'));
          bottomRow.append($('<td>').addClass('separator'));
        }
        topRow.append($('<td>').append($('<a>').attr({
          href: '#',
          tabindex: '-1',
          'title': options.tooltips.incrementSecond
        }).addClass('btn').attr('data-action', 'incrementSeconds').append($('<span>').addClass(options.icons.up))));
        middleRow.append($('<td>').append($('<span>').addClass('timepicker-second').attr({
          'data-time-component': 'seconds',
          'title': options.tooltips.pickSecond
        }).attr('data-action', 'showSeconds')));
        bottomRow.append($('<td>').append($('<a>').attr({
          href: '#',
          tabindex: '-1',
          'title': options.tooltips.decrementSecond
        }).addClass('btn').attr('data-action', 'decrementSeconds').append($('<span>').addClass(options.icons.down))));
      }
      if (!use24Hours) {
        topRow.append($('<td>').addClass('separator'));
        middleRow.append($('<td>').append($('<button>').addClass('btn btn-primary').attr({
          'data-action': 'togglePeriod',
          tabindex: '-1',
          'title': options.tooltips.togglePeriod
        })));
        bottomRow.append($('<td>').addClass('separator'));
      }
      return $('<div>').addClass('timepicker-picker').append($('<table>').addClass('table-condensed').append([topRow, middleRow, bottomRow]));
    };
    var getTimePickerTemplate = function getTimePickerTemplate() {
      var hoursView = $('<div>').addClass('timepicker-hours').append($('<table>').addClass('table-condensed'));
      var minutesView = $('<div>').addClass('timepicker-minutes').append($('<table>').addClass('table-condensed'));
      var secondsView = $('<div>').addClass('timepicker-seconds').append($('<table>').addClass('table-condensed'));
      var ret = [getTimePickerMainTemplate()];
      if (isEnabled('h')) {
        ret.push(hoursView);
      }
      if (isEnabled('m')) {
        ret.push(minutesView);
      }
      if (isEnabled('s')) {
        ret.push(secondsView);
      }
      return ret;
    };
    var getToolbar = function getToolbar() {
      var row = [];
      if (options.showTodayButton) {
        row.push($('<td>').append($('<a>').attr({
          'data-action': 'today',
          'title': options.tooltips.today
        }).append($('<span>').addClass(options.icons.today))));
      }
      if (!options.sideBySide && hasDate() && hasTime()) {
        row.push($('<td>').append($('<a>').attr({
          'data-action': 'togglePicker',
          'title': options.tooltips.selectTime
        }).append($('<span>').addClass(options.icons.time))));
      }
      if (options.showClear) {
        row.push($('<td>').append($('<a>').attr({
          'data-action': 'clear',
          'title': options.tooltips.clear
        }).append($('<span>').addClass(options.icons.clear))));
      }
      if (options.showClose) {
        row.push($('<td>').append($('<a>').attr({
          'data-action': 'close',
          'title': options.tooltips.close
        }).append($('<span>').addClass(options.icons.close))));
      }
      return $('<table>').addClass('table-condensed').append($('<tbody>').append($('<tr>').append(row)));
    };
    var getTemplate = function getTemplate() {
      var template = $('<div>').addClass('bootstrap-datetimepicker-widget dropdown-menu');
      var dateView = $('<div>').addClass('datepicker').append(getDatePickerTemplate());
      var timeView = $('<div>').addClass('timepicker').append(getTimePickerTemplate());
      var content = $('<ul>').addClass('list-unstyled');
      var toolbar = $('<li>').addClass('picker-switch' + (options.collapse ? ' accordion-toggle' : '')).append(getToolbar());
      if (options.inline) {
        template.removeClass('dropdown-menu');
      }
      if (use24Hours) {
        template.addClass('usetwentyfour');
      }
      if (isEnabled('s') && !use24Hours) {
        template.addClass('wider');
      }
      if (options.sideBySide && hasDate() && hasTime()) {
        template.addClass('timepicker-sbs');
        if (options.toolbarPlacement === 'top') {
          template.append(toolbar);
        }
        template.append($('<div>').addClass('row').append(dateView.addClass('col-md-6')).append(timeView.addClass('col-md-6')));
        if (options.toolbarPlacement === 'bottom') {
          template.append(toolbar);
        }
        return template;
      }
      if (options.toolbarPlacement === 'top') {
        content.append(toolbar);
      }
      if (hasDate()) {
        content.append($('<li>').addClass(options.collapse && hasTime() ? 'collapse in' : '').append(dateView));
      }
      if (options.toolbarPlacement === 'default') {
        content.append(toolbar);
      }
      if (hasTime()) {
        content.append($('<li>').addClass(options.collapse && hasDate() ? 'collapse' : '').append(timeView));
      }
      if (options.toolbarPlacement === 'bottom') {
        content.append(toolbar);
      }
      return template.append(content);
    };
    var dataToOptions = function dataToOptions() {
      var eData;
      var dataOptions = {};
      if (element.is('input') || options.inline) {
        eData = element.data();
      } else {
        eData = element.find('input').data();
      }
      if (eData.dateOptions && eData.dateOptions instanceof Object) {
        dataOptions = $.extend(true, dataOptions, eData.dateOptions);
      }
      $.each(options, function (key) {
        var attributeName = 'date' + key.charAt(0).toUpperCase() + key.slice(1);
        if (eData[attributeName] !== undefined) {
          dataOptions[key] = eData[attributeName];
        }
      });
      return dataOptions;
    };
    var place = function place() {
      var position = (component || element).position();
      var offset = (component || element).offset();
      var vertical = options.widgetPositioning.vertical;
      var horizontal = options.widgetPositioning.horizontal;
      var parent;
      if (options.widgetParent) {
        parent = options.widgetParent.append(widget);
      } else if (element.is('input')) {
        parent = element.after(widget).parent();
      } else if (options.inline) {
        parent = element.append(widget);
        return;
      } else {
        parent = element;
        element.children().first().after(widget);
      }

      // Top and bottom logic
      if (vertical === 'auto') {
        if (offset.top + widget.height() * 1.5 >= $(window).height() + $(window).scrollTop() && widget.height() + element.outerHeight() < offset.top) {
          vertical = 'top';
        } else {
          vertical = 'bottom';
        }
      }

      // Left and right logic
      if (horizontal === 'auto') {
        if (parent.width() < offset.left + widget.outerWidth() / 2 && offset.left + widget.outerWidth() > $(window).width()) {
          horizontal = 'right';
        } else {
          horizontal = 'left';
        }
      }
      if (vertical === 'top') {
        widget.addClass('top').removeClass('bottom');
      } else {
        widget.addClass('bottom').removeClass('top');
      }
      if (horizontal === 'right') {
        widget.addClass('pull-right');
      } else {
        widget.removeClass('pull-right');
      }

      // find the first parent element that has a non-static css positioning
      if (parent.css('position') === 'static') {
        parent = parent.parents().filter(function () {
          return $(this).css('position') !== 'static';
        }).first();
      }
      if (parent.length === 0) {
        throw new Error('datetimepicker component should be placed within a non-static positioned container');
      }
      widget.css({
        top: vertical === 'top' ? 'auto' : position.top + element.outerHeight(),
        bottom: vertical === 'top' ? parent.outerHeight() - (parent === element ? 0 : position.top) : 'auto',
        left: horizontal === 'left' ? parent === element ? 0 : position.left : 'auto',
        right: horizontal === 'left' ? 'auto' : parent.outerWidth() - element.outerWidth() - (parent === element ? 0 : position.left)
      });
    };
    var notifyEvent = function notifyEvent(e) {
      if (e.type === 'dp.change' && (e.date && e.date.isSame(e.oldDate) || !e.date && !e.oldDate)) {
        return;
      }
      element.trigger(e);
    };
    var viewUpdate = function viewUpdate(e) {
      if (e === 'y') {
        e = 'YYYY';
      }
      notifyEvent({
        type: 'dp.update',
        change: e,
        viewDate: viewDate.clone()
      });
    };
    var showMode = function showMode(dir) {
      if (!widget) {
        return;
      }
      if (dir) {
        currentViewMode = Math.max(minViewModeNumber, Math.min(3, currentViewMode + dir));
      }
      widget.find('.datepicker > div').hide().filter('.datepicker-' + datePickerModes[currentViewMode].clsName).show();
    };
    var fillDow = function fillDow() {
      var row = $('<tr>');
      var currentDate = viewDate.clone().startOf('w').startOf('d');
      if (options.calendarWeeks === true) {
        row.append($('<th>').addClass('cw').text('#'));
      }
      while (currentDate.isBefore(viewDate.clone().endOf('w'))) {
        row.append($('<th>').addClass('dow').text(currentDate.format('dd')));
        currentDate.add(1, 'd');
      }
      widget.find('.datepicker-days thead').append(row);
    };
    var isInDisabledDates = function isInDisabledDates(testDate) {
      return options.disabledDates[testDate.format('YYYY-MM-DD')] === true;
    };
    var isInEnabledDates = function isInEnabledDates(testDate) {
      return options.enabledDates[testDate.format('YYYY-MM-DD')] === true;
    };
    var isInDisabledHours = function isInDisabledHours(testDate) {
      return options.disabledHours[testDate.format('H')] === true;
    };
    var isInEnabledHours = function isInEnabledHours(testDate) {
      return options.enabledHours[testDate.format('H')] === true;
    };
    var isValid = function isValid(targetMoment, granularity) {
      if (!targetMoment.isValid()) {
        return false;
      }
      if (options.disabledDates && granularity === 'd' && isInDisabledDates(targetMoment)) {
        return false;
      }
      if (options.enabledDates && granularity === 'd' && !isInEnabledDates(targetMoment)) {
        return false;
      }
      if (options.minDate && targetMoment.isBefore(options.minDate, granularity)) {
        return false;
      }
      if (options.maxDate && targetMoment.isAfter(options.maxDate, granularity)) {
        return false;
      }
      if (options.daysOfWeekDisabled && granularity === 'd' && options.daysOfWeekDisabled.indexOf(targetMoment.day()) !== -1) {
        return false;
      }
      if (options.disabledHours && (granularity === 'h' || granularity === 'm' || granularity === 's') && isInDisabledHours(targetMoment)) {
        return false;
      }
      if (options.enabledHours && (granularity === 'h' || granularity === 'm' || granularity === 's') && !isInEnabledHours(targetMoment)) {
        return false;
      }
      if (options.disabledTimeIntervals && (granularity === 'h' || granularity === 'm' || granularity === 's')) {
        var found = false;
        $.each(options.disabledTimeIntervals, function () {
          if (targetMoment.isBetween(this[0], this[1])) {
            found = true;
            return false;
          }
        });
        if (found) {
          return false;
        }
      }
      return true;
    };
    var fillMonths = function fillMonths() {
      var spans = [];
      var monthsShort = viewDate.clone().startOf('y').startOf('d');
      while (monthsShort.isSame(viewDate, 'y')) {
        spans.push($('<span>').attr('data-action', 'selectMonth').addClass('month').text(monthsShort.format('MMM')));
        monthsShort.add(1, 'M');
      }
      widget.find('.datepicker-months td').empty().append(spans);
    };
    var updateMonths = function updateMonths() {
      var monthsView = widget.find('.datepicker-months');
      var monthsViewHeader = monthsView.find('th');
      var months = monthsView.find('tbody').find('span');
      monthsViewHeader.eq(0).find('span').attr('title', options.tooltips.prevYear);
      monthsViewHeader.eq(1).attr('title', options.tooltips.selectYear);
      monthsViewHeader.eq(2).find('span').attr('title', options.tooltips.nextYear);
      monthsView.find('.disabled').removeClass('disabled');
      if (!isValid(viewDate.clone().subtract(1, 'y'), 'y')) {
        monthsViewHeader.eq(0).addClass('disabled');
      }
      monthsViewHeader.eq(1).text(viewDate.year());
      if (!isValid(viewDate.clone().add(1, 'y'), 'y')) {
        monthsViewHeader.eq(2).addClass('disabled');
      }
      months.removeClass('active');
      if (date.isSame(viewDate, 'y') && !unset) {
        months.eq(date.month()).addClass('active');
      }
      months.each(function (index) {
        if (!isValid(viewDate.clone().month(index), 'M')) {
          $(this).addClass('disabled');
        }
      });
    };
    var updateYears = function updateYears() {
      var yearsView = widget.find('.datepicker-years');
      var yearsViewHeader = yearsView.find('th');
      var startYear = viewDate.clone().subtract(5, 'y');
      var endYear = viewDate.clone().add(6, 'y');
      var html = '';
      yearsViewHeader.eq(0).find('span').attr('title', options.tooltips.prevDecade);
      yearsViewHeader.eq(1).attr('title', options.tooltips.selectDecade);
      yearsViewHeader.eq(2).find('span').attr('title', options.tooltips.nextDecade);
      yearsView.find('.disabled').removeClass('disabled');
      if (options.minDate && options.minDate.isAfter(startYear, 'y')) {
        yearsViewHeader.eq(0).addClass('disabled');
      }
      yearsViewHeader.eq(1).text(startYear.year() + '-' + endYear.year());
      if (options.maxDate && options.maxDate.isBefore(endYear, 'y')) {
        yearsViewHeader.eq(2).addClass('disabled');
      }
      while (!startYear.isAfter(endYear, 'y')) {
        html += '<span data-action="selectYear" class="year' + (startYear.isSame(date, 'y') && !unset ? ' active' : '') + (!isValid(startYear, 'y') ? ' disabled' : '') + '">' + startYear.year() + '</span>';
        startYear.add(1, 'y');
      }
      yearsView.find('td').html(html);
    };
    var updateDecades = function updateDecades() {
      var decadesView = widget.find('.datepicker-decades');
      var decadesViewHeader = decadesView.find('th');
      var startDecade = moment({
        y: viewDate.year() - viewDate.year() % 100 - 1
      });
      var endDecade = startDecade.clone().add(100, 'y');
      var startedAt = startDecade.clone();
      var minDateDecade = false;
      var maxDateDecade = false;
      var endDecadeYear;
      var html = '';
      decadesViewHeader.eq(0).find('span').attr('title', options.tooltips.prevCentury);
      decadesViewHeader.eq(2).find('span').attr('title', options.tooltips.nextCentury);
      decadesView.find('.disabled').removeClass('disabled');
      if (startDecade.isSame(moment({
        y: 1900
      })) || options.minDate && options.minDate.isAfter(startDecade, 'y')) {
        decadesViewHeader.eq(0).addClass('disabled');
      }
      decadesViewHeader.eq(1).text(startDecade.year() + '-' + endDecade.year());
      if (startDecade.isSame(moment({
        y: 2000
      })) || options.maxDate && options.maxDate.isBefore(endDecade, 'y')) {
        decadesViewHeader.eq(2).addClass('disabled');
      }
      while (!startDecade.isAfter(endDecade, 'y')) {
        endDecadeYear = startDecade.year() + 12;
        minDateDecade = options.minDate && options.minDate.isAfter(startDecade, 'y') && options.minDate.year() <= endDecadeYear;
        maxDateDecade = options.maxDate && options.maxDate.isAfter(startDecade, 'y') && options.maxDate.year() <= endDecadeYear;
        html += '<span data-action="selectDecade" class="decade' + (date.isAfter(startDecade) && date.year() <= endDecadeYear ? ' active' : '') + (!isValid(startDecade, 'y') && !minDateDecade && !maxDateDecade ? ' disabled' : '') + '" data-selection="' + (startDecade.year() + 6) + '">' + (startDecade.year() + 1) + ' - ' + (startDecade.year() + 12) + '</span>';
        startDecade.add(12, 'y');
      }
      html += '<span></span><span></span><span></span>'; // push the dangling block over, at least this way it's even

      decadesView.find('td').html(html);
      decadesViewHeader.eq(1).text(startedAt.year() + 1 + '-' + startDecade.year());
    };
    var fillDate = function fillDate() {
      var daysView = widget.find('.datepicker-days');
      var daysViewHeader = daysView.find('th');
      var currentDate;
      var html = [];
      var row;
      var clsNames = [];
      var i;
      if (!hasDate()) {
        return;
      }
      daysViewHeader.eq(0).find('span').attr('title', options.tooltips.prevMonth);
      daysViewHeader.eq(1).attr('title', options.tooltips.selectMonth);
      daysViewHeader.eq(2).find('span').attr('title', options.tooltips.nextMonth);
      daysView.find('.disabled').removeClass('disabled');
      daysViewHeader.eq(1).text(viewDate.format(options.dayViewHeaderFormat));
      if (!isValid(viewDate.clone().subtract(1, 'M'), 'M')) {
        daysViewHeader.eq(0).addClass('disabled');
      }
      if (!isValid(viewDate.clone().add(1, 'M'), 'M')) {
        daysViewHeader.eq(2).addClass('disabled');
      }
      currentDate = viewDate.clone().startOf('M').startOf('w').startOf('d');
      for (i = 0; i < 42; i++) {
        // always display 42 days (should show 6 weeks)
        if (currentDate.weekday() === 0) {
          row = $('<tr>');
          if (options.calendarWeeks) {
            row.append('<td class="cw">' + currentDate.week() + '</td>');
          }
          html.push(row);
        }
        clsNames = ['day'];
        if (currentDate.isBefore(viewDate, 'M')) {
          clsNames.push('old');
        }
        if (currentDate.isAfter(viewDate, 'M')) {
          clsNames.push('new');
        }
        if (currentDate.isSame(date, 'd') && !unset) {
          clsNames.push('active');
        }
        if (!isValid(currentDate, 'd')) {
          clsNames.push('disabled');
        }
        if (currentDate.isSame(getMoment(), 'd')) {
          clsNames.push('today');
        }
        if (currentDate.day() === 0 || currentDate.day() === 6) {
          clsNames.push('weekend');
        }
        notifyEvent({
          type: 'dp.classify',
          date: currentDate,
          classNames: clsNames
        });
        row.append('<td data-action="selectDay" data-day="' + currentDate.format('L') + '" class="' + clsNames.join(' ') + '">' + currentDate.date() + '</td>');
        currentDate.add(1, 'd');
      }
      daysView.find('tbody').empty().append(html);
      updateMonths();
      updateYears();
      updateDecades();
    };
    var fillHours = function fillHours() {
      var table = widget.find('.timepicker-hours table');
      var currentHour = viewDate.clone().startOf('d');
      var html = [];
      var row = $('<tr>');
      if (viewDate.hour() > 11 && !use24Hours) {
        currentHour.hour(12);
      }
      while (currentHour.isSame(viewDate, 'd') && (use24Hours || viewDate.hour() < 12 && currentHour.hour() < 12 || viewDate.hour() > 11)) {
        if (currentHour.hour() % 4 === 0) {
          row = $('<tr>');
          html.push(row);
        }
        row.append('<td data-action="selectHour" class="hour' + (!isValid(currentHour, 'h') ? ' disabled' : '') + '">' + currentHour.format(use24Hours ? 'HH' : 'hh') + '</td>');
        currentHour.add(1, 'h');
      }
      table.empty().append(html);
    };
    var fillMinutes = function fillMinutes() {
      var table = widget.find('.timepicker-minutes table');
      var currentMinute = viewDate.clone().startOf('h');
      var html = [];
      var row = $('<tr>');
      var step = options.stepping === 1 ? 5 : options.stepping;
      while (viewDate.isSame(currentMinute, 'h')) {
        if (currentMinute.minute() % (step * 4) === 0) {
          row = $('<tr>');
          html.push(row);
        }
        row.append('<td data-action="selectMinute" class="minute' + (!isValid(currentMinute, 'm') ? ' disabled' : '') + '">' + currentMinute.format('mm') + '</td>');
        currentMinute.add(step, 'm');
      }
      table.empty().append(html);
    };
    var fillSeconds = function fillSeconds() {
      var table = widget.find('.timepicker-seconds table');
      var currentSecond = viewDate.clone().startOf('m');
      var html = [];
      var row = $('<tr>');
      while (viewDate.isSame(currentSecond, 'm')) {
        if (currentSecond.second() % 20 === 0) {
          row = $('<tr>');
          html.push(row);
        }
        row.append('<td data-action="selectSecond" class="second' + (!isValid(currentSecond, 's') ? ' disabled' : '') + '">' + currentSecond.format('ss') + '</td>');
        currentSecond.add(5, 's');
      }
      table.empty().append(html);
    };
    var fillTime = function fillTime() {
      var toggle;
      var newDate;
      var timeComponents = widget.find('.timepicker span[data-time-component]');
      if (!use24Hours) {
        toggle = widget.find('.timepicker [data-action=togglePeriod]');
        newDate = date.clone().add(date.hours() >= 12 ? -12 : 12, 'h');
        toggle.text(date.format('A'));
        if (isValid(newDate, 'h')) {
          toggle.removeClass('disabled');
        } else {
          toggle.addClass('disabled');
        }
      }
      timeComponents.filter('[data-time-component=hours]').text(date.format(use24Hours ? 'HH' : 'hh'));
      timeComponents.filter('[data-time-component=minutes]').text(date.format('mm'));
      timeComponents.filter('[data-time-component=seconds]').text(date.format('ss'));
      fillHours();
      fillMinutes();
      fillSeconds();
    };
    var update = function update() {
      if (!widget) {
        return;
      }
      fillDate();
      fillTime();
    };
    var setValue = function setValue(targetMoment) {
      var oldDate = unset ? null : date;

      // case of calling setValue(null or false)
      if (!targetMoment) {
        unset = true;
        input.val('');
        element.data('date', '');
        notifyEvent({
          type: 'dp.change',
          date: false,
          oldDate: oldDate
        });
        update();
        return;
      }
      targetMoment = targetMoment.clone().locale(options.locale);
      if (hasTimeZone()) {
        targetMoment.tz(options.timeZone);
      }
      if (options.stepping !== 1) {
        targetMoment.minutes(Math.round(targetMoment.minutes() / options.stepping) * options.stepping).seconds(0);
        while (options.minDate && targetMoment.isBefore(options.minDate)) {
          targetMoment.add(options.stepping, 'minutes');
        }
      }
      if (isValid(targetMoment)) {
        date = targetMoment;
        viewDate = date.clone();
        input.val(date.format(actualFormat));
        element.data('date', date.format(actualFormat));
        unset = false;
        update();
        notifyEvent({
          type: 'dp.change',
          date: date.clone(),
          oldDate: oldDate
        });
      } else {
        if (!options.keepInvalid) {
          input.val(unset ? '' : date.format(actualFormat));
        } else {
          notifyEvent({
            type: 'dp.change',
            date: targetMoment,
            oldDate: oldDate
          });
        }
        notifyEvent({
          type: 'dp.error',
          date: targetMoment,
          oldDate: oldDate
        });
      }
    };

    /**
         * Hides the widget. Possibly will emit dp.hide
         */
    var hide = function hide() {
      var transitioning = false;
      if (!widget) {
        return picker;
      }
      // Ignore event if in the middle of a picker transition
      widget.find('.collapse').each(function () {
        var collapseData = $(this).data('collapse');
        if (collapseData && collapseData.transitioning) {
          transitioning = true;
          return false;
        }
        return true;
      });
      if (transitioning) {
        return picker;
      }
      if (component && component.hasClass('btn')) {
        component.toggleClass('active');
      }
      widget.hide();
      $(window).off('resize', place);
      widget.off('click', '[data-action]');
      widget.off('mousedown', false);
      widget.remove();
      widget = false;
      notifyEvent({
        type: 'dp.hide',
        date: date.clone()
      });
      input.blur();
      viewDate = date.clone();
      return picker;
    };
    var clear = function clear() {
      setValue(null);
    };
    var parseInputDate = function parseInputDate(inputDate) {
      if (options.parseInputDate === undefined) {
        if (!moment.isMoment(inputDate) || inputDate instanceof Date) {
          inputDate = getMoment(inputDate);
        }
      } else {
        inputDate = options.parseInputDate(inputDate);
      }
      // inputDate.locale(options.locale);
      return inputDate;
    };

    /** ******************************************************************************
         *
         * Widget UI interaction functions
         *
         ********************************************************************************/
    var actions = {
      next: function next() {
        var navFnc = datePickerModes[currentViewMode].navFnc;
        viewDate.add(datePickerModes[currentViewMode].navStep, navFnc);
        fillDate();
        viewUpdate(navFnc);
      },
      previous: function previous() {
        var navFnc = datePickerModes[currentViewMode].navFnc;
        viewDate.subtract(datePickerModes[currentViewMode].navStep, navFnc);
        fillDate();
        viewUpdate(navFnc);
      },
      pickerSwitch: function pickerSwitch() {
        showMode(1);
      },
      selectMonth: function selectMonth(e) {
        var month = $(e.target).closest('tbody').find('span').index($(e.target));
        viewDate.month(month);
        if (currentViewMode === minViewModeNumber) {
          setValue(date.clone().year(viewDate.year()).month(viewDate.month()));
          if (!options.inline) {
            hide();
          }
        } else {
          showMode(-1);
          fillDate();
        }
        viewUpdate('M');
      },
      selectYear: function selectYear(e) {
        var year = parseInt($(e.target).text(), 10) || 0;
        viewDate.year(year);
        if (currentViewMode === minViewModeNumber) {
          setValue(date.clone().year(viewDate.year()));
          if (!options.inline) {
            hide();
          }
        } else {
          showMode(-1);
          fillDate();
        }
        viewUpdate('YYYY');
      },
      selectDecade: function selectDecade(e) {
        var year = parseInt($(e.target).data('selection'), 10) || 0;
        viewDate.year(year);
        if (currentViewMode === minViewModeNumber) {
          setValue(date.clone().year(viewDate.year()));
          if (!options.inline) {
            hide();
          }
        } else {
          showMode(-1);
          fillDate();
        }
        viewUpdate('YYYY');
      },
      selectDay: function selectDay(e) {
        var day = viewDate.clone();
        if ($(e.target).is('.old')) {
          day.subtract(1, 'M');
        }
        if ($(e.target).is('.new')) {
          day.add(1, 'M');
        }
        setValue(day.date(parseInt($(e.target).text(), 10)));
        if (!hasTime() && !options.keepOpen && !options.inline) {
          hide();
        }
      },
      incrementHours: function incrementHours() {
        var newDate = date.clone().add(1, 'h');
        if (isValid(newDate, 'h')) {
          setValue(newDate);
        }
      },
      incrementMinutes: function incrementMinutes() {
        var newDate = date.clone().add(options.stepping, 'm');
        if (isValid(newDate, 'm')) {
          setValue(newDate);
        }
      },
      incrementSeconds: function incrementSeconds() {
        var newDate = date.clone().add(1, 's');
        if (isValid(newDate, 's')) {
          setValue(newDate);
        }
      },
      decrementHours: function decrementHours() {
        var newDate = date.clone().subtract(1, 'h');
        if (isValid(newDate, 'h')) {
          setValue(newDate);
        }
      },
      decrementMinutes: function decrementMinutes() {
        var newDate = date.clone().subtract(options.stepping, 'm');
        if (isValid(newDate, 'm')) {
          setValue(newDate);
        }
      },
      decrementSeconds: function decrementSeconds() {
        var newDate = date.clone().subtract(1, 's');
        if (isValid(newDate, 's')) {
          setValue(newDate);
        }
      },
      togglePeriod: function togglePeriod() {
        setValue(date.clone().add(date.hours() >= 12 ? -12 : 12, 'h'));
      },
      togglePicker: function togglePicker(e) {
        var $this = $(e.target);
        var $parent = $this.closest('ul');
        var expanded = $parent.find('.in');
        var closed = $parent.find('.collapse:not(.in)');
        var collapseData;
        if (expanded && expanded.length) {
          collapseData = expanded.data('collapse');
          if (collapseData && collapseData.transitioning) {
            return;
          }
          if (expanded.collapse) {
            // if collapse plugin is available through bootstrap.js then use it
            expanded.collapse('hide');
            closed.collapse('show');
          } else {
            // otherwise just toggle in class on the two views
            expanded.removeClass('in');
            closed.addClass('in');
          }
          if ($this.is('span')) {
            $this.toggleClass(options.icons.time + ' ' + options.icons.date);
          } else {
            $this.find('span').toggleClass(options.icons.time + ' ' + options.icons.date);
          }

          // NOTE: uncomment if toggled state will be restored in show()
          // if (component) {
          //    component.find('span').toggleClass(options.icons.time + ' ' + options.icons.date);
          // }
        }
      },
      showPicker: function showPicker() {
        widget.find('.timepicker > div:not(.timepicker-picker)').hide();
        widget.find('.timepicker .timepicker-picker').show();
      },
      showHours: function showHours() {
        widget.find('.timepicker .timepicker-picker').hide();
        widget.find('.timepicker .timepicker-hours').show();
      },
      showMinutes: function showMinutes() {
        widget.find('.timepicker .timepicker-picker').hide();
        widget.find('.timepicker .timepicker-minutes').show();
      },
      showSeconds: function showSeconds() {
        widget.find('.timepicker .timepicker-picker').hide();
        widget.find('.timepicker .timepicker-seconds').show();
      },
      selectHour: function selectHour(e) {
        var hour = parseInt($(e.target).text(), 10);
        if (!use24Hours) {
          if (date.hours() >= 12) {
            if (hour !== 12) {
              hour += 12;
            }
          } else {
            if (hour === 12) {
              hour = 0;
            }
          }
        }
        setValue(date.clone().hours(hour));
        actions.showPicker.call(picker);
      },
      selectMinute: function selectMinute(e) {
        setValue(date.clone().minutes(parseInt($(e.target).text(), 10)));
        actions.showPicker.call(picker);
      },
      selectSecond: function selectSecond(e) {
        setValue(date.clone().seconds(parseInt($(e.target).text(), 10)));
        actions.showPicker.call(picker);
      },
      clear: clear,
      today: function today() {
        var todaysDate = getMoment();
        if (isValid(todaysDate, 'd')) {
          setValue(todaysDate);
        }
      },
      close: hide
    };
    var doAction = function doAction(e) {
      if ($(e.currentTarget).is('.disabled')) {
        return false;
      }
      actions[$(e.currentTarget).data('action')].apply(picker, arguments);
      return false;
    };

    /**
         * Shows the widget. Possibly will emit dp.show and dp.change
         */
    var show = function show() {
      var currentMoment;
      var useCurrentGranularity = {
        'year': function year(m) {
          return m.month(0).date(1).hours(0).seconds(0).minutes(0);
        },
        'month': function month(m) {
          return m.date(1).hours(0).seconds(0).minutes(0);
        },
        'day': function day(m) {
          return m.hours(0).seconds(0).minutes(0);
        },
        'hour': function hour(m) {
          return m.seconds(0).minutes(0);
        },
        'minute': function minute(m) {
          return m.seconds(0);
        }
      };
      if (input.prop('disabled') || !options.ignoreReadonly && input.prop('readonly') || widget) {
        return picker;
      }
      if (input.val() !== undefined && input.val().trim().length !== 0) {
        setValue(parseInputDate(input.val().trim()));
      } else if (unset && options.useCurrent && (options.inline || input.is('input') && input.val().trim().length === 0)) {
        currentMoment = getMoment();
        if (typeof options.useCurrent === 'string') {
          currentMoment = useCurrentGranularity[options.useCurrent](currentMoment);
        }
        setValue(currentMoment);
      }
      widget = getTemplate();
      fillDow();
      fillMonths();
      widget.find('.timepicker-hours').hide();
      widget.find('.timepicker-minutes').hide();
      widget.find('.timepicker-seconds').hide();
      update();
      showMode();
      $(window).on('resize', place);
      widget.on('click', '[data-action]', doAction); // this handles clicks on the widget
      widget.on('mousedown', false);
      if (component && component.hasClass('btn')) {
        component.toggleClass('active');
      }
      place();
      widget.show();
      if (options.focusOnShow && !input.is(':focus')) {
        input.focus();
      }
      notifyEvent({
        type: 'dp.show'
      });
      return picker;
    };

    /**
         * Shows or hides the widget
         */
    var toggle = function toggle() {
      return widget ? hide() : show();
    };
    var keydown = function keydown(e) {
      var handler = null;
      var index;
      var index2;
      var pressedKeys = [];
      var pressedModifiers = {};
      var currentKey = e.which;
      var keyBindKeys;
      var allModifiersPressed;
      var pressed = 'p';
      keyState[currentKey] = pressed;
      for (index in keyState) {
        if (keyState.hasOwnProperty(index) && keyState[index] === pressed) {
          pressedKeys.push(index);
          if (parseInt(index, 10) !== currentKey) {
            pressedModifiers[index] = true;
          }
        }
      }
      for (index in options.keyBinds) {
        if (options.keyBinds.hasOwnProperty(index) && typeof options.keyBinds[index] === 'function') {
          keyBindKeys = index.split(' ');
          if (keyBindKeys.length === pressedKeys.length && keyMap[currentKey] === keyBindKeys[keyBindKeys.length - 1]) {
            allModifiersPressed = true;
            for (index2 = keyBindKeys.length - 2; index2 >= 0; index2--) {
              if (!(keyMap[keyBindKeys[index2]] in pressedModifiers)) {
                allModifiersPressed = false;
                break;
              }
            }
            if (allModifiersPressed) {
              handler = options.keyBinds[index];
              break;
            }
          }
        }
      }
      if (handler) {
        handler.call(picker, widget);
        e.stopPropagation();
        e.preventDefault();
      }
    };
    var keyup = function keyup(e) {
      keyState[e.which] = 'r';
      e.stopPropagation();
      e.preventDefault();
    };
    var change = function change(e) {
      var val = $(e.target).val().trim();
      var parsedDate = val ? parseInputDate(val) : null;
      setValue(parsedDate);
      e.stopImmediatePropagation();
      return false;
    };
    var attachDatePickerElementEvents = function attachDatePickerElementEvents() {
      input.on({
        'change': change,
        'blur': options.debug ? '' : hide,
        'keydown': keydown,
        'keyup': keyup,
        'focus': options.allowInputToggle ? show : ''
      });
      if (element.is('input')) {
        input.on({
          'focus': show
        });
      } else if (component) {
        component.on('click', toggle);
        component.on('mousedown', false);
      }
    };
    var detachDatePickerElementEvents = function detachDatePickerElementEvents() {
      input.off({
        'change': change,
        'blur': blur,
        'keydown': keydown,
        'keyup': keyup,
        'focus': options.allowInputToggle ? hide : ''
      });
      if (element.is('input')) {
        input.off({
          'focus': show
        });
      } else if (component) {
        component.off('click', toggle);
        component.off('mousedown', false);
      }
    };
    var indexGivenDates = function indexGivenDates(givenDatesArray) {
      // Store given enabledDates and disabledDates as keys.
      // This way we can check their existence in O(1) time instead of looping through whole array.
      // (for example: options.enabledDates['2014-02-27'] === true)
      var givenDatesIndexed = {};
      $.each(givenDatesArray, function () {
        var dDate = parseInputDate(this);
        if (dDate.isValid()) {
          givenDatesIndexed[dDate.format('YYYY-MM-DD')] = true;
        }
      });
      return Object.keys(givenDatesIndexed).length ? givenDatesIndexed : false;
    };
    var indexGivenHours = function indexGivenHours(givenHoursArray) {
      // Store given enabledHours and disabledHours as keys.
      // This way we can check their existence in O(1) time instead of looping through whole array.
      // (for example: options.enabledHours['2014-02-27'] === true)
      var givenHoursIndexed = {};
      $.each(givenHoursArray, function () {
        givenHoursIndexed[this] = true;
      });
      return Object.keys(givenHoursIndexed).length ? givenHoursIndexed : false;
    };
    var initFormatting = function initFormatting() {
      var format = options.format || 'L LT';
      actualFormat = format.replace(/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g, function (formatInput) {
        var newinput = date.localeData().longDateFormat(formatInput) || formatInput;
        return newinput.replace(/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g, function (formatInput2) {
          // temp fix for #740
          return date.localeData().longDateFormat(formatInput2) || formatInput2;
        });
      });
      parseFormats = options.extraFormats ? options.extraFormats.slice() : [];
      if (parseFormats.indexOf(format) < 0 && parseFormats.indexOf(actualFormat) < 0) {
        parseFormats.push(actualFormat);
      }
      use24Hours = actualFormat.toLowerCase().indexOf('a') < 1 && actualFormat.replace(/\[.*?\]/g, '').indexOf('h') < 1;
      if (isEnabled('y')) {
        minViewModeNumber = 2;
      }
      if (isEnabled('M')) {
        minViewModeNumber = 1;
      }
      if (isEnabled('d')) {
        minViewModeNumber = 0;
      }
      currentViewMode = Math.max(minViewModeNumber, currentViewMode);
      if (!unset) {
        setValue(date);
      }
    };

    /** ******************************************************************************
     *
     * Public API functions
     * =====================
     *
     * Important: Do not expose direct references to private objects or the options
     * object to the outer world. Always return a clone when returning values or make
     * a clone when setting a private variable.
     *
     ********************************************************************************/
    picker.destroy = function () {
      // /<summary>Destroys the widget and removes all attached event listeners</summary>
      hide();
      detachDatePickerElementEvents();
      element.removeData('DateTimePicker');
      element.removeData('date');
    };
    picker.toggle = toggle;
    picker.show = show;
    picker.hide = hide;
    picker.disable = function () {
      // /<summary>Disables the input element, the component is attached to, by adding a disabled="true" attribute to it.
      // /If the widget was visible before that call it is hidden. Possibly emits dp.hide</summary>
      hide();
      if (component && component.hasClass('btn')) {
        component.addClass('disabled');
      }
      input.prop('disabled', true);
      return picker;
    };
    picker.enable = function () {
      // /<summary>Enables the input element, the component is attached to, by removing disabled attribute from it.</summary>
      if (component && component.hasClass('btn')) {
        component.removeClass('disabled');
      }
      input.prop('disabled', false);
      return picker;
    };
    picker.ignoreReadonly = function (ignoreReadonly) {
      if (arguments.length === 0) {
        return options.ignoreReadonly;
      }
      if (typeof ignoreReadonly !== 'boolean') {
        throw new TypeError('ignoreReadonly () expects a boolean parameter');
      }
      options.ignoreReadonly = ignoreReadonly;
      return picker;
    };
    picker.options = function (newOptions) {
      if (arguments.length === 0) {
        return $.extend(true, {}, options);
      }
      if (!(newOptions instanceof Object)) {
        throw new TypeError('options() options parameter should be an object');
      }
      $.extend(true, options, newOptions);
      $.each(options, function (key, value) {
        if (picker[key] !== undefined) {
          picker[key](value);
        } else {
          throw new TypeError('option ' + key + ' is not recognized!');
        }
      });
      return picker;
    };
    picker.date = function (newDate) {
      // /<signature helpKeyword="$.fn.datetimepicker.date">
      // /<summary>Returns the component's model current date, a moment object or null if not set.</summary>
      // /<returns type="Moment">date.clone()</returns>
      // /</signature>
      // /<signature>
      // /<summary>Sets the components model current moment to it. Passing a null value unsets the components model current moment. Parsing of the newDate parameter is made using moment library with the options.format and options.useStrict components configuration.</summary>
      // /<param name="newDate" locid="$.fn.datetimepicker.date_p:newDate">Takes string, Date, moment, null parameter.</param>
      // /</signature>
      if (arguments.length === 0) {
        if (unset) {
          return null;
        }
        return date.clone();
      }
      if (newDate !== null && typeof newDate !== 'string' && !moment.isMoment(newDate) && !(newDate instanceof Date)) {
        throw new TypeError('date() parameter must be one of [null, string, moment or Date]');
      }
      setValue(newDate === null ? null : parseInputDate(newDate));
      return picker;
    };
    picker.format = function (newFormat) {
      // /<summary>test su</summary>
      // /<param name="newFormat">info about para</param>
      // /<returns type="string|boolean">returns foo</returns>
      if (arguments.length === 0) {
        return options.format;
      }
      if (typeof newFormat !== 'string' && (typeof newFormat !== 'boolean' || newFormat !== false)) {
        throw new TypeError('format() expects a string or boolean:false parameter ' + newFormat);
      }
      options.format = newFormat;
      if (actualFormat) {
        initFormatting(); // reinit formatting
      }
      return picker;
    };
    picker.timeZone = function (newZone) {
      if (arguments.length === 0) {
        return options.timeZone;
      }
      if (typeof newZone !== 'string') {
        throw new TypeError('newZone() expects a string parameter');
      }
      options.timeZone = newZone;
      return picker;
    };
    picker.dayViewHeaderFormat = function (newFormat) {
      if (arguments.length === 0) {
        return options.dayViewHeaderFormat;
      }
      if (typeof newFormat !== 'string') {
        throw new TypeError('dayViewHeaderFormat() expects a string parameter');
      }
      options.dayViewHeaderFormat = newFormat;
      return picker;
    };
    picker.extraFormats = function (formats) {
      if (arguments.length === 0) {
        return options.extraFormats;
      }
      if (formats !== false && !(formats instanceof Array)) {
        throw new TypeError('extraFormats() expects an array or false parameter');
      }
      options.extraFormats = formats;
      if (parseFormats) {
        initFormatting(); // reinit formatting
      }
      return picker;
    };
    picker.disabledDates = function (dates) {
      // /<signature helpKeyword="$.fn.datetimepicker.disabledDates">
      // /<summary>Returns an array with the currently set disabled dates on the component.</summary>
      // /<returns type="array">options.disabledDates</returns>
      // /</signature>
      // /<signature>
      // /<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of
      // /options.enabledDates if such exist.</summary>
      // /<param name="dates" locid="$.fn.datetimepicker.disabledDates_p:dates">Takes an [ string or Date or moment ] of values and allows the user to select only from those days.</param>
      // /</signature>
      if (arguments.length === 0) {
        return options.disabledDates ? $.extend({}, options.disabledDates) : options.disabledDates;
      }
      if (!dates) {
        options.disabledDates = false;
        update();
        return picker;
      }
      if (!(dates instanceof Array)) {
        throw new TypeError('disabledDates() expects an array parameter');
      }
      options.disabledDates = indexGivenDates(dates);
      options.enabledDates = false;
      update();
      return picker;
    };
    picker.enabledDates = function (dates) {
      // /<signature helpKeyword="$.fn.datetimepicker.enabledDates">
      // /<summary>Returns an array with the currently set enabled dates on the component.</summary>
      // /<returns type="array">options.enabledDates</returns>
      // /</signature>
      // /<signature>
      // /<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of options.disabledDates if such exist.</summary>
      // /<param name="dates" locid="$.fn.datetimepicker.enabledDates_p:dates">Takes an [ string or Date or moment ] of values and allows the user to select only from those days.</param>
      // /</signature>
      if (arguments.length === 0) {
        return options.enabledDates ? $.extend({}, options.enabledDates) : options.enabledDates;
      }
      if (!dates) {
        options.enabledDates = false;
        update();
        return picker;
      }
      if (!(dates instanceof Array)) {
        throw new TypeError('enabledDates() expects an array parameter');
      }
      options.enabledDates = indexGivenDates(dates);
      options.disabledDates = false;
      update();
      return picker;
    };
    picker.daysOfWeekDisabled = function (daysOfWeekDisabled) {
      if (arguments.length === 0) {
        return options.daysOfWeekDisabled.splice(0);
      }
      if (typeof daysOfWeekDisabled === 'boolean' && !daysOfWeekDisabled) {
        options.daysOfWeekDisabled = false;
        update();
        return picker;
      }
      if (!(daysOfWeekDisabled instanceof Array)) {
        throw new TypeError('daysOfWeekDisabled() expects an array parameter');
      }
      options.daysOfWeekDisabled = daysOfWeekDisabled.reduce(function (previousValue, currentValue) {
        currentValue = parseInt(currentValue, 10);
        if (currentValue > 6 || currentValue < 0 || isNaN(currentValue)) {
          return previousValue;
        }
        if (previousValue.indexOf(currentValue) === -1) {
          previousValue.push(currentValue);
        }
        return previousValue;
      }, []).sort();
      if (options.useCurrent && !options.keepInvalid) {
        var tries = 0;
        while (!isValid(date, 'd')) {
          date.add(1, 'd');
          if (tries === 31) {
            throw new Error('Tried 31 times to find a valid date');
          }
          tries++;
        }
        setValue(date);
      }
      update();
      return picker;
    };
    picker.maxDate = function (maxDate) {
      if (arguments.length === 0) {
        return options.maxDate ? options.maxDate.clone() : options.maxDate;
      }
      if (typeof maxDate === 'boolean' && maxDate === false) {
        options.maxDate = false;
        update();
        return picker;
      }
      if (typeof maxDate === 'string') {
        if (maxDate === 'now' || maxDate === 'moment') {
          maxDate = getMoment();
        }
      }
      var parsedDate = parseInputDate(maxDate);
      if (!parsedDate.isValid()) {
        throw new TypeError('maxDate() Could not parse date parameter: ' + maxDate);
      }
      if (options.minDate && parsedDate.isBefore(options.minDate)) {
        throw new TypeError('maxDate() date parameter is before options.minDate: ' + parsedDate.format(actualFormat));
      }
      options.maxDate = parsedDate;
      if (options.useCurrent && !options.keepInvalid && date.isAfter(maxDate)) {
        setValue(options.maxDate);
      }
      if (viewDate.isAfter(parsedDate)) {
        viewDate = parsedDate.clone().subtract(options.stepping, 'm');
      }
      update();
      return picker;
    };
    picker.minDate = function (minDate) {
      if (arguments.length === 0) {
        return options.minDate ? options.minDate.clone() : options.minDate;
      }
      if (typeof minDate === 'boolean' && minDate === false) {
        options.minDate = false;
        update();
        return picker;
      }
      if (typeof minDate === 'string') {
        if (minDate === 'now' || minDate === 'moment') {
          minDate = getMoment();
        }
      }
      var parsedDate = parseInputDate(minDate);
      if (!parsedDate.isValid()) {
        throw new TypeError('minDate() Could not parse date parameter: ' + minDate);
      }
      if (options.maxDate && parsedDate.isAfter(options.maxDate)) {
        throw new TypeError('minDate() date parameter is after options.maxDate: ' + parsedDate.format(actualFormat));
      }
      options.minDate = parsedDate;
      if (options.useCurrent && !options.keepInvalid && date.isBefore(minDate)) {
        setValue(options.minDate);
      }
      if (viewDate.isBefore(parsedDate)) {
        viewDate = parsedDate.clone().add(options.stepping, 'm');
      }
      update();
      return picker;
    };
    picker.defaultDate = function (defaultDate) {
      // /<signature helpKeyword="$.fn.datetimepicker.defaultDate">
      // /<summary>Returns a moment with the options.defaultDate option configuration or false if not set</summary>
      // /<returns type="Moment">date.clone()</returns>
      // /</signature>
      // /<signature>
      // /<summary>Will set the picker's inital date. If a boolean:false value is passed the options.defaultDate parameter is cleared.</summary>
      // /<param name="defaultDate" locid="$.fn.datetimepicker.defaultDate_p:defaultDate">Takes a string, Date, moment, boolean:false</param>
      // /</signature>
      if (arguments.length === 0) {
        return options.defaultDate ? options.defaultDate.clone() : options.defaultDate;
      }
      if (!defaultDate) {
        options.defaultDate = false;
        return picker;
      }
      if (typeof defaultDate === 'string') {
        if (defaultDate === 'now' || defaultDate === 'moment') {
          defaultDate = getMoment();
        } else {
          defaultDate = getMoment(defaultDate);
        }
      }
      var parsedDate = parseInputDate(defaultDate);
      if (!parsedDate.isValid()) {
        throw new TypeError('defaultDate() Could not parse date parameter: ' + defaultDate);
      }
      if (!isValid(parsedDate)) {
        throw new TypeError('defaultDate() date passed is invalid according to component setup validations');
      }
      options.defaultDate = parsedDate;
      if (options.defaultDate && options.inline || input.val().trim() === '') {
        setValue(options.defaultDate);
      }
      return picker;
    };
    picker.locale = function (locale) {
      if (arguments.length === 0) {
        return options.locale;
      }
      if (!moment.localeData(locale)) {
        throw new TypeError('locale() locale ' + locale + ' is not loaded from moment locales!');
      }
      options.locale = locale;
      date.locale(options.locale);
      viewDate.locale(options.locale);
      if (actualFormat) {
        initFormatting(); // reinit formatting
      }
      if (widget) {
        hide();
        show();
      }
      return picker;
    };
    picker.stepping = function (stepping) {
      if (arguments.length === 0) {
        return options.stepping;
      }
      stepping = parseInt(stepping, 10);
      if (isNaN(stepping) || stepping < 1) {
        stepping = 1;
      }
      options.stepping = stepping;
      return picker;
    };
    picker.useCurrent = function (useCurrent) {
      var useCurrentOptions = ['year', 'month', 'day', 'hour', 'minute'];
      if (arguments.length === 0) {
        return options.useCurrent;
      }
      if (typeof useCurrent !== 'boolean' && typeof useCurrent !== 'string') {
        throw new TypeError('useCurrent() expects a boolean or string parameter');
      }
      if (typeof useCurrent === 'string' && useCurrentOptions.indexOf(useCurrent.toLowerCase()) === -1) {
        throw new TypeError('useCurrent() expects a string parameter of ' + useCurrentOptions.join(', '));
      }
      options.useCurrent = useCurrent;
      return picker;
    };
    picker.collapse = function (collapse) {
      if (arguments.length === 0) {
        return options.collapse;
      }
      if (typeof collapse !== 'boolean') {
        throw new TypeError('collapse() expects a boolean parameter');
      }
      if (options.collapse === collapse) {
        return picker;
      }
      options.collapse = collapse;
      if (widget) {
        hide();
        show();
      }
      return picker;
    };
    picker.icons = function (icons) {
      if (arguments.length === 0) {
        return $.extend({}, options.icons);
      }
      if (!(icons instanceof Object)) {
        throw new TypeError('icons() expects parameter to be an Object');
      }
      $.extend(options.icons, icons);
      if (widget) {
        hide();
        show();
      }
      return picker;
    };
    picker.tooltips = function (tooltips) {
      if (arguments.length === 0) {
        return $.extend({}, options.tooltips);
      }
      if (!(tooltips instanceof Object)) {
        throw new TypeError('tooltips() expects parameter to be an Object');
      }
      $.extend(options.tooltips, tooltips);
      if (widget) {
        hide();
        show();
      }
      return picker;
    };
    picker.useStrict = function (useStrict) {
      if (arguments.length === 0) {
        return options.useStrict;
      }
      if (typeof useStrict !== 'boolean') {
        throw new TypeError('useStrict() expects a boolean parameter');
      }
      options.useStrict = useStrict;
      return picker;
    };
    picker.sideBySide = function (sideBySide) {
      if (arguments.length === 0) {
        return options.sideBySide;
      }
      if (typeof sideBySide !== 'boolean') {
        throw new TypeError('sideBySide() expects a boolean parameter');
      }
      options.sideBySide = sideBySide;
      if (widget) {
        hide();
        show();
      }
      return picker;
    };
    picker.viewMode = function (viewMode) {
      if (arguments.length === 0) {
        return options.viewMode;
      }
      if (typeof viewMode !== 'string') {
        throw new TypeError('viewMode() expects a string parameter');
      }
      if (viewModes.indexOf(viewMode) === -1) {
        throw new TypeError('viewMode() parameter must be one of (' + viewModes.join(', ') + ') value');
      }
      options.viewMode = viewMode;
      currentViewMode = Math.max(viewModes.indexOf(viewMode), minViewModeNumber);
      showMode();
      return picker;
    };
    picker.toolbarPlacement = function (toolbarPlacement) {
      if (arguments.length === 0) {
        return options.toolbarPlacement;
      }
      if (typeof toolbarPlacement !== 'string') {
        throw new TypeError('toolbarPlacement() expects a string parameter');
      }
      if (toolbarPlacements.indexOf(toolbarPlacement) === -1) {
        throw new TypeError('toolbarPlacement() parameter must be one of (' + toolbarPlacements.join(', ') + ') value');
      }
      options.toolbarPlacement = toolbarPlacement;
      if (widget) {
        hide();
        show();
      }
      return picker;
    };
    picker.widgetPositioning = function (widgetPositioning) {
      if (arguments.length === 0) {
        return $.extend({}, options.widgetPositioning);
      }
      if ({}.toString.call(widgetPositioning) !== '[object Object]') {
        throw new TypeError('widgetPositioning() expects an object variable');
      }
      if (widgetPositioning.horizontal) {
        if (typeof widgetPositioning.horizontal !== 'string') {
          throw new TypeError('widgetPositioning() horizontal variable must be a string');
        }
        widgetPositioning.horizontal = widgetPositioning.horizontal.toLowerCase();
        if (horizontalModes.indexOf(widgetPositioning.horizontal) === -1) {
          throw new TypeError('widgetPositioning() expects horizontal parameter to be one of (' + horizontalModes.join(', ') + ')');
        }
        options.widgetPositioning.horizontal = widgetPositioning.horizontal;
      }
      if (widgetPositioning.vertical) {
        if (typeof widgetPositioning.vertical !== 'string') {
          throw new TypeError('widgetPositioning() vertical variable must be a string');
        }
        widgetPositioning.vertical = widgetPositioning.vertical.toLowerCase();
        if (verticalModes.indexOf(widgetPositioning.vertical) === -1) {
          throw new TypeError('widgetPositioning() expects vertical parameter to be one of (' + verticalModes.join(', ') + ')');
        }
        options.widgetPositioning.vertical = widgetPositioning.vertical;
      }
      update();
      return picker;
    };
    picker.calendarWeeks = function (calendarWeeks) {
      if (arguments.length === 0) {
        return options.calendarWeeks;
      }
      if (typeof calendarWeeks !== 'boolean') {
        throw new TypeError('calendarWeeks() expects parameter to be a boolean value');
      }
      options.calendarWeeks = calendarWeeks;
      update();
      return picker;
    };
    picker.showTodayButton = function (showTodayButton) {
      if (arguments.length === 0) {
        return options.showTodayButton;
      }
      if (typeof showTodayButton !== 'boolean') {
        throw new TypeError('showTodayButton() expects a boolean parameter');
      }
      options.showTodayButton = showTodayButton;
      if (widget) {
        hide();
        show();
      }
      return picker;
    };
    picker.showClear = function (showClear) {
      if (arguments.length === 0) {
        return options.showClear;
      }
      if (typeof showClear !== 'boolean') {
        throw new TypeError('showClear() expects a boolean parameter');
      }
      options.showClear = showClear;
      if (widget) {
        hide();
        show();
      }
      return picker;
    };
    picker.widgetParent = function (widgetParent) {
      if (arguments.length === 0) {
        return options.widgetParent;
      }
      if (typeof widgetParent === 'string') {
        widgetParent = $(widgetParent);
      }
      if (widgetParent !== null && typeof widgetParent !== 'string' && !(widgetParent instanceof $)) {
        throw new TypeError('widgetParent() expects a string or a jQuery object parameter');
      }
      options.widgetParent = widgetParent;
      if (widget) {
        hide();
        show();
      }
      return picker;
    };
    picker.keepOpen = function (keepOpen) {
      if (arguments.length === 0) {
        return options.keepOpen;
      }
      if (typeof keepOpen !== 'boolean') {
        throw new TypeError('keepOpen() expects a boolean parameter');
      }
      options.keepOpen = keepOpen;
      return picker;
    };
    picker.focusOnShow = function (focusOnShow) {
      if (arguments.length === 0) {
        return options.focusOnShow;
      }
      if (typeof focusOnShow !== 'boolean') {
        throw new TypeError('focusOnShow() expects a boolean parameter');
      }
      options.focusOnShow = focusOnShow;
      return picker;
    };
    picker.inline = function (inline) {
      if (arguments.length === 0) {
        return options.inline;
      }
      if (typeof inline !== 'boolean') {
        throw new TypeError('inline() expects a boolean parameter');
      }
      options.inline = inline;
      return picker;
    };
    picker.clear = function () {
      clear();
      return picker;
    };
    picker.keyBinds = function (keyBinds) {
      if (arguments.length === 0) {
        return options.keyBinds;
      }
      options.keyBinds = keyBinds;
      return picker;
    };
    picker.getMoment = function (d) {
      return getMoment(d);
    };
    picker.debug = function (debug) {
      if (typeof debug !== 'boolean') {
        throw new TypeError('debug() expects a boolean parameter');
      }
      options.debug = debug;
      return picker;
    };
    picker.allowInputToggle = function (allowInputToggle) {
      if (arguments.length === 0) {
        return options.allowInputToggle;
      }
      if (typeof allowInputToggle !== 'boolean') {
        throw new TypeError('allowInputToggle() expects a boolean parameter');
      }
      options.allowInputToggle = allowInputToggle;
      return picker;
    };
    picker.showClose = function (showClose) {
      if (arguments.length === 0) {
        return options.showClose;
      }
      if (typeof showClose !== 'boolean') {
        throw new TypeError('showClose() expects a boolean parameter');
      }
      options.showClose = showClose;
      return picker;
    };
    picker.keepInvalid = function (keepInvalid) {
      if (arguments.length === 0) {
        return options.keepInvalid;
      }
      if (typeof keepInvalid !== 'boolean') {
        throw new TypeError('keepInvalid() expects a boolean parameter');
      }
      options.keepInvalid = keepInvalid;
      return picker;
    };
    picker.datepickerInput = function (datepickerInput) {
      if (arguments.length === 0) {
        return options.datepickerInput;
      }
      if (typeof datepickerInput !== 'string') {
        throw new TypeError('datepickerInput() expects a string parameter');
      }
      options.datepickerInput = datepickerInput;
      return picker;
    };
    picker.parseInputDate = function (parseInputDate) {
      if (arguments.length === 0) {
        return options.parseInputDate;
      }
      if (typeof parseInputDate !== 'function') {
        throw new TypeError('parseInputDate() sholud be as function');
      }
      options.parseInputDate = parseInputDate;
      return picker;
    };
    picker.disabledTimeIntervals = function (disabledTimeIntervals) {
      // /<signature helpKeyword="$.fn.datetimepicker.disabledTimeIntervals">
      // /<summary>Returns an array with the currently set disabled dates on the component.</summary>
      // /<returns type="array">options.disabledTimeIntervals</returns>
      // /</signature>
      // /<signature>
      // /<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of
      // /options.enabledDates if such exist.</summary>
      // /<param name="dates" locid="$.fn.datetimepicker.disabledTimeIntervals_p:dates">Takes an [ string or Date or moment ] of values and allows the user to select only from those days.</param>
      // /</signature>
      if (arguments.length === 0) {
        return options.disabledTimeIntervals ? $.extend({}, options.disabledTimeIntervals) : options.disabledTimeIntervals;
      }
      if (!disabledTimeIntervals) {
        options.disabledTimeIntervals = false;
        update();
        return picker;
      }
      if (!(disabledTimeIntervals instanceof Array)) {
        throw new TypeError('disabledTimeIntervals() expects an array parameter');
      }
      options.disabledTimeIntervals = disabledTimeIntervals;
      update();
      return picker;
    };
    picker.disabledHours = function (hours) {
      // /<signature helpKeyword="$.fn.datetimepicker.disabledHours">
      // /<summary>Returns an array with the currently set disabled hours on the component.</summary>
      // /<returns type="array">options.disabledHours</returns>
      // /</signature>
      // /<signature>
      // /<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of
      // /options.enabledHours if such exist.</summary>
      // /<param name="hours" locid="$.fn.datetimepicker.disabledHours_p:hours">Takes an [ int ] of values and disallows the user to select only from those hours.</param>
      // /</signature>
      if (arguments.length === 0) {
        return options.disabledHours ? $.extend({}, options.disabledHours) : options.disabledHours;
      }
      if (!hours) {
        options.disabledHours = false;
        update();
        return picker;
      }
      if (!(hours instanceof Array)) {
        throw new TypeError('disabledHours() expects an array parameter');
      }
      options.disabledHours = indexGivenHours(hours);
      options.enabledHours = false;
      if (options.useCurrent && !options.keepInvalid) {
        var tries = 0;
        while (!isValid(date, 'h')) {
          date.add(1, 'h');
          if (tries === 24) {
            throw new Error('Tried 24 times to find a valid date');
          }
          tries++;
        }
        setValue(date);
      }
      update();
      return picker;
    };
    picker.enabledHours = function (hours) {
      // /<signature helpKeyword="$.fn.datetimepicker.enabledHours">
      // /<summary>Returns an array with the currently set enabled hours on the component.</summary>
      // /<returns type="array">options.enabledHours</returns>
      // /</signature>
      // /<signature>
      // /<summary>Setting this takes precedence over options.minDate, options.maxDate configuration. Also calling this function removes the configuration of options.disabledHours if such exist.</summary>
      // /<param name="hours" locid="$.fn.datetimepicker.enabledHours_p:hours">Takes an [ int ] of values and allows the user to select only from those hours.</param>
      // /</signature>
      if (arguments.length === 0) {
        return options.enabledHours ? $.extend({}, options.enabledHours) : options.enabledHours;
      }
      if (!hours) {
        options.enabledHours = false;
        update();
        return picker;
      }
      if (!(hours instanceof Array)) {
        throw new TypeError('enabledHours() expects an array parameter');
      }
      options.enabledHours = indexGivenHours(hours);
      options.disabledHours = false;
      if (options.useCurrent && !options.keepInvalid) {
        var tries = 0;
        while (!isValid(date, 'h')) {
          date.add(1, 'h');
          if (tries === 24) {
            throw new Error('Tried 24 times to find a valid date');
          }
          tries++;
        }
        setValue(date);
      }
      update();
      return picker;
    };
    /**
     * Returns the component's model current viewDate, a moment object or null if not set. Passing a null value unsets the components model current moment. Parsing of the newDate parameter is made using moment library with the options.format and options.useStrict components configuration.
     * @param {Takes string, viewDate, moment, null parameter.} newDate
     * @returns {viewDate.clone()}
     */
    picker.viewDate = function (newDate) {
      if (arguments.length === 0) {
        return viewDate.clone();
      }
      if (!newDate) {
        viewDate = date.clone();
        return picker;
      }
      if (typeof newDate !== 'string' && !moment.isMoment(newDate) && !(newDate instanceof Date)) {
        throw new TypeError('viewDate() parameter must be one of [string, moment or Date]');
      }
      viewDate = parseInputDate(newDate);
      viewUpdate();
      return picker;
    };

    // initializing element and component attributes
    if (element.is('input')) {
      input = element;
    } else {
      input = element.find(options.datepickerInput);
      if (input.length === 0) {
        input = element.find('input');
      } else if (!input.is('input')) {
        throw new Error('CSS class "' + options.datepickerInput + '" cannot be applied to non input element');
      }
    }
    if (element.hasClass('input-group')) {
      // in case there is more then one 'input-group-addon' Issue #48
      if (element.find('.datepickerbutton').length === 0) {
        component = element.find('.input-group-addon');
      } else {
        component = element.find('.datepickerbutton');
      }
    }
    if (!options.inline && !input.is('input')) {
      throw new Error('Could not initialize DateTimePicker without an input element');
    }

    // Set defaults for date here now instead of in var declaration
    date = getMoment();
    viewDate = date.clone();
    $.extend(true, options, dataToOptions());
    picker.options(options);
    initFormatting();
    attachDatePickerElementEvents();
    if (input.prop('disabled')) {
      picker.disable();
    }
    if (input.is('input') && input.val().trim().length !== 0) {
      setValue(parseInputDate(input.val().trim()));
    } else if (options.defaultDate && input.attr('placeholder') === undefined) {
      setValue(options.defaultDate);
    }
    if (options.inline) {
      show();
    }
    return picker;
  };

  /** ******************************************************************************
   *
   * jQuery plugin constructor and defaults object
   *
   ********************************************************************************/

  /**
   * See (http://jquery.com/).
   * @name jQuery
   * @class
   * See the jQuery Library  (http://jquery.com/) for full details.  This just
   * documents the function and classes that are added to jQuery by this plug-in.
   */
  /**
   * See (http://jquery.com/)
   * @name fn
   * @class
   * See the jQuery Library  (http://jquery.com/) for full details.  This just
   * documents the function and classes that are added to jQuery by this plug-in.
   * @memberOf jQuery
   */
  /**
   * Show comments
   * @class datetimepicker
   * @memberOf jQuery.fn
   */
  $.fn.datetimepicker = function (options) {
    options = options || {};
    var args = Array.prototype.slice.call(arguments, 1);
    var isInstance = true;
    var thisMethods = ['destroy', 'hide', 'show', 'toggle'];
    var returnValue;
    if (_typeof(options) === 'object') {
      return this.each(function () {
        var $this = $(this);
        var _options;
        if (!$this.data('DateTimePicker')) {
          // create a private copy of the defaults object
          _options = $.extend(true, {}, $.fn.datetimepicker.defaults, options);
          $this.data('DateTimePicker', dateTimePicker($this, _options));
        }
      });
    } else if (typeof options === 'string') {
      this.each(function () {
        var $this = $(this);
        var instance = $this.data('DateTimePicker');
        if (!instance) {
          throw new Error('bootstrap-datetimepicker("' + options + '") method was called on an element that is not using DateTimePicker');
        }
        returnValue = instance[options].apply(instance, args);
        isInstance = returnValue === instance;
      });
      if (isInstance || $.inArray(options, thisMethods) > -1) {
        return this;
      }
      return returnValue;
    }
    throw new TypeError('Invalid arguments for DateTimePicker: ' + options);
  };
  $.fn.datetimepicker.defaults = {
    timeZone: '',
    format: false,
    dayViewHeaderFormat: 'MMMM YYYY',
    extraFormats: false,
    stepping: 1,
    minDate: false,
    maxDate: false,
    useCurrent: true,
    collapse: true,
    locale: moment.locale(),
    defaultDate: false,
    disabledDates: false,
    enabledDates: false,
    icons: {
      time: 'glyphicon glyphicon-time',
      date: 'glyphicon glyphicon-calendar',
      up: 'glyphicon glyphicon-chevron-up',
      down: 'glyphicon glyphicon-chevron-down',
      previous: 'glyphicon glyphicon-chevron-left',
      next: 'glyphicon glyphicon-chevron-right',
      today: 'glyphicon glyphicon-screenshot',
      clear: 'glyphicon glyphicon-trash',
      close: 'glyphicon glyphicon-remove'
    },
    tooltips: {
      today: 'Go to today',
      clear: 'Clear selection',
      close: 'Close the picker',
      selectMonth: 'Select Month',
      prevMonth: 'Previous Month',
      nextMonth: 'Next Month',
      selectYear: 'Select Year',
      prevYear: 'Previous Year',
      nextYear: 'Next Year',
      selectDecade: 'Select Decade',
      prevDecade: 'Previous Decade',
      nextDecade: 'Next Decade',
      prevCentury: 'Previous Century',
      nextCentury: 'Next Century',
      pickHour: 'Pick Hour',
      incrementHour: 'Increment Hour',
      decrementHour: 'Decrement Hour',
      pickMinute: 'Pick Minute',
      incrementMinute: 'Increment Minute',
      decrementMinute: 'Decrement Minute',
      pickSecond: 'Pick Second',
      incrementSecond: 'Increment Second',
      decrementSecond: 'Decrement Second',
      togglePeriod: 'Toggle Period',
      selectTime: 'Select Time'
    },
    useStrict: false,
    sideBySide: false,
    daysOfWeekDisabled: false,
    calendarWeeks: false,
    viewMode: 'days',
    toolbarPlacement: 'default',
    showTodayButton: false,
    showClear: false,
    showClose: false,
    widgetPositioning: {
      horizontal: 'auto',
      vertical: 'auto'
    },
    widgetParent: null,
    ignoreReadonly: false,
    keepOpen: false,
    focusOnShow: true,
    inline: false,
    keepInvalid: false,
    datepickerInput: '.datepickerinput',
    keyBinds: {
      up: function up(widget) {
        if (!widget) {
          return;
        }
        var d = this.date() || this.getMoment();
        if (widget.find('.datepicker').is(':visible')) {
          this.date(d.clone().subtract(7, 'd'));
        } else {
          this.date(d.clone().add(this.stepping(), 'm'));
        }
      },
      down: function down(widget) {
        if (!widget) {
          this.show();
          return;
        }
        var d = this.date() || this.getMoment();
        if (widget.find('.datepicker').is(':visible')) {
          this.date(d.clone().add(7, 'd'));
        } else {
          this.date(d.clone().subtract(this.stepping(), 'm'));
        }
      },
      'control up': function controlUp(widget) {
        if (!widget) {
          return;
        }
        var d = this.date() || this.getMoment();
        if (widget.find('.datepicker').is(':visible')) {
          this.date(d.clone().subtract(1, 'y'));
        } else {
          this.date(d.clone().add(1, 'h'));
        }
      },
      'control down': function controlDown(widget) {
        if (!widget) {
          return;
        }
        var d = this.date() || this.getMoment();
        if (widget.find('.datepicker').is(':visible')) {
          this.date(d.clone().add(1, 'y'));
        } else {
          this.date(d.clone().subtract(1, 'h'));
        }
      },
      left: function left(widget) {
        if (!widget) {
          return;
        }
        var d = this.date() || this.getMoment();
        if (widget.find('.datepicker').is(':visible')) {
          this.date(d.clone().subtract(1, 'd'));
        }
      },
      right: function right(widget) {
        if (!widget) {
          return;
        }
        var d = this.date() || this.getMoment();
        if (widget.find('.datepicker').is(':visible')) {
          this.date(d.clone().add(1, 'd'));
        }
      },
      pageUp: function pageUp(widget) {
        if (!widget) {
          return;
        }
        var d = this.date() || this.getMoment();
        if (widget.find('.datepicker').is(':visible')) {
          this.date(d.clone().subtract(1, 'M'));
        }
      },
      pageDown: function pageDown(widget) {
        if (!widget) {
          return;
        }
        var d = this.date() || this.getMoment();
        if (widget.find('.datepicker').is(':visible')) {
          this.date(d.clone().add(1, 'M'));
        }
      },
      enter: function enter() {
        this.hide();
      },
      escape: function escape() {
        this.hide();
      },
      // tab: function (widget) { //this break the flow of the form. disabling for now
      //    var toggle = widget.find('.picker-switch a[data-action="togglePicker"]');
      //    if(toggle.length > 0) toggle.click();
      // },
      'control space': function controlSpace(widget) {
        if (!widget) {
          return;
        }
        if (widget.find('.timepicker').is(':visible')) {
          widget.find('.btn[data-action="togglePeriod"]').click();
        }
      },
      t: function t() {
        this.date(this.getMoment());
      },
      'delete': function _delete() {
        this.clear();
      }
    },
    debug: false,
    allowInputToggle: false,
    disabledTimeIntervals: false,
    disabledHours: false,
    enabledHours: false,
    viewDate: false
  };
  return $.fn.datetimepicker;
});

/***/ }),

/***/ 95851:
/***/ (() => {

// localStorage
(function () {
  function isSupported() {
    var item = 'localStoragePollyfill';
    try {
      localStorage.setItem(item, item);
      localStorage.removeItem(item);
      sessionStorage.setItem(item, item);
      sessionStorage.removeItem(item);
      return true;
    } catch (e) {
      return false;
    }
  }
  if (!isSupported()) {
    try {
      Storage.prototype._data = {};
      Storage.prototype.setItem = function (id, val) {
        this._data[id] = String(val);
        return this._data[id];
      };
      Storage.prototype.getItem = function (id) {
        return this._data.hasOwnProperty(id) ? this._data[id] : undefined;
      };
      Storage.prototype.removeItem = function (id) {
        return delete this._data[id];
      };
      Storage.prototype.clear = function () {
        this._data = {};
        return this._data;
      };
    } catch (e) {
      console.error('localStorage pollyfill error: ', e);
    }
  }
})();

/***/ }),

/***/ 35358:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var map = {
	"./af": 25177,
	"./af.js": 25177,
	"./ar": 61509,
	"./ar-dz": 41488,
	"./ar-dz.js": 41488,
	"./ar-kw": 58676,
	"./ar-kw.js": 58676,
	"./ar-ly": 42353,
	"./ar-ly.js": 42353,
	"./ar-ma": 24496,
	"./ar-ma.js": 24496,
	"./ar-sa": 82682,
	"./ar-sa.js": 82682,
	"./ar-tn": 89756,
	"./ar-tn.js": 89756,
	"./ar.js": 61509,
	"./az": 95533,
	"./az.js": 95533,
	"./be": 28959,
	"./be.js": 28959,
	"./bg": 47777,
	"./bg.js": 47777,
	"./bm": 54903,
	"./bm.js": 54903,
	"./bn": 61290,
	"./bn-bd": 17357,
	"./bn-bd.js": 17357,
	"./bn.js": 61290,
	"./bo": 31545,
	"./bo.js": 31545,
	"./br": 11470,
	"./br.js": 11470,
	"./bs": 44429,
	"./bs.js": 44429,
	"./ca": 7306,
	"./ca.js": 7306,
	"./cs": 56464,
	"./cs.js": 56464,
	"./cv": 73635,
	"./cv.js": 73635,
	"./cy": 64226,
	"./cy.js": 64226,
	"./da": 93601,
	"./da.js": 93601,
	"./de": 77853,
	"./de-at": 26111,
	"./de-at.js": 26111,
	"./de-ch": 54697,
	"./de-ch.js": 54697,
	"./de.js": 77853,
	"./dv": 60708,
	"./dv.js": 60708,
	"./el": 54691,
	"./el.js": 54691,
	"./en-au": 53872,
	"./en-au.js": 53872,
	"./en-ca": 28298,
	"./en-ca.js": 28298,
	"./en-gb": 56195,
	"./en-gb.js": 56195,
	"./en-ie": 66584,
	"./en-ie.js": 66584,
	"./en-il": 65543,
	"./en-il.js": 65543,
	"./en-in": 9033,
	"./en-in.js": 9033,
	"./en-nz": 79402,
	"./en-nz.js": 79402,
	"./en-sg": 43004,
	"./en-sg.js": 43004,
	"./eo": 32934,
	"./eo.js": 32934,
	"./es": 97650,
	"./es-do": 20838,
	"./es-do.js": 20838,
	"./es-mx": 17730,
	"./es-mx.js": 17730,
	"./es-us": 56575,
	"./es-us.js": 56575,
	"./es.js": 97650,
	"./et": 3035,
	"./et.js": 3035,
	"./eu": 3508,
	"./eu.js": 3508,
	"./fa": 119,
	"./fa.js": 119,
	"./fi": 90527,
	"./fi.js": 90527,
	"./fil": 95995,
	"./fil.js": 95995,
	"./fo": 52477,
	"./fo.js": 52477,
	"./fr": 85498,
	"./fr-ca": 26435,
	"./fr-ca.js": 26435,
	"./fr-ch": 37892,
	"./fr-ch.js": 37892,
	"./fr.js": 85498,
	"./fy": 37071,
	"./fy.js": 37071,
	"./ga": 41734,
	"./ga.js": 41734,
	"./gd": 70217,
	"./gd.js": 70217,
	"./gl": 77329,
	"./gl.js": 77329,
	"./gom-deva": 32124,
	"./gom-deva.js": 32124,
	"./gom-latn": 93383,
	"./gom-latn.js": 93383,
	"./gu": 95050,
	"./gu.js": 95050,
	"./he": 11713,
	"./he.js": 11713,
	"./hi": 43861,
	"./hi.js": 43861,
	"./hr": 26308,
	"./hr.js": 26308,
	"./hu": 90609,
	"./hu.js": 90609,
	"./hy-am": 17160,
	"./hy-am.js": 17160,
	"./id": 74063,
	"./id.js": 74063,
	"./is": 89374,
	"./is.js": 89374,
	"./it": 88383,
	"./it-ch": 21827,
	"./it-ch.js": 21827,
	"./it.js": 88383,
	"./ja": 23827,
	"./ja.js": 23827,
	"./jv": 89722,
	"./jv.js": 89722,
	"./ka": 41794,
	"./ka.js": 41794,
	"./kk": 27088,
	"./kk.js": 27088,
	"./km": 96870,
	"./km.js": 96870,
	"./kn": 84451,
	"./kn.js": 84451,
	"./ko": 63164,
	"./ko.js": 63164,
	"./ku": 98174,
	"./ku.js": 98174,
	"./ky": 78474,
	"./ky.js": 78474,
	"./lb": 79680,
	"./lb.js": 79680,
	"./lo": 15867,
	"./lo.js": 15867,
	"./lt": 45766,
	"./lt.js": 45766,
	"./lv": 69532,
	"./lv.js": 69532,
	"./me": 58076,
	"./me.js": 58076,
	"./mi": 41848,
	"./mi.js": 41848,
	"./mk": 30306,
	"./mk.js": 30306,
	"./ml": 73739,
	"./ml.js": 73739,
	"./mn": 99053,
	"./mn.js": 99053,
	"./mr": 86169,
	"./mr.js": 86169,
	"./ms": 73386,
	"./ms-my": 92297,
	"./ms-my.js": 92297,
	"./ms.js": 73386,
	"./mt": 77075,
	"./mt.js": 77075,
	"./my": 72264,
	"./my.js": 72264,
	"./nb": 22274,
	"./nb.js": 22274,
	"./ne": 8235,
	"./ne.js": 8235,
	"./nl": 92572,
	"./nl-be": 43784,
	"./nl-be.js": 43784,
	"./nl.js": 92572,
	"./nn": 54566,
	"./nn.js": 54566,
	"./oc-lnc": 69330,
	"./oc-lnc.js": 69330,
	"./pa-in": 29849,
	"./pa-in.js": 29849,
	"./pl": 94418,
	"./pl.js": 94418,
	"./pt": 79834,
	"./pt-br": 48303,
	"./pt-br.js": 48303,
	"./pt.js": 79834,
	"./ro": 24457,
	"./ro.js": 24457,
	"./ru": 82271,
	"./ru.js": 82271,
	"./sd": 1221,
	"./sd.js": 1221,
	"./se": 33478,
	"./se.js": 33478,
	"./si": 17538,
	"./si.js": 17538,
	"./sk": 5784,
	"./sk.js": 5784,
	"./sl": 46637,
	"./sl.js": 46637,
	"./sq": 86794,
	"./sq.js": 86794,
	"./sr": 45719,
	"./sr-cyrl": 3322,
	"./sr-cyrl.js": 3322,
	"./sr.js": 45719,
	"./ss": 33619,
	"./ss.js": 33619,
	"./sv": 41011,
	"./sv.js": 41011,
	"./sw": 40748,
	"./sw.js": 40748,
	"./ta": 11025,
	"./ta.js": 11025,
	"./te": 11885,
	"./te.js": 11885,
	"./tet": 28861,
	"./tet.js": 28861,
	"./tg": 86571,
	"./tg.js": 86571,
	"./th": 55802,
	"./th.js": 55802,
	"./tk": 59527,
	"./tk.js": 59527,
	"./tl-ph": 29231,
	"./tl-ph.js": 29231,
	"./tlh": 31052,
	"./tlh.js": 31052,
	"./tr": 85096,
	"./tr.js": 85096,
	"./tzl": 79846,
	"./tzl.js": 79846,
	"./tzm": 81765,
	"./tzm-latn": 97711,
	"./tzm-latn.js": 97711,
	"./tzm.js": 81765,
	"./ug-cn": 48414,
	"./ug-cn.js": 48414,
	"./uk": 16618,
	"./uk.js": 16618,
	"./ur": 57777,
	"./ur.js": 57777,
	"./uz": 57609,
	"./uz-latn": 72475,
	"./uz-latn.js": 72475,
	"./uz.js": 57609,
	"./vi": 21135,
	"./vi.js": 21135,
	"./x-pseudo": 64051,
	"./x-pseudo.js": 64051,
	"./yo": 82218,
	"./yo.js": 82218,
	"./zh-cn": 52648,
	"./zh-cn.js": 52648,
	"./zh-hk": 1632,
	"./zh-hk.js": 1632,
	"./zh-mo": 31541,
	"./zh-mo.js": 31541,
	"./zh-tw": 50304,
	"./zh-tw.js": 50304
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	if(!__webpack_require__.o(map, req)) {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return map[req];
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = 35358;

/***/ }),

/***/ 24912:
/***/ ((module) => {

"use strict";
module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAADCAYAAAC09K7GAAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9sJDw4cOCW1/KIAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAAHElEQVQI12NggIL/DAz/GdA5/xkY/qPKMDAwAADLZwf5rvm+LQAAAABJRU5ErkJggg==";

/***/ }),

/***/ 61954:
/***/ ((module) => {

"use strict";
module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAADCAYAAAC09K7GAAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9sJFhQXEbhTg7YAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAAMklEQVQI12NkgIIvJ3QXMjAwdDN+OaEbysDA4MPAwNDNwMCwiOHLCd1zX07o6kBVGQEAKBANtobskNMAAAAASUVORK5CYII=";

/***/ }),

/***/ 75139:
/***/ ((module) => {

"use strict";
module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAHCAMAAADzjKfhAAAACVBMVEUAAAAAAAC/v7914kyHAAAAAXRSTlMAQObYZgAAACNJREFUeNo1ioEJAAAIwmz/H90iFFSGJgFMe3gaLZ0od+9/AQZ0ADosbYraAAAAAElFTkSuQmCC";

/***/ }),

/***/ 3604:
/***/ ((module) => {

"use strict";
module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAHlBMVEW7AAC7AACxAAC7AAC7AAAAAAC4AAC5AAD///+7AAAUdclpAAAABnRSTlMXnORSiwCK0ZKSAAAATUlEQVR42mWPOQ7AQAgDuQLx/z8csYRmPRIFIwRGnosRrpamvkKi0FTIiMASR3hhKW+hAN6/tIWhu9PDWiTGNEkTtIOucA5Oyr9ckPgAWm0GPBog6v4AAAAASUVORK5CYII=";

/***/ }),

/***/ 15980:
/***/ ((module) => {

"use strict";
module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAANlBMVEX/uwDvrwD/uwD/uwD/uwD/uwD/uwD/uwD/uwD6twD/uwAAAADurwD2tQD7uAD+ugAAAAD/uwDhmeTRAAAADHRSTlMJ8mN1EYcbmiixgACm7WbuAAAAVklEQVR42n3PUQqAIBBFUU1LLc3u/jdbOJoW1P08DA9Gba8+YWJ6gNJoNYIBzAA2chBth5kLmG9YUoG0NHAUwFXwO9LuBQL1giCQb8gC9Oro2vp5rncCIY8L8uEx5ZkAAAAASUVORK5CYII=";

/***/ }),

/***/ 41669:
/***/ ((module) => {

"use strict";
module.exports = jQuery;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			id: moduleId,
/******/ 			loaded: false,
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/amd define */
/******/ 	(() => {
/******/ 		__webpack_require__.amdD = function () {
/******/ 			throw new Error('define cannot be used indirect');
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/node module decorator */
/******/ 	(() => {
/******/ 		__webpack_require__.nmd = (module) => {
/******/ 			module.paths = [];
/******/ 			if (!module.children) module.children = [];
/******/ 			return module;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		__webpack_require__.b = document.baseURI || self.location.href;
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			884: 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = self["webpackChunkGrav"] = self["webpackChunkGrav"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/nonce */
/******/ 	(() => {
/******/ 		__webpack_require__.nc = undefined;
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, [121], () => (__webpack_require__(64848)))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	Grav = __webpack_exports__;
/******/ 	
/******/ })()
;