# Changelog

[PyPI History][1]

[1]: https://pypi.org/project/google-cloud-bigquery-datatransfer/#history

## [3.11.0](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.10.1...v3.11.0) (2023-02-28)


### Features

* Enable "rest" transport in Python for services supporting numeric enums ([#439](https://github.com/googleapis/python-bigquery-datatransfer/issues/439)) ([b77f671](https://github.com/googleapis/python-bigquery-datatransfer/commit/b77f6716a47ba5bda4e50919e37b41fbc7cb3e20))


### Documentation

* Minor comment update ([#445](https://github.com/googleapis/python-bigquery-datatransfer/issues/445)) ([27b3271](https://github.com/googleapis/python-bigquery-datatransfer/commit/27b3271682fae002d29c65e057190c01f4f24ed4))

## [3.10.1](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.10.0...v3.10.1) (2023-01-20)


### Bug Fixes

* Add context manager return types ([a10a470](https://github.com/googleapis/python-bigquery-datatransfer/commit/a10a470dc53947e35202c0b296fe74e519c0abe2))


### Documentation

* Add documentation for enums ([a10a470](https://github.com/googleapis/python-bigquery-datatransfer/commit/a10a470dc53947e35202c0b296fe74e519c0abe2))

## [3.10.0](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.9.0...v3.10.0) (2023-01-10)


### Features

* Add support for python 3.11 ([#421](https://github.com/googleapis/python-bigquery-datatransfer/issues/421)) ([d81fe69](https://github.com/googleapis/python-bigquery-datatransfer/commit/d81fe694862b9663e8ffd407c9bad7af6bc4fc01))

## [3.9.0](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.8.0...v3.9.0) (2023-01-04)


### Features

* Add location methods ([#416](https://github.com/googleapis/python-bigquery-datatransfer/issues/416)) ([6538b29](https://github.com/googleapis/python-bigquery-datatransfer/commit/6538b29601e91d16e6a2095a256b4b18920d73b9))

## [3.8.0](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.7.3...v3.8.0) (2022-12-15)


### Features

* Add support for `google.cloud.bigquery_datatransfer.__version__` ([c333464](https://github.com/googleapis/python-bigquery-datatransfer/commit/c3334647fd103e2f10466f1daecde51a89aae727))
* Add typing to proto.Message based class attributes ([c333464](https://github.com/googleapis/python-bigquery-datatransfer/commit/c3334647fd103e2f10466f1daecde51a89aae727))


### Bug Fixes

* Add dict typing for client_options ([c333464](https://github.com/googleapis/python-bigquery-datatransfer/commit/c3334647fd103e2f10466f1daecde51a89aae727))
* **deps:** Require google-api-core &gt;=1.34.0, >=2.11.0  ([20be9ee](https://github.com/googleapis/python-bigquery-datatransfer/commit/20be9ee41126f3c38ef9a6070e7a6fad5a7712d1))
* Drop usage of pkg_resources ([20be9ee](https://github.com/googleapis/python-bigquery-datatransfer/commit/20be9ee41126f3c38ef9a6070e7a6fad5a7712d1))
* Fix timeout default values ([20be9ee](https://github.com/googleapis/python-bigquery-datatransfer/commit/20be9ee41126f3c38ef9a6070e7a6fad5a7712d1))


### Documentation

* **samples:** Snippetgen handling of repeated enum field ([c333464](https://github.com/googleapis/python-bigquery-datatransfer/commit/c3334647fd103e2f10466f1daecde51a89aae727))
* **samples:** Snippetgen should call await on the operation coroutine before calling result ([20be9ee](https://github.com/googleapis/python-bigquery-datatransfer/commit/20be9ee41126f3c38ef9a6070e7a6fad5a7712d1))

## [3.7.3](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.7.2...v3.7.3) (2022-10-07)


### Bug Fixes

* **deps:** Allow protobuf 3.19.5 ([#400](https://github.com/googleapis/python-bigquery-datatransfer/issues/400)) ([5e71c7c](https://github.com/googleapis/python-bigquery-datatransfer/commit/5e71c7c38ee937a4b61dc6a0f1ba79431a7d97b1))

## [3.7.2](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.7.1...v3.7.2) (2022-09-29)


### Bug Fixes

* **deps:** Require protobuf >= 3.20.2 ([#397](https://github.com/googleapis/python-bigquery-datatransfer/issues/397)) ([4b5288d](https://github.com/googleapis/python-bigquery-datatransfer/commit/4b5288df912cfcd7db36012f0a34be9c150a5419))

## [3.7.1](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.7.0...v3.7.1) (2022-08-12)


### Bug Fixes

* **deps:** allow protobuf < 5.0.0 ([#375](https://github.com/googleapis/python-bigquery-datatransfer/issues/375)) ([4bbf741](https://github.com/googleapis/python-bigquery-datatransfer/commit/4bbf741b77c3210e7065daeb0eb56625ae60a488))
* **deps:** require proto-plus >= 1.22.0 ([4bbf741](https://github.com/googleapis/python-bigquery-datatransfer/commit/4bbf741b77c3210e7065daeb0eb56625ae60a488))

## [3.7.0](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.6.2...v3.7.0) (2022-07-16)


### Features

* add audience parameter ([f756c16](https://github.com/googleapis/python-bigquery-datatransfer/commit/f756c16d8bff3246e77d74f03ffc7e95ce9d1e77))


### Bug Fixes

* **deps:** require google-api-core>=1.32.0,>=2.8.0 ([#362](https://github.com/googleapis/python-bigquery-datatransfer/issues/362)) ([f756c16](https://github.com/googleapis/python-bigquery-datatransfer/commit/f756c16d8bff3246e77d74f03ffc7e95ce9d1e77))
* require python 3.7+ ([#364](https://github.com/googleapis/python-bigquery-datatransfer/issues/364)) ([106aa92](https://github.com/googleapis/python-bigquery-datatransfer/commit/106aa926b22f4a5dd64c9e0ecf17317727ab8735))

## [3.6.2](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.6.1...v3.6.2) (2022-06-03)


### Bug Fixes

* **deps:** require protobuf <4.0.0dev ([#349](https://github.com/googleapis/python-bigquery-datatransfer/issues/349)) ([6b03c4b](https://github.com/googleapis/python-bigquery-datatransfer/commit/6b03c4b44b391f4cb9c47cebe40716db66a91ca1))


### Documentation

* fix changelog header to consistent size ([#350](https://github.com/googleapis/python-bigquery-datatransfer/issues/350)) ([c18147a](https://github.com/googleapis/python-bigquery-datatransfer/commit/c18147ab9d3713736ccdf7f327f1913c9be1e994))

## [3.6.1](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.6.0...v3.6.1) (2022-03-05)


### Bug Fixes

* **deps:** require google-api-core>=1.31.5, >=2.3.2 ([#295](https://github.com/googleapis/python-bigquery-datatransfer/issues/295)) ([61d89b1](https://github.com/googleapis/python-bigquery-datatransfer/commit/61d89b10466b6e4792d87b5274c7e8ca8a03f8ab))

## [3.6.0](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.5.0...v3.6.0) (2022-02-14)


### Features

* add api key support ([6bd57bd](https://github.com/googleapis/python-bigquery-datatransfer/commit/6bd57bd2fb0a8fbf8d4507045a1dad5abebb7cbb))
* add owner email to TransferConfig message ([#279](https://github.com/googleapis/python-bigquery-datatransfer/issues/279)) ([6bd57bd](https://github.com/googleapis/python-bigquery-datatransfer/commit/6bd57bd2fb0a8fbf8d4507045a1dad5abebb7cbb))
* allow customer to enroll a datasource programmatically ([6bd57bd](https://github.com/googleapis/python-bigquery-datatransfer/commit/6bd57bd2fb0a8fbf8d4507045a1dad5abebb7cbb))


### Bug Fixes

* resolve DuplicateCredentialArgs error when using credentials_file ([6bd57bd](https://github.com/googleapis/python-bigquery-datatransfer/commit/6bd57bd2fb0a8fbf8d4507045a1dad5abebb7cbb))


### Documentation

* add generated code samples ([#283](https://github.com/googleapis/python-bigquery-datatransfer/issues/283)) ([939d4c3](https://github.com/googleapis/python-bigquery-datatransfer/commit/939d4c3d507a0c38daf6f8568c64f7c44a7dd4f3))
* add generated snippets ([939d4c3](https://github.com/googleapis/python-bigquery-datatransfer/commit/939d4c3d507a0c38daf6f8568c64f7c44a7dd4f3))
* improvements to various message and field descriptions ([6bd57bd](https://github.com/googleapis/python-bigquery-datatransfer/commit/6bd57bd2fb0a8fbf8d4507045a1dad5abebb7cbb))
* preserve hyperlinks with hyphens ([6bd57bd](https://github.com/googleapis/python-bigquery-datatransfer/commit/6bd57bd2fb0a8fbf8d4507045a1dad5abebb7cbb))

## [3.5.0](https://github.com/googleapis/python-bigquery-datatransfer/compare/v3.4.1...v3.5.0) (2022-01-14)


### Features

* add support for Python 3.9 / 3.10 ([#253](https://github.com/googleapis/python-bigquery-datatransfer/issues/253)) ([5e02bd1](https://github.com/googleapis/python-bigquery-datatransfer/commit/5e02bd166149b4ef7ee0f295fdcb6a3570ec2f58))

## [3.4.1](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v3.4.0...v3.4.1) (2021-11-01)


### Bug Fixes

* **deps:** drop packaging dependency ([2a7e0db](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/2a7e0dba3714d1664d9c67518040ccf6b51eda83))
* **deps:** require google-api-core >= 1.28.0 ([2a7e0db](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/2a7e0dba3714d1664d9c67518040ccf6b51eda83))


### Documentation

* list oneofs in docstring ([2a7e0db](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/2a7e0dba3714d1664d9c67518040ccf6b51eda83))

## [3.4.0](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v3.3.4...v3.4.0) (2021-10-08)


### Features

* add context manager support in client ([#234](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/234)) ([cba3dad](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/cba3dad55db8a00f95503b9c94d4ca21ed462a4f))

## [3.3.4](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v3.3.3...v3.3.4) (2021-10-04)


### Bug Fixes

* improper types in pagers generation ([702a848](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/702a84864e5395cf7a7b8f2aeed93d2109414f7c))

## [3.3.3](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v3.3.2...v3.3.3) (2021-09-24)


### Bug Fixes

* add 'dict' annotation type to 'request' ([fe024db](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/fe024dbcc3075fd779358d434f37ec3ee3a0adf9))

## [3.3.2](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v3.3.1...v3.3.2) (2021-08-27)


### Documentation

* Improvements to various message and field descriptions ([#202](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/202)) ([9684723](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/9684723aed8c743d665ccac2b338770dd09fc94a))

## [3.3.1](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v3.3.0...v3.3.1) (2021-07-26)


### Bug Fixes

* **deps:** pin 'google-{api,cloud}-core', 'google-auth' to allow 2.x versions ([#180](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/180)) ([b0e9533](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/b0e953347b43dd2252cf907bfaa8b6fbb16379b6))
* enable self signed jwt for grpc ([#185](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/185)) ([3dd3bdd](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/3dd3bdd9074297803eced776e0ab12491f91da3b))


### Documentation

* add Samples section to CONTRIBUTING.rst ([#181](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/181)) ([5bc909c](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/5bc909c606fdf7cc037e1f014a997272f6284c65))


### Miscellaneous Chores

* release as 3.3.1 ([#186](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/186)) ([7c1a7b9](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/7c1a7b98fcb08dbe081c8c645d079a6586fa7b7b))

## [3.3.0](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v3.2.0...v3.3.0) (2021-07-12)


### Features

* add always_use_jwt_access ([#171](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/171)) ([cd4494f](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/cd4494f0dc7304469e7d4a0ed6e13d716b3cacbf))


### Documentation

* add sample to include run notification ([#173](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/173)) ([ea018c9](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/ea018c9f4a1f9c360dbe9f08650250ea8c505f29))

## [3.2.0](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v3.1.1...v3.2.0) (2021-06-22)


### Features

* support self-signed JWT flow for service accounts ([046c368](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/046c368cf5a75a210b0ecc7e6e1eee9bcd907669))


### Bug Fixes

* add async client to %name_%version/init.py ([046c368](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/046c368cf5a75a210b0ecc7e6e1eee9bcd907669))


### Documentation

* omit mention of Python 2.7 in 'CONTRIBUTING.rst' ([#1127](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/1127)) ([#164](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/164)) ([2741e4f](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/2741e4fb1d9074494872fafcec96d870b14b671d)), closes [#1126](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/1126)

## [3.1.1](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v3.1.0...v3.1.1) (2021-04-07)


### Bug Fixes

* require proto-plus>=1.15.0 ([91910f1](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/91910f1ea01c5324fa63a7d85a034d08aeaae3f9))
* use correct retry deadline ([#121](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/121)) ([91910f1](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/91910f1ea01c5324fa63a7d85a034d08aeaae3f9))

## [3.1.0](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v3.0.1...v3.1.0) (2021-03-22)


### Features

* add `client_cert_source_for_mtls` parameter to grpc transport ([#114](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/114)) ([9c7ed28](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/9c7ed285203cd44917911e78c2c313d3ad50afda))

## [3.0.1](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v3.0.0...v3.0.1) (2021-03-03)


### Bug Fixes

* remove recv msg limit, add enums to `types` ([#84](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/84)) ([3e2bbef](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/3e2bbef292ddda6a736be397be4e5a0fb213eeff))


### Documentation

* add sample for dataset copy ([#76](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/76)) ([f6d2c5b](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/f6d2c5b8f3c75426881dfce90ab713535416950e))
* add scheduled query samples ([#83](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/83)) ([cd51970](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/cd519709228cda3bbcf2fd978d37ccd04ef27c82))
* ensure minimum width for 'Parameters' / 'Returns' column ([#95](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/95)) ([5c8d7c1](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/5c8d7c1e860d1c50d892bfabc7ec936aaa40e714))
* **python:** document adding Python 3.9 support, dropping 3.5 support ([#89](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/89)) ([dd84592](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/dd8459291a3ac0f98606b61ae566cb264ce96825)), closes [#787](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/787)
* remove out-of-date sample from README ([#80](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/80)) ([af0406e](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/af0406eedac1dc8c663b5c8f67f56255caeea2fa))
* remove redundant samples ([#86](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/86)) ([093e407](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/093e407c60b117a00d2cdf8d225f22d61bc221c4))
* update contributing guide to Python 3.8 ([#105](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/105)) ([678c335](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/678c3355e1b2e8525005ad337048d60a51400fc0))

## [3.0.0](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v2.1.0...v3.0.0) (2020-12-09)


### ⚠ BREAKING CHANGES

* type is renamed to type_ to avoid conflict with built-in functions (introduced in googleapis/gapic-generator-python#595)

### Features

* add common resource path helpers ([#69](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/69)) ([e0bcedb](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/e0bcedb58109e38a58584d5b3087f03e1fa10835))


### Bug Fixes

* avoid collision with built-in functions by renaming type property to type_ ([#53](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/53)) ([b954411](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/b95441140f7c86dd3e833aef0532badd6280ef48)), closes [/github.com/googleapis/python-talent/blob/ef045e8eb348db36d7a2a611e6f26b11530d273b/samples/snippets/noxfile_config.py#L27-L32](https://www.github.com/googleapis//github.com/googleapis/python-talent/blob/ef045e8eb348db36d7a2a611e6f26b11530d273b/samples/snippets/noxfile_config.py/issues/L27-L32)


### Documentation

* update intersphinx links ([#78](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/78)) ([a78ba39](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/a78ba39bf1507cbc9e2a51fe4553d602da7f7601))

## 2.1.0

09-29-2020 09:34 PDT


### Implementation Changes

Adjust gapic namespace to `google.cloud.bigquery_datatransfer` ([#61](https://github.com/googleapis/python-bigquery-datatransfer/pull/61))

## 2.0.0

09-21-2020 08:36 PDT


### Implementation Changes

- Transition the library to microgenerator. ([#56](https://github.com/googleapis/python-bigquery-datatransfer/pull/56))
  This is a **breaking change** that introduces several **method signature changes** and **drops support
  for Python 2.7 and 3.5**. See [migration guide](https://googleapis.dev/python/bigquerydatatransfer/latest/UPGRADING.html)
  for more info.

## 1.1.1

09-16-2020 11:12 PDT


### Implementation Changes

- Change default retry policies timeouts (via synth). ([#48](https://github.com/googleapis/python-bigquery-datatransfer/pull/48))


### Documentation

- Add sample for updating transfer config. ([#46](https://github.com/googleapis/python-bigquery-datatransfer/pull/46))
- Add dataset ID in function call in samples. ([#44](https://github.com/googleapis/python-bigquery-datatransfer/pull/44))
- Move code samples from the common samples repo to this library. ([#38](https://github.com/googleapis/python-bigquery-datatransfer/pull/38))


### Internal / Testing Changes

- Update CODEOWNERS for samples and library code. ([#47](https://github.com/googleapis/python-bigquery-datatransfer/pull/47))

## [1.1.0](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v1.0.0...v1.1.0) (2020-06-20)


### Features

* add first party oauth ([#22](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/22)) ([a806b8b](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/a806b8b3d0e3213f1488563f25504a27af9a9cda))

## [1.0.0](https://www.github.com/googleapis/python-bigquery-datatransfer/compare/v0.4.1...v1.0.0) (2020-03-04)


### Features

* **bigquerydatatransfer:** add `service_account_name` option to transfer configs ([#10013](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/10013)) ([9ca090a](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/9ca090af431092bc4286fa4443dd0dc0141f6de6))
* **bigquerydatatransfer:** undeprecate resource name helper methods; add py2 deprecation warning; bump copyright year to 2020 (via synth) ([#10226](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/10226)) ([c0f9cc3](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/c0f9cc398e5558002c79a875809bb6cd1a98a8a4))
* set release_status to production/stable ([#15](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/15)) ([a9c1160](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/a9c1160475dbc327e8cc5da3b5aee3ceaa618bd3))


### Bug Fixes

* **bigquery_datatransfer:** deprecate resource name helper methods (via synth) ([#9829](https://www.github.com/googleapis/python-bigquery-datatransfer/issues/9829)) ([fc06995](https://www.github.com/googleapis/python-bigquery-datatransfer/commit/fc0699549479cc3e34e217f9e588f5128107ba89))

## 0.4.1

07-31-2019 17:50 PDT


### Dependencies
- Bump minimum version for google-api-core to 1.14.0. ([#8709](https://github.com/googleapis/google-cloud-python/pull/8709))

### Documentation
- Fix links to BigQuery Datatransfer documentation. ([#8859](https://github.com/googleapis/google-cloud-python/pull/8859))
- Link to googleapis.dev documentation in READMEs. ([#8705](https://github.com/googleapis/google-cloud-python/pull/8705))

### Internal / Testing Changes
- Update intersphinx mapping for requests. ([#8805](https://github.com/googleapis/google-cloud-python/pull/8805))

## 0.4.0

07-16-2019 17:11 PDT

### Implementation Changes

- Retry DEADLINE_EXCEEDED (via synth). ([#7920](https://github.com/googleapis/google-cloud-python/pull/7920))
- Remove classifier for Python 3.4 for end-of-life. ([#7535](https://github.com/googleapis/google-cloud-python/pull/7535))

### New Features

- Add `DatasourceServiceClient` (via synth). ([#8630](https://github.com/googleapis/google-cloud-python/pull/8630))
- Add `start_manual_transfer_runs` method (via synth). ([#8630](https://github.com/googleapis/google-cloud-python/pull/8630))
- Add `client_info`/`version_info` support (via synth). ([#8630](https://github.com/googleapis/google-cloud-python/pull/8630))
- Allow passing kwargs to `create_channel` (via synth). ([#8630](https://github.com/googleapis/google-cloud-python/pull/8630))
- Add path helpers (via synth). ([#8630](https://github.com/googleapis/google-cloud-python/pull/8630))
- Add protos as an artifact to library ([#7205](https://github.com/googleapis/google-cloud-python/pull/7205))

### Documentation

- Add compatibility check badges to READMEs. ([#8288](https://github.com/googleapis/google-cloud-python/pull/8288))
- Adjust indentation on scheduled query sample. ([#8493](https://github.com/googleapis/google-cloud-python/pull/8493))
- Add docs job to publish to googleapis.dev. ([#8464](https://github.com/googleapis/google-cloud-python/pull/8464))
- Add sample to schedule query with BQ DTS. ([#7703](https://github.com/googleapis/google-cloud-python/pull/7703))
- Add nox session `docs` (via synth). ([#7765](https://github.com/googleapis/google-cloud-python/pull/7765))
- Updated client library documentation URLs. ([#7307](https://github.com/googleapis/google-cloud-python/pull/7307))
- Pick up stub docstring fix in GAPIC generator. ([#6965](https://github.com/googleapis/google-cloud-python/pull/6965))

### Internal / Testing Changes

- Blacken noxfile.py, setup.py (via synth). ([#8116](https://github.com/googleapis/google-cloud-python/pull/8116))
- Add empty lines (via synth). ([#8050](https://github.com/googleapis/google-cloud-python/pull/8050))
- Remove unused message exports (via synth). ([#7263](https://github.com/googleapis/google-cloud-python/pull/7263))
- Protoc-generated serialization update. ([#7075](https://github.com/googleapis/google-cloud-python/pull/7075))

## 0.3.0

12-17-2018 17:59 PST


### Implementation Changes
- Pick up enum fixes in the GAPIC generator. ([#6608](https://github.com/googleapis/google-cloud-python/pull/6608))
- Pick up fixes in GAPIC generator. ([#6491](https://github.com/googleapis/google-cloud-python/pull/6491))
- Fix `client_info` bug, update docstrings. ([#6405](https://github.com/googleapis/google-cloud-python/pull/6405))
- Re-generate library using bigquery_datatransfer/synth.py ([#5973](https://github.com/googleapis/google-cloud-python/pull/5973))
- Fix stray, lint-breaking blank lines from autosynth. ([#5960](https://github.com/googleapis/google-cloud-python/pull/5960))
- Re-generate library using `bigquery_datatransfer/synth.py`. ([#5947](https://github.com/googleapis/google-cloud-python/pull/5947))

### Dependencies
- Bump minimum api_core version for all GAPIC libs to 1.4.1. ([#6391](https://github.com/googleapis/google-cloud-python/pull/6391))

### Documentation
- Document Python 2 deprecation ([#6910](https://github.com/googleapis/google-cloud-python/pull/6910))
- Fix GAX fossils ([#6264](https://github.com/googleapis/google-cloud-python/pull/6264))
- Normalize use of support level badges ([#6159](https://github.com/googleapis/google-cloud-python/pull/6159))
- Harmonize / DRY 'README.rst' / 'docs/index.rst'. ([#6013](https://github.com/googleapis/google-cloud-python/pull/6013))

### Internal / Testing Changes
- Update noxfile.
- Blacken all gen'd libs ([#6792](https://github.com/googleapis/google-cloud-python/pull/6792))
- Omit local deps ([#6701](https://github.com/googleapis/google-cloud-python/pull/6701))
- Run black at end of synth.py ([#6698](https://github.com/googleapis/google-cloud-python/pull/6698))
- Unblack bigquery gapic and protos.
- Run Black on Generated libraries ([#6666](https://github.com/googleapis/google-cloud-python/pull/6666))
- Add templates for flake8, coveragerc, noxfile, and black. ([#6642](https://github.com/googleapis/google-cloud-python/pull/6642))
- Add synth metadata. ([#6562](https://github.com/googleapis/google-cloud-python/pull/6562))
- Use new Nox ([#6175](https://github.com/googleapis/google-cloud-python/pull/6175))

## 0.2.0

### Implementation Changes
- Regenerate bigquery-datatransfer (#5793)

### Internal / Testing Changes
- Avoid overwriting '__module__' of messages from shared modules. (#5364)
- Modify system tests to use prerelease versions of grpcio (#5304)
- Add Test runs for Python 3.7 and remove 3.4 (#5295)
- Fix bad trove classifier
- Rename releases to changelog and include from CHANGELOG.md (#5191)

## 0.1.1

### Dependencies

- Update dependency range for api-core to include v1.0.0 releases (#4944)

### Documentation

- Fix package name in readme (#4670)
- BigQueryDataTransfer: update 404 link for API documentation (#4672)
- Replacing references to `stable/` docs with `latest/`. (#4638)

### Testing and internal changes

- Re-enable lint for tests, remove usage of pylint (#4921)
- Normalize all setup.py files (#4909)
- Update index.rst (#4816)
- nox unittest updates (#4646)

## 0.1.0

[![release level](https://img.shields.io/badge/release%20level-alpha-orange.svg?style&#x3D;flat)](https://cloud.google.com/terms/launch-stages)

The BigQuery Data Transfer Service automates data movement from SaaS
applications to Google BigQuery on a scheduled, managed basis. Your analytics
team can lay the foundation for a data warehouse without writing a single line
of code. BigQuery Data Transfer Service initially supports Google application
sources like Adwords, DoubleClick Campaign Manager, DoubleClick for Publishers
and YouTube.

PyPI: https://pypi.org/project/google-cloud-bigquery-datatransfer/0.1.0/
