# Supported Packages

On each commit, Circle CI automatically compiles all supported packages with GopherJS and runs their tests:

[![Circle CI](https://circleci.com/gh/gopherjs/gopherjs.svg?style=svg)](https://circleci.com/gh/gopherjs/gopherjs)

| Name                | Supported    | Comment                                                                           |
| ------------------- | ------------ | --------------------------------------------------------------------------------- |
| archive             |              |
| -- tar              | ✅ yes       |
| -- zip              | ✅ yes       |
| bufio               | ✅ yes       |
| builtin             | ✅ yes       |
| bytes               | ✅ yes       |
| compress            |              |
| -- bzip2            | ✅ yes       |
| -- flate            | ✅ yes       |
| -- gzip             | ✅ yes       |
| -- lzw              | ✅ yes       |
| -- zlib             | ✅ yes       |
| container           |              |
| -- heap             | ✅ yes       |
| -- list             | ✅ yes       |
| -- ring             | ✅ yes       |
| context             | ✅ yes       |
| crypto              | ✅ yes       |
| -- aes              | ✅ yes       |
| -- cipher           | ✅ yes       |
| -- des              | ✅ yes       |
| -- dsa              | ✅ yes       |
| -- ecdsa            | ✅ yes       |
| -- ed25519          | ✅ yes       |
| -- elliptic         | ✅ yes       |
| -- hmac             | ✅ yes       |
| -- md5              | ✅ yes       |
| -- rand             | ✅ yes       |
| -- rc4              | ✅ yes       |
| -- rsa              | ✅ yes       |
| -- sha1             | ✅ yes       |
| -- sha256           | ✅ yes       |
| -- sha512           | ✅ yes       |
| -- subtle           | ✅ yes       |
| -- tls              | ❌ no        |
| -- x509             | ✅ yes       |
| -- -- pkix          | ✅ yes       |
| database            |              |
| -- sql              | ✅ yes       |
| -- -- driver        | ✅ yes       |
| debug               |              |
| -- dwarf            | ✅ yes       |
| -- elf              | ✅ yes       |
| -- gosym            | ☑️ partially | on binaries generated by gc                                                       |
| -- macho            | ✅ yes       |
| -- pe               | ✅ yes       |
| -- plan9obj         | ✅ yes       |
| embed               | ❌ no        | Not implemented yet: https://github.com/gopherjs/gopherjs/issues/997.             |
| encoding            |              |
| -- ascii85          | ✅ yes       |
| -- asn1             | ✅ yes       |
| -- base32           | ✅ yes       |
| -- base64           | ✅ yes       |
| -- binary           | ✅ yes       |
| -- csv              | ✅ yes       |
| -- gob              | ✅ yes       |
| -- hex              | ✅ yes       |
| -- json             | ✅ yes       |
| -- pem              | ✅ yes       |
| -- xml              | ✅ yes       |
| errors              | ✅ yes       |
| expvar              | ✅ yes       |
| flag                | ✅ yes       |
| fmt                 | ✅ yes       |
| go                  |              |
| -- ast              | ✅ yes       |
| -- build            | ❌ no        |
| -- build/constraint | ✅ yes       |
| -- constant         | ✅ yes       |
| -- doc              | ✅ yes       |
| -- format           | ✅ yes       |
| -- importer         | ❌ no        |
| -- parser           | ✅ yes       |
| -- printer          | ✅ yes       |
| -- scanner          | ✅ yes       |
| -- token            | ✅ yes       |
| -- types            | ❌ no        |
| hash                | ✅ yes       |
| -- adler32          | ✅ yes       |
| -- crc32            | ✅ yes       |
| -- crc64            | ✅ yes       |
| -- fnv              | ✅ yes       |
| -- maphash          | ✅ yes       |
| html                | ✅ yes       |
| -- template         | ✅ yes       |
| image               | ✅ yes       |
| -- color            | ✅ yes       |
| -- -- palette       | ✅ yes       |
| -- draw             | ✅ yes       |
| -- gif              | ✅ yes       |
| -- jpeg             | ✅ yes       |
| -- png              | ✅ yes       |
| index               |              |
| -- suffixarray      | ✅ yes       |
| io                  | ✅ yes       |
| -- fs               | ✅ yes       |
| -- ioutil           | ✅ yes       |
| log                 | ✅ yes       |
| -- syslog           | ❌ no        |
| math                | ✅ yes       |
| -- big              | ✅ yes       |
| -- bits             | ✅ yes       |
| -- cmplx            | ✅ yes       |
| -- rand             | ✅ yes       |
| mime                | ✅ yes       |
| -- multipart        | ✅ yes       |
| -- quotedprintable  | ✅ yes       |
| net                 | ☑️ partially | network is simulated, supports only localhost connections                         |
| -- http             | ☑️ partially | client only, emulated via Fetch/XMLHttpRequest APIs;<br>node.js requires polyfill |
| -- -- cgi           | ❌ no        |
| -- -- cookiejar     | ✅ yes       |
| -- -- fcgi          | ✅ yes       |
| -- -- httptest      | ☑️ partially |
| -- -- httputil      | ☑️ partially |
| -- -- pprof         | ❌ no        |
| -- mail             | ✅ yes       |
| -- rpc              | ☑️ partially | data structures only (no net)                                                     |
| -- -- jsonrpc       | ✅ yes       |
| -- smtp             | ☑️ partially | data structures only (no net)                                                     |
| -- textproto        | ✅ yes       |
| -- url              | ✅ yes       |
| os                  | ☑️ partially | node.js only                                                                      |
| -- exec             | ☑️ partially | node.js only                                                                      |
| -- signal           | ☑️ partially | node.js only                                                                      |
| -- user             | ☑️ partially | node.js only                                                                      |
| path                | ✅ yes       |
| -- filepath         | ✅ yes       |
| plugin              | ❌ no        |
| reflect             | ✅ yes       |
| regexp              | ✅ yes       |
| -- syntax           | ✅ yes       |
| runtime             | ☑️ partially | SetMutexProfileFraction, SetFinalizer, ReadMemStats unsupported                   |
| -- metrics          | ☑️ partially | Same as runtime.                                                                  |
| -- cgo              | ❌ no        |
| -- debug            | ❌ no        |
| -- pprof            | ❌ no        |
| -- race             | ❌ no        |
| -- trace            | ❌ no        |
| sort                | ✅ yes       |
| strconv             | ✅ yes       |
| strings             | ✅ yes       |
| sync                | ✅ yes       |
| -- atomic           | ✅ yes       |
| syscall             | ☑️ partially | node.js only                                                                      |
| testing             | ☑️ partially | AllocsPerRun and T.Helper are unsupported.                                        |
| -- iotest           | ✅ yes       |
| -- fstest           | ✅ yes       |
| -- quick            | ✅ yes       |
| text                |              |
| -- scanner          | ✅ yes       |
| -- tabwriter        | ✅ yes       |
| -- template         | ✅ yes       |
| -- -- parse         | ✅ yes       |
| time                | ✅ yes       | UTC and Local only (see [issue](https://github.com/gopherjs/gopherjs/issues/64))  |
| -- tzdata           | ✅ yes       |
| unicode             | ✅ yes       |
| -- utf16            | ✅ yes       |
| -- utf8             | ✅ yes       |
| unsafe              | ❌ no        |
