<p align="center">
  <img width="100%" src="resources/construction.svg" title="Under Construction" />
</p>

# Graph Node

[The Graph](https://thegraph.com/) is a protocol for building decentralized applications quickly on Ethereum and IPFS using GraphQL.

Graph Node is an open source Rust implementation that event-sources the Ethereum blockchain to deterministically update a datastore which can be queried via the GraphQL endpoint.

For detailed instructions and more context check out the [Getting Started Guide](docs/getting-started.md).

*Note: this project is heavily WIP and until it reaches v1.0 the API is subject to change in breaking ways without notice.*

## Quick Start

### Prerequisites

To build and run this project you need
to have the following installed on your system:

- Rust (latest stable) - [How to install Rust](https://www.rust-lang.org/en-US/install.html)
- PostgreSQL – [PostgreSQL Downloads](https://www.postgresql.org/download/)
- IPFS – [Installing IPFS](https://ipfs.io/docs/install/)

For Ethereum network data you can either run a local node or use Infura.io:

- Local node – [Installing and running Ethereum node](https://ethereum.gitbooks.io/frontier-guide/content/getting_a_client.html)
- Infura infra – [Infura.io](https://infura.io/)

### Running a local Graph Node

1. Install IPFS and run `ipfs init` followed by `ipfs daemon`
2. Install PostgreSQL and run `initdb -D .postgres` followed by `createdb adchain-subgraph`
2. Clone https://github.com/graphprotocol/adchain-subgraph, build it with `yarn install; yarn build-ipfs --verbosity debug` and copy the IPFS hash for use in the step below
3. Clone https://github.com/graphprotocol/graph-node and run `cargo build`

Once you have all the dependencies setup you can run the following:
```
cargo run -p graph-node --release -- \
  --postgres-url postgresql://localhost:5432/adchain-subgraph \
  --ethereum-ws wss://mainnet.infura.io/_ws \
  --ipfs 127.0.0.1:5001 \
  --subgraph IPFS_HASH
```

This will also spin up a GraphiQL interface at `http://127.0.0.1:8000/`.

### Command-line interface

```
USAGE:
    graph-node
      --subgraph <IPFS_HASH>
      --ethereum-ipc <FILE>
        or --ethereum-rpc <URL>
        or --ethereum-ws <URL>
      --ipfs <HOST:PORT>
      --postgres-url <URL>

FLAGS:
    -h, --help       Prints help information
    -V, --version    Prints version information

OPTIONS:
        --subgraph <IPFS_HASH>       IPFS hash of the subgraph manifest
        --ethereum-ipc <FILE>        Ethereum IPC pipe
        --ethereum-rpc <URL>         Ethereum RPC endpoint
        --ethereum-ws <URL>          Ethereum WebSocket endpoint
        --ipfs <HOST:PORT>           HTTP address of an IPFS node
        --postgres-url <URL>         Location of the Postgres database used for storing entities
```

### Environment Variables

The Graph supports the following environment variables:

```
THEGRAPH_SENTRY_URL (optional) — Activates error reporting using Sentry
```

## Project Layout

- `node` — A local Graph node.
- `graph` — A library providing traits for system components and types for
  common data.
- `core` — A library providing implementations for core components, used by all
  nodes.
- `datasource/ethereum` — A library with components for obtaining data from
  Ethereum.
- `graphql` — A GraphQL implementation with API schema generation,
  introspection and more.
- `mock` — A library providing mock implementations for all system components.
- `runtime/wasm` — A library for running WASM data extraction scripts.
- `server/http` — A library providing a GraphQL server over HTTP.
- `store/postgres` — A Postgres store with a GraphQL friendly interface
  and audit logs.

## Roadmap

🔨 = In Progress

🛠 = Feature complete. Additional testing required.

✅ = Feature complete


| Feature |  Status |
| ------- |  :------: |
| **Ethereum** |    |
| Indexing Smart Contract Events | ✅ |
| Handle chain reorganizations | 🛠 |
| **Mappings** |    |
| WASM-based mappings| ✅ |
| TypeScript-to-WASM toolchain | ✅ |
| Autogenerated TypeScript types | ✅ |
| **GraphQL** |     |
| Query entities by ID | ✅ |
| Query entity collections | ✅ |
| Pagination | ✅ |
| Filtering | ✅ |
| Entity relationships | ✅ |
| Subscriptions | 🔨|


## Contributing

Please check [CONTRIBUTING.md](CONTRIBUTING.md) for development flow and conventions we use.

## License

Copyright &copy; 2018 Graph Protocol, Inc. and contributors.

The Graph is dual-licensed under the [MIT license](LICENSE-MIT) and the
[Apache License, Version 2.0](LICENSE-APACHE).

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
