# LeetCode

[![Travis](https://img.shields.io/badge/language-C++-green.svg)]()
[![Travis](https://img.shields.io/badge/language-JavaScript-yellow.svg)]()
[![Travis](https://img.shields.io/badge/language-Python-red.svg)]()
[![Travis](https://img.shields.io/badge/language-Java-blue.svg)]()

[![](https://img.shields.io/badge/WeChat-微信群-brightgreen)](#关注我)
[![](https://img.shields.io/badge/公众号-脑洞前端-blueviolet)](#关注我)
[![](https://img.shields.io/badge/Juejin-掘金-blue)](https://juejin.im/user/58af98305c497d0067780b3b)
[![](https://img.shields.io/badge/Zhihu-知乎-blue)](https://www.zhihu.com/people/lu-xiao-13-70)
[![](https://img.shields.io/badge/bilili-哔哩哔哩-ff69b4)](https://space.bilibili.com/519510412/)

![历史共访问次数](https://visitor-count-badge.herokuapp.com/total.svg?repo_id=azl397985856.leetcode)
![今天被访问次数](https://visitor-count-badge.herokuapp.com/today.svg?repo_id=azl397985856.leetcode)

> 统计数据的时间是从 2019-09-03 19:40 起至今

简体中文 | [English](./README.en.md)

---

![leetcode.jpeg](./assets/leetcode.jpeg)

- 2019-07-10 ：[纪念项目 Star 突破 1W 的一个短文](./thanksGiving.md)， 记录了项目的"兴起"之路，大家有兴趣可以看一下，如果对这个项目感兴趣，请**点击一下 Star**， 项目会**持续更新**，感谢大家的支持。

- 2019-10-08: [纪念 LeetCode 项目 Star 突破 2W](./thanksGiving2.md)，并且 Github 搜索“LeetCode”，排名第一。

- 2020-04-12: [项目突破三万 Star](./thanksGiving3.md)。
- 2020-04-14: 官网`力扣加加`上线啦 💐💐💐💐💐，有专题讲解，每日一题，下载区和视频题解，后续会增加更多内容，还不赶紧收藏起来？地址：http://leetcode-solution.cn/

![](https://tva1.sinaimg.cn/large/007S8ZIlly1gdvenxvjlsj30z90dtdhw.jpg)

## 介绍

leetcode 题解，记录自己的 leetcode 解题之路。

本仓库目前分为**五个**部分：

- 第一个部分是 leetcode 经典题目的解析，包括思路，关键点和具体的代码实现。

- 第二部分是对于数据结构与算法的总结

- 第三部分是 anki 卡片， 将 leetcode 题目按照一定的方式记录在 anki 中，方便大家记忆。

- 第四部分是每日一题，每日一题是在交流群（包括微信和 qq）里进行的一种活动，大家一起 解一道题，这样讨论问题更加集中，会得到更多的反馈。而且 这些题目可以被记录下来，日后会进行筛选添加到仓库的题解模块。

- 第五部分是计划， 这里会记录将来要加入到以上三个部分内容

> 只有熟练掌握基础的数据结构与算法，才能对复杂问题迎刃有余。

## 关于我

擅长前端工程化，前端性能优化，前端标准化等，做过。net， 搞过 Java，现在是一名前端工程师，我的个人博客：https://lucifer.ren/blog/

我经常会在开源社区进行一些输出和分享，比较受欢迎的有 [宇宙最强的前端面试指南](https://github.com/azl397985856/fe-interview)
和 [我的第一本小书](https://github.com/azl397985856/automate-everything)。目前本人正在写一本关于《leetcode 题解》的实体书，感兴趣的可以通过邮箱或者微信联系我，我会在出版的第一时间通知你，并给出首发优惠价。有需要可以直接群里联系我，或者发送到我的个人邮箱 [azl397985856@gmail.com]。 新书详情戳这里：[《或许是一本可以彻底改变你刷 LeetCode 效率的题解书》](https://lucifer.ren/blog/2020/04/07/leetcode-book.intro/)

## 食用指南

- 对于最近添加的部分， 后面会有 🆕 标注
- 对于最近更新的部分， 后面会有 🖊 标注
- 将来会在这里更新 anki 卡片
- 这里有一份 leetcode 官方账号在知乎上给出的一个《互联网公司最常见的面试算法题有哪些？》的答案，我这里尽量去覆盖回答中的题目和知识点
  原文地址： https://www.zhihu.com/question/24964987/answer/586425979

- 这里有一份我在知乎上的回答 [《大家都是如何刷 LeetCode 的？》](https://www.zhihu.com/question/280279208/answer/824585814)

- 这里有一张互联网公司面试中经常考察的问题类型总结的思维导图，我们可以结合图片中的信息分析一下。

![leetcode-zhihu](./assets//leetcode-zhihu.jpg)

（图片来自 leetcode)

其中算法，主要是以下几种：

- 基础技巧：分治、二分、贪心
- 排序算法：快速排序、归并排序、计数排序
- 搜索算法：回溯、递归、深度优先遍历，广度优先遍历，二叉搜索树等
- 图论：最短路径、最小生成树
- 动态规划：背包问题、最长子序列

数据结构，主要有如下几种：

- 数组与链表：单 / 双向链表
- 栈与队列
- 哈希表
- 堆：最大堆 ／ 最小堆
- 树与图：最近公共祖先、并查集
- 字符串：前缀树（字典树） ／ 后缀树

## 精彩预告

[0042.trapping-rain-water](./problems/42.trapping-rain-water.md):

![0042.trapping-rain-water](./assets/problems/42.trapping-rain-water-1.png)

[0547.friend-circles](./problems/547.friend-circles-en.md):

<img width="600" src="./assets/problems/547.friend-circle-bfs.png">

[backtrack problems](./problems/90.subsets-ii.md):

<img width="600" src="./assets/problems/backtrack.png">

[0198.house-robber](./problems/198.house-robber.md):

<img width="600" src="./assets/problems/198.house-robber.png">

[0454.4-sum-ii](./problems/454.4-sum-ii.md):

<img width="600" src="./assets/problems/454.4-sum-ii.png">

## Top 题目进度

- [Top 100 Liked Questions](https://leetcode.com/problemset/top-100-liked-questions/) (84 / 100)

- [Top Interview Questions](https://leetcode.com/problemset/top-interview-questions/) (115 / 145)

## 传送门

### leetcode 经典题目的解析

> 这里仅列举具有**代表性题目**，并不是全部题目

#### 简单难度

- [0001.TwoSum](./problems/1.TwoSum.md)
- [0020.Valid Parentheses](./problems/20.validParentheses.md)
- [0021.MergeTwoSortedLists](./problems/21.MergeTwoSortedLists.md)
- [0026.remove-duplicates-from-sorted-array](./problems/26.remove-duplicates-from-sorted-array.md)
- [0053.maximum-sum-subarray](./problems/53.maximum-sum-subarray-cn.md)
- [0088.merge-sorted-array](./problems/88.merge-sorted-array.md)
- [0101.symmetric-tree](./problems/101.symmetric-tree.md)🆕
- [0104.maximum-depth-of-binary-tree](./problems/104.maximum-depth-of-binary-tree.md)
- [0121.best-time-to-buy-and-sell-stock](./problems/121.best-time-to-buy-and-sell-stock.md)
- [0122.best-time-to-buy-and-sell-stock-ii](./problems/122.best-time-to-buy-and-sell-stock-ii.md)
- [0125.valid-palindrome](./problems/125.valid-palindrome.md)
- [0136.single-number](./problems/136.single-number.md)
- [0155.min-stack](./problems/155.min-stack.md) 🆕
- [0167.two-sum-ii-input-array-is-sorted](./problems/167.two-sum-ii-input-array-is-sorted.md)
- [0169.majority-element](./problems/169.majority-element.md)
- [0172.factorial-trailing-zeroes](./problems/172.factorial-trailing-zeroes.md)
- [0190.reverse-bits](./problems/190.reverse-bits.md)
- [0191.number-of-1-bits](./problems/191.number-of-1-bits.md)
- [0198.house-robber](./problems/198.house-robber.md)
- [0203.remove-linked-list-elements](./problems/203.remove-linked-list-elements.md)
- [0206.reverse-linked-list](./problems/206.reverse-linked-list.md)
- [0219.contains-duplicate-ii](./problems/219.contains-duplicate-ii.md)
- [0226.invert-binary-tree](./problems/226.invert-binary-tree.md)
- [0232.implement-queue-using-stacks](./problems/232.implement-queue-using-stacks.md) 🆕
- [0263.ugly-number](./problems/263.ugly-number.md)
- [0283.move-zeroes](./problems/283.move-zeroes.md)
- [0342.power-of-four](./problems/342.power-of-four.md)
- [0349.intersection-of-two-arrays](./problems/349.intersection-of-two-arrays.md)
- [0371.sum-of-two-integers](./problems/371.sum-of-two-integers.md)
- [0437.path-sum-iii](./problems/437.path-sum-iii.md) 🆕
- [0455.AssignCookies](./problems/455.AssignCookies.md) 🆕
- [0501.find-mode-in-binary-search-tree](./problems/501.Find-Mode-in-Binary-Search-Tree.md)🆕
- [0575.distribute-candies](./problems/575.distribute-candies.md)
- [0874.walking-robot-simulation](./problems/874.walking-robot-simulation.md) 🆕
- [1260.shift-2d-grid](./problems/1260.shift-2d-grid.md) 🆕
- [1332.remove-palindromic-subsequences](./problems/1332.remove-palindromic-subsequences.md) 🆕

#### 中等难度

- [0002. Add Two Numbers](./problems/2.addTwoNumbers.md)
- [0003. Longest Substring Without Repeating Characters](./problems/3.longestSubstringWithoutRepeatingCharacters.md)
- [0005.longest-palindromic-substring](./problems/5.longest-palindromic-substring.md)
- [0011.container-with-most-water](./problems/11.container-with-most-water.md)
- [0015.3-sum](./problems/15.3-sum.md)
- [0017.Letter-Combinations-of-a-Phone-Number](./problems/17.Letter-Combinations-of-a-Phone-Number.md) 🆕
- [0019. Remove Nth Node From End of List](./problems/19.removeNthNodeFromEndofList.md)
- [0022.GenerateParentheses](./problems/22.GenerateParentheses.md) 🆕
- [0024. Swap Nodes In Pairs](./problems/24.swapNodesInPairs.md)
- [0029.divide-two-integers](./problems/29.divide-two-integers.md)
- [0031.next-permutation](./problems/31.next-permutation.md)
- [0033.search-in-rotated-sorted-array](./problems/33.search-in-rotated-sorted-array.md)
- [0039.combination-sum](./problems/39.combination-sum.md)
- [0040.combination-sum-ii](./problems/40.combination-sum-ii.md)
- [0046.permutations](./problems/46.permutations.md)
- [0047.permutations-ii](./problems/47.permutations-ii.md)
- [0048.rotate-image](./problems/48.rotate-image.md)
- [0049.group-anagrams](./problems/49.group-anagrams.md)
- [0050.pow-x-n](./problems/50.pow-x-n.md) 🆕
- [0055.jump-game](./problems/55.jump-game.md)
- [0056.merge-intervals](./problems/56.merge-intervals.md)
- [0060.permutation-sequence](./problems/60.permutation-sequence.md) 🆕
- [0062.unique-paths](./problems/62.unique-paths.md) 🖊
- [0073.set-matrix-zeroes](./problems/73.set-matrix-zeroes.md)
- [0075.sort-colors](./problems/75.sort-colors.md)
- [0078.subsets](./problems/78.subsets.md)
- [0079.word-search](./problems/79.word-search-en.md)
- [0080.remove-duplicates-from-sorted-array-ii](./problems/80.remove-duplicates-from-sorted-array-ii.md) 🆕
- [0086.partition-list](./problems/86.partition-list.md)
- [0090.subsets-ii](./problems/90.subsets-ii.md)
- [0091.decode-ways](./problems/91.decode-ways.md)
- [0092.reverse-linked-list-ii](./problems/92.reverse-linked-list-ii.md) 🖊
- [0094.binary-tree-inorder-traversal](./problems/94.binary-tree-inorder-traversal.md)
- [0095.unique-binary-search-trees-ii](./problems/95.unique-binary-search-trees-ii.md) 🆕
- [0096.unique-binary-search-trees](./problems/96.unique-binary-search-trees.md) 🆕
- [0098.validate-binary-search-tree](./problems/98.validate-binary-search-tree.md)
- [0102.binary-tree-level-order-traversal](./problems/102.binary-tree-level-order-traversal.md)
- [0103.binary-tree-zigzag-level-order-traversal](./problems/103.binary-tree-zigzag-level-order-traversal.md)
- [105.Construct-Binary-Tree-from-Preorder-and-Inorder-Traversal.md](./problems/105.Construct-Binary-Tree-from-Preorder-and-Inorder-Traversal.md)
- [0113.path-sum-ii](./problems/113.path-sum-ii.md)
- [0129.sum-root-to-leaf-numbers](./problems/129.sum-root-to-leaf-numbers.md)
- [0130.surrounded-regions](./problems/130.surrounded-regions.md)
- [0131.palindrome-partitioning](./problems/131.palindrome-partitioning.md)
- [0139.word-break](./problems/139.word-break.md)
- [0144.binary-tree-preorder-traversal](./problems/144.binary-tree-preorder-traversal.md)
- [0150.evaluate-reverse-polish-notation](./problems/150.evaluate-reverse-polish-notation.md)
- [0152.maximum-product-subarray](./problems/152.maximum-product-subarray.md) 🖊
- [0199.binary-tree-right-side-view](./problems/199.binary-tree-right-side-view.md)
- [0200.number-of-islands](./problems/200.number-of-islands.md) 🆕
- [0201.bitwise-and-of-numbers-range](./problems/201.bitwise-and-of-numbers-range.md) 🖊
- [0208.implement-trie-prefix-tree](./problems/208.implement-trie-prefix-tree.md)
- [0209.minimum-size-subarray-sum](./problems/209.minimum-size-subarray-sum.md)
- [0211.add-and-search-word-data-structure-design](./problems/211.add-and-search-word-data-structure-design.md) 🆕
- [0215.kth-largest-element-in-an-array](./problems/215.kth-largest-element-in-an-array.md) 🆕
- [0221.maximal-square](./problems/221.maximal-square.md)
- [0229.majority-element-ii](./problems/229.majority-element-ii.md) 🆕
- [0230.kth-smallest-element-in-a-bst](./problems/230.kth-smallest-element-in-a-bst.md)
- [0236.lowest-common-ancestor-of-a-binary-tree](./problems/236.lowest-common-ancestor-of-a-binary-tree.md)
- [0238.product-of-array-except-self](./problems/238.product-of-array-except-self.md)
- [0240.search-a-2-d-matrix-ii](./problems/240.search-a-2-d-matrix-ii.md)
- [0279.perfect-squares](./problems/279.perfect-squares.md)
- [0309.best-time-to-buy-and-sell-stock-with-cooldown](./problems/309.best-time-to-buy-and-sell-stock-with-cooldown.md)
- [0322.coin-change](./problems/322.coin-change.md)
- [0328.odd-even-linked-list](./problems/328.odd-even-linked-list.md)
- [0334.increasing-triplet-subsequence](./problems/334.increasing-triplet-subsequence.md)
- [0343.integer-break](./problems/343.integer-break.md)🆕
- [0365.water-and-jug-problem](./problems/365.water-and-jug-problem.md)
- [0378.kth-smallest-element-in-a-sorted-matrix](./problems/378.kth-smallest-element-in-a-sorted-matrix.md)
- [0380.insert-delete-getrandom-o1](./problems/380.insert-delete-getrandom-o1.md)🆕
- [0416.partition-equal-subset-sum](./problems/416.partition-equal-subset-sum.md)
- [0445.add-two-numbers-ii](./problems/445.add-two-numbers-ii.md)
- [0454.4-sum-ii](./problems/454.4-sum-ii.md)
- [0474.ones-and-zeros](./problems/474.ones-and-zeros-en.md)
- [0494.target-sum](./problems/494.target-sum.md)
- [0516.longest-palindromic-subsequence](./problems/516.longest-palindromic-subsequence.md)
- [0518.coin-change-2](./problems/518.coin-change-2.md)
- [0547.friend-circles](./problems/547.friend-circles-en.md) 🆕
- [0560.subarray-sum-equals-k](./problems/560.subarray-sum-equals-k.md)
- [0609.find-duplicate-file-in-system](./problems/609.find-duplicate-file-in-system.md)
- [0820.short-encoding-of-words](./problems/820.short-encoding-of-words.md) 🆕
- [0875.koko-eating-bananas](./problems/875.koko-eating-bananas.md)
- [0877.stone-game](./problems/877.stone-game.md)
- [0887.super-egg-drop](./problems/887.super-egg-drop.md)
- [0900.rle-iterator](./problems/900.rle-iterator.md)
- [0912.sort-an-array](./problems/912.sort-an-array.md)
- [0935.knight-dialer](./problems/935.knight-dialer.md) 🆕
- [1011.capacity-to-ship-packages-within-d-days](./problems/1011.capacity-to-ship-packages-within-d-days.md)
- [1014.best-sightseeing-pair](./problems/1014.best-sightseeing-pair.md) 🆕
- [1015.smallest-integer-divisible-by-k](./problems/1015.smallest-integer-divisible-by-k.md)
- [1019.next-greater-node-in-linked-list](./problems/1019.next-greater-node-in-linked-list.md) 🆕
- [1020.number-of-enclaves](./problems/1020.number-of-enclaves.md)
- [1023.camelcase-matching](./problems/1023.camelcase-matching.md)
- [1031.maximum-sum-of-two-non-overlapping-subarrays](./problems/1031.maximum-sum-of-two-non-overlapping-subarrays.md)
- [1104.path-in-zigzag-labelled-binary-tree](./problems/1104.path-in-zigzag-labelled-binary-tree.md)
- [1131.maximum-of-absolute-value-expression](./problems/1131.maximum-of-absolute-value-expression.md)
- [1186.maximum-subarray-sum-with-one-deletion](./problems/1186.maximum-subarray-sum-with-one-deletion.md) 🆕
- [1218.longest-arithmetic-subsequence-of-given-difference](./problems/1218.longest-arithmetic-subsequence-of-given-difference.md)
- [1227.airplane-seat-assignment-probability](./problems/1227.airplane-seat-assignment-probability.md)
- [1261.find-elements-in-a-contaminated-binary-tree](./problems/1261.find-elements-in-a-contaminated-binary-tree.md)
- [1262.greatest-sum-divisible-by-three](./problems/1262.greatest-sum-divisible-by-three.md)
- [1297.maximum-number-of-occurrences-of-a-substring](./problems/1297.maximum-number-of-occurrences-of-a-substring.md)
- [1310.xor-queries-of-a-subarray](./problems/1310.xor-queries-of-a-subarray.md) 🆕
- [1334.find-the-city-with-the-smallest-number-of-neighbors-at-a-threshold-distance](./problems/1334.find-the-city-with-the-smallest-number-of-neighbors-at-a-threshold-distance.md) 🆕
- [1371.find-the-longest-substring-containing-vowels-in-even-counts](./problems/1371.find-the-longest-substring-containing-vowels-in-even-counts.md) 🆕

#### 困难难度

- [0004.median-of-two-sorted-array](./problems/4.median-of-two-sorted-array.md)
- [0023.merge-k-sorted-lists](./problems/23.merge-k-sorted-lists.md)
- [0025.reverse-nodes-in-k-group](./problems/25.reverse-nodes-in-k-groups-cn.md)
- [0030.substring-with-concatenation-of-all-words](./problems/30.substring-with-concatenation-of-all-words.md)
- [0032.longest-valid-parentheses](./problems/32.longest-valid-parentheses.md)
- [0042.trapping-rain-water](./problems/42.trapping-rain-water.md)
- [0052.N-Queens-II](./problems/52.N-Queens-II.md) 🆕
- [0084.largest-rectangle-in-histogram](./problems/84.largest-rectangle-in-histogram.md)
- [0085.maximal-rectangle](./problems/85.maximal-rectangle.md)
- [0124.binary-tree-maximum-path-sum](./problems/124.binary-tree-maximum-path-sum.md)
- [0128.longest-consecutive-sequence](./problems/128.longest-consecutive-sequence.md)
- [0145.binary-tree-postorder-traversal](./problems/145.binary-tree-postorder-traversal.md)
- [0212.word-search-ii](./problems/212.word-search-ii.md)
- [0239.sliding-window-maximum](./problems/239.sliding-window-maximum.md)
- [0295.find-median-from-data-stream](./problems/295.find-median-from-data-stream.md)
- [0301.remove-invalid-parentheses](./problems/301.remove-invalid-parentheses.md)
- [0312.burst-balloons](./problems/312.burst-balloons.md) 🆕
- [0335.self-crossPing](./problems/335.self-crossing.md)
- [0460.lfu-cache](./problems/460.lfu-cache.md)
- [0472.concatenated-words](./problems/472.concatenated-words.md) 🆕
- [0493.reverse-pairs](./problems/493.reverse-pairs.md) 🆕
- [0895.maximum-frequency-stack](./problems/895.maximum-frequency-stack.md) 🆕
- [1168.optimize-water-distribution-in-a-village](./problems/1168.optimize-water-distribution-in-a-village-cn.md) 🆕
- [1449.form-largest-integer-with-digits-that-add-up-to-target](./problems/1449.form-largest-integer-with-digits-that-add-up-to-target.md) 🆕

### 数据结构与算法的总结

- [数据结构](./thinkings/basic-data-structure.md)
- [基础算法](./thinkings/basic-algorithm.md)
- [二叉树的遍历](./thinkings/binary-tree-traversal.md) 🖊
- [动态规划](./thinkings/dynamic-programming.md)
- [哈夫曼编码和游程编码](./thinkings/run-length-encode-and-huffman-encode.md)
- [布隆过滤器](./thinkings/bloom-filter.md)
- [字符串问题](./thinkings/string-problems.md)
- [前缀树专题](./thinkings/trie.md)
- [《日程安排》专题](https://lucifer.ren/blog/2020/02/03/leetcode-%E6%88%91%E7%9A%84%E6%97%A5%E7%A8%8B%E5%AE%89%E6%8E%92%E8%A1%A8%E7%B3%BB%E5%88%97/)
- [《构造二叉树》专题](https://lucifer.ren/blog/2020/02/08/%E6%9E%84%E9%80%A0%E4%BA%8C%E5%8F%89%E6%A0%91%E4%B8%93%E9%A2%98/)
- [《贪婪策略》专题](./thinkings/greedy.md)
- [《深度优先遍历》专题](./thinkings/DFS.md)
- [滑动窗口（思路 + 模板）](./thinkings/slide-window.md)
- [位运算](./thinkings/bit.md) 🆕
- [设计题](./thinkings/design.md) 🆕
- [小岛问题](./thinkings/island.md) 🆕
- [最大公约数](./thinkings/GCD.md) 🆕
- [并查集](./thinkings/union-find.md) 🆕
- [前缀和](./thinkings/prefix.md) 🆕

### anki 卡片

Anki 主要分为两个部分：一部分是关键点到题目的映射，另一部分是题目到思路，关键点，代码的映射。

全部卡片都在 [anki-card](./assets/anki/leetcode.apkg)

使用方法：

anki - 文件 - 导入 - 下拉格式选择“打包的 anki 集合”，然后选中你下载好的文件，确定即可。

更多关于 anki 使用方法的请查看 [anki 官网](https://apps.ankiweb.net/)

目前已更新卡片一览（仅列举正面）：

- 二分法解决问题的关键点是什么，相关问题有哪些？
- 如何用栈的特点来简化操作， 涉及到的题目有哪些？
- 双指针问题的思路以及相关题目有哪些？
- 滑动窗口问题的思路以及相关题目有哪些？
- 回溯法解题的思路以及相关题目有哪些？
- 数论解决问题的关键点是什么，相关问题有哪些？
- 位运算解决问题的关键点是什么，相关问题有哪些？

> 已加入的题目有：#2 #3 #11

### 每日一题

每日一题是在交流群（包括微信和 qq）里通过 issues 来进行的一种活动，大家一起 解一道题，这样讨论问题更加集中，会得到更多的反馈。而且 这些题目可以被记录下来，日后会进行筛选添加到仓库的题解模块。

- [每日一题汇总](./daily/)

![每日一题汇总](./assets/daily-summary.png)

- [每日一题认领区](https://github.com/azl397985856/leetcode/projects/1)

![每日一题认领区](./assets/daily-board.png)

### 计划

- [anki 卡片 完善](./assets/anki/)

- [字符串类问题汇总](./todo/str/)

- LeetCode 换皮题目集锦

- 动态规划完善。最长递增子序列，最长回文子序列，编辑距离等“字符串”题目， 扔鸡蛋问题。 解题模板，滚动数组。

- 堆可以解决的题目。 手写堆

- 单调栈

## 关注我

点关注，不迷路。如果再给 ➕ 个星标就更棒啦！

> 关注加加，星标加加～

<img src="https://tva1.sinaimg.cn/large/007S8ZIlly1gfcuzagjalj30p00dwabs.jpg" width="100%">

## 捐赠

[点击查看完整的捐赠列表](./donation.md)

### 微信

<img width="300" src="./assets/donate-weixin.jpg">

### 支付宝

<img width="300" src="./assets/donate-zfb.jpg">

## 贡献

- 如果有想法和创意，请提 [issue](https://github.com/azl397985856/leetcode/issues) 或者进群提
- 如果想贡献增加题解或者翻译， 可以参考[贡献指南](./CONTRIBUTING.md)
  > 关于如何提交题解，我写了一份 [指南](./templates/problems/1014.best-sightseeing-pair.md)
- 如果需要修改项目中图片，[这里](./assets/drawio/) 存放了项目中绘制图的源代码， 大家可以用 [draw.io](https://www.draw.io/) 打开进行编辑。

## 鸣谢

感谢为这个项目作出贡献的所有 [小伙伴](https://github.com/azl397985856/leetcode/graphs/contributors)

## License

[Apache-2.0](./LICENSE.txt)
