# 毎日一题 - 771.jewels-and-stones

## 信息卡片

- 时间：2019-08-02
- 题目链接：https://leetcode.com/problems/jewels-and-stones/
- tag：`String` `Hash Table`

## 题目描述

```
 给定字符串J 代表石头中宝石的类型，和字符串 S代表你拥有的石头。 S 中每个字符代表了一种你拥有的石头的类型，你想知道你拥有的石头中有多少是宝石。

J 中的字母不重复，J 和 S中的所有字符都是字母。字母区分大小写，因此"a"和"A"是不同类型的石头。

示例 1:

输入: J = "aA", S = "aAAbbbb"
输出: 3
示例 2:

输入: J = "z", S = "ZZ"
输出: 0
注意:

S 和 J 最多含有50个字母。
 J 中的字符不重复。
```

## 参考答案

### 正则匹配

时间复杂度比较高，具体复杂度取决于内部回溯的时机。

思路：正则把石头里的宝石 replace 掉，长度相减，就是结果

代码：

```js
let newS = S;
for (let i = 0; i < J.length; i++) {
  newS = newS.replace(new RegExp(J[i], "g"), "");
}
return S.length - newS.length;
```

### Hash Table

使用 hash table， 空间换时间的方式。

代码：

```js
const set = {};
let res = 0;

for (let i = 0; i < J.length; i++) {
  set[J[i]] = true;
}

for (let i = 0; i < S.length; i++) {
  if (set[S[i]]) {
    res++;
  }
}
return res;
```

### JS 一行代码

```js
return S.split("").filter(c => J.indexOf(c) !== -1).length;
```

## 优秀解答

> 暂缺
