## Problem

https://leetcode-cn.com/problems/capacity-to-ship-packages-within-d-days

## Problem Description

A conveyor belt has packages that must be shipped from one port to another within D days.

The i-th package on the conveyor belt has a weight of weights[i].  Each day, we load the ship with packages on the conveyor belt (in the order given by weights). We may not load more weight than the maximum weight capacity of the ship.

Return the least weight capacity of the ship that will result in all the packages on the conveyor belt being shipped within D days.

**Example 1:**

```
Input: weights = [1,2,3,4,5,6,7,8,9,10], D = 5
Output: 15
Explanation: 
A ship capacity of 15 is the minimum to ship all the packages in 5 days like this:
1st day: 1, 2, 3, 4, 5
2nd day: 6, 7
3rd day: 8
4th day: 9
5th day: 10

Note that the cargo must be shipped in the order given, so using a ship of capacity 14 and splitting the packages into parts like (2, 3, 4, 5), (1, 6, 7), (8), (9), (10) is not allowed. 
```

**Example 2:**

```
Input: weights = [3,2,2,4,1,4], D = 3
Output: 6
Explanation: 
A ship capacity of 6 is the minimum to ship all the packages in 3 days like this:
1st day: 3, 2
2nd day: 2, 4
3rd day: 1, 4
```

**Example 3:**

```
Input: weights = [1,2,3,1,1], D = 4
Output: 3
Explanation: 
1st day: 1
2nd day: 2
3rd day: 3
4th day: 1, 1
```



 **Note:**

1. `1 <= D <= weights.length <= 50000`
2. `1 <= weights[i] <= 500`



## Solution

The problem is same as [**LeetCode 875 koko-eating-bananas**] (https://github.com/azl397985856/leetcode/blob/master/problems/875.koko-eating-bananas-en.md) practically.

It is easy to solve this kind of problems  if you take a closer look into it.


The essence is to search a given number in finite discrete data like [ 1,2,3,4, ... , total ].  

However, We should find the cargo that can be shipped in D days rather than look for the target directly.


Consider the following questions:

- Can it be shipped if the capacity is 1?
- Can it be shipped if the capacity is 2?
- Can it be shipped if the capacity is 3?
- ...
- Can it be shipped if the capacity is total ? ( Yeap we can,  D is greater than or equal to 1)

During the process, we  directly `return`  if the answer is *yes*.

If the answer is *no*,  just keep asking.

This is a typical binary search problem, the only difference is the judgement condition:


```python
def canShip(opacity):
    # Whether the capacity of the specified ship can be shipped in D days
    lo = 0
    hi = total
    while lo < hi:
        mid = (lo + hi) // 2
        if canShip(mid):
            hi = mid
        else:
            lo = mid + 1
    return lo
```

## Key Points

- if you are so familiar with binary search as well its transformation, you can easily find out that using binary search to find one number in a given number sequence of a certain length.

## Code (`JS/Python`)

- `Python`

```python
class Solution:
    def shipWithinDays(self, weights: List[int], D: int) -> int:
        lo = 0
        hi = 0

        def canShip(opacity):
            days = 1
            remain = opacity
            for weight in weights:
                if weight > opacity:
                    return False
                remain -= weight
                if remain < 0:
                    days += 1
                    remain = opacity - weight
            return days <= D

        for weight in weights:
            hi += weight
        while lo < hi:
            mid = (lo + hi) // 2
            if canShip(mid):
                hi = mid
            else:
                lo = mid + 1

        return lo
```

- `JavaScript`

```js
/**
 * @param {number[]} weights
 * @param {number} D
 * @return {number}
 */
var shipWithinDays = function(weights, D) {
  let high = weights.reduce((acc, cur) => acc + cur)
  let low = 0

  while(low < high) {
    let mid = Math.floor((high + low) / 2)
    if (canShip(mid)) {
      high = mid
    } else {
      low = mid + 1
    }
  }

  return low

  function canShip(opacity) {
    let remain = opacity
    let count = 1
    for (let weight of weights) {
      if (weight > opacity) {
        return false
      }
      remain -= weight
      if (remain < 0) {
        count++
        remain = opacity - weight
      }
      if (count > D) {
        return false
      }
    }
    return count <= D
  }
};
```

## References

## Extension
