

## 题目地址
https://leetcode.com/problems/4sum-ii/description/

## 题目描述

```
Given four lists A, B, C, D of integer values, compute how many tuples (i, j, k, l) there are such that A[i] + B[j] + C[k] + D[l] is zero.

To make problem a bit easier, all A, B, C, D have same length of N where 0 ≤ N ≤ 500. All integers are in the range of -228 to 228 - 1 and the result is guaranteed to be at most 231 - 1.

Example:

Input:
A = [ 1, 2]
B = [-2,-1]
C = [-1, 2]
D = [ 0, 2]

Output:
2

Explanation:
The two tuples are:
1. (0, 0, 0, 1) -> A[0] + B[0] + C[0] + D[1] = 1 + (-2) + (-1) + 2 = 0
2. (1, 1, 0, 0) -> A[1] + B[1] + C[0] + D[0] = 2 + (-1) + (-1) + 0 = 0
```
## 思路

如果按照常规思路去完成查找需要四层遍历，时间复杂是O(n^4), 显然是行不通的。
因此我们有必要想一种更加高效的算法。

我一个思路就是我们将四个数组分成两组，两两结合。
然后我们分别计算`两两结合能够算出的和有哪些，以及其对应的个数`。

如图：

![454.4-sum-ii](../assets/problems/454.4-sum-ii.png)


这个时候我们得到了两个`hashTable`， 我们只需要进行简单的数学运算就可以得到结果。

## 关键点解析

- 空间换时间
- 两两分组，求出两两结合能够得出的可能数，然后合并即可。

## 代码

语言支持： `JavaScript`，`Python3`

`JavaScript`: 
```js

/*
 * @lc app=leetcode id=454 lang=javascript
 *
 * [454] 4Sum II
 *
 * https://leetcode.com/problems/4sum-ii/description/
/**
 * @param {number[]} A
 * @param {number[]} B
 * @param {number[]} C
 * @param {number[]} D
 * @return {number}
 */
var fourSumCount = function(A, B, C, D) {
  const sumMapper = {};
  let res = 0;
  for (let i = 0; i < A.length; i++) {
    for (let j = 0; j < B.length; j++) {
        sumMapper[A[i] + B[j]] = (sumMapper[A[i] + B[j]] || 0) + 1;
    }
  }

  for (let i = 0; i < C.length; i++) {
    for (let j = 0; j < D.length; j++) {
        res += sumMapper[- (C[i] + D[j])] || 0;
    }
  }

  return res;
};
```

`Python3`: 

```python
class Solution:
    def fourSumCount(self, A: List[int], B: List[int], C: List[int], D: List[int]) -> int:
        mapper = {}
        res = 0
        for i in A:
            for j in B:
                mapper[i + j] = mapper.get(i + j, 0) + 1
        
        for i in C:
            for j in D:
                res += mapper.get(-1 * (i + j), 0)
        return res
 ```
