* **Workflow**

  * :doc:`/cookbook/workflow/new_project_git`

* **Controllers**

  * :doc:`/cookbook/controller/error_pages`
  * :doc:`/cookbook/controller/service`

* **Routing**

  * :doc:`/cookbook/routing/scheme`
  * :doc:`/cookbook/routing/slash_in_parameter`

* **Handling JavaScript and CSS Assets**

  * :doc:`/cookbook/assetic/asset_management`
  * :doc:`/cookbook/assetic/yuicompressor`
  * :doc:`/cookbook/assetic/jpeg_optimize`
  * :doc:`/cookbook/assetic/apply_to_option`

* **Database Interaction (Doctrine)**

  * :doc:`/cookbook/doctrine/file_uploads`
  * :doc:`/cookbook/doctrine/common_extensions`
  * :doc:`/cookbook/doctrine/event_listeners_subscribers`
  * :doc:`/cookbook/doctrine/dbal`
  * :doc:`/cookbook/doctrine/reverse_engineering`
  * :doc:`/cookbook/doctrine/multiple_entity_managers`
  * :doc:`/cookbook/doctrine/custom_dql_functions`

* **Forms and Validation**

  * :doc:`/cookbook/form/form_customization`
  * :doc:`/cookbook/form/data_transformers`
  * :doc:`/cookbook/form/dynamic_form_generation`
  * :doc:`/cookbook/form/form_collections`
  * :doc:`/cookbook/form/create_custom_field_type`
  * :doc:`/cookbook/validation/custom_constraint`
  * (doctrine) :doc:`/cookbook/doctrine/file_uploads`

* **Configuration and the Service Container**

  * :doc:`/cookbook/configuration/environments`
  * :doc:`/cookbook/configuration/external_parameters`
  * :doc:`/cookbook/service_container/factories`
  * :doc:`/cookbook/service_container/parentservices`
  * :doc:`/cookbook/service_container/scopes`
  * :doc:`/cookbook/configuration/pdo_session_storage`

* **Bundles**

  * :doc:`/cookbook/bundles/best_practices`
  * :doc:`/cookbook/bundles/inheritance`
  * :doc:`/cookbook/bundles/override`
  * :doc:`/cookbook/bundles/extension`

* **Emailing**

  * :doc:`/cookbook/email`
  * :doc:`/cookbook/gmail`
  * :doc:`/cookbook/email/dev_environment`
  * :doc:`/cookbook/email/spool`

* **Testing**

  * :doc:`/cookbook/testing/http_authentication`
  * :doc:`/cookbook/testing/insulating_clients`
  * :doc:`/cookbook/testing/profiling`
  * :doc:`/cookbook/testing/doctrine`

* **Security**

  * :doc:`/cookbook/security/remember_me`
  * :doc:`/cookbook/security/voters`
  * :doc:`/cookbook/security/acl`
  * :doc:`/cookbook/security/acl_advanced`
  * :doc:`/cookbook/security/force_https`
  * :doc:`/cookbook/security/form_login`
  * :doc:`/cookbook/security/securing_services`
  * :doc:`/cookbook/security/entity_provider`
  * :doc:`/cookbook/security/custom_provider`
  * :doc:`/cookbook/security/custom_authentication_provider`

* **Caching**

  * :doc:`/cookbook/cache/varnish`

* **Templating**

  * :doc:`/cookbook/templating/global_variables`
  * :doc:`/cookbook/templating/PHP`

* **Tools, Logging and Internals**

  * :doc:`/cookbook/tools/autoloader`
  * :doc:`/cookbook/tools/finder`
  * :doc:`/cookbook/console`
  * :doc:`/cookbook/debugging`
  * :doc:`/cookbook/logging/monolog`

* **Web Services**

  * :doc:`/cookbook/web_services/php_soap_extension`

* **Extending Symfony**

  * :doc:`/cookbook/event_dispatcher/class_extension`
  * :doc:`/cookbook/event_dispatcher/method_behavior`
  * :doc:`/cookbook/request/mime_type`
  * :doc:`/cookbook/profiler/data_collector`

* **Symfony2 for symfony1 Users**

  * :doc:`/cookbook/symfony1`
