/*
 * Decompiled with CFR 0.152.
 */
package net.tootallnate.websocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.BlockingQueue;
import net.tootallnate.websocket.WebSocketListener;

public final class WebSocket {
    public static final int DEFAULT_PORT = 80;
    public static final String UTF8_CHARSET = "UTF-8";
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte START_OF_FRAME = 0;
    public static final byte END_OF_FRAME = -1;
    private final SocketChannel socketChannel;
    private boolean handshakeComplete;
    private WebSocketListener wsl;
    private ByteBuffer buffer;
    private ByteBuffer socketBuffer;
    private ByteBuffer remoteHandshake;
    private ByteBuffer currentFrame;
    private BlockingQueue<ByteBuffer> bufferQueue;
    private Object bufferQueueMutex = new Object();
    private boolean readingState = false;

    WebSocket(SocketChannel socketChannel, BlockingQueue<ByteBuffer> blockingQueue, WebSocketListener webSocketListener) {
        this.socketChannel = socketChannel;
        this.bufferQueue = blockingQueue;
        this.handshakeComplete = false;
        this.currentFrame = null;
        this.remoteHandshake = null;
        this.socketBuffer = ByteBuffer.allocate(8192);
        this.buffer = ByteBuffer.allocate(1);
        this.wsl = webSocketListener;
    }

    void handleRead() throws IOException, NoSuchAlgorithmException {
        int n = -1;
        try {
            this.socketBuffer.rewind();
            n = this.socketChannel.read(this.socketBuffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == -1) {
            this.close();
        } else if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.buffer.rewind();
                this.buffer.put(this.socketBuffer.get(i));
                this.buffer.rewind();
                if (!this.handshakeComplete) {
                    this.recieveHandshake();
                    continue;
                }
                this.recieveFrame();
            }
        }
    }

    public void close() throws IOException {
        this.socketChannel.close();
        this.wsl.onClose(this);
    }

    public boolean send(String string) throws IOException {
        if (!this.handshakeComplete) {
            throw new NotYetConnectedException();
        }
        if (string == null) {
            throw new NullPointerException("Cannot send 'null' data to a WebSocket.");
        }
        byte[] byArray = string.getBytes(UTF8_CHARSET);
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + 2);
        byteBuffer.put((byte)0);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)-1);
        byteBuffer.rewind();
        if (this.handleWrite()) {
            this.socketChannel.write(byteBuffer);
        }
        if (byteBuffer.remaining() > 0) {
            if (!this.bufferQueue.offer(byteBuffer)) {
                throw new IOException("Buffers are full, message could not be sent to" + this.socketChannel.socket().getRemoteSocketAddress());
            }
            return false;
        }
        return true;
    }

    boolean hasBufferedData() {
        return !this.bufferQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleWrite() throws IOException {
        Object object = this.bufferQueueMutex;
        synchronized (object) {
            ByteBuffer byteBuffer = (ByteBuffer)this.bufferQueue.peek();
            while (byteBuffer != null) {
                this.socketChannel.write(byteBuffer);
                if (byteBuffer.remaining() > 0) {
                    return false;
                }
                this.bufferQueue.poll();
                byteBuffer = (ByteBuffer)this.bufferQueue.peek();
            }
            return true;
        }
    }

    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    private void recieveFrame() {
        byte by = this.buffer.get();
        if (by == 0 && !this.readingState) {
            this.currentFrame = null;
            this.readingState = true;
        } else if (by == -1 && this.readingState) {
            this.readingState = false;
            String string = null;
            if (this.currentFrame != null) {
                try {
                    string = new String(this.currentFrame.array(), UTF8_CHARSET);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    string = "";
                }
            }
            this.wsl.onMessage(this, string);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate((this.currentFrame != null ? this.currentFrame.capacity() : 0) + this.buffer.capacity());
            if (this.currentFrame != null) {
                this.currentFrame.rewind();
                byteBuffer.put(this.currentFrame);
            }
            byteBuffer.put(by);
            this.currentFrame = byteBuffer;
        }
    }

    private void recieveHandshake() throws IOException, NoSuchAlgorithmException {
        ByteBuffer byteBuffer = ByteBuffer.allocate((this.remoteHandshake != null ? this.remoteHandshake.capacity() : 0) + this.buffer.capacity());
        if (this.remoteHandshake != null) {
            this.remoteHandshake.rewind();
            byteBuffer.put(this.remoteHandshake);
        }
        byteBuffer.put(this.buffer);
        this.remoteHandshake = byteBuffer;
        byte[] byArray = this.remoteHandshake.array();
        if (byArray.length >= 20 && byArray[byArray.length - 20] == 13 && byArray[byArray.length - 19] == 10 && byArray[byArray.length - 18] == 13 && byArray[byArray.length - 17] == 10) {
            this.completeHandshake(new byte[]{byArray[byArray.length - 16], byArray[byArray.length - 15], byArray[byArray.length - 14], byArray[byArray.length - 13], byArray[byArray.length - 12], byArray[byArray.length - 11], byArray[byArray.length - 10], byArray[byArray.length - 9], byArray[byArray.length - 8], byArray[byArray.length - 7], byArray[byArray.length - 6], byArray[byArray.length - 5], byArray[byArray.length - 4], byArray[byArray.length - 3], byArray[byArray.length - 2], byArray[byArray.length - 1]});
        } else if (byArray.length >= 12 && byArray[byArray.length - 12] == 13 && byArray[byArray.length - 11] == 10 && byArray[byArray.length - 10] == 13 && byArray[byArray.length - 9] == 10 && new String(this.remoteHandshake.array(), UTF8_CHARSET).contains("Sec-WebSocket-Key1")) {
            this.completeHandshake(new byte[]{byArray[byArray.length - 8], byArray[byArray.length - 7], byArray[byArray.length - 6], byArray[byArray.length - 5], byArray[byArray.length - 4], byArray[byArray.length - 3], byArray[byArray.length - 2], byArray[byArray.length - 1]});
        } else if (byArray.length >= 4 && byArray[byArray.length - 4] == 13 && byArray[byArray.length - 3] == 10 && byArray[byArray.length - 2] == 13 && byArray[byArray.length - 1] == 10 && !new String(this.remoteHandshake.array(), UTF8_CHARSET).contains("Sec") || byArray.length == 23 && byArray[byArray.length - 1] == 0) {
            this.completeHandshake(null);
        }
    }

    private void completeHandshake(byte[] byArray) throws IOException, NoSuchAlgorithmException {
        byte[] byArray2 = this.remoteHandshake.array();
        String string = new String(byArray2, UTF8_CHARSET);
        this.handshakeComplete = true;
        if (this.wsl.onHandshakeRecieved(this, string, byArray)) {
            this.wsl.onOpen(this);
        } else {
            this.close();
        }
    }
}

