# Results for v1.0.0

<!-- TOC -->
- [Results for v1.0.0](#results-for-v100)
  - [Versions](#versions)
  - [Tests](#tests)
    - [Scale Listeners](#scale-listeners)
    - [Scale HTTPS Listeners](#scale-https-listeners)
    - [Scale HTTPRoutes](#scale-httproutes)
    - [Scale Upstream Servers](#scale-upstream-servers)
    - [Scale HTTP Matches](#scale-http-matches)
  - [Future Improvements](#future-improvements)
<!-- TOC -->

## Versions

NGF - version from https://github.com/nginx/nginx-gateway-fabric/pull/1151

with NGINX:

```text
nginx/1.25.2
built by gcc 12.2.1 20220924 (Alpine 12.2.1_git20220924-r10)
OS: Linux 5.15.109+
```

Kubernetes:

```text
Server Version: version.Info{Major:"1", Minor:"27",
GitVersion:"v1.27.6-gke.1445000",
GitCommit:"85a90ed8e702b392003d6757917e4cc167776e03",
GitTreeState:"clean", BuildDate:"2023-09-21T22:16:57Z",
GoVersion:"go1.20.8 X:boringcrypto", Compiler:"gc",
Platform:"linux/amd64"}
```

## Tests

### Scale Listeners

Reloads:

| Total | Total Errors | Ave Time (ms)      | <= 500ms |
|-------|--------------|--------------------|----------|
| 128   | 0            | 134.69505494505492 | 100%     |


Event Batch Processing:

| Total | Ave Time (ms)      | <= 500ms | <= 1000ms |
|-------|--------------------|----------|-----------|
| 398   | 218.22692307692304 | 93.22%   | 100%      |

**NGINX Errors**: None.

**NGF Errors**: None.

**Pod Restarts**: None.

**CPU**: ![CPU.png](/tests/scale/results/1.0.0/TestScale_Listeners/CPU.png).

**Memory**: ![Memory.png](/tests/scale/results/1.0.0/TestScale_Listeners/Memory.png).

**Time To Ready**: ![TTR.png](/tests/scale/results/1.0.0/TestScale_Listeners/TTR.png).

### Scale HTTPS Listeners

Reloads:

| Total | Total Errors | Ave Time (ms)      | <= 500ms |
|-------|--------------|--------------------|----------|
| 128   | 0            | 153.67699221223148 | 100%     |


Event Batch Processing:

| Total | Ave Time (ms)      | <= 500ms | <= 1000ms | <= 5000ms |
|-------|--------------------|----------|-----------|-----------|
| 457   | 201.60030046204622 | 91.69%   | 99.78%    | 100%      |


**NGINX Errors**: None.

**NGF Errors**: None.

**Pod Restarts**: None.

**CPU**: ![CPU.png](/tests/scale/results/1.0.0/TestScale_HTTPSListeners/CPU.png).

**Memory**: ![Memory.png](/tests/scale/results/1.0.0/TestScale_HTTPSListeners/Memory.png).

**Time To Ready**: ![TTR.png](/tests/scale/results/1.0.0/TestScale_HTTPSListeners/TTR.png).

### Scale HTTPRoutes

Reloads:

| Delay     | Total | Total Errors | Ave Time (ms)     | <= 500ms | <= 1000ms |
|-----------|-------|--------------|-------------------|----------|-----------|
| 2 seconds | 1001  | 0            | 341.7087396702501 | 83.32%   | 100%      |
| No delay  | 1001  | 0            | 369.2821023173991 | 75.72%   | 100%      |


Event Batch Processing:

| Delay     | Total | Ave Time           | <= 500ms | <= 1000ms |
|-----------|-------|--------------------|----------|-----------|
| 2 seconds | 2089  | 192.62227561490883 | 86.21%   | 100%      |
| No delay  | 2082  | 206.68062489354992 | 83.43%   | 100%      |


**NGINX Errors**: None.

**NGF Errors**: None.

**Pod Restarts**: None.

**CPU**:

2-sec delay:
![CPU.png](/tests/scale/results/1.0.0/TestScale_HTTPRoutes/CPU.png).

No delay:
![CPU.png](/tests/scale/results/1.0.0/TestScale_HTTPRoutes/CPU-no-delay.png).

**Memory**:

2-sec delay:
![Memory.png](/tests/scale/results/1.0.0/TestScale_HTTPRoutes/Memory.png).

No delay:
![Memory.png](/tests/scale/results/1.0.0/TestScale_HTTPRoutes/Memory-no-delay.png).

**TTR**:

Combined:
![TTR.png](/tests/scale/results/1.0.0/TestScale_HTTPRoutes/TTR.png)


Issue Filed: [Improve HTTPRoute Processing at Scale](https://github.com/nginx/nginx-gateway-fabric/issues/1122).

### Scale Upstream Servers

| Start Time (UNIX) | End Time (UNIX) | Duration (s) |
|-------------------|-----------------|--------------|
| 1697516151        | 1697516255      | 104          |

Reloads:

| Total | Total Errors | Ave Time (ms)      | <= 500ms |
|-------|--------------|--------------------|----------|
| 116   | 0            | 125.35251106285726 | 100%     |

Event Batch Processing:

| Total | Ave Time (ms)      | <=500ms | <= 1000ms | <= 5000ms |
|-------|--------------------|---------|-----------|-----------|
| 122   | 241.95484032851115 | 97.54%  | 98.36%    | 100%      |

**NGINX Errors**: None.

**NGF Errors**: None.

**Pod Restarts**: None.

**CPU**: ![CPU.png](/tests/scale/results/1.0.0/TestScale_UpstreamServers/CPU.png).

**Memory**: ![Memory.png](/tests/scale/results/1.0.0/TestScale_UpstreamServers/Memory.png).

### Scale HTTP Matches

**Results for the first match**:

```text
Running 30s test @ http://cafe.example.com
2 threads and 10 connections
Thread Stats   Avg      Stdev     Max       +/- Stdev
Latency       47.64ms   13.87ms   217.49ms   97.52%
Req/Sec      107.84     17.47     151.00     79.76%
6410 requests in 30.09s, 0.95MB read
Requests/sec: 213.02
Transfer/sec: 32.24KB
```

**Results for the last match**:

```text
Running 30s test @ http://cafe.example.com
2 threads and 10 connections
Thread Stats   Avg       Stdev     Max      +/- Stdev
Latency       47.10ms    13.59ms  301.73ms   98.57%
Req/Sec       108.01     12.55    150.00     84.62%
6459 requests in 30.10s, 0.95MB read
Requests/sec:  214.61
Transfer/sec:  32.49KB
```

**Findings**:

- There's not a noticeable difference between the response times for the first match and last match. In
fact, the latency of the last match is slightly lower than the latency of the first match.
- If you add one more match to the [manifest](/tests/scale/manifests/scale-matches.yaml) NGINX will fail to reload
  because the generate `http_matches` variable is too long.

Issue Filed: https://github.com/nginx/nginx-gateway-fabric/issues/1107

## Future Improvements

- Check that the statuses of the Gateway API resources are updated after each scaling event.
- Measure the time it takes for NGF to update the status of the Gateway API resources after creating or updating the resources.
- Record the reload time distributions per bucket after each test.
