# Results

## Test environment

NGINX Plus: false

NGINX Gateway Fabric:

- Commit: 9fbef714ea22a35c4f1a8c97bd5b4e406ae0c1e9
- Date: 2025-10-21T10:57:37Z
- Dirty: false

GKE Cluster:

- Node count: 12
- k8s version: v1.33.5-gke.1080000
- vCPUs per node: 16
- RAM per node: 65851524Ki
- Max pods per node: 110
- Zone: us-west1-b
- Instance Type: n2d-standard-16

## Summary:

- 2.2.0 shows meaningful improvements in configuration reliability with ~46% fewer errors, though at the cost of slightly more event processing overhead for dynamic resource creation.

### Key Findings
- Test 1 Improvements (Pre-existing Resources):
  - Faster time to ready for both 30 and 150 resources
  - No configuration errors in either version
  - Stable event batch processing
- Test 2 Mixed Results (Dynamic Resources):
  - Slight time increase for 30 resources (+1s)
  - Nearly identical time for 150 resources (-1s)
  - More event batches in 2.2.0 (15-8% increase)
  - Slower average processing (+63.6% for 30, +5.9% for 150)
  - Significantly fewer errors (-33% for 30, -46% for 150)
- Configuration Error Improvements:
  - 46% reduction in NGINX errors for 150 resources
  - No duplicate upstream errors in 2.2.0
  - Cleaner error pattern (only EOF and pread issues)
  - Jumbled configuration issue still present but reduced

### Positive Changes:
- Better handling of pre-existing resources (faster startup)
- Significantly fewer configuration errors during dynamic resource creation
- Eliminated certain error types (invalid zone directive, duplicate upstream)

### Concerns:
- Increased event batch count suggests more reconciliation loops
- Slower average processing time for dynamic resources
- Jumbled configuration issue seen in 2.1.0 still exists but is less severe

## Test 1: Resources exist before startup - NumResources 30

### Time to Ready

Time To Ready Description: From when NGF starts to when the NGINX configuration is fully configured
- TimeToReadyTotal: 14s

### Event Batch Processing

- Event Batch Total: 10
- Event Batch Processing Average Time: 3ms
- Event Batch Processing distribution:
	- 500.0ms: 10
	- 1000.0ms: 10
	- 5000.0ms: 10
	- 10000.0ms: 10
	- 30000.0ms: 10
	- +Infms: 10

### NGINX Error Logs

## Test 1: Resources exist before startup - NumResources 150

### Time to Ready

Time To Ready Description: From when NGF starts to when the NGINX configuration is fully configured
- TimeToReadyTotal: 19s

### Event Batch Processing

- Event Batch Total: 9
- Event Batch Processing Average Time: 9ms
- Event Batch Processing distribution:
	- 500.0ms: 9
	- 1000.0ms: 9
	- 5000.0ms: 9
	- 10000.0ms: 9
	- 30000.0ms: 9
	- +Infms: 9

### NGINX Error Logs

## Test 2: Start NGF, deploy Gateway, wait until NGINX agent instance connects to NGF, create many resources attached to GW - NumResources 30

### Time to Ready

Time To Ready Description: From when NGINX receives the first configuration created by NGF to when the NGINX configuration is fully configured
- TimeToReadyTotal: 25s

### Event Batch Processing

- Event Batch Total: 356
- Event Batch Processing Average Time: 18ms
- Event Batch Processing distribution:
	- 500.0ms: 355
	- 1000.0ms: 356
	- 5000.0ms: 356
	- 10000.0ms: 356
	- 30000.0ms: 356
	- +Infms: 356

### NGINX Error Logs
2025/10/21 15:57:24 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:282
2025/10/21 15:57:24 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:484
2025/10/21 15:57:29 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:3349
2025/10/21 15:57:30 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:3488

## Test 2: Start NGF, deploy Gateway, wait until NGINX agent instance connects to NGF, create many resources attached to GW - NumResources 150

### Time to Ready

Time To Ready Description: From when NGINX receives the first configuration created by NGF to when the NGINX configuration is fully configured
- TimeToReadyTotal: 127s

### Event Batch Processing

- Event Batch Total: 1575
- Event Batch Processing Average Time: 18ms
- Event Batch Processing distribution:
	- 500.0ms: 1572
	- 1000.0ms: 1575
	- 5000.0ms: 1575
	- 10000.0ms: 1575
	- 30000.0ms: 1575
	- +Infms: 1575

### NGINX Error Logs
2025/10/21 16:01:53 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:2872
2025/10/21 16:01:58 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:5099
2025/10/21 16:01:59 [emerg] 8#8: pread() returned only 0 bytes instead of 4095 in /etc/nginx/conf.d/http.conf:2071
2025/10/21 16:02:01 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:6884
2025/10/21 16:02:02 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:7122
2025/10/21 16:02:03 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:8346
2025/10/21 16:02:04 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:8507
2025/10/21 16:02:04 [emerg] 8#8: pread() returned only 0 bytes instead of 4085 in /etc/nginx/conf.d/http.conf:5599
2025/10/21 16:02:05 [emerg] 8#8: pread() returned only 0 bytes instead of 4095 in /etc/nginx/conf.d/http.conf:6258
2025/10/21 16:02:07 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:10627
2025/10/21 16:02:09 [emerg] 8#8: pread() returned only 0 bytes instead of 4093 in /etc/nginx/conf.d/http.conf:5594
2025/10/21 16:02:10 [emerg] 8#8: pread() returned only 0 bytes instead of 4087 in /etc/nginx/conf.d/http.conf:5758
2025/10/21 16:02:11 [emerg] 8#8: pread() returned only 0 bytes instead of 4095 in /etc/nginx/conf.d/http.conf:4606
2025/10/21 16:02:12 [emerg] 8#8: unexpected end of file, expecting "}" in /etc/nginx/conf.d/http.conf:2823
2025/10/21 16:02:12 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:7890
2025/10/21 16:02:14 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:15203
2025/10/21 16:02:15 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:15528
2025/10/21 16:02:15 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:15646
2025/10/21 16:02:16 [emerg] 8#8: pread() returned only 0 bytes instead of 4092 in /etc/nginx/conf.d/http.conf:7977
2025/10/21 16:02:18 [emerg] 8#8: pread() returned only 0 bytes instead of 4095 in /etc/nginx/conf.d/http.conf:16349
2025/10/21 16:02:18 [emerg] 8#8: unexpected end of file, expecting ";" or "}" in /etc/nginx/conf.d/http.conf:17767
