NG_DOCS={
  "sections": {
    "api": "API Documentation"
  },
  "pages": [
    {
      "section": "api",
      "id": "patternfly.autofocus:pfFocused",
      "shortName": "pfFocused",
      "type": "directive",
      "moduleName": "patternfly",
      "shortDescription": "The focus on element is evaluated from given expression. If the expression provided as an attribute to this directive",
      "keywords": "api attribute autofocus box checkbox checking class col-sm-10 col-sm-2 control-label directive element evaluated expression focus focused form-control form-group form-horizontal html i1 i2 input isfocus module ng-model patternfly pf-focused pffocused placeholder provided selected true type"
    },
    {
      "section": "api",
      "id": "patternfly.canvas.component:pfCanvas",
      "shortName": "pfCanvas",
      "type": "directive",
      "moduleName": "patternfly.canvas",
      "shortDescription": "Component for core operations and rendering of a canvas. Does not work in IE 11 or lower because they do not support",
      "keywords": "$broadcast $emit $on $scope $window action actioniconclicked actions additional addnode advanced angular api appear args argument arguments array background background-image background-repeat backgroundcolor browsers bundle canvas canvas-demo-container canvasdemoctrl characters chart chart-data-model chart-view-model chartdatamodel chartviewmodel checkbox checkbox-inline chrome class click clicking col-md-12 color component connect connection connections connector connectorindex connectors container controller copy core currently data define defined defines deleted deleteselected demo deselectall dest destination details directive edit endpoints equals event eventtext example-container fa fa-share-alt fa-tag false family fff firefox flag font font-weight fontawesome fontcontent fontfamily fontsize foreignobject form-group function getselectednodes helper hidden hide-connectors hideconnectors html icon iconclass identifier image image_path imagepath img increment indicating initialized input inputconnectors isonlyonenodeselected items js key latest left list-style-type listen listens log lower main margin-left methods mode module modules mouse moved ms-edge netapp network newnode ng-click ng-controller ng-model node nodeactionclicked nodeactionclosed nodeactionconnect nodeactionedit nodeactions nodeactiontag nodeid nodes note nuage numnewnodes object objects openshift operations output padding-top parameters passed passes patternfly patternflyicons-webfont pf pficon-edit pficon-service place plan png read-only readonly rectangle rendering repeat rows script selectall selected side single size source specification starts storage string style subsequent support svg tag tested toolbar top true type types unicode url user valid validconnectiontypes var vmware width work x-coordinate y-coordinate zoomin zoomout"
    },
    {
      "section": "api",
      "id": "patternfly.canvas.component:pfCanvasEditor",
      "shortName": "pfCanvasEditor",
      "type": "directive",
      "moduleName": "patternfly.canvas",
      "shortDescription": "Component for canvas editor which adds a toolbox where items can be dragged and dropped onto canvas, as well as other canvas",
      "keywords": "$filter $on $scope $window action active additional addnode adds angular api areanynodesselected args array background-image background-repeat backgroundcolor basename basenamelength blur bottom bundle canvas canvaseditor canvaseditordemoctrl changes chart chart-data-model chart-view-model chartdatamodel chartviewmodel checkbox checkbox-inline chrome class col-md-12 component connect connections connectorindex container controller copy copyname data defines delete deleted deletenodes deleteselected demo dest detailed directive disabled dragged dropped duplicate duplicated duplicatednode duplicateitem duplicatenode duplicateselectednode duplicating edit editor element eventtext example-container existing fa fa-cloud fa-copy fa-share-alt fa-tag false fff filter filteredarray firefox flag floor font-weight fontawesome fontcontent fontfamily fontsize foreignobject form-group function getcopyname getselectednodes helper hidden hide html icon iconclass image image_path imagepath img inconnectingmode indexof indicating initialized inputconnectors isonlyonenodeselected item items js latest length levels list-style-type lower main math methods mode module modules more-actions moved ms-edge nested netapp network ng-class ng-click ng-controller ng-if ng-model node nodeactionclicked nodeactionconnect nodeactionedit nodeactions nodeactiontag nodeid nodes note nuage number object objects openshift openstack operations padding-top patternfly patternflyicons-webfont pf pficon pficon-delete pficon-edit pficon-network pficon-replicator pficon-service pficon-storage-domain pficon-virtual-machine png pretitle random read-only readonly remove repeat replicatore return rows script selected small source specification storage style substr subtabs support supports svg tab tabs tag test tested three title toolbar toolbox toolbox-tabs toolboxtabs tooltip-append-to-body tooltip-placement true type uib-tooltip updated url validconnectiontypes var vm vmware width work zoom"
    },
    {
      "section": "api",
      "id": "patternfly.card.component:pfAggregateStatusCard",
      "shortName": "pfAggregateStatusCard",
      "type": "directive",
      "moduleName": "patternfly.card",
      "shortDescription": "Component for easily displaying status information",
      "keywords": "$scope $timeout $window adipiscing aggregate aggstatusalt aggstatusalt2 alt-layout alternate alternative angular api array border card carddemoctrl class clicks col-lg-4 col-md-5 col-sm-6 col-xs-12 component configuration container-fluid controller count counts data dataloading depreciated directive display displaying displays easily equals fa fa-shield false function height hides href html icon iconclass iconimage icons image image_path imagepath img js layout layouts left list-style-type loading main mini miniaggstatus miniaggstatus2 module navigate ng-controller nodes normal note notification notifications number object param patternfly pficon pficon-cluster pficon-container-node pficon-error-circle-o pficon-ok pficon-warning-triangle-o providers row script set show-spinner show-top-border showspinner single spinner spinner-card-height spinner-text spinnercardheight spinnertext status status2 statuses style svg tall text title top true var"
    },
    {
      "section": "api",
      "id": "patternfly.card.component:pfCard - Timeframe Filters",
      "shortName": "pfCard - Timeframe Filters",
      "type": "directive",
      "moduleName": "patternfly.card",
      "shortDescription": "Component for easily displaying a card with html content",
      "keywords": "$scope $timeout alert angular api appear array based blue border bottom call callback callbackfn called card chartctrl charts class clicked component configuration content contents controller dataloading days defaultfilter defined demo directive displaying drop dropdown easily events fa fa-flag false filter filterconfig filterconfigheader filters fn footer footerconfig function grey head-title header headtitle hides href html icon iconclass integer items js label label-title left link list-style-type loading module navigate ng-controller panel patternfly position properties script selected set show-spinner show-top-border showspinner showtitlesseparator showtopborder spinner spinner-text spinnertext style sub-title subtitle text timeframe title today top true user view width"
    },
    {
      "section": "api",
      "id": "patternfly.card.component:pfCard - Trends",
      "shortName": "pfCard - Trends",
      "type": "directive",
      "moduleName": "patternfly.card",
      "shortDescription": "Component for easily displaying a card with html content",
      "keywords": "$scope $timeout actionbarconfig actual add alert angular api array based blue border bottom call callback callbackfn called capacity card chart-data chartctrl chartid charts class clicked cluster compact compactlabelposition component config configmemory configphysical configrightlabel configsingle configuration configvirtual content controller d-- data dataloading datamemory dataphysical datasingle datavirtual dates days defaultfilter defined demo directive disk displaying drop easily events example2trendschart examplerightlabeltrendschart fa fa-flag fa-plus-circle false filter filterconfig filters fn footer footerconfig function gb gettime grey head-title headtitle height hides href html icon iconclass inline integer items js label label-title layout left link list-style-type loading memory memorytrendschart mhz module multiple navigate ng-controller panel patternfly percentage performance physical physicaltrendschart properties push script selected set show-spinner show-titles-separator show-top-border showspinner showtitlesseparator showtopborder single spinner spinner-text spinnercardheight spinnertext storage style sub-title subtitle tb text title today tooltiptype top total trend trendlabel trends true units user utilization valuetype var view virtual virtualtrendschart width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.card.component:pfCard - Utilization",
      "shortName": "pfCard - Utilization",
      "type": "directive",
      "moduleName": "patternfly.card",
      "shortDescription": "Component for easily displaying a card with html content",
      "keywords": "$scope $timeout angular api array bars based blue border bottom call callbackfn called card chart-data chart-title chartctrl charts class clicked component configuration content controller cpu data2 data3 data4 data5 dataloading days defaultfilter defined demo directive disk displaying drop easily false filter filters footer function gb grey head-title headtitle hides href html icon iconclass inline integer items js label-title layout layoutinline left link list-style-type loading memory mhz module multiple navigate ng-controller panel patternfly properties resources script selected show-spinner show-top-border showspinner showtitlesseparator showtopborder spinner spinner-text spinnertext style sub-title subtitle system tb text threshold-error threshold-warning title title2 title3 title4 title5 today top total true type units units2 units3 units4 units5 usage user utilization"
    },
    {
      "section": "api",
      "id": "patternfly.card.component:pfInfoStatusCard",
      "shortName": "pfInfoStatusCard",
      "type": "directive",
      "moduleName": "patternfly.card",
      "shortDescription": "Component for easily displaying textual information",
      "keywords": "$scope $timeout $window aapdemo002 accepts address allow angular api array border card carddemoctrl class clicks col-lg-4 col-md-5 col-sm-6 col-xs-12 component configuration container-fluid content controller core count cpu data dataloading directive display displaying drift easily element fa fa-coffee fa-heart fa-motorcycle fa-shield false favorite flag function height hides history host href html html-content htmlcontent icon iconclass iconimage image image_path imagepath img infastructure info infostatus infostatus2 infostatusalt infostatustitless infrastructure ip js left list-style-type loading localdomian localhost main mb module navigate ng-controller options patternfly power row script set show-spinner show-top-border showspinner snapshots socket spinner spinner-card-height spinner-text spinnercardheight spinnertext status strings style svg text textual things tinycore-local title top true var vm vmware"
    },
    {
      "section": "api",
      "id": "patternfly.charts.component:pfC3Chart",
      "shortName": "pfC3Chart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Component for wrapping c3 library",
      "keywords": "$scope add angular api application bind button c3 c3chartdefaults callback called chart chartconfig chartctrl chartid charts class columns component config configuration console container controller data default dependency directive donut focus focusused form form-control form-group function generated get-chart-callback getchart getchartcallback getdefaultdonutconfig groups html js library log mhz module newused ng-click ng-controller ng-model note null object options order patternfly role script set style submitform text total type updateavailable user val width wrapping"
    },
    {
      "section": "api",
      "id": "patternfly.charts.component:pfDonutChart",
      "shortName": "pfDonutChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Component for rendering a donut chart which shows the relationships of a set of values to a whole.  When using a",
      "keywords": "$interval $scope alert angular animals api arc array blue c3 categories cats cc0000 center centerlabelfn chart chart-height chartctrl chartheight chartid chartone charts charttwo class clicked col-md-6 colors component config configuration container-fluid controller copy custconfig customize data defined directive dogs donut ec7a08 fish full function green hamsters handle height html http js key label legend list list-style-type module ng-controller number onclickfn options orange org patternfly pets position properties red relationship relationships rendering representing return row script set string style text text-center title unique user values"
    },
    {
      "section": "api",
      "id": "patternfly.charts.component:pfDonutPctChart",
      "shortName": "pfDonutPctChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Component for rendering a percentage used donut/radial chart.  The Used Percentage fill starts at 12 o’clock and",
      "keywords": "$interval $scope accessed alert amount angular api arc availchart availconfig availdata availlabel blue c3 calculate calculated callback camelcase center center-label centerlabelfn change chart chart-height chartctrl charterr chartheight chartid chartnothresh chartok charts chartwarn checkbox checkbox-inline class click clicked clockwise col-md-12 col-md-3 col-md-4 color colors component config configdynamic configerr configlabel confignothresh configorientationcenter configorientationleft configorientationright configuration configwarn container-fluid contents controller custchart custchartheight custconfig custdata customize data dataavailable datadynamic dataerr datanothresh dataorientationcenter dataorientationleft dataorientationright datawarn default defined demo dependent determine directive display displays donut donut-tooltip-pf empty error exist external fill flag form form-group format full function gb gray grey handle handling height hovering html http indicator ipsum js label labelconfig labeldynamic labelfn left legend list list-style-type lorem mhz module moves ng-controller ng-model nolabel nonechart noneconfig nonedata nowrap number object on-threshold-change onclickfn options orange org orientation parameter passed patternfly pctchart pctconfig pctdata pctlabel percent percentage portion prefix properties radial red rendered rendering represented representing return returns role row script segments set size specifies start starts string style surpassed text text-center text-left text-right three threshlabel threshold thresholdchanged thresholds thresolds title tool tooltip tooltipamount tooltipboth tooltipfn tooltop total true type undefined unique unit units updated usage usedchart usedconfig useddata usedlabel user values warning white-space width wording"
    },
    {
      "section": "api",
      "id": "patternfly.charts.component:pfLineChart",
      "shortName": "pfLineChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Component for rendering a line chart.",
      "keywords": "$scope adddatapoint angular api area array arrays axis bind blue c3 chart chart-data chartctrl chartdata chartid charts checkbox checkbox-inline class col-md-12 col-md-3 col-md-6 color colorpalette component config configuration container contents controller created custareachart custshowxaxis custshowyaxis d-- data dataavailable dates default deleted directive display element elements exampleline exist false form form-group full function functions gb generation gettime green grid html http js label legend length list list-style-type markup mhz module ng-click ng-controller ng-model optional options org override overrides patternfly pfutils point points properties push random rendering resetdata return role round row script second set-area-chart setareachart setting settings show-x-axis show-y-axis showing showxaxis showyaxis size style today tooltip tooltipfn tooltiptype true type unit units values var width xdata ydata ydata0 ydata1"
    },
    {
      "section": "api",
      "id": "patternfly.charts.component:pfSparklineChart",
      "shortName": "pfSparklineChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Component for rendering a sparkline chart.",
      "keywords": "$scope adddatapoint amount angular api area array axis bind c3 chart chart-data chart-height chartctrl chartdata chartheight chartid charts checkbox checkbox-inline class col-md-12 col-md-3 col-md-6 color component config configuration container contents controller current custchartheight custshowxaxis custshowyaxis d-- data dataavailable dates day default determining directive display element examplesparkline false flag form form-group full function functions gb generation gettime height html http js label legend length list list-style-type markup mhz module ng-click ng-controller ng-model number options org override overrides patternfly percent percentage percentages point points properties push radio radio-inline random rendering return role round row script set setting settings show-x-axis show-y-axis showing showxaxis showyaxis size sparkline style today tooltip tooltipfn tooltiptype total true type unit units usageperday valid valueperday values var width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.charts.component:pfTopology",
      "shortName": "pfTopology",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Component for rendering a topology chart.  Individual nodes and relationships can be represented with this view.  CSS is especially important for rendering the nodes and lines.  The example inline contains specific examples that can be used to change the icon size and the line type of the relationships.",
      "keywords": "$rootscope $scope addition angular api appropriate argument associated attribute availabilityzone behavior beneath boolean button change changes chart chartrendered charts checkbox circle class color component configuration container container-topology container10r235 container10r236 containergroup containergroup10r240 containergroup10r241 containergroupcontainerreplicator containergroupcontainerservice containermanager containermanager10r20 containernode containernode10r14 containerreplicator containerreplicator10r56 containerreplicator10r57 containerreplicatorcontainergroup containerroute containerservice containerservice10r61 containerservicecontainergroup containerservicecontainerroute controller controls correctly correspond creating css d3 data datasets default delete determines differentiate directive dispatched display display_kind displayed docker-registry docker-registry-2 docker-registry-2-vrguw element elements enabled error event example examples ff7f0e fill filtering font-family font-size fontawesome fontfamily force function general getelementbyid glyph grouping height highlights host html icon icons implementation individual inline input item item-selected items itemselected js key kind kinds kubernetes label labels lables layout lines list-style-type matching metadata miq_id module ng-click ng-controller ng-model node nodekinds nodes object ocp-master openshiftenterprise optional overwrite passed patternfly patternflyicons-webfont pf-topology-svg pod prevent preventdefault push radius ready registry relations relationships remove removekind rendering replicationcontroller replicationcontrollerpod replicator representations represented represents return round running script search search-text searching searchtext select selected selection service set sets show-labels showlabels sink size source specific started status statuses stroke-dasharray stroke-linecap style styles supported target text textx texty title tooltip tooltip-function tooltipfunction topology topologyctrl true tweaks type types unique unknown updated usual valid values var view visibility vm watched width"
    },
    {
      "section": "api",
      "id": "patternfly.charts.component:pfTopologyMap",
      "shortName": "pfTopologyMap",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Component for rendering topology chart on Canvas element. This is just a simple component. It has no searching/filtering or other methods. Will only render given data and return data about selected objects.",
      "keywords": "$apply $rootscope $scope abby ad1457 alyce angular annabelle api arial arlene array attribute attributes aurelia avaliable background barron barton benita berg bettie beverly blabla border bordercolor butler calhoun canvas carpenter celina changedata charles chart charts checkbox class clicking code coleman color component container-topology controller cooke css currently cursor dashed data davis deborah decker default dennis directive distance dudley edge edges element fa fa-cog fa-info false ff0000 file fileicon fill fitzpatrick font fonticon frank fuentes function gates glass graph gray growing hammond harper harrell harrington harrison hayden hays helen hex higher hobbs holding holly hopper horn houston html http hull icon icontype identifier image ines jackie janette js julia kasey kaufman key kimberly kristy label labels lawrence leah lesley lester levy lindsay list-style-type lolita louella lynnette maddox mandatory margarita marguerite mason mcdowell methods module mona moreno morton mouse multi-select-edges multi-select-nodes multiple multiselect multiselectedges nancy natalia newman ng-click ng-controller ng-model node nodes number object objects opacity optional org parameter parker path patternfly percentage phillips png potts priority px radius remains render rendering renee representing represents return returns rgb rgba roberta robles rocha rose russell ruthie santiago script searching select-edge select-node selected selectededge selectededges selectedge selectednode selectednodes selectnode semantic show-edge-labels show-node-labels showedgelabels shownodelabels simple size snyder sonya source sparks specifies stanton stephanie string stroke style styling suarez supports svg talley tanner target taylor testnode testnode2 testnode3 text textcolor title tooltip tooltip-style tooltips tooltipstyle topology topologymapctrl type unique utilization walker wallace washington watkins white wilcox wolf woods yang zoom zooming"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfHeatMap",
      "shortName": "pfHeatMap",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Component for rendering a heatmap chart.",
      "keywords": "$scope angular api block block-padding blockpadding blocks call ce0000 chart chart-data-available chart-title chartctrl chartdataavailable charts charttitle checkbox checkbox-inline class click-action clickaction clicked col-md-3 col-md-5 colors component console controller correspond d4f0fa data dataavailable default defaults directive displayed ec7a08 example-heatmap-container f00 f9d67a flag form form-group function heapmap heatmap heatmap-color-pattern heatmapcolorpattern height highlight highlighting hightest hover html js kubernetes labels legend legend-labels legendlabels legends list-style-type log m8y max-block-size maxblocksize maximum measurement memory message minblocksize minimum module ng-controller ng-model node nodes openshift overriding padding patternfly pixels provider range range-tooltips rangehoversize rangeonhover rangetooltips rendering role row script show-legend showlegend showlegends size small style threshold thresholds title titlealt titlesmall tooltip tooltips total true type units utilization values var"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfTrendsChart",
      "shortName": "pfTrendsChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Component for rendering a trend chart. The trend chart combines overall data with a",
      "keywords": "$scope actual add adddatapoint alert amount angular api array axis bootstrap btn btn-default btn-group button c3 callback callbackfn called card caret chart chart-data chartctrl chartdata chartheight chartid charts checkbox checkbox-inline class cluster col-md-12 col-md-2 col-md-3 col-md-4 combines compact compactlabelposition component config configuration controller custshowxaxis custshowyaxis d-- data dataavailable dates days default demo directive disk display dropdown-menu-right element exampletrendschart fa fa-plus-circle false filter filterconfig filters flag fn footer footerconfig form form-group format frame full function gb gettime height html http iconclass inline item js label large latest layout layouts left length list list-style-type menu menuitem mhz minutes module network ng-class ng-click ng-controller ng-hide ng-if ng-model ng-repeat number options org override patternfly percentage pfsparklinechart point points position positioning push radio radio-inline random rendering representing role round row script selected settings show-x-axis show-y-axis showing showxaxis showyaxis sizes small sparkline style tabindex text time timeframe title titles today tooltiptype total trend trendlabel trends true type ui uib-dropdown uib-dropdown-menu uib-dropdown-toggle unique unit units updatelayout updatevaluetype utilization values valuetype valuetypes var virtual width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfUtilizationBarChart",
      "shortName": "pfUtilizationBarChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Component for rendering a utilization bar chart",
      "keywords": "$interval $scope actual alternative amount angular api arc auto-format automatic available-tooltip-function availabletooltip avaliabletooltipfunction bar behavior blue card chart chart-data chart-footer chart-title chartctrl chartdata charts checkbox checkbox-inline class col-md-6 colors component controller cpu custom data data1 data2 data3 data4 data5 dataavailable default denotes dependent directive disk displayed displays donut error example examples exist fill flag footer footer-label-format footer1 footer2 footerlabelwidth form form-group function gb html indicator inline js label label-title labels layout layoutinline layouts left-hand list-style-type mb memory mhz module ng-controller ng-model number orange overwrite passed patternfly percent percentage ram reached red regular rendering representing return right-hand role row script side smaller standard style surpassed tb three threshold threshold-error threshold-warning thresholds title title1 title2 title3 title4 title5 titlelabelwidth tooltip tooltips total true type units units1 units2 units3 units4 units5 usage used-tooltip-function usedtooltip usedtooltipfunction utilization valid values warning width"
    },
    {
      "section": "api",
      "id": "patternfly.charts.directive:pfUtilizationTrendChart",
      "shortName": "pfUtilizationTrendChart",
      "type": "directive",
      "moduleName": "patternfly.charts",
      "shortDescription": "Component for rendering a utilization trend chart. The utilization trend chart combines overall",
      "keywords": "$scope add adddatapoint amount angular api array axis c3 center center-label centerlabel chart chart-data charta chartctrl chartdata chartid charts checkbox checkbox-inline class col-md-12 col-md-3 col-md-6 combines component config configuration contents controller custchartheight custshowxaxis custshowyaxis d-- data dataavailable dates day default directive display displays donut donut-config donutcenterlabel donutconfig element error examplesparkline false flag form form-group full function gb gettime height html http js label length list list-style-type math memory mhz module newdata newdate ng-change ng-click ng-controller ng-model number options org override parameter patternfly pct percent percentage pfdonutchart pfdonutpctchart pfsparklinechart point points push radio radio-inline random rendering representing role round row script settings show-sparkline-x-axis show-sparkline-y-axis showing showsparklinexaxis showsparklineyaxis sparkline sparkline-chart-height sparkline-config sparklinechartheight sparklineconfig specifics specifies style thresholds title today tooltip tooltiptype total trend true type unit units updatedataavailable usage usageperday utilization valueperday values var warning width xdata ydata"
    },
    {
      "section": "api",
      "id": "patternfly.datepicker.componenet:pfBootstrapDatepicker",
      "shortName": "pfBootstrapDatepicker",
      "type": "directive",
      "moduleName": "patternfly.datepicker",
      "shortDescription": "A wrapper for the Angular UI datepicker.",
      "keywords": "$scope angular api boolean bottom-left componenet configuration controller date-options dateoptions datepicker datepickerpopup dates default demobootstrapdatepicker determining directive displayed element empty format format1 function github html http https input io is-open isopen jan javascript js left mm module ng-controller object open optional patternfly pf-bootstrap-datepicker popup popup-placement popupplacement position relative script second showweeks string true ui uib-datepicker wrapper"
    },
    {
      "section": "api",
      "id": "patternfly.filters.component:pfFilter",
      "shortName": "pfFilter",
      "type": "directive",
      "moduleName": "patternfly.filters",
      "shortDescription": "Component for a filter bar",
      "keywords": "$scope address allitems allow angular api apple applied appliedfilters applyfilters april array august bar bedrock birth birthmonth boulevard box call car case categories category changes checkbox checkbox-inline cincinatti class col-sm-12 col-sm-2 col-sm-3 col-sm-4 col-xs-12 col-xs-4 col-xs-6 col-xs-8 comparisons complex-select component config configuration controller corolla count crosstrek current currently december default delimiter dinosaur directive display east echo elm entered events-label example-container examplefilter false feb february field fields filter filterable filtercategories filtercategoriesplaceholder filtercategory filterchange filterconfig filterdelimiter filtermultiselect filters filterstext filtertype filtervalue filtervalues flag flintstone foreach form form-group frank fred function green hidden-xs html impreza include inline inlineresults input insensitive insensitve item items itemslabel itemslabelplural jan january john js judy july june label length list list-style-type livingston main march match matches matchesfilter matchesfilters model module month multiple ng-controller ng-model ng-repeat norfolk november null number objects october ohio onfilterchange optional outback pat patternfly pennsylvania pittsburgh placeholder plural pri prius push regexp result resultscount resuults return returned role row rows script second select selected selection separating september serve settings showtotalcountresults single smith space street style subaru subie subie-crosstrek subie-impreza subie-out text thomas title total totalcount toyota toyota-echo toyota-pri true type unique valid values var viewctrl virginia washingstone whoes york"
    },
    {
      "section": "api",
      "id": "patternfly.filters.component:pfFilterFields",
      "shortName": "pfFilterFields",
      "type": "directive",
      "moduleName": "patternfly.filters",
      "shortDescription": "Directive for the filter bar&#39;s filter entry components",
      "keywords": "allow api applied appliedfilters array bar box case categories category comparisons complex-select component components config configuration currently default delimiter directive display entered entry false field fields filter filterable filtercategories filtercategoriesplaceholder filterdelimiter filtermultiselect filters filtertype filtervalues html include input insensitive insensitve list list-style-type match multiple objects optional patternfly placeholder select selection separating serve settings single space style text title type unique valid values whoes"
    },
    {
      "section": "api",
      "id": "patternfly.filters.component:pfFilterPanel",
      "shortName": "pfFilterPanel",
      "type": "directive",
      "moduleName": "patternfly.filters",
      "shortDescription": "The Filter Panel is opened and closed by clicking on the Filter button.  It can contain any HTML desired by",
      "keywords": "$scope allitems angular api application applied appliedfilter appliedfilters applyfilters array bar based button call called case category category-option-label category1 category2 categoryone categorytwo cfme-row-column changed changedfilter changedfilterid changedfiltervalue changes checkbox checkboxes class clear cleared clicked clicking clicks closed col-md-12 col-md-2 col-md-4 col-sx-3 col-xs-3 comparisons component config configuration constructing controller createappliedfilter current currentkeyword currently default delete denote desired developer directive display events-label example-container examplefilter existingkeyword false filter filter-panel-container filterchanged filterconfig filtering filteritems filterpanelmodel filters filterstext filtertype filtervalues find foo foreach function hitting html input insensitive isdefined item items js keywoard keyword keyword-filter keywordfilterexists label length link list list-style-type match matches matchesfilter matchesfilters module newappliedfilters ng-change ng-controller ng-if ng-keypress ng-model ng-repeat null number onfilterchange onkeywordkeypress opened optional panel passed patternfly placeholder push regexp remove render repsonsible resetfilterpanelmodel responsible result resultscount resultslabel return returned row script selected sensitive set sets settings single store stored style tag tags text title tolowercase total totalcount triggered true type units unselect updatefilterpanelmodel user val1 val2 val3 values var viewctrl"
    },
    {
      "section": "api",
      "id": "patternfly.filters.component:pfFilterPanelResults",
      "shortName": "pfFilterPanelResults",
      "type": "directive",
      "moduleName": "patternfly.filters",
      "shortDescription": "Component for the filter panel results",
      "keywords": "api applied appliedfilters call changedfilterid changedfiltervalue changes clear cleared clicked clicking clicks comparisons component config configuration current currently default denote directive display filter filters function items label link list list-style-type number onfilterchange optional panel patternfly render result resultscount resultslabel returned set settings style tag tags title total totalcount triggered units user values"
    },
    {
      "section": "api",
      "id": "patternfly.filters.component:pfFilterResults",
      "shortName": "pfFilterResults",
      "type": "directive",
      "moduleName": "patternfly.filters",
      "shortDescription": "Component for the filter results",
      "keywords": "api applied appliedfilters box call changes comparisons component config configuration count current currently directive display entered field fields filter filterable filters filtertype filtervalues flag function html input items itemslabel itemslabelplural label list list-style-type number onfilterchange optional patternfly placeholder plural result resultscount returned select selected selectedcount settings showtotalcountresults style text title total totalcount type unique valid values"
    },
    {
      "section": "api",
      "id": "patternfly.form.component:pfFormButtons",
      "shortName": "pfFormButtons",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Encapsulates the standard structure and styling for create and cancel buttons",
      "keywords": "$element $scope $timeout angular api button buttons call cancel cancelled class clicks col-sm-2 col-sm-5 component container control-label controller create creates directive encapsulates false form form-control form-group formbuttonctrl function html input item js model module ng-controller ng-model null patternfly pf-on-cancel pf-on-save pf-working pfbuttonclass pfhandlecancel pfhandlesave pfworking required save saved scope script standard status store structure styling testform text true type user working"
    },
    {
      "section": "api",
      "id": "patternfly.form.directive:pfFormGroup",
      "shortName": "pfFormGroup",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Encapsulates the structure and styling for a label + input used within a",
      "keywords": "$scope angular api based bootstrap3 class col-sm-2 col-sm-5 controller creates default description directive doh donuts duff element encapsulates field form form-horizontal formdemoctrl function homer html input item js label module ng-controller ng-model patternfly pf-input-class pf-label pf-label-class pffieldid pfinputclass pflabel pflabelclass required scope script simpson structure styling text type"
    },
    {
      "section": "api",
      "id": "patternfly.form.directive:pfRemainingCharsCount",
      "shortName": "pfRemainingCharsCount",
      "type": "directive",
      "moduleName": "patternfly.form",
      "shortDescription": "Directive for showing a characters remaining count and triggering warning and error",
      "keywords": "$on $scope additional additionally allow angular api applied area behavior block block-input-at-max-limit btn btn-default button character characters characters-remaining charremainingcntfld_1 charremainingcntfld_2 charremainingcntfld_3 chars-max-limit chars-remaining-pf chars-warn-remaining chars-warn-remaining-pf charsmaxlimitexceeded class col-md-4 color container controller count count-fld css default democtrl directive disable dispatched dispatching display emptly entered equal error event example falls false field form form-control form-group function greater html initial input input_3 js limit max maximum message messagearea messagearea1text messagearea2text messagearea_1 messagearea_2 messageinput3text model module negative ng-controller ng-disabled ng-model number overcharsmaxlimit padding-left passed passing paste patternfly pf-remaining-chars-count placeholder postbtn_1 postbtn_2 pull-left pull-right reached red remaining removed representing required resize right-click row rows scope script setting showing string style submit text textarea tfid threshold thresholds trigger triggered triggering true turns type undercharsmaxlimit variable warn warning width"
    },
    {
      "section": "api",
      "id": "patternfly.modals.componenet:pfModalOverlay",
      "shortName": "pfModalOverlay",
      "type": "directive",
      "moduleName": "patternfly.modals",
      "shortDescription": "The Modal Overlay pattern provides a way to quickly load and display important information to the user without navigating",
      "keywords": "$ctrl $scope action action-buttons actionbuttons actionbuttons2 actionfn actions-label actionstext add advancing allow allowbackgrounddismissal allowed angular ante api array attention backdrop background background-close backgroundclose bibendum body boolean btn btn-default btn-primary button call cancel cases checkbox class classes clicked clicking clicks close closed col-md-12 col-sm-12 col-sm-3 col-sm-9 col-sm-offset-3 commodo componenet confirmation consequat control-label controller current custom-class deal default defined demo demo-form demo-info demoform demomodal1 demomodal2 demomodaloverlayctrl demotitle2 dialogs dignissim directive disabled dismiss dismissal dismisscause display displayed egestas enabled event example example-container examples false feugiat fire flag flow form form-control form-group form-horizontal formscope full function fusce github great has-error header help-block hide hide-close-icon hidecloseicon hidecloseicon2 html https iaculis icon include indicating input inputs interdum io ipsum is-form iscancel isdisabled isform js label laoreet lectus list-style-type load lorem modal modal-body-scope modal-body-template modal-id modal-title modalbodyscope modalbodytemplate modalid modalid2 modals modaltitle modaltitle2 module named navigating neque ng-click ng-controller ng-model ng-required ng-show note nulla object objects odio on-background-click on-close onbackgroundclick onclose onclose2 open open2 order overlay overlays parameter passed path pattern patternfly pfmodaloverlay placerat prompt properties quam remind require required-pf return risus row rows save scope script second sed semper set setting show-modal showmodal showmodal2 shownotallowedmsg stepping style styling suscipit suspendisse tasks template template2 tempus test text textinput textinput2 textinput3 third three title title-id titleid titleid2 tristique true type ui urna user users ut utilizes valid vary vel vestibulum warnings wizard"
    },
    {
      "section": "api",
      "id": "patternfly.modals.component:pfAboutModal",
      "shortName": "pfAboutModal",
      "type": "directive",
      "moduleName": "patternfly.modals",
      "shortDescription": "Component for rendering modal windows.",
      "keywords": "$scope additional-info additionalinfo admin administrator alt angular ante api bibendum btn btn-default call class closed commodo component consequat controller copyright corner data dignissim directive donec egestas explaining false feugiat flag function fusce grahpic html iaculis img img-alt img-src imgalt imgsrc indicating interdum ipsum is-open isopen js label laoreet lectus list-style-type localhost lorem modal modalctrl modals module neque ng-click ng-controller nulla odio on-close onclose open opened patternfly placerat product product-info productinfo quam rendering risus role script sed semper server source style suscipit suspendisse svg symbol tempus text title trademark tristique true urna user ut vel version vestibulum windows"
    },
    {
      "section": "api",
      "id": "patternfly.navigation.component:pfApplicationLauncher",
      "shortName": "pfApplicationLauncher",
      "type": "directive",
      "moduleName": "patternfly.navigation",
      "shortDescription": "Component for rendering application launcher dropdown.",
      "keywords": "$scope $window active alt angular api application applicationlaunchercontroller aria-expanded aria-haspopup badge button caret class classes click col-md-12 col-md-3 col-xs-12 collapse component controller ctrl custom data-toggle default directive disable display displayed dropdown dropdown-toggle enterprise fa fa-dashboard false flag form form-group function general good grid help hidden-icons hiddenicons horizontaldropdownmenu11 href html icon iconclass icons image_path imagepath img indicator interface is-disabled is-list isdisabled islist item items johnson js label launch launcher link links list list-style-type lorem menu module nav nav-item-iconic navbar navbar-brand navbar-collapse navbar-collapse-1 navbar-default navbar-header navbar-nav navbar-pf navbar-primary navbar-utility navigate navigation navigationitems ng-controller ng-model patternfly pficon pficon-build pficon-domain pficon-help pficon-home pficon-storage-domain pficon-user pre-demo-text radio radio-inline recteque rendering role row rule script src style suavitate svg title tooltip true type user"
    },
    {
      "section": "api",
      "id": "patternfly.navigation.component:pfVerticalNavigation - Basic",
      "shortName": "pfVerticalNavigation - Basic",
      "type": "directive",
      "moduleName": "patternfly.navigation",
      "shortDescription": "Component for vertical navigation. This sets up the nav bar header with the collapse button (hamburger) and the",
      "keywords": "$scope absolutely accumsan active add add_content addclass additional adipiscing adipscing aeque aliquam allow amet angular api application aria-expanded aria-haspopup aria-labelledby badge badgeclass badges bar based basic brand brand-alt brandalt brandsrc browser btn btn-primary button callback card-pf card-pf-accented card-pf-aggregate-status card-pf-aggregate-status-count card-pf-aggregate-status-mini card-pf-aggregate-status-notification card-pf-aggregate-status-notifications card-pf-body card-pf-heading card-pf-title caret change children class classes click col-md-3 col-sm-6 col-xs-12 collapse component conjunction container container-cards-pf container-fluid container-pf-nav-pf-vertical content contentcontainer controller convenire copiosae corrumpit count current dashboard data-placement data-toggle default delenit delicatissimi demo deps deserunt detracto directive display displayed dolor dropdown dropdown-menu dropdown-toggle dropdownmenu1 dropdownmenu2 element error example-error-background example-info-text example-page-container example-warning-background exerci exit fa fa-dashboard fa-graduation-cap fa-paper-plane fa-rebel fa-shield fa-space-shuttle false faux-layout filters flag function gb gubergren handlenavigateclick header height help hidden hiddenicons hide-vertical-nav hideverticalnav href html icon iconclass icons ignored ignoremobile image includedcontent intellegam invoked ipsum item itemclickcallback items js layout-pf layout-pf-fixed level link list list-style-type location logout lorem main marked mediocrem menu menus method mhz mobile mobileonly mock mode module nav nav-item-iconic navbar navbar-iconic navbar-nav navbar-right navigate navigate-callback navigatecallback navigation navigationitems ng-click ng-controller ng-include nonumy novum number option options parts patrioque patternfly pericula persistent persistentsecondary pficon pficon-add-circle-o pficon-cluster pficon-error-circle-o pficon-help pficon-image pficon-ok pficon-user pficon-warning-triangle-o pinnable-menus pinning preferences primary principes product progress progress-bar progress-bar-danger progress-bar-remaining progress-bar-success progress-bar-warning progress-container progress-description progress-description-left progress-label-right progress-label-top-right progressbar quaeque qualisque queryselector quotas recteque remaining removeclass return role row row-cards-pf script secondary selector set sets show-badges showbadges showdemocontroller showing showverticalnav sort sr-only src structure style suavitate submenu submenus supports tertiary text tha title tooltip top total transcluded true update-active-items-on-click updateactiveitemsonclick urbanitas user username utilized utils utroque vertical verticalnavlayout vertnavcontroller views vituperatoribus warning width works"
    },
    {
      "section": "api",
      "id": "patternfly.navigation.component:pfVerticalNavigation - Router",
      "shortName": "pfVerticalNavigation - Router",
      "type": "directive",
      "moduleName": "patternfly.navigation",
      "shortDescription": "This example shows how to use pfVerticalNavigation with angular-ui-router&#39;s $states and uiSrefs.",
      "keywords": "$scope $state $stateprovider $states $urlrouterprovider absolutely active add addclass additional angular angular-ui-router api aria-expanded aria-haspopup aria-labelledby badge badgeclass badges bar brand brand-alt brandalt brandsrc browser btn btn-primary callback card-pf card-pf-accented card-pf-aggregate-status card-pf-aggregate-status-notifications card-pf-body caret change children class classes click component config container container-cards-pf container-fluid container-pf-nav-pf-vertical content contentcontainer controller count dashboard data-toggle default defined demo deps directive display displayed dolor dropdown dropdown-menu dropdown-toggle dropdownmenu1 dropdownmenu2 element example example-info-text example-page-container exit fa fa-dashboard fa-shield fa-space-shuttle false faux-layout filters flag function handlenavigateclickrouter height help hidden hiddenicons hide-vertical-nav hideverticalnav hideverticalnavwithrouter href html icon iconclass icons ignored ignoremobile image invoked ipsum item itemclickcallback items js layout-pf layout-pf-fixed level link list list-style-type logout marked menu menus method mobile mobileonly mock mode module myapp nav nav-item-iconic navbar-iconic navbar-nav navbar-right navigate navigate-callback navigatecallback navigation navigationitems ng-click ng-controller object optional passed patternfly persistent persistentsecondary pficon-help pficon-user pfverticalnavigation pinnable-menus preferences primary product queryselector removeclass return router script secondary set show-badges showbadges showdemocontroller showing showverticalnav showverticalnavwithrouter somekey somevalue sort src structure style submenu submenus template text title tooltip top true ui uirouter uisref uisrefoptions uisrefs update-active-items-on-click updateactiveitemsonclick url user user-prefs username utils versa vertical verticalnavwithrouterlayout vertnavwithroutercontroller vice views"
    },
    {
      "section": "api",
      "id": "patternfly.notification.component:pfInlineNotification",
      "shortName": "pfInlineNotification",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "The main visual element of the notification message.",
      "keywords": "$scope $timeout add allowed angular api btn btn-default btn-group button caret checkbox class clicked close closed col-sm-10 col-sm-2 component control-label controller createnotification danger default delay demo directive disappear dropdown-menu-right element false form-control form-group form-horizontal function header html info ispersistent item js main manually menu menuitem message module ng-class ng-click ng-controller ng-model ng-repeat notification notificationdemoctrl patternfly pf-notification-header pf-notification-message pf-notification-persistent pf-notification-remove pf-notification-type pfnotificationheader pfnotificationmessage pfnotificationpersistent pfnotificationremove pfnotificationtype purposes remove removenotification role script selected success tabindex text timeout type types uib-dropdown uib-dropdown-menu uib-dropdown-toggle undefined updatetype var visual warning won"
    },
    {
      "section": "api",
      "id": "patternfly.notification.component:pfNotificationDrawer",
      "shortName": "pfNotificationDrawer",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "Component for rendering a notification drawer. This provides a common mechanism to handle how the notification",
      "keywords": "$ctrl $scope access accessed action actionbuttoncallback actionbuttontitle actions actions-label actionstext add aligned allow-expand allowexpand alternatively angular api area aria-expanded aria-haspopup aria-labelledby badge badge-pf-bordered behave blank body bold bottom btn btn-link button calc callback called capability categorization class clear clearall close closedrawer col-md-12 collapse collection common component configuration containers content controller create currently currenttime custom-scope customize customscope data-toggle default define demo deps desire desired directive disabled display displayed divider drawer drawer-hidden drawer-pf drawer-pf-notification-content drawer-pf-notification-info drawer-pf-notification-message drawer-pf-trigger drawer-pf-trigger-icon drawer-title drawerctrl drawerexpanded drawerhidden drawertitle dropdown dropdown-kebab-pf dropdown-menu dropdown-menu-right dropdown-toggle dropdownkebabright empty entire error event events example-container expand expanded fa fa-bell fa-ellipsis-v false field files filter filters find flag footer foreach function getnotficationstatusiconclass gettime group grouped groups handle handleaction handler handlers heading heading-include headinginclude height hidden hide hidedrawer html huzzah include included indicator info instance isdisabled isloading isseparator js label-title layout-pf-fixed leave length listing lower mandating margin-left mark markallread markread mechanism menuactions menuitem message method mm module modules my-nav-container nav nav-item-iconic navbar-collapse navbar-iconic navbar-left navbar-nav navbar-pf navbar-pf-vertical newtext nextnotification ng-class ng-click ng-controller ng-if ng-repeat nonotificationstext note notification notification-body notification-body-include notification-footer notification-footer-include notification-groups notification-track-field notificationbodyinclude notificationfooterinclude notificationgroup notificationgroups notifications notificationtrackfield notificaton object on-clear-all on-close on-mark-all-read onclearall onclose onmarkallread open optional options order org override pass passed patternfly perform pficon pficon-error-circle-o pficon-info pficon-ok pficon-warning-triangle-o pfnotificationdrawer pre-demo-text pre-set provide provided pull-left pull-right read remove rendering requirements retclass return role row rows scope script secondary-action separator set show-clear-all show-mark-all-read showclearall showmarkallread single sort source src status style stylings sub-heading subheading subheading-include subheadinginclude supplied tab text time timestamp title titleinclude toggleshowdrawer tooltip tooltip-append-to-body tooltip-placement tooltip-popup-delay top track trigger true type uib-dropdown uib-dropdown-toggle uid unavailable unread unreadnotifications updateunreadstatus utils valid var variables vertically viewport views warning"
    },
    {
      "section": "api",
      "id": "patternfly.notification.component:pfNotificationList",
      "shortName": "pfNotificationList",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "Using this component automatically creates a list of notifications generated by the notification service.",
      "keywords": "$scope angular api automatically btn btn-default btn-group button caret class click col-sm-10 col-sm-12 col-sm-2 component control-label controller creates danger default directive dropdown-menu-right error form-control form-group form-horizontal function generated html info item js list menu menuitem message module ng-class ng-click ng-controller ng-model ng-repeat notification notificationdemoctrl notifications notify object patternfly role script selected service success tabindex text times type typemap types uib-dropdown uib-dropdown-menu uib-dropdown-toggle updatetype var warn warning"
    },
    {
      "section": "api",
      "id": "patternfly.notification.component:pfToastNotification",
      "shortName": "pfToastNotification",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "Toast notifications are used to notify users of a system occurence. Toast notifications should be transient and stay on the screen for 8 seconds,",
      "keywords": "$scope $watch accepts action action-callback action-title actioncallback actionfn actions actions-label actiontext actiontitle add allow allowed allows angular api block btn btn-default btn-group button callbacks capabilities caret checkbox class close close-callback closecallback col-md-12 col-sm-1 col-sm-10 col-sm-2 component content control-label controller currently danger data default directive disable disabled displayed dropdown-menu-right example-container false flag form-control form-group form-horizontal function grouped handleaction header html html-content htmlcontent info invoke isdisabled isseparator item js kebab list list-style-type long main menu menu-actions menuaction menuactions menuitem message module needed ng-class ng-click ng-controller ng-model ng-repeat note notification notification-type notifications notificationtype notify occurence optional options patternfly perform performaction pftoastnotification place placehodler primary primaryaction read role row rows screen script seconds selected separator set show-close showclose showmenu status stay style success supported system tabindex text title toast toastnotificationdemoctrl transient true type types uib-dropdown uib-dropdown-menu uib-dropdown-toggle unavailable undefined updatetype updateviewing user users var viewing warning"
    },
    {
      "section": "api",
      "id": "patternfly.notification.component:pfToastNotificationList",
      "shortName": "pfToastNotificationList",
      "type": "directive",
      "moduleName": "patternfly.notification",
      "shortDescription": "Using this component displayes a list of toast notifications",
      "keywords": "$rootscope $scope accepts action actioncallback actionfn actions actions-label actiontext actiontitle allow allowed angular api btn btn-default btn-group button buttons caret checkbox class click close close-callback closecallback closed closes col-md-12 col-sm-1 col-sm-10 col-sm-12 col-sm-2 col-sm-3 component content control-label controller current danger data default directive disable disabled display displayed displayes dropdown-menu-right example-container false flag form-control form-group form-horizontal function grouped handleaction handleclose header html html-content htmlcontent info invoke isdisabled ispersistent isseparator item js kebab list list-style-type main menu menuaction menuactions menuitem message module ng-class ng-click ng-controller ng-model ng-repeat notification notifications notify object optional options patternfly perform performaction persistent pftoastnotification place placehodler primary primaryaction remove role row rows script selected separator set setviewing show-close showclose showmenu style success tabindex text times title toast toastnotificationlistdemoctrl true type typemap types uib-dropdown uib-dropdown-menu uib-dropdown-toggle unavailable undefined update-viewing updatetype updateviewing user var viewing warning"
    },
    {
      "section": "api",
      "id": "patternfly.notification.Notification",
      "shortName": "patternfly.notification.Notification",
      "type": "service",
      "moduleName": "patternfly.notification",
      "shortDescription": "Notification service used to notify user about important events in the application.",
      "keywords": "$log $rootscope $scope angular api application argument btn btn-default btn-group button caret class close closed col-sm-10 col-sm-12 col-sm-2 config configuration configure configuring console control-label controller danger default delay dismissed dropdown-menu-right error events example expects form-control form-group form-horizontal format function html httperror info input item js manually menu menuitem message method miliseconds mode modes module ms myapp ng-class ng-click ng-controller ng-model ng-repeat notification notificationdemoctrl notifications notificationsprovider notify object option patternfly persist persistent persistvalue printed role script selected service set setdelay setpersist sets setverbose success tabindex text true type typemap types uib-dropdown uib-dropdown-menu uib-dropdown-toggle updatetype user var verbose warn warning won"
    },
    {
      "section": "api",
      "id": "patternfly.pagination.component:pfPagination",
      "shortName": "pfPagination",
      "type": "directive",
      "moduleName": "patternfly.pagination",
      "shortDescription": "Component for pagination controls used in various views (list, card, table)",
      "keywords": "$scope angular api applied array card class col-md-12 col-md-2 col-md-3 col-md-7 component controller controls current data default directive dropdown filter floor function html increment increments initial item items js length limitto math module ng-controller ng-repeat num-total-items number numtotalitems page-number page-size pagectrl pagenumber pagesize pagesizeincrements pagination patternfly push random row script set size startfrom status table total update values views"
    },
    {
      "section": "api",
      "id": "patternfly.select.component:pfSelect",
      "shortName": "pfSelect",
      "type": "directive",
      "moduleName": "patternfly.select",
      "shortDescription": "The pfSelect component provides a wrapper for the angular ui bootstrap dropdown.",
      "keywords": "$scope angular ape api apple apples array banana bananas beer bootstrap call cat chicken class coffee col-sm-10 col-sm-2 component control-label controller curently directive display display-field displayfield dog drink drinks dropdown empty-value emptyvalue field florida form-group form-horizontal fresh fruit fruits function great html item js macintosh module ng-controller nodrink nopet object onselect options orange oranges patternfly pet pets pfselect pies preferred script select selectdemoctrl selected selection selections tea title ui user valid water wine wrapper"
    },
    {
      "section": "api",
      "id": "patternfly.select.directive:pfBootstrapSelect",
      "shortName": "pfBootstrapSelect",
      "type": "directive",
      "moduleName": "patternfly.select",
      "shortDescription": "An AngularJS wrapper for the Bootstrap-select jQuery plugin which is used",
      "keywords": "$scope angular angularjs api apple attribute banana binding bootstrap-select cat chicken class coffee col-sm-10 col-sm-2 control-label controller decorator default directive dog drink drinks dynamically element elements form-group form-horizontal fruit function generate github html http https io jquery js list mandatory model module ng-controller ng-model ng-options ng-selected ngmodel ngmodelcontroller ngoptions noneselectedtext orange org patternfly pet pets pf-bootstrap-select plugin preferred script select selectdemoctrl selected tea true water wrapper"
    },
    {
      "section": "api",
      "id": "patternfly.sort.component:pfSort",
      "shortName": "pfSort",
      "type": "directive",
      "moduleName": "patternfly.sort",
      "shortDescription": "Sort component",
      "keywords": "$scope alpha alright angular api ascending beautiful call cfme-row-column change cheap class col-md-12 col-md-3 comparefn component compvalue config configuration controller count current currentfield currently descending description direction directive display events-label example-container examplesort excellent false fantastic field fields forever function good horrible html isascending item item1 item2 items js lasts list list-style-type localecompare module ng-controller ng-repeat nice numeric onsortchange params patternfly return row script selected settings sort sortable sortchange sortconfig sortdirection sorttype stuff style title true type unique var viewctrl"
    },
    {
      "section": "api",
      "id": "patternfly.table.component:pfTableView-Basic",
      "shortName": "pfTableView-Basic",
      "type": "directive",
      "moduleName": "patternfly.table",
      "shortDescription": "Component for rendering a simple table view.",
      "keywords": "$ctrl $q $scope $timeout account achieve action action-buttons actionbuttons actionfn actions addnewcomponenttodom address adjust angular angular-datatables angularjs api array asc associate attribute bedrock better bird boston bourbon brown button buttons california call callback called cell cells changes chase checkbox checkbox-inline checkboxes checked cheryl city class clicked col col-md-12 colactionfn colorado column columns component con config configuration controller cross default demo denver desc determining dilorenzo dinosaur directive directives disabled display displayed displays doesn dropdown dt-options dtoptions dtoptionsbuilder east edwards elm embedded empty empty-state-action-buttons empty-state-config emptystateactionbuttons emptystateconfig equal error eventtext example example-container exampletableview exists false field flintstone font-weight form-group frank fred function getitems github goal goals good grouped guide handlecheckboxchange handlecolaction header helplink helps hill holly hollywood href html htmltemplate http icon impression info informational init invoke io isdisabled isseparator item itemfield itemfld items itemsavailable itemsservice jim john js jump key kim label lane large linda list list-style-type livingston main marie massachusetts massacusetts matching mcgovern menu menu-actions menuactions mike module name_template nashville ng ng-change ng-click ng-controller ng-if ng-model nichols norfolk notify null numbers oak object objects oncheckboxchange onnameclick optional optionaly order padding-top paragraph paramenter passed pat pattern patternfly pennsylvania perform performaction performance performant performemptystateaction performs pfexample pficon pficon-error-circle-o pficon-ok pficon-warning-triangle-o pftableview pftoolbar pittsburgh poor pro property provide reject ren render rendering resolve return row rows second secondary selected selection selectionmatchprop service settimeout settings showcheckboxes showcomponent simple smith sort specific status status_template street style support supports switcher table tablectrl tables tableview taylor tempatefn template templatefn templating tennessee text things thomas title toolbar toolbars tooltip tree true type unavailable url urllabel user users uuid var view views virginia warning washingstone york"
    },
    {
      "section": "api",
      "id": "patternfly.table.component:pfTableView-with-Toolbar",
      "shortName": "pfTableView-with-Toolbar",
      "type": "directive",
      "moduleName": "patternfly.table",
      "shortDescription": "Example configuring a table view with a toolbar.",
      "keywords": "$ctrl $filter $scope $timeout absolute achieve action action-buttons actionbuttons actionfn actions actions-label actionsconfig actionsinclude actionstext addnewcomponenttodom address address_template age allitems allowed angular angular-datatables angularjs api apple appliedfilters applyfilters april array associate attribute august backward bedrock better birth birthmonth boulevard bourbon brown button buttons california call callback called cell cells changes checkbox checkbox-inline checkboxes chris cincinatti class classname clicked col-md-12 colactionfn colorado column columns comment compatibility component con config configuration configuring content controller controls december default demo denver determining dinosaur directive directives disabled display displayed displaylength displays doesn dom don dropdown dt-options dtoptions dtoptionsbuilder east ellipsis elm embedded empty empty-state-config emptystateactionbuttons emptystateconfig equal error example example-container exampletoolbar exists false february field fields filter filterchange filterconfig filters filtertype filtervalues flex flintstone foreach form-group frank fred full function github goal goals good green grouped guide handlecheckboxchange handlecolaction header helplink helps henry hidden holly hollywood href html htmltemplate http icon impression increments indicate info informational initial inline-block invoke io isdisabled isseparator istableview item itemfield itemfld items itemsavailable jane january jim john js judy july jump june key label large larry left length linda list list-style-type livingston liz longer main march match matches matchesfilter matchesfilters matching max-width mcgovern menu menu-actions menuactions min-width module modules month monthvals moreactions name_template nashville neccesary ng ng-change ng-click ng-controller ng-if ng-model ngdoc nichols norfolk note notify november nowrap null number oak object objects october ohio oncheckboxchange onfilterchange onnameclick optional optionaly order overflow-x overflow-y padding page-config pageconfig pagenumber pagesize pagesizeincrements pagination paginationtype paragraph paramenter parameters parseint passed pat pattern patternfly pennsylvania perform performaction performance performant performs performtableaction pf pfexample pficon pficon-error-circle-o pficon-ok pficon-warning-triangle-o pftoolbar pfviewutils pittsburgh placeholder poor position prefered primaryactions pro properties property provide push relative remove render required resultscount return row rows script second select selected selectedcount selecteditems selection selectionmatchprop september settings showcheckboxes showcomponent size smith sortconfig specific status status_template stree street style support supports switch switcher tabbable table tableactionbuttons tableconfig tablemenuactions tables tableview tabpane tempatefn template templatefn templating tennessee text text-bottom text-overflow text-success text-warning thing things thomas time title todo toolbar toolbaractionsconfig toolbarconfig toolbars tooltip top totalcount tp true truncate-text-container truncate-text-ellipsis type unavailable updateitemsavailable url urllabel user users uuid values var ve vertical-align view viewctrl views virginia visibility visible warning washingstone wasted white-space width wilma york"
    },
    {
      "section": "api",
      "id": "patternfly.toolbars.component:pfToolbar",
      "shortName": "pfToolbar",
      "type": "directive",
      "moduleName": "patternfly.toolbars",
      "shortDescription": "Standard toolbar component. Includes filtering and view selection capabilities",
      "keywords": "$filter $scope $timeout achieve action actionfn actions actions-label actionsconfig actionsinclude actionstext active add addnewcomponenttodom address age allitems alpha angular api apple appliedfilters applyfilters april august bedrock birth birthmonth boulevard bourbon brown btn btn-default button buttons california call capabilities cardview caret checkbox checkbox-inline checkdisabled chris cincinatti class clear clearfilters col-md-12 colorado columns comparefn comparisons component compvalue config configuration controller criteria currentfield currently currentview custom dave december defined delete demo denver dinosaur directive disable disabled display displayed doadd dropdown dropdown-menu dropdown-toggle east elm empty empty-state-config emptystateconfig events-label example-container exampletoolbar exists fa fa-plus false february fields filter filterchange filterconfig filtering filters filterstext filtertype filtervalues flintstone foreach form-group frank fred function getcardview getlistview gettableview goal goals good green grouped guide handlecheckboxchange header helplink helps hiding holly hollywood html icon iconclass impression includes info invoke isascending isdisabled isseparator istableview item item1 item2 itemfield items itemsavailable january jeff jessica jim john js judy july jump june label length linda list list-group-item-heading list-group-item-text list-style-type list-view-pf-additional-info list-view-pf-additional-info-item list-view-pf-description listconfig listview livingston localecompare main march match matches matchesfilter matchesfilters mcgovern menu menuitem module modules month monthvals moreactions nashville ng-change ng-click ng-controller ng-if ng-model nichols noitemsconfig norfolk november null numeric oak objects october ohio oncheckboxchange onfilterchange onsortchange onviewselect option optional options optionselected padding-top page-config pageconfig pagesize pagination parseint pat pattern patternfly pennsylvania perform performaction pfexample pficon-warning-triangle-o pfsimplefilter pfsort pfviewutils pittsburgh placehodler placeholder primary primary-action primaryactions provide pulldown push regexp resultscount return role row rows script second secondary secondary-action select selected selectedcount selecteditems selection selectionmatchprop selector separator september set settings showcomponent showpagination smith sort sortchange sortconfig sorttype specific standard stree street style table tableconfig tableview tennessee text thing thomas title togglepagination toolbar toolbarconfig toolbars tooltip totalcount transclude true type uib-dropdown uib-dropdown-toggle unavailable undefined unique updateitemsavailable url urlaction urllabel user users var view viewctrl viewid views viewsconfig viewselected viewtype virginia washingstone york"
    },
    {
      "section": "api",
      "id": "patternfly.utils.directive:pfTransclude",
      "shortName": "pfTransclude",
      "type": "directive",
      "moduleName": "patternfly.utils",
      "shortDescription": "Directive for transcluding in directives and setting up scope of children of parent directives. This is a workaround",
      "keywords": "$delegate $id $provide angular api child children class config content contents controller decorator directive directives display element function html https js list-style-type module ng-controller ngtranscludedirective original parent patternfly pf-transclude pf-transclude-example pftransclude remove restrict return row scope script setting shift sibling specifies style template transclude transcludechild transcluded transcludeparent transcludesibling transcluding transclusion true type utilctrl utils width workaround"
    },
    {
      "section": "api",
      "id": "patternfly.utils:pfFixedAccordion",
      "shortName": "pfFixedAccordion",
      "type": "directive",
      "moduleName": "patternfly",
      "shortDescription": "Directive for setting a ui-bootstrap uib-accordion to use a fixed height (collapse elements scroll when necessary)",
      "keywords": "$scope ac accordioncntrl accumsan ad adipiscing adipisicing aenean aliqua aliquam aliquet aliquip amet angular anim ante api arcu area augue aute bibendum blandit bootstrap cillum class close-others col-md-4 collapse commodo congue consectetuer consectetur consequat content controller convallis cras cubilia culpa cupidatat curabitur curae cursus dapibus default deps deserunt diam dictum dignissim directive dolor dolore donec dui duis ea egestas eget eiusmod eleifend element elements elementum elit enim entire erat eros esse est etiam eu euismod example-container excepteur exercitation false faucibus felis fermentum feugiat find fixed fringilla fugiat function fusce gravida group group-height groupclass groupheight heading height hendrerit html iaculis imperdiet incididunt integer interdum ipsum irure is-open isopen item items js justo labore laboris laborum lacinia lacus laoreet lectus leo libero ligula lobortis lorem luctus maecenas magna malesuada massa mattis mauris metus mi minim module molestie mollis mollit morbi nam nec neque ng-attr-heading ng-controller ng-repeat nibh nisi nisl nonummy nostrud nulla nunc occaecat odio officia orci ornare panel-default pariatur patternfly pede pellentesque pf-fixed-accordion pharetra placerat porta porttitor posuere praesent pretium primis proident proin pulvinar purus quam qui quis reprehenderit rhoncus risus row rutrum sagittis sapien scelerisque script scroll scrolls scrollselector sed selector sem semper set setting sint sit sodales sollicitudin specifies sunt suscipit suspendisse tellus tempor tempus tincidunt tortor tristique true turpis ui ui-bootstrap uib-accordion uib-accordion-group ullamco ullamcorper ultrices ultricies urna ut utils varius vehicula vel velit venenatis veniam vestibulum vitae vivamus viverra voluptate volutpat vulputate"
    },
    {
      "section": "api",
      "id": "patternfly.validation:pfValidation",
      "shortName": "pfValidation",
      "type": "directive",
      "moduleName": "patternfly",
      "shortDescription": "Directive used for input validation based on custom function.",
      "keywords": "$scope angular api based change checkbox class col-sm-10 col-sm-2 control-label controller custom directive disabled enabled false form-control form-group form-horizontal function help-block html input isnumber isvalidationdisabled js message module myvalue myvaluevalid ng-controller ng-model number patternfly pf-validation pf-validation-disabled pfvalidationdisabled return script text true type typed valid validation validationdemoctrl"
    },
    {
      "section": "api",
      "id": "patternfly.views.component:pfCardView",
      "shortName": "pfCardView",
      "type": "directive",
      "moduleName": "patternfly.views",
      "shortDescription": "Component for rendering cards in a view",
      "keywords": "$scope achieve action actionfn actions address allow angular api apple applicable bedrock betty block border border-top boston boulevard bourbon boxes brown buttons california call called card cards change changes checkbox checkbox-inline checkdisabled checkdisableditem checked chris cincinatti city class click clicked clicking col-md-12 colorado component config configuration controller cross current data dblclick default delete denver deps determine determining dinosaur directive disabled display displays dlbclick double dropdown east edwards elm empty empty-state-action-buttons empty-state-config emptystateactionbuttons emptystateconfig event events-label eventtext examplecardview exists false flintstone form form-group frank fred function goal goals good green guide handle handlecheckboxchange handleclick handledblclick handleselect handleselectionchange height helplink helps hollywood howard hr html icon impression increments indicate info informational initial item items itemsavailable john joyce js judy jump label length list-style-type livingston liz main margin mark martha massachusetts matching mcgovern mike module multiple multiselect nashville ng-change ng-controller ng-disabled ng-model nichols norfolk notify number oak object objects ohio oncheckboxchange onclick ondblclick onselect onselectionchange optional padding page-config pageconfig pagenumber pagesize pagesizeincrements pagination paragraph parameters pat pattern patternfly pennsylvania perform performemptystateaction pfexample pficon-warning-triangle-o pittsburgh properties property provide radio radio-inline remains rendering return role row rows rubble script second secondary select selected selecteditems selection selectionmatchprop selections selectitems selecttype set settings showdisabled showpagination showselectbox size smith solid specific street style tennessee thomas title togglepagination true type updateselectiontype url urllabel user users utils uuid values var view viewctrl views virginia washingstone width york"
    },
    {
      "section": "api",
      "id": "patternfly.views.component:pfEmptyState",
      "shortName": "pfEmptyState",
      "type": "directive",
      "moduleName": "patternfly.views",
      "shortDescription": "Component for rendering an empty state.",
      "keywords": "$scope achieve action action-buttons actionbuttons actionfn actions angular api appears button buttons callback class clickable col-md-12 component config configuration controller deps directive display displayed empty eventtext example-container execute executed exists font-weight function goal goals good guide helplink helps html icon impression info informational invoke js label link list-style-type main method module nagivate ng-controller object objects optional paragraph path pattern patternfly perform performaction performemptystateaction pfexample pficon pficon-add-circle-o portion properties property provide rendering row rows script secondary selected set specific style text title tooltip type unspecified url urlaction urllabel user users utils var view viewctrl views"
    },
    {
      "section": "api",
      "id": "patternfly.views.component:pfListView",
      "shortName": "pfListView",
      "type": "directive",
      "moduleName": "patternfly.views",
      "shortDescription": "Component for rendering a list view.",
      "keywords": "$ctrl $parent $scope $templatecache access accessed achieve action action-buttons actionbuttons actionfn actions active ad add adding address adipisicing aliqua aliquip allow allowing amet angular anim api applicable applicatiot array aute background-color based basic basicctrl bedrock behavior betty bindings body boston bourbon boxes break brown btn-primary button buttoninclude buttons california call called center-label change changes chartid checkbox checkbox-inline checkdisabled checkdisableditem checked chris cillum city class click clicked clicking close clustercount clusters col-md-12 col-md-3 col-md-9 collapseitem colorado commodo component compound compoundexanspansionctrl compoundexpanion compoundexpansiononly config configuration consectetur consequat console content contents controller cross ctrl culpa cupidatat current cursor custom custom-scope customscope data dblclick default denver deps deserunt determine determining dinosaur directive disable disabled disablerowexpansion display displayed displays div dl-horizontal dlbclick dolor dolore double drag dragenabled dragend dragitem dragmoved dragstart drop dropdown dropdowns duis ea east edwards eiusmod element elit elm empty empty-state-action-buttons empty-state-config emptystateactionbuttons emptystateconfig enable enable-button-for-item-fn enablebuttonforitemfn enabled ended enim error esse est eu event eventtext example-container example-list-view examplechartconfig examplelistview excepteur exercitation exists expand expandable expanded expander expandfield expanding expansion fa fa-angle-down fa-angle-right fa-briefcase fa-coffee fa-gamepad fa-linux fa-magic fa-plane fa-plus false fff field flintstone font-weight form form-group frank fred fugiat function functionality gb getmenuclass goal goals good grouped guide handle handlecheckboxchange handleclick handledblclick handleselect handleselectionchange helplink helps hide hide-menu-for-item-fn hidemenuactions hidemenuforitemfn hides hmtl holly hollywood hostcount hosts howard href html icon imagecount images impression incididunt include includeclass increments indicate info informational initial inside invoke ipsum irure isdisabled isexpanded isitemexpanded isseparator isvisible item itemexpansion items itemsavailable jim john joyce js jump kebab label labore laboris laborum layouts length linda link list list-expanded-content list-group-item-heading list-group-item-text list-style-type list-view-container list-view-pf-additional-info list-view-pf-additional-info-item list-view-pf-body list-view-pf-description list-view-pf-expand list-view-pf-icon-sm list-view-pf-left livingston liz log lorem magna main margin marie mark martha massachusetts matching mcgovern menu menu-actions menu-class-for-item-fn menuactions menuclass menuclassforitemfn mike minim module mollit moved multiple multiselect my-button-template nashville nav nav-tabs ng-change ng-class ng-click ng-controller ng-disabled ng-if ng-include ng-model nichols nisi nodecount nodes norfolk nostrud note notify nulla number oak object objects occaecat officia oncheckboxchange onclick ondblclick onselect onselectionchange operation optional options page-config pageconfig pagenumber pagesize pagesizeincrements pagination paginationctrl paginationlistview paragraph parameters pariatur pass pat pattern patternfly pctchart pennsylvania percent perform performaction performed performemptystateaction pfexample pficon pficon-close pficon-cluster pficon-container-node pficon-image pficon-screen pficon-warning-triangle-o pittsburgh placeholder pointer proident properties property provide qui quis radio radio-inline red relevant remains rendering reprehenderit requires return role row rowclass rows rubble scope second secondary sed select selected selecteditems selection selectionmatchprop selections selectitems selecttype sentence separator server set setting settings setview showdisabled showselectbox sint sit size smith snippet source special specific splice src start start-button-template startbuttoninclude started starting startserver street strict style sunt templateurl tempor tennessee text thomas three thresholds title toggleexpanditemfield tooltip total transcluded true type typeicon ullamco unavailable units update update-menu-action-for-item-fn updatemenuactionforitemfn updateselectiontype url urllabel useexpandingrows useexpandrows user users ut utils uuid valid values var variables velit veniam view viewctrl views viewtype virginia voluptate warning washingstone york"
    },
    {
      "section": "api",
      "id": "patternfly.views.pfViewUtils",
      "shortName": "patternfly.views.pfViewUtils",
      "type": "object",
      "moduleName": "patternfly.views",
      "shortDescription": "A utility constant to return view objects used for Dashboard, Card, Table, List, and Topology view switcher types.",
      "keywords": "$scope api card class comparisons component constant dashboard getcardview getlistview gettableview getxxxxview icon iconclass list list-style-type object objects optional patternfly pftoolbar pfviewutils return returns selector style switcher table title toolbar toolbars tooltip topology types unique utility view views viewsconfig"
    },
    {
      "section": "api",
      "id": "patternfly.wizard.component:pfWizard",
      "shortName": "pfWizard",
      "type": "directive",
      "moduleName": "patternfly.wizard",
      "shortDescription": "Component for rendering a Wizard modal.  Each wizard dynamically creates the step navigation both in the header and the left-hand side based on nested steps.",
      "keywords": "$ctrl $emit $on $parent $rootscope $scope $timeout $uibmodal ac active activesteptitleonly additional amet angular animation api back-callback backcallback backdrop backtitle bar based basic blank-slate-pf blank-slate-pf-icon blank-slate-pf-main-action blank-slate-pf-secondary-action boolean btn btn-default btn-lg btn-primary button buttons call called cancel canceldeploymentwizard canceled canceltitle changed class clicked close closewizard col-md-10 col-md-2 col-sm-3 col-sm-9 command complete component configuration consistently container content contentheight controller creates css current currentstep data default defaults define deploy deploycomplete deployinprogress deployment deploymentcomplete deploymentcontroller deps description descriptive desired detail-page details details-extra details-general detailsgeneralcomplete detailsgeneralcontroller detailsreviewcontroller directive dismiss display displayed dolor dynamically eget embedded embedinpage example example-wizard-sidebar example-wizard-step externally extra false final find finish finishedwizard firststepnexttooltip firststepprevtooltip focus-selectors focusselectors footer form form-horizontal function general glyphicon glyphicon-ok-circle group hand head header height hide hidebackbutton hideheader hideindicators hides hidesidebar html indicate indicates indicators individual initializewizard instance invalid-classname ipsum isdefined isundefined js left left-hand length lg loading loading-secondary-information loadingsecondaryinformation loadingwizardtitle logical lorem modal modalinstance module moves navigation nested new-description new-ipsum new-lorem new-name next-callback next-enabled next-title next-tooltip nextbuttontitle nextcallback nexttitle ng-change ng-click ng-controller ng-if ng-include ng-model notify nunc ok-to-nav-away on-cancel on-finish on-show on-step-changed oncancel onfinish onshow onstepchanged open openwizardmodel operation optional pageshown panel passes patternfly pf-input-class pf-label pf-label-class pf-wizard-step pf-wizard-steps pf-wizard-substep porta portions prev-enabled prev-tooltip progress property provided ready reason removes rendering required result return returns review review-progress review-second-template review-summary review-template reviewstepnexttooltip reviewstepprevtooltip reviewtemplate script second second-step secondary secondaryloadinformation secondstepcontroller secondstepnexttooltip secondstepprevtooltip set setting show-review show-review-details side sidebar sidebar-class sidebarclass sit size sociosqu spinner spinner-lg startdeploy static step step-class step-id step-priority step-title step-two-new-ipsum step-two-new-lorem stepchanged stepclass stepid steps strict structure substeps successful summary summarycontroller supplied suspendisse switch tab templateurl text time title true type updatename updates ut var vivamus wisi wizard wizard-container wizard-data wizard-done wizard-pf-complete wizard-pf-contents wizard-pf-process wizard-pf-review-item wizard-pf-review-item-label wizard-pf-review-item-value wizard-pf-success-icon wizard-ready wizard-title wizardcontroller wizarddata wizarddone wizarddonelistener wizardmodalcontroller wizardready wizards wizardtitle wz-disabled"
    },
    {
      "section": "api",
      "id": "patternfly.wizard.component:pfWizardReviewPage",
      "shortName": "pfWizardReviewPage",
      "type": "directive",
      "moduleName": "patternfly.wizard",
      "shortDescription": "Component for rendering a Wizard Review Page - should only be used within a wizard.",
      "keywords": "api apply component content data directive internal internally patternfly rendering review sets templates visible watched wizard wizarddata"
    },
    {
      "section": "api",
      "id": "patternfly.wizard.component:pfWizardStep",
      "shortName": "pfWizardStep",
      "type": "directive",
      "moduleName": "patternfly.wizard",
      "shortDescription": "Component for rendering a Wizard step.  Each step can stand alone or have substeps.  This directive can only be used as a child of pf-wizard.",
      "keywords": "allowclicknav api array button called child click component data default description details directive directly display displayed enabled entire expanded find focus focusselectors function header hides identifier indicates indicators initial leave navigate nextenabled nexttooltip numbered numeric oktonavaway onshow order passed patternfly pf-wizard prevenabled prevtooltip priority reached relative rendering review reviewtemplate screen selectors sequentially set sets shared showreview showreviewdetails stand step stepid steppriority steps steptitle substeps template text title tooltip true user viewed wizard wizarddata wzdisabled"
    },
    {
      "section": "api",
      "id": "patternfly.wizard.component:pfWizardSubstep",
      "shortName": "pfWizardSubstep",
      "type": "directive",
      "moduleName": "patternfly.wizard",
      "shortDescription": "Component for rendering a Wizard substep.  Each substep must be a child of a pf-wizardstep in a pf-wizard directive.",
      "keywords": "allowclicknav api array button called child click component data default description details directive directly displayed enabled entire expanded find focus focusselectors function header hides identifier indicators initial leave navigate nextenabled numbered numeric oktonavaway onshow order passed patternfly pf-wizard pf-wizardstep prevenabled priority reached relative rendering review reviewtemplate screen selectors sequentially set sets shared showreviewdetails step stepid steppriority steps steptitle substep template text title true user viewed wizard wizarddata wzdisabled"
    }
  ],
  "apis": {
    "api": true
  },
  "html5Mode": false,
  "editExample": true,
  "startPage": "/api",
  "scripts": [
    "jquery.js",
    "bootstrap.min.js",
    "bootstrap-select.js",
    "jquery-ui.js",
    "jquery.dataTables.js",
    "dataTables.select.js",
    "moment.js",
    "d3.js",
    "c3.js",
    "patternfly-settings.js",
    "patternfly-settings-colors.js",
    "patternfly-settings-charts.js",
    "angular.js",
    "angular-dragdrop.js",
    "angular-datatables.js",
    "angular-datatables.select.min.js",
    "angular-sanitize.js",
    "angular-animate.js",
    "ui-bootstrap-tpls.js",
    "angular-bootstrap-prettify.js",
    "lodash.min.js",
    "angular-patternfly.js",
    "angular-ui-router.min.js",
    "angular-drag-and-drop-lists.js"
  ]
};