
module.exports = function (config) {
  config.set({
    // base path, that will be used to resolve files and exclude
    basePath: '../',

    frameworks: ['jasmine'],

    // list of files / patterns to load in the browser
    files: [
      'node_modules/jquery/dist/jquery.js',
      'node_modules/datatables.net/js/jquery.dataTables.js',
      'node_modules/moment/moment.js',
      'node_modules/bootstrap-select/js/bootstrap-select.js',
      'node_modules/d3/d3.js',
      'node_modules/c3/c3.js',
      'node_modules/patternfly/dist/js/patternfly.js',
      'node_modules/angular/angular.js',
      'node_modules/angular-sanitize/angular-sanitize.js',
      'node_modules/angular-animate/angular-animate.js',
      'node_modules/angular-mocks/angular-mocks.js',
      'node_modules/angular-ui-bootstrap/dist/ui-bootstrap.js',
      'node_modules/angular-ui-bootstrap/dist/ui-bootstrap-tpls.js',
      'misc/angular-bootstrap-prettify.js',
      'node_modules/angularjs-datatables/dist/angular-datatables.min.js',
      'node_modules/lodash/lodash.js',
      'misc/test-lib/helpers.js',
      'src/**/*.module.js',
      'src/**/*.js',
      'src/**/*.html',
      'test/utils/*.js',
      'test/wizard/script.js',
      'test/**/*.spec.js',
      'test/**/*.html',
      'node_modules/angular-ui-router/release/angular-ui-router.min.js',
      'node_modules/angular-drag-and-drop-lists/angular-drag-and-drop-lists.js'
    ],

    // list of files to exclude
    exclude: [
      'client/main.js'
    ],

    preprocessors: {
      'src/**/*.html': 'ng-html2js',
      'test/**/*.html': 'ng-html2js',
      'src/**/*.js': "coverage"
    },

    ngHtml2JsPreprocessor: {
      stripPrefix: 'src/'
    },

    // use dots reporter, as travis terminal does not support escaping sequences
    // possible values: 'dots', 'progress'
    // CLI --reporters progress
    reporters: ['progress', 'junit', 'coverage'],

    junitReporter: {
      // will be resolved to basePath (in the same way as files/exclude patterns)
      outputFile: 'test/test-results.xml'
    },

    coverageReporter: {
      type: "lcov",
      dir: "coverage/"
    },

    // web server port
    // CLI --port 9876
    port: 9876,

    // enable / disable colors in the output (reporters and logs)
    // CLI --colors --no-colors
    colors: true,

    // level of logging
    // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    // CLI --log-level debug
    logLevel: config.LOG_WARN,

    // enable / disable watching file and executing tests whenever any file changes
    // CLI --auto-watch --no-auto-watch
    autoWatch: true,

    // Start these browsers, currently available:
    // - Chrome
    // - ChromeCanary
    // - Firefox
    // - Opera
    // - Safari (only Mac)
    // - PhantomJS
    // - IE (only Windows)
    // CLI --browsers Chrome,Firefox,Safari
    browsers: [process.env.TRAVIS ? 'Firefox' : 'Chrome'],

    // If browser does not capture in given timeout [ms], kill it
    // CLI --capture-timeout 5000
    captureTimeout: 20000,

    // Auto run tests on start (when browsers are captured) and exit
    // CLI --single-run --no-single-run
    singleRun: false,

    // report which specs are slower than 500ms
    // CLI --report-slower-than 500
    reportSlowerThan: 500
  });
};
