<?php

declare(strict_types=1);

namespace Rector\NodeAnalyzer;

use PhpParser\Node\Expr\FuncCall;
use PhpParser\Node\Expr\MethodCall;
use PhpParser\Node\Expr\StaticCall;
use PHPStan\Reflection\FunctionReflection;
use PHPStan\Reflection\MethodReflection;
use Rector\Reflection\ReflectionResolver;

final readonly class VariadicAnalyzer
{
    public function __construct(
        private ReflectionResolver $reflectionResolver
    ) {
    }

    public function hasVariadicParameters(FuncCall | StaticCall | MethodCall $call): bool
    {
        $functionLikeReflection = $this->reflectionResolver->resolveFunctionLikeReflectionFromCall($call);
        if ($functionLikeReflection === null) {
            return false;
        }

        return $this->hasVariadicVariant($functionLikeReflection);
    }

    private function hasVariadicVariant(MethodReflection | FunctionReflection $functionLikeReflection): bool
    {
        foreach ($functionLikeReflection->getVariants() as $variant) {
            // can be any number of arguments → nothing to limit here
            if ($variant->isVariadic()) {
                return true;
            }
        }

        return false;
    }
}
