# setup.py

import os
from distutils.core import setup
from distutils.extension import Extension
from Cython.Build import cythonize

DIRNAME = os.path.dirname(__file__)

# patch spa.c
with open(os.path.join(DIRNAME, 'spa.c'), 'rb') as f:
    SPA_C = f.read()
# replace timezone with time_zone to avoid nameclash with the function
# __timezone which is defined by a MACRO in pyconfig.h as timezone
# see https://bugs.python.org/issue24643
SPA_C = SPA_C.replace(b'timezone', b'time_zone')
with open(os.path.join(DIRNAME, 'spa.c'), 'wb') as f:
    f.write(SPA_C)

# patch spa.h
with open(os.path.join(DIRNAME, 'spa.h'), 'rb') as f:
    SPA_H = f.read()
# replace timezone with time_zone to avoid nameclash with the function
# __timezone which is defined by a MACRO in pyconfig.h as timezone
# see https://bugs.python.org/issue24643
SPA_H = SPA_H.replace(b'timezone', b'time_zone')
with open(os.path.join(DIRNAME, 'spa.h'), 'wb') as f:
    f.write(SPA_H)

SPA_SOURCES = [os.path.join(DIRNAME, src) for src in ['spa_py.pyx', 'spa.c']]

setup(
    ext_modules=cythonize([Extension('spa_py', SPA_SOURCES)])
)
