# GitHub OAuth

By default, Coder is accessible via built-in authentication. Alternatively, you
can configure Coder to enable logging in through GitHub OAuth. See below for
configuration steps.

## Step 1: Configure the OAuth application in GitHub

First, [https://developer.github.com/apps/building-oauth-apps/creating-an-oauth-app/](register a GitHub OAuth app). GitHub will ask you for the following Coder parameters:

- **Homepage URL**: Set to your Coder domain (e.g. `https://coder.domain.com`)
- **User Authorization Callback URL**: Set to `https://coder.domain.com/api/v2/users/oauth2/github/callback`

Note the Client ID and Client Secret generated by GitHub. You will use these
values in the next step.

## Step 2: Configure Coder with the OAuth credentials

Navigate to your Coder host and run the following command to start up the Coder
server:

```console
coder server --oauth2-github-allow-signups=true --oauth2-github-allowed-orgs="your-org" --oauth2-github-client-id="8d1...e05" --oauth2-github-client-secret="57ebc9...02c24c"
```

Alternatively, if you are running Coder as a system service, you can achieve the
same result as the command above by adding the following environment variables
to the `/etc/coder.d/coder.env` file:

```console
CODER_OAUTH2_GITHUB_ALLOW_SIGNUPS=true
CODER_OAUTH2_GITHUB_ALLOWED_ORGS="your-org"
CODER_OAUTH2_GITHUB_CLIENT_ID="8d1...e05"
CODER_OAUTH2_GITHUB_CLIENT_SECRET="57ebc9...02c24c"
```

Once complete, run `sudo service coder restart` to reboot Coder.
