[API categories](API-categories.md) | [API index](API-index.md)


# KeyboardHandler (interface)

This handler allows you to handle events related to keyboard input and is called only for the main frame. For an example of how to implement handler see [cefpython](cefpython.md).CreateBrowser().


Table of contents:
* [Callbacks](#callbacks)
  * [OnPreKeyEvent](#onprekeyevent)
  * [OnKeyEvent](#onkeyevent)


## Callbacks


### OnPreKeyEvent

| Parameter | Type |
| --- | --- |
| browser | [Browser](Browser.md) |
| event | KeyEvent |
| event_handle | MSG\* / GdkEvent\* / NSEvent\*` |
| is_keyboard_shortcut_out | list |
| __Return__ | bool |

Called before a keyboard event is sent to the renderer. |event| contains
information about the keyboard event. |event_handle| is the operating system
event message, if any. Return true if the event was handled or false
otherwise. If the event will be handled in OnKeyEvent() as a keyboard
shortcut, set |is_keyboard_shortcut_out[0]| to True and return False.

KeyEvent is a dictionary with the following keys:

| Key | Type | Description |
| --- | --- | --- |
| type | KeyEventType | The type of keyboard event |
| modifiers | KeyEventFlags | Bit flags describing any pressed modifier keys |
| windows_key_code | int | The Windows key code for the key event. This value is used by the DOM specification. Sometimes it comes directly from the event (i.e. on Windows) and sometimes it's determined using a mapping function. See "chromium/KeyboardCodes.h" for a list of values. |
| native_key_code | int | The actual key code genenerated by the platform |
| is_system_key | bool | Indicates whether the event is considered a "system key" event. For Windows see [WM_SYSKEYDOWN](http://msdn.microsoft.com/en-us/library/ms646286.aspx). This value will always be false on non-Windows platforms. |
| character | wchar_t or unsigned short | The character generated by the keystroke |
| unmodified_character | wchar_t or unsigned short | Same as 'character' but unmodified by any concurrently-held modifiers (except shift). This is useful for working out shortcut keys. |
| focus_on_editable_field | bool | True if the focus is currently on an editable field on the page. This is useful for determining if standard key events should be intercepted. |

KeyEventType constants defined in the cefpython module:
* KEYEVENT_RAWKEYDOWN - Notification that a key transitioned from
    "up" to "down".
* KEYEVENT_KEYDOWN - Notification that a key was pressed. This does not
    necessarily correspond to a character depending on the key and language.
    Use KEYEVENT_CHAR for character input.
* KEYEVENT_KEYUP - Notification that a key was released.
* KEYEVENT_CHAR - Notification that a character was typed. Use this for text
    input. Key down events may generate 0, 1, or more than one character
    event depending on the key, locale, and operating system.

KeyEventFlags constants defined in the cefpython module:
* EVENTFLAG_NONE
* EVENTFLAG_CAPS_LOCK_ON
* EVENTFLAG_SHIFT_DOWN
* EVENTFLAG_CONTROL_DOWN
* EVENTFLAG_ALT_DOWN
* EVENTFLAG_LEFT_MOUSE_BUTTON
* EVENTFLAG_MIDDLE_MOUSE_BUTTON
* EVENTFLAG_RIGHT_MOUSE_BUTTON
* EVENTFLAG_COMMAND_DOWN (Mac)
* EVENTFLAG_NUM_LOCK_ON (Mac)
* EVENTFLAG_IS_KEY_PAD (Mac)
* EVENTFLAG_IS_LEFT (Mac)
* EVENTFLAG_IS_RIGHT (Mac)


### OnKeyEvent

| Parameter | Type |
| --- | --- |
| browser | [Browser](Browser.md) |
| event | KeyEvent |
| event_handle | MSG\* / GdkEvent\* / NSEvent\* |
| __Return__ | bool |

Called after the renderer and javascript in the page has had a chance to
handle the event. |event| contains information about the keyboard event.
|os_event| is the operating system event message, if any. Return true if
the keyboard event was handled or false otherwise. Description of the
KeyEvent type is in the OnPreKeyEvent() callback.
