### March 14th

This week we made progress on several key features: File Search and Preview.
File Search got variable search and a lot faster. Preview got support for showing `this` and made progress towards properties.

We also migrated to Jest and got lots of polish from many nice folks!

[@arthur801031], [@jasonLaster], [@jcreighton], [@DanUgelow], [@wldcordeiro], [@aklt], [@bomsy], [@montogeek], [@MarkPollmann], [@jbhoosreddy], [@jryans], [@ThomasCrevoisier], [@AnshulMalik], [@rrandom], [@magsout], [@clarkbw], [@amitzur], [@irfanhudda], [@ryanjduffy]

#### UI

There were a lot of papercut fixes this week from seven different people.
The end result is that the debugger is feeling better every day.

I especially appreciate Mark's fix for large array buckets in RTL, which shows just how many edge cases there are in a debugger!

Also, big thanks to Dan and Guillaume, who's first PRs make the UI feel much more solid. Dan, lined up toggle buttons and command bar buttons and Guillaume fixed the way we calculated the Editor Height to reflect the footer.

* [Polish colors in dark theme][pr-35] - [@amitzur]
* [Make close button appear correctly upon opening the conditional panel][pr-8] - [@aklt]
* [fix for bucket range showing up backwards][pr-17] - [@MarkPollmann]
* [Increase pane toggle button size and margin][pr-3] - [@DanUgelow]
* [Fix command bar background][pr-6] - [@jasonLaster]
* [Fix typo in transition timing property value][pr-37] - [@irfanhudda]
* [fix the object inspector bug][pr-19] - [@bomsy]
* [Fixes Editor Height][pr-28] - [@magsout]


#### Editor

We're continue to add support for new languages and clean up some UI interaction like context menus.

* [add clojure syntax mode for editor (#2307)][pr-14] - [@jbhoosreddy]
* [Fix editor context menu][pr-15] - [@jasonLaster]
* [Follow up actors fix][pr-16] - [@bomsy]


#### File Search

File search continues to get a lot of love. We now support variable search in addition
to function search. We also did a lot of UI and UX polish!

* [Tweak the search bar appearance][pr-7] - [@jasonLaster]
* [Variable Search UI][pr-4] - [@wldcordeiro]
* [Cmd+f without a selection should refocus the search bar][pr-10] - [@aklt]
* [Trigger search when changing the type of symbol searched][pr-22] - [@ThomasCrevoisier]
* [Add a parser worker to the project.][pr-27] - [@wldcordeiro]
* [Improve searchbar and search performance on large files][pr-38] - [@ryanjduffy]

#### Preview

Preview is the other major feature that received a lot of love. We made progres on previewing member expressions, which in practice is every object property like `obj.foo.bar.bazz`. We also, landed support for preview `this`, which is a special property.

* [Begin member expressions][pr-9] - [@bomsy]
* [show `this` when it’s in scope][pr-18] - [@jcreighton]


#### Infrastructure

The two big infrastructure wins this week were:

1. switching to Jest, which will let us write unit tests for react components, gather coverage metrics, and write better tests with their mock library.
2. moving our source map worker to a separate package. This will let tools like the console and perf get source map support. I also hope other project will use it to translate bundle addresses into original adresses for instance `debugger.js#L2222` => `Editor/Searchbar.js#L12`

* [Migrate tests to jest][pr-11] [2][pr-30] [3][pr-20] - [@montogeek]
* [Add flow to ObjectInspector.js, Rep.js, Svg.js,...][pr-0] - [@arthur801031]
* [addExpression expected string not object][pr-2] - [@jcreighton]
* [Use devtools-source-map package, remove extracted files][pr-21] - [@jryans]
* [fix console error for selectedLocation][pr-24] - [@jbhoosreddy]
* [Fix failing test on windows][pr-25] - [@rrandom]
* [Update docker image][pr-29] - [@jasonLaster]

#### ES6 Refactoring

We continue to chip away at converting our source code to ES6 modules and classes. Big thanks to [@AnshulMalik] who's making a lot of progress here!

* [converted src/components/App.js to es6][pr-23] - [@AnshulMalik]
* [Refactor(ES6) src/components/Sources.js][pr-26] - [@AnshulMalik]
* [Refactor(ES6) src/components/SourcesTree.js][pr-31] - [@AnshulMalik]
* [Es module secondary panes][pr-32] - [@clarkbw]
* [convert WelcomeBox to es modules][pr-34] - [@clarkbw]

#### Docs

* [Update debugging-the-debugger.md][pr-13] - [@MarkPollmann]
* [#2335 : Mention the debugger examples repo on the getting setup docs][pr-33] - [@ThomasCrevoisier]


#### Clojure Syntax

|Old | New|
|-----|-----|
|![old-clojure]|![new-clojure]|

#### Editor Polish

![editor-polish]

#### Dark Theme Polish

|Before|After|
|---|--|
|![new-ui]|![old-ui]|

![](http://g.recordit.co/13KfTeqCFK.gif)


[old-clojure]:https://cloud.githubusercontent.com/assets/2481105/23819572/0d5333a2-05d6-11e7-8ba9-0ba5cdb89a3e.png
[new-clojure]:https://cloud.githubusercontent.com/assets/2481105/23818604/b623f2ca-05ca-11e7-8d99-12ad2f15a020.png

[old-ui]:https://cloud.githubusercontent.com/assets/254562/23834846/7995e376-0733-11e7-8172-9fc834147eb8.png
[new-ui]:https://cloud.githubusercontent.com/assets/254562/23834847/799a1982-0733-11e7-966f-99c64c66751f.png

[editor-polish]:https://cloud.githubusercontent.com/assets/254562/23680633/f0ad3ef6-0359-11e7-9241-96ff93ab079f.png

[pr-0]:https://github.com/devtools-html/debugger.html/pull/2295
[pr-1]:https://github.com/devtools-html/debugger.html/pull/2298
[pr-2]:https://github.com/devtools-html/debugger.html/pull/2303
[pr-3]:https://github.com/devtools-html/debugger.html/pull/2301
[pr-4]:https://github.com/devtools-html/debugger.html/pull/2251
[pr-5]:https://github.com/devtools-html/debugger.html/pull/2311
[pr-6]:https://github.com/devtools-html/debugger.html/pull/2308
[pr-7]:https://github.com/devtools-html/debugger.html/pull/2288
[pr-8]:https://github.com/devtools-html/debugger.html/pull/2314
[pr-9]:https://github.com/devtools-html/debugger.html/pull/2297
[pr-10]:https://github.com/devtools-html/debugger.html/pull/2247
[pr-11]:https://github.com/devtools-html/debugger.html/pull/2315
[pr-12]:https://github.com/devtools-html/debugger.html/pull/2322
[pr-13]:https://github.com/devtools-html/debugger.html/pull/2330
[pr-14]:https://github.com/devtools-html/debugger.html/pull/2313
[pr-15]:https://github.com/devtools-html/debugger.html/pull/2325
[pr-16]:https://github.com/devtools-html/debugger.html/pull/2338
[pr-17]:https://github.com/devtools-html/debugger.html/pull/2328
[pr-18]:https://github.com/devtools-html/debugger.html/pull/2340
[pr-19]:https://github.com/devtools-html/debugger.html/pull/2337
[pr-20]:https://github.com/devtools-html/debugger.html/pull/2320
[pr-21]:https://github.com/devtools-html/debugger.html/pull/2329
[pr-22]:https://github.com/devtools-html/debugger.html/pull/2346
[pr-23]:https://github.com/devtools-html/debugger.html/pull/2342
[pr-24]:https://github.com/devtools-html/debugger.html/pull/2334
[pr-25]:https://github.com/devtools-html/debugger.html/pull/2343
[pr-26]:https://github.com/devtools-html/debugger.html/pull/2345
[pr-27]:https://github.com/devtools-html/debugger.html/pull/2312
[pr-28]:https://github.com/devtools-html/debugger.html/pull/2331
[pr-29]:https://github.com/devtools-html/debugger.html/pull/2361
[pr-30]:https://github.com/devtools-html/debugger.html/pull/2354
[pr-31]:https://github.com/devtools-html/debugger.html/pull/2353
[pr-32]:https://github.com/devtools-html/debugger.html/pull/2352
[pr-33]:https://github.com/devtools-html/debugger.html/pull/2356
[pr-34]:https://github.com/devtools-html/debugger.html/pull/2348
[pr-35]:https://github.com/devtools-html/debugger.html/pull/2344
[pr-36]:https://github.com/devtools-html/debugger.html/pull/2360
[pr-37]:https://github.com/devtools-html/debugger.html/pull/2358
[pr-38]:https://github.com/devtools-html/debugger.html/pull/2332
[@arthur801031]:http://github.com/arthur801031
[@jasonLaster]:http://github.com/jasonLaster
[@jcreighton]:http://github.com/jcreighton
[@DanUgelow]:http://github.com/DanUgelow
[@wldcordeiro]:http://github.com/wldcordeiro
[@aklt]:http://github.com/aklt
[@bomsy]:http://github.com/bomsy
[@montogeek]:http://github.com/montogeek
[@MarkPollmann]:http://github.com/MarkPollmann
[@jbhoosreddy]:http://github.com/jbhoosreddy
[@jryans]:http://github.com/jryans
[@ThomasCrevoisier]:http://github.com/ThomasCrevoisier
[@AnshulMalik]:http://github.com/AnshulMalik
[@rrandom]:http://github.com/rrandom
[@magsout]:http://github.com/magsout
[@clarkbw]:http://github.com/clarkbw
[@amitzur]:http://github.com/amitzur
[@irfanhudda]:http://github.com/irfanhudda
[@ryanjduffy]:http://github.com/ryanjduffy
