// Copyright 2012-2018 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// NOTE: The following code was generated by "scripts/unicode.py", do not edit directly

#![allow(missing_docs)]
#[derive(Debug)]
pub struct NormalizationTest {
    pub source: &'static str,
    pub nfc: &'static str,
    pub nfd: &'static str,
    pub nfkc: &'static str,
    pub nfkd: &'static str,
}

pub const NORMALIZATION_TESTS: &[NormalizationTest] = &[
    NormalizationTest {
        source: "\u{1E0A}",
        nfc: "\u{1E0A}",
        nfd: "\u{0044}\u{0307}",
        nfkc: "\u{1E0A}",
        nfkd: "\u{0044}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E0C}",
        nfc: "\u{1E0C}",
        nfd: "\u{0044}\u{0323}",
        nfkc: "\u{1E0C}",
        nfkd: "\u{0044}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E0A}\u{0323}",
        nfc: "\u{1E0C}\u{0307}",
        nfd: "\u{0044}\u{0323}\u{0307}",
        nfkc: "\u{1E0C}\u{0307}",
        nfkd: "\u{0044}\u{0323}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E0C}\u{0307}",
        nfc: "\u{1E0C}\u{0307}",
        nfd: "\u{0044}\u{0323}\u{0307}",
        nfkc: "\u{1E0C}\u{0307}",
        nfkd: "\u{0044}\u{0323}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0044}\u{0307}\u{0323}",
        nfc: "\u{1E0C}\u{0307}",
        nfd: "\u{0044}\u{0323}\u{0307}",
        nfkc: "\u{1E0C}\u{0307}",
        nfkd: "\u{0044}\u{0323}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0044}\u{0323}\u{0307}",
        nfc: "\u{1E0C}\u{0307}",
        nfd: "\u{0044}\u{0323}\u{0307}",
        nfkc: "\u{1E0C}\u{0307}",
        nfkd: "\u{0044}\u{0323}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E0A}\u{031B}",
        nfc: "\u{1E0A}\u{031B}",
        nfd: "\u{0044}\u{031B}\u{0307}",
        nfkc: "\u{1E0A}\u{031B}",
        nfkd: "\u{0044}\u{031B}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E0C}\u{031B}",
        nfc: "\u{1E0C}\u{031B}",
        nfd: "\u{0044}\u{031B}\u{0323}",
        nfkc: "\u{1E0C}\u{031B}",
        nfkd: "\u{0044}\u{031B}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E0A}\u{031B}\u{0323}",
        nfc: "\u{1E0C}\u{031B}\u{0307}",
        nfd: "\u{0044}\u{031B}\u{0323}\u{0307}",
        nfkc: "\u{1E0C}\u{031B}\u{0307}",
        nfkd: "\u{0044}\u{031B}\u{0323}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E0C}\u{031B}\u{0307}",
        nfc: "\u{1E0C}\u{031B}\u{0307}",
        nfd: "\u{0044}\u{031B}\u{0323}\u{0307}",
        nfkc: "\u{1E0C}\u{031B}\u{0307}",
        nfkd: "\u{0044}\u{031B}\u{0323}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0044}\u{031B}\u{0307}\u{0323}",
        nfc: "\u{1E0C}\u{031B}\u{0307}",
        nfd: "\u{0044}\u{031B}\u{0323}\u{0307}",
        nfkc: "\u{1E0C}\u{031B}\u{0307}",
        nfkd: "\u{0044}\u{031B}\u{0323}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0044}\u{031B}\u{0323}\u{0307}",
        nfc: "\u{1E0C}\u{031B}\u{0307}",
        nfd: "\u{0044}\u{031B}\u{0323}\u{0307}",
        nfkc: "\u{1E0C}\u{031B}\u{0307}",
        nfkd: "\u{0044}\u{031B}\u{0323}\u{0307}",
    },
    NormalizationTest {
        source: "\u{00C8}",
        nfc: "\u{00C8}",
        nfd: "\u{0045}\u{0300}",
        nfkc: "\u{00C8}",
        nfkd: "\u{0045}\u{0300}",
    },
    NormalizationTest {
        source: "\u{0112}",
        nfc: "\u{0112}",
        nfd: "\u{0045}\u{0304}",
        nfkc: "\u{0112}",
        nfkd: "\u{0045}\u{0304}",
    },
    NormalizationTest {
        source: "\u{0045}\u{0300}",
        nfc: "\u{00C8}",
        nfd: "\u{0045}\u{0300}",
        nfkc: "\u{00C8}",
        nfkd: "\u{0045}\u{0300}",
    },
    NormalizationTest {
        source: "\u{0045}\u{0304}",
        nfc: "\u{0112}",
        nfd: "\u{0045}\u{0304}",
        nfkc: "\u{0112}",
        nfkd: "\u{0045}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1E14}",
        nfc: "\u{1E14}",
        nfd: "\u{0045}\u{0304}\u{0300}",
        nfkc: "\u{1E14}",
        nfkd: "\u{0045}\u{0304}\u{0300}",
    },
    NormalizationTest {
        source: "\u{0112}\u{0300}",
        nfc: "\u{1E14}",
        nfd: "\u{0045}\u{0304}\u{0300}",
        nfkc: "\u{1E14}",
        nfkd: "\u{0045}\u{0304}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1E14}\u{0304}",
        nfc: "\u{1E14}\u{0304}",
        nfd: "\u{0045}\u{0304}\u{0300}\u{0304}",
        nfkc: "\u{1E14}\u{0304}",
        nfkd: "\u{0045}\u{0304}\u{0300}\u{0304}",
    },
    NormalizationTest {
        source: "\u{0045}\u{0304}\u{0300}",
        nfc: "\u{1E14}",
        nfd: "\u{0045}\u{0304}\u{0300}",
        nfkc: "\u{1E14}",
        nfkd: "\u{0045}\u{0304}\u{0300}",
    },
    NormalizationTest {
        source: "\u{0045}\u{0300}\u{0304}",
        nfc: "\u{00C8}\u{0304}",
        nfd: "\u{0045}\u{0300}\u{0304}",
        nfkc: "\u{00C8}\u{0304}",
        nfkd: "\u{0045}\u{0300}\u{0304}",
    },
    NormalizationTest {
        source: "\u{05B8}\u{05B9}\u{05B1}\u{0591}\u{05C3}\u{05B0}\u{05AC}\u{059F}",
        nfc: "\u{05B1}\u{05B8}\u{05B9}\u{0591}\u{05C3}\u{05B0}\u{05AC}\u{059F}",
        nfd: "\u{05B1}\u{05B8}\u{05B9}\u{0591}\u{05C3}\u{05B0}\u{05AC}\u{059F}",
        nfkc: "\u{05B1}\u{05B8}\u{05B9}\u{0591}\u{05C3}\u{05B0}\u{05AC}\u{059F}",
        nfkd: "\u{05B1}\u{05B8}\u{05B9}\u{0591}\u{05C3}\u{05B0}\u{05AC}\u{059F}",
    },
    NormalizationTest {
        source: "\u{0592}\u{05B7}\u{05BC}\u{05A5}\u{05B0}\u{05C0}\u{05C4}\u{05AD}",
        nfc: "\u{05B0}\u{05B7}\u{05BC}\u{05A5}\u{0592}\u{05C0}\u{05AD}\u{05C4}",
        nfd: "\u{05B0}\u{05B7}\u{05BC}\u{05A5}\u{0592}\u{05C0}\u{05AD}\u{05C4}",
        nfkc: "\u{05B0}\u{05B7}\u{05BC}\u{05A5}\u{0592}\u{05C0}\u{05AD}\u{05C4}",
        nfkd: "\u{05B0}\u{05B7}\u{05BC}\u{05A5}\u{0592}\u{05C0}\u{05AD}\u{05C4}",
    },
    NormalizationTest {
        source: "\u{1100}\u{AC00}\u{11A8}",
        nfc: "\u{1100}\u{AC01}",
        nfd: "\u{1100}\u{1100}\u{1161}\u{11A8}",
        nfkc: "\u{1100}\u{AC01}",
        nfkd: "\u{1100}\u{1100}\u{1161}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{1100}\u{AC00}\u{11A8}\u{11A8}",
        nfc: "\u{1100}\u{AC01}\u{11A8}",
        nfd: "\u{1100}\u{1100}\u{1161}\u{11A8}\u{11A8}",
        nfkc: "\u{1100}\u{AC01}\u{11A8}",
        nfkd: "\u{1100}\u{1100}\u{1161}\u{11A8}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{00A0}",
        nfc: "\u{00A0}",
        nfd: "\u{00A0}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{00A8}",
        nfc: "\u{00A8}",
        nfd: "\u{00A8}",
        nfkc: "\u{0020}\u{0308}",
        nfkd: "\u{0020}\u{0308}",
    },
    NormalizationTest {
        source: "\u{00AA}",
        nfc: "\u{00AA}",
        nfd: "\u{00AA}",
        nfkc: "\u{0061}",
        nfkd: "\u{0061}",
    },
    NormalizationTest {
        source: "\u{00AF}",
        nfc: "\u{00AF}",
        nfd: "\u{00AF}",
        nfkc: "\u{0020}\u{0304}",
        nfkd: "\u{0020}\u{0304}",
    },
    NormalizationTest {
        source: "\u{00B2}",
        nfc: "\u{00B2}",
        nfd: "\u{00B2}",
        nfkc: "\u{0032}",
        nfkd: "\u{0032}",
    },
    NormalizationTest {
        source: "\u{00B3}",
        nfc: "\u{00B3}",
        nfd: "\u{00B3}",
        nfkc: "\u{0033}",
        nfkd: "\u{0033}",
    },
    NormalizationTest {
        source: "\u{00B4}",
        nfc: "\u{00B4}",
        nfd: "\u{00B4}",
        nfkc: "\u{0020}\u{0301}",
        nfkd: "\u{0020}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00B5}",
        nfc: "\u{00B5}",
        nfd: "\u{00B5}",
        nfkc: "\u{03BC}",
        nfkd: "\u{03BC}",
    },
    NormalizationTest {
        source: "\u{00B8}",
        nfc: "\u{00B8}",
        nfd: "\u{00B8}",
        nfkc: "\u{0020}\u{0327}",
        nfkd: "\u{0020}\u{0327}",
    },
    NormalizationTest {
        source: "\u{00B9}",
        nfc: "\u{00B9}",
        nfd: "\u{00B9}",
        nfkc: "\u{0031}",
        nfkd: "\u{0031}",
    },
    NormalizationTest {
        source: "\u{00BA}",
        nfc: "\u{00BA}",
        nfd: "\u{00BA}",
        nfkc: "\u{006F}",
        nfkd: "\u{006F}",
    },
    NormalizationTest {
        source: "\u{00BC}",
        nfc: "\u{00BC}",
        nfd: "\u{00BC}",
        nfkc: "\u{0031}\u{2044}\u{0034}",
        nfkd: "\u{0031}\u{2044}\u{0034}",
    },
    NormalizationTest {
        source: "\u{00BD}",
        nfc: "\u{00BD}",
        nfd: "\u{00BD}",
        nfkc: "\u{0031}\u{2044}\u{0032}",
        nfkd: "\u{0031}\u{2044}\u{0032}",
    },
    NormalizationTest {
        source: "\u{00BE}",
        nfc: "\u{00BE}",
        nfd: "\u{00BE}",
        nfkc: "\u{0033}\u{2044}\u{0034}",
        nfkd: "\u{0033}\u{2044}\u{0034}",
    },
    NormalizationTest {
        source: "\u{00C0}",
        nfc: "\u{00C0}",
        nfd: "\u{0041}\u{0300}",
        nfkc: "\u{00C0}",
        nfkd: "\u{0041}\u{0300}",
    },
    NormalizationTest {
        source: "\u{00C1}",
        nfc: "\u{00C1}",
        nfd: "\u{0041}\u{0301}",
        nfkc: "\u{00C1}",
        nfkd: "\u{0041}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00C2}",
        nfc: "\u{00C2}",
        nfd: "\u{0041}\u{0302}",
        nfkc: "\u{00C2}",
        nfkd: "\u{0041}\u{0302}",
    },
    NormalizationTest {
        source: "\u{00C3}",
        nfc: "\u{00C3}",
        nfd: "\u{0041}\u{0303}",
        nfkc: "\u{00C3}",
        nfkd: "\u{0041}\u{0303}",
    },
    NormalizationTest {
        source: "\u{00C4}",
        nfc: "\u{00C4}",
        nfd: "\u{0041}\u{0308}",
        nfkc: "\u{00C4}",
        nfkd: "\u{0041}\u{0308}",
    },
    NormalizationTest {
        source: "\u{00C5}",
        nfc: "\u{00C5}",
        nfd: "\u{0041}\u{030A}",
        nfkc: "\u{00C5}",
        nfkd: "\u{0041}\u{030A}",
    },
    NormalizationTest {
        source: "\u{00C7}",
        nfc: "\u{00C7}",
        nfd: "\u{0043}\u{0327}",
        nfkc: "\u{00C7}",
        nfkd: "\u{0043}\u{0327}",
    },
    NormalizationTest {
        source: "\u{00C8}",
        nfc: "\u{00C8}",
        nfd: "\u{0045}\u{0300}",
        nfkc: "\u{00C8}",
        nfkd: "\u{0045}\u{0300}",
    },
    NormalizationTest {
        source: "\u{00C9}",
        nfc: "\u{00C9}",
        nfd: "\u{0045}\u{0301}",
        nfkc: "\u{00C9}",
        nfkd: "\u{0045}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00CA}",
        nfc: "\u{00CA}",
        nfd: "\u{0045}\u{0302}",
        nfkc: "\u{00CA}",
        nfkd: "\u{0045}\u{0302}",
    },
    NormalizationTest {
        source: "\u{00CB}",
        nfc: "\u{00CB}",
        nfd: "\u{0045}\u{0308}",
        nfkc: "\u{00CB}",
        nfkd: "\u{0045}\u{0308}",
    },
    NormalizationTest {
        source: "\u{00CC}",
        nfc: "\u{00CC}",
        nfd: "\u{0049}\u{0300}",
        nfkc: "\u{00CC}",
        nfkd: "\u{0049}\u{0300}",
    },
    NormalizationTest {
        source: "\u{00CD}",
        nfc: "\u{00CD}",
        nfd: "\u{0049}\u{0301}",
        nfkc: "\u{00CD}",
        nfkd: "\u{0049}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00CE}",
        nfc: "\u{00CE}",
        nfd: "\u{0049}\u{0302}",
        nfkc: "\u{00CE}",
        nfkd: "\u{0049}\u{0302}",
    },
    NormalizationTest {
        source: "\u{00CF}",
        nfc: "\u{00CF}",
        nfd: "\u{0049}\u{0308}",
        nfkc: "\u{00CF}",
        nfkd: "\u{0049}\u{0308}",
    },
    NormalizationTest {
        source: "\u{00D1}",
        nfc: "\u{00D1}",
        nfd: "\u{004E}\u{0303}",
        nfkc: "\u{00D1}",
        nfkd: "\u{004E}\u{0303}",
    },
    NormalizationTest {
        source: "\u{00D2}",
        nfc: "\u{00D2}",
        nfd: "\u{004F}\u{0300}",
        nfkc: "\u{00D2}",
        nfkd: "\u{004F}\u{0300}",
    },
    NormalizationTest {
        source: "\u{00D3}",
        nfc: "\u{00D3}",
        nfd: "\u{004F}\u{0301}",
        nfkc: "\u{00D3}",
        nfkd: "\u{004F}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00D4}",
        nfc: "\u{00D4}",
        nfd: "\u{004F}\u{0302}",
        nfkc: "\u{00D4}",
        nfkd: "\u{004F}\u{0302}",
    },
    NormalizationTest {
        source: "\u{00D5}",
        nfc: "\u{00D5}",
        nfd: "\u{004F}\u{0303}",
        nfkc: "\u{00D5}",
        nfkd: "\u{004F}\u{0303}",
    },
    NormalizationTest {
        source: "\u{00D6}",
        nfc: "\u{00D6}",
        nfd: "\u{004F}\u{0308}",
        nfkc: "\u{00D6}",
        nfkd: "\u{004F}\u{0308}",
    },
    NormalizationTest {
        source: "\u{00D9}",
        nfc: "\u{00D9}",
        nfd: "\u{0055}\u{0300}",
        nfkc: "\u{00D9}",
        nfkd: "\u{0055}\u{0300}",
    },
    NormalizationTest {
        source: "\u{00DA}",
        nfc: "\u{00DA}",
        nfd: "\u{0055}\u{0301}",
        nfkc: "\u{00DA}",
        nfkd: "\u{0055}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00DB}",
        nfc: "\u{00DB}",
        nfd: "\u{0055}\u{0302}",
        nfkc: "\u{00DB}",
        nfkd: "\u{0055}\u{0302}",
    },
    NormalizationTest {
        source: "\u{00DC}",
        nfc: "\u{00DC}",
        nfd: "\u{0055}\u{0308}",
        nfkc: "\u{00DC}",
        nfkd: "\u{0055}\u{0308}",
    },
    NormalizationTest {
        source: "\u{00DD}",
        nfc: "\u{00DD}",
        nfd: "\u{0059}\u{0301}",
        nfkc: "\u{00DD}",
        nfkd: "\u{0059}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00E0}",
        nfc: "\u{00E0}",
        nfd: "\u{0061}\u{0300}",
        nfkc: "\u{00E0}",
        nfkd: "\u{0061}\u{0300}",
    },
    NormalizationTest {
        source: "\u{00E1}",
        nfc: "\u{00E1}",
        nfd: "\u{0061}\u{0301}",
        nfkc: "\u{00E1}",
        nfkd: "\u{0061}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00E2}",
        nfc: "\u{00E2}",
        nfd: "\u{0061}\u{0302}",
        nfkc: "\u{00E2}",
        nfkd: "\u{0061}\u{0302}",
    },
    NormalizationTest {
        source: "\u{00E3}",
        nfc: "\u{00E3}",
        nfd: "\u{0061}\u{0303}",
        nfkc: "\u{00E3}",
        nfkd: "\u{0061}\u{0303}",
    },
    NormalizationTest {
        source: "\u{00E4}",
        nfc: "\u{00E4}",
        nfd: "\u{0061}\u{0308}",
        nfkc: "\u{00E4}",
        nfkd: "\u{0061}\u{0308}",
    },
    NormalizationTest {
        source: "\u{00E5}",
        nfc: "\u{00E5}",
        nfd: "\u{0061}\u{030A}",
        nfkc: "\u{00E5}",
        nfkd: "\u{0061}\u{030A}",
    },
    NormalizationTest {
        source: "\u{00E7}",
        nfc: "\u{00E7}",
        nfd: "\u{0063}\u{0327}",
        nfkc: "\u{00E7}",
        nfkd: "\u{0063}\u{0327}",
    },
    NormalizationTest {
        source: "\u{00E8}",
        nfc: "\u{00E8}",
        nfd: "\u{0065}\u{0300}",
        nfkc: "\u{00E8}",
        nfkd: "\u{0065}\u{0300}",
    },
    NormalizationTest {
        source: "\u{00E9}",
        nfc: "\u{00E9}",
        nfd: "\u{0065}\u{0301}",
        nfkc: "\u{00E9}",
        nfkd: "\u{0065}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00EA}",
        nfc: "\u{00EA}",
        nfd: "\u{0065}\u{0302}",
        nfkc: "\u{00EA}",
        nfkd: "\u{0065}\u{0302}",
    },
    NormalizationTest {
        source: "\u{00EB}",
        nfc: "\u{00EB}",
        nfd: "\u{0065}\u{0308}",
        nfkc: "\u{00EB}",
        nfkd: "\u{0065}\u{0308}",
    },
    NormalizationTest {
        source: "\u{00EC}",
        nfc: "\u{00EC}",
        nfd: "\u{0069}\u{0300}",
        nfkc: "\u{00EC}",
        nfkd: "\u{0069}\u{0300}",
    },
    NormalizationTest {
        source: "\u{00ED}",
        nfc: "\u{00ED}",
        nfd: "\u{0069}\u{0301}",
        nfkc: "\u{00ED}",
        nfkd: "\u{0069}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00EE}",
        nfc: "\u{00EE}",
        nfd: "\u{0069}\u{0302}",
        nfkc: "\u{00EE}",
        nfkd: "\u{0069}\u{0302}",
    },
    NormalizationTest {
        source: "\u{00EF}",
        nfc: "\u{00EF}",
        nfd: "\u{0069}\u{0308}",
        nfkc: "\u{00EF}",
        nfkd: "\u{0069}\u{0308}",
    },
    NormalizationTest {
        source: "\u{00F1}",
        nfc: "\u{00F1}",
        nfd: "\u{006E}\u{0303}",
        nfkc: "\u{00F1}",
        nfkd: "\u{006E}\u{0303}",
    },
    NormalizationTest {
        source: "\u{00F2}",
        nfc: "\u{00F2}",
        nfd: "\u{006F}\u{0300}",
        nfkc: "\u{00F2}",
        nfkd: "\u{006F}\u{0300}",
    },
    NormalizationTest {
        source: "\u{00F3}",
        nfc: "\u{00F3}",
        nfd: "\u{006F}\u{0301}",
        nfkc: "\u{00F3}",
        nfkd: "\u{006F}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00F4}",
        nfc: "\u{00F4}",
        nfd: "\u{006F}\u{0302}",
        nfkc: "\u{00F4}",
        nfkd: "\u{006F}\u{0302}",
    },
    NormalizationTest {
        source: "\u{00F5}",
        nfc: "\u{00F5}",
        nfd: "\u{006F}\u{0303}",
        nfkc: "\u{00F5}",
        nfkd: "\u{006F}\u{0303}",
    },
    NormalizationTest {
        source: "\u{00F6}",
        nfc: "\u{00F6}",
        nfd: "\u{006F}\u{0308}",
        nfkc: "\u{00F6}",
        nfkd: "\u{006F}\u{0308}",
    },
    NormalizationTest {
        source: "\u{00F9}",
        nfc: "\u{00F9}",
        nfd: "\u{0075}\u{0300}",
        nfkc: "\u{00F9}",
        nfkd: "\u{0075}\u{0300}",
    },
    NormalizationTest {
        source: "\u{00FA}",
        nfc: "\u{00FA}",
        nfd: "\u{0075}\u{0301}",
        nfkc: "\u{00FA}",
        nfkd: "\u{0075}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00FB}",
        nfc: "\u{00FB}",
        nfd: "\u{0075}\u{0302}",
        nfkc: "\u{00FB}",
        nfkd: "\u{0075}\u{0302}",
    },
    NormalizationTest {
        source: "\u{00FC}",
        nfc: "\u{00FC}",
        nfd: "\u{0075}\u{0308}",
        nfkc: "\u{00FC}",
        nfkd: "\u{0075}\u{0308}",
    },
    NormalizationTest {
        source: "\u{00FD}",
        nfc: "\u{00FD}",
        nfd: "\u{0079}\u{0301}",
        nfkc: "\u{00FD}",
        nfkd: "\u{0079}\u{0301}",
    },
    NormalizationTest {
        source: "\u{00FF}",
        nfc: "\u{00FF}",
        nfd: "\u{0079}\u{0308}",
        nfkc: "\u{00FF}",
        nfkd: "\u{0079}\u{0308}",
    },
    NormalizationTest {
        source: "\u{0100}",
        nfc: "\u{0100}",
        nfd: "\u{0041}\u{0304}",
        nfkc: "\u{0100}",
        nfkd: "\u{0041}\u{0304}",
    },
    NormalizationTest {
        source: "\u{0101}",
        nfc: "\u{0101}",
        nfd: "\u{0061}\u{0304}",
        nfkc: "\u{0101}",
        nfkd: "\u{0061}\u{0304}",
    },
    NormalizationTest {
        source: "\u{0102}",
        nfc: "\u{0102}",
        nfd: "\u{0041}\u{0306}",
        nfkc: "\u{0102}",
        nfkd: "\u{0041}\u{0306}",
    },
    NormalizationTest {
        source: "\u{0103}",
        nfc: "\u{0103}",
        nfd: "\u{0061}\u{0306}",
        nfkc: "\u{0103}",
        nfkd: "\u{0061}\u{0306}",
    },
    NormalizationTest {
        source: "\u{0104}",
        nfc: "\u{0104}",
        nfd: "\u{0041}\u{0328}",
        nfkc: "\u{0104}",
        nfkd: "\u{0041}\u{0328}",
    },
    NormalizationTest {
        source: "\u{0105}",
        nfc: "\u{0105}",
        nfd: "\u{0061}\u{0328}",
        nfkc: "\u{0105}",
        nfkd: "\u{0061}\u{0328}",
    },
    NormalizationTest {
        source: "\u{0106}",
        nfc: "\u{0106}",
        nfd: "\u{0043}\u{0301}",
        nfkc: "\u{0106}",
        nfkd: "\u{0043}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0107}",
        nfc: "\u{0107}",
        nfd: "\u{0063}\u{0301}",
        nfkc: "\u{0107}",
        nfkd: "\u{0063}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0108}",
        nfc: "\u{0108}",
        nfd: "\u{0043}\u{0302}",
        nfkc: "\u{0108}",
        nfkd: "\u{0043}\u{0302}",
    },
    NormalizationTest {
        source: "\u{0109}",
        nfc: "\u{0109}",
        nfd: "\u{0063}\u{0302}",
        nfkc: "\u{0109}",
        nfkd: "\u{0063}\u{0302}",
    },
    NormalizationTest {
        source: "\u{010A}",
        nfc: "\u{010A}",
        nfd: "\u{0043}\u{0307}",
        nfkc: "\u{010A}",
        nfkd: "\u{0043}\u{0307}",
    },
    NormalizationTest {
        source: "\u{010B}",
        nfc: "\u{010B}",
        nfd: "\u{0063}\u{0307}",
        nfkc: "\u{010B}",
        nfkd: "\u{0063}\u{0307}",
    },
    NormalizationTest {
        source: "\u{010C}",
        nfc: "\u{010C}",
        nfd: "\u{0043}\u{030C}",
        nfkc: "\u{010C}",
        nfkd: "\u{0043}\u{030C}",
    },
    NormalizationTest {
        source: "\u{010D}",
        nfc: "\u{010D}",
        nfd: "\u{0063}\u{030C}",
        nfkc: "\u{010D}",
        nfkd: "\u{0063}\u{030C}",
    },
    NormalizationTest {
        source: "\u{010E}",
        nfc: "\u{010E}",
        nfd: "\u{0044}\u{030C}",
        nfkc: "\u{010E}",
        nfkd: "\u{0044}\u{030C}",
    },
    NormalizationTest {
        source: "\u{010F}",
        nfc: "\u{010F}",
        nfd: "\u{0064}\u{030C}",
        nfkc: "\u{010F}",
        nfkd: "\u{0064}\u{030C}",
    },
    NormalizationTest {
        source: "\u{0112}",
        nfc: "\u{0112}",
        nfd: "\u{0045}\u{0304}",
        nfkc: "\u{0112}",
        nfkd: "\u{0045}\u{0304}",
    },
    NormalizationTest {
        source: "\u{0113}",
        nfc: "\u{0113}",
        nfd: "\u{0065}\u{0304}",
        nfkc: "\u{0113}",
        nfkd: "\u{0065}\u{0304}",
    },
    NormalizationTest {
        source: "\u{0114}",
        nfc: "\u{0114}",
        nfd: "\u{0045}\u{0306}",
        nfkc: "\u{0114}",
        nfkd: "\u{0045}\u{0306}",
    },
    NormalizationTest {
        source: "\u{0115}",
        nfc: "\u{0115}",
        nfd: "\u{0065}\u{0306}",
        nfkc: "\u{0115}",
        nfkd: "\u{0065}\u{0306}",
    },
    NormalizationTest {
        source: "\u{0116}",
        nfc: "\u{0116}",
        nfd: "\u{0045}\u{0307}",
        nfkc: "\u{0116}",
        nfkd: "\u{0045}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0117}",
        nfc: "\u{0117}",
        nfd: "\u{0065}\u{0307}",
        nfkc: "\u{0117}",
        nfkd: "\u{0065}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0118}",
        nfc: "\u{0118}",
        nfd: "\u{0045}\u{0328}",
        nfkc: "\u{0118}",
        nfkd: "\u{0045}\u{0328}",
    },
    NormalizationTest {
        source: "\u{0119}",
        nfc: "\u{0119}",
        nfd: "\u{0065}\u{0328}",
        nfkc: "\u{0119}",
        nfkd: "\u{0065}\u{0328}",
    },
    NormalizationTest {
        source: "\u{011A}",
        nfc: "\u{011A}",
        nfd: "\u{0045}\u{030C}",
        nfkc: "\u{011A}",
        nfkd: "\u{0045}\u{030C}",
    },
    NormalizationTest {
        source: "\u{011B}",
        nfc: "\u{011B}",
        nfd: "\u{0065}\u{030C}",
        nfkc: "\u{011B}",
        nfkd: "\u{0065}\u{030C}",
    },
    NormalizationTest {
        source: "\u{011C}",
        nfc: "\u{011C}",
        nfd: "\u{0047}\u{0302}",
        nfkc: "\u{011C}",
        nfkd: "\u{0047}\u{0302}",
    },
    NormalizationTest {
        source: "\u{011D}",
        nfc: "\u{011D}",
        nfd: "\u{0067}\u{0302}",
        nfkc: "\u{011D}",
        nfkd: "\u{0067}\u{0302}",
    },
    NormalizationTest {
        source: "\u{011E}",
        nfc: "\u{011E}",
        nfd: "\u{0047}\u{0306}",
        nfkc: "\u{011E}",
        nfkd: "\u{0047}\u{0306}",
    },
    NormalizationTest {
        source: "\u{011F}",
        nfc: "\u{011F}",
        nfd: "\u{0067}\u{0306}",
        nfkc: "\u{011F}",
        nfkd: "\u{0067}\u{0306}",
    },
    NormalizationTest {
        source: "\u{0120}",
        nfc: "\u{0120}",
        nfd: "\u{0047}\u{0307}",
        nfkc: "\u{0120}",
        nfkd: "\u{0047}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0121}",
        nfc: "\u{0121}",
        nfd: "\u{0067}\u{0307}",
        nfkc: "\u{0121}",
        nfkd: "\u{0067}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0122}",
        nfc: "\u{0122}",
        nfd: "\u{0047}\u{0327}",
        nfkc: "\u{0122}",
        nfkd: "\u{0047}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0123}",
        nfc: "\u{0123}",
        nfd: "\u{0067}\u{0327}",
        nfkc: "\u{0123}",
        nfkd: "\u{0067}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0124}",
        nfc: "\u{0124}",
        nfd: "\u{0048}\u{0302}",
        nfkc: "\u{0124}",
        nfkd: "\u{0048}\u{0302}",
    },
    NormalizationTest {
        source: "\u{0125}",
        nfc: "\u{0125}",
        nfd: "\u{0068}\u{0302}",
        nfkc: "\u{0125}",
        nfkd: "\u{0068}\u{0302}",
    },
    NormalizationTest {
        source: "\u{0128}",
        nfc: "\u{0128}",
        nfd: "\u{0049}\u{0303}",
        nfkc: "\u{0128}",
        nfkd: "\u{0049}\u{0303}",
    },
    NormalizationTest {
        source: "\u{0129}",
        nfc: "\u{0129}",
        nfd: "\u{0069}\u{0303}",
        nfkc: "\u{0129}",
        nfkd: "\u{0069}\u{0303}",
    },
    NormalizationTest {
        source: "\u{012A}",
        nfc: "\u{012A}",
        nfd: "\u{0049}\u{0304}",
        nfkc: "\u{012A}",
        nfkd: "\u{0049}\u{0304}",
    },
    NormalizationTest {
        source: "\u{012B}",
        nfc: "\u{012B}",
        nfd: "\u{0069}\u{0304}",
        nfkc: "\u{012B}",
        nfkd: "\u{0069}\u{0304}",
    },
    NormalizationTest {
        source: "\u{012C}",
        nfc: "\u{012C}",
        nfd: "\u{0049}\u{0306}",
        nfkc: "\u{012C}",
        nfkd: "\u{0049}\u{0306}",
    },
    NormalizationTest {
        source: "\u{012D}",
        nfc: "\u{012D}",
        nfd: "\u{0069}\u{0306}",
        nfkc: "\u{012D}",
        nfkd: "\u{0069}\u{0306}",
    },
    NormalizationTest {
        source: "\u{012E}",
        nfc: "\u{012E}",
        nfd: "\u{0049}\u{0328}",
        nfkc: "\u{012E}",
        nfkd: "\u{0049}\u{0328}",
    },
    NormalizationTest {
        source: "\u{012F}",
        nfc: "\u{012F}",
        nfd: "\u{0069}\u{0328}",
        nfkc: "\u{012F}",
        nfkd: "\u{0069}\u{0328}",
    },
    NormalizationTest {
        source: "\u{0130}",
        nfc: "\u{0130}",
        nfd: "\u{0049}\u{0307}",
        nfkc: "\u{0130}",
        nfkd: "\u{0049}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0132}",
        nfc: "\u{0132}",
        nfd: "\u{0132}",
        nfkc: "\u{0049}\u{004A}",
        nfkd: "\u{0049}\u{004A}",
    },
    NormalizationTest {
        source: "\u{0133}",
        nfc: "\u{0133}",
        nfd: "\u{0133}",
        nfkc: "\u{0069}\u{006A}",
        nfkd: "\u{0069}\u{006A}",
    },
    NormalizationTest {
        source: "\u{0134}",
        nfc: "\u{0134}",
        nfd: "\u{004A}\u{0302}",
        nfkc: "\u{0134}",
        nfkd: "\u{004A}\u{0302}",
    },
    NormalizationTest {
        source: "\u{0135}",
        nfc: "\u{0135}",
        nfd: "\u{006A}\u{0302}",
        nfkc: "\u{0135}",
        nfkd: "\u{006A}\u{0302}",
    },
    NormalizationTest {
        source: "\u{0136}",
        nfc: "\u{0136}",
        nfd: "\u{004B}\u{0327}",
        nfkc: "\u{0136}",
        nfkd: "\u{004B}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0137}",
        nfc: "\u{0137}",
        nfd: "\u{006B}\u{0327}",
        nfkc: "\u{0137}",
        nfkd: "\u{006B}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0139}",
        nfc: "\u{0139}",
        nfd: "\u{004C}\u{0301}",
        nfkc: "\u{0139}",
        nfkd: "\u{004C}\u{0301}",
    },
    NormalizationTest {
        source: "\u{013A}",
        nfc: "\u{013A}",
        nfd: "\u{006C}\u{0301}",
        nfkc: "\u{013A}",
        nfkd: "\u{006C}\u{0301}",
    },
    NormalizationTest {
        source: "\u{013B}",
        nfc: "\u{013B}",
        nfd: "\u{004C}\u{0327}",
        nfkc: "\u{013B}",
        nfkd: "\u{004C}\u{0327}",
    },
    NormalizationTest {
        source: "\u{013C}",
        nfc: "\u{013C}",
        nfd: "\u{006C}\u{0327}",
        nfkc: "\u{013C}",
        nfkd: "\u{006C}\u{0327}",
    },
    NormalizationTest {
        source: "\u{013D}",
        nfc: "\u{013D}",
        nfd: "\u{004C}\u{030C}",
        nfkc: "\u{013D}",
        nfkd: "\u{004C}\u{030C}",
    },
    NormalizationTest {
        source: "\u{013E}",
        nfc: "\u{013E}",
        nfd: "\u{006C}\u{030C}",
        nfkc: "\u{013E}",
        nfkd: "\u{006C}\u{030C}",
    },
    NormalizationTest {
        source: "\u{013F}",
        nfc: "\u{013F}",
        nfd: "\u{013F}",
        nfkc: "\u{004C}\u{00B7}",
        nfkd: "\u{004C}\u{00B7}",
    },
    NormalizationTest {
        source: "\u{0140}",
        nfc: "\u{0140}",
        nfd: "\u{0140}",
        nfkc: "\u{006C}\u{00B7}",
        nfkd: "\u{006C}\u{00B7}",
    },
    NormalizationTest {
        source: "\u{0143}",
        nfc: "\u{0143}",
        nfd: "\u{004E}\u{0301}",
        nfkc: "\u{0143}",
        nfkd: "\u{004E}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0144}",
        nfc: "\u{0144}",
        nfd: "\u{006E}\u{0301}",
        nfkc: "\u{0144}",
        nfkd: "\u{006E}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0145}",
        nfc: "\u{0145}",
        nfd: "\u{004E}\u{0327}",
        nfkc: "\u{0145}",
        nfkd: "\u{004E}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0146}",
        nfc: "\u{0146}",
        nfd: "\u{006E}\u{0327}",
        nfkc: "\u{0146}",
        nfkd: "\u{006E}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0147}",
        nfc: "\u{0147}",
        nfd: "\u{004E}\u{030C}",
        nfkc: "\u{0147}",
        nfkd: "\u{004E}\u{030C}",
    },
    NormalizationTest {
        source: "\u{0148}",
        nfc: "\u{0148}",
        nfd: "\u{006E}\u{030C}",
        nfkc: "\u{0148}",
        nfkd: "\u{006E}\u{030C}",
    },
    NormalizationTest {
        source: "\u{0149}",
        nfc: "\u{0149}",
        nfd: "\u{0149}",
        nfkc: "\u{02BC}\u{006E}",
        nfkd: "\u{02BC}\u{006E}",
    },
    NormalizationTest {
        source: "\u{014C}",
        nfc: "\u{014C}",
        nfd: "\u{004F}\u{0304}",
        nfkc: "\u{014C}",
        nfkd: "\u{004F}\u{0304}",
    },
    NormalizationTest {
        source: "\u{014D}",
        nfc: "\u{014D}",
        nfd: "\u{006F}\u{0304}",
        nfkc: "\u{014D}",
        nfkd: "\u{006F}\u{0304}",
    },
    NormalizationTest {
        source: "\u{014E}",
        nfc: "\u{014E}",
        nfd: "\u{004F}\u{0306}",
        nfkc: "\u{014E}",
        nfkd: "\u{004F}\u{0306}",
    },
    NormalizationTest {
        source: "\u{014F}",
        nfc: "\u{014F}",
        nfd: "\u{006F}\u{0306}",
        nfkc: "\u{014F}",
        nfkd: "\u{006F}\u{0306}",
    },
    NormalizationTest {
        source: "\u{0150}",
        nfc: "\u{0150}",
        nfd: "\u{004F}\u{030B}",
        nfkc: "\u{0150}",
        nfkd: "\u{004F}\u{030B}",
    },
    NormalizationTest {
        source: "\u{0151}",
        nfc: "\u{0151}",
        nfd: "\u{006F}\u{030B}",
        nfkc: "\u{0151}",
        nfkd: "\u{006F}\u{030B}",
    },
    NormalizationTest {
        source: "\u{0154}",
        nfc: "\u{0154}",
        nfd: "\u{0052}\u{0301}",
        nfkc: "\u{0154}",
        nfkd: "\u{0052}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0155}",
        nfc: "\u{0155}",
        nfd: "\u{0072}\u{0301}",
        nfkc: "\u{0155}",
        nfkd: "\u{0072}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0156}",
        nfc: "\u{0156}",
        nfd: "\u{0052}\u{0327}",
        nfkc: "\u{0156}",
        nfkd: "\u{0052}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0157}",
        nfc: "\u{0157}",
        nfd: "\u{0072}\u{0327}",
        nfkc: "\u{0157}",
        nfkd: "\u{0072}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0158}",
        nfc: "\u{0158}",
        nfd: "\u{0052}\u{030C}",
        nfkc: "\u{0158}",
        nfkd: "\u{0052}\u{030C}",
    },
    NormalizationTest {
        source: "\u{0159}",
        nfc: "\u{0159}",
        nfd: "\u{0072}\u{030C}",
        nfkc: "\u{0159}",
        nfkd: "\u{0072}\u{030C}",
    },
    NormalizationTest {
        source: "\u{015A}",
        nfc: "\u{015A}",
        nfd: "\u{0053}\u{0301}",
        nfkc: "\u{015A}",
        nfkd: "\u{0053}\u{0301}",
    },
    NormalizationTest {
        source: "\u{015B}",
        nfc: "\u{015B}",
        nfd: "\u{0073}\u{0301}",
        nfkc: "\u{015B}",
        nfkd: "\u{0073}\u{0301}",
    },
    NormalizationTest {
        source: "\u{015C}",
        nfc: "\u{015C}",
        nfd: "\u{0053}\u{0302}",
        nfkc: "\u{015C}",
        nfkd: "\u{0053}\u{0302}",
    },
    NormalizationTest {
        source: "\u{015D}",
        nfc: "\u{015D}",
        nfd: "\u{0073}\u{0302}",
        nfkc: "\u{015D}",
        nfkd: "\u{0073}\u{0302}",
    },
    NormalizationTest {
        source: "\u{015E}",
        nfc: "\u{015E}",
        nfd: "\u{0053}\u{0327}",
        nfkc: "\u{015E}",
        nfkd: "\u{0053}\u{0327}",
    },
    NormalizationTest {
        source: "\u{015F}",
        nfc: "\u{015F}",
        nfd: "\u{0073}\u{0327}",
        nfkc: "\u{015F}",
        nfkd: "\u{0073}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0160}",
        nfc: "\u{0160}",
        nfd: "\u{0053}\u{030C}",
        nfkc: "\u{0160}",
        nfkd: "\u{0053}\u{030C}",
    },
    NormalizationTest {
        source: "\u{0161}",
        nfc: "\u{0161}",
        nfd: "\u{0073}\u{030C}",
        nfkc: "\u{0161}",
        nfkd: "\u{0073}\u{030C}",
    },
    NormalizationTest {
        source: "\u{0162}",
        nfc: "\u{0162}",
        nfd: "\u{0054}\u{0327}",
        nfkc: "\u{0162}",
        nfkd: "\u{0054}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0163}",
        nfc: "\u{0163}",
        nfd: "\u{0074}\u{0327}",
        nfkc: "\u{0163}",
        nfkd: "\u{0074}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0164}",
        nfc: "\u{0164}",
        nfd: "\u{0054}\u{030C}",
        nfkc: "\u{0164}",
        nfkd: "\u{0054}\u{030C}",
    },
    NormalizationTest {
        source: "\u{0165}",
        nfc: "\u{0165}",
        nfd: "\u{0074}\u{030C}",
        nfkc: "\u{0165}",
        nfkd: "\u{0074}\u{030C}",
    },
    NormalizationTest {
        source: "\u{0168}",
        nfc: "\u{0168}",
        nfd: "\u{0055}\u{0303}",
        nfkc: "\u{0168}",
        nfkd: "\u{0055}\u{0303}",
    },
    NormalizationTest {
        source: "\u{0169}",
        nfc: "\u{0169}",
        nfd: "\u{0075}\u{0303}",
        nfkc: "\u{0169}",
        nfkd: "\u{0075}\u{0303}",
    },
    NormalizationTest {
        source: "\u{016A}",
        nfc: "\u{016A}",
        nfd: "\u{0055}\u{0304}",
        nfkc: "\u{016A}",
        nfkd: "\u{0055}\u{0304}",
    },
    NormalizationTest {
        source: "\u{016B}",
        nfc: "\u{016B}",
        nfd: "\u{0075}\u{0304}",
        nfkc: "\u{016B}",
        nfkd: "\u{0075}\u{0304}",
    },
    NormalizationTest {
        source: "\u{016C}",
        nfc: "\u{016C}",
        nfd: "\u{0055}\u{0306}",
        nfkc: "\u{016C}",
        nfkd: "\u{0055}\u{0306}",
    },
    NormalizationTest {
        source: "\u{016D}",
        nfc: "\u{016D}",
        nfd: "\u{0075}\u{0306}",
        nfkc: "\u{016D}",
        nfkd: "\u{0075}\u{0306}",
    },
    NormalizationTest {
        source: "\u{016E}",
        nfc: "\u{016E}",
        nfd: "\u{0055}\u{030A}",
        nfkc: "\u{016E}",
        nfkd: "\u{0055}\u{030A}",
    },
    NormalizationTest {
        source: "\u{016F}",
        nfc: "\u{016F}",
        nfd: "\u{0075}\u{030A}",
        nfkc: "\u{016F}",
        nfkd: "\u{0075}\u{030A}",
    },
    NormalizationTest {
        source: "\u{0170}",
        nfc: "\u{0170}",
        nfd: "\u{0055}\u{030B}",
        nfkc: "\u{0170}",
        nfkd: "\u{0055}\u{030B}",
    },
    NormalizationTest {
        source: "\u{0171}",
        nfc: "\u{0171}",
        nfd: "\u{0075}\u{030B}",
        nfkc: "\u{0171}",
        nfkd: "\u{0075}\u{030B}",
    },
    NormalizationTest {
        source: "\u{0172}",
        nfc: "\u{0172}",
        nfd: "\u{0055}\u{0328}",
        nfkc: "\u{0172}",
        nfkd: "\u{0055}\u{0328}",
    },
    NormalizationTest {
        source: "\u{0173}",
        nfc: "\u{0173}",
        nfd: "\u{0075}\u{0328}",
        nfkc: "\u{0173}",
        nfkd: "\u{0075}\u{0328}",
    },
    NormalizationTest {
        source: "\u{0174}",
        nfc: "\u{0174}",
        nfd: "\u{0057}\u{0302}",
        nfkc: "\u{0174}",
        nfkd: "\u{0057}\u{0302}",
    },
    NormalizationTest {
        source: "\u{0175}",
        nfc: "\u{0175}",
        nfd: "\u{0077}\u{0302}",
        nfkc: "\u{0175}",
        nfkd: "\u{0077}\u{0302}",
    },
    NormalizationTest {
        source: "\u{0176}",
        nfc: "\u{0176}",
        nfd: "\u{0059}\u{0302}",
        nfkc: "\u{0176}",
        nfkd: "\u{0059}\u{0302}",
    },
    NormalizationTest {
        source: "\u{0177}",
        nfc: "\u{0177}",
        nfd: "\u{0079}\u{0302}",
        nfkc: "\u{0177}",
        nfkd: "\u{0079}\u{0302}",
    },
    NormalizationTest {
        source: "\u{0178}",
        nfc: "\u{0178}",
        nfd: "\u{0059}\u{0308}",
        nfkc: "\u{0178}",
        nfkd: "\u{0059}\u{0308}",
    },
    NormalizationTest {
        source: "\u{0179}",
        nfc: "\u{0179}",
        nfd: "\u{005A}\u{0301}",
        nfkc: "\u{0179}",
        nfkd: "\u{005A}\u{0301}",
    },
    NormalizationTest {
        source: "\u{017A}",
        nfc: "\u{017A}",
        nfd: "\u{007A}\u{0301}",
        nfkc: "\u{017A}",
        nfkd: "\u{007A}\u{0301}",
    },
    NormalizationTest {
        source: "\u{017B}",
        nfc: "\u{017B}",
        nfd: "\u{005A}\u{0307}",
        nfkc: "\u{017B}",
        nfkd: "\u{005A}\u{0307}",
    },
    NormalizationTest {
        source: "\u{017C}",
        nfc: "\u{017C}",
        nfd: "\u{007A}\u{0307}",
        nfkc: "\u{017C}",
        nfkd: "\u{007A}\u{0307}",
    },
    NormalizationTest {
        source: "\u{017D}",
        nfc: "\u{017D}",
        nfd: "\u{005A}\u{030C}",
        nfkc: "\u{017D}",
        nfkd: "\u{005A}\u{030C}",
    },
    NormalizationTest {
        source: "\u{017E}",
        nfc: "\u{017E}",
        nfd: "\u{007A}\u{030C}",
        nfkc: "\u{017E}",
        nfkd: "\u{007A}\u{030C}",
    },
    NormalizationTest {
        source: "\u{017F}",
        nfc: "\u{017F}",
        nfd: "\u{017F}",
        nfkc: "\u{0073}",
        nfkd: "\u{0073}",
    },
    NormalizationTest {
        source: "\u{01A0}",
        nfc: "\u{01A0}",
        nfd: "\u{004F}\u{031B}",
        nfkc: "\u{01A0}",
        nfkd: "\u{004F}\u{031B}",
    },
    NormalizationTest {
        source: "\u{01A1}",
        nfc: "\u{01A1}",
        nfd: "\u{006F}\u{031B}",
        nfkc: "\u{01A1}",
        nfkd: "\u{006F}\u{031B}",
    },
    NormalizationTest {
        source: "\u{01AF}",
        nfc: "\u{01AF}",
        nfd: "\u{0055}\u{031B}",
        nfkc: "\u{01AF}",
        nfkd: "\u{0055}\u{031B}",
    },
    NormalizationTest {
        source: "\u{01B0}",
        nfc: "\u{01B0}",
        nfd: "\u{0075}\u{031B}",
        nfkc: "\u{01B0}",
        nfkd: "\u{0075}\u{031B}",
    },
    NormalizationTest {
        source: "\u{01C4}",
        nfc: "\u{01C4}",
        nfd: "\u{01C4}",
        nfkc: "\u{0044}\u{017D}",
        nfkd: "\u{0044}\u{005A}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01C5}",
        nfc: "\u{01C5}",
        nfd: "\u{01C5}",
        nfkc: "\u{0044}\u{017E}",
        nfkd: "\u{0044}\u{007A}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01C6}",
        nfc: "\u{01C6}",
        nfd: "\u{01C6}",
        nfkc: "\u{0064}\u{017E}",
        nfkd: "\u{0064}\u{007A}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01C7}",
        nfc: "\u{01C7}",
        nfd: "\u{01C7}",
        nfkc: "\u{004C}\u{004A}",
        nfkd: "\u{004C}\u{004A}",
    },
    NormalizationTest {
        source: "\u{01C8}",
        nfc: "\u{01C8}",
        nfd: "\u{01C8}",
        nfkc: "\u{004C}\u{006A}",
        nfkd: "\u{004C}\u{006A}",
    },
    NormalizationTest {
        source: "\u{01C9}",
        nfc: "\u{01C9}",
        nfd: "\u{01C9}",
        nfkc: "\u{006C}\u{006A}",
        nfkd: "\u{006C}\u{006A}",
    },
    NormalizationTest {
        source: "\u{01CA}",
        nfc: "\u{01CA}",
        nfd: "\u{01CA}",
        nfkc: "\u{004E}\u{004A}",
        nfkd: "\u{004E}\u{004A}",
    },
    NormalizationTest {
        source: "\u{01CB}",
        nfc: "\u{01CB}",
        nfd: "\u{01CB}",
        nfkc: "\u{004E}\u{006A}",
        nfkd: "\u{004E}\u{006A}",
    },
    NormalizationTest {
        source: "\u{01CC}",
        nfc: "\u{01CC}",
        nfd: "\u{01CC}",
        nfkc: "\u{006E}\u{006A}",
        nfkd: "\u{006E}\u{006A}",
    },
    NormalizationTest {
        source: "\u{01CD}",
        nfc: "\u{01CD}",
        nfd: "\u{0041}\u{030C}",
        nfkc: "\u{01CD}",
        nfkd: "\u{0041}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01CE}",
        nfc: "\u{01CE}",
        nfd: "\u{0061}\u{030C}",
        nfkc: "\u{01CE}",
        nfkd: "\u{0061}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01CF}",
        nfc: "\u{01CF}",
        nfd: "\u{0049}\u{030C}",
        nfkc: "\u{01CF}",
        nfkd: "\u{0049}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01D0}",
        nfc: "\u{01D0}",
        nfd: "\u{0069}\u{030C}",
        nfkc: "\u{01D0}",
        nfkd: "\u{0069}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01D1}",
        nfc: "\u{01D1}",
        nfd: "\u{004F}\u{030C}",
        nfkc: "\u{01D1}",
        nfkd: "\u{004F}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01D2}",
        nfc: "\u{01D2}",
        nfd: "\u{006F}\u{030C}",
        nfkc: "\u{01D2}",
        nfkd: "\u{006F}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01D3}",
        nfc: "\u{01D3}",
        nfd: "\u{0055}\u{030C}",
        nfkc: "\u{01D3}",
        nfkd: "\u{0055}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01D4}",
        nfc: "\u{01D4}",
        nfd: "\u{0075}\u{030C}",
        nfkc: "\u{01D4}",
        nfkd: "\u{0075}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01D5}",
        nfc: "\u{01D5}",
        nfd: "\u{0055}\u{0308}\u{0304}",
        nfkc: "\u{01D5}",
        nfkd: "\u{0055}\u{0308}\u{0304}",
    },
    NormalizationTest {
        source: "\u{01D6}",
        nfc: "\u{01D6}",
        nfd: "\u{0075}\u{0308}\u{0304}",
        nfkc: "\u{01D6}",
        nfkd: "\u{0075}\u{0308}\u{0304}",
    },
    NormalizationTest {
        source: "\u{01D7}",
        nfc: "\u{01D7}",
        nfd: "\u{0055}\u{0308}\u{0301}",
        nfkc: "\u{01D7}",
        nfkd: "\u{0055}\u{0308}\u{0301}",
    },
    NormalizationTest {
        source: "\u{01D8}",
        nfc: "\u{01D8}",
        nfd: "\u{0075}\u{0308}\u{0301}",
        nfkc: "\u{01D8}",
        nfkd: "\u{0075}\u{0308}\u{0301}",
    },
    NormalizationTest {
        source: "\u{01D9}",
        nfc: "\u{01D9}",
        nfd: "\u{0055}\u{0308}\u{030C}",
        nfkc: "\u{01D9}",
        nfkd: "\u{0055}\u{0308}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01DA}",
        nfc: "\u{01DA}",
        nfd: "\u{0075}\u{0308}\u{030C}",
        nfkc: "\u{01DA}",
        nfkd: "\u{0075}\u{0308}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01DB}",
        nfc: "\u{01DB}",
        nfd: "\u{0055}\u{0308}\u{0300}",
        nfkc: "\u{01DB}",
        nfkd: "\u{0055}\u{0308}\u{0300}",
    },
    NormalizationTest {
        source: "\u{01DC}",
        nfc: "\u{01DC}",
        nfd: "\u{0075}\u{0308}\u{0300}",
        nfkc: "\u{01DC}",
        nfkd: "\u{0075}\u{0308}\u{0300}",
    },
    NormalizationTest {
        source: "\u{01DE}",
        nfc: "\u{01DE}",
        nfd: "\u{0041}\u{0308}\u{0304}",
        nfkc: "\u{01DE}",
        nfkd: "\u{0041}\u{0308}\u{0304}",
    },
    NormalizationTest {
        source: "\u{01DF}",
        nfc: "\u{01DF}",
        nfd: "\u{0061}\u{0308}\u{0304}",
        nfkc: "\u{01DF}",
        nfkd: "\u{0061}\u{0308}\u{0304}",
    },
    NormalizationTest {
        source: "\u{01E0}",
        nfc: "\u{01E0}",
        nfd: "\u{0041}\u{0307}\u{0304}",
        nfkc: "\u{01E0}",
        nfkd: "\u{0041}\u{0307}\u{0304}",
    },
    NormalizationTest {
        source: "\u{01E1}",
        nfc: "\u{01E1}",
        nfd: "\u{0061}\u{0307}\u{0304}",
        nfkc: "\u{01E1}",
        nfkd: "\u{0061}\u{0307}\u{0304}",
    },
    NormalizationTest {
        source: "\u{01E2}",
        nfc: "\u{01E2}",
        nfd: "\u{00C6}\u{0304}",
        nfkc: "\u{01E2}",
        nfkd: "\u{00C6}\u{0304}",
    },
    NormalizationTest {
        source: "\u{01E3}",
        nfc: "\u{01E3}",
        nfd: "\u{00E6}\u{0304}",
        nfkc: "\u{01E3}",
        nfkd: "\u{00E6}\u{0304}",
    },
    NormalizationTest {
        source: "\u{01E6}",
        nfc: "\u{01E6}",
        nfd: "\u{0047}\u{030C}",
        nfkc: "\u{01E6}",
        nfkd: "\u{0047}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01E7}",
        nfc: "\u{01E7}",
        nfd: "\u{0067}\u{030C}",
        nfkc: "\u{01E7}",
        nfkd: "\u{0067}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01E8}",
        nfc: "\u{01E8}",
        nfd: "\u{004B}\u{030C}",
        nfkc: "\u{01E8}",
        nfkd: "\u{004B}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01E9}",
        nfc: "\u{01E9}",
        nfd: "\u{006B}\u{030C}",
        nfkc: "\u{01E9}",
        nfkd: "\u{006B}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01EA}",
        nfc: "\u{01EA}",
        nfd: "\u{004F}\u{0328}",
        nfkc: "\u{01EA}",
        nfkd: "\u{004F}\u{0328}",
    },
    NormalizationTest {
        source: "\u{01EB}",
        nfc: "\u{01EB}",
        nfd: "\u{006F}\u{0328}",
        nfkc: "\u{01EB}",
        nfkd: "\u{006F}\u{0328}",
    },
    NormalizationTest {
        source: "\u{01EC}",
        nfc: "\u{01EC}",
        nfd: "\u{004F}\u{0328}\u{0304}",
        nfkc: "\u{01EC}",
        nfkd: "\u{004F}\u{0328}\u{0304}",
    },
    NormalizationTest {
        source: "\u{01ED}",
        nfc: "\u{01ED}",
        nfd: "\u{006F}\u{0328}\u{0304}",
        nfkc: "\u{01ED}",
        nfkd: "\u{006F}\u{0328}\u{0304}",
    },
    NormalizationTest {
        source: "\u{01EE}",
        nfc: "\u{01EE}",
        nfd: "\u{01B7}\u{030C}",
        nfkc: "\u{01EE}",
        nfkd: "\u{01B7}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01EF}",
        nfc: "\u{01EF}",
        nfd: "\u{0292}\u{030C}",
        nfkc: "\u{01EF}",
        nfkd: "\u{0292}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01F0}",
        nfc: "\u{01F0}",
        nfd: "\u{006A}\u{030C}",
        nfkc: "\u{01F0}",
        nfkd: "\u{006A}\u{030C}",
    },
    NormalizationTest {
        source: "\u{01F1}",
        nfc: "\u{01F1}",
        nfd: "\u{01F1}",
        nfkc: "\u{0044}\u{005A}",
        nfkd: "\u{0044}\u{005A}",
    },
    NormalizationTest {
        source: "\u{01F2}",
        nfc: "\u{01F2}",
        nfd: "\u{01F2}",
        nfkc: "\u{0044}\u{007A}",
        nfkd: "\u{0044}\u{007A}",
    },
    NormalizationTest {
        source: "\u{01F3}",
        nfc: "\u{01F3}",
        nfd: "\u{01F3}",
        nfkc: "\u{0064}\u{007A}",
        nfkd: "\u{0064}\u{007A}",
    },
    NormalizationTest {
        source: "\u{01F4}",
        nfc: "\u{01F4}",
        nfd: "\u{0047}\u{0301}",
        nfkc: "\u{01F4}",
        nfkd: "\u{0047}\u{0301}",
    },
    NormalizationTest {
        source: "\u{01F5}",
        nfc: "\u{01F5}",
        nfd: "\u{0067}\u{0301}",
        nfkc: "\u{01F5}",
        nfkd: "\u{0067}\u{0301}",
    },
    NormalizationTest {
        source: "\u{01F8}",
        nfc: "\u{01F8}",
        nfd: "\u{004E}\u{0300}",
        nfkc: "\u{01F8}",
        nfkd: "\u{004E}\u{0300}",
    },
    NormalizationTest {
        source: "\u{01F9}",
        nfc: "\u{01F9}",
        nfd: "\u{006E}\u{0300}",
        nfkc: "\u{01F9}",
        nfkd: "\u{006E}\u{0300}",
    },
    NormalizationTest {
        source: "\u{01FA}",
        nfc: "\u{01FA}",
        nfd: "\u{0041}\u{030A}\u{0301}",
        nfkc: "\u{01FA}",
        nfkd: "\u{0041}\u{030A}\u{0301}",
    },
    NormalizationTest {
        source: "\u{01FB}",
        nfc: "\u{01FB}",
        nfd: "\u{0061}\u{030A}\u{0301}",
        nfkc: "\u{01FB}",
        nfkd: "\u{0061}\u{030A}\u{0301}",
    },
    NormalizationTest {
        source: "\u{01FC}",
        nfc: "\u{01FC}",
        nfd: "\u{00C6}\u{0301}",
        nfkc: "\u{01FC}",
        nfkd: "\u{00C6}\u{0301}",
    },
    NormalizationTest {
        source: "\u{01FD}",
        nfc: "\u{01FD}",
        nfd: "\u{00E6}\u{0301}",
        nfkc: "\u{01FD}",
        nfkd: "\u{00E6}\u{0301}",
    },
    NormalizationTest {
        source: "\u{01FE}",
        nfc: "\u{01FE}",
        nfd: "\u{00D8}\u{0301}",
        nfkc: "\u{01FE}",
        nfkd: "\u{00D8}\u{0301}",
    },
    NormalizationTest {
        source: "\u{01FF}",
        nfc: "\u{01FF}",
        nfd: "\u{00F8}\u{0301}",
        nfkc: "\u{01FF}",
        nfkd: "\u{00F8}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0200}",
        nfc: "\u{0200}",
        nfd: "\u{0041}\u{030F}",
        nfkc: "\u{0200}",
        nfkd: "\u{0041}\u{030F}",
    },
    NormalizationTest {
        source: "\u{0201}",
        nfc: "\u{0201}",
        nfd: "\u{0061}\u{030F}",
        nfkc: "\u{0201}",
        nfkd: "\u{0061}\u{030F}",
    },
    NormalizationTest {
        source: "\u{0202}",
        nfc: "\u{0202}",
        nfd: "\u{0041}\u{0311}",
        nfkc: "\u{0202}",
        nfkd: "\u{0041}\u{0311}",
    },
    NormalizationTest {
        source: "\u{0203}",
        nfc: "\u{0203}",
        nfd: "\u{0061}\u{0311}",
        nfkc: "\u{0203}",
        nfkd: "\u{0061}\u{0311}",
    },
    NormalizationTest {
        source: "\u{0204}",
        nfc: "\u{0204}",
        nfd: "\u{0045}\u{030F}",
        nfkc: "\u{0204}",
        nfkd: "\u{0045}\u{030F}",
    },
    NormalizationTest {
        source: "\u{0205}",
        nfc: "\u{0205}",
        nfd: "\u{0065}\u{030F}",
        nfkc: "\u{0205}",
        nfkd: "\u{0065}\u{030F}",
    },
    NormalizationTest {
        source: "\u{0206}",
        nfc: "\u{0206}",
        nfd: "\u{0045}\u{0311}",
        nfkc: "\u{0206}",
        nfkd: "\u{0045}\u{0311}",
    },
    NormalizationTest {
        source: "\u{0207}",
        nfc: "\u{0207}",
        nfd: "\u{0065}\u{0311}",
        nfkc: "\u{0207}",
        nfkd: "\u{0065}\u{0311}",
    },
    NormalizationTest {
        source: "\u{0208}",
        nfc: "\u{0208}",
        nfd: "\u{0049}\u{030F}",
        nfkc: "\u{0208}",
        nfkd: "\u{0049}\u{030F}",
    },
    NormalizationTest {
        source: "\u{0209}",
        nfc: "\u{0209}",
        nfd: "\u{0069}\u{030F}",
        nfkc: "\u{0209}",
        nfkd: "\u{0069}\u{030F}",
    },
    NormalizationTest {
        source: "\u{020A}",
        nfc: "\u{020A}",
        nfd: "\u{0049}\u{0311}",
        nfkc: "\u{020A}",
        nfkd: "\u{0049}\u{0311}",
    },
    NormalizationTest {
        source: "\u{020B}",
        nfc: "\u{020B}",
        nfd: "\u{0069}\u{0311}",
        nfkc: "\u{020B}",
        nfkd: "\u{0069}\u{0311}",
    },
    NormalizationTest {
        source: "\u{020C}",
        nfc: "\u{020C}",
        nfd: "\u{004F}\u{030F}",
        nfkc: "\u{020C}",
        nfkd: "\u{004F}\u{030F}",
    },
    NormalizationTest {
        source: "\u{020D}",
        nfc: "\u{020D}",
        nfd: "\u{006F}\u{030F}",
        nfkc: "\u{020D}",
        nfkd: "\u{006F}\u{030F}",
    },
    NormalizationTest {
        source: "\u{020E}",
        nfc: "\u{020E}",
        nfd: "\u{004F}\u{0311}",
        nfkc: "\u{020E}",
        nfkd: "\u{004F}\u{0311}",
    },
    NormalizationTest {
        source: "\u{020F}",
        nfc: "\u{020F}",
        nfd: "\u{006F}\u{0311}",
        nfkc: "\u{020F}",
        nfkd: "\u{006F}\u{0311}",
    },
    NormalizationTest {
        source: "\u{0210}",
        nfc: "\u{0210}",
        nfd: "\u{0052}\u{030F}",
        nfkc: "\u{0210}",
        nfkd: "\u{0052}\u{030F}",
    },
    NormalizationTest {
        source: "\u{0211}",
        nfc: "\u{0211}",
        nfd: "\u{0072}\u{030F}",
        nfkc: "\u{0211}",
        nfkd: "\u{0072}\u{030F}",
    },
    NormalizationTest {
        source: "\u{0212}",
        nfc: "\u{0212}",
        nfd: "\u{0052}\u{0311}",
        nfkc: "\u{0212}",
        nfkd: "\u{0052}\u{0311}",
    },
    NormalizationTest {
        source: "\u{0213}",
        nfc: "\u{0213}",
        nfd: "\u{0072}\u{0311}",
        nfkc: "\u{0213}",
        nfkd: "\u{0072}\u{0311}",
    },
    NormalizationTest {
        source: "\u{0214}",
        nfc: "\u{0214}",
        nfd: "\u{0055}\u{030F}",
        nfkc: "\u{0214}",
        nfkd: "\u{0055}\u{030F}",
    },
    NormalizationTest {
        source: "\u{0215}",
        nfc: "\u{0215}",
        nfd: "\u{0075}\u{030F}",
        nfkc: "\u{0215}",
        nfkd: "\u{0075}\u{030F}",
    },
    NormalizationTest {
        source: "\u{0216}",
        nfc: "\u{0216}",
        nfd: "\u{0055}\u{0311}",
        nfkc: "\u{0216}",
        nfkd: "\u{0055}\u{0311}",
    },
    NormalizationTest {
        source: "\u{0217}",
        nfc: "\u{0217}",
        nfd: "\u{0075}\u{0311}",
        nfkc: "\u{0217}",
        nfkd: "\u{0075}\u{0311}",
    },
    NormalizationTest {
        source: "\u{0218}",
        nfc: "\u{0218}",
        nfd: "\u{0053}\u{0326}",
        nfkc: "\u{0218}",
        nfkd: "\u{0053}\u{0326}",
    },
    NormalizationTest {
        source: "\u{0219}",
        nfc: "\u{0219}",
        nfd: "\u{0073}\u{0326}",
        nfkc: "\u{0219}",
        nfkd: "\u{0073}\u{0326}",
    },
    NormalizationTest {
        source: "\u{021A}",
        nfc: "\u{021A}",
        nfd: "\u{0054}\u{0326}",
        nfkc: "\u{021A}",
        nfkd: "\u{0054}\u{0326}",
    },
    NormalizationTest {
        source: "\u{021B}",
        nfc: "\u{021B}",
        nfd: "\u{0074}\u{0326}",
        nfkc: "\u{021B}",
        nfkd: "\u{0074}\u{0326}",
    },
    NormalizationTest {
        source: "\u{021E}",
        nfc: "\u{021E}",
        nfd: "\u{0048}\u{030C}",
        nfkc: "\u{021E}",
        nfkd: "\u{0048}\u{030C}",
    },
    NormalizationTest {
        source: "\u{021F}",
        nfc: "\u{021F}",
        nfd: "\u{0068}\u{030C}",
        nfkc: "\u{021F}",
        nfkd: "\u{0068}\u{030C}",
    },
    NormalizationTest {
        source: "\u{0226}",
        nfc: "\u{0226}",
        nfd: "\u{0041}\u{0307}",
        nfkc: "\u{0226}",
        nfkd: "\u{0041}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0227}",
        nfc: "\u{0227}",
        nfd: "\u{0061}\u{0307}",
        nfkc: "\u{0227}",
        nfkd: "\u{0061}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0228}",
        nfc: "\u{0228}",
        nfd: "\u{0045}\u{0327}",
        nfkc: "\u{0228}",
        nfkd: "\u{0045}\u{0327}",
    },
    NormalizationTest {
        source: "\u{0229}",
        nfc: "\u{0229}",
        nfd: "\u{0065}\u{0327}",
        nfkc: "\u{0229}",
        nfkd: "\u{0065}\u{0327}",
    },
    NormalizationTest {
        source: "\u{022A}",
        nfc: "\u{022A}",
        nfd: "\u{004F}\u{0308}\u{0304}",
        nfkc: "\u{022A}",
        nfkd: "\u{004F}\u{0308}\u{0304}",
    },
    NormalizationTest {
        source: "\u{022B}",
        nfc: "\u{022B}",
        nfd: "\u{006F}\u{0308}\u{0304}",
        nfkc: "\u{022B}",
        nfkd: "\u{006F}\u{0308}\u{0304}",
    },
    NormalizationTest {
        source: "\u{022C}",
        nfc: "\u{022C}",
        nfd: "\u{004F}\u{0303}\u{0304}",
        nfkc: "\u{022C}",
        nfkd: "\u{004F}\u{0303}\u{0304}",
    },
    NormalizationTest {
        source: "\u{022D}",
        nfc: "\u{022D}",
        nfd: "\u{006F}\u{0303}\u{0304}",
        nfkc: "\u{022D}",
        nfkd: "\u{006F}\u{0303}\u{0304}",
    },
    NormalizationTest {
        source: "\u{022E}",
        nfc: "\u{022E}",
        nfd: "\u{004F}\u{0307}",
        nfkc: "\u{022E}",
        nfkd: "\u{004F}\u{0307}",
    },
    NormalizationTest {
        source: "\u{022F}",
        nfc: "\u{022F}",
        nfd: "\u{006F}\u{0307}",
        nfkc: "\u{022F}",
        nfkd: "\u{006F}\u{0307}",
    },
    NormalizationTest {
        source: "\u{0230}",
        nfc: "\u{0230}",
        nfd: "\u{004F}\u{0307}\u{0304}",
        nfkc: "\u{0230}",
        nfkd: "\u{004F}\u{0307}\u{0304}",
    },
    NormalizationTest {
        source: "\u{0231}",
        nfc: "\u{0231}",
        nfd: "\u{006F}\u{0307}\u{0304}",
        nfkc: "\u{0231}",
        nfkd: "\u{006F}\u{0307}\u{0304}",
    },
    NormalizationTest {
        source: "\u{0232}",
        nfc: "\u{0232}",
        nfd: "\u{0059}\u{0304}",
        nfkc: "\u{0232}",
        nfkd: "\u{0059}\u{0304}",
    },
    NormalizationTest {
        source: "\u{0233}",
        nfc: "\u{0233}",
        nfd: "\u{0079}\u{0304}",
        nfkc: "\u{0233}",
        nfkd: "\u{0079}\u{0304}",
    },
    NormalizationTest {
        source: "\u{02B0}",
        nfc: "\u{02B0}",
        nfd: "\u{02B0}",
        nfkc: "\u{0068}",
        nfkd: "\u{0068}",
    },
    NormalizationTest {
        source: "\u{02B1}",
        nfc: "\u{02B1}",
        nfd: "\u{02B1}",
        nfkc: "\u{0266}",
        nfkd: "\u{0266}",
    },
    NormalizationTest {
        source: "\u{02B2}",
        nfc: "\u{02B2}",
        nfd: "\u{02B2}",
        nfkc: "\u{006A}",
        nfkd: "\u{006A}",
    },
    NormalizationTest {
        source: "\u{02B3}",
        nfc: "\u{02B3}",
        nfd: "\u{02B3}",
        nfkc: "\u{0072}",
        nfkd: "\u{0072}",
    },
    NormalizationTest {
        source: "\u{02B4}",
        nfc: "\u{02B4}",
        nfd: "\u{02B4}",
        nfkc: "\u{0279}",
        nfkd: "\u{0279}",
    },
    NormalizationTest {
        source: "\u{02B5}",
        nfc: "\u{02B5}",
        nfd: "\u{02B5}",
        nfkc: "\u{027B}",
        nfkd: "\u{027B}",
    },
    NormalizationTest {
        source: "\u{02B6}",
        nfc: "\u{02B6}",
        nfd: "\u{02B6}",
        nfkc: "\u{0281}",
        nfkd: "\u{0281}",
    },
    NormalizationTest {
        source: "\u{02B7}",
        nfc: "\u{02B7}",
        nfd: "\u{02B7}",
        nfkc: "\u{0077}",
        nfkd: "\u{0077}",
    },
    NormalizationTest {
        source: "\u{02B8}",
        nfc: "\u{02B8}",
        nfd: "\u{02B8}",
        nfkc: "\u{0079}",
        nfkd: "\u{0079}",
    },
    NormalizationTest {
        source: "\u{02D8}",
        nfc: "\u{02D8}",
        nfd: "\u{02D8}",
        nfkc: "\u{0020}\u{0306}",
        nfkd: "\u{0020}\u{0306}",
    },
    NormalizationTest {
        source: "\u{02D9}",
        nfc: "\u{02D9}",
        nfd: "\u{02D9}",
        nfkc: "\u{0020}\u{0307}",
        nfkd: "\u{0020}\u{0307}",
    },
    NormalizationTest {
        source: "\u{02DA}",
        nfc: "\u{02DA}",
        nfd: "\u{02DA}",
        nfkc: "\u{0020}\u{030A}",
        nfkd: "\u{0020}\u{030A}",
    },
    NormalizationTest {
        source: "\u{02DB}",
        nfc: "\u{02DB}",
        nfd: "\u{02DB}",
        nfkc: "\u{0020}\u{0328}",
        nfkd: "\u{0020}\u{0328}",
    },
    NormalizationTest {
        source: "\u{02DC}",
        nfc: "\u{02DC}",
        nfd: "\u{02DC}",
        nfkc: "\u{0020}\u{0303}",
        nfkd: "\u{0020}\u{0303}",
    },
    NormalizationTest {
        source: "\u{02DD}",
        nfc: "\u{02DD}",
        nfd: "\u{02DD}",
        nfkc: "\u{0020}\u{030B}",
        nfkd: "\u{0020}\u{030B}",
    },
    NormalizationTest {
        source: "\u{02E0}",
        nfc: "\u{02E0}",
        nfd: "\u{02E0}",
        nfkc: "\u{0263}",
        nfkd: "\u{0263}",
    },
    NormalizationTest {
        source: "\u{02E1}",
        nfc: "\u{02E1}",
        nfd: "\u{02E1}",
        nfkc: "\u{006C}",
        nfkd: "\u{006C}",
    },
    NormalizationTest {
        source: "\u{02E2}",
        nfc: "\u{02E2}",
        nfd: "\u{02E2}",
        nfkc: "\u{0073}",
        nfkd: "\u{0073}",
    },
    NormalizationTest {
        source: "\u{02E3}",
        nfc: "\u{02E3}",
        nfd: "\u{02E3}",
        nfkc: "\u{0078}",
        nfkd: "\u{0078}",
    },
    NormalizationTest {
        source: "\u{02E4}",
        nfc: "\u{02E4}",
        nfd: "\u{02E4}",
        nfkc: "\u{0295}",
        nfkd: "\u{0295}",
    },
    NormalizationTest {
        source: "\u{0340}",
        nfc: "\u{0300}",
        nfd: "\u{0300}",
        nfkc: "\u{0300}",
        nfkd: "\u{0300}",
    },
    NormalizationTest {
        source: "\u{0341}",
        nfc: "\u{0301}",
        nfd: "\u{0301}",
        nfkc: "\u{0301}",
        nfkd: "\u{0301}",
    },
    NormalizationTest {
        source: "\u{0343}",
        nfc: "\u{0313}",
        nfd: "\u{0313}",
        nfkc: "\u{0313}",
        nfkd: "\u{0313}",
    },
    NormalizationTest {
        source: "\u{0344}",
        nfc: "\u{0308}\u{0301}",
        nfd: "\u{0308}\u{0301}",
        nfkc: "\u{0308}\u{0301}",
        nfkd: "\u{0308}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0374}",
        nfc: "\u{02B9}",
        nfd: "\u{02B9}",
        nfkc: "\u{02B9}",
        nfkd: "\u{02B9}",
    },
    NormalizationTest {
        source: "\u{037A}",
        nfc: "\u{037A}",
        nfd: "\u{037A}",
        nfkc: "\u{0020}\u{0345}",
        nfkd: "\u{0020}\u{0345}",
    },
    NormalizationTest {
        source: "\u{037E}",
        nfc: "\u{003B}",
        nfd: "\u{003B}",
        nfkc: "\u{003B}",
        nfkd: "\u{003B}",
    },
    NormalizationTest {
        source: "\u{0384}",
        nfc: "\u{0384}",
        nfd: "\u{0384}",
        nfkc: "\u{0020}\u{0301}",
        nfkd: "\u{0020}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0385}",
        nfc: "\u{0385}",
        nfd: "\u{00A8}\u{0301}",
        nfkc: "\u{0020}\u{0308}\u{0301}",
        nfkd: "\u{0020}\u{0308}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0386}",
        nfc: "\u{0386}",
        nfd: "\u{0391}\u{0301}",
        nfkc: "\u{0386}",
        nfkd: "\u{0391}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0387}",
        nfc: "\u{00B7}",
        nfd: "\u{00B7}",
        nfkc: "\u{00B7}",
        nfkd: "\u{00B7}",
    },
    NormalizationTest {
        source: "\u{0388}",
        nfc: "\u{0388}",
        nfd: "\u{0395}\u{0301}",
        nfkc: "\u{0388}",
        nfkd: "\u{0395}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0389}",
        nfc: "\u{0389}",
        nfd: "\u{0397}\u{0301}",
        nfkc: "\u{0389}",
        nfkd: "\u{0397}\u{0301}",
    },
    NormalizationTest {
        source: "\u{038A}",
        nfc: "\u{038A}",
        nfd: "\u{0399}\u{0301}",
        nfkc: "\u{038A}",
        nfkd: "\u{0399}\u{0301}",
    },
    NormalizationTest {
        source: "\u{038C}",
        nfc: "\u{038C}",
        nfd: "\u{039F}\u{0301}",
        nfkc: "\u{038C}",
        nfkd: "\u{039F}\u{0301}",
    },
    NormalizationTest {
        source: "\u{038E}",
        nfc: "\u{038E}",
        nfd: "\u{03A5}\u{0301}",
        nfkc: "\u{038E}",
        nfkd: "\u{03A5}\u{0301}",
    },
    NormalizationTest {
        source: "\u{038F}",
        nfc: "\u{038F}",
        nfd: "\u{03A9}\u{0301}",
        nfkc: "\u{038F}",
        nfkd: "\u{03A9}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0390}",
        nfc: "\u{0390}",
        nfd: "\u{03B9}\u{0308}\u{0301}",
        nfkc: "\u{0390}",
        nfkd: "\u{03B9}\u{0308}\u{0301}",
    },
    NormalizationTest {
        source: "\u{03AA}",
        nfc: "\u{03AA}",
        nfd: "\u{0399}\u{0308}",
        nfkc: "\u{03AA}",
        nfkd: "\u{0399}\u{0308}",
    },
    NormalizationTest {
        source: "\u{03AB}",
        nfc: "\u{03AB}",
        nfd: "\u{03A5}\u{0308}",
        nfkc: "\u{03AB}",
        nfkd: "\u{03A5}\u{0308}",
    },
    NormalizationTest {
        source: "\u{03AC}",
        nfc: "\u{03AC}",
        nfd: "\u{03B1}\u{0301}",
        nfkc: "\u{03AC}",
        nfkd: "\u{03B1}\u{0301}",
    },
    NormalizationTest {
        source: "\u{03AD}",
        nfc: "\u{03AD}",
        nfd: "\u{03B5}\u{0301}",
        nfkc: "\u{03AD}",
        nfkd: "\u{03B5}\u{0301}",
    },
    NormalizationTest {
        source: "\u{03AE}",
        nfc: "\u{03AE}",
        nfd: "\u{03B7}\u{0301}",
        nfkc: "\u{03AE}",
        nfkd: "\u{03B7}\u{0301}",
    },
    NormalizationTest {
        source: "\u{03AF}",
        nfc: "\u{03AF}",
        nfd: "\u{03B9}\u{0301}",
        nfkc: "\u{03AF}",
        nfkd: "\u{03B9}\u{0301}",
    },
    NormalizationTest {
        source: "\u{03B0}",
        nfc: "\u{03B0}",
        nfd: "\u{03C5}\u{0308}\u{0301}",
        nfkc: "\u{03B0}",
        nfkd: "\u{03C5}\u{0308}\u{0301}",
    },
    NormalizationTest {
        source: "\u{03CA}",
        nfc: "\u{03CA}",
        nfd: "\u{03B9}\u{0308}",
        nfkc: "\u{03CA}",
        nfkd: "\u{03B9}\u{0308}",
    },
    NormalizationTest {
        source: "\u{03CB}",
        nfc: "\u{03CB}",
        nfd: "\u{03C5}\u{0308}",
        nfkc: "\u{03CB}",
        nfkd: "\u{03C5}\u{0308}",
    },
    NormalizationTest {
        source: "\u{03CC}",
        nfc: "\u{03CC}",
        nfd: "\u{03BF}\u{0301}",
        nfkc: "\u{03CC}",
        nfkd: "\u{03BF}\u{0301}",
    },
    NormalizationTest {
        source: "\u{03CD}",
        nfc: "\u{03CD}",
        nfd: "\u{03C5}\u{0301}",
        nfkc: "\u{03CD}",
        nfkd: "\u{03C5}\u{0301}",
    },
    NormalizationTest {
        source: "\u{03CE}",
        nfc: "\u{03CE}",
        nfd: "\u{03C9}\u{0301}",
        nfkc: "\u{03CE}",
        nfkd: "\u{03C9}\u{0301}",
    },
    NormalizationTest {
        source: "\u{03D0}",
        nfc: "\u{03D0}",
        nfd: "\u{03D0}",
        nfkc: "\u{03B2}",
        nfkd: "\u{03B2}",
    },
    NormalizationTest {
        source: "\u{03D1}",
        nfc: "\u{03D1}",
        nfd: "\u{03D1}",
        nfkc: "\u{03B8}",
        nfkd: "\u{03B8}",
    },
    NormalizationTest {
        source: "\u{03D2}",
        nfc: "\u{03D2}",
        nfd: "\u{03D2}",
        nfkc: "\u{03A5}",
        nfkd: "\u{03A5}",
    },
    NormalizationTest {
        source: "\u{03D3}",
        nfc: "\u{03D3}",
        nfd: "\u{03D2}\u{0301}",
        nfkc: "\u{038E}",
        nfkd: "\u{03A5}\u{0301}",
    },
    NormalizationTest {
        source: "\u{03D4}",
        nfc: "\u{03D4}",
        nfd: "\u{03D2}\u{0308}",
        nfkc: "\u{03AB}",
        nfkd: "\u{03A5}\u{0308}",
    },
    NormalizationTest {
        source: "\u{03D5}",
        nfc: "\u{03D5}",
        nfd: "\u{03D5}",
        nfkc: "\u{03C6}",
        nfkd: "\u{03C6}",
    },
    NormalizationTest {
        source: "\u{03D6}",
        nfc: "\u{03D6}",
        nfd: "\u{03D6}",
        nfkc: "\u{03C0}",
        nfkd: "\u{03C0}",
    },
    NormalizationTest {
        source: "\u{03F0}",
        nfc: "\u{03F0}",
        nfd: "\u{03F0}",
        nfkc: "\u{03BA}",
        nfkd: "\u{03BA}",
    },
    NormalizationTest {
        source: "\u{03F1}",
        nfc: "\u{03F1}",
        nfd: "\u{03F1}",
        nfkc: "\u{03C1}",
        nfkd: "\u{03C1}",
    },
    NormalizationTest {
        source: "\u{03F2}",
        nfc: "\u{03F2}",
        nfd: "\u{03F2}",
        nfkc: "\u{03C2}",
        nfkd: "\u{03C2}",
    },
    NormalizationTest {
        source: "\u{03F4}",
        nfc: "\u{03F4}",
        nfd: "\u{03F4}",
        nfkc: "\u{0398}",
        nfkd: "\u{0398}",
    },
    NormalizationTest {
        source: "\u{03F5}",
        nfc: "\u{03F5}",
        nfd: "\u{03F5}",
        nfkc: "\u{03B5}",
        nfkd: "\u{03B5}",
    },
    NormalizationTest {
        source: "\u{03F9}",
        nfc: "\u{03F9}",
        nfd: "\u{03F9}",
        nfkc: "\u{03A3}",
        nfkd: "\u{03A3}",
    },
    NormalizationTest {
        source: "\u{0400}",
        nfc: "\u{0400}",
        nfd: "\u{0415}\u{0300}",
        nfkc: "\u{0400}",
        nfkd: "\u{0415}\u{0300}",
    },
    NormalizationTest {
        source: "\u{0401}",
        nfc: "\u{0401}",
        nfd: "\u{0415}\u{0308}",
        nfkc: "\u{0401}",
        nfkd: "\u{0415}\u{0308}",
    },
    NormalizationTest {
        source: "\u{0403}",
        nfc: "\u{0403}",
        nfd: "\u{0413}\u{0301}",
        nfkc: "\u{0403}",
        nfkd: "\u{0413}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0407}",
        nfc: "\u{0407}",
        nfd: "\u{0406}\u{0308}",
        nfkc: "\u{0407}",
        nfkd: "\u{0406}\u{0308}",
    },
    NormalizationTest {
        source: "\u{040C}",
        nfc: "\u{040C}",
        nfd: "\u{041A}\u{0301}",
        nfkc: "\u{040C}",
        nfkd: "\u{041A}\u{0301}",
    },
    NormalizationTest {
        source: "\u{040D}",
        nfc: "\u{040D}",
        nfd: "\u{0418}\u{0300}",
        nfkc: "\u{040D}",
        nfkd: "\u{0418}\u{0300}",
    },
    NormalizationTest {
        source: "\u{040E}",
        nfc: "\u{040E}",
        nfd: "\u{0423}\u{0306}",
        nfkc: "\u{040E}",
        nfkd: "\u{0423}\u{0306}",
    },
    NormalizationTest {
        source: "\u{0419}",
        nfc: "\u{0419}",
        nfd: "\u{0418}\u{0306}",
        nfkc: "\u{0419}",
        nfkd: "\u{0418}\u{0306}",
    },
    NormalizationTest {
        source: "\u{0439}",
        nfc: "\u{0439}",
        nfd: "\u{0438}\u{0306}",
        nfkc: "\u{0439}",
        nfkd: "\u{0438}\u{0306}",
    },
    NormalizationTest {
        source: "\u{0450}",
        nfc: "\u{0450}",
        nfd: "\u{0435}\u{0300}",
        nfkc: "\u{0450}",
        nfkd: "\u{0435}\u{0300}",
    },
    NormalizationTest {
        source: "\u{0451}",
        nfc: "\u{0451}",
        nfd: "\u{0435}\u{0308}",
        nfkc: "\u{0451}",
        nfkd: "\u{0435}\u{0308}",
    },
    NormalizationTest {
        source: "\u{0453}",
        nfc: "\u{0453}",
        nfd: "\u{0433}\u{0301}",
        nfkc: "\u{0453}",
        nfkd: "\u{0433}\u{0301}",
    },
    NormalizationTest {
        source: "\u{0457}",
        nfc: "\u{0457}",
        nfd: "\u{0456}\u{0308}",
        nfkc: "\u{0457}",
        nfkd: "\u{0456}\u{0308}",
    },
    NormalizationTest {
        source: "\u{045C}",
        nfc: "\u{045C}",
        nfd: "\u{043A}\u{0301}",
        nfkc: "\u{045C}",
        nfkd: "\u{043A}\u{0301}",
    },
    NormalizationTest {
        source: "\u{045D}",
        nfc: "\u{045D}",
        nfd: "\u{0438}\u{0300}",
        nfkc: "\u{045D}",
        nfkd: "\u{0438}\u{0300}",
    },
    NormalizationTest {
        source: "\u{045E}",
        nfc: "\u{045E}",
        nfd: "\u{0443}\u{0306}",
        nfkc: "\u{045E}",
        nfkd: "\u{0443}\u{0306}",
    },
    NormalizationTest {
        source: "\u{0476}",
        nfc: "\u{0476}",
        nfd: "\u{0474}\u{030F}",
        nfkc: "\u{0476}",
        nfkd: "\u{0474}\u{030F}",
    },
    NormalizationTest {
        source: "\u{0477}",
        nfc: "\u{0477}",
        nfd: "\u{0475}\u{030F}",
        nfkc: "\u{0477}",
        nfkd: "\u{0475}\u{030F}",
    },
    NormalizationTest {
        source: "\u{04C1}",
        nfc: "\u{04C1}",
        nfd: "\u{0416}\u{0306}",
        nfkc: "\u{04C1}",
        nfkd: "\u{0416}\u{0306}",
    },
    NormalizationTest {
        source: "\u{04C2}",
        nfc: "\u{04C2}",
        nfd: "\u{0436}\u{0306}",
        nfkc: "\u{04C2}",
        nfkd: "\u{0436}\u{0306}",
    },
    NormalizationTest {
        source: "\u{04D0}",
        nfc: "\u{04D0}",
        nfd: "\u{0410}\u{0306}",
        nfkc: "\u{04D0}",
        nfkd: "\u{0410}\u{0306}",
    },
    NormalizationTest {
        source: "\u{04D1}",
        nfc: "\u{04D1}",
        nfd: "\u{0430}\u{0306}",
        nfkc: "\u{04D1}",
        nfkd: "\u{0430}\u{0306}",
    },
    NormalizationTest {
        source: "\u{04D2}",
        nfc: "\u{04D2}",
        nfd: "\u{0410}\u{0308}",
        nfkc: "\u{04D2}",
        nfkd: "\u{0410}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04D3}",
        nfc: "\u{04D3}",
        nfd: "\u{0430}\u{0308}",
        nfkc: "\u{04D3}",
        nfkd: "\u{0430}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04D6}",
        nfc: "\u{04D6}",
        nfd: "\u{0415}\u{0306}",
        nfkc: "\u{04D6}",
        nfkd: "\u{0415}\u{0306}",
    },
    NormalizationTest {
        source: "\u{04D7}",
        nfc: "\u{04D7}",
        nfd: "\u{0435}\u{0306}",
        nfkc: "\u{04D7}",
        nfkd: "\u{0435}\u{0306}",
    },
    NormalizationTest {
        source: "\u{04DA}",
        nfc: "\u{04DA}",
        nfd: "\u{04D8}\u{0308}",
        nfkc: "\u{04DA}",
        nfkd: "\u{04D8}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04DB}",
        nfc: "\u{04DB}",
        nfd: "\u{04D9}\u{0308}",
        nfkc: "\u{04DB}",
        nfkd: "\u{04D9}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04DC}",
        nfc: "\u{04DC}",
        nfd: "\u{0416}\u{0308}",
        nfkc: "\u{04DC}",
        nfkd: "\u{0416}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04DD}",
        nfc: "\u{04DD}",
        nfd: "\u{0436}\u{0308}",
        nfkc: "\u{04DD}",
        nfkd: "\u{0436}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04DE}",
        nfc: "\u{04DE}",
        nfd: "\u{0417}\u{0308}",
        nfkc: "\u{04DE}",
        nfkd: "\u{0417}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04DF}",
        nfc: "\u{04DF}",
        nfd: "\u{0437}\u{0308}",
        nfkc: "\u{04DF}",
        nfkd: "\u{0437}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04E2}",
        nfc: "\u{04E2}",
        nfd: "\u{0418}\u{0304}",
        nfkc: "\u{04E2}",
        nfkd: "\u{0418}\u{0304}",
    },
    NormalizationTest {
        source: "\u{04E3}",
        nfc: "\u{04E3}",
        nfd: "\u{0438}\u{0304}",
        nfkc: "\u{04E3}",
        nfkd: "\u{0438}\u{0304}",
    },
    NormalizationTest {
        source: "\u{04E4}",
        nfc: "\u{04E4}",
        nfd: "\u{0418}\u{0308}",
        nfkc: "\u{04E4}",
        nfkd: "\u{0418}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04E5}",
        nfc: "\u{04E5}",
        nfd: "\u{0438}\u{0308}",
        nfkc: "\u{04E5}",
        nfkd: "\u{0438}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04E6}",
        nfc: "\u{04E6}",
        nfd: "\u{041E}\u{0308}",
        nfkc: "\u{04E6}",
        nfkd: "\u{041E}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04E7}",
        nfc: "\u{04E7}",
        nfd: "\u{043E}\u{0308}",
        nfkc: "\u{04E7}",
        nfkd: "\u{043E}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04EA}",
        nfc: "\u{04EA}",
        nfd: "\u{04E8}\u{0308}",
        nfkc: "\u{04EA}",
        nfkd: "\u{04E8}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04EB}",
        nfc: "\u{04EB}",
        nfd: "\u{04E9}\u{0308}",
        nfkc: "\u{04EB}",
        nfkd: "\u{04E9}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04EC}",
        nfc: "\u{04EC}",
        nfd: "\u{042D}\u{0308}",
        nfkc: "\u{04EC}",
        nfkd: "\u{042D}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04ED}",
        nfc: "\u{04ED}",
        nfd: "\u{044D}\u{0308}",
        nfkc: "\u{04ED}",
        nfkd: "\u{044D}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04EE}",
        nfc: "\u{04EE}",
        nfd: "\u{0423}\u{0304}",
        nfkc: "\u{04EE}",
        nfkd: "\u{0423}\u{0304}",
    },
    NormalizationTest {
        source: "\u{04EF}",
        nfc: "\u{04EF}",
        nfd: "\u{0443}\u{0304}",
        nfkc: "\u{04EF}",
        nfkd: "\u{0443}\u{0304}",
    },
    NormalizationTest {
        source: "\u{04F0}",
        nfc: "\u{04F0}",
        nfd: "\u{0423}\u{0308}",
        nfkc: "\u{04F0}",
        nfkd: "\u{0423}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04F1}",
        nfc: "\u{04F1}",
        nfd: "\u{0443}\u{0308}",
        nfkc: "\u{04F1}",
        nfkd: "\u{0443}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04F2}",
        nfc: "\u{04F2}",
        nfd: "\u{0423}\u{030B}",
        nfkc: "\u{04F2}",
        nfkd: "\u{0423}\u{030B}",
    },
    NormalizationTest {
        source: "\u{04F3}",
        nfc: "\u{04F3}",
        nfd: "\u{0443}\u{030B}",
        nfkc: "\u{04F3}",
        nfkd: "\u{0443}\u{030B}",
    },
    NormalizationTest {
        source: "\u{04F4}",
        nfc: "\u{04F4}",
        nfd: "\u{0427}\u{0308}",
        nfkc: "\u{04F4}",
        nfkd: "\u{0427}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04F5}",
        nfc: "\u{04F5}",
        nfd: "\u{0447}\u{0308}",
        nfkc: "\u{04F5}",
        nfkd: "\u{0447}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04F8}",
        nfc: "\u{04F8}",
        nfd: "\u{042B}\u{0308}",
        nfkc: "\u{04F8}",
        nfkd: "\u{042B}\u{0308}",
    },
    NormalizationTest {
        source: "\u{04F9}",
        nfc: "\u{04F9}",
        nfd: "\u{044B}\u{0308}",
        nfkc: "\u{04F9}",
        nfkd: "\u{044B}\u{0308}",
    },
    NormalizationTest {
        source: "\u{0587}",
        nfc: "\u{0587}",
        nfd: "\u{0587}",
        nfkc: "\u{0565}\u{0582}",
        nfkd: "\u{0565}\u{0582}",
    },
    NormalizationTest {
        source: "\u{0622}",
        nfc: "\u{0622}",
        nfd: "\u{0627}\u{0653}",
        nfkc: "\u{0622}",
        nfkd: "\u{0627}\u{0653}",
    },
    NormalizationTest {
        source: "\u{0623}",
        nfc: "\u{0623}",
        nfd: "\u{0627}\u{0654}",
        nfkc: "\u{0623}",
        nfkd: "\u{0627}\u{0654}",
    },
    NormalizationTest {
        source: "\u{0624}",
        nfc: "\u{0624}",
        nfd: "\u{0648}\u{0654}",
        nfkc: "\u{0624}",
        nfkd: "\u{0648}\u{0654}",
    },
    NormalizationTest {
        source: "\u{0625}",
        nfc: "\u{0625}",
        nfd: "\u{0627}\u{0655}",
        nfkc: "\u{0625}",
        nfkd: "\u{0627}\u{0655}",
    },
    NormalizationTest {
        source: "\u{0626}",
        nfc: "\u{0626}",
        nfd: "\u{064A}\u{0654}",
        nfkc: "\u{0626}",
        nfkd: "\u{064A}\u{0654}",
    },
    NormalizationTest {
        source: "\u{0675}",
        nfc: "\u{0675}",
        nfd: "\u{0675}",
        nfkc: "\u{0627}\u{0674}",
        nfkd: "\u{0627}\u{0674}",
    },
    NormalizationTest {
        source: "\u{0676}",
        nfc: "\u{0676}",
        nfd: "\u{0676}",
        nfkc: "\u{0648}\u{0674}",
        nfkd: "\u{0648}\u{0674}",
    },
    NormalizationTest {
        source: "\u{0677}",
        nfc: "\u{0677}",
        nfd: "\u{0677}",
        nfkc: "\u{06C7}\u{0674}",
        nfkd: "\u{06C7}\u{0674}",
    },
    NormalizationTest {
        source: "\u{0678}",
        nfc: "\u{0678}",
        nfd: "\u{0678}",
        nfkc: "\u{064A}\u{0674}",
        nfkd: "\u{064A}\u{0674}",
    },
    NormalizationTest {
        source: "\u{06C0}",
        nfc: "\u{06C0}",
        nfd: "\u{06D5}\u{0654}",
        nfkc: "\u{06C0}",
        nfkd: "\u{06D5}\u{0654}",
    },
    NormalizationTest {
        source: "\u{06C2}",
        nfc: "\u{06C2}",
        nfd: "\u{06C1}\u{0654}",
        nfkc: "\u{06C2}",
        nfkd: "\u{06C1}\u{0654}",
    },
    NormalizationTest {
        source: "\u{06D3}",
        nfc: "\u{06D3}",
        nfd: "\u{06D2}\u{0654}",
        nfkc: "\u{06D3}",
        nfkd: "\u{06D2}\u{0654}",
    },
    NormalizationTest {
        source: "\u{0929}",
        nfc: "\u{0929}",
        nfd: "\u{0928}\u{093C}",
        nfkc: "\u{0929}",
        nfkd: "\u{0928}\u{093C}",
    },
    NormalizationTest {
        source: "\u{0931}",
        nfc: "\u{0931}",
        nfd: "\u{0930}\u{093C}",
        nfkc: "\u{0931}",
        nfkd: "\u{0930}\u{093C}",
    },
    NormalizationTest {
        source: "\u{0934}",
        nfc: "\u{0934}",
        nfd: "\u{0933}\u{093C}",
        nfkc: "\u{0934}",
        nfkd: "\u{0933}\u{093C}",
    },
    NormalizationTest {
        source: "\u{0958}",
        nfc: "\u{0915}\u{093C}",
        nfd: "\u{0915}\u{093C}",
        nfkc: "\u{0915}\u{093C}",
        nfkd: "\u{0915}\u{093C}",
    },
    NormalizationTest {
        source: "\u{0959}",
        nfc: "\u{0916}\u{093C}",
        nfd: "\u{0916}\u{093C}",
        nfkc: "\u{0916}\u{093C}",
        nfkd: "\u{0916}\u{093C}",
    },
    NormalizationTest {
        source: "\u{095A}",
        nfc: "\u{0917}\u{093C}",
        nfd: "\u{0917}\u{093C}",
        nfkc: "\u{0917}\u{093C}",
        nfkd: "\u{0917}\u{093C}",
    },
    NormalizationTest {
        source: "\u{095B}",
        nfc: "\u{091C}\u{093C}",
        nfd: "\u{091C}\u{093C}",
        nfkc: "\u{091C}\u{093C}",
        nfkd: "\u{091C}\u{093C}",
    },
    NormalizationTest {
        source: "\u{095C}",
        nfc: "\u{0921}\u{093C}",
        nfd: "\u{0921}\u{093C}",
        nfkc: "\u{0921}\u{093C}",
        nfkd: "\u{0921}\u{093C}",
    },
    NormalizationTest {
        source: "\u{095D}",
        nfc: "\u{0922}\u{093C}",
        nfd: "\u{0922}\u{093C}",
        nfkc: "\u{0922}\u{093C}",
        nfkd: "\u{0922}\u{093C}",
    },
    NormalizationTest {
        source: "\u{095E}",
        nfc: "\u{092B}\u{093C}",
        nfd: "\u{092B}\u{093C}",
        nfkc: "\u{092B}\u{093C}",
        nfkd: "\u{092B}\u{093C}",
    },
    NormalizationTest {
        source: "\u{095F}",
        nfc: "\u{092F}\u{093C}",
        nfd: "\u{092F}\u{093C}",
        nfkc: "\u{092F}\u{093C}",
        nfkd: "\u{092F}\u{093C}",
    },
    NormalizationTest {
        source: "\u{09CB}",
        nfc: "\u{09CB}",
        nfd: "\u{09C7}\u{09BE}",
        nfkc: "\u{09CB}",
        nfkd: "\u{09C7}\u{09BE}",
    },
    NormalizationTest {
        source: "\u{09CC}",
        nfc: "\u{09CC}",
        nfd: "\u{09C7}\u{09D7}",
        nfkc: "\u{09CC}",
        nfkd: "\u{09C7}\u{09D7}",
    },
    NormalizationTest {
        source: "\u{09DC}",
        nfc: "\u{09A1}\u{09BC}",
        nfd: "\u{09A1}\u{09BC}",
        nfkc: "\u{09A1}\u{09BC}",
        nfkd: "\u{09A1}\u{09BC}",
    },
    NormalizationTest {
        source: "\u{09DD}",
        nfc: "\u{09A2}\u{09BC}",
        nfd: "\u{09A2}\u{09BC}",
        nfkc: "\u{09A2}\u{09BC}",
        nfkd: "\u{09A2}\u{09BC}",
    },
    NormalizationTest {
        source: "\u{09DF}",
        nfc: "\u{09AF}\u{09BC}",
        nfd: "\u{09AF}\u{09BC}",
        nfkc: "\u{09AF}\u{09BC}",
        nfkd: "\u{09AF}\u{09BC}",
    },
    NormalizationTest {
        source: "\u{0A33}",
        nfc: "\u{0A32}\u{0A3C}",
        nfd: "\u{0A32}\u{0A3C}",
        nfkc: "\u{0A32}\u{0A3C}",
        nfkd: "\u{0A32}\u{0A3C}",
    },
    NormalizationTest {
        source: "\u{0A36}",
        nfc: "\u{0A38}\u{0A3C}",
        nfd: "\u{0A38}\u{0A3C}",
        nfkc: "\u{0A38}\u{0A3C}",
        nfkd: "\u{0A38}\u{0A3C}",
    },
    NormalizationTest {
        source: "\u{0A59}",
        nfc: "\u{0A16}\u{0A3C}",
        nfd: "\u{0A16}\u{0A3C}",
        nfkc: "\u{0A16}\u{0A3C}",
        nfkd: "\u{0A16}\u{0A3C}",
    },
    NormalizationTest {
        source: "\u{0A5A}",
        nfc: "\u{0A17}\u{0A3C}",
        nfd: "\u{0A17}\u{0A3C}",
        nfkc: "\u{0A17}\u{0A3C}",
        nfkd: "\u{0A17}\u{0A3C}",
    },
    NormalizationTest {
        source: "\u{0A5B}",
        nfc: "\u{0A1C}\u{0A3C}",
        nfd: "\u{0A1C}\u{0A3C}",
        nfkc: "\u{0A1C}\u{0A3C}",
        nfkd: "\u{0A1C}\u{0A3C}",
    },
    NormalizationTest {
        source: "\u{0A5E}",
        nfc: "\u{0A2B}\u{0A3C}",
        nfd: "\u{0A2B}\u{0A3C}",
        nfkc: "\u{0A2B}\u{0A3C}",
        nfkd: "\u{0A2B}\u{0A3C}",
    },
    NormalizationTest {
        source: "\u{0B48}",
        nfc: "\u{0B48}",
        nfd: "\u{0B47}\u{0B56}",
        nfkc: "\u{0B48}",
        nfkd: "\u{0B47}\u{0B56}",
    },
    NormalizationTest {
        source: "\u{0B4B}",
        nfc: "\u{0B4B}",
        nfd: "\u{0B47}\u{0B3E}",
        nfkc: "\u{0B4B}",
        nfkd: "\u{0B47}\u{0B3E}",
    },
    NormalizationTest {
        source: "\u{0B4C}",
        nfc: "\u{0B4C}",
        nfd: "\u{0B47}\u{0B57}",
        nfkc: "\u{0B4C}",
        nfkd: "\u{0B47}\u{0B57}",
    },
    NormalizationTest {
        source: "\u{0B5C}",
        nfc: "\u{0B21}\u{0B3C}",
        nfd: "\u{0B21}\u{0B3C}",
        nfkc: "\u{0B21}\u{0B3C}",
        nfkd: "\u{0B21}\u{0B3C}",
    },
    NormalizationTest {
        source: "\u{0B5D}",
        nfc: "\u{0B22}\u{0B3C}",
        nfd: "\u{0B22}\u{0B3C}",
        nfkc: "\u{0B22}\u{0B3C}",
        nfkd: "\u{0B22}\u{0B3C}",
    },
    NormalizationTest {
        source: "\u{0B94}",
        nfc: "\u{0B94}",
        nfd: "\u{0B92}\u{0BD7}",
        nfkc: "\u{0B94}",
        nfkd: "\u{0B92}\u{0BD7}",
    },
    NormalizationTest {
        source: "\u{0BCA}",
        nfc: "\u{0BCA}",
        nfd: "\u{0BC6}\u{0BBE}",
        nfkc: "\u{0BCA}",
        nfkd: "\u{0BC6}\u{0BBE}",
    },
    NormalizationTest {
        source: "\u{0BCB}",
        nfc: "\u{0BCB}",
        nfd: "\u{0BC7}\u{0BBE}",
        nfkc: "\u{0BCB}",
        nfkd: "\u{0BC7}\u{0BBE}",
    },
    NormalizationTest {
        source: "\u{0BCC}",
        nfc: "\u{0BCC}",
        nfd: "\u{0BC6}\u{0BD7}",
        nfkc: "\u{0BCC}",
        nfkd: "\u{0BC6}\u{0BD7}",
    },
    NormalizationTest {
        source: "\u{0C48}",
        nfc: "\u{0C48}",
        nfd: "\u{0C46}\u{0C56}",
        nfkc: "\u{0C48}",
        nfkd: "\u{0C46}\u{0C56}",
    },
    NormalizationTest {
        source: "\u{0CC0}",
        nfc: "\u{0CC0}",
        nfd: "\u{0CBF}\u{0CD5}",
        nfkc: "\u{0CC0}",
        nfkd: "\u{0CBF}\u{0CD5}",
    },
    NormalizationTest {
        source: "\u{0CC7}",
        nfc: "\u{0CC7}",
        nfd: "\u{0CC6}\u{0CD5}",
        nfkc: "\u{0CC7}",
        nfkd: "\u{0CC6}\u{0CD5}",
    },
    NormalizationTest {
        source: "\u{0CC8}",
        nfc: "\u{0CC8}",
        nfd: "\u{0CC6}\u{0CD6}",
        nfkc: "\u{0CC8}",
        nfkd: "\u{0CC6}\u{0CD6}",
    },
    NormalizationTest {
        source: "\u{0CCA}",
        nfc: "\u{0CCA}",
        nfd: "\u{0CC6}\u{0CC2}",
        nfkc: "\u{0CCA}",
        nfkd: "\u{0CC6}\u{0CC2}",
    },
    NormalizationTest {
        source: "\u{0CCB}",
        nfc: "\u{0CCB}",
        nfd: "\u{0CC6}\u{0CC2}\u{0CD5}",
        nfkc: "\u{0CCB}",
        nfkd: "\u{0CC6}\u{0CC2}\u{0CD5}",
    },
    NormalizationTest {
        source: "\u{0D4A}",
        nfc: "\u{0D4A}",
        nfd: "\u{0D46}\u{0D3E}",
        nfkc: "\u{0D4A}",
        nfkd: "\u{0D46}\u{0D3E}",
    },
    NormalizationTest {
        source: "\u{0D4B}",
        nfc: "\u{0D4B}",
        nfd: "\u{0D47}\u{0D3E}",
        nfkc: "\u{0D4B}",
        nfkd: "\u{0D47}\u{0D3E}",
    },
    NormalizationTest {
        source: "\u{0D4C}",
        nfc: "\u{0D4C}",
        nfd: "\u{0D46}\u{0D57}",
        nfkc: "\u{0D4C}",
        nfkd: "\u{0D46}\u{0D57}",
    },
    NormalizationTest {
        source: "\u{0DDA}",
        nfc: "\u{0DDA}",
        nfd: "\u{0DD9}\u{0DCA}",
        nfkc: "\u{0DDA}",
        nfkd: "\u{0DD9}\u{0DCA}",
    },
    NormalizationTest {
        source: "\u{0DDC}",
        nfc: "\u{0DDC}",
        nfd: "\u{0DD9}\u{0DCF}",
        nfkc: "\u{0DDC}",
        nfkd: "\u{0DD9}\u{0DCF}",
    },
    NormalizationTest {
        source: "\u{0DDD}",
        nfc: "\u{0DDD}",
        nfd: "\u{0DD9}\u{0DCF}\u{0DCA}",
        nfkc: "\u{0DDD}",
        nfkd: "\u{0DD9}\u{0DCF}\u{0DCA}",
    },
    NormalizationTest {
        source: "\u{0DDE}",
        nfc: "\u{0DDE}",
        nfd: "\u{0DD9}\u{0DDF}",
        nfkc: "\u{0DDE}",
        nfkd: "\u{0DD9}\u{0DDF}",
    },
    NormalizationTest {
        source: "\u{0E33}",
        nfc: "\u{0E33}",
        nfd: "\u{0E33}",
        nfkc: "\u{0E4D}\u{0E32}",
        nfkd: "\u{0E4D}\u{0E32}",
    },
    NormalizationTest {
        source: "\u{0EB3}",
        nfc: "\u{0EB3}",
        nfd: "\u{0EB3}",
        nfkc: "\u{0ECD}\u{0EB2}",
        nfkd: "\u{0ECD}\u{0EB2}",
    },
    NormalizationTest {
        source: "\u{0EDC}",
        nfc: "\u{0EDC}",
        nfd: "\u{0EDC}",
        nfkc: "\u{0EAB}\u{0E99}",
        nfkd: "\u{0EAB}\u{0E99}",
    },
    NormalizationTest {
        source: "\u{0EDD}",
        nfc: "\u{0EDD}",
        nfd: "\u{0EDD}",
        nfkc: "\u{0EAB}\u{0EA1}",
        nfkd: "\u{0EAB}\u{0EA1}",
    },
    NormalizationTest {
        source: "\u{0F0C}",
        nfc: "\u{0F0C}",
        nfd: "\u{0F0C}",
        nfkc: "\u{0F0B}",
        nfkd: "\u{0F0B}",
    },
    NormalizationTest {
        source: "\u{0F43}",
        nfc: "\u{0F42}\u{0FB7}",
        nfd: "\u{0F42}\u{0FB7}",
        nfkc: "\u{0F42}\u{0FB7}",
        nfkd: "\u{0F42}\u{0FB7}",
    },
    NormalizationTest {
        source: "\u{0F4D}",
        nfc: "\u{0F4C}\u{0FB7}",
        nfd: "\u{0F4C}\u{0FB7}",
        nfkc: "\u{0F4C}\u{0FB7}",
        nfkd: "\u{0F4C}\u{0FB7}",
    },
    NormalizationTest {
        source: "\u{0F52}",
        nfc: "\u{0F51}\u{0FB7}",
        nfd: "\u{0F51}\u{0FB7}",
        nfkc: "\u{0F51}\u{0FB7}",
        nfkd: "\u{0F51}\u{0FB7}",
    },
    NormalizationTest {
        source: "\u{0F57}",
        nfc: "\u{0F56}\u{0FB7}",
        nfd: "\u{0F56}\u{0FB7}",
        nfkc: "\u{0F56}\u{0FB7}",
        nfkd: "\u{0F56}\u{0FB7}",
    },
    NormalizationTest {
        source: "\u{0F5C}",
        nfc: "\u{0F5B}\u{0FB7}",
        nfd: "\u{0F5B}\u{0FB7}",
        nfkc: "\u{0F5B}\u{0FB7}",
        nfkd: "\u{0F5B}\u{0FB7}",
    },
    NormalizationTest {
        source: "\u{0F69}",
        nfc: "\u{0F40}\u{0FB5}",
        nfd: "\u{0F40}\u{0FB5}",
        nfkc: "\u{0F40}\u{0FB5}",
        nfkd: "\u{0F40}\u{0FB5}",
    },
    NormalizationTest {
        source: "\u{0F73}",
        nfc: "\u{0F71}\u{0F72}",
        nfd: "\u{0F71}\u{0F72}",
        nfkc: "\u{0F71}\u{0F72}",
        nfkd: "\u{0F71}\u{0F72}",
    },
    NormalizationTest {
        source: "\u{0F75}",
        nfc: "\u{0F71}\u{0F74}",
        nfd: "\u{0F71}\u{0F74}",
        nfkc: "\u{0F71}\u{0F74}",
        nfkd: "\u{0F71}\u{0F74}",
    },
    NormalizationTest {
        source: "\u{0F76}",
        nfc: "\u{0FB2}\u{0F80}",
        nfd: "\u{0FB2}\u{0F80}",
        nfkc: "\u{0FB2}\u{0F80}",
        nfkd: "\u{0FB2}\u{0F80}",
    },
    NormalizationTest {
        source: "\u{0F77}",
        nfc: "\u{0F77}",
        nfd: "\u{0F77}",
        nfkc: "\u{0FB2}\u{0F71}\u{0F80}",
        nfkd: "\u{0FB2}\u{0F71}\u{0F80}",
    },
    NormalizationTest {
        source: "\u{0F78}",
        nfc: "\u{0FB3}\u{0F80}",
        nfd: "\u{0FB3}\u{0F80}",
        nfkc: "\u{0FB3}\u{0F80}",
        nfkd: "\u{0FB3}\u{0F80}",
    },
    NormalizationTest {
        source: "\u{0F79}",
        nfc: "\u{0F79}",
        nfd: "\u{0F79}",
        nfkc: "\u{0FB3}\u{0F71}\u{0F80}",
        nfkd: "\u{0FB3}\u{0F71}\u{0F80}",
    },
    NormalizationTest {
        source: "\u{0F81}",
        nfc: "\u{0F71}\u{0F80}",
        nfd: "\u{0F71}\u{0F80}",
        nfkc: "\u{0F71}\u{0F80}",
        nfkd: "\u{0F71}\u{0F80}",
    },
    NormalizationTest {
        source: "\u{0F93}",
        nfc: "\u{0F92}\u{0FB7}",
        nfd: "\u{0F92}\u{0FB7}",
        nfkc: "\u{0F92}\u{0FB7}",
        nfkd: "\u{0F92}\u{0FB7}",
    },
    NormalizationTest {
        source: "\u{0F9D}",
        nfc: "\u{0F9C}\u{0FB7}",
        nfd: "\u{0F9C}\u{0FB7}",
        nfkc: "\u{0F9C}\u{0FB7}",
        nfkd: "\u{0F9C}\u{0FB7}",
    },
    NormalizationTest {
        source: "\u{0FA2}",
        nfc: "\u{0FA1}\u{0FB7}",
        nfd: "\u{0FA1}\u{0FB7}",
        nfkc: "\u{0FA1}\u{0FB7}",
        nfkd: "\u{0FA1}\u{0FB7}",
    },
    NormalizationTest {
        source: "\u{0FA7}",
        nfc: "\u{0FA6}\u{0FB7}",
        nfd: "\u{0FA6}\u{0FB7}",
        nfkc: "\u{0FA6}\u{0FB7}",
        nfkd: "\u{0FA6}\u{0FB7}",
    },
    NormalizationTest {
        source: "\u{0FAC}",
        nfc: "\u{0FAB}\u{0FB7}",
        nfd: "\u{0FAB}\u{0FB7}",
        nfkc: "\u{0FAB}\u{0FB7}",
        nfkd: "\u{0FAB}\u{0FB7}",
    },
    NormalizationTest {
        source: "\u{0FB9}",
        nfc: "\u{0F90}\u{0FB5}",
        nfd: "\u{0F90}\u{0FB5}",
        nfkc: "\u{0F90}\u{0FB5}",
        nfkd: "\u{0F90}\u{0FB5}",
    },
    NormalizationTest {
        source: "\u{1026}",
        nfc: "\u{1026}",
        nfd: "\u{1025}\u{102E}",
        nfkc: "\u{1026}",
        nfkd: "\u{1025}\u{102E}",
    },
    NormalizationTest {
        source: "\u{10FC}",
        nfc: "\u{10FC}",
        nfd: "\u{10FC}",
        nfkc: "\u{10DC}",
        nfkd: "\u{10DC}",
    },
    NormalizationTest {
        source: "\u{1B06}",
        nfc: "\u{1B06}",
        nfd: "\u{1B05}\u{1B35}",
        nfkc: "\u{1B06}",
        nfkd: "\u{1B05}\u{1B35}",
    },
    NormalizationTest {
        source: "\u{1B08}",
        nfc: "\u{1B08}",
        nfd: "\u{1B07}\u{1B35}",
        nfkc: "\u{1B08}",
        nfkd: "\u{1B07}\u{1B35}",
    },
    NormalizationTest {
        source: "\u{1B0A}",
        nfc: "\u{1B0A}",
        nfd: "\u{1B09}\u{1B35}",
        nfkc: "\u{1B0A}",
        nfkd: "\u{1B09}\u{1B35}",
    },
    NormalizationTest {
        source: "\u{1B0C}",
        nfc: "\u{1B0C}",
        nfd: "\u{1B0B}\u{1B35}",
        nfkc: "\u{1B0C}",
        nfkd: "\u{1B0B}\u{1B35}",
    },
    NormalizationTest {
        source: "\u{1B0E}",
        nfc: "\u{1B0E}",
        nfd: "\u{1B0D}\u{1B35}",
        nfkc: "\u{1B0E}",
        nfkd: "\u{1B0D}\u{1B35}",
    },
    NormalizationTest {
        source: "\u{1B12}",
        nfc: "\u{1B12}",
        nfd: "\u{1B11}\u{1B35}",
        nfkc: "\u{1B12}",
        nfkd: "\u{1B11}\u{1B35}",
    },
    NormalizationTest {
        source: "\u{1B3B}",
        nfc: "\u{1B3B}",
        nfd: "\u{1B3A}\u{1B35}",
        nfkc: "\u{1B3B}",
        nfkd: "\u{1B3A}\u{1B35}",
    },
    NormalizationTest {
        source: "\u{1B3D}",
        nfc: "\u{1B3D}",
        nfd: "\u{1B3C}\u{1B35}",
        nfkc: "\u{1B3D}",
        nfkd: "\u{1B3C}\u{1B35}",
    },
    NormalizationTest {
        source: "\u{1B40}",
        nfc: "\u{1B40}",
        nfd: "\u{1B3E}\u{1B35}",
        nfkc: "\u{1B40}",
        nfkd: "\u{1B3E}\u{1B35}",
    },
    NormalizationTest {
        source: "\u{1B41}",
        nfc: "\u{1B41}",
        nfd: "\u{1B3F}\u{1B35}",
        nfkc: "\u{1B41}",
        nfkd: "\u{1B3F}\u{1B35}",
    },
    NormalizationTest {
        source: "\u{1B43}",
        nfc: "\u{1B43}",
        nfd: "\u{1B42}\u{1B35}",
        nfkc: "\u{1B43}",
        nfkd: "\u{1B42}\u{1B35}",
    },
    NormalizationTest {
        source: "\u{1D2C}",
        nfc: "\u{1D2C}",
        nfd: "\u{1D2C}",
        nfkc: "\u{0041}",
        nfkd: "\u{0041}",
    },
    NormalizationTest {
        source: "\u{1D2D}",
        nfc: "\u{1D2D}",
        nfd: "\u{1D2D}",
        nfkc: "\u{00C6}",
        nfkd: "\u{00C6}",
    },
    NormalizationTest {
        source: "\u{1D2E}",
        nfc: "\u{1D2E}",
        nfd: "\u{1D2E}",
        nfkc: "\u{0042}",
        nfkd: "\u{0042}",
    },
    NormalizationTest {
        source: "\u{1D30}",
        nfc: "\u{1D30}",
        nfd: "\u{1D30}",
        nfkc: "\u{0044}",
        nfkd: "\u{0044}",
    },
    NormalizationTest {
        source: "\u{1D31}",
        nfc: "\u{1D31}",
        nfd: "\u{1D31}",
        nfkc: "\u{0045}",
        nfkd: "\u{0045}",
    },
    NormalizationTest {
        source: "\u{1D32}",
        nfc: "\u{1D32}",
        nfd: "\u{1D32}",
        nfkc: "\u{018E}",
        nfkd: "\u{018E}",
    },
    NormalizationTest {
        source: "\u{1D33}",
        nfc: "\u{1D33}",
        nfd: "\u{1D33}",
        nfkc: "\u{0047}",
        nfkd: "\u{0047}",
    },
    NormalizationTest {
        source: "\u{1D34}",
        nfc: "\u{1D34}",
        nfd: "\u{1D34}",
        nfkc: "\u{0048}",
        nfkd: "\u{0048}",
    },
    NormalizationTest {
        source: "\u{1D35}",
        nfc: "\u{1D35}",
        nfd: "\u{1D35}",
        nfkc: "\u{0049}",
        nfkd: "\u{0049}",
    },
    NormalizationTest {
        source: "\u{1D36}",
        nfc: "\u{1D36}",
        nfd: "\u{1D36}",
        nfkc: "\u{004A}",
        nfkd: "\u{004A}",
    },
    NormalizationTest {
        source: "\u{1D37}",
        nfc: "\u{1D37}",
        nfd: "\u{1D37}",
        nfkc: "\u{004B}",
        nfkd: "\u{004B}",
    },
    NormalizationTest {
        source: "\u{1D38}",
        nfc: "\u{1D38}",
        nfd: "\u{1D38}",
        nfkc: "\u{004C}",
        nfkd: "\u{004C}",
    },
    NormalizationTest {
        source: "\u{1D39}",
        nfc: "\u{1D39}",
        nfd: "\u{1D39}",
        nfkc: "\u{004D}",
        nfkd: "\u{004D}",
    },
    NormalizationTest {
        source: "\u{1D3A}",
        nfc: "\u{1D3A}",
        nfd: "\u{1D3A}",
        nfkc: "\u{004E}",
        nfkd: "\u{004E}",
    },
    NormalizationTest {
        source: "\u{1D3C}",
        nfc: "\u{1D3C}",
        nfd: "\u{1D3C}",
        nfkc: "\u{004F}",
        nfkd: "\u{004F}",
    },
    NormalizationTest {
        source: "\u{1D3D}",
        nfc: "\u{1D3D}",
        nfd: "\u{1D3D}",
        nfkc: "\u{0222}",
        nfkd: "\u{0222}",
    },
    NormalizationTest {
        source: "\u{1D3E}",
        nfc: "\u{1D3E}",
        nfd: "\u{1D3E}",
        nfkc: "\u{0050}",
        nfkd: "\u{0050}",
    },
    NormalizationTest {
        source: "\u{1D3F}",
        nfc: "\u{1D3F}",
        nfd: "\u{1D3F}",
        nfkc: "\u{0052}",
        nfkd: "\u{0052}",
    },
    NormalizationTest {
        source: "\u{1D40}",
        nfc: "\u{1D40}",
        nfd: "\u{1D40}",
        nfkc: "\u{0054}",
        nfkd: "\u{0054}",
    },
    NormalizationTest {
        source: "\u{1D41}",
        nfc: "\u{1D41}",
        nfd: "\u{1D41}",
        nfkc: "\u{0055}",
        nfkd: "\u{0055}",
    },
    NormalizationTest {
        source: "\u{1D42}",
        nfc: "\u{1D42}",
        nfd: "\u{1D42}",
        nfkc: "\u{0057}",
        nfkd: "\u{0057}",
    },
    NormalizationTest {
        source: "\u{1D43}",
        nfc: "\u{1D43}",
        nfd: "\u{1D43}",
        nfkc: "\u{0061}",
        nfkd: "\u{0061}",
    },
    NormalizationTest {
        source: "\u{1D44}",
        nfc: "\u{1D44}",
        nfd: "\u{1D44}",
        nfkc: "\u{0250}",
        nfkd: "\u{0250}",
    },
    NormalizationTest {
        source: "\u{1D45}",
        nfc: "\u{1D45}",
        nfd: "\u{1D45}",
        nfkc: "\u{0251}",
        nfkd: "\u{0251}",
    },
    NormalizationTest {
        source: "\u{1D46}",
        nfc: "\u{1D46}",
        nfd: "\u{1D46}",
        nfkc: "\u{1D02}",
        nfkd: "\u{1D02}",
    },
    NormalizationTest {
        source: "\u{1D47}",
        nfc: "\u{1D47}",
        nfd: "\u{1D47}",
        nfkc: "\u{0062}",
        nfkd: "\u{0062}",
    },
    NormalizationTest {
        source: "\u{1D48}",
        nfc: "\u{1D48}",
        nfd: "\u{1D48}",
        nfkc: "\u{0064}",
        nfkd: "\u{0064}",
    },
    NormalizationTest {
        source: "\u{1D49}",
        nfc: "\u{1D49}",
        nfd: "\u{1D49}",
        nfkc: "\u{0065}",
        nfkd: "\u{0065}",
    },
    NormalizationTest {
        source: "\u{1D4A}",
        nfc: "\u{1D4A}",
        nfd: "\u{1D4A}",
        nfkc: "\u{0259}",
        nfkd: "\u{0259}",
    },
    NormalizationTest {
        source: "\u{1D4B}",
        nfc: "\u{1D4B}",
        nfd: "\u{1D4B}",
        nfkc: "\u{025B}",
        nfkd: "\u{025B}",
    },
    NormalizationTest {
        source: "\u{1D4C}",
        nfc: "\u{1D4C}",
        nfd: "\u{1D4C}",
        nfkc: "\u{025C}",
        nfkd: "\u{025C}",
    },
    NormalizationTest {
        source: "\u{1D4D}",
        nfc: "\u{1D4D}",
        nfd: "\u{1D4D}",
        nfkc: "\u{0067}",
        nfkd: "\u{0067}",
    },
    NormalizationTest {
        source: "\u{1D4F}",
        nfc: "\u{1D4F}",
        nfd: "\u{1D4F}",
        nfkc: "\u{006B}",
        nfkd: "\u{006B}",
    },
    NormalizationTest {
        source: "\u{1D50}",
        nfc: "\u{1D50}",
        nfd: "\u{1D50}",
        nfkc: "\u{006D}",
        nfkd: "\u{006D}",
    },
    NormalizationTest {
        source: "\u{1D51}",
        nfc: "\u{1D51}",
        nfd: "\u{1D51}",
        nfkc: "\u{014B}",
        nfkd: "\u{014B}",
    },
    NormalizationTest {
        source: "\u{1D52}",
        nfc: "\u{1D52}",
        nfd: "\u{1D52}",
        nfkc: "\u{006F}",
        nfkd: "\u{006F}",
    },
    NormalizationTest {
        source: "\u{1D53}",
        nfc: "\u{1D53}",
        nfd: "\u{1D53}",
        nfkc: "\u{0254}",
        nfkd: "\u{0254}",
    },
    NormalizationTest {
        source: "\u{1D54}",
        nfc: "\u{1D54}",
        nfd: "\u{1D54}",
        nfkc: "\u{1D16}",
        nfkd: "\u{1D16}",
    },
    NormalizationTest {
        source: "\u{1D55}",
        nfc: "\u{1D55}",
        nfd: "\u{1D55}",
        nfkc: "\u{1D17}",
        nfkd: "\u{1D17}",
    },
    NormalizationTest {
        source: "\u{1D56}",
        nfc: "\u{1D56}",
        nfd: "\u{1D56}",
        nfkc: "\u{0070}",
        nfkd: "\u{0070}",
    },
    NormalizationTest {
        source: "\u{1D57}",
        nfc: "\u{1D57}",
        nfd: "\u{1D57}",
        nfkc: "\u{0074}",
        nfkd: "\u{0074}",
    },
    NormalizationTest {
        source: "\u{1D58}",
        nfc: "\u{1D58}",
        nfd: "\u{1D58}",
        nfkc: "\u{0075}",
        nfkd: "\u{0075}",
    },
    NormalizationTest {
        source: "\u{1D59}",
        nfc: "\u{1D59}",
        nfd: "\u{1D59}",
        nfkc: "\u{1D1D}",
        nfkd: "\u{1D1D}",
    },
    NormalizationTest {
        source: "\u{1D5A}",
        nfc: "\u{1D5A}",
        nfd: "\u{1D5A}",
        nfkc: "\u{026F}",
        nfkd: "\u{026F}",
    },
    NormalizationTest {
        source: "\u{1D5B}",
        nfc: "\u{1D5B}",
        nfd: "\u{1D5B}",
        nfkc: "\u{0076}",
        nfkd: "\u{0076}",
    },
    NormalizationTest {
        source: "\u{1D5C}",
        nfc: "\u{1D5C}",
        nfd: "\u{1D5C}",
        nfkc: "\u{1D25}",
        nfkd: "\u{1D25}",
    },
    NormalizationTest {
        source: "\u{1D5D}",
        nfc: "\u{1D5D}",
        nfd: "\u{1D5D}",
        nfkc: "\u{03B2}",
        nfkd: "\u{03B2}",
    },
    NormalizationTest {
        source: "\u{1D5E}",
        nfc: "\u{1D5E}",
        nfd: "\u{1D5E}",
        nfkc: "\u{03B3}",
        nfkd: "\u{03B3}",
    },
    NormalizationTest {
        source: "\u{1D5F}",
        nfc: "\u{1D5F}",
        nfd: "\u{1D5F}",
        nfkc: "\u{03B4}",
        nfkd: "\u{03B4}",
    },
    NormalizationTest {
        source: "\u{1D60}",
        nfc: "\u{1D60}",
        nfd: "\u{1D60}",
        nfkc: "\u{03C6}",
        nfkd: "\u{03C6}",
    },
    NormalizationTest {
        source: "\u{1D61}",
        nfc: "\u{1D61}",
        nfd: "\u{1D61}",
        nfkc: "\u{03C7}",
        nfkd: "\u{03C7}",
    },
    NormalizationTest {
        source: "\u{1D62}",
        nfc: "\u{1D62}",
        nfd: "\u{1D62}",
        nfkc: "\u{0069}",
        nfkd: "\u{0069}",
    },
    NormalizationTest {
        source: "\u{1D63}",
        nfc: "\u{1D63}",
        nfd: "\u{1D63}",
        nfkc: "\u{0072}",
        nfkd: "\u{0072}",
    },
    NormalizationTest {
        source: "\u{1D64}",
        nfc: "\u{1D64}",
        nfd: "\u{1D64}",
        nfkc: "\u{0075}",
        nfkd: "\u{0075}",
    },
    NormalizationTest {
        source: "\u{1D65}",
        nfc: "\u{1D65}",
        nfd: "\u{1D65}",
        nfkc: "\u{0076}",
        nfkd: "\u{0076}",
    },
    NormalizationTest {
        source: "\u{1D66}",
        nfc: "\u{1D66}",
        nfd: "\u{1D66}",
        nfkc: "\u{03B2}",
        nfkd: "\u{03B2}",
    },
    NormalizationTest {
        source: "\u{1D67}",
        nfc: "\u{1D67}",
        nfd: "\u{1D67}",
        nfkc: "\u{03B3}",
        nfkd: "\u{03B3}",
    },
    NormalizationTest {
        source: "\u{1D68}",
        nfc: "\u{1D68}",
        nfd: "\u{1D68}",
        nfkc: "\u{03C1}",
        nfkd: "\u{03C1}",
    },
    NormalizationTest {
        source: "\u{1D69}",
        nfc: "\u{1D69}",
        nfd: "\u{1D69}",
        nfkc: "\u{03C6}",
        nfkd: "\u{03C6}",
    },
    NormalizationTest {
        source: "\u{1D6A}",
        nfc: "\u{1D6A}",
        nfd: "\u{1D6A}",
        nfkc: "\u{03C7}",
        nfkd: "\u{03C7}",
    },
    NormalizationTest {
        source: "\u{1D78}",
        nfc: "\u{1D78}",
        nfd: "\u{1D78}",
        nfkc: "\u{043D}",
        nfkd: "\u{043D}",
    },
    NormalizationTest {
        source: "\u{1D9B}",
        nfc: "\u{1D9B}",
        nfd: "\u{1D9B}",
        nfkc: "\u{0252}",
        nfkd: "\u{0252}",
    },
    NormalizationTest {
        source: "\u{1D9C}",
        nfc: "\u{1D9C}",
        nfd: "\u{1D9C}",
        nfkc: "\u{0063}",
        nfkd: "\u{0063}",
    },
    NormalizationTest {
        source: "\u{1D9D}",
        nfc: "\u{1D9D}",
        nfd: "\u{1D9D}",
        nfkc: "\u{0255}",
        nfkd: "\u{0255}",
    },
    NormalizationTest {
        source: "\u{1D9E}",
        nfc: "\u{1D9E}",
        nfd: "\u{1D9E}",
        nfkc: "\u{00F0}",
        nfkd: "\u{00F0}",
    },
    NormalizationTest {
        source: "\u{1D9F}",
        nfc: "\u{1D9F}",
        nfd: "\u{1D9F}",
        nfkc: "\u{025C}",
        nfkd: "\u{025C}",
    },
    NormalizationTest {
        source: "\u{1DA0}",
        nfc: "\u{1DA0}",
        nfd: "\u{1DA0}",
        nfkc: "\u{0066}",
        nfkd: "\u{0066}",
    },
    NormalizationTest {
        source: "\u{1DA1}",
        nfc: "\u{1DA1}",
        nfd: "\u{1DA1}",
        nfkc: "\u{025F}",
        nfkd: "\u{025F}",
    },
    NormalizationTest {
        source: "\u{1DA2}",
        nfc: "\u{1DA2}",
        nfd: "\u{1DA2}",
        nfkc: "\u{0261}",
        nfkd: "\u{0261}",
    },
    NormalizationTest {
        source: "\u{1DA3}",
        nfc: "\u{1DA3}",
        nfd: "\u{1DA3}",
        nfkc: "\u{0265}",
        nfkd: "\u{0265}",
    },
    NormalizationTest {
        source: "\u{1DA4}",
        nfc: "\u{1DA4}",
        nfd: "\u{1DA4}",
        nfkc: "\u{0268}",
        nfkd: "\u{0268}",
    },
    NormalizationTest {
        source: "\u{1DA5}",
        nfc: "\u{1DA5}",
        nfd: "\u{1DA5}",
        nfkc: "\u{0269}",
        nfkd: "\u{0269}",
    },
    NormalizationTest {
        source: "\u{1DA6}",
        nfc: "\u{1DA6}",
        nfd: "\u{1DA6}",
        nfkc: "\u{026A}",
        nfkd: "\u{026A}",
    },
    NormalizationTest {
        source: "\u{1DA7}",
        nfc: "\u{1DA7}",
        nfd: "\u{1DA7}",
        nfkc: "\u{1D7B}",
        nfkd: "\u{1D7B}",
    },
    NormalizationTest {
        source: "\u{1DA8}",
        nfc: "\u{1DA8}",
        nfd: "\u{1DA8}",
        nfkc: "\u{029D}",
        nfkd: "\u{029D}",
    },
    NormalizationTest {
        source: "\u{1DA9}",
        nfc: "\u{1DA9}",
        nfd: "\u{1DA9}",
        nfkc: "\u{026D}",
        nfkd: "\u{026D}",
    },
    NormalizationTest {
        source: "\u{1DAA}",
        nfc: "\u{1DAA}",
        nfd: "\u{1DAA}",
        nfkc: "\u{1D85}",
        nfkd: "\u{1D85}",
    },
    NormalizationTest {
        source: "\u{1DAB}",
        nfc: "\u{1DAB}",
        nfd: "\u{1DAB}",
        nfkc: "\u{029F}",
        nfkd: "\u{029F}",
    },
    NormalizationTest {
        source: "\u{1DAC}",
        nfc: "\u{1DAC}",
        nfd: "\u{1DAC}",
        nfkc: "\u{0271}",
        nfkd: "\u{0271}",
    },
    NormalizationTest {
        source: "\u{1DAD}",
        nfc: "\u{1DAD}",
        nfd: "\u{1DAD}",
        nfkc: "\u{0270}",
        nfkd: "\u{0270}",
    },
    NormalizationTest {
        source: "\u{1DAE}",
        nfc: "\u{1DAE}",
        nfd: "\u{1DAE}",
        nfkc: "\u{0272}",
        nfkd: "\u{0272}",
    },
    NormalizationTest {
        source: "\u{1DAF}",
        nfc: "\u{1DAF}",
        nfd: "\u{1DAF}",
        nfkc: "\u{0273}",
        nfkd: "\u{0273}",
    },
    NormalizationTest {
        source: "\u{1DB0}",
        nfc: "\u{1DB0}",
        nfd: "\u{1DB0}",
        nfkc: "\u{0274}",
        nfkd: "\u{0274}",
    },
    NormalizationTest {
        source: "\u{1DB1}",
        nfc: "\u{1DB1}",
        nfd: "\u{1DB1}",
        nfkc: "\u{0275}",
        nfkd: "\u{0275}",
    },
    NormalizationTest {
        source: "\u{1DB2}",
        nfc: "\u{1DB2}",
        nfd: "\u{1DB2}",
        nfkc: "\u{0278}",
        nfkd: "\u{0278}",
    },
    NormalizationTest {
        source: "\u{1DB3}",
        nfc: "\u{1DB3}",
        nfd: "\u{1DB3}",
        nfkc: "\u{0282}",
        nfkd: "\u{0282}",
    },
    NormalizationTest {
        source: "\u{1DB4}",
        nfc: "\u{1DB4}",
        nfd: "\u{1DB4}",
        nfkc: "\u{0283}",
        nfkd: "\u{0283}",
    },
    NormalizationTest {
        source: "\u{1DB5}",
        nfc: "\u{1DB5}",
        nfd: "\u{1DB5}",
        nfkc: "\u{01AB}",
        nfkd: "\u{01AB}",
    },
    NormalizationTest {
        source: "\u{1DB6}",
        nfc: "\u{1DB6}",
        nfd: "\u{1DB6}",
        nfkc: "\u{0289}",
        nfkd: "\u{0289}",
    },
    NormalizationTest {
        source: "\u{1DB7}",
        nfc: "\u{1DB7}",
        nfd: "\u{1DB7}",
        nfkc: "\u{028A}",
        nfkd: "\u{028A}",
    },
    NormalizationTest {
        source: "\u{1DB8}",
        nfc: "\u{1DB8}",
        nfd: "\u{1DB8}",
        nfkc: "\u{1D1C}",
        nfkd: "\u{1D1C}",
    },
    NormalizationTest {
        source: "\u{1DB9}",
        nfc: "\u{1DB9}",
        nfd: "\u{1DB9}",
        nfkc: "\u{028B}",
        nfkd: "\u{028B}",
    },
    NormalizationTest {
        source: "\u{1DBA}",
        nfc: "\u{1DBA}",
        nfd: "\u{1DBA}",
        nfkc: "\u{028C}",
        nfkd: "\u{028C}",
    },
    NormalizationTest {
        source: "\u{1DBB}",
        nfc: "\u{1DBB}",
        nfd: "\u{1DBB}",
        nfkc: "\u{007A}",
        nfkd: "\u{007A}",
    },
    NormalizationTest {
        source: "\u{1DBC}",
        nfc: "\u{1DBC}",
        nfd: "\u{1DBC}",
        nfkc: "\u{0290}",
        nfkd: "\u{0290}",
    },
    NormalizationTest {
        source: "\u{1DBD}",
        nfc: "\u{1DBD}",
        nfd: "\u{1DBD}",
        nfkc: "\u{0291}",
        nfkd: "\u{0291}",
    },
    NormalizationTest {
        source: "\u{1DBE}",
        nfc: "\u{1DBE}",
        nfd: "\u{1DBE}",
        nfkc: "\u{0292}",
        nfkd: "\u{0292}",
    },
    NormalizationTest {
        source: "\u{1DBF}",
        nfc: "\u{1DBF}",
        nfd: "\u{1DBF}",
        nfkc: "\u{03B8}",
        nfkd: "\u{03B8}",
    },
    NormalizationTest {
        source: "\u{1E00}",
        nfc: "\u{1E00}",
        nfd: "\u{0041}\u{0325}",
        nfkc: "\u{1E00}",
        nfkd: "\u{0041}\u{0325}",
    },
    NormalizationTest {
        source: "\u{1E01}",
        nfc: "\u{1E01}",
        nfd: "\u{0061}\u{0325}",
        nfkc: "\u{1E01}",
        nfkd: "\u{0061}\u{0325}",
    },
    NormalizationTest {
        source: "\u{1E02}",
        nfc: "\u{1E02}",
        nfd: "\u{0042}\u{0307}",
        nfkc: "\u{1E02}",
        nfkd: "\u{0042}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E03}",
        nfc: "\u{1E03}",
        nfd: "\u{0062}\u{0307}",
        nfkc: "\u{1E03}",
        nfkd: "\u{0062}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E04}",
        nfc: "\u{1E04}",
        nfd: "\u{0042}\u{0323}",
        nfkc: "\u{1E04}",
        nfkd: "\u{0042}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E05}",
        nfc: "\u{1E05}",
        nfd: "\u{0062}\u{0323}",
        nfkc: "\u{1E05}",
        nfkd: "\u{0062}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E06}",
        nfc: "\u{1E06}",
        nfd: "\u{0042}\u{0331}",
        nfkc: "\u{1E06}",
        nfkd: "\u{0042}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E07}",
        nfc: "\u{1E07}",
        nfd: "\u{0062}\u{0331}",
        nfkc: "\u{1E07}",
        nfkd: "\u{0062}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E08}",
        nfc: "\u{1E08}",
        nfd: "\u{0043}\u{0327}\u{0301}",
        nfkc: "\u{1E08}",
        nfkd: "\u{0043}\u{0327}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E09}",
        nfc: "\u{1E09}",
        nfd: "\u{0063}\u{0327}\u{0301}",
        nfkc: "\u{1E09}",
        nfkd: "\u{0063}\u{0327}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E0A}",
        nfc: "\u{1E0A}",
        nfd: "\u{0044}\u{0307}",
        nfkc: "\u{1E0A}",
        nfkd: "\u{0044}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E0B}",
        nfc: "\u{1E0B}",
        nfd: "\u{0064}\u{0307}",
        nfkc: "\u{1E0B}",
        nfkd: "\u{0064}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E0C}",
        nfc: "\u{1E0C}",
        nfd: "\u{0044}\u{0323}",
        nfkc: "\u{1E0C}",
        nfkd: "\u{0044}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E0D}",
        nfc: "\u{1E0D}",
        nfd: "\u{0064}\u{0323}",
        nfkc: "\u{1E0D}",
        nfkd: "\u{0064}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E0E}",
        nfc: "\u{1E0E}",
        nfd: "\u{0044}\u{0331}",
        nfkc: "\u{1E0E}",
        nfkd: "\u{0044}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E0F}",
        nfc: "\u{1E0F}",
        nfd: "\u{0064}\u{0331}",
        nfkc: "\u{1E0F}",
        nfkd: "\u{0064}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E10}",
        nfc: "\u{1E10}",
        nfd: "\u{0044}\u{0327}",
        nfkc: "\u{1E10}",
        nfkd: "\u{0044}\u{0327}",
    },
    NormalizationTest {
        source: "\u{1E11}",
        nfc: "\u{1E11}",
        nfd: "\u{0064}\u{0327}",
        nfkc: "\u{1E11}",
        nfkd: "\u{0064}\u{0327}",
    },
    NormalizationTest {
        source: "\u{1E12}",
        nfc: "\u{1E12}",
        nfd: "\u{0044}\u{032D}",
        nfkc: "\u{1E12}",
        nfkd: "\u{0044}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E13}",
        nfc: "\u{1E13}",
        nfd: "\u{0064}\u{032D}",
        nfkc: "\u{1E13}",
        nfkd: "\u{0064}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E14}",
        nfc: "\u{1E14}",
        nfd: "\u{0045}\u{0304}\u{0300}",
        nfkc: "\u{1E14}",
        nfkd: "\u{0045}\u{0304}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1E15}",
        nfc: "\u{1E15}",
        nfd: "\u{0065}\u{0304}\u{0300}",
        nfkc: "\u{1E15}",
        nfkd: "\u{0065}\u{0304}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1E16}",
        nfc: "\u{1E16}",
        nfd: "\u{0045}\u{0304}\u{0301}",
        nfkc: "\u{1E16}",
        nfkd: "\u{0045}\u{0304}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E17}",
        nfc: "\u{1E17}",
        nfd: "\u{0065}\u{0304}\u{0301}",
        nfkc: "\u{1E17}",
        nfkd: "\u{0065}\u{0304}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E18}",
        nfc: "\u{1E18}",
        nfd: "\u{0045}\u{032D}",
        nfkc: "\u{1E18}",
        nfkd: "\u{0045}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E19}",
        nfc: "\u{1E19}",
        nfd: "\u{0065}\u{032D}",
        nfkc: "\u{1E19}",
        nfkd: "\u{0065}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E1A}",
        nfc: "\u{1E1A}",
        nfd: "\u{0045}\u{0330}",
        nfkc: "\u{1E1A}",
        nfkd: "\u{0045}\u{0330}",
    },
    NormalizationTest {
        source: "\u{1E1B}",
        nfc: "\u{1E1B}",
        nfd: "\u{0065}\u{0330}",
        nfkc: "\u{1E1B}",
        nfkd: "\u{0065}\u{0330}",
    },
    NormalizationTest {
        source: "\u{1E1C}",
        nfc: "\u{1E1C}",
        nfd: "\u{0045}\u{0327}\u{0306}",
        nfkc: "\u{1E1C}",
        nfkd: "\u{0045}\u{0327}\u{0306}",
    },
    NormalizationTest {
        source: "\u{1E1D}",
        nfc: "\u{1E1D}",
        nfd: "\u{0065}\u{0327}\u{0306}",
        nfkc: "\u{1E1D}",
        nfkd: "\u{0065}\u{0327}\u{0306}",
    },
    NormalizationTest {
        source: "\u{1E1E}",
        nfc: "\u{1E1E}",
        nfd: "\u{0046}\u{0307}",
        nfkc: "\u{1E1E}",
        nfkd: "\u{0046}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E1F}",
        nfc: "\u{1E1F}",
        nfd: "\u{0066}\u{0307}",
        nfkc: "\u{1E1F}",
        nfkd: "\u{0066}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E20}",
        nfc: "\u{1E20}",
        nfd: "\u{0047}\u{0304}",
        nfkc: "\u{1E20}",
        nfkd: "\u{0047}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1E21}",
        nfc: "\u{1E21}",
        nfd: "\u{0067}\u{0304}",
        nfkc: "\u{1E21}",
        nfkd: "\u{0067}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1E22}",
        nfc: "\u{1E22}",
        nfd: "\u{0048}\u{0307}",
        nfkc: "\u{1E22}",
        nfkd: "\u{0048}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E23}",
        nfc: "\u{1E23}",
        nfd: "\u{0068}\u{0307}",
        nfkc: "\u{1E23}",
        nfkd: "\u{0068}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E24}",
        nfc: "\u{1E24}",
        nfd: "\u{0048}\u{0323}",
        nfkc: "\u{1E24}",
        nfkd: "\u{0048}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E25}",
        nfc: "\u{1E25}",
        nfd: "\u{0068}\u{0323}",
        nfkc: "\u{1E25}",
        nfkd: "\u{0068}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E26}",
        nfc: "\u{1E26}",
        nfd: "\u{0048}\u{0308}",
        nfkc: "\u{1E26}",
        nfkd: "\u{0048}\u{0308}",
    },
    NormalizationTest {
        source: "\u{1E27}",
        nfc: "\u{1E27}",
        nfd: "\u{0068}\u{0308}",
        nfkc: "\u{1E27}",
        nfkd: "\u{0068}\u{0308}",
    },
    NormalizationTest {
        source: "\u{1E28}",
        nfc: "\u{1E28}",
        nfd: "\u{0048}\u{0327}",
        nfkc: "\u{1E28}",
        nfkd: "\u{0048}\u{0327}",
    },
    NormalizationTest {
        source: "\u{1E29}",
        nfc: "\u{1E29}",
        nfd: "\u{0068}\u{0327}",
        nfkc: "\u{1E29}",
        nfkd: "\u{0068}\u{0327}",
    },
    NormalizationTest {
        source: "\u{1E2A}",
        nfc: "\u{1E2A}",
        nfd: "\u{0048}\u{032E}",
        nfkc: "\u{1E2A}",
        nfkd: "\u{0048}\u{032E}",
    },
    NormalizationTest {
        source: "\u{1E2B}",
        nfc: "\u{1E2B}",
        nfd: "\u{0068}\u{032E}",
        nfkc: "\u{1E2B}",
        nfkd: "\u{0068}\u{032E}",
    },
    NormalizationTest {
        source: "\u{1E2C}",
        nfc: "\u{1E2C}",
        nfd: "\u{0049}\u{0330}",
        nfkc: "\u{1E2C}",
        nfkd: "\u{0049}\u{0330}",
    },
    NormalizationTest {
        source: "\u{1E2D}",
        nfc: "\u{1E2D}",
        nfd: "\u{0069}\u{0330}",
        nfkc: "\u{1E2D}",
        nfkd: "\u{0069}\u{0330}",
    },
    NormalizationTest {
        source: "\u{1E2E}",
        nfc: "\u{1E2E}",
        nfd: "\u{0049}\u{0308}\u{0301}",
        nfkc: "\u{1E2E}",
        nfkd: "\u{0049}\u{0308}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E2F}",
        nfc: "\u{1E2F}",
        nfd: "\u{0069}\u{0308}\u{0301}",
        nfkc: "\u{1E2F}",
        nfkd: "\u{0069}\u{0308}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E30}",
        nfc: "\u{1E30}",
        nfd: "\u{004B}\u{0301}",
        nfkc: "\u{1E30}",
        nfkd: "\u{004B}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E31}",
        nfc: "\u{1E31}",
        nfd: "\u{006B}\u{0301}",
        nfkc: "\u{1E31}",
        nfkd: "\u{006B}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E32}",
        nfc: "\u{1E32}",
        nfd: "\u{004B}\u{0323}",
        nfkc: "\u{1E32}",
        nfkd: "\u{004B}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E33}",
        nfc: "\u{1E33}",
        nfd: "\u{006B}\u{0323}",
        nfkc: "\u{1E33}",
        nfkd: "\u{006B}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E34}",
        nfc: "\u{1E34}",
        nfd: "\u{004B}\u{0331}",
        nfkc: "\u{1E34}",
        nfkd: "\u{004B}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E35}",
        nfc: "\u{1E35}",
        nfd: "\u{006B}\u{0331}",
        nfkc: "\u{1E35}",
        nfkd: "\u{006B}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E36}",
        nfc: "\u{1E36}",
        nfd: "\u{004C}\u{0323}",
        nfkc: "\u{1E36}",
        nfkd: "\u{004C}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E37}",
        nfc: "\u{1E37}",
        nfd: "\u{006C}\u{0323}",
        nfkc: "\u{1E37}",
        nfkd: "\u{006C}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E38}",
        nfc: "\u{1E38}",
        nfd: "\u{004C}\u{0323}\u{0304}",
        nfkc: "\u{1E38}",
        nfkd: "\u{004C}\u{0323}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1E39}",
        nfc: "\u{1E39}",
        nfd: "\u{006C}\u{0323}\u{0304}",
        nfkc: "\u{1E39}",
        nfkd: "\u{006C}\u{0323}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1E3A}",
        nfc: "\u{1E3A}",
        nfd: "\u{004C}\u{0331}",
        nfkc: "\u{1E3A}",
        nfkd: "\u{004C}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E3B}",
        nfc: "\u{1E3B}",
        nfd: "\u{006C}\u{0331}",
        nfkc: "\u{1E3B}",
        nfkd: "\u{006C}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E3C}",
        nfc: "\u{1E3C}",
        nfd: "\u{004C}\u{032D}",
        nfkc: "\u{1E3C}",
        nfkd: "\u{004C}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E3D}",
        nfc: "\u{1E3D}",
        nfd: "\u{006C}\u{032D}",
        nfkc: "\u{1E3D}",
        nfkd: "\u{006C}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E3E}",
        nfc: "\u{1E3E}",
        nfd: "\u{004D}\u{0301}",
        nfkc: "\u{1E3E}",
        nfkd: "\u{004D}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E3F}",
        nfc: "\u{1E3F}",
        nfd: "\u{006D}\u{0301}",
        nfkc: "\u{1E3F}",
        nfkd: "\u{006D}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E40}",
        nfc: "\u{1E40}",
        nfd: "\u{004D}\u{0307}",
        nfkc: "\u{1E40}",
        nfkd: "\u{004D}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E41}",
        nfc: "\u{1E41}",
        nfd: "\u{006D}\u{0307}",
        nfkc: "\u{1E41}",
        nfkd: "\u{006D}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E42}",
        nfc: "\u{1E42}",
        nfd: "\u{004D}\u{0323}",
        nfkc: "\u{1E42}",
        nfkd: "\u{004D}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E43}",
        nfc: "\u{1E43}",
        nfd: "\u{006D}\u{0323}",
        nfkc: "\u{1E43}",
        nfkd: "\u{006D}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E44}",
        nfc: "\u{1E44}",
        nfd: "\u{004E}\u{0307}",
        nfkc: "\u{1E44}",
        nfkd: "\u{004E}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E45}",
        nfc: "\u{1E45}",
        nfd: "\u{006E}\u{0307}",
        nfkc: "\u{1E45}",
        nfkd: "\u{006E}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E46}",
        nfc: "\u{1E46}",
        nfd: "\u{004E}\u{0323}",
        nfkc: "\u{1E46}",
        nfkd: "\u{004E}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E47}",
        nfc: "\u{1E47}",
        nfd: "\u{006E}\u{0323}",
        nfkc: "\u{1E47}",
        nfkd: "\u{006E}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E48}",
        nfc: "\u{1E48}",
        nfd: "\u{004E}\u{0331}",
        nfkc: "\u{1E48}",
        nfkd: "\u{004E}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E49}",
        nfc: "\u{1E49}",
        nfd: "\u{006E}\u{0331}",
        nfkc: "\u{1E49}",
        nfkd: "\u{006E}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E4A}",
        nfc: "\u{1E4A}",
        nfd: "\u{004E}\u{032D}",
        nfkc: "\u{1E4A}",
        nfkd: "\u{004E}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E4B}",
        nfc: "\u{1E4B}",
        nfd: "\u{006E}\u{032D}",
        nfkc: "\u{1E4B}",
        nfkd: "\u{006E}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E4C}",
        nfc: "\u{1E4C}",
        nfd: "\u{004F}\u{0303}\u{0301}",
        nfkc: "\u{1E4C}",
        nfkd: "\u{004F}\u{0303}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E4D}",
        nfc: "\u{1E4D}",
        nfd: "\u{006F}\u{0303}\u{0301}",
        nfkc: "\u{1E4D}",
        nfkd: "\u{006F}\u{0303}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E4E}",
        nfc: "\u{1E4E}",
        nfd: "\u{004F}\u{0303}\u{0308}",
        nfkc: "\u{1E4E}",
        nfkd: "\u{004F}\u{0303}\u{0308}",
    },
    NormalizationTest {
        source: "\u{1E4F}",
        nfc: "\u{1E4F}",
        nfd: "\u{006F}\u{0303}\u{0308}",
        nfkc: "\u{1E4F}",
        nfkd: "\u{006F}\u{0303}\u{0308}",
    },
    NormalizationTest {
        source: "\u{1E50}",
        nfc: "\u{1E50}",
        nfd: "\u{004F}\u{0304}\u{0300}",
        nfkc: "\u{1E50}",
        nfkd: "\u{004F}\u{0304}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1E51}",
        nfc: "\u{1E51}",
        nfd: "\u{006F}\u{0304}\u{0300}",
        nfkc: "\u{1E51}",
        nfkd: "\u{006F}\u{0304}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1E52}",
        nfc: "\u{1E52}",
        nfd: "\u{004F}\u{0304}\u{0301}",
        nfkc: "\u{1E52}",
        nfkd: "\u{004F}\u{0304}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E53}",
        nfc: "\u{1E53}",
        nfd: "\u{006F}\u{0304}\u{0301}",
        nfkc: "\u{1E53}",
        nfkd: "\u{006F}\u{0304}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E54}",
        nfc: "\u{1E54}",
        nfd: "\u{0050}\u{0301}",
        nfkc: "\u{1E54}",
        nfkd: "\u{0050}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E55}",
        nfc: "\u{1E55}",
        nfd: "\u{0070}\u{0301}",
        nfkc: "\u{1E55}",
        nfkd: "\u{0070}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E56}",
        nfc: "\u{1E56}",
        nfd: "\u{0050}\u{0307}",
        nfkc: "\u{1E56}",
        nfkd: "\u{0050}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E57}",
        nfc: "\u{1E57}",
        nfd: "\u{0070}\u{0307}",
        nfkc: "\u{1E57}",
        nfkd: "\u{0070}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E58}",
        nfc: "\u{1E58}",
        nfd: "\u{0052}\u{0307}",
        nfkc: "\u{1E58}",
        nfkd: "\u{0052}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E59}",
        nfc: "\u{1E59}",
        nfd: "\u{0072}\u{0307}",
        nfkc: "\u{1E59}",
        nfkd: "\u{0072}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E5A}",
        nfc: "\u{1E5A}",
        nfd: "\u{0052}\u{0323}",
        nfkc: "\u{1E5A}",
        nfkd: "\u{0052}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E5B}",
        nfc: "\u{1E5B}",
        nfd: "\u{0072}\u{0323}",
        nfkc: "\u{1E5B}",
        nfkd: "\u{0072}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E5C}",
        nfc: "\u{1E5C}",
        nfd: "\u{0052}\u{0323}\u{0304}",
        nfkc: "\u{1E5C}",
        nfkd: "\u{0052}\u{0323}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1E5D}",
        nfc: "\u{1E5D}",
        nfd: "\u{0072}\u{0323}\u{0304}",
        nfkc: "\u{1E5D}",
        nfkd: "\u{0072}\u{0323}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1E5E}",
        nfc: "\u{1E5E}",
        nfd: "\u{0052}\u{0331}",
        nfkc: "\u{1E5E}",
        nfkd: "\u{0052}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E5F}",
        nfc: "\u{1E5F}",
        nfd: "\u{0072}\u{0331}",
        nfkc: "\u{1E5F}",
        nfkd: "\u{0072}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E60}",
        nfc: "\u{1E60}",
        nfd: "\u{0053}\u{0307}",
        nfkc: "\u{1E60}",
        nfkd: "\u{0053}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E61}",
        nfc: "\u{1E61}",
        nfd: "\u{0073}\u{0307}",
        nfkc: "\u{1E61}",
        nfkd: "\u{0073}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E62}",
        nfc: "\u{1E62}",
        nfd: "\u{0053}\u{0323}",
        nfkc: "\u{1E62}",
        nfkd: "\u{0053}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E63}",
        nfc: "\u{1E63}",
        nfd: "\u{0073}\u{0323}",
        nfkc: "\u{1E63}",
        nfkd: "\u{0073}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E64}",
        nfc: "\u{1E64}",
        nfd: "\u{0053}\u{0301}\u{0307}",
        nfkc: "\u{1E64}",
        nfkd: "\u{0053}\u{0301}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E65}",
        nfc: "\u{1E65}",
        nfd: "\u{0073}\u{0301}\u{0307}",
        nfkc: "\u{1E65}",
        nfkd: "\u{0073}\u{0301}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E66}",
        nfc: "\u{1E66}",
        nfd: "\u{0053}\u{030C}\u{0307}",
        nfkc: "\u{1E66}",
        nfkd: "\u{0053}\u{030C}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E67}",
        nfc: "\u{1E67}",
        nfd: "\u{0073}\u{030C}\u{0307}",
        nfkc: "\u{1E67}",
        nfkd: "\u{0073}\u{030C}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E68}",
        nfc: "\u{1E68}",
        nfd: "\u{0053}\u{0323}\u{0307}",
        nfkc: "\u{1E68}",
        nfkd: "\u{0053}\u{0323}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E69}",
        nfc: "\u{1E69}",
        nfd: "\u{0073}\u{0323}\u{0307}",
        nfkc: "\u{1E69}",
        nfkd: "\u{0073}\u{0323}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E6A}",
        nfc: "\u{1E6A}",
        nfd: "\u{0054}\u{0307}",
        nfkc: "\u{1E6A}",
        nfkd: "\u{0054}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E6B}",
        nfc: "\u{1E6B}",
        nfd: "\u{0074}\u{0307}",
        nfkc: "\u{1E6B}",
        nfkd: "\u{0074}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E6C}",
        nfc: "\u{1E6C}",
        nfd: "\u{0054}\u{0323}",
        nfkc: "\u{1E6C}",
        nfkd: "\u{0054}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E6D}",
        nfc: "\u{1E6D}",
        nfd: "\u{0074}\u{0323}",
        nfkc: "\u{1E6D}",
        nfkd: "\u{0074}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E6E}",
        nfc: "\u{1E6E}",
        nfd: "\u{0054}\u{0331}",
        nfkc: "\u{1E6E}",
        nfkd: "\u{0054}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E6F}",
        nfc: "\u{1E6F}",
        nfd: "\u{0074}\u{0331}",
        nfkc: "\u{1E6F}",
        nfkd: "\u{0074}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E70}",
        nfc: "\u{1E70}",
        nfd: "\u{0054}\u{032D}",
        nfkc: "\u{1E70}",
        nfkd: "\u{0054}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E71}",
        nfc: "\u{1E71}",
        nfd: "\u{0074}\u{032D}",
        nfkc: "\u{1E71}",
        nfkd: "\u{0074}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E72}",
        nfc: "\u{1E72}",
        nfd: "\u{0055}\u{0324}",
        nfkc: "\u{1E72}",
        nfkd: "\u{0055}\u{0324}",
    },
    NormalizationTest {
        source: "\u{1E73}",
        nfc: "\u{1E73}",
        nfd: "\u{0075}\u{0324}",
        nfkc: "\u{1E73}",
        nfkd: "\u{0075}\u{0324}",
    },
    NormalizationTest {
        source: "\u{1E74}",
        nfc: "\u{1E74}",
        nfd: "\u{0055}\u{0330}",
        nfkc: "\u{1E74}",
        nfkd: "\u{0055}\u{0330}",
    },
    NormalizationTest {
        source: "\u{1E75}",
        nfc: "\u{1E75}",
        nfd: "\u{0075}\u{0330}",
        nfkc: "\u{1E75}",
        nfkd: "\u{0075}\u{0330}",
    },
    NormalizationTest {
        source: "\u{1E76}",
        nfc: "\u{1E76}",
        nfd: "\u{0055}\u{032D}",
        nfkc: "\u{1E76}",
        nfkd: "\u{0055}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E77}",
        nfc: "\u{1E77}",
        nfd: "\u{0075}\u{032D}",
        nfkc: "\u{1E77}",
        nfkd: "\u{0075}\u{032D}",
    },
    NormalizationTest {
        source: "\u{1E78}",
        nfc: "\u{1E78}",
        nfd: "\u{0055}\u{0303}\u{0301}",
        nfkc: "\u{1E78}",
        nfkd: "\u{0055}\u{0303}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E79}",
        nfc: "\u{1E79}",
        nfd: "\u{0075}\u{0303}\u{0301}",
        nfkc: "\u{1E79}",
        nfkd: "\u{0075}\u{0303}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E7A}",
        nfc: "\u{1E7A}",
        nfd: "\u{0055}\u{0304}\u{0308}",
        nfkc: "\u{1E7A}",
        nfkd: "\u{0055}\u{0304}\u{0308}",
    },
    NormalizationTest {
        source: "\u{1E7B}",
        nfc: "\u{1E7B}",
        nfd: "\u{0075}\u{0304}\u{0308}",
        nfkc: "\u{1E7B}",
        nfkd: "\u{0075}\u{0304}\u{0308}",
    },
    NormalizationTest {
        source: "\u{1E7C}",
        nfc: "\u{1E7C}",
        nfd: "\u{0056}\u{0303}",
        nfkc: "\u{1E7C}",
        nfkd: "\u{0056}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1E7D}",
        nfc: "\u{1E7D}",
        nfd: "\u{0076}\u{0303}",
        nfkc: "\u{1E7D}",
        nfkd: "\u{0076}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1E7E}",
        nfc: "\u{1E7E}",
        nfd: "\u{0056}\u{0323}",
        nfkc: "\u{1E7E}",
        nfkd: "\u{0056}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E7F}",
        nfc: "\u{1E7F}",
        nfd: "\u{0076}\u{0323}",
        nfkc: "\u{1E7F}",
        nfkd: "\u{0076}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E80}",
        nfc: "\u{1E80}",
        nfd: "\u{0057}\u{0300}",
        nfkc: "\u{1E80}",
        nfkd: "\u{0057}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1E81}",
        nfc: "\u{1E81}",
        nfd: "\u{0077}\u{0300}",
        nfkc: "\u{1E81}",
        nfkd: "\u{0077}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1E82}",
        nfc: "\u{1E82}",
        nfd: "\u{0057}\u{0301}",
        nfkc: "\u{1E82}",
        nfkd: "\u{0057}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E83}",
        nfc: "\u{1E83}",
        nfd: "\u{0077}\u{0301}",
        nfkc: "\u{1E83}",
        nfkd: "\u{0077}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1E84}",
        nfc: "\u{1E84}",
        nfd: "\u{0057}\u{0308}",
        nfkc: "\u{1E84}",
        nfkd: "\u{0057}\u{0308}",
    },
    NormalizationTest {
        source: "\u{1E85}",
        nfc: "\u{1E85}",
        nfd: "\u{0077}\u{0308}",
        nfkc: "\u{1E85}",
        nfkd: "\u{0077}\u{0308}",
    },
    NormalizationTest {
        source: "\u{1E86}",
        nfc: "\u{1E86}",
        nfd: "\u{0057}\u{0307}",
        nfkc: "\u{1E86}",
        nfkd: "\u{0057}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E87}",
        nfc: "\u{1E87}",
        nfd: "\u{0077}\u{0307}",
        nfkc: "\u{1E87}",
        nfkd: "\u{0077}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E88}",
        nfc: "\u{1E88}",
        nfd: "\u{0057}\u{0323}",
        nfkc: "\u{1E88}",
        nfkd: "\u{0057}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E89}",
        nfc: "\u{1E89}",
        nfd: "\u{0077}\u{0323}",
        nfkc: "\u{1E89}",
        nfkd: "\u{0077}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E8A}",
        nfc: "\u{1E8A}",
        nfd: "\u{0058}\u{0307}",
        nfkc: "\u{1E8A}",
        nfkd: "\u{0058}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E8B}",
        nfc: "\u{1E8B}",
        nfd: "\u{0078}\u{0307}",
        nfkc: "\u{1E8B}",
        nfkd: "\u{0078}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E8C}",
        nfc: "\u{1E8C}",
        nfd: "\u{0058}\u{0308}",
        nfkc: "\u{1E8C}",
        nfkd: "\u{0058}\u{0308}",
    },
    NormalizationTest {
        source: "\u{1E8D}",
        nfc: "\u{1E8D}",
        nfd: "\u{0078}\u{0308}",
        nfkc: "\u{1E8D}",
        nfkd: "\u{0078}\u{0308}",
    },
    NormalizationTest {
        source: "\u{1E8E}",
        nfc: "\u{1E8E}",
        nfd: "\u{0059}\u{0307}",
        nfkc: "\u{1E8E}",
        nfkd: "\u{0059}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E8F}",
        nfc: "\u{1E8F}",
        nfd: "\u{0079}\u{0307}",
        nfkc: "\u{1E8F}",
        nfkd: "\u{0079}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1E90}",
        nfc: "\u{1E90}",
        nfd: "\u{005A}\u{0302}",
        nfkc: "\u{1E90}",
        nfkd: "\u{005A}\u{0302}",
    },
    NormalizationTest {
        source: "\u{1E91}",
        nfc: "\u{1E91}",
        nfd: "\u{007A}\u{0302}",
        nfkc: "\u{1E91}",
        nfkd: "\u{007A}\u{0302}",
    },
    NormalizationTest {
        source: "\u{1E92}",
        nfc: "\u{1E92}",
        nfd: "\u{005A}\u{0323}",
        nfkc: "\u{1E92}",
        nfkd: "\u{005A}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E93}",
        nfc: "\u{1E93}",
        nfd: "\u{007A}\u{0323}",
        nfkc: "\u{1E93}",
        nfkd: "\u{007A}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1E94}",
        nfc: "\u{1E94}",
        nfd: "\u{005A}\u{0331}",
        nfkc: "\u{1E94}",
        nfkd: "\u{005A}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E95}",
        nfc: "\u{1E95}",
        nfd: "\u{007A}\u{0331}",
        nfkc: "\u{1E95}",
        nfkd: "\u{007A}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E96}",
        nfc: "\u{1E96}",
        nfd: "\u{0068}\u{0331}",
        nfkc: "\u{1E96}",
        nfkd: "\u{0068}\u{0331}",
    },
    NormalizationTest {
        source: "\u{1E97}",
        nfc: "\u{1E97}",
        nfd: "\u{0074}\u{0308}",
        nfkc: "\u{1E97}",
        nfkd: "\u{0074}\u{0308}",
    },
    NormalizationTest {
        source: "\u{1E98}",
        nfc: "\u{1E98}",
        nfd: "\u{0077}\u{030A}",
        nfkc: "\u{1E98}",
        nfkd: "\u{0077}\u{030A}",
    },
    NormalizationTest {
        source: "\u{1E99}",
        nfc: "\u{1E99}",
        nfd: "\u{0079}\u{030A}",
        nfkc: "\u{1E99}",
        nfkd: "\u{0079}\u{030A}",
    },
    NormalizationTest {
        source: "\u{1E9A}",
        nfc: "\u{1E9A}",
        nfd: "\u{1E9A}",
        nfkc: "\u{0061}\u{02BE}",
        nfkd: "\u{0061}\u{02BE}",
    },
    NormalizationTest {
        source: "\u{1E9B}",
        nfc: "\u{1E9B}",
        nfd: "\u{017F}\u{0307}",
        nfkc: "\u{1E61}",
        nfkd: "\u{0073}\u{0307}",
    },
    NormalizationTest {
        source: "\u{1EA0}",
        nfc: "\u{1EA0}",
        nfd: "\u{0041}\u{0323}",
        nfkc: "\u{1EA0}",
        nfkd: "\u{0041}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EA1}",
        nfc: "\u{1EA1}",
        nfd: "\u{0061}\u{0323}",
        nfkc: "\u{1EA1}",
        nfkd: "\u{0061}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EA2}",
        nfc: "\u{1EA2}",
        nfd: "\u{0041}\u{0309}",
        nfkc: "\u{1EA2}",
        nfkd: "\u{0041}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EA3}",
        nfc: "\u{1EA3}",
        nfd: "\u{0061}\u{0309}",
        nfkc: "\u{1EA3}",
        nfkd: "\u{0061}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EA4}",
        nfc: "\u{1EA4}",
        nfd: "\u{0041}\u{0302}\u{0301}",
        nfkc: "\u{1EA4}",
        nfkd: "\u{0041}\u{0302}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1EA5}",
        nfc: "\u{1EA5}",
        nfd: "\u{0061}\u{0302}\u{0301}",
        nfkc: "\u{1EA5}",
        nfkd: "\u{0061}\u{0302}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1EA6}",
        nfc: "\u{1EA6}",
        nfd: "\u{0041}\u{0302}\u{0300}",
        nfkc: "\u{1EA6}",
        nfkd: "\u{0041}\u{0302}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EA7}",
        nfc: "\u{1EA7}",
        nfd: "\u{0061}\u{0302}\u{0300}",
        nfkc: "\u{1EA7}",
        nfkd: "\u{0061}\u{0302}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EA8}",
        nfc: "\u{1EA8}",
        nfd: "\u{0041}\u{0302}\u{0309}",
        nfkc: "\u{1EA8}",
        nfkd: "\u{0041}\u{0302}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EA9}",
        nfc: "\u{1EA9}",
        nfd: "\u{0061}\u{0302}\u{0309}",
        nfkc: "\u{1EA9}",
        nfkd: "\u{0061}\u{0302}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EAA}",
        nfc: "\u{1EAA}",
        nfd: "\u{0041}\u{0302}\u{0303}",
        nfkc: "\u{1EAA}",
        nfkd: "\u{0041}\u{0302}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EAB}",
        nfc: "\u{1EAB}",
        nfd: "\u{0061}\u{0302}\u{0303}",
        nfkc: "\u{1EAB}",
        nfkd: "\u{0061}\u{0302}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EAC}",
        nfc: "\u{1EAC}",
        nfd: "\u{0041}\u{0323}\u{0302}",
        nfkc: "\u{1EAC}",
        nfkd: "\u{0041}\u{0323}\u{0302}",
    },
    NormalizationTest {
        source: "\u{1EAD}",
        nfc: "\u{1EAD}",
        nfd: "\u{0061}\u{0323}\u{0302}",
        nfkc: "\u{1EAD}",
        nfkd: "\u{0061}\u{0323}\u{0302}",
    },
    NormalizationTest {
        source: "\u{1EAE}",
        nfc: "\u{1EAE}",
        nfd: "\u{0041}\u{0306}\u{0301}",
        nfkc: "\u{1EAE}",
        nfkd: "\u{0041}\u{0306}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1EAF}",
        nfc: "\u{1EAF}",
        nfd: "\u{0061}\u{0306}\u{0301}",
        nfkc: "\u{1EAF}",
        nfkd: "\u{0061}\u{0306}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1EB0}",
        nfc: "\u{1EB0}",
        nfd: "\u{0041}\u{0306}\u{0300}",
        nfkc: "\u{1EB0}",
        nfkd: "\u{0041}\u{0306}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EB1}",
        nfc: "\u{1EB1}",
        nfd: "\u{0061}\u{0306}\u{0300}",
        nfkc: "\u{1EB1}",
        nfkd: "\u{0061}\u{0306}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EB2}",
        nfc: "\u{1EB2}",
        nfd: "\u{0041}\u{0306}\u{0309}",
        nfkc: "\u{1EB2}",
        nfkd: "\u{0041}\u{0306}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EB3}",
        nfc: "\u{1EB3}",
        nfd: "\u{0061}\u{0306}\u{0309}",
        nfkc: "\u{1EB3}",
        nfkd: "\u{0061}\u{0306}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EB4}",
        nfc: "\u{1EB4}",
        nfd: "\u{0041}\u{0306}\u{0303}",
        nfkc: "\u{1EB4}",
        nfkd: "\u{0041}\u{0306}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EB5}",
        nfc: "\u{1EB5}",
        nfd: "\u{0061}\u{0306}\u{0303}",
        nfkc: "\u{1EB5}",
        nfkd: "\u{0061}\u{0306}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EB6}",
        nfc: "\u{1EB6}",
        nfd: "\u{0041}\u{0323}\u{0306}",
        nfkc: "\u{1EB6}",
        nfkd: "\u{0041}\u{0323}\u{0306}",
    },
    NormalizationTest {
        source: "\u{1EB7}",
        nfc: "\u{1EB7}",
        nfd: "\u{0061}\u{0323}\u{0306}",
        nfkc: "\u{1EB7}",
        nfkd: "\u{0061}\u{0323}\u{0306}",
    },
    NormalizationTest {
        source: "\u{1EB8}",
        nfc: "\u{1EB8}",
        nfd: "\u{0045}\u{0323}",
        nfkc: "\u{1EB8}",
        nfkd: "\u{0045}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EB9}",
        nfc: "\u{1EB9}",
        nfd: "\u{0065}\u{0323}",
        nfkc: "\u{1EB9}",
        nfkd: "\u{0065}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EBA}",
        nfc: "\u{1EBA}",
        nfd: "\u{0045}\u{0309}",
        nfkc: "\u{1EBA}",
        nfkd: "\u{0045}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EBB}",
        nfc: "\u{1EBB}",
        nfd: "\u{0065}\u{0309}",
        nfkc: "\u{1EBB}",
        nfkd: "\u{0065}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EBC}",
        nfc: "\u{1EBC}",
        nfd: "\u{0045}\u{0303}",
        nfkc: "\u{1EBC}",
        nfkd: "\u{0045}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EBD}",
        nfc: "\u{1EBD}",
        nfd: "\u{0065}\u{0303}",
        nfkc: "\u{1EBD}",
        nfkd: "\u{0065}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EBE}",
        nfc: "\u{1EBE}",
        nfd: "\u{0045}\u{0302}\u{0301}",
        nfkc: "\u{1EBE}",
        nfkd: "\u{0045}\u{0302}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1EBF}",
        nfc: "\u{1EBF}",
        nfd: "\u{0065}\u{0302}\u{0301}",
        nfkc: "\u{1EBF}",
        nfkd: "\u{0065}\u{0302}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1EC0}",
        nfc: "\u{1EC0}",
        nfd: "\u{0045}\u{0302}\u{0300}",
        nfkc: "\u{1EC0}",
        nfkd: "\u{0045}\u{0302}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EC1}",
        nfc: "\u{1EC1}",
        nfd: "\u{0065}\u{0302}\u{0300}",
        nfkc: "\u{1EC1}",
        nfkd: "\u{0065}\u{0302}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EC2}",
        nfc: "\u{1EC2}",
        nfd: "\u{0045}\u{0302}\u{0309}",
        nfkc: "\u{1EC2}",
        nfkd: "\u{0045}\u{0302}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EC3}",
        nfc: "\u{1EC3}",
        nfd: "\u{0065}\u{0302}\u{0309}",
        nfkc: "\u{1EC3}",
        nfkd: "\u{0065}\u{0302}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EC4}",
        nfc: "\u{1EC4}",
        nfd: "\u{0045}\u{0302}\u{0303}",
        nfkc: "\u{1EC4}",
        nfkd: "\u{0045}\u{0302}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EC5}",
        nfc: "\u{1EC5}",
        nfd: "\u{0065}\u{0302}\u{0303}",
        nfkc: "\u{1EC5}",
        nfkd: "\u{0065}\u{0302}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EC6}",
        nfc: "\u{1EC6}",
        nfd: "\u{0045}\u{0323}\u{0302}",
        nfkc: "\u{1EC6}",
        nfkd: "\u{0045}\u{0323}\u{0302}",
    },
    NormalizationTest {
        source: "\u{1EC7}",
        nfc: "\u{1EC7}",
        nfd: "\u{0065}\u{0323}\u{0302}",
        nfkc: "\u{1EC7}",
        nfkd: "\u{0065}\u{0323}\u{0302}",
    },
    NormalizationTest {
        source: "\u{1EC8}",
        nfc: "\u{1EC8}",
        nfd: "\u{0049}\u{0309}",
        nfkc: "\u{1EC8}",
        nfkd: "\u{0049}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EC9}",
        nfc: "\u{1EC9}",
        nfd: "\u{0069}\u{0309}",
        nfkc: "\u{1EC9}",
        nfkd: "\u{0069}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1ECA}",
        nfc: "\u{1ECA}",
        nfd: "\u{0049}\u{0323}",
        nfkc: "\u{1ECA}",
        nfkd: "\u{0049}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1ECB}",
        nfc: "\u{1ECB}",
        nfd: "\u{0069}\u{0323}",
        nfkc: "\u{1ECB}",
        nfkd: "\u{0069}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1ECC}",
        nfc: "\u{1ECC}",
        nfd: "\u{004F}\u{0323}",
        nfkc: "\u{1ECC}",
        nfkd: "\u{004F}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1ECD}",
        nfc: "\u{1ECD}",
        nfd: "\u{006F}\u{0323}",
        nfkc: "\u{1ECD}",
        nfkd: "\u{006F}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1ECE}",
        nfc: "\u{1ECE}",
        nfd: "\u{004F}\u{0309}",
        nfkc: "\u{1ECE}",
        nfkd: "\u{004F}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1ECF}",
        nfc: "\u{1ECF}",
        nfd: "\u{006F}\u{0309}",
        nfkc: "\u{1ECF}",
        nfkd: "\u{006F}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1ED0}",
        nfc: "\u{1ED0}",
        nfd: "\u{004F}\u{0302}\u{0301}",
        nfkc: "\u{1ED0}",
        nfkd: "\u{004F}\u{0302}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1ED1}",
        nfc: "\u{1ED1}",
        nfd: "\u{006F}\u{0302}\u{0301}",
        nfkc: "\u{1ED1}",
        nfkd: "\u{006F}\u{0302}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1ED2}",
        nfc: "\u{1ED2}",
        nfd: "\u{004F}\u{0302}\u{0300}",
        nfkc: "\u{1ED2}",
        nfkd: "\u{004F}\u{0302}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1ED3}",
        nfc: "\u{1ED3}",
        nfd: "\u{006F}\u{0302}\u{0300}",
        nfkc: "\u{1ED3}",
        nfkd: "\u{006F}\u{0302}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1ED4}",
        nfc: "\u{1ED4}",
        nfd: "\u{004F}\u{0302}\u{0309}",
        nfkc: "\u{1ED4}",
        nfkd: "\u{004F}\u{0302}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1ED5}",
        nfc: "\u{1ED5}",
        nfd: "\u{006F}\u{0302}\u{0309}",
        nfkc: "\u{1ED5}",
        nfkd: "\u{006F}\u{0302}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1ED6}",
        nfc: "\u{1ED6}",
        nfd: "\u{004F}\u{0302}\u{0303}",
        nfkc: "\u{1ED6}",
        nfkd: "\u{004F}\u{0302}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1ED7}",
        nfc: "\u{1ED7}",
        nfd: "\u{006F}\u{0302}\u{0303}",
        nfkc: "\u{1ED7}",
        nfkd: "\u{006F}\u{0302}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1ED8}",
        nfc: "\u{1ED8}",
        nfd: "\u{004F}\u{0323}\u{0302}",
        nfkc: "\u{1ED8}",
        nfkd: "\u{004F}\u{0323}\u{0302}",
    },
    NormalizationTest {
        source: "\u{1ED9}",
        nfc: "\u{1ED9}",
        nfd: "\u{006F}\u{0323}\u{0302}",
        nfkc: "\u{1ED9}",
        nfkd: "\u{006F}\u{0323}\u{0302}",
    },
    NormalizationTest {
        source: "\u{1EDA}",
        nfc: "\u{1EDA}",
        nfd: "\u{004F}\u{031B}\u{0301}",
        nfkc: "\u{1EDA}",
        nfkd: "\u{004F}\u{031B}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1EDB}",
        nfc: "\u{1EDB}",
        nfd: "\u{006F}\u{031B}\u{0301}",
        nfkc: "\u{1EDB}",
        nfkd: "\u{006F}\u{031B}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1EDC}",
        nfc: "\u{1EDC}",
        nfd: "\u{004F}\u{031B}\u{0300}",
        nfkc: "\u{1EDC}",
        nfkd: "\u{004F}\u{031B}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EDD}",
        nfc: "\u{1EDD}",
        nfd: "\u{006F}\u{031B}\u{0300}",
        nfkc: "\u{1EDD}",
        nfkd: "\u{006F}\u{031B}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EDE}",
        nfc: "\u{1EDE}",
        nfd: "\u{004F}\u{031B}\u{0309}",
        nfkc: "\u{1EDE}",
        nfkd: "\u{004F}\u{031B}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EDF}",
        nfc: "\u{1EDF}",
        nfd: "\u{006F}\u{031B}\u{0309}",
        nfkc: "\u{1EDF}",
        nfkd: "\u{006F}\u{031B}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EE0}",
        nfc: "\u{1EE0}",
        nfd: "\u{004F}\u{031B}\u{0303}",
        nfkc: "\u{1EE0}",
        nfkd: "\u{004F}\u{031B}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EE1}",
        nfc: "\u{1EE1}",
        nfd: "\u{006F}\u{031B}\u{0303}",
        nfkc: "\u{1EE1}",
        nfkd: "\u{006F}\u{031B}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EE2}",
        nfc: "\u{1EE2}",
        nfd: "\u{004F}\u{031B}\u{0323}",
        nfkc: "\u{1EE2}",
        nfkd: "\u{004F}\u{031B}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EE3}",
        nfc: "\u{1EE3}",
        nfd: "\u{006F}\u{031B}\u{0323}",
        nfkc: "\u{1EE3}",
        nfkd: "\u{006F}\u{031B}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EE4}",
        nfc: "\u{1EE4}",
        nfd: "\u{0055}\u{0323}",
        nfkc: "\u{1EE4}",
        nfkd: "\u{0055}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EE5}",
        nfc: "\u{1EE5}",
        nfd: "\u{0075}\u{0323}",
        nfkc: "\u{1EE5}",
        nfkd: "\u{0075}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EE6}",
        nfc: "\u{1EE6}",
        nfd: "\u{0055}\u{0309}",
        nfkc: "\u{1EE6}",
        nfkd: "\u{0055}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EE7}",
        nfc: "\u{1EE7}",
        nfd: "\u{0075}\u{0309}",
        nfkc: "\u{1EE7}",
        nfkd: "\u{0075}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EE8}",
        nfc: "\u{1EE8}",
        nfd: "\u{0055}\u{031B}\u{0301}",
        nfkc: "\u{1EE8}",
        nfkd: "\u{0055}\u{031B}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1EE9}",
        nfc: "\u{1EE9}",
        nfd: "\u{0075}\u{031B}\u{0301}",
        nfkc: "\u{1EE9}",
        nfkd: "\u{0075}\u{031B}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1EEA}",
        nfc: "\u{1EEA}",
        nfd: "\u{0055}\u{031B}\u{0300}",
        nfkc: "\u{1EEA}",
        nfkd: "\u{0055}\u{031B}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EEB}",
        nfc: "\u{1EEB}",
        nfd: "\u{0075}\u{031B}\u{0300}",
        nfkc: "\u{1EEB}",
        nfkd: "\u{0075}\u{031B}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EEC}",
        nfc: "\u{1EEC}",
        nfd: "\u{0055}\u{031B}\u{0309}",
        nfkc: "\u{1EEC}",
        nfkd: "\u{0055}\u{031B}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EED}",
        nfc: "\u{1EED}",
        nfd: "\u{0075}\u{031B}\u{0309}",
        nfkc: "\u{1EED}",
        nfkd: "\u{0075}\u{031B}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EEE}",
        nfc: "\u{1EEE}",
        nfd: "\u{0055}\u{031B}\u{0303}",
        nfkc: "\u{1EEE}",
        nfkd: "\u{0055}\u{031B}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EEF}",
        nfc: "\u{1EEF}",
        nfd: "\u{0075}\u{031B}\u{0303}",
        nfkc: "\u{1EEF}",
        nfkd: "\u{0075}\u{031B}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EF0}",
        nfc: "\u{1EF0}",
        nfd: "\u{0055}\u{031B}\u{0323}",
        nfkc: "\u{1EF0}",
        nfkd: "\u{0055}\u{031B}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EF1}",
        nfc: "\u{1EF1}",
        nfd: "\u{0075}\u{031B}\u{0323}",
        nfkc: "\u{1EF1}",
        nfkd: "\u{0075}\u{031B}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EF2}",
        nfc: "\u{1EF2}",
        nfd: "\u{0059}\u{0300}",
        nfkc: "\u{1EF2}",
        nfkd: "\u{0059}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EF3}",
        nfc: "\u{1EF3}",
        nfd: "\u{0079}\u{0300}",
        nfkc: "\u{1EF3}",
        nfkd: "\u{0079}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1EF4}",
        nfc: "\u{1EF4}",
        nfd: "\u{0059}\u{0323}",
        nfkc: "\u{1EF4}",
        nfkd: "\u{0059}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EF5}",
        nfc: "\u{1EF5}",
        nfd: "\u{0079}\u{0323}",
        nfkc: "\u{1EF5}",
        nfkd: "\u{0079}\u{0323}",
    },
    NormalizationTest {
        source: "\u{1EF6}",
        nfc: "\u{1EF6}",
        nfd: "\u{0059}\u{0309}",
        nfkc: "\u{1EF6}",
        nfkd: "\u{0059}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EF7}",
        nfc: "\u{1EF7}",
        nfd: "\u{0079}\u{0309}",
        nfkc: "\u{1EF7}",
        nfkd: "\u{0079}\u{0309}",
    },
    NormalizationTest {
        source: "\u{1EF8}",
        nfc: "\u{1EF8}",
        nfd: "\u{0059}\u{0303}",
        nfkc: "\u{1EF8}",
        nfkd: "\u{0059}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1EF9}",
        nfc: "\u{1EF9}",
        nfd: "\u{0079}\u{0303}",
        nfkc: "\u{1EF9}",
        nfkd: "\u{0079}\u{0303}",
    },
    NormalizationTest {
        source: "\u{1F00}",
        nfc: "\u{1F00}",
        nfd: "\u{03B1}\u{0313}",
        nfkc: "\u{1F00}",
        nfkd: "\u{03B1}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F01}",
        nfc: "\u{1F01}",
        nfd: "\u{03B1}\u{0314}",
        nfkc: "\u{1F01}",
        nfkd: "\u{03B1}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F02}",
        nfc: "\u{1F02}",
        nfd: "\u{03B1}\u{0313}\u{0300}",
        nfkc: "\u{1F02}",
        nfkd: "\u{03B1}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F03}",
        nfc: "\u{1F03}",
        nfd: "\u{03B1}\u{0314}\u{0300}",
        nfkc: "\u{1F03}",
        nfkd: "\u{03B1}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F04}",
        nfc: "\u{1F04}",
        nfd: "\u{03B1}\u{0313}\u{0301}",
        nfkc: "\u{1F04}",
        nfkd: "\u{03B1}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F05}",
        nfc: "\u{1F05}",
        nfd: "\u{03B1}\u{0314}\u{0301}",
        nfkc: "\u{1F05}",
        nfkd: "\u{03B1}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F06}",
        nfc: "\u{1F06}",
        nfd: "\u{03B1}\u{0313}\u{0342}",
        nfkc: "\u{1F06}",
        nfkd: "\u{03B1}\u{0313}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F07}",
        nfc: "\u{1F07}",
        nfd: "\u{03B1}\u{0314}\u{0342}",
        nfkc: "\u{1F07}",
        nfkd: "\u{03B1}\u{0314}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F08}",
        nfc: "\u{1F08}",
        nfd: "\u{0391}\u{0313}",
        nfkc: "\u{1F08}",
        nfkd: "\u{0391}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F09}",
        nfc: "\u{1F09}",
        nfd: "\u{0391}\u{0314}",
        nfkc: "\u{1F09}",
        nfkd: "\u{0391}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F0A}",
        nfc: "\u{1F0A}",
        nfd: "\u{0391}\u{0313}\u{0300}",
        nfkc: "\u{1F0A}",
        nfkd: "\u{0391}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F0B}",
        nfc: "\u{1F0B}",
        nfd: "\u{0391}\u{0314}\u{0300}",
        nfkc: "\u{1F0B}",
        nfkd: "\u{0391}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F0C}",
        nfc: "\u{1F0C}",
        nfd: "\u{0391}\u{0313}\u{0301}",
        nfkc: "\u{1F0C}",
        nfkd: "\u{0391}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F0D}",
        nfc: "\u{1F0D}",
        nfd: "\u{0391}\u{0314}\u{0301}",
        nfkc: "\u{1F0D}",
        nfkd: "\u{0391}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F0E}",
        nfc: "\u{1F0E}",
        nfd: "\u{0391}\u{0313}\u{0342}",
        nfkc: "\u{1F0E}",
        nfkd: "\u{0391}\u{0313}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F0F}",
        nfc: "\u{1F0F}",
        nfd: "\u{0391}\u{0314}\u{0342}",
        nfkc: "\u{1F0F}",
        nfkd: "\u{0391}\u{0314}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F10}",
        nfc: "\u{1F10}",
        nfd: "\u{03B5}\u{0313}",
        nfkc: "\u{1F10}",
        nfkd: "\u{03B5}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F11}",
        nfc: "\u{1F11}",
        nfd: "\u{03B5}\u{0314}",
        nfkc: "\u{1F11}",
        nfkd: "\u{03B5}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F12}",
        nfc: "\u{1F12}",
        nfd: "\u{03B5}\u{0313}\u{0300}",
        nfkc: "\u{1F12}",
        nfkd: "\u{03B5}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F13}",
        nfc: "\u{1F13}",
        nfd: "\u{03B5}\u{0314}\u{0300}",
        nfkc: "\u{1F13}",
        nfkd: "\u{03B5}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F14}",
        nfc: "\u{1F14}",
        nfd: "\u{03B5}\u{0313}\u{0301}",
        nfkc: "\u{1F14}",
        nfkd: "\u{03B5}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F15}",
        nfc: "\u{1F15}",
        nfd: "\u{03B5}\u{0314}\u{0301}",
        nfkc: "\u{1F15}",
        nfkd: "\u{03B5}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F18}",
        nfc: "\u{1F18}",
        nfd: "\u{0395}\u{0313}",
        nfkc: "\u{1F18}",
        nfkd: "\u{0395}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F19}",
        nfc: "\u{1F19}",
        nfd: "\u{0395}\u{0314}",
        nfkc: "\u{1F19}",
        nfkd: "\u{0395}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F1A}",
        nfc: "\u{1F1A}",
        nfd: "\u{0395}\u{0313}\u{0300}",
        nfkc: "\u{1F1A}",
        nfkd: "\u{0395}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F1B}",
        nfc: "\u{1F1B}",
        nfd: "\u{0395}\u{0314}\u{0300}",
        nfkc: "\u{1F1B}",
        nfkd: "\u{0395}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F1C}",
        nfc: "\u{1F1C}",
        nfd: "\u{0395}\u{0313}\u{0301}",
        nfkc: "\u{1F1C}",
        nfkd: "\u{0395}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F1D}",
        nfc: "\u{1F1D}",
        nfd: "\u{0395}\u{0314}\u{0301}",
        nfkc: "\u{1F1D}",
        nfkd: "\u{0395}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F20}",
        nfc: "\u{1F20}",
        nfd: "\u{03B7}\u{0313}",
        nfkc: "\u{1F20}",
        nfkd: "\u{03B7}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F21}",
        nfc: "\u{1F21}",
        nfd: "\u{03B7}\u{0314}",
        nfkc: "\u{1F21}",
        nfkd: "\u{03B7}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F22}",
        nfc: "\u{1F22}",
        nfd: "\u{03B7}\u{0313}\u{0300}",
        nfkc: "\u{1F22}",
        nfkd: "\u{03B7}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F23}",
        nfc: "\u{1F23}",
        nfd: "\u{03B7}\u{0314}\u{0300}",
        nfkc: "\u{1F23}",
        nfkd: "\u{03B7}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F24}",
        nfc: "\u{1F24}",
        nfd: "\u{03B7}\u{0313}\u{0301}",
        nfkc: "\u{1F24}",
        nfkd: "\u{03B7}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F25}",
        nfc: "\u{1F25}",
        nfd: "\u{03B7}\u{0314}\u{0301}",
        nfkc: "\u{1F25}",
        nfkd: "\u{03B7}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F26}",
        nfc: "\u{1F26}",
        nfd: "\u{03B7}\u{0313}\u{0342}",
        nfkc: "\u{1F26}",
        nfkd: "\u{03B7}\u{0313}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F27}",
        nfc: "\u{1F27}",
        nfd: "\u{03B7}\u{0314}\u{0342}",
        nfkc: "\u{1F27}",
        nfkd: "\u{03B7}\u{0314}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F28}",
        nfc: "\u{1F28}",
        nfd: "\u{0397}\u{0313}",
        nfkc: "\u{1F28}",
        nfkd: "\u{0397}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F29}",
        nfc: "\u{1F29}",
        nfd: "\u{0397}\u{0314}",
        nfkc: "\u{1F29}",
        nfkd: "\u{0397}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F2A}",
        nfc: "\u{1F2A}",
        nfd: "\u{0397}\u{0313}\u{0300}",
        nfkc: "\u{1F2A}",
        nfkd: "\u{0397}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F2B}",
        nfc: "\u{1F2B}",
        nfd: "\u{0397}\u{0314}\u{0300}",
        nfkc: "\u{1F2B}",
        nfkd: "\u{0397}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F2C}",
        nfc: "\u{1F2C}",
        nfd: "\u{0397}\u{0313}\u{0301}",
        nfkc: "\u{1F2C}",
        nfkd: "\u{0397}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F2D}",
        nfc: "\u{1F2D}",
        nfd: "\u{0397}\u{0314}\u{0301}",
        nfkc: "\u{1F2D}",
        nfkd: "\u{0397}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F2E}",
        nfc: "\u{1F2E}",
        nfd: "\u{0397}\u{0313}\u{0342}",
        nfkc: "\u{1F2E}",
        nfkd: "\u{0397}\u{0313}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F2F}",
        nfc: "\u{1F2F}",
        nfd: "\u{0397}\u{0314}\u{0342}",
        nfkc: "\u{1F2F}",
        nfkd: "\u{0397}\u{0314}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F30}",
        nfc: "\u{1F30}",
        nfd: "\u{03B9}\u{0313}",
        nfkc: "\u{1F30}",
        nfkd: "\u{03B9}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F31}",
        nfc: "\u{1F31}",
        nfd: "\u{03B9}\u{0314}",
        nfkc: "\u{1F31}",
        nfkd: "\u{03B9}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F32}",
        nfc: "\u{1F32}",
        nfd: "\u{03B9}\u{0313}\u{0300}",
        nfkc: "\u{1F32}",
        nfkd: "\u{03B9}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F33}",
        nfc: "\u{1F33}",
        nfd: "\u{03B9}\u{0314}\u{0300}",
        nfkc: "\u{1F33}",
        nfkd: "\u{03B9}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F34}",
        nfc: "\u{1F34}",
        nfd: "\u{03B9}\u{0313}\u{0301}",
        nfkc: "\u{1F34}",
        nfkd: "\u{03B9}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F35}",
        nfc: "\u{1F35}",
        nfd: "\u{03B9}\u{0314}\u{0301}",
        nfkc: "\u{1F35}",
        nfkd: "\u{03B9}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F36}",
        nfc: "\u{1F36}",
        nfd: "\u{03B9}\u{0313}\u{0342}",
        nfkc: "\u{1F36}",
        nfkd: "\u{03B9}\u{0313}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F37}",
        nfc: "\u{1F37}",
        nfd: "\u{03B9}\u{0314}\u{0342}",
        nfkc: "\u{1F37}",
        nfkd: "\u{03B9}\u{0314}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F38}",
        nfc: "\u{1F38}",
        nfd: "\u{0399}\u{0313}",
        nfkc: "\u{1F38}",
        nfkd: "\u{0399}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F39}",
        nfc: "\u{1F39}",
        nfd: "\u{0399}\u{0314}",
        nfkc: "\u{1F39}",
        nfkd: "\u{0399}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F3A}",
        nfc: "\u{1F3A}",
        nfd: "\u{0399}\u{0313}\u{0300}",
        nfkc: "\u{1F3A}",
        nfkd: "\u{0399}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F3B}",
        nfc: "\u{1F3B}",
        nfd: "\u{0399}\u{0314}\u{0300}",
        nfkc: "\u{1F3B}",
        nfkd: "\u{0399}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F3C}",
        nfc: "\u{1F3C}",
        nfd: "\u{0399}\u{0313}\u{0301}",
        nfkc: "\u{1F3C}",
        nfkd: "\u{0399}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F3D}",
        nfc: "\u{1F3D}",
        nfd: "\u{0399}\u{0314}\u{0301}",
        nfkc: "\u{1F3D}",
        nfkd: "\u{0399}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F3E}",
        nfc: "\u{1F3E}",
        nfd: "\u{0399}\u{0313}\u{0342}",
        nfkc: "\u{1F3E}",
        nfkd: "\u{0399}\u{0313}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F3F}",
        nfc: "\u{1F3F}",
        nfd: "\u{0399}\u{0314}\u{0342}",
        nfkc: "\u{1F3F}",
        nfkd: "\u{0399}\u{0314}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F40}",
        nfc: "\u{1F40}",
        nfd: "\u{03BF}\u{0313}",
        nfkc: "\u{1F40}",
        nfkd: "\u{03BF}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F41}",
        nfc: "\u{1F41}",
        nfd: "\u{03BF}\u{0314}",
        nfkc: "\u{1F41}",
        nfkd: "\u{03BF}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F42}",
        nfc: "\u{1F42}",
        nfd: "\u{03BF}\u{0313}\u{0300}",
        nfkc: "\u{1F42}",
        nfkd: "\u{03BF}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F43}",
        nfc: "\u{1F43}",
        nfd: "\u{03BF}\u{0314}\u{0300}",
        nfkc: "\u{1F43}",
        nfkd: "\u{03BF}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F44}",
        nfc: "\u{1F44}",
        nfd: "\u{03BF}\u{0313}\u{0301}",
        nfkc: "\u{1F44}",
        nfkd: "\u{03BF}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F45}",
        nfc: "\u{1F45}",
        nfd: "\u{03BF}\u{0314}\u{0301}",
        nfkc: "\u{1F45}",
        nfkd: "\u{03BF}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F48}",
        nfc: "\u{1F48}",
        nfd: "\u{039F}\u{0313}",
        nfkc: "\u{1F48}",
        nfkd: "\u{039F}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F49}",
        nfc: "\u{1F49}",
        nfd: "\u{039F}\u{0314}",
        nfkc: "\u{1F49}",
        nfkd: "\u{039F}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F4A}",
        nfc: "\u{1F4A}",
        nfd: "\u{039F}\u{0313}\u{0300}",
        nfkc: "\u{1F4A}",
        nfkd: "\u{039F}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F4B}",
        nfc: "\u{1F4B}",
        nfd: "\u{039F}\u{0314}\u{0300}",
        nfkc: "\u{1F4B}",
        nfkd: "\u{039F}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F4C}",
        nfc: "\u{1F4C}",
        nfd: "\u{039F}\u{0313}\u{0301}",
        nfkc: "\u{1F4C}",
        nfkd: "\u{039F}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F4D}",
        nfc: "\u{1F4D}",
        nfd: "\u{039F}\u{0314}\u{0301}",
        nfkc: "\u{1F4D}",
        nfkd: "\u{039F}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F50}",
        nfc: "\u{1F50}",
        nfd: "\u{03C5}\u{0313}",
        nfkc: "\u{1F50}",
        nfkd: "\u{03C5}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F51}",
        nfc: "\u{1F51}",
        nfd: "\u{03C5}\u{0314}",
        nfkc: "\u{1F51}",
        nfkd: "\u{03C5}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F52}",
        nfc: "\u{1F52}",
        nfd: "\u{03C5}\u{0313}\u{0300}",
        nfkc: "\u{1F52}",
        nfkd: "\u{03C5}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F53}",
        nfc: "\u{1F53}",
        nfd: "\u{03C5}\u{0314}\u{0300}",
        nfkc: "\u{1F53}",
        nfkd: "\u{03C5}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F54}",
        nfc: "\u{1F54}",
        nfd: "\u{03C5}\u{0313}\u{0301}",
        nfkc: "\u{1F54}",
        nfkd: "\u{03C5}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F55}",
        nfc: "\u{1F55}",
        nfd: "\u{03C5}\u{0314}\u{0301}",
        nfkc: "\u{1F55}",
        nfkd: "\u{03C5}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F56}",
        nfc: "\u{1F56}",
        nfd: "\u{03C5}\u{0313}\u{0342}",
        nfkc: "\u{1F56}",
        nfkd: "\u{03C5}\u{0313}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F57}",
        nfc: "\u{1F57}",
        nfd: "\u{03C5}\u{0314}\u{0342}",
        nfkc: "\u{1F57}",
        nfkd: "\u{03C5}\u{0314}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F59}",
        nfc: "\u{1F59}",
        nfd: "\u{03A5}\u{0314}",
        nfkc: "\u{1F59}",
        nfkd: "\u{03A5}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F5B}",
        nfc: "\u{1F5B}",
        nfd: "\u{03A5}\u{0314}\u{0300}",
        nfkc: "\u{1F5B}",
        nfkd: "\u{03A5}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F5D}",
        nfc: "\u{1F5D}",
        nfd: "\u{03A5}\u{0314}\u{0301}",
        nfkc: "\u{1F5D}",
        nfkd: "\u{03A5}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F5F}",
        nfc: "\u{1F5F}",
        nfd: "\u{03A5}\u{0314}\u{0342}",
        nfkc: "\u{1F5F}",
        nfkd: "\u{03A5}\u{0314}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F60}",
        nfc: "\u{1F60}",
        nfd: "\u{03C9}\u{0313}",
        nfkc: "\u{1F60}",
        nfkd: "\u{03C9}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F61}",
        nfc: "\u{1F61}",
        nfd: "\u{03C9}\u{0314}",
        nfkc: "\u{1F61}",
        nfkd: "\u{03C9}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F62}",
        nfc: "\u{1F62}",
        nfd: "\u{03C9}\u{0313}\u{0300}",
        nfkc: "\u{1F62}",
        nfkd: "\u{03C9}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F63}",
        nfc: "\u{1F63}",
        nfd: "\u{03C9}\u{0314}\u{0300}",
        nfkc: "\u{1F63}",
        nfkd: "\u{03C9}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F64}",
        nfc: "\u{1F64}",
        nfd: "\u{03C9}\u{0313}\u{0301}",
        nfkc: "\u{1F64}",
        nfkd: "\u{03C9}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F65}",
        nfc: "\u{1F65}",
        nfd: "\u{03C9}\u{0314}\u{0301}",
        nfkc: "\u{1F65}",
        nfkd: "\u{03C9}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F66}",
        nfc: "\u{1F66}",
        nfd: "\u{03C9}\u{0313}\u{0342}",
        nfkc: "\u{1F66}",
        nfkd: "\u{03C9}\u{0313}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F67}",
        nfc: "\u{1F67}",
        nfd: "\u{03C9}\u{0314}\u{0342}",
        nfkc: "\u{1F67}",
        nfkd: "\u{03C9}\u{0314}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F68}",
        nfc: "\u{1F68}",
        nfd: "\u{03A9}\u{0313}",
        nfkc: "\u{1F68}",
        nfkd: "\u{03A9}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1F69}",
        nfc: "\u{1F69}",
        nfd: "\u{03A9}\u{0314}",
        nfkc: "\u{1F69}",
        nfkd: "\u{03A9}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1F6A}",
        nfc: "\u{1F6A}",
        nfd: "\u{03A9}\u{0313}\u{0300}",
        nfkc: "\u{1F6A}",
        nfkd: "\u{03A9}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F6B}",
        nfc: "\u{1F6B}",
        nfd: "\u{03A9}\u{0314}\u{0300}",
        nfkc: "\u{1F6B}",
        nfkd: "\u{03A9}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F6C}",
        nfc: "\u{1F6C}",
        nfd: "\u{03A9}\u{0313}\u{0301}",
        nfkc: "\u{1F6C}",
        nfkd: "\u{03A9}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F6D}",
        nfc: "\u{1F6D}",
        nfd: "\u{03A9}\u{0314}\u{0301}",
        nfkc: "\u{1F6D}",
        nfkd: "\u{03A9}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F6E}",
        nfc: "\u{1F6E}",
        nfd: "\u{03A9}\u{0313}\u{0342}",
        nfkc: "\u{1F6E}",
        nfkd: "\u{03A9}\u{0313}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F6F}",
        nfc: "\u{1F6F}",
        nfd: "\u{03A9}\u{0314}\u{0342}",
        nfkc: "\u{1F6F}",
        nfkd: "\u{03A9}\u{0314}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1F70}",
        nfc: "\u{1F70}",
        nfd: "\u{03B1}\u{0300}",
        nfkc: "\u{1F70}",
        nfkd: "\u{03B1}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F71}",
        nfc: "\u{03AC}",
        nfd: "\u{03B1}\u{0301}",
        nfkc: "\u{03AC}",
        nfkd: "\u{03B1}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F72}",
        nfc: "\u{1F72}",
        nfd: "\u{03B5}\u{0300}",
        nfkc: "\u{1F72}",
        nfkd: "\u{03B5}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F73}",
        nfc: "\u{03AD}",
        nfd: "\u{03B5}\u{0301}",
        nfkc: "\u{03AD}",
        nfkd: "\u{03B5}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F74}",
        nfc: "\u{1F74}",
        nfd: "\u{03B7}\u{0300}",
        nfkc: "\u{1F74}",
        nfkd: "\u{03B7}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F75}",
        nfc: "\u{03AE}",
        nfd: "\u{03B7}\u{0301}",
        nfkc: "\u{03AE}",
        nfkd: "\u{03B7}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F76}",
        nfc: "\u{1F76}",
        nfd: "\u{03B9}\u{0300}",
        nfkc: "\u{1F76}",
        nfkd: "\u{03B9}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F77}",
        nfc: "\u{03AF}",
        nfd: "\u{03B9}\u{0301}",
        nfkc: "\u{03AF}",
        nfkd: "\u{03B9}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F78}",
        nfc: "\u{1F78}",
        nfd: "\u{03BF}\u{0300}",
        nfkc: "\u{1F78}",
        nfkd: "\u{03BF}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F79}",
        nfc: "\u{03CC}",
        nfd: "\u{03BF}\u{0301}",
        nfkc: "\u{03CC}",
        nfkd: "\u{03BF}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F7A}",
        nfc: "\u{1F7A}",
        nfd: "\u{03C5}\u{0300}",
        nfkc: "\u{1F7A}",
        nfkd: "\u{03C5}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F7B}",
        nfc: "\u{03CD}",
        nfd: "\u{03C5}\u{0301}",
        nfkc: "\u{03CD}",
        nfkd: "\u{03C5}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F7C}",
        nfc: "\u{1F7C}",
        nfd: "\u{03C9}\u{0300}",
        nfkc: "\u{1F7C}",
        nfkd: "\u{03C9}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1F7D}",
        nfc: "\u{03CE}",
        nfd: "\u{03C9}\u{0301}",
        nfkc: "\u{03CE}",
        nfkd: "\u{03C9}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1F80}",
        nfc: "\u{1F80}",
        nfd: "\u{03B1}\u{0313}\u{0345}",
        nfkc: "\u{1F80}",
        nfkd: "\u{03B1}\u{0313}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F81}",
        nfc: "\u{1F81}",
        nfd: "\u{03B1}\u{0314}\u{0345}",
        nfkc: "\u{1F81}",
        nfkd: "\u{03B1}\u{0314}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F82}",
        nfc: "\u{1F82}",
        nfd: "\u{03B1}\u{0313}\u{0300}\u{0345}",
        nfkc: "\u{1F82}",
        nfkd: "\u{03B1}\u{0313}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F83}",
        nfc: "\u{1F83}",
        nfd: "\u{03B1}\u{0314}\u{0300}\u{0345}",
        nfkc: "\u{1F83}",
        nfkd: "\u{03B1}\u{0314}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F84}",
        nfc: "\u{1F84}",
        nfd: "\u{03B1}\u{0313}\u{0301}\u{0345}",
        nfkc: "\u{1F84}",
        nfkd: "\u{03B1}\u{0313}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F85}",
        nfc: "\u{1F85}",
        nfd: "\u{03B1}\u{0314}\u{0301}\u{0345}",
        nfkc: "\u{1F85}",
        nfkd: "\u{03B1}\u{0314}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F86}",
        nfc: "\u{1F86}",
        nfd: "\u{03B1}\u{0313}\u{0342}\u{0345}",
        nfkc: "\u{1F86}",
        nfkd: "\u{03B1}\u{0313}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F87}",
        nfc: "\u{1F87}",
        nfd: "\u{03B1}\u{0314}\u{0342}\u{0345}",
        nfkc: "\u{1F87}",
        nfkd: "\u{03B1}\u{0314}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F88}",
        nfc: "\u{1F88}",
        nfd: "\u{0391}\u{0313}\u{0345}",
        nfkc: "\u{1F88}",
        nfkd: "\u{0391}\u{0313}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F89}",
        nfc: "\u{1F89}",
        nfd: "\u{0391}\u{0314}\u{0345}",
        nfkc: "\u{1F89}",
        nfkd: "\u{0391}\u{0314}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F8A}",
        nfc: "\u{1F8A}",
        nfd: "\u{0391}\u{0313}\u{0300}\u{0345}",
        nfkc: "\u{1F8A}",
        nfkd: "\u{0391}\u{0313}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F8B}",
        nfc: "\u{1F8B}",
        nfd: "\u{0391}\u{0314}\u{0300}\u{0345}",
        nfkc: "\u{1F8B}",
        nfkd: "\u{0391}\u{0314}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F8C}",
        nfc: "\u{1F8C}",
        nfd: "\u{0391}\u{0313}\u{0301}\u{0345}",
        nfkc: "\u{1F8C}",
        nfkd: "\u{0391}\u{0313}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F8D}",
        nfc: "\u{1F8D}",
        nfd: "\u{0391}\u{0314}\u{0301}\u{0345}",
        nfkc: "\u{1F8D}",
        nfkd: "\u{0391}\u{0314}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F8E}",
        nfc: "\u{1F8E}",
        nfd: "\u{0391}\u{0313}\u{0342}\u{0345}",
        nfkc: "\u{1F8E}",
        nfkd: "\u{0391}\u{0313}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F8F}",
        nfc: "\u{1F8F}",
        nfd: "\u{0391}\u{0314}\u{0342}\u{0345}",
        nfkc: "\u{1F8F}",
        nfkd: "\u{0391}\u{0314}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F90}",
        nfc: "\u{1F90}",
        nfd: "\u{03B7}\u{0313}\u{0345}",
        nfkc: "\u{1F90}",
        nfkd: "\u{03B7}\u{0313}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F91}",
        nfc: "\u{1F91}",
        nfd: "\u{03B7}\u{0314}\u{0345}",
        nfkc: "\u{1F91}",
        nfkd: "\u{03B7}\u{0314}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F92}",
        nfc: "\u{1F92}",
        nfd: "\u{03B7}\u{0313}\u{0300}\u{0345}",
        nfkc: "\u{1F92}",
        nfkd: "\u{03B7}\u{0313}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F93}",
        nfc: "\u{1F93}",
        nfd: "\u{03B7}\u{0314}\u{0300}\u{0345}",
        nfkc: "\u{1F93}",
        nfkd: "\u{03B7}\u{0314}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F94}",
        nfc: "\u{1F94}",
        nfd: "\u{03B7}\u{0313}\u{0301}\u{0345}",
        nfkc: "\u{1F94}",
        nfkd: "\u{03B7}\u{0313}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F95}",
        nfc: "\u{1F95}",
        nfd: "\u{03B7}\u{0314}\u{0301}\u{0345}",
        nfkc: "\u{1F95}",
        nfkd: "\u{03B7}\u{0314}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F96}",
        nfc: "\u{1F96}",
        nfd: "\u{03B7}\u{0313}\u{0342}\u{0345}",
        nfkc: "\u{1F96}",
        nfkd: "\u{03B7}\u{0313}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F97}",
        nfc: "\u{1F97}",
        nfd: "\u{03B7}\u{0314}\u{0342}\u{0345}",
        nfkc: "\u{1F97}",
        nfkd: "\u{03B7}\u{0314}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F98}",
        nfc: "\u{1F98}",
        nfd: "\u{0397}\u{0313}\u{0345}",
        nfkc: "\u{1F98}",
        nfkd: "\u{0397}\u{0313}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F99}",
        nfc: "\u{1F99}",
        nfd: "\u{0397}\u{0314}\u{0345}",
        nfkc: "\u{1F99}",
        nfkd: "\u{0397}\u{0314}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F9A}",
        nfc: "\u{1F9A}",
        nfd: "\u{0397}\u{0313}\u{0300}\u{0345}",
        nfkc: "\u{1F9A}",
        nfkd: "\u{0397}\u{0313}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F9B}",
        nfc: "\u{1F9B}",
        nfd: "\u{0397}\u{0314}\u{0300}\u{0345}",
        nfkc: "\u{1F9B}",
        nfkd: "\u{0397}\u{0314}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F9C}",
        nfc: "\u{1F9C}",
        nfd: "\u{0397}\u{0313}\u{0301}\u{0345}",
        nfkc: "\u{1F9C}",
        nfkd: "\u{0397}\u{0313}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F9D}",
        nfc: "\u{1F9D}",
        nfd: "\u{0397}\u{0314}\u{0301}\u{0345}",
        nfkc: "\u{1F9D}",
        nfkd: "\u{0397}\u{0314}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F9E}",
        nfc: "\u{1F9E}",
        nfd: "\u{0397}\u{0313}\u{0342}\u{0345}",
        nfkc: "\u{1F9E}",
        nfkd: "\u{0397}\u{0313}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1F9F}",
        nfc: "\u{1F9F}",
        nfd: "\u{0397}\u{0314}\u{0342}\u{0345}",
        nfkc: "\u{1F9F}",
        nfkd: "\u{0397}\u{0314}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FA0}",
        nfc: "\u{1FA0}",
        nfd: "\u{03C9}\u{0313}\u{0345}",
        nfkc: "\u{1FA0}",
        nfkd: "\u{03C9}\u{0313}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FA1}",
        nfc: "\u{1FA1}",
        nfd: "\u{03C9}\u{0314}\u{0345}",
        nfkc: "\u{1FA1}",
        nfkd: "\u{03C9}\u{0314}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FA2}",
        nfc: "\u{1FA2}",
        nfd: "\u{03C9}\u{0313}\u{0300}\u{0345}",
        nfkc: "\u{1FA2}",
        nfkd: "\u{03C9}\u{0313}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FA3}",
        nfc: "\u{1FA3}",
        nfd: "\u{03C9}\u{0314}\u{0300}\u{0345}",
        nfkc: "\u{1FA3}",
        nfkd: "\u{03C9}\u{0314}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FA4}",
        nfc: "\u{1FA4}",
        nfd: "\u{03C9}\u{0313}\u{0301}\u{0345}",
        nfkc: "\u{1FA4}",
        nfkd: "\u{03C9}\u{0313}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FA5}",
        nfc: "\u{1FA5}",
        nfd: "\u{03C9}\u{0314}\u{0301}\u{0345}",
        nfkc: "\u{1FA5}",
        nfkd: "\u{03C9}\u{0314}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FA6}",
        nfc: "\u{1FA6}",
        nfd: "\u{03C9}\u{0313}\u{0342}\u{0345}",
        nfkc: "\u{1FA6}",
        nfkd: "\u{03C9}\u{0313}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FA7}",
        nfc: "\u{1FA7}",
        nfd: "\u{03C9}\u{0314}\u{0342}\u{0345}",
        nfkc: "\u{1FA7}",
        nfkd: "\u{03C9}\u{0314}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FA8}",
        nfc: "\u{1FA8}",
        nfd: "\u{03A9}\u{0313}\u{0345}",
        nfkc: "\u{1FA8}",
        nfkd: "\u{03A9}\u{0313}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FA9}",
        nfc: "\u{1FA9}",
        nfd: "\u{03A9}\u{0314}\u{0345}",
        nfkc: "\u{1FA9}",
        nfkd: "\u{03A9}\u{0314}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FAA}",
        nfc: "\u{1FAA}",
        nfd: "\u{03A9}\u{0313}\u{0300}\u{0345}",
        nfkc: "\u{1FAA}",
        nfkd: "\u{03A9}\u{0313}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FAB}",
        nfc: "\u{1FAB}",
        nfd: "\u{03A9}\u{0314}\u{0300}\u{0345}",
        nfkc: "\u{1FAB}",
        nfkd: "\u{03A9}\u{0314}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FAC}",
        nfc: "\u{1FAC}",
        nfd: "\u{03A9}\u{0313}\u{0301}\u{0345}",
        nfkc: "\u{1FAC}",
        nfkd: "\u{03A9}\u{0313}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FAD}",
        nfc: "\u{1FAD}",
        nfd: "\u{03A9}\u{0314}\u{0301}\u{0345}",
        nfkc: "\u{1FAD}",
        nfkd: "\u{03A9}\u{0314}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FAE}",
        nfc: "\u{1FAE}",
        nfd: "\u{03A9}\u{0313}\u{0342}\u{0345}",
        nfkc: "\u{1FAE}",
        nfkd: "\u{03A9}\u{0313}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FAF}",
        nfc: "\u{1FAF}",
        nfd: "\u{03A9}\u{0314}\u{0342}\u{0345}",
        nfkc: "\u{1FAF}",
        nfkd: "\u{03A9}\u{0314}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FB0}",
        nfc: "\u{1FB0}",
        nfd: "\u{03B1}\u{0306}",
        nfkc: "\u{1FB0}",
        nfkd: "\u{03B1}\u{0306}",
    },
    NormalizationTest {
        source: "\u{1FB1}",
        nfc: "\u{1FB1}",
        nfd: "\u{03B1}\u{0304}",
        nfkc: "\u{1FB1}",
        nfkd: "\u{03B1}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1FB2}",
        nfc: "\u{1FB2}",
        nfd: "\u{03B1}\u{0300}\u{0345}",
        nfkc: "\u{1FB2}",
        nfkd: "\u{03B1}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FB3}",
        nfc: "\u{1FB3}",
        nfd: "\u{03B1}\u{0345}",
        nfkc: "\u{1FB3}",
        nfkd: "\u{03B1}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FB4}",
        nfc: "\u{1FB4}",
        nfd: "\u{03B1}\u{0301}\u{0345}",
        nfkc: "\u{1FB4}",
        nfkd: "\u{03B1}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FB6}",
        nfc: "\u{1FB6}",
        nfd: "\u{03B1}\u{0342}",
        nfkc: "\u{1FB6}",
        nfkd: "\u{03B1}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1FB7}",
        nfc: "\u{1FB7}",
        nfd: "\u{03B1}\u{0342}\u{0345}",
        nfkc: "\u{1FB7}",
        nfkd: "\u{03B1}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FB8}",
        nfc: "\u{1FB8}",
        nfd: "\u{0391}\u{0306}",
        nfkc: "\u{1FB8}",
        nfkd: "\u{0391}\u{0306}",
    },
    NormalizationTest {
        source: "\u{1FB9}",
        nfc: "\u{1FB9}",
        nfd: "\u{0391}\u{0304}",
        nfkc: "\u{1FB9}",
        nfkd: "\u{0391}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1FBA}",
        nfc: "\u{1FBA}",
        nfd: "\u{0391}\u{0300}",
        nfkc: "\u{1FBA}",
        nfkd: "\u{0391}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FBB}",
        nfc: "\u{0386}",
        nfd: "\u{0391}\u{0301}",
        nfkc: "\u{0386}",
        nfkd: "\u{0391}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FBC}",
        nfc: "\u{1FBC}",
        nfd: "\u{0391}\u{0345}",
        nfkc: "\u{1FBC}",
        nfkd: "\u{0391}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FBD}",
        nfc: "\u{1FBD}",
        nfd: "\u{1FBD}",
        nfkc: "\u{0020}\u{0313}",
        nfkd: "\u{0020}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1FBE}",
        nfc: "\u{03B9}",
        nfd: "\u{03B9}",
        nfkc: "\u{03B9}",
        nfkd: "\u{03B9}",
    },
    NormalizationTest {
        source: "\u{1FBF}",
        nfc: "\u{1FBF}",
        nfd: "\u{1FBF}",
        nfkc: "\u{0020}\u{0313}",
        nfkd: "\u{0020}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1FC0}",
        nfc: "\u{1FC0}",
        nfd: "\u{1FC0}",
        nfkc: "\u{0020}\u{0342}",
        nfkd: "\u{0020}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1FC1}",
        nfc: "\u{1FC1}",
        nfd: "\u{00A8}\u{0342}",
        nfkc: "\u{0020}\u{0308}\u{0342}",
        nfkd: "\u{0020}\u{0308}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1FC2}",
        nfc: "\u{1FC2}",
        nfd: "\u{03B7}\u{0300}\u{0345}",
        nfkc: "\u{1FC2}",
        nfkd: "\u{03B7}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FC3}",
        nfc: "\u{1FC3}",
        nfd: "\u{03B7}\u{0345}",
        nfkc: "\u{1FC3}",
        nfkd: "\u{03B7}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FC4}",
        nfc: "\u{1FC4}",
        nfd: "\u{03B7}\u{0301}\u{0345}",
        nfkc: "\u{1FC4}",
        nfkd: "\u{03B7}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FC6}",
        nfc: "\u{1FC6}",
        nfd: "\u{03B7}\u{0342}",
        nfkc: "\u{1FC6}",
        nfkd: "\u{03B7}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1FC7}",
        nfc: "\u{1FC7}",
        nfd: "\u{03B7}\u{0342}\u{0345}",
        nfkc: "\u{1FC7}",
        nfkd: "\u{03B7}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FC8}",
        nfc: "\u{1FC8}",
        nfd: "\u{0395}\u{0300}",
        nfkc: "\u{1FC8}",
        nfkd: "\u{0395}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FC9}",
        nfc: "\u{0388}",
        nfd: "\u{0395}\u{0301}",
        nfkc: "\u{0388}",
        nfkd: "\u{0395}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FCA}",
        nfc: "\u{1FCA}",
        nfd: "\u{0397}\u{0300}",
        nfkc: "\u{1FCA}",
        nfkd: "\u{0397}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FCB}",
        nfc: "\u{0389}",
        nfd: "\u{0397}\u{0301}",
        nfkc: "\u{0389}",
        nfkd: "\u{0397}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FCC}",
        nfc: "\u{1FCC}",
        nfd: "\u{0397}\u{0345}",
        nfkc: "\u{1FCC}",
        nfkd: "\u{0397}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FCD}",
        nfc: "\u{1FCD}",
        nfd: "\u{1FBF}\u{0300}",
        nfkc: "\u{0020}\u{0313}\u{0300}",
        nfkd: "\u{0020}\u{0313}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FCE}",
        nfc: "\u{1FCE}",
        nfd: "\u{1FBF}\u{0301}",
        nfkc: "\u{0020}\u{0313}\u{0301}",
        nfkd: "\u{0020}\u{0313}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FCF}",
        nfc: "\u{1FCF}",
        nfd: "\u{1FBF}\u{0342}",
        nfkc: "\u{0020}\u{0313}\u{0342}",
        nfkd: "\u{0020}\u{0313}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1FD0}",
        nfc: "\u{1FD0}",
        nfd: "\u{03B9}\u{0306}",
        nfkc: "\u{1FD0}",
        nfkd: "\u{03B9}\u{0306}",
    },
    NormalizationTest {
        source: "\u{1FD1}",
        nfc: "\u{1FD1}",
        nfd: "\u{03B9}\u{0304}",
        nfkc: "\u{1FD1}",
        nfkd: "\u{03B9}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1FD2}",
        nfc: "\u{1FD2}",
        nfd: "\u{03B9}\u{0308}\u{0300}",
        nfkc: "\u{1FD2}",
        nfkd: "\u{03B9}\u{0308}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FD3}",
        nfc: "\u{0390}",
        nfd: "\u{03B9}\u{0308}\u{0301}",
        nfkc: "\u{0390}",
        nfkd: "\u{03B9}\u{0308}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FD6}",
        nfc: "\u{1FD6}",
        nfd: "\u{03B9}\u{0342}",
        nfkc: "\u{1FD6}",
        nfkd: "\u{03B9}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1FD7}",
        nfc: "\u{1FD7}",
        nfd: "\u{03B9}\u{0308}\u{0342}",
        nfkc: "\u{1FD7}",
        nfkd: "\u{03B9}\u{0308}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1FD8}",
        nfc: "\u{1FD8}",
        nfd: "\u{0399}\u{0306}",
        nfkc: "\u{1FD8}",
        nfkd: "\u{0399}\u{0306}",
    },
    NormalizationTest {
        source: "\u{1FD9}",
        nfc: "\u{1FD9}",
        nfd: "\u{0399}\u{0304}",
        nfkc: "\u{1FD9}",
        nfkd: "\u{0399}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1FDA}",
        nfc: "\u{1FDA}",
        nfd: "\u{0399}\u{0300}",
        nfkc: "\u{1FDA}",
        nfkd: "\u{0399}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FDB}",
        nfc: "\u{038A}",
        nfd: "\u{0399}\u{0301}",
        nfkc: "\u{038A}",
        nfkd: "\u{0399}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FDD}",
        nfc: "\u{1FDD}",
        nfd: "\u{1FFE}\u{0300}",
        nfkc: "\u{0020}\u{0314}\u{0300}",
        nfkd: "\u{0020}\u{0314}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FDE}",
        nfc: "\u{1FDE}",
        nfd: "\u{1FFE}\u{0301}",
        nfkc: "\u{0020}\u{0314}\u{0301}",
        nfkd: "\u{0020}\u{0314}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FDF}",
        nfc: "\u{1FDF}",
        nfd: "\u{1FFE}\u{0342}",
        nfkc: "\u{0020}\u{0314}\u{0342}",
        nfkd: "\u{0020}\u{0314}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1FE0}",
        nfc: "\u{1FE0}",
        nfd: "\u{03C5}\u{0306}",
        nfkc: "\u{1FE0}",
        nfkd: "\u{03C5}\u{0306}",
    },
    NormalizationTest {
        source: "\u{1FE1}",
        nfc: "\u{1FE1}",
        nfd: "\u{03C5}\u{0304}",
        nfkc: "\u{1FE1}",
        nfkd: "\u{03C5}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1FE2}",
        nfc: "\u{1FE2}",
        nfd: "\u{03C5}\u{0308}\u{0300}",
        nfkc: "\u{1FE2}",
        nfkd: "\u{03C5}\u{0308}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FE3}",
        nfc: "\u{03B0}",
        nfd: "\u{03C5}\u{0308}\u{0301}",
        nfkc: "\u{03B0}",
        nfkd: "\u{03C5}\u{0308}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FE4}",
        nfc: "\u{1FE4}",
        nfd: "\u{03C1}\u{0313}",
        nfkc: "\u{1FE4}",
        nfkd: "\u{03C1}\u{0313}",
    },
    NormalizationTest {
        source: "\u{1FE5}",
        nfc: "\u{1FE5}",
        nfd: "\u{03C1}\u{0314}",
        nfkc: "\u{1FE5}",
        nfkd: "\u{03C1}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1FE6}",
        nfc: "\u{1FE6}",
        nfd: "\u{03C5}\u{0342}",
        nfkc: "\u{1FE6}",
        nfkd: "\u{03C5}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1FE7}",
        nfc: "\u{1FE7}",
        nfd: "\u{03C5}\u{0308}\u{0342}",
        nfkc: "\u{1FE7}",
        nfkd: "\u{03C5}\u{0308}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1FE8}",
        nfc: "\u{1FE8}",
        nfd: "\u{03A5}\u{0306}",
        nfkc: "\u{1FE8}",
        nfkd: "\u{03A5}\u{0306}",
    },
    NormalizationTest {
        source: "\u{1FE9}",
        nfc: "\u{1FE9}",
        nfd: "\u{03A5}\u{0304}",
        nfkc: "\u{1FE9}",
        nfkd: "\u{03A5}\u{0304}",
    },
    NormalizationTest {
        source: "\u{1FEA}",
        nfc: "\u{1FEA}",
        nfd: "\u{03A5}\u{0300}",
        nfkc: "\u{1FEA}",
        nfkd: "\u{03A5}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FEB}",
        nfc: "\u{038E}",
        nfd: "\u{03A5}\u{0301}",
        nfkc: "\u{038E}",
        nfkd: "\u{03A5}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FEC}",
        nfc: "\u{1FEC}",
        nfd: "\u{03A1}\u{0314}",
        nfkc: "\u{1FEC}",
        nfkd: "\u{03A1}\u{0314}",
    },
    NormalizationTest {
        source: "\u{1FED}",
        nfc: "\u{1FED}",
        nfd: "\u{00A8}\u{0300}",
        nfkc: "\u{0020}\u{0308}\u{0300}",
        nfkd: "\u{0020}\u{0308}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FEE}",
        nfc: "\u{0385}",
        nfd: "\u{00A8}\u{0301}",
        nfkc: "\u{0020}\u{0308}\u{0301}",
        nfkd: "\u{0020}\u{0308}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FEF}",
        nfc: "\u{0060}",
        nfd: "\u{0060}",
        nfkc: "\u{0060}",
        nfkd: "\u{0060}",
    },
    NormalizationTest {
        source: "\u{1FF2}",
        nfc: "\u{1FF2}",
        nfd: "\u{03C9}\u{0300}\u{0345}",
        nfkc: "\u{1FF2}",
        nfkd: "\u{03C9}\u{0300}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FF3}",
        nfc: "\u{1FF3}",
        nfd: "\u{03C9}\u{0345}",
        nfkc: "\u{1FF3}",
        nfkd: "\u{03C9}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FF4}",
        nfc: "\u{1FF4}",
        nfd: "\u{03C9}\u{0301}\u{0345}",
        nfkc: "\u{1FF4}",
        nfkd: "\u{03C9}\u{0301}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FF6}",
        nfc: "\u{1FF6}",
        nfd: "\u{03C9}\u{0342}",
        nfkc: "\u{1FF6}",
        nfkd: "\u{03C9}\u{0342}",
    },
    NormalizationTest {
        source: "\u{1FF7}",
        nfc: "\u{1FF7}",
        nfd: "\u{03C9}\u{0342}\u{0345}",
        nfkc: "\u{1FF7}",
        nfkd: "\u{03C9}\u{0342}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FF8}",
        nfc: "\u{1FF8}",
        nfd: "\u{039F}\u{0300}",
        nfkc: "\u{1FF8}",
        nfkd: "\u{039F}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FF9}",
        nfc: "\u{038C}",
        nfd: "\u{039F}\u{0301}",
        nfkc: "\u{038C}",
        nfkd: "\u{039F}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FFA}",
        nfc: "\u{1FFA}",
        nfd: "\u{03A9}\u{0300}",
        nfkc: "\u{1FFA}",
        nfkd: "\u{03A9}\u{0300}",
    },
    NormalizationTest {
        source: "\u{1FFB}",
        nfc: "\u{038F}",
        nfd: "\u{03A9}\u{0301}",
        nfkc: "\u{038F}",
        nfkd: "\u{03A9}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FFC}",
        nfc: "\u{1FFC}",
        nfd: "\u{03A9}\u{0345}",
        nfkc: "\u{1FFC}",
        nfkd: "\u{03A9}\u{0345}",
    },
    NormalizationTest {
        source: "\u{1FFD}",
        nfc: "\u{00B4}",
        nfd: "\u{00B4}",
        nfkc: "\u{0020}\u{0301}",
        nfkd: "\u{0020}\u{0301}",
    },
    NormalizationTest {
        source: "\u{1FFE}",
        nfc: "\u{1FFE}",
        nfd: "\u{1FFE}",
        nfkc: "\u{0020}\u{0314}",
        nfkd: "\u{0020}\u{0314}",
    },
    NormalizationTest {
        source: "\u{2000}",
        nfc: "\u{2002}",
        nfd: "\u{2002}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2001}",
        nfc: "\u{2003}",
        nfd: "\u{2003}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2002}",
        nfc: "\u{2002}",
        nfd: "\u{2002}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2003}",
        nfc: "\u{2003}",
        nfd: "\u{2003}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2004}",
        nfc: "\u{2004}",
        nfd: "\u{2004}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2005}",
        nfc: "\u{2005}",
        nfd: "\u{2005}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2006}",
        nfc: "\u{2006}",
        nfd: "\u{2006}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2007}",
        nfc: "\u{2007}",
        nfd: "\u{2007}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2008}",
        nfc: "\u{2008}",
        nfd: "\u{2008}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2009}",
        nfc: "\u{2009}",
        nfd: "\u{2009}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{200A}",
        nfc: "\u{200A}",
        nfd: "\u{200A}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2011}",
        nfc: "\u{2011}",
        nfd: "\u{2011}",
        nfkc: "\u{2010}",
        nfkd: "\u{2010}",
    },
    NormalizationTest {
        source: "\u{2017}",
        nfc: "\u{2017}",
        nfd: "\u{2017}",
        nfkc: "\u{0020}\u{0333}",
        nfkd: "\u{0020}\u{0333}",
    },
    NormalizationTest {
        source: "\u{2024}",
        nfc: "\u{2024}",
        nfd: "\u{2024}",
        nfkc: "\u{002E}",
        nfkd: "\u{002E}",
    },
    NormalizationTest {
        source: "\u{2025}",
        nfc: "\u{2025}",
        nfd: "\u{2025}",
        nfkc: "\u{002E}\u{002E}",
        nfkd: "\u{002E}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2026}",
        nfc: "\u{2026}",
        nfd: "\u{2026}",
        nfkc: "\u{002E}\u{002E}\u{002E}",
        nfkd: "\u{002E}\u{002E}\u{002E}",
    },
    NormalizationTest {
        source: "\u{202F}",
        nfc: "\u{202F}",
        nfd: "\u{202F}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2033}",
        nfc: "\u{2033}",
        nfd: "\u{2033}",
        nfkc: "\u{2032}\u{2032}",
        nfkd: "\u{2032}\u{2032}",
    },
    NormalizationTest {
        source: "\u{2034}",
        nfc: "\u{2034}",
        nfd: "\u{2034}",
        nfkc: "\u{2032}\u{2032}\u{2032}",
        nfkd: "\u{2032}\u{2032}\u{2032}",
    },
    NormalizationTest {
        source: "\u{2036}",
        nfc: "\u{2036}",
        nfd: "\u{2036}",
        nfkc: "\u{2035}\u{2035}",
        nfkd: "\u{2035}\u{2035}",
    },
    NormalizationTest {
        source: "\u{2037}",
        nfc: "\u{2037}",
        nfd: "\u{2037}",
        nfkc: "\u{2035}\u{2035}\u{2035}",
        nfkd: "\u{2035}\u{2035}\u{2035}",
    },
    NormalizationTest {
        source: "\u{203C}",
        nfc: "\u{203C}",
        nfd: "\u{203C}",
        nfkc: "\u{0021}\u{0021}",
        nfkd: "\u{0021}\u{0021}",
    },
    NormalizationTest {
        source: "\u{203E}",
        nfc: "\u{203E}",
        nfd: "\u{203E}",
        nfkc: "\u{0020}\u{0305}",
        nfkd: "\u{0020}\u{0305}",
    },
    NormalizationTest {
        source: "\u{2047}",
        nfc: "\u{2047}",
        nfd: "\u{2047}",
        nfkc: "\u{003F}\u{003F}",
        nfkd: "\u{003F}\u{003F}",
    },
    NormalizationTest {
        source: "\u{2048}",
        nfc: "\u{2048}",
        nfd: "\u{2048}",
        nfkc: "\u{003F}\u{0021}",
        nfkd: "\u{003F}\u{0021}",
    },
    NormalizationTest {
        source: "\u{2049}",
        nfc: "\u{2049}",
        nfd: "\u{2049}",
        nfkc: "\u{0021}\u{003F}",
        nfkd: "\u{0021}\u{003F}",
    },
    NormalizationTest {
        source: "\u{2057}",
        nfc: "\u{2057}",
        nfd: "\u{2057}",
        nfkc: "\u{2032}\u{2032}\u{2032}\u{2032}",
        nfkd: "\u{2032}\u{2032}\u{2032}\u{2032}",
    },
    NormalizationTest {
        source: "\u{205F}",
        nfc: "\u{205F}",
        nfd: "\u{205F}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{2070}",
        nfc: "\u{2070}",
        nfd: "\u{2070}",
        nfkc: "\u{0030}",
        nfkd: "\u{0030}",
    },
    NormalizationTest {
        source: "\u{2071}",
        nfc: "\u{2071}",
        nfd: "\u{2071}",
        nfkc: "\u{0069}",
        nfkd: "\u{0069}",
    },
    NormalizationTest {
        source: "\u{2074}",
        nfc: "\u{2074}",
        nfd: "\u{2074}",
        nfkc: "\u{0034}",
        nfkd: "\u{0034}",
    },
    NormalizationTest {
        source: "\u{2075}",
        nfc: "\u{2075}",
        nfd: "\u{2075}",
        nfkc: "\u{0035}",
        nfkd: "\u{0035}",
    },
    NormalizationTest {
        source: "\u{2076}",
        nfc: "\u{2076}",
        nfd: "\u{2076}",
        nfkc: "\u{0036}",
        nfkd: "\u{0036}",
    },
    NormalizationTest {
        source: "\u{2077}",
        nfc: "\u{2077}",
        nfd: "\u{2077}",
        nfkc: "\u{0037}",
        nfkd: "\u{0037}",
    },
    NormalizationTest {
        source: "\u{2078}",
        nfc: "\u{2078}",
        nfd: "\u{2078}",
        nfkc: "\u{0038}",
        nfkd: "\u{0038}",
    },
    NormalizationTest {
        source: "\u{2079}",
        nfc: "\u{2079}",
        nfd: "\u{2079}",
        nfkc: "\u{0039}",
        nfkd: "\u{0039}",
    },
    NormalizationTest {
        source: "\u{207A}",
        nfc: "\u{207A}",
        nfd: "\u{207A}",
        nfkc: "\u{002B}",
        nfkd: "\u{002B}",
    },
    NormalizationTest {
        source: "\u{207B}",
        nfc: "\u{207B}",
        nfd: "\u{207B}",
        nfkc: "\u{2212}",
        nfkd: "\u{2212}",
    },
    NormalizationTest {
        source: "\u{207C}",
        nfc: "\u{207C}",
        nfd: "\u{207C}",
        nfkc: "\u{003D}",
        nfkd: "\u{003D}",
    },
    NormalizationTest {
        source: "\u{207D}",
        nfc: "\u{207D}",
        nfd: "\u{207D}",
        nfkc: "\u{0028}",
        nfkd: "\u{0028}",
    },
    NormalizationTest {
        source: "\u{207E}",
        nfc: "\u{207E}",
        nfd: "\u{207E}",
        nfkc: "\u{0029}",
        nfkd: "\u{0029}",
    },
    NormalizationTest {
        source: "\u{207F}",
        nfc: "\u{207F}",
        nfd: "\u{207F}",
        nfkc: "\u{006E}",
        nfkd: "\u{006E}",
    },
    NormalizationTest {
        source: "\u{2080}",
        nfc: "\u{2080}",
        nfd: "\u{2080}",
        nfkc: "\u{0030}",
        nfkd: "\u{0030}",
    },
    NormalizationTest {
        source: "\u{2081}",
        nfc: "\u{2081}",
        nfd: "\u{2081}",
        nfkc: "\u{0031}",
        nfkd: "\u{0031}",
    },
    NormalizationTest {
        source: "\u{2082}",
        nfc: "\u{2082}",
        nfd: "\u{2082}",
        nfkc: "\u{0032}",
        nfkd: "\u{0032}",
    },
    NormalizationTest {
        source: "\u{2083}",
        nfc: "\u{2083}",
        nfd: "\u{2083}",
        nfkc: "\u{0033}",
        nfkd: "\u{0033}",
    },
    NormalizationTest {
        source: "\u{2084}",
        nfc: "\u{2084}",
        nfd: "\u{2084}",
        nfkc: "\u{0034}",
        nfkd: "\u{0034}",
    },
    NormalizationTest {
        source: "\u{2085}",
        nfc: "\u{2085}",
        nfd: "\u{2085}",
        nfkc: "\u{0035}",
        nfkd: "\u{0035}",
    },
    NormalizationTest {
        source: "\u{2086}",
        nfc: "\u{2086}",
        nfd: "\u{2086}",
        nfkc: "\u{0036}",
        nfkd: "\u{0036}",
    },
    NormalizationTest {
        source: "\u{2087}",
        nfc: "\u{2087}",
        nfd: "\u{2087}",
        nfkc: "\u{0037}",
        nfkd: "\u{0037}",
    },
    NormalizationTest {
        source: "\u{2088}",
        nfc: "\u{2088}",
        nfd: "\u{2088}",
        nfkc: "\u{0038}",
        nfkd: "\u{0038}",
    },
    NormalizationTest {
        source: "\u{2089}",
        nfc: "\u{2089}",
        nfd: "\u{2089}",
        nfkc: "\u{0039}",
        nfkd: "\u{0039}",
    },
    NormalizationTest {
        source: "\u{208A}",
        nfc: "\u{208A}",
        nfd: "\u{208A}",
        nfkc: "\u{002B}",
        nfkd: "\u{002B}",
    },
    NormalizationTest {
        source: "\u{208B}",
        nfc: "\u{208B}",
        nfd: "\u{208B}",
        nfkc: "\u{2212}",
        nfkd: "\u{2212}",
    },
    NormalizationTest {
        source: "\u{208C}",
        nfc: "\u{208C}",
        nfd: "\u{208C}",
        nfkc: "\u{003D}",
        nfkd: "\u{003D}",
    },
    NormalizationTest {
        source: "\u{208D}",
        nfc: "\u{208D}",
        nfd: "\u{208D}",
        nfkc: "\u{0028}",
        nfkd: "\u{0028}",
    },
    NormalizationTest {
        source: "\u{208E}",
        nfc: "\u{208E}",
        nfd: "\u{208E}",
        nfkc: "\u{0029}",
        nfkd: "\u{0029}",
    },
    NormalizationTest {
        source: "\u{2090}",
        nfc: "\u{2090}",
        nfd: "\u{2090}",
        nfkc: "\u{0061}",
        nfkd: "\u{0061}",
    },
    NormalizationTest {
        source: "\u{2091}",
        nfc: "\u{2091}",
        nfd: "\u{2091}",
        nfkc: "\u{0065}",
        nfkd: "\u{0065}",
    },
    NormalizationTest {
        source: "\u{2092}",
        nfc: "\u{2092}",
        nfd: "\u{2092}",
        nfkc: "\u{006F}",
        nfkd: "\u{006F}",
    },
    NormalizationTest {
        source: "\u{2093}",
        nfc: "\u{2093}",
        nfd: "\u{2093}",
        nfkc: "\u{0078}",
        nfkd: "\u{0078}",
    },
    NormalizationTest {
        source: "\u{2094}",
        nfc: "\u{2094}",
        nfd: "\u{2094}",
        nfkc: "\u{0259}",
        nfkd: "\u{0259}",
    },
    NormalizationTest {
        source: "\u{2095}",
        nfc: "\u{2095}",
        nfd: "\u{2095}",
        nfkc: "\u{0068}",
        nfkd: "\u{0068}",
    },
    NormalizationTest {
        source: "\u{2096}",
        nfc: "\u{2096}",
        nfd: "\u{2096}",
        nfkc: "\u{006B}",
        nfkd: "\u{006B}",
    },
    NormalizationTest {
        source: "\u{2097}",
        nfc: "\u{2097}",
        nfd: "\u{2097}",
        nfkc: "\u{006C}",
        nfkd: "\u{006C}",
    },
    NormalizationTest {
        source: "\u{2098}",
        nfc: "\u{2098}",
        nfd: "\u{2098}",
        nfkc: "\u{006D}",
        nfkd: "\u{006D}",
    },
    NormalizationTest {
        source: "\u{2099}",
        nfc: "\u{2099}",
        nfd: "\u{2099}",
        nfkc: "\u{006E}",
        nfkd: "\u{006E}",
    },
    NormalizationTest {
        source: "\u{209A}",
        nfc: "\u{209A}",
        nfd: "\u{209A}",
        nfkc: "\u{0070}",
        nfkd: "\u{0070}",
    },
    NormalizationTest {
        source: "\u{209B}",
        nfc: "\u{209B}",
        nfd: "\u{209B}",
        nfkc: "\u{0073}",
        nfkd: "\u{0073}",
    },
    NormalizationTest {
        source: "\u{209C}",
        nfc: "\u{209C}",
        nfd: "\u{209C}",
        nfkc: "\u{0074}",
        nfkd: "\u{0074}",
    },
    NormalizationTest {
        source: "\u{20A8}",
        nfc: "\u{20A8}",
        nfd: "\u{20A8}",
        nfkc: "\u{0052}\u{0073}",
        nfkd: "\u{0052}\u{0073}",
    },
    NormalizationTest {
        source: "\u{2100}",
        nfc: "\u{2100}",
        nfd: "\u{2100}",
        nfkc: "\u{0061}\u{002F}\u{0063}",
        nfkd: "\u{0061}\u{002F}\u{0063}",
    },
    NormalizationTest {
        source: "\u{2101}",
        nfc: "\u{2101}",
        nfd: "\u{2101}",
        nfkc: "\u{0061}\u{002F}\u{0073}",
        nfkd: "\u{0061}\u{002F}\u{0073}",
    },
    NormalizationTest {
        source: "\u{2102}",
        nfc: "\u{2102}",
        nfd: "\u{2102}",
        nfkc: "\u{0043}",
        nfkd: "\u{0043}",
    },
    NormalizationTest {
        source: "\u{2103}",
        nfc: "\u{2103}",
        nfd: "\u{2103}",
        nfkc: "\u{00B0}\u{0043}",
        nfkd: "\u{00B0}\u{0043}",
    },
    NormalizationTest {
        source: "\u{2105}",
        nfc: "\u{2105}",
        nfd: "\u{2105}",
        nfkc: "\u{0063}\u{002F}\u{006F}",
        nfkd: "\u{0063}\u{002F}\u{006F}",
    },
    NormalizationTest {
        source: "\u{2106}",
        nfc: "\u{2106}",
        nfd: "\u{2106}",
        nfkc: "\u{0063}\u{002F}\u{0075}",
        nfkd: "\u{0063}\u{002F}\u{0075}",
    },
    NormalizationTest {
        source: "\u{2107}",
        nfc: "\u{2107}",
        nfd: "\u{2107}",
        nfkc: "\u{0190}",
        nfkd: "\u{0190}",
    },
    NormalizationTest {
        source: "\u{2109}",
        nfc: "\u{2109}",
        nfd: "\u{2109}",
        nfkc: "\u{00B0}\u{0046}",
        nfkd: "\u{00B0}\u{0046}",
    },
    NormalizationTest {
        source: "\u{210A}",
        nfc: "\u{210A}",
        nfd: "\u{210A}",
        nfkc: "\u{0067}",
        nfkd: "\u{0067}",
    },
    NormalizationTest {
        source: "\u{210B}",
        nfc: "\u{210B}",
        nfd: "\u{210B}",
        nfkc: "\u{0048}",
        nfkd: "\u{0048}",
    },
    NormalizationTest {
        source: "\u{210C}",
        nfc: "\u{210C}",
        nfd: "\u{210C}",
        nfkc: "\u{0048}",
        nfkd: "\u{0048}",
    },
    NormalizationTest {
        source: "\u{210D}",
        nfc: "\u{210D}",
        nfd: "\u{210D}",
        nfkc: "\u{0048}",
        nfkd: "\u{0048}",
    },
    NormalizationTest {
        source: "\u{210E}",
        nfc: "\u{210E}",
        nfd: "\u{210E}",
        nfkc: "\u{0068}",
        nfkd: "\u{0068}",
    },
    NormalizationTest {
        source: "\u{210F}",
        nfc: "\u{210F}",
        nfd: "\u{210F}",
        nfkc: "\u{0127}",
        nfkd: "\u{0127}",
    },
    NormalizationTest {
        source: "\u{2110}",
        nfc: "\u{2110}",
        nfd: "\u{2110}",
        nfkc: "\u{0049}",
        nfkd: "\u{0049}",
    },
    NormalizationTest {
        source: "\u{2111}",
        nfc: "\u{2111}",
        nfd: "\u{2111}",
        nfkc: "\u{0049}",
        nfkd: "\u{0049}",
    },
    NormalizationTest {
        source: "\u{2112}",
        nfc: "\u{2112}",
        nfd: "\u{2112}",
        nfkc: "\u{004C}",
        nfkd: "\u{004C}",
    },
    NormalizationTest {
        source: "\u{2113}",
        nfc: "\u{2113}",
        nfd: "\u{2113}",
        nfkc: "\u{006C}",
        nfkd: "\u{006C}",
    },
    NormalizationTest {
        source: "\u{2115}",
        nfc: "\u{2115}",
        nfd: "\u{2115}",
        nfkc: "\u{004E}",
        nfkd: "\u{004E}",
    },
    NormalizationTest {
        source: "\u{2116}",
        nfc: "\u{2116}",
        nfd: "\u{2116}",
        nfkc: "\u{004E}\u{006F}",
        nfkd: "\u{004E}\u{006F}",
    },
    NormalizationTest {
        source: "\u{2119}",
        nfc: "\u{2119}",
        nfd: "\u{2119}",
        nfkc: "\u{0050}",
        nfkd: "\u{0050}",
    },
    NormalizationTest {
        source: "\u{211A}",
        nfc: "\u{211A}",
        nfd: "\u{211A}",
        nfkc: "\u{0051}",
        nfkd: "\u{0051}",
    },
    NormalizationTest {
        source: "\u{211B}",
        nfc: "\u{211B}",
        nfd: "\u{211B}",
        nfkc: "\u{0052}",
        nfkd: "\u{0052}",
    },
    NormalizationTest {
        source: "\u{211C}",
        nfc: "\u{211C}",
        nfd: "\u{211C}",
        nfkc: "\u{0052}",
        nfkd: "\u{0052}",
    },
    NormalizationTest {
        source: "\u{211D}",
        nfc: "\u{211D}",
        nfd: "\u{211D}",
        nfkc: "\u{0052}",
        nfkd: "\u{0052}",
    },
    NormalizationTest {
        source: "\u{2120}",
        nfc: "\u{2120}",
        nfd: "\u{2120}",
        nfkc: "\u{0053}\u{004D}",
        nfkd: "\u{0053}\u{004D}",
    },
    NormalizationTest {
        source: "\u{2121}",
        nfc: "\u{2121}",
        nfd: "\u{2121}",
        nfkc: "\u{0054}\u{0045}\u{004C}",
        nfkd: "\u{0054}\u{0045}\u{004C}",
    },
    NormalizationTest {
        source: "\u{2122}",
        nfc: "\u{2122}",
        nfd: "\u{2122}",
        nfkc: "\u{0054}\u{004D}",
        nfkd: "\u{0054}\u{004D}",
    },
    NormalizationTest {
        source: "\u{2124}",
        nfc: "\u{2124}",
        nfd: "\u{2124}",
        nfkc: "\u{005A}",
        nfkd: "\u{005A}",
    },
    NormalizationTest {
        source: "\u{2126}",
        nfc: "\u{03A9}",
        nfd: "\u{03A9}",
        nfkc: "\u{03A9}",
        nfkd: "\u{03A9}",
    },
    NormalizationTest {
        source: "\u{2128}",
        nfc: "\u{2128}",
        nfd: "\u{2128}",
        nfkc: "\u{005A}",
        nfkd: "\u{005A}",
    },
    NormalizationTest {
        source: "\u{212A}",
        nfc: "\u{004B}",
        nfd: "\u{004B}",
        nfkc: "\u{004B}",
        nfkd: "\u{004B}",
    },
    NormalizationTest {
        source: "\u{212B}",
        nfc: "\u{00C5}",
        nfd: "\u{0041}\u{030A}",
        nfkc: "\u{00C5}",
        nfkd: "\u{0041}\u{030A}",
    },
    NormalizationTest {
        source: "\u{212C}",
        nfc: "\u{212C}",
        nfd: "\u{212C}",
        nfkc: "\u{0042}",
        nfkd: "\u{0042}",
    },
    NormalizationTest {
        source: "\u{212D}",
        nfc: "\u{212D}",
        nfd: "\u{212D}",
        nfkc: "\u{0043}",
        nfkd: "\u{0043}",
    },
    NormalizationTest {
        source: "\u{212F}",
        nfc: "\u{212F}",
        nfd: "\u{212F}",
        nfkc: "\u{0065}",
        nfkd: "\u{0065}",
    },
    NormalizationTest {
        source: "\u{2130}",
        nfc: "\u{2130}",
        nfd: "\u{2130}",
        nfkc: "\u{0045}",
        nfkd: "\u{0045}",
    },
    NormalizationTest {
        source: "\u{2131}",
        nfc: "\u{2131}",
        nfd: "\u{2131}",
        nfkc: "\u{0046}",
        nfkd: "\u{0046}",
    },
    NormalizationTest {
        source: "\u{2133}",
        nfc: "\u{2133}",
        nfd: "\u{2133}",
        nfkc: "\u{004D}",
        nfkd: "\u{004D}",
    },
    NormalizationTest {
        source: "\u{2134}",
        nfc: "\u{2134}",
        nfd: "\u{2134}",
        nfkc: "\u{006F}",
        nfkd: "\u{006F}",
    },
    NormalizationTest {
        source: "\u{2135}",
        nfc: "\u{2135}",
        nfd: "\u{2135}",
        nfkc: "\u{05D0}",
        nfkd: "\u{05D0}",
    },
    NormalizationTest {
        source: "\u{2136}",
        nfc: "\u{2136}",
        nfd: "\u{2136}",
        nfkc: "\u{05D1}",
        nfkd: "\u{05D1}",
    },
    NormalizationTest {
        source: "\u{2137}",
        nfc: "\u{2137}",
        nfd: "\u{2137}",
        nfkc: "\u{05D2}",
        nfkd: "\u{05D2}",
    },
    NormalizationTest {
        source: "\u{2138}",
        nfc: "\u{2138}",
        nfd: "\u{2138}",
        nfkc: "\u{05D3}",
        nfkd: "\u{05D3}",
    },
    NormalizationTest {
        source: "\u{2139}",
        nfc: "\u{2139}",
        nfd: "\u{2139}",
        nfkc: "\u{0069}",
        nfkd: "\u{0069}",
    },
    NormalizationTest {
        source: "\u{213B}",
        nfc: "\u{213B}",
        nfd: "\u{213B}",
        nfkc: "\u{0046}\u{0041}\u{0058}",
        nfkd: "\u{0046}\u{0041}\u{0058}",
    },
    NormalizationTest {
        source: "\u{213C}",
        nfc: "\u{213C}",
        nfd: "\u{213C}",
        nfkc: "\u{03C0}",
        nfkd: "\u{03C0}",
    },
    NormalizationTest {
        source: "\u{213D}",
        nfc: "\u{213D}",
        nfd: "\u{213D}",
        nfkc: "\u{03B3}",
        nfkd: "\u{03B3}",
    },
    NormalizationTest {
        source: "\u{213E}",
        nfc: "\u{213E}",
        nfd: "\u{213E}",
        nfkc: "\u{0393}",
        nfkd: "\u{0393}",
    },
    NormalizationTest {
        source: "\u{213F}",
        nfc: "\u{213F}",
        nfd: "\u{213F}",
        nfkc: "\u{03A0}",
        nfkd: "\u{03A0}",
    },
    NormalizationTest {
        source: "\u{2140}",
        nfc: "\u{2140}",
        nfd: "\u{2140}",
        nfkc: "\u{2211}",
        nfkd: "\u{2211}",
    },
    NormalizationTest {
        source: "\u{2145}",
        nfc: "\u{2145}",
        nfd: "\u{2145}",
        nfkc: "\u{0044}",
        nfkd: "\u{0044}",
    },
    NormalizationTest {
        source: "\u{2146}",
        nfc: "\u{2146}",
        nfd: "\u{2146}",
        nfkc: "\u{0064}",
        nfkd: "\u{0064}",
    },
    NormalizationTest {
        source: "\u{2147}",
        nfc: "\u{2147}",
        nfd: "\u{2147}",
        nfkc: "\u{0065}",
        nfkd: "\u{0065}",
    },
    NormalizationTest {
        source: "\u{2148}",
        nfc: "\u{2148}",
        nfd: "\u{2148}",
        nfkc: "\u{0069}",
        nfkd: "\u{0069}",
    },
    NormalizationTest {
        source: "\u{2149}",
        nfc: "\u{2149}",
        nfd: "\u{2149}",
        nfkc: "\u{006A}",
        nfkd: "\u{006A}",
    },
    NormalizationTest {
        source: "\u{2150}",
        nfc: "\u{2150}",
        nfd: "\u{2150}",
        nfkc: "\u{0031}\u{2044}\u{0037}",
        nfkd: "\u{0031}\u{2044}\u{0037}",
    },
    NormalizationTest {
        source: "\u{2151}",
        nfc: "\u{2151}",
        nfd: "\u{2151}",
        nfkc: "\u{0031}\u{2044}\u{0039}",
        nfkd: "\u{0031}\u{2044}\u{0039}",
    },
    NormalizationTest {
        source: "\u{2152}",
        nfc: "\u{2152}",
        nfd: "\u{2152}",
        nfkc: "\u{0031}\u{2044}\u{0031}\u{0030}",
        nfkd: "\u{0031}\u{2044}\u{0031}\u{0030}",
    },
    NormalizationTest {
        source: "\u{2153}",
        nfc: "\u{2153}",
        nfd: "\u{2153}",
        nfkc: "\u{0031}\u{2044}\u{0033}",
        nfkd: "\u{0031}\u{2044}\u{0033}",
    },
    NormalizationTest {
        source: "\u{2154}",
        nfc: "\u{2154}",
        nfd: "\u{2154}",
        nfkc: "\u{0032}\u{2044}\u{0033}",
        nfkd: "\u{0032}\u{2044}\u{0033}",
    },
    NormalizationTest {
        source: "\u{2155}",
        nfc: "\u{2155}",
        nfd: "\u{2155}",
        nfkc: "\u{0031}\u{2044}\u{0035}",
        nfkd: "\u{0031}\u{2044}\u{0035}",
    },
    NormalizationTest {
        source: "\u{2156}",
        nfc: "\u{2156}",
        nfd: "\u{2156}",
        nfkc: "\u{0032}\u{2044}\u{0035}",
        nfkd: "\u{0032}\u{2044}\u{0035}",
    },
    NormalizationTest {
        source: "\u{2157}",
        nfc: "\u{2157}",
        nfd: "\u{2157}",
        nfkc: "\u{0033}\u{2044}\u{0035}",
        nfkd: "\u{0033}\u{2044}\u{0035}",
    },
    NormalizationTest {
        source: "\u{2158}",
        nfc: "\u{2158}",
        nfd: "\u{2158}",
        nfkc: "\u{0034}\u{2044}\u{0035}",
        nfkd: "\u{0034}\u{2044}\u{0035}",
    },
    NormalizationTest {
        source: "\u{2159}",
        nfc: "\u{2159}",
        nfd: "\u{2159}",
        nfkc: "\u{0031}\u{2044}\u{0036}",
        nfkd: "\u{0031}\u{2044}\u{0036}",
    },
    NormalizationTest {
        source: "\u{215A}",
        nfc: "\u{215A}",
        nfd: "\u{215A}",
        nfkc: "\u{0035}\u{2044}\u{0036}",
        nfkd: "\u{0035}\u{2044}\u{0036}",
    },
    NormalizationTest {
        source: "\u{215B}",
        nfc: "\u{215B}",
        nfd: "\u{215B}",
        nfkc: "\u{0031}\u{2044}\u{0038}",
        nfkd: "\u{0031}\u{2044}\u{0038}",
    },
    NormalizationTest {
        source: "\u{215C}",
        nfc: "\u{215C}",
        nfd: "\u{215C}",
        nfkc: "\u{0033}\u{2044}\u{0038}",
        nfkd: "\u{0033}\u{2044}\u{0038}",
    },
    NormalizationTest {
        source: "\u{215D}",
        nfc: "\u{215D}",
        nfd: "\u{215D}",
        nfkc: "\u{0035}\u{2044}\u{0038}",
        nfkd: "\u{0035}\u{2044}\u{0038}",
    },
    NormalizationTest {
        source: "\u{215E}",
        nfc: "\u{215E}",
        nfd: "\u{215E}",
        nfkc: "\u{0037}\u{2044}\u{0038}",
        nfkd: "\u{0037}\u{2044}\u{0038}",
    },
    NormalizationTest {
        source: "\u{215F}",
        nfc: "\u{215F}",
        nfd: "\u{215F}",
        nfkc: "\u{0031}\u{2044}",
        nfkd: "\u{0031}\u{2044}",
    },
    NormalizationTest {
        source: "\u{2160}",
        nfc: "\u{2160}",
        nfd: "\u{2160}",
        nfkc: "\u{0049}",
        nfkd: "\u{0049}",
    },
    NormalizationTest {
        source: "\u{2161}",
        nfc: "\u{2161}",
        nfd: "\u{2161}",
        nfkc: "\u{0049}\u{0049}",
        nfkd: "\u{0049}\u{0049}",
    },
    NormalizationTest {
        source: "\u{2162}",
        nfc: "\u{2162}",
        nfd: "\u{2162}",
        nfkc: "\u{0049}\u{0049}\u{0049}",
        nfkd: "\u{0049}\u{0049}\u{0049}",
    },
    NormalizationTest {
        source: "\u{2163}",
        nfc: "\u{2163}",
        nfd: "\u{2163}",
        nfkc: "\u{0049}\u{0056}",
        nfkd: "\u{0049}\u{0056}",
    },
    NormalizationTest {
        source: "\u{2164}",
        nfc: "\u{2164}",
        nfd: "\u{2164}",
        nfkc: "\u{0056}",
        nfkd: "\u{0056}",
    },
    NormalizationTest {
        source: "\u{2165}",
        nfc: "\u{2165}",
        nfd: "\u{2165}",
        nfkc: "\u{0056}\u{0049}",
        nfkd: "\u{0056}\u{0049}",
    },
    NormalizationTest {
        source: "\u{2166}",
        nfc: "\u{2166}",
        nfd: "\u{2166}",
        nfkc: "\u{0056}\u{0049}\u{0049}",
        nfkd: "\u{0056}\u{0049}\u{0049}",
    },
    NormalizationTest {
        source: "\u{2167}",
        nfc: "\u{2167}",
        nfd: "\u{2167}",
        nfkc: "\u{0056}\u{0049}\u{0049}\u{0049}",
        nfkd: "\u{0056}\u{0049}\u{0049}\u{0049}",
    },
    NormalizationTest {
        source: "\u{2168}",
        nfc: "\u{2168}",
        nfd: "\u{2168}",
        nfkc: "\u{0049}\u{0058}",
        nfkd: "\u{0049}\u{0058}",
    },
    NormalizationTest {
        source: "\u{2169}",
        nfc: "\u{2169}",
        nfd: "\u{2169}",
        nfkc: "\u{0058}",
        nfkd: "\u{0058}",
    },
    NormalizationTest {
        source: "\u{216A}",
        nfc: "\u{216A}",
        nfd: "\u{216A}",
        nfkc: "\u{0058}\u{0049}",
        nfkd: "\u{0058}\u{0049}",
    },
    NormalizationTest {
        source: "\u{216B}",
        nfc: "\u{216B}",
        nfd: "\u{216B}",
        nfkc: "\u{0058}\u{0049}\u{0049}",
        nfkd: "\u{0058}\u{0049}\u{0049}",
    },
    NormalizationTest {
        source: "\u{216C}",
        nfc: "\u{216C}",
        nfd: "\u{216C}",
        nfkc: "\u{004C}",
        nfkd: "\u{004C}",
    },
    NormalizationTest {
        source: "\u{216D}",
        nfc: "\u{216D}",
        nfd: "\u{216D}",
        nfkc: "\u{0043}",
        nfkd: "\u{0043}",
    },
    NormalizationTest {
        source: "\u{216E}",
        nfc: "\u{216E}",
        nfd: "\u{216E}",
        nfkc: "\u{0044}",
        nfkd: "\u{0044}",
    },
    NormalizationTest {
        source: "\u{216F}",
        nfc: "\u{216F}",
        nfd: "\u{216F}",
        nfkc: "\u{004D}",
        nfkd: "\u{004D}",
    },
    NormalizationTest {
        source: "\u{2170}",
        nfc: "\u{2170}",
        nfd: "\u{2170}",
        nfkc: "\u{0069}",
        nfkd: "\u{0069}",
    },
    NormalizationTest {
        source: "\u{2171}",
        nfc: "\u{2171}",
        nfd: "\u{2171}",
        nfkc: "\u{0069}\u{0069}",
        nfkd: "\u{0069}\u{0069}",
    },
    NormalizationTest {
        source: "\u{2172}",
        nfc: "\u{2172}",
        nfd: "\u{2172}",
        nfkc: "\u{0069}\u{0069}\u{0069}",
        nfkd: "\u{0069}\u{0069}\u{0069}",
    },
    NormalizationTest {
        source: "\u{2173}",
        nfc: "\u{2173}",
        nfd: "\u{2173}",
        nfkc: "\u{0069}\u{0076}",
        nfkd: "\u{0069}\u{0076}",
    },
    NormalizationTest {
        source: "\u{2174}",
        nfc: "\u{2174}",
        nfd: "\u{2174}",
        nfkc: "\u{0076}",
        nfkd: "\u{0076}",
    },
    NormalizationTest {
        source: "\u{2175}",
        nfc: "\u{2175}",
        nfd: "\u{2175}",
        nfkc: "\u{0076}\u{0069}",
        nfkd: "\u{0076}\u{0069}",
    },
    NormalizationTest {
        source: "\u{2176}",
        nfc: "\u{2176}",
        nfd: "\u{2176}",
        nfkc: "\u{0076}\u{0069}\u{0069}",
        nfkd: "\u{0076}\u{0069}\u{0069}",
    },
    NormalizationTest {
        source: "\u{2177}",
        nfc: "\u{2177}",
        nfd: "\u{2177}",
        nfkc: "\u{0076}\u{0069}\u{0069}\u{0069}",
        nfkd: "\u{0076}\u{0069}\u{0069}\u{0069}",
    },
    NormalizationTest {
        source: "\u{2178}",
        nfc: "\u{2178}",
        nfd: "\u{2178}",
        nfkc: "\u{0069}\u{0078}",
        nfkd: "\u{0069}\u{0078}",
    },
    NormalizationTest {
        source: "\u{2179}",
        nfc: "\u{2179}",
        nfd: "\u{2179}",
        nfkc: "\u{0078}",
        nfkd: "\u{0078}",
    },
    NormalizationTest {
        source: "\u{217A}",
        nfc: "\u{217A}",
        nfd: "\u{217A}",
        nfkc: "\u{0078}\u{0069}",
        nfkd: "\u{0078}\u{0069}",
    },
    NormalizationTest {
        source: "\u{217B}",
        nfc: "\u{217B}",
        nfd: "\u{217B}",
        nfkc: "\u{0078}\u{0069}\u{0069}",
        nfkd: "\u{0078}\u{0069}\u{0069}",
    },
    NormalizationTest {
        source: "\u{217C}",
        nfc: "\u{217C}",
        nfd: "\u{217C}",
        nfkc: "\u{006C}",
        nfkd: "\u{006C}",
    },
    NormalizationTest {
        source: "\u{217D}",
        nfc: "\u{217D}",
        nfd: "\u{217D}",
        nfkc: "\u{0063}",
        nfkd: "\u{0063}",
    },
    NormalizationTest {
        source: "\u{217E}",
        nfc: "\u{217E}",
        nfd: "\u{217E}",
        nfkc: "\u{0064}",
        nfkd: "\u{0064}",
    },
    NormalizationTest {
        source: "\u{217F}",
        nfc: "\u{217F}",
        nfd: "\u{217F}",
        nfkc: "\u{006D}",
        nfkd: "\u{006D}",
    },
    NormalizationTest {
        source: "\u{2189}",
        nfc: "\u{2189}",
        nfd: "\u{2189}",
        nfkc: "\u{0030}\u{2044}\u{0033}",
        nfkd: "\u{0030}\u{2044}\u{0033}",
    },
    NormalizationTest {
        source: "\u{219A}",
        nfc: "\u{219A}",
        nfd: "\u{2190}\u{0338}",
        nfkc: "\u{219A}",
        nfkd: "\u{2190}\u{0338}",
    },
    NormalizationTest {
        source: "\u{219B}",
        nfc: "\u{219B}",
        nfd: "\u{2192}\u{0338}",
        nfkc: "\u{219B}",
        nfkd: "\u{2192}\u{0338}",
    },
    NormalizationTest {
        source: "\u{21AE}",
        nfc: "\u{21AE}",
        nfd: "\u{2194}\u{0338}",
        nfkc: "\u{21AE}",
        nfkd: "\u{2194}\u{0338}",
    },
    NormalizationTest {
        source: "\u{21CD}",
        nfc: "\u{21CD}",
        nfd: "\u{21D0}\u{0338}",
        nfkc: "\u{21CD}",
        nfkd: "\u{21D0}\u{0338}",
    },
    NormalizationTest {
        source: "\u{21CE}",
        nfc: "\u{21CE}",
        nfd: "\u{21D4}\u{0338}",
        nfkc: "\u{21CE}",
        nfkd: "\u{21D4}\u{0338}",
    },
    NormalizationTest {
        source: "\u{21CF}",
        nfc: "\u{21CF}",
        nfd: "\u{21D2}\u{0338}",
        nfkc: "\u{21CF}",
        nfkd: "\u{21D2}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2204}",
        nfc: "\u{2204}",
        nfd: "\u{2203}\u{0338}",
        nfkc: "\u{2204}",
        nfkd: "\u{2203}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2209}",
        nfc: "\u{2209}",
        nfd: "\u{2208}\u{0338}",
        nfkc: "\u{2209}",
        nfkd: "\u{2208}\u{0338}",
    },
    NormalizationTest {
        source: "\u{220C}",
        nfc: "\u{220C}",
        nfd: "\u{220B}\u{0338}",
        nfkc: "\u{220C}",
        nfkd: "\u{220B}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2224}",
        nfc: "\u{2224}",
        nfd: "\u{2223}\u{0338}",
        nfkc: "\u{2224}",
        nfkd: "\u{2223}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2226}",
        nfc: "\u{2226}",
        nfd: "\u{2225}\u{0338}",
        nfkc: "\u{2226}",
        nfkd: "\u{2225}\u{0338}",
    },
    NormalizationTest {
        source: "\u{222C}",
        nfc: "\u{222C}",
        nfd: "\u{222C}",
        nfkc: "\u{222B}\u{222B}",
        nfkd: "\u{222B}\u{222B}",
    },
    NormalizationTest {
        source: "\u{222D}",
        nfc: "\u{222D}",
        nfd: "\u{222D}",
        nfkc: "\u{222B}\u{222B}\u{222B}",
        nfkd: "\u{222B}\u{222B}\u{222B}",
    },
    NormalizationTest {
        source: "\u{222F}",
        nfc: "\u{222F}",
        nfd: "\u{222F}",
        nfkc: "\u{222E}\u{222E}",
        nfkd: "\u{222E}\u{222E}",
    },
    NormalizationTest {
        source: "\u{2230}",
        nfc: "\u{2230}",
        nfd: "\u{2230}",
        nfkc: "\u{222E}\u{222E}\u{222E}",
        nfkd: "\u{222E}\u{222E}\u{222E}",
    },
    NormalizationTest {
        source: "\u{2241}",
        nfc: "\u{2241}",
        nfd: "\u{223C}\u{0338}",
        nfkc: "\u{2241}",
        nfkd: "\u{223C}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2244}",
        nfc: "\u{2244}",
        nfd: "\u{2243}\u{0338}",
        nfkc: "\u{2244}",
        nfkd: "\u{2243}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2247}",
        nfc: "\u{2247}",
        nfd: "\u{2245}\u{0338}",
        nfkc: "\u{2247}",
        nfkd: "\u{2245}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2249}",
        nfc: "\u{2249}",
        nfd: "\u{2248}\u{0338}",
        nfkc: "\u{2249}",
        nfkd: "\u{2248}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2260}",
        nfc: "\u{2260}",
        nfd: "\u{003D}\u{0338}",
        nfkc: "\u{2260}",
        nfkd: "\u{003D}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2262}",
        nfc: "\u{2262}",
        nfd: "\u{2261}\u{0338}",
        nfkc: "\u{2262}",
        nfkd: "\u{2261}\u{0338}",
    },
    NormalizationTest {
        source: "\u{226D}",
        nfc: "\u{226D}",
        nfd: "\u{224D}\u{0338}",
        nfkc: "\u{226D}",
        nfkd: "\u{224D}\u{0338}",
    },
    NormalizationTest {
        source: "\u{226E}",
        nfc: "\u{226E}",
        nfd: "\u{003C}\u{0338}",
        nfkc: "\u{226E}",
        nfkd: "\u{003C}\u{0338}",
    },
    NormalizationTest {
        source: "\u{226F}",
        nfc: "\u{226F}",
        nfd: "\u{003E}\u{0338}",
        nfkc: "\u{226F}",
        nfkd: "\u{003E}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2270}",
        nfc: "\u{2270}",
        nfd: "\u{2264}\u{0338}",
        nfkc: "\u{2270}",
        nfkd: "\u{2264}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2271}",
        nfc: "\u{2271}",
        nfd: "\u{2265}\u{0338}",
        nfkc: "\u{2271}",
        nfkd: "\u{2265}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2274}",
        nfc: "\u{2274}",
        nfd: "\u{2272}\u{0338}",
        nfkc: "\u{2274}",
        nfkd: "\u{2272}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2275}",
        nfc: "\u{2275}",
        nfd: "\u{2273}\u{0338}",
        nfkc: "\u{2275}",
        nfkd: "\u{2273}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2278}",
        nfc: "\u{2278}",
        nfd: "\u{2276}\u{0338}",
        nfkc: "\u{2278}",
        nfkd: "\u{2276}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2279}",
        nfc: "\u{2279}",
        nfd: "\u{2277}\u{0338}",
        nfkc: "\u{2279}",
        nfkd: "\u{2277}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2280}",
        nfc: "\u{2280}",
        nfd: "\u{227A}\u{0338}",
        nfkc: "\u{2280}",
        nfkd: "\u{227A}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2281}",
        nfc: "\u{2281}",
        nfd: "\u{227B}\u{0338}",
        nfkc: "\u{2281}",
        nfkd: "\u{227B}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2284}",
        nfc: "\u{2284}",
        nfd: "\u{2282}\u{0338}",
        nfkc: "\u{2284}",
        nfkd: "\u{2282}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2285}",
        nfc: "\u{2285}",
        nfd: "\u{2283}\u{0338}",
        nfkc: "\u{2285}",
        nfkd: "\u{2283}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2288}",
        nfc: "\u{2288}",
        nfd: "\u{2286}\u{0338}",
        nfkc: "\u{2288}",
        nfkd: "\u{2286}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2289}",
        nfc: "\u{2289}",
        nfd: "\u{2287}\u{0338}",
        nfkc: "\u{2289}",
        nfkd: "\u{2287}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22AC}",
        nfc: "\u{22AC}",
        nfd: "\u{22A2}\u{0338}",
        nfkc: "\u{22AC}",
        nfkd: "\u{22A2}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22AD}",
        nfc: "\u{22AD}",
        nfd: "\u{22A8}\u{0338}",
        nfkc: "\u{22AD}",
        nfkd: "\u{22A8}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22AE}",
        nfc: "\u{22AE}",
        nfd: "\u{22A9}\u{0338}",
        nfkc: "\u{22AE}",
        nfkd: "\u{22A9}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22AF}",
        nfc: "\u{22AF}",
        nfd: "\u{22AB}\u{0338}",
        nfkc: "\u{22AF}",
        nfkd: "\u{22AB}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22E0}",
        nfc: "\u{22E0}",
        nfd: "\u{227C}\u{0338}",
        nfkc: "\u{22E0}",
        nfkd: "\u{227C}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22E1}",
        nfc: "\u{22E1}",
        nfd: "\u{227D}\u{0338}",
        nfkc: "\u{22E1}",
        nfkd: "\u{227D}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22E2}",
        nfc: "\u{22E2}",
        nfd: "\u{2291}\u{0338}",
        nfkc: "\u{22E2}",
        nfkd: "\u{2291}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22E3}",
        nfc: "\u{22E3}",
        nfd: "\u{2292}\u{0338}",
        nfkc: "\u{22E3}",
        nfkd: "\u{2292}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22EA}",
        nfc: "\u{22EA}",
        nfd: "\u{22B2}\u{0338}",
        nfkc: "\u{22EA}",
        nfkd: "\u{22B2}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22EB}",
        nfc: "\u{22EB}",
        nfd: "\u{22B3}\u{0338}",
        nfkc: "\u{22EB}",
        nfkd: "\u{22B3}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22EC}",
        nfc: "\u{22EC}",
        nfd: "\u{22B4}\u{0338}",
        nfkc: "\u{22EC}",
        nfkd: "\u{22B4}\u{0338}",
    },
    NormalizationTest {
        source: "\u{22ED}",
        nfc: "\u{22ED}",
        nfd: "\u{22B5}\u{0338}",
        nfkc: "\u{22ED}",
        nfkd: "\u{22B5}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2329}",
        nfc: "\u{3008}",
        nfd: "\u{3008}",
        nfkc: "\u{3008}",
        nfkd: "\u{3008}",
    },
    NormalizationTest {
        source: "\u{232A}",
        nfc: "\u{3009}",
        nfd: "\u{3009}",
        nfkc: "\u{3009}",
        nfkd: "\u{3009}",
    },
    NormalizationTest {
        source: "\u{2460}",
        nfc: "\u{2460}",
        nfd: "\u{2460}",
        nfkc: "\u{0031}",
        nfkd: "\u{0031}",
    },
    NormalizationTest {
        source: "\u{2461}",
        nfc: "\u{2461}",
        nfd: "\u{2461}",
        nfkc: "\u{0032}",
        nfkd: "\u{0032}",
    },
    NormalizationTest {
        source: "\u{2462}",
        nfc: "\u{2462}",
        nfd: "\u{2462}",
        nfkc: "\u{0033}",
        nfkd: "\u{0033}",
    },
    NormalizationTest {
        source: "\u{2463}",
        nfc: "\u{2463}",
        nfd: "\u{2463}",
        nfkc: "\u{0034}",
        nfkd: "\u{0034}",
    },
    NormalizationTest {
        source: "\u{2464}",
        nfc: "\u{2464}",
        nfd: "\u{2464}",
        nfkc: "\u{0035}",
        nfkd: "\u{0035}",
    },
    NormalizationTest {
        source: "\u{2465}",
        nfc: "\u{2465}",
        nfd: "\u{2465}",
        nfkc: "\u{0036}",
        nfkd: "\u{0036}",
    },
    NormalizationTest {
        source: "\u{2466}",
        nfc: "\u{2466}",
        nfd: "\u{2466}",
        nfkc: "\u{0037}",
        nfkd: "\u{0037}",
    },
    NormalizationTest {
        source: "\u{2467}",
        nfc: "\u{2467}",
        nfd: "\u{2467}",
        nfkc: "\u{0038}",
        nfkd: "\u{0038}",
    },
    NormalizationTest {
        source: "\u{2468}",
        nfc: "\u{2468}",
        nfd: "\u{2468}",
        nfkc: "\u{0039}",
        nfkd: "\u{0039}",
    },
    NormalizationTest {
        source: "\u{2469}",
        nfc: "\u{2469}",
        nfd: "\u{2469}",
        nfkc: "\u{0031}\u{0030}",
        nfkd: "\u{0031}\u{0030}",
    },
    NormalizationTest {
        source: "\u{246A}",
        nfc: "\u{246A}",
        nfd: "\u{246A}",
        nfkc: "\u{0031}\u{0031}",
        nfkd: "\u{0031}\u{0031}",
    },
    NormalizationTest {
        source: "\u{246B}",
        nfc: "\u{246B}",
        nfd: "\u{246B}",
        nfkc: "\u{0031}\u{0032}",
        nfkd: "\u{0031}\u{0032}",
    },
    NormalizationTest {
        source: "\u{246C}",
        nfc: "\u{246C}",
        nfd: "\u{246C}",
        nfkc: "\u{0031}\u{0033}",
        nfkd: "\u{0031}\u{0033}",
    },
    NormalizationTest {
        source: "\u{246D}",
        nfc: "\u{246D}",
        nfd: "\u{246D}",
        nfkc: "\u{0031}\u{0034}",
        nfkd: "\u{0031}\u{0034}",
    },
    NormalizationTest {
        source: "\u{246E}",
        nfc: "\u{246E}",
        nfd: "\u{246E}",
        nfkc: "\u{0031}\u{0035}",
        nfkd: "\u{0031}\u{0035}",
    },
    NormalizationTest {
        source: "\u{246F}",
        nfc: "\u{246F}",
        nfd: "\u{246F}",
        nfkc: "\u{0031}\u{0036}",
        nfkd: "\u{0031}\u{0036}",
    },
    NormalizationTest {
        source: "\u{2470}",
        nfc: "\u{2470}",
        nfd: "\u{2470}",
        nfkc: "\u{0031}\u{0037}",
        nfkd: "\u{0031}\u{0037}",
    },
    NormalizationTest {
        source: "\u{2471}",
        nfc: "\u{2471}",
        nfd: "\u{2471}",
        nfkc: "\u{0031}\u{0038}",
        nfkd: "\u{0031}\u{0038}",
    },
    NormalizationTest {
        source: "\u{2472}",
        nfc: "\u{2472}",
        nfd: "\u{2472}",
        nfkc: "\u{0031}\u{0039}",
        nfkd: "\u{0031}\u{0039}",
    },
    NormalizationTest {
        source: "\u{2473}",
        nfc: "\u{2473}",
        nfd: "\u{2473}",
        nfkc: "\u{0032}\u{0030}",
        nfkd: "\u{0032}\u{0030}",
    },
    NormalizationTest {
        source: "\u{2474}",
        nfc: "\u{2474}",
        nfd: "\u{2474}",
        nfkc: "\u{0028}\u{0031}\u{0029}",
        nfkd: "\u{0028}\u{0031}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2475}",
        nfc: "\u{2475}",
        nfd: "\u{2475}",
        nfkc: "\u{0028}\u{0032}\u{0029}",
        nfkd: "\u{0028}\u{0032}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2476}",
        nfc: "\u{2476}",
        nfd: "\u{2476}",
        nfkc: "\u{0028}\u{0033}\u{0029}",
        nfkd: "\u{0028}\u{0033}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2477}",
        nfc: "\u{2477}",
        nfd: "\u{2477}",
        nfkc: "\u{0028}\u{0034}\u{0029}",
        nfkd: "\u{0028}\u{0034}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2478}",
        nfc: "\u{2478}",
        nfd: "\u{2478}",
        nfkc: "\u{0028}\u{0035}\u{0029}",
        nfkd: "\u{0028}\u{0035}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2479}",
        nfc: "\u{2479}",
        nfd: "\u{2479}",
        nfkc: "\u{0028}\u{0036}\u{0029}",
        nfkd: "\u{0028}\u{0036}\u{0029}",
    },
    NormalizationTest {
        source: "\u{247A}",
        nfc: "\u{247A}",
        nfd: "\u{247A}",
        nfkc: "\u{0028}\u{0037}\u{0029}",
        nfkd: "\u{0028}\u{0037}\u{0029}",
    },
    NormalizationTest {
        source: "\u{247B}",
        nfc: "\u{247B}",
        nfd: "\u{247B}",
        nfkc: "\u{0028}\u{0038}\u{0029}",
        nfkd: "\u{0028}\u{0038}\u{0029}",
    },
    NormalizationTest {
        source: "\u{247C}",
        nfc: "\u{247C}",
        nfd: "\u{247C}",
        nfkc: "\u{0028}\u{0039}\u{0029}",
        nfkd: "\u{0028}\u{0039}\u{0029}",
    },
    NormalizationTest {
        source: "\u{247D}",
        nfc: "\u{247D}",
        nfd: "\u{247D}",
        nfkc: "\u{0028}\u{0031}\u{0030}\u{0029}",
        nfkd: "\u{0028}\u{0031}\u{0030}\u{0029}",
    },
    NormalizationTest {
        source: "\u{247E}",
        nfc: "\u{247E}",
        nfd: "\u{247E}",
        nfkc: "\u{0028}\u{0031}\u{0031}\u{0029}",
        nfkd: "\u{0028}\u{0031}\u{0031}\u{0029}",
    },
    NormalizationTest {
        source: "\u{247F}",
        nfc: "\u{247F}",
        nfd: "\u{247F}",
        nfkc: "\u{0028}\u{0031}\u{0032}\u{0029}",
        nfkd: "\u{0028}\u{0031}\u{0032}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2480}",
        nfc: "\u{2480}",
        nfd: "\u{2480}",
        nfkc: "\u{0028}\u{0031}\u{0033}\u{0029}",
        nfkd: "\u{0028}\u{0031}\u{0033}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2481}",
        nfc: "\u{2481}",
        nfd: "\u{2481}",
        nfkc: "\u{0028}\u{0031}\u{0034}\u{0029}",
        nfkd: "\u{0028}\u{0031}\u{0034}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2482}",
        nfc: "\u{2482}",
        nfd: "\u{2482}",
        nfkc: "\u{0028}\u{0031}\u{0035}\u{0029}",
        nfkd: "\u{0028}\u{0031}\u{0035}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2483}",
        nfc: "\u{2483}",
        nfd: "\u{2483}",
        nfkc: "\u{0028}\u{0031}\u{0036}\u{0029}",
        nfkd: "\u{0028}\u{0031}\u{0036}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2484}",
        nfc: "\u{2484}",
        nfd: "\u{2484}",
        nfkc: "\u{0028}\u{0031}\u{0037}\u{0029}",
        nfkd: "\u{0028}\u{0031}\u{0037}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2485}",
        nfc: "\u{2485}",
        nfd: "\u{2485}",
        nfkc: "\u{0028}\u{0031}\u{0038}\u{0029}",
        nfkd: "\u{0028}\u{0031}\u{0038}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2486}",
        nfc: "\u{2486}",
        nfd: "\u{2486}",
        nfkc: "\u{0028}\u{0031}\u{0039}\u{0029}",
        nfkd: "\u{0028}\u{0031}\u{0039}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2487}",
        nfc: "\u{2487}",
        nfd: "\u{2487}",
        nfkc: "\u{0028}\u{0032}\u{0030}\u{0029}",
        nfkd: "\u{0028}\u{0032}\u{0030}\u{0029}",
    },
    NormalizationTest {
        source: "\u{2488}",
        nfc: "\u{2488}",
        nfd: "\u{2488}",
        nfkc: "\u{0031}\u{002E}",
        nfkd: "\u{0031}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2489}",
        nfc: "\u{2489}",
        nfd: "\u{2489}",
        nfkc: "\u{0032}\u{002E}",
        nfkd: "\u{0032}\u{002E}",
    },
    NormalizationTest {
        source: "\u{248A}",
        nfc: "\u{248A}",
        nfd: "\u{248A}",
        nfkc: "\u{0033}\u{002E}",
        nfkd: "\u{0033}\u{002E}",
    },
    NormalizationTest {
        source: "\u{248B}",
        nfc: "\u{248B}",
        nfd: "\u{248B}",
        nfkc: "\u{0034}\u{002E}",
        nfkd: "\u{0034}\u{002E}",
    },
    NormalizationTest {
        source: "\u{248C}",
        nfc: "\u{248C}",
        nfd: "\u{248C}",
        nfkc: "\u{0035}\u{002E}",
        nfkd: "\u{0035}\u{002E}",
    },
    NormalizationTest {
        source: "\u{248D}",
        nfc: "\u{248D}",
        nfd: "\u{248D}",
        nfkc: "\u{0036}\u{002E}",
        nfkd: "\u{0036}\u{002E}",
    },
    NormalizationTest {
        source: "\u{248E}",
        nfc: "\u{248E}",
        nfd: "\u{248E}",
        nfkc: "\u{0037}\u{002E}",
        nfkd: "\u{0037}\u{002E}",
    },
    NormalizationTest {
        source: "\u{248F}",
        nfc: "\u{248F}",
        nfd: "\u{248F}",
        nfkc: "\u{0038}\u{002E}",
        nfkd: "\u{0038}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2490}",
        nfc: "\u{2490}",
        nfd: "\u{2490}",
        nfkc: "\u{0039}\u{002E}",
        nfkd: "\u{0039}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2491}",
        nfc: "\u{2491}",
        nfd: "\u{2491}",
        nfkc: "\u{0031}\u{0030}\u{002E}",
        nfkd: "\u{0031}\u{0030}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2492}",
        nfc: "\u{2492}",
        nfd: "\u{2492}",
        nfkc: "\u{0031}\u{0031}\u{002E}",
        nfkd: "\u{0031}\u{0031}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2493}",
        nfc: "\u{2493}",
        nfd: "\u{2493}",
        nfkc: "\u{0031}\u{0032}\u{002E}",
        nfkd: "\u{0031}\u{0032}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2494}",
        nfc: "\u{2494}",
        nfd: "\u{2494}",
        nfkc: "\u{0031}\u{0033}\u{002E}",
        nfkd: "\u{0031}\u{0033}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2495}",
        nfc: "\u{2495}",
        nfd: "\u{2495}",
        nfkc: "\u{0031}\u{0034}\u{002E}",
        nfkd: "\u{0031}\u{0034}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2496}",
        nfc: "\u{2496}",
        nfd: "\u{2496}",
        nfkc: "\u{0031}\u{0035}\u{002E}",
        nfkd: "\u{0031}\u{0035}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2497}",
        nfc: "\u{2497}",
        nfd: "\u{2497}",
        nfkc: "\u{0031}\u{0036}\u{002E}",
        nfkd: "\u{0031}\u{0036}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2498}",
        nfc: "\u{2498}",
        nfd: "\u{2498}",
        nfkc: "\u{0031}\u{0037}\u{002E}",
        nfkd: "\u{0031}\u{0037}\u{002E}",
    },
    NormalizationTest {
        source: "\u{2499}",
        nfc: "\u{2499}",
        nfd: "\u{2499}",
        nfkc: "\u{0031}\u{0038}\u{002E}",
        nfkd: "\u{0031}\u{0038}\u{002E}",
    },
    NormalizationTest {
        source: "\u{249A}",
        nfc: "\u{249A}",
        nfd: "\u{249A}",
        nfkc: "\u{0031}\u{0039}\u{002E}",
        nfkd: "\u{0031}\u{0039}\u{002E}",
    },
    NormalizationTest {
        source: "\u{249B}",
        nfc: "\u{249B}",
        nfd: "\u{249B}",
        nfkc: "\u{0032}\u{0030}\u{002E}",
        nfkd: "\u{0032}\u{0030}\u{002E}",
    },
    NormalizationTest {
        source: "\u{249C}",
        nfc: "\u{249C}",
        nfd: "\u{249C}",
        nfkc: "\u{0028}\u{0061}\u{0029}",
        nfkd: "\u{0028}\u{0061}\u{0029}",
    },
    NormalizationTest {
        source: "\u{249D}",
        nfc: "\u{249D}",
        nfd: "\u{249D}",
        nfkc: "\u{0028}\u{0062}\u{0029}",
        nfkd: "\u{0028}\u{0062}\u{0029}",
    },
    NormalizationTest {
        source: "\u{249E}",
        nfc: "\u{249E}",
        nfd: "\u{249E}",
        nfkc: "\u{0028}\u{0063}\u{0029}",
        nfkd: "\u{0028}\u{0063}\u{0029}",
    },
    NormalizationTest {
        source: "\u{249F}",
        nfc: "\u{249F}",
        nfd: "\u{249F}",
        nfkc: "\u{0028}\u{0064}\u{0029}",
        nfkd: "\u{0028}\u{0064}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24A0}",
        nfc: "\u{24A0}",
        nfd: "\u{24A0}",
        nfkc: "\u{0028}\u{0065}\u{0029}",
        nfkd: "\u{0028}\u{0065}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24A1}",
        nfc: "\u{24A1}",
        nfd: "\u{24A1}",
        nfkc: "\u{0028}\u{0066}\u{0029}",
        nfkd: "\u{0028}\u{0066}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24A2}",
        nfc: "\u{24A2}",
        nfd: "\u{24A2}",
        nfkc: "\u{0028}\u{0067}\u{0029}",
        nfkd: "\u{0028}\u{0067}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24A3}",
        nfc: "\u{24A3}",
        nfd: "\u{24A3}",
        nfkc: "\u{0028}\u{0068}\u{0029}",
        nfkd: "\u{0028}\u{0068}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24A4}",
        nfc: "\u{24A4}",
        nfd: "\u{24A4}",
        nfkc: "\u{0028}\u{0069}\u{0029}",
        nfkd: "\u{0028}\u{0069}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24A5}",
        nfc: "\u{24A5}",
        nfd: "\u{24A5}",
        nfkc: "\u{0028}\u{006A}\u{0029}",
        nfkd: "\u{0028}\u{006A}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24A6}",
        nfc: "\u{24A6}",
        nfd: "\u{24A6}",
        nfkc: "\u{0028}\u{006B}\u{0029}",
        nfkd: "\u{0028}\u{006B}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24A7}",
        nfc: "\u{24A7}",
        nfd: "\u{24A7}",
        nfkc: "\u{0028}\u{006C}\u{0029}",
        nfkd: "\u{0028}\u{006C}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24A8}",
        nfc: "\u{24A8}",
        nfd: "\u{24A8}",
        nfkc: "\u{0028}\u{006D}\u{0029}",
        nfkd: "\u{0028}\u{006D}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24A9}",
        nfc: "\u{24A9}",
        nfd: "\u{24A9}",
        nfkc: "\u{0028}\u{006E}\u{0029}",
        nfkd: "\u{0028}\u{006E}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24AA}",
        nfc: "\u{24AA}",
        nfd: "\u{24AA}",
        nfkc: "\u{0028}\u{006F}\u{0029}",
        nfkd: "\u{0028}\u{006F}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24AB}",
        nfc: "\u{24AB}",
        nfd: "\u{24AB}",
        nfkc: "\u{0028}\u{0070}\u{0029}",
        nfkd: "\u{0028}\u{0070}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24AC}",
        nfc: "\u{24AC}",
        nfd: "\u{24AC}",
        nfkc: "\u{0028}\u{0071}\u{0029}",
        nfkd: "\u{0028}\u{0071}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24AD}",
        nfc: "\u{24AD}",
        nfd: "\u{24AD}",
        nfkc: "\u{0028}\u{0072}\u{0029}",
        nfkd: "\u{0028}\u{0072}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24AE}",
        nfc: "\u{24AE}",
        nfd: "\u{24AE}",
        nfkc: "\u{0028}\u{0073}\u{0029}",
        nfkd: "\u{0028}\u{0073}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24AF}",
        nfc: "\u{24AF}",
        nfd: "\u{24AF}",
        nfkc: "\u{0028}\u{0074}\u{0029}",
        nfkd: "\u{0028}\u{0074}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24B0}",
        nfc: "\u{24B0}",
        nfd: "\u{24B0}",
        nfkc: "\u{0028}\u{0075}\u{0029}",
        nfkd: "\u{0028}\u{0075}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24B1}",
        nfc: "\u{24B1}",
        nfd: "\u{24B1}",
        nfkc: "\u{0028}\u{0076}\u{0029}",
        nfkd: "\u{0028}\u{0076}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24B2}",
        nfc: "\u{24B2}",
        nfd: "\u{24B2}",
        nfkc: "\u{0028}\u{0077}\u{0029}",
        nfkd: "\u{0028}\u{0077}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24B3}",
        nfc: "\u{24B3}",
        nfd: "\u{24B3}",
        nfkc: "\u{0028}\u{0078}\u{0029}",
        nfkd: "\u{0028}\u{0078}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24B4}",
        nfc: "\u{24B4}",
        nfd: "\u{24B4}",
        nfkc: "\u{0028}\u{0079}\u{0029}",
        nfkd: "\u{0028}\u{0079}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24B5}",
        nfc: "\u{24B5}",
        nfd: "\u{24B5}",
        nfkc: "\u{0028}\u{007A}\u{0029}",
        nfkd: "\u{0028}\u{007A}\u{0029}",
    },
    NormalizationTest {
        source: "\u{24B6}",
        nfc: "\u{24B6}",
        nfd: "\u{24B6}",
        nfkc: "\u{0041}",
        nfkd: "\u{0041}",
    },
    NormalizationTest {
        source: "\u{24B7}",
        nfc: "\u{24B7}",
        nfd: "\u{24B7}",
        nfkc: "\u{0042}",
        nfkd: "\u{0042}",
    },
    NormalizationTest {
        source: "\u{24B8}",
        nfc: "\u{24B8}",
        nfd: "\u{24B8}",
        nfkc: "\u{0043}",
        nfkd: "\u{0043}",
    },
    NormalizationTest {
        source: "\u{24B9}",
        nfc: "\u{24B9}",
        nfd: "\u{24B9}",
        nfkc: "\u{0044}",
        nfkd: "\u{0044}",
    },
    NormalizationTest {
        source: "\u{24BA}",
        nfc: "\u{24BA}",
        nfd: "\u{24BA}",
        nfkc: "\u{0045}",
        nfkd: "\u{0045}",
    },
    NormalizationTest {
        source: "\u{24BB}",
        nfc: "\u{24BB}",
        nfd: "\u{24BB}",
        nfkc: "\u{0046}",
        nfkd: "\u{0046}",
    },
    NormalizationTest {
        source: "\u{24BC}",
        nfc: "\u{24BC}",
        nfd: "\u{24BC}",
        nfkc: "\u{0047}",
        nfkd: "\u{0047}",
    },
    NormalizationTest {
        source: "\u{24BD}",
        nfc: "\u{24BD}",
        nfd: "\u{24BD}",
        nfkc: "\u{0048}",
        nfkd: "\u{0048}",
    },
    NormalizationTest {
        source: "\u{24BE}",
        nfc: "\u{24BE}",
        nfd: "\u{24BE}",
        nfkc: "\u{0049}",
        nfkd: "\u{0049}",
    },
    NormalizationTest {
        source: "\u{24BF}",
        nfc: "\u{24BF}",
        nfd: "\u{24BF}",
        nfkc: "\u{004A}",
        nfkd: "\u{004A}",
    },
    NormalizationTest {
        source: "\u{24C0}",
        nfc: "\u{24C0}",
        nfd: "\u{24C0}",
        nfkc: "\u{004B}",
        nfkd: "\u{004B}",
    },
    NormalizationTest {
        source: "\u{24C1}",
        nfc: "\u{24C1}",
        nfd: "\u{24C1}",
        nfkc: "\u{004C}",
        nfkd: "\u{004C}",
    },
    NormalizationTest {
        source: "\u{24C2}",
        nfc: "\u{24C2}",
        nfd: "\u{24C2}",
        nfkc: "\u{004D}",
        nfkd: "\u{004D}",
    },
    NormalizationTest {
        source: "\u{24C3}",
        nfc: "\u{24C3}",
        nfd: "\u{24C3}",
        nfkc: "\u{004E}",
        nfkd: "\u{004E}",
    },
    NormalizationTest {
        source: "\u{24C4}",
        nfc: "\u{24C4}",
        nfd: "\u{24C4}",
        nfkc: "\u{004F}",
        nfkd: "\u{004F}",
    },
    NormalizationTest {
        source: "\u{24C5}",
        nfc: "\u{24C5}",
        nfd: "\u{24C5}",
        nfkc: "\u{0050}",
        nfkd: "\u{0050}",
    },
    NormalizationTest {
        source: "\u{24C6}",
        nfc: "\u{24C6}",
        nfd: "\u{24C6}",
        nfkc: "\u{0051}",
        nfkd: "\u{0051}",
    },
    NormalizationTest {
        source: "\u{24C7}",
        nfc: "\u{24C7}",
        nfd: "\u{24C7}",
        nfkc: "\u{0052}",
        nfkd: "\u{0052}",
    },
    NormalizationTest {
        source: "\u{24C8}",
        nfc: "\u{24C8}",
        nfd: "\u{24C8}",
        nfkc: "\u{0053}",
        nfkd: "\u{0053}",
    },
    NormalizationTest {
        source: "\u{24C9}",
        nfc: "\u{24C9}",
        nfd: "\u{24C9}",
        nfkc: "\u{0054}",
        nfkd: "\u{0054}",
    },
    NormalizationTest {
        source: "\u{24CA}",
        nfc: "\u{24CA}",
        nfd: "\u{24CA}",
        nfkc: "\u{0055}",
        nfkd: "\u{0055}",
    },
    NormalizationTest {
        source: "\u{24CB}",
        nfc: "\u{24CB}",
        nfd: "\u{24CB}",
        nfkc: "\u{0056}",
        nfkd: "\u{0056}",
    },
    NormalizationTest {
        source: "\u{24CC}",
        nfc: "\u{24CC}",
        nfd: "\u{24CC}",
        nfkc: "\u{0057}",
        nfkd: "\u{0057}",
    },
    NormalizationTest {
        source: "\u{24CD}",
        nfc: "\u{24CD}",
        nfd: "\u{24CD}",
        nfkc: "\u{0058}",
        nfkd: "\u{0058}",
    },
    NormalizationTest {
        source: "\u{24CE}",
        nfc: "\u{24CE}",
        nfd: "\u{24CE}",
        nfkc: "\u{0059}",
        nfkd: "\u{0059}",
    },
    NormalizationTest {
        source: "\u{24CF}",
        nfc: "\u{24CF}",
        nfd: "\u{24CF}",
        nfkc: "\u{005A}",
        nfkd: "\u{005A}",
    },
    NormalizationTest {
        source: "\u{24D0}",
        nfc: "\u{24D0}",
        nfd: "\u{24D0}",
        nfkc: "\u{0061}",
        nfkd: "\u{0061}",
    },
    NormalizationTest {
        source: "\u{24D1}",
        nfc: "\u{24D1}",
        nfd: "\u{24D1}",
        nfkc: "\u{0062}",
        nfkd: "\u{0062}",
    },
    NormalizationTest {
        source: "\u{24D2}",
        nfc: "\u{24D2}",
        nfd: "\u{24D2}",
        nfkc: "\u{0063}",
        nfkd: "\u{0063}",
    },
    NormalizationTest {
        source: "\u{24D3}",
        nfc: "\u{24D3}",
        nfd: "\u{24D3}",
        nfkc: "\u{0064}",
        nfkd: "\u{0064}",
    },
    NormalizationTest {
        source: "\u{24D4}",
        nfc: "\u{24D4}",
        nfd: "\u{24D4}",
        nfkc: "\u{0065}",
        nfkd: "\u{0065}",
    },
    NormalizationTest {
        source: "\u{24D5}",
        nfc: "\u{24D5}",
        nfd: "\u{24D5}",
        nfkc: "\u{0066}",
        nfkd: "\u{0066}",
    },
    NormalizationTest {
        source: "\u{24D6}",
        nfc: "\u{24D6}",
        nfd: "\u{24D6}",
        nfkc: "\u{0067}",
        nfkd: "\u{0067}",
    },
    NormalizationTest {
        source: "\u{24D7}",
        nfc: "\u{24D7}",
        nfd: "\u{24D7}",
        nfkc: "\u{0068}",
        nfkd: "\u{0068}",
    },
    NormalizationTest {
        source: "\u{24D8}",
        nfc: "\u{24D8}",
        nfd: "\u{24D8}",
        nfkc: "\u{0069}",
        nfkd: "\u{0069}",
    },
    NormalizationTest {
        source: "\u{24D9}",
        nfc: "\u{24D9}",
        nfd: "\u{24D9}",
        nfkc: "\u{006A}",
        nfkd: "\u{006A}",
    },
    NormalizationTest {
        source: "\u{24DA}",
        nfc: "\u{24DA}",
        nfd: "\u{24DA}",
        nfkc: "\u{006B}",
        nfkd: "\u{006B}",
    },
    NormalizationTest {
        source: "\u{24DB}",
        nfc: "\u{24DB}",
        nfd: "\u{24DB}",
        nfkc: "\u{006C}",
        nfkd: "\u{006C}",
    },
    NormalizationTest {
        source: "\u{24DC}",
        nfc: "\u{24DC}",
        nfd: "\u{24DC}",
        nfkc: "\u{006D}",
        nfkd: "\u{006D}",
    },
    NormalizationTest {
        source: "\u{24DD}",
        nfc: "\u{24DD}",
        nfd: "\u{24DD}",
        nfkc: "\u{006E}",
        nfkd: "\u{006E}",
    },
    NormalizationTest {
        source: "\u{24DE}",
        nfc: "\u{24DE}",
        nfd: "\u{24DE}",
        nfkc: "\u{006F}",
        nfkd: "\u{006F}",
    },
    NormalizationTest {
        source: "\u{24DF}",
        nfc: "\u{24DF}",
        nfd: "\u{24DF}",
        nfkc: "\u{0070}",
        nfkd: "\u{0070}",
    },
    NormalizationTest {
        source: "\u{24E0}",
        nfc: "\u{24E0}",
        nfd: "\u{24E0}",
        nfkc: "\u{0071}",
        nfkd: "\u{0071}",
    },
    NormalizationTest {
        source: "\u{24E1}",
        nfc: "\u{24E1}",
        nfd: "\u{24E1}",
        nfkc: "\u{0072}",
        nfkd: "\u{0072}",
    },
    NormalizationTest {
        source: "\u{24E2}",
        nfc: "\u{24E2}",
        nfd: "\u{24E2}",
        nfkc: "\u{0073}",
        nfkd: "\u{0073}",
    },
    NormalizationTest {
        source: "\u{24E3}",
        nfc: "\u{24E3}",
        nfd: "\u{24E3}",
        nfkc: "\u{0074}",
        nfkd: "\u{0074}",
    },
    NormalizationTest {
        source: "\u{24E4}",
        nfc: "\u{24E4}",
        nfd: "\u{24E4}",
        nfkc: "\u{0075}",
        nfkd: "\u{0075}",
    },
    NormalizationTest {
        source: "\u{24E5}",
        nfc: "\u{24E5}",
        nfd: "\u{24E5}",
        nfkc: "\u{0076}",
        nfkd: "\u{0076}",
    },
    NormalizationTest {
        source: "\u{24E6}",
        nfc: "\u{24E6}",
        nfd: "\u{24E6}",
        nfkc: "\u{0077}",
        nfkd: "\u{0077}",
    },
    NormalizationTest {
        source: "\u{24E7}",
        nfc: "\u{24E7}",
        nfd: "\u{24E7}",
        nfkc: "\u{0078}",
        nfkd: "\u{0078}",
    },
    NormalizationTest {
        source: "\u{24E8}",
        nfc: "\u{24E8}",
        nfd: "\u{24E8}",
        nfkc: "\u{0079}",
        nfkd: "\u{0079}",
    },
    NormalizationTest {
        source: "\u{24E9}",
        nfc: "\u{24E9}",
        nfd: "\u{24E9}",
        nfkc: "\u{007A}",
        nfkd: "\u{007A}",
    },
    NormalizationTest {
        source: "\u{24EA}",
        nfc: "\u{24EA}",
        nfd: "\u{24EA}",
        nfkc: "\u{0030}",
        nfkd: "\u{0030}",
    },
    NormalizationTest {
        source: "\u{2A0C}",
        nfc: "\u{2A0C}",
        nfd: "\u{2A0C}",
        nfkc: "\u{222B}\u{222B}\u{222B}\u{222B}",
        nfkd: "\u{222B}\u{222B}\u{222B}\u{222B}",
    },
    NormalizationTest {
        source: "\u{2A74}",
        nfc: "\u{2A74}",
        nfd: "\u{2A74}",
        nfkc: "\u{003A}\u{003A}\u{003D}",
        nfkd: "\u{003A}\u{003A}\u{003D}",
    },
    NormalizationTest {
        source: "\u{2A75}",
        nfc: "\u{2A75}",
        nfd: "\u{2A75}",
        nfkc: "\u{003D}\u{003D}",
        nfkd: "\u{003D}\u{003D}",
    },
    NormalizationTest {
        source: "\u{2A76}",
        nfc: "\u{2A76}",
        nfd: "\u{2A76}",
        nfkc: "\u{003D}\u{003D}\u{003D}",
        nfkd: "\u{003D}\u{003D}\u{003D}",
    },
    NormalizationTest {
        source: "\u{2ADC}",
        nfc: "\u{2ADD}\u{0338}",
        nfd: "\u{2ADD}\u{0338}",
        nfkc: "\u{2ADD}\u{0338}",
        nfkd: "\u{2ADD}\u{0338}",
    },
    NormalizationTest {
        source: "\u{2C7C}",
        nfc: "\u{2C7C}",
        nfd: "\u{2C7C}",
        nfkc: "\u{006A}",
        nfkd: "\u{006A}",
    },
    NormalizationTest {
        source: "\u{2C7D}",
        nfc: "\u{2C7D}",
        nfd: "\u{2C7D}",
        nfkc: "\u{0056}",
        nfkd: "\u{0056}",
    },
    NormalizationTest {
        source: "\u{2D6F}",
        nfc: "\u{2D6F}",
        nfd: "\u{2D6F}",
        nfkc: "\u{2D61}",
        nfkd: "\u{2D61}",
    },
    NormalizationTest {
        source: "\u{2E9F}",
        nfc: "\u{2E9F}",
        nfd: "\u{2E9F}",
        nfkc: "\u{6BCD}",
        nfkd: "\u{6BCD}",
    },
    NormalizationTest {
        source: "\u{2EF3}",
        nfc: "\u{2EF3}",
        nfd: "\u{2EF3}",
        nfkc: "\u{9F9F}",
        nfkd: "\u{9F9F}",
    },
    NormalizationTest {
        source: "\u{2F00}",
        nfc: "\u{2F00}",
        nfd: "\u{2F00}",
        nfkc: "\u{4E00}",
        nfkd: "\u{4E00}",
    },
    NormalizationTest {
        source: "\u{2F01}",
        nfc: "\u{2F01}",
        nfd: "\u{2F01}",
        nfkc: "\u{4E28}",
        nfkd: "\u{4E28}",
    },
    NormalizationTest {
        source: "\u{2F02}",
        nfc: "\u{2F02}",
        nfd: "\u{2F02}",
        nfkc: "\u{4E36}",
        nfkd: "\u{4E36}",
    },
    NormalizationTest {
        source: "\u{2F03}",
        nfc: "\u{2F03}",
        nfd: "\u{2F03}",
        nfkc: "\u{4E3F}",
        nfkd: "\u{4E3F}",
    },
    NormalizationTest {
        source: "\u{2F04}",
        nfc: "\u{2F04}",
        nfd: "\u{2F04}",
        nfkc: "\u{4E59}",
        nfkd: "\u{4E59}",
    },
    NormalizationTest {
        source: "\u{2F05}",
        nfc: "\u{2F05}",
        nfd: "\u{2F05}",
        nfkc: "\u{4E85}",
        nfkd: "\u{4E85}",
    },
    NormalizationTest {
        source: "\u{2F06}",
        nfc: "\u{2F06}",
        nfd: "\u{2F06}",
        nfkc: "\u{4E8C}",
        nfkd: "\u{4E8C}",
    },
    NormalizationTest {
        source: "\u{2F07}",
        nfc: "\u{2F07}",
        nfd: "\u{2F07}",
        nfkc: "\u{4EA0}",
        nfkd: "\u{4EA0}",
    },
    NormalizationTest {
        source: "\u{2F08}",
        nfc: "\u{2F08}",
        nfd: "\u{2F08}",
        nfkc: "\u{4EBA}",
        nfkd: "\u{4EBA}",
    },
    NormalizationTest {
        source: "\u{2F09}",
        nfc: "\u{2F09}",
        nfd: "\u{2F09}",
        nfkc: "\u{513F}",
        nfkd: "\u{513F}",
    },
    NormalizationTest {
        source: "\u{2F0A}",
        nfc: "\u{2F0A}",
        nfd: "\u{2F0A}",
        nfkc: "\u{5165}",
        nfkd: "\u{5165}",
    },
    NormalizationTest {
        source: "\u{2F0B}",
        nfc: "\u{2F0B}",
        nfd: "\u{2F0B}",
        nfkc: "\u{516B}",
        nfkd: "\u{516B}",
    },
    NormalizationTest {
        source: "\u{2F0C}",
        nfc: "\u{2F0C}",
        nfd: "\u{2F0C}",
        nfkc: "\u{5182}",
        nfkd: "\u{5182}",
    },
    NormalizationTest {
        source: "\u{2F0D}",
        nfc: "\u{2F0D}",
        nfd: "\u{2F0D}",
        nfkc: "\u{5196}",
        nfkd: "\u{5196}",
    },
    NormalizationTest {
        source: "\u{2F0E}",
        nfc: "\u{2F0E}",
        nfd: "\u{2F0E}",
        nfkc: "\u{51AB}",
        nfkd: "\u{51AB}",
    },
    NormalizationTest {
        source: "\u{2F0F}",
        nfc: "\u{2F0F}",
        nfd: "\u{2F0F}",
        nfkc: "\u{51E0}",
        nfkd: "\u{51E0}",
    },
    NormalizationTest {
        source: "\u{2F10}",
        nfc: "\u{2F10}",
        nfd: "\u{2F10}",
        nfkc: "\u{51F5}",
        nfkd: "\u{51F5}",
    },
    NormalizationTest {
        source: "\u{2F11}",
        nfc: "\u{2F11}",
        nfd: "\u{2F11}",
        nfkc: "\u{5200}",
        nfkd: "\u{5200}",
    },
    NormalizationTest {
        source: "\u{2F12}",
        nfc: "\u{2F12}",
        nfd: "\u{2F12}",
        nfkc: "\u{529B}",
        nfkd: "\u{529B}",
    },
    NormalizationTest {
        source: "\u{2F13}",
        nfc: "\u{2F13}",
        nfd: "\u{2F13}",
        nfkc: "\u{52F9}",
        nfkd: "\u{52F9}",
    },
    NormalizationTest {
        source: "\u{2F14}",
        nfc: "\u{2F14}",
        nfd: "\u{2F14}",
        nfkc: "\u{5315}",
        nfkd: "\u{5315}",
    },
    NormalizationTest {
        source: "\u{2F15}",
        nfc: "\u{2F15}",
        nfd: "\u{2F15}",
        nfkc: "\u{531A}",
        nfkd: "\u{531A}",
    },
    NormalizationTest {
        source: "\u{2F16}",
        nfc: "\u{2F16}",
        nfd: "\u{2F16}",
        nfkc: "\u{5338}",
        nfkd: "\u{5338}",
    },
    NormalizationTest {
        source: "\u{2F17}",
        nfc: "\u{2F17}",
        nfd: "\u{2F17}",
        nfkc: "\u{5341}",
        nfkd: "\u{5341}",
    },
    NormalizationTest {
        source: "\u{2F18}",
        nfc: "\u{2F18}",
        nfd: "\u{2F18}",
        nfkc: "\u{535C}",
        nfkd: "\u{535C}",
    },
    NormalizationTest {
        source: "\u{2F19}",
        nfc: "\u{2F19}",
        nfd: "\u{2F19}",
        nfkc: "\u{5369}",
        nfkd: "\u{5369}",
    },
    NormalizationTest {
        source: "\u{2F1A}",
        nfc: "\u{2F1A}",
        nfd: "\u{2F1A}",
        nfkc: "\u{5382}",
        nfkd: "\u{5382}",
    },
    NormalizationTest {
        source: "\u{2F1B}",
        nfc: "\u{2F1B}",
        nfd: "\u{2F1B}",
        nfkc: "\u{53B6}",
        nfkd: "\u{53B6}",
    },
    NormalizationTest {
        source: "\u{2F1C}",
        nfc: "\u{2F1C}",
        nfd: "\u{2F1C}",
        nfkc: "\u{53C8}",
        nfkd: "\u{53C8}",
    },
    NormalizationTest {
        source: "\u{2F1D}",
        nfc: "\u{2F1D}",
        nfd: "\u{2F1D}",
        nfkc: "\u{53E3}",
        nfkd: "\u{53E3}",
    },
    NormalizationTest {
        source: "\u{2F1E}",
        nfc: "\u{2F1E}",
        nfd: "\u{2F1E}",
        nfkc: "\u{56D7}",
        nfkd: "\u{56D7}",
    },
    NormalizationTest {
        source: "\u{2F1F}",
        nfc: "\u{2F1F}",
        nfd: "\u{2F1F}",
        nfkc: "\u{571F}",
        nfkd: "\u{571F}",
    },
    NormalizationTest {
        source: "\u{2F20}",
        nfc: "\u{2F20}",
        nfd: "\u{2F20}",
        nfkc: "\u{58EB}",
        nfkd: "\u{58EB}",
    },
    NormalizationTest {
        source: "\u{2F21}",
        nfc: "\u{2F21}",
        nfd: "\u{2F21}",
        nfkc: "\u{5902}",
        nfkd: "\u{5902}",
    },
    NormalizationTest {
        source: "\u{2F22}",
        nfc: "\u{2F22}",
        nfd: "\u{2F22}",
        nfkc: "\u{590A}",
        nfkd: "\u{590A}",
    },
    NormalizationTest {
        source: "\u{2F23}",
        nfc: "\u{2F23}",
        nfd: "\u{2F23}",
        nfkc: "\u{5915}",
        nfkd: "\u{5915}",
    },
    NormalizationTest {
        source: "\u{2F24}",
        nfc: "\u{2F24}",
        nfd: "\u{2F24}",
        nfkc: "\u{5927}",
        nfkd: "\u{5927}",
    },
    NormalizationTest {
        source: "\u{2F25}",
        nfc: "\u{2F25}",
        nfd: "\u{2F25}",
        nfkc: "\u{5973}",
        nfkd: "\u{5973}",
    },
    NormalizationTest {
        source: "\u{2F26}",
        nfc: "\u{2F26}",
        nfd: "\u{2F26}",
        nfkc: "\u{5B50}",
        nfkd: "\u{5B50}",
    },
    NormalizationTest {
        source: "\u{2F27}",
        nfc: "\u{2F27}",
        nfd: "\u{2F27}",
        nfkc: "\u{5B80}",
        nfkd: "\u{5B80}",
    },
    NormalizationTest {
        source: "\u{2F28}",
        nfc: "\u{2F28}",
        nfd: "\u{2F28}",
        nfkc: "\u{5BF8}",
        nfkd: "\u{5BF8}",
    },
    NormalizationTest {
        source: "\u{2F29}",
        nfc: "\u{2F29}",
        nfd: "\u{2F29}",
        nfkc: "\u{5C0F}",
        nfkd: "\u{5C0F}",
    },
    NormalizationTest {
        source: "\u{2F2A}",
        nfc: "\u{2F2A}",
        nfd: "\u{2F2A}",
        nfkc: "\u{5C22}",
        nfkd: "\u{5C22}",
    },
    NormalizationTest {
        source: "\u{2F2B}",
        nfc: "\u{2F2B}",
        nfd: "\u{2F2B}",
        nfkc: "\u{5C38}",
        nfkd: "\u{5C38}",
    },
    NormalizationTest {
        source: "\u{2F2C}",
        nfc: "\u{2F2C}",
        nfd: "\u{2F2C}",
        nfkc: "\u{5C6E}",
        nfkd: "\u{5C6E}",
    },
    NormalizationTest {
        source: "\u{2F2D}",
        nfc: "\u{2F2D}",
        nfd: "\u{2F2D}",
        nfkc: "\u{5C71}",
        nfkd: "\u{5C71}",
    },
    NormalizationTest {
        source: "\u{2F2E}",
        nfc: "\u{2F2E}",
        nfd: "\u{2F2E}",
        nfkc: "\u{5DDB}",
        nfkd: "\u{5DDB}",
    },
    NormalizationTest {
        source: "\u{2F2F}",
        nfc: "\u{2F2F}",
        nfd: "\u{2F2F}",
        nfkc: "\u{5DE5}",
        nfkd: "\u{5DE5}",
    },
    NormalizationTest {
        source: "\u{2F30}",
        nfc: "\u{2F30}",
        nfd: "\u{2F30}",
        nfkc: "\u{5DF1}",
        nfkd: "\u{5DF1}",
    },
    NormalizationTest {
        source: "\u{2F31}",
        nfc: "\u{2F31}",
        nfd: "\u{2F31}",
        nfkc: "\u{5DFE}",
        nfkd: "\u{5DFE}",
    },
    NormalizationTest {
        source: "\u{2F32}",
        nfc: "\u{2F32}",
        nfd: "\u{2F32}",
        nfkc: "\u{5E72}",
        nfkd: "\u{5E72}",
    },
    NormalizationTest {
        source: "\u{2F33}",
        nfc: "\u{2F33}",
        nfd: "\u{2F33}",
        nfkc: "\u{5E7A}",
        nfkd: "\u{5E7A}",
    },
    NormalizationTest {
        source: "\u{2F34}",
        nfc: "\u{2F34}",
        nfd: "\u{2F34}",
        nfkc: "\u{5E7F}",
        nfkd: "\u{5E7F}",
    },
    NormalizationTest {
        source: "\u{2F35}",
        nfc: "\u{2F35}",
        nfd: "\u{2F35}",
        nfkc: "\u{5EF4}",
        nfkd: "\u{5EF4}",
    },
    NormalizationTest {
        source: "\u{2F36}",
        nfc: "\u{2F36}",
        nfd: "\u{2F36}",
        nfkc: "\u{5EFE}",
        nfkd: "\u{5EFE}",
    },
    NormalizationTest {
        source: "\u{2F37}",
        nfc: "\u{2F37}",
        nfd: "\u{2F37}",
        nfkc: "\u{5F0B}",
        nfkd: "\u{5F0B}",
    },
    NormalizationTest {
        source: "\u{2F38}",
        nfc: "\u{2F38}",
        nfd: "\u{2F38}",
        nfkc: "\u{5F13}",
        nfkd: "\u{5F13}",
    },
    NormalizationTest {
        source: "\u{2F39}",
        nfc: "\u{2F39}",
        nfd: "\u{2F39}",
        nfkc: "\u{5F50}",
        nfkd: "\u{5F50}",
    },
    NormalizationTest {
        source: "\u{2F3A}",
        nfc: "\u{2F3A}",
        nfd: "\u{2F3A}",
        nfkc: "\u{5F61}",
        nfkd: "\u{5F61}",
    },
    NormalizationTest {
        source: "\u{2F3B}",
        nfc: "\u{2F3B}",
        nfd: "\u{2F3B}",
        nfkc: "\u{5F73}",
        nfkd: "\u{5F73}",
    },
    NormalizationTest {
        source: "\u{2F3C}",
        nfc: "\u{2F3C}",
        nfd: "\u{2F3C}",
        nfkc: "\u{5FC3}",
        nfkd: "\u{5FC3}",
    },
    NormalizationTest {
        source: "\u{2F3D}",
        nfc: "\u{2F3D}",
        nfd: "\u{2F3D}",
        nfkc: "\u{6208}",
        nfkd: "\u{6208}",
    },
    NormalizationTest {
        source: "\u{2F3E}",
        nfc: "\u{2F3E}",
        nfd: "\u{2F3E}",
        nfkc: "\u{6236}",
        nfkd: "\u{6236}",
    },
    NormalizationTest {
        source: "\u{2F3F}",
        nfc: "\u{2F3F}",
        nfd: "\u{2F3F}",
        nfkc: "\u{624B}",
        nfkd: "\u{624B}",
    },
    NormalizationTest {
        source: "\u{2F40}",
        nfc: "\u{2F40}",
        nfd: "\u{2F40}",
        nfkc: "\u{652F}",
        nfkd: "\u{652F}",
    },
    NormalizationTest {
        source: "\u{2F41}",
        nfc: "\u{2F41}",
        nfd: "\u{2F41}",
        nfkc: "\u{6534}",
        nfkd: "\u{6534}",
    },
    NormalizationTest {
        source: "\u{2F42}",
        nfc: "\u{2F42}",
        nfd: "\u{2F42}",
        nfkc: "\u{6587}",
        nfkd: "\u{6587}",
    },
    NormalizationTest {
        source: "\u{2F43}",
        nfc: "\u{2F43}",
        nfd: "\u{2F43}",
        nfkc: "\u{6597}",
        nfkd: "\u{6597}",
    },
    NormalizationTest {
        source: "\u{2F44}",
        nfc: "\u{2F44}",
        nfd: "\u{2F44}",
        nfkc: "\u{65A4}",
        nfkd: "\u{65A4}",
    },
    NormalizationTest {
        source: "\u{2F45}",
        nfc: "\u{2F45}",
        nfd: "\u{2F45}",
        nfkc: "\u{65B9}",
        nfkd: "\u{65B9}",
    },
    NormalizationTest {
        source: "\u{2F46}",
        nfc: "\u{2F46}",
        nfd: "\u{2F46}",
        nfkc: "\u{65E0}",
        nfkd: "\u{65E0}",
    },
    NormalizationTest {
        source: "\u{2F47}",
        nfc: "\u{2F47}",
        nfd: "\u{2F47}",
        nfkc: "\u{65E5}",
        nfkd: "\u{65E5}",
    },
    NormalizationTest {
        source: "\u{2F48}",
        nfc: "\u{2F48}",
        nfd: "\u{2F48}",
        nfkc: "\u{66F0}",
        nfkd: "\u{66F0}",
    },
    NormalizationTest {
        source: "\u{2F49}",
        nfc: "\u{2F49}",
        nfd: "\u{2F49}",
        nfkc: "\u{6708}",
        nfkd: "\u{6708}",
    },
    NormalizationTest {
        source: "\u{2F4A}",
        nfc: "\u{2F4A}",
        nfd: "\u{2F4A}",
        nfkc: "\u{6728}",
        nfkd: "\u{6728}",
    },
    NormalizationTest {
        source: "\u{2F4B}",
        nfc: "\u{2F4B}",
        nfd: "\u{2F4B}",
        nfkc: "\u{6B20}",
        nfkd: "\u{6B20}",
    },
    NormalizationTest {
        source: "\u{2F4C}",
        nfc: "\u{2F4C}",
        nfd: "\u{2F4C}",
        nfkc: "\u{6B62}",
        nfkd: "\u{6B62}",
    },
    NormalizationTest {
        source: "\u{2F4D}",
        nfc: "\u{2F4D}",
        nfd: "\u{2F4D}",
        nfkc: "\u{6B79}",
        nfkd: "\u{6B79}",
    },
    NormalizationTest {
        source: "\u{2F4E}",
        nfc: "\u{2F4E}",
        nfd: "\u{2F4E}",
        nfkc: "\u{6BB3}",
        nfkd: "\u{6BB3}",
    },
    NormalizationTest {
        source: "\u{2F4F}",
        nfc: "\u{2F4F}",
        nfd: "\u{2F4F}",
        nfkc: "\u{6BCB}",
        nfkd: "\u{6BCB}",
    },
    NormalizationTest {
        source: "\u{2F50}",
        nfc: "\u{2F50}",
        nfd: "\u{2F50}",
        nfkc: "\u{6BD4}",
        nfkd: "\u{6BD4}",
    },
    NormalizationTest {
        source: "\u{2F51}",
        nfc: "\u{2F51}",
        nfd: "\u{2F51}",
        nfkc: "\u{6BDB}",
        nfkd: "\u{6BDB}",
    },
    NormalizationTest {
        source: "\u{2F52}",
        nfc: "\u{2F52}",
        nfd: "\u{2F52}",
        nfkc: "\u{6C0F}",
        nfkd: "\u{6C0F}",
    },
    NormalizationTest {
        source: "\u{2F53}",
        nfc: "\u{2F53}",
        nfd: "\u{2F53}",
        nfkc: "\u{6C14}",
        nfkd: "\u{6C14}",
    },
    NormalizationTest {
        source: "\u{2F54}",
        nfc: "\u{2F54}",
        nfd: "\u{2F54}",
        nfkc: "\u{6C34}",
        nfkd: "\u{6C34}",
    },
    NormalizationTest {
        source: "\u{2F55}",
        nfc: "\u{2F55}",
        nfd: "\u{2F55}",
        nfkc: "\u{706B}",
        nfkd: "\u{706B}",
    },
    NormalizationTest {
        source: "\u{2F56}",
        nfc: "\u{2F56}",
        nfd: "\u{2F56}",
        nfkc: "\u{722A}",
        nfkd: "\u{722A}",
    },
    NormalizationTest {
        source: "\u{2F57}",
        nfc: "\u{2F57}",
        nfd: "\u{2F57}",
        nfkc: "\u{7236}",
        nfkd: "\u{7236}",
    },
    NormalizationTest {
        source: "\u{2F58}",
        nfc: "\u{2F58}",
        nfd: "\u{2F58}",
        nfkc: "\u{723B}",
        nfkd: "\u{723B}",
    },
    NormalizationTest {
        source: "\u{2F59}",
        nfc: "\u{2F59}",
        nfd: "\u{2F59}",
        nfkc: "\u{723F}",
        nfkd: "\u{723F}",
    },
    NormalizationTest {
        source: "\u{2F5A}",
        nfc: "\u{2F5A}",
        nfd: "\u{2F5A}",
        nfkc: "\u{7247}",
        nfkd: "\u{7247}",
    },
    NormalizationTest {
        source: "\u{2F5B}",
        nfc: "\u{2F5B}",
        nfd: "\u{2F5B}",
        nfkc: "\u{7259}",
        nfkd: "\u{7259}",
    },
    NormalizationTest {
        source: "\u{2F5C}",
        nfc: "\u{2F5C}",
        nfd: "\u{2F5C}",
        nfkc: "\u{725B}",
        nfkd: "\u{725B}",
    },
    NormalizationTest {
        source: "\u{2F5D}",
        nfc: "\u{2F5D}",
        nfd: "\u{2F5D}",
        nfkc: "\u{72AC}",
        nfkd: "\u{72AC}",
    },
    NormalizationTest {
        source: "\u{2F5E}",
        nfc: "\u{2F5E}",
        nfd: "\u{2F5E}",
        nfkc: "\u{7384}",
        nfkd: "\u{7384}",
    },
    NormalizationTest {
        source: "\u{2F5F}",
        nfc: "\u{2F5F}",
        nfd: "\u{2F5F}",
        nfkc: "\u{7389}",
        nfkd: "\u{7389}",
    },
    NormalizationTest {
        source: "\u{2F60}",
        nfc: "\u{2F60}",
        nfd: "\u{2F60}",
        nfkc: "\u{74DC}",
        nfkd: "\u{74DC}",
    },
    NormalizationTest {
        source: "\u{2F61}",
        nfc: "\u{2F61}",
        nfd: "\u{2F61}",
        nfkc: "\u{74E6}",
        nfkd: "\u{74E6}",
    },
    NormalizationTest {
        source: "\u{2F62}",
        nfc: "\u{2F62}",
        nfd: "\u{2F62}",
        nfkc: "\u{7518}",
        nfkd: "\u{7518}",
    },
    NormalizationTest {
        source: "\u{2F63}",
        nfc: "\u{2F63}",
        nfd: "\u{2F63}",
        nfkc: "\u{751F}",
        nfkd: "\u{751F}",
    },
    NormalizationTest {
        source: "\u{2F64}",
        nfc: "\u{2F64}",
        nfd: "\u{2F64}",
        nfkc: "\u{7528}",
        nfkd: "\u{7528}",
    },
    NormalizationTest {
        source: "\u{2F65}",
        nfc: "\u{2F65}",
        nfd: "\u{2F65}",
        nfkc: "\u{7530}",
        nfkd: "\u{7530}",
    },
    NormalizationTest {
        source: "\u{2F66}",
        nfc: "\u{2F66}",
        nfd: "\u{2F66}",
        nfkc: "\u{758B}",
        nfkd: "\u{758B}",
    },
    NormalizationTest {
        source: "\u{2F67}",
        nfc: "\u{2F67}",
        nfd: "\u{2F67}",
        nfkc: "\u{7592}",
        nfkd: "\u{7592}",
    },
    NormalizationTest {
        source: "\u{2F68}",
        nfc: "\u{2F68}",
        nfd: "\u{2F68}",
        nfkc: "\u{7676}",
        nfkd: "\u{7676}",
    },
    NormalizationTest {
        source: "\u{2F69}",
        nfc: "\u{2F69}",
        nfd: "\u{2F69}",
        nfkc: "\u{767D}",
        nfkd: "\u{767D}",
    },
    NormalizationTest {
        source: "\u{2F6A}",
        nfc: "\u{2F6A}",
        nfd: "\u{2F6A}",
        nfkc: "\u{76AE}",
        nfkd: "\u{76AE}",
    },
    NormalizationTest {
        source: "\u{2F6B}",
        nfc: "\u{2F6B}",
        nfd: "\u{2F6B}",
        nfkc: "\u{76BF}",
        nfkd: "\u{76BF}",
    },
    NormalizationTest {
        source: "\u{2F6C}",
        nfc: "\u{2F6C}",
        nfd: "\u{2F6C}",
        nfkc: "\u{76EE}",
        nfkd: "\u{76EE}",
    },
    NormalizationTest {
        source: "\u{2F6D}",
        nfc: "\u{2F6D}",
        nfd: "\u{2F6D}",
        nfkc: "\u{77DB}",
        nfkd: "\u{77DB}",
    },
    NormalizationTest {
        source: "\u{2F6E}",
        nfc: "\u{2F6E}",
        nfd: "\u{2F6E}",
        nfkc: "\u{77E2}",
        nfkd: "\u{77E2}",
    },
    NormalizationTest {
        source: "\u{2F6F}",
        nfc: "\u{2F6F}",
        nfd: "\u{2F6F}",
        nfkc: "\u{77F3}",
        nfkd: "\u{77F3}",
    },
    NormalizationTest {
        source: "\u{2F70}",
        nfc: "\u{2F70}",
        nfd: "\u{2F70}",
        nfkc: "\u{793A}",
        nfkd: "\u{793A}",
    },
    NormalizationTest {
        source: "\u{2F71}",
        nfc: "\u{2F71}",
        nfd: "\u{2F71}",
        nfkc: "\u{79B8}",
        nfkd: "\u{79B8}",
    },
    NormalizationTest {
        source: "\u{2F72}",
        nfc: "\u{2F72}",
        nfd: "\u{2F72}",
        nfkc: "\u{79BE}",
        nfkd: "\u{79BE}",
    },
    NormalizationTest {
        source: "\u{2F73}",
        nfc: "\u{2F73}",
        nfd: "\u{2F73}",
        nfkc: "\u{7A74}",
        nfkd: "\u{7A74}",
    },
    NormalizationTest {
        source: "\u{2F74}",
        nfc: "\u{2F74}",
        nfd: "\u{2F74}",
        nfkc: "\u{7ACB}",
        nfkd: "\u{7ACB}",
    },
    NormalizationTest {
        source: "\u{2F75}",
        nfc: "\u{2F75}",
        nfd: "\u{2F75}",
        nfkc: "\u{7AF9}",
        nfkd: "\u{7AF9}",
    },
    NormalizationTest {
        source: "\u{2F76}",
        nfc: "\u{2F76}",
        nfd: "\u{2F76}",
        nfkc: "\u{7C73}",
        nfkd: "\u{7C73}",
    },
    NormalizationTest {
        source: "\u{2F77}",
        nfc: "\u{2F77}",
        nfd: "\u{2F77}",
        nfkc: "\u{7CF8}",
        nfkd: "\u{7CF8}",
    },
    NormalizationTest {
        source: "\u{2F78}",
        nfc: "\u{2F78}",
        nfd: "\u{2F78}",
        nfkc: "\u{7F36}",
        nfkd: "\u{7F36}",
    },
    NormalizationTest {
        source: "\u{2F79}",
        nfc: "\u{2F79}",
        nfd: "\u{2F79}",
        nfkc: "\u{7F51}",
        nfkd: "\u{7F51}",
    },
    NormalizationTest {
        source: "\u{2F7A}",
        nfc: "\u{2F7A}",
        nfd: "\u{2F7A}",
        nfkc: "\u{7F8A}",
        nfkd: "\u{7F8A}",
    },
    NormalizationTest {
        source: "\u{2F7B}",
        nfc: "\u{2F7B}",
        nfd: "\u{2F7B}",
        nfkc: "\u{7FBD}",
        nfkd: "\u{7FBD}",
    },
    NormalizationTest {
        source: "\u{2F7C}",
        nfc: "\u{2F7C}",
        nfd: "\u{2F7C}",
        nfkc: "\u{8001}",
        nfkd: "\u{8001}",
    },
    NormalizationTest {
        source: "\u{2F7D}",
        nfc: "\u{2F7D}",
        nfd: "\u{2F7D}",
        nfkc: "\u{800C}",
        nfkd: "\u{800C}",
    },
    NormalizationTest {
        source: "\u{2F7E}",
        nfc: "\u{2F7E}",
        nfd: "\u{2F7E}",
        nfkc: "\u{8012}",
        nfkd: "\u{8012}",
    },
    NormalizationTest {
        source: "\u{2F7F}",
        nfc: "\u{2F7F}",
        nfd: "\u{2F7F}",
        nfkc: "\u{8033}",
        nfkd: "\u{8033}",
    },
    NormalizationTest {
        source: "\u{2F80}",
        nfc: "\u{2F80}",
        nfd: "\u{2F80}",
        nfkc: "\u{807F}",
        nfkd: "\u{807F}",
    },
    NormalizationTest {
        source: "\u{2F81}",
        nfc: "\u{2F81}",
        nfd: "\u{2F81}",
        nfkc: "\u{8089}",
        nfkd: "\u{8089}",
    },
    NormalizationTest {
        source: "\u{2F82}",
        nfc: "\u{2F82}",
        nfd: "\u{2F82}",
        nfkc: "\u{81E3}",
        nfkd: "\u{81E3}",
    },
    NormalizationTest {
        source: "\u{2F83}",
        nfc: "\u{2F83}",
        nfd: "\u{2F83}",
        nfkc: "\u{81EA}",
        nfkd: "\u{81EA}",
    },
    NormalizationTest {
        source: "\u{2F84}",
        nfc: "\u{2F84}",
        nfd: "\u{2F84}",
        nfkc: "\u{81F3}",
        nfkd: "\u{81F3}",
    },
    NormalizationTest {
        source: "\u{2F85}",
        nfc: "\u{2F85}",
        nfd: "\u{2F85}",
        nfkc: "\u{81FC}",
        nfkd: "\u{81FC}",
    },
    NormalizationTest {
        source: "\u{2F86}",
        nfc: "\u{2F86}",
        nfd: "\u{2F86}",
        nfkc: "\u{820C}",
        nfkd: "\u{820C}",
    },
    NormalizationTest {
        source: "\u{2F87}",
        nfc: "\u{2F87}",
        nfd: "\u{2F87}",
        nfkc: "\u{821B}",
        nfkd: "\u{821B}",
    },
    NormalizationTest {
        source: "\u{2F88}",
        nfc: "\u{2F88}",
        nfd: "\u{2F88}",
        nfkc: "\u{821F}",
        nfkd: "\u{821F}",
    },
    NormalizationTest {
        source: "\u{2F89}",
        nfc: "\u{2F89}",
        nfd: "\u{2F89}",
        nfkc: "\u{826E}",
        nfkd: "\u{826E}",
    },
    NormalizationTest {
        source: "\u{2F8A}",
        nfc: "\u{2F8A}",
        nfd: "\u{2F8A}",
        nfkc: "\u{8272}",
        nfkd: "\u{8272}",
    },
    NormalizationTest {
        source: "\u{2F8B}",
        nfc: "\u{2F8B}",
        nfd: "\u{2F8B}",
        nfkc: "\u{8278}",
        nfkd: "\u{8278}",
    },
    NormalizationTest {
        source: "\u{2F8C}",
        nfc: "\u{2F8C}",
        nfd: "\u{2F8C}",
        nfkc: "\u{864D}",
        nfkd: "\u{864D}",
    },
    NormalizationTest {
        source: "\u{2F8D}",
        nfc: "\u{2F8D}",
        nfd: "\u{2F8D}",
        nfkc: "\u{866B}",
        nfkd: "\u{866B}",
    },
    NormalizationTest {
        source: "\u{2F8E}",
        nfc: "\u{2F8E}",
        nfd: "\u{2F8E}",
        nfkc: "\u{8840}",
        nfkd: "\u{8840}",
    },
    NormalizationTest {
        source: "\u{2F8F}",
        nfc: "\u{2F8F}",
        nfd: "\u{2F8F}",
        nfkc: "\u{884C}",
        nfkd: "\u{884C}",
    },
    NormalizationTest {
        source: "\u{2F90}",
        nfc: "\u{2F90}",
        nfd: "\u{2F90}",
        nfkc: "\u{8863}",
        nfkd: "\u{8863}",
    },
    NormalizationTest {
        source: "\u{2F91}",
        nfc: "\u{2F91}",
        nfd: "\u{2F91}",
        nfkc: "\u{897E}",
        nfkd: "\u{897E}",
    },
    NormalizationTest {
        source: "\u{2F92}",
        nfc: "\u{2F92}",
        nfd: "\u{2F92}",
        nfkc: "\u{898B}",
        nfkd: "\u{898B}",
    },
    NormalizationTest {
        source: "\u{2F93}",
        nfc: "\u{2F93}",
        nfd: "\u{2F93}",
        nfkc: "\u{89D2}",
        nfkd: "\u{89D2}",
    },
    NormalizationTest {
        source: "\u{2F94}",
        nfc: "\u{2F94}",
        nfd: "\u{2F94}",
        nfkc: "\u{8A00}",
        nfkd: "\u{8A00}",
    },
    NormalizationTest {
        source: "\u{2F95}",
        nfc: "\u{2F95}",
        nfd: "\u{2F95}",
        nfkc: "\u{8C37}",
        nfkd: "\u{8C37}",
    },
    NormalizationTest {
        source: "\u{2F96}",
        nfc: "\u{2F96}",
        nfd: "\u{2F96}",
        nfkc: "\u{8C46}",
        nfkd: "\u{8C46}",
    },
    NormalizationTest {
        source: "\u{2F97}",
        nfc: "\u{2F97}",
        nfd: "\u{2F97}",
        nfkc: "\u{8C55}",
        nfkd: "\u{8C55}",
    },
    NormalizationTest {
        source: "\u{2F98}",
        nfc: "\u{2F98}",
        nfd: "\u{2F98}",
        nfkc: "\u{8C78}",
        nfkd: "\u{8C78}",
    },
    NormalizationTest {
        source: "\u{2F99}",
        nfc: "\u{2F99}",
        nfd: "\u{2F99}",
        nfkc: "\u{8C9D}",
        nfkd: "\u{8C9D}",
    },
    NormalizationTest {
        source: "\u{2F9A}",
        nfc: "\u{2F9A}",
        nfd: "\u{2F9A}",
        nfkc: "\u{8D64}",
        nfkd: "\u{8D64}",
    },
    NormalizationTest {
        source: "\u{2F9B}",
        nfc: "\u{2F9B}",
        nfd: "\u{2F9B}",
        nfkc: "\u{8D70}",
        nfkd: "\u{8D70}",
    },
    NormalizationTest {
        source: "\u{2F9C}",
        nfc: "\u{2F9C}",
        nfd: "\u{2F9C}",
        nfkc: "\u{8DB3}",
        nfkd: "\u{8DB3}",
    },
    NormalizationTest {
        source: "\u{2F9D}",
        nfc: "\u{2F9D}",
        nfd: "\u{2F9D}",
        nfkc: "\u{8EAB}",
        nfkd: "\u{8EAB}",
    },
    NormalizationTest {
        source: "\u{2F9E}",
        nfc: "\u{2F9E}",
        nfd: "\u{2F9E}",
        nfkc: "\u{8ECA}",
        nfkd: "\u{8ECA}",
    },
    NormalizationTest {
        source: "\u{2F9F}",
        nfc: "\u{2F9F}",
        nfd: "\u{2F9F}",
        nfkc: "\u{8F9B}",
        nfkd: "\u{8F9B}",
    },
    NormalizationTest {
        source: "\u{2FA0}",
        nfc: "\u{2FA0}",
        nfd: "\u{2FA0}",
        nfkc: "\u{8FB0}",
        nfkd: "\u{8FB0}",
    },
    NormalizationTest {
        source: "\u{2FA1}",
        nfc: "\u{2FA1}",
        nfd: "\u{2FA1}",
        nfkc: "\u{8FB5}",
        nfkd: "\u{8FB5}",
    },
    NormalizationTest {
        source: "\u{2FA2}",
        nfc: "\u{2FA2}",
        nfd: "\u{2FA2}",
        nfkc: "\u{9091}",
        nfkd: "\u{9091}",
    },
    NormalizationTest {
        source: "\u{2FA3}",
        nfc: "\u{2FA3}",
        nfd: "\u{2FA3}",
        nfkc: "\u{9149}",
        nfkd: "\u{9149}",
    },
    NormalizationTest {
        source: "\u{2FA4}",
        nfc: "\u{2FA4}",
        nfd: "\u{2FA4}",
        nfkc: "\u{91C6}",
        nfkd: "\u{91C6}",
    },
    NormalizationTest {
        source: "\u{2FA5}",
        nfc: "\u{2FA5}",
        nfd: "\u{2FA5}",
        nfkc: "\u{91CC}",
        nfkd: "\u{91CC}",
    },
    NormalizationTest {
        source: "\u{2FA6}",
        nfc: "\u{2FA6}",
        nfd: "\u{2FA6}",
        nfkc: "\u{91D1}",
        nfkd: "\u{91D1}",
    },
    NormalizationTest {
        source: "\u{2FA7}",
        nfc: "\u{2FA7}",
        nfd: "\u{2FA7}",
        nfkc: "\u{9577}",
        nfkd: "\u{9577}",
    },
    NormalizationTest {
        source: "\u{2FA8}",
        nfc: "\u{2FA8}",
        nfd: "\u{2FA8}",
        nfkc: "\u{9580}",
        nfkd: "\u{9580}",
    },
    NormalizationTest {
        source: "\u{2FA9}",
        nfc: "\u{2FA9}",
        nfd: "\u{2FA9}",
        nfkc: "\u{961C}",
        nfkd: "\u{961C}",
    },
    NormalizationTest {
        source: "\u{2FAA}",
        nfc: "\u{2FAA}",
        nfd: "\u{2FAA}",
        nfkc: "\u{96B6}",
        nfkd: "\u{96B6}",
    },
    NormalizationTest {
        source: "\u{2FAB}",
        nfc: "\u{2FAB}",
        nfd: "\u{2FAB}",
        nfkc: "\u{96B9}",
        nfkd: "\u{96B9}",
    },
    NormalizationTest {
        source: "\u{2FAC}",
        nfc: "\u{2FAC}",
        nfd: "\u{2FAC}",
        nfkc: "\u{96E8}",
        nfkd: "\u{96E8}",
    },
    NormalizationTest {
        source: "\u{2FAD}",
        nfc: "\u{2FAD}",
        nfd: "\u{2FAD}",
        nfkc: "\u{9751}",
        nfkd: "\u{9751}",
    },
    NormalizationTest {
        source: "\u{2FAE}",
        nfc: "\u{2FAE}",
        nfd: "\u{2FAE}",
        nfkc: "\u{975E}",
        nfkd: "\u{975E}",
    },
    NormalizationTest {
        source: "\u{2FAF}",
        nfc: "\u{2FAF}",
        nfd: "\u{2FAF}",
        nfkc: "\u{9762}",
        nfkd: "\u{9762}",
    },
    NormalizationTest {
        source: "\u{2FB0}",
        nfc: "\u{2FB0}",
        nfd: "\u{2FB0}",
        nfkc: "\u{9769}",
        nfkd: "\u{9769}",
    },
    NormalizationTest {
        source: "\u{2FB1}",
        nfc: "\u{2FB1}",
        nfd: "\u{2FB1}",
        nfkc: "\u{97CB}",
        nfkd: "\u{97CB}",
    },
    NormalizationTest {
        source: "\u{2FB2}",
        nfc: "\u{2FB2}",
        nfd: "\u{2FB2}",
        nfkc: "\u{97ED}",
        nfkd: "\u{97ED}",
    },
    NormalizationTest {
        source: "\u{2FB3}",
        nfc: "\u{2FB3}",
        nfd: "\u{2FB3}",
        nfkc: "\u{97F3}",
        nfkd: "\u{97F3}",
    },
    NormalizationTest {
        source: "\u{2FB4}",
        nfc: "\u{2FB4}",
        nfd: "\u{2FB4}",
        nfkc: "\u{9801}",
        nfkd: "\u{9801}",
    },
    NormalizationTest {
        source: "\u{2FB5}",
        nfc: "\u{2FB5}",
        nfd: "\u{2FB5}",
        nfkc: "\u{98A8}",
        nfkd: "\u{98A8}",
    },
    NormalizationTest {
        source: "\u{2FB6}",
        nfc: "\u{2FB6}",
        nfd: "\u{2FB6}",
        nfkc: "\u{98DB}",
        nfkd: "\u{98DB}",
    },
    NormalizationTest {
        source: "\u{2FB7}",
        nfc: "\u{2FB7}",
        nfd: "\u{2FB7}",
        nfkc: "\u{98DF}",
        nfkd: "\u{98DF}",
    },
    NormalizationTest {
        source: "\u{2FB8}",
        nfc: "\u{2FB8}",
        nfd: "\u{2FB8}",
        nfkc: "\u{9996}",
        nfkd: "\u{9996}",
    },
    NormalizationTest {
        source: "\u{2FB9}",
        nfc: "\u{2FB9}",
        nfd: "\u{2FB9}",
        nfkc: "\u{9999}",
        nfkd: "\u{9999}",
    },
    NormalizationTest {
        source: "\u{2FBA}",
        nfc: "\u{2FBA}",
        nfd: "\u{2FBA}",
        nfkc: "\u{99AC}",
        nfkd: "\u{99AC}",
    },
    NormalizationTest {
        source: "\u{2FBB}",
        nfc: "\u{2FBB}",
        nfd: "\u{2FBB}",
        nfkc: "\u{9AA8}",
        nfkd: "\u{9AA8}",
    },
    NormalizationTest {
        source: "\u{2FBC}",
        nfc: "\u{2FBC}",
        nfd: "\u{2FBC}",
        nfkc: "\u{9AD8}",
        nfkd: "\u{9AD8}",
    },
    NormalizationTest {
        source: "\u{2FBD}",
        nfc: "\u{2FBD}",
        nfd: "\u{2FBD}",
        nfkc: "\u{9ADF}",
        nfkd: "\u{9ADF}",
    },
    NormalizationTest {
        source: "\u{2FBE}",
        nfc: "\u{2FBE}",
        nfd: "\u{2FBE}",
        nfkc: "\u{9B25}",
        nfkd: "\u{9B25}",
    },
    NormalizationTest {
        source: "\u{2FBF}",
        nfc: "\u{2FBF}",
        nfd: "\u{2FBF}",
        nfkc: "\u{9B2F}",
        nfkd: "\u{9B2F}",
    },
    NormalizationTest {
        source: "\u{2FC0}",
        nfc: "\u{2FC0}",
        nfd: "\u{2FC0}",
        nfkc: "\u{9B32}",
        nfkd: "\u{9B32}",
    },
    NormalizationTest {
        source: "\u{2FC1}",
        nfc: "\u{2FC1}",
        nfd: "\u{2FC1}",
        nfkc: "\u{9B3C}",
        nfkd: "\u{9B3C}",
    },
    NormalizationTest {
        source: "\u{2FC2}",
        nfc: "\u{2FC2}",
        nfd: "\u{2FC2}",
        nfkc: "\u{9B5A}",
        nfkd: "\u{9B5A}",
    },
    NormalizationTest {
        source: "\u{2FC3}",
        nfc: "\u{2FC3}",
        nfd: "\u{2FC3}",
        nfkc: "\u{9CE5}",
        nfkd: "\u{9CE5}",
    },
    NormalizationTest {
        source: "\u{2FC4}",
        nfc: "\u{2FC4}",
        nfd: "\u{2FC4}",
        nfkc: "\u{9E75}",
        nfkd: "\u{9E75}",
    },
    NormalizationTest {
        source: "\u{2FC5}",
        nfc: "\u{2FC5}",
        nfd: "\u{2FC5}",
        nfkc: "\u{9E7F}",
        nfkd: "\u{9E7F}",
    },
    NormalizationTest {
        source: "\u{2FC6}",
        nfc: "\u{2FC6}",
        nfd: "\u{2FC6}",
        nfkc: "\u{9EA5}",
        nfkd: "\u{9EA5}",
    },
    NormalizationTest {
        source: "\u{2FC7}",
        nfc: "\u{2FC7}",
        nfd: "\u{2FC7}",
        nfkc: "\u{9EBB}",
        nfkd: "\u{9EBB}",
    },
    NormalizationTest {
        source: "\u{2FC8}",
        nfc: "\u{2FC8}",
        nfd: "\u{2FC8}",
        nfkc: "\u{9EC3}",
        nfkd: "\u{9EC3}",
    },
    NormalizationTest {
        source: "\u{2FC9}",
        nfc: "\u{2FC9}",
        nfd: "\u{2FC9}",
        nfkc: "\u{9ECD}",
        nfkd: "\u{9ECD}",
    },
    NormalizationTest {
        source: "\u{2FCA}",
        nfc: "\u{2FCA}",
        nfd: "\u{2FCA}",
        nfkc: "\u{9ED1}",
        nfkd: "\u{9ED1}",
    },
    NormalizationTest {
        source: "\u{2FCB}",
        nfc: "\u{2FCB}",
        nfd: "\u{2FCB}",
        nfkc: "\u{9EF9}",
        nfkd: "\u{9EF9}",
    },
    NormalizationTest {
        source: "\u{2FCC}",
        nfc: "\u{2FCC}",
        nfd: "\u{2FCC}",
        nfkc: "\u{9EFD}",
        nfkd: "\u{9EFD}",
    },
    NormalizationTest {
        source: "\u{2FCD}",
        nfc: "\u{2FCD}",
        nfd: "\u{2FCD}",
        nfkc: "\u{9F0E}",
        nfkd: "\u{9F0E}",
    },
    NormalizationTest {
        source: "\u{2FCE}",
        nfc: "\u{2FCE}",
        nfd: "\u{2FCE}",
        nfkc: "\u{9F13}",
        nfkd: "\u{9F13}",
    },
    NormalizationTest {
        source: "\u{2FCF}",
        nfc: "\u{2FCF}",
        nfd: "\u{2FCF}",
        nfkc: "\u{9F20}",
        nfkd: "\u{9F20}",
    },
    NormalizationTest {
        source: "\u{2FD0}",
        nfc: "\u{2FD0}",
        nfd: "\u{2FD0}",
        nfkc: "\u{9F3B}",
        nfkd: "\u{9F3B}",
    },
    NormalizationTest {
        source: "\u{2FD1}",
        nfc: "\u{2FD1}",
        nfd: "\u{2FD1}",
        nfkc: "\u{9F4A}",
        nfkd: "\u{9F4A}",
    },
    NormalizationTest {
        source: "\u{2FD2}",
        nfc: "\u{2FD2}",
        nfd: "\u{2FD2}",
        nfkc: "\u{9F52}",
        nfkd: "\u{9F52}",
    },
    NormalizationTest {
        source: "\u{2FD3}",
        nfc: "\u{2FD3}",
        nfd: "\u{2FD3}",
        nfkc: "\u{9F8D}",
        nfkd: "\u{9F8D}",
    },
    NormalizationTest {
        source: "\u{2FD4}",
        nfc: "\u{2FD4}",
        nfd: "\u{2FD4}",
        nfkc: "\u{9F9C}",
        nfkd: "\u{9F9C}",
    },
    NormalizationTest {
        source: "\u{2FD5}",
        nfc: "\u{2FD5}",
        nfd: "\u{2FD5}",
        nfkc: "\u{9FA0}",
        nfkd: "\u{9FA0}",
    },
    NormalizationTest {
        source: "\u{3000}",
        nfc: "\u{3000}",
        nfd: "\u{3000}",
        nfkc: "\u{0020}",
        nfkd: "\u{0020}",
    },
    NormalizationTest {
        source: "\u{3036}",
        nfc: "\u{3036}",
        nfd: "\u{3036}",
        nfkc: "\u{3012}",
        nfkd: "\u{3012}",
    },
    NormalizationTest {
        source: "\u{3038}",
        nfc: "\u{3038}",
        nfd: "\u{3038}",
        nfkc: "\u{5341}",
        nfkd: "\u{5341}",
    },
    NormalizationTest {
        source: "\u{3039}",
        nfc: "\u{3039}",
        nfd: "\u{3039}",
        nfkc: "\u{5344}",
        nfkd: "\u{5344}",
    },
    NormalizationTest {
        source: "\u{303A}",
        nfc: "\u{303A}",
        nfd: "\u{303A}",
        nfkc: "\u{5345}",
        nfkd: "\u{5345}",
    },
    NormalizationTest {
        source: "\u{304C}",
        nfc: "\u{304C}",
        nfd: "\u{304B}\u{3099}",
        nfkc: "\u{304C}",
        nfkd: "\u{304B}\u{3099}",
    },
    NormalizationTest {
        source: "\u{304E}",
        nfc: "\u{304E}",
        nfd: "\u{304D}\u{3099}",
        nfkc: "\u{304E}",
        nfkd: "\u{304D}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3050}",
        nfc: "\u{3050}",
        nfd: "\u{304F}\u{3099}",
        nfkc: "\u{3050}",
        nfkd: "\u{304F}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3052}",
        nfc: "\u{3052}",
        nfd: "\u{3051}\u{3099}",
        nfkc: "\u{3052}",
        nfkd: "\u{3051}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3054}",
        nfc: "\u{3054}",
        nfd: "\u{3053}\u{3099}",
        nfkc: "\u{3054}",
        nfkd: "\u{3053}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3056}",
        nfc: "\u{3056}",
        nfd: "\u{3055}\u{3099}",
        nfkc: "\u{3056}",
        nfkd: "\u{3055}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3058}",
        nfc: "\u{3058}",
        nfd: "\u{3057}\u{3099}",
        nfkc: "\u{3058}",
        nfkd: "\u{3057}\u{3099}",
    },
    NormalizationTest {
        source: "\u{305A}",
        nfc: "\u{305A}",
        nfd: "\u{3059}\u{3099}",
        nfkc: "\u{305A}",
        nfkd: "\u{3059}\u{3099}",
    },
    NormalizationTest {
        source: "\u{305C}",
        nfc: "\u{305C}",
        nfd: "\u{305B}\u{3099}",
        nfkc: "\u{305C}",
        nfkd: "\u{305B}\u{3099}",
    },
    NormalizationTest {
        source: "\u{305E}",
        nfc: "\u{305E}",
        nfd: "\u{305D}\u{3099}",
        nfkc: "\u{305E}",
        nfkd: "\u{305D}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3060}",
        nfc: "\u{3060}",
        nfd: "\u{305F}\u{3099}",
        nfkc: "\u{3060}",
        nfkd: "\u{305F}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3062}",
        nfc: "\u{3062}",
        nfd: "\u{3061}\u{3099}",
        nfkc: "\u{3062}",
        nfkd: "\u{3061}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3065}",
        nfc: "\u{3065}",
        nfd: "\u{3064}\u{3099}",
        nfkc: "\u{3065}",
        nfkd: "\u{3064}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3067}",
        nfc: "\u{3067}",
        nfd: "\u{3066}\u{3099}",
        nfkc: "\u{3067}",
        nfkd: "\u{3066}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3069}",
        nfc: "\u{3069}",
        nfd: "\u{3068}\u{3099}",
        nfkc: "\u{3069}",
        nfkd: "\u{3068}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3070}",
        nfc: "\u{3070}",
        nfd: "\u{306F}\u{3099}",
        nfkc: "\u{3070}",
        nfkd: "\u{306F}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3071}",
        nfc: "\u{3071}",
        nfd: "\u{306F}\u{309A}",
        nfkc: "\u{3071}",
        nfkd: "\u{306F}\u{309A}",
    },
    NormalizationTest {
        source: "\u{3073}",
        nfc: "\u{3073}",
        nfd: "\u{3072}\u{3099}",
        nfkc: "\u{3073}",
        nfkd: "\u{3072}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3074}",
        nfc: "\u{3074}",
        nfd: "\u{3072}\u{309A}",
        nfkc: "\u{3074}",
        nfkd: "\u{3072}\u{309A}",
    },
    NormalizationTest {
        source: "\u{3076}",
        nfc: "\u{3076}",
        nfd: "\u{3075}\u{3099}",
        nfkc: "\u{3076}",
        nfkd: "\u{3075}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3077}",
        nfc: "\u{3077}",
        nfd: "\u{3075}\u{309A}",
        nfkc: "\u{3077}",
        nfkd: "\u{3075}\u{309A}",
    },
    NormalizationTest {
        source: "\u{3079}",
        nfc: "\u{3079}",
        nfd: "\u{3078}\u{3099}",
        nfkc: "\u{3079}",
        nfkd: "\u{3078}\u{3099}",
    },
    NormalizationTest {
        source: "\u{307A}",
        nfc: "\u{307A}",
        nfd: "\u{3078}\u{309A}",
        nfkc: "\u{307A}",
        nfkd: "\u{3078}\u{309A}",
    },
    NormalizationTest {
        source: "\u{307C}",
        nfc: "\u{307C}",
        nfd: "\u{307B}\u{3099}",
        nfkc: "\u{307C}",
        nfkd: "\u{307B}\u{3099}",
    },
    NormalizationTest {
        source: "\u{307D}",
        nfc: "\u{307D}",
        nfd: "\u{307B}\u{309A}",
        nfkc: "\u{307D}",
        nfkd: "\u{307B}\u{309A}",
    },
    NormalizationTest {
        source: "\u{3094}",
        nfc: "\u{3094}",
        nfd: "\u{3046}\u{3099}",
        nfkc: "\u{3094}",
        nfkd: "\u{3046}\u{3099}",
    },
    NormalizationTest {
        source: "\u{309B}",
        nfc: "\u{309B}",
        nfd: "\u{309B}",
        nfkc: "\u{0020}\u{3099}",
        nfkd: "\u{0020}\u{3099}",
    },
    NormalizationTest {
        source: "\u{309C}",
        nfc: "\u{309C}",
        nfd: "\u{309C}",
        nfkc: "\u{0020}\u{309A}",
        nfkd: "\u{0020}\u{309A}",
    },
    NormalizationTest {
        source: "\u{309E}",
        nfc: "\u{309E}",
        nfd: "\u{309D}\u{3099}",
        nfkc: "\u{309E}",
        nfkd: "\u{309D}\u{3099}",
    },
    NormalizationTest {
        source: "\u{309F}",
        nfc: "\u{309F}",
        nfd: "\u{309F}",
        nfkc: "\u{3088}\u{308A}",
        nfkd: "\u{3088}\u{308A}",
    },
    NormalizationTest {
        source: "\u{30AC}",
        nfc: "\u{30AC}",
        nfd: "\u{30AB}\u{3099}",
        nfkc: "\u{30AC}",
        nfkd: "\u{30AB}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30AE}",
        nfc: "\u{30AE}",
        nfd: "\u{30AD}\u{3099}",
        nfkc: "\u{30AE}",
        nfkd: "\u{30AD}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30B0}",
        nfc: "\u{30B0}",
        nfd: "\u{30AF}\u{3099}",
        nfkc: "\u{30B0}",
        nfkd: "\u{30AF}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30B2}",
        nfc: "\u{30B2}",
        nfd: "\u{30B1}\u{3099}",
        nfkc: "\u{30B2}",
        nfkd: "\u{30B1}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30B4}",
        nfc: "\u{30B4}",
        nfd: "\u{30B3}\u{3099}",
        nfkc: "\u{30B4}",
        nfkd: "\u{30B3}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30B6}",
        nfc: "\u{30B6}",
        nfd: "\u{30B5}\u{3099}",
        nfkc: "\u{30B6}",
        nfkd: "\u{30B5}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30B8}",
        nfc: "\u{30B8}",
        nfd: "\u{30B7}\u{3099}",
        nfkc: "\u{30B8}",
        nfkd: "\u{30B7}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30BA}",
        nfc: "\u{30BA}",
        nfd: "\u{30B9}\u{3099}",
        nfkc: "\u{30BA}",
        nfkd: "\u{30B9}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30BC}",
        nfc: "\u{30BC}",
        nfd: "\u{30BB}\u{3099}",
        nfkc: "\u{30BC}",
        nfkd: "\u{30BB}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30BE}",
        nfc: "\u{30BE}",
        nfd: "\u{30BD}\u{3099}",
        nfkc: "\u{30BE}",
        nfkd: "\u{30BD}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30C0}",
        nfc: "\u{30C0}",
        nfd: "\u{30BF}\u{3099}",
        nfkc: "\u{30C0}",
        nfkd: "\u{30BF}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30C2}",
        nfc: "\u{30C2}",
        nfd: "\u{30C1}\u{3099}",
        nfkc: "\u{30C2}",
        nfkd: "\u{30C1}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30C5}",
        nfc: "\u{30C5}",
        nfd: "\u{30C4}\u{3099}",
        nfkc: "\u{30C5}",
        nfkd: "\u{30C4}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30C7}",
        nfc: "\u{30C7}",
        nfd: "\u{30C6}\u{3099}",
        nfkc: "\u{30C7}",
        nfkd: "\u{30C6}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30C9}",
        nfc: "\u{30C9}",
        nfd: "\u{30C8}\u{3099}",
        nfkc: "\u{30C9}",
        nfkd: "\u{30C8}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30D0}",
        nfc: "\u{30D0}",
        nfd: "\u{30CF}\u{3099}",
        nfkc: "\u{30D0}",
        nfkd: "\u{30CF}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30D1}",
        nfc: "\u{30D1}",
        nfd: "\u{30CF}\u{309A}",
        nfkc: "\u{30D1}",
        nfkd: "\u{30CF}\u{309A}",
    },
    NormalizationTest {
        source: "\u{30D3}",
        nfc: "\u{30D3}",
        nfd: "\u{30D2}\u{3099}",
        nfkc: "\u{30D3}",
        nfkd: "\u{30D2}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30D4}",
        nfc: "\u{30D4}",
        nfd: "\u{30D2}\u{309A}",
        nfkc: "\u{30D4}",
        nfkd: "\u{30D2}\u{309A}",
    },
    NormalizationTest {
        source: "\u{30D6}",
        nfc: "\u{30D6}",
        nfd: "\u{30D5}\u{3099}",
        nfkc: "\u{30D6}",
        nfkd: "\u{30D5}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30D7}",
        nfc: "\u{30D7}",
        nfd: "\u{30D5}\u{309A}",
        nfkc: "\u{30D7}",
        nfkd: "\u{30D5}\u{309A}",
    },
    NormalizationTest {
        source: "\u{30D9}",
        nfc: "\u{30D9}",
        nfd: "\u{30D8}\u{3099}",
        nfkc: "\u{30D9}",
        nfkd: "\u{30D8}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30DA}",
        nfc: "\u{30DA}",
        nfd: "\u{30D8}\u{309A}",
        nfkc: "\u{30DA}",
        nfkd: "\u{30D8}\u{309A}",
    },
    NormalizationTest {
        source: "\u{30DC}",
        nfc: "\u{30DC}",
        nfd: "\u{30DB}\u{3099}",
        nfkc: "\u{30DC}",
        nfkd: "\u{30DB}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30DD}",
        nfc: "\u{30DD}",
        nfd: "\u{30DB}\u{309A}",
        nfkc: "\u{30DD}",
        nfkd: "\u{30DB}\u{309A}",
    },
    NormalizationTest {
        source: "\u{30F4}",
        nfc: "\u{30F4}",
        nfd: "\u{30A6}\u{3099}",
        nfkc: "\u{30F4}",
        nfkd: "\u{30A6}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30F7}",
        nfc: "\u{30F7}",
        nfd: "\u{30EF}\u{3099}",
        nfkc: "\u{30F7}",
        nfkd: "\u{30EF}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30F8}",
        nfc: "\u{30F8}",
        nfd: "\u{30F0}\u{3099}",
        nfkc: "\u{30F8}",
        nfkd: "\u{30F0}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30F9}",
        nfc: "\u{30F9}",
        nfd: "\u{30F1}\u{3099}",
        nfkc: "\u{30F9}",
        nfkd: "\u{30F1}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30FA}",
        nfc: "\u{30FA}",
        nfd: "\u{30F2}\u{3099}",
        nfkc: "\u{30FA}",
        nfkd: "\u{30F2}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30FE}",
        nfc: "\u{30FE}",
        nfd: "\u{30FD}\u{3099}",
        nfkc: "\u{30FE}",
        nfkd: "\u{30FD}\u{3099}",
    },
    NormalizationTest {
        source: "\u{30FF}",
        nfc: "\u{30FF}",
        nfd: "\u{30FF}",
        nfkc: "\u{30B3}\u{30C8}",
        nfkd: "\u{30B3}\u{30C8}",
    },
    NormalizationTest {
        source: "\u{3131}",
        nfc: "\u{3131}",
        nfd: "\u{3131}",
        nfkc: "\u{1100}",
        nfkd: "\u{1100}",
    },
    NormalizationTest {
        source: "\u{3132}",
        nfc: "\u{3132}",
        nfd: "\u{3132}",
        nfkc: "\u{1101}",
        nfkd: "\u{1101}",
    },
    NormalizationTest {
        source: "\u{3133}",
        nfc: "\u{3133}",
        nfd: "\u{3133}",
        nfkc: "\u{11AA}",
        nfkd: "\u{11AA}",
    },
    NormalizationTest {
        source: "\u{3134}",
        nfc: "\u{3134}",
        nfd: "\u{3134}",
        nfkc: "\u{1102}",
        nfkd: "\u{1102}",
    },
    NormalizationTest {
        source: "\u{3135}",
        nfc: "\u{3135}",
        nfd: "\u{3135}",
        nfkc: "\u{11AC}",
        nfkd: "\u{11AC}",
    },
    NormalizationTest {
        source: "\u{3136}",
        nfc: "\u{3136}",
        nfd: "\u{3136}",
        nfkc: "\u{11AD}",
        nfkd: "\u{11AD}",
    },
    NormalizationTest {
        source: "\u{3137}",
        nfc: "\u{3137}",
        nfd: "\u{3137}",
        nfkc: "\u{1103}",
        nfkd: "\u{1103}",
    },
    NormalizationTest {
        source: "\u{3138}",
        nfc: "\u{3138}",
        nfd: "\u{3138}",
        nfkc: "\u{1104}",
        nfkd: "\u{1104}",
    },
    NormalizationTest {
        source: "\u{3139}",
        nfc: "\u{3139}",
        nfd: "\u{3139}",
        nfkc: "\u{1105}",
        nfkd: "\u{1105}",
    },
    NormalizationTest {
        source: "\u{313A}",
        nfc: "\u{313A}",
        nfd: "\u{313A}",
        nfkc: "\u{11B0}",
        nfkd: "\u{11B0}",
    },
    NormalizationTest {
        source: "\u{313B}",
        nfc: "\u{313B}",
        nfd: "\u{313B}",
        nfkc: "\u{11B1}",
        nfkd: "\u{11B1}",
    },
    NormalizationTest {
        source: "\u{313C}",
        nfc: "\u{313C}",
        nfd: "\u{313C}",
        nfkc: "\u{11B2}",
        nfkd: "\u{11B2}",
    },
    NormalizationTest {
        source: "\u{313D}",
        nfc: "\u{313D}",
        nfd: "\u{313D}",
        nfkc: "\u{11B3}",
        nfkd: "\u{11B3}",
    },
    NormalizationTest {
        source: "\u{313E}",
        nfc: "\u{313E}",
        nfd: "\u{313E}",
        nfkc: "\u{11B4}",
        nfkd: "\u{11B4}",
    },
    NormalizationTest {
        source: "\u{313F}",
        nfc: "\u{313F}",
        nfd: "\u{313F}",
        nfkc: "\u{11B5}",
        nfkd: "\u{11B5}",
    },
    NormalizationTest {
        source: "\u{3140}",
        nfc: "\u{3140}",
        nfd: "\u{3140}",
        nfkc: "\u{111A}",
        nfkd: "\u{111A}",
    },
    NormalizationTest {
        source: "\u{3141}",
        nfc: "\u{3141}",
        nfd: "\u{3141}",
        nfkc: "\u{1106}",
        nfkd: "\u{1106}",
    },
    NormalizationTest {
        source: "\u{3142}",
        nfc: "\u{3142}",
        nfd: "\u{3142}",
        nfkc: "\u{1107}",
        nfkd: "\u{1107}",
    },
    NormalizationTest {
        source: "\u{3143}",
        nfc: "\u{3143}",
        nfd: "\u{3143}",
        nfkc: "\u{1108}",
        nfkd: "\u{1108}",
    },
    NormalizationTest {
        source: "\u{3144}",
        nfc: "\u{3144}",
        nfd: "\u{3144}",
        nfkc: "\u{1121}",
        nfkd: "\u{1121}",
    },
    NormalizationTest {
        source: "\u{3145}",
        nfc: "\u{3145}",
        nfd: "\u{3145}",
        nfkc: "\u{1109}",
        nfkd: "\u{1109}",
    },
    NormalizationTest {
        source: "\u{3146}",
        nfc: "\u{3146}",
        nfd: "\u{3146}",
        nfkc: "\u{110A}",
        nfkd: "\u{110A}",
    },
    NormalizationTest {
        source: "\u{3147}",
        nfc: "\u{3147}",
        nfd: "\u{3147}",
        nfkc: "\u{110B}",
        nfkd: "\u{110B}",
    },
    NormalizationTest {
        source: "\u{3148}",
        nfc: "\u{3148}",
        nfd: "\u{3148}",
        nfkc: "\u{110C}",
        nfkd: "\u{110C}",
    },
    NormalizationTest {
        source: "\u{3149}",
        nfc: "\u{3149}",
        nfd: "\u{3149}",
        nfkc: "\u{110D}",
        nfkd: "\u{110D}",
    },
    NormalizationTest {
        source: "\u{314A}",
        nfc: "\u{314A}",
        nfd: "\u{314A}",
        nfkc: "\u{110E}",
        nfkd: "\u{110E}",
    },
    NormalizationTest {
        source: "\u{314B}",
        nfc: "\u{314B}",
        nfd: "\u{314B}",
        nfkc: "\u{110F}",
        nfkd: "\u{110F}",
    },
    NormalizationTest {
        source: "\u{314C}",
        nfc: "\u{314C}",
        nfd: "\u{314C}",
        nfkc: "\u{1110}",
        nfkd: "\u{1110}",
    },
    NormalizationTest {
        source: "\u{314D}",
        nfc: "\u{314D}",
        nfd: "\u{314D}",
        nfkc: "\u{1111}",
        nfkd: "\u{1111}",
    },
    NormalizationTest {
        source: "\u{314E}",
        nfc: "\u{314E}",
        nfd: "\u{314E}",
        nfkc: "\u{1112}",
        nfkd: "\u{1112}",
    },
    NormalizationTest {
        source: "\u{314F}",
        nfc: "\u{314F}",
        nfd: "\u{314F}",
        nfkc: "\u{1161}",
        nfkd: "\u{1161}",
    },
    NormalizationTest {
        source: "\u{3150}",
        nfc: "\u{3150}",
        nfd: "\u{3150}",
        nfkc: "\u{1162}",
        nfkd: "\u{1162}",
    },
    NormalizationTest {
        source: "\u{3151}",
        nfc: "\u{3151}",
        nfd: "\u{3151}",
        nfkc: "\u{1163}",
        nfkd: "\u{1163}",
    },
    NormalizationTest {
        source: "\u{3152}",
        nfc: "\u{3152}",
        nfd: "\u{3152}",
        nfkc: "\u{1164}",
        nfkd: "\u{1164}",
    },
    NormalizationTest {
        source: "\u{3153}",
        nfc: "\u{3153}",
        nfd: "\u{3153}",
        nfkc: "\u{1165}",
        nfkd: "\u{1165}",
    },
    NormalizationTest {
        source: "\u{3154}",
        nfc: "\u{3154}",
        nfd: "\u{3154}",
        nfkc: "\u{1166}",
        nfkd: "\u{1166}",
    },
    NormalizationTest {
        source: "\u{3155}",
        nfc: "\u{3155}",
        nfd: "\u{3155}",
        nfkc: "\u{1167}",
        nfkd: "\u{1167}",
    },
    NormalizationTest {
        source: "\u{3156}",
        nfc: "\u{3156}",
        nfd: "\u{3156}",
        nfkc: "\u{1168}",
        nfkd: "\u{1168}",
    },
    NormalizationTest {
        source: "\u{3157}",
        nfc: "\u{3157}",
        nfd: "\u{3157}",
        nfkc: "\u{1169}",
        nfkd: "\u{1169}",
    },
    NormalizationTest {
        source: "\u{3158}",
        nfc: "\u{3158}",
        nfd: "\u{3158}",
        nfkc: "\u{116A}",
        nfkd: "\u{116A}",
    },
    NormalizationTest {
        source: "\u{3159}",
        nfc: "\u{3159}",
        nfd: "\u{3159}",
        nfkc: "\u{116B}",
        nfkd: "\u{116B}",
    },
    NormalizationTest {
        source: "\u{315A}",
        nfc: "\u{315A}",
        nfd: "\u{315A}",
        nfkc: "\u{116C}",
        nfkd: "\u{116C}",
    },
    NormalizationTest {
        source: "\u{315B}",
        nfc: "\u{315B}",
        nfd: "\u{315B}",
        nfkc: "\u{116D}",
        nfkd: "\u{116D}",
    },
    NormalizationTest {
        source: "\u{315C}",
        nfc: "\u{315C}",
        nfd: "\u{315C}",
        nfkc: "\u{116E}",
        nfkd: "\u{116E}",
    },
    NormalizationTest {
        source: "\u{315D}",
        nfc: "\u{315D}",
        nfd: "\u{315D}",
        nfkc: "\u{116F}",
        nfkd: "\u{116F}",
    },
    NormalizationTest {
        source: "\u{315E}",
        nfc: "\u{315E}",
        nfd: "\u{315E}",
        nfkc: "\u{1170}",
        nfkd: "\u{1170}",
    },
    NormalizationTest {
        source: "\u{315F}",
        nfc: "\u{315F}",
        nfd: "\u{315F}",
        nfkc: "\u{1171}",
        nfkd: "\u{1171}",
    },
    NormalizationTest {
        source: "\u{3160}",
        nfc: "\u{3160}",
        nfd: "\u{3160}",
        nfkc: "\u{1172}",
        nfkd: "\u{1172}",
    },
    NormalizationTest {
        source: "\u{3161}",
        nfc: "\u{3161}",
        nfd: "\u{3161}",
        nfkc: "\u{1173}",
        nfkd: "\u{1173}",
    },
    NormalizationTest {
        source: "\u{3162}",
        nfc: "\u{3162}",
        nfd: "\u{3162}",
        nfkc: "\u{1174}",
        nfkd: "\u{1174}",
    },
    NormalizationTest {
        source: "\u{3163}",
        nfc: "\u{3163}",
        nfd: "\u{3163}",
        nfkc: "\u{1175}",
        nfkd: "\u{1175}",
    },
    NormalizationTest {
        source: "\u{3164}",
        nfc: "\u{3164}",
        nfd: "\u{3164}",
        nfkc: "\u{1160}",
        nfkd: "\u{1160}",
    },
    NormalizationTest {
        source: "\u{3165}",
        nfc: "\u{3165}",
        nfd: "\u{3165}",
        nfkc: "\u{1114}",
        nfkd: "\u{1114}",
    },
    NormalizationTest {
        source: "\u{3166}",
        nfc: "\u{3166}",
        nfd: "\u{3166}",
        nfkc: "\u{1115}",
        nfkd: "\u{1115}",
    },
    NormalizationTest {
        source: "\u{3167}",
        nfc: "\u{3167}",
        nfd: "\u{3167}",
        nfkc: "\u{11C7}",
        nfkd: "\u{11C7}",
    },
    NormalizationTest {
        source: "\u{3168}",
        nfc: "\u{3168}",
        nfd: "\u{3168}",
        nfkc: "\u{11C8}",
        nfkd: "\u{11C8}",
    },
    NormalizationTest {
        source: "\u{3169}",
        nfc: "\u{3169}",
        nfd: "\u{3169}",
        nfkc: "\u{11CC}",
        nfkd: "\u{11CC}",
    },
    NormalizationTest {
        source: "\u{316A}",
        nfc: "\u{316A}",
        nfd: "\u{316A}",
        nfkc: "\u{11CE}",
        nfkd: "\u{11CE}",
    },
    NormalizationTest {
        source: "\u{316B}",
        nfc: "\u{316B}",
        nfd: "\u{316B}",
        nfkc: "\u{11D3}",
        nfkd: "\u{11D3}",
    },
    NormalizationTest {
        source: "\u{316C}",
        nfc: "\u{316C}",
        nfd: "\u{316C}",
        nfkc: "\u{11D7}",
        nfkd: "\u{11D7}",
    },
    NormalizationTest {
        source: "\u{316D}",
        nfc: "\u{316D}",
        nfd: "\u{316D}",
        nfkc: "\u{11D9}",
        nfkd: "\u{11D9}",
    },
    NormalizationTest {
        source: "\u{316E}",
        nfc: "\u{316E}",
        nfd: "\u{316E}",
        nfkc: "\u{111C}",
        nfkd: "\u{111C}",
    },
    NormalizationTest {
        source: "\u{316F}",
        nfc: "\u{316F}",
        nfd: "\u{316F}",
        nfkc: "\u{11DD}",
        nfkd: "\u{11DD}",
    },
    NormalizationTest {
        source: "\u{3170}",
        nfc: "\u{3170}",
        nfd: "\u{3170}",
        nfkc: "\u{11DF}",
        nfkd: "\u{11DF}",
    },
    NormalizationTest {
        source: "\u{3171}",
        nfc: "\u{3171}",
        nfd: "\u{3171}",
        nfkc: "\u{111D}",
        nfkd: "\u{111D}",
    },
    NormalizationTest {
        source: "\u{3172}",
        nfc: "\u{3172}",
        nfd: "\u{3172}",
        nfkc: "\u{111E}",
        nfkd: "\u{111E}",
    },
    NormalizationTest {
        source: "\u{3173}",
        nfc: "\u{3173}",
        nfd: "\u{3173}",
        nfkc: "\u{1120}",
        nfkd: "\u{1120}",
    },
    NormalizationTest {
        source: "\u{3174}",
        nfc: "\u{3174}",
        nfd: "\u{3174}",
        nfkc: "\u{1122}",
        nfkd: "\u{1122}",
    },
    NormalizationTest {
        source: "\u{3175}",
        nfc: "\u{3175}",
        nfd: "\u{3175}",
        nfkc: "\u{1123}",
        nfkd: "\u{1123}",
    },
    NormalizationTest {
        source: "\u{3176}",
        nfc: "\u{3176}",
        nfd: "\u{3176}",
        nfkc: "\u{1127}",
        nfkd: "\u{1127}",
    },
    NormalizationTest {
        source: "\u{3177}",
        nfc: "\u{3177}",
        nfd: "\u{3177}",
        nfkc: "\u{1129}",
        nfkd: "\u{1129}",
    },
    NormalizationTest {
        source: "\u{3178}",
        nfc: "\u{3178}",
        nfd: "\u{3178}",
        nfkc: "\u{112B}",
        nfkd: "\u{112B}",
    },
    NormalizationTest {
        source: "\u{3179}",
        nfc: "\u{3179}",
        nfd: "\u{3179}",
        nfkc: "\u{112C}",
        nfkd: "\u{112C}",
    },
    NormalizationTest {
        source: "\u{317A}",
        nfc: "\u{317A}",
        nfd: "\u{317A}",
        nfkc: "\u{112D}",
        nfkd: "\u{112D}",
    },
    NormalizationTest {
        source: "\u{317B}",
        nfc: "\u{317B}",
        nfd: "\u{317B}",
        nfkc: "\u{112E}",
        nfkd: "\u{112E}",
    },
    NormalizationTest {
        source: "\u{317C}",
        nfc: "\u{317C}",
        nfd: "\u{317C}",
        nfkc: "\u{112F}",
        nfkd: "\u{112F}",
    },
    NormalizationTest {
        source: "\u{317D}",
        nfc: "\u{317D}",
        nfd: "\u{317D}",
        nfkc: "\u{1132}",
        nfkd: "\u{1132}",
    },
    NormalizationTest {
        source: "\u{317E}",
        nfc: "\u{317E}",
        nfd: "\u{317E}",
        nfkc: "\u{1136}",
        nfkd: "\u{1136}",
    },
    NormalizationTest {
        source: "\u{317F}",
        nfc: "\u{317F}",
        nfd: "\u{317F}",
        nfkc: "\u{1140}",
        nfkd: "\u{1140}",
    },
    NormalizationTest {
        source: "\u{3180}",
        nfc: "\u{3180}",
        nfd: "\u{3180}",
        nfkc: "\u{1147}",
        nfkd: "\u{1147}",
    },
    NormalizationTest {
        source: "\u{3181}",
        nfc: "\u{3181}",
        nfd: "\u{3181}",
        nfkc: "\u{114C}",
        nfkd: "\u{114C}",
    },
    NormalizationTest {
        source: "\u{3182}",
        nfc: "\u{3182}",
        nfd: "\u{3182}",
        nfkc: "\u{11F1}",
        nfkd: "\u{11F1}",
    },
    NormalizationTest {
        source: "\u{3183}",
        nfc: "\u{3183}",
        nfd: "\u{3183}",
        nfkc: "\u{11F2}",
        nfkd: "\u{11F2}",
    },
    NormalizationTest {
        source: "\u{3184}",
        nfc: "\u{3184}",
        nfd: "\u{3184}",
        nfkc: "\u{1157}",
        nfkd: "\u{1157}",
    },
    NormalizationTest {
        source: "\u{3185}",
        nfc: "\u{3185}",
        nfd: "\u{3185}",
        nfkc: "\u{1158}",
        nfkd: "\u{1158}",
    },
    NormalizationTest {
        source: "\u{3186}",
        nfc: "\u{3186}",
        nfd: "\u{3186}",
        nfkc: "\u{1159}",
        nfkd: "\u{1159}",
    },
    NormalizationTest {
        source: "\u{3187}",
        nfc: "\u{3187}",
        nfd: "\u{3187}",
        nfkc: "\u{1184}",
        nfkd: "\u{1184}",
    },
    NormalizationTest {
        source: "\u{3188}",
        nfc: "\u{3188}",
        nfd: "\u{3188}",
        nfkc: "\u{1185}",
        nfkd: "\u{1185}",
    },
    NormalizationTest {
        source: "\u{3189}",
        nfc: "\u{3189}",
        nfd: "\u{3189}",
        nfkc: "\u{1188}",
        nfkd: "\u{1188}",
    },
    NormalizationTest {
        source: "\u{318A}",
        nfc: "\u{318A}",
        nfd: "\u{318A}",
        nfkc: "\u{1191}",
        nfkd: "\u{1191}",
    },
    NormalizationTest {
        source: "\u{318B}",
        nfc: "\u{318B}",
        nfd: "\u{318B}",
        nfkc: "\u{1192}",
        nfkd: "\u{1192}",
    },
    NormalizationTest {
        source: "\u{318C}",
        nfc: "\u{318C}",
        nfd: "\u{318C}",
        nfkc: "\u{1194}",
        nfkd: "\u{1194}",
    },
    NormalizationTest {
        source: "\u{318D}",
        nfc: "\u{318D}",
        nfd: "\u{318D}",
        nfkc: "\u{119E}",
        nfkd: "\u{119E}",
    },
    NormalizationTest {
        source: "\u{318E}",
        nfc: "\u{318E}",
        nfd: "\u{318E}",
        nfkc: "\u{11A1}",
        nfkd: "\u{11A1}",
    },
    NormalizationTest {
        source: "\u{3192}",
        nfc: "\u{3192}",
        nfd: "\u{3192}",
        nfkc: "\u{4E00}",
        nfkd: "\u{4E00}",
    },
    NormalizationTest {
        source: "\u{3193}",
        nfc: "\u{3193}",
        nfd: "\u{3193}",
        nfkc: "\u{4E8C}",
        nfkd: "\u{4E8C}",
    },
    NormalizationTest {
        source: "\u{3194}",
        nfc: "\u{3194}",
        nfd: "\u{3194}",
        nfkc: "\u{4E09}",
        nfkd: "\u{4E09}",
    },
    NormalizationTest {
        source: "\u{3195}",
        nfc: "\u{3195}",
        nfd: "\u{3195}",
        nfkc: "\u{56DB}",
        nfkd: "\u{56DB}",
    },
    NormalizationTest {
        source: "\u{3196}",
        nfc: "\u{3196}",
        nfd: "\u{3196}",
        nfkc: "\u{4E0A}",
        nfkd: "\u{4E0A}",
    },
    NormalizationTest {
        source: "\u{3197}",
        nfc: "\u{3197}",
        nfd: "\u{3197}",
        nfkc: "\u{4E2D}",
        nfkd: "\u{4E2D}",
    },
    NormalizationTest {
        source: "\u{3198}",
        nfc: "\u{3198}",
        nfd: "\u{3198}",
        nfkc: "\u{4E0B}",
        nfkd: "\u{4E0B}",
    },
    NormalizationTest {
        source: "\u{3199}",
        nfc: "\u{3199}",
        nfd: "\u{3199}",
        nfkc: "\u{7532}",
        nfkd: "\u{7532}",
    },
    NormalizationTest {
        source: "\u{319A}",
        nfc: "\u{319A}",
        nfd: "\u{319A}",
        nfkc: "\u{4E59}",
        nfkd: "\u{4E59}",
    },
    NormalizationTest {
        source: "\u{319B}",
        nfc: "\u{319B}",
        nfd: "\u{319B}",
        nfkc: "\u{4E19}",
        nfkd: "\u{4E19}",
    },
    NormalizationTest {
        source: "\u{319C}",
        nfc: "\u{319C}",
        nfd: "\u{319C}",
        nfkc: "\u{4E01}",
        nfkd: "\u{4E01}",
    },
    NormalizationTest {
        source: "\u{319D}",
        nfc: "\u{319D}",
        nfd: "\u{319D}",
        nfkc: "\u{5929}",
        nfkd: "\u{5929}",
    },
    NormalizationTest {
        source: "\u{319E}",
        nfc: "\u{319E}",
        nfd: "\u{319E}",
        nfkc: "\u{5730}",
        nfkd: "\u{5730}",
    },
    NormalizationTest {
        source: "\u{319F}",
        nfc: "\u{319F}",
        nfd: "\u{319F}",
        nfkc: "\u{4EBA}",
        nfkd: "\u{4EBA}",
    },
    NormalizationTest {
        source: "\u{3200}",
        nfc: "\u{3200}",
        nfd: "\u{3200}",
        nfkc: "\u{0028}\u{1100}\u{0029}",
        nfkd: "\u{0028}\u{1100}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3201}",
        nfc: "\u{3201}",
        nfd: "\u{3201}",
        nfkc: "\u{0028}\u{1102}\u{0029}",
        nfkd: "\u{0028}\u{1102}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3202}",
        nfc: "\u{3202}",
        nfd: "\u{3202}",
        nfkc: "\u{0028}\u{1103}\u{0029}",
        nfkd: "\u{0028}\u{1103}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3203}",
        nfc: "\u{3203}",
        nfd: "\u{3203}",
        nfkc: "\u{0028}\u{1105}\u{0029}",
        nfkd: "\u{0028}\u{1105}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3204}",
        nfc: "\u{3204}",
        nfd: "\u{3204}",
        nfkc: "\u{0028}\u{1106}\u{0029}",
        nfkd: "\u{0028}\u{1106}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3205}",
        nfc: "\u{3205}",
        nfd: "\u{3205}",
        nfkc: "\u{0028}\u{1107}\u{0029}",
        nfkd: "\u{0028}\u{1107}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3206}",
        nfc: "\u{3206}",
        nfd: "\u{3206}",
        nfkc: "\u{0028}\u{1109}\u{0029}",
        nfkd: "\u{0028}\u{1109}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3207}",
        nfc: "\u{3207}",
        nfd: "\u{3207}",
        nfkc: "\u{0028}\u{110B}\u{0029}",
        nfkd: "\u{0028}\u{110B}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3208}",
        nfc: "\u{3208}",
        nfd: "\u{3208}",
        nfkc: "\u{0028}\u{110C}\u{0029}",
        nfkd: "\u{0028}\u{110C}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3209}",
        nfc: "\u{3209}",
        nfd: "\u{3209}",
        nfkc: "\u{0028}\u{110E}\u{0029}",
        nfkd: "\u{0028}\u{110E}\u{0029}",
    },
    NormalizationTest {
        source: "\u{320A}",
        nfc: "\u{320A}",
        nfd: "\u{320A}",
        nfkc: "\u{0028}\u{110F}\u{0029}",
        nfkd: "\u{0028}\u{110F}\u{0029}",
    },
    NormalizationTest {
        source: "\u{320B}",
        nfc: "\u{320B}",
        nfd: "\u{320B}",
        nfkc: "\u{0028}\u{1110}\u{0029}",
        nfkd: "\u{0028}\u{1110}\u{0029}",
    },
    NormalizationTest {
        source: "\u{320C}",
        nfc: "\u{320C}",
        nfd: "\u{320C}",
        nfkc: "\u{0028}\u{1111}\u{0029}",
        nfkd: "\u{0028}\u{1111}\u{0029}",
    },
    NormalizationTest {
        source: "\u{320D}",
        nfc: "\u{320D}",
        nfd: "\u{320D}",
        nfkc: "\u{0028}\u{1112}\u{0029}",
        nfkd: "\u{0028}\u{1112}\u{0029}",
    },
    NormalizationTest {
        source: "\u{320E}",
        nfc: "\u{320E}",
        nfd: "\u{320E}",
        nfkc: "\u{0028}\u{AC00}\u{0029}",
        nfkd: "\u{0028}\u{1100}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{320F}",
        nfc: "\u{320F}",
        nfd: "\u{320F}",
        nfkc: "\u{0028}\u{B098}\u{0029}",
        nfkd: "\u{0028}\u{1102}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3210}",
        nfc: "\u{3210}",
        nfd: "\u{3210}",
        nfkc: "\u{0028}\u{B2E4}\u{0029}",
        nfkd: "\u{0028}\u{1103}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3211}",
        nfc: "\u{3211}",
        nfd: "\u{3211}",
        nfkc: "\u{0028}\u{B77C}\u{0029}",
        nfkd: "\u{0028}\u{1105}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3212}",
        nfc: "\u{3212}",
        nfd: "\u{3212}",
        nfkc: "\u{0028}\u{B9C8}\u{0029}",
        nfkd: "\u{0028}\u{1106}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3213}",
        nfc: "\u{3213}",
        nfd: "\u{3213}",
        nfkc: "\u{0028}\u{BC14}\u{0029}",
        nfkd: "\u{0028}\u{1107}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3214}",
        nfc: "\u{3214}",
        nfd: "\u{3214}",
        nfkc: "\u{0028}\u{C0AC}\u{0029}",
        nfkd: "\u{0028}\u{1109}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3215}",
        nfc: "\u{3215}",
        nfd: "\u{3215}",
        nfkc: "\u{0028}\u{C544}\u{0029}",
        nfkd: "\u{0028}\u{110B}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3216}",
        nfc: "\u{3216}",
        nfd: "\u{3216}",
        nfkc: "\u{0028}\u{C790}\u{0029}",
        nfkd: "\u{0028}\u{110C}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3217}",
        nfc: "\u{3217}",
        nfd: "\u{3217}",
        nfkc: "\u{0028}\u{CC28}\u{0029}",
        nfkd: "\u{0028}\u{110E}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3218}",
        nfc: "\u{3218}",
        nfd: "\u{3218}",
        nfkc: "\u{0028}\u{CE74}\u{0029}",
        nfkd: "\u{0028}\u{110F}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3219}",
        nfc: "\u{3219}",
        nfd: "\u{3219}",
        nfkc: "\u{0028}\u{D0C0}\u{0029}",
        nfkd: "\u{0028}\u{1110}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{321A}",
        nfc: "\u{321A}",
        nfd: "\u{321A}",
        nfkc: "\u{0028}\u{D30C}\u{0029}",
        nfkd: "\u{0028}\u{1111}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{321B}",
        nfc: "\u{321B}",
        nfd: "\u{321B}",
        nfkc: "\u{0028}\u{D558}\u{0029}",
        nfkd: "\u{0028}\u{1112}\u{1161}\u{0029}",
    },
    NormalizationTest {
        source: "\u{321C}",
        nfc: "\u{321C}",
        nfd: "\u{321C}",
        nfkc: "\u{0028}\u{C8FC}\u{0029}",
        nfkd: "\u{0028}\u{110C}\u{116E}\u{0029}",
    },
    NormalizationTest {
        source: "\u{321D}",
        nfc: "\u{321D}",
        nfd: "\u{321D}",
        nfkc: "\u{0028}\u{C624}\u{C804}\u{0029}",
        nfkd: "\u{0028}\u{110B}\u{1169}\u{110C}\u{1165}\u{11AB}\u{0029}",
    },
    NormalizationTest {
        source: "\u{321E}",
        nfc: "\u{321E}",
        nfd: "\u{321E}",
        nfkc: "\u{0028}\u{C624}\u{D6C4}\u{0029}",
        nfkd: "\u{0028}\u{110B}\u{1169}\u{1112}\u{116E}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3220}",
        nfc: "\u{3220}",
        nfd: "\u{3220}",
        nfkc: "\u{0028}\u{4E00}\u{0029}",
        nfkd: "\u{0028}\u{4E00}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3221}",
        nfc: "\u{3221}",
        nfd: "\u{3221}",
        nfkc: "\u{0028}\u{4E8C}\u{0029}",
        nfkd: "\u{0028}\u{4E8C}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3222}",
        nfc: "\u{3222}",
        nfd: "\u{3222}",
        nfkc: "\u{0028}\u{4E09}\u{0029}",
        nfkd: "\u{0028}\u{4E09}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3223}",
        nfc: "\u{3223}",
        nfd: "\u{3223}",
        nfkc: "\u{0028}\u{56DB}\u{0029}",
        nfkd: "\u{0028}\u{56DB}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3224}",
        nfc: "\u{3224}",
        nfd: "\u{3224}",
        nfkc: "\u{0028}\u{4E94}\u{0029}",
        nfkd: "\u{0028}\u{4E94}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3225}",
        nfc: "\u{3225}",
        nfd: "\u{3225}",
        nfkc: "\u{0028}\u{516D}\u{0029}",
        nfkd: "\u{0028}\u{516D}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3226}",
        nfc: "\u{3226}",
        nfd: "\u{3226}",
        nfkc: "\u{0028}\u{4E03}\u{0029}",
        nfkd: "\u{0028}\u{4E03}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3227}",
        nfc: "\u{3227}",
        nfd: "\u{3227}",
        nfkc: "\u{0028}\u{516B}\u{0029}",
        nfkd: "\u{0028}\u{516B}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3228}",
        nfc: "\u{3228}",
        nfd: "\u{3228}",
        nfkc: "\u{0028}\u{4E5D}\u{0029}",
        nfkd: "\u{0028}\u{4E5D}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3229}",
        nfc: "\u{3229}",
        nfd: "\u{3229}",
        nfkc: "\u{0028}\u{5341}\u{0029}",
        nfkd: "\u{0028}\u{5341}\u{0029}",
    },
    NormalizationTest {
        source: "\u{322A}",
        nfc: "\u{322A}",
        nfd: "\u{322A}",
        nfkc: "\u{0028}\u{6708}\u{0029}",
        nfkd: "\u{0028}\u{6708}\u{0029}",
    },
    NormalizationTest {
        source: "\u{322B}",
        nfc: "\u{322B}",
        nfd: "\u{322B}",
        nfkc: "\u{0028}\u{706B}\u{0029}",
        nfkd: "\u{0028}\u{706B}\u{0029}",
    },
    NormalizationTest {
        source: "\u{322C}",
        nfc: "\u{322C}",
        nfd: "\u{322C}",
        nfkc: "\u{0028}\u{6C34}\u{0029}",
        nfkd: "\u{0028}\u{6C34}\u{0029}",
    },
    NormalizationTest {
        source: "\u{322D}",
        nfc: "\u{322D}",
        nfd: "\u{322D}",
        nfkc: "\u{0028}\u{6728}\u{0029}",
        nfkd: "\u{0028}\u{6728}\u{0029}",
    },
    NormalizationTest {
        source: "\u{322E}",
        nfc: "\u{322E}",
        nfd: "\u{322E}",
        nfkc: "\u{0028}\u{91D1}\u{0029}",
        nfkd: "\u{0028}\u{91D1}\u{0029}",
    },
    NormalizationTest {
        source: "\u{322F}",
        nfc: "\u{322F}",
        nfd: "\u{322F}",
        nfkc: "\u{0028}\u{571F}\u{0029}",
        nfkd: "\u{0028}\u{571F}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3230}",
        nfc: "\u{3230}",
        nfd: "\u{3230}",
        nfkc: "\u{0028}\u{65E5}\u{0029}",
        nfkd: "\u{0028}\u{65E5}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3231}",
        nfc: "\u{3231}",
        nfd: "\u{3231}",
        nfkc: "\u{0028}\u{682A}\u{0029}",
        nfkd: "\u{0028}\u{682A}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3232}",
        nfc: "\u{3232}",
        nfd: "\u{3232}",
        nfkc: "\u{0028}\u{6709}\u{0029}",
        nfkd: "\u{0028}\u{6709}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3233}",
        nfc: "\u{3233}",
        nfd: "\u{3233}",
        nfkc: "\u{0028}\u{793E}\u{0029}",
        nfkd: "\u{0028}\u{793E}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3234}",
        nfc: "\u{3234}",
        nfd: "\u{3234}",
        nfkc: "\u{0028}\u{540D}\u{0029}",
        nfkd: "\u{0028}\u{540D}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3235}",
        nfc: "\u{3235}",
        nfd: "\u{3235}",
        nfkc: "\u{0028}\u{7279}\u{0029}",
        nfkd: "\u{0028}\u{7279}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3236}",
        nfc: "\u{3236}",
        nfd: "\u{3236}",
        nfkc: "\u{0028}\u{8CA1}\u{0029}",
        nfkd: "\u{0028}\u{8CA1}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3237}",
        nfc: "\u{3237}",
        nfd: "\u{3237}",
        nfkc: "\u{0028}\u{795D}\u{0029}",
        nfkd: "\u{0028}\u{795D}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3238}",
        nfc: "\u{3238}",
        nfd: "\u{3238}",
        nfkc: "\u{0028}\u{52B4}\u{0029}",
        nfkd: "\u{0028}\u{52B4}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3239}",
        nfc: "\u{3239}",
        nfd: "\u{3239}",
        nfkc: "\u{0028}\u{4EE3}\u{0029}",
        nfkd: "\u{0028}\u{4EE3}\u{0029}",
    },
    NormalizationTest {
        source: "\u{323A}",
        nfc: "\u{323A}",
        nfd: "\u{323A}",
        nfkc: "\u{0028}\u{547C}\u{0029}",
        nfkd: "\u{0028}\u{547C}\u{0029}",
    },
    NormalizationTest {
        source: "\u{323B}",
        nfc: "\u{323B}",
        nfd: "\u{323B}",
        nfkc: "\u{0028}\u{5B66}\u{0029}",
        nfkd: "\u{0028}\u{5B66}\u{0029}",
    },
    NormalizationTest {
        source: "\u{323C}",
        nfc: "\u{323C}",
        nfd: "\u{323C}",
        nfkc: "\u{0028}\u{76E3}\u{0029}",
        nfkd: "\u{0028}\u{76E3}\u{0029}",
    },
    NormalizationTest {
        source: "\u{323D}",
        nfc: "\u{323D}",
        nfd: "\u{323D}",
        nfkc: "\u{0028}\u{4F01}\u{0029}",
        nfkd: "\u{0028}\u{4F01}\u{0029}",
    },
    NormalizationTest {
        source: "\u{323E}",
        nfc: "\u{323E}",
        nfd: "\u{323E}",
        nfkc: "\u{0028}\u{8CC7}\u{0029}",
        nfkd: "\u{0028}\u{8CC7}\u{0029}",
    },
    NormalizationTest {
        source: "\u{323F}",
        nfc: "\u{323F}",
        nfd: "\u{323F}",
        nfkc: "\u{0028}\u{5354}\u{0029}",
        nfkd: "\u{0028}\u{5354}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3240}",
        nfc: "\u{3240}",
        nfd: "\u{3240}",
        nfkc: "\u{0028}\u{796D}\u{0029}",
        nfkd: "\u{0028}\u{796D}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3241}",
        nfc: "\u{3241}",
        nfd: "\u{3241}",
        nfkc: "\u{0028}\u{4F11}\u{0029}",
        nfkd: "\u{0028}\u{4F11}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3242}",
        nfc: "\u{3242}",
        nfd: "\u{3242}",
        nfkc: "\u{0028}\u{81EA}\u{0029}",
        nfkd: "\u{0028}\u{81EA}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3243}",
        nfc: "\u{3243}",
        nfd: "\u{3243}",
        nfkc: "\u{0028}\u{81F3}\u{0029}",
        nfkd: "\u{0028}\u{81F3}\u{0029}",
    },
    NormalizationTest {
        source: "\u{3244}",
        nfc: "\u{3244}",
        nfd: "\u{3244}",
        nfkc: "\u{554F}",
        nfkd: "\u{554F}",
    },
    NormalizationTest {
        source: "\u{3245}",
        nfc: "\u{3245}",
        nfd: "\u{3245}",
        nfkc: "\u{5E7C}",
        nfkd: "\u{5E7C}",
    },
    NormalizationTest {
        source: "\u{3246}",
        nfc: "\u{3246}",
        nfd: "\u{3246}",
        nfkc: "\u{6587}",
        nfkd: "\u{6587}",
    },
    NormalizationTest {
        source: "\u{3247}",
        nfc: "\u{3247}",
        nfd: "\u{3247}",
        nfkc: "\u{7B8F}",
        nfkd: "\u{7B8F}",
    },
    NormalizationTest {
        source: "\u{3250}",
        nfc: "\u{3250}",
        nfd: "\u{3250}",
        nfkc: "\u{0050}\u{0054}\u{0045}",
        nfkd: "\u{0050}\u{0054}\u{0045}",
    },
    NormalizationTest {
        source: "\u{3251}",
        nfc: "\u{3251}",
        nfd: "\u{3251}",
        nfkc: "\u{0032}\u{0031}",
        nfkd: "\u{0032}\u{0031}",
    },
    NormalizationTest {
        source: "\u{3252}",
        nfc: "\u{3252}",
        nfd: "\u{3252}",
        nfkc: "\u{0032}\u{0032}",
        nfkd: "\u{0032}\u{0032}",
    },
    NormalizationTest {
        source: "\u{3253}",
        nfc: "\u{3253}",
        nfd: "\u{3253}",
        nfkc: "\u{0032}\u{0033}",
        nfkd: "\u{0032}\u{0033}",
    },
    NormalizationTest {
        source: "\u{3254}",
        nfc: "\u{3254}",
        nfd: "\u{3254}",
        nfkc: "\u{0032}\u{0034}",
        nfkd: "\u{0032}\u{0034}",
    },
    NormalizationTest {
        source: "\u{3255}",
        nfc: "\u{3255}",
        nfd: "\u{3255}",
        nfkc: "\u{0032}\u{0035}",
        nfkd: "\u{0032}\u{0035}",
    },
    NormalizationTest {
        source: "\u{3256}",
        nfc: "\u{3256}",
        nfd: "\u{3256}",
        nfkc: "\u{0032}\u{0036}",
        nfkd: "\u{0032}\u{0036}",
    },
    NormalizationTest {
        source: "\u{3257}",
        nfc: "\u{3257}",
        nfd: "\u{3257}",
        nfkc: "\u{0032}\u{0037}",
        nfkd: "\u{0032}\u{0037}",
    },
    NormalizationTest {
        source: "\u{3258}",
        nfc: "\u{3258}",
        nfd: "\u{3258}",
        nfkc: "\u{0032}\u{0038}",
        nfkd: "\u{0032}\u{0038}",
    },
    NormalizationTest {
        source: "\u{3259}",
        nfc: "\u{3259}",
        nfd: "\u{3259}",
        nfkc: "\u{0032}\u{0039}",
        nfkd: "\u{0032}\u{0039}",
    },
    NormalizationTest {
        source: "\u{325A}",
        nfc: "\u{325A}",
        nfd: "\u{325A}",
        nfkc: "\u{0033}\u{0030}",
        nfkd: "\u{0033}\u{0030}",
    },
    NormalizationTest {
        source: "\u{325B}",
        nfc: "\u{325B}",
        nfd: "\u{325B}",
        nfkc: "\u{0033}\u{0031}",
        nfkd: "\u{0033}\u{0031}",
    },
    NormalizationTest {
        source: "\u{325C}",
        nfc: "\u{325C}",
        nfd: "\u{325C}",
        nfkc: "\u{0033}\u{0032}",
        nfkd: "\u{0033}\u{0032}",
    },
    NormalizationTest {
        source: "\u{325D}",
        nfc: "\u{325D}",
        nfd: "\u{325D}",
        nfkc: "\u{0033}\u{0033}",
        nfkd: "\u{0033}\u{0033}",
    },
    NormalizationTest {
        source: "\u{325E}",
        nfc: "\u{325E}",
        nfd: "\u{325E}",
        nfkc: "\u{0033}\u{0034}",
        nfkd: "\u{0033}\u{0034}",
    },
    NormalizationTest {
        source: "\u{325F}",
        nfc: "\u{325F}",
        nfd: "\u{325F}",
        nfkc: "\u{0033}\u{0035}",
        nfkd: "\u{0033}\u{0035}",
    },
    NormalizationTest {
        source: "\u{3260}",
        nfc: "\u{3260}",
        nfd: "\u{3260}",
        nfkc: "\u{1100}",
        nfkd: "\u{1100}",
    },
    NormalizationTest {
        source: "\u{3261}",
        nfc: "\u{3261}",
        nfd: "\u{3261}",
        nfkc: "\u{1102}",
        nfkd: "\u{1102}",
    },
    NormalizationTest {
        source: "\u{3262}",
        nfc: "\u{3262}",
        nfd: "\u{3262}",
        nfkc: "\u{1103}",
        nfkd: "\u{1103}",
    },
    NormalizationTest {
        source: "\u{3263}",
        nfc: "\u{3263}",
        nfd: "\u{3263}",
        nfkc: "\u{1105}",
        nfkd: "\u{1105}",
    },
    NormalizationTest {
        source: "\u{3264}",
        nfc: "\u{3264}",
        nfd: "\u{3264}",
        nfkc: "\u{1106}",
        nfkd: "\u{1106}",
    },
    NormalizationTest {
        source: "\u{3265}",
        nfc: "\u{3265}",
        nfd: "\u{3265}",
        nfkc: "\u{1107}",
        nfkd: "\u{1107}",
    },
    NormalizationTest {
        source: "\u{3266}",
        nfc: "\u{3266}",
        nfd: "\u{3266}",
        nfkc: "\u{1109}",
        nfkd: "\u{1109}",
    },
    NormalizationTest {
        source: "\u{3267}",
        nfc: "\u{3267}",
        nfd: "\u{3267}",
        nfkc: "\u{110B}",
        nfkd: "\u{110B}",
    },
    NormalizationTest {
        source: "\u{3268}",
        nfc: "\u{3268}",
        nfd: "\u{3268}",
        nfkc: "\u{110C}",
        nfkd: "\u{110C}",
    },
    NormalizationTest {
        source: "\u{3269}",
        nfc: "\u{3269}",
        nfd: "\u{3269}",
        nfkc: "\u{110E}",
        nfkd: "\u{110E}",
    },
    NormalizationTest {
        source: "\u{326A}",
        nfc: "\u{326A}",
        nfd: "\u{326A}",
        nfkc: "\u{110F}",
        nfkd: "\u{110F}",
    },
    NormalizationTest {
        source: "\u{326B}",
        nfc: "\u{326B}",
        nfd: "\u{326B}",
        nfkc: "\u{1110}",
        nfkd: "\u{1110}",
    },
    NormalizationTest {
        source: "\u{326C}",
        nfc: "\u{326C}",
        nfd: "\u{326C}",
        nfkc: "\u{1111}",
        nfkd: "\u{1111}",
    },
    NormalizationTest {
        source: "\u{326D}",
        nfc: "\u{326D}",
        nfd: "\u{326D}",
        nfkc: "\u{1112}",
        nfkd: "\u{1112}",
    },
    NormalizationTest {
        source: "\u{326E}",
        nfc: "\u{326E}",
        nfd: "\u{326E}",
        nfkc: "\u{AC00}",
        nfkd: "\u{1100}\u{1161}",
    },
    NormalizationTest {
        source: "\u{326F}",
        nfc: "\u{326F}",
        nfd: "\u{326F}",
        nfkc: "\u{B098}",
        nfkd: "\u{1102}\u{1161}",
    },
    NormalizationTest {
        source: "\u{3270}",
        nfc: "\u{3270}",
        nfd: "\u{3270}",
        nfkc: "\u{B2E4}",
        nfkd: "\u{1103}\u{1161}",
    },
    NormalizationTest {
        source: "\u{3271}",
        nfc: "\u{3271}",
        nfd: "\u{3271}",
        nfkc: "\u{B77C}",
        nfkd: "\u{1105}\u{1161}",
    },
    NormalizationTest {
        source: "\u{3272}",
        nfc: "\u{3272}",
        nfd: "\u{3272}",
        nfkc: "\u{B9C8}",
        nfkd: "\u{1106}\u{1161}",
    },
    NormalizationTest {
        source: "\u{3273}",
        nfc: "\u{3273}",
        nfd: "\u{3273}",
        nfkc: "\u{BC14}",
        nfkd: "\u{1107}\u{1161}",
    },
    NormalizationTest {
        source: "\u{3274}",
        nfc: "\u{3274}",
        nfd: "\u{3274}",
        nfkc: "\u{C0AC}",
        nfkd: "\u{1109}\u{1161}",
    },
    NormalizationTest {
        source: "\u{3275}",
        nfc: "\u{3275}",
        nfd: "\u{3275}",
        nfkc: "\u{C544}",
        nfkd: "\u{110B}\u{1161}",
    },
    NormalizationTest {
        source: "\u{3276}",
        nfc: "\u{3276}",
        nfd: "\u{3276}",
        nfkc: "\u{C790}",
        nfkd: "\u{110C}\u{1161}",
    },
    NormalizationTest {
        source: "\u{3277}",
        nfc: "\u{3277}",
        nfd: "\u{3277}",
        nfkc: "\u{CC28}",
        nfkd: "\u{110E}\u{1161}",
    },
    NormalizationTest {
        source: "\u{3278}",
        nfc: "\u{3278}",
        nfd: "\u{3278}",
        nfkc: "\u{CE74}",
        nfkd: "\u{110F}\u{1161}",
    },
    NormalizationTest {
        source: "\u{3279}",
        nfc: "\u{3279}",
        nfd: "\u{3279}",
        nfkc: "\u{D0C0}",
        nfkd: "\u{1110}\u{1161}",
    },
    NormalizationTest {
        source: "\u{327A}",
        nfc: "\u{327A}",
        nfd: "\u{327A}",
        nfkc: "\u{D30C}",
        nfkd: "\u{1111}\u{1161}",
    },
    NormalizationTest {
        source: "\u{327B}",
        nfc: "\u{327B}",
        nfd: "\u{327B}",
        nfkc: "\u{D558}",
        nfkd: "\u{1112}\u{1161}",
    },
    NormalizationTest {
        source: "\u{327C}",
        nfc: "\u{327C}",
        nfd: "\u{327C}",
        nfkc: "\u{CC38}\u{ACE0}",
        nfkd: "\u{110E}\u{1161}\u{11B7}\u{1100}\u{1169}",
    },
    NormalizationTest {
        source: "\u{327D}",
        nfc: "\u{327D}",
        nfd: "\u{327D}",
        nfkc: "\u{C8FC}\u{C758}",
        nfkd: "\u{110C}\u{116E}\u{110B}\u{1174}",
    },
    NormalizationTest {
        source: "\u{327E}",
        nfc: "\u{327E}",
        nfd: "\u{327E}",
        nfkc: "\u{C6B0}",
        nfkd: "\u{110B}\u{116E}",
    },
    NormalizationTest {
        source: "\u{3280}",
        nfc: "\u{3280}",
        nfd: "\u{3280}",
        nfkc: "\u{4E00}",
        nfkd: "\u{4E00}",
    },
    NormalizationTest {
        source: "\u{3281}",
        nfc: "\u{3281}",
        nfd: "\u{3281}",
        nfkc: "\u{4E8C}",
        nfkd: "\u{4E8C}",
    },
    NormalizationTest {
        source: "\u{3282}",
        nfc: "\u{3282}",
        nfd: "\u{3282}",
        nfkc: "\u{4E09}",
        nfkd: "\u{4E09}",
    },
    NormalizationTest {
        source: "\u{3283}",
        nfc: "\u{3283}",
        nfd: "\u{3283}",
        nfkc: "\u{56DB}",
        nfkd: "\u{56DB}",
    },
    NormalizationTest {
        source: "\u{3284}",
        nfc: "\u{3284}",
        nfd: "\u{3284}",
        nfkc: "\u{4E94}",
        nfkd: "\u{4E94}",
    },
    NormalizationTest {
        source: "\u{3285}",
        nfc: "\u{3285}",
        nfd: "\u{3285}",
        nfkc: "\u{516D}",
        nfkd: "\u{516D}",
    },
    NormalizationTest {
        source: "\u{3286}",
        nfc: "\u{3286}",
        nfd: "\u{3286}",
        nfkc: "\u{4E03}",
        nfkd: "\u{4E03}",
    },
    NormalizationTest {
        source: "\u{3287}",
        nfc: "\u{3287}",
        nfd: "\u{3287}",
        nfkc: "\u{516B}",
        nfkd: "\u{516B}",
    },
    NormalizationTest {
        source: "\u{3288}",
        nfc: "\u{3288}",
        nfd: "\u{3288}",
        nfkc: "\u{4E5D}",
        nfkd: "\u{4E5D}",
    },
    NormalizationTest {
        source: "\u{3289}",
        nfc: "\u{3289}",
        nfd: "\u{3289}",
        nfkc: "\u{5341}",
        nfkd: "\u{5341}",
    },
    NormalizationTest {
        source: "\u{328A}",
        nfc: "\u{328A}",
        nfd: "\u{328A}",
        nfkc: "\u{6708}",
        nfkd: "\u{6708}",
    },
    NormalizationTest {
        source: "\u{328B}",
        nfc: "\u{328B}",
        nfd: "\u{328B}",
        nfkc: "\u{706B}",
        nfkd: "\u{706B}",
    },
    NormalizationTest {
        source: "\u{328C}",
        nfc: "\u{328C}",
        nfd: "\u{328C}",
        nfkc: "\u{6C34}",
        nfkd: "\u{6C34}",
    },
    NormalizationTest {
        source: "\u{328D}",
        nfc: "\u{328D}",
        nfd: "\u{328D}",
        nfkc: "\u{6728}",
        nfkd: "\u{6728}",
    },
    NormalizationTest {
        source: "\u{328E}",
        nfc: "\u{328E}",
        nfd: "\u{328E}",
        nfkc: "\u{91D1}",
        nfkd: "\u{91D1}",
    },
    NormalizationTest {
        source: "\u{328F}",
        nfc: "\u{328F}",
        nfd: "\u{328F}",
        nfkc: "\u{571F}",
        nfkd: "\u{571F}",
    },
    NormalizationTest {
        source: "\u{3290}",
        nfc: "\u{3290}",
        nfd: "\u{3290}",
        nfkc: "\u{65E5}",
        nfkd: "\u{65E5}",
    },
    NormalizationTest {
        source: "\u{3291}",
        nfc: "\u{3291}",
        nfd: "\u{3291}",
        nfkc: "\u{682A}",
        nfkd: "\u{682A}",
    },
    NormalizationTest {
        source: "\u{3292}",
        nfc: "\u{3292}",
        nfd: "\u{3292}",
        nfkc: "\u{6709}",
        nfkd: "\u{6709}",
    },
    NormalizationTest {
        source: "\u{3293}",
        nfc: "\u{3293}",
        nfd: "\u{3293}",
        nfkc: "\u{793E}",
        nfkd: "\u{793E}",
    },
    NormalizationTest {
        source: "\u{3294}",
        nfc: "\u{3294}",
        nfd: "\u{3294}",
        nfkc: "\u{540D}",
        nfkd: "\u{540D}",
    },
    NormalizationTest {
        source: "\u{3295}",
        nfc: "\u{3295}",
        nfd: "\u{3295}",
        nfkc: "\u{7279}",
        nfkd: "\u{7279}",
    },
    NormalizationTest {
        source: "\u{3296}",
        nfc: "\u{3296}",
        nfd: "\u{3296}",
        nfkc: "\u{8CA1}",
        nfkd: "\u{8CA1}",
    },
    NormalizationTest {
        source: "\u{3297}",
        nfc: "\u{3297}",
        nfd: "\u{3297}",
        nfkc: "\u{795D}",
        nfkd: "\u{795D}",
    },
    NormalizationTest {
        source: "\u{3298}",
        nfc: "\u{3298}",
        nfd: "\u{3298}",
        nfkc: "\u{52B4}",
        nfkd: "\u{52B4}",
    },
    NormalizationTest {
        source: "\u{3299}",
        nfc: "\u{3299}",
        nfd: "\u{3299}",
        nfkc: "\u{79D8}",
        nfkd: "\u{79D8}",
    },
    NormalizationTest {
        source: "\u{329A}",
        nfc: "\u{329A}",
        nfd: "\u{329A}",
        nfkc: "\u{7537}",
        nfkd: "\u{7537}",
    },
    NormalizationTest {
        source: "\u{329B}",
        nfc: "\u{329B}",
        nfd: "\u{329B}",
        nfkc: "\u{5973}",
        nfkd: "\u{5973}",
    },
    NormalizationTest {
        source: "\u{329C}",
        nfc: "\u{329C}",
        nfd: "\u{329C}",
        nfkc: "\u{9069}",
        nfkd: "\u{9069}",
    },
    NormalizationTest {
        source: "\u{329D}",
        nfc: "\u{329D}",
        nfd: "\u{329D}",
        nfkc: "\u{512A}",
        nfkd: "\u{512A}",
    },
    NormalizationTest {
        source: "\u{329E}",
        nfc: "\u{329E}",
        nfd: "\u{329E}",
        nfkc: "\u{5370}",
        nfkd: "\u{5370}",
    },
    NormalizationTest {
        source: "\u{329F}",
        nfc: "\u{329F}",
        nfd: "\u{329F}",
        nfkc: "\u{6CE8}",
        nfkd: "\u{6CE8}",
    },
    NormalizationTest {
        source: "\u{32A0}",
        nfc: "\u{32A0}",
        nfd: "\u{32A0}",
        nfkc: "\u{9805}",
        nfkd: "\u{9805}",
    },
    NormalizationTest {
        source: "\u{32A1}",
        nfc: "\u{32A1}",
        nfd: "\u{32A1}",
        nfkc: "\u{4F11}",
        nfkd: "\u{4F11}",
    },
    NormalizationTest {
        source: "\u{32A2}",
        nfc: "\u{32A2}",
        nfd: "\u{32A2}",
        nfkc: "\u{5199}",
        nfkd: "\u{5199}",
    },
    NormalizationTest {
        source: "\u{32A3}",
        nfc: "\u{32A3}",
        nfd: "\u{32A3}",
        nfkc: "\u{6B63}",
        nfkd: "\u{6B63}",
    },
    NormalizationTest {
        source: "\u{32A4}",
        nfc: "\u{32A4}",
        nfd: "\u{32A4}",
        nfkc: "\u{4E0A}",
        nfkd: "\u{4E0A}",
    },
    NormalizationTest {
        source: "\u{32A5}",
        nfc: "\u{32A5}",
        nfd: "\u{32A5}",
        nfkc: "\u{4E2D}",
        nfkd: "\u{4E2D}",
    },
    NormalizationTest {
        source: "\u{32A6}",
        nfc: "\u{32A6}",
        nfd: "\u{32A6}",
        nfkc: "\u{4E0B}",
        nfkd: "\u{4E0B}",
    },
    NormalizationTest {
        source: "\u{32A7}",
        nfc: "\u{32A7}",
        nfd: "\u{32A7}",
        nfkc: "\u{5DE6}",
        nfkd: "\u{5DE6}",
    },
    NormalizationTest {
        source: "\u{32A8}",
        nfc: "\u{32A8}",
        nfd: "\u{32A8}",
        nfkc: "\u{53F3}",
        nfkd: "\u{53F3}",
    },
    NormalizationTest {
        source: "\u{32A9}",
        nfc: "\u{32A9}",
        nfd: "\u{32A9}",
        nfkc: "\u{533B}",
        nfkd: "\u{533B}",
    },
    NormalizationTest {
        source: "\u{32AA}",
        nfc: "\u{32AA}",
        nfd: "\u{32AA}",
        nfkc: "\u{5B97}",
        nfkd: "\u{5B97}",
    },
    NormalizationTest {
        source: "\u{32AB}",
        nfc: "\u{32AB}",
        nfd: "\u{32AB}",
        nfkc: "\u{5B66}",
        nfkd: "\u{5B66}",
    },
    NormalizationTest {
        source: "\u{32AC}",
        nfc: "\u{32AC}",
        nfd: "\u{32AC}",
        nfkc: "\u{76E3}",
        nfkd: "\u{76E3}",
    },
    NormalizationTest {
        source: "\u{32AD}",
        nfc: "\u{32AD}",
        nfd: "\u{32AD}",
        nfkc: "\u{4F01}",
        nfkd: "\u{4F01}",
    },
    NormalizationTest {
        source: "\u{32AE}",
        nfc: "\u{32AE}",
        nfd: "\u{32AE}",
        nfkc: "\u{8CC7}",
        nfkd: "\u{8CC7}",
    },
    NormalizationTest {
        source: "\u{32AF}",
        nfc: "\u{32AF}",
        nfd: "\u{32AF}",
        nfkc: "\u{5354}",
        nfkd: "\u{5354}",
    },
    NormalizationTest {
        source: "\u{32B0}",
        nfc: "\u{32B0}",
        nfd: "\u{32B0}",
        nfkc: "\u{591C}",
        nfkd: "\u{591C}",
    },
    NormalizationTest {
        source: "\u{32B1}",
        nfc: "\u{32B1}",
        nfd: "\u{32B1}",
        nfkc: "\u{0033}\u{0036}",
        nfkd: "\u{0033}\u{0036}",
    },
    NormalizationTest {
        source: "\u{32B2}",
        nfc: "\u{32B2}",
        nfd: "\u{32B2}",
        nfkc: "\u{0033}\u{0037}",
        nfkd: "\u{0033}\u{0037}",
    },
    NormalizationTest {
        source: "\u{32B3}",
        nfc: "\u{32B3}",
        nfd: "\u{32B3}",
        nfkc: "\u{0033}\u{0038}",
        nfkd: "\u{0033}\u{0038}",
    },
    NormalizationTest {
        source: "\u{32B4}",
        nfc: "\u{32B4}",
        nfd: "\u{32B4}",
        nfkc: "\u{0033}\u{0039}",
        nfkd: "\u{0033}\u{0039}",
    },
    NormalizationTest {
        source: "\u{32B5}",
        nfc: "\u{32B5}",
        nfd: "\u{32B5}",
        nfkc: "\u{0034}\u{0030}",
        nfkd: "\u{0034}\u{0030}",
    },
    NormalizationTest {
        source: "\u{32B6}",
        nfc: "\u{32B6}",
        nfd: "\u{32B6}",
        nfkc: "\u{0034}\u{0031}",
        nfkd: "\u{0034}\u{0031}",
    },
    NormalizationTest {
        source: "\u{32B7}",
        nfc: "\u{32B7}",
        nfd: "\u{32B7}",
        nfkc: "\u{0034}\u{0032}",
        nfkd: "\u{0034}\u{0032}",
    },
    NormalizationTest {
        source: "\u{32B8}",
        nfc: "\u{32B8}",
        nfd: "\u{32B8}",
        nfkc: "\u{0034}\u{0033}",
        nfkd: "\u{0034}\u{0033}",
    },
    NormalizationTest {
        source: "\u{32B9}",
        nfc: "\u{32B9}",
        nfd: "\u{32B9}",
        nfkc: "\u{0034}\u{0034}",
        nfkd: "\u{0034}\u{0034}",
    },
    NormalizationTest {
        source: "\u{32BA}",
        nfc: "\u{32BA}",
        nfd: "\u{32BA}",
        nfkc: "\u{0034}\u{0035}",
        nfkd: "\u{0034}\u{0035}",
    },
    NormalizationTest {
        source: "\u{32BB}",
        nfc: "\u{32BB}",
        nfd: "\u{32BB}",
        nfkc: "\u{0034}\u{0036}",
        nfkd: "\u{0034}\u{0036}",
    },
    NormalizationTest {
        source: "\u{32BC}",
        nfc: "\u{32BC}",
        nfd: "\u{32BC}",
        nfkc: "\u{0034}\u{0037}",
        nfkd: "\u{0034}\u{0037}",
    },
    NormalizationTest {
        source: "\u{32BD}",
        nfc: "\u{32BD}",
        nfd: "\u{32BD}",
        nfkc: "\u{0034}\u{0038}",
        nfkd: "\u{0034}\u{0038}",
    },
    NormalizationTest {
        source: "\u{32BE}",
        nfc: "\u{32BE}",
        nfd: "\u{32BE}",
        nfkc: "\u{0034}\u{0039}",
        nfkd: "\u{0034}\u{0039}",
    },
    NormalizationTest {
        source: "\u{32BF}",
        nfc: "\u{32BF}",
        nfd: "\u{32BF}",
        nfkc: "\u{0035}\u{0030}",
        nfkd: "\u{0035}\u{0030}",
    },
    NormalizationTest {
        source: "\u{32C0}",
        nfc: "\u{32C0}",
        nfd: "\u{32C0}",
        nfkc: "\u{0031}\u{6708}",
        nfkd: "\u{0031}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32C1}",
        nfc: "\u{32C1}",
        nfd: "\u{32C1}",
        nfkc: "\u{0032}\u{6708}",
        nfkd: "\u{0032}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32C2}",
        nfc: "\u{32C2}",
        nfd: "\u{32C2}",
        nfkc: "\u{0033}\u{6708}",
        nfkd: "\u{0033}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32C3}",
        nfc: "\u{32C3}",
        nfd: "\u{32C3}",
        nfkc: "\u{0034}\u{6708}",
        nfkd: "\u{0034}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32C4}",
        nfc: "\u{32C4}",
        nfd: "\u{32C4}",
        nfkc: "\u{0035}\u{6708}",
        nfkd: "\u{0035}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32C5}",
        nfc: "\u{32C5}",
        nfd: "\u{32C5}",
        nfkc: "\u{0036}\u{6708}",
        nfkd: "\u{0036}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32C6}",
        nfc: "\u{32C6}",
        nfd: "\u{32C6}",
        nfkc: "\u{0037}\u{6708}",
        nfkd: "\u{0037}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32C7}",
        nfc: "\u{32C7}",
        nfd: "\u{32C7}",
        nfkc: "\u{0038}\u{6708}",
        nfkd: "\u{0038}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32C8}",
        nfc: "\u{32C8}",
        nfd: "\u{32C8}",
        nfkc: "\u{0039}\u{6708}",
        nfkd: "\u{0039}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32C9}",
        nfc: "\u{32C9}",
        nfd: "\u{32C9}",
        nfkc: "\u{0031}\u{0030}\u{6708}",
        nfkd: "\u{0031}\u{0030}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32CA}",
        nfc: "\u{32CA}",
        nfd: "\u{32CA}",
        nfkc: "\u{0031}\u{0031}\u{6708}",
        nfkd: "\u{0031}\u{0031}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32CB}",
        nfc: "\u{32CB}",
        nfd: "\u{32CB}",
        nfkc: "\u{0031}\u{0032}\u{6708}",
        nfkd: "\u{0031}\u{0032}\u{6708}",
    },
    NormalizationTest {
        source: "\u{32CC}",
        nfc: "\u{32CC}",
        nfd: "\u{32CC}",
        nfkc: "\u{0048}\u{0067}",
        nfkd: "\u{0048}\u{0067}",
    },
    NormalizationTest {
        source: "\u{32CD}",
        nfc: "\u{32CD}",
        nfd: "\u{32CD}",
        nfkc: "\u{0065}\u{0072}\u{0067}",
        nfkd: "\u{0065}\u{0072}\u{0067}",
    },
    NormalizationTest {
        source: "\u{32CE}",
        nfc: "\u{32CE}",
        nfd: "\u{32CE}",
        nfkc: "\u{0065}\u{0056}",
        nfkd: "\u{0065}\u{0056}",
    },
    NormalizationTest {
        source: "\u{32CF}",
        nfc: "\u{32CF}",
        nfd: "\u{32CF}",
        nfkc: "\u{004C}\u{0054}\u{0044}",
        nfkd: "\u{004C}\u{0054}\u{0044}",
    },
    NormalizationTest {
        source: "\u{32D0}",
        nfc: "\u{32D0}",
        nfd: "\u{32D0}",
        nfkc: "\u{30A2}",
        nfkd: "\u{30A2}",
    },
    NormalizationTest {
        source: "\u{32D1}",
        nfc: "\u{32D1}",
        nfd: "\u{32D1}",
        nfkc: "\u{30A4}",
        nfkd: "\u{30A4}",
    },
    NormalizationTest {
        source: "\u{32D2}",
        nfc: "\u{32D2}",
        nfd: "\u{32D2}",
        nfkc: "\u{30A6}",
        nfkd: "\u{30A6}",
    },
    NormalizationTest {
        source: "\u{32D3}",
        nfc: "\u{32D3}",
        nfd: "\u{32D3}",
        nfkc: "\u{30A8}",
        nfkd: "\u{30A8}",
    },
    NormalizationTest {
        source: "\u{32D4}",
        nfc: "\u{32D4}",
        nfd: "\u{32D4}",
        nfkc: "\u{30AA}",
        nfkd: "\u{30AA}",
    },
    NormalizationTest {
        source: "\u{32D5}",
        nfc: "\u{32D5}",
        nfd: "\u{32D5}",
        nfkc: "\u{30AB}",
        nfkd: "\u{30AB}",
    },
    NormalizationTest {
        source: "\u{32D6}",
        nfc: "\u{32D6}",
        nfd: "\u{32D6}",
        nfkc: "\u{30AD}",
        nfkd: "\u{30AD}",
    },
    NormalizationTest {
        source: "\u{32D7}",
        nfc: "\u{32D7}",
        nfd: "\u{32D7}",
        nfkc: "\u{30AF}",
        nfkd: "\u{30AF}",
    },
    NormalizationTest {
        source: "\u{32D8}",
        nfc: "\u{32D8}",
        nfd: "\u{32D8}",
        nfkc: "\u{30B1}",
        nfkd: "\u{30B1}",
    },
    NormalizationTest {
        source: "\u{32D9}",
        nfc: "\u{32D9}",
        nfd: "\u{32D9}",
        nfkc: "\u{30B3}",
        nfkd: "\u{30B3}",
    },
    NormalizationTest {
        source: "\u{32DA}",
        nfc: "\u{32DA}",
        nfd: "\u{32DA}",
        nfkc: "\u{30B5}",
        nfkd: "\u{30B5}",
    },
    NormalizationTest {
        source: "\u{32DB}",
        nfc: "\u{32DB}",
        nfd: "\u{32DB}",
        nfkc: "\u{30B7}",
        nfkd: "\u{30B7}",
    },
    NormalizationTest {
        source: "\u{32DC}",
        nfc: "\u{32DC}",
        nfd: "\u{32DC}",
        nfkc: "\u{30B9}",
        nfkd: "\u{30B9}",
    },
    NormalizationTest {
        source: "\u{32DD}",
        nfc: "\u{32DD}",
        nfd: "\u{32DD}",
        nfkc: "\u{30BB}",
        nfkd: "\u{30BB}",
    },
    NormalizationTest {
        source: "\u{32DE}",
        nfc: "\u{32DE}",
        nfd: "\u{32DE}",
        nfkc: "\u{30BD}",
        nfkd: "\u{30BD}",
    },
    NormalizationTest {
        source: "\u{32DF}",
        nfc: "\u{32DF}",
        nfd: "\u{32DF}",
        nfkc: "\u{30BF}",
        nfkd: "\u{30BF}",
    },
    NormalizationTest {
        source: "\u{32E0}",
        nfc: "\u{32E0}",
        nfd: "\u{32E0}",
        nfkc: "\u{30C1}",
        nfkd: "\u{30C1}",
    },
    NormalizationTest {
        source: "\u{32E1}",
        nfc: "\u{32E1}",
        nfd: "\u{32E1}",
        nfkc: "\u{30C4}",
        nfkd: "\u{30C4}",
    },
    NormalizationTest {
        source: "\u{32E2}",
        nfc: "\u{32E2}",
        nfd: "\u{32E2}",
        nfkc: "\u{30C6}",
        nfkd: "\u{30C6}",
    },
    NormalizationTest {
        source: "\u{32E3}",
        nfc: "\u{32E3}",
        nfd: "\u{32E3}",
        nfkc: "\u{30C8}",
        nfkd: "\u{30C8}",
    },
    NormalizationTest {
        source: "\u{32E4}",
        nfc: "\u{32E4}",
        nfd: "\u{32E4}",
        nfkc: "\u{30CA}",
        nfkd: "\u{30CA}",
    },
    NormalizationTest {
        source: "\u{32E5}",
        nfc: "\u{32E5}",
        nfd: "\u{32E5}",
        nfkc: "\u{30CB}",
        nfkd: "\u{30CB}",
    },
    NormalizationTest {
        source: "\u{32E6}",
        nfc: "\u{32E6}",
        nfd: "\u{32E6}",
        nfkc: "\u{30CC}",
        nfkd: "\u{30CC}",
    },
    NormalizationTest {
        source: "\u{32E7}",
        nfc: "\u{32E7}",
        nfd: "\u{32E7}",
        nfkc: "\u{30CD}",
        nfkd: "\u{30CD}",
    },
    NormalizationTest {
        source: "\u{32E8}",
        nfc: "\u{32E8}",
        nfd: "\u{32E8}",
        nfkc: "\u{30CE}",
        nfkd: "\u{30CE}",
    },
    NormalizationTest {
        source: "\u{32E9}",
        nfc: "\u{32E9}",
        nfd: "\u{32E9}",
        nfkc: "\u{30CF}",
        nfkd: "\u{30CF}",
    },
    NormalizationTest {
        source: "\u{32EA}",
        nfc: "\u{32EA}",
        nfd: "\u{32EA}",
        nfkc: "\u{30D2}",
        nfkd: "\u{30D2}",
    },
    NormalizationTest {
        source: "\u{32EB}",
        nfc: "\u{32EB}",
        nfd: "\u{32EB}",
        nfkc: "\u{30D5}",
        nfkd: "\u{30D5}",
    },
    NormalizationTest {
        source: "\u{32EC}",
        nfc: "\u{32EC}",
        nfd: "\u{32EC}",
        nfkc: "\u{30D8}",
        nfkd: "\u{30D8}",
    },
    NormalizationTest {
        source: "\u{32ED}",
        nfc: "\u{32ED}",
        nfd: "\u{32ED}",
        nfkc: "\u{30DB}",
        nfkd: "\u{30DB}",
    },
    NormalizationTest {
        source: "\u{32EE}",
        nfc: "\u{32EE}",
        nfd: "\u{32EE}",
        nfkc: "\u{30DE}",
        nfkd: "\u{30DE}",
    },
    NormalizationTest {
        source: "\u{32EF}",
        nfc: "\u{32EF}",
        nfd: "\u{32EF}",
        nfkc: "\u{30DF}",
        nfkd: "\u{30DF}",
    },
    NormalizationTest {
        source: "\u{32F0}",
        nfc: "\u{32F0}",
        nfd: "\u{32F0}",
        nfkc: "\u{30E0}",
        nfkd: "\u{30E0}",
    },
    NormalizationTest {
        source: "\u{32F1}",
        nfc: "\u{32F1}",
        nfd: "\u{32F1}",
        nfkc: "\u{30E1}",
        nfkd: "\u{30E1}",
    },
    NormalizationTest {
        source: "\u{32F2}",
        nfc: "\u{32F2}",
        nfd: "\u{32F2}",
        nfkc: "\u{30E2}",
        nfkd: "\u{30E2}",
    },
    NormalizationTest {
        source: "\u{32F3}",
        nfc: "\u{32F3}",
        nfd: "\u{32F3}",
        nfkc: "\u{30E4}",
        nfkd: "\u{30E4}",
    },
    NormalizationTest {
        source: "\u{32F4}",
        nfc: "\u{32F4}",
        nfd: "\u{32F4}",
        nfkc: "\u{30E6}",
        nfkd: "\u{30E6}",
    },
    NormalizationTest {
        source: "\u{32F5}",
        nfc: "\u{32F5}",
        nfd: "\u{32F5}",
        nfkc: "\u{30E8}",
        nfkd: "\u{30E8}",
    },
    NormalizationTest {
        source: "\u{32F6}",
        nfc: "\u{32F6}",
        nfd: "\u{32F6}",
        nfkc: "\u{30E9}",
        nfkd: "\u{30E9}",
    },
    NormalizationTest {
        source: "\u{32F7}",
        nfc: "\u{32F7}",
        nfd: "\u{32F7}",
        nfkc: "\u{30EA}",
        nfkd: "\u{30EA}",
    },
    NormalizationTest {
        source: "\u{32F8}",
        nfc: "\u{32F8}",
        nfd: "\u{32F8}",
        nfkc: "\u{30EB}",
        nfkd: "\u{30EB}",
    },
    NormalizationTest {
        source: "\u{32F9}",
        nfc: "\u{32F9}",
        nfd: "\u{32F9}",
        nfkc: "\u{30EC}",
        nfkd: "\u{30EC}",
    },
    NormalizationTest {
        source: "\u{32FA}",
        nfc: "\u{32FA}",
        nfd: "\u{32FA}",
        nfkc: "\u{30ED}",
        nfkd: "\u{30ED}",
    },
    NormalizationTest {
        source: "\u{32FB}",
        nfc: "\u{32FB}",
        nfd: "\u{32FB}",
        nfkc: "\u{30EF}",
        nfkd: "\u{30EF}",
    },
    NormalizationTest {
        source: "\u{32FC}",
        nfc: "\u{32FC}",
        nfd: "\u{32FC}",
        nfkc: "\u{30F0}",
        nfkd: "\u{30F0}",
    },
    NormalizationTest {
        source: "\u{32FD}",
        nfc: "\u{32FD}",
        nfd: "\u{32FD}",
        nfkc: "\u{30F1}",
        nfkd: "\u{30F1}",
    },
    NormalizationTest {
        source: "\u{32FE}",
        nfc: "\u{32FE}",
        nfd: "\u{32FE}",
        nfkc: "\u{30F2}",
        nfkd: "\u{30F2}",
    },
    NormalizationTest {
        source: "\u{32FF}",
        nfc: "\u{32FF}",
        nfd: "\u{32FF}",
        nfkc: "\u{4EE4}\u{548C}",
        nfkd: "\u{4EE4}\u{548C}",
    },
    NormalizationTest {
        source: "\u{3300}",
        nfc: "\u{3300}",
        nfd: "\u{3300}",
        nfkc: "\u{30A2}\u{30D1}\u{30FC}\u{30C8}",
        nfkd: "\u{30A2}\u{30CF}\u{309A}\u{30FC}\u{30C8}",
    },
    NormalizationTest {
        source: "\u{3301}",
        nfc: "\u{3301}",
        nfd: "\u{3301}",
        nfkc: "\u{30A2}\u{30EB}\u{30D5}\u{30A1}",
        nfkd: "\u{30A2}\u{30EB}\u{30D5}\u{30A1}",
    },
    NormalizationTest {
        source: "\u{3302}",
        nfc: "\u{3302}",
        nfd: "\u{3302}",
        nfkc: "\u{30A2}\u{30F3}\u{30DA}\u{30A2}",
        nfkd: "\u{30A2}\u{30F3}\u{30D8}\u{309A}\u{30A2}",
    },
    NormalizationTest {
        source: "\u{3303}",
        nfc: "\u{3303}",
        nfd: "\u{3303}",
        nfkc: "\u{30A2}\u{30FC}\u{30EB}",
        nfkd: "\u{30A2}\u{30FC}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3304}",
        nfc: "\u{3304}",
        nfd: "\u{3304}",
        nfkc: "\u{30A4}\u{30CB}\u{30F3}\u{30B0}",
        nfkd: "\u{30A4}\u{30CB}\u{30F3}\u{30AF}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3305}",
        nfc: "\u{3305}",
        nfd: "\u{3305}",
        nfkc: "\u{30A4}\u{30F3}\u{30C1}",
        nfkd: "\u{30A4}\u{30F3}\u{30C1}",
    },
    NormalizationTest {
        source: "\u{3306}",
        nfc: "\u{3306}",
        nfd: "\u{3306}",
        nfkc: "\u{30A6}\u{30A9}\u{30F3}",
        nfkd: "\u{30A6}\u{30A9}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{3307}",
        nfc: "\u{3307}",
        nfd: "\u{3307}",
        nfkc: "\u{30A8}\u{30B9}\u{30AF}\u{30FC}\u{30C9}",
        nfkd: "\u{30A8}\u{30B9}\u{30AF}\u{30FC}\u{30C8}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3308}",
        nfc: "\u{3308}",
        nfd: "\u{3308}",
        nfkc: "\u{30A8}\u{30FC}\u{30AB}\u{30FC}",
        nfkd: "\u{30A8}\u{30FC}\u{30AB}\u{30FC}",
    },
    NormalizationTest {
        source: "\u{3309}",
        nfc: "\u{3309}",
        nfd: "\u{3309}",
        nfkc: "\u{30AA}\u{30F3}\u{30B9}",
        nfkd: "\u{30AA}\u{30F3}\u{30B9}",
    },
    NormalizationTest {
        source: "\u{330A}",
        nfc: "\u{330A}",
        nfd: "\u{330A}",
        nfkc: "\u{30AA}\u{30FC}\u{30E0}",
        nfkd: "\u{30AA}\u{30FC}\u{30E0}",
    },
    NormalizationTest {
        source: "\u{330B}",
        nfc: "\u{330B}",
        nfd: "\u{330B}",
        nfkc: "\u{30AB}\u{30A4}\u{30EA}",
        nfkd: "\u{30AB}\u{30A4}\u{30EA}",
    },
    NormalizationTest {
        source: "\u{330C}",
        nfc: "\u{330C}",
        nfd: "\u{330C}",
        nfkc: "\u{30AB}\u{30E9}\u{30C3}\u{30C8}",
        nfkd: "\u{30AB}\u{30E9}\u{30C3}\u{30C8}",
    },
    NormalizationTest {
        source: "\u{330D}",
        nfc: "\u{330D}",
        nfd: "\u{330D}",
        nfkc: "\u{30AB}\u{30ED}\u{30EA}\u{30FC}",
        nfkd: "\u{30AB}\u{30ED}\u{30EA}\u{30FC}",
    },
    NormalizationTest {
        source: "\u{330E}",
        nfc: "\u{330E}",
        nfd: "\u{330E}",
        nfkc: "\u{30AC}\u{30ED}\u{30F3}",
        nfkd: "\u{30AB}\u{3099}\u{30ED}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{330F}",
        nfc: "\u{330F}",
        nfd: "\u{330F}",
        nfkc: "\u{30AC}\u{30F3}\u{30DE}",
        nfkd: "\u{30AB}\u{3099}\u{30F3}\u{30DE}",
    },
    NormalizationTest {
        source: "\u{3310}",
        nfc: "\u{3310}",
        nfd: "\u{3310}",
        nfkc: "\u{30AE}\u{30AC}",
        nfkd: "\u{30AD}\u{3099}\u{30AB}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3311}",
        nfc: "\u{3311}",
        nfd: "\u{3311}",
        nfkc: "\u{30AE}\u{30CB}\u{30FC}",
        nfkd: "\u{30AD}\u{3099}\u{30CB}\u{30FC}",
    },
    NormalizationTest {
        source: "\u{3312}",
        nfc: "\u{3312}",
        nfd: "\u{3312}",
        nfkc: "\u{30AD}\u{30E5}\u{30EA}\u{30FC}",
        nfkd: "\u{30AD}\u{30E5}\u{30EA}\u{30FC}",
    },
    NormalizationTest {
        source: "\u{3313}",
        nfc: "\u{3313}",
        nfd: "\u{3313}",
        nfkc: "\u{30AE}\u{30EB}\u{30C0}\u{30FC}",
        nfkd: "\u{30AD}\u{3099}\u{30EB}\u{30BF}\u{3099}\u{30FC}",
    },
    NormalizationTest {
        source: "\u{3314}",
        nfc: "\u{3314}",
        nfd: "\u{3314}",
        nfkc: "\u{30AD}\u{30ED}",
        nfkd: "\u{30AD}\u{30ED}",
    },
    NormalizationTest {
        source: "\u{3315}",
        nfc: "\u{3315}",
        nfd: "\u{3315}",
        nfkc: "\u{30AD}\u{30ED}\u{30B0}\u{30E9}\u{30E0}",
        nfkd: "\u{30AD}\u{30ED}\u{30AF}\u{3099}\u{30E9}\u{30E0}",
    },
    NormalizationTest {
        source: "\u{3316}",
        nfc: "\u{3316}",
        nfd: "\u{3316}",
        nfkc: "\u{30AD}\u{30ED}\u{30E1}\u{30FC}\u{30C8}\u{30EB}",
        nfkd: "\u{30AD}\u{30ED}\u{30E1}\u{30FC}\u{30C8}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3317}",
        nfc: "\u{3317}",
        nfd: "\u{3317}",
        nfkc: "\u{30AD}\u{30ED}\u{30EF}\u{30C3}\u{30C8}",
        nfkd: "\u{30AD}\u{30ED}\u{30EF}\u{30C3}\u{30C8}",
    },
    NormalizationTest {
        source: "\u{3318}",
        nfc: "\u{3318}",
        nfd: "\u{3318}",
        nfkc: "\u{30B0}\u{30E9}\u{30E0}",
        nfkd: "\u{30AF}\u{3099}\u{30E9}\u{30E0}",
    },
    NormalizationTest {
        source: "\u{3319}",
        nfc: "\u{3319}",
        nfd: "\u{3319}",
        nfkc: "\u{30B0}\u{30E9}\u{30E0}\u{30C8}\u{30F3}",
        nfkd: "\u{30AF}\u{3099}\u{30E9}\u{30E0}\u{30C8}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{331A}",
        nfc: "\u{331A}",
        nfd: "\u{331A}",
        nfkc: "\u{30AF}\u{30EB}\u{30BC}\u{30A4}\u{30ED}",
        nfkd: "\u{30AF}\u{30EB}\u{30BB}\u{3099}\u{30A4}\u{30ED}",
    },
    NormalizationTest {
        source: "\u{331B}",
        nfc: "\u{331B}",
        nfd: "\u{331B}",
        nfkc: "\u{30AF}\u{30ED}\u{30FC}\u{30CD}",
        nfkd: "\u{30AF}\u{30ED}\u{30FC}\u{30CD}",
    },
    NormalizationTest {
        source: "\u{331C}",
        nfc: "\u{331C}",
        nfd: "\u{331C}",
        nfkc: "\u{30B1}\u{30FC}\u{30B9}",
        nfkd: "\u{30B1}\u{30FC}\u{30B9}",
    },
    NormalizationTest {
        source: "\u{331D}",
        nfc: "\u{331D}",
        nfd: "\u{331D}",
        nfkc: "\u{30B3}\u{30EB}\u{30CA}",
        nfkd: "\u{30B3}\u{30EB}\u{30CA}",
    },
    NormalizationTest {
        source: "\u{331E}",
        nfc: "\u{331E}",
        nfd: "\u{331E}",
        nfkc: "\u{30B3}\u{30FC}\u{30DD}",
        nfkd: "\u{30B3}\u{30FC}\u{30DB}\u{309A}",
    },
    NormalizationTest {
        source: "\u{331F}",
        nfc: "\u{331F}",
        nfd: "\u{331F}",
        nfkc: "\u{30B5}\u{30A4}\u{30AF}\u{30EB}",
        nfkd: "\u{30B5}\u{30A4}\u{30AF}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3320}",
        nfc: "\u{3320}",
        nfd: "\u{3320}",
        nfkc: "\u{30B5}\u{30F3}\u{30C1}\u{30FC}\u{30E0}",
        nfkd: "\u{30B5}\u{30F3}\u{30C1}\u{30FC}\u{30E0}",
    },
    NormalizationTest {
        source: "\u{3321}",
        nfc: "\u{3321}",
        nfd: "\u{3321}",
        nfkc: "\u{30B7}\u{30EA}\u{30F3}\u{30B0}",
        nfkd: "\u{30B7}\u{30EA}\u{30F3}\u{30AF}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3322}",
        nfc: "\u{3322}",
        nfd: "\u{3322}",
        nfkc: "\u{30BB}\u{30F3}\u{30C1}",
        nfkd: "\u{30BB}\u{30F3}\u{30C1}",
    },
    NormalizationTest {
        source: "\u{3323}",
        nfc: "\u{3323}",
        nfd: "\u{3323}",
        nfkc: "\u{30BB}\u{30F3}\u{30C8}",
        nfkd: "\u{30BB}\u{30F3}\u{30C8}",
    },
    NormalizationTest {
        source: "\u{3324}",
        nfc: "\u{3324}",
        nfd: "\u{3324}",
        nfkc: "\u{30C0}\u{30FC}\u{30B9}",
        nfkd: "\u{30BF}\u{3099}\u{30FC}\u{30B9}",
    },
    NormalizationTest {
        source: "\u{3325}",
        nfc: "\u{3325}",
        nfd: "\u{3325}",
        nfkc: "\u{30C7}\u{30B7}",
        nfkd: "\u{30C6}\u{3099}\u{30B7}",
    },
    NormalizationTest {
        source: "\u{3326}",
        nfc: "\u{3326}",
        nfd: "\u{3326}",
        nfkc: "\u{30C9}\u{30EB}",
        nfkd: "\u{30C8}\u{3099}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3327}",
        nfc: "\u{3327}",
        nfd: "\u{3327}",
        nfkc: "\u{30C8}\u{30F3}",
        nfkd: "\u{30C8}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{3328}",
        nfc: "\u{3328}",
        nfd: "\u{3328}",
        nfkc: "\u{30CA}\u{30CE}",
        nfkd: "\u{30CA}\u{30CE}",
    },
    NormalizationTest {
        source: "\u{3329}",
        nfc: "\u{3329}",
        nfd: "\u{3329}",
        nfkc: "\u{30CE}\u{30C3}\u{30C8}",
        nfkd: "\u{30CE}\u{30C3}\u{30C8}",
    },
    NormalizationTest {
        source: "\u{332A}",
        nfc: "\u{332A}",
        nfd: "\u{332A}",
        nfkc: "\u{30CF}\u{30A4}\u{30C4}",
        nfkd: "\u{30CF}\u{30A4}\u{30C4}",
    },
    NormalizationTest {
        source: "\u{332B}",
        nfc: "\u{332B}",
        nfd: "\u{332B}",
        nfkc: "\u{30D1}\u{30FC}\u{30BB}\u{30F3}\u{30C8}",
        nfkd: "\u{30CF}\u{309A}\u{30FC}\u{30BB}\u{30F3}\u{30C8}",
    },
    NormalizationTest {
        source: "\u{332C}",
        nfc: "\u{332C}",
        nfd: "\u{332C}",
        nfkc: "\u{30D1}\u{30FC}\u{30C4}",
        nfkd: "\u{30CF}\u{309A}\u{30FC}\u{30C4}",
    },
    NormalizationTest {
        source: "\u{332D}",
        nfc: "\u{332D}",
        nfd: "\u{332D}",
        nfkc: "\u{30D0}\u{30FC}\u{30EC}\u{30EB}",
        nfkd: "\u{30CF}\u{3099}\u{30FC}\u{30EC}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{332E}",
        nfc: "\u{332E}",
        nfd: "\u{332E}",
        nfkc: "\u{30D4}\u{30A2}\u{30B9}\u{30C8}\u{30EB}",
        nfkd: "\u{30D2}\u{309A}\u{30A2}\u{30B9}\u{30C8}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{332F}",
        nfc: "\u{332F}",
        nfd: "\u{332F}",
        nfkc: "\u{30D4}\u{30AF}\u{30EB}",
        nfkd: "\u{30D2}\u{309A}\u{30AF}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3330}",
        nfc: "\u{3330}",
        nfd: "\u{3330}",
        nfkc: "\u{30D4}\u{30B3}",
        nfkd: "\u{30D2}\u{309A}\u{30B3}",
    },
    NormalizationTest {
        source: "\u{3331}",
        nfc: "\u{3331}",
        nfd: "\u{3331}",
        nfkc: "\u{30D3}\u{30EB}",
        nfkd: "\u{30D2}\u{3099}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3332}",
        nfc: "\u{3332}",
        nfd: "\u{3332}",
        nfkc: "\u{30D5}\u{30A1}\u{30E9}\u{30C3}\u{30C9}",
        nfkd: "\u{30D5}\u{30A1}\u{30E9}\u{30C3}\u{30C8}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3333}",
        nfc: "\u{3333}",
        nfd: "\u{3333}",
        nfkc: "\u{30D5}\u{30A3}\u{30FC}\u{30C8}",
        nfkd: "\u{30D5}\u{30A3}\u{30FC}\u{30C8}",
    },
    NormalizationTest {
        source: "\u{3334}",
        nfc: "\u{3334}",
        nfd: "\u{3334}",
        nfkc: "\u{30D6}\u{30C3}\u{30B7}\u{30A7}\u{30EB}",
        nfkd: "\u{30D5}\u{3099}\u{30C3}\u{30B7}\u{30A7}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3335}",
        nfc: "\u{3335}",
        nfd: "\u{3335}",
        nfkc: "\u{30D5}\u{30E9}\u{30F3}",
        nfkd: "\u{30D5}\u{30E9}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{3336}",
        nfc: "\u{3336}",
        nfd: "\u{3336}",
        nfkc: "\u{30D8}\u{30AF}\u{30BF}\u{30FC}\u{30EB}",
        nfkd: "\u{30D8}\u{30AF}\u{30BF}\u{30FC}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3337}",
        nfc: "\u{3337}",
        nfd: "\u{3337}",
        nfkc: "\u{30DA}\u{30BD}",
        nfkd: "\u{30D8}\u{309A}\u{30BD}",
    },
    NormalizationTest {
        source: "\u{3338}",
        nfc: "\u{3338}",
        nfd: "\u{3338}",
        nfkc: "\u{30DA}\u{30CB}\u{30D2}",
        nfkd: "\u{30D8}\u{309A}\u{30CB}\u{30D2}",
    },
    NormalizationTest {
        source: "\u{3339}",
        nfc: "\u{3339}",
        nfd: "\u{3339}",
        nfkc: "\u{30D8}\u{30EB}\u{30C4}",
        nfkd: "\u{30D8}\u{30EB}\u{30C4}",
    },
    NormalizationTest {
        source: "\u{333A}",
        nfc: "\u{333A}",
        nfd: "\u{333A}",
        nfkc: "\u{30DA}\u{30F3}\u{30B9}",
        nfkd: "\u{30D8}\u{309A}\u{30F3}\u{30B9}",
    },
    NormalizationTest {
        source: "\u{333B}",
        nfc: "\u{333B}",
        nfd: "\u{333B}",
        nfkc: "\u{30DA}\u{30FC}\u{30B8}",
        nfkd: "\u{30D8}\u{309A}\u{30FC}\u{30B7}\u{3099}",
    },
    NormalizationTest {
        source: "\u{333C}",
        nfc: "\u{333C}",
        nfd: "\u{333C}",
        nfkc: "\u{30D9}\u{30FC}\u{30BF}",
        nfkd: "\u{30D8}\u{3099}\u{30FC}\u{30BF}",
    },
    NormalizationTest {
        source: "\u{333D}",
        nfc: "\u{333D}",
        nfd: "\u{333D}",
        nfkc: "\u{30DD}\u{30A4}\u{30F3}\u{30C8}",
        nfkd: "\u{30DB}\u{309A}\u{30A4}\u{30F3}\u{30C8}",
    },
    NormalizationTest {
        source: "\u{333E}",
        nfc: "\u{333E}",
        nfd: "\u{333E}",
        nfkc: "\u{30DC}\u{30EB}\u{30C8}",
        nfkd: "\u{30DB}\u{3099}\u{30EB}\u{30C8}",
    },
    NormalizationTest {
        source: "\u{333F}",
        nfc: "\u{333F}",
        nfd: "\u{333F}",
        nfkc: "\u{30DB}\u{30F3}",
        nfkd: "\u{30DB}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{3340}",
        nfc: "\u{3340}",
        nfd: "\u{3340}",
        nfkc: "\u{30DD}\u{30F3}\u{30C9}",
        nfkd: "\u{30DB}\u{309A}\u{30F3}\u{30C8}\u{3099}",
    },
    NormalizationTest {
        source: "\u{3341}",
        nfc: "\u{3341}",
        nfd: "\u{3341}",
        nfkc: "\u{30DB}\u{30FC}\u{30EB}",
        nfkd: "\u{30DB}\u{30FC}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3342}",
        nfc: "\u{3342}",
        nfd: "\u{3342}",
        nfkc: "\u{30DB}\u{30FC}\u{30F3}",
        nfkd: "\u{30DB}\u{30FC}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{3343}",
        nfc: "\u{3343}",
        nfd: "\u{3343}",
        nfkc: "\u{30DE}\u{30A4}\u{30AF}\u{30ED}",
        nfkd: "\u{30DE}\u{30A4}\u{30AF}\u{30ED}",
    },
    NormalizationTest {
        source: "\u{3344}",
        nfc: "\u{3344}",
        nfd: "\u{3344}",
        nfkc: "\u{30DE}\u{30A4}\u{30EB}",
        nfkd: "\u{30DE}\u{30A4}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3345}",
        nfc: "\u{3345}",
        nfd: "\u{3345}",
        nfkc: "\u{30DE}\u{30C3}\u{30CF}",
        nfkd: "\u{30DE}\u{30C3}\u{30CF}",
    },
    NormalizationTest {
        source: "\u{3346}",
        nfc: "\u{3346}",
        nfd: "\u{3346}",
        nfkc: "\u{30DE}\u{30EB}\u{30AF}",
        nfkd: "\u{30DE}\u{30EB}\u{30AF}",
    },
    NormalizationTest {
        source: "\u{3347}",
        nfc: "\u{3347}",
        nfd: "\u{3347}",
        nfkc: "\u{30DE}\u{30F3}\u{30B7}\u{30E7}\u{30F3}",
        nfkd: "\u{30DE}\u{30F3}\u{30B7}\u{30E7}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{3348}",
        nfc: "\u{3348}",
        nfd: "\u{3348}",
        nfkc: "\u{30DF}\u{30AF}\u{30ED}\u{30F3}",
        nfkd: "\u{30DF}\u{30AF}\u{30ED}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{3349}",
        nfc: "\u{3349}",
        nfd: "\u{3349}",
        nfkc: "\u{30DF}\u{30EA}",
        nfkd: "\u{30DF}\u{30EA}",
    },
    NormalizationTest {
        source: "\u{334A}",
        nfc: "\u{334A}",
        nfd: "\u{334A}",
        nfkc: "\u{30DF}\u{30EA}\u{30D0}\u{30FC}\u{30EB}",
        nfkd: "\u{30DF}\u{30EA}\u{30CF}\u{3099}\u{30FC}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{334B}",
        nfc: "\u{334B}",
        nfd: "\u{334B}",
        nfkc: "\u{30E1}\u{30AC}",
        nfkd: "\u{30E1}\u{30AB}\u{3099}",
    },
    NormalizationTest {
        source: "\u{334C}",
        nfc: "\u{334C}",
        nfd: "\u{334C}",
        nfkc: "\u{30E1}\u{30AC}\u{30C8}\u{30F3}",
        nfkd: "\u{30E1}\u{30AB}\u{3099}\u{30C8}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{334D}",
        nfc: "\u{334D}",
        nfd: "\u{334D}",
        nfkc: "\u{30E1}\u{30FC}\u{30C8}\u{30EB}",
        nfkd: "\u{30E1}\u{30FC}\u{30C8}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{334E}",
        nfc: "\u{334E}",
        nfd: "\u{334E}",
        nfkc: "\u{30E4}\u{30FC}\u{30C9}",
        nfkd: "\u{30E4}\u{30FC}\u{30C8}\u{3099}",
    },
    NormalizationTest {
        source: "\u{334F}",
        nfc: "\u{334F}",
        nfd: "\u{334F}",
        nfkc: "\u{30E4}\u{30FC}\u{30EB}",
        nfkd: "\u{30E4}\u{30FC}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3350}",
        nfc: "\u{3350}",
        nfd: "\u{3350}",
        nfkc: "\u{30E6}\u{30A2}\u{30F3}",
        nfkd: "\u{30E6}\u{30A2}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{3351}",
        nfc: "\u{3351}",
        nfd: "\u{3351}",
        nfkc: "\u{30EA}\u{30C3}\u{30C8}\u{30EB}",
        nfkd: "\u{30EA}\u{30C3}\u{30C8}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3352}",
        nfc: "\u{3352}",
        nfd: "\u{3352}",
        nfkc: "\u{30EA}\u{30E9}",
        nfkd: "\u{30EA}\u{30E9}",
    },
    NormalizationTest {
        source: "\u{3353}",
        nfc: "\u{3353}",
        nfd: "\u{3353}",
        nfkc: "\u{30EB}\u{30D4}\u{30FC}",
        nfkd: "\u{30EB}\u{30D2}\u{309A}\u{30FC}",
    },
    NormalizationTest {
        source: "\u{3354}",
        nfc: "\u{3354}",
        nfd: "\u{3354}",
        nfkc: "\u{30EB}\u{30FC}\u{30D6}\u{30EB}",
        nfkd: "\u{30EB}\u{30FC}\u{30D5}\u{3099}\u{30EB}",
    },
    NormalizationTest {
        source: "\u{3355}",
        nfc: "\u{3355}",
        nfd: "\u{3355}",
        nfkc: "\u{30EC}\u{30E0}",
        nfkd: "\u{30EC}\u{30E0}",
    },
    NormalizationTest {
        source: "\u{3356}",
        nfc: "\u{3356}",
        nfd: "\u{3356}",
        nfkc: "\u{30EC}\u{30F3}\u{30C8}\u{30B2}\u{30F3}",
        nfkd: "\u{30EC}\u{30F3}\u{30C8}\u{30B1}\u{3099}\u{30F3}",
    },
    NormalizationTest {
        source: "\u{3357}",
        nfc: "\u{3357}",
        nfd: "\u{3357}",
        nfkc: "\u{30EF}\u{30C3}\u{30C8}",
        nfkd: "\u{30EF}\u{30C3}\u{30C8}",
    },
    NormalizationTest {
        source: "\u{3358}",
        nfc: "\u{3358}",
        nfd: "\u{3358}",
        nfkc: "\u{0030}\u{70B9}",
        nfkd: "\u{0030}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3359}",
        nfc: "\u{3359}",
        nfd: "\u{3359}",
        nfkc: "\u{0031}\u{70B9}",
        nfkd: "\u{0031}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{335A}",
        nfc: "\u{335A}",
        nfd: "\u{335A}",
        nfkc: "\u{0032}\u{70B9}",
        nfkd: "\u{0032}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{335B}",
        nfc: "\u{335B}",
        nfd: "\u{335B}",
        nfkc: "\u{0033}\u{70B9}",
        nfkd: "\u{0033}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{335C}",
        nfc: "\u{335C}",
        nfd: "\u{335C}",
        nfkc: "\u{0034}\u{70B9}",
        nfkd: "\u{0034}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{335D}",
        nfc: "\u{335D}",
        nfd: "\u{335D}",
        nfkc: "\u{0035}\u{70B9}",
        nfkd: "\u{0035}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{335E}",
        nfc: "\u{335E}",
        nfd: "\u{335E}",
        nfkc: "\u{0036}\u{70B9}",
        nfkd: "\u{0036}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{335F}",
        nfc: "\u{335F}",
        nfd: "\u{335F}",
        nfkc: "\u{0037}\u{70B9}",
        nfkd: "\u{0037}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3360}",
        nfc: "\u{3360}",
        nfd: "\u{3360}",
        nfkc: "\u{0038}\u{70B9}",
        nfkd: "\u{0038}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3361}",
        nfc: "\u{3361}",
        nfd: "\u{3361}",
        nfkc: "\u{0039}\u{70B9}",
        nfkd: "\u{0039}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3362}",
        nfc: "\u{3362}",
        nfd: "\u{3362}",
        nfkc: "\u{0031}\u{0030}\u{70B9}",
        nfkd: "\u{0031}\u{0030}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3363}",
        nfc: "\u{3363}",
        nfd: "\u{3363}",
        nfkc: "\u{0031}\u{0031}\u{70B9}",
        nfkd: "\u{0031}\u{0031}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3364}",
        nfc: "\u{3364}",
        nfd: "\u{3364}",
        nfkc: "\u{0031}\u{0032}\u{70B9}",
        nfkd: "\u{0031}\u{0032}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3365}",
        nfc: "\u{3365}",
        nfd: "\u{3365}",
        nfkc: "\u{0031}\u{0033}\u{70B9}",
        nfkd: "\u{0031}\u{0033}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3366}",
        nfc: "\u{3366}",
        nfd: "\u{3366}",
        nfkc: "\u{0031}\u{0034}\u{70B9}",
        nfkd: "\u{0031}\u{0034}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3367}",
        nfc: "\u{3367}",
        nfd: "\u{3367}",
        nfkc: "\u{0031}\u{0035}\u{70B9}",
        nfkd: "\u{0031}\u{0035}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3368}",
        nfc: "\u{3368}",
        nfd: "\u{3368}",
        nfkc: "\u{0031}\u{0036}\u{70B9}",
        nfkd: "\u{0031}\u{0036}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3369}",
        nfc: "\u{3369}",
        nfd: "\u{3369}",
        nfkc: "\u{0031}\u{0037}\u{70B9}",
        nfkd: "\u{0031}\u{0037}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{336A}",
        nfc: "\u{336A}",
        nfd: "\u{336A}",
        nfkc: "\u{0031}\u{0038}\u{70B9}",
        nfkd: "\u{0031}\u{0038}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{336B}",
        nfc: "\u{336B}",
        nfd: "\u{336B}",
        nfkc: "\u{0031}\u{0039}\u{70B9}",
        nfkd: "\u{0031}\u{0039}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{336C}",
        nfc: "\u{336C}",
        nfd: "\u{336C}",
        nfkc: "\u{0032}\u{0030}\u{70B9}",
        nfkd: "\u{0032}\u{0030}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{336D}",
        nfc: "\u{336D}",
        nfd: "\u{336D}",
        nfkc: "\u{0032}\u{0031}\u{70B9}",
        nfkd: "\u{0032}\u{0031}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{336E}",
        nfc: "\u{336E}",
        nfd: "\u{336E}",
        nfkc: "\u{0032}\u{0032}\u{70B9}",
        nfkd: "\u{0032}\u{0032}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{336F}",
        nfc: "\u{336F}",
        nfd: "\u{336F}",
        nfkc: "\u{0032}\u{0033}\u{70B9}",
        nfkd: "\u{0032}\u{0033}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3370}",
        nfc: "\u{3370}",
        nfd: "\u{3370}",
        nfkc: "\u{0032}\u{0034}\u{70B9}",
        nfkd: "\u{0032}\u{0034}\u{70B9}",
    },
    NormalizationTest {
        source: "\u{3371}",
        nfc: "\u{3371}",
        nfd: "\u{3371}",
        nfkc: "\u{0068}\u{0050}\u{0061}",
        nfkd: "\u{0068}\u{0050}\u{0061}",
    },
    NormalizationTest {
        source: "\u{3372}",
        nfc: "\u{3372}",
        nfd: "\u{3372}",
        nfkc: "\u{0064}\u{0061}",
        nfkd: "\u{0064}\u{0061}",
    },
    NormalizationTest {
        source: "\u{3373}",
        nfc: "\u{3373}",
        nfd: "\u{3373}",
        nfkc: "\u{0041}\u{0055}",
        nfkd: "\u{0041}\u{0055}",
    },
    NormalizationTest {
        source: "\u{3374}",
        nfc: "\u{3374}",
        nfd: "\u{3374}",
        nfkc: "\u{0062}\u{0061}\u{0072}",
        nfkd: "\u{0062}\u{0061}\u{0072}",
    },
    NormalizationTest {
        source: "\u{3375}",
        nfc: "\u{3375}",
        nfd: "\u{3375}",
        nfkc: "\u{006F}\u{0056}",
        nfkd: "\u{006F}\u{0056}",
    },
    NormalizationTest {
        source: "\u{3376}",
        nfc: "\u{3376}",
        nfd: "\u{3376}",
        nfkc: "\u{0070}\u{0063}",
        nfkd: "\u{0070}\u{0063}",
    },
    NormalizationTest {
        source: "\u{3377}",
        nfc: "\u{3377}",
        nfd: "\u{3377}",
        nfkc: "\u{0064}\u{006D}",
        nfkd: "\u{0064}\u{006D}",
    },
    NormalizationTest {
        source: "\u{3378}",
        nfc: "\u{3378}",
        nfd: "\u{3378}",
        nfkc: "\u{0064}\u{006D}\u{0032}",
        nfkd: "\u{0064}\u{006D}\u{0032}",
    },
    NormalizationTest {
        source: "\u{3379}",
        nfc: "\u{3379}",
        nfd: "\u{3379}",
        nfkc: "\u{0064}\u{006D}\u{0033}",
        nfkd: "\u{0064}\u{006D}\u{0033}",
    },
    NormalizationTest {
        source: "\u{337A}",
        nfc: "\u{337A}",
        nfd: "\u{337A}",
        nfkc: "\u{0049}\u{0055}",
        nfkd: "\u{0049}\u{0055}",
    },
    NormalizationTest {
        source: "\u{337B}",
        nfc: "\u{337B}",
        nfd: "\u{337B}",
        nfkc: "\u{5E73}\u{6210}",
        nfkd: "\u{5E73}\u{6210}",
    },
    NormalizationTest {
        source: "\u{337C}",
        nfc: "\u{337C}",
        nfd: "\u{337C}",
        nfkc: "\u{662D}\u{548C}",
        nfkd: "\u{662D}\u{548C}",
    },
    NormalizationTest {
        source: "\u{337D}",
        nfc: "\u{337D}",
        nfd: "\u{337D}",
        nfkc: "\u{5927}\u{6B63}",
        nfkd: "\u{5927}\u{6B63}",
    },
    NormalizationTest {
        source: "\u{337E}",
        nfc: "\u{337E}",
        nfd: "\u{337E}",
        nfkc: "\u{660E}\u{6CBB}",
        nfkd: "\u{660E}\u{6CBB}",
    },
    NormalizationTest {
        source: "\u{337F}",
        nfc: "\u{337F}",
        nfd: "\u{337F}",
        nfkc: "\u{682A}\u{5F0F}\u{4F1A}\u{793E}",
        nfkd: "\u{682A}\u{5F0F}\u{4F1A}\u{793E}",
    },
    NormalizationTest {
        source: "\u{3380}",
        nfc: "\u{3380}",
        nfd: "\u{3380}",
        nfkc: "\u{0070}\u{0041}",
        nfkd: "\u{0070}\u{0041}",
    },
    NormalizationTest {
        source: "\u{3381}",
        nfc: "\u{3381}",
        nfd: "\u{3381}",
        nfkc: "\u{006E}\u{0041}",
        nfkd: "\u{006E}\u{0041}",
    },
    NormalizationTest {
        source: "\u{3382}",
        nfc: "\u{3382}",
        nfd: "\u{3382}",
        nfkc: "\u{03BC}\u{0041}",
        nfkd: "\u{03BC}\u{0041}",
    },
    NormalizationTest {
        source: "\u{3383}",
        nfc: "\u{3383}",
        nfd: "\u{3383}",
        nfkc: "\u{006D}\u{0041}",
        nfkd: "\u{006D}\u{0041}",
    },
    NormalizationTest {
        source: "\u{3384}",
        nfc: "\u{3384}",
        nfd: "\u{3384}",
        nfkc: "\u{006B}\u{0041}",
        nfkd: "\u{006B}\u{0041}",
    },
    NormalizationTest {
        source: "\u{3385}",
        nfc: "\u{3385}",
        nfd: "\u{3385}",
        nfkc: "\u{004B}\u{0042}",
        nfkd: "\u{004B}\u{0042}",
    },
    NormalizationTest {
        source: "\u{3386}",
        nfc: "\u{3386}",
        nfd: "\u{3386}",
        nfkc: "\u{004D}\u{0042}",
        nfkd: "\u{004D}\u{0042}",
    },
    NormalizationTest {
        source: "\u{3387}",
        nfc: "\u{3387}",
        nfd: "\u{3387}",
        nfkc: "\u{0047}\u{0042}",
        nfkd: "\u{0047}\u{0042}",
    },
    NormalizationTest {
        source: "\u{3388}",
        nfc: "\u{3388}",
        nfd: "\u{3388}",
        nfkc: "\u{0063}\u{0061}\u{006C}",
        nfkd: "\u{0063}\u{0061}\u{006C}",
    },
    NormalizationTest {
        source: "\u{3389}",
        nfc: "\u{3389}",
        nfd: "\u{3389}",
        nfkc: "\u{006B}\u{0063}\u{0061}\u{006C}",
        nfkd: "\u{006B}\u{0063}\u{0061}\u{006C}",
    },
    NormalizationTest {
        source: "\u{338A}",
        nfc: "\u{338A}",
        nfd: "\u{338A}",
        nfkc: "\u{0070}\u{0046}",
        nfkd: "\u{0070}\u{0046}",
    },
    NormalizationTest {
        source: "\u{338B}",
        nfc: "\u{338B}",
        nfd: "\u{338B}",
        nfkc: "\u{006E}\u{0046}",
        nfkd: "\u{006E}\u{0046}",
    },
    NormalizationTest {
        source: "\u{338C}",
        nfc: "\u{338C}",
        nfd: "\u{338C}",
        nfkc: "\u{03BC}\u{0046}",
        nfkd: "\u{03BC}\u{0046}",
    },
    NormalizationTest {
        source: "\u{338D}",
        nfc: "\u{338D}",
        nfd: "\u{338D}",
        nfkc: "\u{03BC}\u{0067}",
        nfkd: "\u{03BC}\u{0067}",
    },
    NormalizationTest {
        source: "\u{338E}",
        nfc: "\u{338E}",
        nfd: "\u{338E}",
        nfkc: "\u{006D}\u{0067}",
        nfkd: "\u{006D}\u{0067}",
    },
    NormalizationTest {
        source: "\u{338F}",
        nfc: "\u{338F}",
        nfd: "\u{338F}",
        nfkc: "\u{006B}\u{0067}",
        nfkd: "\u{006B}\u{0067}",
    },
    NormalizationTest {
        source: "\u{3390}",
        nfc: "\u{3390}",
        nfd: "\u{3390}",
        nfkc: "\u{0048}\u{007A}",
        nfkd: "\u{0048}\u{007A}",
    },
    NormalizationTest {
        source: "\u{3391}",
        nfc: "\u{3391}",
        nfd: "\u{3391}",
        nfkc: "\u{006B}\u{0048}\u{007A}",
        nfkd: "\u{006B}\u{0048}\u{007A}",
    },
    NormalizationTest {
        source: "\u{3392}",
        nfc: "\u{3392}",
        nfd: "\u{3392}",
        nfkc: "\u{004D}\u{0048}\u{007A}",
        nfkd: "\u{004D}\u{0048}\u{007A}",
    },
    NormalizationTest {
        source: "\u{3393}",
        nfc: "\u{3393}",
        nfd: "\u{3393}",
        nfkc: "\u{0047}\u{0048}\u{007A}",
        nfkd: "\u{0047}\u{0048}\u{007A}",
    },
    NormalizationTest {
        source: "\u{3394}",
        nfc: "\u{3394}",
        nfd: "\u{3394}",
        nfkc: "\u{0054}\u{0048}\u{007A}",
        nfkd: "\u{0054}\u{0048}\u{007A}",
    },
    NormalizationTest {
        source: "\u{3395}",
        nfc: "\u{3395}",
        nfd: "\u{3395}",
        nfkc: "\u{03BC}\u{006C}",
        nfkd: "\u{03BC}\u{006C}",
    },
    NormalizationTest {
        source: "\u{3396}",
        nfc: "\u{3396}",
        nfd: "\u{3396}",
        nfkc: "\u{006D}\u{006C}",
        nfkd: "\u{006D}\u{006C}",
    },
    NormalizationTest {
        source: "\u{3397}",
        nfc: "\u{3397}",
        nfd: "\u{3397}",
        nfkc: "\u{0064}\u{006C}",
        nfkd: "\u{0064}\u{006C}",
    },
    NormalizationTest {
        source: "\u{3398}",
        nfc: "\u{3398}",
        nfd: "\u{3398}",
        nfkc: "\u{006B}\u{006C}",
        nfkd: "\u{006B}\u{006C}",
    },
    NormalizationTest {
        source: "\u{3399}",
        nfc: "\u{3399}",
        nfd: "\u{3399}",
        nfkc: "\u{0066}\u{006D}",
        nfkd: "\u{0066}\u{006D}",
    },
    NormalizationTest {
        source: "\u{339A}",
        nfc: "\u{339A}",
        nfd: "\u{339A}",
        nfkc: "\u{006E}\u{006D}",
        nfkd: "\u{006E}\u{006D}",
    },
    NormalizationTest {
        source: "\u{339B}",
        nfc: "\u{339B}",
        nfd: "\u{339B}",
        nfkc: "\u{03BC}\u{006D}",
        nfkd: "\u{03BC}\u{006D}",
    },
    NormalizationTest {
        source: "\u{339C}",
        nfc: "\u{339C}",
        nfd: "\u{339C}",
        nfkc: "\u{006D}\u{006D}",
        nfkd: "\u{006D}\u{006D}",
    },
    NormalizationTest {
        source: "\u{339D}",
        nfc: "\u{339D}",
        nfd: "\u{339D}",
        nfkc: "\u{0063}\u{006D}",
        nfkd: "\u{0063}\u{006D}",
    },
    NormalizationTest {
        source: "\u{339E}",
        nfc: "\u{339E}",
        nfd: "\u{339E}",
        nfkc: "\u{006B}\u{006D}",
        nfkd: "\u{006B}\u{006D}",
    },
    NormalizationTest {
        source: "\u{339F}",
        nfc: "\u{339F}",
        nfd: "\u{339F}",
        nfkc: "\u{006D}\u{006D}\u{0032}",
        nfkd: "\u{006D}\u{006D}\u{0032}",
    },
    NormalizationTest {
        source: "\u{33A0}",
        nfc: "\u{33A0}",
        nfd: "\u{33A0}",
        nfkc: "\u{0063}\u{006D}\u{0032}",
        nfkd: "\u{0063}\u{006D}\u{0032}",
    },
    NormalizationTest {
        source: "\u{33A1}",
        nfc: "\u{33A1}",
        nfd: "\u{33A1}",
        nfkc: "\u{006D}\u{0032}",
        nfkd: "\u{006D}\u{0032}",
    },
    NormalizationTest {
        source: "\u{33A2}",
        nfc: "\u{33A2}",
        nfd: "\u{33A2}",
        nfkc: "\u{006B}\u{006D}\u{0032}",
        nfkd: "\u{006B}\u{006D}\u{0032}",
    },
    NormalizationTest {
        source: "\u{33A3}",
        nfc: "\u{33A3}",
        nfd: "\u{33A3}",
        nfkc: "\u{006D}\u{006D}\u{0033}",
        nfkd: "\u{006D}\u{006D}\u{0033}",
    },
    NormalizationTest {
        source: "\u{33A4}",
        nfc: "\u{33A4}",
        nfd: "\u{33A4}",
        nfkc: "\u{0063}\u{006D}\u{0033}",
        nfkd: "\u{0063}\u{006D}\u{0033}",
    },
    NormalizationTest {
        source: "\u{33A5}",
        nfc: "\u{33A5}",
        nfd: "\u{33A5}",
        nfkc: "\u{006D}\u{0033}",
        nfkd: "\u{006D}\u{0033}",
    },
    NormalizationTest {
        source: "\u{33A6}",
        nfc: "\u{33A6}",
        nfd: "\u{33A6}",
        nfkc: "\u{006B}\u{006D}\u{0033}",
        nfkd: "\u{006B}\u{006D}\u{0033}",
    },
    NormalizationTest {
        source: "\u{33A7}",
        nfc: "\u{33A7}",
        nfd: "\u{33A7}",
        nfkc: "\u{006D}\u{2215}\u{0073}",
        nfkd: "\u{006D}\u{2215}\u{0073}",
    },
    NormalizationTest {
        source: "\u{33A8}",
        nfc: "\u{33A8}",
        nfd: "\u{33A8}",
        nfkc: "\u{006D}\u{2215}\u{0073}\u{0032}",
        nfkd: "\u{006D}\u{2215}\u{0073}\u{0032}",
    },
    NormalizationTest {
        source: "\u{33A9}",
        nfc: "\u{33A9}",
        nfd: "\u{33A9}",
        nfkc: "\u{0050}\u{0061}",
        nfkd: "\u{0050}\u{0061}",
    },
    NormalizationTest {
        source: "\u{33AA}",
        nfc: "\u{33AA}",
        nfd: "\u{33AA}",
        nfkc: "\u{006B}\u{0050}\u{0061}",
        nfkd: "\u{006B}\u{0050}\u{0061}",
    },
    NormalizationTest {
        source: "\u{33AB}",
        nfc: "\u{33AB}",
        nfd: "\u{33AB}",
        nfkc: "\u{004D}\u{0050}\u{0061}",
        nfkd: "\u{004D}\u{0050}\u{0061}",
    },
    NormalizationTest {
        source: "\u{33AC}",
        nfc: "\u{33AC}",
        nfd: "\u{33AC}",
        nfkc: "\u{0047}\u{0050}\u{0061}",
        nfkd: "\u{0047}\u{0050}\u{0061}",
    },
    NormalizationTest {
        source: "\u{33AD}",
        nfc: "\u{33AD}",
        nfd: "\u{33AD}",
        nfkc: "\u{0072}\u{0061}\u{0064}",
        nfkd: "\u{0072}\u{0061}\u{0064}",
    },
    NormalizationTest {
        source: "\u{33AE}",
        nfc: "\u{33AE}",
        nfd: "\u{33AE}",
        nfkc: "\u{0072}\u{0061}\u{0064}\u{2215}\u{0073}",
        nfkd: "\u{0072}\u{0061}\u{0064}\u{2215}\u{0073}",
    },
    NormalizationTest {
        source: "\u{33AF}",
        nfc: "\u{33AF}",
        nfd: "\u{33AF}",
        nfkc: "\u{0072}\u{0061}\u{0064}\u{2215}\u{0073}\u{0032}",
        nfkd: "\u{0072}\u{0061}\u{0064}\u{2215}\u{0073}\u{0032}",
    },
    NormalizationTest {
        source: "\u{33B0}",
        nfc: "\u{33B0}",
        nfd: "\u{33B0}",
        nfkc: "\u{0070}\u{0073}",
        nfkd: "\u{0070}\u{0073}",
    },
    NormalizationTest {
        source: "\u{33B1}",
        nfc: "\u{33B1}",
        nfd: "\u{33B1}",
        nfkc: "\u{006E}\u{0073}",
        nfkd: "\u{006E}\u{0073}",
    },
    NormalizationTest {
        source: "\u{33B2}",
        nfc: "\u{33B2}",
        nfd: "\u{33B2}",
        nfkc: "\u{03BC}\u{0073}",
        nfkd: "\u{03BC}\u{0073}",
    },
    NormalizationTest {
        source: "\u{33B3}",
        nfc: "\u{33B3}",
        nfd: "\u{33B3}",
        nfkc: "\u{006D}\u{0073}",
        nfkd: "\u{006D}\u{0073}",
    },
    NormalizationTest {
        source: "\u{33B4}",
        nfc: "\u{33B4}",
        nfd: "\u{33B4}",
        nfkc: "\u{0070}\u{0056}",
        nfkd: "\u{0070}\u{0056}",
    },
    NormalizationTest {
        source: "\u{33B5}",
        nfc: "\u{33B5}",
        nfd: "\u{33B5}",
        nfkc: "\u{006E}\u{0056}",
        nfkd: "\u{006E}\u{0056}",
    },
    NormalizationTest {
        source: "\u{33B6}",
        nfc: "\u{33B6}",
        nfd: "\u{33B6}",
        nfkc: "\u{03BC}\u{0056}",
        nfkd: "\u{03BC}\u{0056}",
    },
    NormalizationTest {
        source: "\u{33B7}",
        nfc: "\u{33B7}",
        nfd: "\u{33B7}",
        nfkc: "\u{006D}\u{0056}",
        nfkd: "\u{006D}\u{0056}",
    },
    NormalizationTest {
        source: "\u{33B8}",
        nfc: "\u{33B8}",
        nfd: "\u{33B8}",
        nfkc: "\u{006B}\u{0056}",
        nfkd: "\u{006B}\u{0056}",
    },
    NormalizationTest {
        source: "\u{33B9}",
        nfc: "\u{33B9}",
        nfd: "\u{33B9}",
        nfkc: "\u{004D}\u{0056}",
        nfkd: "\u{004D}\u{0056}",
    },
    NormalizationTest {
        source: "\u{33BA}",
        nfc: "\u{33BA}",
        nfd: "\u{33BA}",
        nfkc: "\u{0070}\u{0057}",
        nfkd: "\u{0070}\u{0057}",
    },
    NormalizationTest {
        source: "\u{33BB}",
        nfc: "\u{33BB}",
        nfd: "\u{33BB}",
        nfkc: "\u{006E}\u{0057}",
        nfkd: "\u{006E}\u{0057}",
    },
    NormalizationTest {
        source: "\u{33BC}",
        nfc: "\u{33BC}",
        nfd: "\u{33BC}",
        nfkc: "\u{03BC}\u{0057}",
        nfkd: "\u{03BC}\u{0057}",
    },
    NormalizationTest {
        source: "\u{33BD}",
        nfc: "\u{33BD}",
        nfd: "\u{33BD}",
        nfkc: "\u{006D}\u{0057}",
        nfkd: "\u{006D}\u{0057}",
    },
    NormalizationTest {
        source: "\u{33BE}",
        nfc: "\u{33BE}",
        nfd: "\u{33BE}",
        nfkc: "\u{006B}\u{0057}",
        nfkd: "\u{006B}\u{0057}",
    },
    NormalizationTest {
        source: "\u{33BF}",
        nfc: "\u{33BF}",
        nfd: "\u{33BF}",
        nfkc: "\u{004D}\u{0057}",
        nfkd: "\u{004D}\u{0057}",
    },
    NormalizationTest {
        source: "\u{33C0}",
        nfc: "\u{33C0}",
        nfd: "\u{33C0}",
        nfkc: "\u{006B}\u{03A9}",
        nfkd: "\u{006B}\u{03A9}",
    },
    NormalizationTest {
        source: "\u{33C1}",
        nfc: "\u{33C1}",
        nfd: "\u{33C1}",
        nfkc: "\u{004D}\u{03A9}",
        nfkd: "\u{004D}\u{03A9}",
    },
    NormalizationTest {
        source: "\u{33C2}",
        nfc: "\u{33C2}",
        nfd: "\u{33C2}",
        nfkc: "\u{0061}\u{002E}\u{006D}\u{002E}",
        nfkd: "\u{0061}\u{002E}\u{006D}\u{002E}",
    },
    NormalizationTest {
        source: "\u{33C3}",
        nfc: "\u{33C3}",
        nfd: "\u{33C3}",
        nfkc: "\u{0042}\u{0071}",
        nfkd: "\u{0042}\u{0071}",
    },
    NormalizationTest {
        source: "\u{33C4}",
        nfc: "\u{33C4}",
        nfd: "\u{33C4}",
        nfkc: "\u{0063}\u{0063}",
        nfkd: "\u{0063}\u{0063}",
    },
    NormalizationTest {
        source: "\u{33C5}",
        nfc: "\u{33C5}",
        nfd: "\u{33C5}",
        nfkc: "\u{0063}\u{0064}",
        nfkd: "\u{0063}\u{0064}",
    },
    NormalizationTest {
        source: "\u{33C6}",
        nfc: "\u{33C6}",
        nfd: "\u{33C6}",
        nfkc: "\u{0043}\u{2215}\u{006B}\u{0067}",
        nfkd: "\u{0043}\u{2215}\u{006B}\u{0067}",
    },
    NormalizationTest {
        source: "\u{33C7}",
        nfc: "\u{33C7}",
        nfd: "\u{33C7}",
        nfkc: "\u{0043}\u{006F}\u{002E}",
        nfkd: "\u{0043}\u{006F}\u{002E}",
    },
    NormalizationTest {
        source: "\u{33C8}",
        nfc: "\u{33C8}",
        nfd: "\u{33C8}",
        nfkc: "\u{0064}\u{0042}",
        nfkd: "\u{0064}\u{0042}",
    },
    NormalizationTest {
        source: "\u{33C9}",
        nfc: "\u{33C9}",
        nfd: "\u{33C9}",
        nfkc: "\u{0047}\u{0079}",
        nfkd: "\u{0047}\u{0079}",
    },
    NormalizationTest {
        source: "\u{33CA}",
        nfc: "\u{33CA}",
        nfd: "\u{33CA}",
        nfkc: "\u{0068}\u{0061}",
        nfkd: "\u{0068}\u{0061}",
    },
    NormalizationTest {
        source: "\u{33CB}",
        nfc: "\u{33CB}",
        nfd: "\u{33CB}",
        nfkc: "\u{0048}\u{0050}",
        nfkd: "\u{0048}\u{0050}",
    },
    NormalizationTest {
        source: "\u{33CC}",
        nfc: "\u{33CC}",
        nfd: "\u{33CC}",
        nfkc: "\u{0069}\u{006E}",
        nfkd: "\u{0069}\u{006E}",
    },
    NormalizationTest {
        source: "\u{33CD}",
        nfc: "\u{33CD}",
        nfd: "\u{33CD}",
        nfkc: "\u{004B}\u{004B}",
        nfkd: "\u{004B}\u{004B}",
    },
    NormalizationTest {
        source: "\u{33CE}",
        nfc: "\u{33CE}",
        nfd: "\u{33CE}",
        nfkc: "\u{004B}\u{004D}",
        nfkd: "\u{004B}\u{004D}",
    },
    NormalizationTest {
        source: "\u{33CF}",
        nfc: "\u{33CF}",
        nfd: "\u{33CF}",
        nfkc: "\u{006B}\u{0074}",
        nfkd: "\u{006B}\u{0074}",
    },
    NormalizationTest {
        source: "\u{33D0}",
        nfc: "\u{33D0}",
        nfd: "\u{33D0}",
        nfkc: "\u{006C}\u{006D}",
        nfkd: "\u{006C}\u{006D}",
    },
    NormalizationTest {
        source: "\u{33D1}",
        nfc: "\u{33D1}",
        nfd: "\u{33D1}",
        nfkc: "\u{006C}\u{006E}",
        nfkd: "\u{006C}\u{006E}",
    },
    NormalizationTest {
        source: "\u{33D2}",
        nfc: "\u{33D2}",
        nfd: "\u{33D2}",
        nfkc: "\u{006C}\u{006F}\u{0067}",
        nfkd: "\u{006C}\u{006F}\u{0067}",
    },
    NormalizationTest {
        source: "\u{33D3}",
        nfc: "\u{33D3}",
        nfd: "\u{33D3}",
        nfkc: "\u{006C}\u{0078}",
        nfkd: "\u{006C}\u{0078}",
    },
    NormalizationTest {
        source: "\u{33D4}",
        nfc: "\u{33D4}",
        nfd: "\u{33D4}",
        nfkc: "\u{006D}\u{0062}",
        nfkd: "\u{006D}\u{0062}",
    },
    NormalizationTest {
        source: "\u{33D5}",
        nfc: "\u{33D5}",
        nfd: "\u{33D5}",
        nfkc: "\u{006D}\u{0069}\u{006C}",
        nfkd: "\u{006D}\u{0069}\u{006C}",
    },
    NormalizationTest {
        source: "\u{33D6}",
        nfc: "\u{33D6}",
        nfd: "\u{33D6}",
        nfkc: "\u{006D}\u{006F}\u{006C}",
        nfkd: "\u{006D}\u{006F}\u{006C}",
    },
    NormalizationTest {
        source: "\u{33D7}",
        nfc: "\u{33D7}",
        nfd: "\u{33D7}",
        nfkc: "\u{0050}\u{0048}",
        nfkd: "\u{0050}\u{0048}",
    },
    NormalizationTest {
        source: "\u{33D8}",
        nfc: "\u{33D8}",
        nfd: "\u{33D8}",
        nfkc: "\u{0070}\u{002E}\u{006D}\u{002E}",
        nfkd: "\u{0070}\u{002E}\u{006D}\u{002E}",
    },
    NormalizationTest {
        source: "\u{33D9}",
        nfc: "\u{33D9}",
        nfd: "\u{33D9}",
        nfkc: "\u{0050}\u{0050}\u{004D}",
        nfkd: "\u{0050}\u{0050}\u{004D}",
    },
    NormalizationTest {
        source: "\u{33DA}",
        nfc: "\u{33DA}",
        nfd: "\u{33DA}",
        nfkc: "\u{0050}\u{0052}",
        nfkd: "\u{0050}\u{0052}",
    },
    NormalizationTest {
        source: "\u{33DB}",
        nfc: "\u{33DB}",
        nfd: "\u{33DB}",
        nfkc: "\u{0073}\u{0072}",
        nfkd: "\u{0073}\u{0072}",
    },
    NormalizationTest {
        source: "\u{33DC}",
        nfc: "\u{33DC}",
        nfd: "\u{33DC}",
        nfkc: "\u{0053}\u{0076}",
        nfkd: "\u{0053}\u{0076}",
    },
    NormalizationTest {
        source: "\u{33DD}",
        nfc: "\u{33DD}",
        nfd: "\u{33DD}",
        nfkc: "\u{0057}\u{0062}",
        nfkd: "\u{0057}\u{0062}",
    },
    NormalizationTest {
        source: "\u{33DE}",
        nfc: "\u{33DE}",
        nfd: "\u{33DE}",
        nfkc: "\u{0056}\u{2215}\u{006D}",
        nfkd: "\u{0056}\u{2215}\u{006D}",
    },
    NormalizationTest {
        source: "\u{33DF}",
        nfc: "\u{33DF}",
        nfd: "\u{33DF}",
        nfkc: "\u{0041}\u{2215}\u{006D}",
        nfkd: "\u{0041}\u{2215}\u{006D}",
    },
    NormalizationTest {
        source: "\u{33E0}",
        nfc: "\u{33E0}",
        nfd: "\u{33E0}",
        nfkc: "\u{0031}\u{65E5}",
        nfkd: "\u{0031}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33E1}",
        nfc: "\u{33E1}",
        nfd: "\u{33E1}",
        nfkc: "\u{0032}\u{65E5}",
        nfkd: "\u{0032}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33E2}",
        nfc: "\u{33E2}",
        nfd: "\u{33E2}",
        nfkc: "\u{0033}\u{65E5}",
        nfkd: "\u{0033}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33E3}",
        nfc: "\u{33E3}",
        nfd: "\u{33E3}",
        nfkc: "\u{0034}\u{65E5}",
        nfkd: "\u{0034}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33E4}",
        nfc: "\u{33E4}",
        nfd: "\u{33E4}",
        nfkc: "\u{0035}\u{65E5}",
        nfkd: "\u{0035}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33E5}",
        nfc: "\u{33E5}",
        nfd: "\u{33E5}",
        nfkc: "\u{0036}\u{65E5}",
        nfkd: "\u{0036}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33E6}",
        nfc: "\u{33E6}",
        nfd: "\u{33E6}",
        nfkc: "\u{0037}\u{65E5}",
        nfkd: "\u{0037}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33E7}",
        nfc: "\u{33E7}",
        nfd: "\u{33E7}",
        nfkc: "\u{0038}\u{65E5}",
        nfkd: "\u{0038}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33E8}",
        nfc: "\u{33E8}",
        nfd: "\u{33E8}",
        nfkc: "\u{0039}\u{65E5}",
        nfkd: "\u{0039}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33E9}",
        nfc: "\u{33E9}",
        nfd: "\u{33E9}",
        nfkc: "\u{0031}\u{0030}\u{65E5}",
        nfkd: "\u{0031}\u{0030}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33EA}",
        nfc: "\u{33EA}",
        nfd: "\u{33EA}",
        nfkc: "\u{0031}\u{0031}\u{65E5}",
        nfkd: "\u{0031}\u{0031}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33EB}",
        nfc: "\u{33EB}",
        nfd: "\u{33EB}",
        nfkc: "\u{0031}\u{0032}\u{65E5}",
        nfkd: "\u{0031}\u{0032}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33EC}",
        nfc: "\u{33EC}",
        nfd: "\u{33EC}",
        nfkc: "\u{0031}\u{0033}\u{65E5}",
        nfkd: "\u{0031}\u{0033}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33ED}",
        nfc: "\u{33ED}",
        nfd: "\u{33ED}",
        nfkc: "\u{0031}\u{0034}\u{65E5}",
        nfkd: "\u{0031}\u{0034}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33EE}",
        nfc: "\u{33EE}",
        nfd: "\u{33EE}",
        nfkc: "\u{0031}\u{0035}\u{65E5}",
        nfkd: "\u{0031}\u{0035}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33EF}",
        nfc: "\u{33EF}",
        nfd: "\u{33EF}",
        nfkc: "\u{0031}\u{0036}\u{65E5}",
        nfkd: "\u{0031}\u{0036}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33F0}",
        nfc: "\u{33F0}",
        nfd: "\u{33F0}",
        nfkc: "\u{0031}\u{0037}\u{65E5}",
        nfkd: "\u{0031}\u{0037}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33F1}",
        nfc: "\u{33F1}",
        nfd: "\u{33F1}",
        nfkc: "\u{0031}\u{0038}\u{65E5}",
        nfkd: "\u{0031}\u{0038}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33F2}",
        nfc: "\u{33F2}",
        nfd: "\u{33F2}",
        nfkc: "\u{0031}\u{0039}\u{65E5}",
        nfkd: "\u{0031}\u{0039}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33F3}",
        nfc: "\u{33F3}",
        nfd: "\u{33F3}",
        nfkc: "\u{0032}\u{0030}\u{65E5}",
        nfkd: "\u{0032}\u{0030}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33F4}",
        nfc: "\u{33F4}",
        nfd: "\u{33F4}",
        nfkc: "\u{0032}\u{0031}\u{65E5}",
        nfkd: "\u{0032}\u{0031}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33F5}",
        nfc: "\u{33F5}",
        nfd: "\u{33F5}",
        nfkc: "\u{0032}\u{0032}\u{65E5}",
        nfkd: "\u{0032}\u{0032}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33F6}",
        nfc: "\u{33F6}",
        nfd: "\u{33F6}",
        nfkc: "\u{0032}\u{0033}\u{65E5}",
        nfkd: "\u{0032}\u{0033}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33F7}",
        nfc: "\u{33F7}",
        nfd: "\u{33F7}",
        nfkc: "\u{0032}\u{0034}\u{65E5}",
        nfkd: "\u{0032}\u{0034}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33F8}",
        nfc: "\u{33F8}",
        nfd: "\u{33F8}",
        nfkc: "\u{0032}\u{0035}\u{65E5}",
        nfkd: "\u{0032}\u{0035}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33F9}",
        nfc: "\u{33F9}",
        nfd: "\u{33F9}",
        nfkc: "\u{0032}\u{0036}\u{65E5}",
        nfkd: "\u{0032}\u{0036}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33FA}",
        nfc: "\u{33FA}",
        nfd: "\u{33FA}",
        nfkc: "\u{0032}\u{0037}\u{65E5}",
        nfkd: "\u{0032}\u{0037}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33FB}",
        nfc: "\u{33FB}",
        nfd: "\u{33FB}",
        nfkc: "\u{0032}\u{0038}\u{65E5}",
        nfkd: "\u{0032}\u{0038}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33FC}",
        nfc: "\u{33FC}",
        nfd: "\u{33FC}",
        nfkc: "\u{0032}\u{0039}\u{65E5}",
        nfkd: "\u{0032}\u{0039}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33FD}",
        nfc: "\u{33FD}",
        nfd: "\u{33FD}",
        nfkc: "\u{0033}\u{0030}\u{65E5}",
        nfkd: "\u{0033}\u{0030}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33FE}",
        nfc: "\u{33FE}",
        nfd: "\u{33FE}",
        nfkc: "\u{0033}\u{0031}\u{65E5}",
        nfkd: "\u{0033}\u{0031}\u{65E5}",
    },
    NormalizationTest {
        source: "\u{33FF}",
        nfc: "\u{33FF}",
        nfd: "\u{33FF}",
        nfkc: "\u{0067}\u{0061}\u{006C}",
        nfkd: "\u{0067}\u{0061}\u{006C}",
    },
    NormalizationTest {
        source: "\u{A69C}",
        nfc: "\u{A69C}",
        nfd: "\u{A69C}",
        nfkc: "\u{044A}",
        nfkd: "\u{044A}",
    },
    NormalizationTest {
        source: "\u{A69D}",
        nfc: "\u{A69D}",
        nfd: "\u{A69D}",
        nfkc: "\u{044C}",
        nfkd: "\u{044C}",
    },
    NormalizationTest {
        source: "\u{A770}",
        nfc: "\u{A770}",
        nfd: "\u{A770}",
        nfkc: "\u{A76F}",
        nfkd: "\u{A76F}",
    },
    NormalizationTest {
        source: "\u{A7F2}",
        nfc: "\u{A7F2}",
        nfd: "\u{A7F2}",
        nfkc: "\u{0043}",
        nfkd: "\u{0043}",
    },
    NormalizationTest {
        source: "\u{A7F3}",
        nfc: "\u{A7F3}",
        nfd: "\u{A7F3}",
        nfkc: "\u{0046}",
        nfkd: "\u{0046}",
    },
    NormalizationTest {
        source: "\u{A7F4}",
        nfc: "\u{A7F4}",
        nfd: "\u{A7F4}",
        nfkc: "\u{0051}",
        nfkd: "\u{0051}",
    },
    NormalizationTest {
        source: "\u{A7F8}",
        nfc: "\u{A7F8}",
        nfd: "\u{A7F8}",
        nfkc: "\u{0126}",
        nfkd: "\u{0126}",
    },
    NormalizationTest {
        source: "\u{A7F9}",
        nfc: "\u{A7F9}",
        nfd: "\u{A7F9}",
        nfkc: "\u{0153}",
        nfkd: "\u{0153}",
    },
    NormalizationTest {
        source: "\u{AB5C}",
        nfc: "\u{AB5C}",
        nfd: "\u{AB5C}",
        nfkc: "\u{A727}",
        nfkd: "\u{A727}",
    },
    NormalizationTest {
        source: "\u{AB5D}",
        nfc: "\u{AB5D}",
        nfd: "\u{AB5D}",
        nfkc: "\u{AB37}",
        nfkd: "\u{AB37}",
    },
    NormalizationTest {
        source: "\u{AB5E}",
        nfc: "\u{AB5E}",
        nfd: "\u{AB5E}",
        nfkc: "\u{026B}",
        nfkd: "\u{026B}",
    },
    NormalizationTest {
        source: "\u{AB5F}",
        nfc: "\u{AB5F}",
        nfd: "\u{AB5F}",
        nfkc: "\u{AB52}",
        nfkd: "\u{AB52}",
    },
    NormalizationTest {
        source: "\u{AB69}",
        nfc: "\u{AB69}",
        nfd: "\u{AB69}",
        nfkc: "\u{028D}",
        nfkd: "\u{028D}",
    },
    NormalizationTest {
        source: "\u{AC00}",
        nfc: "\u{AC00}",
        nfd: "\u{1100}\u{1161}",
        nfkc: "\u{AC00}",
        nfkd: "\u{1100}\u{1161}",
    },
    NormalizationTest {
        source: "\u{AC01}",
        nfc: "\u{AC01}",
        nfd: "\u{1100}\u{1161}\u{11A8}",
        nfkc: "\u{AC01}",
        nfkd: "\u{1100}\u{1161}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AC02}",
        nfc: "\u{AC02}",
        nfd: "\u{1100}\u{1161}\u{11A9}",
        nfkc: "\u{AC02}",
        nfkd: "\u{1100}\u{1161}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AC03}",
        nfc: "\u{AC03}",
        nfd: "\u{1100}\u{1161}\u{11AA}",
        nfkc: "\u{AC03}",
        nfkd: "\u{1100}\u{1161}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AC04}",
        nfc: "\u{AC04}",
        nfd: "\u{1100}\u{1161}\u{11AB}",
        nfkc: "\u{AC04}",
        nfkd: "\u{1100}\u{1161}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AC05}",
        nfc: "\u{AC05}",
        nfd: "\u{1100}\u{1161}\u{11AC}",
        nfkc: "\u{AC05}",
        nfkd: "\u{1100}\u{1161}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AC06}",
        nfc: "\u{AC06}",
        nfd: "\u{1100}\u{1161}\u{11AD}",
        nfkc: "\u{AC06}",
        nfkd: "\u{1100}\u{1161}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AC07}",
        nfc: "\u{AC07}",
        nfd: "\u{1100}\u{1161}\u{11AE}",
        nfkc: "\u{AC07}",
        nfkd: "\u{1100}\u{1161}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AC08}",
        nfc: "\u{AC08}",
        nfd: "\u{1100}\u{1161}\u{11AF}",
        nfkc: "\u{AC08}",
        nfkd: "\u{1100}\u{1161}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AC09}",
        nfc: "\u{AC09}",
        nfd: "\u{1100}\u{1161}\u{11B0}",
        nfkc: "\u{AC09}",
        nfkd: "\u{1100}\u{1161}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AC0A}",
        nfc: "\u{AC0A}",
        nfd: "\u{1100}\u{1161}\u{11B1}",
        nfkc: "\u{AC0A}",
        nfkd: "\u{1100}\u{1161}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AC0B}",
        nfc: "\u{AC0B}",
        nfd: "\u{1100}\u{1161}\u{11B2}",
        nfkc: "\u{AC0B}",
        nfkd: "\u{1100}\u{1161}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AC0C}",
        nfc: "\u{AC0C}",
        nfd: "\u{1100}\u{1161}\u{11B3}",
        nfkc: "\u{AC0C}",
        nfkd: "\u{1100}\u{1161}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AC0D}",
        nfc: "\u{AC0D}",
        nfd: "\u{1100}\u{1161}\u{11B4}",
        nfkc: "\u{AC0D}",
        nfkd: "\u{1100}\u{1161}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AC0E}",
        nfc: "\u{AC0E}",
        nfd: "\u{1100}\u{1161}\u{11B5}",
        nfkc: "\u{AC0E}",
        nfkd: "\u{1100}\u{1161}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AC0F}",
        nfc: "\u{AC0F}",
        nfd: "\u{1100}\u{1161}\u{11B6}",
        nfkc: "\u{AC0F}",
        nfkd: "\u{1100}\u{1161}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AC10}",
        nfc: "\u{AC10}",
        nfd: "\u{1100}\u{1161}\u{11B7}",
        nfkc: "\u{AC10}",
        nfkd: "\u{1100}\u{1161}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AC11}",
        nfc: "\u{AC11}",
        nfd: "\u{1100}\u{1161}\u{11B8}",
        nfkc: "\u{AC11}",
        nfkd: "\u{1100}\u{1161}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AC12}",
        nfc: "\u{AC12}",
        nfd: "\u{1100}\u{1161}\u{11B9}",
        nfkc: "\u{AC12}",
        nfkd: "\u{1100}\u{1161}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AC13}",
        nfc: "\u{AC13}",
        nfd: "\u{1100}\u{1161}\u{11BA}",
        nfkc: "\u{AC13}",
        nfkd: "\u{1100}\u{1161}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AC14}",
        nfc: "\u{AC14}",
        nfd: "\u{1100}\u{1161}\u{11BB}",
        nfkc: "\u{AC14}",
        nfkd: "\u{1100}\u{1161}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AC15}",
        nfc: "\u{AC15}",
        nfd: "\u{1100}\u{1161}\u{11BC}",
        nfkc: "\u{AC15}",
        nfkd: "\u{1100}\u{1161}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AC16}",
        nfc: "\u{AC16}",
        nfd: "\u{1100}\u{1161}\u{11BD}",
        nfkc: "\u{AC16}",
        nfkd: "\u{1100}\u{1161}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AC17}",
        nfc: "\u{AC17}",
        nfd: "\u{1100}\u{1161}\u{11BE}",
        nfkc: "\u{AC17}",
        nfkd: "\u{1100}\u{1161}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AC18}",
        nfc: "\u{AC18}",
        nfd: "\u{1100}\u{1161}\u{11BF}",
        nfkc: "\u{AC18}",
        nfkd: "\u{1100}\u{1161}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AC19}",
        nfc: "\u{AC19}",
        nfd: "\u{1100}\u{1161}\u{11C0}",
        nfkc: "\u{AC19}",
        nfkd: "\u{1100}\u{1161}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AC1A}",
        nfc: "\u{AC1A}",
        nfd: "\u{1100}\u{1161}\u{11C1}",
        nfkc: "\u{AC1A}",
        nfkd: "\u{1100}\u{1161}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AC1B}",
        nfc: "\u{AC1B}",
        nfd: "\u{1100}\u{1161}\u{11C2}",
        nfkc: "\u{AC1B}",
        nfkd: "\u{1100}\u{1161}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AC1C}",
        nfc: "\u{AC1C}",
        nfd: "\u{1100}\u{1162}",
        nfkc: "\u{AC1C}",
        nfkd: "\u{1100}\u{1162}",
    },
    NormalizationTest {
        source: "\u{AC1D}",
        nfc: "\u{AC1D}",
        nfd: "\u{1100}\u{1162}\u{11A8}",
        nfkc: "\u{AC1D}",
        nfkd: "\u{1100}\u{1162}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AC1E}",
        nfc: "\u{AC1E}",
        nfd: "\u{1100}\u{1162}\u{11A9}",
        nfkc: "\u{AC1E}",
        nfkd: "\u{1100}\u{1162}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AC1F}",
        nfc: "\u{AC1F}",
        nfd: "\u{1100}\u{1162}\u{11AA}",
        nfkc: "\u{AC1F}",
        nfkd: "\u{1100}\u{1162}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AC20}",
        nfc: "\u{AC20}",
        nfd: "\u{1100}\u{1162}\u{11AB}",
        nfkc: "\u{AC20}",
        nfkd: "\u{1100}\u{1162}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AC21}",
        nfc: "\u{AC21}",
        nfd: "\u{1100}\u{1162}\u{11AC}",
        nfkc: "\u{AC21}",
        nfkd: "\u{1100}\u{1162}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AC22}",
        nfc: "\u{AC22}",
        nfd: "\u{1100}\u{1162}\u{11AD}",
        nfkc: "\u{AC22}",
        nfkd: "\u{1100}\u{1162}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AC23}",
        nfc: "\u{AC23}",
        nfd: "\u{1100}\u{1162}\u{11AE}",
        nfkc: "\u{AC23}",
        nfkd: "\u{1100}\u{1162}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AC24}",
        nfc: "\u{AC24}",
        nfd: "\u{1100}\u{1162}\u{11AF}",
        nfkc: "\u{AC24}",
        nfkd: "\u{1100}\u{1162}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AC25}",
        nfc: "\u{AC25}",
        nfd: "\u{1100}\u{1162}\u{11B0}",
        nfkc: "\u{AC25}",
        nfkd: "\u{1100}\u{1162}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AC26}",
        nfc: "\u{AC26}",
        nfd: "\u{1100}\u{1162}\u{11B1}",
        nfkc: "\u{AC26}",
        nfkd: "\u{1100}\u{1162}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AC27}",
        nfc: "\u{AC27}",
        nfd: "\u{1100}\u{1162}\u{11B2}",
        nfkc: "\u{AC27}",
        nfkd: "\u{1100}\u{1162}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AC28}",
        nfc: "\u{AC28}",
        nfd: "\u{1100}\u{1162}\u{11B3}",
        nfkc: "\u{AC28}",
        nfkd: "\u{1100}\u{1162}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AC29}",
        nfc: "\u{AC29}",
        nfd: "\u{1100}\u{1162}\u{11B4}",
        nfkc: "\u{AC29}",
        nfkd: "\u{1100}\u{1162}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AC2A}",
        nfc: "\u{AC2A}",
        nfd: "\u{1100}\u{1162}\u{11B5}",
        nfkc: "\u{AC2A}",
        nfkd: "\u{1100}\u{1162}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AC2B}",
        nfc: "\u{AC2B}",
        nfd: "\u{1100}\u{1162}\u{11B6}",
        nfkc: "\u{AC2B}",
        nfkd: "\u{1100}\u{1162}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AC2C}",
        nfc: "\u{AC2C}",
        nfd: "\u{1100}\u{1162}\u{11B7}",
        nfkc: "\u{AC2C}",
        nfkd: "\u{1100}\u{1162}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AC2D}",
        nfc: "\u{AC2D}",
        nfd: "\u{1100}\u{1162}\u{11B8}",
        nfkc: "\u{AC2D}",
        nfkd: "\u{1100}\u{1162}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AC2E}",
        nfc: "\u{AC2E}",
        nfd: "\u{1100}\u{1162}\u{11B9}",
        nfkc: "\u{AC2E}",
        nfkd: "\u{1100}\u{1162}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AC2F}",
        nfc: "\u{AC2F}",
        nfd: "\u{1100}\u{1162}\u{11BA}",
        nfkc: "\u{AC2F}",
        nfkd: "\u{1100}\u{1162}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AC30}",
        nfc: "\u{AC30}",
        nfd: "\u{1100}\u{1162}\u{11BB}",
        nfkc: "\u{AC30}",
        nfkd: "\u{1100}\u{1162}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AC31}",
        nfc: "\u{AC31}",
        nfd: "\u{1100}\u{1162}\u{11BC}",
        nfkc: "\u{AC31}",
        nfkd: "\u{1100}\u{1162}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AC32}",
        nfc: "\u{AC32}",
        nfd: "\u{1100}\u{1162}\u{11BD}",
        nfkc: "\u{AC32}",
        nfkd: "\u{1100}\u{1162}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AC33}",
        nfc: "\u{AC33}",
        nfd: "\u{1100}\u{1162}\u{11BE}",
        nfkc: "\u{AC33}",
        nfkd: "\u{1100}\u{1162}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AC34}",
        nfc: "\u{AC34}",
        nfd: "\u{1100}\u{1162}\u{11BF}",
        nfkc: "\u{AC34}",
        nfkd: "\u{1100}\u{1162}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AC35}",
        nfc: "\u{AC35}",
        nfd: "\u{1100}\u{1162}\u{11C0}",
        nfkc: "\u{AC35}",
        nfkd: "\u{1100}\u{1162}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AC36}",
        nfc: "\u{AC36}",
        nfd: "\u{1100}\u{1162}\u{11C1}",
        nfkc: "\u{AC36}",
        nfkd: "\u{1100}\u{1162}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AC37}",
        nfc: "\u{AC37}",
        nfd: "\u{1100}\u{1162}\u{11C2}",
        nfkc: "\u{AC37}",
        nfkd: "\u{1100}\u{1162}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AC38}",
        nfc: "\u{AC38}",
        nfd: "\u{1100}\u{1163}",
        nfkc: "\u{AC38}",
        nfkd: "\u{1100}\u{1163}",
    },
    NormalizationTest {
        source: "\u{AC39}",
        nfc: "\u{AC39}",
        nfd: "\u{1100}\u{1163}\u{11A8}",
        nfkc: "\u{AC39}",
        nfkd: "\u{1100}\u{1163}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AC3A}",
        nfc: "\u{AC3A}",
        nfd: "\u{1100}\u{1163}\u{11A9}",
        nfkc: "\u{AC3A}",
        nfkd: "\u{1100}\u{1163}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AC3B}",
        nfc: "\u{AC3B}",
        nfd: "\u{1100}\u{1163}\u{11AA}",
        nfkc: "\u{AC3B}",
        nfkd: "\u{1100}\u{1163}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AC3C}",
        nfc: "\u{AC3C}",
        nfd: "\u{1100}\u{1163}\u{11AB}",
        nfkc: "\u{AC3C}",
        nfkd: "\u{1100}\u{1163}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AC3D}",
        nfc: "\u{AC3D}",
        nfd: "\u{1100}\u{1163}\u{11AC}",
        nfkc: "\u{AC3D}",
        nfkd: "\u{1100}\u{1163}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AC3E}",
        nfc: "\u{AC3E}",
        nfd: "\u{1100}\u{1163}\u{11AD}",
        nfkc: "\u{AC3E}",
        nfkd: "\u{1100}\u{1163}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AC3F}",
        nfc: "\u{AC3F}",
        nfd: "\u{1100}\u{1163}\u{11AE}",
        nfkc: "\u{AC3F}",
        nfkd: "\u{1100}\u{1163}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AC40}",
        nfc: "\u{AC40}",
        nfd: "\u{1100}\u{1163}\u{11AF}",
        nfkc: "\u{AC40}",
        nfkd: "\u{1100}\u{1163}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AC41}",
        nfc: "\u{AC41}",
        nfd: "\u{1100}\u{1163}\u{11B0}",
        nfkc: "\u{AC41}",
        nfkd: "\u{1100}\u{1163}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AC42}",
        nfc: "\u{AC42}",
        nfd: "\u{1100}\u{1163}\u{11B1}",
        nfkc: "\u{AC42}",
        nfkd: "\u{1100}\u{1163}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AC43}",
        nfc: "\u{AC43}",
        nfd: "\u{1100}\u{1163}\u{11B2}",
        nfkc: "\u{AC43}",
        nfkd: "\u{1100}\u{1163}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AC44}",
        nfc: "\u{AC44}",
        nfd: "\u{1100}\u{1163}\u{11B3}",
        nfkc: "\u{AC44}",
        nfkd: "\u{1100}\u{1163}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AC45}",
        nfc: "\u{AC45}",
        nfd: "\u{1100}\u{1163}\u{11B4}",
        nfkc: "\u{AC45}",
        nfkd: "\u{1100}\u{1163}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AC46}",
        nfc: "\u{AC46}",
        nfd: "\u{1100}\u{1163}\u{11B5}",
        nfkc: "\u{AC46}",
        nfkd: "\u{1100}\u{1163}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AC47}",
        nfc: "\u{AC47}",
        nfd: "\u{1100}\u{1163}\u{11B6}",
        nfkc: "\u{AC47}",
        nfkd: "\u{1100}\u{1163}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AC48}",
        nfc: "\u{AC48}",
        nfd: "\u{1100}\u{1163}\u{11B7}",
        nfkc: "\u{AC48}",
        nfkd: "\u{1100}\u{1163}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AC49}",
        nfc: "\u{AC49}",
        nfd: "\u{1100}\u{1163}\u{11B8}",
        nfkc: "\u{AC49}",
        nfkd: "\u{1100}\u{1163}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AC4A}",
        nfc: "\u{AC4A}",
        nfd: "\u{1100}\u{1163}\u{11B9}",
        nfkc: "\u{AC4A}",
        nfkd: "\u{1100}\u{1163}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AC4B}",
        nfc: "\u{AC4B}",
        nfd: "\u{1100}\u{1163}\u{11BA}",
        nfkc: "\u{AC4B}",
        nfkd: "\u{1100}\u{1163}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AC4C}",
        nfc: "\u{AC4C}",
        nfd: "\u{1100}\u{1163}\u{11BB}",
        nfkc: "\u{AC4C}",
        nfkd: "\u{1100}\u{1163}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AC4D}",
        nfc: "\u{AC4D}",
        nfd: "\u{1100}\u{1163}\u{11BC}",
        nfkc: "\u{AC4D}",
        nfkd: "\u{1100}\u{1163}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AC4E}",
        nfc: "\u{AC4E}",
        nfd: "\u{1100}\u{1163}\u{11BD}",
        nfkc: "\u{AC4E}",
        nfkd: "\u{1100}\u{1163}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AC4F}",
        nfc: "\u{AC4F}",
        nfd: "\u{1100}\u{1163}\u{11BE}",
        nfkc: "\u{AC4F}",
        nfkd: "\u{1100}\u{1163}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AC50}",
        nfc: "\u{AC50}",
        nfd: "\u{1100}\u{1163}\u{11BF}",
        nfkc: "\u{AC50}",
        nfkd: "\u{1100}\u{1163}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AC51}",
        nfc: "\u{AC51}",
        nfd: "\u{1100}\u{1163}\u{11C0}",
        nfkc: "\u{AC51}",
        nfkd: "\u{1100}\u{1163}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AC52}",
        nfc: "\u{AC52}",
        nfd: "\u{1100}\u{1163}\u{11C1}",
        nfkc: "\u{AC52}",
        nfkd: "\u{1100}\u{1163}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AC53}",
        nfc: "\u{AC53}",
        nfd: "\u{1100}\u{1163}\u{11C2}",
        nfkc: "\u{AC53}",
        nfkd: "\u{1100}\u{1163}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AC54}",
        nfc: "\u{AC54}",
        nfd: "\u{1100}\u{1164}",
        nfkc: "\u{AC54}",
        nfkd: "\u{1100}\u{1164}",
    },
    NormalizationTest {
        source: "\u{AC55}",
        nfc: "\u{AC55}",
        nfd: "\u{1100}\u{1164}\u{11A8}",
        nfkc: "\u{AC55}",
        nfkd: "\u{1100}\u{1164}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AC56}",
        nfc: "\u{AC56}",
        nfd: "\u{1100}\u{1164}\u{11A9}",
        nfkc: "\u{AC56}",
        nfkd: "\u{1100}\u{1164}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AC57}",
        nfc: "\u{AC57}",
        nfd: "\u{1100}\u{1164}\u{11AA}",
        nfkc: "\u{AC57}",
        nfkd: "\u{1100}\u{1164}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AC58}",
        nfc: "\u{AC58}",
        nfd: "\u{1100}\u{1164}\u{11AB}",
        nfkc: "\u{AC58}",
        nfkd: "\u{1100}\u{1164}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AC59}",
        nfc: "\u{AC59}",
        nfd: "\u{1100}\u{1164}\u{11AC}",
        nfkc: "\u{AC59}",
        nfkd: "\u{1100}\u{1164}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AC5A}",
        nfc: "\u{AC5A}",
        nfd: "\u{1100}\u{1164}\u{11AD}",
        nfkc: "\u{AC5A}",
        nfkd: "\u{1100}\u{1164}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AC5B}",
        nfc: "\u{AC5B}",
        nfd: "\u{1100}\u{1164}\u{11AE}",
        nfkc: "\u{AC5B}",
        nfkd: "\u{1100}\u{1164}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AC5C}",
        nfc: "\u{AC5C}",
        nfd: "\u{1100}\u{1164}\u{11AF}",
        nfkc: "\u{AC5C}",
        nfkd: "\u{1100}\u{1164}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AC5D}",
        nfc: "\u{AC5D}",
        nfd: "\u{1100}\u{1164}\u{11B0}",
        nfkc: "\u{AC5D}",
        nfkd: "\u{1100}\u{1164}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AC5E}",
        nfc: "\u{AC5E}",
        nfd: "\u{1100}\u{1164}\u{11B1}",
        nfkc: "\u{AC5E}",
        nfkd: "\u{1100}\u{1164}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AC5F}",
        nfc: "\u{AC5F}",
        nfd: "\u{1100}\u{1164}\u{11B2}",
        nfkc: "\u{AC5F}",
        nfkd: "\u{1100}\u{1164}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AC60}",
        nfc: "\u{AC60}",
        nfd: "\u{1100}\u{1164}\u{11B3}",
        nfkc: "\u{AC60}",
        nfkd: "\u{1100}\u{1164}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AC61}",
        nfc: "\u{AC61}",
        nfd: "\u{1100}\u{1164}\u{11B4}",
        nfkc: "\u{AC61}",
        nfkd: "\u{1100}\u{1164}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AC62}",
        nfc: "\u{AC62}",
        nfd: "\u{1100}\u{1164}\u{11B5}",
        nfkc: "\u{AC62}",
        nfkd: "\u{1100}\u{1164}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AC63}",
        nfc: "\u{AC63}",
        nfd: "\u{1100}\u{1164}\u{11B6}",
        nfkc: "\u{AC63}",
        nfkd: "\u{1100}\u{1164}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AC64}",
        nfc: "\u{AC64}",
        nfd: "\u{1100}\u{1164}\u{11B7}",
        nfkc: "\u{AC64}",
        nfkd: "\u{1100}\u{1164}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AC65}",
        nfc: "\u{AC65}",
        nfd: "\u{1100}\u{1164}\u{11B8}",
        nfkc: "\u{AC65}",
        nfkd: "\u{1100}\u{1164}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AC66}",
        nfc: "\u{AC66}",
        nfd: "\u{1100}\u{1164}\u{11B9}",
        nfkc: "\u{AC66}",
        nfkd: "\u{1100}\u{1164}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AC67}",
        nfc: "\u{AC67}",
        nfd: "\u{1100}\u{1164}\u{11BA}",
        nfkc: "\u{AC67}",
        nfkd: "\u{1100}\u{1164}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AC68}",
        nfc: "\u{AC68}",
        nfd: "\u{1100}\u{1164}\u{11BB}",
        nfkc: "\u{AC68}",
        nfkd: "\u{1100}\u{1164}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AC69}",
        nfc: "\u{AC69}",
        nfd: "\u{1100}\u{1164}\u{11BC}",
        nfkc: "\u{AC69}",
        nfkd: "\u{1100}\u{1164}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AC6A}",
        nfc: "\u{AC6A}",
        nfd: "\u{1100}\u{1164}\u{11BD}",
        nfkc: "\u{AC6A}",
        nfkd: "\u{1100}\u{1164}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AC6B}",
        nfc: "\u{AC6B}",
        nfd: "\u{1100}\u{1164}\u{11BE}",
        nfkc: "\u{AC6B}",
        nfkd: "\u{1100}\u{1164}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AC6C}",
        nfc: "\u{AC6C}",
        nfd: "\u{1100}\u{1164}\u{11BF}",
        nfkc: "\u{AC6C}",
        nfkd: "\u{1100}\u{1164}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AC6D}",
        nfc: "\u{AC6D}",
        nfd: "\u{1100}\u{1164}\u{11C0}",
        nfkc: "\u{AC6D}",
        nfkd: "\u{1100}\u{1164}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AC6E}",
        nfc: "\u{AC6E}",
        nfd: "\u{1100}\u{1164}\u{11C1}",
        nfkc: "\u{AC6E}",
        nfkd: "\u{1100}\u{1164}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AC6F}",
        nfc: "\u{AC6F}",
        nfd: "\u{1100}\u{1164}\u{11C2}",
        nfkc: "\u{AC6F}",
        nfkd: "\u{1100}\u{1164}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AC70}",
        nfc: "\u{AC70}",
        nfd: "\u{1100}\u{1165}",
        nfkc: "\u{AC70}",
        nfkd: "\u{1100}\u{1165}",
    },
    NormalizationTest {
        source: "\u{AC71}",
        nfc: "\u{AC71}",
        nfd: "\u{1100}\u{1165}\u{11A8}",
        nfkc: "\u{AC71}",
        nfkd: "\u{1100}\u{1165}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AC72}",
        nfc: "\u{AC72}",
        nfd: "\u{1100}\u{1165}\u{11A9}",
        nfkc: "\u{AC72}",
        nfkd: "\u{1100}\u{1165}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AC73}",
        nfc: "\u{AC73}",
        nfd: "\u{1100}\u{1165}\u{11AA}",
        nfkc: "\u{AC73}",
        nfkd: "\u{1100}\u{1165}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AC74}",
        nfc: "\u{AC74}",
        nfd: "\u{1100}\u{1165}\u{11AB}",
        nfkc: "\u{AC74}",
        nfkd: "\u{1100}\u{1165}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AC75}",
        nfc: "\u{AC75}",
        nfd: "\u{1100}\u{1165}\u{11AC}",
        nfkc: "\u{AC75}",
        nfkd: "\u{1100}\u{1165}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AC76}",
        nfc: "\u{AC76}",
        nfd: "\u{1100}\u{1165}\u{11AD}",
        nfkc: "\u{AC76}",
        nfkd: "\u{1100}\u{1165}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AC77}",
        nfc: "\u{AC77}",
        nfd: "\u{1100}\u{1165}\u{11AE}",
        nfkc: "\u{AC77}",
        nfkd: "\u{1100}\u{1165}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AC78}",
        nfc: "\u{AC78}",
        nfd: "\u{1100}\u{1165}\u{11AF}",
        nfkc: "\u{AC78}",
        nfkd: "\u{1100}\u{1165}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AC79}",
        nfc: "\u{AC79}",
        nfd: "\u{1100}\u{1165}\u{11B0}",
        nfkc: "\u{AC79}",
        nfkd: "\u{1100}\u{1165}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AC7A}",
        nfc: "\u{AC7A}",
        nfd: "\u{1100}\u{1165}\u{11B1}",
        nfkc: "\u{AC7A}",
        nfkd: "\u{1100}\u{1165}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AC7B}",
        nfc: "\u{AC7B}",
        nfd: "\u{1100}\u{1165}\u{11B2}",
        nfkc: "\u{AC7B}",
        nfkd: "\u{1100}\u{1165}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AC7C}",
        nfc: "\u{AC7C}",
        nfd: "\u{1100}\u{1165}\u{11B3}",
        nfkc: "\u{AC7C}",
        nfkd: "\u{1100}\u{1165}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AC7D}",
        nfc: "\u{AC7D}",
        nfd: "\u{1100}\u{1165}\u{11B4}",
        nfkc: "\u{AC7D}",
        nfkd: "\u{1100}\u{1165}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AC7E}",
        nfc: "\u{AC7E}",
        nfd: "\u{1100}\u{1165}\u{11B5}",
        nfkc: "\u{AC7E}",
        nfkd: "\u{1100}\u{1165}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AC7F}",
        nfc: "\u{AC7F}",
        nfd: "\u{1100}\u{1165}\u{11B6}",
        nfkc: "\u{AC7F}",
        nfkd: "\u{1100}\u{1165}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AC80}",
        nfc: "\u{AC80}",
        nfd: "\u{1100}\u{1165}\u{11B7}",
        nfkc: "\u{AC80}",
        nfkd: "\u{1100}\u{1165}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AC81}",
        nfc: "\u{AC81}",
        nfd: "\u{1100}\u{1165}\u{11B8}",
        nfkc: "\u{AC81}",
        nfkd: "\u{1100}\u{1165}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AC82}",
        nfc: "\u{AC82}",
        nfd: "\u{1100}\u{1165}\u{11B9}",
        nfkc: "\u{AC82}",
        nfkd: "\u{1100}\u{1165}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AC83}",
        nfc: "\u{AC83}",
        nfd: "\u{1100}\u{1165}\u{11BA}",
        nfkc: "\u{AC83}",
        nfkd: "\u{1100}\u{1165}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AC84}",
        nfc: "\u{AC84}",
        nfd: "\u{1100}\u{1165}\u{11BB}",
        nfkc: "\u{AC84}",
        nfkd: "\u{1100}\u{1165}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AC85}",
        nfc: "\u{AC85}",
        nfd: "\u{1100}\u{1165}\u{11BC}",
        nfkc: "\u{AC85}",
        nfkd: "\u{1100}\u{1165}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AC86}",
        nfc: "\u{AC86}",
        nfd: "\u{1100}\u{1165}\u{11BD}",
        nfkc: "\u{AC86}",
        nfkd: "\u{1100}\u{1165}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AC87}",
        nfc: "\u{AC87}",
        nfd: "\u{1100}\u{1165}\u{11BE}",
        nfkc: "\u{AC87}",
        nfkd: "\u{1100}\u{1165}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AC88}",
        nfc: "\u{AC88}",
        nfd: "\u{1100}\u{1165}\u{11BF}",
        nfkc: "\u{AC88}",
        nfkd: "\u{1100}\u{1165}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AC89}",
        nfc: "\u{AC89}",
        nfd: "\u{1100}\u{1165}\u{11C0}",
        nfkc: "\u{AC89}",
        nfkd: "\u{1100}\u{1165}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AC8A}",
        nfc: "\u{AC8A}",
        nfd: "\u{1100}\u{1165}\u{11C1}",
        nfkc: "\u{AC8A}",
        nfkd: "\u{1100}\u{1165}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AC8B}",
        nfc: "\u{AC8B}",
        nfd: "\u{1100}\u{1165}\u{11C2}",
        nfkc: "\u{AC8B}",
        nfkd: "\u{1100}\u{1165}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AC8C}",
        nfc: "\u{AC8C}",
        nfd: "\u{1100}\u{1166}",
        nfkc: "\u{AC8C}",
        nfkd: "\u{1100}\u{1166}",
    },
    NormalizationTest {
        source: "\u{AC8D}",
        nfc: "\u{AC8D}",
        nfd: "\u{1100}\u{1166}\u{11A8}",
        nfkc: "\u{AC8D}",
        nfkd: "\u{1100}\u{1166}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AC8E}",
        nfc: "\u{AC8E}",
        nfd: "\u{1100}\u{1166}\u{11A9}",
        nfkc: "\u{AC8E}",
        nfkd: "\u{1100}\u{1166}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AC8F}",
        nfc: "\u{AC8F}",
        nfd: "\u{1100}\u{1166}\u{11AA}",
        nfkc: "\u{AC8F}",
        nfkd: "\u{1100}\u{1166}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AC90}",
        nfc: "\u{AC90}",
        nfd: "\u{1100}\u{1166}\u{11AB}",
        nfkc: "\u{AC90}",
        nfkd: "\u{1100}\u{1166}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AC91}",
        nfc: "\u{AC91}",
        nfd: "\u{1100}\u{1166}\u{11AC}",
        nfkc: "\u{AC91}",
        nfkd: "\u{1100}\u{1166}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AC92}",
        nfc: "\u{AC92}",
        nfd: "\u{1100}\u{1166}\u{11AD}",
        nfkc: "\u{AC92}",
        nfkd: "\u{1100}\u{1166}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AC93}",
        nfc: "\u{AC93}",
        nfd: "\u{1100}\u{1166}\u{11AE}",
        nfkc: "\u{AC93}",
        nfkd: "\u{1100}\u{1166}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AC94}",
        nfc: "\u{AC94}",
        nfd: "\u{1100}\u{1166}\u{11AF}",
        nfkc: "\u{AC94}",
        nfkd: "\u{1100}\u{1166}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AC95}",
        nfc: "\u{AC95}",
        nfd: "\u{1100}\u{1166}\u{11B0}",
        nfkc: "\u{AC95}",
        nfkd: "\u{1100}\u{1166}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AC96}",
        nfc: "\u{AC96}",
        nfd: "\u{1100}\u{1166}\u{11B1}",
        nfkc: "\u{AC96}",
        nfkd: "\u{1100}\u{1166}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AC97}",
        nfc: "\u{AC97}",
        nfd: "\u{1100}\u{1166}\u{11B2}",
        nfkc: "\u{AC97}",
        nfkd: "\u{1100}\u{1166}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AC98}",
        nfc: "\u{AC98}",
        nfd: "\u{1100}\u{1166}\u{11B3}",
        nfkc: "\u{AC98}",
        nfkd: "\u{1100}\u{1166}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AC99}",
        nfc: "\u{AC99}",
        nfd: "\u{1100}\u{1166}\u{11B4}",
        nfkc: "\u{AC99}",
        nfkd: "\u{1100}\u{1166}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AC9A}",
        nfc: "\u{AC9A}",
        nfd: "\u{1100}\u{1166}\u{11B5}",
        nfkc: "\u{AC9A}",
        nfkd: "\u{1100}\u{1166}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AC9B}",
        nfc: "\u{AC9B}",
        nfd: "\u{1100}\u{1166}\u{11B6}",
        nfkc: "\u{AC9B}",
        nfkd: "\u{1100}\u{1166}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AC9C}",
        nfc: "\u{AC9C}",
        nfd: "\u{1100}\u{1166}\u{11B7}",
        nfkc: "\u{AC9C}",
        nfkd: "\u{1100}\u{1166}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AC9D}",
        nfc: "\u{AC9D}",
        nfd: "\u{1100}\u{1166}\u{11B8}",
        nfkc: "\u{AC9D}",
        nfkd: "\u{1100}\u{1166}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AC9E}",
        nfc: "\u{AC9E}",
        nfd: "\u{1100}\u{1166}\u{11B9}",
        nfkc: "\u{AC9E}",
        nfkd: "\u{1100}\u{1166}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AC9F}",
        nfc: "\u{AC9F}",
        nfd: "\u{1100}\u{1166}\u{11BA}",
        nfkc: "\u{AC9F}",
        nfkd: "\u{1100}\u{1166}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{ACA0}",
        nfc: "\u{ACA0}",
        nfd: "\u{1100}\u{1166}\u{11BB}",
        nfkc: "\u{ACA0}",
        nfkd: "\u{1100}\u{1166}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{ACA1}",
        nfc: "\u{ACA1}",
        nfd: "\u{1100}\u{1166}\u{11BC}",
        nfkc: "\u{ACA1}",
        nfkd: "\u{1100}\u{1166}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{ACA2}",
        nfc: "\u{ACA2}",
        nfd: "\u{1100}\u{1166}\u{11BD}",
        nfkc: "\u{ACA2}",
        nfkd: "\u{1100}\u{1166}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{ACA3}",
        nfc: "\u{ACA3}",
        nfd: "\u{1100}\u{1166}\u{11BE}",
        nfkc: "\u{ACA3}",
        nfkd: "\u{1100}\u{1166}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{ACA4}",
        nfc: "\u{ACA4}",
        nfd: "\u{1100}\u{1166}\u{11BF}",
        nfkc: "\u{ACA4}",
        nfkd: "\u{1100}\u{1166}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{ACA5}",
        nfc: "\u{ACA5}",
        nfd: "\u{1100}\u{1166}\u{11C0}",
        nfkc: "\u{ACA5}",
        nfkd: "\u{1100}\u{1166}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{ACA6}",
        nfc: "\u{ACA6}",
        nfd: "\u{1100}\u{1166}\u{11C1}",
        nfkc: "\u{ACA6}",
        nfkd: "\u{1100}\u{1166}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{ACA7}",
        nfc: "\u{ACA7}",
        nfd: "\u{1100}\u{1166}\u{11C2}",
        nfkc: "\u{ACA7}",
        nfkd: "\u{1100}\u{1166}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{ACA8}",
        nfc: "\u{ACA8}",
        nfd: "\u{1100}\u{1167}",
        nfkc: "\u{ACA8}",
        nfkd: "\u{1100}\u{1167}",
    },
    NormalizationTest {
        source: "\u{ACA9}",
        nfc: "\u{ACA9}",
        nfd: "\u{1100}\u{1167}\u{11A8}",
        nfkc: "\u{ACA9}",
        nfkd: "\u{1100}\u{1167}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{ACAA}",
        nfc: "\u{ACAA}",
        nfd: "\u{1100}\u{1167}\u{11A9}",
        nfkc: "\u{ACAA}",
        nfkd: "\u{1100}\u{1167}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{ACAB}",
        nfc: "\u{ACAB}",
        nfd: "\u{1100}\u{1167}\u{11AA}",
        nfkc: "\u{ACAB}",
        nfkd: "\u{1100}\u{1167}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{ACAC}",
        nfc: "\u{ACAC}",
        nfd: "\u{1100}\u{1167}\u{11AB}",
        nfkc: "\u{ACAC}",
        nfkd: "\u{1100}\u{1167}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{ACAD}",
        nfc: "\u{ACAD}",
        nfd: "\u{1100}\u{1167}\u{11AC}",
        nfkc: "\u{ACAD}",
        nfkd: "\u{1100}\u{1167}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{ACAE}",
        nfc: "\u{ACAE}",
        nfd: "\u{1100}\u{1167}\u{11AD}",
        nfkc: "\u{ACAE}",
        nfkd: "\u{1100}\u{1167}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{ACAF}",
        nfc: "\u{ACAF}",
        nfd: "\u{1100}\u{1167}\u{11AE}",
        nfkc: "\u{ACAF}",
        nfkd: "\u{1100}\u{1167}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{ACB0}",
        nfc: "\u{ACB0}",
        nfd: "\u{1100}\u{1167}\u{11AF}",
        nfkc: "\u{ACB0}",
        nfkd: "\u{1100}\u{1167}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{ACB1}",
        nfc: "\u{ACB1}",
        nfd: "\u{1100}\u{1167}\u{11B0}",
        nfkc: "\u{ACB1}",
        nfkd: "\u{1100}\u{1167}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{ACB2}",
        nfc: "\u{ACB2}",
        nfd: "\u{1100}\u{1167}\u{11B1}",
        nfkc: "\u{ACB2}",
        nfkd: "\u{1100}\u{1167}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{ACB3}",
        nfc: "\u{ACB3}",
        nfd: "\u{1100}\u{1167}\u{11B2}",
        nfkc: "\u{ACB3}",
        nfkd: "\u{1100}\u{1167}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{ACB4}",
        nfc: "\u{ACB4}",
        nfd: "\u{1100}\u{1167}\u{11B3}",
        nfkc: "\u{ACB4}",
        nfkd: "\u{1100}\u{1167}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{ACB5}",
        nfc: "\u{ACB5}",
        nfd: "\u{1100}\u{1167}\u{11B4}",
        nfkc: "\u{ACB5}",
        nfkd: "\u{1100}\u{1167}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{ACB6}",
        nfc: "\u{ACB6}",
        nfd: "\u{1100}\u{1167}\u{11B5}",
        nfkc: "\u{ACB6}",
        nfkd: "\u{1100}\u{1167}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{ACB7}",
        nfc: "\u{ACB7}",
        nfd: "\u{1100}\u{1167}\u{11B6}",
        nfkc: "\u{ACB7}",
        nfkd: "\u{1100}\u{1167}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{ACB8}",
        nfc: "\u{ACB8}",
        nfd: "\u{1100}\u{1167}\u{11B7}",
        nfkc: "\u{ACB8}",
        nfkd: "\u{1100}\u{1167}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{ACB9}",
        nfc: "\u{ACB9}",
        nfd: "\u{1100}\u{1167}\u{11B8}",
        nfkc: "\u{ACB9}",
        nfkd: "\u{1100}\u{1167}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{ACBA}",
        nfc: "\u{ACBA}",
        nfd: "\u{1100}\u{1167}\u{11B9}",
        nfkc: "\u{ACBA}",
        nfkd: "\u{1100}\u{1167}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{ACBB}",
        nfc: "\u{ACBB}",
        nfd: "\u{1100}\u{1167}\u{11BA}",
        nfkc: "\u{ACBB}",
        nfkd: "\u{1100}\u{1167}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{ACBC}",
        nfc: "\u{ACBC}",
        nfd: "\u{1100}\u{1167}\u{11BB}",
        nfkc: "\u{ACBC}",
        nfkd: "\u{1100}\u{1167}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{ACBD}",
        nfc: "\u{ACBD}",
        nfd: "\u{1100}\u{1167}\u{11BC}",
        nfkc: "\u{ACBD}",
        nfkd: "\u{1100}\u{1167}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{ACBE}",
        nfc: "\u{ACBE}",
        nfd: "\u{1100}\u{1167}\u{11BD}",
        nfkc: "\u{ACBE}",
        nfkd: "\u{1100}\u{1167}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{ACBF}",
        nfc: "\u{ACBF}",
        nfd: "\u{1100}\u{1167}\u{11BE}",
        nfkc: "\u{ACBF}",
        nfkd: "\u{1100}\u{1167}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{ACC0}",
        nfc: "\u{ACC0}",
        nfd: "\u{1100}\u{1167}\u{11BF}",
        nfkc: "\u{ACC0}",
        nfkd: "\u{1100}\u{1167}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{ACC1}",
        nfc: "\u{ACC1}",
        nfd: "\u{1100}\u{1167}\u{11C0}",
        nfkc: "\u{ACC1}",
        nfkd: "\u{1100}\u{1167}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{ACC2}",
        nfc: "\u{ACC2}",
        nfd: "\u{1100}\u{1167}\u{11C1}",
        nfkc: "\u{ACC2}",
        nfkd: "\u{1100}\u{1167}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{ACC3}",
        nfc: "\u{ACC3}",
        nfd: "\u{1100}\u{1167}\u{11C2}",
        nfkc: "\u{ACC3}",
        nfkd: "\u{1100}\u{1167}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{ACC4}",
        nfc: "\u{ACC4}",
        nfd: "\u{1100}\u{1168}",
        nfkc: "\u{ACC4}",
        nfkd: "\u{1100}\u{1168}",
    },
    NormalizationTest {
        source: "\u{ACC5}",
        nfc: "\u{ACC5}",
        nfd: "\u{1100}\u{1168}\u{11A8}",
        nfkc: "\u{ACC5}",
        nfkd: "\u{1100}\u{1168}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{ACC6}",
        nfc: "\u{ACC6}",
        nfd: "\u{1100}\u{1168}\u{11A9}",
        nfkc: "\u{ACC6}",
        nfkd: "\u{1100}\u{1168}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{ACC7}",
        nfc: "\u{ACC7}",
        nfd: "\u{1100}\u{1168}\u{11AA}",
        nfkc: "\u{ACC7}",
        nfkd: "\u{1100}\u{1168}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{ACC8}",
        nfc: "\u{ACC8}",
        nfd: "\u{1100}\u{1168}\u{11AB}",
        nfkc: "\u{ACC8}",
        nfkd: "\u{1100}\u{1168}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{ACC9}",
        nfc: "\u{ACC9}",
        nfd: "\u{1100}\u{1168}\u{11AC}",
        nfkc: "\u{ACC9}",
        nfkd: "\u{1100}\u{1168}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{ACCA}",
        nfc: "\u{ACCA}",
        nfd: "\u{1100}\u{1168}\u{11AD}",
        nfkc: "\u{ACCA}",
        nfkd: "\u{1100}\u{1168}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{ACCB}",
        nfc: "\u{ACCB}",
        nfd: "\u{1100}\u{1168}\u{11AE}",
        nfkc: "\u{ACCB}",
        nfkd: "\u{1100}\u{1168}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{ACCC}",
        nfc: "\u{ACCC}",
        nfd: "\u{1100}\u{1168}\u{11AF}",
        nfkc: "\u{ACCC}",
        nfkd: "\u{1100}\u{1168}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{ACCD}",
        nfc: "\u{ACCD}",
        nfd: "\u{1100}\u{1168}\u{11B0}",
        nfkc: "\u{ACCD}",
        nfkd: "\u{1100}\u{1168}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{ACCE}",
        nfc: "\u{ACCE}",
        nfd: "\u{1100}\u{1168}\u{11B1}",
        nfkc: "\u{ACCE}",
        nfkd: "\u{1100}\u{1168}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{ACCF}",
        nfc: "\u{ACCF}",
        nfd: "\u{1100}\u{1168}\u{11B2}",
        nfkc: "\u{ACCF}",
        nfkd: "\u{1100}\u{1168}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{ACD0}",
        nfc: "\u{ACD0}",
        nfd: "\u{1100}\u{1168}\u{11B3}",
        nfkc: "\u{ACD0}",
        nfkd: "\u{1100}\u{1168}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{ACD1}",
        nfc: "\u{ACD1}",
        nfd: "\u{1100}\u{1168}\u{11B4}",
        nfkc: "\u{ACD1}",
        nfkd: "\u{1100}\u{1168}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{ACD2}",
        nfc: "\u{ACD2}",
        nfd: "\u{1100}\u{1168}\u{11B5}",
        nfkc: "\u{ACD2}",
        nfkd: "\u{1100}\u{1168}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{ACD3}",
        nfc: "\u{ACD3}",
        nfd: "\u{1100}\u{1168}\u{11B6}",
        nfkc: "\u{ACD3}",
        nfkd: "\u{1100}\u{1168}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{ACD4}",
        nfc: "\u{ACD4}",
        nfd: "\u{1100}\u{1168}\u{11B7}",
        nfkc: "\u{ACD4}",
        nfkd: "\u{1100}\u{1168}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{ACD5}",
        nfc: "\u{ACD5}",
        nfd: "\u{1100}\u{1168}\u{11B8}",
        nfkc: "\u{ACD5}",
        nfkd: "\u{1100}\u{1168}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{ACD6}",
        nfc: "\u{ACD6}",
        nfd: "\u{1100}\u{1168}\u{11B9}",
        nfkc: "\u{ACD6}",
        nfkd: "\u{1100}\u{1168}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{ACD7}",
        nfc: "\u{ACD7}",
        nfd: "\u{1100}\u{1168}\u{11BA}",
        nfkc: "\u{ACD7}",
        nfkd: "\u{1100}\u{1168}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{ACD8}",
        nfc: "\u{ACD8}",
        nfd: "\u{1100}\u{1168}\u{11BB}",
        nfkc: "\u{ACD8}",
        nfkd: "\u{1100}\u{1168}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{ACD9}",
        nfc: "\u{ACD9}",
        nfd: "\u{1100}\u{1168}\u{11BC}",
        nfkc: "\u{ACD9}",
        nfkd: "\u{1100}\u{1168}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{ACDA}",
        nfc: "\u{ACDA}",
        nfd: "\u{1100}\u{1168}\u{11BD}",
        nfkc: "\u{ACDA}",
        nfkd: "\u{1100}\u{1168}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{ACDB}",
        nfc: "\u{ACDB}",
        nfd: "\u{1100}\u{1168}\u{11BE}",
        nfkc: "\u{ACDB}",
        nfkd: "\u{1100}\u{1168}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{ACDC}",
        nfc: "\u{ACDC}",
        nfd: "\u{1100}\u{1168}\u{11BF}",
        nfkc: "\u{ACDC}",
        nfkd: "\u{1100}\u{1168}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{ACDD}",
        nfc: "\u{ACDD}",
        nfd: "\u{1100}\u{1168}\u{11C0}",
        nfkc: "\u{ACDD}",
        nfkd: "\u{1100}\u{1168}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{ACDE}",
        nfc: "\u{ACDE}",
        nfd: "\u{1100}\u{1168}\u{11C1}",
        nfkc: "\u{ACDE}",
        nfkd: "\u{1100}\u{1168}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{ACDF}",
        nfc: "\u{ACDF}",
        nfd: "\u{1100}\u{1168}\u{11C2}",
        nfkc: "\u{ACDF}",
        nfkd: "\u{1100}\u{1168}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{ACE0}",
        nfc: "\u{ACE0}",
        nfd: "\u{1100}\u{1169}",
        nfkc: "\u{ACE0}",
        nfkd: "\u{1100}\u{1169}",
    },
    NormalizationTest {
        source: "\u{ACE1}",
        nfc: "\u{ACE1}",
        nfd: "\u{1100}\u{1169}\u{11A8}",
        nfkc: "\u{ACE1}",
        nfkd: "\u{1100}\u{1169}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{ACE2}",
        nfc: "\u{ACE2}",
        nfd: "\u{1100}\u{1169}\u{11A9}",
        nfkc: "\u{ACE2}",
        nfkd: "\u{1100}\u{1169}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{ACE3}",
        nfc: "\u{ACE3}",
        nfd: "\u{1100}\u{1169}\u{11AA}",
        nfkc: "\u{ACE3}",
        nfkd: "\u{1100}\u{1169}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{ACE4}",
        nfc: "\u{ACE4}",
        nfd: "\u{1100}\u{1169}\u{11AB}",
        nfkc: "\u{ACE4}",
        nfkd: "\u{1100}\u{1169}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{ACE5}",
        nfc: "\u{ACE5}",
        nfd: "\u{1100}\u{1169}\u{11AC}",
        nfkc: "\u{ACE5}",
        nfkd: "\u{1100}\u{1169}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{ACE6}",
        nfc: "\u{ACE6}",
        nfd: "\u{1100}\u{1169}\u{11AD}",
        nfkc: "\u{ACE6}",
        nfkd: "\u{1100}\u{1169}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{ACE7}",
        nfc: "\u{ACE7}",
        nfd: "\u{1100}\u{1169}\u{11AE}",
        nfkc: "\u{ACE7}",
        nfkd: "\u{1100}\u{1169}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{ACE8}",
        nfc: "\u{ACE8}",
        nfd: "\u{1100}\u{1169}\u{11AF}",
        nfkc: "\u{ACE8}",
        nfkd: "\u{1100}\u{1169}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{ACE9}",
        nfc: "\u{ACE9}",
        nfd: "\u{1100}\u{1169}\u{11B0}",
        nfkc: "\u{ACE9}",
        nfkd: "\u{1100}\u{1169}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{ACEA}",
        nfc: "\u{ACEA}",
        nfd: "\u{1100}\u{1169}\u{11B1}",
        nfkc: "\u{ACEA}",
        nfkd: "\u{1100}\u{1169}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{ACEB}",
        nfc: "\u{ACEB}",
        nfd: "\u{1100}\u{1169}\u{11B2}",
        nfkc: "\u{ACEB}",
        nfkd: "\u{1100}\u{1169}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{ACEC}",
        nfc: "\u{ACEC}",
        nfd: "\u{1100}\u{1169}\u{11B3}",
        nfkc: "\u{ACEC}",
        nfkd: "\u{1100}\u{1169}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{ACED}",
        nfc: "\u{ACED}",
        nfd: "\u{1100}\u{1169}\u{11B4}",
        nfkc: "\u{ACED}",
        nfkd: "\u{1100}\u{1169}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{ACEE}",
        nfc: "\u{ACEE}",
        nfd: "\u{1100}\u{1169}\u{11B5}",
        nfkc: "\u{ACEE}",
        nfkd: "\u{1100}\u{1169}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{ACEF}",
        nfc: "\u{ACEF}",
        nfd: "\u{1100}\u{1169}\u{11B6}",
        nfkc: "\u{ACEF}",
        nfkd: "\u{1100}\u{1169}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{ACF0}",
        nfc: "\u{ACF0}",
        nfd: "\u{1100}\u{1169}\u{11B7}",
        nfkc: "\u{ACF0}",
        nfkd: "\u{1100}\u{1169}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{ACF1}",
        nfc: "\u{ACF1}",
        nfd: "\u{1100}\u{1169}\u{11B8}",
        nfkc: "\u{ACF1}",
        nfkd: "\u{1100}\u{1169}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{ACF2}",
        nfc: "\u{ACF2}",
        nfd: "\u{1100}\u{1169}\u{11B9}",
        nfkc: "\u{ACF2}",
        nfkd: "\u{1100}\u{1169}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{ACF3}",
        nfc: "\u{ACF3}",
        nfd: "\u{1100}\u{1169}\u{11BA}",
        nfkc: "\u{ACF3}",
        nfkd: "\u{1100}\u{1169}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{ACF4}",
        nfc: "\u{ACF4}",
        nfd: "\u{1100}\u{1169}\u{11BB}",
        nfkc: "\u{ACF4}",
        nfkd: "\u{1100}\u{1169}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{ACF5}",
        nfc: "\u{ACF5}",
        nfd: "\u{1100}\u{1169}\u{11BC}",
        nfkc: "\u{ACF5}",
        nfkd: "\u{1100}\u{1169}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{ACF6}",
        nfc: "\u{ACF6}",
        nfd: "\u{1100}\u{1169}\u{11BD}",
        nfkc: "\u{ACF6}",
        nfkd: "\u{1100}\u{1169}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{ACF7}",
        nfc: "\u{ACF7}",
        nfd: "\u{1100}\u{1169}\u{11BE}",
        nfkc: "\u{ACF7}",
        nfkd: "\u{1100}\u{1169}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{ACF8}",
        nfc: "\u{ACF8}",
        nfd: "\u{1100}\u{1169}\u{11BF}",
        nfkc: "\u{ACF8}",
        nfkd: "\u{1100}\u{1169}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{ACF9}",
        nfc: "\u{ACF9}",
        nfd: "\u{1100}\u{1169}\u{11C0}",
        nfkc: "\u{ACF9}",
        nfkd: "\u{1100}\u{1169}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{ACFA}",
        nfc: "\u{ACFA}",
        nfd: "\u{1100}\u{1169}\u{11C1}",
        nfkc: "\u{ACFA}",
        nfkd: "\u{1100}\u{1169}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{ACFB}",
        nfc: "\u{ACFB}",
        nfd: "\u{1100}\u{1169}\u{11C2}",
        nfkc: "\u{ACFB}",
        nfkd: "\u{1100}\u{1169}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{ACFC}",
        nfc: "\u{ACFC}",
        nfd: "\u{1100}\u{116A}",
        nfkc: "\u{ACFC}",
        nfkd: "\u{1100}\u{116A}",
    },
    NormalizationTest {
        source: "\u{ACFD}",
        nfc: "\u{ACFD}",
        nfd: "\u{1100}\u{116A}\u{11A8}",
        nfkc: "\u{ACFD}",
        nfkd: "\u{1100}\u{116A}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{ACFE}",
        nfc: "\u{ACFE}",
        nfd: "\u{1100}\u{116A}\u{11A9}",
        nfkc: "\u{ACFE}",
        nfkd: "\u{1100}\u{116A}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{ACFF}",
        nfc: "\u{ACFF}",
        nfd: "\u{1100}\u{116A}\u{11AA}",
        nfkc: "\u{ACFF}",
        nfkd: "\u{1100}\u{116A}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AD00}",
        nfc: "\u{AD00}",
        nfd: "\u{1100}\u{116A}\u{11AB}",
        nfkc: "\u{AD00}",
        nfkd: "\u{1100}\u{116A}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AD01}",
        nfc: "\u{AD01}",
        nfd: "\u{1100}\u{116A}\u{11AC}",
        nfkc: "\u{AD01}",
        nfkd: "\u{1100}\u{116A}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AD02}",
        nfc: "\u{AD02}",
        nfd: "\u{1100}\u{116A}\u{11AD}",
        nfkc: "\u{AD02}",
        nfkd: "\u{1100}\u{116A}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AD03}",
        nfc: "\u{AD03}",
        nfd: "\u{1100}\u{116A}\u{11AE}",
        nfkc: "\u{AD03}",
        nfkd: "\u{1100}\u{116A}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AD04}",
        nfc: "\u{AD04}",
        nfd: "\u{1100}\u{116A}\u{11AF}",
        nfkc: "\u{AD04}",
        nfkd: "\u{1100}\u{116A}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AD05}",
        nfc: "\u{AD05}",
        nfd: "\u{1100}\u{116A}\u{11B0}",
        nfkc: "\u{AD05}",
        nfkd: "\u{1100}\u{116A}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AD06}",
        nfc: "\u{AD06}",
        nfd: "\u{1100}\u{116A}\u{11B1}",
        nfkc: "\u{AD06}",
        nfkd: "\u{1100}\u{116A}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AD07}",
        nfc: "\u{AD07}",
        nfd: "\u{1100}\u{116A}\u{11B2}",
        nfkc: "\u{AD07}",
        nfkd: "\u{1100}\u{116A}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AD08}",
        nfc: "\u{AD08}",
        nfd: "\u{1100}\u{116A}\u{11B3}",
        nfkc: "\u{AD08}",
        nfkd: "\u{1100}\u{116A}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AD09}",
        nfc: "\u{AD09}",
        nfd: "\u{1100}\u{116A}\u{11B4}",
        nfkc: "\u{AD09}",
        nfkd: "\u{1100}\u{116A}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AD0A}",
        nfc: "\u{AD0A}",
        nfd: "\u{1100}\u{116A}\u{11B5}",
        nfkc: "\u{AD0A}",
        nfkd: "\u{1100}\u{116A}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AD0B}",
        nfc: "\u{AD0B}",
        nfd: "\u{1100}\u{116A}\u{11B6}",
        nfkc: "\u{AD0B}",
        nfkd: "\u{1100}\u{116A}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AD0C}",
        nfc: "\u{AD0C}",
        nfd: "\u{1100}\u{116A}\u{11B7}",
        nfkc: "\u{AD0C}",
        nfkd: "\u{1100}\u{116A}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AD0D}",
        nfc: "\u{AD0D}",
        nfd: "\u{1100}\u{116A}\u{11B8}",
        nfkc: "\u{AD0D}",
        nfkd: "\u{1100}\u{116A}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AD0E}",
        nfc: "\u{AD0E}",
        nfd: "\u{1100}\u{116A}\u{11B9}",
        nfkc: "\u{AD0E}",
        nfkd: "\u{1100}\u{116A}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AD0F}",
        nfc: "\u{AD0F}",
        nfd: "\u{1100}\u{116A}\u{11BA}",
        nfkc: "\u{AD0F}",
        nfkd: "\u{1100}\u{116A}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AD10}",
        nfc: "\u{AD10}",
        nfd: "\u{1100}\u{116A}\u{11BB}",
        nfkc: "\u{AD10}",
        nfkd: "\u{1100}\u{116A}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AD11}",
        nfc: "\u{AD11}",
        nfd: "\u{1100}\u{116A}\u{11BC}",
        nfkc: "\u{AD11}",
        nfkd: "\u{1100}\u{116A}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AD12}",
        nfc: "\u{AD12}",
        nfd: "\u{1100}\u{116A}\u{11BD}",
        nfkc: "\u{AD12}",
        nfkd: "\u{1100}\u{116A}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AD13}",
        nfc: "\u{AD13}",
        nfd: "\u{1100}\u{116A}\u{11BE}",
        nfkc: "\u{AD13}",
        nfkd: "\u{1100}\u{116A}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AD14}",
        nfc: "\u{AD14}",
        nfd: "\u{1100}\u{116A}\u{11BF}",
        nfkc: "\u{AD14}",
        nfkd: "\u{1100}\u{116A}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AD15}",
        nfc: "\u{AD15}",
        nfd: "\u{1100}\u{116A}\u{11C0}",
        nfkc: "\u{AD15}",
        nfkd: "\u{1100}\u{116A}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AD16}",
        nfc: "\u{AD16}",
        nfd: "\u{1100}\u{116A}\u{11C1}",
        nfkc: "\u{AD16}",
        nfkd: "\u{1100}\u{116A}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AD17}",
        nfc: "\u{AD17}",
        nfd: "\u{1100}\u{116A}\u{11C2}",
        nfkc: "\u{AD17}",
        nfkd: "\u{1100}\u{116A}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AD18}",
        nfc: "\u{AD18}",
        nfd: "\u{1100}\u{116B}",
        nfkc: "\u{AD18}",
        nfkd: "\u{1100}\u{116B}",
    },
    NormalizationTest {
        source: "\u{AD19}",
        nfc: "\u{AD19}",
        nfd: "\u{1100}\u{116B}\u{11A8}",
        nfkc: "\u{AD19}",
        nfkd: "\u{1100}\u{116B}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AD1A}",
        nfc: "\u{AD1A}",
        nfd: "\u{1100}\u{116B}\u{11A9}",
        nfkc: "\u{AD1A}",
        nfkd: "\u{1100}\u{116B}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AD1B}",
        nfc: "\u{AD1B}",
        nfd: "\u{1100}\u{116B}\u{11AA}",
        nfkc: "\u{AD1B}",
        nfkd: "\u{1100}\u{116B}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AD1C}",
        nfc: "\u{AD1C}",
        nfd: "\u{1100}\u{116B}\u{11AB}",
        nfkc: "\u{AD1C}",
        nfkd: "\u{1100}\u{116B}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AD1D}",
        nfc: "\u{AD1D}",
        nfd: "\u{1100}\u{116B}\u{11AC}",
        nfkc: "\u{AD1D}",
        nfkd: "\u{1100}\u{116B}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AD1E}",
        nfc: "\u{AD1E}",
        nfd: "\u{1100}\u{116B}\u{11AD}",
        nfkc: "\u{AD1E}",
        nfkd: "\u{1100}\u{116B}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AD1F}",
        nfc: "\u{AD1F}",
        nfd: "\u{1100}\u{116B}\u{11AE}",
        nfkc: "\u{AD1F}",
        nfkd: "\u{1100}\u{116B}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AD20}",
        nfc: "\u{AD20}",
        nfd: "\u{1100}\u{116B}\u{11AF}",
        nfkc: "\u{AD20}",
        nfkd: "\u{1100}\u{116B}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AD21}",
        nfc: "\u{AD21}",
        nfd: "\u{1100}\u{116B}\u{11B0}",
        nfkc: "\u{AD21}",
        nfkd: "\u{1100}\u{116B}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AD22}",
        nfc: "\u{AD22}",
        nfd: "\u{1100}\u{116B}\u{11B1}",
        nfkc: "\u{AD22}",
        nfkd: "\u{1100}\u{116B}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AD23}",
        nfc: "\u{AD23}",
        nfd: "\u{1100}\u{116B}\u{11B2}",
        nfkc: "\u{AD23}",
        nfkd: "\u{1100}\u{116B}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AD24}",
        nfc: "\u{AD24}",
        nfd: "\u{1100}\u{116B}\u{11B3}",
        nfkc: "\u{AD24}",
        nfkd: "\u{1100}\u{116B}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AD25}",
        nfc: "\u{AD25}",
        nfd: "\u{1100}\u{116B}\u{11B4}",
        nfkc: "\u{AD25}",
        nfkd: "\u{1100}\u{116B}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AD26}",
        nfc: "\u{AD26}",
        nfd: "\u{1100}\u{116B}\u{11B5}",
        nfkc: "\u{AD26}",
        nfkd: "\u{1100}\u{116B}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AD27}",
        nfc: "\u{AD27}",
        nfd: "\u{1100}\u{116B}\u{11B6}",
        nfkc: "\u{AD27}",
        nfkd: "\u{1100}\u{116B}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AD28}",
        nfc: "\u{AD28}",
        nfd: "\u{1100}\u{116B}\u{11B7}",
        nfkc: "\u{AD28}",
        nfkd: "\u{1100}\u{116B}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AD29}",
        nfc: "\u{AD29}",
        nfd: "\u{1100}\u{116B}\u{11B8}",
        nfkc: "\u{AD29}",
        nfkd: "\u{1100}\u{116B}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AD2A}",
        nfc: "\u{AD2A}",
        nfd: "\u{1100}\u{116B}\u{11B9}",
        nfkc: "\u{AD2A}",
        nfkd: "\u{1100}\u{116B}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AD2B}",
        nfc: "\u{AD2B}",
        nfd: "\u{1100}\u{116B}\u{11BA}",
        nfkc: "\u{AD2B}",
        nfkd: "\u{1100}\u{116B}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AD2C}",
        nfc: "\u{AD2C}",
        nfd: "\u{1100}\u{116B}\u{11BB}",
        nfkc: "\u{AD2C}",
        nfkd: "\u{1100}\u{116B}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AD2D}",
        nfc: "\u{AD2D}",
        nfd: "\u{1100}\u{116B}\u{11BC}",
        nfkc: "\u{AD2D}",
        nfkd: "\u{1100}\u{116B}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AD2E}",
        nfc: "\u{AD2E}",
        nfd: "\u{1100}\u{116B}\u{11BD}",
        nfkc: "\u{AD2E}",
        nfkd: "\u{1100}\u{116B}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AD2F}",
        nfc: "\u{AD2F}",
        nfd: "\u{1100}\u{116B}\u{11BE}",
        nfkc: "\u{AD2F}",
        nfkd: "\u{1100}\u{116B}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AD30}",
        nfc: "\u{AD30}",
        nfd: "\u{1100}\u{116B}\u{11BF}",
        nfkc: "\u{AD30}",
        nfkd: "\u{1100}\u{116B}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AD31}",
        nfc: "\u{AD31}",
        nfd: "\u{1100}\u{116B}\u{11C0}",
        nfkc: "\u{AD31}",
        nfkd: "\u{1100}\u{116B}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AD32}",
        nfc: "\u{AD32}",
        nfd: "\u{1100}\u{116B}\u{11C1}",
        nfkc: "\u{AD32}",
        nfkd: "\u{1100}\u{116B}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AD33}",
        nfc: "\u{AD33}",
        nfd: "\u{1100}\u{116B}\u{11C2}",
        nfkc: "\u{AD33}",
        nfkd: "\u{1100}\u{116B}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AD34}",
        nfc: "\u{AD34}",
        nfd: "\u{1100}\u{116C}",
        nfkc: "\u{AD34}",
        nfkd: "\u{1100}\u{116C}",
    },
    NormalizationTest {
        source: "\u{AD35}",
        nfc: "\u{AD35}",
        nfd: "\u{1100}\u{116C}\u{11A8}",
        nfkc: "\u{AD35}",
        nfkd: "\u{1100}\u{116C}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AD36}",
        nfc: "\u{AD36}",
        nfd: "\u{1100}\u{116C}\u{11A9}",
        nfkc: "\u{AD36}",
        nfkd: "\u{1100}\u{116C}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AD37}",
        nfc: "\u{AD37}",
        nfd: "\u{1100}\u{116C}\u{11AA}",
        nfkc: "\u{AD37}",
        nfkd: "\u{1100}\u{116C}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AD38}",
        nfc: "\u{AD38}",
        nfd: "\u{1100}\u{116C}\u{11AB}",
        nfkc: "\u{AD38}",
        nfkd: "\u{1100}\u{116C}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AD39}",
        nfc: "\u{AD39}",
        nfd: "\u{1100}\u{116C}\u{11AC}",
        nfkc: "\u{AD39}",
        nfkd: "\u{1100}\u{116C}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AD3A}",
        nfc: "\u{AD3A}",
        nfd: "\u{1100}\u{116C}\u{11AD}",
        nfkc: "\u{AD3A}",
        nfkd: "\u{1100}\u{116C}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AD3B}",
        nfc: "\u{AD3B}",
        nfd: "\u{1100}\u{116C}\u{11AE}",
        nfkc: "\u{AD3B}",
        nfkd: "\u{1100}\u{116C}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AD3C}",
        nfc: "\u{AD3C}",
        nfd: "\u{1100}\u{116C}\u{11AF}",
        nfkc: "\u{AD3C}",
        nfkd: "\u{1100}\u{116C}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AD3D}",
        nfc: "\u{AD3D}",
        nfd: "\u{1100}\u{116C}\u{11B0}",
        nfkc: "\u{AD3D}",
        nfkd: "\u{1100}\u{116C}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AD3E}",
        nfc: "\u{AD3E}",
        nfd: "\u{1100}\u{116C}\u{11B1}",
        nfkc: "\u{AD3E}",
        nfkd: "\u{1100}\u{116C}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AD3F}",
        nfc: "\u{AD3F}",
        nfd: "\u{1100}\u{116C}\u{11B2}",
        nfkc: "\u{AD3F}",
        nfkd: "\u{1100}\u{116C}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AD40}",
        nfc: "\u{AD40}",
        nfd: "\u{1100}\u{116C}\u{11B3}",
        nfkc: "\u{AD40}",
        nfkd: "\u{1100}\u{116C}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AD41}",
        nfc: "\u{AD41}",
        nfd: "\u{1100}\u{116C}\u{11B4}",
        nfkc: "\u{AD41}",
        nfkd: "\u{1100}\u{116C}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AD42}",
        nfc: "\u{AD42}",
        nfd: "\u{1100}\u{116C}\u{11B5}",
        nfkc: "\u{AD42}",
        nfkd: "\u{1100}\u{116C}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AD43}",
        nfc: "\u{AD43}",
        nfd: "\u{1100}\u{116C}\u{11B6}",
        nfkc: "\u{AD43}",
        nfkd: "\u{1100}\u{116C}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AD44}",
        nfc: "\u{AD44}",
        nfd: "\u{1100}\u{116C}\u{11B7}",
        nfkc: "\u{AD44}",
        nfkd: "\u{1100}\u{116C}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AD45}",
        nfc: "\u{AD45}",
        nfd: "\u{1100}\u{116C}\u{11B8}",
        nfkc: "\u{AD45}",
        nfkd: "\u{1100}\u{116C}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AD46}",
        nfc: "\u{AD46}",
        nfd: "\u{1100}\u{116C}\u{11B9}",
        nfkc: "\u{AD46}",
        nfkd: "\u{1100}\u{116C}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AD47}",
        nfc: "\u{AD47}",
        nfd: "\u{1100}\u{116C}\u{11BA}",
        nfkc: "\u{AD47}",
        nfkd: "\u{1100}\u{116C}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AD48}",
        nfc: "\u{AD48}",
        nfd: "\u{1100}\u{116C}\u{11BB}",
        nfkc: "\u{AD48}",
        nfkd: "\u{1100}\u{116C}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AD49}",
        nfc: "\u{AD49}",
        nfd: "\u{1100}\u{116C}\u{11BC}",
        nfkc: "\u{AD49}",
        nfkd: "\u{1100}\u{116C}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AD4A}",
        nfc: "\u{AD4A}",
        nfd: "\u{1100}\u{116C}\u{11BD}",
        nfkc: "\u{AD4A}",
        nfkd: "\u{1100}\u{116C}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AD4B}",
        nfc: "\u{AD4B}",
        nfd: "\u{1100}\u{116C}\u{11BE}",
        nfkc: "\u{AD4B}",
        nfkd: "\u{1100}\u{116C}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AD4C}",
        nfc: "\u{AD4C}",
        nfd: "\u{1100}\u{116C}\u{11BF}",
        nfkc: "\u{AD4C}",
        nfkd: "\u{1100}\u{116C}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AD4D}",
        nfc: "\u{AD4D}",
        nfd: "\u{1100}\u{116C}\u{11C0}",
        nfkc: "\u{AD4D}",
        nfkd: "\u{1100}\u{116C}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AD4E}",
        nfc: "\u{AD4E}",
        nfd: "\u{1100}\u{116C}\u{11C1}",
        nfkc: "\u{AD4E}",
        nfkd: "\u{1100}\u{116C}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AD4F}",
        nfc: "\u{AD4F}",
        nfd: "\u{1100}\u{116C}\u{11C2}",
        nfkc: "\u{AD4F}",
        nfkd: "\u{1100}\u{116C}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AD50}",
        nfc: "\u{AD50}",
        nfd: "\u{1100}\u{116D}",
        nfkc: "\u{AD50}",
        nfkd: "\u{1100}\u{116D}",
    },
    NormalizationTest {
        source: "\u{AD51}",
        nfc: "\u{AD51}",
        nfd: "\u{1100}\u{116D}\u{11A8}",
        nfkc: "\u{AD51}",
        nfkd: "\u{1100}\u{116D}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AD52}",
        nfc: "\u{AD52}",
        nfd: "\u{1100}\u{116D}\u{11A9}",
        nfkc: "\u{AD52}",
        nfkd: "\u{1100}\u{116D}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AD53}",
        nfc: "\u{AD53}",
        nfd: "\u{1100}\u{116D}\u{11AA}",
        nfkc: "\u{AD53}",
        nfkd: "\u{1100}\u{116D}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AD54}",
        nfc: "\u{AD54}",
        nfd: "\u{1100}\u{116D}\u{11AB}",
        nfkc: "\u{AD54}",
        nfkd: "\u{1100}\u{116D}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AD55}",
        nfc: "\u{AD55}",
        nfd: "\u{1100}\u{116D}\u{11AC}",
        nfkc: "\u{AD55}",
        nfkd: "\u{1100}\u{116D}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AD56}",
        nfc: "\u{AD56}",
        nfd: "\u{1100}\u{116D}\u{11AD}",
        nfkc: "\u{AD56}",
        nfkd: "\u{1100}\u{116D}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AD57}",
        nfc: "\u{AD57}",
        nfd: "\u{1100}\u{116D}\u{11AE}",
        nfkc: "\u{AD57}",
        nfkd: "\u{1100}\u{116D}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AD58}",
        nfc: "\u{AD58}",
        nfd: "\u{1100}\u{116D}\u{11AF}",
        nfkc: "\u{AD58}",
        nfkd: "\u{1100}\u{116D}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AD59}",
        nfc: "\u{AD59}",
        nfd: "\u{1100}\u{116D}\u{11B0}",
        nfkc: "\u{AD59}",
        nfkd: "\u{1100}\u{116D}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AD5A}",
        nfc: "\u{AD5A}",
        nfd: "\u{1100}\u{116D}\u{11B1}",
        nfkc: "\u{AD5A}",
        nfkd: "\u{1100}\u{116D}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AD5B}",
        nfc: "\u{AD5B}",
        nfd: "\u{1100}\u{116D}\u{11B2}",
        nfkc: "\u{AD5B}",
        nfkd: "\u{1100}\u{116D}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AD5C}",
        nfc: "\u{AD5C}",
        nfd: "\u{1100}\u{116D}\u{11B3}",
        nfkc: "\u{AD5C}",
        nfkd: "\u{1100}\u{116D}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AD5D}",
        nfc: "\u{AD5D}",
        nfd: "\u{1100}\u{116D}\u{11B4}",
        nfkc: "\u{AD5D}",
        nfkd: "\u{1100}\u{116D}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AD5E}",
        nfc: "\u{AD5E}",
        nfd: "\u{1100}\u{116D}\u{11B5}",
        nfkc: "\u{AD5E}",
        nfkd: "\u{1100}\u{116D}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AD5F}",
        nfc: "\u{AD5F}",
        nfd: "\u{1100}\u{116D}\u{11B6}",
        nfkc: "\u{AD5F}",
        nfkd: "\u{1100}\u{116D}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AD60}",
        nfc: "\u{AD60}",
        nfd: "\u{1100}\u{116D}\u{11B7}",
        nfkc: "\u{AD60}",
        nfkd: "\u{1100}\u{116D}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AD61}",
        nfc: "\u{AD61}",
        nfd: "\u{1100}\u{116D}\u{11B8}",
        nfkc: "\u{AD61}",
        nfkd: "\u{1100}\u{116D}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AD62}",
        nfc: "\u{AD62}",
        nfd: "\u{1100}\u{116D}\u{11B9}",
        nfkc: "\u{AD62}",
        nfkd: "\u{1100}\u{116D}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AD63}",
        nfc: "\u{AD63}",
        nfd: "\u{1100}\u{116D}\u{11BA}",
        nfkc: "\u{AD63}",
        nfkd: "\u{1100}\u{116D}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AD64}",
        nfc: "\u{AD64}",
        nfd: "\u{1100}\u{116D}\u{11BB}",
        nfkc: "\u{AD64}",
        nfkd: "\u{1100}\u{116D}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AD65}",
        nfc: "\u{AD65}",
        nfd: "\u{1100}\u{116D}\u{11BC}",
        nfkc: "\u{AD65}",
        nfkd: "\u{1100}\u{116D}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AD66}",
        nfc: "\u{AD66}",
        nfd: "\u{1100}\u{116D}\u{11BD}",
        nfkc: "\u{AD66}",
        nfkd: "\u{1100}\u{116D}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AD67}",
        nfc: "\u{AD67}",
        nfd: "\u{1100}\u{116D}\u{11BE}",
        nfkc: "\u{AD67}",
        nfkd: "\u{1100}\u{116D}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AD68}",
        nfc: "\u{AD68}",
        nfd: "\u{1100}\u{116D}\u{11BF}",
        nfkc: "\u{AD68}",
        nfkd: "\u{1100}\u{116D}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AD69}",
        nfc: "\u{AD69}",
        nfd: "\u{1100}\u{116D}\u{11C0}",
        nfkc: "\u{AD69}",
        nfkd: "\u{1100}\u{116D}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AD6A}",
        nfc: "\u{AD6A}",
        nfd: "\u{1100}\u{116D}\u{11C1}",
        nfkc: "\u{AD6A}",
        nfkd: "\u{1100}\u{116D}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AD6B}",
        nfc: "\u{AD6B}",
        nfd: "\u{1100}\u{116D}\u{11C2}",
        nfkc: "\u{AD6B}",
        nfkd: "\u{1100}\u{116D}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AD6C}",
        nfc: "\u{AD6C}",
        nfd: "\u{1100}\u{116E}",
        nfkc: "\u{AD6C}",
        nfkd: "\u{1100}\u{116E}",
    },
    NormalizationTest {
        source: "\u{AD6D}",
        nfc: "\u{AD6D}",
        nfd: "\u{1100}\u{116E}\u{11A8}",
        nfkc: "\u{AD6D}",
        nfkd: "\u{1100}\u{116E}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AD6E}",
        nfc: "\u{AD6E}",
        nfd: "\u{1100}\u{116E}\u{11A9}",
        nfkc: "\u{AD6E}",
        nfkd: "\u{1100}\u{116E}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AD6F}",
        nfc: "\u{AD6F}",
        nfd: "\u{1100}\u{116E}\u{11AA}",
        nfkc: "\u{AD6F}",
        nfkd: "\u{1100}\u{116E}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AD70}",
        nfc: "\u{AD70}",
        nfd: "\u{1100}\u{116E}\u{11AB}",
        nfkc: "\u{AD70}",
        nfkd: "\u{1100}\u{116E}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AD71}",
        nfc: "\u{AD71}",
        nfd: "\u{1100}\u{116E}\u{11AC}",
        nfkc: "\u{AD71}",
        nfkd: "\u{1100}\u{116E}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AD72}",
        nfc: "\u{AD72}",
        nfd: "\u{1100}\u{116E}\u{11AD}",
        nfkc: "\u{AD72}",
        nfkd: "\u{1100}\u{116E}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AD73}",
        nfc: "\u{AD73}",
        nfd: "\u{1100}\u{116E}\u{11AE}",
        nfkc: "\u{AD73}",
        nfkd: "\u{1100}\u{116E}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AD74}",
        nfc: "\u{AD74}",
        nfd: "\u{1100}\u{116E}\u{11AF}",
        nfkc: "\u{AD74}",
        nfkd: "\u{1100}\u{116E}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AD75}",
        nfc: "\u{AD75}",
        nfd: "\u{1100}\u{116E}\u{11B0}",
        nfkc: "\u{AD75}",
        nfkd: "\u{1100}\u{116E}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AD76}",
        nfc: "\u{AD76}",
        nfd: "\u{1100}\u{116E}\u{11B1}",
        nfkc: "\u{AD76}",
        nfkd: "\u{1100}\u{116E}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AD77}",
        nfc: "\u{AD77}",
        nfd: "\u{1100}\u{116E}\u{11B2}",
        nfkc: "\u{AD77}",
        nfkd: "\u{1100}\u{116E}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AD78}",
        nfc: "\u{AD78}",
        nfd: "\u{1100}\u{116E}\u{11B3}",
        nfkc: "\u{AD78}",
        nfkd: "\u{1100}\u{116E}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AD79}",
        nfc: "\u{AD79}",
        nfd: "\u{1100}\u{116E}\u{11B4}",
        nfkc: "\u{AD79}",
        nfkd: "\u{1100}\u{116E}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AD7A}",
        nfc: "\u{AD7A}",
        nfd: "\u{1100}\u{116E}\u{11B5}",
        nfkc: "\u{AD7A}",
        nfkd: "\u{1100}\u{116E}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AD7B}",
        nfc: "\u{AD7B}",
        nfd: "\u{1100}\u{116E}\u{11B6}",
        nfkc: "\u{AD7B}",
        nfkd: "\u{1100}\u{116E}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AD7C}",
        nfc: "\u{AD7C}",
        nfd: "\u{1100}\u{116E}\u{11B7}",
        nfkc: "\u{AD7C}",
        nfkd: "\u{1100}\u{116E}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AD7D}",
        nfc: "\u{AD7D}",
        nfd: "\u{1100}\u{116E}\u{11B8}",
        nfkc: "\u{AD7D}",
        nfkd: "\u{1100}\u{116E}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AD7E}",
        nfc: "\u{AD7E}",
        nfd: "\u{1100}\u{116E}\u{11B9}",
        nfkc: "\u{AD7E}",
        nfkd: "\u{1100}\u{116E}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AD7F}",
        nfc: "\u{AD7F}",
        nfd: "\u{1100}\u{116E}\u{11BA}",
        nfkc: "\u{AD7F}",
        nfkd: "\u{1100}\u{116E}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AD80}",
        nfc: "\u{AD80}",
        nfd: "\u{1100}\u{116E}\u{11BB}",
        nfkc: "\u{AD80}",
        nfkd: "\u{1100}\u{116E}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AD81}",
        nfc: "\u{AD81}",
        nfd: "\u{1100}\u{116E}\u{11BC}",
        nfkc: "\u{AD81}",
        nfkd: "\u{1100}\u{116E}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AD82}",
        nfc: "\u{AD82}",
        nfd: "\u{1100}\u{116E}\u{11BD}",
        nfkc: "\u{AD82}",
        nfkd: "\u{1100}\u{116E}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AD83}",
        nfc: "\u{AD83}",
        nfd: "\u{1100}\u{116E}\u{11BE}",
        nfkc: "\u{AD83}",
        nfkd: "\u{1100}\u{116E}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AD84}",
        nfc: "\u{AD84}",
        nfd: "\u{1100}\u{116E}\u{11BF}",
        nfkc: "\u{AD84}",
        nfkd: "\u{1100}\u{116E}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AD85}",
        nfc: "\u{AD85}",
        nfd: "\u{1100}\u{116E}\u{11C0}",
        nfkc: "\u{AD85}",
        nfkd: "\u{1100}\u{116E}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AD86}",
        nfc: "\u{AD86}",
        nfd: "\u{1100}\u{116E}\u{11C1}",
        nfkc: "\u{AD86}",
        nfkd: "\u{1100}\u{116E}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AD87}",
        nfc: "\u{AD87}",
        nfd: "\u{1100}\u{116E}\u{11C2}",
        nfkc: "\u{AD87}",
        nfkd: "\u{1100}\u{116E}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AD88}",
        nfc: "\u{AD88}",
        nfd: "\u{1100}\u{116F}",
        nfkc: "\u{AD88}",
        nfkd: "\u{1100}\u{116F}",
    },
    NormalizationTest {
        source: "\u{AD89}",
        nfc: "\u{AD89}",
        nfd: "\u{1100}\u{116F}\u{11A8}",
        nfkc: "\u{AD89}",
        nfkd: "\u{1100}\u{116F}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AD8A}",
        nfc: "\u{AD8A}",
        nfd: "\u{1100}\u{116F}\u{11A9}",
        nfkc: "\u{AD8A}",
        nfkd: "\u{1100}\u{116F}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AD8B}",
        nfc: "\u{AD8B}",
        nfd: "\u{1100}\u{116F}\u{11AA}",
        nfkc: "\u{AD8B}",
        nfkd: "\u{1100}\u{116F}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AD8C}",
        nfc: "\u{AD8C}",
        nfd: "\u{1100}\u{116F}\u{11AB}",
        nfkc: "\u{AD8C}",
        nfkd: "\u{1100}\u{116F}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AD8D}",
        nfc: "\u{AD8D}",
        nfd: "\u{1100}\u{116F}\u{11AC}",
        nfkc: "\u{AD8D}",
        nfkd: "\u{1100}\u{116F}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AD8E}",
        nfc: "\u{AD8E}",
        nfd: "\u{1100}\u{116F}\u{11AD}",
        nfkc: "\u{AD8E}",
        nfkd: "\u{1100}\u{116F}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AD8F}",
        nfc: "\u{AD8F}",
        nfd: "\u{1100}\u{116F}\u{11AE}",
        nfkc: "\u{AD8F}",
        nfkd: "\u{1100}\u{116F}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AD90}",
        nfc: "\u{AD90}",
        nfd: "\u{1100}\u{116F}\u{11AF}",
        nfkc: "\u{AD90}",
        nfkd: "\u{1100}\u{116F}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AD91}",
        nfc: "\u{AD91}",
        nfd: "\u{1100}\u{116F}\u{11B0}",
        nfkc: "\u{AD91}",
        nfkd: "\u{1100}\u{116F}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AD92}",
        nfc: "\u{AD92}",
        nfd: "\u{1100}\u{116F}\u{11B1}",
        nfkc: "\u{AD92}",
        nfkd: "\u{1100}\u{116F}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AD93}",
        nfc: "\u{AD93}",
        nfd: "\u{1100}\u{116F}\u{11B2}",
        nfkc: "\u{AD93}",
        nfkd: "\u{1100}\u{116F}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AD94}",
        nfc: "\u{AD94}",
        nfd: "\u{1100}\u{116F}\u{11B3}",
        nfkc: "\u{AD94}",
        nfkd: "\u{1100}\u{116F}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AD95}",
        nfc: "\u{AD95}",
        nfd: "\u{1100}\u{116F}\u{11B4}",
        nfkc: "\u{AD95}",
        nfkd: "\u{1100}\u{116F}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AD96}",
        nfc: "\u{AD96}",
        nfd: "\u{1100}\u{116F}\u{11B5}",
        nfkc: "\u{AD96}",
        nfkd: "\u{1100}\u{116F}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AD97}",
        nfc: "\u{AD97}",
        nfd: "\u{1100}\u{116F}\u{11B6}",
        nfkc: "\u{AD97}",
        nfkd: "\u{1100}\u{116F}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AD98}",
        nfc: "\u{AD98}",
        nfd: "\u{1100}\u{116F}\u{11B7}",
        nfkc: "\u{AD98}",
        nfkd: "\u{1100}\u{116F}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AD99}",
        nfc: "\u{AD99}",
        nfd: "\u{1100}\u{116F}\u{11B8}",
        nfkc: "\u{AD99}",
        nfkd: "\u{1100}\u{116F}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AD9A}",
        nfc: "\u{AD9A}",
        nfd: "\u{1100}\u{116F}\u{11B9}",
        nfkc: "\u{AD9A}",
        nfkd: "\u{1100}\u{116F}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AD9B}",
        nfc: "\u{AD9B}",
        nfd: "\u{1100}\u{116F}\u{11BA}",
        nfkc: "\u{AD9B}",
        nfkd: "\u{1100}\u{116F}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AD9C}",
        nfc: "\u{AD9C}",
        nfd: "\u{1100}\u{116F}\u{11BB}",
        nfkc: "\u{AD9C}",
        nfkd: "\u{1100}\u{116F}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AD9D}",
        nfc: "\u{AD9D}",
        nfd: "\u{1100}\u{116F}\u{11BC}",
        nfkc: "\u{AD9D}",
        nfkd: "\u{1100}\u{116F}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AD9E}",
        nfc: "\u{AD9E}",
        nfd: "\u{1100}\u{116F}\u{11BD}",
        nfkc: "\u{AD9E}",
        nfkd: "\u{1100}\u{116F}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AD9F}",
        nfc: "\u{AD9F}",
        nfd: "\u{1100}\u{116F}\u{11BE}",
        nfkc: "\u{AD9F}",
        nfkd: "\u{1100}\u{116F}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{ADA0}",
        nfc: "\u{ADA0}",
        nfd: "\u{1100}\u{116F}\u{11BF}",
        nfkc: "\u{ADA0}",
        nfkd: "\u{1100}\u{116F}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{ADA1}",
        nfc: "\u{ADA1}",
        nfd: "\u{1100}\u{116F}\u{11C0}",
        nfkc: "\u{ADA1}",
        nfkd: "\u{1100}\u{116F}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{ADA2}",
        nfc: "\u{ADA2}",
        nfd: "\u{1100}\u{116F}\u{11C1}",
        nfkc: "\u{ADA2}",
        nfkd: "\u{1100}\u{116F}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{ADA3}",
        nfc: "\u{ADA3}",
        nfd: "\u{1100}\u{116F}\u{11C2}",
        nfkc: "\u{ADA3}",
        nfkd: "\u{1100}\u{116F}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{ADA4}",
        nfc: "\u{ADA4}",
        nfd: "\u{1100}\u{1170}",
        nfkc: "\u{ADA4}",
        nfkd: "\u{1100}\u{1170}",
    },
    NormalizationTest {
        source: "\u{ADA5}",
        nfc: "\u{ADA5}",
        nfd: "\u{1100}\u{1170}\u{11A8}",
        nfkc: "\u{ADA5}",
        nfkd: "\u{1100}\u{1170}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{ADA6}",
        nfc: "\u{ADA6}",
        nfd: "\u{1100}\u{1170}\u{11A9}",
        nfkc: "\u{ADA6}",
        nfkd: "\u{1100}\u{1170}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{ADA7}",
        nfc: "\u{ADA7}",
        nfd: "\u{1100}\u{1170}\u{11AA}",
        nfkc: "\u{ADA7}",
        nfkd: "\u{1100}\u{1170}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{ADA8}",
        nfc: "\u{ADA8}",
        nfd: "\u{1100}\u{1170}\u{11AB}",
        nfkc: "\u{ADA8}",
        nfkd: "\u{1100}\u{1170}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{ADA9}",
        nfc: "\u{ADA9}",
        nfd: "\u{1100}\u{1170}\u{11AC}",
        nfkc: "\u{ADA9}",
        nfkd: "\u{1100}\u{1170}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{ADAA}",
        nfc: "\u{ADAA}",
        nfd: "\u{1100}\u{1170}\u{11AD}",
        nfkc: "\u{ADAA}",
        nfkd: "\u{1100}\u{1170}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{ADAB}",
        nfc: "\u{ADAB}",
        nfd: "\u{1100}\u{1170}\u{11AE}",
        nfkc: "\u{ADAB}",
        nfkd: "\u{1100}\u{1170}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{ADAC}",
        nfc: "\u{ADAC}",
        nfd: "\u{1100}\u{1170}\u{11AF}",
        nfkc: "\u{ADAC}",
        nfkd: "\u{1100}\u{1170}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{ADAD}",
        nfc: "\u{ADAD}",
        nfd: "\u{1100}\u{1170}\u{11B0}",
        nfkc: "\u{ADAD}",
        nfkd: "\u{1100}\u{1170}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{ADAE}",
        nfc: "\u{ADAE}",
        nfd: "\u{1100}\u{1170}\u{11B1}",
        nfkc: "\u{ADAE}",
        nfkd: "\u{1100}\u{1170}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{ADAF}",
        nfc: "\u{ADAF}",
        nfd: "\u{1100}\u{1170}\u{11B2}",
        nfkc: "\u{ADAF}",
        nfkd: "\u{1100}\u{1170}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{ADB0}",
        nfc: "\u{ADB0}",
        nfd: "\u{1100}\u{1170}\u{11B3}",
        nfkc: "\u{ADB0}",
        nfkd: "\u{1100}\u{1170}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{ADB1}",
        nfc: "\u{ADB1}",
        nfd: "\u{1100}\u{1170}\u{11B4}",
        nfkc: "\u{ADB1}",
        nfkd: "\u{1100}\u{1170}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{ADB2}",
        nfc: "\u{ADB2}",
        nfd: "\u{1100}\u{1170}\u{11B5}",
        nfkc: "\u{ADB2}",
        nfkd: "\u{1100}\u{1170}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{ADB3}",
        nfc: "\u{ADB3}",
        nfd: "\u{1100}\u{1170}\u{11B6}",
        nfkc: "\u{ADB3}",
        nfkd: "\u{1100}\u{1170}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{ADB4}",
        nfc: "\u{ADB4}",
        nfd: "\u{1100}\u{1170}\u{11B7}",
        nfkc: "\u{ADB4}",
        nfkd: "\u{1100}\u{1170}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{ADB5}",
        nfc: "\u{ADB5}",
        nfd: "\u{1100}\u{1170}\u{11B8}",
        nfkc: "\u{ADB5}",
        nfkd: "\u{1100}\u{1170}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{ADB6}",
        nfc: "\u{ADB6}",
        nfd: "\u{1100}\u{1170}\u{11B9}",
        nfkc: "\u{ADB6}",
        nfkd: "\u{1100}\u{1170}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{ADB7}",
        nfc: "\u{ADB7}",
        nfd: "\u{1100}\u{1170}\u{11BA}",
        nfkc: "\u{ADB7}",
        nfkd: "\u{1100}\u{1170}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{ADB8}",
        nfc: "\u{ADB8}",
        nfd: "\u{1100}\u{1170}\u{11BB}",
        nfkc: "\u{ADB8}",
        nfkd: "\u{1100}\u{1170}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{ADB9}",
        nfc: "\u{ADB9}",
        nfd: "\u{1100}\u{1170}\u{11BC}",
        nfkc: "\u{ADB9}",
        nfkd: "\u{1100}\u{1170}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{ADBA}",
        nfc: "\u{ADBA}",
        nfd: "\u{1100}\u{1170}\u{11BD}",
        nfkc: "\u{ADBA}",
        nfkd: "\u{1100}\u{1170}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{ADBB}",
        nfc: "\u{ADBB}",
        nfd: "\u{1100}\u{1170}\u{11BE}",
        nfkc: "\u{ADBB}",
        nfkd: "\u{1100}\u{1170}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{ADBC}",
        nfc: "\u{ADBC}",
        nfd: "\u{1100}\u{1170}\u{11BF}",
        nfkc: "\u{ADBC}",
        nfkd: "\u{1100}\u{1170}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{ADBD}",
        nfc: "\u{ADBD}",
        nfd: "\u{1100}\u{1170}\u{11C0}",
        nfkc: "\u{ADBD}",
        nfkd: "\u{1100}\u{1170}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{ADBE}",
        nfc: "\u{ADBE}",
        nfd: "\u{1100}\u{1170}\u{11C1}",
        nfkc: "\u{ADBE}",
        nfkd: "\u{1100}\u{1170}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{ADBF}",
        nfc: "\u{ADBF}",
        nfd: "\u{1100}\u{1170}\u{11C2}",
        nfkc: "\u{ADBF}",
        nfkd: "\u{1100}\u{1170}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{ADC0}",
        nfc: "\u{ADC0}",
        nfd: "\u{1100}\u{1171}",
        nfkc: "\u{ADC0}",
        nfkd: "\u{1100}\u{1171}",
    },
    NormalizationTest {
        source: "\u{ADC1}",
        nfc: "\u{ADC1}",
        nfd: "\u{1100}\u{1171}\u{11A8}",
        nfkc: "\u{ADC1}",
        nfkd: "\u{1100}\u{1171}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{ADC2}",
        nfc: "\u{ADC2}",
        nfd: "\u{1100}\u{1171}\u{11A9}",
        nfkc: "\u{ADC2}",
        nfkd: "\u{1100}\u{1171}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{ADC3}",
        nfc: "\u{ADC3}",
        nfd: "\u{1100}\u{1171}\u{11AA}",
        nfkc: "\u{ADC3}",
        nfkd: "\u{1100}\u{1171}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{ADC4}",
        nfc: "\u{ADC4}",
        nfd: "\u{1100}\u{1171}\u{11AB}",
        nfkc: "\u{ADC4}",
        nfkd: "\u{1100}\u{1171}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{ADC5}",
        nfc: "\u{ADC5}",
        nfd: "\u{1100}\u{1171}\u{11AC}",
        nfkc: "\u{ADC5}",
        nfkd: "\u{1100}\u{1171}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{ADC6}",
        nfc: "\u{ADC6}",
        nfd: "\u{1100}\u{1171}\u{11AD}",
        nfkc: "\u{ADC6}",
        nfkd: "\u{1100}\u{1171}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{ADC7}",
        nfc: "\u{ADC7}",
        nfd: "\u{1100}\u{1171}\u{11AE}",
        nfkc: "\u{ADC7}",
        nfkd: "\u{1100}\u{1171}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{ADC8}",
        nfc: "\u{ADC8}",
        nfd: "\u{1100}\u{1171}\u{11AF}",
        nfkc: "\u{ADC8}",
        nfkd: "\u{1100}\u{1171}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{ADC9}",
        nfc: "\u{ADC9}",
        nfd: "\u{1100}\u{1171}\u{11B0}",
        nfkc: "\u{ADC9}",
        nfkd: "\u{1100}\u{1171}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{ADCA}",
        nfc: "\u{ADCA}",
        nfd: "\u{1100}\u{1171}\u{11B1}",
        nfkc: "\u{ADCA}",
        nfkd: "\u{1100}\u{1171}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{ADCB}",
        nfc: "\u{ADCB}",
        nfd: "\u{1100}\u{1171}\u{11B2}",
        nfkc: "\u{ADCB}",
        nfkd: "\u{1100}\u{1171}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{ADCC}",
        nfc: "\u{ADCC}",
        nfd: "\u{1100}\u{1171}\u{11B3}",
        nfkc: "\u{ADCC}",
        nfkd: "\u{1100}\u{1171}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{ADCD}",
        nfc: "\u{ADCD}",
        nfd: "\u{1100}\u{1171}\u{11B4}",
        nfkc: "\u{ADCD}",
        nfkd: "\u{1100}\u{1171}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{ADCE}",
        nfc: "\u{ADCE}",
        nfd: "\u{1100}\u{1171}\u{11B5}",
        nfkc: "\u{ADCE}",
        nfkd: "\u{1100}\u{1171}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{ADCF}",
        nfc: "\u{ADCF}",
        nfd: "\u{1100}\u{1171}\u{11B6}",
        nfkc: "\u{ADCF}",
        nfkd: "\u{1100}\u{1171}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{ADD0}",
        nfc: "\u{ADD0}",
        nfd: "\u{1100}\u{1171}\u{11B7}",
        nfkc: "\u{ADD0}",
        nfkd: "\u{1100}\u{1171}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{ADD1}",
        nfc: "\u{ADD1}",
        nfd: "\u{1100}\u{1171}\u{11B8}",
        nfkc: "\u{ADD1}",
        nfkd: "\u{1100}\u{1171}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{ADD2}",
        nfc: "\u{ADD2}",
        nfd: "\u{1100}\u{1171}\u{11B9}",
        nfkc: "\u{ADD2}",
        nfkd: "\u{1100}\u{1171}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{ADD3}",
        nfc: "\u{ADD3}",
        nfd: "\u{1100}\u{1171}\u{11BA}",
        nfkc: "\u{ADD3}",
        nfkd: "\u{1100}\u{1171}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{ADD4}",
        nfc: "\u{ADD4}",
        nfd: "\u{1100}\u{1171}\u{11BB}",
        nfkc: "\u{ADD4}",
        nfkd: "\u{1100}\u{1171}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{ADD5}",
        nfc: "\u{ADD5}",
        nfd: "\u{1100}\u{1171}\u{11BC}",
        nfkc: "\u{ADD5}",
        nfkd: "\u{1100}\u{1171}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{ADD6}",
        nfc: "\u{ADD6}",
        nfd: "\u{1100}\u{1171}\u{11BD}",
        nfkc: "\u{ADD6}",
        nfkd: "\u{1100}\u{1171}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{ADD7}",
        nfc: "\u{ADD7}",
        nfd: "\u{1100}\u{1171}\u{11BE}",
        nfkc: "\u{ADD7}",
        nfkd: "\u{1100}\u{1171}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{ADD8}",
        nfc: "\u{ADD8}",
        nfd: "\u{1100}\u{1171}\u{11BF}",
        nfkc: "\u{ADD8}",
        nfkd: "\u{1100}\u{1171}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{ADD9}",
        nfc: "\u{ADD9}",
        nfd: "\u{1100}\u{1171}\u{11C0}",
        nfkc: "\u{ADD9}",
        nfkd: "\u{1100}\u{1171}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{ADDA}",
        nfc: "\u{ADDA}",
        nfd: "\u{1100}\u{1171}\u{11C1}",
        nfkc: "\u{ADDA}",
        nfkd: "\u{1100}\u{1171}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{ADDB}",
        nfc: "\u{ADDB}",
        nfd: "\u{1100}\u{1171}\u{11C2}",
        nfkc: "\u{ADDB}",
        nfkd: "\u{1100}\u{1171}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{ADDC}",
        nfc: "\u{ADDC}",
        nfd: "\u{1100}\u{1172}",
        nfkc: "\u{ADDC}",
        nfkd: "\u{1100}\u{1172}",
    },
    NormalizationTest {
        source: "\u{ADDD}",
        nfc: "\u{ADDD}",
        nfd: "\u{1100}\u{1172}\u{11A8}",
        nfkc: "\u{ADDD}",
        nfkd: "\u{1100}\u{1172}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{ADDE}",
        nfc: "\u{ADDE}",
        nfd: "\u{1100}\u{1172}\u{11A9}",
        nfkc: "\u{ADDE}",
        nfkd: "\u{1100}\u{1172}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{ADDF}",
        nfc: "\u{ADDF}",
        nfd: "\u{1100}\u{1172}\u{11AA}",
        nfkc: "\u{ADDF}",
        nfkd: "\u{1100}\u{1172}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{ADE0}",
        nfc: "\u{ADE0}",
        nfd: "\u{1100}\u{1172}\u{11AB}",
        nfkc: "\u{ADE0}",
        nfkd: "\u{1100}\u{1172}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{ADE1}",
        nfc: "\u{ADE1}",
        nfd: "\u{1100}\u{1172}\u{11AC}",
        nfkc: "\u{ADE1}",
        nfkd: "\u{1100}\u{1172}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{ADE2}",
        nfc: "\u{ADE2}",
        nfd: "\u{1100}\u{1172}\u{11AD}",
        nfkc: "\u{ADE2}",
        nfkd: "\u{1100}\u{1172}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{ADE3}",
        nfc: "\u{ADE3}",
        nfd: "\u{1100}\u{1172}\u{11AE}",
        nfkc: "\u{ADE3}",
        nfkd: "\u{1100}\u{1172}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{ADE4}",
        nfc: "\u{ADE4}",
        nfd: "\u{1100}\u{1172}\u{11AF}",
        nfkc: "\u{ADE4}",
        nfkd: "\u{1100}\u{1172}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{ADE5}",
        nfc: "\u{ADE5}",
        nfd: "\u{1100}\u{1172}\u{11B0}",
        nfkc: "\u{ADE5}",
        nfkd: "\u{1100}\u{1172}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{ADE6}",
        nfc: "\u{ADE6}",
        nfd: "\u{1100}\u{1172}\u{11B1}",
        nfkc: "\u{ADE6}",
        nfkd: "\u{1100}\u{1172}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{ADE7}",
        nfc: "\u{ADE7}",
        nfd: "\u{1100}\u{1172}\u{11B2}",
        nfkc: "\u{ADE7}",
        nfkd: "\u{1100}\u{1172}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{ADE8}",
        nfc: "\u{ADE8}",
        nfd: "\u{1100}\u{1172}\u{11B3}",
        nfkc: "\u{ADE8}",
        nfkd: "\u{1100}\u{1172}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{ADE9}",
        nfc: "\u{ADE9}",
        nfd: "\u{1100}\u{1172}\u{11B4}",
        nfkc: "\u{ADE9}",
        nfkd: "\u{1100}\u{1172}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{ADEA}",
        nfc: "\u{ADEA}",
        nfd: "\u{1100}\u{1172}\u{11B5}",
        nfkc: "\u{ADEA}",
        nfkd: "\u{1100}\u{1172}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{ADEB}",
        nfc: "\u{ADEB}",
        nfd: "\u{1100}\u{1172}\u{11B6}",
        nfkc: "\u{ADEB}",
        nfkd: "\u{1100}\u{1172}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{ADEC}",
        nfc: "\u{ADEC}",
        nfd: "\u{1100}\u{1172}\u{11B7}",
        nfkc: "\u{ADEC}",
        nfkd: "\u{1100}\u{1172}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{ADED}",
        nfc: "\u{ADED}",
        nfd: "\u{1100}\u{1172}\u{11B8}",
        nfkc: "\u{ADED}",
        nfkd: "\u{1100}\u{1172}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{ADEE}",
        nfc: "\u{ADEE}",
        nfd: "\u{1100}\u{1172}\u{11B9}",
        nfkc: "\u{ADEE}",
        nfkd: "\u{1100}\u{1172}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{ADEF}",
        nfc: "\u{ADEF}",
        nfd: "\u{1100}\u{1172}\u{11BA}",
        nfkc: "\u{ADEF}",
        nfkd: "\u{1100}\u{1172}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{ADF0}",
        nfc: "\u{ADF0}",
        nfd: "\u{1100}\u{1172}\u{11BB}",
        nfkc: "\u{ADF0}",
        nfkd: "\u{1100}\u{1172}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{ADF1}",
        nfc: "\u{ADF1}",
        nfd: "\u{1100}\u{1172}\u{11BC}",
        nfkc: "\u{ADF1}",
        nfkd: "\u{1100}\u{1172}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{ADF2}",
        nfc: "\u{ADF2}",
        nfd: "\u{1100}\u{1172}\u{11BD}",
        nfkc: "\u{ADF2}",
        nfkd: "\u{1100}\u{1172}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{ADF3}",
        nfc: "\u{ADF3}",
        nfd: "\u{1100}\u{1172}\u{11BE}",
        nfkc: "\u{ADF3}",
        nfkd: "\u{1100}\u{1172}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{ADF4}",
        nfc: "\u{ADF4}",
        nfd: "\u{1100}\u{1172}\u{11BF}",
        nfkc: "\u{ADF4}",
        nfkd: "\u{1100}\u{1172}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{ADF5}",
        nfc: "\u{ADF5}",
        nfd: "\u{1100}\u{1172}\u{11C0}",
        nfkc: "\u{ADF5}",
        nfkd: "\u{1100}\u{1172}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{ADF6}",
        nfc: "\u{ADF6}",
        nfd: "\u{1100}\u{1172}\u{11C1}",
        nfkc: "\u{ADF6}",
        nfkd: "\u{1100}\u{1172}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{ADF7}",
        nfc: "\u{ADF7}",
        nfd: "\u{1100}\u{1172}\u{11C2}",
        nfkc: "\u{ADF7}",
        nfkd: "\u{1100}\u{1172}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{ADF8}",
        nfc: "\u{ADF8}",
        nfd: "\u{1100}\u{1173}",
        nfkc: "\u{ADF8}",
        nfkd: "\u{1100}\u{1173}",
    },
    NormalizationTest {
        source: "\u{ADF9}",
        nfc: "\u{ADF9}",
        nfd: "\u{1100}\u{1173}\u{11A8}",
        nfkc: "\u{ADF9}",
        nfkd: "\u{1100}\u{1173}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{ADFA}",
        nfc: "\u{ADFA}",
        nfd: "\u{1100}\u{1173}\u{11A9}",
        nfkc: "\u{ADFA}",
        nfkd: "\u{1100}\u{1173}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{ADFB}",
        nfc: "\u{ADFB}",
        nfd: "\u{1100}\u{1173}\u{11AA}",
        nfkc: "\u{ADFB}",
        nfkd: "\u{1100}\u{1173}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{ADFC}",
        nfc: "\u{ADFC}",
        nfd: "\u{1100}\u{1173}\u{11AB}",
        nfkc: "\u{ADFC}",
        nfkd: "\u{1100}\u{1173}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{ADFD}",
        nfc: "\u{ADFD}",
        nfd: "\u{1100}\u{1173}\u{11AC}",
        nfkc: "\u{ADFD}",
        nfkd: "\u{1100}\u{1173}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{ADFE}",
        nfc: "\u{ADFE}",
        nfd: "\u{1100}\u{1173}\u{11AD}",
        nfkc: "\u{ADFE}",
        nfkd: "\u{1100}\u{1173}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{ADFF}",
        nfc: "\u{ADFF}",
        nfd: "\u{1100}\u{1173}\u{11AE}",
        nfkc: "\u{ADFF}",
        nfkd: "\u{1100}\u{1173}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AE00}",
        nfc: "\u{AE00}",
        nfd: "\u{1100}\u{1173}\u{11AF}",
        nfkc: "\u{AE00}",
        nfkd: "\u{1100}\u{1173}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AE01}",
        nfc: "\u{AE01}",
        nfd: "\u{1100}\u{1173}\u{11B0}",
        nfkc: "\u{AE01}",
        nfkd: "\u{1100}\u{1173}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AE02}",
        nfc: "\u{AE02}",
        nfd: "\u{1100}\u{1173}\u{11B1}",
        nfkc: "\u{AE02}",
        nfkd: "\u{1100}\u{1173}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AE03}",
        nfc: "\u{AE03}",
        nfd: "\u{1100}\u{1173}\u{11B2}",
        nfkc: "\u{AE03}",
        nfkd: "\u{1100}\u{1173}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AE04}",
        nfc: "\u{AE04}",
        nfd: "\u{1100}\u{1173}\u{11B3}",
        nfkc: "\u{AE04}",
        nfkd: "\u{1100}\u{1173}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AE05}",
        nfc: "\u{AE05}",
        nfd: "\u{1100}\u{1173}\u{11B4}",
        nfkc: "\u{AE05}",
        nfkd: "\u{1100}\u{1173}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AE06}",
        nfc: "\u{AE06}",
        nfd: "\u{1100}\u{1173}\u{11B5}",
        nfkc: "\u{AE06}",
        nfkd: "\u{1100}\u{1173}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AE07}",
        nfc: "\u{AE07}",
        nfd: "\u{1100}\u{1173}\u{11B6}",
        nfkc: "\u{AE07}",
        nfkd: "\u{1100}\u{1173}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AE08}",
        nfc: "\u{AE08}",
        nfd: "\u{1100}\u{1173}\u{11B7}",
        nfkc: "\u{AE08}",
        nfkd: "\u{1100}\u{1173}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AE09}",
        nfc: "\u{AE09}",
        nfd: "\u{1100}\u{1173}\u{11B8}",
        nfkc: "\u{AE09}",
        nfkd: "\u{1100}\u{1173}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AE0A}",
        nfc: "\u{AE0A}",
        nfd: "\u{1100}\u{1173}\u{11B9}",
        nfkc: "\u{AE0A}",
        nfkd: "\u{1100}\u{1173}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AE0B}",
        nfc: "\u{AE0B}",
        nfd: "\u{1100}\u{1173}\u{11BA}",
        nfkc: "\u{AE0B}",
        nfkd: "\u{1100}\u{1173}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AE0C}",
        nfc: "\u{AE0C}",
        nfd: "\u{1100}\u{1173}\u{11BB}",
        nfkc: "\u{AE0C}",
        nfkd: "\u{1100}\u{1173}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AE0D}",
        nfc: "\u{AE0D}",
        nfd: "\u{1100}\u{1173}\u{11BC}",
        nfkc: "\u{AE0D}",
        nfkd: "\u{1100}\u{1173}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AE0E}",
        nfc: "\u{AE0E}",
        nfd: "\u{1100}\u{1173}\u{11BD}",
        nfkc: "\u{AE0E}",
        nfkd: "\u{1100}\u{1173}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AE0F}",
        nfc: "\u{AE0F}",
        nfd: "\u{1100}\u{1173}\u{11BE}",
        nfkc: "\u{AE0F}",
        nfkd: "\u{1100}\u{1173}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AE10}",
        nfc: "\u{AE10}",
        nfd: "\u{1100}\u{1173}\u{11BF}",
        nfkc: "\u{AE10}",
        nfkd: "\u{1100}\u{1173}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AE11}",
        nfc: "\u{AE11}",
        nfd: "\u{1100}\u{1173}\u{11C0}",
        nfkc: "\u{AE11}",
        nfkd: "\u{1100}\u{1173}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AE12}",
        nfc: "\u{AE12}",
        nfd: "\u{1100}\u{1173}\u{11C1}",
        nfkc: "\u{AE12}",
        nfkd: "\u{1100}\u{1173}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AE13}",
        nfc: "\u{AE13}",
        nfd: "\u{1100}\u{1173}\u{11C2}",
        nfkc: "\u{AE13}",
        nfkd: "\u{1100}\u{1173}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AE14}",
        nfc: "\u{AE14}",
        nfd: "\u{1100}\u{1174}",
        nfkc: "\u{AE14}",
        nfkd: "\u{1100}\u{1174}",
    },
    NormalizationTest {
        source: "\u{AE15}",
        nfc: "\u{AE15}",
        nfd: "\u{1100}\u{1174}\u{11A8}",
        nfkc: "\u{AE15}",
        nfkd: "\u{1100}\u{1174}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AE16}",
        nfc: "\u{AE16}",
        nfd: "\u{1100}\u{1174}\u{11A9}",
        nfkc: "\u{AE16}",
        nfkd: "\u{1100}\u{1174}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AE17}",
        nfc: "\u{AE17}",
        nfd: "\u{1100}\u{1174}\u{11AA}",
        nfkc: "\u{AE17}",
        nfkd: "\u{1100}\u{1174}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AE18}",
        nfc: "\u{AE18}",
        nfd: "\u{1100}\u{1174}\u{11AB}",
        nfkc: "\u{AE18}",
        nfkd: "\u{1100}\u{1174}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AE19}",
        nfc: "\u{AE19}",
        nfd: "\u{1100}\u{1174}\u{11AC}",
        nfkc: "\u{AE19}",
        nfkd: "\u{1100}\u{1174}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AE1A}",
        nfc: "\u{AE1A}",
        nfd: "\u{1100}\u{1174}\u{11AD}",
        nfkc: "\u{AE1A}",
        nfkd: "\u{1100}\u{1174}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AE1B}",
        nfc: "\u{AE1B}",
        nfd: "\u{1100}\u{1174}\u{11AE}",
        nfkc: "\u{AE1B}",
        nfkd: "\u{1100}\u{1174}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AE1C}",
        nfc: "\u{AE1C}",
        nfd: "\u{1100}\u{1174}\u{11AF}",
        nfkc: "\u{AE1C}",
        nfkd: "\u{1100}\u{1174}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AE1D}",
        nfc: "\u{AE1D}",
        nfd: "\u{1100}\u{1174}\u{11B0}",
        nfkc: "\u{AE1D}",
        nfkd: "\u{1100}\u{1174}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AE1E}",
        nfc: "\u{AE1E}",
        nfd: "\u{1100}\u{1174}\u{11B1}",
        nfkc: "\u{AE1E}",
        nfkd: "\u{1100}\u{1174}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AE1F}",
        nfc: "\u{AE1F}",
        nfd: "\u{1100}\u{1174}\u{11B2}",
        nfkc: "\u{AE1F}",
        nfkd: "\u{1100}\u{1174}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AE20}",
        nfc: "\u{AE20}",
        nfd: "\u{1100}\u{1174}\u{11B3}",
        nfkc: "\u{AE20}",
        nfkd: "\u{1100}\u{1174}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AE21}",
        nfc: "\u{AE21}",
        nfd: "\u{1100}\u{1174}\u{11B4}",
        nfkc: "\u{AE21}",
        nfkd: "\u{1100}\u{1174}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AE22}",
        nfc: "\u{AE22}",
        nfd: "\u{1100}\u{1174}\u{11B5}",
        nfkc: "\u{AE22}",
        nfkd: "\u{1100}\u{1174}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AE23}",
        nfc: "\u{AE23}",
        nfd: "\u{1100}\u{1174}\u{11B6}",
        nfkc: "\u{AE23}",
        nfkd: "\u{1100}\u{1174}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AE24}",
        nfc: "\u{AE24}",
        nfd: "\u{1100}\u{1174}\u{11B7}",
        nfkc: "\u{AE24}",
        nfkd: "\u{1100}\u{1174}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AE25}",
        nfc: "\u{AE25}",
        nfd: "\u{1100}\u{1174}\u{11B8}",
        nfkc: "\u{AE25}",
        nfkd: "\u{1100}\u{1174}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AE26}",
        nfc: "\u{AE26}",
        nfd: "\u{1100}\u{1174}\u{11B9}",
        nfkc: "\u{AE26}",
        nfkd: "\u{1100}\u{1174}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AE27}",
        nfc: "\u{AE27}",
        nfd: "\u{1100}\u{1174}\u{11BA}",
        nfkc: "\u{AE27}",
        nfkd: "\u{1100}\u{1174}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AE28}",
        nfc: "\u{AE28}",
        nfd: "\u{1100}\u{1174}\u{11BB}",
        nfkc: "\u{AE28}",
        nfkd: "\u{1100}\u{1174}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AE29}",
        nfc: "\u{AE29}",
        nfd: "\u{1100}\u{1174}\u{11BC}",
        nfkc: "\u{AE29}",
        nfkd: "\u{1100}\u{1174}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AE2A}",
        nfc: "\u{AE2A}",
        nfd: "\u{1100}\u{1174}\u{11BD}",
        nfkc: "\u{AE2A}",
        nfkd: "\u{1100}\u{1174}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AE2B}",
        nfc: "\u{AE2B}",
        nfd: "\u{1100}\u{1174}\u{11BE}",
        nfkc: "\u{AE2B}",
        nfkd: "\u{1100}\u{1174}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AE2C}",
        nfc: "\u{AE2C}",
        nfd: "\u{1100}\u{1174}\u{11BF}",
        nfkc: "\u{AE2C}",
        nfkd: "\u{1100}\u{1174}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AE2D}",
        nfc: "\u{AE2D}",
        nfd: "\u{1100}\u{1174}\u{11C0}",
        nfkc: "\u{AE2D}",
        nfkd: "\u{1100}\u{1174}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AE2E}",
        nfc: "\u{AE2E}",
        nfd: "\u{1100}\u{1174}\u{11C1}",
        nfkc: "\u{AE2E}",
        nfkd: "\u{1100}\u{1174}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AE2F}",
        nfc: "\u{AE2F}",
        nfd: "\u{1100}\u{1174}\u{11C2}",
        nfkc: "\u{AE2F}",
        nfkd: "\u{1100}\u{1174}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AE30}",
        nfc: "\u{AE30}",
        nfd: "\u{1100}\u{1175}",
        nfkc: "\u{AE30}",
        nfkd: "\u{1100}\u{1175}",
    },
    NormalizationTest {
        source: "\u{AE31}",
        nfc: "\u{AE31}",
        nfd: "\u{1100}\u{1175}\u{11A8}",
        nfkc: "\u{AE31}",
        nfkd: "\u{1100}\u{1175}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AE32}",
        nfc: "\u{AE32}",
        nfd: "\u{1100}\u{1175}\u{11A9}",
        nfkc: "\u{AE32}",
        nfkd: "\u{1100}\u{1175}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AE33}",
        nfc: "\u{AE33}",
        nfd: "\u{1100}\u{1175}\u{11AA}",
        nfkc: "\u{AE33}",
        nfkd: "\u{1100}\u{1175}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AE34}",
        nfc: "\u{AE34}",
        nfd: "\u{1100}\u{1175}\u{11AB}",
        nfkc: "\u{AE34}",
        nfkd: "\u{1100}\u{1175}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AE35}",
        nfc: "\u{AE35}",
        nfd: "\u{1100}\u{1175}\u{11AC}",
        nfkc: "\u{AE35}",
        nfkd: "\u{1100}\u{1175}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AE36}",
        nfc: "\u{AE36}",
        nfd: "\u{1100}\u{1175}\u{11AD}",
        nfkc: "\u{AE36}",
        nfkd: "\u{1100}\u{1175}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AE37}",
        nfc: "\u{AE37}",
        nfd: "\u{1100}\u{1175}\u{11AE}",
        nfkc: "\u{AE37}",
        nfkd: "\u{1100}\u{1175}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AE38}",
        nfc: "\u{AE38}",
        nfd: "\u{1100}\u{1175}\u{11AF}",
        nfkc: "\u{AE38}",
        nfkd: "\u{1100}\u{1175}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AE39}",
        nfc: "\u{AE39}",
        nfd: "\u{1100}\u{1175}\u{11B0}",
        nfkc: "\u{AE39}",
        nfkd: "\u{1100}\u{1175}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AE3A}",
        nfc: "\u{AE3A}",
        nfd: "\u{1100}\u{1175}\u{11B1}",
        nfkc: "\u{AE3A}",
        nfkd: "\u{1100}\u{1175}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AE3B}",
        nfc: "\u{AE3B}",
        nfd: "\u{1100}\u{1175}\u{11B2}",
        nfkc: "\u{AE3B}",
        nfkd: "\u{1100}\u{1175}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AE3C}",
        nfc: "\u{AE3C}",
        nfd: "\u{1100}\u{1175}\u{11B3}",
        nfkc: "\u{AE3C}",
        nfkd: "\u{1100}\u{1175}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AE3D}",
        nfc: "\u{AE3D}",
        nfd: "\u{1100}\u{1175}\u{11B4}",
        nfkc: "\u{AE3D}",
        nfkd: "\u{1100}\u{1175}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AE3E}",
        nfc: "\u{AE3E}",
        nfd: "\u{1100}\u{1175}\u{11B5}",
        nfkc: "\u{AE3E}",
        nfkd: "\u{1100}\u{1175}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AE3F}",
        nfc: "\u{AE3F}",
        nfd: "\u{1100}\u{1175}\u{11B6}",
        nfkc: "\u{AE3F}",
        nfkd: "\u{1100}\u{1175}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AE40}",
        nfc: "\u{AE40}",
        nfd: "\u{1100}\u{1175}\u{11B7}",
        nfkc: "\u{AE40}",
        nfkd: "\u{1100}\u{1175}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AE41}",
        nfc: "\u{AE41}",
        nfd: "\u{1100}\u{1175}\u{11B8}",
        nfkc: "\u{AE41}",
        nfkd: "\u{1100}\u{1175}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AE42}",
        nfc: "\u{AE42}",
        nfd: "\u{1100}\u{1175}\u{11B9}",
        nfkc: "\u{AE42}",
        nfkd: "\u{1100}\u{1175}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AE43}",
        nfc: "\u{AE43}",
        nfd: "\u{1100}\u{1175}\u{11BA}",
        nfkc: "\u{AE43}",
        nfkd: "\u{1100}\u{1175}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AE44}",
        nfc: "\u{AE44}",
        nfd: "\u{1100}\u{1175}\u{11BB}",
        nfkc: "\u{AE44}",
        nfkd: "\u{1100}\u{1175}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AE45}",
        nfc: "\u{AE45}",
        nfd: "\u{1100}\u{1175}\u{11BC}",
        nfkc: "\u{AE45}",
        nfkd: "\u{1100}\u{1175}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AE46}",
        nfc: "\u{AE46}",
        nfd: "\u{1100}\u{1175}\u{11BD}",
        nfkc: "\u{AE46}",
        nfkd: "\u{1100}\u{1175}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AE47}",
        nfc: "\u{AE47}",
        nfd: "\u{1100}\u{1175}\u{11BE}",
        nfkc: "\u{AE47}",
        nfkd: "\u{1100}\u{1175}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AE48}",
        nfc: "\u{AE48}",
        nfd: "\u{1100}\u{1175}\u{11BF}",
        nfkc: "\u{AE48}",
        nfkd: "\u{1100}\u{1175}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AE49}",
        nfc: "\u{AE49}",
        nfd: "\u{1100}\u{1175}\u{11C0}",
        nfkc: "\u{AE49}",
        nfkd: "\u{1100}\u{1175}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AE4A}",
        nfc: "\u{AE4A}",
        nfd: "\u{1100}\u{1175}\u{11C1}",
        nfkc: "\u{AE4A}",
        nfkd: "\u{1100}\u{1175}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AE4B}",
        nfc: "\u{AE4B}",
        nfd: "\u{1100}\u{1175}\u{11C2}",
        nfkc: "\u{AE4B}",
        nfkd: "\u{1100}\u{1175}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AE4C}",
        nfc: "\u{AE4C}",
        nfd: "\u{1101}\u{1161}",
        nfkc: "\u{AE4C}",
        nfkd: "\u{1101}\u{1161}",
    },
    NormalizationTest {
        source: "\u{AE4D}",
        nfc: "\u{AE4D}",
        nfd: "\u{1101}\u{1161}\u{11A8}",
        nfkc: "\u{AE4D}",
        nfkd: "\u{1101}\u{1161}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AE4E}",
        nfc: "\u{AE4E}",
        nfd: "\u{1101}\u{1161}\u{11A9}",
        nfkc: "\u{AE4E}",
        nfkd: "\u{1101}\u{1161}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AE4F}",
        nfc: "\u{AE4F}",
        nfd: "\u{1101}\u{1161}\u{11AA}",
        nfkc: "\u{AE4F}",
        nfkd: "\u{1101}\u{1161}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AE50}",
        nfc: "\u{AE50}",
        nfd: "\u{1101}\u{1161}\u{11AB}",
        nfkc: "\u{AE50}",
        nfkd: "\u{1101}\u{1161}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AE51}",
        nfc: "\u{AE51}",
        nfd: "\u{1101}\u{1161}\u{11AC}",
        nfkc: "\u{AE51}",
        nfkd: "\u{1101}\u{1161}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AE52}",
        nfc: "\u{AE52}",
        nfd: "\u{1101}\u{1161}\u{11AD}",
        nfkc: "\u{AE52}",
        nfkd: "\u{1101}\u{1161}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AE53}",
        nfc: "\u{AE53}",
        nfd: "\u{1101}\u{1161}\u{11AE}",
        nfkc: "\u{AE53}",
        nfkd: "\u{1101}\u{1161}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AE54}",
        nfc: "\u{AE54}",
        nfd: "\u{1101}\u{1161}\u{11AF}",
        nfkc: "\u{AE54}",
        nfkd: "\u{1101}\u{1161}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AE55}",
        nfc: "\u{AE55}",
        nfd: "\u{1101}\u{1161}\u{11B0}",
        nfkc: "\u{AE55}",
        nfkd: "\u{1101}\u{1161}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AE56}",
        nfc: "\u{AE56}",
        nfd: "\u{1101}\u{1161}\u{11B1}",
        nfkc: "\u{AE56}",
        nfkd: "\u{1101}\u{1161}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AE57}",
        nfc: "\u{AE57}",
        nfd: "\u{1101}\u{1161}\u{11B2}",
        nfkc: "\u{AE57}",
        nfkd: "\u{1101}\u{1161}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AE58}",
        nfc: "\u{AE58}",
        nfd: "\u{1101}\u{1161}\u{11B3}",
        nfkc: "\u{AE58}",
        nfkd: "\u{1101}\u{1161}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AE59}",
        nfc: "\u{AE59}",
        nfd: "\u{1101}\u{1161}\u{11B4}",
        nfkc: "\u{AE59}",
        nfkd: "\u{1101}\u{1161}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AE5A}",
        nfc: "\u{AE5A}",
        nfd: "\u{1101}\u{1161}\u{11B5}",
        nfkc: "\u{AE5A}",
        nfkd: "\u{1101}\u{1161}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AE5B}",
        nfc: "\u{AE5B}",
        nfd: "\u{1101}\u{1161}\u{11B6}",
        nfkc: "\u{AE5B}",
        nfkd: "\u{1101}\u{1161}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AE5C}",
        nfc: "\u{AE5C}",
        nfd: "\u{1101}\u{1161}\u{11B7}",
        nfkc: "\u{AE5C}",
        nfkd: "\u{1101}\u{1161}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AE5D}",
        nfc: "\u{AE5D}",
        nfd: "\u{1101}\u{1161}\u{11B8}",
        nfkc: "\u{AE5D}",
        nfkd: "\u{1101}\u{1161}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AE5E}",
        nfc: "\u{AE5E}",
        nfd: "\u{1101}\u{1161}\u{11B9}",
        nfkc: "\u{AE5E}",
        nfkd: "\u{1101}\u{1161}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AE5F}",
        nfc: "\u{AE5F}",
        nfd: "\u{1101}\u{1161}\u{11BA}",
        nfkc: "\u{AE5F}",
        nfkd: "\u{1101}\u{1161}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AE60}",
        nfc: "\u{AE60}",
        nfd: "\u{1101}\u{1161}\u{11BB}",
        nfkc: "\u{AE60}",
        nfkd: "\u{1101}\u{1161}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AE61}",
        nfc: "\u{AE61}",
        nfd: "\u{1101}\u{1161}\u{11BC}",
        nfkc: "\u{AE61}",
        nfkd: "\u{1101}\u{1161}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AE62}",
        nfc: "\u{AE62}",
        nfd: "\u{1101}\u{1161}\u{11BD}",
        nfkc: "\u{AE62}",
        nfkd: "\u{1101}\u{1161}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AE63}",
        nfc: "\u{AE63}",
        nfd: "\u{1101}\u{1161}\u{11BE}",
        nfkc: "\u{AE63}",
        nfkd: "\u{1101}\u{1161}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AE64}",
        nfc: "\u{AE64}",
        nfd: "\u{1101}\u{1161}\u{11BF}",
        nfkc: "\u{AE64}",
        nfkd: "\u{1101}\u{1161}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AE65}",
        nfc: "\u{AE65}",
        nfd: "\u{1101}\u{1161}\u{11C0}",
        nfkc: "\u{AE65}",
        nfkd: "\u{1101}\u{1161}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AE66}",
        nfc: "\u{AE66}",
        nfd: "\u{1101}\u{1161}\u{11C1}",
        nfkc: "\u{AE66}",
        nfkd: "\u{1101}\u{1161}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AE67}",
        nfc: "\u{AE67}",
        nfd: "\u{1101}\u{1161}\u{11C2}",
        nfkc: "\u{AE67}",
        nfkd: "\u{1101}\u{1161}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AE68}",
        nfc: "\u{AE68}",
        nfd: "\u{1101}\u{1162}",
        nfkc: "\u{AE68}",
        nfkd: "\u{1101}\u{1162}",
    },
    NormalizationTest {
        source: "\u{AE69}",
        nfc: "\u{AE69}",
        nfd: "\u{1101}\u{1162}\u{11A8}",
        nfkc: "\u{AE69}",
        nfkd: "\u{1101}\u{1162}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AE6A}",
        nfc: "\u{AE6A}",
        nfd: "\u{1101}\u{1162}\u{11A9}",
        nfkc: "\u{AE6A}",
        nfkd: "\u{1101}\u{1162}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AE6B}",
        nfc: "\u{AE6B}",
        nfd: "\u{1101}\u{1162}\u{11AA}",
        nfkc: "\u{AE6B}",
        nfkd: "\u{1101}\u{1162}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AE6C}",
        nfc: "\u{AE6C}",
        nfd: "\u{1101}\u{1162}\u{11AB}",
        nfkc: "\u{AE6C}",
        nfkd: "\u{1101}\u{1162}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AE6D}",
        nfc: "\u{AE6D}",
        nfd: "\u{1101}\u{1162}\u{11AC}",
        nfkc: "\u{AE6D}",
        nfkd: "\u{1101}\u{1162}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AE6E}",
        nfc: "\u{AE6E}",
        nfd: "\u{1101}\u{1162}\u{11AD}",
        nfkc: "\u{AE6E}",
        nfkd: "\u{1101}\u{1162}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AE6F}",
        nfc: "\u{AE6F}",
        nfd: "\u{1101}\u{1162}\u{11AE}",
        nfkc: "\u{AE6F}",
        nfkd: "\u{1101}\u{1162}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AE70}",
        nfc: "\u{AE70}",
        nfd: "\u{1101}\u{1162}\u{11AF}",
        nfkc: "\u{AE70}",
        nfkd: "\u{1101}\u{1162}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AE71}",
        nfc: "\u{AE71}",
        nfd: "\u{1101}\u{1162}\u{11B0}",
        nfkc: "\u{AE71}",
        nfkd: "\u{1101}\u{1162}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AE72}",
        nfc: "\u{AE72}",
        nfd: "\u{1101}\u{1162}\u{11B1}",
        nfkc: "\u{AE72}",
        nfkd: "\u{1101}\u{1162}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AE73}",
        nfc: "\u{AE73}",
        nfd: "\u{1101}\u{1162}\u{11B2}",
        nfkc: "\u{AE73}",
        nfkd: "\u{1101}\u{1162}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AE74}",
        nfc: "\u{AE74}",
        nfd: "\u{1101}\u{1162}\u{11B3}",
        nfkc: "\u{AE74}",
        nfkd: "\u{1101}\u{1162}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AE75}",
        nfc: "\u{AE75}",
        nfd: "\u{1101}\u{1162}\u{11B4}",
        nfkc: "\u{AE75}",
        nfkd: "\u{1101}\u{1162}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AE76}",
        nfc: "\u{AE76}",
        nfd: "\u{1101}\u{1162}\u{11B5}",
        nfkc: "\u{AE76}",
        nfkd: "\u{1101}\u{1162}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AE77}",
        nfc: "\u{AE77}",
        nfd: "\u{1101}\u{1162}\u{11B6}",
        nfkc: "\u{AE77}",
        nfkd: "\u{1101}\u{1162}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AE78}",
        nfc: "\u{AE78}",
        nfd: "\u{1101}\u{1162}\u{11B7}",
        nfkc: "\u{AE78}",
        nfkd: "\u{1101}\u{1162}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AE79}",
        nfc: "\u{AE79}",
        nfd: "\u{1101}\u{1162}\u{11B8}",
        nfkc: "\u{AE79}",
        nfkd: "\u{1101}\u{1162}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AE7A}",
        nfc: "\u{AE7A}",
        nfd: "\u{1101}\u{1162}\u{11B9}",
        nfkc: "\u{AE7A}",
        nfkd: "\u{1101}\u{1162}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AE7B}",
        nfc: "\u{AE7B}",
        nfd: "\u{1101}\u{1162}\u{11BA}",
        nfkc: "\u{AE7B}",
        nfkd: "\u{1101}\u{1162}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AE7C}",
        nfc: "\u{AE7C}",
        nfd: "\u{1101}\u{1162}\u{11BB}",
        nfkc: "\u{AE7C}",
        nfkd: "\u{1101}\u{1162}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AE7D}",
        nfc: "\u{AE7D}",
        nfd: "\u{1101}\u{1162}\u{11BC}",
        nfkc: "\u{AE7D}",
        nfkd: "\u{1101}\u{1162}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AE7E}",
        nfc: "\u{AE7E}",
        nfd: "\u{1101}\u{1162}\u{11BD}",
        nfkc: "\u{AE7E}",
        nfkd: "\u{1101}\u{1162}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AE7F}",
        nfc: "\u{AE7F}",
        nfd: "\u{1101}\u{1162}\u{11BE}",
        nfkc: "\u{AE7F}",
        nfkd: "\u{1101}\u{1162}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AE80}",
        nfc: "\u{AE80}",
        nfd: "\u{1101}\u{1162}\u{11BF}",
        nfkc: "\u{AE80}",
        nfkd: "\u{1101}\u{1162}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AE81}",
        nfc: "\u{AE81}",
        nfd: "\u{1101}\u{1162}\u{11C0}",
        nfkc: "\u{AE81}",
        nfkd: "\u{1101}\u{1162}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AE82}",
        nfc: "\u{AE82}",
        nfd: "\u{1101}\u{1162}\u{11C1}",
        nfkc: "\u{AE82}",
        nfkd: "\u{1101}\u{1162}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AE83}",
        nfc: "\u{AE83}",
        nfd: "\u{1101}\u{1162}\u{11C2}",
        nfkc: "\u{AE83}",
        nfkd: "\u{1101}\u{1162}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AE84}",
        nfc: "\u{AE84}",
        nfd: "\u{1101}\u{1163}",
        nfkc: "\u{AE84}",
        nfkd: "\u{1101}\u{1163}",
    },
    NormalizationTest {
        source: "\u{AE85}",
        nfc: "\u{AE85}",
        nfd: "\u{1101}\u{1163}\u{11A8}",
        nfkc: "\u{AE85}",
        nfkd: "\u{1101}\u{1163}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AE86}",
        nfc: "\u{AE86}",
        nfd: "\u{1101}\u{1163}\u{11A9}",
        nfkc: "\u{AE86}",
        nfkd: "\u{1101}\u{1163}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AE87}",
        nfc: "\u{AE87}",
        nfd: "\u{1101}\u{1163}\u{11AA}",
        nfkc: "\u{AE87}",
        nfkd: "\u{1101}\u{1163}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AE88}",
        nfc: "\u{AE88}",
        nfd: "\u{1101}\u{1163}\u{11AB}",
        nfkc: "\u{AE88}",
        nfkd: "\u{1101}\u{1163}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AE89}",
        nfc: "\u{AE89}",
        nfd: "\u{1101}\u{1163}\u{11AC}",
        nfkc: "\u{AE89}",
        nfkd: "\u{1101}\u{1163}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AE8A}",
        nfc: "\u{AE8A}",
        nfd: "\u{1101}\u{1163}\u{11AD}",
        nfkc: "\u{AE8A}",
        nfkd: "\u{1101}\u{1163}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AE8B}",
        nfc: "\u{AE8B}",
        nfd: "\u{1101}\u{1163}\u{11AE}",
        nfkc: "\u{AE8B}",
        nfkd: "\u{1101}\u{1163}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AE8C}",
        nfc: "\u{AE8C}",
        nfd: "\u{1101}\u{1163}\u{11AF}",
        nfkc: "\u{AE8C}",
        nfkd: "\u{1101}\u{1163}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AE8D}",
        nfc: "\u{AE8D}",
        nfd: "\u{1101}\u{1163}\u{11B0}",
        nfkc: "\u{AE8D}",
        nfkd: "\u{1101}\u{1163}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AE8E}",
        nfc: "\u{AE8E}",
        nfd: "\u{1101}\u{1163}\u{11B1}",
        nfkc: "\u{AE8E}",
        nfkd: "\u{1101}\u{1163}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AE8F}",
        nfc: "\u{AE8F}",
        nfd: "\u{1101}\u{1163}\u{11B2}",
        nfkc: "\u{AE8F}",
        nfkd: "\u{1101}\u{1163}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AE90}",
        nfc: "\u{AE90}",
        nfd: "\u{1101}\u{1163}\u{11B3}",
        nfkc: "\u{AE90}",
        nfkd: "\u{1101}\u{1163}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AE91}",
        nfc: "\u{AE91}",
        nfd: "\u{1101}\u{1163}\u{11B4}",
        nfkc: "\u{AE91}",
        nfkd: "\u{1101}\u{1163}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AE92}",
        nfc: "\u{AE92}",
        nfd: "\u{1101}\u{1163}\u{11B5}",
        nfkc: "\u{AE92}",
        nfkd: "\u{1101}\u{1163}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AE93}",
        nfc: "\u{AE93}",
        nfd: "\u{1101}\u{1163}\u{11B6}",
        nfkc: "\u{AE93}",
        nfkd: "\u{1101}\u{1163}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AE94}",
        nfc: "\u{AE94}",
        nfd: "\u{1101}\u{1163}\u{11B7}",
        nfkc: "\u{AE94}",
        nfkd: "\u{1101}\u{1163}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AE95}",
        nfc: "\u{AE95}",
        nfd: "\u{1101}\u{1163}\u{11B8}",
        nfkc: "\u{AE95}",
        nfkd: "\u{1101}\u{1163}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AE96}",
        nfc: "\u{AE96}",
        nfd: "\u{1101}\u{1163}\u{11B9}",
        nfkc: "\u{AE96}",
        nfkd: "\u{1101}\u{1163}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AE97}",
        nfc: "\u{AE97}",
        nfd: "\u{1101}\u{1163}\u{11BA}",
        nfkc: "\u{AE97}",
        nfkd: "\u{1101}\u{1163}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AE98}",
        nfc: "\u{AE98}",
        nfd: "\u{1101}\u{1163}\u{11BB}",
        nfkc: "\u{AE98}",
        nfkd: "\u{1101}\u{1163}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AE99}",
        nfc: "\u{AE99}",
        nfd: "\u{1101}\u{1163}\u{11BC}",
        nfkc: "\u{AE99}",
        nfkd: "\u{1101}\u{1163}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AE9A}",
        nfc: "\u{AE9A}",
        nfd: "\u{1101}\u{1163}\u{11BD}",
        nfkc: "\u{AE9A}",
        nfkd: "\u{1101}\u{1163}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AE9B}",
        nfc: "\u{AE9B}",
        nfd: "\u{1101}\u{1163}\u{11BE}",
        nfkc: "\u{AE9B}",
        nfkd: "\u{1101}\u{1163}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AE9C}",
        nfc: "\u{AE9C}",
        nfd: "\u{1101}\u{1163}\u{11BF}",
        nfkc: "\u{AE9C}",
        nfkd: "\u{1101}\u{1163}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AE9D}",
        nfc: "\u{AE9D}",
        nfd: "\u{1101}\u{1163}\u{11C0}",
        nfkc: "\u{AE9D}",
        nfkd: "\u{1101}\u{1163}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AE9E}",
        nfc: "\u{AE9E}",
        nfd: "\u{1101}\u{1163}\u{11C1}",
        nfkc: "\u{AE9E}",
        nfkd: "\u{1101}\u{1163}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AE9F}",
        nfc: "\u{AE9F}",
        nfd: "\u{1101}\u{1163}\u{11C2}",
        nfkc: "\u{AE9F}",
        nfkd: "\u{1101}\u{1163}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AEA0}",
        nfc: "\u{AEA0}",
        nfd: "\u{1101}\u{1164}",
        nfkc: "\u{AEA0}",
        nfkd: "\u{1101}\u{1164}",
    },
    NormalizationTest {
        source: "\u{AEA1}",
        nfc: "\u{AEA1}",
        nfd: "\u{1101}\u{1164}\u{11A8}",
        nfkc: "\u{AEA1}",
        nfkd: "\u{1101}\u{1164}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AEA2}",
        nfc: "\u{AEA2}",
        nfd: "\u{1101}\u{1164}\u{11A9}",
        nfkc: "\u{AEA2}",
        nfkd: "\u{1101}\u{1164}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AEA3}",
        nfc: "\u{AEA3}",
        nfd: "\u{1101}\u{1164}\u{11AA}",
        nfkc: "\u{AEA3}",
        nfkd: "\u{1101}\u{1164}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AEA4}",
        nfc: "\u{AEA4}",
        nfd: "\u{1101}\u{1164}\u{11AB}",
        nfkc: "\u{AEA4}",
        nfkd: "\u{1101}\u{1164}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AEA5}",
        nfc: "\u{AEA5}",
        nfd: "\u{1101}\u{1164}\u{11AC}",
        nfkc: "\u{AEA5}",
        nfkd: "\u{1101}\u{1164}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AEA6}",
        nfc: "\u{AEA6}",
        nfd: "\u{1101}\u{1164}\u{11AD}",
        nfkc: "\u{AEA6}",
        nfkd: "\u{1101}\u{1164}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AEA7}",
        nfc: "\u{AEA7}",
        nfd: "\u{1101}\u{1164}\u{11AE}",
        nfkc: "\u{AEA7}",
        nfkd: "\u{1101}\u{1164}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AEA8}",
        nfc: "\u{AEA8}",
        nfd: "\u{1101}\u{1164}\u{11AF}",
        nfkc: "\u{AEA8}",
        nfkd: "\u{1101}\u{1164}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AEA9}",
        nfc: "\u{AEA9}",
        nfd: "\u{1101}\u{1164}\u{11B0}",
        nfkc: "\u{AEA9}",
        nfkd: "\u{1101}\u{1164}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AEAA}",
        nfc: "\u{AEAA}",
        nfd: "\u{1101}\u{1164}\u{11B1}",
        nfkc: "\u{AEAA}",
        nfkd: "\u{1101}\u{1164}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AEAB}",
        nfc: "\u{AEAB}",
        nfd: "\u{1101}\u{1164}\u{11B2}",
        nfkc: "\u{AEAB}",
        nfkd: "\u{1101}\u{1164}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AEAC}",
        nfc: "\u{AEAC}",
        nfd: "\u{1101}\u{1164}\u{11B3}",
        nfkc: "\u{AEAC}",
        nfkd: "\u{1101}\u{1164}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AEAD}",
        nfc: "\u{AEAD}",
        nfd: "\u{1101}\u{1164}\u{11B4}",
        nfkc: "\u{AEAD}",
        nfkd: "\u{1101}\u{1164}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AEAE}",
        nfc: "\u{AEAE}",
        nfd: "\u{1101}\u{1164}\u{11B5}",
        nfkc: "\u{AEAE}",
        nfkd: "\u{1101}\u{1164}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AEAF}",
        nfc: "\u{AEAF}",
        nfd: "\u{1101}\u{1164}\u{11B6}",
        nfkc: "\u{AEAF}",
        nfkd: "\u{1101}\u{1164}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AEB0}",
        nfc: "\u{AEB0}",
        nfd: "\u{1101}\u{1164}\u{11B7}",
        nfkc: "\u{AEB0}",
        nfkd: "\u{1101}\u{1164}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AEB1}",
        nfc: "\u{AEB1}",
        nfd: "\u{1101}\u{1164}\u{11B8}",
        nfkc: "\u{AEB1}",
        nfkd: "\u{1101}\u{1164}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AEB2}",
        nfc: "\u{AEB2}",
        nfd: "\u{1101}\u{1164}\u{11B9}",
        nfkc: "\u{AEB2}",
        nfkd: "\u{1101}\u{1164}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AEB3}",
        nfc: "\u{AEB3}",
        nfd: "\u{1101}\u{1164}\u{11BA}",
        nfkc: "\u{AEB3}",
        nfkd: "\u{1101}\u{1164}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AEB4}",
        nfc: "\u{AEB4}",
        nfd: "\u{1101}\u{1164}\u{11BB}",
        nfkc: "\u{AEB4}",
        nfkd: "\u{1101}\u{1164}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AEB5}",
        nfc: "\u{AEB5}",
        nfd: "\u{1101}\u{1164}\u{11BC}",
        nfkc: "\u{AEB5}",
        nfkd: "\u{1101}\u{1164}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AEB6}",
        nfc: "\u{AEB6}",
        nfd: "\u{1101}\u{1164}\u{11BD}",
        nfkc: "\u{AEB6}",
        nfkd: "\u{1101}\u{1164}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AEB7}",
        nfc: "\u{AEB7}",
        nfd: "\u{1101}\u{1164}\u{11BE}",
        nfkc: "\u{AEB7}",
        nfkd: "\u{1101}\u{1164}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AEB8}",
        nfc: "\u{AEB8}",
        nfd: "\u{1101}\u{1164}\u{11BF}",
        nfkc: "\u{AEB8}",
        nfkd: "\u{1101}\u{1164}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AEB9}",
        nfc: "\u{AEB9}",
        nfd: "\u{1101}\u{1164}\u{11C0}",
        nfkc: "\u{AEB9}",
        nfkd: "\u{1101}\u{1164}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AEBA}",
        nfc: "\u{AEBA}",
        nfd: "\u{1101}\u{1164}\u{11C1}",
        nfkc: "\u{AEBA}",
        nfkd: "\u{1101}\u{1164}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AEBB}",
        nfc: "\u{AEBB}",
        nfd: "\u{1101}\u{1164}\u{11C2}",
        nfkc: "\u{AEBB}",
        nfkd: "\u{1101}\u{1164}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AEBC}",
        nfc: "\u{AEBC}",
        nfd: "\u{1101}\u{1165}",
        nfkc: "\u{AEBC}",
        nfkd: "\u{1101}\u{1165}",
    },
    NormalizationTest {
        source: "\u{AEBD}",
        nfc: "\u{AEBD}",
        nfd: "\u{1101}\u{1165}\u{11A8}",
        nfkc: "\u{AEBD}",
        nfkd: "\u{1101}\u{1165}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AEBE}",
        nfc: "\u{AEBE}",
        nfd: "\u{1101}\u{1165}\u{11A9}",
        nfkc: "\u{AEBE}",
        nfkd: "\u{1101}\u{1165}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AEBF}",
        nfc: "\u{AEBF}",
        nfd: "\u{1101}\u{1165}\u{11AA}",
        nfkc: "\u{AEBF}",
        nfkd: "\u{1101}\u{1165}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AEC0}",
        nfc: "\u{AEC0}",
        nfd: "\u{1101}\u{1165}\u{11AB}",
        nfkc: "\u{AEC0}",
        nfkd: "\u{1101}\u{1165}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AEC1}",
        nfc: "\u{AEC1}",
        nfd: "\u{1101}\u{1165}\u{11AC}",
        nfkc: "\u{AEC1}",
        nfkd: "\u{1101}\u{1165}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AEC2}",
        nfc: "\u{AEC2}",
        nfd: "\u{1101}\u{1165}\u{11AD}",
        nfkc: "\u{AEC2}",
        nfkd: "\u{1101}\u{1165}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AEC3}",
        nfc: "\u{AEC3}",
        nfd: "\u{1101}\u{1165}\u{11AE}",
        nfkc: "\u{AEC3}",
        nfkd: "\u{1101}\u{1165}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AEC4}",
        nfc: "\u{AEC4}",
        nfd: "\u{1101}\u{1165}\u{11AF}",
        nfkc: "\u{AEC4}",
        nfkd: "\u{1101}\u{1165}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AEC5}",
        nfc: "\u{AEC5}",
        nfd: "\u{1101}\u{1165}\u{11B0}",
        nfkc: "\u{AEC5}",
        nfkd: "\u{1101}\u{1165}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AEC6}",
        nfc: "\u{AEC6}",
        nfd: "\u{1101}\u{1165}\u{11B1}",
        nfkc: "\u{AEC6}",
        nfkd: "\u{1101}\u{1165}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AEC7}",
        nfc: "\u{AEC7}",
        nfd: "\u{1101}\u{1165}\u{11B2}",
        nfkc: "\u{AEC7}",
        nfkd: "\u{1101}\u{1165}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AEC8}",
        nfc: "\u{AEC8}",
        nfd: "\u{1101}\u{1165}\u{11B3}",
        nfkc: "\u{AEC8}",
        nfkd: "\u{1101}\u{1165}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AEC9}",
        nfc: "\u{AEC9}",
        nfd: "\u{1101}\u{1165}\u{11B4}",
        nfkc: "\u{AEC9}",
        nfkd: "\u{1101}\u{1165}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AECA}",
        nfc: "\u{AECA}",
        nfd: "\u{1101}\u{1165}\u{11B5}",
        nfkc: "\u{AECA}",
        nfkd: "\u{1101}\u{1165}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AECB}",
        nfc: "\u{AECB}",
        nfd: "\u{1101}\u{1165}\u{11B6}",
        nfkc: "\u{AECB}",
        nfkd: "\u{1101}\u{1165}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AECC}",
        nfc: "\u{AECC}",
        nfd: "\u{1101}\u{1165}\u{11B7}",
        nfkc: "\u{AECC}",
        nfkd: "\u{1101}\u{1165}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AECD}",
        nfc: "\u{AECD}",
        nfd: "\u{1101}\u{1165}\u{11B8}",
        nfkc: "\u{AECD}",
        nfkd: "\u{1101}\u{1165}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AECE}",
        nfc: "\u{AECE}",
        nfd: "\u{1101}\u{1165}\u{11B9}",
        nfkc: "\u{AECE}",
        nfkd: "\u{1101}\u{1165}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AECF}",
        nfc: "\u{AECF}",
        nfd: "\u{1101}\u{1165}\u{11BA}",
        nfkc: "\u{AECF}",
        nfkd: "\u{1101}\u{1165}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AED0}",
        nfc: "\u{AED0}",
        nfd: "\u{1101}\u{1165}\u{11BB}",
        nfkc: "\u{AED0}",
        nfkd: "\u{1101}\u{1165}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AED1}",
        nfc: "\u{AED1}",
        nfd: "\u{1101}\u{1165}\u{11BC}",
        nfkc: "\u{AED1}",
        nfkd: "\u{1101}\u{1165}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AED2}",
        nfc: "\u{AED2}",
        nfd: "\u{1101}\u{1165}\u{11BD}",
        nfkc: "\u{AED2}",
        nfkd: "\u{1101}\u{1165}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AED3}",
        nfc: "\u{AED3}",
        nfd: "\u{1101}\u{1165}\u{11BE}",
        nfkc: "\u{AED3}",
        nfkd: "\u{1101}\u{1165}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AED4}",
        nfc: "\u{AED4}",
        nfd: "\u{1101}\u{1165}\u{11BF}",
        nfkc: "\u{AED4}",
        nfkd: "\u{1101}\u{1165}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AED5}",
        nfc: "\u{AED5}",
        nfd: "\u{1101}\u{1165}\u{11C0}",
        nfkc: "\u{AED5}",
        nfkd: "\u{1101}\u{1165}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AED6}",
        nfc: "\u{AED6}",
        nfd: "\u{1101}\u{1165}\u{11C1}",
        nfkc: "\u{AED6}",
        nfkd: "\u{1101}\u{1165}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AED7}",
        nfc: "\u{AED7}",
        nfd: "\u{1101}\u{1165}\u{11C2}",
        nfkc: "\u{AED7}",
        nfkd: "\u{1101}\u{1165}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AED8}",
        nfc: "\u{AED8}",
        nfd: "\u{1101}\u{1166}",
        nfkc: "\u{AED8}",
        nfkd: "\u{1101}\u{1166}",
    },
    NormalizationTest {
        source: "\u{AED9}",
        nfc: "\u{AED9}",
        nfd: "\u{1101}\u{1166}\u{11A8}",
        nfkc: "\u{AED9}",
        nfkd: "\u{1101}\u{1166}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AEDA}",
        nfc: "\u{AEDA}",
        nfd: "\u{1101}\u{1166}\u{11A9}",
        nfkc: "\u{AEDA}",
        nfkd: "\u{1101}\u{1166}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AEDB}",
        nfc: "\u{AEDB}",
        nfd: "\u{1101}\u{1166}\u{11AA}",
        nfkc: "\u{AEDB}",
        nfkd: "\u{1101}\u{1166}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AEDC}",
        nfc: "\u{AEDC}",
        nfd: "\u{1101}\u{1166}\u{11AB}",
        nfkc: "\u{AEDC}",
        nfkd: "\u{1101}\u{1166}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AEDD}",
        nfc: "\u{AEDD}",
        nfd: "\u{1101}\u{1166}\u{11AC}",
        nfkc: "\u{AEDD}",
        nfkd: "\u{1101}\u{1166}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AEDE}",
        nfc: "\u{AEDE}",
        nfd: "\u{1101}\u{1166}\u{11AD}",
        nfkc: "\u{AEDE}",
        nfkd: "\u{1101}\u{1166}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AEDF}",
        nfc: "\u{AEDF}",
        nfd: "\u{1101}\u{1166}\u{11AE}",
        nfkc: "\u{AEDF}",
        nfkd: "\u{1101}\u{1166}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AEE0}",
        nfc: "\u{AEE0}",
        nfd: "\u{1101}\u{1166}\u{11AF}",
        nfkc: "\u{AEE0}",
        nfkd: "\u{1101}\u{1166}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AEE1}",
        nfc: "\u{AEE1}",
        nfd: "\u{1101}\u{1166}\u{11B0}",
        nfkc: "\u{AEE1}",
        nfkd: "\u{1101}\u{1166}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AEE2}",
        nfc: "\u{AEE2}",
        nfd: "\u{1101}\u{1166}\u{11B1}",
        nfkc: "\u{AEE2}",
        nfkd: "\u{1101}\u{1166}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AEE3}",
        nfc: "\u{AEE3}",
        nfd: "\u{1101}\u{1166}\u{11B2}",
        nfkc: "\u{AEE3}",
        nfkd: "\u{1101}\u{1166}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AEE4}",
        nfc: "\u{AEE4}",
        nfd: "\u{1101}\u{1166}\u{11B3}",
        nfkc: "\u{AEE4}",
        nfkd: "\u{1101}\u{1166}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AEE5}",
        nfc: "\u{AEE5}",
        nfd: "\u{1101}\u{1166}\u{11B4}",
        nfkc: "\u{AEE5}",
        nfkd: "\u{1101}\u{1166}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AEE6}",
        nfc: "\u{AEE6}",
        nfd: "\u{1101}\u{1166}\u{11B5}",
        nfkc: "\u{AEE6}",
        nfkd: "\u{1101}\u{1166}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AEE7}",
        nfc: "\u{AEE7}",
        nfd: "\u{1101}\u{1166}\u{11B6}",
        nfkc: "\u{AEE7}",
        nfkd: "\u{1101}\u{1166}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AEE8}",
        nfc: "\u{AEE8}",
        nfd: "\u{1101}\u{1166}\u{11B7}",
        nfkc: "\u{AEE8}",
        nfkd: "\u{1101}\u{1166}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AEE9}",
        nfc: "\u{AEE9}",
        nfd: "\u{1101}\u{1166}\u{11B8}",
        nfkc: "\u{AEE9}",
        nfkd: "\u{1101}\u{1166}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AEEA}",
        nfc: "\u{AEEA}",
        nfd: "\u{1101}\u{1166}\u{11B9}",
        nfkc: "\u{AEEA}",
        nfkd: "\u{1101}\u{1166}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AEEB}",
        nfc: "\u{AEEB}",
        nfd: "\u{1101}\u{1166}\u{11BA}",
        nfkc: "\u{AEEB}",
        nfkd: "\u{1101}\u{1166}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AEEC}",
        nfc: "\u{AEEC}",
        nfd: "\u{1101}\u{1166}\u{11BB}",
        nfkc: "\u{AEEC}",
        nfkd: "\u{1101}\u{1166}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AEED}",
        nfc: "\u{AEED}",
        nfd: "\u{1101}\u{1166}\u{11BC}",
        nfkc: "\u{AEED}",
        nfkd: "\u{1101}\u{1166}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AEEE}",
        nfc: "\u{AEEE}",
        nfd: "\u{1101}\u{1166}\u{11BD}",
        nfkc: "\u{AEEE}",
        nfkd: "\u{1101}\u{1166}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AEEF}",
        nfc: "\u{AEEF}",
        nfd: "\u{1101}\u{1166}\u{11BE}",
        nfkc: "\u{AEEF}",
        nfkd: "\u{1101}\u{1166}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AEF0}",
        nfc: "\u{AEF0}",
        nfd: "\u{1101}\u{1166}\u{11BF}",
        nfkc: "\u{AEF0}",
        nfkd: "\u{1101}\u{1166}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AEF1}",
        nfc: "\u{AEF1}",
        nfd: "\u{1101}\u{1166}\u{11C0}",
        nfkc: "\u{AEF1}",
        nfkd: "\u{1101}\u{1166}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AEF2}",
        nfc: "\u{AEF2}",
        nfd: "\u{1101}\u{1166}\u{11C1}",
        nfkc: "\u{AEF2}",
        nfkd: "\u{1101}\u{1166}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AEF3}",
        nfc: "\u{AEF3}",
        nfd: "\u{1101}\u{1166}\u{11C2}",
        nfkc: "\u{AEF3}",
        nfkd: "\u{1101}\u{1166}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AEF4}",
        nfc: "\u{AEF4}",
        nfd: "\u{1101}\u{1167}",
        nfkc: "\u{AEF4}",
        nfkd: "\u{1101}\u{1167}",
    },
    NormalizationTest {
        source: "\u{AEF5}",
        nfc: "\u{AEF5}",
        nfd: "\u{1101}\u{1167}\u{11A8}",
        nfkc: "\u{AEF5}",
        nfkd: "\u{1101}\u{1167}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AEF6}",
        nfc: "\u{AEF6}",
        nfd: "\u{1101}\u{1167}\u{11A9}",
        nfkc: "\u{AEF6}",
        nfkd: "\u{1101}\u{1167}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AEF7}",
        nfc: "\u{AEF7}",
        nfd: "\u{1101}\u{1167}\u{11AA}",
        nfkc: "\u{AEF7}",
        nfkd: "\u{1101}\u{1167}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AEF8}",
        nfc: "\u{AEF8}",
        nfd: "\u{1101}\u{1167}\u{11AB}",
        nfkc: "\u{AEF8}",
        nfkd: "\u{1101}\u{1167}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AEF9}",
        nfc: "\u{AEF9}",
        nfd: "\u{1101}\u{1167}\u{11AC}",
        nfkc: "\u{AEF9}",
        nfkd: "\u{1101}\u{1167}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AEFA}",
        nfc: "\u{AEFA}",
        nfd: "\u{1101}\u{1167}\u{11AD}",
        nfkc: "\u{AEFA}",
        nfkd: "\u{1101}\u{1167}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AEFB}",
        nfc: "\u{AEFB}",
        nfd: "\u{1101}\u{1167}\u{11AE}",
        nfkc: "\u{AEFB}",
        nfkd: "\u{1101}\u{1167}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AEFC}",
        nfc: "\u{AEFC}",
        nfd: "\u{1101}\u{1167}\u{11AF}",
        nfkc: "\u{AEFC}",
        nfkd: "\u{1101}\u{1167}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AEFD}",
        nfc: "\u{AEFD}",
        nfd: "\u{1101}\u{1167}\u{11B0}",
        nfkc: "\u{AEFD}",
        nfkd: "\u{1101}\u{1167}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AEFE}",
        nfc: "\u{AEFE}",
        nfd: "\u{1101}\u{1167}\u{11B1}",
        nfkc: "\u{AEFE}",
        nfkd: "\u{1101}\u{1167}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AEFF}",
        nfc: "\u{AEFF}",
        nfd: "\u{1101}\u{1167}\u{11B2}",
        nfkc: "\u{AEFF}",
        nfkd: "\u{1101}\u{1167}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AF00}",
        nfc: "\u{AF00}",
        nfd: "\u{1101}\u{1167}\u{11B3}",
        nfkc: "\u{AF00}",
        nfkd: "\u{1101}\u{1167}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AF01}",
        nfc: "\u{AF01}",
        nfd: "\u{1101}\u{1167}\u{11B4}",
        nfkc: "\u{AF01}",
        nfkd: "\u{1101}\u{1167}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AF02}",
        nfc: "\u{AF02}",
        nfd: "\u{1101}\u{1167}\u{11B5}",
        nfkc: "\u{AF02}",
        nfkd: "\u{1101}\u{1167}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AF03}",
        nfc: "\u{AF03}",
        nfd: "\u{1101}\u{1167}\u{11B6}",
        nfkc: "\u{AF03}",
        nfkd: "\u{1101}\u{1167}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AF04}",
        nfc: "\u{AF04}",
        nfd: "\u{1101}\u{1167}\u{11B7}",
        nfkc: "\u{AF04}",
        nfkd: "\u{1101}\u{1167}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AF05}",
        nfc: "\u{AF05}",
        nfd: "\u{1101}\u{1167}\u{11B8}",
        nfkc: "\u{AF05}",
        nfkd: "\u{1101}\u{1167}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AF06}",
        nfc: "\u{AF06}",
        nfd: "\u{1101}\u{1167}\u{11B9}",
        nfkc: "\u{AF06}",
        nfkd: "\u{1101}\u{1167}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AF07}",
        nfc: "\u{AF07}",
        nfd: "\u{1101}\u{1167}\u{11BA}",
        nfkc: "\u{AF07}",
        nfkd: "\u{1101}\u{1167}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AF08}",
        nfc: "\u{AF08}",
        nfd: "\u{1101}\u{1167}\u{11BB}",
        nfkc: "\u{AF08}",
        nfkd: "\u{1101}\u{1167}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AF09}",
        nfc: "\u{AF09}",
        nfd: "\u{1101}\u{1167}\u{11BC}",
        nfkc: "\u{AF09}",
        nfkd: "\u{1101}\u{1167}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AF0A}",
        nfc: "\u{AF0A}",
        nfd: "\u{1101}\u{1167}\u{11BD}",
        nfkc: "\u{AF0A}",
        nfkd: "\u{1101}\u{1167}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AF0B}",
        nfc: "\u{AF0B}",
        nfd: "\u{1101}\u{1167}\u{11BE}",
        nfkc: "\u{AF0B}",
        nfkd: "\u{1101}\u{1167}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AF0C}",
        nfc: "\u{AF0C}",
        nfd: "\u{1101}\u{1167}\u{11BF}",
        nfkc: "\u{AF0C}",
        nfkd: "\u{1101}\u{1167}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AF0D}",
        nfc: "\u{AF0D}",
        nfd: "\u{1101}\u{1167}\u{11C0}",
        nfkc: "\u{AF0D}",
        nfkd: "\u{1101}\u{1167}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AF0E}",
        nfc: "\u{AF0E}",
        nfd: "\u{1101}\u{1167}\u{11C1}",
        nfkc: "\u{AF0E}",
        nfkd: "\u{1101}\u{1167}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AF0F}",
        nfc: "\u{AF0F}",
        nfd: "\u{1101}\u{1167}\u{11C2}",
        nfkc: "\u{AF0F}",
        nfkd: "\u{1101}\u{1167}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AF10}",
        nfc: "\u{AF10}",
        nfd: "\u{1101}\u{1168}",
        nfkc: "\u{AF10}",
        nfkd: "\u{1101}\u{1168}",
    },
    NormalizationTest {
        source: "\u{AF11}",
        nfc: "\u{AF11}",
        nfd: "\u{1101}\u{1168}\u{11A8}",
        nfkc: "\u{AF11}",
        nfkd: "\u{1101}\u{1168}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AF12}",
        nfc: "\u{AF12}",
        nfd: "\u{1101}\u{1168}\u{11A9}",
        nfkc: "\u{AF12}",
        nfkd: "\u{1101}\u{1168}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AF13}",
        nfc: "\u{AF13}",
        nfd: "\u{1101}\u{1168}\u{11AA}",
        nfkc: "\u{AF13}",
        nfkd: "\u{1101}\u{1168}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AF14}",
        nfc: "\u{AF14}",
        nfd: "\u{1101}\u{1168}\u{11AB}",
        nfkc: "\u{AF14}",
        nfkd: "\u{1101}\u{1168}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AF15}",
        nfc: "\u{AF15}",
        nfd: "\u{1101}\u{1168}\u{11AC}",
        nfkc: "\u{AF15}",
        nfkd: "\u{1101}\u{1168}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AF16}",
        nfc: "\u{AF16}",
        nfd: "\u{1101}\u{1168}\u{11AD}",
        nfkc: "\u{AF16}",
        nfkd: "\u{1101}\u{1168}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AF17}",
        nfc: "\u{AF17}",
        nfd: "\u{1101}\u{1168}\u{11AE}",
        nfkc: "\u{AF17}",
        nfkd: "\u{1101}\u{1168}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AF18}",
        nfc: "\u{AF18}",
        nfd: "\u{1101}\u{1168}\u{11AF}",
        nfkc: "\u{AF18}",
        nfkd: "\u{1101}\u{1168}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AF19}",
        nfc: "\u{AF19}",
        nfd: "\u{1101}\u{1168}\u{11B0}",
        nfkc: "\u{AF19}",
        nfkd: "\u{1101}\u{1168}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AF1A}",
        nfc: "\u{AF1A}",
        nfd: "\u{1101}\u{1168}\u{11B1}",
        nfkc: "\u{AF1A}",
        nfkd: "\u{1101}\u{1168}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AF1B}",
        nfc: "\u{AF1B}",
        nfd: "\u{1101}\u{1168}\u{11B2}",
        nfkc: "\u{AF1B}",
        nfkd: "\u{1101}\u{1168}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AF1C}",
        nfc: "\u{AF1C}",
        nfd: "\u{1101}\u{1168}\u{11B3}",
        nfkc: "\u{AF1C}",
        nfkd: "\u{1101}\u{1168}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AF1D}",
        nfc: "\u{AF1D}",
        nfd: "\u{1101}\u{1168}\u{11B4}",
        nfkc: "\u{AF1D}",
        nfkd: "\u{1101}\u{1168}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AF1E}",
        nfc: "\u{AF1E}",
        nfd: "\u{1101}\u{1168}\u{11B5}",
        nfkc: "\u{AF1E}",
        nfkd: "\u{1101}\u{1168}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AF1F}",
        nfc: "\u{AF1F}",
        nfd: "\u{1101}\u{1168}\u{11B6}",
        nfkc: "\u{AF1F}",
        nfkd: "\u{1101}\u{1168}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AF20}",
        nfc: "\u{AF20}",
        nfd: "\u{1101}\u{1168}\u{11B7}",
        nfkc: "\u{AF20}",
        nfkd: "\u{1101}\u{1168}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AF21}",
        nfc: "\u{AF21}",
        nfd: "\u{1101}\u{1168}\u{11B8}",
        nfkc: "\u{AF21}",
        nfkd: "\u{1101}\u{1168}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AF22}",
        nfc: "\u{AF22}",
        nfd: "\u{1101}\u{1168}\u{11B9}",
        nfkc: "\u{AF22}",
        nfkd: "\u{1101}\u{1168}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AF23}",
        nfc: "\u{AF23}",
        nfd: "\u{1101}\u{1168}\u{11BA}",
        nfkc: "\u{AF23}",
        nfkd: "\u{1101}\u{1168}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AF24}",
        nfc: "\u{AF24}",
        nfd: "\u{1101}\u{1168}\u{11BB}",
        nfkc: "\u{AF24}",
        nfkd: "\u{1101}\u{1168}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AF25}",
        nfc: "\u{AF25}",
        nfd: "\u{1101}\u{1168}\u{11BC}",
        nfkc: "\u{AF25}",
        nfkd: "\u{1101}\u{1168}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AF26}",
        nfc: "\u{AF26}",
        nfd: "\u{1101}\u{1168}\u{11BD}",
        nfkc: "\u{AF26}",
        nfkd: "\u{1101}\u{1168}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AF27}",
        nfc: "\u{AF27}",
        nfd: "\u{1101}\u{1168}\u{11BE}",
        nfkc: "\u{AF27}",
        nfkd: "\u{1101}\u{1168}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AF28}",
        nfc: "\u{AF28}",
        nfd: "\u{1101}\u{1168}\u{11BF}",
        nfkc: "\u{AF28}",
        nfkd: "\u{1101}\u{1168}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AF29}",
        nfc: "\u{AF29}",
        nfd: "\u{1101}\u{1168}\u{11C0}",
        nfkc: "\u{AF29}",
        nfkd: "\u{1101}\u{1168}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AF2A}",
        nfc: "\u{AF2A}",
        nfd: "\u{1101}\u{1168}\u{11C1}",
        nfkc: "\u{AF2A}",
        nfkd: "\u{1101}\u{1168}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AF2B}",
        nfc: "\u{AF2B}",
        nfd: "\u{1101}\u{1168}\u{11C2}",
        nfkc: "\u{AF2B}",
        nfkd: "\u{1101}\u{1168}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AF2C}",
        nfc: "\u{AF2C}",
        nfd: "\u{1101}\u{1169}",
        nfkc: "\u{AF2C}",
        nfkd: "\u{1101}\u{1169}",
    },
    NormalizationTest {
        source: "\u{AF2D}",
        nfc: "\u{AF2D}",
        nfd: "\u{1101}\u{1169}\u{11A8}",
        nfkc: "\u{AF2D}",
        nfkd: "\u{1101}\u{1169}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AF2E}",
        nfc: "\u{AF2E}",
        nfd: "\u{1101}\u{1169}\u{11A9}",
        nfkc: "\u{AF2E}",
        nfkd: "\u{1101}\u{1169}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AF2F}",
        nfc: "\u{AF2F}",
        nfd: "\u{1101}\u{1169}\u{11AA}",
        nfkc: "\u{AF2F}",
        nfkd: "\u{1101}\u{1169}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AF30}",
        nfc: "\u{AF30}",
        nfd: "\u{1101}\u{1169}\u{11AB}",
        nfkc: "\u{AF30}",
        nfkd: "\u{1101}\u{1169}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AF31}",
        nfc: "\u{AF31}",
        nfd: "\u{1101}\u{1169}\u{11AC}",
        nfkc: "\u{AF31}",
        nfkd: "\u{1101}\u{1169}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AF32}",
        nfc: "\u{AF32}",
        nfd: "\u{1101}\u{1169}\u{11AD}",
        nfkc: "\u{AF32}",
        nfkd: "\u{1101}\u{1169}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AF33}",
        nfc: "\u{AF33}",
        nfd: "\u{1101}\u{1169}\u{11AE}",
        nfkc: "\u{AF33}",
        nfkd: "\u{1101}\u{1169}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AF34}",
        nfc: "\u{AF34}",
        nfd: "\u{1101}\u{1169}\u{11AF}",
        nfkc: "\u{AF34}",
        nfkd: "\u{1101}\u{1169}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AF35}",
        nfc: "\u{AF35}",
        nfd: "\u{1101}\u{1169}\u{11B0}",
        nfkc: "\u{AF35}",
        nfkd: "\u{1101}\u{1169}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AF36}",
        nfc: "\u{AF36}",
        nfd: "\u{1101}\u{1169}\u{11B1}",
        nfkc: "\u{AF36}",
        nfkd: "\u{1101}\u{1169}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AF37}",
        nfc: "\u{AF37}",
        nfd: "\u{1101}\u{1169}\u{11B2}",
        nfkc: "\u{AF37}",
        nfkd: "\u{1101}\u{1169}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AF38}",
        nfc: "\u{AF38}",
        nfd: "\u{1101}\u{1169}\u{11B3}",
        nfkc: "\u{AF38}",
        nfkd: "\u{1101}\u{1169}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AF39}",
        nfc: "\u{AF39}",
        nfd: "\u{1101}\u{1169}\u{11B4}",
        nfkc: "\u{AF39}",
        nfkd: "\u{1101}\u{1169}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AF3A}",
        nfc: "\u{AF3A}",
        nfd: "\u{1101}\u{1169}\u{11B5}",
        nfkc: "\u{AF3A}",
        nfkd: "\u{1101}\u{1169}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AF3B}",
        nfc: "\u{AF3B}",
        nfd: "\u{1101}\u{1169}\u{11B6}",
        nfkc: "\u{AF3B}",
        nfkd: "\u{1101}\u{1169}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AF3C}",
        nfc: "\u{AF3C}",
        nfd: "\u{1101}\u{1169}\u{11B7}",
        nfkc: "\u{AF3C}",
        nfkd: "\u{1101}\u{1169}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AF3D}",
        nfc: "\u{AF3D}",
        nfd: "\u{1101}\u{1169}\u{11B8}",
        nfkc: "\u{AF3D}",
        nfkd: "\u{1101}\u{1169}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AF3E}",
        nfc: "\u{AF3E}",
        nfd: "\u{1101}\u{1169}\u{11B9}",
        nfkc: "\u{AF3E}",
        nfkd: "\u{1101}\u{1169}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AF3F}",
        nfc: "\u{AF3F}",
        nfd: "\u{1101}\u{1169}\u{11BA}",
        nfkc: "\u{AF3F}",
        nfkd: "\u{1101}\u{1169}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AF40}",
        nfc: "\u{AF40}",
        nfd: "\u{1101}\u{1169}\u{11BB}",
        nfkc: "\u{AF40}",
        nfkd: "\u{1101}\u{1169}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AF41}",
        nfc: "\u{AF41}",
        nfd: "\u{1101}\u{1169}\u{11BC}",
        nfkc: "\u{AF41}",
        nfkd: "\u{1101}\u{1169}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AF42}",
        nfc: "\u{AF42}",
        nfd: "\u{1101}\u{1169}\u{11BD}",
        nfkc: "\u{AF42}",
        nfkd: "\u{1101}\u{1169}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AF43}",
        nfc: "\u{AF43}",
        nfd: "\u{1101}\u{1169}\u{11BE}",
        nfkc: "\u{AF43}",
        nfkd: "\u{1101}\u{1169}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AF44}",
        nfc: "\u{AF44}",
        nfd: "\u{1101}\u{1169}\u{11BF}",
        nfkc: "\u{AF44}",
        nfkd: "\u{1101}\u{1169}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AF45}",
        nfc: "\u{AF45}",
        nfd: "\u{1101}\u{1169}\u{11C0}",
        nfkc: "\u{AF45}",
        nfkd: "\u{1101}\u{1169}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AF46}",
        nfc: "\u{AF46}",
        nfd: "\u{1101}\u{1169}\u{11C1}",
        nfkc: "\u{AF46}",
        nfkd: "\u{1101}\u{1169}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AF47}",
        nfc: "\u{AF47}",
        nfd: "\u{1101}\u{1169}\u{11C2}",
        nfkc: "\u{AF47}",
        nfkd: "\u{1101}\u{1169}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AF48}",
        nfc: "\u{AF48}",
        nfd: "\u{1101}\u{116A}",
        nfkc: "\u{AF48}",
        nfkd: "\u{1101}\u{116A}",
    },
    NormalizationTest {
        source: "\u{AF49}",
        nfc: "\u{AF49}",
        nfd: "\u{1101}\u{116A}\u{11A8}",
        nfkc: "\u{AF49}",
        nfkd: "\u{1101}\u{116A}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AF4A}",
        nfc: "\u{AF4A}",
        nfd: "\u{1101}\u{116A}\u{11A9}",
        nfkc: "\u{AF4A}",
        nfkd: "\u{1101}\u{116A}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AF4B}",
        nfc: "\u{AF4B}",
        nfd: "\u{1101}\u{116A}\u{11AA}",
        nfkc: "\u{AF4B}",
        nfkd: "\u{1101}\u{116A}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AF4C}",
        nfc: "\u{AF4C}",
        nfd: "\u{1101}\u{116A}\u{11AB}",
        nfkc: "\u{AF4C}",
        nfkd: "\u{1101}\u{116A}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AF4D}",
        nfc: "\u{AF4D}",
        nfd: "\u{1101}\u{116A}\u{11AC}",
        nfkc: "\u{AF4D}",
        nfkd: "\u{1101}\u{116A}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AF4E}",
        nfc: "\u{AF4E}",
        nfd: "\u{1101}\u{116A}\u{11AD}",
        nfkc: "\u{AF4E}",
        nfkd: "\u{1101}\u{116A}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AF4F}",
        nfc: "\u{AF4F}",
        nfd: "\u{1101}\u{116A}\u{11AE}",
        nfkc: "\u{AF4F}",
        nfkd: "\u{1101}\u{116A}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AF50}",
        nfc: "\u{AF50}",
        nfd: "\u{1101}\u{116A}\u{11AF}",
        nfkc: "\u{AF50}",
        nfkd: "\u{1101}\u{116A}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AF51}",
        nfc: "\u{AF51}",
        nfd: "\u{1101}\u{116A}\u{11B0}",
        nfkc: "\u{AF51}",
        nfkd: "\u{1101}\u{116A}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AF52}",
        nfc: "\u{AF52}",
        nfd: "\u{1101}\u{116A}\u{11B1}",
        nfkc: "\u{AF52}",
        nfkd: "\u{1101}\u{116A}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AF53}",
        nfc: "\u{AF53}",
        nfd: "\u{1101}\u{116A}\u{11B2}",
        nfkc: "\u{AF53}",
        nfkd: "\u{1101}\u{116A}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AF54}",
        nfc: "\u{AF54}",
        nfd: "\u{1101}\u{116A}\u{11B3}",
        nfkc: "\u{AF54}",
        nfkd: "\u{1101}\u{116A}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AF55}",
        nfc: "\u{AF55}",
        nfd: "\u{1101}\u{116A}\u{11B4}",
        nfkc: "\u{AF55}",
        nfkd: "\u{1101}\u{116A}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AF56}",
        nfc: "\u{AF56}",
        nfd: "\u{1101}\u{116A}\u{11B5}",
        nfkc: "\u{AF56}",
        nfkd: "\u{1101}\u{116A}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AF57}",
        nfc: "\u{AF57}",
        nfd: "\u{1101}\u{116A}\u{11B6}",
        nfkc: "\u{AF57}",
        nfkd: "\u{1101}\u{116A}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AF58}",
        nfc: "\u{AF58}",
        nfd: "\u{1101}\u{116A}\u{11B7}",
        nfkc: "\u{AF58}",
        nfkd: "\u{1101}\u{116A}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AF59}",
        nfc: "\u{AF59}",
        nfd: "\u{1101}\u{116A}\u{11B8}",
        nfkc: "\u{AF59}",
        nfkd: "\u{1101}\u{116A}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AF5A}",
        nfc: "\u{AF5A}",
        nfd: "\u{1101}\u{116A}\u{11B9}",
        nfkc: "\u{AF5A}",
        nfkd: "\u{1101}\u{116A}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AF5B}",
        nfc: "\u{AF5B}",
        nfd: "\u{1101}\u{116A}\u{11BA}",
        nfkc: "\u{AF5B}",
        nfkd: "\u{1101}\u{116A}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AF5C}",
        nfc: "\u{AF5C}",
        nfd: "\u{1101}\u{116A}\u{11BB}",
        nfkc: "\u{AF5C}",
        nfkd: "\u{1101}\u{116A}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AF5D}",
        nfc: "\u{AF5D}",
        nfd: "\u{1101}\u{116A}\u{11BC}",
        nfkc: "\u{AF5D}",
        nfkd: "\u{1101}\u{116A}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AF5E}",
        nfc: "\u{AF5E}",
        nfd: "\u{1101}\u{116A}\u{11BD}",
        nfkc: "\u{AF5E}",
        nfkd: "\u{1101}\u{116A}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AF5F}",
        nfc: "\u{AF5F}",
        nfd: "\u{1101}\u{116A}\u{11BE}",
        nfkc: "\u{AF5F}",
        nfkd: "\u{1101}\u{116A}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AF60}",
        nfc: "\u{AF60}",
        nfd: "\u{1101}\u{116A}\u{11BF}",
        nfkc: "\u{AF60}",
        nfkd: "\u{1101}\u{116A}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AF61}",
        nfc: "\u{AF61}",
        nfd: "\u{1101}\u{116A}\u{11C0}",
        nfkc: "\u{AF61}",
        nfkd: "\u{1101}\u{116A}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AF62}",
        nfc: "\u{AF62}",
        nfd: "\u{1101}\u{116A}\u{11C1}",
        nfkc: "\u{AF62}",
        nfkd: "\u{1101}\u{116A}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AF63}",
        nfc: "\u{AF63}",
        nfd: "\u{1101}\u{116A}\u{11C2}",
        nfkc: "\u{AF63}",
        nfkd: "\u{1101}\u{116A}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AF64}",
        nfc: "\u{AF64}",
        nfd: "\u{1101}\u{116B}",
        nfkc: "\u{AF64}",
        nfkd: "\u{1101}\u{116B}",
    },
    NormalizationTest {
        source: "\u{AF65}",
        nfc: "\u{AF65}",
        nfd: "\u{1101}\u{116B}\u{11A8}",
        nfkc: "\u{AF65}",
        nfkd: "\u{1101}\u{116B}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AF66}",
        nfc: "\u{AF66}",
        nfd: "\u{1101}\u{116B}\u{11A9}",
        nfkc: "\u{AF66}",
        nfkd: "\u{1101}\u{116B}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AF67}",
        nfc: "\u{AF67}",
        nfd: "\u{1101}\u{116B}\u{11AA}",
        nfkc: "\u{AF67}",
        nfkd: "\u{1101}\u{116B}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AF68}",
        nfc: "\u{AF68}",
        nfd: "\u{1101}\u{116B}\u{11AB}",
        nfkc: "\u{AF68}",
        nfkd: "\u{1101}\u{116B}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AF69}",
        nfc: "\u{AF69}",
        nfd: "\u{1101}\u{116B}\u{11AC}",
        nfkc: "\u{AF69}",
        nfkd: "\u{1101}\u{116B}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AF6A}",
        nfc: "\u{AF6A}",
        nfd: "\u{1101}\u{116B}\u{11AD}",
        nfkc: "\u{AF6A}",
        nfkd: "\u{1101}\u{116B}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AF6B}",
        nfc: "\u{AF6B}",
        nfd: "\u{1101}\u{116B}\u{11AE}",
        nfkc: "\u{AF6B}",
        nfkd: "\u{1101}\u{116B}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AF6C}",
        nfc: "\u{AF6C}",
        nfd: "\u{1101}\u{116B}\u{11AF}",
        nfkc: "\u{AF6C}",
        nfkd: "\u{1101}\u{116B}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AF6D}",
        nfc: "\u{AF6D}",
        nfd: "\u{1101}\u{116B}\u{11B0}",
        nfkc: "\u{AF6D}",
        nfkd: "\u{1101}\u{116B}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AF6E}",
        nfc: "\u{AF6E}",
        nfd: "\u{1101}\u{116B}\u{11B1}",
        nfkc: "\u{AF6E}",
        nfkd: "\u{1101}\u{116B}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AF6F}",
        nfc: "\u{AF6F}",
        nfd: "\u{1101}\u{116B}\u{11B2}",
        nfkc: "\u{AF6F}",
        nfkd: "\u{1101}\u{116B}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AF70}",
        nfc: "\u{AF70}",
        nfd: "\u{1101}\u{116B}\u{11B3}",
        nfkc: "\u{AF70}",
        nfkd: "\u{1101}\u{116B}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AF71}",
        nfc: "\u{AF71}",
        nfd: "\u{1101}\u{116B}\u{11B4}",
        nfkc: "\u{AF71}",
        nfkd: "\u{1101}\u{116B}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AF72}",
        nfc: "\u{AF72}",
        nfd: "\u{1101}\u{116B}\u{11B5}",
        nfkc: "\u{AF72}",
        nfkd: "\u{1101}\u{116B}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AF73}",
        nfc: "\u{AF73}",
        nfd: "\u{1101}\u{116B}\u{11B6}",
        nfkc: "\u{AF73}",
        nfkd: "\u{1101}\u{116B}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AF74}",
        nfc: "\u{AF74}",
        nfd: "\u{1101}\u{116B}\u{11B7}",
        nfkc: "\u{AF74}",
        nfkd: "\u{1101}\u{116B}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AF75}",
        nfc: "\u{AF75}",
        nfd: "\u{1101}\u{116B}\u{11B8}",
        nfkc: "\u{AF75}",
        nfkd: "\u{1101}\u{116B}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AF76}",
        nfc: "\u{AF76}",
        nfd: "\u{1101}\u{116B}\u{11B9}",
        nfkc: "\u{AF76}",
        nfkd: "\u{1101}\u{116B}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AF77}",
        nfc: "\u{AF77}",
        nfd: "\u{1101}\u{116B}\u{11BA}",
        nfkc: "\u{AF77}",
        nfkd: "\u{1101}\u{116B}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AF78}",
        nfc: "\u{AF78}",
        nfd: "\u{1101}\u{116B}\u{11BB}",
        nfkc: "\u{AF78}",
        nfkd: "\u{1101}\u{116B}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AF79}",
        nfc: "\u{AF79}",
        nfd: "\u{1101}\u{116B}\u{11BC}",
        nfkc: "\u{AF79}",
        nfkd: "\u{1101}\u{116B}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AF7A}",
        nfc: "\u{AF7A}",
        nfd: "\u{1101}\u{116B}\u{11BD}",
        nfkc: "\u{AF7A}",
        nfkd: "\u{1101}\u{116B}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AF7B}",
        nfc: "\u{AF7B}",
        nfd: "\u{1101}\u{116B}\u{11BE}",
        nfkc: "\u{AF7B}",
        nfkd: "\u{1101}\u{116B}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AF7C}",
        nfc: "\u{AF7C}",
        nfd: "\u{1101}\u{116B}\u{11BF}",
        nfkc: "\u{AF7C}",
        nfkd: "\u{1101}\u{116B}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AF7D}",
        nfc: "\u{AF7D}",
        nfd: "\u{1101}\u{116B}\u{11C0}",
        nfkc: "\u{AF7D}",
        nfkd: "\u{1101}\u{116B}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AF7E}",
        nfc: "\u{AF7E}",
        nfd: "\u{1101}\u{116B}\u{11C1}",
        nfkc: "\u{AF7E}",
        nfkd: "\u{1101}\u{116B}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AF7F}",
        nfc: "\u{AF7F}",
        nfd: "\u{1101}\u{116B}\u{11C2}",
        nfkc: "\u{AF7F}",
        nfkd: "\u{1101}\u{116B}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AF80}",
        nfc: "\u{AF80}",
        nfd: "\u{1101}\u{116C}",
        nfkc: "\u{AF80}",
        nfkd: "\u{1101}\u{116C}",
    },
    NormalizationTest {
        source: "\u{AF81}",
        nfc: "\u{AF81}",
        nfd: "\u{1101}\u{116C}\u{11A8}",
        nfkc: "\u{AF81}",
        nfkd: "\u{1101}\u{116C}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AF82}",
        nfc: "\u{AF82}",
        nfd: "\u{1101}\u{116C}\u{11A9}",
        nfkc: "\u{AF82}",
        nfkd: "\u{1101}\u{116C}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AF83}",
        nfc: "\u{AF83}",
        nfd: "\u{1101}\u{116C}\u{11AA}",
        nfkc: "\u{AF83}",
        nfkd: "\u{1101}\u{116C}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AF84}",
        nfc: "\u{AF84}",
        nfd: "\u{1101}\u{116C}\u{11AB}",
        nfkc: "\u{AF84}",
        nfkd: "\u{1101}\u{116C}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AF85}",
        nfc: "\u{AF85}",
        nfd: "\u{1101}\u{116C}\u{11AC}",
        nfkc: "\u{AF85}",
        nfkd: "\u{1101}\u{116C}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AF86}",
        nfc: "\u{AF86}",
        nfd: "\u{1101}\u{116C}\u{11AD}",
        nfkc: "\u{AF86}",
        nfkd: "\u{1101}\u{116C}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AF87}",
        nfc: "\u{AF87}",
        nfd: "\u{1101}\u{116C}\u{11AE}",
        nfkc: "\u{AF87}",
        nfkd: "\u{1101}\u{116C}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AF88}",
        nfc: "\u{AF88}",
        nfd: "\u{1101}\u{116C}\u{11AF}",
        nfkc: "\u{AF88}",
        nfkd: "\u{1101}\u{116C}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AF89}",
        nfc: "\u{AF89}",
        nfd: "\u{1101}\u{116C}\u{11B0}",
        nfkc: "\u{AF89}",
        nfkd: "\u{1101}\u{116C}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AF8A}",
        nfc: "\u{AF8A}",
        nfd: "\u{1101}\u{116C}\u{11B1}",
        nfkc: "\u{AF8A}",
        nfkd: "\u{1101}\u{116C}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AF8B}",
        nfc: "\u{AF8B}",
        nfd: "\u{1101}\u{116C}\u{11B2}",
        nfkc: "\u{AF8B}",
        nfkd: "\u{1101}\u{116C}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AF8C}",
        nfc: "\u{AF8C}",
        nfd: "\u{1101}\u{116C}\u{11B3}",
        nfkc: "\u{AF8C}",
        nfkd: "\u{1101}\u{116C}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AF8D}",
        nfc: "\u{AF8D}",
        nfd: "\u{1101}\u{116C}\u{11B4}",
        nfkc: "\u{AF8D}",
        nfkd: "\u{1101}\u{116C}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AF8E}",
        nfc: "\u{AF8E}",
        nfd: "\u{1101}\u{116C}\u{11B5}",
        nfkc: "\u{AF8E}",
        nfkd: "\u{1101}\u{116C}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AF8F}",
        nfc: "\u{AF8F}",
        nfd: "\u{1101}\u{116C}\u{11B6}",
        nfkc: "\u{AF8F}",
        nfkd: "\u{1101}\u{116C}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AF90}",
        nfc: "\u{AF90}",
        nfd: "\u{1101}\u{116C}\u{11B7}",
        nfkc: "\u{AF90}",
        nfkd: "\u{1101}\u{116C}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AF91}",
        nfc: "\u{AF91}",
        nfd: "\u{1101}\u{116C}\u{11B8}",
        nfkc: "\u{AF91}",
        nfkd: "\u{1101}\u{116C}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AF92}",
        nfc: "\u{AF92}",
        nfd: "\u{1101}\u{116C}\u{11B9}",
        nfkc: "\u{AF92}",
        nfkd: "\u{1101}\u{116C}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AF93}",
        nfc: "\u{AF93}",
        nfd: "\u{1101}\u{116C}\u{11BA}",
        nfkc: "\u{AF93}",
        nfkd: "\u{1101}\u{116C}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AF94}",
        nfc: "\u{AF94}",
        nfd: "\u{1101}\u{116C}\u{11BB}",
        nfkc: "\u{AF94}",
        nfkd: "\u{1101}\u{116C}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AF95}",
        nfc: "\u{AF95}",
        nfd: "\u{1101}\u{116C}\u{11BC}",
        nfkc: "\u{AF95}",
        nfkd: "\u{1101}\u{116C}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AF96}",
        nfc: "\u{AF96}",
        nfd: "\u{1101}\u{116C}\u{11BD}",
        nfkc: "\u{AF96}",
        nfkd: "\u{1101}\u{116C}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AF97}",
        nfc: "\u{AF97}",
        nfd: "\u{1101}\u{116C}\u{11BE}",
        nfkc: "\u{AF97}",
        nfkd: "\u{1101}\u{116C}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AF98}",
        nfc: "\u{AF98}",
        nfd: "\u{1101}\u{116C}\u{11BF}",
        nfkc: "\u{AF98}",
        nfkd: "\u{1101}\u{116C}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AF99}",
        nfc: "\u{AF99}",
        nfd: "\u{1101}\u{116C}\u{11C0}",
        nfkc: "\u{AF99}",
        nfkd: "\u{1101}\u{116C}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AF9A}",
        nfc: "\u{AF9A}",
        nfd: "\u{1101}\u{116C}\u{11C1}",
        nfkc: "\u{AF9A}",
        nfkd: "\u{1101}\u{116C}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AF9B}",
        nfc: "\u{AF9B}",
        nfd: "\u{1101}\u{116C}\u{11C2}",
        nfkc: "\u{AF9B}",
        nfkd: "\u{1101}\u{116C}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AF9C}",
        nfc: "\u{AF9C}",
        nfd: "\u{1101}\u{116D}",
        nfkc: "\u{AF9C}",
        nfkd: "\u{1101}\u{116D}",
    },
    NormalizationTest {
        source: "\u{AF9D}",
        nfc: "\u{AF9D}",
        nfd: "\u{1101}\u{116D}\u{11A8}",
        nfkc: "\u{AF9D}",
        nfkd: "\u{1101}\u{116D}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AF9E}",
        nfc: "\u{AF9E}",
        nfd: "\u{1101}\u{116D}\u{11A9}",
        nfkc: "\u{AF9E}",
        nfkd: "\u{1101}\u{116D}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AF9F}",
        nfc: "\u{AF9F}",
        nfd: "\u{1101}\u{116D}\u{11AA}",
        nfkc: "\u{AF9F}",
        nfkd: "\u{1101}\u{116D}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AFA0}",
        nfc: "\u{AFA0}",
        nfd: "\u{1101}\u{116D}\u{11AB}",
        nfkc: "\u{AFA0}",
        nfkd: "\u{1101}\u{116D}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AFA1}",
        nfc: "\u{AFA1}",
        nfd: "\u{1101}\u{116D}\u{11AC}",
        nfkc: "\u{AFA1}",
        nfkd: "\u{1101}\u{116D}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AFA2}",
        nfc: "\u{AFA2}",
        nfd: "\u{1101}\u{116D}\u{11AD}",
        nfkc: "\u{AFA2}",
        nfkd: "\u{1101}\u{116D}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AFA3}",
        nfc: "\u{AFA3}",
        nfd: "\u{1101}\u{116D}\u{11AE}",
        nfkc: "\u{AFA3}",
        nfkd: "\u{1101}\u{116D}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AFA4}",
        nfc: "\u{AFA4}",
        nfd: "\u{1101}\u{116D}\u{11AF}",
        nfkc: "\u{AFA4}",
        nfkd: "\u{1101}\u{116D}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AFA5}",
        nfc: "\u{AFA5}",
        nfd: "\u{1101}\u{116D}\u{11B0}",
        nfkc: "\u{AFA5}",
        nfkd: "\u{1101}\u{116D}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AFA6}",
        nfc: "\u{AFA6}",
        nfd: "\u{1101}\u{116D}\u{11B1}",
        nfkc: "\u{AFA6}",
        nfkd: "\u{1101}\u{116D}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AFA7}",
        nfc: "\u{AFA7}",
        nfd: "\u{1101}\u{116D}\u{11B2}",
        nfkc: "\u{AFA7}",
        nfkd: "\u{1101}\u{116D}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AFA8}",
        nfc: "\u{AFA8}",
        nfd: "\u{1101}\u{116D}\u{11B3}",
        nfkc: "\u{AFA8}",
        nfkd: "\u{1101}\u{116D}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AFA9}",
        nfc: "\u{AFA9}",
        nfd: "\u{1101}\u{116D}\u{11B4}",
        nfkc: "\u{AFA9}",
        nfkd: "\u{1101}\u{116D}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AFAA}",
        nfc: "\u{AFAA}",
        nfd: "\u{1101}\u{116D}\u{11B5}",
        nfkc: "\u{AFAA}",
        nfkd: "\u{1101}\u{116D}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AFAB}",
        nfc: "\u{AFAB}",
        nfd: "\u{1101}\u{116D}\u{11B6}",
        nfkc: "\u{AFAB}",
        nfkd: "\u{1101}\u{116D}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AFAC}",
        nfc: "\u{AFAC}",
        nfd: "\u{1101}\u{116D}\u{11B7}",
        nfkc: "\u{AFAC}",
        nfkd: "\u{1101}\u{116D}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AFAD}",
        nfc: "\u{AFAD}",
        nfd: "\u{1101}\u{116D}\u{11B8}",
        nfkc: "\u{AFAD}",
        nfkd: "\u{1101}\u{116D}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AFAE}",
        nfc: "\u{AFAE}",
        nfd: "\u{1101}\u{116D}\u{11B9}",
        nfkc: "\u{AFAE}",
        nfkd: "\u{1101}\u{116D}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AFAF}",
        nfc: "\u{AFAF}",
        nfd: "\u{1101}\u{116D}\u{11BA}",
        nfkc: "\u{AFAF}",
        nfkd: "\u{1101}\u{116D}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AFB0}",
        nfc: "\u{AFB0}",
        nfd: "\u{1101}\u{116D}\u{11BB}",
        nfkc: "\u{AFB0}",
        nfkd: "\u{1101}\u{116D}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AFB1}",
        nfc: "\u{AFB1}",
        nfd: "\u{1101}\u{116D}\u{11BC}",
        nfkc: "\u{AFB1}",
        nfkd: "\u{1101}\u{116D}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AFB2}",
        nfc: "\u{AFB2}",
        nfd: "\u{1101}\u{116D}\u{11BD}",
        nfkc: "\u{AFB2}",
        nfkd: "\u{1101}\u{116D}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AFB3}",
        nfc: "\u{AFB3}",
        nfd: "\u{1101}\u{116D}\u{11BE}",
        nfkc: "\u{AFB3}",
        nfkd: "\u{1101}\u{116D}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AFB4}",
        nfc: "\u{AFB4}",
        nfd: "\u{1101}\u{116D}\u{11BF}",
        nfkc: "\u{AFB4}",
        nfkd: "\u{1101}\u{116D}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AFB5}",
        nfc: "\u{AFB5}",
        nfd: "\u{1101}\u{116D}\u{11C0}",
        nfkc: "\u{AFB5}",
        nfkd: "\u{1101}\u{116D}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AFB6}",
        nfc: "\u{AFB6}",
        nfd: "\u{1101}\u{116D}\u{11C1}",
        nfkc: "\u{AFB6}",
        nfkd: "\u{1101}\u{116D}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AFB7}",
        nfc: "\u{AFB7}",
        nfd: "\u{1101}\u{116D}\u{11C2}",
        nfkc: "\u{AFB7}",
        nfkd: "\u{1101}\u{116D}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AFB8}",
        nfc: "\u{AFB8}",
        nfd: "\u{1101}\u{116E}",
        nfkc: "\u{AFB8}",
        nfkd: "\u{1101}\u{116E}",
    },
    NormalizationTest {
        source: "\u{AFB9}",
        nfc: "\u{AFB9}",
        nfd: "\u{1101}\u{116E}\u{11A8}",
        nfkc: "\u{AFB9}",
        nfkd: "\u{1101}\u{116E}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AFBA}",
        nfc: "\u{AFBA}",
        nfd: "\u{1101}\u{116E}\u{11A9}",
        nfkc: "\u{AFBA}",
        nfkd: "\u{1101}\u{116E}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AFBB}",
        nfc: "\u{AFBB}",
        nfd: "\u{1101}\u{116E}\u{11AA}",
        nfkc: "\u{AFBB}",
        nfkd: "\u{1101}\u{116E}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AFBC}",
        nfc: "\u{AFBC}",
        nfd: "\u{1101}\u{116E}\u{11AB}",
        nfkc: "\u{AFBC}",
        nfkd: "\u{1101}\u{116E}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AFBD}",
        nfc: "\u{AFBD}",
        nfd: "\u{1101}\u{116E}\u{11AC}",
        nfkc: "\u{AFBD}",
        nfkd: "\u{1101}\u{116E}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AFBE}",
        nfc: "\u{AFBE}",
        nfd: "\u{1101}\u{116E}\u{11AD}",
        nfkc: "\u{AFBE}",
        nfkd: "\u{1101}\u{116E}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AFBF}",
        nfc: "\u{AFBF}",
        nfd: "\u{1101}\u{116E}\u{11AE}",
        nfkc: "\u{AFBF}",
        nfkd: "\u{1101}\u{116E}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AFC0}",
        nfc: "\u{AFC0}",
        nfd: "\u{1101}\u{116E}\u{11AF}",
        nfkc: "\u{AFC0}",
        nfkd: "\u{1101}\u{116E}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AFC1}",
        nfc: "\u{AFC1}",
        nfd: "\u{1101}\u{116E}\u{11B0}",
        nfkc: "\u{AFC1}",
        nfkd: "\u{1101}\u{116E}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AFC2}",
        nfc: "\u{AFC2}",
        nfd: "\u{1101}\u{116E}\u{11B1}",
        nfkc: "\u{AFC2}",
        nfkd: "\u{1101}\u{116E}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AFC3}",
        nfc: "\u{AFC3}",
        nfd: "\u{1101}\u{116E}\u{11B2}",
        nfkc: "\u{AFC3}",
        nfkd: "\u{1101}\u{116E}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AFC4}",
        nfc: "\u{AFC4}",
        nfd: "\u{1101}\u{116E}\u{11B3}",
        nfkc: "\u{AFC4}",
        nfkd: "\u{1101}\u{116E}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AFC5}",
        nfc: "\u{AFC5}",
        nfd: "\u{1101}\u{116E}\u{11B4}",
        nfkc: "\u{AFC5}",
        nfkd: "\u{1101}\u{116E}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AFC6}",
        nfc: "\u{AFC6}",
        nfd: "\u{1101}\u{116E}\u{11B5}",
        nfkc: "\u{AFC6}",
        nfkd: "\u{1101}\u{116E}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AFC7}",
        nfc: "\u{AFC7}",
        nfd: "\u{1101}\u{116E}\u{11B6}",
        nfkc: "\u{AFC7}",
        nfkd: "\u{1101}\u{116E}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AFC8}",
        nfc: "\u{AFC8}",
        nfd: "\u{1101}\u{116E}\u{11B7}",
        nfkc: "\u{AFC8}",
        nfkd: "\u{1101}\u{116E}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AFC9}",
        nfc: "\u{AFC9}",
        nfd: "\u{1101}\u{116E}\u{11B8}",
        nfkc: "\u{AFC9}",
        nfkd: "\u{1101}\u{116E}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AFCA}",
        nfc: "\u{AFCA}",
        nfd: "\u{1101}\u{116E}\u{11B9}",
        nfkc: "\u{AFCA}",
        nfkd: "\u{1101}\u{116E}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AFCB}",
        nfc: "\u{AFCB}",
        nfd: "\u{1101}\u{116E}\u{11BA}",
        nfkc: "\u{AFCB}",
        nfkd: "\u{1101}\u{116E}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AFCC}",
        nfc: "\u{AFCC}",
        nfd: "\u{1101}\u{116E}\u{11BB}",
        nfkc: "\u{AFCC}",
        nfkd: "\u{1101}\u{116E}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AFCD}",
        nfc: "\u{AFCD}",
        nfd: "\u{1101}\u{116E}\u{11BC}",
        nfkc: "\u{AFCD}",
        nfkd: "\u{1101}\u{116E}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AFCE}",
        nfc: "\u{AFCE}",
        nfd: "\u{1101}\u{116E}\u{11BD}",
        nfkc: "\u{AFCE}",
        nfkd: "\u{1101}\u{116E}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AFCF}",
        nfc: "\u{AFCF}",
        nfd: "\u{1101}\u{116E}\u{11BE}",
        nfkc: "\u{AFCF}",
        nfkd: "\u{1101}\u{116E}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AFD0}",
        nfc: "\u{AFD0}",
        nfd: "\u{1101}\u{116E}\u{11BF}",
        nfkc: "\u{AFD0}",
        nfkd: "\u{1101}\u{116E}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AFD1}",
        nfc: "\u{AFD1}",
        nfd: "\u{1101}\u{116E}\u{11C0}",
        nfkc: "\u{AFD1}",
        nfkd: "\u{1101}\u{116E}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AFD2}",
        nfc: "\u{AFD2}",
        nfd: "\u{1101}\u{116E}\u{11C1}",
        nfkc: "\u{AFD2}",
        nfkd: "\u{1101}\u{116E}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AFD3}",
        nfc: "\u{AFD3}",
        nfd: "\u{1101}\u{116E}\u{11C2}",
        nfkc: "\u{AFD3}",
        nfkd: "\u{1101}\u{116E}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AFD4}",
        nfc: "\u{AFD4}",
        nfd: "\u{1101}\u{116F}",
        nfkc: "\u{AFD4}",
        nfkd: "\u{1101}\u{116F}",
    },
    NormalizationTest {
        source: "\u{AFD5}",
        nfc: "\u{AFD5}",
        nfd: "\u{1101}\u{116F}\u{11A8}",
        nfkc: "\u{AFD5}",
        nfkd: "\u{1101}\u{116F}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AFD6}",
        nfc: "\u{AFD6}",
        nfd: "\u{1101}\u{116F}\u{11A9}",
        nfkc: "\u{AFD6}",
        nfkd: "\u{1101}\u{116F}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AFD7}",
        nfc: "\u{AFD7}",
        nfd: "\u{1101}\u{116F}\u{11AA}",
        nfkc: "\u{AFD7}",
        nfkd: "\u{1101}\u{116F}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AFD8}",
        nfc: "\u{AFD8}",
        nfd: "\u{1101}\u{116F}\u{11AB}",
        nfkc: "\u{AFD8}",
        nfkd: "\u{1101}\u{116F}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AFD9}",
        nfc: "\u{AFD9}",
        nfd: "\u{1101}\u{116F}\u{11AC}",
        nfkc: "\u{AFD9}",
        nfkd: "\u{1101}\u{116F}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AFDA}",
        nfc: "\u{AFDA}",
        nfd: "\u{1101}\u{116F}\u{11AD}",
        nfkc: "\u{AFDA}",
        nfkd: "\u{1101}\u{116F}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AFDB}",
        nfc: "\u{AFDB}",
        nfd: "\u{1101}\u{116F}\u{11AE}",
        nfkc: "\u{AFDB}",
        nfkd: "\u{1101}\u{116F}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AFDC}",
        nfc: "\u{AFDC}",
        nfd: "\u{1101}\u{116F}\u{11AF}",
        nfkc: "\u{AFDC}",
        nfkd: "\u{1101}\u{116F}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AFDD}",
        nfc: "\u{AFDD}",
        nfd: "\u{1101}\u{116F}\u{11B0}",
        nfkc: "\u{AFDD}",
        nfkd: "\u{1101}\u{116F}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AFDE}",
        nfc: "\u{AFDE}",
        nfd: "\u{1101}\u{116F}\u{11B1}",
        nfkc: "\u{AFDE}",
        nfkd: "\u{1101}\u{116F}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AFDF}",
        nfc: "\u{AFDF}",
        nfd: "\u{1101}\u{116F}\u{11B2}",
        nfkc: "\u{AFDF}",
        nfkd: "\u{1101}\u{116F}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AFE0}",
        nfc: "\u{AFE0}",
        nfd: "\u{1101}\u{116F}\u{11B3}",
        nfkc: "\u{AFE0}",
        nfkd: "\u{1101}\u{116F}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AFE1}",
        nfc: "\u{AFE1}",
        nfd: "\u{1101}\u{116F}\u{11B4}",
        nfkc: "\u{AFE1}",
        nfkd: "\u{1101}\u{116F}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AFE2}",
        nfc: "\u{AFE2}",
        nfd: "\u{1101}\u{116F}\u{11B5}",
        nfkc: "\u{AFE2}",
        nfkd: "\u{1101}\u{116F}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AFE3}",
        nfc: "\u{AFE3}",
        nfd: "\u{1101}\u{116F}\u{11B6}",
        nfkc: "\u{AFE3}",
        nfkd: "\u{1101}\u{116F}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{AFE4}",
        nfc: "\u{AFE4}",
        nfd: "\u{1101}\u{116F}\u{11B7}",
        nfkc: "\u{AFE4}",
        nfkd: "\u{1101}\u{116F}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{AFE5}",
        nfc: "\u{AFE5}",
        nfd: "\u{1101}\u{116F}\u{11B8}",
        nfkc: "\u{AFE5}",
        nfkd: "\u{1101}\u{116F}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{AFE6}",
        nfc: "\u{AFE6}",
        nfd: "\u{1101}\u{116F}\u{11B9}",
        nfkc: "\u{AFE6}",
        nfkd: "\u{1101}\u{116F}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{AFE7}",
        nfc: "\u{AFE7}",
        nfd: "\u{1101}\u{116F}\u{11BA}",
        nfkc: "\u{AFE7}",
        nfkd: "\u{1101}\u{116F}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{AFE8}",
        nfc: "\u{AFE8}",
        nfd: "\u{1101}\u{116F}\u{11BB}",
        nfkc: "\u{AFE8}",
        nfkd: "\u{1101}\u{116F}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{AFE9}",
        nfc: "\u{AFE9}",
        nfd: "\u{1101}\u{116F}\u{11BC}",
        nfkc: "\u{AFE9}",
        nfkd: "\u{1101}\u{116F}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{AFEA}",
        nfc: "\u{AFEA}",
        nfd: "\u{1101}\u{116F}\u{11BD}",
        nfkc: "\u{AFEA}",
        nfkd: "\u{1101}\u{116F}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{AFEB}",
        nfc: "\u{AFEB}",
        nfd: "\u{1101}\u{116F}\u{11BE}",
        nfkc: "\u{AFEB}",
        nfkd: "\u{1101}\u{116F}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{AFEC}",
        nfc: "\u{AFEC}",
        nfd: "\u{1101}\u{116F}\u{11BF}",
        nfkc: "\u{AFEC}",
        nfkd: "\u{1101}\u{116F}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{AFED}",
        nfc: "\u{AFED}",
        nfd: "\u{1101}\u{116F}\u{11C0}",
        nfkc: "\u{AFED}",
        nfkd: "\u{1101}\u{116F}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{AFEE}",
        nfc: "\u{AFEE}",
        nfd: "\u{1101}\u{116F}\u{11C1}",
        nfkc: "\u{AFEE}",
        nfkd: "\u{1101}\u{116F}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{AFEF}",
        nfc: "\u{AFEF}",
        nfd: "\u{1101}\u{116F}\u{11C2}",
        nfkc: "\u{AFEF}",
        nfkd: "\u{1101}\u{116F}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{AFF0}",
        nfc: "\u{AFF0}",
        nfd: "\u{1101}\u{1170}",
        nfkc: "\u{AFF0}",
        nfkd: "\u{1101}\u{1170}",
    },
    NormalizationTest {
        source: "\u{AFF1}",
        nfc: "\u{AFF1}",
        nfd: "\u{1101}\u{1170}\u{11A8}",
        nfkc: "\u{AFF1}",
        nfkd: "\u{1101}\u{1170}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{AFF2}",
        nfc: "\u{AFF2}",
        nfd: "\u{1101}\u{1170}\u{11A9}",
        nfkc: "\u{AFF2}",
        nfkd: "\u{1101}\u{1170}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{AFF3}",
        nfc: "\u{AFF3}",
        nfd: "\u{1101}\u{1170}\u{11AA}",
        nfkc: "\u{AFF3}",
        nfkd: "\u{1101}\u{1170}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{AFF4}",
        nfc: "\u{AFF4}",
        nfd: "\u{1101}\u{1170}\u{11AB}",
        nfkc: "\u{AFF4}",
        nfkd: "\u{1101}\u{1170}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{AFF5}",
        nfc: "\u{AFF5}",
        nfd: "\u{1101}\u{1170}\u{11AC}",
        nfkc: "\u{AFF5}",
        nfkd: "\u{1101}\u{1170}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{AFF6}",
        nfc: "\u{AFF6}",
        nfd: "\u{1101}\u{1170}\u{11AD}",
        nfkc: "\u{AFF6}",
        nfkd: "\u{1101}\u{1170}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{AFF7}",
        nfc: "\u{AFF7}",
        nfd: "\u{1101}\u{1170}\u{11AE}",
        nfkc: "\u{AFF7}",
        nfkd: "\u{1101}\u{1170}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{AFF8}",
        nfc: "\u{AFF8}",
        nfd: "\u{1101}\u{1170}\u{11AF}",
        nfkc: "\u{AFF8}",
        nfkd: "\u{1101}\u{1170}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{AFF9}",
        nfc: "\u{AFF9}",
        nfd: "\u{1101}\u{1170}\u{11B0}",
        nfkc: "\u{AFF9}",
        nfkd: "\u{1101}\u{1170}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{AFFA}",
        nfc: "\u{AFFA}",
        nfd: "\u{1101}\u{1170}\u{11B1}",
        nfkc: "\u{AFFA}",
        nfkd: "\u{1101}\u{1170}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{AFFB}",
        nfc: "\u{AFFB}",
        nfd: "\u{1101}\u{1170}\u{11B2}",
        nfkc: "\u{AFFB}",
        nfkd: "\u{1101}\u{1170}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{AFFC}",
        nfc: "\u{AFFC}",
        nfd: "\u{1101}\u{1170}\u{11B3}",
        nfkc: "\u{AFFC}",
        nfkd: "\u{1101}\u{1170}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{AFFD}",
        nfc: "\u{AFFD}",
        nfd: "\u{1101}\u{1170}\u{11B4}",
        nfkc: "\u{AFFD}",
        nfkd: "\u{1101}\u{1170}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{AFFE}",
        nfc: "\u{AFFE}",
        nfd: "\u{1101}\u{1170}\u{11B5}",
        nfkc: "\u{AFFE}",
        nfkd: "\u{1101}\u{1170}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{AFFF}",
        nfc: "\u{AFFF}",
        nfd: "\u{1101}\u{1170}\u{11B6}",
        nfkc: "\u{AFFF}",
        nfkd: "\u{1101}\u{1170}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B000}",
        nfc: "\u{B000}",
        nfd: "\u{1101}\u{1170}\u{11B7}",
        nfkc: "\u{B000}",
        nfkd: "\u{1101}\u{1170}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B001}",
        nfc: "\u{B001}",
        nfd: "\u{1101}\u{1170}\u{11B8}",
        nfkc: "\u{B001}",
        nfkd: "\u{1101}\u{1170}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B002}",
        nfc: "\u{B002}",
        nfd: "\u{1101}\u{1170}\u{11B9}",
        nfkc: "\u{B002}",
        nfkd: "\u{1101}\u{1170}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B003}",
        nfc: "\u{B003}",
        nfd: "\u{1101}\u{1170}\u{11BA}",
        nfkc: "\u{B003}",
        nfkd: "\u{1101}\u{1170}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B004}",
        nfc: "\u{B004}",
        nfd: "\u{1101}\u{1170}\u{11BB}",
        nfkc: "\u{B004}",
        nfkd: "\u{1101}\u{1170}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B005}",
        nfc: "\u{B005}",
        nfd: "\u{1101}\u{1170}\u{11BC}",
        nfkc: "\u{B005}",
        nfkd: "\u{1101}\u{1170}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B006}",
        nfc: "\u{B006}",
        nfd: "\u{1101}\u{1170}\u{11BD}",
        nfkc: "\u{B006}",
        nfkd: "\u{1101}\u{1170}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B007}",
        nfc: "\u{B007}",
        nfd: "\u{1101}\u{1170}\u{11BE}",
        nfkc: "\u{B007}",
        nfkd: "\u{1101}\u{1170}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B008}",
        nfc: "\u{B008}",
        nfd: "\u{1101}\u{1170}\u{11BF}",
        nfkc: "\u{B008}",
        nfkd: "\u{1101}\u{1170}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B009}",
        nfc: "\u{B009}",
        nfd: "\u{1101}\u{1170}\u{11C0}",
        nfkc: "\u{B009}",
        nfkd: "\u{1101}\u{1170}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B00A}",
        nfc: "\u{B00A}",
        nfd: "\u{1101}\u{1170}\u{11C1}",
        nfkc: "\u{B00A}",
        nfkd: "\u{1101}\u{1170}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B00B}",
        nfc: "\u{B00B}",
        nfd: "\u{1101}\u{1170}\u{11C2}",
        nfkc: "\u{B00B}",
        nfkd: "\u{1101}\u{1170}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B00C}",
        nfc: "\u{B00C}",
        nfd: "\u{1101}\u{1171}",
        nfkc: "\u{B00C}",
        nfkd: "\u{1101}\u{1171}",
    },
    NormalizationTest {
        source: "\u{B00D}",
        nfc: "\u{B00D}",
        nfd: "\u{1101}\u{1171}\u{11A8}",
        nfkc: "\u{B00D}",
        nfkd: "\u{1101}\u{1171}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B00E}",
        nfc: "\u{B00E}",
        nfd: "\u{1101}\u{1171}\u{11A9}",
        nfkc: "\u{B00E}",
        nfkd: "\u{1101}\u{1171}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B00F}",
        nfc: "\u{B00F}",
        nfd: "\u{1101}\u{1171}\u{11AA}",
        nfkc: "\u{B00F}",
        nfkd: "\u{1101}\u{1171}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B010}",
        nfc: "\u{B010}",
        nfd: "\u{1101}\u{1171}\u{11AB}",
        nfkc: "\u{B010}",
        nfkd: "\u{1101}\u{1171}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B011}",
        nfc: "\u{B011}",
        nfd: "\u{1101}\u{1171}\u{11AC}",
        nfkc: "\u{B011}",
        nfkd: "\u{1101}\u{1171}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B012}",
        nfc: "\u{B012}",
        nfd: "\u{1101}\u{1171}\u{11AD}",
        nfkc: "\u{B012}",
        nfkd: "\u{1101}\u{1171}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B013}",
        nfc: "\u{B013}",
        nfd: "\u{1101}\u{1171}\u{11AE}",
        nfkc: "\u{B013}",
        nfkd: "\u{1101}\u{1171}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B014}",
        nfc: "\u{B014}",
        nfd: "\u{1101}\u{1171}\u{11AF}",
        nfkc: "\u{B014}",
        nfkd: "\u{1101}\u{1171}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B015}",
        nfc: "\u{B015}",
        nfd: "\u{1101}\u{1171}\u{11B0}",
        nfkc: "\u{B015}",
        nfkd: "\u{1101}\u{1171}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B016}",
        nfc: "\u{B016}",
        nfd: "\u{1101}\u{1171}\u{11B1}",
        nfkc: "\u{B016}",
        nfkd: "\u{1101}\u{1171}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B017}",
        nfc: "\u{B017}",
        nfd: "\u{1101}\u{1171}\u{11B2}",
        nfkc: "\u{B017}",
        nfkd: "\u{1101}\u{1171}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B018}",
        nfc: "\u{B018}",
        nfd: "\u{1101}\u{1171}\u{11B3}",
        nfkc: "\u{B018}",
        nfkd: "\u{1101}\u{1171}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B019}",
        nfc: "\u{B019}",
        nfd: "\u{1101}\u{1171}\u{11B4}",
        nfkc: "\u{B019}",
        nfkd: "\u{1101}\u{1171}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B01A}",
        nfc: "\u{B01A}",
        nfd: "\u{1101}\u{1171}\u{11B5}",
        nfkc: "\u{B01A}",
        nfkd: "\u{1101}\u{1171}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B01B}",
        nfc: "\u{B01B}",
        nfd: "\u{1101}\u{1171}\u{11B6}",
        nfkc: "\u{B01B}",
        nfkd: "\u{1101}\u{1171}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B01C}",
        nfc: "\u{B01C}",
        nfd: "\u{1101}\u{1171}\u{11B7}",
        nfkc: "\u{B01C}",
        nfkd: "\u{1101}\u{1171}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B01D}",
        nfc: "\u{B01D}",
        nfd: "\u{1101}\u{1171}\u{11B8}",
        nfkc: "\u{B01D}",
        nfkd: "\u{1101}\u{1171}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B01E}",
        nfc: "\u{B01E}",
        nfd: "\u{1101}\u{1171}\u{11B9}",
        nfkc: "\u{B01E}",
        nfkd: "\u{1101}\u{1171}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B01F}",
        nfc: "\u{B01F}",
        nfd: "\u{1101}\u{1171}\u{11BA}",
        nfkc: "\u{B01F}",
        nfkd: "\u{1101}\u{1171}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B020}",
        nfc: "\u{B020}",
        nfd: "\u{1101}\u{1171}\u{11BB}",
        nfkc: "\u{B020}",
        nfkd: "\u{1101}\u{1171}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B021}",
        nfc: "\u{B021}",
        nfd: "\u{1101}\u{1171}\u{11BC}",
        nfkc: "\u{B021}",
        nfkd: "\u{1101}\u{1171}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B022}",
        nfc: "\u{B022}",
        nfd: "\u{1101}\u{1171}\u{11BD}",
        nfkc: "\u{B022}",
        nfkd: "\u{1101}\u{1171}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B023}",
        nfc: "\u{B023}",
        nfd: "\u{1101}\u{1171}\u{11BE}",
        nfkc: "\u{B023}",
        nfkd: "\u{1101}\u{1171}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B024}",
        nfc: "\u{B024}",
        nfd: "\u{1101}\u{1171}\u{11BF}",
        nfkc: "\u{B024}",
        nfkd: "\u{1101}\u{1171}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B025}",
        nfc: "\u{B025}",
        nfd: "\u{1101}\u{1171}\u{11C0}",
        nfkc: "\u{B025}",
        nfkd: "\u{1101}\u{1171}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B026}",
        nfc: "\u{B026}",
        nfd: "\u{1101}\u{1171}\u{11C1}",
        nfkc: "\u{B026}",
        nfkd: "\u{1101}\u{1171}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B027}",
        nfc: "\u{B027}",
        nfd: "\u{1101}\u{1171}\u{11C2}",
        nfkc: "\u{B027}",
        nfkd: "\u{1101}\u{1171}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B028}",
        nfc: "\u{B028}",
        nfd: "\u{1101}\u{1172}",
        nfkc: "\u{B028}",
        nfkd: "\u{1101}\u{1172}",
    },
    NormalizationTest {
        source: "\u{B029}",
        nfc: "\u{B029}",
        nfd: "\u{1101}\u{1172}\u{11A8}",
        nfkc: "\u{B029}",
        nfkd: "\u{1101}\u{1172}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B02A}",
        nfc: "\u{B02A}",
        nfd: "\u{1101}\u{1172}\u{11A9}",
        nfkc: "\u{B02A}",
        nfkd: "\u{1101}\u{1172}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B02B}",
        nfc: "\u{B02B}",
        nfd: "\u{1101}\u{1172}\u{11AA}",
        nfkc: "\u{B02B}",
        nfkd: "\u{1101}\u{1172}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B02C}",
        nfc: "\u{B02C}",
        nfd: "\u{1101}\u{1172}\u{11AB}",
        nfkc: "\u{B02C}",
        nfkd: "\u{1101}\u{1172}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B02D}",
        nfc: "\u{B02D}",
        nfd: "\u{1101}\u{1172}\u{11AC}",
        nfkc: "\u{B02D}",
        nfkd: "\u{1101}\u{1172}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B02E}",
        nfc: "\u{B02E}",
        nfd: "\u{1101}\u{1172}\u{11AD}",
        nfkc: "\u{B02E}",
        nfkd: "\u{1101}\u{1172}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B02F}",
        nfc: "\u{B02F}",
        nfd: "\u{1101}\u{1172}\u{11AE}",
        nfkc: "\u{B02F}",
        nfkd: "\u{1101}\u{1172}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B030}",
        nfc: "\u{B030}",
        nfd: "\u{1101}\u{1172}\u{11AF}",
        nfkc: "\u{B030}",
        nfkd: "\u{1101}\u{1172}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B031}",
        nfc: "\u{B031}",
        nfd: "\u{1101}\u{1172}\u{11B0}",
        nfkc: "\u{B031}",
        nfkd: "\u{1101}\u{1172}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B032}",
        nfc: "\u{B032}",
        nfd: "\u{1101}\u{1172}\u{11B1}",
        nfkc: "\u{B032}",
        nfkd: "\u{1101}\u{1172}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B033}",
        nfc: "\u{B033}",
        nfd: "\u{1101}\u{1172}\u{11B2}",
        nfkc: "\u{B033}",
        nfkd: "\u{1101}\u{1172}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B034}",
        nfc: "\u{B034}",
        nfd: "\u{1101}\u{1172}\u{11B3}",
        nfkc: "\u{B034}",
        nfkd: "\u{1101}\u{1172}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B035}",
        nfc: "\u{B035}",
        nfd: "\u{1101}\u{1172}\u{11B4}",
        nfkc: "\u{B035}",
        nfkd: "\u{1101}\u{1172}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B036}",
        nfc: "\u{B036}",
        nfd: "\u{1101}\u{1172}\u{11B5}",
        nfkc: "\u{B036}",
        nfkd: "\u{1101}\u{1172}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B037}",
        nfc: "\u{B037}",
        nfd: "\u{1101}\u{1172}\u{11B6}",
        nfkc: "\u{B037}",
        nfkd: "\u{1101}\u{1172}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B038}",
        nfc: "\u{B038}",
        nfd: "\u{1101}\u{1172}\u{11B7}",
        nfkc: "\u{B038}",
        nfkd: "\u{1101}\u{1172}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B039}",
        nfc: "\u{B039}",
        nfd: "\u{1101}\u{1172}\u{11B8}",
        nfkc: "\u{B039}",
        nfkd: "\u{1101}\u{1172}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B03A}",
        nfc: "\u{B03A}",
        nfd: "\u{1101}\u{1172}\u{11B9}",
        nfkc: "\u{B03A}",
        nfkd: "\u{1101}\u{1172}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B03B}",
        nfc: "\u{B03B}",
        nfd: "\u{1101}\u{1172}\u{11BA}",
        nfkc: "\u{B03B}",
        nfkd: "\u{1101}\u{1172}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B03C}",
        nfc: "\u{B03C}",
        nfd: "\u{1101}\u{1172}\u{11BB}",
        nfkc: "\u{B03C}",
        nfkd: "\u{1101}\u{1172}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B03D}",
        nfc: "\u{B03D}",
        nfd: "\u{1101}\u{1172}\u{11BC}",
        nfkc: "\u{B03D}",
        nfkd: "\u{1101}\u{1172}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B03E}",
        nfc: "\u{B03E}",
        nfd: "\u{1101}\u{1172}\u{11BD}",
        nfkc: "\u{B03E}",
        nfkd: "\u{1101}\u{1172}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B03F}",
        nfc: "\u{B03F}",
        nfd: "\u{1101}\u{1172}\u{11BE}",
        nfkc: "\u{B03F}",
        nfkd: "\u{1101}\u{1172}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B040}",
        nfc: "\u{B040}",
        nfd: "\u{1101}\u{1172}\u{11BF}",
        nfkc: "\u{B040}",
        nfkd: "\u{1101}\u{1172}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B041}",
        nfc: "\u{B041}",
        nfd: "\u{1101}\u{1172}\u{11C0}",
        nfkc: "\u{B041}",
        nfkd: "\u{1101}\u{1172}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B042}",
        nfc: "\u{B042}",
        nfd: "\u{1101}\u{1172}\u{11C1}",
        nfkc: "\u{B042}",
        nfkd: "\u{1101}\u{1172}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B043}",
        nfc: "\u{B043}",
        nfd: "\u{1101}\u{1172}\u{11C2}",
        nfkc: "\u{B043}",
        nfkd: "\u{1101}\u{1172}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B044}",
        nfc: "\u{B044}",
        nfd: "\u{1101}\u{1173}",
        nfkc: "\u{B044}",
        nfkd: "\u{1101}\u{1173}",
    },
    NormalizationTest {
        source: "\u{B045}",
        nfc: "\u{B045}",
        nfd: "\u{1101}\u{1173}\u{11A8}",
        nfkc: "\u{B045}",
        nfkd: "\u{1101}\u{1173}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B046}",
        nfc: "\u{B046}",
        nfd: "\u{1101}\u{1173}\u{11A9}",
        nfkc: "\u{B046}",
        nfkd: "\u{1101}\u{1173}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B047}",
        nfc: "\u{B047}",
        nfd: "\u{1101}\u{1173}\u{11AA}",
        nfkc: "\u{B047}",
        nfkd: "\u{1101}\u{1173}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B048}",
        nfc: "\u{B048}",
        nfd: "\u{1101}\u{1173}\u{11AB}",
        nfkc: "\u{B048}",
        nfkd: "\u{1101}\u{1173}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B049}",
        nfc: "\u{B049}",
        nfd: "\u{1101}\u{1173}\u{11AC}",
        nfkc: "\u{B049}",
        nfkd: "\u{1101}\u{1173}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B04A}",
        nfc: "\u{B04A}",
        nfd: "\u{1101}\u{1173}\u{11AD}",
        nfkc: "\u{B04A}",
        nfkd: "\u{1101}\u{1173}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B04B}",
        nfc: "\u{B04B}",
        nfd: "\u{1101}\u{1173}\u{11AE}",
        nfkc: "\u{B04B}",
        nfkd: "\u{1101}\u{1173}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B04C}",
        nfc: "\u{B04C}",
        nfd: "\u{1101}\u{1173}\u{11AF}",
        nfkc: "\u{B04C}",
        nfkd: "\u{1101}\u{1173}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B04D}",
        nfc: "\u{B04D}",
        nfd: "\u{1101}\u{1173}\u{11B0}",
        nfkc: "\u{B04D}",
        nfkd: "\u{1101}\u{1173}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B04E}",
        nfc: "\u{B04E}",
        nfd: "\u{1101}\u{1173}\u{11B1}",
        nfkc: "\u{B04E}",
        nfkd: "\u{1101}\u{1173}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B04F}",
        nfc: "\u{B04F}",
        nfd: "\u{1101}\u{1173}\u{11B2}",
        nfkc: "\u{B04F}",
        nfkd: "\u{1101}\u{1173}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B050}",
        nfc: "\u{B050}",
        nfd: "\u{1101}\u{1173}\u{11B3}",
        nfkc: "\u{B050}",
        nfkd: "\u{1101}\u{1173}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B051}",
        nfc: "\u{B051}",
        nfd: "\u{1101}\u{1173}\u{11B4}",
        nfkc: "\u{B051}",
        nfkd: "\u{1101}\u{1173}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B052}",
        nfc: "\u{B052}",
        nfd: "\u{1101}\u{1173}\u{11B5}",
        nfkc: "\u{B052}",
        nfkd: "\u{1101}\u{1173}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B053}",
        nfc: "\u{B053}",
        nfd: "\u{1101}\u{1173}\u{11B6}",
        nfkc: "\u{B053}",
        nfkd: "\u{1101}\u{1173}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B054}",
        nfc: "\u{B054}",
        nfd: "\u{1101}\u{1173}\u{11B7}",
        nfkc: "\u{B054}",
        nfkd: "\u{1101}\u{1173}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B055}",
        nfc: "\u{B055}",
        nfd: "\u{1101}\u{1173}\u{11B8}",
        nfkc: "\u{B055}",
        nfkd: "\u{1101}\u{1173}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B056}",
        nfc: "\u{B056}",
        nfd: "\u{1101}\u{1173}\u{11B9}",
        nfkc: "\u{B056}",
        nfkd: "\u{1101}\u{1173}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B057}",
        nfc: "\u{B057}",
        nfd: "\u{1101}\u{1173}\u{11BA}",
        nfkc: "\u{B057}",
        nfkd: "\u{1101}\u{1173}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B058}",
        nfc: "\u{B058}",
        nfd: "\u{1101}\u{1173}\u{11BB}",
        nfkc: "\u{B058}",
        nfkd: "\u{1101}\u{1173}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B059}",
        nfc: "\u{B059}",
        nfd: "\u{1101}\u{1173}\u{11BC}",
        nfkc: "\u{B059}",
        nfkd: "\u{1101}\u{1173}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B05A}",
        nfc: "\u{B05A}",
        nfd: "\u{1101}\u{1173}\u{11BD}",
        nfkc: "\u{B05A}",
        nfkd: "\u{1101}\u{1173}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B05B}",
        nfc: "\u{B05B}",
        nfd: "\u{1101}\u{1173}\u{11BE}",
        nfkc: "\u{B05B}",
        nfkd: "\u{1101}\u{1173}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B05C}",
        nfc: "\u{B05C}",
        nfd: "\u{1101}\u{1173}\u{11BF}",
        nfkc: "\u{B05C}",
        nfkd: "\u{1101}\u{1173}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B05D}",
        nfc: "\u{B05D}",
        nfd: "\u{1101}\u{1173}\u{11C0}",
        nfkc: "\u{B05D}",
        nfkd: "\u{1101}\u{1173}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B05E}",
        nfc: "\u{B05E}",
        nfd: "\u{1101}\u{1173}\u{11C1}",
        nfkc: "\u{B05E}",
        nfkd: "\u{1101}\u{1173}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B05F}",
        nfc: "\u{B05F}",
        nfd: "\u{1101}\u{1173}\u{11C2}",
        nfkc: "\u{B05F}",
        nfkd: "\u{1101}\u{1173}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B060}",
        nfc: "\u{B060}",
        nfd: "\u{1101}\u{1174}",
        nfkc: "\u{B060}",
        nfkd: "\u{1101}\u{1174}",
    },
    NormalizationTest {
        source: "\u{B061}",
        nfc: "\u{B061}",
        nfd: "\u{1101}\u{1174}\u{11A8}",
        nfkc: "\u{B061}",
        nfkd: "\u{1101}\u{1174}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B062}",
        nfc: "\u{B062}",
        nfd: "\u{1101}\u{1174}\u{11A9}",
        nfkc: "\u{B062}",
        nfkd: "\u{1101}\u{1174}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B063}",
        nfc: "\u{B063}",
        nfd: "\u{1101}\u{1174}\u{11AA}",
        nfkc: "\u{B063}",
        nfkd: "\u{1101}\u{1174}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B064}",
        nfc: "\u{B064}",
        nfd: "\u{1101}\u{1174}\u{11AB}",
        nfkc: "\u{B064}",
        nfkd: "\u{1101}\u{1174}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B065}",
        nfc: "\u{B065}",
        nfd: "\u{1101}\u{1174}\u{11AC}",
        nfkc: "\u{B065}",
        nfkd: "\u{1101}\u{1174}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B066}",
        nfc: "\u{B066}",
        nfd: "\u{1101}\u{1174}\u{11AD}",
        nfkc: "\u{B066}",
        nfkd: "\u{1101}\u{1174}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B067}",
        nfc: "\u{B067}",
        nfd: "\u{1101}\u{1174}\u{11AE}",
        nfkc: "\u{B067}",
        nfkd: "\u{1101}\u{1174}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B068}",
        nfc: "\u{B068}",
        nfd: "\u{1101}\u{1174}\u{11AF}",
        nfkc: "\u{B068}",
        nfkd: "\u{1101}\u{1174}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B069}",
        nfc: "\u{B069}",
        nfd: "\u{1101}\u{1174}\u{11B0}",
        nfkc: "\u{B069}",
        nfkd: "\u{1101}\u{1174}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B06A}",
        nfc: "\u{B06A}",
        nfd: "\u{1101}\u{1174}\u{11B1}",
        nfkc: "\u{B06A}",
        nfkd: "\u{1101}\u{1174}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B06B}",
        nfc: "\u{B06B}",
        nfd: "\u{1101}\u{1174}\u{11B2}",
        nfkc: "\u{B06B}",
        nfkd: "\u{1101}\u{1174}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B06C}",
        nfc: "\u{B06C}",
        nfd: "\u{1101}\u{1174}\u{11B3}",
        nfkc: "\u{B06C}",
        nfkd: "\u{1101}\u{1174}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B06D}",
        nfc: "\u{B06D}",
        nfd: "\u{1101}\u{1174}\u{11B4}",
        nfkc: "\u{B06D}",
        nfkd: "\u{1101}\u{1174}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B06E}",
        nfc: "\u{B06E}",
        nfd: "\u{1101}\u{1174}\u{11B5}",
        nfkc: "\u{B06E}",
        nfkd: "\u{1101}\u{1174}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B06F}",
        nfc: "\u{B06F}",
        nfd: "\u{1101}\u{1174}\u{11B6}",
        nfkc: "\u{B06F}",
        nfkd: "\u{1101}\u{1174}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B070}",
        nfc: "\u{B070}",
        nfd: "\u{1101}\u{1174}\u{11B7}",
        nfkc: "\u{B070}",
        nfkd: "\u{1101}\u{1174}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B071}",
        nfc: "\u{B071}",
        nfd: "\u{1101}\u{1174}\u{11B8}",
        nfkc: "\u{B071}",
        nfkd: "\u{1101}\u{1174}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B072}",
        nfc: "\u{B072}",
        nfd: "\u{1101}\u{1174}\u{11B9}",
        nfkc: "\u{B072}",
        nfkd: "\u{1101}\u{1174}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B073}",
        nfc: "\u{B073}",
        nfd: "\u{1101}\u{1174}\u{11BA}",
        nfkc: "\u{B073}",
        nfkd: "\u{1101}\u{1174}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B074}",
        nfc: "\u{B074}",
        nfd: "\u{1101}\u{1174}\u{11BB}",
        nfkc: "\u{B074}",
        nfkd: "\u{1101}\u{1174}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B075}",
        nfc: "\u{B075}",
        nfd: "\u{1101}\u{1174}\u{11BC}",
        nfkc: "\u{B075}",
        nfkd: "\u{1101}\u{1174}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B076}",
        nfc: "\u{B076}",
        nfd: "\u{1101}\u{1174}\u{11BD}",
        nfkc: "\u{B076}",
        nfkd: "\u{1101}\u{1174}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B077}",
        nfc: "\u{B077}",
        nfd: "\u{1101}\u{1174}\u{11BE}",
        nfkc: "\u{B077}",
        nfkd: "\u{1101}\u{1174}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B078}",
        nfc: "\u{B078}",
        nfd: "\u{1101}\u{1174}\u{11BF}",
        nfkc: "\u{B078}",
        nfkd: "\u{1101}\u{1174}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B079}",
        nfc: "\u{B079}",
        nfd: "\u{1101}\u{1174}\u{11C0}",
        nfkc: "\u{B079}",
        nfkd: "\u{1101}\u{1174}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B07A}",
        nfc: "\u{B07A}",
        nfd: "\u{1101}\u{1174}\u{11C1}",
        nfkc: "\u{B07A}",
        nfkd: "\u{1101}\u{1174}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B07B}",
        nfc: "\u{B07B}",
        nfd: "\u{1101}\u{1174}\u{11C2}",
        nfkc: "\u{B07B}",
        nfkd: "\u{1101}\u{1174}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B07C}",
        nfc: "\u{B07C}",
        nfd: "\u{1101}\u{1175}",
        nfkc: "\u{B07C}",
        nfkd: "\u{1101}\u{1175}",
    },
    NormalizationTest {
        source: "\u{B07D}",
        nfc: "\u{B07D}",
        nfd: "\u{1101}\u{1175}\u{11A8}",
        nfkc: "\u{B07D}",
        nfkd: "\u{1101}\u{1175}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B07E}",
        nfc: "\u{B07E}",
        nfd: "\u{1101}\u{1175}\u{11A9}",
        nfkc: "\u{B07E}",
        nfkd: "\u{1101}\u{1175}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B07F}",
        nfc: "\u{B07F}",
        nfd: "\u{1101}\u{1175}\u{11AA}",
        nfkc: "\u{B07F}",
        nfkd: "\u{1101}\u{1175}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B080}",
        nfc: "\u{B080}",
        nfd: "\u{1101}\u{1175}\u{11AB}",
        nfkc: "\u{B080}",
        nfkd: "\u{1101}\u{1175}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B081}",
        nfc: "\u{B081}",
        nfd: "\u{1101}\u{1175}\u{11AC}",
        nfkc: "\u{B081}",
        nfkd: "\u{1101}\u{1175}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B082}",
        nfc: "\u{B082}",
        nfd: "\u{1101}\u{1175}\u{11AD}",
        nfkc: "\u{B082}",
        nfkd: "\u{1101}\u{1175}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B083}",
        nfc: "\u{B083}",
        nfd: "\u{1101}\u{1175}\u{11AE}",
        nfkc: "\u{B083}",
        nfkd: "\u{1101}\u{1175}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B084}",
        nfc: "\u{B084}",
        nfd: "\u{1101}\u{1175}\u{11AF}",
        nfkc: "\u{B084}",
        nfkd: "\u{1101}\u{1175}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B085}",
        nfc: "\u{B085}",
        nfd: "\u{1101}\u{1175}\u{11B0}",
        nfkc: "\u{B085}",
        nfkd: "\u{1101}\u{1175}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B086}",
        nfc: "\u{B086}",
        nfd: "\u{1101}\u{1175}\u{11B1}",
        nfkc: "\u{B086}",
        nfkd: "\u{1101}\u{1175}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B087}",
        nfc: "\u{B087}",
        nfd: "\u{1101}\u{1175}\u{11B2}",
        nfkc: "\u{B087}",
        nfkd: "\u{1101}\u{1175}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B088}",
        nfc: "\u{B088}",
        nfd: "\u{1101}\u{1175}\u{11B3}",
        nfkc: "\u{B088}",
        nfkd: "\u{1101}\u{1175}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B089}",
        nfc: "\u{B089}",
        nfd: "\u{1101}\u{1175}\u{11B4}",
        nfkc: "\u{B089}",
        nfkd: "\u{1101}\u{1175}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B08A}",
        nfc: "\u{B08A}",
        nfd: "\u{1101}\u{1175}\u{11B5}",
        nfkc: "\u{B08A}",
        nfkd: "\u{1101}\u{1175}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B08B}",
        nfc: "\u{B08B}",
        nfd: "\u{1101}\u{1175}\u{11B6}",
        nfkc: "\u{B08B}",
        nfkd: "\u{1101}\u{1175}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B08C}",
        nfc: "\u{B08C}",
        nfd: "\u{1101}\u{1175}\u{11B7}",
        nfkc: "\u{B08C}",
        nfkd: "\u{1101}\u{1175}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B08D}",
        nfc: "\u{B08D}",
        nfd: "\u{1101}\u{1175}\u{11B8}",
        nfkc: "\u{B08D}",
        nfkd: "\u{1101}\u{1175}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B08E}",
        nfc: "\u{B08E}",
        nfd: "\u{1101}\u{1175}\u{11B9}",
        nfkc: "\u{B08E}",
        nfkd: "\u{1101}\u{1175}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B08F}",
        nfc: "\u{B08F}",
        nfd: "\u{1101}\u{1175}\u{11BA}",
        nfkc: "\u{B08F}",
        nfkd: "\u{1101}\u{1175}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B090}",
        nfc: "\u{B090}",
        nfd: "\u{1101}\u{1175}\u{11BB}",
        nfkc: "\u{B090}",
        nfkd: "\u{1101}\u{1175}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B091}",
        nfc: "\u{B091}",
        nfd: "\u{1101}\u{1175}\u{11BC}",
        nfkc: "\u{B091}",
        nfkd: "\u{1101}\u{1175}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B092}",
        nfc: "\u{B092}",
        nfd: "\u{1101}\u{1175}\u{11BD}",
        nfkc: "\u{B092}",
        nfkd: "\u{1101}\u{1175}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B093}",
        nfc: "\u{B093}",
        nfd: "\u{1101}\u{1175}\u{11BE}",
        nfkc: "\u{B093}",
        nfkd: "\u{1101}\u{1175}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B094}",
        nfc: "\u{B094}",
        nfd: "\u{1101}\u{1175}\u{11BF}",
        nfkc: "\u{B094}",
        nfkd: "\u{1101}\u{1175}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B095}",
        nfc: "\u{B095}",
        nfd: "\u{1101}\u{1175}\u{11C0}",
        nfkc: "\u{B095}",
        nfkd: "\u{1101}\u{1175}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B096}",
        nfc: "\u{B096}",
        nfd: "\u{1101}\u{1175}\u{11C1}",
        nfkc: "\u{B096}",
        nfkd: "\u{1101}\u{1175}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B097}",
        nfc: "\u{B097}",
        nfd: "\u{1101}\u{1175}\u{11C2}",
        nfkc: "\u{B097}",
        nfkd: "\u{1101}\u{1175}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B098}",
        nfc: "\u{B098}",
        nfd: "\u{1102}\u{1161}",
        nfkc: "\u{B098}",
        nfkd: "\u{1102}\u{1161}",
    },
    NormalizationTest {
        source: "\u{B099}",
        nfc: "\u{B099}",
        nfd: "\u{1102}\u{1161}\u{11A8}",
        nfkc: "\u{B099}",
        nfkd: "\u{1102}\u{1161}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B09A}",
        nfc: "\u{B09A}",
        nfd: "\u{1102}\u{1161}\u{11A9}",
        nfkc: "\u{B09A}",
        nfkd: "\u{1102}\u{1161}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B09B}",
        nfc: "\u{B09B}",
        nfd: "\u{1102}\u{1161}\u{11AA}",
        nfkc: "\u{B09B}",
        nfkd: "\u{1102}\u{1161}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B09C}",
        nfc: "\u{B09C}",
        nfd: "\u{1102}\u{1161}\u{11AB}",
        nfkc: "\u{B09C}",
        nfkd: "\u{1102}\u{1161}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B09D}",
        nfc: "\u{B09D}",
        nfd: "\u{1102}\u{1161}\u{11AC}",
        nfkc: "\u{B09D}",
        nfkd: "\u{1102}\u{1161}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B09E}",
        nfc: "\u{B09E}",
        nfd: "\u{1102}\u{1161}\u{11AD}",
        nfkc: "\u{B09E}",
        nfkd: "\u{1102}\u{1161}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B09F}",
        nfc: "\u{B09F}",
        nfd: "\u{1102}\u{1161}\u{11AE}",
        nfkc: "\u{B09F}",
        nfkd: "\u{1102}\u{1161}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B0A0}",
        nfc: "\u{B0A0}",
        nfd: "\u{1102}\u{1161}\u{11AF}",
        nfkc: "\u{B0A0}",
        nfkd: "\u{1102}\u{1161}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B0A1}",
        nfc: "\u{B0A1}",
        nfd: "\u{1102}\u{1161}\u{11B0}",
        nfkc: "\u{B0A1}",
        nfkd: "\u{1102}\u{1161}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B0A2}",
        nfc: "\u{B0A2}",
        nfd: "\u{1102}\u{1161}\u{11B1}",
        nfkc: "\u{B0A2}",
        nfkd: "\u{1102}\u{1161}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B0A3}",
        nfc: "\u{B0A3}",
        nfd: "\u{1102}\u{1161}\u{11B2}",
        nfkc: "\u{B0A3}",
        nfkd: "\u{1102}\u{1161}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B0A4}",
        nfc: "\u{B0A4}",
        nfd: "\u{1102}\u{1161}\u{11B3}",
        nfkc: "\u{B0A4}",
        nfkd: "\u{1102}\u{1161}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B0A5}",
        nfc: "\u{B0A5}",
        nfd: "\u{1102}\u{1161}\u{11B4}",
        nfkc: "\u{B0A5}",
        nfkd: "\u{1102}\u{1161}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B0A6}",
        nfc: "\u{B0A6}",
        nfd: "\u{1102}\u{1161}\u{11B5}",
        nfkc: "\u{B0A6}",
        nfkd: "\u{1102}\u{1161}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B0A7}",
        nfc: "\u{B0A7}",
        nfd: "\u{1102}\u{1161}\u{11B6}",
        nfkc: "\u{B0A7}",
        nfkd: "\u{1102}\u{1161}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B0A8}",
        nfc: "\u{B0A8}",
        nfd: "\u{1102}\u{1161}\u{11B7}",
        nfkc: "\u{B0A8}",
        nfkd: "\u{1102}\u{1161}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B0A9}",
        nfc: "\u{B0A9}",
        nfd: "\u{1102}\u{1161}\u{11B8}",
        nfkc: "\u{B0A9}",
        nfkd: "\u{1102}\u{1161}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B0AA}",
        nfc: "\u{B0AA}",
        nfd: "\u{1102}\u{1161}\u{11B9}",
        nfkc: "\u{B0AA}",
        nfkd: "\u{1102}\u{1161}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B0AB}",
        nfc: "\u{B0AB}",
        nfd: "\u{1102}\u{1161}\u{11BA}",
        nfkc: "\u{B0AB}",
        nfkd: "\u{1102}\u{1161}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B0AC}",
        nfc: "\u{B0AC}",
        nfd: "\u{1102}\u{1161}\u{11BB}",
        nfkc: "\u{B0AC}",
        nfkd: "\u{1102}\u{1161}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B0AD}",
        nfc: "\u{B0AD}",
        nfd: "\u{1102}\u{1161}\u{11BC}",
        nfkc: "\u{B0AD}",
        nfkd: "\u{1102}\u{1161}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B0AE}",
        nfc: "\u{B0AE}",
        nfd: "\u{1102}\u{1161}\u{11BD}",
        nfkc: "\u{B0AE}",
        nfkd: "\u{1102}\u{1161}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B0AF}",
        nfc: "\u{B0AF}",
        nfd: "\u{1102}\u{1161}\u{11BE}",
        nfkc: "\u{B0AF}",
        nfkd: "\u{1102}\u{1161}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B0B0}",
        nfc: "\u{B0B0}",
        nfd: "\u{1102}\u{1161}\u{11BF}",
        nfkc: "\u{B0B0}",
        nfkd: "\u{1102}\u{1161}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B0B1}",
        nfc: "\u{B0B1}",
        nfd: "\u{1102}\u{1161}\u{11C0}",
        nfkc: "\u{B0B1}",
        nfkd: "\u{1102}\u{1161}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B0B2}",
        nfc: "\u{B0B2}",
        nfd: "\u{1102}\u{1161}\u{11C1}",
        nfkc: "\u{B0B2}",
        nfkd: "\u{1102}\u{1161}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B0B3}",
        nfc: "\u{B0B3}",
        nfd: "\u{1102}\u{1161}\u{11C2}",
        nfkc: "\u{B0B3}",
        nfkd: "\u{1102}\u{1161}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B0B4}",
        nfc: "\u{B0B4}",
        nfd: "\u{1102}\u{1162}",
        nfkc: "\u{B0B4}",
        nfkd: "\u{1102}\u{1162}",
    },
    NormalizationTest {
        source: "\u{B0B5}",
        nfc: "\u{B0B5}",
        nfd: "\u{1102}\u{1162}\u{11A8}",
        nfkc: "\u{B0B5}",
        nfkd: "\u{1102}\u{1162}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B0B6}",
        nfc: "\u{B0B6}",
        nfd: "\u{1102}\u{1162}\u{11A9}",
        nfkc: "\u{B0B6}",
        nfkd: "\u{1102}\u{1162}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B0B7}",
        nfc: "\u{B0B7}",
        nfd: "\u{1102}\u{1162}\u{11AA}",
        nfkc: "\u{B0B7}",
        nfkd: "\u{1102}\u{1162}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B0B8}",
        nfc: "\u{B0B8}",
        nfd: "\u{1102}\u{1162}\u{11AB}",
        nfkc: "\u{B0B8}",
        nfkd: "\u{1102}\u{1162}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B0B9}",
        nfc: "\u{B0B9}",
        nfd: "\u{1102}\u{1162}\u{11AC}",
        nfkc: "\u{B0B9}",
        nfkd: "\u{1102}\u{1162}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B0BA}",
        nfc: "\u{B0BA}",
        nfd: "\u{1102}\u{1162}\u{11AD}",
        nfkc: "\u{B0BA}",
        nfkd: "\u{1102}\u{1162}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B0BB}",
        nfc: "\u{B0BB}",
        nfd: "\u{1102}\u{1162}\u{11AE}",
        nfkc: "\u{B0BB}",
        nfkd: "\u{1102}\u{1162}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B0BC}",
        nfc: "\u{B0BC}",
        nfd: "\u{1102}\u{1162}\u{11AF}",
        nfkc: "\u{B0BC}",
        nfkd: "\u{1102}\u{1162}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B0BD}",
        nfc: "\u{B0BD}",
        nfd: "\u{1102}\u{1162}\u{11B0}",
        nfkc: "\u{B0BD}",
        nfkd: "\u{1102}\u{1162}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B0BE}",
        nfc: "\u{B0BE}",
        nfd: "\u{1102}\u{1162}\u{11B1}",
        nfkc: "\u{B0BE}",
        nfkd: "\u{1102}\u{1162}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B0BF}",
        nfc: "\u{B0BF}",
        nfd: "\u{1102}\u{1162}\u{11B2}",
        nfkc: "\u{B0BF}",
        nfkd: "\u{1102}\u{1162}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B0C0}",
        nfc: "\u{B0C0}",
        nfd: "\u{1102}\u{1162}\u{11B3}",
        nfkc: "\u{B0C0}",
        nfkd: "\u{1102}\u{1162}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B0C1}",
        nfc: "\u{B0C1}",
        nfd: "\u{1102}\u{1162}\u{11B4}",
        nfkc: "\u{B0C1}",
        nfkd: "\u{1102}\u{1162}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B0C2}",
        nfc: "\u{B0C2}",
        nfd: "\u{1102}\u{1162}\u{11B5}",
        nfkc: "\u{B0C2}",
        nfkd: "\u{1102}\u{1162}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B0C3}",
        nfc: "\u{B0C3}",
        nfd: "\u{1102}\u{1162}\u{11B6}",
        nfkc: "\u{B0C3}",
        nfkd: "\u{1102}\u{1162}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B0C4}",
        nfc: "\u{B0C4}",
        nfd: "\u{1102}\u{1162}\u{11B7}",
        nfkc: "\u{B0C4}",
        nfkd: "\u{1102}\u{1162}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B0C5}",
        nfc: "\u{B0C5}",
        nfd: "\u{1102}\u{1162}\u{11B8}",
        nfkc: "\u{B0C5}",
        nfkd: "\u{1102}\u{1162}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B0C6}",
        nfc: "\u{B0C6}",
        nfd: "\u{1102}\u{1162}\u{11B9}",
        nfkc: "\u{B0C6}",
        nfkd: "\u{1102}\u{1162}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B0C7}",
        nfc: "\u{B0C7}",
        nfd: "\u{1102}\u{1162}\u{11BA}",
        nfkc: "\u{B0C7}",
        nfkd: "\u{1102}\u{1162}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B0C8}",
        nfc: "\u{B0C8}",
        nfd: "\u{1102}\u{1162}\u{11BB}",
        nfkc: "\u{B0C8}",
        nfkd: "\u{1102}\u{1162}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B0C9}",
        nfc: "\u{B0C9}",
        nfd: "\u{1102}\u{1162}\u{11BC}",
        nfkc: "\u{B0C9}",
        nfkd: "\u{1102}\u{1162}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B0CA}",
        nfc: "\u{B0CA}",
        nfd: "\u{1102}\u{1162}\u{11BD}",
        nfkc: "\u{B0CA}",
        nfkd: "\u{1102}\u{1162}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B0CB}",
        nfc: "\u{B0CB}",
        nfd: "\u{1102}\u{1162}\u{11BE}",
        nfkc: "\u{B0CB}",
        nfkd: "\u{1102}\u{1162}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B0CC}",
        nfc: "\u{B0CC}",
        nfd: "\u{1102}\u{1162}\u{11BF}",
        nfkc: "\u{B0CC}",
        nfkd: "\u{1102}\u{1162}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B0CD}",
        nfc: "\u{B0CD}",
        nfd: "\u{1102}\u{1162}\u{11C0}",
        nfkc: "\u{B0CD}",
        nfkd: "\u{1102}\u{1162}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B0CE}",
        nfc: "\u{B0CE}",
        nfd: "\u{1102}\u{1162}\u{11C1}",
        nfkc: "\u{B0CE}",
        nfkd: "\u{1102}\u{1162}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B0CF}",
        nfc: "\u{B0CF}",
        nfd: "\u{1102}\u{1162}\u{11C2}",
        nfkc: "\u{B0CF}",
        nfkd: "\u{1102}\u{1162}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B0D0}",
        nfc: "\u{B0D0}",
        nfd: "\u{1102}\u{1163}",
        nfkc: "\u{B0D0}",
        nfkd: "\u{1102}\u{1163}",
    },
    NormalizationTest {
        source: "\u{B0D1}",
        nfc: "\u{B0D1}",
        nfd: "\u{1102}\u{1163}\u{11A8}",
        nfkc: "\u{B0D1}",
        nfkd: "\u{1102}\u{1163}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B0D2}",
        nfc: "\u{B0D2}",
        nfd: "\u{1102}\u{1163}\u{11A9}",
        nfkc: "\u{B0D2}",
        nfkd: "\u{1102}\u{1163}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B0D3}",
        nfc: "\u{B0D3}",
        nfd: "\u{1102}\u{1163}\u{11AA}",
        nfkc: "\u{B0D3}",
        nfkd: "\u{1102}\u{1163}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B0D4}",
        nfc: "\u{B0D4}",
        nfd: "\u{1102}\u{1163}\u{11AB}",
        nfkc: "\u{B0D4}",
        nfkd: "\u{1102}\u{1163}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B0D5}",
        nfc: "\u{B0D5}",
        nfd: "\u{1102}\u{1163}\u{11AC}",
        nfkc: "\u{B0D5}",
        nfkd: "\u{1102}\u{1163}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B0D6}",
        nfc: "\u{B0D6}",
        nfd: "\u{1102}\u{1163}\u{11AD}",
        nfkc: "\u{B0D6}",
        nfkd: "\u{1102}\u{1163}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B0D7}",
        nfc: "\u{B0D7}",
        nfd: "\u{1102}\u{1163}\u{11AE}",
        nfkc: "\u{B0D7}",
        nfkd: "\u{1102}\u{1163}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B0D8}",
        nfc: "\u{B0D8}",
        nfd: "\u{1102}\u{1163}\u{11AF}",
        nfkc: "\u{B0D8}",
        nfkd: "\u{1102}\u{1163}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B0D9}",
        nfc: "\u{B0D9}",
        nfd: "\u{1102}\u{1163}\u{11B0}",
        nfkc: "\u{B0D9}",
        nfkd: "\u{1102}\u{1163}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B0DA}",
        nfc: "\u{B0DA}",
        nfd: "\u{1102}\u{1163}\u{11B1}",
        nfkc: "\u{B0DA}",
        nfkd: "\u{1102}\u{1163}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B0DB}",
        nfc: "\u{B0DB}",
        nfd: "\u{1102}\u{1163}\u{11B2}",
        nfkc: "\u{B0DB}",
        nfkd: "\u{1102}\u{1163}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B0DC}",
        nfc: "\u{B0DC}",
        nfd: "\u{1102}\u{1163}\u{11B3}",
        nfkc: "\u{B0DC}",
        nfkd: "\u{1102}\u{1163}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B0DD}",
        nfc: "\u{B0DD}",
        nfd: "\u{1102}\u{1163}\u{11B4}",
        nfkc: "\u{B0DD}",
        nfkd: "\u{1102}\u{1163}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B0DE}",
        nfc: "\u{B0DE}",
        nfd: "\u{1102}\u{1163}\u{11B5}",
        nfkc: "\u{B0DE}",
        nfkd: "\u{1102}\u{1163}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B0DF}",
        nfc: "\u{B0DF}",
        nfd: "\u{1102}\u{1163}\u{11B6}",
        nfkc: "\u{B0DF}",
        nfkd: "\u{1102}\u{1163}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B0E0}",
        nfc: "\u{B0E0}",
        nfd: "\u{1102}\u{1163}\u{11B7}",
        nfkc: "\u{B0E0}",
        nfkd: "\u{1102}\u{1163}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B0E1}",
        nfc: "\u{B0E1}",
        nfd: "\u{1102}\u{1163}\u{11B8}",
        nfkc: "\u{B0E1}",
        nfkd: "\u{1102}\u{1163}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B0E2}",
        nfc: "\u{B0E2}",
        nfd: "\u{1102}\u{1163}\u{11B9}",
        nfkc: "\u{B0E2}",
        nfkd: "\u{1102}\u{1163}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B0E3}",
        nfc: "\u{B0E3}",
        nfd: "\u{1102}\u{1163}\u{11BA}",
        nfkc: "\u{B0E3}",
        nfkd: "\u{1102}\u{1163}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B0E4}",
        nfc: "\u{B0E4}",
        nfd: "\u{1102}\u{1163}\u{11BB}",
        nfkc: "\u{B0E4}",
        nfkd: "\u{1102}\u{1163}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B0E5}",
        nfc: "\u{B0E5}",
        nfd: "\u{1102}\u{1163}\u{11BC}",
        nfkc: "\u{B0E5}",
        nfkd: "\u{1102}\u{1163}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B0E6}",
        nfc: "\u{B0E6}",
        nfd: "\u{1102}\u{1163}\u{11BD}",
        nfkc: "\u{B0E6}",
        nfkd: "\u{1102}\u{1163}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B0E7}",
        nfc: "\u{B0E7}",
        nfd: "\u{1102}\u{1163}\u{11BE}",
        nfkc: "\u{B0E7}",
        nfkd: "\u{1102}\u{1163}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B0E8}",
        nfc: "\u{B0E8}",
        nfd: "\u{1102}\u{1163}\u{11BF}",
        nfkc: "\u{B0E8}",
        nfkd: "\u{1102}\u{1163}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B0E9}",
        nfc: "\u{B0E9}",
        nfd: "\u{1102}\u{1163}\u{11C0}",
        nfkc: "\u{B0E9}",
        nfkd: "\u{1102}\u{1163}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B0EA}",
        nfc: "\u{B0EA}",
        nfd: "\u{1102}\u{1163}\u{11C1}",
        nfkc: "\u{B0EA}",
        nfkd: "\u{1102}\u{1163}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B0EB}",
        nfc: "\u{B0EB}",
        nfd: "\u{1102}\u{1163}\u{11C2}",
        nfkc: "\u{B0EB}",
        nfkd: "\u{1102}\u{1163}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B0EC}",
        nfc: "\u{B0EC}",
        nfd: "\u{1102}\u{1164}",
        nfkc: "\u{B0EC}",
        nfkd: "\u{1102}\u{1164}",
    },
    NormalizationTest {
        source: "\u{B0ED}",
        nfc: "\u{B0ED}",
        nfd: "\u{1102}\u{1164}\u{11A8}",
        nfkc: "\u{B0ED}",
        nfkd: "\u{1102}\u{1164}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B0EE}",
        nfc: "\u{B0EE}",
        nfd: "\u{1102}\u{1164}\u{11A9}",
        nfkc: "\u{B0EE}",
        nfkd: "\u{1102}\u{1164}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B0EF}",
        nfc: "\u{B0EF}",
        nfd: "\u{1102}\u{1164}\u{11AA}",
        nfkc: "\u{B0EF}",
        nfkd: "\u{1102}\u{1164}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B0F0}",
        nfc: "\u{B0F0}",
        nfd: "\u{1102}\u{1164}\u{11AB}",
        nfkc: "\u{B0F0}",
        nfkd: "\u{1102}\u{1164}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B0F1}",
        nfc: "\u{B0F1}",
        nfd: "\u{1102}\u{1164}\u{11AC}",
        nfkc: "\u{B0F1}",
        nfkd: "\u{1102}\u{1164}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B0F2}",
        nfc: "\u{B0F2}",
        nfd: "\u{1102}\u{1164}\u{11AD}",
        nfkc: "\u{B0F2}",
        nfkd: "\u{1102}\u{1164}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B0F3}",
        nfc: "\u{B0F3}",
        nfd: "\u{1102}\u{1164}\u{11AE}",
        nfkc: "\u{B0F3}",
        nfkd: "\u{1102}\u{1164}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B0F4}",
        nfc: "\u{B0F4}",
        nfd: "\u{1102}\u{1164}\u{11AF}",
        nfkc: "\u{B0F4}",
        nfkd: "\u{1102}\u{1164}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B0F5}",
        nfc: "\u{B0F5}",
        nfd: "\u{1102}\u{1164}\u{11B0}",
        nfkc: "\u{B0F5}",
        nfkd: "\u{1102}\u{1164}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B0F6}",
        nfc: "\u{B0F6}",
        nfd: "\u{1102}\u{1164}\u{11B1}",
        nfkc: "\u{B0F6}",
        nfkd: "\u{1102}\u{1164}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B0F7}",
        nfc: "\u{B0F7}",
        nfd: "\u{1102}\u{1164}\u{11B2}",
        nfkc: "\u{B0F7}",
        nfkd: "\u{1102}\u{1164}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B0F8}",
        nfc: "\u{B0F8}",
        nfd: "\u{1102}\u{1164}\u{11B3}",
        nfkc: "\u{B0F8}",
        nfkd: "\u{1102}\u{1164}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B0F9}",
        nfc: "\u{B0F9}",
        nfd: "\u{1102}\u{1164}\u{11B4}",
        nfkc: "\u{B0F9}",
        nfkd: "\u{1102}\u{1164}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B0FA}",
        nfc: "\u{B0FA}",
        nfd: "\u{1102}\u{1164}\u{11B5}",
        nfkc: "\u{B0FA}",
        nfkd: "\u{1102}\u{1164}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B0FB}",
        nfc: "\u{B0FB}",
        nfd: "\u{1102}\u{1164}\u{11B6}",
        nfkc: "\u{B0FB}",
        nfkd: "\u{1102}\u{1164}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B0FC}",
        nfc: "\u{B0FC}",
        nfd: "\u{1102}\u{1164}\u{11B7}",
        nfkc: "\u{B0FC}",
        nfkd: "\u{1102}\u{1164}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B0FD}",
        nfc: "\u{B0FD}",
        nfd: "\u{1102}\u{1164}\u{11B8}",
        nfkc: "\u{B0FD}",
        nfkd: "\u{1102}\u{1164}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B0FE}",
        nfc: "\u{B0FE}",
        nfd: "\u{1102}\u{1164}\u{11B9}",
        nfkc: "\u{B0FE}",
        nfkd: "\u{1102}\u{1164}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B0FF}",
        nfc: "\u{B0FF}",
        nfd: "\u{1102}\u{1164}\u{11BA}",
        nfkc: "\u{B0FF}",
        nfkd: "\u{1102}\u{1164}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B100}",
        nfc: "\u{B100}",
        nfd: "\u{1102}\u{1164}\u{11BB}",
        nfkc: "\u{B100}",
        nfkd: "\u{1102}\u{1164}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B101}",
        nfc: "\u{B101}",
        nfd: "\u{1102}\u{1164}\u{11BC}",
        nfkc: "\u{B101}",
        nfkd: "\u{1102}\u{1164}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B102}",
        nfc: "\u{B102}",
        nfd: "\u{1102}\u{1164}\u{11BD}",
        nfkc: "\u{B102}",
        nfkd: "\u{1102}\u{1164}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B103}",
        nfc: "\u{B103}",
        nfd: "\u{1102}\u{1164}\u{11BE}",
        nfkc: "\u{B103}",
        nfkd: "\u{1102}\u{1164}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B104}",
        nfc: "\u{B104}",
        nfd: "\u{1102}\u{1164}\u{11BF}",
        nfkc: "\u{B104}",
        nfkd: "\u{1102}\u{1164}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B105}",
        nfc: "\u{B105}",
        nfd: "\u{1102}\u{1164}\u{11C0}",
        nfkc: "\u{B105}",
        nfkd: "\u{1102}\u{1164}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B106}",
        nfc: "\u{B106}",
        nfd: "\u{1102}\u{1164}\u{11C1}",
        nfkc: "\u{B106}",
        nfkd: "\u{1102}\u{1164}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B107}",
        nfc: "\u{B107}",
        nfd: "\u{1102}\u{1164}\u{11C2}",
        nfkc: "\u{B107}",
        nfkd: "\u{1102}\u{1164}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B108}",
        nfc: "\u{B108}",
        nfd: "\u{1102}\u{1165}",
        nfkc: "\u{B108}",
        nfkd: "\u{1102}\u{1165}",
    },
    NormalizationTest {
        source: "\u{B109}",
        nfc: "\u{B109}",
        nfd: "\u{1102}\u{1165}\u{11A8}",
        nfkc: "\u{B109}",
        nfkd: "\u{1102}\u{1165}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B10A}",
        nfc: "\u{B10A}",
        nfd: "\u{1102}\u{1165}\u{11A9}",
        nfkc: "\u{B10A}",
        nfkd: "\u{1102}\u{1165}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B10B}",
        nfc: "\u{B10B}",
        nfd: "\u{1102}\u{1165}\u{11AA}",
        nfkc: "\u{B10B}",
        nfkd: "\u{1102}\u{1165}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B10C}",
        nfc: "\u{B10C}",
        nfd: "\u{1102}\u{1165}\u{11AB}",
        nfkc: "\u{B10C}",
        nfkd: "\u{1102}\u{1165}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B10D}",
        nfc: "\u{B10D}",
        nfd: "\u{1102}\u{1165}\u{11AC}",
        nfkc: "\u{B10D}",
        nfkd: "\u{1102}\u{1165}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B10E}",
        nfc: "\u{B10E}",
        nfd: "\u{1102}\u{1165}\u{11AD}",
        nfkc: "\u{B10E}",
        nfkd: "\u{1102}\u{1165}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B10F}",
        nfc: "\u{B10F}",
        nfd: "\u{1102}\u{1165}\u{11AE}",
        nfkc: "\u{B10F}",
        nfkd: "\u{1102}\u{1165}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B110}",
        nfc: "\u{B110}",
        nfd: "\u{1102}\u{1165}\u{11AF}",
        nfkc: "\u{B110}",
        nfkd: "\u{1102}\u{1165}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B111}",
        nfc: "\u{B111}",
        nfd: "\u{1102}\u{1165}\u{11B0}",
        nfkc: "\u{B111}",
        nfkd: "\u{1102}\u{1165}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B112}",
        nfc: "\u{B112}",
        nfd: "\u{1102}\u{1165}\u{11B1}",
        nfkc: "\u{B112}",
        nfkd: "\u{1102}\u{1165}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B113}",
        nfc: "\u{B113}",
        nfd: "\u{1102}\u{1165}\u{11B2}",
        nfkc: "\u{B113}",
        nfkd: "\u{1102}\u{1165}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B114}",
        nfc: "\u{B114}",
        nfd: "\u{1102}\u{1165}\u{11B3}",
        nfkc: "\u{B114}",
        nfkd: "\u{1102}\u{1165}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B115}",
        nfc: "\u{B115}",
        nfd: "\u{1102}\u{1165}\u{11B4}",
        nfkc: "\u{B115}",
        nfkd: "\u{1102}\u{1165}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B116}",
        nfc: "\u{B116}",
        nfd: "\u{1102}\u{1165}\u{11B5}",
        nfkc: "\u{B116}",
        nfkd: "\u{1102}\u{1165}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B117}",
        nfc: "\u{B117}",
        nfd: "\u{1102}\u{1165}\u{11B6}",
        nfkc: "\u{B117}",
        nfkd: "\u{1102}\u{1165}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B118}",
        nfc: "\u{B118}",
        nfd: "\u{1102}\u{1165}\u{11B7}",
        nfkc: "\u{B118}",
        nfkd: "\u{1102}\u{1165}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B119}",
        nfc: "\u{B119}",
        nfd: "\u{1102}\u{1165}\u{11B8}",
        nfkc: "\u{B119}",
        nfkd: "\u{1102}\u{1165}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B11A}",
        nfc: "\u{B11A}",
        nfd: "\u{1102}\u{1165}\u{11B9}",
        nfkc: "\u{B11A}",
        nfkd: "\u{1102}\u{1165}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B11B}",
        nfc: "\u{B11B}",
        nfd: "\u{1102}\u{1165}\u{11BA}",
        nfkc: "\u{B11B}",
        nfkd: "\u{1102}\u{1165}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B11C}",
        nfc: "\u{B11C}",
        nfd: "\u{1102}\u{1165}\u{11BB}",
        nfkc: "\u{B11C}",
        nfkd: "\u{1102}\u{1165}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B11D}",
        nfc: "\u{B11D}",
        nfd: "\u{1102}\u{1165}\u{11BC}",
        nfkc: "\u{B11D}",
        nfkd: "\u{1102}\u{1165}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B11E}",
        nfc: "\u{B11E}",
        nfd: "\u{1102}\u{1165}\u{11BD}",
        nfkc: "\u{B11E}",
        nfkd: "\u{1102}\u{1165}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B11F}",
        nfc: "\u{B11F}",
        nfd: "\u{1102}\u{1165}\u{11BE}",
        nfkc: "\u{B11F}",
        nfkd: "\u{1102}\u{1165}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B120}",
        nfc: "\u{B120}",
        nfd: "\u{1102}\u{1165}\u{11BF}",
        nfkc: "\u{B120}",
        nfkd: "\u{1102}\u{1165}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B121}",
        nfc: "\u{B121}",
        nfd: "\u{1102}\u{1165}\u{11C0}",
        nfkc: "\u{B121}",
        nfkd: "\u{1102}\u{1165}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B122}",
        nfc: "\u{B122}",
        nfd: "\u{1102}\u{1165}\u{11C1}",
        nfkc: "\u{B122}",
        nfkd: "\u{1102}\u{1165}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B123}",
        nfc: "\u{B123}",
        nfd: "\u{1102}\u{1165}\u{11C2}",
        nfkc: "\u{B123}",
        nfkd: "\u{1102}\u{1165}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B124}",
        nfc: "\u{B124}",
        nfd: "\u{1102}\u{1166}",
        nfkc: "\u{B124}",
        nfkd: "\u{1102}\u{1166}",
    },
    NormalizationTest {
        source: "\u{B125}",
        nfc: "\u{B125}",
        nfd: "\u{1102}\u{1166}\u{11A8}",
        nfkc: "\u{B125}",
        nfkd: "\u{1102}\u{1166}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B126}",
        nfc: "\u{B126}",
        nfd: "\u{1102}\u{1166}\u{11A9}",
        nfkc: "\u{B126}",
        nfkd: "\u{1102}\u{1166}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B127}",
        nfc: "\u{B127}",
        nfd: "\u{1102}\u{1166}\u{11AA}",
        nfkc: "\u{B127}",
        nfkd: "\u{1102}\u{1166}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B128}",
        nfc: "\u{B128}",
        nfd: "\u{1102}\u{1166}\u{11AB}",
        nfkc: "\u{B128}",
        nfkd: "\u{1102}\u{1166}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B129}",
        nfc: "\u{B129}",
        nfd: "\u{1102}\u{1166}\u{11AC}",
        nfkc: "\u{B129}",
        nfkd: "\u{1102}\u{1166}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B12A}",
        nfc: "\u{B12A}",
        nfd: "\u{1102}\u{1166}\u{11AD}",
        nfkc: "\u{B12A}",
        nfkd: "\u{1102}\u{1166}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B12B}",
        nfc: "\u{B12B}",
        nfd: "\u{1102}\u{1166}\u{11AE}",
        nfkc: "\u{B12B}",
        nfkd: "\u{1102}\u{1166}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B12C}",
        nfc: "\u{B12C}",
        nfd: "\u{1102}\u{1166}\u{11AF}",
        nfkc: "\u{B12C}",
        nfkd: "\u{1102}\u{1166}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B12D}",
        nfc: "\u{B12D}",
        nfd: "\u{1102}\u{1166}\u{11B0}",
        nfkc: "\u{B12D}",
        nfkd: "\u{1102}\u{1166}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B12E}",
        nfc: "\u{B12E}",
        nfd: "\u{1102}\u{1166}\u{11B1}",
        nfkc: "\u{B12E}",
        nfkd: "\u{1102}\u{1166}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B12F}",
        nfc: "\u{B12F}",
        nfd: "\u{1102}\u{1166}\u{11B2}",
        nfkc: "\u{B12F}",
        nfkd: "\u{1102}\u{1166}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B130}",
        nfc: "\u{B130}",
        nfd: "\u{1102}\u{1166}\u{11B3}",
        nfkc: "\u{B130}",
        nfkd: "\u{1102}\u{1166}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B131}",
        nfc: "\u{B131}",
        nfd: "\u{1102}\u{1166}\u{11B4}",
        nfkc: "\u{B131}",
        nfkd: "\u{1102}\u{1166}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B132}",
        nfc: "\u{B132}",
        nfd: "\u{1102}\u{1166}\u{11B5}",
        nfkc: "\u{B132}",
        nfkd: "\u{1102}\u{1166}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B133}",
        nfc: "\u{B133}",
        nfd: "\u{1102}\u{1166}\u{11B6}",
        nfkc: "\u{B133}",
        nfkd: "\u{1102}\u{1166}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B134}",
        nfc: "\u{B134}",
        nfd: "\u{1102}\u{1166}\u{11B7}",
        nfkc: "\u{B134}",
        nfkd: "\u{1102}\u{1166}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B135}",
        nfc: "\u{B135}",
        nfd: "\u{1102}\u{1166}\u{11B8}",
        nfkc: "\u{B135}",
        nfkd: "\u{1102}\u{1166}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B136}",
        nfc: "\u{B136}",
        nfd: "\u{1102}\u{1166}\u{11B9}",
        nfkc: "\u{B136}",
        nfkd: "\u{1102}\u{1166}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B137}",
        nfc: "\u{B137}",
        nfd: "\u{1102}\u{1166}\u{11BA}",
        nfkc: "\u{B137}",
        nfkd: "\u{1102}\u{1166}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B138}",
        nfc: "\u{B138}",
        nfd: "\u{1102}\u{1166}\u{11BB}",
        nfkc: "\u{B138}",
        nfkd: "\u{1102}\u{1166}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B139}",
        nfc: "\u{B139}",
        nfd: "\u{1102}\u{1166}\u{11BC}",
        nfkc: "\u{B139}",
        nfkd: "\u{1102}\u{1166}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B13A}",
        nfc: "\u{B13A}",
        nfd: "\u{1102}\u{1166}\u{11BD}",
        nfkc: "\u{B13A}",
        nfkd: "\u{1102}\u{1166}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B13B}",
        nfc: "\u{B13B}",
        nfd: "\u{1102}\u{1166}\u{11BE}",
        nfkc: "\u{B13B}",
        nfkd: "\u{1102}\u{1166}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B13C}",
        nfc: "\u{B13C}",
        nfd: "\u{1102}\u{1166}\u{11BF}",
        nfkc: "\u{B13C}",
        nfkd: "\u{1102}\u{1166}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B13D}",
        nfc: "\u{B13D}",
        nfd: "\u{1102}\u{1166}\u{11C0}",
        nfkc: "\u{B13D}",
        nfkd: "\u{1102}\u{1166}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B13E}",
        nfc: "\u{B13E}",
        nfd: "\u{1102}\u{1166}\u{11C1}",
        nfkc: "\u{B13E}",
        nfkd: "\u{1102}\u{1166}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B13F}",
        nfc: "\u{B13F}",
        nfd: "\u{1102}\u{1166}\u{11C2}",
        nfkc: "\u{B13F}",
        nfkd: "\u{1102}\u{1166}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B140}",
        nfc: "\u{B140}",
        nfd: "\u{1102}\u{1167}",
        nfkc: "\u{B140}",
        nfkd: "\u{1102}\u{1167}",
    },
    NormalizationTest {
        source: "\u{B141}",
        nfc: "\u{B141}",
        nfd: "\u{1102}\u{1167}\u{11A8}",
        nfkc: "\u{B141}",
        nfkd: "\u{1102}\u{1167}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B142}",
        nfc: "\u{B142}",
        nfd: "\u{1102}\u{1167}\u{11A9}",
        nfkc: "\u{B142}",
        nfkd: "\u{1102}\u{1167}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B143}",
        nfc: "\u{B143}",
        nfd: "\u{1102}\u{1167}\u{11AA}",
        nfkc: "\u{B143}",
        nfkd: "\u{1102}\u{1167}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B144}",
        nfc: "\u{B144}",
        nfd: "\u{1102}\u{1167}\u{11AB}",
        nfkc: "\u{B144}",
        nfkd: "\u{1102}\u{1167}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B145}",
        nfc: "\u{B145}",
        nfd: "\u{1102}\u{1167}\u{11AC}",
        nfkc: "\u{B145}",
        nfkd: "\u{1102}\u{1167}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B146}",
        nfc: "\u{B146}",
        nfd: "\u{1102}\u{1167}\u{11AD}",
        nfkc: "\u{B146}",
        nfkd: "\u{1102}\u{1167}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B147}",
        nfc: "\u{B147}",
        nfd: "\u{1102}\u{1167}\u{11AE}",
        nfkc: "\u{B147}",
        nfkd: "\u{1102}\u{1167}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B148}",
        nfc: "\u{B148}",
        nfd: "\u{1102}\u{1167}\u{11AF}",
        nfkc: "\u{B148}",
        nfkd: "\u{1102}\u{1167}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B149}",
        nfc: "\u{B149}",
        nfd: "\u{1102}\u{1167}\u{11B0}",
        nfkc: "\u{B149}",
        nfkd: "\u{1102}\u{1167}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B14A}",
        nfc: "\u{B14A}",
        nfd: "\u{1102}\u{1167}\u{11B1}",
        nfkc: "\u{B14A}",
        nfkd: "\u{1102}\u{1167}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B14B}",
        nfc: "\u{B14B}",
        nfd: "\u{1102}\u{1167}\u{11B2}",
        nfkc: "\u{B14B}",
        nfkd: "\u{1102}\u{1167}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B14C}",
        nfc: "\u{B14C}",
        nfd: "\u{1102}\u{1167}\u{11B3}",
        nfkc: "\u{B14C}",
        nfkd: "\u{1102}\u{1167}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B14D}",
        nfc: "\u{B14D}",
        nfd: "\u{1102}\u{1167}\u{11B4}",
        nfkc: "\u{B14D}",
        nfkd: "\u{1102}\u{1167}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B14E}",
        nfc: "\u{B14E}",
        nfd: "\u{1102}\u{1167}\u{11B5}",
        nfkc: "\u{B14E}",
        nfkd: "\u{1102}\u{1167}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B14F}",
        nfc: "\u{B14F}",
        nfd: "\u{1102}\u{1167}\u{11B6}",
        nfkc: "\u{B14F}",
        nfkd: "\u{1102}\u{1167}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B150}",
        nfc: "\u{B150}",
        nfd: "\u{1102}\u{1167}\u{11B7}",
        nfkc: "\u{B150}",
        nfkd: "\u{1102}\u{1167}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B151}",
        nfc: "\u{B151}",
        nfd: "\u{1102}\u{1167}\u{11B8}",
        nfkc: "\u{B151}",
        nfkd: "\u{1102}\u{1167}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B152}",
        nfc: "\u{B152}",
        nfd: "\u{1102}\u{1167}\u{11B9}",
        nfkc: "\u{B152}",
        nfkd: "\u{1102}\u{1167}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B153}",
        nfc: "\u{B153}",
        nfd: "\u{1102}\u{1167}\u{11BA}",
        nfkc: "\u{B153}",
        nfkd: "\u{1102}\u{1167}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B154}",
        nfc: "\u{B154}",
        nfd: "\u{1102}\u{1167}\u{11BB}",
        nfkc: "\u{B154}",
        nfkd: "\u{1102}\u{1167}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B155}",
        nfc: "\u{B155}",
        nfd: "\u{1102}\u{1167}\u{11BC}",
        nfkc: "\u{B155}",
        nfkd: "\u{1102}\u{1167}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B156}",
        nfc: "\u{B156}",
        nfd: "\u{1102}\u{1167}\u{11BD}",
        nfkc: "\u{B156}",
        nfkd: "\u{1102}\u{1167}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B157}",
        nfc: "\u{B157}",
        nfd: "\u{1102}\u{1167}\u{11BE}",
        nfkc: "\u{B157}",
        nfkd: "\u{1102}\u{1167}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B158}",
        nfc: "\u{B158}",
        nfd: "\u{1102}\u{1167}\u{11BF}",
        nfkc: "\u{B158}",
        nfkd: "\u{1102}\u{1167}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B159}",
        nfc: "\u{B159}",
        nfd: "\u{1102}\u{1167}\u{11C0}",
        nfkc: "\u{B159}",
        nfkd: "\u{1102}\u{1167}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B15A}",
        nfc: "\u{B15A}",
        nfd: "\u{1102}\u{1167}\u{11C1}",
        nfkc: "\u{B15A}",
        nfkd: "\u{1102}\u{1167}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B15B}",
        nfc: "\u{B15B}",
        nfd: "\u{1102}\u{1167}\u{11C2}",
        nfkc: "\u{B15B}",
        nfkd: "\u{1102}\u{1167}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B15C}",
        nfc: "\u{B15C}",
        nfd: "\u{1102}\u{1168}",
        nfkc: "\u{B15C}",
        nfkd: "\u{1102}\u{1168}",
    },
    NormalizationTest {
        source: "\u{B15D}",
        nfc: "\u{B15D}",
        nfd: "\u{1102}\u{1168}\u{11A8}",
        nfkc: "\u{B15D}",
        nfkd: "\u{1102}\u{1168}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B15E}",
        nfc: "\u{B15E}",
        nfd: "\u{1102}\u{1168}\u{11A9}",
        nfkc: "\u{B15E}",
        nfkd: "\u{1102}\u{1168}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B15F}",
        nfc: "\u{B15F}",
        nfd: "\u{1102}\u{1168}\u{11AA}",
        nfkc: "\u{B15F}",
        nfkd: "\u{1102}\u{1168}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B160}",
        nfc: "\u{B160}",
        nfd: "\u{1102}\u{1168}\u{11AB}",
        nfkc: "\u{B160}",
        nfkd: "\u{1102}\u{1168}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B161}",
        nfc: "\u{B161}",
        nfd: "\u{1102}\u{1168}\u{11AC}",
        nfkc: "\u{B161}",
        nfkd: "\u{1102}\u{1168}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B162}",
        nfc: "\u{B162}",
        nfd: "\u{1102}\u{1168}\u{11AD}",
        nfkc: "\u{B162}",
        nfkd: "\u{1102}\u{1168}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B163}",
        nfc: "\u{B163}",
        nfd: "\u{1102}\u{1168}\u{11AE}",
        nfkc: "\u{B163}",
        nfkd: "\u{1102}\u{1168}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B164}",
        nfc: "\u{B164}",
        nfd: "\u{1102}\u{1168}\u{11AF}",
        nfkc: "\u{B164}",
        nfkd: "\u{1102}\u{1168}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B165}",
        nfc: "\u{B165}",
        nfd: "\u{1102}\u{1168}\u{11B0}",
        nfkc: "\u{B165}",
        nfkd: "\u{1102}\u{1168}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B166}",
        nfc: "\u{B166}",
        nfd: "\u{1102}\u{1168}\u{11B1}",
        nfkc: "\u{B166}",
        nfkd: "\u{1102}\u{1168}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B167}",
        nfc: "\u{B167}",
        nfd: "\u{1102}\u{1168}\u{11B2}",
        nfkc: "\u{B167}",
        nfkd: "\u{1102}\u{1168}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B168}",
        nfc: "\u{B168}",
        nfd: "\u{1102}\u{1168}\u{11B3}",
        nfkc: "\u{B168}",
        nfkd: "\u{1102}\u{1168}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B169}",
        nfc: "\u{B169}",
        nfd: "\u{1102}\u{1168}\u{11B4}",
        nfkc: "\u{B169}",
        nfkd: "\u{1102}\u{1168}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B16A}",
        nfc: "\u{B16A}",
        nfd: "\u{1102}\u{1168}\u{11B5}",
        nfkc: "\u{B16A}",
        nfkd: "\u{1102}\u{1168}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B16B}",
        nfc: "\u{B16B}",
        nfd: "\u{1102}\u{1168}\u{11B6}",
        nfkc: "\u{B16B}",
        nfkd: "\u{1102}\u{1168}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B16C}",
        nfc: "\u{B16C}",
        nfd: "\u{1102}\u{1168}\u{11B7}",
        nfkc: "\u{B16C}",
        nfkd: "\u{1102}\u{1168}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B16D}",
        nfc: "\u{B16D}",
        nfd: "\u{1102}\u{1168}\u{11B8}",
        nfkc: "\u{B16D}",
        nfkd: "\u{1102}\u{1168}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B16E}",
        nfc: "\u{B16E}",
        nfd: "\u{1102}\u{1168}\u{11B9}",
        nfkc: "\u{B16E}",
        nfkd: "\u{1102}\u{1168}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B16F}",
        nfc: "\u{B16F}",
        nfd: "\u{1102}\u{1168}\u{11BA}",
        nfkc: "\u{B16F}",
        nfkd: "\u{1102}\u{1168}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B170}",
        nfc: "\u{B170}",
        nfd: "\u{1102}\u{1168}\u{11BB}",
        nfkc: "\u{B170}",
        nfkd: "\u{1102}\u{1168}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B171}",
        nfc: "\u{B171}",
        nfd: "\u{1102}\u{1168}\u{11BC}",
        nfkc: "\u{B171}",
        nfkd: "\u{1102}\u{1168}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B172}",
        nfc: "\u{B172}",
        nfd: "\u{1102}\u{1168}\u{11BD}",
        nfkc: "\u{B172}",
        nfkd: "\u{1102}\u{1168}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B173}",
        nfc: "\u{B173}",
        nfd: "\u{1102}\u{1168}\u{11BE}",
        nfkc: "\u{B173}",
        nfkd: "\u{1102}\u{1168}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B174}",
        nfc: "\u{B174}",
        nfd: "\u{1102}\u{1168}\u{11BF}",
        nfkc: "\u{B174}",
        nfkd: "\u{1102}\u{1168}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B175}",
        nfc: "\u{B175}",
        nfd: "\u{1102}\u{1168}\u{11C0}",
        nfkc: "\u{B175}",
        nfkd: "\u{1102}\u{1168}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B176}",
        nfc: "\u{B176}",
        nfd: "\u{1102}\u{1168}\u{11C1}",
        nfkc: "\u{B176}",
        nfkd: "\u{1102}\u{1168}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B177}",
        nfc: "\u{B177}",
        nfd: "\u{1102}\u{1168}\u{11C2}",
        nfkc: "\u{B177}",
        nfkd: "\u{1102}\u{1168}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B178}",
        nfc: "\u{B178}",
        nfd: "\u{1102}\u{1169}",
        nfkc: "\u{B178}",
        nfkd: "\u{1102}\u{1169}",
    },
    NormalizationTest {
        source: "\u{B179}",
        nfc: "\u{B179}",
        nfd: "\u{1102}\u{1169}\u{11A8}",
        nfkc: "\u{B179}",
        nfkd: "\u{1102}\u{1169}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B17A}",
        nfc: "\u{B17A}",
        nfd: "\u{1102}\u{1169}\u{11A9}",
        nfkc: "\u{B17A}",
        nfkd: "\u{1102}\u{1169}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B17B}",
        nfc: "\u{B17B}",
        nfd: "\u{1102}\u{1169}\u{11AA}",
        nfkc: "\u{B17B}",
        nfkd: "\u{1102}\u{1169}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B17C}",
        nfc: "\u{B17C}",
        nfd: "\u{1102}\u{1169}\u{11AB}",
        nfkc: "\u{B17C}",
        nfkd: "\u{1102}\u{1169}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B17D}",
        nfc: "\u{B17D}",
        nfd: "\u{1102}\u{1169}\u{11AC}",
        nfkc: "\u{B17D}",
        nfkd: "\u{1102}\u{1169}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B17E}",
        nfc: "\u{B17E}",
        nfd: "\u{1102}\u{1169}\u{11AD}",
        nfkc: "\u{B17E}",
        nfkd: "\u{1102}\u{1169}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B17F}",
        nfc: "\u{B17F}",
        nfd: "\u{1102}\u{1169}\u{11AE}",
        nfkc: "\u{B17F}",
        nfkd: "\u{1102}\u{1169}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B180}",
        nfc: "\u{B180}",
        nfd: "\u{1102}\u{1169}\u{11AF}",
        nfkc: "\u{B180}",
        nfkd: "\u{1102}\u{1169}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B181}",
        nfc: "\u{B181}",
        nfd: "\u{1102}\u{1169}\u{11B0}",
        nfkc: "\u{B181}",
        nfkd: "\u{1102}\u{1169}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B182}",
        nfc: "\u{B182}",
        nfd: "\u{1102}\u{1169}\u{11B1}",
        nfkc: "\u{B182}",
        nfkd: "\u{1102}\u{1169}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B183}",
        nfc: "\u{B183}",
        nfd: "\u{1102}\u{1169}\u{11B2}",
        nfkc: "\u{B183}",
        nfkd: "\u{1102}\u{1169}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B184}",
        nfc: "\u{B184}",
        nfd: "\u{1102}\u{1169}\u{11B3}",
        nfkc: "\u{B184}",
        nfkd: "\u{1102}\u{1169}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B185}",
        nfc: "\u{B185}",
        nfd: "\u{1102}\u{1169}\u{11B4}",
        nfkc: "\u{B185}",
        nfkd: "\u{1102}\u{1169}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B186}",
        nfc: "\u{B186}",
        nfd: "\u{1102}\u{1169}\u{11B5}",
        nfkc: "\u{B186}",
        nfkd: "\u{1102}\u{1169}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B187}",
        nfc: "\u{B187}",
        nfd: "\u{1102}\u{1169}\u{11B6}",
        nfkc: "\u{B187}",
        nfkd: "\u{1102}\u{1169}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B188}",
        nfc: "\u{B188}",
        nfd: "\u{1102}\u{1169}\u{11B7}",
        nfkc: "\u{B188}",
        nfkd: "\u{1102}\u{1169}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B189}",
        nfc: "\u{B189}",
        nfd: "\u{1102}\u{1169}\u{11B8}",
        nfkc: "\u{B189}",
        nfkd: "\u{1102}\u{1169}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B18A}",
        nfc: "\u{B18A}",
        nfd: "\u{1102}\u{1169}\u{11B9}",
        nfkc: "\u{B18A}",
        nfkd: "\u{1102}\u{1169}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B18B}",
        nfc: "\u{B18B}",
        nfd: "\u{1102}\u{1169}\u{11BA}",
        nfkc: "\u{B18B}",
        nfkd: "\u{1102}\u{1169}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B18C}",
        nfc: "\u{B18C}",
        nfd: "\u{1102}\u{1169}\u{11BB}",
        nfkc: "\u{B18C}",
        nfkd: "\u{1102}\u{1169}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B18D}",
        nfc: "\u{B18D}",
        nfd: "\u{1102}\u{1169}\u{11BC}",
        nfkc: "\u{B18D}",
        nfkd: "\u{1102}\u{1169}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B18E}",
        nfc: "\u{B18E}",
        nfd: "\u{1102}\u{1169}\u{11BD}",
        nfkc: "\u{B18E}",
        nfkd: "\u{1102}\u{1169}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B18F}",
        nfc: "\u{B18F}",
        nfd: "\u{1102}\u{1169}\u{11BE}",
        nfkc: "\u{B18F}",
        nfkd: "\u{1102}\u{1169}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B190}",
        nfc: "\u{B190}",
        nfd: "\u{1102}\u{1169}\u{11BF}",
        nfkc: "\u{B190}",
        nfkd: "\u{1102}\u{1169}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B191}",
        nfc: "\u{B191}",
        nfd: "\u{1102}\u{1169}\u{11C0}",
        nfkc: "\u{B191}",
        nfkd: "\u{1102}\u{1169}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B192}",
        nfc: "\u{B192}",
        nfd: "\u{1102}\u{1169}\u{11C1}",
        nfkc: "\u{B192}",
        nfkd: "\u{1102}\u{1169}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B193}",
        nfc: "\u{B193}",
        nfd: "\u{1102}\u{1169}\u{11C2}",
        nfkc: "\u{B193}",
        nfkd: "\u{1102}\u{1169}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B194}",
        nfc: "\u{B194}",
        nfd: "\u{1102}\u{116A}",
        nfkc: "\u{B194}",
        nfkd: "\u{1102}\u{116A}",
    },
    NormalizationTest {
        source: "\u{B195}",
        nfc: "\u{B195}",
        nfd: "\u{1102}\u{116A}\u{11A8}",
        nfkc: "\u{B195}",
        nfkd: "\u{1102}\u{116A}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B196}",
        nfc: "\u{B196}",
        nfd: "\u{1102}\u{116A}\u{11A9}",
        nfkc: "\u{B196}",
        nfkd: "\u{1102}\u{116A}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B197}",
        nfc: "\u{B197}",
        nfd: "\u{1102}\u{116A}\u{11AA}",
        nfkc: "\u{B197}",
        nfkd: "\u{1102}\u{116A}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B198}",
        nfc: "\u{B198}",
        nfd: "\u{1102}\u{116A}\u{11AB}",
        nfkc: "\u{B198}",
        nfkd: "\u{1102}\u{116A}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B199}",
        nfc: "\u{B199}",
        nfd: "\u{1102}\u{116A}\u{11AC}",
        nfkc: "\u{B199}",
        nfkd: "\u{1102}\u{116A}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B19A}",
        nfc: "\u{B19A}",
        nfd: "\u{1102}\u{116A}\u{11AD}",
        nfkc: "\u{B19A}",
        nfkd: "\u{1102}\u{116A}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B19B}",
        nfc: "\u{B19B}",
        nfd: "\u{1102}\u{116A}\u{11AE}",
        nfkc: "\u{B19B}",
        nfkd: "\u{1102}\u{116A}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B19C}",
        nfc: "\u{B19C}",
        nfd: "\u{1102}\u{116A}\u{11AF}",
        nfkc: "\u{B19C}",
        nfkd: "\u{1102}\u{116A}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B19D}",
        nfc: "\u{B19D}",
        nfd: "\u{1102}\u{116A}\u{11B0}",
        nfkc: "\u{B19D}",
        nfkd: "\u{1102}\u{116A}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B19E}",
        nfc: "\u{B19E}",
        nfd: "\u{1102}\u{116A}\u{11B1}",
        nfkc: "\u{B19E}",
        nfkd: "\u{1102}\u{116A}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B19F}",
        nfc: "\u{B19F}",
        nfd: "\u{1102}\u{116A}\u{11B2}",
        nfkc: "\u{B19F}",
        nfkd: "\u{1102}\u{116A}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B1A0}",
        nfc: "\u{B1A0}",
        nfd: "\u{1102}\u{116A}\u{11B3}",
        nfkc: "\u{B1A0}",
        nfkd: "\u{1102}\u{116A}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B1A1}",
        nfc: "\u{B1A1}",
        nfd: "\u{1102}\u{116A}\u{11B4}",
        nfkc: "\u{B1A1}",
        nfkd: "\u{1102}\u{116A}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B1A2}",
        nfc: "\u{B1A2}",
        nfd: "\u{1102}\u{116A}\u{11B5}",
        nfkc: "\u{B1A2}",
        nfkd: "\u{1102}\u{116A}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B1A3}",
        nfc: "\u{B1A3}",
        nfd: "\u{1102}\u{116A}\u{11B6}",
        nfkc: "\u{B1A3}",
        nfkd: "\u{1102}\u{116A}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B1A4}",
        nfc: "\u{B1A4}",
        nfd: "\u{1102}\u{116A}\u{11B7}",
        nfkc: "\u{B1A4}",
        nfkd: "\u{1102}\u{116A}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B1A5}",
        nfc: "\u{B1A5}",
        nfd: "\u{1102}\u{116A}\u{11B8}",
        nfkc: "\u{B1A5}",
        nfkd: "\u{1102}\u{116A}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B1A6}",
        nfc: "\u{B1A6}",
        nfd: "\u{1102}\u{116A}\u{11B9}",
        nfkc: "\u{B1A6}",
        nfkd: "\u{1102}\u{116A}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B1A7}",
        nfc: "\u{B1A7}",
        nfd: "\u{1102}\u{116A}\u{11BA}",
        nfkc: "\u{B1A7}",
        nfkd: "\u{1102}\u{116A}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B1A8}",
        nfc: "\u{B1A8}",
        nfd: "\u{1102}\u{116A}\u{11BB}",
        nfkc: "\u{B1A8}",
        nfkd: "\u{1102}\u{116A}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B1A9}",
        nfc: "\u{B1A9}",
        nfd: "\u{1102}\u{116A}\u{11BC}",
        nfkc: "\u{B1A9}",
        nfkd: "\u{1102}\u{116A}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B1AA}",
        nfc: "\u{B1AA}",
        nfd: "\u{1102}\u{116A}\u{11BD}",
        nfkc: "\u{B1AA}",
        nfkd: "\u{1102}\u{116A}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B1AB}",
        nfc: "\u{B1AB}",
        nfd: "\u{1102}\u{116A}\u{11BE}",
        nfkc: "\u{B1AB}",
        nfkd: "\u{1102}\u{116A}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B1AC}",
        nfc: "\u{B1AC}",
        nfd: "\u{1102}\u{116A}\u{11BF}",
        nfkc: "\u{B1AC}",
        nfkd: "\u{1102}\u{116A}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B1AD}",
        nfc: "\u{B1AD}",
        nfd: "\u{1102}\u{116A}\u{11C0}",
        nfkc: "\u{B1AD}",
        nfkd: "\u{1102}\u{116A}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B1AE}",
        nfc: "\u{B1AE}",
        nfd: "\u{1102}\u{116A}\u{11C1}",
        nfkc: "\u{B1AE}",
        nfkd: "\u{1102}\u{116A}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B1AF}",
        nfc: "\u{B1AF}",
        nfd: "\u{1102}\u{116A}\u{11C2}",
        nfkc: "\u{B1AF}",
        nfkd: "\u{1102}\u{116A}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B1B0}",
        nfc: "\u{B1B0}",
        nfd: "\u{1102}\u{116B}",
        nfkc: "\u{B1B0}",
        nfkd: "\u{1102}\u{116B}",
    },
    NormalizationTest {
        source: "\u{B1B1}",
        nfc: "\u{B1B1}",
        nfd: "\u{1102}\u{116B}\u{11A8}",
        nfkc: "\u{B1B1}",
        nfkd: "\u{1102}\u{116B}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B1B2}",
        nfc: "\u{B1B2}",
        nfd: "\u{1102}\u{116B}\u{11A9}",
        nfkc: "\u{B1B2}",
        nfkd: "\u{1102}\u{116B}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B1B3}",
        nfc: "\u{B1B3}",
        nfd: "\u{1102}\u{116B}\u{11AA}",
        nfkc: "\u{B1B3}",
        nfkd: "\u{1102}\u{116B}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B1B4}",
        nfc: "\u{B1B4}",
        nfd: "\u{1102}\u{116B}\u{11AB}",
        nfkc: "\u{B1B4}",
        nfkd: "\u{1102}\u{116B}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B1B5}",
        nfc: "\u{B1B5}",
        nfd: "\u{1102}\u{116B}\u{11AC}",
        nfkc: "\u{B1B5}",
        nfkd: "\u{1102}\u{116B}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B1B6}",
        nfc: "\u{B1B6}",
        nfd: "\u{1102}\u{116B}\u{11AD}",
        nfkc: "\u{B1B6}",
        nfkd: "\u{1102}\u{116B}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B1B7}",
        nfc: "\u{B1B7}",
        nfd: "\u{1102}\u{116B}\u{11AE}",
        nfkc: "\u{B1B7}",
        nfkd: "\u{1102}\u{116B}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B1B8}",
        nfc: "\u{B1B8}",
        nfd: "\u{1102}\u{116B}\u{11AF}",
        nfkc: "\u{B1B8}",
        nfkd: "\u{1102}\u{116B}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B1B9}",
        nfc: "\u{B1B9}",
        nfd: "\u{1102}\u{116B}\u{11B0}",
        nfkc: "\u{B1B9}",
        nfkd: "\u{1102}\u{116B}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B1BA}",
        nfc: "\u{B1BA}",
        nfd: "\u{1102}\u{116B}\u{11B1}",
        nfkc: "\u{B1BA}",
        nfkd: "\u{1102}\u{116B}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B1BB}",
        nfc: "\u{B1BB}",
        nfd: "\u{1102}\u{116B}\u{11B2}",
        nfkc: "\u{B1BB}",
        nfkd: "\u{1102}\u{116B}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B1BC}",
        nfc: "\u{B1BC}",
        nfd: "\u{1102}\u{116B}\u{11B3}",
        nfkc: "\u{B1BC}",
        nfkd: "\u{1102}\u{116B}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B1BD}",
        nfc: "\u{B1BD}",
        nfd: "\u{1102}\u{116B}\u{11B4}",
        nfkc: "\u{B1BD}",
        nfkd: "\u{1102}\u{116B}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B1BE}",
        nfc: "\u{B1BE}",
        nfd: "\u{1102}\u{116B}\u{11B5}",
        nfkc: "\u{B1BE}",
        nfkd: "\u{1102}\u{116B}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B1BF}",
        nfc: "\u{B1BF}",
        nfd: "\u{1102}\u{116B}\u{11B6}",
        nfkc: "\u{B1BF}",
        nfkd: "\u{1102}\u{116B}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B1C0}",
        nfc: "\u{B1C0}",
        nfd: "\u{1102}\u{116B}\u{11B7}",
        nfkc: "\u{B1C0}",
        nfkd: "\u{1102}\u{116B}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B1C1}",
        nfc: "\u{B1C1}",
        nfd: "\u{1102}\u{116B}\u{11B8}",
        nfkc: "\u{B1C1}",
        nfkd: "\u{1102}\u{116B}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B1C2}",
        nfc: "\u{B1C2}",
        nfd: "\u{1102}\u{116B}\u{11B9}",
        nfkc: "\u{B1C2}",
        nfkd: "\u{1102}\u{116B}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B1C3}",
        nfc: "\u{B1C3}",
        nfd: "\u{1102}\u{116B}\u{11BA}",
        nfkc: "\u{B1C3}",
        nfkd: "\u{1102}\u{116B}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B1C4}",
        nfc: "\u{B1C4}",
        nfd: "\u{1102}\u{116B}\u{11BB}",
        nfkc: "\u{B1C4}",
        nfkd: "\u{1102}\u{116B}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B1C5}",
        nfc: "\u{B1C5}",
        nfd: "\u{1102}\u{116B}\u{11BC}",
        nfkc: "\u{B1C5}",
        nfkd: "\u{1102}\u{116B}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B1C6}",
        nfc: "\u{B1C6}",
        nfd: "\u{1102}\u{116B}\u{11BD}",
        nfkc: "\u{B1C6}",
        nfkd: "\u{1102}\u{116B}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B1C7}",
        nfc: "\u{B1C7}",
        nfd: "\u{1102}\u{116B}\u{11BE}",
        nfkc: "\u{B1C7}",
        nfkd: "\u{1102}\u{116B}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B1C8}",
        nfc: "\u{B1C8}",
        nfd: "\u{1102}\u{116B}\u{11BF}",
        nfkc: "\u{B1C8}",
        nfkd: "\u{1102}\u{116B}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B1C9}",
        nfc: "\u{B1C9}",
        nfd: "\u{1102}\u{116B}\u{11C0}",
        nfkc: "\u{B1C9}",
        nfkd: "\u{1102}\u{116B}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B1CA}",
        nfc: "\u{B1CA}",
        nfd: "\u{1102}\u{116B}\u{11C1}",
        nfkc: "\u{B1CA}",
        nfkd: "\u{1102}\u{116B}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B1CB}",
        nfc: "\u{B1CB}",
        nfd: "\u{1102}\u{116B}\u{11C2}",
        nfkc: "\u{B1CB}",
        nfkd: "\u{1102}\u{116B}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B1CC}",
        nfc: "\u{B1CC}",
        nfd: "\u{1102}\u{116C}",
        nfkc: "\u{B1CC}",
        nfkd: "\u{1102}\u{116C}",
    },
    NormalizationTest {
        source: "\u{B1CD}",
        nfc: "\u{B1CD}",
        nfd: "\u{1102}\u{116C}\u{11A8}",
        nfkc: "\u{B1CD}",
        nfkd: "\u{1102}\u{116C}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B1CE}",
        nfc: "\u{B1CE}",
        nfd: "\u{1102}\u{116C}\u{11A9}",
        nfkc: "\u{B1CE}",
        nfkd: "\u{1102}\u{116C}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B1CF}",
        nfc: "\u{B1CF}",
        nfd: "\u{1102}\u{116C}\u{11AA}",
        nfkc: "\u{B1CF}",
        nfkd: "\u{1102}\u{116C}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B1D0}",
        nfc: "\u{B1D0}",
        nfd: "\u{1102}\u{116C}\u{11AB}",
        nfkc: "\u{B1D0}",
        nfkd: "\u{1102}\u{116C}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B1D1}",
        nfc: "\u{B1D1}",
        nfd: "\u{1102}\u{116C}\u{11AC}",
        nfkc: "\u{B1D1}",
        nfkd: "\u{1102}\u{116C}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B1D2}",
        nfc: "\u{B1D2}",
        nfd: "\u{1102}\u{116C}\u{11AD}",
        nfkc: "\u{B1D2}",
        nfkd: "\u{1102}\u{116C}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B1D3}",
        nfc: "\u{B1D3}",
        nfd: "\u{1102}\u{116C}\u{11AE}",
        nfkc: "\u{B1D3}",
        nfkd: "\u{1102}\u{116C}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B1D4}",
        nfc: "\u{B1D4}",
        nfd: "\u{1102}\u{116C}\u{11AF}",
        nfkc: "\u{B1D4}",
        nfkd: "\u{1102}\u{116C}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B1D5}",
        nfc: "\u{B1D5}",
        nfd: "\u{1102}\u{116C}\u{11B0}",
        nfkc: "\u{B1D5}",
        nfkd: "\u{1102}\u{116C}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B1D6}",
        nfc: "\u{B1D6}",
        nfd: "\u{1102}\u{116C}\u{11B1}",
        nfkc: "\u{B1D6}",
        nfkd: "\u{1102}\u{116C}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B1D7}",
        nfc: "\u{B1D7}",
        nfd: "\u{1102}\u{116C}\u{11B2}",
        nfkc: "\u{B1D7}",
        nfkd: "\u{1102}\u{116C}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B1D8}",
        nfc: "\u{B1D8}",
        nfd: "\u{1102}\u{116C}\u{11B3}",
        nfkc: "\u{B1D8}",
        nfkd: "\u{1102}\u{116C}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B1D9}",
        nfc: "\u{B1D9}",
        nfd: "\u{1102}\u{116C}\u{11B4}",
        nfkc: "\u{B1D9}",
        nfkd: "\u{1102}\u{116C}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B1DA}",
        nfc: "\u{B1DA}",
        nfd: "\u{1102}\u{116C}\u{11B5}",
        nfkc: "\u{B1DA}",
        nfkd: "\u{1102}\u{116C}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B1DB}",
        nfc: "\u{B1DB}",
        nfd: "\u{1102}\u{116C}\u{11B6}",
        nfkc: "\u{B1DB}",
        nfkd: "\u{1102}\u{116C}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B1DC}",
        nfc: "\u{B1DC}",
        nfd: "\u{1102}\u{116C}\u{11B7}",
        nfkc: "\u{B1DC}",
        nfkd: "\u{1102}\u{116C}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B1DD}",
        nfc: "\u{B1DD}",
        nfd: "\u{1102}\u{116C}\u{11B8}",
        nfkc: "\u{B1DD}",
        nfkd: "\u{1102}\u{116C}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B1DE}",
        nfc: "\u{B1DE}",
        nfd: "\u{1102}\u{116C}\u{11B9}",
        nfkc: "\u{B1DE}",
        nfkd: "\u{1102}\u{116C}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B1DF}",
        nfc: "\u{B1DF}",
        nfd: "\u{1102}\u{116C}\u{11BA}",
        nfkc: "\u{B1DF}",
        nfkd: "\u{1102}\u{116C}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B1E0}",
        nfc: "\u{B1E0}",
        nfd: "\u{1102}\u{116C}\u{11BB}",
        nfkc: "\u{B1E0}",
        nfkd: "\u{1102}\u{116C}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B1E1}",
        nfc: "\u{B1E1}",
        nfd: "\u{1102}\u{116C}\u{11BC}",
        nfkc: "\u{B1E1}",
        nfkd: "\u{1102}\u{116C}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B1E2}",
        nfc: "\u{B1E2}",
        nfd: "\u{1102}\u{116C}\u{11BD}",
        nfkc: "\u{B1E2}",
        nfkd: "\u{1102}\u{116C}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B1E3}",
        nfc: "\u{B1E3}",
        nfd: "\u{1102}\u{116C}\u{11BE}",
        nfkc: "\u{B1E3}",
        nfkd: "\u{1102}\u{116C}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B1E4}",
        nfc: "\u{B1E4}",
        nfd: "\u{1102}\u{116C}\u{11BF}",
        nfkc: "\u{B1E4}",
        nfkd: "\u{1102}\u{116C}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B1E5}",
        nfc: "\u{B1E5}",
        nfd: "\u{1102}\u{116C}\u{11C0}",
        nfkc: "\u{B1E5}",
        nfkd: "\u{1102}\u{116C}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B1E6}",
        nfc: "\u{B1E6}",
        nfd: "\u{1102}\u{116C}\u{11C1}",
        nfkc: "\u{B1E6}",
        nfkd: "\u{1102}\u{116C}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B1E7}",
        nfc: "\u{B1E7}",
        nfd: "\u{1102}\u{116C}\u{11C2}",
        nfkc: "\u{B1E7}",
        nfkd: "\u{1102}\u{116C}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B1E8}",
        nfc: "\u{B1E8}",
        nfd: "\u{1102}\u{116D}",
        nfkc: "\u{B1E8}",
        nfkd: "\u{1102}\u{116D}",
    },
    NormalizationTest {
        source: "\u{B1E9}",
        nfc: "\u{B1E9}",
        nfd: "\u{1102}\u{116D}\u{11A8}",
        nfkc: "\u{B1E9}",
        nfkd: "\u{1102}\u{116D}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B1EA}",
        nfc: "\u{B1EA}",
        nfd: "\u{1102}\u{116D}\u{11A9}",
        nfkc: "\u{B1EA}",
        nfkd: "\u{1102}\u{116D}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B1EB}",
        nfc: "\u{B1EB}",
        nfd: "\u{1102}\u{116D}\u{11AA}",
        nfkc: "\u{B1EB}",
        nfkd: "\u{1102}\u{116D}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B1EC}",
        nfc: "\u{B1EC}",
        nfd: "\u{1102}\u{116D}\u{11AB}",
        nfkc: "\u{B1EC}",
        nfkd: "\u{1102}\u{116D}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B1ED}",
        nfc: "\u{B1ED}",
        nfd: "\u{1102}\u{116D}\u{11AC}",
        nfkc: "\u{B1ED}",
        nfkd: "\u{1102}\u{116D}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B1EE}",
        nfc: "\u{B1EE}",
        nfd: "\u{1102}\u{116D}\u{11AD}",
        nfkc: "\u{B1EE}",
        nfkd: "\u{1102}\u{116D}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B1EF}",
        nfc: "\u{B1EF}",
        nfd: "\u{1102}\u{116D}\u{11AE}",
        nfkc: "\u{B1EF}",
        nfkd: "\u{1102}\u{116D}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B1F0}",
        nfc: "\u{B1F0}",
        nfd: "\u{1102}\u{116D}\u{11AF}",
        nfkc: "\u{B1F0}",
        nfkd: "\u{1102}\u{116D}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B1F1}",
        nfc: "\u{B1F1}",
        nfd: "\u{1102}\u{116D}\u{11B0}",
        nfkc: "\u{B1F1}",
        nfkd: "\u{1102}\u{116D}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B1F2}",
        nfc: "\u{B1F2}",
        nfd: "\u{1102}\u{116D}\u{11B1}",
        nfkc: "\u{B1F2}",
        nfkd: "\u{1102}\u{116D}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B1F3}",
        nfc: "\u{B1F3}",
        nfd: "\u{1102}\u{116D}\u{11B2}",
        nfkc: "\u{B1F3}",
        nfkd: "\u{1102}\u{116D}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B1F4}",
        nfc: "\u{B1F4}",
        nfd: "\u{1102}\u{116D}\u{11B3}",
        nfkc: "\u{B1F4}",
        nfkd: "\u{1102}\u{116D}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B1F5}",
        nfc: "\u{B1F5}",
        nfd: "\u{1102}\u{116D}\u{11B4}",
        nfkc: "\u{B1F5}",
        nfkd: "\u{1102}\u{116D}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B1F6}",
        nfc: "\u{B1F6}",
        nfd: "\u{1102}\u{116D}\u{11B5}",
        nfkc: "\u{B1F6}",
        nfkd: "\u{1102}\u{116D}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B1F7}",
        nfc: "\u{B1F7}",
        nfd: "\u{1102}\u{116D}\u{11B6}",
        nfkc: "\u{B1F7}",
        nfkd: "\u{1102}\u{116D}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B1F8}",
        nfc: "\u{B1F8}",
        nfd: "\u{1102}\u{116D}\u{11B7}",
        nfkc: "\u{B1F8}",
        nfkd: "\u{1102}\u{116D}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B1F9}",
        nfc: "\u{B1F9}",
        nfd: "\u{1102}\u{116D}\u{11B8}",
        nfkc: "\u{B1F9}",
        nfkd: "\u{1102}\u{116D}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B1FA}",
        nfc: "\u{B1FA}",
        nfd: "\u{1102}\u{116D}\u{11B9}",
        nfkc: "\u{B1FA}",
        nfkd: "\u{1102}\u{116D}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B1FB}",
        nfc: "\u{B1FB}",
        nfd: "\u{1102}\u{116D}\u{11BA}",
        nfkc: "\u{B1FB}",
        nfkd: "\u{1102}\u{116D}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B1FC}",
        nfc: "\u{B1FC}",
        nfd: "\u{1102}\u{116D}\u{11BB}",
        nfkc: "\u{B1FC}",
        nfkd: "\u{1102}\u{116D}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B1FD}",
        nfc: "\u{B1FD}",
        nfd: "\u{1102}\u{116D}\u{11BC}",
        nfkc: "\u{B1FD}",
        nfkd: "\u{1102}\u{116D}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B1FE}",
        nfc: "\u{B1FE}",
        nfd: "\u{1102}\u{116D}\u{11BD}",
        nfkc: "\u{B1FE}",
        nfkd: "\u{1102}\u{116D}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B1FF}",
        nfc: "\u{B1FF}",
        nfd: "\u{1102}\u{116D}\u{11BE}",
        nfkc: "\u{B1FF}",
        nfkd: "\u{1102}\u{116D}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B200}",
        nfc: "\u{B200}",
        nfd: "\u{1102}\u{116D}\u{11BF}",
        nfkc: "\u{B200}",
        nfkd: "\u{1102}\u{116D}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B201}",
        nfc: "\u{B201}",
        nfd: "\u{1102}\u{116D}\u{11C0}",
        nfkc: "\u{B201}",
        nfkd: "\u{1102}\u{116D}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B202}",
        nfc: "\u{B202}",
        nfd: "\u{1102}\u{116D}\u{11C1}",
        nfkc: "\u{B202}",
        nfkd: "\u{1102}\u{116D}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B203}",
        nfc: "\u{B203}",
        nfd: "\u{1102}\u{116D}\u{11C2}",
        nfkc: "\u{B203}",
        nfkd: "\u{1102}\u{116D}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B204}",
        nfc: "\u{B204}",
        nfd: "\u{1102}\u{116E}",
        nfkc: "\u{B204}",
        nfkd: "\u{1102}\u{116E}",
    },
    NormalizationTest {
        source: "\u{B205}",
        nfc: "\u{B205}",
        nfd: "\u{1102}\u{116E}\u{11A8}",
        nfkc: "\u{B205}",
        nfkd: "\u{1102}\u{116E}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B206}",
        nfc: "\u{B206}",
        nfd: "\u{1102}\u{116E}\u{11A9}",
        nfkc: "\u{B206}",
        nfkd: "\u{1102}\u{116E}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B207}",
        nfc: "\u{B207}",
        nfd: "\u{1102}\u{116E}\u{11AA}",
        nfkc: "\u{B207}",
        nfkd: "\u{1102}\u{116E}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B208}",
        nfc: "\u{B208}",
        nfd: "\u{1102}\u{116E}\u{11AB}",
        nfkc: "\u{B208}",
        nfkd: "\u{1102}\u{116E}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B209}",
        nfc: "\u{B209}",
        nfd: "\u{1102}\u{116E}\u{11AC}",
        nfkc: "\u{B209}",
        nfkd: "\u{1102}\u{116E}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B20A}",
        nfc: "\u{B20A}",
        nfd: "\u{1102}\u{116E}\u{11AD}",
        nfkc: "\u{B20A}",
        nfkd: "\u{1102}\u{116E}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B20B}",
        nfc: "\u{B20B}",
        nfd: "\u{1102}\u{116E}\u{11AE}",
        nfkc: "\u{B20B}",
        nfkd: "\u{1102}\u{116E}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B20C}",
        nfc: "\u{B20C}",
        nfd: "\u{1102}\u{116E}\u{11AF}",
        nfkc: "\u{B20C}",
        nfkd: "\u{1102}\u{116E}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B20D}",
        nfc: "\u{B20D}",
        nfd: "\u{1102}\u{116E}\u{11B0}",
        nfkc: "\u{B20D}",
        nfkd: "\u{1102}\u{116E}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B20E}",
        nfc: "\u{B20E}",
        nfd: "\u{1102}\u{116E}\u{11B1}",
        nfkc: "\u{B20E}",
        nfkd: "\u{1102}\u{116E}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B20F}",
        nfc: "\u{B20F}",
        nfd: "\u{1102}\u{116E}\u{11B2}",
        nfkc: "\u{B20F}",
        nfkd: "\u{1102}\u{116E}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B210}",
        nfc: "\u{B210}",
        nfd: "\u{1102}\u{116E}\u{11B3}",
        nfkc: "\u{B210}",
        nfkd: "\u{1102}\u{116E}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B211}",
        nfc: "\u{B211}",
        nfd: "\u{1102}\u{116E}\u{11B4}",
        nfkc: "\u{B211}",
        nfkd: "\u{1102}\u{116E}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B212}",
        nfc: "\u{B212}",
        nfd: "\u{1102}\u{116E}\u{11B5}",
        nfkc: "\u{B212}",
        nfkd: "\u{1102}\u{116E}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B213}",
        nfc: "\u{B213}",
        nfd: "\u{1102}\u{116E}\u{11B6}",
        nfkc: "\u{B213}",
        nfkd: "\u{1102}\u{116E}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B214}",
        nfc: "\u{B214}",
        nfd: "\u{1102}\u{116E}\u{11B7}",
        nfkc: "\u{B214}",
        nfkd: "\u{1102}\u{116E}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B215}",
        nfc: "\u{B215}",
        nfd: "\u{1102}\u{116E}\u{11B8}",
        nfkc: "\u{B215}",
        nfkd: "\u{1102}\u{116E}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B216}",
        nfc: "\u{B216}",
        nfd: "\u{1102}\u{116E}\u{11B9}",
        nfkc: "\u{B216}",
        nfkd: "\u{1102}\u{116E}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B217}",
        nfc: "\u{B217}",
        nfd: "\u{1102}\u{116E}\u{11BA}",
        nfkc: "\u{B217}",
        nfkd: "\u{1102}\u{116E}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B218}",
        nfc: "\u{B218}",
        nfd: "\u{1102}\u{116E}\u{11BB}",
        nfkc: "\u{B218}",
        nfkd: "\u{1102}\u{116E}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B219}",
        nfc: "\u{B219}",
        nfd: "\u{1102}\u{116E}\u{11BC}",
        nfkc: "\u{B219}",
        nfkd: "\u{1102}\u{116E}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B21A}",
        nfc: "\u{B21A}",
        nfd: "\u{1102}\u{116E}\u{11BD}",
        nfkc: "\u{B21A}",
        nfkd: "\u{1102}\u{116E}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B21B}",
        nfc: "\u{B21B}",
        nfd: "\u{1102}\u{116E}\u{11BE}",
        nfkc: "\u{B21B}",
        nfkd: "\u{1102}\u{116E}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B21C}",
        nfc: "\u{B21C}",
        nfd: "\u{1102}\u{116E}\u{11BF}",
        nfkc: "\u{B21C}",
        nfkd: "\u{1102}\u{116E}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B21D}",
        nfc: "\u{B21D}",
        nfd: "\u{1102}\u{116E}\u{11C0}",
        nfkc: "\u{B21D}",
        nfkd: "\u{1102}\u{116E}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B21E}",
        nfc: "\u{B21E}",
        nfd: "\u{1102}\u{116E}\u{11C1}",
        nfkc: "\u{B21E}",
        nfkd: "\u{1102}\u{116E}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B21F}",
        nfc: "\u{B21F}",
        nfd: "\u{1102}\u{116E}\u{11C2}",
        nfkc: "\u{B21F}",
        nfkd: "\u{1102}\u{116E}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B220}",
        nfc: "\u{B220}",
        nfd: "\u{1102}\u{116F}",
        nfkc: "\u{B220}",
        nfkd: "\u{1102}\u{116F}",
    },
    NormalizationTest {
        source: "\u{B221}",
        nfc: "\u{B221}",
        nfd: "\u{1102}\u{116F}\u{11A8}",
        nfkc: "\u{B221}",
        nfkd: "\u{1102}\u{116F}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B222}",
        nfc: "\u{B222}",
        nfd: "\u{1102}\u{116F}\u{11A9}",
        nfkc: "\u{B222}",
        nfkd: "\u{1102}\u{116F}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B223}",
        nfc: "\u{B223}",
        nfd: "\u{1102}\u{116F}\u{11AA}",
        nfkc: "\u{B223}",
        nfkd: "\u{1102}\u{116F}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B224}",
        nfc: "\u{B224}",
        nfd: "\u{1102}\u{116F}\u{11AB}",
        nfkc: "\u{B224}",
        nfkd: "\u{1102}\u{116F}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B225}",
        nfc: "\u{B225}",
        nfd: "\u{1102}\u{116F}\u{11AC}",
        nfkc: "\u{B225}",
        nfkd: "\u{1102}\u{116F}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B226}",
        nfc: "\u{B226}",
        nfd: "\u{1102}\u{116F}\u{11AD}",
        nfkc: "\u{B226}",
        nfkd: "\u{1102}\u{116F}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B227}",
        nfc: "\u{B227}",
        nfd: "\u{1102}\u{116F}\u{11AE}",
        nfkc: "\u{B227}",
        nfkd: "\u{1102}\u{116F}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B228}",
        nfc: "\u{B228}",
        nfd: "\u{1102}\u{116F}\u{11AF}",
        nfkc: "\u{B228}",
        nfkd: "\u{1102}\u{116F}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B229}",
        nfc: "\u{B229}",
        nfd: "\u{1102}\u{116F}\u{11B0}",
        nfkc: "\u{B229}",
        nfkd: "\u{1102}\u{116F}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B22A}",
        nfc: "\u{B22A}",
        nfd: "\u{1102}\u{116F}\u{11B1}",
        nfkc: "\u{B22A}",
        nfkd: "\u{1102}\u{116F}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B22B}",
        nfc: "\u{B22B}",
        nfd: "\u{1102}\u{116F}\u{11B2}",
        nfkc: "\u{B22B}",
        nfkd: "\u{1102}\u{116F}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B22C}",
        nfc: "\u{B22C}",
        nfd: "\u{1102}\u{116F}\u{11B3}",
        nfkc: "\u{B22C}",
        nfkd: "\u{1102}\u{116F}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B22D}",
        nfc: "\u{B22D}",
        nfd: "\u{1102}\u{116F}\u{11B4}",
        nfkc: "\u{B22D}",
        nfkd: "\u{1102}\u{116F}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B22E}",
        nfc: "\u{B22E}",
        nfd: "\u{1102}\u{116F}\u{11B5}",
        nfkc: "\u{B22E}",
        nfkd: "\u{1102}\u{116F}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B22F}",
        nfc: "\u{B22F}",
        nfd: "\u{1102}\u{116F}\u{11B6}",
        nfkc: "\u{B22F}",
        nfkd: "\u{1102}\u{116F}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B230}",
        nfc: "\u{B230}",
        nfd: "\u{1102}\u{116F}\u{11B7}",
        nfkc: "\u{B230}",
        nfkd: "\u{1102}\u{116F}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B231}",
        nfc: "\u{B231}",
        nfd: "\u{1102}\u{116F}\u{11B8}",
        nfkc: "\u{B231}",
        nfkd: "\u{1102}\u{116F}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B232}",
        nfc: "\u{B232}",
        nfd: "\u{1102}\u{116F}\u{11B9}",
        nfkc: "\u{B232}",
        nfkd: "\u{1102}\u{116F}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B233}",
        nfc: "\u{B233}",
        nfd: "\u{1102}\u{116F}\u{11BA}",
        nfkc: "\u{B233}",
        nfkd: "\u{1102}\u{116F}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B234}",
        nfc: "\u{B234}",
        nfd: "\u{1102}\u{116F}\u{11BB}",
        nfkc: "\u{B234}",
        nfkd: "\u{1102}\u{116F}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B235}",
        nfc: "\u{B235}",
        nfd: "\u{1102}\u{116F}\u{11BC}",
        nfkc: "\u{B235}",
        nfkd: "\u{1102}\u{116F}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B236}",
        nfc: "\u{B236}",
        nfd: "\u{1102}\u{116F}\u{11BD}",
        nfkc: "\u{B236}",
        nfkd: "\u{1102}\u{116F}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B237}",
        nfc: "\u{B237}",
        nfd: "\u{1102}\u{116F}\u{11BE}",
        nfkc: "\u{B237}",
        nfkd: "\u{1102}\u{116F}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B238}",
        nfc: "\u{B238}",
        nfd: "\u{1102}\u{116F}\u{11BF}",
        nfkc: "\u{B238}",
        nfkd: "\u{1102}\u{116F}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B239}",
        nfc: "\u{B239}",
        nfd: "\u{1102}\u{116F}\u{11C0}",
        nfkc: "\u{B239}",
        nfkd: "\u{1102}\u{116F}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B23A}",
        nfc: "\u{B23A}",
        nfd: "\u{1102}\u{116F}\u{11C1}",
        nfkc: "\u{B23A}",
        nfkd: "\u{1102}\u{116F}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B23B}",
        nfc: "\u{B23B}",
        nfd: "\u{1102}\u{116F}\u{11C2}",
        nfkc: "\u{B23B}",
        nfkd: "\u{1102}\u{116F}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B23C}",
        nfc: "\u{B23C}",
        nfd: "\u{1102}\u{1170}",
        nfkc: "\u{B23C}",
        nfkd: "\u{1102}\u{1170}",
    },
    NormalizationTest {
        source: "\u{B23D}",
        nfc: "\u{B23D}",
        nfd: "\u{1102}\u{1170}\u{11A8}",
        nfkc: "\u{B23D}",
        nfkd: "\u{1102}\u{1170}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B23E}",
        nfc: "\u{B23E}",
        nfd: "\u{1102}\u{1170}\u{11A9}",
        nfkc: "\u{B23E}",
        nfkd: "\u{1102}\u{1170}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B23F}",
        nfc: "\u{B23F}",
        nfd: "\u{1102}\u{1170}\u{11AA}",
        nfkc: "\u{B23F}",
        nfkd: "\u{1102}\u{1170}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B240}",
        nfc: "\u{B240}",
        nfd: "\u{1102}\u{1170}\u{11AB}",
        nfkc: "\u{B240}",
        nfkd: "\u{1102}\u{1170}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B241}",
        nfc: "\u{B241}",
        nfd: "\u{1102}\u{1170}\u{11AC}",
        nfkc: "\u{B241}",
        nfkd: "\u{1102}\u{1170}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B242}",
        nfc: "\u{B242}",
        nfd: "\u{1102}\u{1170}\u{11AD}",
        nfkc: "\u{B242}",
        nfkd: "\u{1102}\u{1170}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B243}",
        nfc: "\u{B243}",
        nfd: "\u{1102}\u{1170}\u{11AE}",
        nfkc: "\u{B243}",
        nfkd: "\u{1102}\u{1170}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B244}",
        nfc: "\u{B244}",
        nfd: "\u{1102}\u{1170}\u{11AF}",
        nfkc: "\u{B244}",
        nfkd: "\u{1102}\u{1170}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B245}",
        nfc: "\u{B245}",
        nfd: "\u{1102}\u{1170}\u{11B0}",
        nfkc: "\u{B245}",
        nfkd: "\u{1102}\u{1170}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B246}",
        nfc: "\u{B246}",
        nfd: "\u{1102}\u{1170}\u{11B1}",
        nfkc: "\u{B246}",
        nfkd: "\u{1102}\u{1170}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B247}",
        nfc: "\u{B247}",
        nfd: "\u{1102}\u{1170}\u{11B2}",
        nfkc: "\u{B247}",
        nfkd: "\u{1102}\u{1170}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B248}",
        nfc: "\u{B248}",
        nfd: "\u{1102}\u{1170}\u{11B3}",
        nfkc: "\u{B248}",
        nfkd: "\u{1102}\u{1170}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B249}",
        nfc: "\u{B249}",
        nfd: "\u{1102}\u{1170}\u{11B4}",
        nfkc: "\u{B249}",
        nfkd: "\u{1102}\u{1170}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B24A}",
        nfc: "\u{B24A}",
        nfd: "\u{1102}\u{1170}\u{11B5}",
        nfkc: "\u{B24A}",
        nfkd: "\u{1102}\u{1170}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B24B}",
        nfc: "\u{B24B}",
        nfd: "\u{1102}\u{1170}\u{11B6}",
        nfkc: "\u{B24B}",
        nfkd: "\u{1102}\u{1170}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B24C}",
        nfc: "\u{B24C}",
        nfd: "\u{1102}\u{1170}\u{11B7}",
        nfkc: "\u{B24C}",
        nfkd: "\u{1102}\u{1170}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B24D}",
        nfc: "\u{B24D}",
        nfd: "\u{1102}\u{1170}\u{11B8}",
        nfkc: "\u{B24D}",
        nfkd: "\u{1102}\u{1170}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B24E}",
        nfc: "\u{B24E}",
        nfd: "\u{1102}\u{1170}\u{11B9}",
        nfkc: "\u{B24E}",
        nfkd: "\u{1102}\u{1170}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B24F}",
        nfc: "\u{B24F}",
        nfd: "\u{1102}\u{1170}\u{11BA}",
        nfkc: "\u{B24F}",
        nfkd: "\u{1102}\u{1170}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B250}",
        nfc: "\u{B250}",
        nfd: "\u{1102}\u{1170}\u{11BB}",
        nfkc: "\u{B250}",
        nfkd: "\u{1102}\u{1170}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B251}",
        nfc: "\u{B251}",
        nfd: "\u{1102}\u{1170}\u{11BC}",
        nfkc: "\u{B251}",
        nfkd: "\u{1102}\u{1170}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B252}",
        nfc: "\u{B252}",
        nfd: "\u{1102}\u{1170}\u{11BD}",
        nfkc: "\u{B252}",
        nfkd: "\u{1102}\u{1170}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B253}",
        nfc: "\u{B253}",
        nfd: "\u{1102}\u{1170}\u{11BE}",
        nfkc: "\u{B253}",
        nfkd: "\u{1102}\u{1170}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B254}",
        nfc: "\u{B254}",
        nfd: "\u{1102}\u{1170}\u{11BF}",
        nfkc: "\u{B254}",
        nfkd: "\u{1102}\u{1170}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B255}",
        nfc: "\u{B255}",
        nfd: "\u{1102}\u{1170}\u{11C0}",
        nfkc: "\u{B255}",
        nfkd: "\u{1102}\u{1170}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B256}",
        nfc: "\u{B256}",
        nfd: "\u{1102}\u{1170}\u{11C1}",
        nfkc: "\u{B256}",
        nfkd: "\u{1102}\u{1170}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B257}",
        nfc: "\u{B257}",
        nfd: "\u{1102}\u{1170}\u{11C2}",
        nfkc: "\u{B257}",
        nfkd: "\u{1102}\u{1170}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B258}",
        nfc: "\u{B258}",
        nfd: "\u{1102}\u{1171}",
        nfkc: "\u{B258}",
        nfkd: "\u{1102}\u{1171}",
    },
    NormalizationTest {
        source: "\u{B259}",
        nfc: "\u{B259}",
        nfd: "\u{1102}\u{1171}\u{11A8}",
        nfkc: "\u{B259}",
        nfkd: "\u{1102}\u{1171}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B25A}",
        nfc: "\u{B25A}",
        nfd: "\u{1102}\u{1171}\u{11A9}",
        nfkc: "\u{B25A}",
        nfkd: "\u{1102}\u{1171}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B25B}",
        nfc: "\u{B25B}",
        nfd: "\u{1102}\u{1171}\u{11AA}",
        nfkc: "\u{B25B}",
        nfkd: "\u{1102}\u{1171}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B25C}",
        nfc: "\u{B25C}",
        nfd: "\u{1102}\u{1171}\u{11AB}",
        nfkc: "\u{B25C}",
        nfkd: "\u{1102}\u{1171}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B25D}",
        nfc: "\u{B25D}",
        nfd: "\u{1102}\u{1171}\u{11AC}",
        nfkc: "\u{B25D}",
        nfkd: "\u{1102}\u{1171}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B25E}",
        nfc: "\u{B25E}",
        nfd: "\u{1102}\u{1171}\u{11AD}",
        nfkc: "\u{B25E}",
        nfkd: "\u{1102}\u{1171}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B25F}",
        nfc: "\u{B25F}",
        nfd: "\u{1102}\u{1171}\u{11AE}",
        nfkc: "\u{B25F}",
        nfkd: "\u{1102}\u{1171}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B260}",
        nfc: "\u{B260}",
        nfd: "\u{1102}\u{1171}\u{11AF}",
        nfkc: "\u{B260}",
        nfkd: "\u{1102}\u{1171}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B261}",
        nfc: "\u{B261}",
        nfd: "\u{1102}\u{1171}\u{11B0}",
        nfkc: "\u{B261}",
        nfkd: "\u{1102}\u{1171}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B262}",
        nfc: "\u{B262}",
        nfd: "\u{1102}\u{1171}\u{11B1}",
        nfkc: "\u{B262}",
        nfkd: "\u{1102}\u{1171}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B263}",
        nfc: "\u{B263}",
        nfd: "\u{1102}\u{1171}\u{11B2}",
        nfkc: "\u{B263}",
        nfkd: "\u{1102}\u{1171}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B264}",
        nfc: "\u{B264}",
        nfd: "\u{1102}\u{1171}\u{11B3}",
        nfkc: "\u{B264}",
        nfkd: "\u{1102}\u{1171}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B265}",
        nfc: "\u{B265}",
        nfd: "\u{1102}\u{1171}\u{11B4}",
        nfkc: "\u{B265}",
        nfkd: "\u{1102}\u{1171}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B266}",
        nfc: "\u{B266}",
        nfd: "\u{1102}\u{1171}\u{11B5}",
        nfkc: "\u{B266}",
        nfkd: "\u{1102}\u{1171}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B267}",
        nfc: "\u{B267}",
        nfd: "\u{1102}\u{1171}\u{11B6}",
        nfkc: "\u{B267}",
        nfkd: "\u{1102}\u{1171}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B268}",
        nfc: "\u{B268}",
        nfd: "\u{1102}\u{1171}\u{11B7}",
        nfkc: "\u{B268}",
        nfkd: "\u{1102}\u{1171}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B269}",
        nfc: "\u{B269}",
        nfd: "\u{1102}\u{1171}\u{11B8}",
        nfkc: "\u{B269}",
        nfkd: "\u{1102}\u{1171}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B26A}",
        nfc: "\u{B26A}",
        nfd: "\u{1102}\u{1171}\u{11B9}",
        nfkc: "\u{B26A}",
        nfkd: "\u{1102}\u{1171}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B26B}",
        nfc: "\u{B26B}",
        nfd: "\u{1102}\u{1171}\u{11BA}",
        nfkc: "\u{B26B}",
        nfkd: "\u{1102}\u{1171}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B26C}",
        nfc: "\u{B26C}",
        nfd: "\u{1102}\u{1171}\u{11BB}",
        nfkc: "\u{B26C}",
        nfkd: "\u{1102}\u{1171}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B26D}",
        nfc: "\u{B26D}",
        nfd: "\u{1102}\u{1171}\u{11BC}",
        nfkc: "\u{B26D}",
        nfkd: "\u{1102}\u{1171}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B26E}",
        nfc: "\u{B26E}",
        nfd: "\u{1102}\u{1171}\u{11BD}",
        nfkc: "\u{B26E}",
        nfkd: "\u{1102}\u{1171}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B26F}",
        nfc: "\u{B26F}",
        nfd: "\u{1102}\u{1171}\u{11BE}",
        nfkc: "\u{B26F}",
        nfkd: "\u{1102}\u{1171}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B270}",
        nfc: "\u{B270}",
        nfd: "\u{1102}\u{1171}\u{11BF}",
        nfkc: "\u{B270}",
        nfkd: "\u{1102}\u{1171}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B271}",
        nfc: "\u{B271}",
        nfd: "\u{1102}\u{1171}\u{11C0}",
        nfkc: "\u{B271}",
        nfkd: "\u{1102}\u{1171}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B272}",
        nfc: "\u{B272}",
        nfd: "\u{1102}\u{1171}\u{11C1}",
        nfkc: "\u{B272}",
        nfkd: "\u{1102}\u{1171}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B273}",
        nfc: "\u{B273}",
        nfd: "\u{1102}\u{1171}\u{11C2}",
        nfkc: "\u{B273}",
        nfkd: "\u{1102}\u{1171}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B274}",
        nfc: "\u{B274}",
        nfd: "\u{1102}\u{1172}",
        nfkc: "\u{B274}",
        nfkd: "\u{1102}\u{1172}",
    },
    NormalizationTest {
        source: "\u{B275}",
        nfc: "\u{B275}",
        nfd: "\u{1102}\u{1172}\u{11A8}",
        nfkc: "\u{B275}",
        nfkd: "\u{1102}\u{1172}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B276}",
        nfc: "\u{B276}",
        nfd: "\u{1102}\u{1172}\u{11A9}",
        nfkc: "\u{B276}",
        nfkd: "\u{1102}\u{1172}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B277}",
        nfc: "\u{B277}",
        nfd: "\u{1102}\u{1172}\u{11AA}",
        nfkc: "\u{B277}",
        nfkd: "\u{1102}\u{1172}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B278}",
        nfc: "\u{B278}",
        nfd: "\u{1102}\u{1172}\u{11AB}",
        nfkc: "\u{B278}",
        nfkd: "\u{1102}\u{1172}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B279}",
        nfc: "\u{B279}",
        nfd: "\u{1102}\u{1172}\u{11AC}",
        nfkc: "\u{B279}",
        nfkd: "\u{1102}\u{1172}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B27A}",
        nfc: "\u{B27A}",
        nfd: "\u{1102}\u{1172}\u{11AD}",
        nfkc: "\u{B27A}",
        nfkd: "\u{1102}\u{1172}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B27B}",
        nfc: "\u{B27B}",
        nfd: "\u{1102}\u{1172}\u{11AE}",
        nfkc: "\u{B27B}",
        nfkd: "\u{1102}\u{1172}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B27C}",
        nfc: "\u{B27C}",
        nfd: "\u{1102}\u{1172}\u{11AF}",
        nfkc: "\u{B27C}",
        nfkd: "\u{1102}\u{1172}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B27D}",
        nfc: "\u{B27D}",
        nfd: "\u{1102}\u{1172}\u{11B0}",
        nfkc: "\u{B27D}",
        nfkd: "\u{1102}\u{1172}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B27E}",
        nfc: "\u{B27E}",
        nfd: "\u{1102}\u{1172}\u{11B1}",
        nfkc: "\u{B27E}",
        nfkd: "\u{1102}\u{1172}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B27F}",
        nfc: "\u{B27F}",
        nfd: "\u{1102}\u{1172}\u{11B2}",
        nfkc: "\u{B27F}",
        nfkd: "\u{1102}\u{1172}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B280}",
        nfc: "\u{B280}",
        nfd: "\u{1102}\u{1172}\u{11B3}",
        nfkc: "\u{B280}",
        nfkd: "\u{1102}\u{1172}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B281}",
        nfc: "\u{B281}",
        nfd: "\u{1102}\u{1172}\u{11B4}",
        nfkc: "\u{B281}",
        nfkd: "\u{1102}\u{1172}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B282}",
        nfc: "\u{B282}",
        nfd: "\u{1102}\u{1172}\u{11B5}",
        nfkc: "\u{B282}",
        nfkd: "\u{1102}\u{1172}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B283}",
        nfc: "\u{B283}",
        nfd: "\u{1102}\u{1172}\u{11B6}",
        nfkc: "\u{B283}",
        nfkd: "\u{1102}\u{1172}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B284}",
        nfc: "\u{B284}",
        nfd: "\u{1102}\u{1172}\u{11B7}",
        nfkc: "\u{B284}",
        nfkd: "\u{1102}\u{1172}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B285}",
        nfc: "\u{B285}",
        nfd: "\u{1102}\u{1172}\u{11B8}",
        nfkc: "\u{B285}",
        nfkd: "\u{1102}\u{1172}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B286}",
        nfc: "\u{B286}",
        nfd: "\u{1102}\u{1172}\u{11B9}",
        nfkc: "\u{B286}",
        nfkd: "\u{1102}\u{1172}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B287}",
        nfc: "\u{B287}",
        nfd: "\u{1102}\u{1172}\u{11BA}",
        nfkc: "\u{B287}",
        nfkd: "\u{1102}\u{1172}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B288}",
        nfc: "\u{B288}",
        nfd: "\u{1102}\u{1172}\u{11BB}",
        nfkc: "\u{B288}",
        nfkd: "\u{1102}\u{1172}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B289}",
        nfc: "\u{B289}",
        nfd: "\u{1102}\u{1172}\u{11BC}",
        nfkc: "\u{B289}",
        nfkd: "\u{1102}\u{1172}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B28A}",
        nfc: "\u{B28A}",
        nfd: "\u{1102}\u{1172}\u{11BD}",
        nfkc: "\u{B28A}",
        nfkd: "\u{1102}\u{1172}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B28B}",
        nfc: "\u{B28B}",
        nfd: "\u{1102}\u{1172}\u{11BE}",
        nfkc: "\u{B28B}",
        nfkd: "\u{1102}\u{1172}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B28C}",
        nfc: "\u{B28C}",
        nfd: "\u{1102}\u{1172}\u{11BF}",
        nfkc: "\u{B28C}",
        nfkd: "\u{1102}\u{1172}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B28D}",
        nfc: "\u{B28D}",
        nfd: "\u{1102}\u{1172}\u{11C0}",
        nfkc: "\u{B28D}",
        nfkd: "\u{1102}\u{1172}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B28E}",
        nfc: "\u{B28E}",
        nfd: "\u{1102}\u{1172}\u{11C1}",
        nfkc: "\u{B28E}",
        nfkd: "\u{1102}\u{1172}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B28F}",
        nfc: "\u{B28F}",
        nfd: "\u{1102}\u{1172}\u{11C2}",
        nfkc: "\u{B28F}",
        nfkd: "\u{1102}\u{1172}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B290}",
        nfc: "\u{B290}",
        nfd: "\u{1102}\u{1173}",
        nfkc: "\u{B290}",
        nfkd: "\u{1102}\u{1173}",
    },
    NormalizationTest {
        source: "\u{B291}",
        nfc: "\u{B291}",
        nfd: "\u{1102}\u{1173}\u{11A8}",
        nfkc: "\u{B291}",
        nfkd: "\u{1102}\u{1173}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B292}",
        nfc: "\u{B292}",
        nfd: "\u{1102}\u{1173}\u{11A9}",
        nfkc: "\u{B292}",
        nfkd: "\u{1102}\u{1173}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B293}",
        nfc: "\u{B293}",
        nfd: "\u{1102}\u{1173}\u{11AA}",
        nfkc: "\u{B293}",
        nfkd: "\u{1102}\u{1173}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B294}",
        nfc: "\u{B294}",
        nfd: "\u{1102}\u{1173}\u{11AB}",
        nfkc: "\u{B294}",
        nfkd: "\u{1102}\u{1173}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B295}",
        nfc: "\u{B295}",
        nfd: "\u{1102}\u{1173}\u{11AC}",
        nfkc: "\u{B295}",
        nfkd: "\u{1102}\u{1173}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B296}",
        nfc: "\u{B296}",
        nfd: "\u{1102}\u{1173}\u{11AD}",
        nfkc: "\u{B296}",
        nfkd: "\u{1102}\u{1173}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B297}",
        nfc: "\u{B297}",
        nfd: "\u{1102}\u{1173}\u{11AE}",
        nfkc: "\u{B297}",
        nfkd: "\u{1102}\u{1173}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B298}",
        nfc: "\u{B298}",
        nfd: "\u{1102}\u{1173}\u{11AF}",
        nfkc: "\u{B298}",
        nfkd: "\u{1102}\u{1173}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B299}",
        nfc: "\u{B299}",
        nfd: "\u{1102}\u{1173}\u{11B0}",
        nfkc: "\u{B299}",
        nfkd: "\u{1102}\u{1173}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B29A}",
        nfc: "\u{B29A}",
        nfd: "\u{1102}\u{1173}\u{11B1}",
        nfkc: "\u{B29A}",
        nfkd: "\u{1102}\u{1173}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B29B}",
        nfc: "\u{B29B}",
        nfd: "\u{1102}\u{1173}\u{11B2}",
        nfkc: "\u{B29B}",
        nfkd: "\u{1102}\u{1173}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B29C}",
        nfc: "\u{B29C}",
        nfd: "\u{1102}\u{1173}\u{11B3}",
        nfkc: "\u{B29C}",
        nfkd: "\u{1102}\u{1173}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B29D}",
        nfc: "\u{B29D}",
        nfd: "\u{1102}\u{1173}\u{11B4}",
        nfkc: "\u{B29D}",
        nfkd: "\u{1102}\u{1173}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B29E}",
        nfc: "\u{B29E}",
        nfd: "\u{1102}\u{1173}\u{11B5}",
        nfkc: "\u{B29E}",
        nfkd: "\u{1102}\u{1173}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B29F}",
        nfc: "\u{B29F}",
        nfd: "\u{1102}\u{1173}\u{11B6}",
        nfkc: "\u{B29F}",
        nfkd: "\u{1102}\u{1173}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B2A0}",
        nfc: "\u{B2A0}",
        nfd: "\u{1102}\u{1173}\u{11B7}",
        nfkc: "\u{B2A0}",
        nfkd: "\u{1102}\u{1173}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B2A1}",
        nfc: "\u{B2A1}",
        nfd: "\u{1102}\u{1173}\u{11B8}",
        nfkc: "\u{B2A1}",
        nfkd: "\u{1102}\u{1173}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B2A2}",
        nfc: "\u{B2A2}",
        nfd: "\u{1102}\u{1173}\u{11B9}",
        nfkc: "\u{B2A2}",
        nfkd: "\u{1102}\u{1173}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B2A3}",
        nfc: "\u{B2A3}",
        nfd: "\u{1102}\u{1173}\u{11BA}",
        nfkc: "\u{B2A3}",
        nfkd: "\u{1102}\u{1173}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B2A4}",
        nfc: "\u{B2A4}",
        nfd: "\u{1102}\u{1173}\u{11BB}",
        nfkc: "\u{B2A4}",
        nfkd: "\u{1102}\u{1173}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B2A5}",
        nfc: "\u{B2A5}",
        nfd: "\u{1102}\u{1173}\u{11BC}",
        nfkc: "\u{B2A5}",
        nfkd: "\u{1102}\u{1173}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B2A6}",
        nfc: "\u{B2A6}",
        nfd: "\u{1102}\u{1173}\u{11BD}",
        nfkc: "\u{B2A6}",
        nfkd: "\u{1102}\u{1173}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B2A7}",
        nfc: "\u{B2A7}",
        nfd: "\u{1102}\u{1173}\u{11BE}",
        nfkc: "\u{B2A7}",
        nfkd: "\u{1102}\u{1173}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B2A8}",
        nfc: "\u{B2A8}",
        nfd: "\u{1102}\u{1173}\u{11BF}",
        nfkc: "\u{B2A8}",
        nfkd: "\u{1102}\u{1173}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B2A9}",
        nfc: "\u{B2A9}",
        nfd: "\u{1102}\u{1173}\u{11C0}",
        nfkc: "\u{B2A9}",
        nfkd: "\u{1102}\u{1173}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B2AA}",
        nfc: "\u{B2AA}",
        nfd: "\u{1102}\u{1173}\u{11C1}",
        nfkc: "\u{B2AA}",
        nfkd: "\u{1102}\u{1173}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B2AB}",
        nfc: "\u{B2AB}",
        nfd: "\u{1102}\u{1173}\u{11C2}",
        nfkc: "\u{B2AB}",
        nfkd: "\u{1102}\u{1173}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B2AC}",
        nfc: "\u{B2AC}",
        nfd: "\u{1102}\u{1174}",
        nfkc: "\u{B2AC}",
        nfkd: "\u{1102}\u{1174}",
    },
    NormalizationTest {
        source: "\u{B2AD}",
        nfc: "\u{B2AD}",
        nfd: "\u{1102}\u{1174}\u{11A8}",
        nfkc: "\u{B2AD}",
        nfkd: "\u{1102}\u{1174}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B2AE}",
        nfc: "\u{B2AE}",
        nfd: "\u{1102}\u{1174}\u{11A9}",
        nfkc: "\u{B2AE}",
        nfkd: "\u{1102}\u{1174}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B2AF}",
        nfc: "\u{B2AF}",
        nfd: "\u{1102}\u{1174}\u{11AA}",
        nfkc: "\u{B2AF}",
        nfkd: "\u{1102}\u{1174}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B2B0}",
        nfc: "\u{B2B0}",
        nfd: "\u{1102}\u{1174}\u{11AB}",
        nfkc: "\u{B2B0}",
        nfkd: "\u{1102}\u{1174}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B2B1}",
        nfc: "\u{B2B1}",
        nfd: "\u{1102}\u{1174}\u{11AC}",
        nfkc: "\u{B2B1}",
        nfkd: "\u{1102}\u{1174}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B2B2}",
        nfc: "\u{B2B2}",
        nfd: "\u{1102}\u{1174}\u{11AD}",
        nfkc: "\u{B2B2}",
        nfkd: "\u{1102}\u{1174}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B2B3}",
        nfc: "\u{B2B3}",
        nfd: "\u{1102}\u{1174}\u{11AE}",
        nfkc: "\u{B2B3}",
        nfkd: "\u{1102}\u{1174}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B2B4}",
        nfc: "\u{B2B4}",
        nfd: "\u{1102}\u{1174}\u{11AF}",
        nfkc: "\u{B2B4}",
        nfkd: "\u{1102}\u{1174}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B2B5}",
        nfc: "\u{B2B5}",
        nfd: "\u{1102}\u{1174}\u{11B0}",
        nfkc: "\u{B2B5}",
        nfkd: "\u{1102}\u{1174}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B2B6}",
        nfc: "\u{B2B6}",
        nfd: "\u{1102}\u{1174}\u{11B1}",
        nfkc: "\u{B2B6}",
        nfkd: "\u{1102}\u{1174}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B2B7}",
        nfc: "\u{B2B7}",
        nfd: "\u{1102}\u{1174}\u{11B2}",
        nfkc: "\u{B2B7}",
        nfkd: "\u{1102}\u{1174}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B2B8}",
        nfc: "\u{B2B8}",
        nfd: "\u{1102}\u{1174}\u{11B3}",
        nfkc: "\u{B2B8}",
        nfkd: "\u{1102}\u{1174}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B2B9}",
        nfc: "\u{B2B9}",
        nfd: "\u{1102}\u{1174}\u{11B4}",
        nfkc: "\u{B2B9}",
        nfkd: "\u{1102}\u{1174}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B2BA}",
        nfc: "\u{B2BA}",
        nfd: "\u{1102}\u{1174}\u{11B5}",
        nfkc: "\u{B2BA}",
        nfkd: "\u{1102}\u{1174}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B2BB}",
        nfc: "\u{B2BB}",
        nfd: "\u{1102}\u{1174}\u{11B6}",
        nfkc: "\u{B2BB}",
        nfkd: "\u{1102}\u{1174}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B2BC}",
        nfc: "\u{B2BC}",
        nfd: "\u{1102}\u{1174}\u{11B7}",
        nfkc: "\u{B2BC}",
        nfkd: "\u{1102}\u{1174}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B2BD}",
        nfc: "\u{B2BD}",
        nfd: "\u{1102}\u{1174}\u{11B8}",
        nfkc: "\u{B2BD}",
        nfkd: "\u{1102}\u{1174}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B2BE}",
        nfc: "\u{B2BE}",
        nfd: "\u{1102}\u{1174}\u{11B9}",
        nfkc: "\u{B2BE}",
        nfkd: "\u{1102}\u{1174}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B2BF}",
        nfc: "\u{B2BF}",
        nfd: "\u{1102}\u{1174}\u{11BA}",
        nfkc: "\u{B2BF}",
        nfkd: "\u{1102}\u{1174}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B2C0}",
        nfc: "\u{B2C0}",
        nfd: "\u{1102}\u{1174}\u{11BB}",
        nfkc: "\u{B2C0}",
        nfkd: "\u{1102}\u{1174}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B2C1}",
        nfc: "\u{B2C1}",
        nfd: "\u{1102}\u{1174}\u{11BC}",
        nfkc: "\u{B2C1}",
        nfkd: "\u{1102}\u{1174}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B2C2}",
        nfc: "\u{B2C2}",
        nfd: "\u{1102}\u{1174}\u{11BD}",
        nfkc: "\u{B2C2}",
        nfkd: "\u{1102}\u{1174}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B2C3}",
        nfc: "\u{B2C3}",
        nfd: "\u{1102}\u{1174}\u{11BE}",
        nfkc: "\u{B2C3}",
        nfkd: "\u{1102}\u{1174}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B2C4}",
        nfc: "\u{B2C4}",
        nfd: "\u{1102}\u{1174}\u{11BF}",
        nfkc: "\u{B2C4}",
        nfkd: "\u{1102}\u{1174}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B2C5}",
        nfc: "\u{B2C5}",
        nfd: "\u{1102}\u{1174}\u{11C0}",
        nfkc: "\u{B2C5}",
        nfkd: "\u{1102}\u{1174}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B2C6}",
        nfc: "\u{B2C6}",
        nfd: "\u{1102}\u{1174}\u{11C1}",
        nfkc: "\u{B2C6}",
        nfkd: "\u{1102}\u{1174}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B2C7}",
        nfc: "\u{B2C7}",
        nfd: "\u{1102}\u{1174}\u{11C2}",
        nfkc: "\u{B2C7}",
        nfkd: "\u{1102}\u{1174}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B2C8}",
        nfc: "\u{B2C8}",
        nfd: "\u{1102}\u{1175}",
        nfkc: "\u{B2C8}",
        nfkd: "\u{1102}\u{1175}",
    },
    NormalizationTest {
        source: "\u{B2C9}",
        nfc: "\u{B2C9}",
        nfd: "\u{1102}\u{1175}\u{11A8}",
        nfkc: "\u{B2C9}",
        nfkd: "\u{1102}\u{1175}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B2CA}",
        nfc: "\u{B2CA}",
        nfd: "\u{1102}\u{1175}\u{11A9}",
        nfkc: "\u{B2CA}",
        nfkd: "\u{1102}\u{1175}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B2CB}",
        nfc: "\u{B2CB}",
        nfd: "\u{1102}\u{1175}\u{11AA}",
        nfkc: "\u{B2CB}",
        nfkd: "\u{1102}\u{1175}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B2CC}",
        nfc: "\u{B2CC}",
        nfd: "\u{1102}\u{1175}\u{11AB}",
        nfkc: "\u{B2CC}",
        nfkd: "\u{1102}\u{1175}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B2CD}",
        nfc: "\u{B2CD}",
        nfd: "\u{1102}\u{1175}\u{11AC}",
        nfkc: "\u{B2CD}",
        nfkd: "\u{1102}\u{1175}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B2CE}",
        nfc: "\u{B2CE}",
        nfd: "\u{1102}\u{1175}\u{11AD}",
        nfkc: "\u{B2CE}",
        nfkd: "\u{1102}\u{1175}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B2CF}",
        nfc: "\u{B2CF}",
        nfd: "\u{1102}\u{1175}\u{11AE}",
        nfkc: "\u{B2CF}",
        nfkd: "\u{1102}\u{1175}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B2D0}",
        nfc: "\u{B2D0}",
        nfd: "\u{1102}\u{1175}\u{11AF}",
        nfkc: "\u{B2D0}",
        nfkd: "\u{1102}\u{1175}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B2D1}",
        nfc: "\u{B2D1}",
        nfd: "\u{1102}\u{1175}\u{11B0}",
        nfkc: "\u{B2D1}",
        nfkd: "\u{1102}\u{1175}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B2D2}",
        nfc: "\u{B2D2}",
        nfd: "\u{1102}\u{1175}\u{11B1}",
        nfkc: "\u{B2D2}",
        nfkd: "\u{1102}\u{1175}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B2D3}",
        nfc: "\u{B2D3}",
        nfd: "\u{1102}\u{1175}\u{11B2}",
        nfkc: "\u{B2D3}",
        nfkd: "\u{1102}\u{1175}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B2D4}",
        nfc: "\u{B2D4}",
        nfd: "\u{1102}\u{1175}\u{11B3}",
        nfkc: "\u{B2D4}",
        nfkd: "\u{1102}\u{1175}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B2D5}",
        nfc: "\u{B2D5}",
        nfd: "\u{1102}\u{1175}\u{11B4}",
        nfkc: "\u{B2D5}",
        nfkd: "\u{1102}\u{1175}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B2D6}",
        nfc: "\u{B2D6}",
        nfd: "\u{1102}\u{1175}\u{11B5}",
        nfkc: "\u{B2D6}",
        nfkd: "\u{1102}\u{1175}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B2D7}",
        nfc: "\u{B2D7}",
        nfd: "\u{1102}\u{1175}\u{11B6}",
        nfkc: "\u{B2D7}",
        nfkd: "\u{1102}\u{1175}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B2D8}",
        nfc: "\u{B2D8}",
        nfd: "\u{1102}\u{1175}\u{11B7}",
        nfkc: "\u{B2D8}",
        nfkd: "\u{1102}\u{1175}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B2D9}",
        nfc: "\u{B2D9}",
        nfd: "\u{1102}\u{1175}\u{11B8}",
        nfkc: "\u{B2D9}",
        nfkd: "\u{1102}\u{1175}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B2DA}",
        nfc: "\u{B2DA}",
        nfd: "\u{1102}\u{1175}\u{11B9}",
        nfkc: "\u{B2DA}",
        nfkd: "\u{1102}\u{1175}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B2DB}",
        nfc: "\u{B2DB}",
        nfd: "\u{1102}\u{1175}\u{11BA}",
        nfkc: "\u{B2DB}",
        nfkd: "\u{1102}\u{1175}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B2DC}",
        nfc: "\u{B2DC}",
        nfd: "\u{1102}\u{1175}\u{11BB}",
        nfkc: "\u{B2DC}",
        nfkd: "\u{1102}\u{1175}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B2DD}",
        nfc: "\u{B2DD}",
        nfd: "\u{1102}\u{1175}\u{11BC}",
        nfkc: "\u{B2DD}",
        nfkd: "\u{1102}\u{1175}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B2DE}",
        nfc: "\u{B2DE}",
        nfd: "\u{1102}\u{1175}\u{11BD}",
        nfkc: "\u{B2DE}",
        nfkd: "\u{1102}\u{1175}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B2DF}",
        nfc: "\u{B2DF}",
        nfd: "\u{1102}\u{1175}\u{11BE}",
        nfkc: "\u{B2DF}",
        nfkd: "\u{1102}\u{1175}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B2E0}",
        nfc: "\u{B2E0}",
        nfd: "\u{1102}\u{1175}\u{11BF}",
        nfkc: "\u{B2E0}",
        nfkd: "\u{1102}\u{1175}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B2E1}",
        nfc: "\u{B2E1}",
        nfd: "\u{1102}\u{1175}\u{11C0}",
        nfkc: "\u{B2E1}",
        nfkd: "\u{1102}\u{1175}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B2E2}",
        nfc: "\u{B2E2}",
        nfd: "\u{1102}\u{1175}\u{11C1}",
        nfkc: "\u{B2E2}",
        nfkd: "\u{1102}\u{1175}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B2E3}",
        nfc: "\u{B2E3}",
        nfd: "\u{1102}\u{1175}\u{11C2}",
        nfkc: "\u{B2E3}",
        nfkd: "\u{1102}\u{1175}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B2E4}",
        nfc: "\u{B2E4}",
        nfd: "\u{1103}\u{1161}",
        nfkc: "\u{B2E4}",
        nfkd: "\u{1103}\u{1161}",
    },
    NormalizationTest {
        source: "\u{B2E5}",
        nfc: "\u{B2E5}",
        nfd: "\u{1103}\u{1161}\u{11A8}",
        nfkc: "\u{B2E5}",
        nfkd: "\u{1103}\u{1161}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B2E6}",
        nfc: "\u{B2E6}",
        nfd: "\u{1103}\u{1161}\u{11A9}",
        nfkc: "\u{B2E6}",
        nfkd: "\u{1103}\u{1161}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B2E7}",
        nfc: "\u{B2E7}",
        nfd: "\u{1103}\u{1161}\u{11AA}",
        nfkc: "\u{B2E7}",
        nfkd: "\u{1103}\u{1161}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B2E8}",
        nfc: "\u{B2E8}",
        nfd: "\u{1103}\u{1161}\u{11AB}",
        nfkc: "\u{B2E8}",
        nfkd: "\u{1103}\u{1161}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B2E9}",
        nfc: "\u{B2E9}",
        nfd: "\u{1103}\u{1161}\u{11AC}",
        nfkc: "\u{B2E9}",
        nfkd: "\u{1103}\u{1161}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B2EA}",
        nfc: "\u{B2EA}",
        nfd: "\u{1103}\u{1161}\u{11AD}",
        nfkc: "\u{B2EA}",
        nfkd: "\u{1103}\u{1161}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B2EB}",
        nfc: "\u{B2EB}",
        nfd: "\u{1103}\u{1161}\u{11AE}",
        nfkc: "\u{B2EB}",
        nfkd: "\u{1103}\u{1161}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B2EC}",
        nfc: "\u{B2EC}",
        nfd: "\u{1103}\u{1161}\u{11AF}",
        nfkc: "\u{B2EC}",
        nfkd: "\u{1103}\u{1161}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B2ED}",
        nfc: "\u{B2ED}",
        nfd: "\u{1103}\u{1161}\u{11B0}",
        nfkc: "\u{B2ED}",
        nfkd: "\u{1103}\u{1161}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B2EE}",
        nfc: "\u{B2EE}",
        nfd: "\u{1103}\u{1161}\u{11B1}",
        nfkc: "\u{B2EE}",
        nfkd: "\u{1103}\u{1161}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B2EF}",
        nfc: "\u{B2EF}",
        nfd: "\u{1103}\u{1161}\u{11B2}",
        nfkc: "\u{B2EF}",
        nfkd: "\u{1103}\u{1161}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B2F0}",
        nfc: "\u{B2F0}",
        nfd: "\u{1103}\u{1161}\u{11B3}",
        nfkc: "\u{B2F0}",
        nfkd: "\u{1103}\u{1161}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B2F1}",
        nfc: "\u{B2F1}",
        nfd: "\u{1103}\u{1161}\u{11B4}",
        nfkc: "\u{B2F1}",
        nfkd: "\u{1103}\u{1161}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B2F2}",
        nfc: "\u{B2F2}",
        nfd: "\u{1103}\u{1161}\u{11B5}",
        nfkc: "\u{B2F2}",
        nfkd: "\u{1103}\u{1161}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B2F3}",
        nfc: "\u{B2F3}",
        nfd: "\u{1103}\u{1161}\u{11B6}",
        nfkc: "\u{B2F3}",
        nfkd: "\u{1103}\u{1161}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B2F4}",
        nfc: "\u{B2F4}",
        nfd: "\u{1103}\u{1161}\u{11B7}",
        nfkc: "\u{B2F4}",
        nfkd: "\u{1103}\u{1161}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B2F5}",
        nfc: "\u{B2F5}",
        nfd: "\u{1103}\u{1161}\u{11B8}",
        nfkc: "\u{B2F5}",
        nfkd: "\u{1103}\u{1161}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B2F6}",
        nfc: "\u{B2F6}",
        nfd: "\u{1103}\u{1161}\u{11B9}",
        nfkc: "\u{B2F6}",
        nfkd: "\u{1103}\u{1161}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B2F7}",
        nfc: "\u{B2F7}",
        nfd: "\u{1103}\u{1161}\u{11BA}",
        nfkc: "\u{B2F7}",
        nfkd: "\u{1103}\u{1161}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B2F8}",
        nfc: "\u{B2F8}",
        nfd: "\u{1103}\u{1161}\u{11BB}",
        nfkc: "\u{B2F8}",
        nfkd: "\u{1103}\u{1161}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B2F9}",
        nfc: "\u{B2F9}",
        nfd: "\u{1103}\u{1161}\u{11BC}",
        nfkc: "\u{B2F9}",
        nfkd: "\u{1103}\u{1161}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B2FA}",
        nfc: "\u{B2FA}",
        nfd: "\u{1103}\u{1161}\u{11BD}",
        nfkc: "\u{B2FA}",
        nfkd: "\u{1103}\u{1161}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B2FB}",
        nfc: "\u{B2FB}",
        nfd: "\u{1103}\u{1161}\u{11BE}",
        nfkc: "\u{B2FB}",
        nfkd: "\u{1103}\u{1161}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B2FC}",
        nfc: "\u{B2FC}",
        nfd: "\u{1103}\u{1161}\u{11BF}",
        nfkc: "\u{B2FC}",
        nfkd: "\u{1103}\u{1161}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B2FD}",
        nfc: "\u{B2FD}",
        nfd: "\u{1103}\u{1161}\u{11C0}",
        nfkc: "\u{B2FD}",
        nfkd: "\u{1103}\u{1161}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B2FE}",
        nfc: "\u{B2FE}",
        nfd: "\u{1103}\u{1161}\u{11C1}",
        nfkc: "\u{B2FE}",
        nfkd: "\u{1103}\u{1161}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B2FF}",
        nfc: "\u{B2FF}",
        nfd: "\u{1103}\u{1161}\u{11C2}",
        nfkc: "\u{B2FF}",
        nfkd: "\u{1103}\u{1161}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B300}",
        nfc: "\u{B300}",
        nfd: "\u{1103}\u{1162}",
        nfkc: "\u{B300}",
        nfkd: "\u{1103}\u{1162}",
    },
    NormalizationTest {
        source: "\u{B301}",
        nfc: "\u{B301}",
        nfd: "\u{1103}\u{1162}\u{11A8}",
        nfkc: "\u{B301}",
        nfkd: "\u{1103}\u{1162}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B302}",
        nfc: "\u{B302}",
        nfd: "\u{1103}\u{1162}\u{11A9}",
        nfkc: "\u{B302}",
        nfkd: "\u{1103}\u{1162}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B303}",
        nfc: "\u{B303}",
        nfd: "\u{1103}\u{1162}\u{11AA}",
        nfkc: "\u{B303}",
        nfkd: "\u{1103}\u{1162}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B304}",
        nfc: "\u{B304}",
        nfd: "\u{1103}\u{1162}\u{11AB}",
        nfkc: "\u{B304}",
        nfkd: "\u{1103}\u{1162}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B305}",
        nfc: "\u{B305}",
        nfd: "\u{1103}\u{1162}\u{11AC}",
        nfkc: "\u{B305}",
        nfkd: "\u{1103}\u{1162}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B306}",
        nfc: "\u{B306}",
        nfd: "\u{1103}\u{1162}\u{11AD}",
        nfkc: "\u{B306}",
        nfkd: "\u{1103}\u{1162}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B307}",
        nfc: "\u{B307}",
        nfd: "\u{1103}\u{1162}\u{11AE}",
        nfkc: "\u{B307}",
        nfkd: "\u{1103}\u{1162}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B308}",
        nfc: "\u{B308}",
        nfd: "\u{1103}\u{1162}\u{11AF}",
        nfkc: "\u{B308}",
        nfkd: "\u{1103}\u{1162}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B309}",
        nfc: "\u{B309}",
        nfd: "\u{1103}\u{1162}\u{11B0}",
        nfkc: "\u{B309}",
        nfkd: "\u{1103}\u{1162}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B30A}",
        nfc: "\u{B30A}",
        nfd: "\u{1103}\u{1162}\u{11B1}",
        nfkc: "\u{B30A}",
        nfkd: "\u{1103}\u{1162}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B30B}",
        nfc: "\u{B30B}",
        nfd: "\u{1103}\u{1162}\u{11B2}",
        nfkc: "\u{B30B}",
        nfkd: "\u{1103}\u{1162}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B30C}",
        nfc: "\u{B30C}",
        nfd: "\u{1103}\u{1162}\u{11B3}",
        nfkc: "\u{B30C}",
        nfkd: "\u{1103}\u{1162}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B30D}",
        nfc: "\u{B30D}",
        nfd: "\u{1103}\u{1162}\u{11B4}",
        nfkc: "\u{B30D}",
        nfkd: "\u{1103}\u{1162}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B30E}",
        nfc: "\u{B30E}",
        nfd: "\u{1103}\u{1162}\u{11B5}",
        nfkc: "\u{B30E}",
        nfkd: "\u{1103}\u{1162}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B30F}",
        nfc: "\u{B30F}",
        nfd: "\u{1103}\u{1162}\u{11B6}",
        nfkc: "\u{B30F}",
        nfkd: "\u{1103}\u{1162}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B310}",
        nfc: "\u{B310}",
        nfd: "\u{1103}\u{1162}\u{11B7}",
        nfkc: "\u{B310}",
        nfkd: "\u{1103}\u{1162}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B311}",
        nfc: "\u{B311}",
        nfd: "\u{1103}\u{1162}\u{11B8}",
        nfkc: "\u{B311}",
        nfkd: "\u{1103}\u{1162}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B312}",
        nfc: "\u{B312}",
        nfd: "\u{1103}\u{1162}\u{11B9}",
        nfkc: "\u{B312}",
        nfkd: "\u{1103}\u{1162}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B313}",
        nfc: "\u{B313}",
        nfd: "\u{1103}\u{1162}\u{11BA}",
        nfkc: "\u{B313}",
        nfkd: "\u{1103}\u{1162}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B314}",
        nfc: "\u{B314}",
        nfd: "\u{1103}\u{1162}\u{11BB}",
        nfkc: "\u{B314}",
        nfkd: "\u{1103}\u{1162}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B315}",
        nfc: "\u{B315}",
        nfd: "\u{1103}\u{1162}\u{11BC}",
        nfkc: "\u{B315}",
        nfkd: "\u{1103}\u{1162}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B316}",
        nfc: "\u{B316}",
        nfd: "\u{1103}\u{1162}\u{11BD}",
        nfkc: "\u{B316}",
        nfkd: "\u{1103}\u{1162}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B317}",
        nfc: "\u{B317}",
        nfd: "\u{1103}\u{1162}\u{11BE}",
        nfkc: "\u{B317}",
        nfkd: "\u{1103}\u{1162}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B318}",
        nfc: "\u{B318}",
        nfd: "\u{1103}\u{1162}\u{11BF}",
        nfkc: "\u{B318}",
        nfkd: "\u{1103}\u{1162}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B319}",
        nfc: "\u{B319}",
        nfd: "\u{1103}\u{1162}\u{11C0}",
        nfkc: "\u{B319}",
        nfkd: "\u{1103}\u{1162}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B31A}",
        nfc: "\u{B31A}",
        nfd: "\u{1103}\u{1162}\u{11C1}",
        nfkc: "\u{B31A}",
        nfkd: "\u{1103}\u{1162}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B31B}",
        nfc: "\u{B31B}",
        nfd: "\u{1103}\u{1162}\u{11C2}",
        nfkc: "\u{B31B}",
        nfkd: "\u{1103}\u{1162}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B31C}",
        nfc: "\u{B31C}",
        nfd: "\u{1103}\u{1163}",
        nfkc: "\u{B31C}",
        nfkd: "\u{1103}\u{1163}",
    },
    NormalizationTest {
        source: "\u{B31D}",
        nfc: "\u{B31D}",
        nfd: "\u{1103}\u{1163}\u{11A8}",
        nfkc: "\u{B31D}",
        nfkd: "\u{1103}\u{1163}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B31E}",
        nfc: "\u{B31E}",
        nfd: "\u{1103}\u{1163}\u{11A9}",
        nfkc: "\u{B31E}",
        nfkd: "\u{1103}\u{1163}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B31F}",
        nfc: "\u{B31F}",
        nfd: "\u{1103}\u{1163}\u{11AA}",
        nfkc: "\u{B31F}",
        nfkd: "\u{1103}\u{1163}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B320}",
        nfc: "\u{B320}",
        nfd: "\u{1103}\u{1163}\u{11AB}",
        nfkc: "\u{B320}",
        nfkd: "\u{1103}\u{1163}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B321}",
        nfc: "\u{B321}",
        nfd: "\u{1103}\u{1163}\u{11AC}",
        nfkc: "\u{B321}",
        nfkd: "\u{1103}\u{1163}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B322}",
        nfc: "\u{B322}",
        nfd: "\u{1103}\u{1163}\u{11AD}",
        nfkc: "\u{B322}",
        nfkd: "\u{1103}\u{1163}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B323}",
        nfc: "\u{B323}",
        nfd: "\u{1103}\u{1163}\u{11AE}",
        nfkc: "\u{B323}",
        nfkd: "\u{1103}\u{1163}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B324}",
        nfc: "\u{B324}",
        nfd: "\u{1103}\u{1163}\u{11AF}",
        nfkc: "\u{B324}",
        nfkd: "\u{1103}\u{1163}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B325}",
        nfc: "\u{B325}",
        nfd: "\u{1103}\u{1163}\u{11B0}",
        nfkc: "\u{B325}",
        nfkd: "\u{1103}\u{1163}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B326}",
        nfc: "\u{B326}",
        nfd: "\u{1103}\u{1163}\u{11B1}",
        nfkc: "\u{B326}",
        nfkd: "\u{1103}\u{1163}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B327}",
        nfc: "\u{B327}",
        nfd: "\u{1103}\u{1163}\u{11B2}",
        nfkc: "\u{B327}",
        nfkd: "\u{1103}\u{1163}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B328}",
        nfc: "\u{B328}",
        nfd: "\u{1103}\u{1163}\u{11B3}",
        nfkc: "\u{B328}",
        nfkd: "\u{1103}\u{1163}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B329}",
        nfc: "\u{B329}",
        nfd: "\u{1103}\u{1163}\u{11B4}",
        nfkc: "\u{B329}",
        nfkd: "\u{1103}\u{1163}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B32A}",
        nfc: "\u{B32A}",
        nfd: "\u{1103}\u{1163}\u{11B5}",
        nfkc: "\u{B32A}",
        nfkd: "\u{1103}\u{1163}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B32B}",
        nfc: "\u{B32B}",
        nfd: "\u{1103}\u{1163}\u{11B6}",
        nfkc: "\u{B32B}",
        nfkd: "\u{1103}\u{1163}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B32C}",
        nfc: "\u{B32C}",
        nfd: "\u{1103}\u{1163}\u{11B7}",
        nfkc: "\u{B32C}",
        nfkd: "\u{1103}\u{1163}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B32D}",
        nfc: "\u{B32D}",
        nfd: "\u{1103}\u{1163}\u{11B8}",
        nfkc: "\u{B32D}",
        nfkd: "\u{1103}\u{1163}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B32E}",
        nfc: "\u{B32E}",
        nfd: "\u{1103}\u{1163}\u{11B9}",
        nfkc: "\u{B32E}",
        nfkd: "\u{1103}\u{1163}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B32F}",
        nfc: "\u{B32F}",
        nfd: "\u{1103}\u{1163}\u{11BA}",
        nfkc: "\u{B32F}",
        nfkd: "\u{1103}\u{1163}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B330}",
        nfc: "\u{B330}",
        nfd: "\u{1103}\u{1163}\u{11BB}",
        nfkc: "\u{B330}",
        nfkd: "\u{1103}\u{1163}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B331}",
        nfc: "\u{B331}",
        nfd: "\u{1103}\u{1163}\u{11BC}",
        nfkc: "\u{B331}",
        nfkd: "\u{1103}\u{1163}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B332}",
        nfc: "\u{B332}",
        nfd: "\u{1103}\u{1163}\u{11BD}",
        nfkc: "\u{B332}",
        nfkd: "\u{1103}\u{1163}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B333}",
        nfc: "\u{B333}",
        nfd: "\u{1103}\u{1163}\u{11BE}",
        nfkc: "\u{B333}",
        nfkd: "\u{1103}\u{1163}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B334}",
        nfc: "\u{B334}",
        nfd: "\u{1103}\u{1163}\u{11BF}",
        nfkc: "\u{B334}",
        nfkd: "\u{1103}\u{1163}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B335}",
        nfc: "\u{B335}",
        nfd: "\u{1103}\u{1163}\u{11C0}",
        nfkc: "\u{B335}",
        nfkd: "\u{1103}\u{1163}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B336}",
        nfc: "\u{B336}",
        nfd: "\u{1103}\u{1163}\u{11C1}",
        nfkc: "\u{B336}",
        nfkd: "\u{1103}\u{1163}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B337}",
        nfc: "\u{B337}",
        nfd: "\u{1103}\u{1163}\u{11C2}",
        nfkc: "\u{B337}",
        nfkd: "\u{1103}\u{1163}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B338}",
        nfc: "\u{B338}",
        nfd: "\u{1103}\u{1164}",
        nfkc: "\u{B338}",
        nfkd: "\u{1103}\u{1164}",
    },
    NormalizationTest {
        source: "\u{B339}",
        nfc: "\u{B339}",
        nfd: "\u{1103}\u{1164}\u{11A8}",
        nfkc: "\u{B339}",
        nfkd: "\u{1103}\u{1164}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B33A}",
        nfc: "\u{B33A}",
        nfd: "\u{1103}\u{1164}\u{11A9}",
        nfkc: "\u{B33A}",
        nfkd: "\u{1103}\u{1164}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B33B}",
        nfc: "\u{B33B}",
        nfd: "\u{1103}\u{1164}\u{11AA}",
        nfkc: "\u{B33B}",
        nfkd: "\u{1103}\u{1164}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B33C}",
        nfc: "\u{B33C}",
        nfd: "\u{1103}\u{1164}\u{11AB}",
        nfkc: "\u{B33C}",
        nfkd: "\u{1103}\u{1164}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B33D}",
        nfc: "\u{B33D}",
        nfd: "\u{1103}\u{1164}\u{11AC}",
        nfkc: "\u{B33D}",
        nfkd: "\u{1103}\u{1164}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B33E}",
        nfc: "\u{B33E}",
        nfd: "\u{1103}\u{1164}\u{11AD}",
        nfkc: "\u{B33E}",
        nfkd: "\u{1103}\u{1164}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B33F}",
        nfc: "\u{B33F}",
        nfd: "\u{1103}\u{1164}\u{11AE}",
        nfkc: "\u{B33F}",
        nfkd: "\u{1103}\u{1164}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B340}",
        nfc: "\u{B340}",
        nfd: "\u{1103}\u{1164}\u{11AF}",
        nfkc: "\u{B340}",
        nfkd: "\u{1103}\u{1164}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B341}",
        nfc: "\u{B341}",
        nfd: "\u{1103}\u{1164}\u{11B0}",
        nfkc: "\u{B341}",
        nfkd: "\u{1103}\u{1164}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B342}",
        nfc: "\u{B342}",
        nfd: "\u{1103}\u{1164}\u{11B1}",
        nfkc: "\u{B342}",
        nfkd: "\u{1103}\u{1164}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B343}",
        nfc: "\u{B343}",
        nfd: "\u{1103}\u{1164}\u{11B2}",
        nfkc: "\u{B343}",
        nfkd: "\u{1103}\u{1164}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B344}",
        nfc: "\u{B344}",
        nfd: "\u{1103}\u{1164}\u{11B3}",
        nfkc: "\u{B344}",
        nfkd: "\u{1103}\u{1164}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B345}",
        nfc: "\u{B345}",
        nfd: "\u{1103}\u{1164}\u{11B4}",
        nfkc: "\u{B345}",
        nfkd: "\u{1103}\u{1164}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B346}",
        nfc: "\u{B346}",
        nfd: "\u{1103}\u{1164}\u{11B5}",
        nfkc: "\u{B346}",
        nfkd: "\u{1103}\u{1164}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B347}",
        nfc: "\u{B347}",
        nfd: "\u{1103}\u{1164}\u{11B6}",
        nfkc: "\u{B347}",
        nfkd: "\u{1103}\u{1164}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B348}",
        nfc: "\u{B348}",
        nfd: "\u{1103}\u{1164}\u{11B7}",
        nfkc: "\u{B348}",
        nfkd: "\u{1103}\u{1164}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B349}",
        nfc: "\u{B349}",
        nfd: "\u{1103}\u{1164}\u{11B8}",
        nfkc: "\u{B349}",
        nfkd: "\u{1103}\u{1164}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B34A}",
        nfc: "\u{B34A}",
        nfd: "\u{1103}\u{1164}\u{11B9}",
        nfkc: "\u{B34A}",
        nfkd: "\u{1103}\u{1164}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B34B}",
        nfc: "\u{B34B}",
        nfd: "\u{1103}\u{1164}\u{11BA}",
        nfkc: "\u{B34B}",
        nfkd: "\u{1103}\u{1164}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B34C}",
        nfc: "\u{B34C}",
        nfd: "\u{1103}\u{1164}\u{11BB}",
        nfkc: "\u{B34C}",
        nfkd: "\u{1103}\u{1164}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B34D}",
        nfc: "\u{B34D}",
        nfd: "\u{1103}\u{1164}\u{11BC}",
        nfkc: "\u{B34D}",
        nfkd: "\u{1103}\u{1164}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B34E}",
        nfc: "\u{B34E}",
        nfd: "\u{1103}\u{1164}\u{11BD}",
        nfkc: "\u{B34E}",
        nfkd: "\u{1103}\u{1164}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B34F}",
        nfc: "\u{B34F}",
        nfd: "\u{1103}\u{1164}\u{11BE}",
        nfkc: "\u{B34F}",
        nfkd: "\u{1103}\u{1164}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B350}",
        nfc: "\u{B350}",
        nfd: "\u{1103}\u{1164}\u{11BF}",
        nfkc: "\u{B350}",
        nfkd: "\u{1103}\u{1164}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B351}",
        nfc: "\u{B351}",
        nfd: "\u{1103}\u{1164}\u{11C0}",
        nfkc: "\u{B351}",
        nfkd: "\u{1103}\u{1164}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B352}",
        nfc: "\u{B352}",
        nfd: "\u{1103}\u{1164}\u{11C1}",
        nfkc: "\u{B352}",
        nfkd: "\u{1103}\u{1164}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B353}",
        nfc: "\u{B353}",
        nfd: "\u{1103}\u{1164}\u{11C2}",
        nfkc: "\u{B353}",
        nfkd: "\u{1103}\u{1164}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B354}",
        nfc: "\u{B354}",
        nfd: "\u{1103}\u{1165}",
        nfkc: "\u{B354}",
        nfkd: "\u{1103}\u{1165}",
    },
    NormalizationTest {
        source: "\u{B355}",
        nfc: "\u{B355}",
        nfd: "\u{1103}\u{1165}\u{11A8}",
        nfkc: "\u{B355}",
        nfkd: "\u{1103}\u{1165}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B356}",
        nfc: "\u{B356}",
        nfd: "\u{1103}\u{1165}\u{11A9}",
        nfkc: "\u{B356}",
        nfkd: "\u{1103}\u{1165}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B357}",
        nfc: "\u{B357}",
        nfd: "\u{1103}\u{1165}\u{11AA}",
        nfkc: "\u{B357}",
        nfkd: "\u{1103}\u{1165}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B358}",
        nfc: "\u{B358}",
        nfd: "\u{1103}\u{1165}\u{11AB}",
        nfkc: "\u{B358}",
        nfkd: "\u{1103}\u{1165}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B359}",
        nfc: "\u{B359}",
        nfd: "\u{1103}\u{1165}\u{11AC}",
        nfkc: "\u{B359}",
        nfkd: "\u{1103}\u{1165}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B35A}",
        nfc: "\u{B35A}",
        nfd: "\u{1103}\u{1165}\u{11AD}",
        nfkc: "\u{B35A}",
        nfkd: "\u{1103}\u{1165}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B35B}",
        nfc: "\u{B35B}",
        nfd: "\u{1103}\u{1165}\u{11AE}",
        nfkc: "\u{B35B}",
        nfkd: "\u{1103}\u{1165}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B35C}",
        nfc: "\u{B35C}",
        nfd: "\u{1103}\u{1165}\u{11AF}",
        nfkc: "\u{B35C}",
        nfkd: "\u{1103}\u{1165}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B35D}",
        nfc: "\u{B35D}",
        nfd: "\u{1103}\u{1165}\u{11B0}",
        nfkc: "\u{B35D}",
        nfkd: "\u{1103}\u{1165}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B35E}",
        nfc: "\u{B35E}",
        nfd: "\u{1103}\u{1165}\u{11B1}",
        nfkc: "\u{B35E}",
        nfkd: "\u{1103}\u{1165}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B35F}",
        nfc: "\u{B35F}",
        nfd: "\u{1103}\u{1165}\u{11B2}",
        nfkc: "\u{B35F}",
        nfkd: "\u{1103}\u{1165}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B360}",
        nfc: "\u{B360}",
        nfd: "\u{1103}\u{1165}\u{11B3}",
        nfkc: "\u{B360}",
        nfkd: "\u{1103}\u{1165}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B361}",
        nfc: "\u{B361}",
        nfd: "\u{1103}\u{1165}\u{11B4}",
        nfkc: "\u{B361}",
        nfkd: "\u{1103}\u{1165}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B362}",
        nfc: "\u{B362}",
        nfd: "\u{1103}\u{1165}\u{11B5}",
        nfkc: "\u{B362}",
        nfkd: "\u{1103}\u{1165}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B363}",
        nfc: "\u{B363}",
        nfd: "\u{1103}\u{1165}\u{11B6}",
        nfkc: "\u{B363}",
        nfkd: "\u{1103}\u{1165}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B364}",
        nfc: "\u{B364}",
        nfd: "\u{1103}\u{1165}\u{11B7}",
        nfkc: "\u{B364}",
        nfkd: "\u{1103}\u{1165}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B365}",
        nfc: "\u{B365}",
        nfd: "\u{1103}\u{1165}\u{11B8}",
        nfkc: "\u{B365}",
        nfkd: "\u{1103}\u{1165}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B366}",
        nfc: "\u{B366}",
        nfd: "\u{1103}\u{1165}\u{11B9}",
        nfkc: "\u{B366}",
        nfkd: "\u{1103}\u{1165}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B367}",
        nfc: "\u{B367}",
        nfd: "\u{1103}\u{1165}\u{11BA}",
        nfkc: "\u{B367}",
        nfkd: "\u{1103}\u{1165}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B368}",
        nfc: "\u{B368}",
        nfd: "\u{1103}\u{1165}\u{11BB}",
        nfkc: "\u{B368}",
        nfkd: "\u{1103}\u{1165}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B369}",
        nfc: "\u{B369}",
        nfd: "\u{1103}\u{1165}\u{11BC}",
        nfkc: "\u{B369}",
        nfkd: "\u{1103}\u{1165}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B36A}",
        nfc: "\u{B36A}",
        nfd: "\u{1103}\u{1165}\u{11BD}",
        nfkc: "\u{B36A}",
        nfkd: "\u{1103}\u{1165}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B36B}",
        nfc: "\u{B36B}",
        nfd: "\u{1103}\u{1165}\u{11BE}",
        nfkc: "\u{B36B}",
        nfkd: "\u{1103}\u{1165}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B36C}",
        nfc: "\u{B36C}",
        nfd: "\u{1103}\u{1165}\u{11BF}",
        nfkc: "\u{B36C}",
        nfkd: "\u{1103}\u{1165}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B36D}",
        nfc: "\u{B36D}",
        nfd: "\u{1103}\u{1165}\u{11C0}",
        nfkc: "\u{B36D}",
        nfkd: "\u{1103}\u{1165}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B36E}",
        nfc: "\u{B36E}",
        nfd: "\u{1103}\u{1165}\u{11C1}",
        nfkc: "\u{B36E}",
        nfkd: "\u{1103}\u{1165}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B36F}",
        nfc: "\u{B36F}",
        nfd: "\u{1103}\u{1165}\u{11C2}",
        nfkc: "\u{B36F}",
        nfkd: "\u{1103}\u{1165}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B370}",
        nfc: "\u{B370}",
        nfd: "\u{1103}\u{1166}",
        nfkc: "\u{B370}",
        nfkd: "\u{1103}\u{1166}",
    },
    NormalizationTest {
        source: "\u{B371}",
        nfc: "\u{B371}",
        nfd: "\u{1103}\u{1166}\u{11A8}",
        nfkc: "\u{B371}",
        nfkd: "\u{1103}\u{1166}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B372}",
        nfc: "\u{B372}",
        nfd: "\u{1103}\u{1166}\u{11A9}",
        nfkc: "\u{B372}",
        nfkd: "\u{1103}\u{1166}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B373}",
        nfc: "\u{B373}",
        nfd: "\u{1103}\u{1166}\u{11AA}",
        nfkc: "\u{B373}",
        nfkd: "\u{1103}\u{1166}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B374}",
        nfc: "\u{B374}",
        nfd: "\u{1103}\u{1166}\u{11AB}",
        nfkc: "\u{B374}",
        nfkd: "\u{1103}\u{1166}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B375}",
        nfc: "\u{B375}",
        nfd: "\u{1103}\u{1166}\u{11AC}",
        nfkc: "\u{B375}",
        nfkd: "\u{1103}\u{1166}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B376}",
        nfc: "\u{B376}",
        nfd: "\u{1103}\u{1166}\u{11AD}",
        nfkc: "\u{B376}",
        nfkd: "\u{1103}\u{1166}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B377}",
        nfc: "\u{B377}",
        nfd: "\u{1103}\u{1166}\u{11AE}",
        nfkc: "\u{B377}",
        nfkd: "\u{1103}\u{1166}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B378}",
        nfc: "\u{B378}",
        nfd: "\u{1103}\u{1166}\u{11AF}",
        nfkc: "\u{B378}",
        nfkd: "\u{1103}\u{1166}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B379}",
        nfc: "\u{B379}",
        nfd: "\u{1103}\u{1166}\u{11B0}",
        nfkc: "\u{B379}",
        nfkd: "\u{1103}\u{1166}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B37A}",
        nfc: "\u{B37A}",
        nfd: "\u{1103}\u{1166}\u{11B1}",
        nfkc: "\u{B37A}",
        nfkd: "\u{1103}\u{1166}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B37B}",
        nfc: "\u{B37B}",
        nfd: "\u{1103}\u{1166}\u{11B2}",
        nfkc: "\u{B37B}",
        nfkd: "\u{1103}\u{1166}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B37C}",
        nfc: "\u{B37C}",
        nfd: "\u{1103}\u{1166}\u{11B3}",
        nfkc: "\u{B37C}",
        nfkd: "\u{1103}\u{1166}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B37D}",
        nfc: "\u{B37D}",
        nfd: "\u{1103}\u{1166}\u{11B4}",
        nfkc: "\u{B37D}",
        nfkd: "\u{1103}\u{1166}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B37E}",
        nfc: "\u{B37E}",
        nfd: "\u{1103}\u{1166}\u{11B5}",
        nfkc: "\u{B37E}",
        nfkd: "\u{1103}\u{1166}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B37F}",
        nfc: "\u{B37F}",
        nfd: "\u{1103}\u{1166}\u{11B6}",
        nfkc: "\u{B37F}",
        nfkd: "\u{1103}\u{1166}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B380}",
        nfc: "\u{B380}",
        nfd: "\u{1103}\u{1166}\u{11B7}",
        nfkc: "\u{B380}",
        nfkd: "\u{1103}\u{1166}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B381}",
        nfc: "\u{B381}",
        nfd: "\u{1103}\u{1166}\u{11B8}",
        nfkc: "\u{B381}",
        nfkd: "\u{1103}\u{1166}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B382}",
        nfc: "\u{B382}",
        nfd: "\u{1103}\u{1166}\u{11B9}",
        nfkc: "\u{B382}",
        nfkd: "\u{1103}\u{1166}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B383}",
        nfc: "\u{B383}",
        nfd: "\u{1103}\u{1166}\u{11BA}",
        nfkc: "\u{B383}",
        nfkd: "\u{1103}\u{1166}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B384}",
        nfc: "\u{B384}",
        nfd: "\u{1103}\u{1166}\u{11BB}",
        nfkc: "\u{B384}",
        nfkd: "\u{1103}\u{1166}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B385}",
        nfc: "\u{B385}",
        nfd: "\u{1103}\u{1166}\u{11BC}",
        nfkc: "\u{B385}",
        nfkd: "\u{1103}\u{1166}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B386}",
        nfc: "\u{B386}",
        nfd: "\u{1103}\u{1166}\u{11BD}",
        nfkc: "\u{B386}",
        nfkd: "\u{1103}\u{1166}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B387}",
        nfc: "\u{B387}",
        nfd: "\u{1103}\u{1166}\u{11BE}",
        nfkc: "\u{B387}",
        nfkd: "\u{1103}\u{1166}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B388}",
        nfc: "\u{B388}",
        nfd: "\u{1103}\u{1166}\u{11BF}",
        nfkc: "\u{B388}",
        nfkd: "\u{1103}\u{1166}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B389}",
        nfc: "\u{B389}",
        nfd: "\u{1103}\u{1166}\u{11C0}",
        nfkc: "\u{B389}",
        nfkd: "\u{1103}\u{1166}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B38A}",
        nfc: "\u{B38A}",
        nfd: "\u{1103}\u{1166}\u{11C1}",
        nfkc: "\u{B38A}",
        nfkd: "\u{1103}\u{1166}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B38B}",
        nfc: "\u{B38B}",
        nfd: "\u{1103}\u{1166}\u{11C2}",
        nfkc: "\u{B38B}",
        nfkd: "\u{1103}\u{1166}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B38C}",
        nfc: "\u{B38C}",
        nfd: "\u{1103}\u{1167}",
        nfkc: "\u{B38C}",
        nfkd: "\u{1103}\u{1167}",
    },
    NormalizationTest {
        source: "\u{B38D}",
        nfc: "\u{B38D}",
        nfd: "\u{1103}\u{1167}\u{11A8}",
        nfkc: "\u{B38D}",
        nfkd: "\u{1103}\u{1167}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B38E}",
        nfc: "\u{B38E}",
        nfd: "\u{1103}\u{1167}\u{11A9}",
        nfkc: "\u{B38E}",
        nfkd: "\u{1103}\u{1167}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B38F}",
        nfc: "\u{B38F}",
        nfd: "\u{1103}\u{1167}\u{11AA}",
        nfkc: "\u{B38F}",
        nfkd: "\u{1103}\u{1167}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B390}",
        nfc: "\u{B390}",
        nfd: "\u{1103}\u{1167}\u{11AB}",
        nfkc: "\u{B390}",
        nfkd: "\u{1103}\u{1167}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B391}",
        nfc: "\u{B391}",
        nfd: "\u{1103}\u{1167}\u{11AC}",
        nfkc: "\u{B391}",
        nfkd: "\u{1103}\u{1167}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B392}",
        nfc: "\u{B392}",
        nfd: "\u{1103}\u{1167}\u{11AD}",
        nfkc: "\u{B392}",
        nfkd: "\u{1103}\u{1167}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B393}",
        nfc: "\u{B393}",
        nfd: "\u{1103}\u{1167}\u{11AE}",
        nfkc: "\u{B393}",
        nfkd: "\u{1103}\u{1167}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B394}",
        nfc: "\u{B394}",
        nfd: "\u{1103}\u{1167}\u{11AF}",
        nfkc: "\u{B394}",
        nfkd: "\u{1103}\u{1167}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B395}",
        nfc: "\u{B395}",
        nfd: "\u{1103}\u{1167}\u{11B0}",
        nfkc: "\u{B395}",
        nfkd: "\u{1103}\u{1167}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B396}",
        nfc: "\u{B396}",
        nfd: "\u{1103}\u{1167}\u{11B1}",
        nfkc: "\u{B396}",
        nfkd: "\u{1103}\u{1167}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B397}",
        nfc: "\u{B397}",
        nfd: "\u{1103}\u{1167}\u{11B2}",
        nfkc: "\u{B397}",
        nfkd: "\u{1103}\u{1167}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B398}",
        nfc: "\u{B398}",
        nfd: "\u{1103}\u{1167}\u{11B3}",
        nfkc: "\u{B398}",
        nfkd: "\u{1103}\u{1167}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B399}",
        nfc: "\u{B399}",
        nfd: "\u{1103}\u{1167}\u{11B4}",
        nfkc: "\u{B399}",
        nfkd: "\u{1103}\u{1167}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B39A}",
        nfc: "\u{B39A}",
        nfd: "\u{1103}\u{1167}\u{11B5}",
        nfkc: "\u{B39A}",
        nfkd: "\u{1103}\u{1167}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B39B}",
        nfc: "\u{B39B}",
        nfd: "\u{1103}\u{1167}\u{11B6}",
        nfkc: "\u{B39B}",
        nfkd: "\u{1103}\u{1167}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B39C}",
        nfc: "\u{B39C}",
        nfd: "\u{1103}\u{1167}\u{11B7}",
        nfkc: "\u{B39C}",
        nfkd: "\u{1103}\u{1167}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B39D}",
        nfc: "\u{B39D}",
        nfd: "\u{1103}\u{1167}\u{11B8}",
        nfkc: "\u{B39D}",
        nfkd: "\u{1103}\u{1167}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B39E}",
        nfc: "\u{B39E}",
        nfd: "\u{1103}\u{1167}\u{11B9}",
        nfkc: "\u{B39E}",
        nfkd: "\u{1103}\u{1167}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B39F}",
        nfc: "\u{B39F}",
        nfd: "\u{1103}\u{1167}\u{11BA}",
        nfkc: "\u{B39F}",
        nfkd: "\u{1103}\u{1167}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B3A0}",
        nfc: "\u{B3A0}",
        nfd: "\u{1103}\u{1167}\u{11BB}",
        nfkc: "\u{B3A0}",
        nfkd: "\u{1103}\u{1167}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B3A1}",
        nfc: "\u{B3A1}",
        nfd: "\u{1103}\u{1167}\u{11BC}",
        nfkc: "\u{B3A1}",
        nfkd: "\u{1103}\u{1167}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B3A2}",
        nfc: "\u{B3A2}",
        nfd: "\u{1103}\u{1167}\u{11BD}",
        nfkc: "\u{B3A2}",
        nfkd: "\u{1103}\u{1167}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B3A3}",
        nfc: "\u{B3A3}",
        nfd: "\u{1103}\u{1167}\u{11BE}",
        nfkc: "\u{B3A3}",
        nfkd: "\u{1103}\u{1167}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B3A4}",
        nfc: "\u{B3A4}",
        nfd: "\u{1103}\u{1167}\u{11BF}",
        nfkc: "\u{B3A4}",
        nfkd: "\u{1103}\u{1167}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B3A5}",
        nfc: "\u{B3A5}",
        nfd: "\u{1103}\u{1167}\u{11C0}",
        nfkc: "\u{B3A5}",
        nfkd: "\u{1103}\u{1167}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B3A6}",
        nfc: "\u{B3A6}",
        nfd: "\u{1103}\u{1167}\u{11C1}",
        nfkc: "\u{B3A6}",
        nfkd: "\u{1103}\u{1167}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B3A7}",
        nfc: "\u{B3A7}",
        nfd: "\u{1103}\u{1167}\u{11C2}",
        nfkc: "\u{B3A7}",
        nfkd: "\u{1103}\u{1167}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B3A8}",
        nfc: "\u{B3A8}",
        nfd: "\u{1103}\u{1168}",
        nfkc: "\u{B3A8}",
        nfkd: "\u{1103}\u{1168}",
    },
    NormalizationTest {
        source: "\u{B3A9}",
        nfc: "\u{B3A9}",
        nfd: "\u{1103}\u{1168}\u{11A8}",
        nfkc: "\u{B3A9}",
        nfkd: "\u{1103}\u{1168}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B3AA}",
        nfc: "\u{B3AA}",
        nfd: "\u{1103}\u{1168}\u{11A9}",
        nfkc: "\u{B3AA}",
        nfkd: "\u{1103}\u{1168}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B3AB}",
        nfc: "\u{B3AB}",
        nfd: "\u{1103}\u{1168}\u{11AA}",
        nfkc: "\u{B3AB}",
        nfkd: "\u{1103}\u{1168}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B3AC}",
        nfc: "\u{B3AC}",
        nfd: "\u{1103}\u{1168}\u{11AB}",
        nfkc: "\u{B3AC}",
        nfkd: "\u{1103}\u{1168}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B3AD}",
        nfc: "\u{B3AD}",
        nfd: "\u{1103}\u{1168}\u{11AC}",
        nfkc: "\u{B3AD}",
        nfkd: "\u{1103}\u{1168}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B3AE}",
        nfc: "\u{B3AE}",
        nfd: "\u{1103}\u{1168}\u{11AD}",
        nfkc: "\u{B3AE}",
        nfkd: "\u{1103}\u{1168}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B3AF}",
        nfc: "\u{B3AF}",
        nfd: "\u{1103}\u{1168}\u{11AE}",
        nfkc: "\u{B3AF}",
        nfkd: "\u{1103}\u{1168}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B3B0}",
        nfc: "\u{B3B0}",
        nfd: "\u{1103}\u{1168}\u{11AF}",
        nfkc: "\u{B3B0}",
        nfkd: "\u{1103}\u{1168}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B3B1}",
        nfc: "\u{B3B1}",
        nfd: "\u{1103}\u{1168}\u{11B0}",
        nfkc: "\u{B3B1}",
        nfkd: "\u{1103}\u{1168}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B3B2}",
        nfc: "\u{B3B2}",
        nfd: "\u{1103}\u{1168}\u{11B1}",
        nfkc: "\u{B3B2}",
        nfkd: "\u{1103}\u{1168}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B3B3}",
        nfc: "\u{B3B3}",
        nfd: "\u{1103}\u{1168}\u{11B2}",
        nfkc: "\u{B3B3}",
        nfkd: "\u{1103}\u{1168}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B3B4}",
        nfc: "\u{B3B4}",
        nfd: "\u{1103}\u{1168}\u{11B3}",
        nfkc: "\u{B3B4}",
        nfkd: "\u{1103}\u{1168}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B3B5}",
        nfc: "\u{B3B5}",
        nfd: "\u{1103}\u{1168}\u{11B4}",
        nfkc: "\u{B3B5}",
        nfkd: "\u{1103}\u{1168}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B3B6}",
        nfc: "\u{B3B6}",
        nfd: "\u{1103}\u{1168}\u{11B5}",
        nfkc: "\u{B3B6}",
        nfkd: "\u{1103}\u{1168}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B3B7}",
        nfc: "\u{B3B7}",
        nfd: "\u{1103}\u{1168}\u{11B6}",
        nfkc: "\u{B3B7}",
        nfkd: "\u{1103}\u{1168}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B3B8}",
        nfc: "\u{B3B8}",
        nfd: "\u{1103}\u{1168}\u{11B7}",
        nfkc: "\u{B3B8}",
        nfkd: "\u{1103}\u{1168}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B3B9}",
        nfc: "\u{B3B9}",
        nfd: "\u{1103}\u{1168}\u{11B8}",
        nfkc: "\u{B3B9}",
        nfkd: "\u{1103}\u{1168}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B3BA}",
        nfc: "\u{B3BA}",
        nfd: "\u{1103}\u{1168}\u{11B9}",
        nfkc: "\u{B3BA}",
        nfkd: "\u{1103}\u{1168}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B3BB}",
        nfc: "\u{B3BB}",
        nfd: "\u{1103}\u{1168}\u{11BA}",
        nfkc: "\u{B3BB}",
        nfkd: "\u{1103}\u{1168}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B3BC}",
        nfc: "\u{B3BC}",
        nfd: "\u{1103}\u{1168}\u{11BB}",
        nfkc: "\u{B3BC}",
        nfkd: "\u{1103}\u{1168}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B3BD}",
        nfc: "\u{B3BD}",
        nfd: "\u{1103}\u{1168}\u{11BC}",
        nfkc: "\u{B3BD}",
        nfkd: "\u{1103}\u{1168}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B3BE}",
        nfc: "\u{B3BE}",
        nfd: "\u{1103}\u{1168}\u{11BD}",
        nfkc: "\u{B3BE}",
        nfkd: "\u{1103}\u{1168}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B3BF}",
        nfc: "\u{B3BF}",
        nfd: "\u{1103}\u{1168}\u{11BE}",
        nfkc: "\u{B3BF}",
        nfkd: "\u{1103}\u{1168}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B3C0}",
        nfc: "\u{B3C0}",
        nfd: "\u{1103}\u{1168}\u{11BF}",
        nfkc: "\u{B3C0}",
        nfkd: "\u{1103}\u{1168}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B3C1}",
        nfc: "\u{B3C1}",
        nfd: "\u{1103}\u{1168}\u{11C0}",
        nfkc: "\u{B3C1}",
        nfkd: "\u{1103}\u{1168}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B3C2}",
        nfc: "\u{B3C2}",
        nfd: "\u{1103}\u{1168}\u{11C1}",
        nfkc: "\u{B3C2}",
        nfkd: "\u{1103}\u{1168}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B3C3}",
        nfc: "\u{B3C3}",
        nfd: "\u{1103}\u{1168}\u{11C2}",
        nfkc: "\u{B3C3}",
        nfkd: "\u{1103}\u{1168}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B3C4}",
        nfc: "\u{B3C4}",
        nfd: "\u{1103}\u{1169}",
        nfkc: "\u{B3C4}",
        nfkd: "\u{1103}\u{1169}",
    },
    NormalizationTest {
        source: "\u{B3C5}",
        nfc: "\u{B3C5}",
        nfd: "\u{1103}\u{1169}\u{11A8}",
        nfkc: "\u{B3C5}",
        nfkd: "\u{1103}\u{1169}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B3C6}",
        nfc: "\u{B3C6}",
        nfd: "\u{1103}\u{1169}\u{11A9}",
        nfkc: "\u{B3C6}",
        nfkd: "\u{1103}\u{1169}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B3C7}",
        nfc: "\u{B3C7}",
        nfd: "\u{1103}\u{1169}\u{11AA}",
        nfkc: "\u{B3C7}",
        nfkd: "\u{1103}\u{1169}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B3C8}",
        nfc: "\u{B3C8}",
        nfd: "\u{1103}\u{1169}\u{11AB}",
        nfkc: "\u{B3C8}",
        nfkd: "\u{1103}\u{1169}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B3C9}",
        nfc: "\u{B3C9}",
        nfd: "\u{1103}\u{1169}\u{11AC}",
        nfkc: "\u{B3C9}",
        nfkd: "\u{1103}\u{1169}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B3CA}",
        nfc: "\u{B3CA}",
        nfd: "\u{1103}\u{1169}\u{11AD}",
        nfkc: "\u{B3CA}",
        nfkd: "\u{1103}\u{1169}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B3CB}",
        nfc: "\u{B3CB}",
        nfd: "\u{1103}\u{1169}\u{11AE}",
        nfkc: "\u{B3CB}",
        nfkd: "\u{1103}\u{1169}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B3CC}",
        nfc: "\u{B3CC}",
        nfd: "\u{1103}\u{1169}\u{11AF}",
        nfkc: "\u{B3CC}",
        nfkd: "\u{1103}\u{1169}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B3CD}",
        nfc: "\u{B3CD}",
        nfd: "\u{1103}\u{1169}\u{11B0}",
        nfkc: "\u{B3CD}",
        nfkd: "\u{1103}\u{1169}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B3CE}",
        nfc: "\u{B3CE}",
        nfd: "\u{1103}\u{1169}\u{11B1}",
        nfkc: "\u{B3CE}",
        nfkd: "\u{1103}\u{1169}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B3CF}",
        nfc: "\u{B3CF}",
        nfd: "\u{1103}\u{1169}\u{11B2}",
        nfkc: "\u{B3CF}",
        nfkd: "\u{1103}\u{1169}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B3D0}",
        nfc: "\u{B3D0}",
        nfd: "\u{1103}\u{1169}\u{11B3}",
        nfkc: "\u{B3D0}",
        nfkd: "\u{1103}\u{1169}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B3D1}",
        nfc: "\u{B3D1}",
        nfd: "\u{1103}\u{1169}\u{11B4}",
        nfkc: "\u{B3D1}",
        nfkd: "\u{1103}\u{1169}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B3D2}",
        nfc: "\u{B3D2}",
        nfd: "\u{1103}\u{1169}\u{11B5}",
        nfkc: "\u{B3D2}",
        nfkd: "\u{1103}\u{1169}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B3D3}",
        nfc: "\u{B3D3}",
        nfd: "\u{1103}\u{1169}\u{11B6}",
        nfkc: "\u{B3D3}",
        nfkd: "\u{1103}\u{1169}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B3D4}",
        nfc: "\u{B3D4}",
        nfd: "\u{1103}\u{1169}\u{11B7}",
        nfkc: "\u{B3D4}",
        nfkd: "\u{1103}\u{1169}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B3D5}",
        nfc: "\u{B3D5}",
        nfd: "\u{1103}\u{1169}\u{11B8}",
        nfkc: "\u{B3D5}",
        nfkd: "\u{1103}\u{1169}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B3D6}",
        nfc: "\u{B3D6}",
        nfd: "\u{1103}\u{1169}\u{11B9}",
        nfkc: "\u{B3D6}",
        nfkd: "\u{1103}\u{1169}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B3D7}",
        nfc: "\u{B3D7}",
        nfd: "\u{1103}\u{1169}\u{11BA}",
        nfkc: "\u{B3D7}",
        nfkd: "\u{1103}\u{1169}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B3D8}",
        nfc: "\u{B3D8}",
        nfd: "\u{1103}\u{1169}\u{11BB}",
        nfkc: "\u{B3D8}",
        nfkd: "\u{1103}\u{1169}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B3D9}",
        nfc: "\u{B3D9}",
        nfd: "\u{1103}\u{1169}\u{11BC}",
        nfkc: "\u{B3D9}",
        nfkd: "\u{1103}\u{1169}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B3DA}",
        nfc: "\u{B3DA}",
        nfd: "\u{1103}\u{1169}\u{11BD}",
        nfkc: "\u{B3DA}",
        nfkd: "\u{1103}\u{1169}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B3DB}",
        nfc: "\u{B3DB}",
        nfd: "\u{1103}\u{1169}\u{11BE}",
        nfkc: "\u{B3DB}",
        nfkd: "\u{1103}\u{1169}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B3DC}",
        nfc: "\u{B3DC}",
        nfd: "\u{1103}\u{1169}\u{11BF}",
        nfkc: "\u{B3DC}",
        nfkd: "\u{1103}\u{1169}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B3DD}",
        nfc: "\u{B3DD}",
        nfd: "\u{1103}\u{1169}\u{11C0}",
        nfkc: "\u{B3DD}",
        nfkd: "\u{1103}\u{1169}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B3DE}",
        nfc: "\u{B3DE}",
        nfd: "\u{1103}\u{1169}\u{11C1}",
        nfkc: "\u{B3DE}",
        nfkd: "\u{1103}\u{1169}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B3DF}",
        nfc: "\u{B3DF}",
        nfd: "\u{1103}\u{1169}\u{11C2}",
        nfkc: "\u{B3DF}",
        nfkd: "\u{1103}\u{1169}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B3E0}",
        nfc: "\u{B3E0}",
        nfd: "\u{1103}\u{116A}",
        nfkc: "\u{B3E0}",
        nfkd: "\u{1103}\u{116A}",
    },
    NormalizationTest {
        source: "\u{B3E1}",
        nfc: "\u{B3E1}",
        nfd: "\u{1103}\u{116A}\u{11A8}",
        nfkc: "\u{B3E1}",
        nfkd: "\u{1103}\u{116A}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B3E2}",
        nfc: "\u{B3E2}",
        nfd: "\u{1103}\u{116A}\u{11A9}",
        nfkc: "\u{B3E2}",
        nfkd: "\u{1103}\u{116A}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B3E3}",
        nfc: "\u{B3E3}",
        nfd: "\u{1103}\u{116A}\u{11AA}",
        nfkc: "\u{B3E3}",
        nfkd: "\u{1103}\u{116A}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B3E4}",
        nfc: "\u{B3E4}",
        nfd: "\u{1103}\u{116A}\u{11AB}",
        nfkc: "\u{B3E4}",
        nfkd: "\u{1103}\u{116A}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B3E5}",
        nfc: "\u{B3E5}",
        nfd: "\u{1103}\u{116A}\u{11AC}",
        nfkc: "\u{B3E5}",
        nfkd: "\u{1103}\u{116A}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B3E6}",
        nfc: "\u{B3E6}",
        nfd: "\u{1103}\u{116A}\u{11AD}",
        nfkc: "\u{B3E6}",
        nfkd: "\u{1103}\u{116A}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B3E7}",
        nfc: "\u{B3E7}",
        nfd: "\u{1103}\u{116A}\u{11AE}",
        nfkc: "\u{B3E7}",
        nfkd: "\u{1103}\u{116A}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B3E8}",
        nfc: "\u{B3E8}",
        nfd: "\u{1103}\u{116A}\u{11AF}",
        nfkc: "\u{B3E8}",
        nfkd: "\u{1103}\u{116A}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B3E9}",
        nfc: "\u{B3E9}",
        nfd: "\u{1103}\u{116A}\u{11B0}",
        nfkc: "\u{B3E9}",
        nfkd: "\u{1103}\u{116A}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B3EA}",
        nfc: "\u{B3EA}",
        nfd: "\u{1103}\u{116A}\u{11B1}",
        nfkc: "\u{B3EA}",
        nfkd: "\u{1103}\u{116A}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B3EB}",
        nfc: "\u{B3EB}",
        nfd: "\u{1103}\u{116A}\u{11B2}",
        nfkc: "\u{B3EB}",
        nfkd: "\u{1103}\u{116A}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B3EC}",
        nfc: "\u{B3EC}",
        nfd: "\u{1103}\u{116A}\u{11B3}",
        nfkc: "\u{B3EC}",
        nfkd: "\u{1103}\u{116A}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B3ED}",
        nfc: "\u{B3ED}",
        nfd: "\u{1103}\u{116A}\u{11B4}",
        nfkc: "\u{B3ED}",
        nfkd: "\u{1103}\u{116A}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B3EE}",
        nfc: "\u{B3EE}",
        nfd: "\u{1103}\u{116A}\u{11B5}",
        nfkc: "\u{B3EE}",
        nfkd: "\u{1103}\u{116A}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B3EF}",
        nfc: "\u{B3EF}",
        nfd: "\u{1103}\u{116A}\u{11B6}",
        nfkc: "\u{B3EF}",
        nfkd: "\u{1103}\u{116A}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B3F0}",
        nfc: "\u{B3F0}",
        nfd: "\u{1103}\u{116A}\u{11B7}",
        nfkc: "\u{B3F0}",
        nfkd: "\u{1103}\u{116A}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B3F1}",
        nfc: "\u{B3F1}",
        nfd: "\u{1103}\u{116A}\u{11B8}",
        nfkc: "\u{B3F1}",
        nfkd: "\u{1103}\u{116A}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B3F2}",
        nfc: "\u{B3F2}",
        nfd: "\u{1103}\u{116A}\u{11B9}",
        nfkc: "\u{B3F2}",
        nfkd: "\u{1103}\u{116A}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B3F3}",
        nfc: "\u{B3F3}",
        nfd: "\u{1103}\u{116A}\u{11BA}",
        nfkc: "\u{B3F3}",
        nfkd: "\u{1103}\u{116A}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B3F4}",
        nfc: "\u{B3F4}",
        nfd: "\u{1103}\u{116A}\u{11BB}",
        nfkc: "\u{B3F4}",
        nfkd: "\u{1103}\u{116A}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B3F5}",
        nfc: "\u{B3F5}",
        nfd: "\u{1103}\u{116A}\u{11BC}",
        nfkc: "\u{B3F5}",
        nfkd: "\u{1103}\u{116A}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B3F6}",
        nfc: "\u{B3F6}",
        nfd: "\u{1103}\u{116A}\u{11BD}",
        nfkc: "\u{B3F6}",
        nfkd: "\u{1103}\u{116A}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B3F7}",
        nfc: "\u{B3F7}",
        nfd: "\u{1103}\u{116A}\u{11BE}",
        nfkc: "\u{B3F7}",
        nfkd: "\u{1103}\u{116A}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B3F8}",
        nfc: "\u{B3F8}",
        nfd: "\u{1103}\u{116A}\u{11BF}",
        nfkc: "\u{B3F8}",
        nfkd: "\u{1103}\u{116A}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B3F9}",
        nfc: "\u{B3F9}",
        nfd: "\u{1103}\u{116A}\u{11C0}",
        nfkc: "\u{B3F9}",
        nfkd: "\u{1103}\u{116A}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B3FA}",
        nfc: "\u{B3FA}",
        nfd: "\u{1103}\u{116A}\u{11C1}",
        nfkc: "\u{B3FA}",
        nfkd: "\u{1103}\u{116A}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B3FB}",
        nfc: "\u{B3FB}",
        nfd: "\u{1103}\u{116A}\u{11C2}",
        nfkc: "\u{B3FB}",
        nfkd: "\u{1103}\u{116A}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B3FC}",
        nfc: "\u{B3FC}",
        nfd: "\u{1103}\u{116B}",
        nfkc: "\u{B3FC}",
        nfkd: "\u{1103}\u{116B}",
    },
    NormalizationTest {
        source: "\u{B3FD}",
        nfc: "\u{B3FD}",
        nfd: "\u{1103}\u{116B}\u{11A8}",
        nfkc: "\u{B3FD}",
        nfkd: "\u{1103}\u{116B}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B3FE}",
        nfc: "\u{B3FE}",
        nfd: "\u{1103}\u{116B}\u{11A9}",
        nfkc: "\u{B3FE}",
        nfkd: "\u{1103}\u{116B}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B3FF}",
        nfc: "\u{B3FF}",
        nfd: "\u{1103}\u{116B}\u{11AA}",
        nfkc: "\u{B3FF}",
        nfkd: "\u{1103}\u{116B}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B400}",
        nfc: "\u{B400}",
        nfd: "\u{1103}\u{116B}\u{11AB}",
        nfkc: "\u{B400}",
        nfkd: "\u{1103}\u{116B}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B401}",
        nfc: "\u{B401}",
        nfd: "\u{1103}\u{116B}\u{11AC}",
        nfkc: "\u{B401}",
        nfkd: "\u{1103}\u{116B}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B402}",
        nfc: "\u{B402}",
        nfd: "\u{1103}\u{116B}\u{11AD}",
        nfkc: "\u{B402}",
        nfkd: "\u{1103}\u{116B}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B403}",
        nfc: "\u{B403}",
        nfd: "\u{1103}\u{116B}\u{11AE}",
        nfkc: "\u{B403}",
        nfkd: "\u{1103}\u{116B}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B404}",
        nfc: "\u{B404}",
        nfd: "\u{1103}\u{116B}\u{11AF}",
        nfkc: "\u{B404}",
        nfkd: "\u{1103}\u{116B}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B405}",
        nfc: "\u{B405}",
        nfd: "\u{1103}\u{116B}\u{11B0}",
        nfkc: "\u{B405}",
        nfkd: "\u{1103}\u{116B}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B406}",
        nfc: "\u{B406}",
        nfd: "\u{1103}\u{116B}\u{11B1}",
        nfkc: "\u{B406}",
        nfkd: "\u{1103}\u{116B}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B407}",
        nfc: "\u{B407}",
        nfd: "\u{1103}\u{116B}\u{11B2}",
        nfkc: "\u{B407}",
        nfkd: "\u{1103}\u{116B}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B408}",
        nfc: "\u{B408}",
        nfd: "\u{1103}\u{116B}\u{11B3}",
        nfkc: "\u{B408}",
        nfkd: "\u{1103}\u{116B}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B409}",
        nfc: "\u{B409}",
        nfd: "\u{1103}\u{116B}\u{11B4}",
        nfkc: "\u{B409}",
        nfkd: "\u{1103}\u{116B}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B40A}",
        nfc: "\u{B40A}",
        nfd: "\u{1103}\u{116B}\u{11B5}",
        nfkc: "\u{B40A}",
        nfkd: "\u{1103}\u{116B}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B40B}",
        nfc: "\u{B40B}",
        nfd: "\u{1103}\u{116B}\u{11B6}",
        nfkc: "\u{B40B}",
        nfkd: "\u{1103}\u{116B}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B40C}",
        nfc: "\u{B40C}",
        nfd: "\u{1103}\u{116B}\u{11B7}",
        nfkc: "\u{B40C}",
        nfkd: "\u{1103}\u{116B}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B40D}",
        nfc: "\u{B40D}",
        nfd: "\u{1103}\u{116B}\u{11B8}",
        nfkc: "\u{B40D}",
        nfkd: "\u{1103}\u{116B}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B40E}",
        nfc: "\u{B40E}",
        nfd: "\u{1103}\u{116B}\u{11B9}",
        nfkc: "\u{B40E}",
        nfkd: "\u{1103}\u{116B}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B40F}",
        nfc: "\u{B40F}",
        nfd: "\u{1103}\u{116B}\u{11BA}",
        nfkc: "\u{B40F}",
        nfkd: "\u{1103}\u{116B}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B410}",
        nfc: "\u{B410}",
        nfd: "\u{1103}\u{116B}\u{11BB}",
        nfkc: "\u{B410}",
        nfkd: "\u{1103}\u{116B}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B411}",
        nfc: "\u{B411}",
        nfd: "\u{1103}\u{116B}\u{11BC}",
        nfkc: "\u{B411}",
        nfkd: "\u{1103}\u{116B}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B412}",
        nfc: "\u{B412}",
        nfd: "\u{1103}\u{116B}\u{11BD}",
        nfkc: "\u{B412}",
        nfkd: "\u{1103}\u{116B}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B413}",
        nfc: "\u{B413}",
        nfd: "\u{1103}\u{116B}\u{11BE}",
        nfkc: "\u{B413}",
        nfkd: "\u{1103}\u{116B}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B414}",
        nfc: "\u{B414}",
        nfd: "\u{1103}\u{116B}\u{11BF}",
        nfkc: "\u{B414}",
        nfkd: "\u{1103}\u{116B}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B415}",
        nfc: "\u{B415}",
        nfd: "\u{1103}\u{116B}\u{11C0}",
        nfkc: "\u{B415}",
        nfkd: "\u{1103}\u{116B}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B416}",
        nfc: "\u{B416}",
        nfd: "\u{1103}\u{116B}\u{11C1}",
        nfkc: "\u{B416}",
        nfkd: "\u{1103}\u{116B}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B417}",
        nfc: "\u{B417}",
        nfd: "\u{1103}\u{116B}\u{11C2}",
        nfkc: "\u{B417}",
        nfkd: "\u{1103}\u{116B}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B418}",
        nfc: "\u{B418}",
        nfd: "\u{1103}\u{116C}",
        nfkc: "\u{B418}",
        nfkd: "\u{1103}\u{116C}",
    },
    NormalizationTest {
        source: "\u{B419}",
        nfc: "\u{B419}",
        nfd: "\u{1103}\u{116C}\u{11A8}",
        nfkc: "\u{B419}",
        nfkd: "\u{1103}\u{116C}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B41A}",
        nfc: "\u{B41A}",
        nfd: "\u{1103}\u{116C}\u{11A9}",
        nfkc: "\u{B41A}",
        nfkd: "\u{1103}\u{116C}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B41B}",
        nfc: "\u{B41B}",
        nfd: "\u{1103}\u{116C}\u{11AA}",
        nfkc: "\u{B41B}",
        nfkd: "\u{1103}\u{116C}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B41C}",
        nfc: "\u{B41C}",
        nfd: "\u{1103}\u{116C}\u{11AB}",
        nfkc: "\u{B41C}",
        nfkd: "\u{1103}\u{116C}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B41D}",
        nfc: "\u{B41D}",
        nfd: "\u{1103}\u{116C}\u{11AC}",
        nfkc: "\u{B41D}",
        nfkd: "\u{1103}\u{116C}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B41E}",
        nfc: "\u{B41E}",
        nfd: "\u{1103}\u{116C}\u{11AD}",
        nfkc: "\u{B41E}",
        nfkd: "\u{1103}\u{116C}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B41F}",
        nfc: "\u{B41F}",
        nfd: "\u{1103}\u{116C}\u{11AE}",
        nfkc: "\u{B41F}",
        nfkd: "\u{1103}\u{116C}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B420}",
        nfc: "\u{B420}",
        nfd: "\u{1103}\u{116C}\u{11AF}",
        nfkc: "\u{B420}",
        nfkd: "\u{1103}\u{116C}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B421}",
        nfc: "\u{B421}",
        nfd: "\u{1103}\u{116C}\u{11B0}",
        nfkc: "\u{B421}",
        nfkd: "\u{1103}\u{116C}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B422}",
        nfc: "\u{B422}",
        nfd: "\u{1103}\u{116C}\u{11B1}",
        nfkc: "\u{B422}",
        nfkd: "\u{1103}\u{116C}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B423}",
        nfc: "\u{B423}",
        nfd: "\u{1103}\u{116C}\u{11B2}",
        nfkc: "\u{B423}",
        nfkd: "\u{1103}\u{116C}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B424}",
        nfc: "\u{B424}",
        nfd: "\u{1103}\u{116C}\u{11B3}",
        nfkc: "\u{B424}",
        nfkd: "\u{1103}\u{116C}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B425}",
        nfc: "\u{B425}",
        nfd: "\u{1103}\u{116C}\u{11B4}",
        nfkc: "\u{B425}",
        nfkd: "\u{1103}\u{116C}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B426}",
        nfc: "\u{B426}",
        nfd: "\u{1103}\u{116C}\u{11B5}",
        nfkc: "\u{B426}",
        nfkd: "\u{1103}\u{116C}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B427}",
        nfc: "\u{B427}",
        nfd: "\u{1103}\u{116C}\u{11B6}",
        nfkc: "\u{B427}",
        nfkd: "\u{1103}\u{116C}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B428}",
        nfc: "\u{B428}",
        nfd: "\u{1103}\u{116C}\u{11B7}",
        nfkc: "\u{B428}",
        nfkd: "\u{1103}\u{116C}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B429}",
        nfc: "\u{B429}",
        nfd: "\u{1103}\u{116C}\u{11B8}",
        nfkc: "\u{B429}",
        nfkd: "\u{1103}\u{116C}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B42A}",
        nfc: "\u{B42A}",
        nfd: "\u{1103}\u{116C}\u{11B9}",
        nfkc: "\u{B42A}",
        nfkd: "\u{1103}\u{116C}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B42B}",
        nfc: "\u{B42B}",
        nfd: "\u{1103}\u{116C}\u{11BA}",
        nfkc: "\u{B42B}",
        nfkd: "\u{1103}\u{116C}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B42C}",
        nfc: "\u{B42C}",
        nfd: "\u{1103}\u{116C}\u{11BB}",
        nfkc: "\u{B42C}",
        nfkd: "\u{1103}\u{116C}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B42D}",
        nfc: "\u{B42D}",
        nfd: "\u{1103}\u{116C}\u{11BC}",
        nfkc: "\u{B42D}",
        nfkd: "\u{1103}\u{116C}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B42E}",
        nfc: "\u{B42E}",
        nfd: "\u{1103}\u{116C}\u{11BD}",
        nfkc: "\u{B42E}",
        nfkd: "\u{1103}\u{116C}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B42F}",
        nfc: "\u{B42F}",
        nfd: "\u{1103}\u{116C}\u{11BE}",
        nfkc: "\u{B42F}",
        nfkd: "\u{1103}\u{116C}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B430}",
        nfc: "\u{B430}",
        nfd: "\u{1103}\u{116C}\u{11BF}",
        nfkc: "\u{B430}",
        nfkd: "\u{1103}\u{116C}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B431}",
        nfc: "\u{B431}",
        nfd: "\u{1103}\u{116C}\u{11C0}",
        nfkc: "\u{B431}",
        nfkd: "\u{1103}\u{116C}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B432}",
        nfc: "\u{B432}",
        nfd: "\u{1103}\u{116C}\u{11C1}",
        nfkc: "\u{B432}",
        nfkd: "\u{1103}\u{116C}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B433}",
        nfc: "\u{B433}",
        nfd: "\u{1103}\u{116C}\u{11C2}",
        nfkc: "\u{B433}",
        nfkd: "\u{1103}\u{116C}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B434}",
        nfc: "\u{B434}",
        nfd: "\u{1103}\u{116D}",
        nfkc: "\u{B434}",
        nfkd: "\u{1103}\u{116D}",
    },
    NormalizationTest {
        source: "\u{B435}",
        nfc: "\u{B435}",
        nfd: "\u{1103}\u{116D}\u{11A8}",
        nfkc: "\u{B435}",
        nfkd: "\u{1103}\u{116D}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B436}",
        nfc: "\u{B436}",
        nfd: "\u{1103}\u{116D}\u{11A9}",
        nfkc: "\u{B436}",
        nfkd: "\u{1103}\u{116D}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B437}",
        nfc: "\u{B437}",
        nfd: "\u{1103}\u{116D}\u{11AA}",
        nfkc: "\u{B437}",
        nfkd: "\u{1103}\u{116D}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B438}",
        nfc: "\u{B438}",
        nfd: "\u{1103}\u{116D}\u{11AB}",
        nfkc: "\u{B438}",
        nfkd: "\u{1103}\u{116D}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B439}",
        nfc: "\u{B439}",
        nfd: "\u{1103}\u{116D}\u{11AC}",
        nfkc: "\u{B439}",
        nfkd: "\u{1103}\u{116D}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B43A}",
        nfc: "\u{B43A}",
        nfd: "\u{1103}\u{116D}\u{11AD}",
        nfkc: "\u{B43A}",
        nfkd: "\u{1103}\u{116D}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B43B}",
        nfc: "\u{B43B}",
        nfd: "\u{1103}\u{116D}\u{11AE}",
        nfkc: "\u{B43B}",
        nfkd: "\u{1103}\u{116D}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B43C}",
        nfc: "\u{B43C}",
        nfd: "\u{1103}\u{116D}\u{11AF}",
        nfkc: "\u{B43C}",
        nfkd: "\u{1103}\u{116D}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B43D}",
        nfc: "\u{B43D}",
        nfd: "\u{1103}\u{116D}\u{11B0}",
        nfkc: "\u{B43D}",
        nfkd: "\u{1103}\u{116D}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B43E}",
        nfc: "\u{B43E}",
        nfd: "\u{1103}\u{116D}\u{11B1}",
        nfkc: "\u{B43E}",
        nfkd: "\u{1103}\u{116D}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B43F}",
        nfc: "\u{B43F}",
        nfd: "\u{1103}\u{116D}\u{11B2}",
        nfkc: "\u{B43F}",
        nfkd: "\u{1103}\u{116D}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B440}",
        nfc: "\u{B440}",
        nfd: "\u{1103}\u{116D}\u{11B3}",
        nfkc: "\u{B440}",
        nfkd: "\u{1103}\u{116D}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B441}",
        nfc: "\u{B441}",
        nfd: "\u{1103}\u{116D}\u{11B4}",
        nfkc: "\u{B441}",
        nfkd: "\u{1103}\u{116D}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B442}",
        nfc: "\u{B442}",
        nfd: "\u{1103}\u{116D}\u{11B5}",
        nfkc: "\u{B442}",
        nfkd: "\u{1103}\u{116D}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B443}",
        nfc: "\u{B443}",
        nfd: "\u{1103}\u{116D}\u{11B6}",
        nfkc: "\u{B443}",
        nfkd: "\u{1103}\u{116D}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B444}",
        nfc: "\u{B444}",
        nfd: "\u{1103}\u{116D}\u{11B7}",
        nfkc: "\u{B444}",
        nfkd: "\u{1103}\u{116D}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B445}",
        nfc: "\u{B445}",
        nfd: "\u{1103}\u{116D}\u{11B8}",
        nfkc: "\u{B445}",
        nfkd: "\u{1103}\u{116D}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B446}",
        nfc: "\u{B446}",
        nfd: "\u{1103}\u{116D}\u{11B9}",
        nfkc: "\u{B446}",
        nfkd: "\u{1103}\u{116D}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B447}",
        nfc: "\u{B447}",
        nfd: "\u{1103}\u{116D}\u{11BA}",
        nfkc: "\u{B447}",
        nfkd: "\u{1103}\u{116D}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B448}",
        nfc: "\u{B448}",
        nfd: "\u{1103}\u{116D}\u{11BB}",
        nfkc: "\u{B448}",
        nfkd: "\u{1103}\u{116D}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B449}",
        nfc: "\u{B449}",
        nfd: "\u{1103}\u{116D}\u{11BC}",
        nfkc: "\u{B449}",
        nfkd: "\u{1103}\u{116D}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B44A}",
        nfc: "\u{B44A}",
        nfd: "\u{1103}\u{116D}\u{11BD}",
        nfkc: "\u{B44A}",
        nfkd: "\u{1103}\u{116D}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B44B}",
        nfc: "\u{B44B}",
        nfd: "\u{1103}\u{116D}\u{11BE}",
        nfkc: "\u{B44B}",
        nfkd: "\u{1103}\u{116D}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B44C}",
        nfc: "\u{B44C}",
        nfd: "\u{1103}\u{116D}\u{11BF}",
        nfkc: "\u{B44C}",
        nfkd: "\u{1103}\u{116D}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B44D}",
        nfc: "\u{B44D}",
        nfd: "\u{1103}\u{116D}\u{11C0}",
        nfkc: "\u{B44D}",
        nfkd: "\u{1103}\u{116D}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B44E}",
        nfc: "\u{B44E}",
        nfd: "\u{1103}\u{116D}\u{11C1}",
        nfkc: "\u{B44E}",
        nfkd: "\u{1103}\u{116D}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B44F}",
        nfc: "\u{B44F}",
        nfd: "\u{1103}\u{116D}\u{11C2}",
        nfkc: "\u{B44F}",
        nfkd: "\u{1103}\u{116D}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B450}",
        nfc: "\u{B450}",
        nfd: "\u{1103}\u{116E}",
        nfkc: "\u{B450}",
        nfkd: "\u{1103}\u{116E}",
    },
    NormalizationTest {
        source: "\u{B451}",
        nfc: "\u{B451}",
        nfd: "\u{1103}\u{116E}\u{11A8}",
        nfkc: "\u{B451}",
        nfkd: "\u{1103}\u{116E}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B452}",
        nfc: "\u{B452}",
        nfd: "\u{1103}\u{116E}\u{11A9}",
        nfkc: "\u{B452}",
        nfkd: "\u{1103}\u{116E}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B453}",
        nfc: "\u{B453}",
        nfd: "\u{1103}\u{116E}\u{11AA}",
        nfkc: "\u{B453}",
        nfkd: "\u{1103}\u{116E}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B454}",
        nfc: "\u{B454}",
        nfd: "\u{1103}\u{116E}\u{11AB}",
        nfkc: "\u{B454}",
        nfkd: "\u{1103}\u{116E}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B455}",
        nfc: "\u{B455}",
        nfd: "\u{1103}\u{116E}\u{11AC}",
        nfkc: "\u{B455}",
        nfkd: "\u{1103}\u{116E}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B456}",
        nfc: "\u{B456}",
        nfd: "\u{1103}\u{116E}\u{11AD}",
        nfkc: "\u{B456}",
        nfkd: "\u{1103}\u{116E}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B457}",
        nfc: "\u{B457}",
        nfd: "\u{1103}\u{116E}\u{11AE}",
        nfkc: "\u{B457}",
        nfkd: "\u{1103}\u{116E}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B458}",
        nfc: "\u{B458}",
        nfd: "\u{1103}\u{116E}\u{11AF}",
        nfkc: "\u{B458}",
        nfkd: "\u{1103}\u{116E}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B459}",
        nfc: "\u{B459}",
        nfd: "\u{1103}\u{116E}\u{11B0}",
        nfkc: "\u{B459}",
        nfkd: "\u{1103}\u{116E}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B45A}",
        nfc: "\u{B45A}",
        nfd: "\u{1103}\u{116E}\u{11B1}",
        nfkc: "\u{B45A}",
        nfkd: "\u{1103}\u{116E}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B45B}",
        nfc: "\u{B45B}",
        nfd: "\u{1103}\u{116E}\u{11B2}",
        nfkc: "\u{B45B}",
        nfkd: "\u{1103}\u{116E}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B45C}",
        nfc: "\u{B45C}",
        nfd: "\u{1103}\u{116E}\u{11B3}",
        nfkc: "\u{B45C}",
        nfkd: "\u{1103}\u{116E}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B45D}",
        nfc: "\u{B45D}",
        nfd: "\u{1103}\u{116E}\u{11B4}",
        nfkc: "\u{B45D}",
        nfkd: "\u{1103}\u{116E}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B45E}",
        nfc: "\u{B45E}",
        nfd: "\u{1103}\u{116E}\u{11B5}",
        nfkc: "\u{B45E}",
        nfkd: "\u{1103}\u{116E}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B45F}",
        nfc: "\u{B45F}",
        nfd: "\u{1103}\u{116E}\u{11B6}",
        nfkc: "\u{B45F}",
        nfkd: "\u{1103}\u{116E}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B460}",
        nfc: "\u{B460}",
        nfd: "\u{1103}\u{116E}\u{11B7}",
        nfkc: "\u{B460}",
        nfkd: "\u{1103}\u{116E}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B461}",
        nfc: "\u{B461}",
        nfd: "\u{1103}\u{116E}\u{11B8}",
        nfkc: "\u{B461}",
        nfkd: "\u{1103}\u{116E}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B462}",
        nfc: "\u{B462}",
        nfd: "\u{1103}\u{116E}\u{11B9}",
        nfkc: "\u{B462}",
        nfkd: "\u{1103}\u{116E}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B463}",
        nfc: "\u{B463}",
        nfd: "\u{1103}\u{116E}\u{11BA}",
        nfkc: "\u{B463}",
        nfkd: "\u{1103}\u{116E}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B464}",
        nfc: "\u{B464}",
        nfd: "\u{1103}\u{116E}\u{11BB}",
        nfkc: "\u{B464}",
        nfkd: "\u{1103}\u{116E}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B465}",
        nfc: "\u{B465}",
        nfd: "\u{1103}\u{116E}\u{11BC}",
        nfkc: "\u{B465}",
        nfkd: "\u{1103}\u{116E}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B466}",
        nfc: "\u{B466}",
        nfd: "\u{1103}\u{116E}\u{11BD}",
        nfkc: "\u{B466}",
        nfkd: "\u{1103}\u{116E}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B467}",
        nfc: "\u{B467}",
        nfd: "\u{1103}\u{116E}\u{11BE}",
        nfkc: "\u{B467}",
        nfkd: "\u{1103}\u{116E}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B468}",
        nfc: "\u{B468}",
        nfd: "\u{1103}\u{116E}\u{11BF}",
        nfkc: "\u{B468}",
        nfkd: "\u{1103}\u{116E}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B469}",
        nfc: "\u{B469}",
        nfd: "\u{1103}\u{116E}\u{11C0}",
        nfkc: "\u{B469}",
        nfkd: "\u{1103}\u{116E}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B46A}",
        nfc: "\u{B46A}",
        nfd: "\u{1103}\u{116E}\u{11C1}",
        nfkc: "\u{B46A}",
        nfkd: "\u{1103}\u{116E}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B46B}",
        nfc: "\u{B46B}",
        nfd: "\u{1103}\u{116E}\u{11C2}",
        nfkc: "\u{B46B}",
        nfkd: "\u{1103}\u{116E}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B46C}",
        nfc: "\u{B46C}",
        nfd: "\u{1103}\u{116F}",
        nfkc: "\u{B46C}",
        nfkd: "\u{1103}\u{116F}",
    },
    NormalizationTest {
        source: "\u{B46D}",
        nfc: "\u{B46D}",
        nfd: "\u{1103}\u{116F}\u{11A8}",
        nfkc: "\u{B46D}",
        nfkd: "\u{1103}\u{116F}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B46E}",
        nfc: "\u{B46E}",
        nfd: "\u{1103}\u{116F}\u{11A9}",
        nfkc: "\u{B46E}",
        nfkd: "\u{1103}\u{116F}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B46F}",
        nfc: "\u{B46F}",
        nfd: "\u{1103}\u{116F}\u{11AA}",
        nfkc: "\u{B46F}",
        nfkd: "\u{1103}\u{116F}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B470}",
        nfc: "\u{B470}",
        nfd: "\u{1103}\u{116F}\u{11AB}",
        nfkc: "\u{B470}",
        nfkd: "\u{1103}\u{116F}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B471}",
        nfc: "\u{B471}",
        nfd: "\u{1103}\u{116F}\u{11AC}",
        nfkc: "\u{B471}",
        nfkd: "\u{1103}\u{116F}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B472}",
        nfc: "\u{B472}",
        nfd: "\u{1103}\u{116F}\u{11AD}",
        nfkc: "\u{B472}",
        nfkd: "\u{1103}\u{116F}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B473}",
        nfc: "\u{B473}",
        nfd: "\u{1103}\u{116F}\u{11AE}",
        nfkc: "\u{B473}",
        nfkd: "\u{1103}\u{116F}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B474}",
        nfc: "\u{B474}",
        nfd: "\u{1103}\u{116F}\u{11AF}",
        nfkc: "\u{B474}",
        nfkd: "\u{1103}\u{116F}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B475}",
        nfc: "\u{B475}",
        nfd: "\u{1103}\u{116F}\u{11B0}",
        nfkc: "\u{B475}",
        nfkd: "\u{1103}\u{116F}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B476}",
        nfc: "\u{B476}",
        nfd: "\u{1103}\u{116F}\u{11B1}",
        nfkc: "\u{B476}",
        nfkd: "\u{1103}\u{116F}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B477}",
        nfc: "\u{B477}",
        nfd: "\u{1103}\u{116F}\u{11B2}",
        nfkc: "\u{B477}",
        nfkd: "\u{1103}\u{116F}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B478}",
        nfc: "\u{B478}",
        nfd: "\u{1103}\u{116F}\u{11B3}",
        nfkc: "\u{B478}",
        nfkd: "\u{1103}\u{116F}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B479}",
        nfc: "\u{B479}",
        nfd: "\u{1103}\u{116F}\u{11B4}",
        nfkc: "\u{B479}",
        nfkd: "\u{1103}\u{116F}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B47A}",
        nfc: "\u{B47A}",
        nfd: "\u{1103}\u{116F}\u{11B5}",
        nfkc: "\u{B47A}",
        nfkd: "\u{1103}\u{116F}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B47B}",
        nfc: "\u{B47B}",
        nfd: "\u{1103}\u{116F}\u{11B6}",
        nfkc: "\u{B47B}",
        nfkd: "\u{1103}\u{116F}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B47C}",
        nfc: "\u{B47C}",
        nfd: "\u{1103}\u{116F}\u{11B7}",
        nfkc: "\u{B47C}",
        nfkd: "\u{1103}\u{116F}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B47D}",
        nfc: "\u{B47D}",
        nfd: "\u{1103}\u{116F}\u{11B8}",
        nfkc: "\u{B47D}",
        nfkd: "\u{1103}\u{116F}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B47E}",
        nfc: "\u{B47E}",
        nfd: "\u{1103}\u{116F}\u{11B9}",
        nfkc: "\u{B47E}",
        nfkd: "\u{1103}\u{116F}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B47F}",
        nfc: "\u{B47F}",
        nfd: "\u{1103}\u{116F}\u{11BA}",
        nfkc: "\u{B47F}",
        nfkd: "\u{1103}\u{116F}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B480}",
        nfc: "\u{B480}",
        nfd: "\u{1103}\u{116F}\u{11BB}",
        nfkc: "\u{B480}",
        nfkd: "\u{1103}\u{116F}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B481}",
        nfc: "\u{B481}",
        nfd: "\u{1103}\u{116F}\u{11BC}",
        nfkc: "\u{B481}",
        nfkd: "\u{1103}\u{116F}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B482}",
        nfc: "\u{B482}",
        nfd: "\u{1103}\u{116F}\u{11BD}",
        nfkc: "\u{B482}",
        nfkd: "\u{1103}\u{116F}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B483}",
        nfc: "\u{B483}",
        nfd: "\u{1103}\u{116F}\u{11BE}",
        nfkc: "\u{B483}",
        nfkd: "\u{1103}\u{116F}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B484}",
        nfc: "\u{B484}",
        nfd: "\u{1103}\u{116F}\u{11BF}",
        nfkc: "\u{B484}",
        nfkd: "\u{1103}\u{116F}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B485}",
        nfc: "\u{B485}",
        nfd: "\u{1103}\u{116F}\u{11C0}",
        nfkc: "\u{B485}",
        nfkd: "\u{1103}\u{116F}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B486}",
        nfc: "\u{B486}",
        nfd: "\u{1103}\u{116F}\u{11C1}",
        nfkc: "\u{B486}",
        nfkd: "\u{1103}\u{116F}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B487}",
        nfc: "\u{B487}",
        nfd: "\u{1103}\u{116F}\u{11C2}",
        nfkc: "\u{B487}",
        nfkd: "\u{1103}\u{116F}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B488}",
        nfc: "\u{B488}",
        nfd: "\u{1103}\u{1170}",
        nfkc: "\u{B488}",
        nfkd: "\u{1103}\u{1170}",
    },
    NormalizationTest {
        source: "\u{B489}",
        nfc: "\u{B489}",
        nfd: "\u{1103}\u{1170}\u{11A8}",
        nfkc: "\u{B489}",
        nfkd: "\u{1103}\u{1170}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B48A}",
        nfc: "\u{B48A}",
        nfd: "\u{1103}\u{1170}\u{11A9}",
        nfkc: "\u{B48A}",
        nfkd: "\u{1103}\u{1170}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B48B}",
        nfc: "\u{B48B}",
        nfd: "\u{1103}\u{1170}\u{11AA}",
        nfkc: "\u{B48B}",
        nfkd: "\u{1103}\u{1170}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B48C}",
        nfc: "\u{B48C}",
        nfd: "\u{1103}\u{1170}\u{11AB}",
        nfkc: "\u{B48C}",
        nfkd: "\u{1103}\u{1170}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B48D}",
        nfc: "\u{B48D}",
        nfd: "\u{1103}\u{1170}\u{11AC}",
        nfkc: "\u{B48D}",
        nfkd: "\u{1103}\u{1170}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B48E}",
        nfc: "\u{B48E}",
        nfd: "\u{1103}\u{1170}\u{11AD}",
        nfkc: "\u{B48E}",
        nfkd: "\u{1103}\u{1170}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B48F}",
        nfc: "\u{B48F}",
        nfd: "\u{1103}\u{1170}\u{11AE}",
        nfkc: "\u{B48F}",
        nfkd: "\u{1103}\u{1170}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B490}",
        nfc: "\u{B490}",
        nfd: "\u{1103}\u{1170}\u{11AF}",
        nfkc: "\u{B490}",
        nfkd: "\u{1103}\u{1170}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B491}",
        nfc: "\u{B491}",
        nfd: "\u{1103}\u{1170}\u{11B0}",
        nfkc: "\u{B491}",
        nfkd: "\u{1103}\u{1170}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B492}",
        nfc: "\u{B492}",
        nfd: "\u{1103}\u{1170}\u{11B1}",
        nfkc: "\u{B492}",
        nfkd: "\u{1103}\u{1170}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B493}",
        nfc: "\u{B493}",
        nfd: "\u{1103}\u{1170}\u{11B2}",
        nfkc: "\u{B493}",
        nfkd: "\u{1103}\u{1170}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B494}",
        nfc: "\u{B494}",
        nfd: "\u{1103}\u{1170}\u{11B3}",
        nfkc: "\u{B494}",
        nfkd: "\u{1103}\u{1170}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B495}",
        nfc: "\u{B495}",
        nfd: "\u{1103}\u{1170}\u{11B4}",
        nfkc: "\u{B495}",
        nfkd: "\u{1103}\u{1170}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B496}",
        nfc: "\u{B496}",
        nfd: "\u{1103}\u{1170}\u{11B5}",
        nfkc: "\u{B496}",
        nfkd: "\u{1103}\u{1170}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B497}",
        nfc: "\u{B497}",
        nfd: "\u{1103}\u{1170}\u{11B6}",
        nfkc: "\u{B497}",
        nfkd: "\u{1103}\u{1170}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B498}",
        nfc: "\u{B498}",
        nfd: "\u{1103}\u{1170}\u{11B7}",
        nfkc: "\u{B498}",
        nfkd: "\u{1103}\u{1170}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B499}",
        nfc: "\u{B499}",
        nfd: "\u{1103}\u{1170}\u{11B8}",
        nfkc: "\u{B499}",
        nfkd: "\u{1103}\u{1170}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B49A}",
        nfc: "\u{B49A}",
        nfd: "\u{1103}\u{1170}\u{11B9}",
        nfkc: "\u{B49A}",
        nfkd: "\u{1103}\u{1170}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B49B}",
        nfc: "\u{B49B}",
        nfd: "\u{1103}\u{1170}\u{11BA}",
        nfkc: "\u{B49B}",
        nfkd: "\u{1103}\u{1170}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B49C}",
        nfc: "\u{B49C}",
        nfd: "\u{1103}\u{1170}\u{11BB}",
        nfkc: "\u{B49C}",
        nfkd: "\u{1103}\u{1170}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B49D}",
        nfc: "\u{B49D}",
        nfd: "\u{1103}\u{1170}\u{11BC}",
        nfkc: "\u{B49D}",
        nfkd: "\u{1103}\u{1170}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B49E}",
        nfc: "\u{B49E}",
        nfd: "\u{1103}\u{1170}\u{11BD}",
        nfkc: "\u{B49E}",
        nfkd: "\u{1103}\u{1170}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B49F}",
        nfc: "\u{B49F}",
        nfd: "\u{1103}\u{1170}\u{11BE}",
        nfkc: "\u{B49F}",
        nfkd: "\u{1103}\u{1170}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B4A0}",
        nfc: "\u{B4A0}",
        nfd: "\u{1103}\u{1170}\u{11BF}",
        nfkc: "\u{B4A0}",
        nfkd: "\u{1103}\u{1170}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B4A1}",
        nfc: "\u{B4A1}",
        nfd: "\u{1103}\u{1170}\u{11C0}",
        nfkc: "\u{B4A1}",
        nfkd: "\u{1103}\u{1170}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B4A2}",
        nfc: "\u{B4A2}",
        nfd: "\u{1103}\u{1170}\u{11C1}",
        nfkc: "\u{B4A2}",
        nfkd: "\u{1103}\u{1170}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B4A3}",
        nfc: "\u{B4A3}",
        nfd: "\u{1103}\u{1170}\u{11C2}",
        nfkc: "\u{B4A3}",
        nfkd: "\u{1103}\u{1170}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B4A4}",
        nfc: "\u{B4A4}",
        nfd: "\u{1103}\u{1171}",
        nfkc: "\u{B4A4}",
        nfkd: "\u{1103}\u{1171}",
    },
    NormalizationTest {
        source: "\u{B4A5}",
        nfc: "\u{B4A5}",
        nfd: "\u{1103}\u{1171}\u{11A8}",
        nfkc: "\u{B4A5}",
        nfkd: "\u{1103}\u{1171}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B4A6}",
        nfc: "\u{B4A6}",
        nfd: "\u{1103}\u{1171}\u{11A9}",
        nfkc: "\u{B4A6}",
        nfkd: "\u{1103}\u{1171}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B4A7}",
        nfc: "\u{B4A7}",
        nfd: "\u{1103}\u{1171}\u{11AA}",
        nfkc: "\u{B4A7}",
        nfkd: "\u{1103}\u{1171}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B4A8}",
        nfc: "\u{B4A8}",
        nfd: "\u{1103}\u{1171}\u{11AB}",
        nfkc: "\u{B4A8}",
        nfkd: "\u{1103}\u{1171}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B4A9}",
        nfc: "\u{B4A9}",
        nfd: "\u{1103}\u{1171}\u{11AC}",
        nfkc: "\u{B4A9}",
        nfkd: "\u{1103}\u{1171}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B4AA}",
        nfc: "\u{B4AA}",
        nfd: "\u{1103}\u{1171}\u{11AD}",
        nfkc: "\u{B4AA}",
        nfkd: "\u{1103}\u{1171}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B4AB}",
        nfc: "\u{B4AB}",
        nfd: "\u{1103}\u{1171}\u{11AE}",
        nfkc: "\u{B4AB}",
        nfkd: "\u{1103}\u{1171}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B4AC}",
        nfc: "\u{B4AC}",
        nfd: "\u{1103}\u{1171}\u{11AF}",
        nfkc: "\u{B4AC}",
        nfkd: "\u{1103}\u{1171}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B4AD}",
        nfc: "\u{B4AD}",
        nfd: "\u{1103}\u{1171}\u{11B0}",
        nfkc: "\u{B4AD}",
        nfkd: "\u{1103}\u{1171}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B4AE}",
        nfc: "\u{B4AE}",
        nfd: "\u{1103}\u{1171}\u{11B1}",
        nfkc: "\u{B4AE}",
        nfkd: "\u{1103}\u{1171}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B4AF}",
        nfc: "\u{B4AF}",
        nfd: "\u{1103}\u{1171}\u{11B2}",
        nfkc: "\u{B4AF}",
        nfkd: "\u{1103}\u{1171}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B4B0}",
        nfc: "\u{B4B0}",
        nfd: "\u{1103}\u{1171}\u{11B3}",
        nfkc: "\u{B4B0}",
        nfkd: "\u{1103}\u{1171}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B4B1}",
        nfc: "\u{B4B1}",
        nfd: "\u{1103}\u{1171}\u{11B4}",
        nfkc: "\u{B4B1}",
        nfkd: "\u{1103}\u{1171}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B4B2}",
        nfc: "\u{B4B2}",
        nfd: "\u{1103}\u{1171}\u{11B5}",
        nfkc: "\u{B4B2}",
        nfkd: "\u{1103}\u{1171}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B4B3}",
        nfc: "\u{B4B3}",
        nfd: "\u{1103}\u{1171}\u{11B6}",
        nfkc: "\u{B4B3}",
        nfkd: "\u{1103}\u{1171}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B4B4}",
        nfc: "\u{B4B4}",
        nfd: "\u{1103}\u{1171}\u{11B7}",
        nfkc: "\u{B4B4}",
        nfkd: "\u{1103}\u{1171}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B4B5}",
        nfc: "\u{B4B5}",
        nfd: "\u{1103}\u{1171}\u{11B8}",
        nfkc: "\u{B4B5}",
        nfkd: "\u{1103}\u{1171}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B4B6}",
        nfc: "\u{B4B6}",
        nfd: "\u{1103}\u{1171}\u{11B9}",
        nfkc: "\u{B4B6}",
        nfkd: "\u{1103}\u{1171}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B4B7}",
        nfc: "\u{B4B7}",
        nfd: "\u{1103}\u{1171}\u{11BA}",
        nfkc: "\u{B4B7}",
        nfkd: "\u{1103}\u{1171}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B4B8}",
        nfc: "\u{B4B8}",
        nfd: "\u{1103}\u{1171}\u{11BB}",
        nfkc: "\u{B4B8}",
        nfkd: "\u{1103}\u{1171}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B4B9}",
        nfc: "\u{B4B9}",
        nfd: "\u{1103}\u{1171}\u{11BC}",
        nfkc: "\u{B4B9}",
        nfkd: "\u{1103}\u{1171}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B4BA}",
        nfc: "\u{B4BA}",
        nfd: "\u{1103}\u{1171}\u{11BD}",
        nfkc: "\u{B4BA}",
        nfkd: "\u{1103}\u{1171}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B4BB}",
        nfc: "\u{B4BB}",
        nfd: "\u{1103}\u{1171}\u{11BE}",
        nfkc: "\u{B4BB}",
        nfkd: "\u{1103}\u{1171}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B4BC}",
        nfc: "\u{B4BC}",
        nfd: "\u{1103}\u{1171}\u{11BF}",
        nfkc: "\u{B4BC}",
        nfkd: "\u{1103}\u{1171}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B4BD}",
        nfc: "\u{B4BD}",
        nfd: "\u{1103}\u{1171}\u{11C0}",
        nfkc: "\u{B4BD}",
        nfkd: "\u{1103}\u{1171}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B4BE}",
        nfc: "\u{B4BE}",
        nfd: "\u{1103}\u{1171}\u{11C1}",
        nfkc: "\u{B4BE}",
        nfkd: "\u{1103}\u{1171}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B4BF}",
        nfc: "\u{B4BF}",
        nfd: "\u{1103}\u{1171}\u{11C2}",
        nfkc: "\u{B4BF}",
        nfkd: "\u{1103}\u{1171}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B4C0}",
        nfc: "\u{B4C0}",
        nfd: "\u{1103}\u{1172}",
        nfkc: "\u{B4C0}",
        nfkd: "\u{1103}\u{1172}",
    },
    NormalizationTest {
        source: "\u{B4C1}",
        nfc: "\u{B4C1}",
        nfd: "\u{1103}\u{1172}\u{11A8}",
        nfkc: "\u{B4C1}",
        nfkd: "\u{1103}\u{1172}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B4C2}",
        nfc: "\u{B4C2}",
        nfd: "\u{1103}\u{1172}\u{11A9}",
        nfkc: "\u{B4C2}",
        nfkd: "\u{1103}\u{1172}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B4C3}",
        nfc: "\u{B4C3}",
        nfd: "\u{1103}\u{1172}\u{11AA}",
        nfkc: "\u{B4C3}",
        nfkd: "\u{1103}\u{1172}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B4C4}",
        nfc: "\u{B4C4}",
        nfd: "\u{1103}\u{1172}\u{11AB}",
        nfkc: "\u{B4C4}",
        nfkd: "\u{1103}\u{1172}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B4C5}",
        nfc: "\u{B4C5}",
        nfd: "\u{1103}\u{1172}\u{11AC}",
        nfkc: "\u{B4C5}",
        nfkd: "\u{1103}\u{1172}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B4C6}",
        nfc: "\u{B4C6}",
        nfd: "\u{1103}\u{1172}\u{11AD}",
        nfkc: "\u{B4C6}",
        nfkd: "\u{1103}\u{1172}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B4C7}",
        nfc: "\u{B4C7}",
        nfd: "\u{1103}\u{1172}\u{11AE}",
        nfkc: "\u{B4C7}",
        nfkd: "\u{1103}\u{1172}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B4C8}",
        nfc: "\u{B4C8}",
        nfd: "\u{1103}\u{1172}\u{11AF}",
        nfkc: "\u{B4C8}",
        nfkd: "\u{1103}\u{1172}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B4C9}",
        nfc: "\u{B4C9}",
        nfd: "\u{1103}\u{1172}\u{11B0}",
        nfkc: "\u{B4C9}",
        nfkd: "\u{1103}\u{1172}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B4CA}",
        nfc: "\u{B4CA}",
        nfd: "\u{1103}\u{1172}\u{11B1}",
        nfkc: "\u{B4CA}",
        nfkd: "\u{1103}\u{1172}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B4CB}",
        nfc: "\u{B4CB}",
        nfd: "\u{1103}\u{1172}\u{11B2}",
        nfkc: "\u{B4CB}",
        nfkd: "\u{1103}\u{1172}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B4CC}",
        nfc: "\u{B4CC}",
        nfd: "\u{1103}\u{1172}\u{11B3}",
        nfkc: "\u{B4CC}",
        nfkd: "\u{1103}\u{1172}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B4CD}",
        nfc: "\u{B4CD}",
        nfd: "\u{1103}\u{1172}\u{11B4}",
        nfkc: "\u{B4CD}",
        nfkd: "\u{1103}\u{1172}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B4CE}",
        nfc: "\u{B4CE}",
        nfd: "\u{1103}\u{1172}\u{11B5}",
        nfkc: "\u{B4CE}",
        nfkd: "\u{1103}\u{1172}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B4CF}",
        nfc: "\u{B4CF}",
        nfd: "\u{1103}\u{1172}\u{11B6}",
        nfkc: "\u{B4CF}",
        nfkd: "\u{1103}\u{1172}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B4D0}",
        nfc: "\u{B4D0}",
        nfd: "\u{1103}\u{1172}\u{11B7}",
        nfkc: "\u{B4D0}",
        nfkd: "\u{1103}\u{1172}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B4D1}",
        nfc: "\u{B4D1}",
        nfd: "\u{1103}\u{1172}\u{11B8}",
        nfkc: "\u{B4D1}",
        nfkd: "\u{1103}\u{1172}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B4D2}",
        nfc: "\u{B4D2}",
        nfd: "\u{1103}\u{1172}\u{11B9}",
        nfkc: "\u{B4D2}",
        nfkd: "\u{1103}\u{1172}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B4D3}",
        nfc: "\u{B4D3}",
        nfd: "\u{1103}\u{1172}\u{11BA}",
        nfkc: "\u{B4D3}",
        nfkd: "\u{1103}\u{1172}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B4D4}",
        nfc: "\u{B4D4}",
        nfd: "\u{1103}\u{1172}\u{11BB}",
        nfkc: "\u{B4D4}",
        nfkd: "\u{1103}\u{1172}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B4D5}",
        nfc: "\u{B4D5}",
        nfd: "\u{1103}\u{1172}\u{11BC}",
        nfkc: "\u{B4D5}",
        nfkd: "\u{1103}\u{1172}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B4D6}",
        nfc: "\u{B4D6}",
        nfd: "\u{1103}\u{1172}\u{11BD}",
        nfkc: "\u{B4D6}",
        nfkd: "\u{1103}\u{1172}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B4D7}",
        nfc: "\u{B4D7}",
        nfd: "\u{1103}\u{1172}\u{11BE}",
        nfkc: "\u{B4D7}",
        nfkd: "\u{1103}\u{1172}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B4D8}",
        nfc: "\u{B4D8}",
        nfd: "\u{1103}\u{1172}\u{11BF}",
        nfkc: "\u{B4D8}",
        nfkd: "\u{1103}\u{1172}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B4D9}",
        nfc: "\u{B4D9}",
        nfd: "\u{1103}\u{1172}\u{11C0}",
        nfkc: "\u{B4D9}",
        nfkd: "\u{1103}\u{1172}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B4DA}",
        nfc: "\u{B4DA}",
        nfd: "\u{1103}\u{1172}\u{11C1}",
        nfkc: "\u{B4DA}",
        nfkd: "\u{1103}\u{1172}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B4DB}",
        nfc: "\u{B4DB}",
        nfd: "\u{1103}\u{1172}\u{11C2}",
        nfkc: "\u{B4DB}",
        nfkd: "\u{1103}\u{1172}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B4DC}",
        nfc: "\u{B4DC}",
        nfd: "\u{1103}\u{1173}",
        nfkc: "\u{B4DC}",
        nfkd: "\u{1103}\u{1173}",
    },
    NormalizationTest {
        source: "\u{B4DD}",
        nfc: "\u{B4DD}",
        nfd: "\u{1103}\u{1173}\u{11A8}",
        nfkc: "\u{B4DD}",
        nfkd: "\u{1103}\u{1173}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B4DE}",
        nfc: "\u{B4DE}",
        nfd: "\u{1103}\u{1173}\u{11A9}",
        nfkc: "\u{B4DE}",
        nfkd: "\u{1103}\u{1173}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B4DF}",
        nfc: "\u{B4DF}",
        nfd: "\u{1103}\u{1173}\u{11AA}",
        nfkc: "\u{B4DF}",
        nfkd: "\u{1103}\u{1173}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B4E0}",
        nfc: "\u{B4E0}",
        nfd: "\u{1103}\u{1173}\u{11AB}",
        nfkc: "\u{B4E0}",
        nfkd: "\u{1103}\u{1173}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B4E1}",
        nfc: "\u{B4E1}",
        nfd: "\u{1103}\u{1173}\u{11AC}",
        nfkc: "\u{B4E1}",
        nfkd: "\u{1103}\u{1173}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B4E2}",
        nfc: "\u{B4E2}",
        nfd: "\u{1103}\u{1173}\u{11AD}",
        nfkc: "\u{B4E2}",
        nfkd: "\u{1103}\u{1173}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B4E3}",
        nfc: "\u{B4E3}",
        nfd: "\u{1103}\u{1173}\u{11AE}",
        nfkc: "\u{B4E3}",
        nfkd: "\u{1103}\u{1173}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B4E4}",
        nfc: "\u{B4E4}",
        nfd: "\u{1103}\u{1173}\u{11AF}",
        nfkc: "\u{B4E4}",
        nfkd: "\u{1103}\u{1173}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B4E5}",
        nfc: "\u{B4E5}",
        nfd: "\u{1103}\u{1173}\u{11B0}",
        nfkc: "\u{B4E5}",
        nfkd: "\u{1103}\u{1173}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B4E6}",
        nfc: "\u{B4E6}",
        nfd: "\u{1103}\u{1173}\u{11B1}",
        nfkc: "\u{B4E6}",
        nfkd: "\u{1103}\u{1173}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B4E7}",
        nfc: "\u{B4E7}",
        nfd: "\u{1103}\u{1173}\u{11B2}",
        nfkc: "\u{B4E7}",
        nfkd: "\u{1103}\u{1173}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B4E8}",
        nfc: "\u{B4E8}",
        nfd: "\u{1103}\u{1173}\u{11B3}",
        nfkc: "\u{B4E8}",
        nfkd: "\u{1103}\u{1173}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B4E9}",
        nfc: "\u{B4E9}",
        nfd: "\u{1103}\u{1173}\u{11B4}",
        nfkc: "\u{B4E9}",
        nfkd: "\u{1103}\u{1173}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B4EA}",
        nfc: "\u{B4EA}",
        nfd: "\u{1103}\u{1173}\u{11B5}",
        nfkc: "\u{B4EA}",
        nfkd: "\u{1103}\u{1173}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B4EB}",
        nfc: "\u{B4EB}",
        nfd: "\u{1103}\u{1173}\u{11B6}",
        nfkc: "\u{B4EB}",
        nfkd: "\u{1103}\u{1173}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B4EC}",
        nfc: "\u{B4EC}",
        nfd: "\u{1103}\u{1173}\u{11B7}",
        nfkc: "\u{B4EC}",
        nfkd: "\u{1103}\u{1173}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B4ED}",
        nfc: "\u{B4ED}",
        nfd: "\u{1103}\u{1173}\u{11B8}",
        nfkc: "\u{B4ED}",
        nfkd: "\u{1103}\u{1173}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B4EE}",
        nfc: "\u{B4EE}",
        nfd: "\u{1103}\u{1173}\u{11B9}",
        nfkc: "\u{B4EE}",
        nfkd: "\u{1103}\u{1173}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B4EF}",
        nfc: "\u{B4EF}",
        nfd: "\u{1103}\u{1173}\u{11BA}",
        nfkc: "\u{B4EF}",
        nfkd: "\u{1103}\u{1173}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B4F0}",
        nfc: "\u{B4F0}",
        nfd: "\u{1103}\u{1173}\u{11BB}",
        nfkc: "\u{B4F0}",
        nfkd: "\u{1103}\u{1173}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B4F1}",
        nfc: "\u{B4F1}",
        nfd: "\u{1103}\u{1173}\u{11BC}",
        nfkc: "\u{B4F1}",
        nfkd: "\u{1103}\u{1173}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B4F2}",
        nfc: "\u{B4F2}",
        nfd: "\u{1103}\u{1173}\u{11BD}",
        nfkc: "\u{B4F2}",
        nfkd: "\u{1103}\u{1173}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B4F3}",
        nfc: "\u{B4F3}",
        nfd: "\u{1103}\u{1173}\u{11BE}",
        nfkc: "\u{B4F3}",
        nfkd: "\u{1103}\u{1173}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B4F4}",
        nfc: "\u{B4F4}",
        nfd: "\u{1103}\u{1173}\u{11BF}",
        nfkc: "\u{B4F4}",
        nfkd: "\u{1103}\u{1173}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B4F5}",
        nfc: "\u{B4F5}",
        nfd: "\u{1103}\u{1173}\u{11C0}",
        nfkc: "\u{B4F5}",
        nfkd: "\u{1103}\u{1173}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B4F6}",
        nfc: "\u{B4F6}",
        nfd: "\u{1103}\u{1173}\u{11C1}",
        nfkc: "\u{B4F6}",
        nfkd: "\u{1103}\u{1173}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B4F7}",
        nfc: "\u{B4F7}",
        nfd: "\u{1103}\u{1173}\u{11C2}",
        nfkc: "\u{B4F7}",
        nfkd: "\u{1103}\u{1173}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B4F8}",
        nfc: "\u{B4F8}",
        nfd: "\u{1103}\u{1174}",
        nfkc: "\u{B4F8}",
        nfkd: "\u{1103}\u{1174}",
    },
    NormalizationTest {
        source: "\u{B4F9}",
        nfc: "\u{B4F9}",
        nfd: "\u{1103}\u{1174}\u{11A8}",
        nfkc: "\u{B4F9}",
        nfkd: "\u{1103}\u{1174}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B4FA}",
        nfc: "\u{B4FA}",
        nfd: "\u{1103}\u{1174}\u{11A9}",
        nfkc: "\u{B4FA}",
        nfkd: "\u{1103}\u{1174}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B4FB}",
        nfc: "\u{B4FB}",
        nfd: "\u{1103}\u{1174}\u{11AA}",
        nfkc: "\u{B4FB}",
        nfkd: "\u{1103}\u{1174}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B4FC}",
        nfc: "\u{B4FC}",
        nfd: "\u{1103}\u{1174}\u{11AB}",
        nfkc: "\u{B4FC}",
        nfkd: "\u{1103}\u{1174}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B4FD}",
        nfc: "\u{B4FD}",
        nfd: "\u{1103}\u{1174}\u{11AC}",
        nfkc: "\u{B4FD}",
        nfkd: "\u{1103}\u{1174}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B4FE}",
        nfc: "\u{B4FE}",
        nfd: "\u{1103}\u{1174}\u{11AD}",
        nfkc: "\u{B4FE}",
        nfkd: "\u{1103}\u{1174}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B4FF}",
        nfc: "\u{B4FF}",
        nfd: "\u{1103}\u{1174}\u{11AE}",
        nfkc: "\u{B4FF}",
        nfkd: "\u{1103}\u{1174}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B500}",
        nfc: "\u{B500}",
        nfd: "\u{1103}\u{1174}\u{11AF}",
        nfkc: "\u{B500}",
        nfkd: "\u{1103}\u{1174}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B501}",
        nfc: "\u{B501}",
        nfd: "\u{1103}\u{1174}\u{11B0}",
        nfkc: "\u{B501}",
        nfkd: "\u{1103}\u{1174}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B502}",
        nfc: "\u{B502}",
        nfd: "\u{1103}\u{1174}\u{11B1}",
        nfkc: "\u{B502}",
        nfkd: "\u{1103}\u{1174}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B503}",
        nfc: "\u{B503}",
        nfd: "\u{1103}\u{1174}\u{11B2}",
        nfkc: "\u{B503}",
        nfkd: "\u{1103}\u{1174}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B504}",
        nfc: "\u{B504}",
        nfd: "\u{1103}\u{1174}\u{11B3}",
        nfkc: "\u{B504}",
        nfkd: "\u{1103}\u{1174}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B505}",
        nfc: "\u{B505}",
        nfd: "\u{1103}\u{1174}\u{11B4}",
        nfkc: "\u{B505}",
        nfkd: "\u{1103}\u{1174}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B506}",
        nfc: "\u{B506}",
        nfd: "\u{1103}\u{1174}\u{11B5}",
        nfkc: "\u{B506}",
        nfkd: "\u{1103}\u{1174}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B507}",
        nfc: "\u{B507}",
        nfd: "\u{1103}\u{1174}\u{11B6}",
        nfkc: "\u{B507}",
        nfkd: "\u{1103}\u{1174}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B508}",
        nfc: "\u{B508}",
        nfd: "\u{1103}\u{1174}\u{11B7}",
        nfkc: "\u{B508}",
        nfkd: "\u{1103}\u{1174}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B509}",
        nfc: "\u{B509}",
        nfd: "\u{1103}\u{1174}\u{11B8}",
        nfkc: "\u{B509}",
        nfkd: "\u{1103}\u{1174}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B50A}",
        nfc: "\u{B50A}",
        nfd: "\u{1103}\u{1174}\u{11B9}",
        nfkc: "\u{B50A}",
        nfkd: "\u{1103}\u{1174}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B50B}",
        nfc: "\u{B50B}",
        nfd: "\u{1103}\u{1174}\u{11BA}",
        nfkc: "\u{B50B}",
        nfkd: "\u{1103}\u{1174}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B50C}",
        nfc: "\u{B50C}",
        nfd: "\u{1103}\u{1174}\u{11BB}",
        nfkc: "\u{B50C}",
        nfkd: "\u{1103}\u{1174}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B50D}",
        nfc: "\u{B50D}",
        nfd: "\u{1103}\u{1174}\u{11BC}",
        nfkc: "\u{B50D}",
        nfkd: "\u{1103}\u{1174}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B50E}",
        nfc: "\u{B50E}",
        nfd: "\u{1103}\u{1174}\u{11BD}",
        nfkc: "\u{B50E}",
        nfkd: "\u{1103}\u{1174}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B50F}",
        nfc: "\u{B50F}",
        nfd: "\u{1103}\u{1174}\u{11BE}",
        nfkc: "\u{B50F}",
        nfkd: "\u{1103}\u{1174}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B510}",
        nfc: "\u{B510}",
        nfd: "\u{1103}\u{1174}\u{11BF}",
        nfkc: "\u{B510}",
        nfkd: "\u{1103}\u{1174}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B511}",
        nfc: "\u{B511}",
        nfd: "\u{1103}\u{1174}\u{11C0}",
        nfkc: "\u{B511}",
        nfkd: "\u{1103}\u{1174}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B512}",
        nfc: "\u{B512}",
        nfd: "\u{1103}\u{1174}\u{11C1}",
        nfkc: "\u{B512}",
        nfkd: "\u{1103}\u{1174}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B513}",
        nfc: "\u{B513}",
        nfd: "\u{1103}\u{1174}\u{11C2}",
        nfkc: "\u{B513}",
        nfkd: "\u{1103}\u{1174}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B514}",
        nfc: "\u{B514}",
        nfd: "\u{1103}\u{1175}",
        nfkc: "\u{B514}",
        nfkd: "\u{1103}\u{1175}",
    },
    NormalizationTest {
        source: "\u{B515}",
        nfc: "\u{B515}",
        nfd: "\u{1103}\u{1175}\u{11A8}",
        nfkc: "\u{B515}",
        nfkd: "\u{1103}\u{1175}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B516}",
        nfc: "\u{B516}",
        nfd: "\u{1103}\u{1175}\u{11A9}",
        nfkc: "\u{B516}",
        nfkd: "\u{1103}\u{1175}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B517}",
        nfc: "\u{B517}",
        nfd: "\u{1103}\u{1175}\u{11AA}",
        nfkc: "\u{B517}",
        nfkd: "\u{1103}\u{1175}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B518}",
        nfc: "\u{B518}",
        nfd: "\u{1103}\u{1175}\u{11AB}",
        nfkc: "\u{B518}",
        nfkd: "\u{1103}\u{1175}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B519}",
        nfc: "\u{B519}",
        nfd: "\u{1103}\u{1175}\u{11AC}",
        nfkc: "\u{B519}",
        nfkd: "\u{1103}\u{1175}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B51A}",
        nfc: "\u{B51A}",
        nfd: "\u{1103}\u{1175}\u{11AD}",
        nfkc: "\u{B51A}",
        nfkd: "\u{1103}\u{1175}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B51B}",
        nfc: "\u{B51B}",
        nfd: "\u{1103}\u{1175}\u{11AE}",
        nfkc: "\u{B51B}",
        nfkd: "\u{1103}\u{1175}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B51C}",
        nfc: "\u{B51C}",
        nfd: "\u{1103}\u{1175}\u{11AF}",
        nfkc: "\u{B51C}",
        nfkd: "\u{1103}\u{1175}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B51D}",
        nfc: "\u{B51D}",
        nfd: "\u{1103}\u{1175}\u{11B0}",
        nfkc: "\u{B51D}",
        nfkd: "\u{1103}\u{1175}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B51E}",
        nfc: "\u{B51E}",
        nfd: "\u{1103}\u{1175}\u{11B1}",
        nfkc: "\u{B51E}",
        nfkd: "\u{1103}\u{1175}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B51F}",
        nfc: "\u{B51F}",
        nfd: "\u{1103}\u{1175}\u{11B2}",
        nfkc: "\u{B51F}",
        nfkd: "\u{1103}\u{1175}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B520}",
        nfc: "\u{B520}",
        nfd: "\u{1103}\u{1175}\u{11B3}",
        nfkc: "\u{B520}",
        nfkd: "\u{1103}\u{1175}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B521}",
        nfc: "\u{B521}",
        nfd: "\u{1103}\u{1175}\u{11B4}",
        nfkc: "\u{B521}",
        nfkd: "\u{1103}\u{1175}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B522}",
        nfc: "\u{B522}",
        nfd: "\u{1103}\u{1175}\u{11B5}",
        nfkc: "\u{B522}",
        nfkd: "\u{1103}\u{1175}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B523}",
        nfc: "\u{B523}",
        nfd: "\u{1103}\u{1175}\u{11B6}",
        nfkc: "\u{B523}",
        nfkd: "\u{1103}\u{1175}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B524}",
        nfc: "\u{B524}",
        nfd: "\u{1103}\u{1175}\u{11B7}",
        nfkc: "\u{B524}",
        nfkd: "\u{1103}\u{1175}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B525}",
        nfc: "\u{B525}",
        nfd: "\u{1103}\u{1175}\u{11B8}",
        nfkc: "\u{B525}",
        nfkd: "\u{1103}\u{1175}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B526}",
        nfc: "\u{B526}",
        nfd: "\u{1103}\u{1175}\u{11B9}",
        nfkc: "\u{B526}",
        nfkd: "\u{1103}\u{1175}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B527}",
        nfc: "\u{B527}",
        nfd: "\u{1103}\u{1175}\u{11BA}",
        nfkc: "\u{B527}",
        nfkd: "\u{1103}\u{1175}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B528}",
        nfc: "\u{B528}",
        nfd: "\u{1103}\u{1175}\u{11BB}",
        nfkc: "\u{B528}",
        nfkd: "\u{1103}\u{1175}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B529}",
        nfc: "\u{B529}",
        nfd: "\u{1103}\u{1175}\u{11BC}",
        nfkc: "\u{B529}",
        nfkd: "\u{1103}\u{1175}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B52A}",
        nfc: "\u{B52A}",
        nfd: "\u{1103}\u{1175}\u{11BD}",
        nfkc: "\u{B52A}",
        nfkd: "\u{1103}\u{1175}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B52B}",
        nfc: "\u{B52B}",
        nfd: "\u{1103}\u{1175}\u{11BE}",
        nfkc: "\u{B52B}",
        nfkd: "\u{1103}\u{1175}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B52C}",
        nfc: "\u{B52C}",
        nfd: "\u{1103}\u{1175}\u{11BF}",
        nfkc: "\u{B52C}",
        nfkd: "\u{1103}\u{1175}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B52D}",
        nfc: "\u{B52D}",
        nfd: "\u{1103}\u{1175}\u{11C0}",
        nfkc: "\u{B52D}",
        nfkd: "\u{1103}\u{1175}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B52E}",
        nfc: "\u{B52E}",
        nfd: "\u{1103}\u{1175}\u{11C1}",
        nfkc: "\u{B52E}",
        nfkd: "\u{1103}\u{1175}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B52F}",
        nfc: "\u{B52F}",
        nfd: "\u{1103}\u{1175}\u{11C2}",
        nfkc: "\u{B52F}",
        nfkd: "\u{1103}\u{1175}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B530}",
        nfc: "\u{B530}",
        nfd: "\u{1104}\u{1161}",
        nfkc: "\u{B530}",
        nfkd: "\u{1104}\u{1161}",
    },
    NormalizationTest {
        source: "\u{B531}",
        nfc: "\u{B531}",
        nfd: "\u{1104}\u{1161}\u{11A8}",
        nfkc: "\u{B531}",
        nfkd: "\u{1104}\u{1161}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B532}",
        nfc: "\u{B532}",
        nfd: "\u{1104}\u{1161}\u{11A9}",
        nfkc: "\u{B532}",
        nfkd: "\u{1104}\u{1161}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B533}",
        nfc: "\u{B533}",
        nfd: "\u{1104}\u{1161}\u{11AA}",
        nfkc: "\u{B533}",
        nfkd: "\u{1104}\u{1161}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B534}",
        nfc: "\u{B534}",
        nfd: "\u{1104}\u{1161}\u{11AB}",
        nfkc: "\u{B534}",
        nfkd: "\u{1104}\u{1161}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B535}",
        nfc: "\u{B535}",
        nfd: "\u{1104}\u{1161}\u{11AC}",
        nfkc: "\u{B535}",
        nfkd: "\u{1104}\u{1161}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B536}",
        nfc: "\u{B536}",
        nfd: "\u{1104}\u{1161}\u{11AD}",
        nfkc: "\u{B536}",
        nfkd: "\u{1104}\u{1161}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B537}",
        nfc: "\u{B537}",
        nfd: "\u{1104}\u{1161}\u{11AE}",
        nfkc: "\u{B537}",
        nfkd: "\u{1104}\u{1161}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B538}",
        nfc: "\u{B538}",
        nfd: "\u{1104}\u{1161}\u{11AF}",
        nfkc: "\u{B538}",
        nfkd: "\u{1104}\u{1161}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B539}",
        nfc: "\u{B539}",
        nfd: "\u{1104}\u{1161}\u{11B0}",
        nfkc: "\u{B539}",
        nfkd: "\u{1104}\u{1161}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B53A}",
        nfc: "\u{B53A}",
        nfd: "\u{1104}\u{1161}\u{11B1}",
        nfkc: "\u{B53A}",
        nfkd: "\u{1104}\u{1161}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B53B}",
        nfc: "\u{B53B}",
        nfd: "\u{1104}\u{1161}\u{11B2}",
        nfkc: "\u{B53B}",
        nfkd: "\u{1104}\u{1161}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B53C}",
        nfc: "\u{B53C}",
        nfd: "\u{1104}\u{1161}\u{11B3}",
        nfkc: "\u{B53C}",
        nfkd: "\u{1104}\u{1161}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B53D}",
        nfc: "\u{B53D}",
        nfd: "\u{1104}\u{1161}\u{11B4}",
        nfkc: "\u{B53D}",
        nfkd: "\u{1104}\u{1161}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B53E}",
        nfc: "\u{B53E}",
        nfd: "\u{1104}\u{1161}\u{11B5}",
        nfkc: "\u{B53E}",
        nfkd: "\u{1104}\u{1161}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B53F}",
        nfc: "\u{B53F}",
        nfd: "\u{1104}\u{1161}\u{11B6}",
        nfkc: "\u{B53F}",
        nfkd: "\u{1104}\u{1161}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B540}",
        nfc: "\u{B540}",
        nfd: "\u{1104}\u{1161}\u{11B7}",
        nfkc: "\u{B540}",
        nfkd: "\u{1104}\u{1161}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B541}",
        nfc: "\u{B541}",
        nfd: "\u{1104}\u{1161}\u{11B8}",
        nfkc: "\u{B541}",
        nfkd: "\u{1104}\u{1161}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B542}",
        nfc: "\u{B542}",
        nfd: "\u{1104}\u{1161}\u{11B9}",
        nfkc: "\u{B542}",
        nfkd: "\u{1104}\u{1161}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B543}",
        nfc: "\u{B543}",
        nfd: "\u{1104}\u{1161}\u{11BA}",
        nfkc: "\u{B543}",
        nfkd: "\u{1104}\u{1161}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B544}",
        nfc: "\u{B544}",
        nfd: "\u{1104}\u{1161}\u{11BB}",
        nfkc: "\u{B544}",
        nfkd: "\u{1104}\u{1161}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B545}",
        nfc: "\u{B545}",
        nfd: "\u{1104}\u{1161}\u{11BC}",
        nfkc: "\u{B545}",
        nfkd: "\u{1104}\u{1161}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B546}",
        nfc: "\u{B546}",
        nfd: "\u{1104}\u{1161}\u{11BD}",
        nfkc: "\u{B546}",
        nfkd: "\u{1104}\u{1161}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B547}",
        nfc: "\u{B547}",
        nfd: "\u{1104}\u{1161}\u{11BE}",
        nfkc: "\u{B547}",
        nfkd: "\u{1104}\u{1161}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B548}",
        nfc: "\u{B548}",
        nfd: "\u{1104}\u{1161}\u{11BF}",
        nfkc: "\u{B548}",
        nfkd: "\u{1104}\u{1161}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B549}",
        nfc: "\u{B549}",
        nfd: "\u{1104}\u{1161}\u{11C0}",
        nfkc: "\u{B549}",
        nfkd: "\u{1104}\u{1161}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B54A}",
        nfc: "\u{B54A}",
        nfd: "\u{1104}\u{1161}\u{11C1}",
        nfkc: "\u{B54A}",
        nfkd: "\u{1104}\u{1161}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B54B}",
        nfc: "\u{B54B}",
        nfd: "\u{1104}\u{1161}\u{11C2}",
        nfkc: "\u{B54B}",
        nfkd: "\u{1104}\u{1161}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B54C}",
        nfc: "\u{B54C}",
        nfd: "\u{1104}\u{1162}",
        nfkc: "\u{B54C}",
        nfkd: "\u{1104}\u{1162}",
    },
    NormalizationTest {
        source: "\u{B54D}",
        nfc: "\u{B54D}",
        nfd: "\u{1104}\u{1162}\u{11A8}",
        nfkc: "\u{B54D}",
        nfkd: "\u{1104}\u{1162}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B54E}",
        nfc: "\u{B54E}",
        nfd: "\u{1104}\u{1162}\u{11A9}",
        nfkc: "\u{B54E}",
        nfkd: "\u{1104}\u{1162}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B54F}",
        nfc: "\u{B54F}",
        nfd: "\u{1104}\u{1162}\u{11AA}",
        nfkc: "\u{B54F}",
        nfkd: "\u{1104}\u{1162}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B550}",
        nfc: "\u{B550}",
        nfd: "\u{1104}\u{1162}\u{11AB}",
        nfkc: "\u{B550}",
        nfkd: "\u{1104}\u{1162}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B551}",
        nfc: "\u{B551}",
        nfd: "\u{1104}\u{1162}\u{11AC}",
        nfkc: "\u{B551}",
        nfkd: "\u{1104}\u{1162}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B552}",
        nfc: "\u{B552}",
        nfd: "\u{1104}\u{1162}\u{11AD}",
        nfkc: "\u{B552}",
        nfkd: "\u{1104}\u{1162}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B553}",
        nfc: "\u{B553}",
        nfd: "\u{1104}\u{1162}\u{11AE}",
        nfkc: "\u{B553}",
        nfkd: "\u{1104}\u{1162}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B554}",
        nfc: "\u{B554}",
        nfd: "\u{1104}\u{1162}\u{11AF}",
        nfkc: "\u{B554}",
        nfkd: "\u{1104}\u{1162}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B555}",
        nfc: "\u{B555}",
        nfd: "\u{1104}\u{1162}\u{11B0}",
        nfkc: "\u{B555}",
        nfkd: "\u{1104}\u{1162}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B556}",
        nfc: "\u{B556}",
        nfd: "\u{1104}\u{1162}\u{11B1}",
        nfkc: "\u{B556}",
        nfkd: "\u{1104}\u{1162}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B557}",
        nfc: "\u{B557}",
        nfd: "\u{1104}\u{1162}\u{11B2}",
        nfkc: "\u{B557}",
        nfkd: "\u{1104}\u{1162}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B558}",
        nfc: "\u{B558}",
        nfd: "\u{1104}\u{1162}\u{11B3}",
        nfkc: "\u{B558}",
        nfkd: "\u{1104}\u{1162}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B559}",
        nfc: "\u{B559}",
        nfd: "\u{1104}\u{1162}\u{11B4}",
        nfkc: "\u{B559}",
        nfkd: "\u{1104}\u{1162}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B55A}",
        nfc: "\u{B55A}",
        nfd: "\u{1104}\u{1162}\u{11B5}",
        nfkc: "\u{B55A}",
        nfkd: "\u{1104}\u{1162}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B55B}",
        nfc: "\u{B55B}",
        nfd: "\u{1104}\u{1162}\u{11B6}",
        nfkc: "\u{B55B}",
        nfkd: "\u{1104}\u{1162}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B55C}",
        nfc: "\u{B55C}",
        nfd: "\u{1104}\u{1162}\u{11B7}",
        nfkc: "\u{B55C}",
        nfkd: "\u{1104}\u{1162}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B55D}",
        nfc: "\u{B55D}",
        nfd: "\u{1104}\u{1162}\u{11B8}",
        nfkc: "\u{B55D}",
        nfkd: "\u{1104}\u{1162}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B55E}",
        nfc: "\u{B55E}",
        nfd: "\u{1104}\u{1162}\u{11B9}",
        nfkc: "\u{B55E}",
        nfkd: "\u{1104}\u{1162}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B55F}",
        nfc: "\u{B55F}",
        nfd: "\u{1104}\u{1162}\u{11BA}",
        nfkc: "\u{B55F}",
        nfkd: "\u{1104}\u{1162}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B560}",
        nfc: "\u{B560}",
        nfd: "\u{1104}\u{1162}\u{11BB}",
        nfkc: "\u{B560}",
        nfkd: "\u{1104}\u{1162}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B561}",
        nfc: "\u{B561}",
        nfd: "\u{1104}\u{1162}\u{11BC}",
        nfkc: "\u{B561}",
        nfkd: "\u{1104}\u{1162}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B562}",
        nfc: "\u{B562}",
        nfd: "\u{1104}\u{1162}\u{11BD}",
        nfkc: "\u{B562}",
        nfkd: "\u{1104}\u{1162}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B563}",
        nfc: "\u{B563}",
        nfd: "\u{1104}\u{1162}\u{11BE}",
        nfkc: "\u{B563}",
        nfkd: "\u{1104}\u{1162}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B564}",
        nfc: "\u{B564}",
        nfd: "\u{1104}\u{1162}\u{11BF}",
        nfkc: "\u{B564}",
        nfkd: "\u{1104}\u{1162}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B565}",
        nfc: "\u{B565}",
        nfd: "\u{1104}\u{1162}\u{11C0}",
        nfkc: "\u{B565}",
        nfkd: "\u{1104}\u{1162}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B566}",
        nfc: "\u{B566}",
        nfd: "\u{1104}\u{1162}\u{11C1}",
        nfkc: "\u{B566}",
        nfkd: "\u{1104}\u{1162}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B567}",
        nfc: "\u{B567}",
        nfd: "\u{1104}\u{1162}\u{11C2}",
        nfkc: "\u{B567}",
        nfkd: "\u{1104}\u{1162}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B568}",
        nfc: "\u{B568}",
        nfd: "\u{1104}\u{1163}",
        nfkc: "\u{B568}",
        nfkd: "\u{1104}\u{1163}",
    },
    NormalizationTest {
        source: "\u{B569}",
        nfc: "\u{B569}",
        nfd: "\u{1104}\u{1163}\u{11A8}",
        nfkc: "\u{B569}",
        nfkd: "\u{1104}\u{1163}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B56A}",
        nfc: "\u{B56A}",
        nfd: "\u{1104}\u{1163}\u{11A9}",
        nfkc: "\u{B56A}",
        nfkd: "\u{1104}\u{1163}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B56B}",
        nfc: "\u{B56B}",
        nfd: "\u{1104}\u{1163}\u{11AA}",
        nfkc: "\u{B56B}",
        nfkd: "\u{1104}\u{1163}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B56C}",
        nfc: "\u{B56C}",
        nfd: "\u{1104}\u{1163}\u{11AB}",
        nfkc: "\u{B56C}",
        nfkd: "\u{1104}\u{1163}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B56D}",
        nfc: "\u{B56D}",
        nfd: "\u{1104}\u{1163}\u{11AC}",
        nfkc: "\u{B56D}",
        nfkd: "\u{1104}\u{1163}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B56E}",
        nfc: "\u{B56E}",
        nfd: "\u{1104}\u{1163}\u{11AD}",
        nfkc: "\u{B56E}",
        nfkd: "\u{1104}\u{1163}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B56F}",
        nfc: "\u{B56F}",
        nfd: "\u{1104}\u{1163}\u{11AE}",
        nfkc: "\u{B56F}",
        nfkd: "\u{1104}\u{1163}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B570}",
        nfc: "\u{B570}",
        nfd: "\u{1104}\u{1163}\u{11AF}",
        nfkc: "\u{B570}",
        nfkd: "\u{1104}\u{1163}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B571}",
        nfc: "\u{B571}",
        nfd: "\u{1104}\u{1163}\u{11B0}",
        nfkc: "\u{B571}",
        nfkd: "\u{1104}\u{1163}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B572}",
        nfc: "\u{B572}",
        nfd: "\u{1104}\u{1163}\u{11B1}",
        nfkc: "\u{B572}",
        nfkd: "\u{1104}\u{1163}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B573}",
        nfc: "\u{B573}",
        nfd: "\u{1104}\u{1163}\u{11B2}",
        nfkc: "\u{B573}",
        nfkd: "\u{1104}\u{1163}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B574}",
        nfc: "\u{B574}",
        nfd: "\u{1104}\u{1163}\u{11B3}",
        nfkc: "\u{B574}",
        nfkd: "\u{1104}\u{1163}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B575}",
        nfc: "\u{B575}",
        nfd: "\u{1104}\u{1163}\u{11B4}",
        nfkc: "\u{B575}",
        nfkd: "\u{1104}\u{1163}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B576}",
        nfc: "\u{B576}",
        nfd: "\u{1104}\u{1163}\u{11B5}",
        nfkc: "\u{B576}",
        nfkd: "\u{1104}\u{1163}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B577}",
        nfc: "\u{B577}",
        nfd: "\u{1104}\u{1163}\u{11B6}",
        nfkc: "\u{B577}",
        nfkd: "\u{1104}\u{1163}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B578}",
        nfc: "\u{B578}",
        nfd: "\u{1104}\u{1163}\u{11B7}",
        nfkc: "\u{B578}",
        nfkd: "\u{1104}\u{1163}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B579}",
        nfc: "\u{B579}",
        nfd: "\u{1104}\u{1163}\u{11B8}",
        nfkc: "\u{B579}",
        nfkd: "\u{1104}\u{1163}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B57A}",
        nfc: "\u{B57A}",
        nfd: "\u{1104}\u{1163}\u{11B9}",
        nfkc: "\u{B57A}",
        nfkd: "\u{1104}\u{1163}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B57B}",
        nfc: "\u{B57B}",
        nfd: "\u{1104}\u{1163}\u{11BA}",
        nfkc: "\u{B57B}",
        nfkd: "\u{1104}\u{1163}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B57C}",
        nfc: "\u{B57C}",
        nfd: "\u{1104}\u{1163}\u{11BB}",
        nfkc: "\u{B57C}",
        nfkd: "\u{1104}\u{1163}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B57D}",
        nfc: "\u{B57D}",
        nfd: "\u{1104}\u{1163}\u{11BC}",
        nfkc: "\u{B57D}",
        nfkd: "\u{1104}\u{1163}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B57E}",
        nfc: "\u{B57E}",
        nfd: "\u{1104}\u{1163}\u{11BD}",
        nfkc: "\u{B57E}",
        nfkd: "\u{1104}\u{1163}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B57F}",
        nfc: "\u{B57F}",
        nfd: "\u{1104}\u{1163}\u{11BE}",
        nfkc: "\u{B57F}",
        nfkd: "\u{1104}\u{1163}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B580}",
        nfc: "\u{B580}",
        nfd: "\u{1104}\u{1163}\u{11BF}",
        nfkc: "\u{B580}",
        nfkd: "\u{1104}\u{1163}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B581}",
        nfc: "\u{B581}",
        nfd: "\u{1104}\u{1163}\u{11C0}",
        nfkc: "\u{B581}",
        nfkd: "\u{1104}\u{1163}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B582}",
        nfc: "\u{B582}",
        nfd: "\u{1104}\u{1163}\u{11C1}",
        nfkc: "\u{B582}",
        nfkd: "\u{1104}\u{1163}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B583}",
        nfc: "\u{B583}",
        nfd: "\u{1104}\u{1163}\u{11C2}",
        nfkc: "\u{B583}",
        nfkd: "\u{1104}\u{1163}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B584}",
        nfc: "\u{B584}",
        nfd: "\u{1104}\u{1164}",
        nfkc: "\u{B584}",
        nfkd: "\u{1104}\u{1164}",
    },
    NormalizationTest {
        source: "\u{B585}",
        nfc: "\u{B585}",
        nfd: "\u{1104}\u{1164}\u{11A8}",
        nfkc: "\u{B585}",
        nfkd: "\u{1104}\u{1164}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B586}",
        nfc: "\u{B586}",
        nfd: "\u{1104}\u{1164}\u{11A9}",
        nfkc: "\u{B586}",
        nfkd: "\u{1104}\u{1164}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B587}",
        nfc: "\u{B587}",
        nfd: "\u{1104}\u{1164}\u{11AA}",
        nfkc: "\u{B587}",
        nfkd: "\u{1104}\u{1164}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B588}",
        nfc: "\u{B588}",
        nfd: "\u{1104}\u{1164}\u{11AB}",
        nfkc: "\u{B588}",
        nfkd: "\u{1104}\u{1164}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B589}",
        nfc: "\u{B589}",
        nfd: "\u{1104}\u{1164}\u{11AC}",
        nfkc: "\u{B589}",
        nfkd: "\u{1104}\u{1164}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B58A}",
        nfc: "\u{B58A}",
        nfd: "\u{1104}\u{1164}\u{11AD}",
        nfkc: "\u{B58A}",
        nfkd: "\u{1104}\u{1164}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B58B}",
        nfc: "\u{B58B}",
        nfd: "\u{1104}\u{1164}\u{11AE}",
        nfkc: "\u{B58B}",
        nfkd: "\u{1104}\u{1164}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B58C}",
        nfc: "\u{B58C}",
        nfd: "\u{1104}\u{1164}\u{11AF}",
        nfkc: "\u{B58C}",
        nfkd: "\u{1104}\u{1164}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B58D}",
        nfc: "\u{B58D}",
        nfd: "\u{1104}\u{1164}\u{11B0}",
        nfkc: "\u{B58D}",
        nfkd: "\u{1104}\u{1164}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B58E}",
        nfc: "\u{B58E}",
        nfd: "\u{1104}\u{1164}\u{11B1}",
        nfkc: "\u{B58E}",
        nfkd: "\u{1104}\u{1164}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B58F}",
        nfc: "\u{B58F}",
        nfd: "\u{1104}\u{1164}\u{11B2}",
        nfkc: "\u{B58F}",
        nfkd: "\u{1104}\u{1164}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B590}",
        nfc: "\u{B590}",
        nfd: "\u{1104}\u{1164}\u{11B3}",
        nfkc: "\u{B590}",
        nfkd: "\u{1104}\u{1164}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B591}",
        nfc: "\u{B591}",
        nfd: "\u{1104}\u{1164}\u{11B4}",
        nfkc: "\u{B591}",
        nfkd: "\u{1104}\u{1164}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B592}",
        nfc: "\u{B592}",
        nfd: "\u{1104}\u{1164}\u{11B5}",
        nfkc: "\u{B592}",
        nfkd: "\u{1104}\u{1164}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B593}",
        nfc: "\u{B593}",
        nfd: "\u{1104}\u{1164}\u{11B6}",
        nfkc: "\u{B593}",
        nfkd: "\u{1104}\u{1164}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B594}",
        nfc: "\u{B594}",
        nfd: "\u{1104}\u{1164}\u{11B7}",
        nfkc: "\u{B594}",
        nfkd: "\u{1104}\u{1164}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B595}",
        nfc: "\u{B595}",
        nfd: "\u{1104}\u{1164}\u{11B8}",
        nfkc: "\u{B595}",
        nfkd: "\u{1104}\u{1164}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B596}",
        nfc: "\u{B596}",
        nfd: "\u{1104}\u{1164}\u{11B9}",
        nfkc: "\u{B596}",
        nfkd: "\u{1104}\u{1164}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B597}",
        nfc: "\u{B597}",
        nfd: "\u{1104}\u{1164}\u{11BA}",
        nfkc: "\u{B597}",
        nfkd: "\u{1104}\u{1164}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B598}",
        nfc: "\u{B598}",
        nfd: "\u{1104}\u{1164}\u{11BB}",
        nfkc: "\u{B598}",
        nfkd: "\u{1104}\u{1164}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B599}",
        nfc: "\u{B599}",
        nfd: "\u{1104}\u{1164}\u{11BC}",
        nfkc: "\u{B599}",
        nfkd: "\u{1104}\u{1164}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B59A}",
        nfc: "\u{B59A}",
        nfd: "\u{1104}\u{1164}\u{11BD}",
        nfkc: "\u{B59A}",
        nfkd: "\u{1104}\u{1164}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B59B}",
        nfc: "\u{B59B}",
        nfd: "\u{1104}\u{1164}\u{11BE}",
        nfkc: "\u{B59B}",
        nfkd: "\u{1104}\u{1164}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B59C}",
        nfc: "\u{B59C}",
        nfd: "\u{1104}\u{1164}\u{11BF}",
        nfkc: "\u{B59C}",
        nfkd: "\u{1104}\u{1164}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B59D}",
        nfc: "\u{B59D}",
        nfd: "\u{1104}\u{1164}\u{11C0}",
        nfkc: "\u{B59D}",
        nfkd: "\u{1104}\u{1164}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B59E}",
        nfc: "\u{B59E}",
        nfd: "\u{1104}\u{1164}\u{11C1}",
        nfkc: "\u{B59E}",
        nfkd: "\u{1104}\u{1164}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B59F}",
        nfc: "\u{B59F}",
        nfd: "\u{1104}\u{1164}\u{11C2}",
        nfkc: "\u{B59F}",
        nfkd: "\u{1104}\u{1164}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B5A0}",
        nfc: "\u{B5A0}",
        nfd: "\u{1104}\u{1165}",
        nfkc: "\u{B5A0}",
        nfkd: "\u{1104}\u{1165}",
    },
    NormalizationTest {
        source: "\u{B5A1}",
        nfc: "\u{B5A1}",
        nfd: "\u{1104}\u{1165}\u{11A8}",
        nfkc: "\u{B5A1}",
        nfkd: "\u{1104}\u{1165}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B5A2}",
        nfc: "\u{B5A2}",
        nfd: "\u{1104}\u{1165}\u{11A9}",
        nfkc: "\u{B5A2}",
        nfkd: "\u{1104}\u{1165}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B5A3}",
        nfc: "\u{B5A3}",
        nfd: "\u{1104}\u{1165}\u{11AA}",
        nfkc: "\u{B5A3}",
        nfkd: "\u{1104}\u{1165}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B5A4}",
        nfc: "\u{B5A4}",
        nfd: "\u{1104}\u{1165}\u{11AB}",
        nfkc: "\u{B5A4}",
        nfkd: "\u{1104}\u{1165}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B5A5}",
        nfc: "\u{B5A5}",
        nfd: "\u{1104}\u{1165}\u{11AC}",
        nfkc: "\u{B5A5}",
        nfkd: "\u{1104}\u{1165}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B5A6}",
        nfc: "\u{B5A6}",
        nfd: "\u{1104}\u{1165}\u{11AD}",
        nfkc: "\u{B5A6}",
        nfkd: "\u{1104}\u{1165}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B5A7}",
        nfc: "\u{B5A7}",
        nfd: "\u{1104}\u{1165}\u{11AE}",
        nfkc: "\u{B5A7}",
        nfkd: "\u{1104}\u{1165}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B5A8}",
        nfc: "\u{B5A8}",
        nfd: "\u{1104}\u{1165}\u{11AF}",
        nfkc: "\u{B5A8}",
        nfkd: "\u{1104}\u{1165}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B5A9}",
        nfc: "\u{B5A9}",
        nfd: "\u{1104}\u{1165}\u{11B0}",
        nfkc: "\u{B5A9}",
        nfkd: "\u{1104}\u{1165}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B5AA}",
        nfc: "\u{B5AA}",
        nfd: "\u{1104}\u{1165}\u{11B1}",
        nfkc: "\u{B5AA}",
        nfkd: "\u{1104}\u{1165}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B5AB}",
        nfc: "\u{B5AB}",
        nfd: "\u{1104}\u{1165}\u{11B2}",
        nfkc: "\u{B5AB}",
        nfkd: "\u{1104}\u{1165}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B5AC}",
        nfc: "\u{B5AC}",
        nfd: "\u{1104}\u{1165}\u{11B3}",
        nfkc: "\u{B5AC}",
        nfkd: "\u{1104}\u{1165}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B5AD}",
        nfc: "\u{B5AD}",
        nfd: "\u{1104}\u{1165}\u{11B4}",
        nfkc: "\u{B5AD}",
        nfkd: "\u{1104}\u{1165}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B5AE}",
        nfc: "\u{B5AE}",
        nfd: "\u{1104}\u{1165}\u{11B5}",
        nfkc: "\u{B5AE}",
        nfkd: "\u{1104}\u{1165}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B5AF}",
        nfc: "\u{B5AF}",
        nfd: "\u{1104}\u{1165}\u{11B6}",
        nfkc: "\u{B5AF}",
        nfkd: "\u{1104}\u{1165}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B5B0}",
        nfc: "\u{B5B0}",
        nfd: "\u{1104}\u{1165}\u{11B7}",
        nfkc: "\u{B5B0}",
        nfkd: "\u{1104}\u{1165}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B5B1}",
        nfc: "\u{B5B1}",
        nfd: "\u{1104}\u{1165}\u{11B8}",
        nfkc: "\u{B5B1}",
        nfkd: "\u{1104}\u{1165}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B5B2}",
        nfc: "\u{B5B2}",
        nfd: "\u{1104}\u{1165}\u{11B9}",
        nfkc: "\u{B5B2}",
        nfkd: "\u{1104}\u{1165}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B5B3}",
        nfc: "\u{B5B3}",
        nfd: "\u{1104}\u{1165}\u{11BA}",
        nfkc: "\u{B5B3}",
        nfkd: "\u{1104}\u{1165}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B5B4}",
        nfc: "\u{B5B4}",
        nfd: "\u{1104}\u{1165}\u{11BB}",
        nfkc: "\u{B5B4}",
        nfkd: "\u{1104}\u{1165}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B5B5}",
        nfc: "\u{B5B5}",
        nfd: "\u{1104}\u{1165}\u{11BC}",
        nfkc: "\u{B5B5}",
        nfkd: "\u{1104}\u{1165}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B5B6}",
        nfc: "\u{B5B6}",
        nfd: "\u{1104}\u{1165}\u{11BD}",
        nfkc: "\u{B5B6}",
        nfkd: "\u{1104}\u{1165}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B5B7}",
        nfc: "\u{B5B7}",
        nfd: "\u{1104}\u{1165}\u{11BE}",
        nfkc: "\u{B5B7}",
        nfkd: "\u{1104}\u{1165}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B5B8}",
        nfc: "\u{B5B8}",
        nfd: "\u{1104}\u{1165}\u{11BF}",
        nfkc: "\u{B5B8}",
        nfkd: "\u{1104}\u{1165}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B5B9}",
        nfc: "\u{B5B9}",
        nfd: "\u{1104}\u{1165}\u{11C0}",
        nfkc: "\u{B5B9}",
        nfkd: "\u{1104}\u{1165}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B5BA}",
        nfc: "\u{B5BA}",
        nfd: "\u{1104}\u{1165}\u{11C1}",
        nfkc: "\u{B5BA}",
        nfkd: "\u{1104}\u{1165}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B5BB}",
        nfc: "\u{B5BB}",
        nfd: "\u{1104}\u{1165}\u{11C2}",
        nfkc: "\u{B5BB}",
        nfkd: "\u{1104}\u{1165}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B5BC}",
        nfc: "\u{B5BC}",
        nfd: "\u{1104}\u{1166}",
        nfkc: "\u{B5BC}",
        nfkd: "\u{1104}\u{1166}",
    },
    NormalizationTest {
        source: "\u{B5BD}",
        nfc: "\u{B5BD}",
        nfd: "\u{1104}\u{1166}\u{11A8}",
        nfkc: "\u{B5BD}",
        nfkd: "\u{1104}\u{1166}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B5BE}",
        nfc: "\u{B5BE}",
        nfd: "\u{1104}\u{1166}\u{11A9}",
        nfkc: "\u{B5BE}",
        nfkd: "\u{1104}\u{1166}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B5BF}",
        nfc: "\u{B5BF}",
        nfd: "\u{1104}\u{1166}\u{11AA}",
        nfkc: "\u{B5BF}",
        nfkd: "\u{1104}\u{1166}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B5C0}",
        nfc: "\u{B5C0}",
        nfd: "\u{1104}\u{1166}\u{11AB}",
        nfkc: "\u{B5C0}",
        nfkd: "\u{1104}\u{1166}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B5C1}",
        nfc: "\u{B5C1}",
        nfd: "\u{1104}\u{1166}\u{11AC}",
        nfkc: "\u{B5C1}",
        nfkd: "\u{1104}\u{1166}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B5C2}",
        nfc: "\u{B5C2}",
        nfd: "\u{1104}\u{1166}\u{11AD}",
        nfkc: "\u{B5C2}",
        nfkd: "\u{1104}\u{1166}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B5C3}",
        nfc: "\u{B5C3}",
        nfd: "\u{1104}\u{1166}\u{11AE}",
        nfkc: "\u{B5C3}",
        nfkd: "\u{1104}\u{1166}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B5C4}",
        nfc: "\u{B5C4}",
        nfd: "\u{1104}\u{1166}\u{11AF}",
        nfkc: "\u{B5C4}",
        nfkd: "\u{1104}\u{1166}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B5C5}",
        nfc: "\u{B5C5}",
        nfd: "\u{1104}\u{1166}\u{11B0}",
        nfkc: "\u{B5C5}",
        nfkd: "\u{1104}\u{1166}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B5C6}",
        nfc: "\u{B5C6}",
        nfd: "\u{1104}\u{1166}\u{11B1}",
        nfkc: "\u{B5C6}",
        nfkd: "\u{1104}\u{1166}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B5C7}",
        nfc: "\u{B5C7}",
        nfd: "\u{1104}\u{1166}\u{11B2}",
        nfkc: "\u{B5C7}",
        nfkd: "\u{1104}\u{1166}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B5C8}",
        nfc: "\u{B5C8}",
        nfd: "\u{1104}\u{1166}\u{11B3}",
        nfkc: "\u{B5C8}",
        nfkd: "\u{1104}\u{1166}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B5C9}",
        nfc: "\u{B5C9}",
        nfd: "\u{1104}\u{1166}\u{11B4}",
        nfkc: "\u{B5C9}",
        nfkd: "\u{1104}\u{1166}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B5CA}",
        nfc: "\u{B5CA}",
        nfd: "\u{1104}\u{1166}\u{11B5}",
        nfkc: "\u{B5CA}",
        nfkd: "\u{1104}\u{1166}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B5CB}",
        nfc: "\u{B5CB}",
        nfd: "\u{1104}\u{1166}\u{11B6}",
        nfkc: "\u{B5CB}",
        nfkd: "\u{1104}\u{1166}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B5CC}",
        nfc: "\u{B5CC}",
        nfd: "\u{1104}\u{1166}\u{11B7}",
        nfkc: "\u{B5CC}",
        nfkd: "\u{1104}\u{1166}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B5CD}",
        nfc: "\u{B5CD}",
        nfd: "\u{1104}\u{1166}\u{11B8}",
        nfkc: "\u{B5CD}",
        nfkd: "\u{1104}\u{1166}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B5CE}",
        nfc: "\u{B5CE}",
        nfd: "\u{1104}\u{1166}\u{11B9}",
        nfkc: "\u{B5CE}",
        nfkd: "\u{1104}\u{1166}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B5CF}",
        nfc: "\u{B5CF}",
        nfd: "\u{1104}\u{1166}\u{11BA}",
        nfkc: "\u{B5CF}",
        nfkd: "\u{1104}\u{1166}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B5D0}",
        nfc: "\u{B5D0}",
        nfd: "\u{1104}\u{1166}\u{11BB}",
        nfkc: "\u{B5D0}",
        nfkd: "\u{1104}\u{1166}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B5D1}",
        nfc: "\u{B5D1}",
        nfd: "\u{1104}\u{1166}\u{11BC}",
        nfkc: "\u{B5D1}",
        nfkd: "\u{1104}\u{1166}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B5D2}",
        nfc: "\u{B5D2}",
        nfd: "\u{1104}\u{1166}\u{11BD}",
        nfkc: "\u{B5D2}",
        nfkd: "\u{1104}\u{1166}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B5D3}",
        nfc: "\u{B5D3}",
        nfd: "\u{1104}\u{1166}\u{11BE}",
        nfkc: "\u{B5D3}",
        nfkd: "\u{1104}\u{1166}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B5D4}",
        nfc: "\u{B5D4}",
        nfd: "\u{1104}\u{1166}\u{11BF}",
        nfkc: "\u{B5D4}",
        nfkd: "\u{1104}\u{1166}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B5D5}",
        nfc: "\u{B5D5}",
        nfd: "\u{1104}\u{1166}\u{11C0}",
        nfkc: "\u{B5D5}",
        nfkd: "\u{1104}\u{1166}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B5D6}",
        nfc: "\u{B5D6}",
        nfd: "\u{1104}\u{1166}\u{11C1}",
        nfkc: "\u{B5D6}",
        nfkd: "\u{1104}\u{1166}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B5D7}",
        nfc: "\u{B5D7}",
        nfd: "\u{1104}\u{1166}\u{11C2}",
        nfkc: "\u{B5D7}",
        nfkd: "\u{1104}\u{1166}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B5D8}",
        nfc: "\u{B5D8}",
        nfd: "\u{1104}\u{1167}",
        nfkc: "\u{B5D8}",
        nfkd: "\u{1104}\u{1167}",
    },
    NormalizationTest {
        source: "\u{B5D9}",
        nfc: "\u{B5D9}",
        nfd: "\u{1104}\u{1167}\u{11A8}",
        nfkc: "\u{B5D9}",
        nfkd: "\u{1104}\u{1167}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B5DA}",
        nfc: "\u{B5DA}",
        nfd: "\u{1104}\u{1167}\u{11A9}",
        nfkc: "\u{B5DA}",
        nfkd: "\u{1104}\u{1167}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B5DB}",
        nfc: "\u{B5DB}",
        nfd: "\u{1104}\u{1167}\u{11AA}",
        nfkc: "\u{B5DB}",
        nfkd: "\u{1104}\u{1167}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B5DC}",
        nfc: "\u{B5DC}",
        nfd: "\u{1104}\u{1167}\u{11AB}",
        nfkc: "\u{B5DC}",
        nfkd: "\u{1104}\u{1167}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B5DD}",
        nfc: "\u{B5DD}",
        nfd: "\u{1104}\u{1167}\u{11AC}",
        nfkc: "\u{B5DD}",
        nfkd: "\u{1104}\u{1167}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B5DE}",
        nfc: "\u{B5DE}",
        nfd: "\u{1104}\u{1167}\u{11AD}",
        nfkc: "\u{B5DE}",
        nfkd: "\u{1104}\u{1167}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B5DF}",
        nfc: "\u{B5DF}",
        nfd: "\u{1104}\u{1167}\u{11AE}",
        nfkc: "\u{B5DF}",
        nfkd: "\u{1104}\u{1167}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B5E0}",
        nfc: "\u{B5E0}",
        nfd: "\u{1104}\u{1167}\u{11AF}",
        nfkc: "\u{B5E0}",
        nfkd: "\u{1104}\u{1167}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B5E1}",
        nfc: "\u{B5E1}",
        nfd: "\u{1104}\u{1167}\u{11B0}",
        nfkc: "\u{B5E1}",
        nfkd: "\u{1104}\u{1167}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B5E2}",
        nfc: "\u{B5E2}",
        nfd: "\u{1104}\u{1167}\u{11B1}",
        nfkc: "\u{B5E2}",
        nfkd: "\u{1104}\u{1167}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B5E3}",
        nfc: "\u{B5E3}",
        nfd: "\u{1104}\u{1167}\u{11B2}",
        nfkc: "\u{B5E3}",
        nfkd: "\u{1104}\u{1167}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B5E4}",
        nfc: "\u{B5E4}",
        nfd: "\u{1104}\u{1167}\u{11B3}",
        nfkc: "\u{B5E4}",
        nfkd: "\u{1104}\u{1167}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B5E5}",
        nfc: "\u{B5E5}",
        nfd: "\u{1104}\u{1167}\u{11B4}",
        nfkc: "\u{B5E5}",
        nfkd: "\u{1104}\u{1167}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B5E6}",
        nfc: "\u{B5E6}",
        nfd: "\u{1104}\u{1167}\u{11B5}",
        nfkc: "\u{B5E6}",
        nfkd: "\u{1104}\u{1167}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B5E7}",
        nfc: "\u{B5E7}",
        nfd: "\u{1104}\u{1167}\u{11B6}",
        nfkc: "\u{B5E7}",
        nfkd: "\u{1104}\u{1167}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B5E8}",
        nfc: "\u{B5E8}",
        nfd: "\u{1104}\u{1167}\u{11B7}",
        nfkc: "\u{B5E8}",
        nfkd: "\u{1104}\u{1167}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B5E9}",
        nfc: "\u{B5E9}",
        nfd: "\u{1104}\u{1167}\u{11B8}",
        nfkc: "\u{B5E9}",
        nfkd: "\u{1104}\u{1167}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B5EA}",
        nfc: "\u{B5EA}",
        nfd: "\u{1104}\u{1167}\u{11B9}",
        nfkc: "\u{B5EA}",
        nfkd: "\u{1104}\u{1167}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B5EB}",
        nfc: "\u{B5EB}",
        nfd: "\u{1104}\u{1167}\u{11BA}",
        nfkc: "\u{B5EB}",
        nfkd: "\u{1104}\u{1167}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B5EC}",
        nfc: "\u{B5EC}",
        nfd: "\u{1104}\u{1167}\u{11BB}",
        nfkc: "\u{B5EC}",
        nfkd: "\u{1104}\u{1167}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B5ED}",
        nfc: "\u{B5ED}",
        nfd: "\u{1104}\u{1167}\u{11BC}",
        nfkc: "\u{B5ED}",
        nfkd: "\u{1104}\u{1167}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B5EE}",
        nfc: "\u{B5EE}",
        nfd: "\u{1104}\u{1167}\u{11BD}",
        nfkc: "\u{B5EE}",
        nfkd: "\u{1104}\u{1167}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B5EF}",
        nfc: "\u{B5EF}",
        nfd: "\u{1104}\u{1167}\u{11BE}",
        nfkc: "\u{B5EF}",
        nfkd: "\u{1104}\u{1167}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B5F0}",
        nfc: "\u{B5F0}",
        nfd: "\u{1104}\u{1167}\u{11BF}",
        nfkc: "\u{B5F0}",
        nfkd: "\u{1104}\u{1167}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B5F1}",
        nfc: "\u{B5F1}",
        nfd: "\u{1104}\u{1167}\u{11C0}",
        nfkc: "\u{B5F1}",
        nfkd: "\u{1104}\u{1167}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B5F2}",
        nfc: "\u{B5F2}",
        nfd: "\u{1104}\u{1167}\u{11C1}",
        nfkc: "\u{B5F2}",
        nfkd: "\u{1104}\u{1167}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B5F3}",
        nfc: "\u{B5F3}",
        nfd: "\u{1104}\u{1167}\u{11C2}",
        nfkc: "\u{B5F3}",
        nfkd: "\u{1104}\u{1167}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B5F4}",
        nfc: "\u{B5F4}",
        nfd: "\u{1104}\u{1168}",
        nfkc: "\u{B5F4}",
        nfkd: "\u{1104}\u{1168}",
    },
    NormalizationTest {
        source: "\u{B5F5}",
        nfc: "\u{B5F5}",
        nfd: "\u{1104}\u{1168}\u{11A8}",
        nfkc: "\u{B5F5}",
        nfkd: "\u{1104}\u{1168}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B5F6}",
        nfc: "\u{B5F6}",
        nfd: "\u{1104}\u{1168}\u{11A9}",
        nfkc: "\u{B5F6}",
        nfkd: "\u{1104}\u{1168}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B5F7}",
        nfc: "\u{B5F7}",
        nfd: "\u{1104}\u{1168}\u{11AA}",
        nfkc: "\u{B5F7}",
        nfkd: "\u{1104}\u{1168}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B5F8}",
        nfc: "\u{B5F8}",
        nfd: "\u{1104}\u{1168}\u{11AB}",
        nfkc: "\u{B5F8}",
        nfkd: "\u{1104}\u{1168}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B5F9}",
        nfc: "\u{B5F9}",
        nfd: "\u{1104}\u{1168}\u{11AC}",
        nfkc: "\u{B5F9}",
        nfkd: "\u{1104}\u{1168}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B5FA}",
        nfc: "\u{B5FA}",
        nfd: "\u{1104}\u{1168}\u{11AD}",
        nfkc: "\u{B5FA}",
        nfkd: "\u{1104}\u{1168}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B5FB}",
        nfc: "\u{B5FB}",
        nfd: "\u{1104}\u{1168}\u{11AE}",
        nfkc: "\u{B5FB}",
        nfkd: "\u{1104}\u{1168}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B5FC}",
        nfc: "\u{B5FC}",
        nfd: "\u{1104}\u{1168}\u{11AF}",
        nfkc: "\u{B5FC}",
        nfkd: "\u{1104}\u{1168}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B5FD}",
        nfc: "\u{B5FD}",
        nfd: "\u{1104}\u{1168}\u{11B0}",
        nfkc: "\u{B5FD}",
        nfkd: "\u{1104}\u{1168}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B5FE}",
        nfc: "\u{B5FE}",
        nfd: "\u{1104}\u{1168}\u{11B1}",
        nfkc: "\u{B5FE}",
        nfkd: "\u{1104}\u{1168}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B5FF}",
        nfc: "\u{B5FF}",
        nfd: "\u{1104}\u{1168}\u{11B2}",
        nfkc: "\u{B5FF}",
        nfkd: "\u{1104}\u{1168}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B600}",
        nfc: "\u{B600}",
        nfd: "\u{1104}\u{1168}\u{11B3}",
        nfkc: "\u{B600}",
        nfkd: "\u{1104}\u{1168}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B601}",
        nfc: "\u{B601}",
        nfd: "\u{1104}\u{1168}\u{11B4}",
        nfkc: "\u{B601}",
        nfkd: "\u{1104}\u{1168}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B602}",
        nfc: "\u{B602}",
        nfd: "\u{1104}\u{1168}\u{11B5}",
        nfkc: "\u{B602}",
        nfkd: "\u{1104}\u{1168}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B603}",
        nfc: "\u{B603}",
        nfd: "\u{1104}\u{1168}\u{11B6}",
        nfkc: "\u{B603}",
        nfkd: "\u{1104}\u{1168}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B604}",
        nfc: "\u{B604}",
        nfd: "\u{1104}\u{1168}\u{11B7}",
        nfkc: "\u{B604}",
        nfkd: "\u{1104}\u{1168}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B605}",
        nfc: "\u{B605}",
        nfd: "\u{1104}\u{1168}\u{11B8}",
        nfkc: "\u{B605}",
        nfkd: "\u{1104}\u{1168}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B606}",
        nfc: "\u{B606}",
        nfd: "\u{1104}\u{1168}\u{11B9}",
        nfkc: "\u{B606}",
        nfkd: "\u{1104}\u{1168}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B607}",
        nfc: "\u{B607}",
        nfd: "\u{1104}\u{1168}\u{11BA}",
        nfkc: "\u{B607}",
        nfkd: "\u{1104}\u{1168}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B608}",
        nfc: "\u{B608}",
        nfd: "\u{1104}\u{1168}\u{11BB}",
        nfkc: "\u{B608}",
        nfkd: "\u{1104}\u{1168}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B609}",
        nfc: "\u{B609}",
        nfd: "\u{1104}\u{1168}\u{11BC}",
        nfkc: "\u{B609}",
        nfkd: "\u{1104}\u{1168}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B60A}",
        nfc: "\u{B60A}",
        nfd: "\u{1104}\u{1168}\u{11BD}",
        nfkc: "\u{B60A}",
        nfkd: "\u{1104}\u{1168}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B60B}",
        nfc: "\u{B60B}",
        nfd: "\u{1104}\u{1168}\u{11BE}",
        nfkc: "\u{B60B}",
        nfkd: "\u{1104}\u{1168}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B60C}",
        nfc: "\u{B60C}",
        nfd: "\u{1104}\u{1168}\u{11BF}",
        nfkc: "\u{B60C}",
        nfkd: "\u{1104}\u{1168}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B60D}",
        nfc: "\u{B60D}",
        nfd: "\u{1104}\u{1168}\u{11C0}",
        nfkc: "\u{B60D}",
        nfkd: "\u{1104}\u{1168}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B60E}",
        nfc: "\u{B60E}",
        nfd: "\u{1104}\u{1168}\u{11C1}",
        nfkc: "\u{B60E}",
        nfkd: "\u{1104}\u{1168}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B60F}",
        nfc: "\u{B60F}",
        nfd: "\u{1104}\u{1168}\u{11C2}",
        nfkc: "\u{B60F}",
        nfkd: "\u{1104}\u{1168}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B610}",
        nfc: "\u{B610}",
        nfd: "\u{1104}\u{1169}",
        nfkc: "\u{B610}",
        nfkd: "\u{1104}\u{1169}",
    },
    NormalizationTest {
        source: "\u{B611}",
        nfc: "\u{B611}",
        nfd: "\u{1104}\u{1169}\u{11A8}",
        nfkc: "\u{B611}",
        nfkd: "\u{1104}\u{1169}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B612}",
        nfc: "\u{B612}",
        nfd: "\u{1104}\u{1169}\u{11A9}",
        nfkc: "\u{B612}",
        nfkd: "\u{1104}\u{1169}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B613}",
        nfc: "\u{B613}",
        nfd: "\u{1104}\u{1169}\u{11AA}",
        nfkc: "\u{B613}",
        nfkd: "\u{1104}\u{1169}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B614}",
        nfc: "\u{B614}",
        nfd: "\u{1104}\u{1169}\u{11AB}",
        nfkc: "\u{B614}",
        nfkd: "\u{1104}\u{1169}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B615}",
        nfc: "\u{B615}",
        nfd: "\u{1104}\u{1169}\u{11AC}",
        nfkc: "\u{B615}",
        nfkd: "\u{1104}\u{1169}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B616}",
        nfc: "\u{B616}",
        nfd: "\u{1104}\u{1169}\u{11AD}",
        nfkc: "\u{B616}",
        nfkd: "\u{1104}\u{1169}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B617}",
        nfc: "\u{B617}",
        nfd: "\u{1104}\u{1169}\u{11AE}",
        nfkc: "\u{B617}",
        nfkd: "\u{1104}\u{1169}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B618}",
        nfc: "\u{B618}",
        nfd: "\u{1104}\u{1169}\u{11AF}",
        nfkc: "\u{B618}",
        nfkd: "\u{1104}\u{1169}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B619}",
        nfc: "\u{B619}",
        nfd: "\u{1104}\u{1169}\u{11B0}",
        nfkc: "\u{B619}",
        nfkd: "\u{1104}\u{1169}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B61A}",
        nfc: "\u{B61A}",
        nfd: "\u{1104}\u{1169}\u{11B1}",
        nfkc: "\u{B61A}",
        nfkd: "\u{1104}\u{1169}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B61B}",
        nfc: "\u{B61B}",
        nfd: "\u{1104}\u{1169}\u{11B2}",
        nfkc: "\u{B61B}",
        nfkd: "\u{1104}\u{1169}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B61C}",
        nfc: "\u{B61C}",
        nfd: "\u{1104}\u{1169}\u{11B3}",
        nfkc: "\u{B61C}",
        nfkd: "\u{1104}\u{1169}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B61D}",
        nfc: "\u{B61D}",
        nfd: "\u{1104}\u{1169}\u{11B4}",
        nfkc: "\u{B61D}",
        nfkd: "\u{1104}\u{1169}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B61E}",
        nfc: "\u{B61E}",
        nfd: "\u{1104}\u{1169}\u{11B5}",
        nfkc: "\u{B61E}",
        nfkd: "\u{1104}\u{1169}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B61F}",
        nfc: "\u{B61F}",
        nfd: "\u{1104}\u{1169}\u{11B6}",
        nfkc: "\u{B61F}",
        nfkd: "\u{1104}\u{1169}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B620}",
        nfc: "\u{B620}",
        nfd: "\u{1104}\u{1169}\u{11B7}",
        nfkc: "\u{B620}",
        nfkd: "\u{1104}\u{1169}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B621}",
        nfc: "\u{B621}",
        nfd: "\u{1104}\u{1169}\u{11B8}",
        nfkc: "\u{B621}",
        nfkd: "\u{1104}\u{1169}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B622}",
        nfc: "\u{B622}",
        nfd: "\u{1104}\u{1169}\u{11B9}",
        nfkc: "\u{B622}",
        nfkd: "\u{1104}\u{1169}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B623}",
        nfc: "\u{B623}",
        nfd: "\u{1104}\u{1169}\u{11BA}",
        nfkc: "\u{B623}",
        nfkd: "\u{1104}\u{1169}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B624}",
        nfc: "\u{B624}",
        nfd: "\u{1104}\u{1169}\u{11BB}",
        nfkc: "\u{B624}",
        nfkd: "\u{1104}\u{1169}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B625}",
        nfc: "\u{B625}",
        nfd: "\u{1104}\u{1169}\u{11BC}",
        nfkc: "\u{B625}",
        nfkd: "\u{1104}\u{1169}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B626}",
        nfc: "\u{B626}",
        nfd: "\u{1104}\u{1169}\u{11BD}",
        nfkc: "\u{B626}",
        nfkd: "\u{1104}\u{1169}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B627}",
        nfc: "\u{B627}",
        nfd: "\u{1104}\u{1169}\u{11BE}",
        nfkc: "\u{B627}",
        nfkd: "\u{1104}\u{1169}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B628}",
        nfc: "\u{B628}",
        nfd: "\u{1104}\u{1169}\u{11BF}",
        nfkc: "\u{B628}",
        nfkd: "\u{1104}\u{1169}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B629}",
        nfc: "\u{B629}",
        nfd: "\u{1104}\u{1169}\u{11C0}",
        nfkc: "\u{B629}",
        nfkd: "\u{1104}\u{1169}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B62A}",
        nfc: "\u{B62A}",
        nfd: "\u{1104}\u{1169}\u{11C1}",
        nfkc: "\u{B62A}",
        nfkd: "\u{1104}\u{1169}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B62B}",
        nfc: "\u{B62B}",
        nfd: "\u{1104}\u{1169}\u{11C2}",
        nfkc: "\u{B62B}",
        nfkd: "\u{1104}\u{1169}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B62C}",
        nfc: "\u{B62C}",
        nfd: "\u{1104}\u{116A}",
        nfkc: "\u{B62C}",
        nfkd: "\u{1104}\u{116A}",
    },
    NormalizationTest {
        source: "\u{B62D}",
        nfc: "\u{B62D}",
        nfd: "\u{1104}\u{116A}\u{11A8}",
        nfkc: "\u{B62D}",
        nfkd: "\u{1104}\u{116A}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B62E}",
        nfc: "\u{B62E}",
        nfd: "\u{1104}\u{116A}\u{11A9}",
        nfkc: "\u{B62E}",
        nfkd: "\u{1104}\u{116A}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B62F}",
        nfc: "\u{B62F}",
        nfd: "\u{1104}\u{116A}\u{11AA}",
        nfkc: "\u{B62F}",
        nfkd: "\u{1104}\u{116A}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B630}",
        nfc: "\u{B630}",
        nfd: "\u{1104}\u{116A}\u{11AB}",
        nfkc: "\u{B630}",
        nfkd: "\u{1104}\u{116A}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B631}",
        nfc: "\u{B631}",
        nfd: "\u{1104}\u{116A}\u{11AC}",
        nfkc: "\u{B631}",
        nfkd: "\u{1104}\u{116A}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B632}",
        nfc: "\u{B632}",
        nfd: "\u{1104}\u{116A}\u{11AD}",
        nfkc: "\u{B632}",
        nfkd: "\u{1104}\u{116A}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B633}",
        nfc: "\u{B633}",
        nfd: "\u{1104}\u{116A}\u{11AE}",
        nfkc: "\u{B633}",
        nfkd: "\u{1104}\u{116A}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B634}",
        nfc: "\u{B634}",
        nfd: "\u{1104}\u{116A}\u{11AF}",
        nfkc: "\u{B634}",
        nfkd: "\u{1104}\u{116A}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B635}",
        nfc: "\u{B635}",
        nfd: "\u{1104}\u{116A}\u{11B0}",
        nfkc: "\u{B635}",
        nfkd: "\u{1104}\u{116A}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B636}",
        nfc: "\u{B636}",
        nfd: "\u{1104}\u{116A}\u{11B1}",
        nfkc: "\u{B636}",
        nfkd: "\u{1104}\u{116A}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B637}",
        nfc: "\u{B637}",
        nfd: "\u{1104}\u{116A}\u{11B2}",
        nfkc: "\u{B637}",
        nfkd: "\u{1104}\u{116A}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B638}",
        nfc: "\u{B638}",
        nfd: "\u{1104}\u{116A}\u{11B3}",
        nfkc: "\u{B638}",
        nfkd: "\u{1104}\u{116A}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B639}",
        nfc: "\u{B639}",
        nfd: "\u{1104}\u{116A}\u{11B4}",
        nfkc: "\u{B639}",
        nfkd: "\u{1104}\u{116A}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B63A}",
        nfc: "\u{B63A}",
        nfd: "\u{1104}\u{116A}\u{11B5}",
        nfkc: "\u{B63A}",
        nfkd: "\u{1104}\u{116A}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B63B}",
        nfc: "\u{B63B}",
        nfd: "\u{1104}\u{116A}\u{11B6}",
        nfkc: "\u{B63B}",
        nfkd: "\u{1104}\u{116A}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B63C}",
        nfc: "\u{B63C}",
        nfd: "\u{1104}\u{116A}\u{11B7}",
        nfkc: "\u{B63C}",
        nfkd: "\u{1104}\u{116A}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B63D}",
        nfc: "\u{B63D}",
        nfd: "\u{1104}\u{116A}\u{11B8}",
        nfkc: "\u{B63D}",
        nfkd: "\u{1104}\u{116A}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B63E}",
        nfc: "\u{B63E}",
        nfd: "\u{1104}\u{116A}\u{11B9}",
        nfkc: "\u{B63E}",
        nfkd: "\u{1104}\u{116A}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B63F}",
        nfc: "\u{B63F}",
        nfd: "\u{1104}\u{116A}\u{11BA}",
        nfkc: "\u{B63F}",
        nfkd: "\u{1104}\u{116A}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B640}",
        nfc: "\u{B640}",
        nfd: "\u{1104}\u{116A}\u{11BB}",
        nfkc: "\u{B640}",
        nfkd: "\u{1104}\u{116A}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B641}",
        nfc: "\u{B641}",
        nfd: "\u{1104}\u{116A}\u{11BC}",
        nfkc: "\u{B641}",
        nfkd: "\u{1104}\u{116A}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B642}",
        nfc: "\u{B642}",
        nfd: "\u{1104}\u{116A}\u{11BD}",
        nfkc: "\u{B642}",
        nfkd: "\u{1104}\u{116A}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B643}",
        nfc: "\u{B643}",
        nfd: "\u{1104}\u{116A}\u{11BE}",
        nfkc: "\u{B643}",
        nfkd: "\u{1104}\u{116A}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B644}",
        nfc: "\u{B644}",
        nfd: "\u{1104}\u{116A}\u{11BF}",
        nfkc: "\u{B644}",
        nfkd: "\u{1104}\u{116A}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B645}",
        nfc: "\u{B645}",
        nfd: "\u{1104}\u{116A}\u{11C0}",
        nfkc: "\u{B645}",
        nfkd: "\u{1104}\u{116A}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B646}",
        nfc: "\u{B646}",
        nfd: "\u{1104}\u{116A}\u{11C1}",
        nfkc: "\u{B646}",
        nfkd: "\u{1104}\u{116A}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B647}",
        nfc: "\u{B647}",
        nfd: "\u{1104}\u{116A}\u{11C2}",
        nfkc: "\u{B647}",
        nfkd: "\u{1104}\u{116A}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B648}",
        nfc: "\u{B648}",
        nfd: "\u{1104}\u{116B}",
        nfkc: "\u{B648}",
        nfkd: "\u{1104}\u{116B}",
    },
    NormalizationTest {
        source: "\u{B649}",
        nfc: "\u{B649}",
        nfd: "\u{1104}\u{116B}\u{11A8}",
        nfkc: "\u{B649}",
        nfkd: "\u{1104}\u{116B}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B64A}",
        nfc: "\u{B64A}",
        nfd: "\u{1104}\u{116B}\u{11A9}",
        nfkc: "\u{B64A}",
        nfkd: "\u{1104}\u{116B}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B64B}",
        nfc: "\u{B64B}",
        nfd: "\u{1104}\u{116B}\u{11AA}",
        nfkc: "\u{B64B}",
        nfkd: "\u{1104}\u{116B}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B64C}",
        nfc: "\u{B64C}",
        nfd: "\u{1104}\u{116B}\u{11AB}",
        nfkc: "\u{B64C}",
        nfkd: "\u{1104}\u{116B}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B64D}",
        nfc: "\u{B64D}",
        nfd: "\u{1104}\u{116B}\u{11AC}",
        nfkc: "\u{B64D}",
        nfkd: "\u{1104}\u{116B}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B64E}",
        nfc: "\u{B64E}",
        nfd: "\u{1104}\u{116B}\u{11AD}",
        nfkc: "\u{B64E}",
        nfkd: "\u{1104}\u{116B}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B64F}",
        nfc: "\u{B64F}",
        nfd: "\u{1104}\u{116B}\u{11AE}",
        nfkc: "\u{B64F}",
        nfkd: "\u{1104}\u{116B}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B650}",
        nfc: "\u{B650}",
        nfd: "\u{1104}\u{116B}\u{11AF}",
        nfkc: "\u{B650}",
        nfkd: "\u{1104}\u{116B}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B651}",
        nfc: "\u{B651}",
        nfd: "\u{1104}\u{116B}\u{11B0}",
        nfkc: "\u{B651}",
        nfkd: "\u{1104}\u{116B}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B652}",
        nfc: "\u{B652}",
        nfd: "\u{1104}\u{116B}\u{11B1}",
        nfkc: "\u{B652}",
        nfkd: "\u{1104}\u{116B}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B653}",
        nfc: "\u{B653}",
        nfd: "\u{1104}\u{116B}\u{11B2}",
        nfkc: "\u{B653}",
        nfkd: "\u{1104}\u{116B}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B654}",
        nfc: "\u{B654}",
        nfd: "\u{1104}\u{116B}\u{11B3}",
        nfkc: "\u{B654}",
        nfkd: "\u{1104}\u{116B}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B655}",
        nfc: "\u{B655}",
        nfd: "\u{1104}\u{116B}\u{11B4}",
        nfkc: "\u{B655}",
        nfkd: "\u{1104}\u{116B}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B656}",
        nfc: "\u{B656}",
        nfd: "\u{1104}\u{116B}\u{11B5}",
        nfkc: "\u{B656}",
        nfkd: "\u{1104}\u{116B}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B657}",
        nfc: "\u{B657}",
        nfd: "\u{1104}\u{116B}\u{11B6}",
        nfkc: "\u{B657}",
        nfkd: "\u{1104}\u{116B}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B658}",
        nfc: "\u{B658}",
        nfd: "\u{1104}\u{116B}\u{11B7}",
        nfkc: "\u{B658}",
        nfkd: "\u{1104}\u{116B}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B659}",
        nfc: "\u{B659}",
        nfd: "\u{1104}\u{116B}\u{11B8}",
        nfkc: "\u{B659}",
        nfkd: "\u{1104}\u{116B}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B65A}",
        nfc: "\u{B65A}",
        nfd: "\u{1104}\u{116B}\u{11B9}",
        nfkc: "\u{B65A}",
        nfkd: "\u{1104}\u{116B}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B65B}",
        nfc: "\u{B65B}",
        nfd: "\u{1104}\u{116B}\u{11BA}",
        nfkc: "\u{B65B}",
        nfkd: "\u{1104}\u{116B}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B65C}",
        nfc: "\u{B65C}",
        nfd: "\u{1104}\u{116B}\u{11BB}",
        nfkc: "\u{B65C}",
        nfkd: "\u{1104}\u{116B}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B65D}",
        nfc: "\u{B65D}",
        nfd: "\u{1104}\u{116B}\u{11BC}",
        nfkc: "\u{B65D}",
        nfkd: "\u{1104}\u{116B}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B65E}",
        nfc: "\u{B65E}",
        nfd: "\u{1104}\u{116B}\u{11BD}",
        nfkc: "\u{B65E}",
        nfkd: "\u{1104}\u{116B}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B65F}",
        nfc: "\u{B65F}",
        nfd: "\u{1104}\u{116B}\u{11BE}",
        nfkc: "\u{B65F}",
        nfkd: "\u{1104}\u{116B}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B660}",
        nfc: "\u{B660}",
        nfd: "\u{1104}\u{116B}\u{11BF}",
        nfkc: "\u{B660}",
        nfkd: "\u{1104}\u{116B}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B661}",
        nfc: "\u{B661}",
        nfd: "\u{1104}\u{116B}\u{11C0}",
        nfkc: "\u{B661}",
        nfkd: "\u{1104}\u{116B}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B662}",
        nfc: "\u{B662}",
        nfd: "\u{1104}\u{116B}\u{11C1}",
        nfkc: "\u{B662}",
        nfkd: "\u{1104}\u{116B}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B663}",
        nfc: "\u{B663}",
        nfd: "\u{1104}\u{116B}\u{11C2}",
        nfkc: "\u{B663}",
        nfkd: "\u{1104}\u{116B}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B664}",
        nfc: "\u{B664}",
        nfd: "\u{1104}\u{116C}",
        nfkc: "\u{B664}",
        nfkd: "\u{1104}\u{116C}",
    },
    NormalizationTest {
        source: "\u{B665}",
        nfc: "\u{B665}",
        nfd: "\u{1104}\u{116C}\u{11A8}",
        nfkc: "\u{B665}",
        nfkd: "\u{1104}\u{116C}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B666}",
        nfc: "\u{B666}",
        nfd: "\u{1104}\u{116C}\u{11A9}",
        nfkc: "\u{B666}",
        nfkd: "\u{1104}\u{116C}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B667}",
        nfc: "\u{B667}",
        nfd: "\u{1104}\u{116C}\u{11AA}",
        nfkc: "\u{B667}",
        nfkd: "\u{1104}\u{116C}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B668}",
        nfc: "\u{B668}",
        nfd: "\u{1104}\u{116C}\u{11AB}",
        nfkc: "\u{B668}",
        nfkd: "\u{1104}\u{116C}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B669}",
        nfc: "\u{B669}",
        nfd: "\u{1104}\u{116C}\u{11AC}",
        nfkc: "\u{B669}",
        nfkd: "\u{1104}\u{116C}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B66A}",
        nfc: "\u{B66A}",
        nfd: "\u{1104}\u{116C}\u{11AD}",
        nfkc: "\u{B66A}",
        nfkd: "\u{1104}\u{116C}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B66B}",
        nfc: "\u{B66B}",
        nfd: "\u{1104}\u{116C}\u{11AE}",
        nfkc: "\u{B66B}",
        nfkd: "\u{1104}\u{116C}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B66C}",
        nfc: "\u{B66C}",
        nfd: "\u{1104}\u{116C}\u{11AF}",
        nfkc: "\u{B66C}",
        nfkd: "\u{1104}\u{116C}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B66D}",
        nfc: "\u{B66D}",
        nfd: "\u{1104}\u{116C}\u{11B0}",
        nfkc: "\u{B66D}",
        nfkd: "\u{1104}\u{116C}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B66E}",
        nfc: "\u{B66E}",
        nfd: "\u{1104}\u{116C}\u{11B1}",
        nfkc: "\u{B66E}",
        nfkd: "\u{1104}\u{116C}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B66F}",
        nfc: "\u{B66F}",
        nfd: "\u{1104}\u{116C}\u{11B2}",
        nfkc: "\u{B66F}",
        nfkd: "\u{1104}\u{116C}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B670}",
        nfc: "\u{B670}",
        nfd: "\u{1104}\u{116C}\u{11B3}",
        nfkc: "\u{B670}",
        nfkd: "\u{1104}\u{116C}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B671}",
        nfc: "\u{B671}",
        nfd: "\u{1104}\u{116C}\u{11B4}",
        nfkc: "\u{B671}",
        nfkd: "\u{1104}\u{116C}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B672}",
        nfc: "\u{B672}",
        nfd: "\u{1104}\u{116C}\u{11B5}",
        nfkc: "\u{B672}",
        nfkd: "\u{1104}\u{116C}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B673}",
        nfc: "\u{B673}",
        nfd: "\u{1104}\u{116C}\u{11B6}",
        nfkc: "\u{B673}",
        nfkd: "\u{1104}\u{116C}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B674}",
        nfc: "\u{B674}",
        nfd: "\u{1104}\u{116C}\u{11B7}",
        nfkc: "\u{B674}",
        nfkd: "\u{1104}\u{116C}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B675}",
        nfc: "\u{B675}",
        nfd: "\u{1104}\u{116C}\u{11B8}",
        nfkc: "\u{B675}",
        nfkd: "\u{1104}\u{116C}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B676}",
        nfc: "\u{B676}",
        nfd: "\u{1104}\u{116C}\u{11B9}",
        nfkc: "\u{B676}",
        nfkd: "\u{1104}\u{116C}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B677}",
        nfc: "\u{B677}",
        nfd: "\u{1104}\u{116C}\u{11BA}",
        nfkc: "\u{B677}",
        nfkd: "\u{1104}\u{116C}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B678}",
        nfc: "\u{B678}",
        nfd: "\u{1104}\u{116C}\u{11BB}",
        nfkc: "\u{B678}",
        nfkd: "\u{1104}\u{116C}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B679}",
        nfc: "\u{B679}",
        nfd: "\u{1104}\u{116C}\u{11BC}",
        nfkc: "\u{B679}",
        nfkd: "\u{1104}\u{116C}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B67A}",
        nfc: "\u{B67A}",
        nfd: "\u{1104}\u{116C}\u{11BD}",
        nfkc: "\u{B67A}",
        nfkd: "\u{1104}\u{116C}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B67B}",
        nfc: "\u{B67B}",
        nfd: "\u{1104}\u{116C}\u{11BE}",
        nfkc: "\u{B67B}",
        nfkd: "\u{1104}\u{116C}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B67C}",
        nfc: "\u{B67C}",
        nfd: "\u{1104}\u{116C}\u{11BF}",
        nfkc: "\u{B67C}",
        nfkd: "\u{1104}\u{116C}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B67D}",
        nfc: "\u{B67D}",
        nfd: "\u{1104}\u{116C}\u{11C0}",
        nfkc: "\u{B67D}",
        nfkd: "\u{1104}\u{116C}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B67E}",
        nfc: "\u{B67E}",
        nfd: "\u{1104}\u{116C}\u{11C1}",
        nfkc: "\u{B67E}",
        nfkd: "\u{1104}\u{116C}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B67F}",
        nfc: "\u{B67F}",
        nfd: "\u{1104}\u{116C}\u{11C2}",
        nfkc: "\u{B67F}",
        nfkd: "\u{1104}\u{116C}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B680}",
        nfc: "\u{B680}",
        nfd: "\u{1104}\u{116D}",
        nfkc: "\u{B680}",
        nfkd: "\u{1104}\u{116D}",
    },
    NormalizationTest {
        source: "\u{B681}",
        nfc: "\u{B681}",
        nfd: "\u{1104}\u{116D}\u{11A8}",
        nfkc: "\u{B681}",
        nfkd: "\u{1104}\u{116D}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B682}",
        nfc: "\u{B682}",
        nfd: "\u{1104}\u{116D}\u{11A9}",
        nfkc: "\u{B682}",
        nfkd: "\u{1104}\u{116D}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B683}",
        nfc: "\u{B683}",
        nfd: "\u{1104}\u{116D}\u{11AA}",
        nfkc: "\u{B683}",
        nfkd: "\u{1104}\u{116D}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B684}",
        nfc: "\u{B684}",
        nfd: "\u{1104}\u{116D}\u{11AB}",
        nfkc: "\u{B684}",
        nfkd: "\u{1104}\u{116D}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B685}",
        nfc: "\u{B685}",
        nfd: "\u{1104}\u{116D}\u{11AC}",
        nfkc: "\u{B685}",
        nfkd: "\u{1104}\u{116D}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B686}",
        nfc: "\u{B686}",
        nfd: "\u{1104}\u{116D}\u{11AD}",
        nfkc: "\u{B686}",
        nfkd: "\u{1104}\u{116D}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B687}",
        nfc: "\u{B687}",
        nfd: "\u{1104}\u{116D}\u{11AE}",
        nfkc: "\u{B687}",
        nfkd: "\u{1104}\u{116D}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B688}",
        nfc: "\u{B688}",
        nfd: "\u{1104}\u{116D}\u{11AF}",
        nfkc: "\u{B688}",
        nfkd: "\u{1104}\u{116D}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B689}",
        nfc: "\u{B689}",
        nfd: "\u{1104}\u{116D}\u{11B0}",
        nfkc: "\u{B689}",
        nfkd: "\u{1104}\u{116D}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B68A}",
        nfc: "\u{B68A}",
        nfd: "\u{1104}\u{116D}\u{11B1}",
        nfkc: "\u{B68A}",
        nfkd: "\u{1104}\u{116D}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B68B}",
        nfc: "\u{B68B}",
        nfd: "\u{1104}\u{116D}\u{11B2}",
        nfkc: "\u{B68B}",
        nfkd: "\u{1104}\u{116D}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B68C}",
        nfc: "\u{B68C}",
        nfd: "\u{1104}\u{116D}\u{11B3}",
        nfkc: "\u{B68C}",
        nfkd: "\u{1104}\u{116D}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B68D}",
        nfc: "\u{B68D}",
        nfd: "\u{1104}\u{116D}\u{11B4}",
        nfkc: "\u{B68D}",
        nfkd: "\u{1104}\u{116D}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B68E}",
        nfc: "\u{B68E}",
        nfd: "\u{1104}\u{116D}\u{11B5}",
        nfkc: "\u{B68E}",
        nfkd: "\u{1104}\u{116D}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B68F}",
        nfc: "\u{B68F}",
        nfd: "\u{1104}\u{116D}\u{11B6}",
        nfkc: "\u{B68F}",
        nfkd: "\u{1104}\u{116D}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B690}",
        nfc: "\u{B690}",
        nfd: "\u{1104}\u{116D}\u{11B7}",
        nfkc: "\u{B690}",
        nfkd: "\u{1104}\u{116D}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B691}",
        nfc: "\u{B691}",
        nfd: "\u{1104}\u{116D}\u{11B8}",
        nfkc: "\u{B691}",
        nfkd: "\u{1104}\u{116D}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B692}",
        nfc: "\u{B692}",
        nfd: "\u{1104}\u{116D}\u{11B9}",
        nfkc: "\u{B692}",
        nfkd: "\u{1104}\u{116D}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B693}",
        nfc: "\u{B693}",
        nfd: "\u{1104}\u{116D}\u{11BA}",
        nfkc: "\u{B693}",
        nfkd: "\u{1104}\u{116D}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B694}",
        nfc: "\u{B694}",
        nfd: "\u{1104}\u{116D}\u{11BB}",
        nfkc: "\u{B694}",
        nfkd: "\u{1104}\u{116D}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B695}",
        nfc: "\u{B695}",
        nfd: "\u{1104}\u{116D}\u{11BC}",
        nfkc: "\u{B695}",
        nfkd: "\u{1104}\u{116D}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B696}",
        nfc: "\u{B696}",
        nfd: "\u{1104}\u{116D}\u{11BD}",
        nfkc: "\u{B696}",
        nfkd: "\u{1104}\u{116D}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B697}",
        nfc: "\u{B697}",
        nfd: "\u{1104}\u{116D}\u{11BE}",
        nfkc: "\u{B697}",
        nfkd: "\u{1104}\u{116D}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B698}",
        nfc: "\u{B698}",
        nfd: "\u{1104}\u{116D}\u{11BF}",
        nfkc: "\u{B698}",
        nfkd: "\u{1104}\u{116D}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B699}",
        nfc: "\u{B699}",
        nfd: "\u{1104}\u{116D}\u{11C0}",
        nfkc: "\u{B699}",
        nfkd: "\u{1104}\u{116D}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B69A}",
        nfc: "\u{B69A}",
        nfd: "\u{1104}\u{116D}\u{11C1}",
        nfkc: "\u{B69A}",
        nfkd: "\u{1104}\u{116D}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B69B}",
        nfc: "\u{B69B}",
        nfd: "\u{1104}\u{116D}\u{11C2}",
        nfkc: "\u{B69B}",
        nfkd: "\u{1104}\u{116D}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B69C}",
        nfc: "\u{B69C}",
        nfd: "\u{1104}\u{116E}",
        nfkc: "\u{B69C}",
        nfkd: "\u{1104}\u{116E}",
    },
    NormalizationTest {
        source: "\u{B69D}",
        nfc: "\u{B69D}",
        nfd: "\u{1104}\u{116E}\u{11A8}",
        nfkc: "\u{B69D}",
        nfkd: "\u{1104}\u{116E}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B69E}",
        nfc: "\u{B69E}",
        nfd: "\u{1104}\u{116E}\u{11A9}",
        nfkc: "\u{B69E}",
        nfkd: "\u{1104}\u{116E}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B69F}",
        nfc: "\u{B69F}",
        nfd: "\u{1104}\u{116E}\u{11AA}",
        nfkc: "\u{B69F}",
        nfkd: "\u{1104}\u{116E}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B6A0}",
        nfc: "\u{B6A0}",
        nfd: "\u{1104}\u{116E}\u{11AB}",
        nfkc: "\u{B6A0}",
        nfkd: "\u{1104}\u{116E}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B6A1}",
        nfc: "\u{B6A1}",
        nfd: "\u{1104}\u{116E}\u{11AC}",
        nfkc: "\u{B6A1}",
        nfkd: "\u{1104}\u{116E}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B6A2}",
        nfc: "\u{B6A2}",
        nfd: "\u{1104}\u{116E}\u{11AD}",
        nfkc: "\u{B6A2}",
        nfkd: "\u{1104}\u{116E}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B6A3}",
        nfc: "\u{B6A3}",
        nfd: "\u{1104}\u{116E}\u{11AE}",
        nfkc: "\u{B6A3}",
        nfkd: "\u{1104}\u{116E}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B6A4}",
        nfc: "\u{B6A4}",
        nfd: "\u{1104}\u{116E}\u{11AF}",
        nfkc: "\u{B6A4}",
        nfkd: "\u{1104}\u{116E}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B6A5}",
        nfc: "\u{B6A5}",
        nfd: "\u{1104}\u{116E}\u{11B0}",
        nfkc: "\u{B6A5}",
        nfkd: "\u{1104}\u{116E}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B6A6}",
        nfc: "\u{B6A6}",
        nfd: "\u{1104}\u{116E}\u{11B1}",
        nfkc: "\u{B6A6}",
        nfkd: "\u{1104}\u{116E}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B6A7}",
        nfc: "\u{B6A7}",
        nfd: "\u{1104}\u{116E}\u{11B2}",
        nfkc: "\u{B6A7}",
        nfkd: "\u{1104}\u{116E}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B6A8}",
        nfc: "\u{B6A8}",
        nfd: "\u{1104}\u{116E}\u{11B3}",
        nfkc: "\u{B6A8}",
        nfkd: "\u{1104}\u{116E}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B6A9}",
        nfc: "\u{B6A9}",
        nfd: "\u{1104}\u{116E}\u{11B4}",
        nfkc: "\u{B6A9}",
        nfkd: "\u{1104}\u{116E}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B6AA}",
        nfc: "\u{B6AA}",
        nfd: "\u{1104}\u{116E}\u{11B5}",
        nfkc: "\u{B6AA}",
        nfkd: "\u{1104}\u{116E}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B6AB}",
        nfc: "\u{B6AB}",
        nfd: "\u{1104}\u{116E}\u{11B6}",
        nfkc: "\u{B6AB}",
        nfkd: "\u{1104}\u{116E}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B6AC}",
        nfc: "\u{B6AC}",
        nfd: "\u{1104}\u{116E}\u{11B7}",
        nfkc: "\u{B6AC}",
        nfkd: "\u{1104}\u{116E}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B6AD}",
        nfc: "\u{B6AD}",
        nfd: "\u{1104}\u{116E}\u{11B8}",
        nfkc: "\u{B6AD}",
        nfkd: "\u{1104}\u{116E}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B6AE}",
        nfc: "\u{B6AE}",
        nfd: "\u{1104}\u{116E}\u{11B9}",
        nfkc: "\u{B6AE}",
        nfkd: "\u{1104}\u{116E}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B6AF}",
        nfc: "\u{B6AF}",
        nfd: "\u{1104}\u{116E}\u{11BA}",
        nfkc: "\u{B6AF}",
        nfkd: "\u{1104}\u{116E}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B6B0}",
        nfc: "\u{B6B0}",
        nfd: "\u{1104}\u{116E}\u{11BB}",
        nfkc: "\u{B6B0}",
        nfkd: "\u{1104}\u{116E}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B6B1}",
        nfc: "\u{B6B1}",
        nfd: "\u{1104}\u{116E}\u{11BC}",
        nfkc: "\u{B6B1}",
        nfkd: "\u{1104}\u{116E}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B6B2}",
        nfc: "\u{B6B2}",
        nfd: "\u{1104}\u{116E}\u{11BD}",
        nfkc: "\u{B6B2}",
        nfkd: "\u{1104}\u{116E}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B6B3}",
        nfc: "\u{B6B3}",
        nfd: "\u{1104}\u{116E}\u{11BE}",
        nfkc: "\u{B6B3}",
        nfkd: "\u{1104}\u{116E}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B6B4}",
        nfc: "\u{B6B4}",
        nfd: "\u{1104}\u{116E}\u{11BF}",
        nfkc: "\u{B6B4}",
        nfkd: "\u{1104}\u{116E}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B6B5}",
        nfc: "\u{B6B5}",
        nfd: "\u{1104}\u{116E}\u{11C0}",
        nfkc: "\u{B6B5}",
        nfkd: "\u{1104}\u{116E}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B6B6}",
        nfc: "\u{B6B6}",
        nfd: "\u{1104}\u{116E}\u{11C1}",
        nfkc: "\u{B6B6}",
        nfkd: "\u{1104}\u{116E}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B6B7}",
        nfc: "\u{B6B7}",
        nfd: "\u{1104}\u{116E}\u{11C2}",
        nfkc: "\u{B6B7}",
        nfkd: "\u{1104}\u{116E}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B6B8}",
        nfc: "\u{B6B8}",
        nfd: "\u{1104}\u{116F}",
        nfkc: "\u{B6B8}",
        nfkd: "\u{1104}\u{116F}",
    },
    NormalizationTest {
        source: "\u{B6B9}",
        nfc: "\u{B6B9}",
        nfd: "\u{1104}\u{116F}\u{11A8}",
        nfkc: "\u{B6B9}",
        nfkd: "\u{1104}\u{116F}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B6BA}",
        nfc: "\u{B6BA}",
        nfd: "\u{1104}\u{116F}\u{11A9}",
        nfkc: "\u{B6BA}",
        nfkd: "\u{1104}\u{116F}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B6BB}",
        nfc: "\u{B6BB}",
        nfd: "\u{1104}\u{116F}\u{11AA}",
        nfkc: "\u{B6BB}",
        nfkd: "\u{1104}\u{116F}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B6BC}",
        nfc: "\u{B6BC}",
        nfd: "\u{1104}\u{116F}\u{11AB}",
        nfkc: "\u{B6BC}",
        nfkd: "\u{1104}\u{116F}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B6BD}",
        nfc: "\u{B6BD}",
        nfd: "\u{1104}\u{116F}\u{11AC}",
        nfkc: "\u{B6BD}",
        nfkd: "\u{1104}\u{116F}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B6BE}",
        nfc: "\u{B6BE}",
        nfd: "\u{1104}\u{116F}\u{11AD}",
        nfkc: "\u{B6BE}",
        nfkd: "\u{1104}\u{116F}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B6BF}",
        nfc: "\u{B6BF}",
        nfd: "\u{1104}\u{116F}\u{11AE}",
        nfkc: "\u{B6BF}",
        nfkd: "\u{1104}\u{116F}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B6C0}",
        nfc: "\u{B6C0}",
        nfd: "\u{1104}\u{116F}\u{11AF}",
        nfkc: "\u{B6C0}",
        nfkd: "\u{1104}\u{116F}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B6C1}",
        nfc: "\u{B6C1}",
        nfd: "\u{1104}\u{116F}\u{11B0}",
        nfkc: "\u{B6C1}",
        nfkd: "\u{1104}\u{116F}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B6C2}",
        nfc: "\u{B6C2}",
        nfd: "\u{1104}\u{116F}\u{11B1}",
        nfkc: "\u{B6C2}",
        nfkd: "\u{1104}\u{116F}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B6C3}",
        nfc: "\u{B6C3}",
        nfd: "\u{1104}\u{116F}\u{11B2}",
        nfkc: "\u{B6C3}",
        nfkd: "\u{1104}\u{116F}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B6C4}",
        nfc: "\u{B6C4}",
        nfd: "\u{1104}\u{116F}\u{11B3}",
        nfkc: "\u{B6C4}",
        nfkd: "\u{1104}\u{116F}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B6C5}",
        nfc: "\u{B6C5}",
        nfd: "\u{1104}\u{116F}\u{11B4}",
        nfkc: "\u{B6C5}",
        nfkd: "\u{1104}\u{116F}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B6C6}",
        nfc: "\u{B6C6}",
        nfd: "\u{1104}\u{116F}\u{11B5}",
        nfkc: "\u{B6C6}",
        nfkd: "\u{1104}\u{116F}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B6C7}",
        nfc: "\u{B6C7}",
        nfd: "\u{1104}\u{116F}\u{11B6}",
        nfkc: "\u{B6C7}",
        nfkd: "\u{1104}\u{116F}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B6C8}",
        nfc: "\u{B6C8}",
        nfd: "\u{1104}\u{116F}\u{11B7}",
        nfkc: "\u{B6C8}",
        nfkd: "\u{1104}\u{116F}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B6C9}",
        nfc: "\u{B6C9}",
        nfd: "\u{1104}\u{116F}\u{11B8}",
        nfkc: "\u{B6C9}",
        nfkd: "\u{1104}\u{116F}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B6CA}",
        nfc: "\u{B6CA}",
        nfd: "\u{1104}\u{116F}\u{11B9}",
        nfkc: "\u{B6CA}",
        nfkd: "\u{1104}\u{116F}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B6CB}",
        nfc: "\u{B6CB}",
        nfd: "\u{1104}\u{116F}\u{11BA}",
        nfkc: "\u{B6CB}",
        nfkd: "\u{1104}\u{116F}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B6CC}",
        nfc: "\u{B6CC}",
        nfd: "\u{1104}\u{116F}\u{11BB}",
        nfkc: "\u{B6CC}",
        nfkd: "\u{1104}\u{116F}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B6CD}",
        nfc: "\u{B6CD}",
        nfd: "\u{1104}\u{116F}\u{11BC}",
        nfkc: "\u{B6CD}",
        nfkd: "\u{1104}\u{116F}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B6CE}",
        nfc: "\u{B6CE}",
        nfd: "\u{1104}\u{116F}\u{11BD}",
        nfkc: "\u{B6CE}",
        nfkd: "\u{1104}\u{116F}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B6CF}",
        nfc: "\u{B6CF}",
        nfd: "\u{1104}\u{116F}\u{11BE}",
        nfkc: "\u{B6CF}",
        nfkd: "\u{1104}\u{116F}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B6D0}",
        nfc: "\u{B6D0}",
        nfd: "\u{1104}\u{116F}\u{11BF}",
        nfkc: "\u{B6D0}",
        nfkd: "\u{1104}\u{116F}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B6D1}",
        nfc: "\u{B6D1}",
        nfd: "\u{1104}\u{116F}\u{11C0}",
        nfkc: "\u{B6D1}",
        nfkd: "\u{1104}\u{116F}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B6D2}",
        nfc: "\u{B6D2}",
        nfd: "\u{1104}\u{116F}\u{11C1}",
        nfkc: "\u{B6D2}",
        nfkd: "\u{1104}\u{116F}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B6D3}",
        nfc: "\u{B6D3}",
        nfd: "\u{1104}\u{116F}\u{11C2}",
        nfkc: "\u{B6D3}",
        nfkd: "\u{1104}\u{116F}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B6D4}",
        nfc: "\u{B6D4}",
        nfd: "\u{1104}\u{1170}",
        nfkc: "\u{B6D4}",
        nfkd: "\u{1104}\u{1170}",
    },
    NormalizationTest {
        source: "\u{B6D5}",
        nfc: "\u{B6D5}",
        nfd: "\u{1104}\u{1170}\u{11A8}",
        nfkc: "\u{B6D5}",
        nfkd: "\u{1104}\u{1170}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B6D6}",
        nfc: "\u{B6D6}",
        nfd: "\u{1104}\u{1170}\u{11A9}",
        nfkc: "\u{B6D6}",
        nfkd: "\u{1104}\u{1170}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B6D7}",
        nfc: "\u{B6D7}",
        nfd: "\u{1104}\u{1170}\u{11AA}",
        nfkc: "\u{B6D7}",
        nfkd: "\u{1104}\u{1170}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B6D8}",
        nfc: "\u{B6D8}",
        nfd: "\u{1104}\u{1170}\u{11AB}",
        nfkc: "\u{B6D8}",
        nfkd: "\u{1104}\u{1170}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B6D9}",
        nfc: "\u{B6D9}",
        nfd: "\u{1104}\u{1170}\u{11AC}",
        nfkc: "\u{B6D9}",
        nfkd: "\u{1104}\u{1170}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B6DA}",
        nfc: "\u{B6DA}",
        nfd: "\u{1104}\u{1170}\u{11AD}",
        nfkc: "\u{B6DA}",
        nfkd: "\u{1104}\u{1170}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B6DB}",
        nfc: "\u{B6DB}",
        nfd: "\u{1104}\u{1170}\u{11AE}",
        nfkc: "\u{B6DB}",
        nfkd: "\u{1104}\u{1170}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B6DC}",
        nfc: "\u{B6DC}",
        nfd: "\u{1104}\u{1170}\u{11AF}",
        nfkc: "\u{B6DC}",
        nfkd: "\u{1104}\u{1170}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B6DD}",
        nfc: "\u{B6DD}",
        nfd: "\u{1104}\u{1170}\u{11B0}",
        nfkc: "\u{B6DD}",
        nfkd: "\u{1104}\u{1170}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B6DE}",
        nfc: "\u{B6DE}",
        nfd: "\u{1104}\u{1170}\u{11B1}",
        nfkc: "\u{B6DE}",
        nfkd: "\u{1104}\u{1170}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B6DF}",
        nfc: "\u{B6DF}",
        nfd: "\u{1104}\u{1170}\u{11B2}",
        nfkc: "\u{B6DF}",
        nfkd: "\u{1104}\u{1170}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B6E0}",
        nfc: "\u{B6E0}",
        nfd: "\u{1104}\u{1170}\u{11B3}",
        nfkc: "\u{B6E0}",
        nfkd: "\u{1104}\u{1170}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B6E1}",
        nfc: "\u{B6E1}",
        nfd: "\u{1104}\u{1170}\u{11B4}",
        nfkc: "\u{B6E1}",
        nfkd: "\u{1104}\u{1170}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B6E2}",
        nfc: "\u{B6E2}",
        nfd: "\u{1104}\u{1170}\u{11B5}",
        nfkc: "\u{B6E2}",
        nfkd: "\u{1104}\u{1170}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B6E3}",
        nfc: "\u{B6E3}",
        nfd: "\u{1104}\u{1170}\u{11B6}",
        nfkc: "\u{B6E3}",
        nfkd: "\u{1104}\u{1170}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B6E4}",
        nfc: "\u{B6E4}",
        nfd: "\u{1104}\u{1170}\u{11B7}",
        nfkc: "\u{B6E4}",
        nfkd: "\u{1104}\u{1170}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B6E5}",
        nfc: "\u{B6E5}",
        nfd: "\u{1104}\u{1170}\u{11B8}",
        nfkc: "\u{B6E5}",
        nfkd: "\u{1104}\u{1170}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B6E6}",
        nfc: "\u{B6E6}",
        nfd: "\u{1104}\u{1170}\u{11B9}",
        nfkc: "\u{B6E6}",
        nfkd: "\u{1104}\u{1170}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B6E7}",
        nfc: "\u{B6E7}",
        nfd: "\u{1104}\u{1170}\u{11BA}",
        nfkc: "\u{B6E7}",
        nfkd: "\u{1104}\u{1170}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B6E8}",
        nfc: "\u{B6E8}",
        nfd: "\u{1104}\u{1170}\u{11BB}",
        nfkc: "\u{B6E8}",
        nfkd: "\u{1104}\u{1170}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B6E9}",
        nfc: "\u{B6E9}",
        nfd: "\u{1104}\u{1170}\u{11BC}",
        nfkc: "\u{B6E9}",
        nfkd: "\u{1104}\u{1170}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B6EA}",
        nfc: "\u{B6EA}",
        nfd: "\u{1104}\u{1170}\u{11BD}",
        nfkc: "\u{B6EA}",
        nfkd: "\u{1104}\u{1170}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B6EB}",
        nfc: "\u{B6EB}",
        nfd: "\u{1104}\u{1170}\u{11BE}",
        nfkc: "\u{B6EB}",
        nfkd: "\u{1104}\u{1170}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B6EC}",
        nfc: "\u{B6EC}",
        nfd: "\u{1104}\u{1170}\u{11BF}",
        nfkc: "\u{B6EC}",
        nfkd: "\u{1104}\u{1170}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B6ED}",
        nfc: "\u{B6ED}",
        nfd: "\u{1104}\u{1170}\u{11C0}",
        nfkc: "\u{B6ED}",
        nfkd: "\u{1104}\u{1170}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B6EE}",
        nfc: "\u{B6EE}",
        nfd: "\u{1104}\u{1170}\u{11C1}",
        nfkc: "\u{B6EE}",
        nfkd: "\u{1104}\u{1170}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B6EF}",
        nfc: "\u{B6EF}",
        nfd: "\u{1104}\u{1170}\u{11C2}",
        nfkc: "\u{B6EF}",
        nfkd: "\u{1104}\u{1170}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B6F0}",
        nfc: "\u{B6F0}",
        nfd: "\u{1104}\u{1171}",
        nfkc: "\u{B6F0}",
        nfkd: "\u{1104}\u{1171}",
    },
    NormalizationTest {
        source: "\u{B6F1}",
        nfc: "\u{B6F1}",
        nfd: "\u{1104}\u{1171}\u{11A8}",
        nfkc: "\u{B6F1}",
        nfkd: "\u{1104}\u{1171}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B6F2}",
        nfc: "\u{B6F2}",
        nfd: "\u{1104}\u{1171}\u{11A9}",
        nfkc: "\u{B6F2}",
        nfkd: "\u{1104}\u{1171}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B6F3}",
        nfc: "\u{B6F3}",
        nfd: "\u{1104}\u{1171}\u{11AA}",
        nfkc: "\u{B6F3}",
        nfkd: "\u{1104}\u{1171}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B6F4}",
        nfc: "\u{B6F4}",
        nfd: "\u{1104}\u{1171}\u{11AB}",
        nfkc: "\u{B6F4}",
        nfkd: "\u{1104}\u{1171}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B6F5}",
        nfc: "\u{B6F5}",
        nfd: "\u{1104}\u{1171}\u{11AC}",
        nfkc: "\u{B6F5}",
        nfkd: "\u{1104}\u{1171}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B6F6}",
        nfc: "\u{B6F6}",
        nfd: "\u{1104}\u{1171}\u{11AD}",
        nfkc: "\u{B6F6}",
        nfkd: "\u{1104}\u{1171}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B6F7}",
        nfc: "\u{B6F7}",
        nfd: "\u{1104}\u{1171}\u{11AE}",
        nfkc: "\u{B6F7}",
        nfkd: "\u{1104}\u{1171}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B6F8}",
        nfc: "\u{B6F8}",
        nfd: "\u{1104}\u{1171}\u{11AF}",
        nfkc: "\u{B6F8}",
        nfkd: "\u{1104}\u{1171}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B6F9}",
        nfc: "\u{B6F9}",
        nfd: "\u{1104}\u{1171}\u{11B0}",
        nfkc: "\u{B6F9}",
        nfkd: "\u{1104}\u{1171}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B6FA}",
        nfc: "\u{B6FA}",
        nfd: "\u{1104}\u{1171}\u{11B1}",
        nfkc: "\u{B6FA}",
        nfkd: "\u{1104}\u{1171}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B6FB}",
        nfc: "\u{B6FB}",
        nfd: "\u{1104}\u{1171}\u{11B2}",
        nfkc: "\u{B6FB}",
        nfkd: "\u{1104}\u{1171}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B6FC}",
        nfc: "\u{B6FC}",
        nfd: "\u{1104}\u{1171}\u{11B3}",
        nfkc: "\u{B6FC}",
        nfkd: "\u{1104}\u{1171}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B6FD}",
        nfc: "\u{B6FD}",
        nfd: "\u{1104}\u{1171}\u{11B4}",
        nfkc: "\u{B6FD}",
        nfkd: "\u{1104}\u{1171}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B6FE}",
        nfc: "\u{B6FE}",
        nfd: "\u{1104}\u{1171}\u{11B5}",
        nfkc: "\u{B6FE}",
        nfkd: "\u{1104}\u{1171}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B6FF}",
        nfc: "\u{B6FF}",
        nfd: "\u{1104}\u{1171}\u{11B6}",
        nfkc: "\u{B6FF}",
        nfkd: "\u{1104}\u{1171}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B700}",
        nfc: "\u{B700}",
        nfd: "\u{1104}\u{1171}\u{11B7}",
        nfkc: "\u{B700}",
        nfkd: "\u{1104}\u{1171}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B701}",
        nfc: "\u{B701}",
        nfd: "\u{1104}\u{1171}\u{11B8}",
        nfkc: "\u{B701}",
        nfkd: "\u{1104}\u{1171}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B702}",
        nfc: "\u{B702}",
        nfd: "\u{1104}\u{1171}\u{11B9}",
        nfkc: "\u{B702}",
        nfkd: "\u{1104}\u{1171}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B703}",
        nfc: "\u{B703}",
        nfd: "\u{1104}\u{1171}\u{11BA}",
        nfkc: "\u{B703}",
        nfkd: "\u{1104}\u{1171}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B704}",
        nfc: "\u{B704}",
        nfd: "\u{1104}\u{1171}\u{11BB}",
        nfkc: "\u{B704}",
        nfkd: "\u{1104}\u{1171}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B705}",
        nfc: "\u{B705}",
        nfd: "\u{1104}\u{1171}\u{11BC}",
        nfkc: "\u{B705}",
        nfkd: "\u{1104}\u{1171}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B706}",
        nfc: "\u{B706}",
        nfd: "\u{1104}\u{1171}\u{11BD}",
        nfkc: "\u{B706}",
        nfkd: "\u{1104}\u{1171}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B707}",
        nfc: "\u{B707}",
        nfd: "\u{1104}\u{1171}\u{11BE}",
        nfkc: "\u{B707}",
        nfkd: "\u{1104}\u{1171}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B708}",
        nfc: "\u{B708}",
        nfd: "\u{1104}\u{1171}\u{11BF}",
        nfkc: "\u{B708}",
        nfkd: "\u{1104}\u{1171}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B709}",
        nfc: "\u{B709}",
        nfd: "\u{1104}\u{1171}\u{11C0}",
        nfkc: "\u{B709}",
        nfkd: "\u{1104}\u{1171}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B70A}",
        nfc: "\u{B70A}",
        nfd: "\u{1104}\u{1171}\u{11C1}",
        nfkc: "\u{B70A}",
        nfkd: "\u{1104}\u{1171}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B70B}",
        nfc: "\u{B70B}",
        nfd: "\u{1104}\u{1171}\u{11C2}",
        nfkc: "\u{B70B}",
        nfkd: "\u{1104}\u{1171}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B70C}",
        nfc: "\u{B70C}",
        nfd: "\u{1104}\u{1172}",
        nfkc: "\u{B70C}",
        nfkd: "\u{1104}\u{1172}",
    },
    NormalizationTest {
        source: "\u{B70D}",
        nfc: "\u{B70D}",
        nfd: "\u{1104}\u{1172}\u{11A8}",
        nfkc: "\u{B70D}",
        nfkd: "\u{1104}\u{1172}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B70E}",
        nfc: "\u{B70E}",
        nfd: "\u{1104}\u{1172}\u{11A9}",
        nfkc: "\u{B70E}",
        nfkd: "\u{1104}\u{1172}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B70F}",
        nfc: "\u{B70F}",
        nfd: "\u{1104}\u{1172}\u{11AA}",
        nfkc: "\u{B70F}",
        nfkd: "\u{1104}\u{1172}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B710}",
        nfc: "\u{B710}",
        nfd: "\u{1104}\u{1172}\u{11AB}",
        nfkc: "\u{B710}",
        nfkd: "\u{1104}\u{1172}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B711}",
        nfc: "\u{B711}",
        nfd: "\u{1104}\u{1172}\u{11AC}",
        nfkc: "\u{B711}",
        nfkd: "\u{1104}\u{1172}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B712}",
        nfc: "\u{B712}",
        nfd: "\u{1104}\u{1172}\u{11AD}",
        nfkc: "\u{B712}",
        nfkd: "\u{1104}\u{1172}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B713}",
        nfc: "\u{B713}",
        nfd: "\u{1104}\u{1172}\u{11AE}",
        nfkc: "\u{B713}",
        nfkd: "\u{1104}\u{1172}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B714}",
        nfc: "\u{B714}",
        nfd: "\u{1104}\u{1172}\u{11AF}",
        nfkc: "\u{B714}",
        nfkd: "\u{1104}\u{1172}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B715}",
        nfc: "\u{B715}",
        nfd: "\u{1104}\u{1172}\u{11B0}",
        nfkc: "\u{B715}",
        nfkd: "\u{1104}\u{1172}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B716}",
        nfc: "\u{B716}",
        nfd: "\u{1104}\u{1172}\u{11B1}",
        nfkc: "\u{B716}",
        nfkd: "\u{1104}\u{1172}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B717}",
        nfc: "\u{B717}",
        nfd: "\u{1104}\u{1172}\u{11B2}",
        nfkc: "\u{B717}",
        nfkd: "\u{1104}\u{1172}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B718}",
        nfc: "\u{B718}",
        nfd: "\u{1104}\u{1172}\u{11B3}",
        nfkc: "\u{B718}",
        nfkd: "\u{1104}\u{1172}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B719}",
        nfc: "\u{B719}",
        nfd: "\u{1104}\u{1172}\u{11B4}",
        nfkc: "\u{B719}",
        nfkd: "\u{1104}\u{1172}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B71A}",
        nfc: "\u{B71A}",
        nfd: "\u{1104}\u{1172}\u{11B5}",
        nfkc: "\u{B71A}",
        nfkd: "\u{1104}\u{1172}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B71B}",
        nfc: "\u{B71B}",
        nfd: "\u{1104}\u{1172}\u{11B6}",
        nfkc: "\u{B71B}",
        nfkd: "\u{1104}\u{1172}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B71C}",
        nfc: "\u{B71C}",
        nfd: "\u{1104}\u{1172}\u{11B7}",
        nfkc: "\u{B71C}",
        nfkd: "\u{1104}\u{1172}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B71D}",
        nfc: "\u{B71D}",
        nfd: "\u{1104}\u{1172}\u{11B8}",
        nfkc: "\u{B71D}",
        nfkd: "\u{1104}\u{1172}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B71E}",
        nfc: "\u{B71E}",
        nfd: "\u{1104}\u{1172}\u{11B9}",
        nfkc: "\u{B71E}",
        nfkd: "\u{1104}\u{1172}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B71F}",
        nfc: "\u{B71F}",
        nfd: "\u{1104}\u{1172}\u{11BA}",
        nfkc: "\u{B71F}",
        nfkd: "\u{1104}\u{1172}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B720}",
        nfc: "\u{B720}",
        nfd: "\u{1104}\u{1172}\u{11BB}",
        nfkc: "\u{B720}",
        nfkd: "\u{1104}\u{1172}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B721}",
        nfc: "\u{B721}",
        nfd: "\u{1104}\u{1172}\u{11BC}",
        nfkc: "\u{B721}",
        nfkd: "\u{1104}\u{1172}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B722}",
        nfc: "\u{B722}",
        nfd: "\u{1104}\u{1172}\u{11BD}",
        nfkc: "\u{B722}",
        nfkd: "\u{1104}\u{1172}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B723}",
        nfc: "\u{B723}",
        nfd: "\u{1104}\u{1172}\u{11BE}",
        nfkc: "\u{B723}",
        nfkd: "\u{1104}\u{1172}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B724}",
        nfc: "\u{B724}",
        nfd: "\u{1104}\u{1172}\u{11BF}",
        nfkc: "\u{B724}",
        nfkd: "\u{1104}\u{1172}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B725}",
        nfc: "\u{B725}",
        nfd: "\u{1104}\u{1172}\u{11C0}",
        nfkc: "\u{B725}",
        nfkd: "\u{1104}\u{1172}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B726}",
        nfc: "\u{B726}",
        nfd: "\u{1104}\u{1172}\u{11C1}",
        nfkc: "\u{B726}",
        nfkd: "\u{1104}\u{1172}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B727}",
        nfc: "\u{B727}",
        nfd: "\u{1104}\u{1172}\u{11C2}",
        nfkc: "\u{B727}",
        nfkd: "\u{1104}\u{1172}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B728}",
        nfc: "\u{B728}",
        nfd: "\u{1104}\u{1173}",
        nfkc: "\u{B728}",
        nfkd: "\u{1104}\u{1173}",
    },
    NormalizationTest {
        source: "\u{B729}",
        nfc: "\u{B729}",
        nfd: "\u{1104}\u{1173}\u{11A8}",
        nfkc: "\u{B729}",
        nfkd: "\u{1104}\u{1173}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B72A}",
        nfc: "\u{B72A}",
        nfd: "\u{1104}\u{1173}\u{11A9}",
        nfkc: "\u{B72A}",
        nfkd: "\u{1104}\u{1173}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B72B}",
        nfc: "\u{B72B}",
        nfd: "\u{1104}\u{1173}\u{11AA}",
        nfkc: "\u{B72B}",
        nfkd: "\u{1104}\u{1173}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B72C}",
        nfc: "\u{B72C}",
        nfd: "\u{1104}\u{1173}\u{11AB}",
        nfkc: "\u{B72C}",
        nfkd: "\u{1104}\u{1173}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B72D}",
        nfc: "\u{B72D}",
        nfd: "\u{1104}\u{1173}\u{11AC}",
        nfkc: "\u{B72D}",
        nfkd: "\u{1104}\u{1173}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B72E}",
        nfc: "\u{B72E}",
        nfd: "\u{1104}\u{1173}\u{11AD}",
        nfkc: "\u{B72E}",
        nfkd: "\u{1104}\u{1173}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B72F}",
        nfc: "\u{B72F}",
        nfd: "\u{1104}\u{1173}\u{11AE}",
        nfkc: "\u{B72F}",
        nfkd: "\u{1104}\u{1173}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B730}",
        nfc: "\u{B730}",
        nfd: "\u{1104}\u{1173}\u{11AF}",
        nfkc: "\u{B730}",
        nfkd: "\u{1104}\u{1173}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B731}",
        nfc: "\u{B731}",
        nfd: "\u{1104}\u{1173}\u{11B0}",
        nfkc: "\u{B731}",
        nfkd: "\u{1104}\u{1173}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B732}",
        nfc: "\u{B732}",
        nfd: "\u{1104}\u{1173}\u{11B1}",
        nfkc: "\u{B732}",
        nfkd: "\u{1104}\u{1173}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B733}",
        nfc: "\u{B733}",
        nfd: "\u{1104}\u{1173}\u{11B2}",
        nfkc: "\u{B733}",
        nfkd: "\u{1104}\u{1173}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B734}",
        nfc: "\u{B734}",
        nfd: "\u{1104}\u{1173}\u{11B3}",
        nfkc: "\u{B734}",
        nfkd: "\u{1104}\u{1173}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B735}",
        nfc: "\u{B735}",
        nfd: "\u{1104}\u{1173}\u{11B4}",
        nfkc: "\u{B735}",
        nfkd: "\u{1104}\u{1173}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B736}",
        nfc: "\u{B736}",
        nfd: "\u{1104}\u{1173}\u{11B5}",
        nfkc: "\u{B736}",
        nfkd: "\u{1104}\u{1173}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B737}",
        nfc: "\u{B737}",
        nfd: "\u{1104}\u{1173}\u{11B6}",
        nfkc: "\u{B737}",
        nfkd: "\u{1104}\u{1173}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B738}",
        nfc: "\u{B738}",
        nfd: "\u{1104}\u{1173}\u{11B7}",
        nfkc: "\u{B738}",
        nfkd: "\u{1104}\u{1173}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B739}",
        nfc: "\u{B739}",
        nfd: "\u{1104}\u{1173}\u{11B8}",
        nfkc: "\u{B739}",
        nfkd: "\u{1104}\u{1173}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B73A}",
        nfc: "\u{B73A}",
        nfd: "\u{1104}\u{1173}\u{11B9}",
        nfkc: "\u{B73A}",
        nfkd: "\u{1104}\u{1173}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B73B}",
        nfc: "\u{B73B}",
        nfd: "\u{1104}\u{1173}\u{11BA}",
        nfkc: "\u{B73B}",
        nfkd: "\u{1104}\u{1173}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B73C}",
        nfc: "\u{B73C}",
        nfd: "\u{1104}\u{1173}\u{11BB}",
        nfkc: "\u{B73C}",
        nfkd: "\u{1104}\u{1173}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B73D}",
        nfc: "\u{B73D}",
        nfd: "\u{1104}\u{1173}\u{11BC}",
        nfkc: "\u{B73D}",
        nfkd: "\u{1104}\u{1173}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B73E}",
        nfc: "\u{B73E}",
        nfd: "\u{1104}\u{1173}\u{11BD}",
        nfkc: "\u{B73E}",
        nfkd: "\u{1104}\u{1173}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B73F}",
        nfc: "\u{B73F}",
        nfd: "\u{1104}\u{1173}\u{11BE}",
        nfkc: "\u{B73F}",
        nfkd: "\u{1104}\u{1173}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B740}",
        nfc: "\u{B740}",
        nfd: "\u{1104}\u{1173}\u{11BF}",
        nfkc: "\u{B740}",
        nfkd: "\u{1104}\u{1173}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B741}",
        nfc: "\u{B741}",
        nfd: "\u{1104}\u{1173}\u{11C0}",
        nfkc: "\u{B741}",
        nfkd: "\u{1104}\u{1173}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B742}",
        nfc: "\u{B742}",
        nfd: "\u{1104}\u{1173}\u{11C1}",
        nfkc: "\u{B742}",
        nfkd: "\u{1104}\u{1173}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B743}",
        nfc: "\u{B743}",
        nfd: "\u{1104}\u{1173}\u{11C2}",
        nfkc: "\u{B743}",
        nfkd: "\u{1104}\u{1173}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B744}",
        nfc: "\u{B744}",
        nfd: "\u{1104}\u{1174}",
        nfkc: "\u{B744}",
        nfkd: "\u{1104}\u{1174}",
    },
    NormalizationTest {
        source: "\u{B745}",
        nfc: "\u{B745}",
        nfd: "\u{1104}\u{1174}\u{11A8}",
        nfkc: "\u{B745}",
        nfkd: "\u{1104}\u{1174}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B746}",
        nfc: "\u{B746}",
        nfd: "\u{1104}\u{1174}\u{11A9}",
        nfkc: "\u{B746}",
        nfkd: "\u{1104}\u{1174}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B747}",
        nfc: "\u{B747}",
        nfd: "\u{1104}\u{1174}\u{11AA}",
        nfkc: "\u{B747}",
        nfkd: "\u{1104}\u{1174}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B748}",
        nfc: "\u{B748}",
        nfd: "\u{1104}\u{1174}\u{11AB}",
        nfkc: "\u{B748}",
        nfkd: "\u{1104}\u{1174}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B749}",
        nfc: "\u{B749}",
        nfd: "\u{1104}\u{1174}\u{11AC}",
        nfkc: "\u{B749}",
        nfkd: "\u{1104}\u{1174}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B74A}",
        nfc: "\u{B74A}",
        nfd: "\u{1104}\u{1174}\u{11AD}",
        nfkc: "\u{B74A}",
        nfkd: "\u{1104}\u{1174}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B74B}",
        nfc: "\u{B74B}",
        nfd: "\u{1104}\u{1174}\u{11AE}",
        nfkc: "\u{B74B}",
        nfkd: "\u{1104}\u{1174}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B74C}",
        nfc: "\u{B74C}",
        nfd: "\u{1104}\u{1174}\u{11AF}",
        nfkc: "\u{B74C}",
        nfkd: "\u{1104}\u{1174}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B74D}",
        nfc: "\u{B74D}",
        nfd: "\u{1104}\u{1174}\u{11B0}",
        nfkc: "\u{B74D}",
        nfkd: "\u{1104}\u{1174}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B74E}",
        nfc: "\u{B74E}",
        nfd: "\u{1104}\u{1174}\u{11B1}",
        nfkc: "\u{B74E}",
        nfkd: "\u{1104}\u{1174}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B74F}",
        nfc: "\u{B74F}",
        nfd: "\u{1104}\u{1174}\u{11B2}",
        nfkc: "\u{B74F}",
        nfkd: "\u{1104}\u{1174}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B750}",
        nfc: "\u{B750}",
        nfd: "\u{1104}\u{1174}\u{11B3}",
        nfkc: "\u{B750}",
        nfkd: "\u{1104}\u{1174}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B751}",
        nfc: "\u{B751}",
        nfd: "\u{1104}\u{1174}\u{11B4}",
        nfkc: "\u{B751}",
        nfkd: "\u{1104}\u{1174}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B752}",
        nfc: "\u{B752}",
        nfd: "\u{1104}\u{1174}\u{11B5}",
        nfkc: "\u{B752}",
        nfkd: "\u{1104}\u{1174}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B753}",
        nfc: "\u{B753}",
        nfd: "\u{1104}\u{1174}\u{11B6}",
        nfkc: "\u{B753}",
        nfkd: "\u{1104}\u{1174}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B754}",
        nfc: "\u{B754}",
        nfd: "\u{1104}\u{1174}\u{11B7}",
        nfkc: "\u{B754}",
        nfkd: "\u{1104}\u{1174}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B755}",
        nfc: "\u{B755}",
        nfd: "\u{1104}\u{1174}\u{11B8}",
        nfkc: "\u{B755}",
        nfkd: "\u{1104}\u{1174}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B756}",
        nfc: "\u{B756}",
        nfd: "\u{1104}\u{1174}\u{11B9}",
        nfkc: "\u{B756}",
        nfkd: "\u{1104}\u{1174}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B757}",
        nfc: "\u{B757}",
        nfd: "\u{1104}\u{1174}\u{11BA}",
        nfkc: "\u{B757}",
        nfkd: "\u{1104}\u{1174}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B758}",
        nfc: "\u{B758}",
        nfd: "\u{1104}\u{1174}\u{11BB}",
        nfkc: "\u{B758}",
        nfkd: "\u{1104}\u{1174}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B759}",
        nfc: "\u{B759}",
        nfd: "\u{1104}\u{1174}\u{11BC}",
        nfkc: "\u{B759}",
        nfkd: "\u{1104}\u{1174}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B75A}",
        nfc: "\u{B75A}",
        nfd: "\u{1104}\u{1174}\u{11BD}",
        nfkc: "\u{B75A}",
        nfkd: "\u{1104}\u{1174}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B75B}",
        nfc: "\u{B75B}",
        nfd: "\u{1104}\u{1174}\u{11BE}",
        nfkc: "\u{B75B}",
        nfkd: "\u{1104}\u{1174}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B75C}",
        nfc: "\u{B75C}",
        nfd: "\u{1104}\u{1174}\u{11BF}",
        nfkc: "\u{B75C}",
        nfkd: "\u{1104}\u{1174}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B75D}",
        nfc: "\u{B75D}",
        nfd: "\u{1104}\u{1174}\u{11C0}",
        nfkc: "\u{B75D}",
        nfkd: "\u{1104}\u{1174}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B75E}",
        nfc: "\u{B75E}",
        nfd: "\u{1104}\u{1174}\u{11C1}",
        nfkc: "\u{B75E}",
        nfkd: "\u{1104}\u{1174}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B75F}",
        nfc: "\u{B75F}",
        nfd: "\u{1104}\u{1174}\u{11C2}",
        nfkc: "\u{B75F}",
        nfkd: "\u{1104}\u{1174}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B760}",
        nfc: "\u{B760}",
        nfd: "\u{1104}\u{1175}",
        nfkc: "\u{B760}",
        nfkd: "\u{1104}\u{1175}",
    },
    NormalizationTest {
        source: "\u{B761}",
        nfc: "\u{B761}",
        nfd: "\u{1104}\u{1175}\u{11A8}",
        nfkc: "\u{B761}",
        nfkd: "\u{1104}\u{1175}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B762}",
        nfc: "\u{B762}",
        nfd: "\u{1104}\u{1175}\u{11A9}",
        nfkc: "\u{B762}",
        nfkd: "\u{1104}\u{1175}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B763}",
        nfc: "\u{B763}",
        nfd: "\u{1104}\u{1175}\u{11AA}",
        nfkc: "\u{B763}",
        nfkd: "\u{1104}\u{1175}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B764}",
        nfc: "\u{B764}",
        nfd: "\u{1104}\u{1175}\u{11AB}",
        nfkc: "\u{B764}",
        nfkd: "\u{1104}\u{1175}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B765}",
        nfc: "\u{B765}",
        nfd: "\u{1104}\u{1175}\u{11AC}",
        nfkc: "\u{B765}",
        nfkd: "\u{1104}\u{1175}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B766}",
        nfc: "\u{B766}",
        nfd: "\u{1104}\u{1175}\u{11AD}",
        nfkc: "\u{B766}",
        nfkd: "\u{1104}\u{1175}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B767}",
        nfc: "\u{B767}",
        nfd: "\u{1104}\u{1175}\u{11AE}",
        nfkc: "\u{B767}",
        nfkd: "\u{1104}\u{1175}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B768}",
        nfc: "\u{B768}",
        nfd: "\u{1104}\u{1175}\u{11AF}",
        nfkc: "\u{B768}",
        nfkd: "\u{1104}\u{1175}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B769}",
        nfc: "\u{B769}",
        nfd: "\u{1104}\u{1175}\u{11B0}",
        nfkc: "\u{B769}",
        nfkd: "\u{1104}\u{1175}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B76A}",
        nfc: "\u{B76A}",
        nfd: "\u{1104}\u{1175}\u{11B1}",
        nfkc: "\u{B76A}",
        nfkd: "\u{1104}\u{1175}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B76B}",
        nfc: "\u{B76B}",
        nfd: "\u{1104}\u{1175}\u{11B2}",
        nfkc: "\u{B76B}",
        nfkd: "\u{1104}\u{1175}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B76C}",
        nfc: "\u{B76C}",
        nfd: "\u{1104}\u{1175}\u{11B3}",
        nfkc: "\u{B76C}",
        nfkd: "\u{1104}\u{1175}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B76D}",
        nfc: "\u{B76D}",
        nfd: "\u{1104}\u{1175}\u{11B4}",
        nfkc: "\u{B76D}",
        nfkd: "\u{1104}\u{1175}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B76E}",
        nfc: "\u{B76E}",
        nfd: "\u{1104}\u{1175}\u{11B5}",
        nfkc: "\u{B76E}",
        nfkd: "\u{1104}\u{1175}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B76F}",
        nfc: "\u{B76F}",
        nfd: "\u{1104}\u{1175}\u{11B6}",
        nfkc: "\u{B76F}",
        nfkd: "\u{1104}\u{1175}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B770}",
        nfc: "\u{B770}",
        nfd: "\u{1104}\u{1175}\u{11B7}",
        nfkc: "\u{B770}",
        nfkd: "\u{1104}\u{1175}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B771}",
        nfc: "\u{B771}",
        nfd: "\u{1104}\u{1175}\u{11B8}",
        nfkc: "\u{B771}",
        nfkd: "\u{1104}\u{1175}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B772}",
        nfc: "\u{B772}",
        nfd: "\u{1104}\u{1175}\u{11B9}",
        nfkc: "\u{B772}",
        nfkd: "\u{1104}\u{1175}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B773}",
        nfc: "\u{B773}",
        nfd: "\u{1104}\u{1175}\u{11BA}",
        nfkc: "\u{B773}",
        nfkd: "\u{1104}\u{1175}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B774}",
        nfc: "\u{B774}",
        nfd: "\u{1104}\u{1175}\u{11BB}",
        nfkc: "\u{B774}",
        nfkd: "\u{1104}\u{1175}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B775}",
        nfc: "\u{B775}",
        nfd: "\u{1104}\u{1175}\u{11BC}",
        nfkc: "\u{B775}",
        nfkd: "\u{1104}\u{1175}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B776}",
        nfc: "\u{B776}",
        nfd: "\u{1104}\u{1175}\u{11BD}",
        nfkc: "\u{B776}",
        nfkd: "\u{1104}\u{1175}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B777}",
        nfc: "\u{B777}",
        nfd: "\u{1104}\u{1175}\u{11BE}",
        nfkc: "\u{B777}",
        nfkd: "\u{1104}\u{1175}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B778}",
        nfc: "\u{B778}",
        nfd: "\u{1104}\u{1175}\u{11BF}",
        nfkc: "\u{B778}",
        nfkd: "\u{1104}\u{1175}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B779}",
        nfc: "\u{B779}",
        nfd: "\u{1104}\u{1175}\u{11C0}",
        nfkc: "\u{B779}",
        nfkd: "\u{1104}\u{1175}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B77A}",
        nfc: "\u{B77A}",
        nfd: "\u{1104}\u{1175}\u{11C1}",
        nfkc: "\u{B77A}",
        nfkd: "\u{1104}\u{1175}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B77B}",
        nfc: "\u{B77B}",
        nfd: "\u{1104}\u{1175}\u{11C2}",
        nfkc: "\u{B77B}",
        nfkd: "\u{1104}\u{1175}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B77C}",
        nfc: "\u{B77C}",
        nfd: "\u{1105}\u{1161}",
        nfkc: "\u{B77C}",
        nfkd: "\u{1105}\u{1161}",
    },
    NormalizationTest {
        source: "\u{B77D}",
        nfc: "\u{B77D}",
        nfd: "\u{1105}\u{1161}\u{11A8}",
        nfkc: "\u{B77D}",
        nfkd: "\u{1105}\u{1161}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B77E}",
        nfc: "\u{B77E}",
        nfd: "\u{1105}\u{1161}\u{11A9}",
        nfkc: "\u{B77E}",
        nfkd: "\u{1105}\u{1161}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B77F}",
        nfc: "\u{B77F}",
        nfd: "\u{1105}\u{1161}\u{11AA}",
        nfkc: "\u{B77F}",
        nfkd: "\u{1105}\u{1161}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B780}",
        nfc: "\u{B780}",
        nfd: "\u{1105}\u{1161}\u{11AB}",
        nfkc: "\u{B780}",
        nfkd: "\u{1105}\u{1161}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B781}",
        nfc: "\u{B781}",
        nfd: "\u{1105}\u{1161}\u{11AC}",
        nfkc: "\u{B781}",
        nfkd: "\u{1105}\u{1161}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B782}",
        nfc: "\u{B782}",
        nfd: "\u{1105}\u{1161}\u{11AD}",
        nfkc: "\u{B782}",
        nfkd: "\u{1105}\u{1161}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B783}",
        nfc: "\u{B783}",
        nfd: "\u{1105}\u{1161}\u{11AE}",
        nfkc: "\u{B783}",
        nfkd: "\u{1105}\u{1161}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B784}",
        nfc: "\u{B784}",
        nfd: "\u{1105}\u{1161}\u{11AF}",
        nfkc: "\u{B784}",
        nfkd: "\u{1105}\u{1161}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B785}",
        nfc: "\u{B785}",
        nfd: "\u{1105}\u{1161}\u{11B0}",
        nfkc: "\u{B785}",
        nfkd: "\u{1105}\u{1161}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B786}",
        nfc: "\u{B786}",
        nfd: "\u{1105}\u{1161}\u{11B1}",
        nfkc: "\u{B786}",
        nfkd: "\u{1105}\u{1161}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B787}",
        nfc: "\u{B787}",
        nfd: "\u{1105}\u{1161}\u{11B2}",
        nfkc: "\u{B787}",
        nfkd: "\u{1105}\u{1161}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B788}",
        nfc: "\u{B788}",
        nfd: "\u{1105}\u{1161}\u{11B3}",
        nfkc: "\u{B788}",
        nfkd: "\u{1105}\u{1161}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B789}",
        nfc: "\u{B789}",
        nfd: "\u{1105}\u{1161}\u{11B4}",
        nfkc: "\u{B789}",
        nfkd: "\u{1105}\u{1161}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B78A}",
        nfc: "\u{B78A}",
        nfd: "\u{1105}\u{1161}\u{11B5}",
        nfkc: "\u{B78A}",
        nfkd: "\u{1105}\u{1161}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B78B}",
        nfc: "\u{B78B}",
        nfd: "\u{1105}\u{1161}\u{11B6}",
        nfkc: "\u{B78B}",
        nfkd: "\u{1105}\u{1161}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B78C}",
        nfc: "\u{B78C}",
        nfd: "\u{1105}\u{1161}\u{11B7}",
        nfkc: "\u{B78C}",
        nfkd: "\u{1105}\u{1161}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B78D}",
        nfc: "\u{B78D}",
        nfd: "\u{1105}\u{1161}\u{11B8}",
        nfkc: "\u{B78D}",
        nfkd: "\u{1105}\u{1161}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B78E}",
        nfc: "\u{B78E}",
        nfd: "\u{1105}\u{1161}\u{11B9}",
        nfkc: "\u{B78E}",
        nfkd: "\u{1105}\u{1161}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B78F}",
        nfc: "\u{B78F}",
        nfd: "\u{1105}\u{1161}\u{11BA}",
        nfkc: "\u{B78F}",
        nfkd: "\u{1105}\u{1161}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B790}",
        nfc: "\u{B790}",
        nfd: "\u{1105}\u{1161}\u{11BB}",
        nfkc: "\u{B790}",
        nfkd: "\u{1105}\u{1161}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B791}",
        nfc: "\u{B791}",
        nfd: "\u{1105}\u{1161}\u{11BC}",
        nfkc: "\u{B791}",
        nfkd: "\u{1105}\u{1161}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B792}",
        nfc: "\u{B792}",
        nfd: "\u{1105}\u{1161}\u{11BD}",
        nfkc: "\u{B792}",
        nfkd: "\u{1105}\u{1161}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B793}",
        nfc: "\u{B793}",
        nfd: "\u{1105}\u{1161}\u{11BE}",
        nfkc: "\u{B793}",
        nfkd: "\u{1105}\u{1161}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B794}",
        nfc: "\u{B794}",
        nfd: "\u{1105}\u{1161}\u{11BF}",
        nfkc: "\u{B794}",
        nfkd: "\u{1105}\u{1161}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B795}",
        nfc: "\u{B795}",
        nfd: "\u{1105}\u{1161}\u{11C0}",
        nfkc: "\u{B795}",
        nfkd: "\u{1105}\u{1161}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B796}",
        nfc: "\u{B796}",
        nfd: "\u{1105}\u{1161}\u{11C1}",
        nfkc: "\u{B796}",
        nfkd: "\u{1105}\u{1161}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B797}",
        nfc: "\u{B797}",
        nfd: "\u{1105}\u{1161}\u{11C2}",
        nfkc: "\u{B797}",
        nfkd: "\u{1105}\u{1161}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B798}",
        nfc: "\u{B798}",
        nfd: "\u{1105}\u{1162}",
        nfkc: "\u{B798}",
        nfkd: "\u{1105}\u{1162}",
    },
    NormalizationTest {
        source: "\u{B799}",
        nfc: "\u{B799}",
        nfd: "\u{1105}\u{1162}\u{11A8}",
        nfkc: "\u{B799}",
        nfkd: "\u{1105}\u{1162}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B79A}",
        nfc: "\u{B79A}",
        nfd: "\u{1105}\u{1162}\u{11A9}",
        nfkc: "\u{B79A}",
        nfkd: "\u{1105}\u{1162}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B79B}",
        nfc: "\u{B79B}",
        nfd: "\u{1105}\u{1162}\u{11AA}",
        nfkc: "\u{B79B}",
        nfkd: "\u{1105}\u{1162}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B79C}",
        nfc: "\u{B79C}",
        nfd: "\u{1105}\u{1162}\u{11AB}",
        nfkc: "\u{B79C}",
        nfkd: "\u{1105}\u{1162}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B79D}",
        nfc: "\u{B79D}",
        nfd: "\u{1105}\u{1162}\u{11AC}",
        nfkc: "\u{B79D}",
        nfkd: "\u{1105}\u{1162}\u{11AC}",
    },
    NormalizationTest {
        source: "\u{B79E}",
        nfc: "\u{B79E}",
        nfd: "\u{1105}\u{1162}\u{11AD}",
        nfkc: "\u{B79E}",
        nfkd: "\u{1105}\u{1162}\u{11AD}",
    },
    NormalizationTest {
        source: "\u{B79F}",
        nfc: "\u{B79F}",
        nfd: "\u{1105}\u{1162}\u{11AE}",
        nfkc: "\u{B79F}",
        nfkd: "\u{1105}\u{1162}\u{11AE}",
    },
    NormalizationTest {
        source: "\u{B7A0}",
        nfc: "\u{B7A0}",
        nfd: "\u{1105}\u{1162}\u{11AF}",
        nfkc: "\u{B7A0}",
        nfkd: "\u{1105}\u{1162}\u{11AF}",
    },
    NormalizationTest {
        source: "\u{B7A1}",
        nfc: "\u{B7A1}",
        nfd: "\u{1105}\u{1162}\u{11B0}",
        nfkc: "\u{B7A1}",
        nfkd: "\u{1105}\u{1162}\u{11B0}",
    },
    NormalizationTest {
        source: "\u{B7A2}",
        nfc: "\u{B7A2}",
        nfd: "\u{1105}\u{1162}\u{11B1}",
        nfkc: "\u{B7A2}",
        nfkd: "\u{1105}\u{1162}\u{11B1}",
    },
    NormalizationTest {
        source: "\u{B7A3}",
        nfc: "\u{B7A3}",
        nfd: "\u{1105}\u{1162}\u{11B2}",
        nfkc: "\u{B7A3}",
        nfkd: "\u{1105}\u{1162}\u{11B2}",
    },
    NormalizationTest {
        source: "\u{B7A4}",
        nfc: "\u{B7A4}",
        nfd: "\u{1105}\u{1162}\u{11B3}",
        nfkc: "\u{B7A4}",
        nfkd: "\u{1105}\u{1162}\u{11B3}",
    },
    NormalizationTest {
        source: "\u{B7A5}",
        nfc: "\u{B7A5}",
        nfd: "\u{1105}\u{1162}\u{11B4}",
        nfkc: "\u{B7A5}",
        nfkd: "\u{1105}\u{1162}\u{11B4}",
    },
    NormalizationTest {
        source: "\u{B7A6}",
        nfc: "\u{B7A6}",
        nfd: "\u{1105}\u{1162}\u{11B5}",
        nfkc: "\u{B7A6}",
        nfkd: "\u{1105}\u{1162}\u{11B5}",
    },
    NormalizationTest {
        source: "\u{B7A7}",
        nfc: "\u{B7A7}",
        nfd: "\u{1105}\u{1162}\u{11B6}",
        nfkc: "\u{B7A7}",
        nfkd: "\u{1105}\u{1162}\u{11B6}",
    },
    NormalizationTest {
        source: "\u{B7A8}",
        nfc: "\u{B7A8}",
        nfd: "\u{1105}\u{1162}\u{11B7}",
        nfkc: "\u{B7A8}",
        nfkd: "\u{1105}\u{1162}\u{11B7}",
    },
    NormalizationTest {
        source: "\u{B7A9}",
        nfc: "\u{B7A9}",
        nfd: "\u{1105}\u{1162}\u{11B8}",
        nfkc: "\u{B7A9}",
        nfkd: "\u{1105}\u{1162}\u{11B8}",
    },
    NormalizationTest {
        source: "\u{B7AA}",
        nfc: "\u{B7AA}",
        nfd: "\u{1105}\u{1162}\u{11B9}",
        nfkc: "\u{B7AA}",
        nfkd: "\u{1105}\u{1162}\u{11B9}",
    },
    NormalizationTest {
        source: "\u{B7AB}",
        nfc: "\u{B7AB}",
        nfd: "\u{1105}\u{1162}\u{11BA}",
        nfkc: "\u{B7AB}",
        nfkd: "\u{1105}\u{1162}\u{11BA}",
    },
    NormalizationTest {
        source: "\u{B7AC}",
        nfc: "\u{B7AC}",
        nfd: "\u{1105}\u{1162}\u{11BB}",
        nfkc: "\u{B7AC}",
        nfkd: "\u{1105}\u{1162}\u{11BB}",
    },
    NormalizationTest {
        source: "\u{B7AD}",
        nfc: "\u{B7AD}",
        nfd: "\u{1105}\u{1162}\u{11BC}",
        nfkc: "\u{B7AD}",
        nfkd: "\u{1105}\u{1162}\u{11BC}",
    },
    NormalizationTest {
        source: "\u{B7AE}",
        nfc: "\u{B7AE}",
        nfd: "\u{1105}\u{1162}\u{11BD}",
        nfkc: "\u{B7AE}",
        nfkd: "\u{1105}\u{1162}\u{11BD}",
    },
    NormalizationTest {
        source: "\u{B7AF}",
        nfc: "\u{B7AF}",
        nfd: "\u{1105}\u{1162}\u{11BE}",
        nfkc: "\u{B7AF}",
        nfkd: "\u{1105}\u{1162}\u{11BE}",
    },
    NormalizationTest {
        source: "\u{B7B0}",
        nfc: "\u{B7B0}",
        nfd: "\u{1105}\u{1162}\u{11BF}",
        nfkc: "\u{B7B0}",
        nfkd: "\u{1105}\u{1162}\u{11BF}",
    },
    NormalizationTest {
        source: "\u{B7B1}",
        nfc: "\u{B7B1}",
        nfd: "\u{1105}\u{1162}\u{11C0}",
        nfkc: "\u{B7B1}",
        nfkd: "\u{1105}\u{1162}\u{11C0}",
    },
    NormalizationTest {
        source: "\u{B7B2}",
        nfc: "\u{B7B2}",
        nfd: "\u{1105}\u{1162}\u{11C1}",
        nfkc: "\u{B7B2}",
        nfkd: "\u{1105}\u{1162}\u{11C1}",
    },
    NormalizationTest {
        source: "\u{B7B3}",
        nfc: "\u{B7B3}",
        nfd: "\u{1105}\u{1162}\u{11C2}",
        nfkc: "\u{B7B3}",
        nfkd: "\u{1105}\u{1162}\u{11C2}",
    },
    NormalizationTest {
        source: "\u{B7B4}",
        nfc: "\u{B7B4}",
        nfd: "\u{1105}\u{1163}",
        nfkc: "\u{B7B4}",
        nfkd: "\u{1105}\u{1163}",
    },
    NormalizationTest {
        source: "\u{B7B5}",
        nfc: "\u{B7B5}",
        nfd: "\u{1105}\u{1163}\u{11A8}",
        nfkc: "\u{B7B5}",
        nfkd: "\u{1105}\u{1163}\u{11A8}",
    },
    NormalizationTest {
        source: "\u{B7B6}",
        nfc: "\u{B7B6}",
        nfd: "\u{1105}\u{1163}\u{11A9}",
        nfkc: "\u{B7B6}",
        nfkd: "\u{1105}\u{1163}\u{11A9}",
    },
    NormalizationTest {
        source: "\u{B7B7}",
        nfc: "\u{B7B7}",
        nfd: "\u{1105}\u{1163}\u{11AA}",
        nfkc: "\u{B7B7}",
        nfkd: "\u{1105}\u{1163}\u{11AA}",
    },
    NormalizationTest {
        source: "\u{B7B8}",
        nfc: "\u{B7B8}",
        nfd: "\u{1105}\u{1163}\u{11AB}",
        nfkc: "\u{B7B8}",
        nfkd: "\u{1105}\u{1163}\u{11AB}",
    },
    NormalizationTest {
        source: "\u{B7B9}",
        nfc: "\u{B7B9}",
        nfd: "\u{11