/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.FileInfo;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSetCacheStrategy {
    private static final Logger logger = LoggerFactory.getLogger(FileSetCacheStrategy.class);

    public Set<FileInfo> createExpiredFileSet(Collection<FileInfo> newFileSet, Set<FileInfo> currentFileSet) {
        LinkedHashSet<FileInfo> expiredFileSet = new LinkedHashSet<FileInfo>();
        if (currentFileSet.isEmpty()) {
            for (FileInfo info : newFileSet) {
                expiredFileSet.add(info);
            }
        } else {
            LinkedHashSet<FileInfo> diff = new LinkedHashSet<FileInfo>(newFileSet);
            diff.removeAll(currentFileSet);
            for (FileInfo info : diff) {
                expiredFileSet.add(info);
            }
            block2: for (FileInfo browserFileInfo : currentFileSet) {
                for (FileInfo clientFileInfo : newFileSet) {
                    if (!clientFileInfo.equals(browserFileInfo)) continue;
                    if (clientFileInfo.getTimestamp() != browserFileInfo.getTimestamp() || clientFileInfo.getLength() != browserFileInfo.getLength()) {
                        expiredFileSet.add(clientFileInfo);
                        logger.debug("files {} not equal ({},{}) ({},{}) update", new Object[]{clientFileInfo.getFilePath(), clientFileInfo.getLength(), clientFileInfo.getTimestamp(), browserFileInfo.getLength(), browserFileInfo.getTimestamp()});
                        continue block2;
                    }
                    logger.debug("files equal {}, {} no update", clientFileInfo, (Object)browserFileInfo);
                    continue block2;
                }
            }
        }
        return expiredFileSet;
    }
}

