/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.jstestdriver.annotations.BaseResourceLocation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.mortbay.resource.Resource;

public class SlaveResourceService {
    public static final String RESOURCE_LOCATION = "/com/google/jstestdriver/javascript";
    private final String baseResourceLocation;
    private ConcurrentHashMap<String, byte[]> resourceCache = new ConcurrentHashMap();

    @Inject
    public SlaveResourceService(@BaseResourceLocation String baseResourceLocation) {
        this.baseResourceLocation = baseResourceLocation;
    }

    public void serve(String path, OutputStream out) throws IOException {
        if (!this.resourceCache.containsKey(this.baseResourceLocation + path)) {
            Resource resource = Resource.newClassPathResource(this.baseResourceLocation + path);
            if (resource == null) {
                throw new IllegalArgumentException(this.baseResourceLocation + path + ": resource is null");
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            resource.writeTo(outputStream, 0L, resource.length());
            this.resourceCache.put(this.baseResourceLocation + path, outputStream.toByteArray());
        }
        out.write(this.resourceCache.get(this.baseResourceLocation + path));
    }
}

