/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.embedded;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.jstestdriver.JsTestDriver;
import com.google.jstestdriver.PluginLoader;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.ConfigurationSource;
import com.google.jstestdriver.config.UserConfigurationSource;
import com.google.jstestdriver.config.YamlParser;
import com.google.jstestdriver.hooks.PluginInitializer;
import com.google.jstestdriver.hooks.ServerListener;
import com.google.jstestdriver.output.TestResultListener;
import com.google.jstestdriver.runner.RunnerMode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTestDriverBuilder {
    private File baseDir;
    private List<Module> pluginModules = Lists.newArrayList();
    private String[] flags = new String[0];
    private Configuration configuration;
    private final PluginLoader pluginLoader = new PluginLoader();
    private int port = -1;
    private final List<ServerListener> serverListeners = Lists.newArrayList();
    private final List<TestResultListener> testListeners = Lists.newArrayList();
    private RunnerMode runnerMode = RunnerMode.QUIET;
    private String serverAddress;
    private final List<Class<? extends PluginInitializer>> pluginInitializers = Lists.newArrayList();

    public JsTestDriverBuilder setDefaultConfiguration(String configPath) {
        this.setConfigurationSource(new UserConfigurationSource(new File(configPath)));
        return this;
    }

    public JsTestDriverBuilder setDefaultConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public JsTestDriverBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public JsTestDriverBuilder addServerListener(ServerListener testServerListener) {
        this.serverListeners.add(testServerListener);
        return this;
    }

    public JsTestDriver build() {
        ArrayList<Module> plugins = Lists.newArrayList(this.pluginModules);
        plugins.add(new ListenerBindingModule(this.serverListeners, this.testListeners));
        return new JsTestDriver(this.configuration, this.pluginLoader, this.pluginInitializers, this.runnerMode, this.flags, this.port, plugins, this.serverListeners, this.testListeners, this.baseDir, this.serverAddress);
    }

    public JsTestDriverBuilder withPluginInitializer(Class<? extends PluginInitializer> initializer) {
        this.pluginInitializers.add(initializer);
        return this;
    }

    public JsTestDriverBuilder setRunnerMode(RunnerMode runnerMode) {
        this.runnerMode = runnerMode;
        return this;
    }

    public JsTestDriverBuilder addTestListener(TestResultListener testResultListener) {
        this.testListeners.add(testResultListener);
        return this;
    }

    public JsTestDriverBuilder setServer(String serverAddress) {
        this.serverAddress = serverAddress;
        return this;
    }

    public JsTestDriverBuilder setBaseDir(File file) {
        this.baseDir = file;
        return this;
    }

    public JsTestDriverBuilder setConfigurationSource(ConfigurationSource source) {
        this.setDefaultConfiguration(source.parse(this.baseDir, new YamlParser()));
        return this;
    }

    public JsTestDriverBuilder addPluginModules(List<Module> pluginModules) {
        this.pluginModules = pluginModules;
        return this;
    }

    public JsTestDriverBuilder setFlags(String[] flags) {
        this.flags = flags;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenerBindingModule
    implements Module {
        private final List<? extends ServerListener> serverListeners;
        private final List<? extends TestResultListener> testListeners;

        ListenerBindingModule(List<? extends ServerListener> serverListeners, List<? extends TestResultListener> testListeners) {
            this.serverListeners = serverListeners;
            this.testListeners = testListeners;
        }

        @Override
        public void configure(Binder binder) {
            Multibinder<ServerListener> serverSetBinder = Multibinder.newSetBinder(binder, ServerListener.class);
            for (ServerListener serverListener : this.serverListeners) {
                serverSetBinder.addBinding().toInstance(serverListener);
            }
            Multibinder<TestResultListener> testSetBinder = Multibinder.newSetBinder(binder, TestResultListener.class);
            for (TestResultListener testResultListener : this.testListeners) {
                testSetBinder.addBinding().toInstance(testResultListener);
            }
        }
    }
}

