/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JstdTestCaseDelta {
    private List<FileInfo> dependencies;
    private List<FileInfo> tests;
    private List<FileInfo> plugins;

    public JstdTestCaseDelta() {
    }

    public JstdTestCaseDelta(List<FileInfo> dependencies, List<FileInfo> tests, List<FileInfo> plugins) {
        this.dependencies = dependencies;
        this.tests = tests;
        this.plugins = plugins;
    }

    public List<FileInfo> getTests() {
        return this.tests;
    }

    public List<FileInfo> getDependencies() {
        return this.dependencies;
    }

    public List<FileInfo> getPlugins() {
        return this.plugins;
    }

    public JstdTestCaseDelta loadFiles(FileLoader fileLoader) {
        return new JstdTestCaseDelta(fileLoader.loadFiles(this.dependencies, false), fileLoader.loadFiles(this.tests, false), fileLoader.loadFiles(this.plugins, false));
    }

    public String toString() {
        Function<FileInfo, String> fileInfoToPath = new Function<FileInfo, String>(){

            @Override
            public String apply(FileInfo in) {
                return "\n\t\t" + in.getFilePath();
            }
        };
        return String.format("JstdTestCaseDelta(\n\tdependencies[%s],\n\ttests[%s],\n\tplugins[%s])", Lists.transform(this.dependencies, fileInfoToPath), Lists.transform(this.tests, fileInfoToPath), Lists.transform(this.plugins, fileInfoToPath));
    }
}

