/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.hooks.JstdTestCaseProcessor;
import com.google.jstestdriver.hooks.ResourceDependencyResolver;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.util.StopWatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JstdTestCaseFactory {
    private static final Logger logger = LoggerFactory.getLogger(JstdTestCaseFactory.class);
    private final Set<JstdTestCaseProcessor> processors;
    private final Set<ResourceDependencyResolver> resolvers;
    private final StopWatch stopWatch;

    @Inject
    public JstdTestCaseFactory(Set<JstdTestCaseProcessor> processors, Set<ResourceDependencyResolver> resolvers, StopWatch stopWatch) {
        this.processors = processors;
        this.resolvers = resolvers;
        this.stopWatch = stopWatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JstdTestCase> createCases(List<FileInfo> plugins, List<FileInfo> deps, List<FileInfo> tests) {
        this.stopWatch.start("Create TestCases", new Object[0]);
        try {
            ArrayList<JstdTestCase> testCases = Lists.newArrayList();
            if (!deps.isEmpty() || !tests.isEmpty()) {
                logger.debug("creating default test case");
                testCases.add(new JstdTestCase(deps, tests, plugins, "default"));
            }
            List<JstdTestCase> list = this.processTestCases(this.resolveDependencies(testCases));
            return list;
        }
        finally {
            this.stopWatch.stop("Create TestCases", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JstdTestCase> resolveDependencies(List<JstdTestCase> testCases) {
        this.stopWatch.start("resolveDependencies", new Object[0]);
        try {
            ArrayList<JstdTestCase> resolved = Lists.newArrayListWithExpectedSize(testCases.size());
            for (JstdTestCase jstdTestCase : testCases) {
                for (ResourceDependencyResolver resolver : this.resolvers) {
                    this.stopWatch.start(resolver.toString(), new Object[0]);
                    jstdTestCase = resolver.resolve(jstdTestCase);
                    this.stopWatch.stop(resolver.toString(), new Object[0]);
                }
                resolved.add(jstdTestCase);
            }
            ArrayList<JstdTestCase> arrayList = resolved;
            return arrayList;
        }
        finally {
            this.stopWatch.stop("resolveDependencies", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JstdTestCase> processTestCases(List<JstdTestCase> testCases) {
        this.stopWatch.start("resolveDependencies", new Object[0]);
        try {
            for (JstdTestCaseProcessor processor : this.processors) {
                this.stopWatch.start(processor.toString(), new Object[0]);
                testCases = processor.process(testCases.iterator());
                this.stopWatch.stop(processor.toString(), new Object[0]);
            }
            List<JstdTestCase> list = testCases;
            return list;
        }
        finally {
            this.stopWatch.stop("resolveDependencies", new Object[0]);
        }
    }

    public List<JstdTestCase> updateCases(Set<FileInfo> fileSet, List<JstdTestCase> testCases) {
        LinkedHashSet<FileInfo> tests = Sets.newLinkedHashSet();
        for (JstdTestCase testCase : testCases) {
            tests.addAll(testCase.getTests());
        }
        fileSet.removeAll(tests);
        return this.createCases(Collections.<FileInfo>emptyList(), Lists.newArrayList(fileSet), Lists.newArrayList(tests));
    }
}

