/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.gson.JsonParser;
import com.google.inject.Inject;
import com.google.jstestdriver.annotations.ResponseWriter;
import com.google.jstestdriver.requesthandlers.GatewayConfiguration;
import com.google.jstestdriver.requesthandlers.HttpMethod;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayConfigurationHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(GatewayConfigurationHandler.class);
    private final HttpMethod method;
    private final HttpServletRequest request;
    private final PrintWriter responseWriter;
    private final JsonParser parser;
    private final GatewayConfiguration gatewayConfiguration;

    @Inject
    public GatewayConfigurationHandler(HttpMethod method, HttpServletRequest request, @ResponseWriter PrintWriter responseWriter, JsonParser parser, GatewayConfiguration gatewayConfiguration) {
        this.method = method;
        this.request = request;
        this.responseWriter = responseWriter;
        this.parser = parser;
        this.gatewayConfiguration = gatewayConfiguration;
    }

    public void handleIt() throws IOException {
        if (this.method.equals((Object)HttpMethod.GET)) {
            this.responseWriter.println(this.gatewayConfiguration.getGatewayConfig());
        } else {
            try {
                this.gatewayConfiguration.updateConfiguration(this.parser.parse(this.request.getReader()).getAsJsonArray());
            }
            catch (ServletException e) {
                logger.error("Error configuring gateway {}", e);
            }
        }
    }
}

