CREATE UNLOGGED TABLE 
	IF NOT EXISTS "a" (
	"id" integer PRIMARY KEY UNIQUE DEFAULT 1,
	"name" varchar(255) CONSTRAINT "name_constraint" NULL DEFERRABLE INITIALLY DEFERRED
	CONSTRAINT "a_id_check" CHECK ("id" > -1)
) 
INHERITS ("b") 
ON COMMIT DELETE ROWS
TABLESPACE "tablespace";

CREATE 
GLOBAL TEMPORARY TABLE 
"b"
(
	"id" uuid REFERENCES "a"("id") MATCH FULL ON DELETE NO ACTION,
	"name" varchar NOT NULL CHECK (name <> ''),
	"email" varchar(55) COLLATE "c",
	CONSTRAINT "b_pk" 
		PRIMARY KEY ("email") 
		USING INDEX TABLESPACE "a" NOT DEFERRABLE INITIALLY IMMEDIATE,
	UNIQUE("name") INCLUDES ("id", "email")
)
PARTITION BY RANGE ("name" COLLATE "c1" "av")
WITH OIDS;

CREATE LOCAL TEMP TABLE IF NOT EXISTS "c" (
	"index" CHARACTER VARYING (255) UNIQUE WITH (fillfactor = 1),
	"phone" SERIAL GENERATED BY DEFAULT AS IDENTITY,
	"time" timestamp,
	CONSTRAINT "c_time_constraint"
		FOREIGN KEY ("time") 
		REFERENCES "a" ("name"),
	LIKE "a" INCLUDING COMMENTS
)
WITH (fillfactor= 70)
ON COMMIT DROP;

CREATE TABLE "circles" (
	"c" circle,
	EXCLUDE USING gist ("c" WITH &&)
);

CREATE TABLE "employees" OF "employee_type" (
	PRIMARY KEY ("name"),
	"salary" WITH OPTIONS DEFAULT 1000
) 
WITHOUT OIDS
ON COMMIT PRESERVE ROWS
TABLESPACE "ts";

CREATE TABLE "measurement_y2016m07"
	PARTITION OF "measurement" (
	"unitsales" DEFAULT 0
) FOR VALUES FROM ('2016-07-01') TO ('2016-08-01');

CREATE TABLE "measurement_ym_y2016m11"
	PARTITION OF "measurement_year_month"
	FOR VALUES FROM (2016, 11) TO (2016, 12);

CREATE TABLE "cities_ab"
    PARTITION OF "cities" (
    CONSTRAINT "city_id_nonzero" CHECK (city_id != 0)
) FOR VALUES IN ('a', 'b');

CREATE TABLE "foo" (
  "bar" text[],
  "bar2" int [ 1 ],
  "bar3" int[2][3 ],
  "bar4" int array,
  "bar5" int ARRAY [2],
  "bar6" text ARRAY[8],
  "bar7" text ARRAY[ 100 ],
  "bar8" time(2) with time zone [],
  "bar9" time(1) [1],
  "bar10" time(1) aRRay,
  "bar11" time aRray [5],
  "bar12" timestamp(2) without time zone[10][2][5],
  "bar13" character varying[],
  "bar14" character varying(25) [][2][],
  "bar15" character varying array [76]
);