/*
 * Generated by PEG.js 0.10.0.
 *
 * http://pegjs.org/
 */

"use strict";

var _ = require("lodash"), pluralize = require("pluralize");

function peg$subclass(child, parent) {
  function ctor() { this.constructor = child; }
  ctor.prototype = parent.prototype;
  child.prototype = new ctor();
}

function peg$SyntaxError(message, expected, found, location) {
  this.message  = message;
  this.expected = expected;
  this.found    = found;
  this.location = location;
  this.name     = "SyntaxError";

  if (typeof Error.captureStackTrace === "function") {
    Error.captureStackTrace(this, peg$SyntaxError);
  }
}

peg$subclass(peg$SyntaxError, Error);

peg$SyntaxError.buildMessage = function(expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
        literal: function(expectation) {
          return "\"" + literalEscape(expectation.text) + "\"";
        },

        "class": function(expectation) {
          var escapedParts = "",
              i;

          for (i = 0; i < expectation.parts.length; i++) {
            escapedParts += expectation.parts[i] instanceof Array
              ? classEscape(expectation.parts[i][0]) + "-" + classEscape(expectation.parts[i][1])
              : classEscape(expectation.parts[i]);
          }

          return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
        },

        any: function(expectation) {
          return "any character";
        },

        end: function(expectation) {
          return "end of input";
        },

        other: function(expectation) {
          return expectation.description;
        }
      };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s
      .replace(/\\/g, '\\\\')
      .replace(/"/g,  '\\"')
      .replace(/\0/g, '\\0')
      .replace(/\t/g, '\\t')
      .replace(/\n/g, '\\n')
      .replace(/\r/g, '\\r')
      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
  }

  function classEscape(s) {
    return s
      .replace(/\\/g, '\\\\')
      .replace(/\]/g, '\\]')
      .replace(/\^/g, '\\^')
      .replace(/-/g,  '\\-')
      .replace(/\0/g, '\\0')
      .replace(/\t/g, '\\t')
      .replace(/\n/g, '\\n')
      .replace(/\r/g, '\\r')
      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = new Array(expected.length),
        i, j;

    for (i = 0; i < expected.length; i++) {
      descriptions[i] = describeExpectation(expected[i]);
    }

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + " or " + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(", ")
          + ", or "
          + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
  }

  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$parse(input, options) {
  options = options !== void 0 ? options : {};

  var peg$FAILED = {},

      peg$startRuleFunctions = { parser: peg$parseparser },
      peg$startRuleFunction  = peg$parseparser,

      peg$c0 = function(commands) {
      	commands.forEach((cmd) => {
      		const { command_name, value: { syntax_name, value }, warning } = cmd;
      		switch(command_name.toLowerCase()){
      			case "create_table":
      				const table = value;
      				switch(syntax_name.toLowerCase()) {
      					case "create_table_normal":
      						tables.push(table);

      						const pkList = [];

      						table.fields.forEach(field => {
      							// process inline_refs
      							if (field.inline_refs) {
      								refs.push(...field.inline_refs.map(ref => {
      									return {
      										endpoints: [
      											{
      												tableName: table.name,
      												schemaName: table.schemaName,
      												fieldNames: [field.name],
      												relation: "*",
      											},
      											ref.endpoint
      										],
      										onDelete: ref.onDelete,
      										onUpdate: ref.onUpdate
      									}
      								}));
      							}

      							// process composite primary key, if primary key is in composite form, push it into indexes
      							if (field.pk) {
      								pkList.push(field);
      							}
      						});

      						if (pkList.length > 1) {
      							table.fields = table.fields.map((field) => {
      								delete field.pk
      								return field;
      							});

      							const index = {
      								columns: pkList.map(field => ({
      									value: field.name,
      									type: 'column'
      								})),
      								pk: true
      							};
      							
      							if (table.indexes) {
      								table.indexes.push(index);
      							} else {
      								table.indexes = [index];
      							}
      						}
      						break;
      					case "create_table_of":
      						break;
      					case "create_table_partition_of":
      						break;
      				}
      				break;
      			case "create_index":
      				const { table_name } = value;
      				delete value.table_name; // remove table_name from column
              const table_index = findTable(table_name.schemaName, table_name.name);
      				if (table_index.indexes) {
      					table_index.indexes.push(value);
      				} else {
      					table_index.indexes = [value];
      				}
      				break;
      			case "create_type":
      				switch(syntax_name.toLowerCase()) {
      					case "create_type_enum":
      						enums.push(value);
      						break;
      					case "create_type_range":
      						break;
      				}
      				break;
      			case "alter_table":
      				switch(syntax_name.toLowerCase()) {
      					case "alter_table_action":
      						value.forEach(v => {
      							const { type } = v;
      							switch(type.toLowerCase()) {
      								case "fk":
      									v.t_value.forEach(endpoints => {
      										refs.push(endpoints);
      									})
      							}
      						})
      						break;
      				}
      				break;
      			case "comment":
      				switch(syntax_name.toLowerCase()) {
      					case "column": {
      						const { schemaName, tableName, columnName } = value;
      						const foundTable = findTable(schemaName, tableName);
      						if (foundTable) {
      							const foundField = findField(foundTable, columnName);
      							if (foundField) foundField.note = value.text;
      						}
      						break;
      					}
      					case "table":	{
      						const { schemaName, name: tableName } = value.table_name;
      						const foundTable = findTable(schemaName, tableName);
      						if (foundTable) foundTable.note = value.text;
      						break;
      					}
      				}
      				break;
      			case "ignore_syntax":
      				// warnings.push(warning);
      				break;
      		}
      	})

      	return {tables, refs, enums};
      },
      peg$c1 = "create",
      peg$c2 = peg$literalExpectation("CREATE", true),
      peg$c3 = "alter",
      peg$c4 = peg$literalExpectation("ALTER", true),
      peg$c5 = "unique",
      peg$c6 = peg$literalExpectation("UNIQUE", true),
      peg$c7 = "index",
      peg$c8 = peg$literalExpectation("INDEX", true),
      peg$c9 = "type",
      peg$c10 = peg$literalExpectation("TYPE", true),
      peg$c11 = "enum",
      peg$c12 = peg$literalExpectation("ENUM", true),
      peg$c13 = "concurrenly",
      peg$c14 = peg$literalExpectation("CONCURRENLY", true),
      peg$c15 = "foreign",
      peg$c16 = peg$literalExpectation("FOREIGN", true),
      peg$c17 = "key",
      peg$c18 = peg$literalExpectation("KEY", true),
      peg$c19 = "references",
      peg$c20 = peg$literalExpectation("REFERENCES", true),
      peg$c21 = "on",
      peg$c22 = peg$literalExpectation("ON", true),
      peg$c23 = "using",
      peg$c24 = peg$literalExpectation("USING", true),
      peg$c25 = "table",
      peg$c26 = peg$literalExpectation("TABLE", true),
      peg$c27 = "if",
      peg$c28 = peg$literalExpectation("IF", true),
      peg$c29 = "not",
      peg$c30 = peg$literalExpectation("NOT", true),
      peg$c31 = "exists",
      peg$c32 = peg$literalExpectation("EXISTS", true),
      peg$c33 = "global",
      peg$c34 = peg$literalExpectation("GLOBAL", true),
      peg$c35 = "local",
      peg$c36 = peg$literalExpectation("LOCAL", true),
      peg$c37 = "temporary",
      peg$c38 = peg$literalExpectation("TEMPORARY", true),
      peg$c39 = "temp",
      peg$c40 = peg$literalExpectation("TEMP", true),
      peg$c41 = "unlogged",
      peg$c42 = peg$literalExpectation("UNLOGGED", true),
      peg$c43 = "collate",
      peg$c44 = peg$literalExpectation("COLLATE", true),
      peg$c45 = "collation",
      peg$c46 = peg$literalExpectation("COLLATION", true),
      peg$c47 = "partition",
      peg$c48 = peg$literalExpectation("PARTITION", true),
      peg$c49 = "by",
      peg$c50 = peg$literalExpectation("BY", true),
      peg$c51 = "range",
      peg$c52 = peg$literalExpectation("RANGE", true),
      peg$c53 = "list",
      peg$c54 = peg$literalExpectation("LIST", true),
      peg$c55 = "hash",
      peg$c56 = peg$literalExpectation("HASH", true),
      peg$c57 = "like",
      peg$c58 = peg$literalExpectation("LIKE", true),
      peg$c59 = "inherits",
      peg$c60 = peg$literalExpectation("INHERITS", true),
      peg$c61 = "inherit",
      peg$c62 = peg$literalExpectation("INHERIT", true),
      peg$c63 = "with",
      peg$c64 = peg$literalExpectation("WITH", true),
      peg$c65 = "without",
      peg$c66 = peg$literalExpectation("WITHOUT", true),
      peg$c67 = "oids",
      peg$c68 = peg$literalExpectation("OIDS", true),
      peg$c69 = "commit",
      peg$c70 = peg$literalExpectation("COMMIT", true),
      peg$c71 = "preserve",
      peg$c72 = peg$literalExpectation("PRESERVE", true),
      peg$c73 = "rows",
      peg$c74 = peg$literalExpectation("ROWS", true),
      peg$c75 = "delete",
      peg$c76 = peg$literalExpectation("DELETE", true),
      peg$c77 = "drop",
      peg$c78 = peg$literalExpectation("DROP", true),
      peg$c79 = "tablespace",
      peg$c80 = peg$literalExpectation("TABLESPACE", true),
      peg$c81 = "constraint",
      peg$c82 = peg$literalExpectation("CONSTRAINT", true),
      peg$c83 = "no",
      peg$c84 = peg$literalExpectation("NO", true),
      peg$c85 = "null",
      peg$c86 = peg$literalExpectation("NULL", true),
      peg$c87 = "check",
      peg$c88 = peg$literalExpectation("CHECK", true),
      peg$c89 = "default",
      peg$c90 = peg$literalExpectation("DEFAULT", true),
      peg$c91 = "primary",
      peg$c92 = peg$literalExpectation("PRIMARY", true),
      peg$c93 = "match",
      peg$c94 = peg$literalExpectation("MATCH", true),
      peg$c95 = "full",
      peg$c96 = peg$literalExpectation("FULL", true),
      peg$c97 = "partial",
      peg$c98 = peg$literalExpectation("PARTIAL", true),
      peg$c99 = "simple",
      peg$c100 = peg$literalExpectation("SIMPLE", true),
      peg$c101 = "update",
      peg$c102 = peg$literalExpectation("UPDATE", true),
      peg$c103 = "deferrable",
      peg$c104 = peg$literalExpectation("DEFERRABLE", true),
      peg$c105 = "initially",
      peg$c106 = peg$literalExpectation("INITIALLY", true),
      peg$c107 = "deferred",
      peg$c108 = peg$literalExpectation("DEFERRED", true),
      peg$c109 = "immediate",
      peg$c110 = peg$literalExpectation("IMMEDIATE", true),
      peg$c111 = "exclude",
      peg$c112 = peg$literalExpectation("EXCLUDE", true),
      peg$c113 = "where",
      peg$c114 = peg$literalExpectation("WHERE", true),
      peg$c115 = "including",
      peg$c116 = peg$literalExpectation("INCLUDING", true),
      peg$c117 = "excluding",
      peg$c118 = peg$literalExpectation("EXCLUDING", true),
      peg$c119 = "comments",
      peg$c120 = peg$literalExpectation("COMMENTS", true),
      peg$c121 = "constraints",
      peg$c122 = peg$literalExpectation("CONSTRAINTS", true),
      peg$c123 = "generated",
      peg$c124 = peg$literalExpectation("GENERATED", true),
      peg$c125 = "always",
      peg$c126 = peg$literalExpectation("ALWAYS", true),
      peg$c127 = "as",
      peg$c128 = peg$literalExpectation("AS", true),
      peg$c129 = "add",
      peg$c130 = peg$literalExpectation("ADD", true),
      peg$c131 = "only",
      peg$c132 = peg$literalExpectation("ONLY", true),
      peg$c133 = "defaults",
      peg$c134 = peg$literalExpectation("DEFAULTS", true),
      peg$c135 = "identity",
      peg$c136 = peg$literalExpectation("IDENTITY", true),
      peg$c137 = "indexes",
      peg$c138 = peg$literalExpectation("INDEXES", true),
      peg$c139 = "statistics",
      peg$c140 = peg$literalExpectation("STATISTICS", true),
      peg$c141 = "storage",
      peg$c142 = peg$literalExpectation("STORAGE", true),
      peg$c143 = "include",
      peg$c144 = peg$literalExpectation("INCLUDE", true),
      peg$c145 = "includes",
      peg$c146 = peg$literalExpectation("INCLUDES", true),
      peg$c147 = "all",
      peg$c148 = peg$literalExpectation("ALL", true),
      peg$c149 = "of",
      peg$c150 = peg$literalExpectation("OF", true),
      peg$c151 = "options",
      peg$c152 = peg$literalExpectation("OPTIONS", true),
      peg$c153 = "for",
      peg$c154 = peg$literalExpectation("FOR", true),
      peg$c155 = "values",
      peg$c156 = peg$literalExpectation("VALUES", true),
      peg$c157 = "in",
      peg$c158 = peg$literalExpectation("IN", true),
      peg$c159 = "from",
      peg$c160 = peg$literalExpectation("FROM", true),
      peg$c161 = "to",
      peg$c162 = peg$literalExpectation("TO", true),
      peg$c163 = "modulus",
      peg$c164 = peg$literalExpectation("MODULUS", true),
      peg$c165 = "remainder",
      peg$c166 = peg$literalExpectation("REMAINDER", true),
      peg$c167 = "true",
      peg$c168 = peg$literalExpectation("TRUE", true),
      peg$c169 = "false",
      peg$c170 = peg$literalExpectation("FALSE", true),
      peg$c171 = "maxvalue",
      peg$c172 = peg$literalExpectation("MAXVALUE", true),
      peg$c173 = "minvalue",
      peg$c174 = peg$literalExpectation("MINVALUE", true),
      peg$c175 = "subtype",
      peg$c176 = peg$literalExpectation("SUBTYPE", true),
      peg$c177 = "subtype_opclass",
      peg$c178 = peg$literalExpectation("SUBTYPE_OPCLASS", true),
      peg$c179 = "canonical",
      peg$c180 = peg$literalExpectation("CANONICAL", true),
      peg$c181 = "subtype_diff",
      peg$c182 = peg$literalExpectation("SUBTYPE_DIFF", true),
      peg$c183 = "valid",
      peg$c184 = peg$literalExpectation("VALID", true),
      peg$c185 = "column",
      peg$c186 = peg$literalExpectation("COLUMN", true),
      peg$c187 = "set",
      peg$c188 = peg$literalExpectation("SET", true),
      peg$c189 = "data",
      peg$c190 = peg$literalExpectation("DATA", true),
      peg$c191 = "reset",
      peg$c192 = peg$literalExpectation("RESET", true),
      peg$c193 = "plain",
      peg$c194 = peg$literalExpectation("PLAIN", true),
      peg$c195 = "external",
      peg$c196 = peg$literalExpectation("EXTERNAL", true),
      peg$c197 = "extended",
      peg$c198 = peg$literalExpectation("EXTENDED", true),
      peg$c199 = "main",
      peg$c200 = peg$literalExpectation("MAIN", true),
      peg$c201 = "asc",
      peg$c202 = peg$literalExpectation("ASC", true),
      peg$c203 = "desc",
      peg$c204 = peg$literalExpectation("DESC", true),
      peg$c205 = "nulls",
      peg$c206 = peg$literalExpectation("NULLS", true),
      peg$c207 = "first",
      peg$c208 = peg$literalExpectation("FIRST", true),
      peg$c209 = "last",
      peg$c210 = peg$literalExpectation("LAST", true),
      peg$c211 = "comment",
      peg$c212 = peg$literalExpectation("COMMENT", true),
      peg$c213 = "IS",
      peg$c214 = peg$literalExpectation("IS", false),
      peg$c215 = "insert",
      peg$c216 = peg$literalExpectation("INSERT", true),
      peg$c217 = "select",
      peg$c218 = peg$literalExpectation("SELECT", true),
      peg$c219 = "use",
      peg$c220 = peg$literalExpectation("USE", true),
      peg$c221 = "sequence",
      peg$c222 = peg$literalExpectation("SEQUENCE", true),
      peg$c223 = "schema",
      peg$c224 = peg$literalExpectation("SCHEMA", true),
      peg$c225 = "view",
      peg$c226 = peg$literalExpectation("VIEW", true),
      peg$c227 = "rename",
      peg$c228 = peg$literalExpectation("RENAME", true),
      peg$c229 = "owned",
      peg$c230 = peg$literalExpectation("OWNED", true),
      peg$c231 = "attach",
      peg$c232 = peg$literalExpectation("ATTACH", true),
      peg$c233 = "detach",
      peg$c234 = peg$literalExpectation("DETACH", true),
      peg$c235 = peg$otherExpectation("expression"),
      peg$c236 = function(factors) {
      	return removeReduntdantSpNewline(_.flattenDeep(factors).join(""));
      },
      peg$c237 = "(",
      peg$c238 = peg$literalExpectation("(", false),
      peg$c239 = ")",
      peg$c240 = peg$literalExpectation(")", false),
      peg$c241 = ",",
      peg$c242 = peg$literalExpectation(",", false),
      peg$c243 = ");",
      peg$c244 = peg$literalExpectation(");", false),
      peg$c245 = peg$anyExpectation(),
      peg$c246 = function(factors) {
      	return _.flattenDeep(factors).join("");
      },
      peg$c247 = /^["',.a-z0-9_+-:<>=!*]/i,
      peg$c248 = peg$classExpectation(["\"", "'", ",", ".", ["a", "z"], ["0", "9"], "_", ["+", ":"], "<", ">", "=", "!", "*"], false, true),
      peg$c249 = /^['.a-z0-9_+\-]/i,
      peg$c250 = peg$classExpectation(["'", ".", ["a", "z"], ["0", "9"], "_", "+", "-"], false, true),
      peg$c251 = peg$otherExpectation("valid column name"),
      peg$c252 = ".",
      peg$c253 = peg$literalExpectation(".", false),
      peg$c254 = function(names) {
        let dbName = null;
        let schemaName = null;
        if (names && names.length > 0) {
          if (names.length === 1) schemaName = names[0][0];
          else {
            dbName = names[0][0];
            schemaName = names[1][0];
          }
        }
        return { dbName, schemaName }
      },
      peg$c255 = peg$otherExpectation("valid table name"),
      peg$c256 = function(pathName, name) {
        return { ...pathName, name }
      },
      peg$c257 = peg$otherExpectation("valid enum name"),
      peg$c258 = peg$otherExpectation("string"),
      peg$c259 = "'",
      peg$c260 = peg$literalExpectation("'", false),
      peg$c261 = function(c) {
      	return c.join('');
      },
      peg$c262 = "''",
      peg$c263 = peg$literalExpectation("''", false),
      peg$c264 = function() { return "'" },
      peg$c265 = /^[^']/,
      peg$c266 = peg$classExpectation(["'"], true, false),
      peg$c267 = "\"",
      peg$c268 = peg$literalExpectation("\"", false),
      peg$c269 = function(c) {
      		return c.join('');
      	},
      peg$c270 = "\"\"",
      peg$c271 = peg$literalExpectation("\"\"", false),
      peg$c272 = function() { return '"' },
      peg$c273 = /^[^"]/,
      peg$c274 = peg$classExpectation(["\""], true, false),
      peg$c275 = peg$otherExpectation("number"),
      peg$c276 = "e",
      peg$c277 = peg$literalExpectation("e", false),
      peg$c278 = "+",
      peg$c279 = peg$literalExpectation("+", false),
      peg$c280 = "-",
      peg$c281 = peg$literalExpectation("-", false),
      peg$c282 = function(a) {
      		return _.flattenDeep(a).filter(ele => ele).join('');
      	},
      peg$c283 = function(d) { return d.join('') },
      peg$c284 = /^[0-9]/,
      peg$c285 = peg$classExpectation([["0", "9"]], false, false),
      peg$c286 = peg$otherExpectation("VALID TYPE"),
      peg$c287 = "character",
      peg$c288 = peg$literalExpectation("CHARACTER", true),
      peg$c289 = "varying",
      peg$c290 = peg$literalExpectation("VARYING", true),
      peg$c291 = function(c1, c2, args, dimensions) {
        let c = `${c1} ${c2}`;
        c = args ? c + '(' + args[1] + ')' : c;
        return {
          type_name: c + (dimensions ? dimensions.map((dimension) => '[' + dimension + ']').join('') : ''),
          args: args ? args[1] : null
        }
      },
      peg$c292 = "timestamp",
      peg$c293 = peg$literalExpectation("timestamp", true),
      peg$c294 = peg$literalExpectation("without", true),
      peg$c295 = peg$literalExpectation("with", true),
      peg$c296 = "time",
      peg$c297 = peg$literalExpectation("time", true),
      peg$c298 = "zone",
      peg$c299 = peg$literalExpectation("zone", true),
      peg$c300 = function(number, dimensions) {
        const args = number ? number[2] : null;
        return {
          type_name: (args !== null ? `timestamp(${args})`: `timestamp`) + (dimensions ? dimensions.map((dimension) => '[' + dimension + ']').join('') : ''),
          args
        }
      },
      peg$c301 = function(number, dimensions) {
        const args = number ? number[2] : null;
        return {
          type_name: (args !== null ? `time(${args})`: `time`) + (dimensions ? dimensions.map((dimension) => '[' + dimension + ']').join('') : ''),
          args
        }
      },
      peg$c302 = function(c, dimensions) {
      	  const args = c.args;
          return {
            type_name: c.type_name + (dimensions ? dimensions.map((dimension) => '[' + dimension + ']').join('') : ''),
            schemaName: c.schemaName,
            args
          };
      	},
      peg$c303 = /^[^"\n]/,
      peg$c304 = peg$classExpectation(["\"", "\n"], true, false),
      peg$c305 = function(c) { 
        return { 
          type_name: c.join(""),
          args: null
        } 
      },
      peg$c306 = function(pathName, c, args) {
      	let type_name = c.join("");
      	args = args ? args[1] : null;
      	if (type_name.toLowerCase() !== 'enum') {
      		type_name = args ? type_name + '(' + args + ')' : type_name;
      	}

      	return {
          ...pathName,
      		type_name,
      		args
      	}
      },
      peg$c307 = "array",
      peg$c308 = peg$literalExpectation("array", true),
      peg$c309 = "[",
      peg$c310 = peg$literalExpectation("[", false),
      peg$c311 = "]",
      peg$c312 = peg$literalExpectation("]", false),
      peg$c313 = function(singledimenson) {
          return [singledimenson ? singledimenson[3] : ''];
      	},
      peg$c314 = function(multidimenson) {
          // this will parse into Array(Array('[', _ , expression , _ ']'))
          return multidimenson.map((dimension) => dimension[2]);
        },
      peg$c315 = function(val) { return { value: val, type: 'string' }},
      peg$c316 = function(val) { return { value: val, type: 'number' }},
      peg$c317 = function(val) { return { value: val, type: 'boolean' }},
      peg$c318 = function(val) { 
      		let str = val;
      		if (val && val.length > 2 && val[0] === '(' && val[val.length - 1] === ')') {
      			str = val.slice(1, -1);
      		}
      		return {
      			value: str,
      			type: 'expression'
      		};
      	},
      peg$c319 = " ",
      peg$c320 = peg$literalExpectation(" ", false),
      peg$c321 = "\t",
      peg$c322 = peg$literalExpectation("\t", false),
      peg$c323 = ";",
      peg$c324 = peg$literalExpectation(";", false),
      peg$c325 = peg$otherExpectation("endline"),
      peg$c326 = peg$otherExpectation("newline"),
      peg$c327 = "\r\n",
      peg$c328 = peg$literalExpectation("\r\n", false),
      peg$c329 = "\n",
      peg$c330 = peg$literalExpectation("\n", false),
      peg$c331 = peg$otherExpectation("space"),
      peg$c332 = peg$otherExpectation("comment"),
      peg$c333 = "--",
      peg$c334 = peg$literalExpectation("--", false),
      peg$c335 = /^[^\n]/,
      peg$c336 = peg$classExpectation(["\n"], true, false),
      peg$c337 = "/*",
      peg$c338 = peg$literalExpectation("/*", false),
      peg$c339 = "*/",
      peg$c340 = peg$literalExpectation("*/", false),
      peg$c341 = peg$otherExpectation("letter, number or underscore"),
      peg$c342 = /^[a-z0-9_]/i,
      peg$c343 = peg$classExpectation([["a", "z"], ["0", "9"], "_"], false, true),
      peg$c344 = "&&",
      peg$c345 = peg$literalExpectation("&&", false),
      peg$c346 = "=",
      peg$c347 = peg$literalExpectation("=", false),
      peg$c348 = function(table_name, table_properties) {
      		const table = { name: table_name.name, schemaName: table_name.schemaName, fields: [], indexes: [] }
      		// process table_properties
      		table_properties.forEach(({ table_property_name, value }) => {
      			switch(table_property_name.toLowerCase()) {
      				case "column":
      					// if column contains inline_refs
      					// if(value.inline_refs && value.inline_refs.length > 0) {
      					// 	value.inline_refs.forEach(({ endpoints }) => {
      					// 		endpoints[0].tableName = table_name;
      					// 	})
      					// }
      					table.fields.push(value);
      					break;
      				case "table_constraint":
      					const { type, t_value } = value;
      					switch (type.toLowerCase()) {
      						case "unique": // set property unique for column
      							t_value.forEach(value => {
      								const field = table.fields.find(field => field.name === value);
      								if(field) {
      									field.unique = true;
      								} else {
      									//throw Error(`${table_name}: UNIQUE - Can not find column ${value}.`);
      								}
      							})
      							break;
      						case "pk": // set property pk for column, pk: PRIMARY KEY
      							t_value.forEach(value => {
      								const field = table.fields.find(field => field.name === value);
      								if(field) {
      									field.pk = true;
      								} else {
      									//throw Error(`${table_name}: PRIMARY KEY - Can not find column ${value}.`);
      								}
      							})
      							break;
      						case "fk": // set inline_ref for column
      							t_value.forEach((ref) => {
      								const { fieldNames } = ref.endpoints[0];
      								// set tableName for endpoints[0];
      								// endpoints[0].tableName = table_name;
      								const field = table.fields.find(field => field.name === fieldNames[0]);
      								if(!field) {
      									//throw Error(`${table_name}: FOREIGN KEY - Can not find column ${fieldNames}`);
      								}
      								if(!field.inline_refs) {
      									field.inline_refs = [];
      								}
      								field.inline_refs.push({
      									endpoint: ref.endpoints[1],
      									onDelete: ref.onDelete,
      									onUpdate: ref.onUpdate
      								});
      							})
      							break;
      					}
      					break;
      				case "like":
      					break;
      			}
      		})
      		return {
      			syntax_name: "create_table_normal",
      			value: table
      		}
      	},
      peg$c349 = function(first, rest) {
      	return [first, ...rest.map(r => r[3])];
      },
      peg$c350 = function(table_constraint) {
      		return {
      			table_property_name: "table_constraint",
      			value: table_constraint
      		}
      	},
      peg$c351 = function(source_table) {
      		return {
      			table_property_name: "like",
      			value: source_table
      		}
      	},
      peg$c352 = function(column_name, data_type, column_constraints) {
      		const column = { name: column_name , type: data_type};
      		
      		// process type (if type === "serial")
      		if (column.type.type_name.toLowerCase() === "serial") {
      			column.type.type_name = "int";
      			column.increment = true;
      		}

      		// map from grammar to right object
      		column_constraints = column_constraints.map(c => c[1]);
      		// process column_constraints
      		column_constraints.forEach(({ type, value }) => {
      			switch(type.toLowerCase()) {
      				case "not_null":
      					column.not_null = value;
      					break;
      				case "dbdefault":
      					column.dbdefault = value;
      					break;
      				case "unique":
      					column.unique = true;
      					break;
      				case "pk":
      					column.pk  = true;
      					break;
      				case "fk":
      					if (!column.inline_refs) {
      						column.inline_refs = [];
      					}
      					column.inline_refs.push(value);
      					break;
      			}
      		})
      		return {
      			table_property_name: "column",
      			value: column
      		}
      	},
      peg$c353 = function() { return { type: "not_null" , value: true } },
      peg$c354 = function() { return { type: "not_null" , value: false } },
      peg$c355 = function() { return { type: "not_supported" } },
      peg$c356 = function(default_expr) { return { type: "dbdefault", value: default_expr } },
      peg$c357 = function() { return { type: "unique" } },
      peg$c358 = function() { return { type: "pk" } },
      peg$c359 = function(reftable, refcolumn) {return refcolumn},
      peg$c360 = function(reftable, refcolumn, fk_actions) {
      			let ref_actions = {};

      			fk_actions.forEach(fkAction => {
      				if (fkAction.type === 'delete') {
      						ref_actions.onDelete = fkAction.action;
      						return;
      					}
      					ref_actions.onUpdate = fkAction.action;
      			});

      			return {
      				type: "fk",
      				value: {
      					endpoint: {
      						tableName: reftable.name,
                  schemaName: reftable.schemaName,
      						fieldNames: refcolumn ? [refcolumn] : null,
      						relation: "1"
      					},
      					...ref_actions
      				}
      			}
      		},
      peg$c361 = function(column_constraint) {
      		return column_constraint;
      	},
      peg$c362 = function() { return { type:"not_supported" } },
      peg$c363 = function(column_names) { return { type: "unique", t_value: column_names } },
      peg$c364 = function(column_names) { return { type: "pk", t_value: column_names } },
      peg$c365 = function() { return { type: "not_supported" }},
      peg$c366 = function(column_names, reftable, refcolumn) {return refcolumn},
      peg$c367 = function(column_names, reftable, refcolumn, fk_actions) {
      			const value = [];
      			if(refcolumn && refcolumn.length > column_names.length) {
      				//throw Error(`Line ${location().start.line}: There are extra ${refcolumn.length - column_names.length} refer column(s) not matched.`);
      			}
      			//if(refcolumn && key >= refcolumn.length) {
      				//throw Error(`Line ${location().start.line}: ${column_name} do not have referenced column.`)
      			//}
      			const v = {
      				endpoints: [
      					{
      						tableName: null,
      						fieldNames: column_names,
      						relation: "*",
      					},
      					{
      						tableName: reftable.name,
                  schemaName: reftable.schemaName,
      						fieldNames: refcolumn,// ? refcolumn[key] : null,
      						relation: "1",
      					},
      				],
      			};
      			fk_actions.forEach(fkAction => {
      				if (fkAction.type === 'delete') {
      					v.onDelete = fkAction.action;
      					return;
      				}
      				v.onUpdate = fkAction.action;
      			});
      			value.push(v);
      			return {
      				type: "fk",
      				t_value: value 
      			}
      		},
      peg$c368 = function(table_constraint) {
      		return table_constraint
      	},
      peg$c369 = function(type, action) { return { type: type.toLowerCase(), action: action.toLowerCase() } },
      peg$c370 = "restrict",
      peg$c371 = peg$literalExpectation("RESTRICT", true),
      peg$c372 = "cascade",
      peg$c373 = peg$literalExpectation("CASCADE", true),
      peg$c374 = "action",
      peg$c375 = peg$literalExpectation("ACTION", true),
      peg$c376 = "btree",
      peg$c377 = peg$literalExpectation("BTREE", true),
      peg$c378 = "gist",
      peg$c379 = peg$literalExpectation("GIST", true),
      peg$c380 = "gin",
      peg$c381 = peg$literalExpectation("GIN", true),
      peg$c382 = "brin",
      peg$c383 = peg$literalExpectation("BRIN", true),
      peg$c384 = "sp-gist",
      peg$c385 = peg$literalExpectation("SP-GIST", true),
      peg$c386 = function(index_method) {
      	return index_method;
      },
      peg$c387 = function(index_parameters) {
      		return index_parameters;
      	},
      peg$c388 = "fillfactor",
      peg$c389 = peg$literalExpectation("fillfactor", true),
      peg$c390 = "parallel_worlers",
      peg$c391 = peg$literalExpectation("parallel_worlers", true),
      peg$c392 = "autovacuum_enabled",
      peg$c393 = peg$literalExpectation("autovacuum_enabled", true),
      peg$c394 = "toast.autovacuum_enabled",
      peg$c395 = peg$literalExpectation("toast.autovacuum_enabled", true),
      peg$c396 = "autovacuum_vacuum_threshold",
      peg$c397 = peg$literalExpectation("autovacuum_vacuum_threshold", true),
      peg$c398 = "toast.autovacuum_vacuum_threshold",
      peg$c399 = peg$literalExpectation("toast.autovacuum_vacuum_threshold", true),
      peg$c400 = "autovacuum_vacuum_scale_factor",
      peg$c401 = peg$literalExpectation("autovacuum_vacuum_scale_factor", true),
      peg$c402 = "toast.autovacuum_vacuum_scale_factor",
      peg$c403 = peg$literalExpectation("toast.autovacuum_vacuum_scale_factor", true),
      peg$c404 = "autovacuum_analyze_threshold",
      peg$c405 = peg$literalExpectation("autovacuum_analyze_threshold", true),
      peg$c406 = "autovacuum_analyze_scale_factor",
      peg$c407 = peg$literalExpectation("autovacuum_analyze_scale_factor", true),
      peg$c408 = "autovacuum_vacuum_cost_delay",
      peg$c409 = peg$literalExpectation("autovacuum_vacuum_cost_delay", true),
      peg$c410 = "toast.autovacuum_vacuum_cost_delay",
      peg$c411 = peg$literalExpectation("toast.autovacuum_vacuum_cost_delay", true),
      peg$c412 = "autovacuum_vacuum_cost_limit",
      peg$c413 = peg$literalExpectation("autovacuum_vacuum_cost_limit", true),
      peg$c414 = "toast.autovacuum_vacuum_cost_limit",
      peg$c415 = peg$literalExpectation("toast.autovacuum_vacuum_cost_limit", true),
      peg$c416 = "autovacuum_freeze_min_age",
      peg$c417 = peg$literalExpectation("autovacuum_freeze_min_age", true),
      peg$c418 = "toast.autovacuum_freeze_min_age",
      peg$c419 = peg$literalExpectation("toast.autovacuum_freeze_min_age", true),
      peg$c420 = "autovacuum_freeze_max_age",
      peg$c421 = peg$literalExpectation("autovacuum_freeze_max_age", true),
      peg$c422 = "toast.autovacuum_freeze_max_age",
      peg$c423 = peg$literalExpectation("toast.autovacuum_freeze_max_age", true),
      peg$c424 = "autovacuum_freeze_table_age",
      peg$c425 = peg$literalExpectation("autovacuum_freeze_table_age", true),
      peg$c426 = "toast.autovacuum_freeze_table_age",
      peg$c427 = peg$literalExpectation("toast.autovacuum_freeze_table_age", true),
      peg$c428 = "autovacuum_multixact_freeze_min_age",
      peg$c429 = peg$literalExpectation("autovacuum_multixact_freeze_min_age", true),
      peg$c430 = "toast.autovacuum_multixact_freeze_min_age",
      peg$c431 = peg$literalExpectation("toast.autovacuum_multixact_freeze_min_age", true),
      peg$c432 = "autovacuum_multixact_freeze_max_age",
      peg$c433 = peg$literalExpectation("autovacuum_multixact_freeze_max_age", true),
      peg$c434 = "toast.autovacuum_multixact_freeze_max_age",
      peg$c435 = peg$literalExpectation("toast.autovacuum_multixact_freeze_max_age", true),
      peg$c436 = "autovacuum_multixact_freeze_table_age",
      peg$c437 = peg$literalExpectation("autovacuum_multixact_freeze_table_age", true),
      peg$c438 = "toast.autovacuum_multixact_freeze_table_age",
      peg$c439 = peg$literalExpectation("toast.autovacuum_multixact_freeze_table_age", true),
      peg$c440 = "log_autovacuum_min_duration",
      peg$c441 = peg$literalExpectation("log_autovacuum_min_duration", true),
      peg$c442 = "toast.log_autovacuum_min_duration",
      peg$c443 = peg$literalExpectation("toast.log_autovacuum_min_duration", true),
      peg$c444 = "user_catalog_table",
      peg$c445 = peg$literalExpectation("user_catalog_table", true),
      peg$c446 = function(table_name, type_name) {
      		const table = { name: table_name.name, schemaName: table_name.schemaName, type: type_name}
      		return {
      			syntax_name: "create_table_of",
      			value: table
      		}
      	},
      peg$c447 = function(column_name, column_constraints) {
      		return {
      			table_property_name: "table_constraint",
      			value: {
      				name: column_name,
      				column_constraints
      			}
      		}
      	},
      peg$c448 = function(table_name, parent_table) {
      		const table = { name: table_name.name, schemaName: table_name.schemaName, parent_table: parent_table}
      		return {
      			syntax_name: "create_table_partition_of",
      			value: table
      		}
      	},
      peg$c449 = function(create_table_normal) {
          return {
            command_name: "create_table",
            value: create_table_normal
          }
        },
      peg$c450 = function(create_table_of) {
          return {
            command_name: "create_table",
            value: create_table_of
          }
        },
      peg$c451 = function(create_table_partition_of) {
          return {
            command_name: "create_table",
            value: create_table_partition_of
          }
        },
      peg$c452 = function(enumName, labels) {
      		const values = labels.map(name => ({ name }))
      		return {
      			syntax_name: "create_type_enum",
      			value: {
      				...enumName,
      				values,
      			}
      		}
      	},
      peg$c453 = function(first, rest) {
      	return [first, ...rest.map(r => r[3])]
      },
      peg$c454 = function(name, subtype) {
      		return {
      			syntax_name: "create_table_range"
      		}
      	},
      peg$c455 = function(create_type_enum) {
      		return {
      			command_name: "create_type",
      			value: create_type_enum
      		}
      	},
      peg$c456 = function(create_type_range) {
      		return {
      			command_name: "create_type",
      			value: create_type_range
      		}
      	},
      peg$c457 = function(alter_sub_syntax) {
      	return {
      		command_name: "alter_table",
      		value: alter_sub_syntax
      	}
      },
      peg$c458 = "*",
      peg$c459 = peg$literalExpectation("*", false),
      peg$c460 = function() {
      	return {
      		syntax_name: "alter_table_rename",
      	}
      },
      peg$c461 = function() {
      	return {
      		syntax_name: "alter_table_set_schema",
      	}
      },
      peg$c462 = function() {
      	return {
      		syntax_name: "alter_set_tablespace",
      	}
      },
      peg$c463 = function() {
      	return {
      		syntax_name: "alter_table_attach",
      	}
      },
      peg$c464 = function() {
      	return {
      		syntax_name: "alter_table_detach",
      	}
      },
      peg$c465 = function(name, actions) {
      		actions.forEach(({ type, t_value}) => {
      			switch(type.toLowerCase()) {
      				case "fk":
      					t_value.forEach(({ endpoints }) => {
      						endpoints[0].tableName = name.name;
      						endpoints[0].schemaName = name.schemaName;
      					})
      			}
      		})
      		return {
      			syntax_name: "alter_table_action",
      			value: actions
      		}
      	},
      peg$c466 = function(table_constraint) { // reuse table_constraint in Create_table_normal.pegjs
      		return table_constraint;
      	},
      peg$c467 = function(column_name, data_type, e) {return e},
      peg$c468 = function(column_name, data_type, expression) {
      		return {
      			type: "type",
      			expression
      		}
      	},
      peg$c469 = function(column_name, expression) {
      		return {
      			type: "set_default",
      			expression
      		}
      	},
      peg$c470 = function(column_name) {
      		return {
      			type: "drop_default"
      		}
      	},
      peg$c471 = function(column_name, action) {
      		if(action.toUpperCase() === "SET") {
      			return {
      				type: "set_not_null"
      			}	
      		} else {
      			return {
      				type: "drop_not_null"
      			}	
      		}
      	},
      peg$c472 = function(column_name, value) {
      		return {
      			type: "set_statistics",
      			value
      		}
      	},
      peg$c473 = function(column_name) {
      		return {
      			type: "set_options"
      		}
      	},
      peg$c474 = function(column_name) {
      		return {
      			type: "reset_options"
      		}
      	},
      peg$c475 = function(column_name, value) {
      		return {
      			type: "set_storage",
      			value: value.toLowerCase()
      		}
      	},
      peg$c476 = function() {
      		return {
      			type: "unknown",
      		}
      	},
      peg$c477 = /^[^,;]/,
      peg$c478 = peg$classExpectation([",", ";"], true, false),
      peg$c479 = function(c) {
      	return removeReduntdantSpNewline(c.join(''));
      },
      peg$c480 = function(unique) {return null},
      peg$c481 = function(unique, name) {return name},
      peg$c482 = function(unique, name, table_name, type) {return type},
      peg$c483 = function(unique, name, table_name, type, index_properties) {
      		const value = {
      			syntax_name: "create_table",
      			value: {
      				table_name,
      		 		columns: index_properties
      			}
      		}

      		if (name)
      			value.value.name = name;
      		
      		if (unique)
      			value.value.unique = true;

      		if (type)
      			value.value.type = type.toUpperCase();

      		return {
      			command_name: "create_index",
      			value
      		}		
      	},
      peg$c484 = function(c, c1) {return {value: `${c}(${removeReduntdantSpNewline(_.flattenDeep(c1).join(""))})`, type: "expression" }},
      peg$c485 = function(c) { return {value: `${c}`, type: "string" }},
      peg$c486 = function(e) {return { value:`${e}`, type: "expression"}},
      peg$c487 = "COLLATE",
      peg$c488 = peg$literalExpectation("COLLATE", false),
      peg$c489 = "ASC",
      peg$c490 = peg$literalExpectation("ASC", false),
      peg$c491 = "DESC",
      peg$c492 = peg$literalExpectation("DESC", false),
      peg$c493 = "NULLS",
      peg$c494 = peg$literalExpectation("NULLS", false),
      peg$c495 = "FIRST",
      peg$c496 = peg$literalExpectation("FIRST", false),
      peg$c497 = "LAST",
      peg$c498 = peg$literalExpectation("LAST", false),
      peg$c499 = function(column) {
      	return column;
      },
      peg$c500 = "vacuum_cleanup_index_scale_factor",
      peg$c501 = peg$literalExpectation("vacuum_cleanup_index_scale_factor", true),
      peg$c502 = "buffering",
      peg$c503 = peg$literalExpectation("buffering", true),
      peg$c504 = "fastupdate",
      peg$c505 = peg$literalExpectation("fastupdate", true),
      peg$c506 = "gin_pending_list_limit",
      peg$c507 = peg$literalExpectation("gin_pending_list_limit", true),
      peg$c508 = "pages_per_range",
      peg$c509 = peg$literalExpectation("pages_per_range", true),
      peg$c510 = "autosummarize",
      peg$c511 = peg$literalExpectation("autosummarize", true),
      peg$c512 = function(comment_option, text) {
        if (text.toLowerCase() !== "null") {
          comment_option.value.text = text;
        } else comment_option.value.text = null;

        return {
          command_name: "comment",
          value: comment_option
        }
      },
      peg$c513 = function(path, column_name) {
          let dbName = null, schemaName = null, tableName;
          if (path.length === 1) {
            tableName = path[0][0];
          } else if (path.length === 2) {
            schemaName = path[0][0];
            tableName = path[1][0];
          }
          else {
            dbName = path[0][0];
            schemaName = path[1][0];
            tableName = path[2][0];
          }
          return {
            syntax_name: "column",
            value: {
              dbName,
              schemaName,
              tableName,
              columnName: column_name
            }
          }
        },
      peg$c514 = function(object_name) {
          return {
            syntax_name: "table",
            value: {
              table_name: object_name
            }
          }
        },
      peg$c515 = /^[^;]/,
      peg$c516 = peg$classExpectation([";"], true, false),
      peg$c517 = function() { return { syntax_name: "insert" } },
      peg$c518 = function() { return { syntax_name: "set" } },
      peg$c519 = function() { return { syntax_name: "reset" } },
      peg$c520 = function() { return { syntax_name: "select" } },
      peg$c521 = function() { return { syntax_name: "drop" } },
      peg$c522 = function() { return { syntax_name: "use" } },
      peg$c523 = function() { return { syntax_name: "create_sequence" } },
      peg$c524 = function() { return { syntax_name: "create_schema" } },
      peg$c525 = function() { return { syntax_name: "create_view" } },
      peg$c526 = function() { return { syntax_name: "alter_not_table" } },
      peg$c527 = function() { return { syntax_name: "comment_and_space" } },
      peg$c528 = function(value) {
        const loc = location();
        const t = text();
        return {
          command_name: "ignore_syntax",
          value,
          warning: {
            type: 'ignore',
            location: loc,
            text: t,
            message: `ignoring "${t}" at line: ${loc.start.line}`,
          },
        }
      },
      peg$c529 = function(create_table) { return create_table },
      peg$c530 = function(create_type) { return create_type },
      peg$c531 = function(alter_table) { return alter_table },
      peg$c532 = function(create_index) { return create_index },
      peg$c533 = function(comment) { return comment },
      peg$c534 = function(ignore_syntax) { return ignore_syntax },

      peg$currPos          = 0,
      peg$savedPos         = 0,
      peg$posDetailsCache  = [{ line: 1, column: 1 }],
      peg$maxFailPos       = 0,
      peg$maxFailExpected  = [],
      peg$silentFails      = 0,

      peg$result;

  if ("startRule" in options) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location
    );
  }

  function error(message, location) {
    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)

    throw peg$buildSimpleError(message, location);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$anyExpectation() {
    return { type: "any" };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos], p;

    if (details) {
      return details;
    } else {
      p = pos - 1;
      while (!peg$posDetailsCache[p]) {
        p--;
      }

      details = peg$posDetailsCache[p];
      details = {
        line:   details.line,
        column: details.column
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;
      return details;
    }
  }

  function peg$computeLocation(startPos, endPos) {
    var startPosDetails = peg$computePosDetails(startPos),
        endPosDetails   = peg$computePosDetails(endPos);

    return {
      start: {
        offset: startPos,
        line:   startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line:   endPosDetails.line,
        column: endPosDetails.column
      }
    };
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) { return; }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(
      peg$SyntaxError.buildMessage(expected, found),
      expected,
      found,
      location
    );
  }

  function peg$parseparser() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsecommand();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsecommand();
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c0(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseCREATE() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c1) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c2); }
    }

    return s0;
  }

  function peg$parseALTER() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c3) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c4); }
    }

    return s0;
  }

  function peg$parseUNIQUE() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c5) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c6); }
    }

    return s0;
  }

  function peg$parseINDEX() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c7) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c8); }
    }

    return s0;
  }

  function peg$parseTYPE() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c9) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c10); }
    }

    return s0;
  }

  function peg$parseENUM() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c11) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c12); }
    }

    return s0;
  }

  function peg$parseCONCURRENTLY() {
    var s0;

    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c13) {
      s0 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c14); }
    }

    return s0;
  }

  function peg$parseFOREIGN_KEY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c15) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c16); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 3).toLowerCase() === peg$c17) {
          s3 = input.substr(peg$currPos, 3);
          peg$currPos += 3;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c18); }
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseREFERENCES() {
    var s0;

    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c19) {
      s0 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c20); }
    }

    return s0;
  }

  function peg$parseON() {
    var s0;

    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c21) {
      s0 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c22); }
    }

    return s0;
  }

  function peg$parseUSING() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c23) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c24); }
    }

    return s0;
  }

  function peg$parseTABLE() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c25) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c26); }
    }

    return s0;
  }

  function peg$parseIF_NOT_EXISTS() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c27) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c28); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 3).toLowerCase() === peg$c29) {
          s3 = input.substr(peg$currPos, 3);
          peg$currPos += 3;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c30); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          if (s4 !== peg$FAILED) {
            if (input.substr(peg$currPos, 6).toLowerCase() === peg$c31) {
              s5 = input.substr(peg$currPos, 6);
              peg$currPos += 6;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c32); }
            }
            if (s5 !== peg$FAILED) {
              s1 = [s1, s2, s3, s4, s5];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseIF_EXISTS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c27) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c28); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 6).toLowerCase() === peg$c31) {
          s3 = input.substr(peg$currPos, 6);
          peg$currPos += 6;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c32); }
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseGLOBAL() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c33) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c34); }
    }

    return s0;
  }

  function peg$parseLOCAL() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c35) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c36); }
    }

    return s0;
  }

  function peg$parseTEMPORARY() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c37) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c38); }
    }

    return s0;
  }

  function peg$parseTEMP() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c39) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c40); }
    }

    return s0;
  }

  function peg$parseUNLOGGED() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c41) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c42); }
    }

    return s0;
  }

  function peg$parseCOLLATE() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c43) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c44); }
    }

    return s0;
  }

  function peg$parseCOLLATION() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c45) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c46); }
    }

    return s0;
  }

  function peg$parsePARTITION() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c47) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c48); }
    }

    return s0;
  }

  function peg$parseBY() {
    var s0;

    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c49) {
      s0 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c50); }
    }

    return s0;
  }

  function peg$parseRANGE() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c51) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c52); }
    }

    return s0;
  }

  function peg$parseLIST() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c53) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c54); }
    }

    return s0;
  }

  function peg$parseHASH() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c55) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c56); }
    }

    return s0;
  }

  function peg$parseLIKE() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c57) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c58); }
    }

    return s0;
  }

  function peg$parseINHERITS() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c59) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c60); }
    }

    return s0;
  }

  function peg$parseINHERIT() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c61) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c62); }
    }

    return s0;
  }

  function peg$parseWITH() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c63) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c64); }
    }

    return s0;
  }

  function peg$parseWITHOUT() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c65) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c66); }
    }

    return s0;
  }

  function peg$parseOIDS() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c67) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c68); }
    }

    return s0;
  }

  function peg$parseCOMMIT() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c69) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c70); }
    }

    return s0;
  }

  function peg$parsePRESERVE() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c71) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c72); }
    }

    return s0;
  }

  function peg$parseROWS() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c73) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c74); }
    }

    return s0;
  }

  function peg$parseDELETE() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c75) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c76); }
    }

    return s0;
  }

  function peg$parseDROP() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c77) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c78); }
    }

    return s0;
  }

  function peg$parseTABLESPACE() {
    var s0;

    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c79) {
      s0 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c80); }
    }

    return s0;
  }

  function peg$parseCONSTRAINT() {
    var s0;

    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c81) {
      s0 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c82); }
    }

    return s0;
  }

  function peg$parseNO() {
    var s0;

    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c83) {
      s0 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c84); }
    }

    return s0;
  }

  function peg$parseNOT() {
    var s0;

    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c29) {
      s0 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c30); }
    }

    return s0;
  }

  function peg$parseNULL() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c85) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c86); }
    }

    return s0;
  }

  function peg$parseCHECK() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c87) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c88); }
    }

    return s0;
  }

  function peg$parseDEFAULT() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c89) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c90); }
    }

    return s0;
  }

  function peg$parsePRIMARY_KEY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c91) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c92); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 3).toLowerCase() === peg$c17) {
          s3 = input.substr(peg$currPos, 3);
          peg$currPos += 3;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c18); }
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseMATCH() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c93) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c94); }
    }

    return s0;
  }

  function peg$parseFULL() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c95) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c96); }
    }

    return s0;
  }

  function peg$parsePARTIAL() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c97) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c98); }
    }

    return s0;
  }

  function peg$parseSIMPLE() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c99) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c100); }
    }

    return s0;
  }

  function peg$parseUPDATE() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c101) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c102); }
    }

    return s0;
  }

  function peg$parseDEFERRABLE() {
    var s0;

    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c103) {
      s0 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c104); }
    }

    return s0;
  }

  function peg$parseINITIALLY() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c105) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c106); }
    }

    return s0;
  }

  function peg$parseDEFERRED() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c107) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c108); }
    }

    return s0;
  }

  function peg$parseIMMEDIATE() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c109) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c110); }
    }

    return s0;
  }

  function peg$parseEXCLUDE() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c111) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c112); }
    }

    return s0;
  }

  function peg$parseWHERE() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c113) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c114); }
    }

    return s0;
  }

  function peg$parseINCLUDING() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c115) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c116); }
    }

    return s0;
  }

  function peg$parseEXCLUDING() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c117) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c118); }
    }

    return s0;
  }

  function peg$parseCOMMENTS() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c119) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c120); }
    }

    return s0;
  }

  function peg$parseCONSTRAINTS() {
    var s0;

    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c121) {
      s0 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c122); }
    }

    return s0;
  }

  function peg$parseGENERATED() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c123) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c124); }
    }

    return s0;
  }

  function peg$parseALWAYS() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c125) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c126); }
    }

    return s0;
  }

  function peg$parseAS() {
    var s0;

    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c127) {
      s0 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c128); }
    }

    return s0;
  }

  function peg$parseADD() {
    var s0;

    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c129) {
      s0 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c130); }
    }

    return s0;
  }

  function peg$parseONLY() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c131) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c132); }
    }

    return s0;
  }

  function peg$parseDEFAULTS() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c133) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c134); }
    }

    return s0;
  }

  function peg$parseIDENTITY() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c135) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c136); }
    }

    return s0;
  }

  function peg$parseINDEXES() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c137) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c138); }
    }

    return s0;
  }

  function peg$parseSTATISTICS() {
    var s0;

    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c139) {
      s0 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c140); }
    }

    return s0;
  }

  function peg$parseSTORAGE() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c141) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c142); }
    }

    return s0;
  }

  function peg$parseINCLUDE() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c143) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c144); }
    }

    return s0;
  }

  function peg$parseINCLUDES() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c145) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c146); }
    }

    return s0;
  }

  function peg$parseALL() {
    var s0;

    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c147) {
      s0 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c148); }
    }

    return s0;
  }

  function peg$parseOF() {
    var s0;

    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c149) {
      s0 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c150); }
    }

    return s0;
  }

  function peg$parseOPTIONS() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c151) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c152); }
    }

    return s0;
  }

  function peg$parseFOR() {
    var s0;

    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c153) {
      s0 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c154); }
    }

    return s0;
  }

  function peg$parseVALUES() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c155) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c156); }
    }

    return s0;
  }

  function peg$parseIN() {
    var s0;

    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c157) {
      s0 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c158); }
    }

    return s0;
  }

  function peg$parseFROM() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c159) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c160); }
    }

    return s0;
  }

  function peg$parseTO() {
    var s0;

    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c161) {
      s0 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c162); }
    }

    return s0;
  }

  function peg$parseMODULUS() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c163) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c164); }
    }

    return s0;
  }

  function peg$parseREMAINDER() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c165) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c166); }
    }

    return s0;
  }

  function peg$parseTRUE() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c167) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c168); }
    }

    return s0;
  }

  function peg$parseFALSE() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c169) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c170); }
    }

    return s0;
  }

  function peg$parseMAXVALUE() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c171) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c172); }
    }

    return s0;
  }

  function peg$parseMINVALUE() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c173) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c174); }
    }

    return s0;
  }

  function peg$parseSUBTYPE() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c175) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c176); }
    }

    return s0;
  }

  function peg$parseSUBTYPE_OPCLASS() {
    var s0;

    if (input.substr(peg$currPos, 15).toLowerCase() === peg$c177) {
      s0 = input.substr(peg$currPos, 15);
      peg$currPos += 15;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c178); }
    }

    return s0;
  }

  function peg$parseCANONICAL() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c179) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c180); }
    }

    return s0;
  }

  function peg$parseSUBTYPE_DIFF() {
    var s0;

    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c181) {
      s0 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c182); }
    }

    return s0;
  }

  function peg$parseVALID() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c183) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c184); }
    }

    return s0;
  }

  function peg$parseCOLUMN() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c185) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c186); }
    }

    return s0;
  }

  function peg$parseSET() {
    var s0;

    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c187) {
      s0 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c188); }
    }

    return s0;
  }

  function peg$parseDATA() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c189) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c190); }
    }

    return s0;
  }

  function peg$parseRESET() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c191) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c192); }
    }

    return s0;
  }

  function peg$parsePLAIN() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c193) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c194); }
    }

    return s0;
  }

  function peg$parseEXTERNAL() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c195) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c196); }
    }

    return s0;
  }

  function peg$parseEXTENDED() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c197) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c198); }
    }

    return s0;
  }

  function peg$parseMAIN() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c199) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c200); }
    }

    return s0;
  }

  function peg$parseASC() {
    var s0;

    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c201) {
      s0 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c202); }
    }

    return s0;
  }

  function peg$parseDESC() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c203) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c204); }
    }

    return s0;
  }

  function peg$parseNULLS() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c205) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c206); }
    }

    return s0;
  }

  function peg$parseFIRST() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c207) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c208); }
    }

    return s0;
  }

  function peg$parseLAST() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c209) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c210); }
    }

    return s0;
  }

  function peg$parseCOMMENT() {
    var s0;

    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c211) {
      s0 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c212); }
    }

    return s0;
  }

  function peg$parseIS() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c213) {
      s0 = peg$c213;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c214); }
    }

    return s0;
  }

  function peg$parseINSERT() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c215) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c216); }
    }

    return s0;
  }

  function peg$parseSELECT() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c217) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c218); }
    }

    return s0;
  }

  function peg$parseUSE() {
    var s0;

    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c219) {
      s0 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c220); }
    }

    return s0;
  }

  function peg$parseSEQUENCE() {
    var s0;

    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c221) {
      s0 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c222); }
    }

    return s0;
  }

  function peg$parseSCHEMA() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c223) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c224); }
    }

    return s0;
  }

  function peg$parseVIEW() {
    var s0;

    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c225) {
      s0 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c226); }
    }

    return s0;
  }

  function peg$parseRENAME() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c227) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c228); }
    }

    return s0;
  }

  function peg$parseOWNED() {
    var s0;

    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c229) {
      s0 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c230); }
    }

    return s0;
  }

  function peg$parseATTACH() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c231) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c232); }
    }

    return s0;
  }

  function peg$parseDETACH() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c233) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c234); }
    }

    return s0;
  }

  function peg$parseexpression() {
    var s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsefactor();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsefactor();
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c236(s1);
    }
    s0 = s1;
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c235); }
    }

    return s0;
  }

  function peg$parsefactor() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = [];
    s3 = peg$parsecharacter();
    if (s3 !== peg$FAILED) {
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsecharacter();
      }
    } else {
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parse_();
      if (s3 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 40) {
          s4 = peg$c237;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c238); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parseexpression();
          if (s5 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 41) {
              s6 = peg$c239;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c240); }
            }
            if (s6 !== peg$FAILED) {
              s2 = [s2, s3, s4, s5, s6];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 40) {
        s2 = peg$c237;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c238); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseexpression();
        if (s3 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 41) {
            s4 = peg$c239;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c240); }
          }
          if (s4 !== peg$FAILED) {
            s2 = [s2, s3, s4];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = peg$currPos;
        s2 = [];
        s3 = peg$parseexprCharNoCommaSpace();
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseexprCharNoCommaSpace();
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          peg$silentFails++;
          s4 = peg$parse_();
          if (s4 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 44) {
              s4 = peg$c241;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c242); }
            }
            if (s4 === peg$FAILED) {
              if (input.substr(peg$currPos, 2) === peg$c243) {
                s4 = peg$c243;
                peg$currPos += 2;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c244); }
              }
              if (s4 === peg$FAILED) {
                s4 = peg$currPos;
                s5 = peg$parseendline();
                if (s5 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 2) === peg$c243) {
                    s6 = peg$c243;
                    peg$currPos += 2;
                  } else {
                    s6 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c244); }
                  }
                  if (s6 !== peg$FAILED) {
                    s5 = [s5, s6];
                    s4 = s5;
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              }
            }
          }
          peg$silentFails--;
          if (s4 !== peg$FAILED) {
            peg$currPos = s3;
            s3 = void 0;
          } else {
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            s2 = [s2, s3];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
        if (s1 === peg$FAILED) {
          s1 = peg$currPos;
          s2 = [];
          s3 = peg$parseexprChar();
          if (s3 !== peg$FAILED) {
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              s3 = peg$parseexprChar();
            }
          } else {
            s2 = peg$FAILED;
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$currPos;
            peg$silentFails++;
            if (input.length > peg$currPos) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c245); }
            }
            peg$silentFails--;
            if (s4 !== peg$FAILED) {
              peg$currPos = s3;
              s3 = void 0;
            } else {
              s3 = peg$FAILED;
            }
            if (s3 !== peg$FAILED) {
              s2 = [s2, s3];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c246(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseexprChar() {
    var s0;

    if (peg$c247.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c248); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsesp();
      if (s0 === peg$FAILED) {
        s0 = peg$parsenewline();
        if (s0 === peg$FAILED) {
          s0 = peg$parsetab();
        }
      }
    }

    return s0;
  }

  function peg$parseexprCharNoCommaSpace() {
    var s0;

    if (peg$c249.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c250); }
    }

    return s0;
  }

  function peg$parsecolumn_name() {
    var s0, s1;

    peg$silentFails++;
    s0 = peg$parseidentifier();
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c251); }
    }

    return s0;
  }

  function peg$parsepath_name() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$currPos;
    s3 = peg$parseidentifier();
    if (s3 !== peg$FAILED) {
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 46) {
          s5 = peg$c252;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c253); }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s3 = [s3, s4, s5, s6];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$currPos;
      s3 = peg$parseidentifier();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 46) {
            s5 = peg$c252;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c253); }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s3 = [s3, s4, s5, s6];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c254(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsetable_name() {
    var s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parsepath_name();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseidentifier();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c256(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c255); }
    }

    return s0;
  }

  function peg$parseenum_name() {
    var s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parsepath_name();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseidentifier();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c256(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c257); }
    }

    return s0;
  }

  function peg$parsestring_constant() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 39) {
      s1 = peg$c259;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c260); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsechar_inside_single_quote();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsechar_inside_single_quote();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 39) {
          s3 = peg$c259;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c260); }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c261(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c258); }
    }

    return s0;
  }

  function peg$parsechar_inside_single_quote() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c262) {
      s1 = peg$c262;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c263); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c264();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      if (peg$c265.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c266); }
      }
    }

    return s0;
  }

  function peg$parseidentifier() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 34) {
      s1 = peg$c267;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c268); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsechar_inside_double_quote();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsechar_inside_double_quote();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 34) {
          s3 = peg$c267;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c268); }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c269(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parsecharacter();
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parsecharacter();
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c269(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsechar_inside_double_quote() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c270) {
      s1 = peg$c270;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c271); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c272();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      if (peg$c273.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c274); }
      }
    }

    return s0;
  }

  function peg$parsenumeric_constant() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parsedigits();
    if (s2 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 46) {
        s3 = peg$c252;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c253); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parsedigits();
        if (s4 === peg$FAILED) {
          s4 = null;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 101) {
            s6 = peg$c276;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c277); }
          }
          if (s6 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 43) {
              s7 = peg$c278;
              peg$currPos++;
            } else {
              s7 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c279); }
            }
            if (s7 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 45) {
                s7 = peg$c280;
                peg$currPos++;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c281); }
              }
            }
            if (s7 === peg$FAILED) {
              s7 = null;
            }
            if (s7 !== peg$FAILED) {
              s8 = peg$parsedigits();
              if (s8 !== peg$FAILED) {
                s6 = [s6, s7, s8];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          if (s5 !== peg$FAILED) {
            s2 = [s2, s3, s4, s5];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      s2 = peg$parsedigits();
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 46) {
          s3 = peg$c252;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c253); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsedigits();
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 101) {
              s6 = peg$c276;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c277); }
            }
            if (s6 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 43) {
                s7 = peg$c278;
                peg$currPos++;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c279); }
              }
              if (s7 === peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 45) {
                  s7 = peg$c280;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c281); }
                }
              }
              if (s7 === peg$FAILED) {
                s7 = null;
              }
              if (s7 !== peg$FAILED) {
                s8 = peg$parsedigits();
                if (s8 !== peg$FAILED) {
                  s6 = [s6, s7, s8];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s2 = [s2, s3, s4, s5];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = peg$currPos;
        s2 = peg$parsedigits();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 101) {
            s3 = peg$c276;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c277); }
          }
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 43) {
              s4 = peg$c278;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c279); }
            }
            if (s4 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 45) {
                s4 = peg$c280;
                peg$currPos++;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c281); }
              }
            }
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsedigits();
              if (s5 !== peg$FAILED) {
                s2 = [s2, s3, s4, s5];
                s1 = s2;
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c282(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parsedigits();
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c275); }
    }

    return s0;
  }

  function peg$parsedigits() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsedigit();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parsedigit();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c283(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsedigit() {
    var s0;

    if (peg$c284.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c285); }
    }

    return s0;
  }

  function peg$parsedata_type() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c287) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c288); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse_();
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 7).toLowerCase() === peg$c289) {
          s3 = input.substr(peg$currPos, 7);
          peg$currPos += 7;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c290); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 40) {
              s6 = peg$c237;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c238); }
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseexpression();
              if (s7 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 41) {
                  s8 = peg$c239;
                  peg$currPos++;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c240); }
                }
                if (s8 !== peg$FAILED) {
                  s6 = [s6, s7, s8];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parsearray_extension();
              if (s6 === peg$FAILED) {
                s6 = null;
              }
              if (s6 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c291(s1, s3, s5, s6);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 9).toLowerCase() === peg$c292) {
        s1 = input.substr(peg$currPos, 9);
        peg$currPos += 9;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c293); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 40) {
            s4 = peg$c237;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c238); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parse_();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsenumeric_constant();
              if (s6 !== peg$FAILED) {
                s7 = peg$parse_();
                if (s7 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s8 = peg$c239;
                    peg$currPos++;
                  } else {
                    s8 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c240); }
                  }
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parse_();
                    if (s9 !== peg$FAILED) {
                      s4 = [s4, s5, s6, s7, s8, s9];
                      s3 = s4;
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            if (input.substr(peg$currPos, 7).toLowerCase() === peg$c65) {
              s5 = input.substr(peg$currPos, 7);
              peg$currPos += 7;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c294); }
            }
            if (s5 === peg$FAILED) {
              if (input.substr(peg$currPos, 4).toLowerCase() === peg$c63) {
                s5 = input.substr(peg$currPos, 4);
                peg$currPos += 4;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c295); }
              }
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parse_();
              if (s6 !== peg$FAILED) {
                if (input.substr(peg$currPos, 4).toLowerCase() === peg$c296) {
                  s7 = input.substr(peg$currPos, 4);
                  peg$currPos += 4;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c297); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parse_();
                  if (s8 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c298) {
                      s9 = input.substr(peg$currPos, 4);
                      peg$currPos += 4;
                    } else {
                      s9 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c299); }
                    }
                    if (s9 !== peg$FAILED) {
                      s5 = [s5, s6, s7, s8, s9];
                      s4 = s5;
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parsearray_extension();
              if (s5 === peg$FAILED) {
                s5 = null;
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c300(s3, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c296) {
          s1 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c297); }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parse_();
          if (s2 !== peg$FAILED) {
            s3 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 40) {
              s4 = peg$c237;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c238); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                s6 = peg$parsenumeric_constant();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse_();
                  if (s7 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 41) {
                      s8 = peg$c239;
                      peg$currPos++;
                    } else {
                      s8 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c240); }
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = peg$parse_();
                      if (s9 !== peg$FAILED) {
                        s4 = [s4, s5, s6, s7, s8, s9];
                        s3 = s4;
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 === peg$FAILED) {
              s3 = null;
            }
            if (s3 !== peg$FAILED) {
              s4 = peg$currPos;
              if (input.substr(peg$currPos, 7).toLowerCase() === peg$c65) {
                s5 = input.substr(peg$currPos, 7);
                peg$currPos += 7;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c294); }
              }
              if (s5 === peg$FAILED) {
                if (input.substr(peg$currPos, 4).toLowerCase() === peg$c63) {
                  s5 = input.substr(peg$currPos, 4);
                  peg$currPos += 4;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c295); }
                }
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parse_();
                if (s6 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 4).toLowerCase() === peg$c296) {
                    s7 = input.substr(peg$currPos, 4);
                    peg$currPos += 4;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c297); }
                  }
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parse_();
                    if (s8 !== peg$FAILED) {
                      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c298) {
                        s9 = input.substr(peg$currPos, 4);
                        peg$currPos += 4;
                      } else {
                        s9 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c299); }
                      }
                      if (s9 !== peg$FAILED) {
                        s5 = [s5, s6, s7, s8, s9];
                        s4 = s5;
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
              if (s4 === peg$FAILED) {
                s4 = null;
              }
              if (s4 !== peg$FAILED) {
                s5 = peg$parsearray_extension();
                if (s5 === peg$FAILED) {
                  s5 = null;
                }
                if (s5 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c301(s3, s5);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parsetype_name();
          if (s1 !== peg$FAILED) {
            s2 = peg$parsearray_extension();
            if (s2 === peg$FAILED) {
              s2 = null;
            }
            if (s2 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c302(s1, s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parsedouble_quote();
            if (s1 !== peg$FAILED) {
              s2 = [];
              if (peg$c303.test(input.charAt(peg$currPos))) {
                s3 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c304); }
              }
              if (s3 !== peg$FAILED) {
                while (s3 !== peg$FAILED) {
                  s2.push(s3);
                  if (peg$c303.test(input.charAt(peg$currPos))) {
                    s3 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c304); }
                  }
                }
              } else {
                s2 = peg$FAILED;
              }
              if (s2 !== peg$FAILED) {
                s3 = peg$parsedouble_quote();
                if (s3 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c305(s2);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          }
        }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c286); }
    }

    return s0;
  }

  function peg$parsetype_name() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsepath_name();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsecharacter();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsecharacter();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 40) {
            s5 = peg$c237;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c238); }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseexpression();
            if (s6 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 41) {
                s7 = peg$c239;
                peg$currPos++;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c240); }
              }
              if (s7 !== peg$FAILED) {
                s5 = [s5, s6, s7];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c306(s1, s2, s4);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsearray_extension() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c307) {
        s2 = input.substr(peg$currPos, 5);
        peg$currPos += 5;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c308); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 91) {
            s5 = peg$c309;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c310); }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseexpression();
              if (s7 !== peg$FAILED) {
                s8 = peg$parse_();
                if (s8 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 93) {
                    s9 = peg$c311;
                    peg$currPos++;
                  } else {
                    s9 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c312); }
                  }
                  if (s9 !== peg$FAILED) {
                    s4 = [s4, s5, s6, s7, s8, s9];
                    s3 = s4;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c313(s3);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parse_();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 91) {
          s4 = peg$c309;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c310); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parse_();
          if (s5 !== peg$FAILED) {
            s6 = peg$parseexpression();
            if (s6 !== peg$FAILED) {
              s7 = peg$parse_();
              if (s7 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 93) {
                  s8 = peg$c311;
                  peg$currPos++;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c312); }
                }
                if (s8 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7, s8];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 91) {
              s4 = peg$c309;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c310); }
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parse_();
              if (s5 !== peg$FAILED) {
                s6 = peg$parseexpression();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse_();
                  if (s7 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 93) {
                      s8 = peg$c311;
                      peg$currPos++;
                    } else {
                      s8 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c312); }
                    }
                    if (s8 !== peg$FAILED) {
                      s4 = [s4, s5, s6, s7, s8];
                      s3 = s4;
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c314(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsedefault_expr() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsestring_constant();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c315(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsenumeric_constant();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c316(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c167) {
          s1 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c168); }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 5).toLowerCase() === peg$c169) {
            s1 = input.substr(peg$currPos, 5);
            peg$currPos += 5;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c170); }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 4).toLowerCase() === peg$c85) {
              s1 = input.substr(peg$currPos, 4);
              peg$currPos += 4;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c86); }
            }
          }
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c317(s1);
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parsefactor();
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c318(s1);
          }
          s0 = s1;
        }
      }
    }

    return s0;
  }

  function peg$parsesp() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 32) {
      s0 = peg$c319;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c320); }
    }

    return s0;
  }

  function peg$parsedouble_quote() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 34) {
      s0 = peg$c267;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c268); }
    }

    return s0;
  }

  function peg$parsesingle_quote() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 39) {
      s0 = peg$c259;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c260); }
    }

    return s0;
  }

  function peg$parsecomma() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 44) {
      s0 = peg$c241;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c242); }
    }

    return s0;
  }

  function peg$parsetab() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 9) {
      s0 = peg$c321;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c322); }
    }

    return s0;
  }

  function peg$parsesemicolon() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 59) {
      s0 = peg$c323;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c324); }
    }

    return s0;
  }

  function peg$parseendline() {
    var s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsesp();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsesp();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsenewline();
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c325); }
    }

    return s0;
  }

  function peg$parsenewline() {
    var s0, s1;

    peg$silentFails++;
    if (input.substr(peg$currPos, 2) === peg$c327) {
      s0 = peg$c327;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c328); }
    }
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 10) {
        s0 = peg$c329;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c330); }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c326); }
    }

    return s0;
  }

  function peg$parse_() {
    var s0, s1;

    peg$silentFails++;
    s0 = [];
    s1 = peg$parsecmt();
    if (s1 === peg$FAILED) {
      s1 = peg$parsesp();
      if (s1 === peg$FAILED) {
        s1 = peg$parsetab();
        if (s1 === peg$FAILED) {
          s1 = peg$parsenewline();
        }
      }
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = peg$parsecmt();
      if (s1 === peg$FAILED) {
        s1 = peg$parsesp();
        if (s1 === peg$FAILED) {
          s1 = peg$parsetab();
          if (s1 === peg$FAILED) {
            s1 = peg$parsenewline();
          }
        }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c331); }
    }

    return s0;
  }

  function peg$parse__() {
    var s0, s1;

    peg$silentFails++;
    s0 = [];
    s1 = peg$parsecmt();
    if (s1 === peg$FAILED) {
      s1 = peg$parsesp();
      if (s1 === peg$FAILED) {
        s1 = peg$parsetab();
        if (s1 === peg$FAILED) {
          s1 = peg$parsenewline();
        }
      }
    }
    if (s1 !== peg$FAILED) {
      while (s1 !== peg$FAILED) {
        s0.push(s1);
        s1 = peg$parsecmt();
        if (s1 === peg$FAILED) {
          s1 = peg$parsesp();
          if (s1 === peg$FAILED) {
            s1 = peg$parsetab();
            if (s1 === peg$FAILED) {
              s1 = peg$parsenewline();
            }
          }
        }
      }
    } else {
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c331); }
    }

    return s0;
  }

  function peg$parsecmt() {
    var s0, s1, s2, s3, s4, s5;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c333) {
      s1 = peg$c333;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c334); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      if (peg$c335.test(input.charAt(peg$currPos))) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c336); }
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        if (peg$c335.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c336); }
        }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 2) === peg$c337) {
        s1 = peg$c337;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c338); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        if (input.substr(peg$currPos, 2) === peg$c339) {
          s5 = peg$c339;
          peg$currPos += 2;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c340); }
        }
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = void 0;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          if (input.length > peg$currPos) {
            s5 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c245); }
          }
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$currPos;
          peg$silentFails++;
          if (input.substr(peg$currPos, 2) === peg$c339) {
            s5 = peg$c339;
            peg$currPos += 2;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c340); }
          }
          peg$silentFails--;
          if (s5 === peg$FAILED) {
            s4 = void 0;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            if (input.length > peg$currPos) {
              s5 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c245); }
            }
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c339) {
            s3 = peg$c339;
            peg$currPos += 2;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c340); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsesemicolon();
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s1 = [s1, s2, s3, s4];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c332); }
    }

    return s0;
  }

  function peg$parsecharacter() {
    var s0, s1;

    peg$silentFails++;
    if (peg$c342.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c343); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c341); }
    }

    return s0;
  }

  function peg$parseoperator() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c344) {
      s0 = peg$c344;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c345); }
    }
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 61) {
        s0 = peg$c346;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c347); }
      }
    }

    return s0;
  }

  function peg$parsecreate_table_normal() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22, s23, s24, s25, s26, s27, s28, s29, s30, s31;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseCREATE();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          s5 = peg$currPos;
          s6 = peg$parseGLOBAL();
          if (s6 !== peg$FAILED) {
            s7 = peg$parse__();
            if (s7 !== peg$FAILED) {
              s6 = [s6, s7];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 === peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parseLOCAL();
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          }
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseTEMPORARY();
            if (s6 === peg$FAILED) {
              s6 = peg$parseTEMP();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s5 = [s5, s6, s7];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 === peg$FAILED) {
            s4 = peg$currPos;
            s5 = peg$parseUNLOGGED();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parseTABLE();
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseIF_NOT_EXISTS();
                if (s8 !== peg$FAILED) {
                  s7 = [s7, s8];
                  s6 = s7;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
              if (s6 === peg$FAILED) {
                s6 = null;
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parse__();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsetable_name();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parse_();
                    if (s9 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 40) {
                        s10 = peg$c237;
                        peg$currPos++;
                      } else {
                        s10 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c238); }
                      }
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parse_();
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parsetable_properties();
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parse_();
                            if (s13 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 41) {
                                s14 = peg$c239;
                                peg$currPos++;
                              } else {
                                s14 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c240); }
                              }
                              if (s14 !== peg$FAILED) {
                                s15 = peg$currPos;
                                s16 = peg$parse__();
                                if (s16 !== peg$FAILED) {
                                  s17 = peg$parseINHERITS();
                                  if (s17 !== peg$FAILED) {
                                    s18 = peg$parse_();
                                    if (s18 !== peg$FAILED) {
                                      if (input.charCodeAt(peg$currPos) === 40) {
                                        s19 = peg$c237;
                                        peg$currPos++;
                                      } else {
                                        s19 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                      }
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parse_();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parsetable_names();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parse_();
                                            if (s22 !== peg$FAILED) {
                                              if (input.charCodeAt(peg$currPos) === 41) {
                                                s23 = peg$c239;
                                                peg$currPos++;
                                              } else {
                                                s23 = peg$FAILED;
                                                if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                              }
                                              if (s23 !== peg$FAILED) {
                                                s16 = [s16, s17, s18, s19, s20, s21, s22, s23];
                                                s15 = s16;
                                              } else {
                                                peg$currPos = s15;
                                                s15 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s15;
                                              s15 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s15;
                                            s15 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s15;
                                          s15 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s15;
                                        s15 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s15;
                                      s15 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s15;
                                    s15 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s15;
                                  s15 = peg$FAILED;
                                }
                                if (s15 === peg$FAILED) {
                                  s15 = null;
                                }
                                if (s15 !== peg$FAILED) {
                                  s16 = peg$currPos;
                                  s17 = peg$parse__();
                                  if (s17 !== peg$FAILED) {
                                    s18 = peg$parsePARTITION();
                                    if (s18 !== peg$FAILED) {
                                      s19 = peg$parse__();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parseBY();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parse__();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parseRANGE();
                                            if (s22 === peg$FAILED) {
                                              s22 = peg$parseLIST();
                                              if (s22 === peg$FAILED) {
                                                s22 = peg$parseHASH();
                                              }
                                            }
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parse_();
                                              if (s23 !== peg$FAILED) {
                                                if (input.charCodeAt(peg$currPos) === 40) {
                                                  s24 = peg$c237;
                                                  peg$currPos++;
                                                } else {
                                                  s24 = peg$FAILED;
                                                  if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                                }
                                                if (s24 !== peg$FAILED) {
                                                  s25 = peg$parse_();
                                                  if (s25 !== peg$FAILED) {
                                                    s26 = peg$parsecolumn_name();
                                                    if (s26 === peg$FAILED) {
                                                      s26 = peg$currPos;
                                                      if (input.charCodeAt(peg$currPos) === 40) {
                                                        s27 = peg$c237;
                                                        peg$currPos++;
                                                      } else {
                                                        s27 = peg$FAILED;
                                                        if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                                      }
                                                      if (s27 !== peg$FAILED) {
                                                        s28 = peg$parse_();
                                                        if (s28 !== peg$FAILED) {
                                                          s29 = peg$parseexpression();
                                                          if (s29 !== peg$FAILED) {
                                                            s30 = peg$parse_();
                                                            if (s30 !== peg$FAILED) {
                                                              if (input.charCodeAt(peg$currPos) === 41) {
                                                                s31 = peg$c239;
                                                                peg$currPos++;
                                                              } else {
                                                                s31 = peg$FAILED;
                                                                if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                              }
                                                              if (s31 !== peg$FAILED) {
                                                                s27 = [s27, s28, s29, s30, s31];
                                                                s26 = s27;
                                                              } else {
                                                                peg$currPos = s26;
                                                                s26 = peg$FAILED;
                                                              }
                                                            } else {
                                                              peg$currPos = s26;
                                                              s26 = peg$FAILED;
                                                            }
                                                          } else {
                                                            peg$currPos = s26;
                                                            s26 = peg$FAILED;
                                                          }
                                                        } else {
                                                          peg$currPos = s26;
                                                          s26 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s26;
                                                        s26 = peg$FAILED;
                                                      }
                                                    }
                                                    if (s26 !== peg$FAILED) {
                                                      s27 = peg$currPos;
                                                      s28 = peg$parse__();
                                                      if (s28 !== peg$FAILED) {
                                                        s29 = peg$parseCOLLATE();
                                                        if (s29 !== peg$FAILED) {
                                                          s30 = peg$parse__();
                                                          if (s30 !== peg$FAILED) {
                                                            s31 = peg$parseidentifier();
                                                            if (s31 !== peg$FAILED) {
                                                              s28 = [s28, s29, s30, s31];
                                                              s27 = s28;
                                                            } else {
                                                              peg$currPos = s27;
                                                              s27 = peg$FAILED;
                                                            }
                                                          } else {
                                                            peg$currPos = s27;
                                                            s27 = peg$FAILED;
                                                          }
                                                        } else {
                                                          peg$currPos = s27;
                                                          s27 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s27;
                                                        s27 = peg$FAILED;
                                                      }
                                                      if (s27 === peg$FAILED) {
                                                        s27 = null;
                                                      }
                                                      if (s27 !== peg$FAILED) {
                                                        s28 = peg$currPos;
                                                        s29 = peg$parse__();
                                                        if (s29 !== peg$FAILED) {
                                                          s30 = peg$parseopclasses();
                                                          if (s30 !== peg$FAILED) {
                                                            s29 = [s29, s30];
                                                            s28 = s29;
                                                          } else {
                                                            peg$currPos = s28;
                                                            s28 = peg$FAILED;
                                                          }
                                                        } else {
                                                          peg$currPos = s28;
                                                          s28 = peg$FAILED;
                                                        }
                                                        if (s28 === peg$FAILED) {
                                                          s28 = null;
                                                        }
                                                        if (s28 !== peg$FAILED) {
                                                          s29 = peg$parse_();
                                                          if (s29 !== peg$FAILED) {
                                                            if (input.charCodeAt(peg$currPos) === 41) {
                                                              s30 = peg$c239;
                                                              peg$currPos++;
                                                            } else {
                                                              s30 = peg$FAILED;
                                                              if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                            }
                                                            if (s30 !== peg$FAILED) {
                                                              s17 = [s17, s18, s19, s20, s21, s22, s23, s24, s25, s26, s27, s28, s29, s30];
                                                              s16 = s17;
                                                            } else {
                                                              peg$currPos = s16;
                                                              s16 = peg$FAILED;
                                                            }
                                                          } else {
                                                            peg$currPos = s16;
                                                            s16 = peg$FAILED;
                                                          }
                                                        } else {
                                                          peg$currPos = s16;
                                                          s16 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s16;
                                                        s16 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s16;
                                                      s16 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s16;
                                                    s16 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s16;
                                                  s16 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s16;
                                                s16 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s16;
                                              s16 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s16;
                                            s16 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s16;
                                          s16 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s16;
                                        s16 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s16;
                                      s16 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s16;
                                    s16 = peg$FAILED;
                                  }
                                  if (s16 === peg$FAILED) {
                                    s16 = null;
                                  }
                                  if (s16 !== peg$FAILED) {
                                    s17 = peg$currPos;
                                    s18 = peg$parse__();
                                    if (s18 !== peg$FAILED) {
                                      s19 = peg$parseWITH();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parse_();
                                        if (s20 !== peg$FAILED) {
                                          if (input.charCodeAt(peg$currPos) === 40) {
                                            s21 = peg$c237;
                                            peg$currPos++;
                                          } else {
                                            s21 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                          }
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parse_();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parsestorage_parameters();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parse_();
                                                if (s24 !== peg$FAILED) {
                                                  if (input.charCodeAt(peg$currPos) === 41) {
                                                    s25 = peg$c239;
                                                    peg$currPos++;
                                                  } else {
                                                    s25 = peg$FAILED;
                                                    if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                  }
                                                  if (s25 !== peg$FAILED) {
                                                    s18 = [s18, s19, s20, s21, s22, s23, s24, s25];
                                                    s17 = s18;
                                                  } else {
                                                    peg$currPos = s17;
                                                    s17 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s17;
                                                  s17 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s17;
                                                s17 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s17;
                                              s17 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s17;
                                            s17 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s17;
                                          s17 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s17;
                                        s17 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s17;
                                      s17 = peg$FAILED;
                                    }
                                    if (s17 === peg$FAILED) {
                                      s17 = peg$currPos;
                                      s18 = peg$parse__();
                                      if (s18 !== peg$FAILED) {
                                        s19 = peg$parseWITH();
                                        if (s19 !== peg$FAILED) {
                                          s20 = peg$parse__();
                                          if (s20 !== peg$FAILED) {
                                            s21 = peg$parseOIDS();
                                            if (s21 !== peg$FAILED) {
                                              s18 = [s18, s19, s20, s21];
                                              s17 = s18;
                                            } else {
                                              peg$currPos = s17;
                                              s17 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s17;
                                            s17 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s17;
                                          s17 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s17;
                                        s17 = peg$FAILED;
                                      }
                                      if (s17 === peg$FAILED) {
                                        s17 = peg$currPos;
                                        s18 = peg$parse__();
                                        if (s18 !== peg$FAILED) {
                                          s19 = peg$parseWITHOUT();
                                          if (s19 !== peg$FAILED) {
                                            s20 = peg$parse__();
                                            if (s20 !== peg$FAILED) {
                                              s21 = peg$parseOIDS();
                                              if (s21 !== peg$FAILED) {
                                                s18 = [s18, s19, s20, s21];
                                                s17 = s18;
                                              } else {
                                                peg$currPos = s17;
                                                s17 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s17;
                                              s17 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s17;
                                            s17 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s17;
                                          s17 = peg$FAILED;
                                        }
                                      }
                                    }
                                    if (s17 === peg$FAILED) {
                                      s17 = null;
                                    }
                                    if (s17 !== peg$FAILED) {
                                      s18 = peg$currPos;
                                      s19 = peg$parse__();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parseON();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parse__();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parseCOMMIT();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parse__();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$currPos;
                                                s25 = peg$parsePRESERVE();
                                                if (s25 !== peg$FAILED) {
                                                  s26 = peg$parse__();
                                                  if (s26 !== peg$FAILED) {
                                                    s27 = peg$parseROWS();
                                                    if (s27 !== peg$FAILED) {
                                                      s25 = [s25, s26, s27];
                                                      s24 = s25;
                                                    } else {
                                                      peg$currPos = s24;
                                                      s24 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s24;
                                                    s24 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s24;
                                                  s24 = peg$FAILED;
                                                }
                                                if (s24 === peg$FAILED) {
                                                  s24 = peg$currPos;
                                                  s25 = peg$parseDELETE();
                                                  if (s25 !== peg$FAILED) {
                                                    s26 = peg$parse__();
                                                    if (s26 !== peg$FAILED) {
                                                      s27 = peg$parseROWS();
                                                      if (s27 !== peg$FAILED) {
                                                        s25 = [s25, s26, s27];
                                                        s24 = s25;
                                                      } else {
                                                        peg$currPos = s24;
                                                        s24 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s24;
                                                      s24 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s24;
                                                    s24 = peg$FAILED;
                                                  }
                                                  if (s24 === peg$FAILED) {
                                                    s24 = peg$parseDROP();
                                                  }
                                                }
                                                if (s24 !== peg$FAILED) {
                                                  s19 = [s19, s20, s21, s22, s23, s24];
                                                  s18 = s19;
                                                } else {
                                                  peg$currPos = s18;
                                                  s18 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s18;
                                                s18 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s18;
                                              s18 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s18;
                                            s18 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s18;
                                          s18 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s18;
                                        s18 = peg$FAILED;
                                      }
                                      if (s18 === peg$FAILED) {
                                        s18 = null;
                                      }
                                      if (s18 !== peg$FAILED) {
                                        s19 = peg$currPos;
                                        s20 = peg$parse__();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parseTABLESPACE();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parse__();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parseidentifier();
                                              if (s23 !== peg$FAILED) {
                                                s20 = [s20, s21, s22, s23];
                                                s19 = s20;
                                              } else {
                                                peg$currPos = s19;
                                                s19 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s19;
                                              s19 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s19;
                                            s19 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s19;
                                          s19 = peg$FAILED;
                                        }
                                        if (s19 === peg$FAILED) {
                                          s19 = null;
                                        }
                                        if (s19 !== peg$FAILED) {
                                          s20 = peg$parse_();
                                          if (s20 !== peg$FAILED) {
                                            s21 = peg$parsesemicolon();
                                            if (s21 !== peg$FAILED) {
                                              s22 = peg$parse_();
                                              if (s22 !== peg$FAILED) {
                                                peg$savedPos = s0;
                                                s1 = peg$c348(s8, s12);
                                                s0 = s1;
                                              } else {
                                                peg$currPos = s0;
                                                s0 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s0;
                                              s0 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_properties() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsetable_property();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsetable_property();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsetable_property();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_property() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$parsetable_constraint();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c350(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseLIKE();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsetable_name();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$currPos;
            s6 = peg$parse__();
            if (s6 !== peg$FAILED) {
              s7 = peg$parselike_option();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$currPos;
              s6 = peg$parse__();
              if (s6 !== peg$FAILED) {
                s7 = peg$parselike_option();
                if (s7 !== peg$FAILED) {
                  s6 = [s6, s7];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c351(s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsecolumn_name();
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          if (s2 !== peg$FAILED) {
            s3 = peg$parsedata_type();
            if (s3 !== peg$FAILED) {
              s4 = peg$currPos;
              s5 = peg$parse__();
              if (s5 !== peg$FAILED) {
                s6 = peg$parseCOLLATE();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse__();
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parseidentifier();
                    if (s8 !== peg$FAILED) {
                      s5 = [s5, s6, s7, s8];
                      s4 = s5;
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
              if (s4 === peg$FAILED) {
                s4 = null;
              }
              if (s4 !== peg$FAILED) {
                s5 = [];
                s6 = peg$currPos;
                s7 = peg$parse_();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsecolumn_constraint();
                  if (s8 !== peg$FAILED) {
                    s7 = [s7, s8];
                    s6 = s7;
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
                while (s6 !== peg$FAILED) {
                  s5.push(s6);
                  s6 = peg$currPos;
                  s7 = peg$parse_();
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parsecolumn_constraint();
                    if (s8 !== peg$FAILED) {
                      s7 = [s7, s8];
                      s6 = s7;
                    } else {
                      peg$currPos = s6;
                      s6 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                }
                if (s5 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c352(s1, s3, s5);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsecolumn_constraint() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseCONSTRAINT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      if (s3 !== peg$FAILED) {
        s4 = peg$parseidentifier();
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          if (s5 !== peg$FAILED) {
            s2 = [s2, s3, s4, s5];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parseNOT();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseNULL();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s2;
            s3 = peg$c353();
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$parseNULL();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s2;
          s3 = peg$c354();
        }
        s2 = s3;
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          s3 = peg$parseCHECK();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 40) {
                s5 = peg$c237;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c238); }
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parse_();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parseexpression();
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parse_();
                    if (s8 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 41) {
                        s9 = peg$c239;
                        peg$currPos++;
                      } else {
                        s9 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c240); }
                      }
                      if (s9 !== peg$FAILED) {
                        s10 = peg$currPos;
                        s11 = peg$parse__();
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parseNO();
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parse__();
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parseINHERIT();
                              if (s14 !== peg$FAILED) {
                                s11 = [s11, s12, s13, s14];
                                s10 = s11;
                              } else {
                                peg$currPos = s10;
                                s10 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s10;
                              s10 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s10;
                            s10 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s10;
                          s10 = peg$FAILED;
                        }
                        if (s10 === peg$FAILED) {
                          s10 = null;
                        }
                        if (s10 !== peg$FAILED) {
                          peg$savedPos = s2;
                          s3 = peg$c355();
                          s2 = s3;
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = peg$currPos;
            s3 = peg$parseDEFAULT();
            if (s3 !== peg$FAILED) {
              s4 = peg$parse__();
              if (s4 !== peg$FAILED) {
                s5 = peg$parsedefault_expr();
                if (s5 !== peg$FAILED) {
                  peg$savedPos = s2;
                  s3 = peg$c356(s5);
                  s2 = s3;
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
            if (s2 === peg$FAILED) {
              s2 = peg$currPos;
              s3 = peg$parseGENERATED();
              if (s3 !== peg$FAILED) {
                s4 = peg$parse__();
                if (s4 !== peg$FAILED) {
                  s5 = peg$parseALWAYS();
                  if (s5 === peg$FAILED) {
                    s5 = peg$currPos;
                    s6 = peg$parseBY();
                    if (s6 !== peg$FAILED) {
                      s7 = peg$parse__();
                      if (s7 !== peg$FAILED) {
                        s8 = peg$parseDEFAULT();
                        if (s8 !== peg$FAILED) {
                          s6 = [s6, s7, s8];
                          s5 = s6;
                        } else {
                          peg$currPos = s5;
                          s5 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s5;
                        s5 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  }
                  if (s5 !== peg$FAILED) {
                    s6 = peg$parse__();
                    if (s6 !== peg$FAILED) {
                      s7 = peg$parseAS();
                      if (s7 !== peg$FAILED) {
                        s8 = peg$parse__();
                        if (s8 !== peg$FAILED) {
                          s9 = peg$parseIDENTITY();
                          if (s9 !== peg$FAILED) {
                            peg$savedPos = s2;
                            s3 = peg$c355();
                            s2 = s3;
                          } else {
                            peg$currPos = s2;
                            s2 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
              if (s2 === peg$FAILED) {
                s2 = peg$currPos;
                s3 = peg$parseUNIQUE();
                if (s3 !== peg$FAILED) {
                  s4 = peg$currPos;
                  s5 = peg$parse__();
                  if (s5 !== peg$FAILED) {
                    s6 = peg$parseindex_parameters();
                    if (s6 !== peg$FAILED) {
                      s5 = [s5, s6];
                      s4 = s5;
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                  if (s4 === peg$FAILED) {
                    s4 = null;
                  }
                  if (s4 !== peg$FAILED) {
                    peg$savedPos = s2;
                    s3 = peg$c357();
                    s2 = s3;
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
                if (s2 === peg$FAILED) {
                  s2 = peg$currPos;
                  s3 = peg$parsePRIMARY_KEY();
                  if (s3 !== peg$FAILED) {
                    s4 = peg$currPos;
                    s5 = peg$parse__();
                    if (s5 !== peg$FAILED) {
                      s6 = peg$parseindex_parameters();
                      if (s6 !== peg$FAILED) {
                        s5 = [s5, s6];
                        s4 = s5;
                      } else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                    if (s4 === peg$FAILED) {
                      s4 = null;
                    }
                    if (s4 !== peg$FAILED) {
                      peg$savedPos = s2;
                      s3 = peg$c358();
                      s2 = s3;
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                  if (s2 === peg$FAILED) {
                    s2 = peg$currPos;
                    s3 = peg$parseREFERENCES();
                    if (s3 !== peg$FAILED) {
                      s4 = peg$parse__();
                      if (s4 !== peg$FAILED) {
                        s5 = peg$parsetable_name();
                        if (s5 !== peg$FAILED) {
                          s6 = peg$currPos;
                          s7 = peg$parse_();
                          if (s7 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 40) {
                              s8 = peg$c237;
                              peg$currPos++;
                            } else {
                              s8 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c238); }
                            }
                            if (s8 !== peg$FAILED) {
                              s9 = peg$parse_();
                              if (s9 !== peg$FAILED) {
                                s10 = peg$parsecolumn_name();
                                if (s10 !== peg$FAILED) {
                                  s11 = peg$parse_();
                                  if (s11 !== peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 41) {
                                      s12 = peg$c239;
                                      peg$currPos++;
                                    } else {
                                      s12 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                    }
                                    if (s12 !== peg$FAILED) {
                                      peg$savedPos = s6;
                                      s7 = peg$c359(s5, s10);
                                      s6 = s7;
                                    } else {
                                      peg$currPos = s6;
                                      s6 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s6;
                                    s6 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s6;
                                  s6 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s6;
                                s6 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s6;
                              s6 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s6;
                            s6 = peg$FAILED;
                          }
                          if (s6 === peg$FAILED) {
                            s6 = null;
                          }
                          if (s6 !== peg$FAILED) {
                            s7 = peg$currPos;
                            s8 = peg$parse__();
                            if (s8 !== peg$FAILED) {
                              s9 = peg$parseMATCH();
                              if (s9 !== peg$FAILED) {
                                s10 = peg$parse__();
                                if (s10 !== peg$FAILED) {
                                  s11 = peg$parseFULL();
                                  if (s11 !== peg$FAILED) {
                                    s8 = [s8, s9, s10, s11];
                                    s7 = s8;
                                  } else {
                                    peg$currPos = s7;
                                    s7 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s7;
                                  s7 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s7;
                                s7 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s7;
                              s7 = peg$FAILED;
                            }
                            if (s7 === peg$FAILED) {
                              s7 = peg$currPos;
                              s8 = peg$parse__();
                              if (s8 !== peg$FAILED) {
                                s9 = peg$parseMATCH();
                                if (s9 !== peg$FAILED) {
                                  s10 = peg$parse__();
                                  if (s10 !== peg$FAILED) {
                                    s11 = peg$parsePARTIAL();
                                    if (s11 !== peg$FAILED) {
                                      s8 = [s8, s9, s10, s11];
                                      s7 = s8;
                                    } else {
                                      peg$currPos = s7;
                                      s7 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s7;
                                    s7 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s7;
                                  s7 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s7;
                                s7 = peg$FAILED;
                              }
                              if (s7 === peg$FAILED) {
                                s7 = peg$currPos;
                                s8 = peg$parse__();
                                if (s8 !== peg$FAILED) {
                                  s9 = peg$parseMATCH();
                                  if (s9 !== peg$FAILED) {
                                    s10 = peg$parse__();
                                    if (s10 !== peg$FAILED) {
                                      s11 = peg$parseSIMPLE();
                                      if (s11 !== peg$FAILED) {
                                        s8 = [s8, s9, s10, s11];
                                        s7 = s8;
                                      } else {
                                        peg$currPos = s7;
                                        s7 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s7;
                                      s7 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s7;
                                    s7 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s7;
                                  s7 = peg$FAILED;
                                }
                              }
                            }
                            if (s7 === peg$FAILED) {
                              s7 = null;
                            }
                            if (s7 !== peg$FAILED) {
                              s8 = [];
                              s9 = peg$parsefk_action();
                              while (s9 !== peg$FAILED) {
                                s8.push(s9);
                                s9 = peg$parsefk_action();
                              }
                              if (s8 !== peg$FAILED) {
                                peg$savedPos = s2;
                                s3 = peg$c360(s5, s6, s8);
                                s2 = s3;
                              } else {
                                peg$currPos = s2;
                                s2 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s2;
                              s2 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s2;
                            s2 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        s4 = peg$parse__();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseDEFERRABLE();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parse__();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseNOT();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseDEFERRABLE();
              if (s6 !== peg$FAILED) {
                s4 = [s4, s5, s6];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          s5 = peg$parse__();
          if (s5 !== peg$FAILED) {
            s6 = peg$parseINITIALLY();
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseDEFERRED();
                if (s8 !== peg$FAILED) {
                  s5 = [s5, s6, s7, s8];
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 === peg$FAILED) {
            s4 = peg$currPos;
            s5 = peg$parse__();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseINITIALLY();
              if (s6 !== peg$FAILED) {
                s7 = peg$parse__();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseIMMEDIATE();
                  if (s8 !== peg$FAILED) {
                    s5 = [s5, s6, s7, s8];
                    s4 = s5;
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c361(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_constraint() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseCONSTRAINT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      if (s3 !== peg$FAILED) {
        s4 = peg$parseidentifier();
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          if (s5 !== peg$FAILED) {
            s2 = [s2, s3, s4, s5];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parseCHECK();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 40) {
            s5 = peg$c237;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c238); }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseexpression();
              if (s7 !== peg$FAILED) {
                s8 = peg$parse_();
                if (s8 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s9 = peg$c239;
                    peg$currPos++;
                  } else {
                    s9 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c240); }
                  }
                  if (s9 !== peg$FAILED) {
                    s10 = peg$currPos;
                    s11 = peg$parse__();
                    if (s11 !== peg$FAILED) {
                      s12 = peg$parseNO();
                      if (s12 !== peg$FAILED) {
                        s13 = peg$parse__();
                        if (s13 !== peg$FAILED) {
                          s14 = peg$parseINHERIT();
                          if (s14 !== peg$FAILED) {
                            s11 = [s11, s12, s13, s14];
                            s10 = s11;
                          } else {
                            peg$currPos = s10;
                            s10 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s10;
                          s10 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s10;
                        s10 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s10;
                      s10 = peg$FAILED;
                    }
                    if (s10 === peg$FAILED) {
                      s10 = null;
                    }
                    if (s10 !== peg$FAILED) {
                      peg$savedPos = s2;
                      s3 = peg$c362();
                      s2 = s3;
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$parseUNIQUE();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 40) {
              s5 = peg$c237;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c238); }
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parse_();
              if (s6 !== peg$FAILED) {
                s7 = peg$parsecolumn_names();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parse_();
                  if (s8 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 41) {
                      s9 = peg$c239;
                      peg$currPos++;
                    } else {
                      s9 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c240); }
                    }
                    if (s9 !== peg$FAILED) {
                      s10 = peg$currPos;
                      s11 = peg$parse__();
                      if (s11 !== peg$FAILED) {
                        s12 = peg$parseindex_parameters();
                        if (s12 !== peg$FAILED) {
                          s11 = [s11, s12];
                          s10 = s11;
                        } else {
                          peg$currPos = s10;
                          s10 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s10;
                        s10 = peg$FAILED;
                      }
                      if (s10 === peg$FAILED) {
                        s10 = null;
                      }
                      if (s10 !== peg$FAILED) {
                        peg$savedPos = s2;
                        s3 = peg$c363(s7);
                        s2 = s3;
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          s3 = peg$parsePRIMARY_KEY();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 40) {
                s5 = peg$c237;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c238); }
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parse_();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parsecolumn_names();
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parse_();
                    if (s8 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 41) {
                        s9 = peg$c239;
                        peg$currPos++;
                      } else {
                        s9 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c240); }
                      }
                      if (s9 !== peg$FAILED) {
                        s10 = peg$currPos;
                        s11 = peg$parse__();
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parseindex_parameters();
                          if (s12 !== peg$FAILED) {
                            s11 = [s11, s12];
                            s10 = s11;
                          } else {
                            peg$currPos = s10;
                            s10 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s10;
                          s10 = peg$FAILED;
                        }
                        if (s10 === peg$FAILED) {
                          s10 = null;
                        }
                        if (s10 !== peg$FAILED) {
                          peg$savedPos = s2;
                          s3 = peg$c364(s7);
                          s2 = s3;
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = peg$currPos;
            s3 = peg$parseEXCLUDE();
            if (s3 !== peg$FAILED) {
              s4 = peg$currPos;
              s5 = peg$parse__();
              if (s5 !== peg$FAILED) {
                s6 = peg$parseUSING();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse__();
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parseindex_method();
                    if (s8 !== peg$FAILED) {
                      s5 = [s5, s6, s7, s8];
                      s4 = s5;
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
              if (s4 === peg$FAILED) {
                s4 = null;
              }
              if (s4 !== peg$FAILED) {
                s5 = peg$parse__();
                if (s5 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 40) {
                    s6 = peg$c237;
                    peg$currPos++;
                  } else {
                    s6 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c238); }
                  }
                  if (s6 !== peg$FAILED) {
                    s7 = peg$parseexclude_element_with_operator_list();
                    if (s7 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 41) {
                        s8 = peg$c239;
                        peg$currPos++;
                      } else {
                        s8 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c240); }
                      }
                      if (s8 !== peg$FAILED) {
                        s9 = peg$parse__();
                        if (s9 !== peg$FAILED) {
                          s10 = peg$parseindex_parameters();
                          if (s10 !== peg$FAILED) {
                            s11 = peg$currPos;
                            s12 = peg$parse__();
                            if (s12 !== peg$FAILED) {
                              s13 = peg$parseWHERE();
                              if (s13 !== peg$FAILED) {
                                s14 = peg$parse_();
                                if (s14 !== peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 40) {
                                    s15 = peg$c237;
                                    peg$currPos++;
                                  } else {
                                    s15 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                  }
                                  if (s15 !== peg$FAILED) {
                                    s16 = peg$parse_();
                                    if (s16 !== peg$FAILED) {
                                      s17 = peg$parseexpression();
                                      if (s17 !== peg$FAILED) {
                                        s18 = peg$parse_();
                                        if (s18 !== peg$FAILED) {
                                          if (input.charCodeAt(peg$currPos) === 41) {
                                            s19 = peg$c239;
                                            peg$currPos++;
                                          } else {
                                            s19 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                          }
                                          if (s19 !== peg$FAILED) {
                                            s12 = [s12, s13, s14, s15, s16, s17, s18, s19];
                                            s11 = s12;
                                          } else {
                                            peg$currPos = s11;
                                            s11 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s11;
                                          s11 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s11;
                                        s11 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s11;
                                      s11 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s11;
                                    s11 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s11;
                                  s11 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s11;
                                s11 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s11;
                              s11 = peg$FAILED;
                            }
                            if (s11 === peg$FAILED) {
                              s11 = null;
                            }
                            if (s11 !== peg$FAILED) {
                              peg$savedPos = s2;
                              s3 = peg$c365();
                              s2 = s3;
                            } else {
                              peg$currPos = s2;
                              s2 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s2;
                            s2 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
            if (s2 === peg$FAILED) {
              s2 = peg$currPos;
              s3 = peg$parseFOREIGN_KEY();
              if (s3 !== peg$FAILED) {
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 40) {
                    s5 = peg$c237;
                    peg$currPos++;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c238); }
                  }
                  if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                      s7 = peg$parsecolumn_names();
                      if (s7 !== peg$FAILED) {
                        s8 = peg$parse_();
                        if (s8 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 41) {
                            s9 = peg$c239;
                            peg$currPos++;
                          } else {
                            s9 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c240); }
                          }
                          if (s9 !== peg$FAILED) {
                            s10 = peg$parse_();
                            if (s10 !== peg$FAILED) {
                              s11 = peg$parseREFERENCES();
                              if (s11 !== peg$FAILED) {
                                s12 = peg$parse__();
                                if (s12 !== peg$FAILED) {
                                  s13 = peg$parsetable_name();
                                  if (s13 !== peg$FAILED) {
                                    s14 = peg$currPos;
                                    s15 = peg$parse_();
                                    if (s15 !== peg$FAILED) {
                                      if (input.charCodeAt(peg$currPos) === 40) {
                                        s16 = peg$c237;
                                        peg$currPos++;
                                      } else {
                                        s16 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                      }
                                      if (s16 !== peg$FAILED) {
                                        s17 = peg$parse_();
                                        if (s17 !== peg$FAILED) {
                                          s18 = peg$parsecolumn_names();
                                          if (s18 !== peg$FAILED) {
                                            s19 = peg$parse_();
                                            if (s19 !== peg$FAILED) {
                                              if (input.charCodeAt(peg$currPos) === 41) {
                                                s20 = peg$c239;
                                                peg$currPos++;
                                              } else {
                                                s20 = peg$FAILED;
                                                if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                              }
                                              if (s20 !== peg$FAILED) {
                                                peg$savedPos = s14;
                                                s15 = peg$c366(s7, s13, s18);
                                                s14 = s15;
                                              } else {
                                                peg$currPos = s14;
                                                s14 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s14;
                                              s14 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s14;
                                            s14 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s14;
                                          s14 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s14;
                                        s14 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s14;
                                      s14 = peg$FAILED;
                                    }
                                    if (s14 === peg$FAILED) {
                                      s14 = null;
                                    }
                                    if (s14 !== peg$FAILED) {
                                      s15 = peg$currPos;
                                      s16 = peg$parse__();
                                      if (s16 !== peg$FAILED) {
                                        s17 = peg$parseMATCH();
                                        if (s17 !== peg$FAILED) {
                                          s18 = peg$parse__();
                                          if (s18 !== peg$FAILED) {
                                            s19 = peg$parseFULL();
                                            if (s19 !== peg$FAILED) {
                                              s16 = [s16, s17, s18, s19];
                                              s15 = s16;
                                            } else {
                                              peg$currPos = s15;
                                              s15 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s15;
                                            s15 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s15;
                                          s15 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s15;
                                        s15 = peg$FAILED;
                                      }
                                      if (s15 === peg$FAILED) {
                                        s15 = peg$currPos;
                                        s16 = peg$parse__();
                                        if (s16 !== peg$FAILED) {
                                          s17 = peg$parseMATCH();
                                          if (s17 !== peg$FAILED) {
                                            s18 = peg$parse__();
                                            if (s18 !== peg$FAILED) {
                                              s19 = peg$parsePARTIAL();
                                              if (s19 !== peg$FAILED) {
                                                s16 = [s16, s17, s18, s19];
                                                s15 = s16;
                                              } else {
                                                peg$currPos = s15;
                                                s15 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s15;
                                              s15 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s15;
                                            s15 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s15;
                                          s15 = peg$FAILED;
                                        }
                                        if (s15 === peg$FAILED) {
                                          s15 = peg$currPos;
                                          s16 = peg$parse__();
                                          if (s16 !== peg$FAILED) {
                                            s17 = peg$parseMATCH();
                                            if (s17 !== peg$FAILED) {
                                              s18 = peg$parse__();
                                              if (s18 !== peg$FAILED) {
                                                s19 = peg$parseSIMPLE();
                                                if (s19 !== peg$FAILED) {
                                                  s16 = [s16, s17, s18, s19];
                                                  s15 = s16;
                                                } else {
                                                  peg$currPos = s15;
                                                  s15 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s15;
                                                s15 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s15;
                                              s15 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s15;
                                            s15 = peg$FAILED;
                                          }
                                        }
                                      }
                                      if (s15 === peg$FAILED) {
                                        s15 = null;
                                      }
                                      if (s15 !== peg$FAILED) {
                                        s16 = [];
                                        s17 = peg$parsefk_action();
                                        while (s17 !== peg$FAILED) {
                                          s16.push(s17);
                                          s17 = peg$parsefk_action();
                                        }
                                        if (s16 !== peg$FAILED) {
                                          peg$savedPos = s2;
                                          s3 = peg$c367(s7, s13, s14, s16);
                                          s2 = s3;
                                        } else {
                                          peg$currPos = s2;
                                          s2 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s2;
                                        s2 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s2;
                                      s2 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s2;
                                    s2 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s2;
                                  s2 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s2;
                                s2 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s2;
                              s2 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s2;
                            s2 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            }
          }
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        s4 = peg$parse__();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseDEFERRABLE();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parse__();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseNOT();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              if (s6 !== peg$FAILED) {
                s7 = peg$parseDEFERRABLE();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          s5 = peg$parse__();
          if (s5 !== peg$FAILED) {
            s6 = peg$parseINITIALLY();
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseDEFERRED();
                if (s8 !== peg$FAILED) {
                  s5 = [s5, s6, s7, s8];
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 === peg$FAILED) {
            s4 = peg$currPos;
            s5 = peg$parse__();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseINITIALLY();
              if (s6 !== peg$FAILED) {
                s7 = peg$parse__();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseIMMEDIATE();
                  if (s8 !== peg$FAILED) {
                    s5 = [s5, s6, s7, s8];
                    s4 = s5;
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c368(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parselike_option() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseINCLUDING();
    if (s1 === peg$FAILED) {
      s1 = peg$parseEXCLUDING();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseCOMMENTS();
        if (s3 === peg$FAILED) {
          s3 = peg$parseCONSTRAINTS();
          if (s3 === peg$FAILED) {
            s3 = peg$parseDEFAULTS();
            if (s3 === peg$FAILED) {
              s3 = peg$parseIDENTITY();
              if (s3 === peg$FAILED) {
                s3 = peg$parseINDEXES();
                if (s3 === peg$FAILED) {
                  s3 = peg$parseSTATISTICS();
                  if (s3 === peg$FAILED) {
                    s3 = peg$parseSTORAGE();
                    if (s3 === peg$FAILED) {
                      s3 = peg$parseALL();
                    }
                  }
                }
              }
            }
          }
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefk_action() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parse__();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseON();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseUPDATE();
          if (s4 === peg$FAILED) {
            s4 = peg$parseDELETE();
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parse__();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsefk_action_options();
              if (s6 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c369(s4, s6);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefk_action_options() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c370) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c371); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c372) {
        s1 = input.substr(peg$currPos, 7);
        peg$currPos += 7;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c373); }
      }
      if (s1 === peg$FAILED) {
        s1 = peg$currPos;
        if (input.substr(peg$currPos, 2).toLowerCase() === peg$c83) {
          s2 = input.substr(peg$currPos, 2);
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c84); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parse__();
          if (s3 !== peg$FAILED) {
            if (input.substr(peg$currPos, 6).toLowerCase() === peg$c374) {
              s4 = input.substr(peg$currPos, 6);
              peg$currPos += 6;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c375); }
            }
            if (s4 !== peg$FAILED) {
              s2 = [s2, s3, s4];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
        if (s1 === peg$FAILED) {
          s1 = peg$currPos;
          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c187) {
            s2 = input.substr(peg$currPos, 3);
            peg$currPos += 3;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c188); }
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parse__();
            if (s3 !== peg$FAILED) {
              if (input.substr(peg$currPos, 4).toLowerCase() === peg$c85) {
                s4 = input.substr(peg$currPos, 4);
                peg$currPos += 4;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c86); }
              }
              if (s4 !== peg$FAILED) {
                s2 = [s2, s3, s4];
                s1 = s2;
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
          if (s1 === peg$FAILED) {
            s1 = peg$currPos;
            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c187) {
              s2 = input.substr(peg$currPos, 3);
              peg$currPos += 3;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c188); }
            }
            if (s2 !== peg$FAILED) {
              s3 = peg$parse__();
              if (s3 !== peg$FAILED) {
                if (input.substr(peg$currPos, 7).toLowerCase() === peg$c89) {
                  s4 = input.substr(peg$currPos, 7);
                  peg$currPos += 7;
                } else {
                  s4 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c90); }
                }
                if (s4 !== peg$FAILED) {
                  s2 = [s2, s3, s4];
                  s1 = s2;
                } else {
                  peg$currPos = s1;
                  s1 = peg$FAILED;
                }
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s0 = input.substring(s0, peg$currPos);
    } else {
      s0 = s1;
    }

    return s0;
  }

  function peg$parseindex_method() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c55) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c56); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 5).toLowerCase() === peg$c376) {
        s1 = input.substr(peg$currPos, 5);
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c377); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c378) {
          s1 = input.substr(peg$currPos, 4);
          peg$currPos += 4;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c379); }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c380) {
            s1 = input.substr(peg$currPos, 3);
            peg$currPos += 3;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c381); }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 4).toLowerCase() === peg$c382) {
              s1 = input.substr(peg$currPos, 4);
              peg$currPos += 4;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c383); }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 7).toLowerCase() === peg$c384) {
                s1 = input.substr(peg$currPos, 7);
                peg$currPos += 7;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c385); }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c386(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseindex_parameters() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseINCLUDES();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse_();
      if (s3 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 40) {
          s4 = peg$c237;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c238); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parse_();
          if (s5 !== peg$FAILED) {
            s6 = peg$parsecolumn_names();
            if (s6 !== peg$FAILED) {
              s7 = peg$parse_();
              if (s7 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 41) {
                  s8 = peg$c239;
                  peg$currPos++;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c240); }
                }
                if (s8 !== peg$FAILED) {
                  s2 = [s2, s3, s4, s5, s6, s7, s8];
                  s1 = s2;
                } else {
                  peg$currPos = s1;
                  s1 = peg$FAILED;
                }
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      s2 = peg$parseWITH();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 40) {
            s4 = peg$c237;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c238); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parse_();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsestorage_parameters();
              if (s6 !== peg$FAILED) {
                s7 = peg$parse_();
                if (s7 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s8 = peg$c239;
                    peg$currPos++;
                  } else {
                    s8 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c240); }
                  }
                  if (s8 !== peg$FAILED) {
                    s2 = [s2, s3, s4, s5, s6, s7, s8];
                    s1 = s2;
                  } else {
                    peg$currPos = s1;
                    s1 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s1;
                  s1 = peg$FAILED;
                }
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = peg$currPos;
        s2 = peg$parseUSING();
        if (s2 !== peg$FAILED) {
          s3 = peg$parse__();
          if (s3 !== peg$FAILED) {
            s4 = peg$parseINDEX();
            if (s4 !== peg$FAILED) {
              s5 = peg$parse__();
              if (s5 !== peg$FAILED) {
                s6 = peg$parseTABLESPACE();
                if (s6 !== peg$FAILED) {
                  s7 = peg$parse__();
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parseidentifier();
                    if (s8 !== peg$FAILED) {
                      s2 = [s2, s3, s4, s5, s6, s7, s8];
                      s1 = s2;
                    } else {
                      peg$currPos = s1;
                      s1 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s1;
                    s1 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s1;
                  s1 = peg$FAILED;
                }
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      }
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c387(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsetable_names() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsetable_name();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsetable_name();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsetable_name();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseopclasses() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseidentifier();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseidentifier();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseidentifier();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_names() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_name();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsecolumn_name();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsecolumn_name();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexclude_element_with_operator_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseexclude_element_with_operator();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseexclude_element_with_operator();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseexclude_element_with_operator();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexclude_element_with_operator() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseidentifier();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse_();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseWITH();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseoperator();
            if (s5 !== peg$FAILED) {
              s1 = [s1, s2, s3, s4, s5];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsestorage_parameters() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsestorage_parameter();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsestorage_parameter();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsestorage_parameter();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsestorage_parameter() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c388) {
      s1 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c389); }
    }
    if (s1 === peg$FAILED) {
      if (input.substr(peg$currPos, 16).toLowerCase() === peg$c390) {
        s1 = input.substr(peg$currPos, 16);
        peg$currPos += 16;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c391); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 18).toLowerCase() === peg$c392) {
          s1 = input.substr(peg$currPos, 18);
          peg$currPos += 18;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c393); }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 24).toLowerCase() === peg$c394) {
            s1 = input.substr(peg$currPos, 24);
            peg$currPos += 24;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c395); }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 27).toLowerCase() === peg$c396) {
              s1 = input.substr(peg$currPos, 27);
              peg$currPos += 27;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c397); }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 33).toLowerCase() === peg$c398) {
                s1 = input.substr(peg$currPos, 33);
                peg$currPos += 33;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c399); }
              }
              if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 30).toLowerCase() === peg$c400) {
                  s1 = input.substr(peg$currPos, 30);
                  peg$currPos += 30;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c401); }
                }
                if (s1 === peg$FAILED) {
                  if (input.substr(peg$currPos, 36).toLowerCase() === peg$c402) {
                    s1 = input.substr(peg$currPos, 36);
                    peg$currPos += 36;
                  } else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c403); }
                  }
                  if (s1 === peg$FAILED) {
                    if (input.substr(peg$currPos, 28).toLowerCase() === peg$c404) {
                      s1 = input.substr(peg$currPos, 28);
                      peg$currPos += 28;
                    } else {
                      s1 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c405); }
                    }
                    if (s1 === peg$FAILED) {
                      if (input.substr(peg$currPos, 31).toLowerCase() === peg$c406) {
                        s1 = input.substr(peg$currPos, 31);
                        peg$currPos += 31;
                      } else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c407); }
                      }
                      if (s1 === peg$FAILED) {
                        if (input.substr(peg$currPos, 28).toLowerCase() === peg$c408) {
                          s1 = input.substr(peg$currPos, 28);
                          peg$currPos += 28;
                        } else {
                          s1 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c409); }
                        }
                        if (s1 === peg$FAILED) {
                          if (input.substr(peg$currPos, 34).toLowerCase() === peg$c410) {
                            s1 = input.substr(peg$currPos, 34);
                            peg$currPos += 34;
                          } else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c411); }
                          }
                          if (s1 === peg$FAILED) {
                            if (input.substr(peg$currPos, 28).toLowerCase() === peg$c412) {
                              s1 = input.substr(peg$currPos, 28);
                              peg$currPos += 28;
                            } else {
                              s1 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c413); }
                            }
                            if (s1 === peg$FAILED) {
                              if (input.substr(peg$currPos, 34).toLowerCase() === peg$c414) {
                                s1 = input.substr(peg$currPos, 34);
                                peg$currPos += 34;
                              } else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c415); }
                              }
                              if (s1 === peg$FAILED) {
                                if (input.substr(peg$currPos, 25).toLowerCase() === peg$c416) {
                                  s1 = input.substr(peg$currPos, 25);
                                  peg$currPos += 25;
                                } else {
                                  s1 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c417); }
                                }
                                if (s1 === peg$FAILED) {
                                  if (input.substr(peg$currPos, 31).toLowerCase() === peg$c418) {
                                    s1 = input.substr(peg$currPos, 31);
                                    peg$currPos += 31;
                                  } else {
                                    s1 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c419); }
                                  }
                                  if (s1 === peg$FAILED) {
                                    if (input.substr(peg$currPos, 25).toLowerCase() === peg$c420) {
                                      s1 = input.substr(peg$currPos, 25);
                                      peg$currPos += 25;
                                    } else {
                                      s1 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c421); }
                                    }
                                    if (s1 === peg$FAILED) {
                                      if (input.substr(peg$currPos, 31).toLowerCase() === peg$c422) {
                                        s1 = input.substr(peg$currPos, 31);
                                        peg$currPos += 31;
                                      } else {
                                        s1 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$c423); }
                                      }
                                      if (s1 === peg$FAILED) {
                                        if (input.substr(peg$currPos, 27).toLowerCase() === peg$c424) {
                                          s1 = input.substr(peg$currPos, 27);
                                          peg$currPos += 27;
                                        } else {
                                          s1 = peg$FAILED;
                                          if (peg$silentFails === 0) { peg$fail(peg$c425); }
                                        }
                                        if (s1 === peg$FAILED) {
                                          if (input.substr(peg$currPos, 33).toLowerCase() === peg$c426) {
                                            s1 = input.substr(peg$currPos, 33);
                                            peg$currPos += 33;
                                          } else {
                                            s1 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$c427); }
                                          }
                                          if (s1 === peg$FAILED) {
                                            if (input.substr(peg$currPos, 35).toLowerCase() === peg$c428) {
                                              s1 = input.substr(peg$currPos, 35);
                                              peg$currPos += 35;
                                            } else {
                                              s1 = peg$FAILED;
                                              if (peg$silentFails === 0) { peg$fail(peg$c429); }
                                            }
                                            if (s1 === peg$FAILED) {
                                              if (input.substr(peg$currPos, 41).toLowerCase() === peg$c430) {
                                                s1 = input.substr(peg$currPos, 41);
                                                peg$currPos += 41;
                                              } else {
                                                s1 = peg$FAILED;
                                                if (peg$silentFails === 0) { peg$fail(peg$c431); }
                                              }
                                              if (s1 === peg$FAILED) {
                                                if (input.substr(peg$currPos, 35).toLowerCase() === peg$c432) {
                                                  s1 = input.substr(peg$currPos, 35);
                                                  peg$currPos += 35;
                                                } else {
                                                  s1 = peg$FAILED;
                                                  if (peg$silentFails === 0) { peg$fail(peg$c433); }
                                                }
                                                if (s1 === peg$FAILED) {
                                                  if (input.substr(peg$currPos, 41).toLowerCase() === peg$c434) {
                                                    s1 = input.substr(peg$currPos, 41);
                                                    peg$currPos += 41;
                                                  } else {
                                                    s1 = peg$FAILED;
                                                    if (peg$silentFails === 0) { peg$fail(peg$c435); }
                                                  }
                                                  if (s1 === peg$FAILED) {
                                                    if (input.substr(peg$currPos, 37).toLowerCase() === peg$c436) {
                                                      s1 = input.substr(peg$currPos, 37);
                                                      peg$currPos += 37;
                                                    } else {
                                                      s1 = peg$FAILED;
                                                      if (peg$silentFails === 0) { peg$fail(peg$c437); }
                                                    }
                                                    if (s1 === peg$FAILED) {
                                                      if (input.substr(peg$currPos, 43).toLowerCase() === peg$c438) {
                                                        s1 = input.substr(peg$currPos, 43);
                                                        peg$currPos += 43;
                                                      } else {
                                                        s1 = peg$FAILED;
                                                        if (peg$silentFails === 0) { peg$fail(peg$c439); }
                                                      }
                                                      if (s1 === peg$FAILED) {
                                                        if (input.substr(peg$currPos, 27).toLowerCase() === peg$c440) {
                                                          s1 = input.substr(peg$currPos, 27);
                                                          peg$currPos += 27;
                                                        } else {
                                                          s1 = peg$FAILED;
                                                          if (peg$silentFails === 0) { peg$fail(peg$c441); }
                                                        }
                                                        if (s1 === peg$FAILED) {
                                                          if (input.substr(peg$currPos, 33).toLowerCase() === peg$c442) {
                                                            s1 = input.substr(peg$currPos, 33);
                                                            peg$currPos += 33;
                                                          } else {
                                                            s1 = peg$FAILED;
                                                            if (peg$silentFails === 0) { peg$fail(peg$c443); }
                                                          }
                                                          if (s1 === peg$FAILED) {
                                                            if (input.substr(peg$currPos, 18).toLowerCase() === peg$c444) {
                                                              s1 = input.substr(peg$currPos, 18);
                                                              peg$currPos += 18;
                                                            } else {
                                                              s1 = peg$FAILED;
                                                              if (peg$silentFails === 0) { peg$fail(peg$c445); }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parse_();
      if (s3 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 61) {
          s4 = peg$c346;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c347); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parse_();
          if (s5 !== peg$FAILED) {
            s6 = peg$parseexpression();
            if (s6 !== peg$FAILED) {
              s3 = [s3, s4, s5, s6];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_table_of() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22, s23, s24, s25, s26, s27, s28, s29;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseCREATE();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          s5 = peg$currPos;
          s6 = peg$parseGLOBAL();
          if (s6 !== peg$FAILED) {
            s7 = peg$parse__();
            if (s7 !== peg$FAILED) {
              s6 = [s6, s7];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 === peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parseLOCAL();
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          }
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseTEMPORARY();
            if (s6 === peg$FAILED) {
              s6 = peg$parseTEMP();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s5 = [s5, s6, s7];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 === peg$FAILED) {
            s4 = peg$currPos;
            s5 = peg$parseUNLOGGED();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parseTABLE();
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseIF_NOT_EXISTS();
                if (s8 !== peg$FAILED) {
                  s7 = [s7, s8];
                  s6 = s7;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
              if (s6 === peg$FAILED) {
                s6 = null;
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parse__();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsetable_name();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parse__();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parseOF();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parse__();
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parseidentifier();
                          if (s12 !== peg$FAILED) {
                            s13 = peg$currPos;
                            s14 = peg$parse_();
                            if (s14 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 40) {
                                s15 = peg$c237;
                                peg$currPos++;
                              } else {
                                s15 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c238); }
                              }
                              if (s15 !== peg$FAILED) {
                                s16 = peg$parse_();
                                if (s16 !== peg$FAILED) {
                                  s17 = peg$parsetable_properties_of();
                                  if (s17 !== peg$FAILED) {
                                    s18 = peg$parse_();
                                    if (s18 !== peg$FAILED) {
                                      if (input.charCodeAt(peg$currPos) === 41) {
                                        s19 = peg$c239;
                                        peg$currPos++;
                                      } else {
                                        s19 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                      }
                                      if (s19 !== peg$FAILED) {
                                        s14 = [s14, s15, s16, s17, s18, s19];
                                        s13 = s14;
                                      } else {
                                        peg$currPos = s13;
                                        s13 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s13;
                                      s13 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s13;
                                    s13 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s13;
                                  s13 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s13;
                                s13 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s13;
                              s13 = peg$FAILED;
                            }
                            if (s13 === peg$FAILED) {
                              s13 = null;
                            }
                            if (s13 !== peg$FAILED) {
                              s14 = peg$currPos;
                              s15 = peg$parse__();
                              if (s15 !== peg$FAILED) {
                                s16 = peg$parsePARTITION();
                                if (s16 !== peg$FAILED) {
                                  s17 = peg$parse__();
                                  if (s17 !== peg$FAILED) {
                                    s18 = peg$parseBY();
                                    if (s18 !== peg$FAILED) {
                                      s19 = peg$parse__();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parseRANGE();
                                        if (s20 === peg$FAILED) {
                                          s20 = peg$parseLIST();
                                          if (s20 === peg$FAILED) {
                                            s20 = peg$parseHASH();
                                          }
                                        }
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parse_();
                                          if (s21 !== peg$FAILED) {
                                            if (input.charCodeAt(peg$currPos) === 40) {
                                              s22 = peg$c237;
                                              peg$currPos++;
                                            } else {
                                              s22 = peg$FAILED;
                                              if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                            }
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parse_();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parsecolumn_name();
                                                if (s24 === peg$FAILED) {
                                                  s24 = peg$currPos;
                                                  if (input.charCodeAt(peg$currPos) === 40) {
                                                    s25 = peg$c237;
                                                    peg$currPos++;
                                                  } else {
                                                    s25 = peg$FAILED;
                                                    if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                                  }
                                                  if (s25 !== peg$FAILED) {
                                                    s26 = peg$parse_();
                                                    if (s26 !== peg$FAILED) {
                                                      s27 = peg$parseexpression();
                                                      if (s27 !== peg$FAILED) {
                                                        s28 = peg$parse_();
                                                        if (s28 !== peg$FAILED) {
                                                          if (input.charCodeAt(peg$currPos) === 41) {
                                                            s29 = peg$c239;
                                                            peg$currPos++;
                                                          } else {
                                                            s29 = peg$FAILED;
                                                            if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                          }
                                                          if (s29 !== peg$FAILED) {
                                                            s25 = [s25, s26, s27, s28, s29];
                                                            s24 = s25;
                                                          } else {
                                                            peg$currPos = s24;
                                                            s24 = peg$FAILED;
                                                          }
                                                        } else {
                                                          peg$currPos = s24;
                                                          s24 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s24;
                                                        s24 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s24;
                                                      s24 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s24;
                                                    s24 = peg$FAILED;
                                                  }
                                                }
                                                if (s24 !== peg$FAILED) {
                                                  s25 = peg$currPos;
                                                  s26 = peg$parse__();
                                                  if (s26 !== peg$FAILED) {
                                                    s27 = peg$parseCOLLATE();
                                                    if (s27 !== peg$FAILED) {
                                                      s28 = peg$parse__();
                                                      if (s28 !== peg$FAILED) {
                                                        s29 = peg$parseidentifier();
                                                        if (s29 !== peg$FAILED) {
                                                          s26 = [s26, s27, s28, s29];
                                                          s25 = s26;
                                                        } else {
                                                          peg$currPos = s25;
                                                          s25 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s25;
                                                        s25 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s25;
                                                      s25 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s25;
                                                    s25 = peg$FAILED;
                                                  }
                                                  if (s25 === peg$FAILED) {
                                                    s25 = null;
                                                  }
                                                  if (s25 !== peg$FAILED) {
                                                    s26 = peg$currPos;
                                                    s27 = peg$parse__();
                                                    if (s27 !== peg$FAILED) {
                                                      s28 = peg$parseopclasses();
                                                      if (s28 !== peg$FAILED) {
                                                        s27 = [s27, s28];
                                                        s26 = s27;
                                                      } else {
                                                        peg$currPos = s26;
                                                        s26 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s26;
                                                      s26 = peg$FAILED;
                                                    }
                                                    if (s26 === peg$FAILED) {
                                                      s26 = null;
                                                    }
                                                    if (s26 !== peg$FAILED) {
                                                      s27 = peg$parse_();
                                                      if (s27 !== peg$FAILED) {
                                                        if (input.charCodeAt(peg$currPos) === 41) {
                                                          s28 = peg$c239;
                                                          peg$currPos++;
                                                        } else {
                                                          s28 = peg$FAILED;
                                                          if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                        }
                                                        if (s28 !== peg$FAILED) {
                                                          s15 = [s15, s16, s17, s18, s19, s20, s21, s22, s23, s24, s25, s26, s27, s28];
                                                          s14 = s15;
                                                        } else {
                                                          peg$currPos = s14;
                                                          s14 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s14;
                                                        s14 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s14;
                                                      s14 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s14;
                                                    s14 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s14;
                                                  s14 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s14;
                                                s14 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s14;
                                              s14 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s14;
                                            s14 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s14;
                                          s14 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s14;
                                        s14 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s14;
                                      s14 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s14;
                                    s14 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s14;
                                  s14 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s14;
                                s14 = peg$FAILED;
                              }
                              if (s14 === peg$FAILED) {
                                s14 = null;
                              }
                              if (s14 !== peg$FAILED) {
                                s15 = peg$currPos;
                                s16 = peg$parse__();
                                if (s16 !== peg$FAILED) {
                                  s17 = peg$parseWITH();
                                  if (s17 !== peg$FAILED) {
                                    s18 = peg$parse_();
                                    if (s18 !== peg$FAILED) {
                                      if (input.charCodeAt(peg$currPos) === 40) {
                                        s19 = peg$c237;
                                        peg$currPos++;
                                      } else {
                                        s19 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                      }
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parse_();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parsestorage_parameters();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parse_();
                                            if (s22 !== peg$FAILED) {
                                              if (input.charCodeAt(peg$currPos) === 41) {
                                                s23 = peg$c239;
                                                peg$currPos++;
                                              } else {
                                                s23 = peg$FAILED;
                                                if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                              }
                                              if (s23 !== peg$FAILED) {
                                                s16 = [s16, s17, s18, s19, s20, s21, s22, s23];
                                                s15 = s16;
                                              } else {
                                                peg$currPos = s15;
                                                s15 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s15;
                                              s15 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s15;
                                            s15 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s15;
                                          s15 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s15;
                                        s15 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s15;
                                      s15 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s15;
                                    s15 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s15;
                                  s15 = peg$FAILED;
                                }
                                if (s15 === peg$FAILED) {
                                  s15 = peg$currPos;
                                  s16 = peg$parse__();
                                  if (s16 !== peg$FAILED) {
                                    s17 = peg$parseWITH();
                                    if (s17 !== peg$FAILED) {
                                      s18 = peg$parse__();
                                      if (s18 !== peg$FAILED) {
                                        s19 = peg$parseOIDS();
                                        if (s19 !== peg$FAILED) {
                                          s16 = [s16, s17, s18, s19];
                                          s15 = s16;
                                        } else {
                                          peg$currPos = s15;
                                          s15 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s15;
                                        s15 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s15;
                                      s15 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s15;
                                    s15 = peg$FAILED;
                                  }
                                  if (s15 === peg$FAILED) {
                                    s15 = peg$currPos;
                                    s16 = peg$parse__();
                                    if (s16 !== peg$FAILED) {
                                      s17 = peg$parseWITHOUT();
                                      if (s17 !== peg$FAILED) {
                                        s18 = peg$parse__();
                                        if (s18 !== peg$FAILED) {
                                          s19 = peg$parseOIDS();
                                          if (s19 !== peg$FAILED) {
                                            s16 = [s16, s17, s18, s19];
                                            s15 = s16;
                                          } else {
                                            peg$currPos = s15;
                                            s15 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s15;
                                          s15 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s15;
                                        s15 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s15;
                                      s15 = peg$FAILED;
                                    }
                                  }
                                }
                                if (s15 === peg$FAILED) {
                                  s15 = null;
                                }
                                if (s15 !== peg$FAILED) {
                                  s16 = peg$currPos;
                                  s17 = peg$parse__();
                                  if (s17 !== peg$FAILED) {
                                    s18 = peg$parseON();
                                    if (s18 !== peg$FAILED) {
                                      s19 = peg$parse__();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parseCOMMIT();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parse__();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$currPos;
                                            s23 = peg$parsePRESERVE();
                                            if (s23 !== peg$FAILED) {
                                              s24 = peg$parse__();
                                              if (s24 !== peg$FAILED) {
                                                s25 = peg$parseROWS();
                                                if (s25 !== peg$FAILED) {
                                                  s23 = [s23, s24, s25];
                                                  s22 = s23;
                                                } else {
                                                  peg$currPos = s22;
                                                  s22 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s22;
                                                s22 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s22;
                                              s22 = peg$FAILED;
                                            }
                                            if (s22 === peg$FAILED) {
                                              s22 = peg$currPos;
                                              s23 = peg$parseDELETE();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parse__();
                                                if (s24 !== peg$FAILED) {
                                                  s25 = peg$parseROWS();
                                                  if (s25 !== peg$FAILED) {
                                                    s23 = [s23, s24, s25];
                                                    s22 = s23;
                                                  } else {
                                                    peg$currPos = s22;
                                                    s22 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s22;
                                                  s22 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s22;
                                                s22 = peg$FAILED;
                                              }
                                              if (s22 === peg$FAILED) {
                                                s22 = peg$parseDROP();
                                              }
                                            }
                                            if (s22 !== peg$FAILED) {
                                              s17 = [s17, s18, s19, s20, s21, s22];
                                              s16 = s17;
                                            } else {
                                              peg$currPos = s16;
                                              s16 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s16;
                                            s16 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s16;
                                          s16 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s16;
                                        s16 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s16;
                                      s16 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s16;
                                    s16 = peg$FAILED;
                                  }
                                  if (s16 === peg$FAILED) {
                                    s16 = null;
                                  }
                                  if (s16 !== peg$FAILED) {
                                    s17 = peg$currPos;
                                    s18 = peg$parse__();
                                    if (s18 !== peg$FAILED) {
                                      s19 = peg$parseTABLESPACE();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parse__();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parseidentifier();
                                          if (s21 !== peg$FAILED) {
                                            s18 = [s18, s19, s20, s21];
                                            s17 = s18;
                                          } else {
                                            peg$currPos = s17;
                                            s17 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s17;
                                          s17 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s17;
                                        s17 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s17;
                                      s17 = peg$FAILED;
                                    }
                                    if (s17 === peg$FAILED) {
                                      s17 = null;
                                    }
                                    if (s17 !== peg$FAILED) {
                                      s18 = peg$parse_();
                                      if (s18 !== peg$FAILED) {
                                        s19 = peg$parsesemicolon();
                                        if (s19 !== peg$FAILED) {
                                          s20 = peg$parse_();
                                          if (s20 !== peg$FAILED) {
                                            peg$savedPos = s0;
                                            s1 = peg$c446(s8, s12);
                                            s0 = s1;
                                          } else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_properties_of() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$parsetable_property_of();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsetable_property_of();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse_();
              if (s8 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7, s8];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsetable_property_of();
              if (s7 !== peg$FAILED) {
                s8 = peg$parse_();
                if (s8 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7, s8];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_property_of() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsetable_constraint();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c350(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsecolumn_name();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parseWITH();
          if (s4 !== peg$FAILED) {
            s5 = peg$parse__();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseOPTIONS();
              if (s6 !== peg$FAILED) {
                s4 = [s4, s5, s6];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$currPos;
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsecolumn_constraint();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$currPos;
              s6 = peg$parse_();
              if (s6 !== peg$FAILED) {
                s7 = peg$parsecolumn_constraint();
                if (s7 !== peg$FAILED) {
                  s6 = [s6, s7];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c447(s1, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecreate_table_partition_of() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22, s23, s24, s25, s26, s27, s28, s29, s30, s31, s32;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseCREATE();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          s5 = peg$currPos;
          s6 = peg$parseGLOBAL();
          if (s6 !== peg$FAILED) {
            s7 = peg$parse__();
            if (s7 !== peg$FAILED) {
              s6 = [s6, s7];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          if (s5 === peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parseLOCAL();
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          }
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseTEMPORARY();
            if (s6 === peg$FAILED) {
              s6 = peg$parseTEMP();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s5 = [s5, s6, s7];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 === peg$FAILED) {
            s4 = peg$currPos;
            s5 = peg$parseUNLOGGED();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parseTABLE();
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseIF_NOT_EXISTS();
                if (s8 !== peg$FAILED) {
                  s7 = [s7, s8];
                  s6 = s7;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
              if (s6 === peg$FAILED) {
                s6 = null;
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parse__();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsetable_name();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parse__();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parsePARTITION();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parse__();
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parseOF();
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parse__();
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parsetable_name();
                              if (s14 !== peg$FAILED) {
                                s15 = peg$currPos;
                                s16 = peg$parse_();
                                if (s16 !== peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 40) {
                                    s17 = peg$c237;
                                    peg$currPos++;
                                  } else {
                                    s17 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                  }
                                  if (s17 !== peg$FAILED) {
                                    s18 = peg$parse_();
                                    if (s18 !== peg$FAILED) {
                                      s19 = peg$parsetable_properties_of();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parse_();
                                        if (s20 !== peg$FAILED) {
                                          if (input.charCodeAt(peg$currPos) === 41) {
                                            s21 = peg$c239;
                                            peg$currPos++;
                                          } else {
                                            s21 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                          }
                                          if (s21 !== peg$FAILED) {
                                            s16 = [s16, s17, s18, s19, s20, s21];
                                            s15 = s16;
                                          } else {
                                            peg$currPos = s15;
                                            s15 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s15;
                                          s15 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s15;
                                        s15 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s15;
                                      s15 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s15;
                                    s15 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s15;
                                  s15 = peg$FAILED;
                                }
                                if (s15 === peg$FAILED) {
                                  s15 = null;
                                }
                                if (s15 !== peg$FAILED) {
                                  s16 = peg$currPos;
                                  s17 = peg$parse__();
                                  if (s17 !== peg$FAILED) {
                                    s18 = peg$parseFOR();
                                    if (s18 !== peg$FAILED) {
                                      s19 = peg$parse__();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parseVALUES();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parse__();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parsepartition_bound_spec();
                                            if (s22 !== peg$FAILED) {
                                              s17 = [s17, s18, s19, s20, s21, s22];
                                              s16 = s17;
                                            } else {
                                              peg$currPos = s16;
                                              s16 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s16;
                                            s16 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s16;
                                          s16 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s16;
                                        s16 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s16;
                                      s16 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s16;
                                    s16 = peg$FAILED;
                                  }
                                  if (s16 === peg$FAILED) {
                                    s16 = peg$currPos;
                                    s17 = peg$parse__();
                                    if (s17 !== peg$FAILED) {
                                      s18 = peg$parseDEFAULT();
                                      if (s18 !== peg$FAILED) {
                                        s17 = [s17, s18];
                                        s16 = s17;
                                      } else {
                                        peg$currPos = s16;
                                        s16 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s16;
                                      s16 = peg$FAILED;
                                    }
                                  }
                                  if (s16 !== peg$FAILED) {
                                    s17 = peg$currPos;
                                    s18 = peg$parse__();
                                    if (s18 !== peg$FAILED) {
                                      s19 = peg$parsePARTITION();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parse__();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parseBY();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parse__();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parseRANGE();
                                              if (s23 === peg$FAILED) {
                                                s23 = peg$parseLIST();
                                                if (s23 === peg$FAILED) {
                                                  s23 = peg$parseHASH();
                                                }
                                              }
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parse_();
                                                if (s24 !== peg$FAILED) {
                                                  if (input.charCodeAt(peg$currPos) === 40) {
                                                    s25 = peg$c237;
                                                    peg$currPos++;
                                                  } else {
                                                    s25 = peg$FAILED;
                                                    if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                                  }
                                                  if (s25 !== peg$FAILED) {
                                                    s26 = peg$parse_();
                                                    if (s26 !== peg$FAILED) {
                                                      s27 = peg$parsecolumn_name();
                                                      if (s27 === peg$FAILED) {
                                                        s27 = peg$currPos;
                                                        if (input.charCodeAt(peg$currPos) === 40) {
                                                          s28 = peg$c237;
                                                          peg$currPos++;
                                                        } else {
                                                          s28 = peg$FAILED;
                                                          if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                                        }
                                                        if (s28 !== peg$FAILED) {
                                                          s29 = peg$parse_();
                                                          if (s29 !== peg$FAILED) {
                                                            s30 = peg$parseexpression();
                                                            if (s30 !== peg$FAILED) {
                                                              s31 = peg$parse_();
                                                              if (s31 !== peg$FAILED) {
                                                                if (input.charCodeAt(peg$currPos) === 41) {
                                                                  s32 = peg$c239;
                                                                  peg$currPos++;
                                                                } else {
                                                                  s32 = peg$FAILED;
                                                                  if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                                }
                                                                if (s32 !== peg$FAILED) {
                                                                  s28 = [s28, s29, s30, s31, s32];
                                                                  s27 = s28;
                                                                } else {
                                                                  peg$currPos = s27;
                                                                  s27 = peg$FAILED;
                                                                }
                                                              } else {
                                                                peg$currPos = s27;
                                                                s27 = peg$FAILED;
                                                              }
                                                            } else {
                                                              peg$currPos = s27;
                                                              s27 = peg$FAILED;
                                                            }
                                                          } else {
                                                            peg$currPos = s27;
                                                            s27 = peg$FAILED;
                                                          }
                                                        } else {
                                                          peg$currPos = s27;
                                                          s27 = peg$FAILED;
                                                        }
                                                      }
                                                      if (s27 !== peg$FAILED) {
                                                        s28 = peg$currPos;
                                                        s29 = peg$parse__();
                                                        if (s29 !== peg$FAILED) {
                                                          s30 = peg$parseCOLLATE();
                                                          if (s30 !== peg$FAILED) {
                                                            s31 = peg$parse__();
                                                            if (s31 !== peg$FAILED) {
                                                              s32 = peg$parseidentifier();
                                                              if (s32 !== peg$FAILED) {
                                                                s29 = [s29, s30, s31, s32];
                                                                s28 = s29;
                                                              } else {
                                                                peg$currPos = s28;
                                                                s28 = peg$FAILED;
                                                              }
                                                            } else {
                                                              peg$currPos = s28;
                                                              s28 = peg$FAILED;
                                                            }
                                                          } else {
                                                            peg$currPos = s28;
                                                            s28 = peg$FAILED;
                                                          }
                                                        } else {
                                                          peg$currPos = s28;
                                                          s28 = peg$FAILED;
                                                        }
                                                        if (s28 === peg$FAILED) {
                                                          s28 = null;
                                                        }
                                                        if (s28 !== peg$FAILED) {
                                                          s29 = peg$currPos;
                                                          s30 = peg$parse__();
                                                          if (s30 !== peg$FAILED) {
                                                            s31 = peg$parseopclasses();
                                                            if (s31 !== peg$FAILED) {
                                                              s30 = [s30, s31];
                                                              s29 = s30;
                                                            } else {
                                                              peg$currPos = s29;
                                                              s29 = peg$FAILED;
                                                            }
                                                          } else {
                                                            peg$currPos = s29;
                                                            s29 = peg$FAILED;
                                                          }
                                                          if (s29 === peg$FAILED) {
                                                            s29 = null;
                                                          }
                                                          if (s29 !== peg$FAILED) {
                                                            s30 = peg$parse_();
                                                            if (s30 !== peg$FAILED) {
                                                              if (input.charCodeAt(peg$currPos) === 41) {
                                                                s31 = peg$c239;
                                                                peg$currPos++;
                                                              } else {
                                                                s31 = peg$FAILED;
                                                                if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                              }
                                                              if (s31 !== peg$FAILED) {
                                                                s18 = [s18, s19, s20, s21, s22, s23, s24, s25, s26, s27, s28, s29, s30, s31];
                                                                s17 = s18;
                                                              } else {
                                                                peg$currPos = s17;
                                                                s17 = peg$FAILED;
                                                              }
                                                            } else {
                                                              peg$currPos = s17;
                                                              s17 = peg$FAILED;
                                                            }
                                                          } else {
                                                            peg$currPos = s17;
                                                            s17 = peg$FAILED;
                                                          }
                                                        } else {
                                                          peg$currPos = s17;
                                                          s17 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s17;
                                                        s17 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s17;
                                                      s17 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s17;
                                                    s17 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s17;
                                                  s17 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s17;
                                                s17 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s17;
                                              s17 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s17;
                                            s17 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s17;
                                          s17 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s17;
                                        s17 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s17;
                                      s17 = peg$FAILED;
                                    }
                                    if (s17 === peg$FAILED) {
                                      s17 = null;
                                    }
                                    if (s17 !== peg$FAILED) {
                                      s18 = peg$currPos;
                                      s19 = peg$parse__();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parseWITH();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parse_();
                                          if (s21 !== peg$FAILED) {
                                            if (input.charCodeAt(peg$currPos) === 40) {
                                              s22 = peg$c237;
                                              peg$currPos++;
                                            } else {
                                              s22 = peg$FAILED;
                                              if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                            }
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parse_();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parsestorage_parameters();
                                                if (s24 !== peg$FAILED) {
                                                  s25 = peg$parse_();
                                                  if (s25 !== peg$FAILED) {
                                                    if (input.charCodeAt(peg$currPos) === 41) {
                                                      s26 = peg$c239;
                                                      peg$currPos++;
                                                    } else {
                                                      s26 = peg$FAILED;
                                                      if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                    }
                                                    if (s26 !== peg$FAILED) {
                                                      s19 = [s19, s20, s21, s22, s23, s24, s25, s26];
                                                      s18 = s19;
                                                    } else {
                                                      peg$currPos = s18;
                                                      s18 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s18;
                                                    s18 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s18;
                                                  s18 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s18;
                                                s18 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s18;
                                              s18 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s18;
                                            s18 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s18;
                                          s18 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s18;
                                        s18 = peg$FAILED;
                                      }
                                      if (s18 === peg$FAILED) {
                                        s18 = peg$currPos;
                                        s19 = peg$parse__();
                                        if (s19 !== peg$FAILED) {
                                          s20 = peg$parseWITH();
                                          if (s20 !== peg$FAILED) {
                                            s21 = peg$parse__();
                                            if (s21 !== peg$FAILED) {
                                              s22 = peg$parseOIDS();
                                              if (s22 !== peg$FAILED) {
                                                s19 = [s19, s20, s21, s22];
                                                s18 = s19;
                                              } else {
                                                peg$currPos = s18;
                                                s18 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s18;
                                              s18 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s18;
                                            s18 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s18;
                                          s18 = peg$FAILED;
                                        }
                                        if (s18 === peg$FAILED) {
                                          s18 = peg$currPos;
                                          s19 = peg$parse__();
                                          if (s19 !== peg$FAILED) {
                                            s20 = peg$parseWITHOUT();
                                            if (s20 !== peg$FAILED) {
                                              s21 = peg$parse__();
                                              if (s21 !== peg$FAILED) {
                                                s22 = peg$parseOIDS();
                                                if (s22 !== peg$FAILED) {
                                                  s19 = [s19, s20, s21, s22];
                                                  s18 = s19;
                                                } else {
                                                  peg$currPos = s18;
                                                  s18 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s18;
                                                s18 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s18;
                                              s18 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s18;
                                            s18 = peg$FAILED;
                                          }
                                        }
                                      }
                                      if (s18 === peg$FAILED) {
                                        s18 = null;
                                      }
                                      if (s18 !== peg$FAILED) {
                                        s19 = peg$currPos;
                                        s20 = peg$parse__();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parseON();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parse__();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parseCOMMIT();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parse__();
                                                if (s24 !== peg$FAILED) {
                                                  s25 = peg$currPos;
                                                  s26 = peg$parsePRESERVE();
                                                  if (s26 !== peg$FAILED) {
                                                    s27 = peg$parse__();
                                                    if (s27 !== peg$FAILED) {
                                                      s28 = peg$parseROWS();
                                                      if (s28 !== peg$FAILED) {
                                                        s26 = [s26, s27, s28];
                                                        s25 = s26;
                                                      } else {
                                                        peg$currPos = s25;
                                                        s25 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s25;
                                                      s25 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s25;
                                                    s25 = peg$FAILED;
                                                  }
                                                  if (s25 === peg$FAILED) {
                                                    s25 = peg$currPos;
                                                    s26 = peg$parseDELETE();
                                                    if (s26 !== peg$FAILED) {
                                                      s27 = peg$parse__();
                                                      if (s27 !== peg$FAILED) {
                                                        s28 = peg$parseROWS();
                                                        if (s28 !== peg$FAILED) {
                                                          s26 = [s26, s27, s28];
                                                          s25 = s26;
                                                        } else {
                                                          peg$currPos = s25;
                                                          s25 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s25;
                                                        s25 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s25;
                                                      s25 = peg$FAILED;
                                                    }
                                                    if (s25 === peg$FAILED) {
                                                      s25 = peg$parseDROP();
                                                    }
                                                  }
                                                  if (s25 !== peg$FAILED) {
                                                    s20 = [s20, s21, s22, s23, s24, s25];
                                                    s19 = s20;
                                                  } else {
                                                    peg$currPos = s19;
                                                    s19 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s19;
                                                  s19 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s19;
                                                s19 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s19;
                                              s19 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s19;
                                            s19 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s19;
                                          s19 = peg$FAILED;
                                        }
                                        if (s19 === peg$FAILED) {
                                          s19 = null;
                                        }
                                        if (s19 !== peg$FAILED) {
                                          s20 = peg$currPos;
                                          s21 = peg$parse__();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parseTABLESPACE();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parse__();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parseidentifier();
                                                if (s24 !== peg$FAILED) {
                                                  s21 = [s21, s22, s23, s24];
                                                  s20 = s21;
                                                } else {
                                                  peg$currPos = s20;
                                                  s20 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s20;
                                                s20 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s20;
                                              s20 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s20;
                                            s20 = peg$FAILED;
                                          }
                                          if (s20 === peg$FAILED) {
                                            s20 = null;
                                          }
                                          if (s20 !== peg$FAILED) {
                                            s21 = peg$parse_();
                                            if (s21 !== peg$FAILED) {
                                              s22 = peg$parsesemicolon();
                                              if (s22 !== peg$FAILED) {
                                                s23 = peg$parse_();
                                                if (s23 !== peg$FAILED) {
                                                  peg$savedPos = s0;
                                                  s1 = peg$c448(s8, s14);
                                                  s0 = s1;
                                                } else {
                                                  peg$currPos = s0;
                                                  s0 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s0;
                                                s0 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s0;
                                              s0 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsepartition_bound_spec() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parseIN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse_();
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 40) {
          s3 = peg$c237;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c238); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            s5 = peg$parsein_bound_spec_list();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse_();
              if (s6 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 41) {
                  s7 = peg$c239;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c240); }
                }
                if (s7 !== peg$FAILED) {
                  s1 = [s1, s2, s3, s4, s5, s6, s7];
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseFROM();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse_();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 40) {
            s3 = peg$c237;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c238); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
              s5 = peg$parsefrom_to_bound_spec_list();
              if (s5 !== peg$FAILED) {
                s6 = peg$parse_();
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s7 = peg$c239;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c240); }
                  }
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parse_();
                    if (s8 !== peg$FAILED) {
                      s9 = peg$parseTO();
                      if (s9 !== peg$FAILED) {
                        s10 = peg$parse_();
                        if (s10 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 40) {
                            s11 = peg$c237;
                            peg$currPos++;
                          } else {
                            s11 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c238); }
                          }
                          if (s11 !== peg$FAILED) {
                            s12 = peg$parse_();
                            if (s12 !== peg$FAILED) {
                              s13 = peg$parsefrom_to_bound_spec_list();
                              if (s13 !== peg$FAILED) {
                                s14 = peg$parse_();
                                if (s14 !== peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 41) {
                                    s15 = peg$c239;
                                    peg$currPos++;
                                  } else {
                                    s15 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                  }
                                  if (s15 !== peg$FAILED) {
                                    s1 = [s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15];
                                    s0 = s1;
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseWITH();
        if (s1 !== peg$FAILED) {
          s2 = peg$parse_();
          if (s2 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 40) {
              s3 = peg$c237;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c238); }
            }
            if (s3 !== peg$FAILED) {
              s4 = peg$parse_();
              if (s4 !== peg$FAILED) {
                s5 = peg$parseMODULUS();
                if (s5 !== peg$FAILED) {
                  s6 = peg$parse__();
                  if (s6 !== peg$FAILED) {
                    s7 = peg$parsenumeric_constant();
                    if (s7 !== peg$FAILED) {
                      s8 = peg$parse_();
                      if (s8 !== peg$FAILED) {
                        s9 = peg$parsecomma();
                        if (s9 !== peg$FAILED) {
                          s10 = peg$parse_();
                          if (s10 !== peg$FAILED) {
                            s11 = peg$parseREMAINDER();
                            if (s11 !== peg$FAILED) {
                              s12 = peg$parse__();
                              if (s12 !== peg$FAILED) {
                                s13 = peg$parsenumeric_constant();
                                if (s13 !== peg$FAILED) {
                                  s14 = peg$parse_();
                                  if (s14 !== peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 41) {
                                      s15 = peg$c239;
                                      peg$currPos++;
                                    } else {
                                      s15 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                    }
                                    if (s15 !== peg$FAILED) {
                                      s1 = [s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15];
                                      s0 = s1;
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsein_bound_spec_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsein_bound_spec();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsein_bound_spec();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsein_bound_spec();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsein_bound_spec() {
    var s0;

    s0 = peg$parsenumeric_constant();
    if (s0 === peg$FAILED) {
      s0 = peg$parsestring_constant();
      if (s0 === peg$FAILED) {
        s0 = peg$parseTRUE();
        if (s0 === peg$FAILED) {
          s0 = peg$parseFALSE();
          if (s0 === peg$FAILED) {
            s0 = peg$parseNULL();
          }
        }
      }
    }

    return s0;
  }

  function peg$parsefrom_to_bound_spec_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsefrom_to_bound_spec();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsefrom_to_bound_spec();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsefrom_to_bound_spec();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefrom_to_bound_spec() {
    var s0;

    s0 = peg$parsenumeric_constant();
    if (s0 === peg$FAILED) {
      s0 = peg$parsestring_constant();
      if (s0 === peg$FAILED) {
        s0 = peg$parseTRUE();
        if (s0 === peg$FAILED) {
          s0 = peg$parseFALSE();
          if (s0 === peg$FAILED) {
            s0 = peg$parseMINVALUE();
            if (s0 === peg$FAILED) {
              s0 = peg$parseMAXVALUE();
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecreate_table() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsecreate_table_normal();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c449(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsecreate_table_of();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c450(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsecreate_table_partition_of();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c451(s1);
        }
        s0 = s1;
      }
    }

    return s0;
  }

  function peg$parsecreate_type_enum() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseCREATE();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseTYPE();
          if (s4 !== peg$FAILED) {
            s5 = peg$parse__();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseenum_name();
              if (s6 !== peg$FAILED) {
                s7 = peg$parse__();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseAS();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parse__();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parseENUM();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parse_();
                        if (s11 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 40) {
                            s12 = peg$c237;
                            peg$currPos++;
                          } else {
                            s12 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c238); }
                          }
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parse_();
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parselabels();
                              if (s14 !== peg$FAILED) {
                                s15 = peg$parse_();
                                if (s15 !== peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 41) {
                                    s16 = peg$c239;
                                    peg$currPos++;
                                  } else {
                                    s16 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                  }
                                  if (s16 !== peg$FAILED) {
                                    s17 = peg$parse_();
                                    if (s17 !== peg$FAILED) {
                                      s18 = peg$parsesemicolon();
                                      if (s18 !== peg$FAILED) {
                                        s19 = peg$parse_();
                                        if (s19 !== peg$FAILED) {
                                          peg$savedPos = s0;
                                          s1 = peg$c452(s6, s14);
                                          s0 = s1;
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parselabels() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsestring_constant();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parsestring_constant();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parsestring_constant();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c453(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_type_range() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22, s23, s24, s25, s26, s27, s28, s29, s30;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseCREATE();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseTYPE();
          if (s4 !== peg$FAILED) {
            s5 = peg$parse__();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseidentifier();
              if (s6 !== peg$FAILED) {
                s7 = peg$parse__();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseAS();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parse__();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parseRANGE();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parse_();
                        if (s11 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 40) {
                            s12 = peg$c237;
                            peg$currPos++;
                          } else {
                            s12 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c238); }
                          }
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parse_();
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parseSUBTYPE();
                              if (s14 !== peg$FAILED) {
                                s15 = peg$parse_();
                                if (s15 !== peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 61) {
                                    s16 = peg$c346;
                                    peg$currPos++;
                                  } else {
                                    s16 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c347); }
                                  }
                                  if (s16 !== peg$FAILED) {
                                    s17 = peg$parse_();
                                    if (s17 !== peg$FAILED) {
                                      s18 = peg$parseexpression();
                                      if (s18 !== peg$FAILED) {
                                        s19 = peg$currPos;
                                        s20 = peg$parse_();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parsecomma();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parse_();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parseSUBTYPE_OPCLASS();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parse_();
                                                if (s24 !== peg$FAILED) {
                                                  if (input.charCodeAt(peg$currPos) === 61) {
                                                    s25 = peg$c346;
                                                    peg$currPos++;
                                                  } else {
                                                    s25 = peg$FAILED;
                                                    if (peg$silentFails === 0) { peg$fail(peg$c347); }
                                                  }
                                                  if (s25 !== peg$FAILED) {
                                                    s26 = peg$parse_();
                                                    if (s26 !== peg$FAILED) {
                                                      s27 = peg$parseexpression();
                                                      if (s27 !== peg$FAILED) {
                                                        s20 = [s20, s21, s22, s23, s24, s25, s26, s27];
                                                        s19 = s20;
                                                      } else {
                                                        peg$currPos = s19;
                                                        s19 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s19;
                                                      s19 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s19;
                                                    s19 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s19;
                                                  s19 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s19;
                                                s19 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s19;
                                              s19 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s19;
                                            s19 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s19;
                                          s19 = peg$FAILED;
                                        }
                                        if (s19 === peg$FAILED) {
                                          s19 = null;
                                        }
                                        if (s19 !== peg$FAILED) {
                                          s20 = peg$currPos;
                                          s21 = peg$parse_();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parsecomma();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parse_();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parseCOLLATE();
                                                if (s24 !== peg$FAILED) {
                                                  s25 = peg$parse_();
                                                  if (s25 !== peg$FAILED) {
                                                    if (input.charCodeAt(peg$currPos) === 61) {
                                                      s26 = peg$c346;
                                                      peg$currPos++;
                                                    } else {
                                                      s26 = peg$FAILED;
                                                      if (peg$silentFails === 0) { peg$fail(peg$c347); }
                                                    }
                                                    if (s26 !== peg$FAILED) {
                                                      s27 = peg$parse_();
                                                      if (s27 !== peg$FAILED) {
                                                        s28 = peg$parseidentifier();
                                                        if (s28 !== peg$FAILED) {
                                                          s21 = [s21, s22, s23, s24, s25, s26, s27, s28];
                                                          s20 = s21;
                                                        } else {
                                                          peg$currPos = s20;
                                                          s20 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s20;
                                                        s20 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s20;
                                                      s20 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s20;
                                                    s20 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s20;
                                                  s20 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s20;
                                                s20 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s20;
                                              s20 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s20;
                                            s20 = peg$FAILED;
                                          }
                                          if (s20 === peg$FAILED) {
                                            s20 = null;
                                          }
                                          if (s20 !== peg$FAILED) {
                                            s21 = peg$currPos;
                                            s22 = peg$parse_();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parsecomma();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parse_();
                                                if (s24 !== peg$FAILED) {
                                                  s25 = peg$parseCANONICAL();
                                                  if (s25 !== peg$FAILED) {
                                                    s26 = peg$parse_();
                                                    if (s26 !== peg$FAILED) {
                                                      if (input.charCodeAt(peg$currPos) === 61) {
                                                        s27 = peg$c346;
                                                        peg$currPos++;
                                                      } else {
                                                        s27 = peg$FAILED;
                                                        if (peg$silentFails === 0) { peg$fail(peg$c347); }
                                                      }
                                                      if (s27 !== peg$FAILED) {
                                                        s28 = peg$parse_();
                                                        if (s28 !== peg$FAILED) {
                                                          s29 = peg$parseexpression();
                                                          if (s29 !== peg$FAILED) {
                                                            s22 = [s22, s23, s24, s25, s26, s27, s28, s29];
                                                            s21 = s22;
                                                          } else {
                                                            peg$currPos = s21;
                                                            s21 = peg$FAILED;
                                                          }
                                                        } else {
                                                          peg$currPos = s21;
                                                          s21 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s21;
                                                        s21 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s21;
                                                      s21 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s21;
                                                    s21 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s21;
                                                  s21 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s21;
                                                s21 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s21;
                                              s21 = peg$FAILED;
                                            }
                                            if (s21 === peg$FAILED) {
                                              s21 = null;
                                            }
                                            if (s21 !== peg$FAILED) {
                                              s22 = peg$currPos;
                                              s23 = peg$parse_();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parsecomma();
                                                if (s24 !== peg$FAILED) {
                                                  s25 = peg$parse_();
                                                  if (s25 !== peg$FAILED) {
                                                    s26 = peg$parseSUBTYPE_DIFF();
                                                    if (s26 !== peg$FAILED) {
                                                      s27 = peg$parse_();
                                                      if (s27 !== peg$FAILED) {
                                                        if (input.charCodeAt(peg$currPos) === 61) {
                                                          s28 = peg$c346;
                                                          peg$currPos++;
                                                        } else {
                                                          s28 = peg$FAILED;
                                                          if (peg$silentFails === 0) { peg$fail(peg$c347); }
                                                        }
                                                        if (s28 !== peg$FAILED) {
                                                          s29 = peg$parse_();
                                                          if (s29 !== peg$FAILED) {
                                                            s30 = peg$parseexpression();
                                                            if (s30 !== peg$FAILED) {
                                                              s23 = [s23, s24, s25, s26, s27, s28, s29, s30];
                                                              s22 = s23;
                                                            } else {
                                                              peg$currPos = s22;
                                                              s22 = peg$FAILED;
                                                            }
                                                          } else {
                                                            peg$currPos = s22;
                                                            s22 = peg$FAILED;
                                                          }
                                                        } else {
                                                          peg$currPos = s22;
                                                          s22 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s22;
                                                        s22 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s22;
                                                      s22 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s22;
                                                    s22 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s22;
                                                  s22 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s22;
                                                s22 = peg$FAILED;
                                              }
                                              if (s22 === peg$FAILED) {
                                                s22 = null;
                                              }
                                              if (s22 !== peg$FAILED) {
                                                s23 = peg$parse_();
                                                if (s23 !== peg$FAILED) {
                                                  if (input.charCodeAt(peg$currPos) === 41) {
                                                    s24 = peg$c239;
                                                    peg$currPos++;
                                                  } else {
                                                    s24 = peg$FAILED;
                                                    if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                  }
                                                  if (s24 !== peg$FAILED) {
                                                    s25 = peg$parse_();
                                                    if (s25 !== peg$FAILED) {
                                                      s26 = peg$parsesemicolon();
                                                      if (s26 !== peg$FAILED) {
                                                        s27 = peg$parse_();
                                                        if (s27 !== peg$FAILED) {
                                                          peg$savedPos = s0;
                                                          s1 = peg$c454(s6, s18);
                                                          s0 = s1;
                                                        } else {
                                                          peg$currPos = s0;
                                                          s0 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s0;
                                                        s0 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s0;
                                                      s0 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s0;
                                                    s0 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s0;
                                                  s0 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s0;
                                                s0 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s0;
                                              s0 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_type() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsecreate_type_enum();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c455(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsecreate_type_range();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c456(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsealter_table() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsealter_table_action();
    if (s1 === peg$FAILED) {
      s1 = peg$parsealter_table_rename();
      if (s1 === peg$FAILED) {
        s1 = peg$parsealter_table_set_schema();
        if (s1 === peg$FAILED) {
          s1 = peg$parsealter_table_set_tablespace();
          if (s1 === peg$FAILED) {
            s1 = peg$parsealter_table_attach();
            if (s1 === peg$FAILED) {
              s1 = peg$parsealter_table_detach();
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c457(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsealter_table_rename() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseALTER();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseTABLE();
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parse__();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseIF_EXISTS();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseONLY();
                if (s8 !== peg$FAILED) {
                  s7 = [s7, s8];
                  s6 = s7;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
              if (s6 === peg$FAILED) {
                s6 = null;
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parse__();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsetable_name();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$currPos;
                    s10 = peg$parse_();
                    if (s10 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 42) {
                        s11 = peg$c458;
                        peg$currPos++;
                      } else {
                        s11 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c459); }
                      }
                      if (s11 !== peg$FAILED) {
                        s10 = [s10, s11];
                        s9 = s10;
                      } else {
                        peg$currPos = s9;
                        s9 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                    if (s9 === peg$FAILED) {
                      s9 = null;
                    }
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parse__();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parseRENAME();
                        if (s11 !== peg$FAILED) {
                          s12 = [];
                          s13 = peg$parsecmt();
                          if (s13 === peg$FAILED) {
                            s13 = peg$currPos;
                            s14 = peg$currPos;
                            peg$silentFails++;
                            s15 = peg$parsesemicolon();
                            peg$silentFails--;
                            if (s15 === peg$FAILED) {
                              s14 = void 0;
                            } else {
                              peg$currPos = s14;
                              s14 = peg$FAILED;
                            }
                            if (s14 !== peg$FAILED) {
                              if (input.length > peg$currPos) {
                                s15 = input.charAt(peg$currPos);
                                peg$currPos++;
                              } else {
                                s15 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c245); }
                              }
                              if (s15 !== peg$FAILED) {
                                s14 = [s14, s15];
                                s13 = s14;
                              } else {
                                peg$currPos = s13;
                                s13 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s13;
                              s13 = peg$FAILED;
                            }
                          }
                          while (s13 !== peg$FAILED) {
                            s12.push(s13);
                            s13 = peg$parsecmt();
                            if (s13 === peg$FAILED) {
                              s13 = peg$currPos;
                              s14 = peg$currPos;
                              peg$silentFails++;
                              s15 = peg$parsesemicolon();
                              peg$silentFails--;
                              if (s15 === peg$FAILED) {
                                s14 = void 0;
                              } else {
                                peg$currPos = s14;
                                s14 = peg$FAILED;
                              }
                              if (s14 !== peg$FAILED) {
                                if (input.length > peg$currPos) {
                                  s15 = input.charAt(peg$currPos);
                                  peg$currPos++;
                                } else {
                                  s15 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c245); }
                                }
                                if (s15 !== peg$FAILED) {
                                  s14 = [s14, s15];
                                  s13 = s14;
                                } else {
                                  peg$currPos = s13;
                                  s13 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s13;
                                s13 = peg$FAILED;
                              }
                            }
                          }
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parse_();
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parsesemicolon();
                              if (s14 !== peg$FAILED) {
                                s15 = peg$parse_();
                                if (s15 !== peg$FAILED) {
                                  peg$savedPos = s0;
                                  s1 = peg$c460();
                                  s0 = s1;
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_table_set_schema() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseALTER();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseTABLE();
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parse__();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseIF_EXISTS();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              if (s6 !== peg$FAILED) {
                s7 = peg$parsetable_name();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parse__();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseSET();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parse__();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parseSCHEMA();
                        if (s11 !== peg$FAILED) {
                          s12 = [];
                          s13 = peg$parsecmt();
                          if (s13 === peg$FAILED) {
                            s13 = peg$currPos;
                            s14 = peg$currPos;
                            peg$silentFails++;
                            s15 = peg$parsesemicolon();
                            peg$silentFails--;
                            if (s15 === peg$FAILED) {
                              s14 = void 0;
                            } else {
                              peg$currPos = s14;
                              s14 = peg$FAILED;
                            }
                            if (s14 !== peg$FAILED) {
                              if (input.length > peg$currPos) {
                                s15 = input.charAt(peg$currPos);
                                peg$currPos++;
                              } else {
                                s15 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c245); }
                              }
                              if (s15 !== peg$FAILED) {
                                s14 = [s14, s15];
                                s13 = s14;
                              } else {
                                peg$currPos = s13;
                                s13 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s13;
                              s13 = peg$FAILED;
                            }
                          }
                          while (s13 !== peg$FAILED) {
                            s12.push(s13);
                            s13 = peg$parsecmt();
                            if (s13 === peg$FAILED) {
                              s13 = peg$currPos;
                              s14 = peg$currPos;
                              peg$silentFails++;
                              s15 = peg$parsesemicolon();
                              peg$silentFails--;
                              if (s15 === peg$FAILED) {
                                s14 = void 0;
                              } else {
                                peg$currPos = s14;
                                s14 = peg$FAILED;
                              }
                              if (s14 !== peg$FAILED) {
                                if (input.length > peg$currPos) {
                                  s15 = input.charAt(peg$currPos);
                                  peg$currPos++;
                                } else {
                                  s15 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c245); }
                                }
                                if (s15 !== peg$FAILED) {
                                  s14 = [s14, s15];
                                  s13 = s14;
                                } else {
                                  peg$currPos = s13;
                                  s13 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s13;
                                s13 = peg$FAILED;
                              }
                            }
                          }
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parse_();
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parsesemicolon();
                              if (s14 !== peg$FAILED) {
                                s15 = peg$parse_();
                                if (s15 !== peg$FAILED) {
                                  peg$savedPos = s0;
                                  s1 = peg$c461();
                                  s0 = s1;
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_table_set_tablespace() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22, s23, s24, s25;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseALTER();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseTABLE();
          if (s4 !== peg$FAILED) {
            s5 = peg$parse__();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseALL();
              if (s6 !== peg$FAILED) {
                s7 = peg$parse__();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseIN();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parse__();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parseTABLESPACE();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parse__();
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parsetable_name();
                          if (s12 !== peg$FAILED) {
                            s13 = peg$currPos;
                            s14 = peg$parse__();
                            if (s14 !== peg$FAILED) {
                              s15 = peg$parseOWNED();
                              if (s15 !== peg$FAILED) {
                                s16 = peg$parse__();
                                if (s16 !== peg$FAILED) {
                                  s17 = peg$parseBY();
                                  if (s17 !== peg$FAILED) {
                                    s18 = peg$parse__();
                                    if (s18 !== peg$FAILED) {
                                      s19 = peg$parseidentifier();
                                      if (s19 !== peg$FAILED) {
                                        s20 = [];
                                        s21 = peg$currPos;
                                        s22 = peg$parse_();
                                        if (s22 !== peg$FAILED) {
                                          s23 = peg$parsecomma();
                                          if (s23 !== peg$FAILED) {
                                            s24 = peg$parse_();
                                            if (s24 !== peg$FAILED) {
                                              s25 = peg$parseidentifier();
                                              if (s25 !== peg$FAILED) {
                                                s22 = [s22, s23, s24, s25];
                                                s21 = s22;
                                              } else {
                                                peg$currPos = s21;
                                                s21 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s21;
                                              s21 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s21;
                                            s21 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s21;
                                          s21 = peg$FAILED;
                                        }
                                        while (s21 !== peg$FAILED) {
                                          s20.push(s21);
                                          s21 = peg$currPos;
                                          s22 = peg$parse_();
                                          if (s22 !== peg$FAILED) {
                                            s23 = peg$parsecomma();
                                            if (s23 !== peg$FAILED) {
                                              s24 = peg$parse_();
                                              if (s24 !== peg$FAILED) {
                                                s25 = peg$parseidentifier();
                                                if (s25 !== peg$FAILED) {
                                                  s22 = [s22, s23, s24, s25];
                                                  s21 = s22;
                                                } else {
                                                  peg$currPos = s21;
                                                  s21 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s21;
                                                s21 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s21;
                                              s21 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s21;
                                            s21 = peg$FAILED;
                                          }
                                        }
                                        if (s20 !== peg$FAILED) {
                                          s14 = [s14, s15, s16, s17, s18, s19, s20];
                                          s13 = s14;
                                        } else {
                                          peg$currPos = s13;
                                          s13 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s13;
                                        s13 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s13;
                                      s13 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s13;
                                    s13 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s13;
                                  s13 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s13;
                                s13 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s13;
                              s13 = peg$FAILED;
                            }
                            if (s13 === peg$FAILED) {
                              s13 = null;
                            }
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parse__();
                              if (s14 !== peg$FAILED) {
                                s15 = peg$parseSET();
                                if (s15 !== peg$FAILED) {
                                  s16 = peg$parse__();
                                  if (s16 !== peg$FAILED) {
                                    s17 = peg$parseTABLESPACE();
                                    if (s17 !== peg$FAILED) {
                                      s18 = [];
                                      s19 = peg$parsecmt();
                                      if (s19 === peg$FAILED) {
                                        s19 = peg$currPos;
                                        s20 = peg$currPos;
                                        peg$silentFails++;
                                        s21 = peg$parsesemicolon();
                                        peg$silentFails--;
                                        if (s21 === peg$FAILED) {
                                          s20 = void 0;
                                        } else {
                                          peg$currPos = s20;
                                          s20 = peg$FAILED;
                                        }
                                        if (s20 !== peg$FAILED) {
                                          if (input.length > peg$currPos) {
                                            s21 = input.charAt(peg$currPos);
                                            peg$currPos++;
                                          } else {
                                            s21 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$c245); }
                                          }
                                          if (s21 !== peg$FAILED) {
                                            s20 = [s20, s21];
                                            s19 = s20;
                                          } else {
                                            peg$currPos = s19;
                                            s19 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s19;
                                          s19 = peg$FAILED;
                                        }
                                      }
                                      while (s19 !== peg$FAILED) {
                                        s18.push(s19);
                                        s19 = peg$parsecmt();
                                        if (s19 === peg$FAILED) {
                                          s19 = peg$currPos;
                                          s20 = peg$currPos;
                                          peg$silentFails++;
                                          s21 = peg$parsesemicolon();
                                          peg$silentFails--;
                                          if (s21 === peg$FAILED) {
                                            s20 = void 0;
                                          } else {
                                            peg$currPos = s20;
                                            s20 = peg$FAILED;
                                          }
                                          if (s20 !== peg$FAILED) {
                                            if (input.length > peg$currPos) {
                                              s21 = input.charAt(peg$currPos);
                                              peg$currPos++;
                                            } else {
                                              s21 = peg$FAILED;
                                              if (peg$silentFails === 0) { peg$fail(peg$c245); }
                                            }
                                            if (s21 !== peg$FAILED) {
                                              s20 = [s20, s21];
                                              s19 = s20;
                                            } else {
                                              peg$currPos = s19;
                                              s19 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s19;
                                            s19 = peg$FAILED;
                                          }
                                        }
                                      }
                                      if (s18 !== peg$FAILED) {
                                        s19 = peg$parse_();
                                        if (s19 !== peg$FAILED) {
                                          s20 = peg$parsesemicolon();
                                          if (s20 !== peg$FAILED) {
                                            s21 = peg$parse_();
                                            if (s21 !== peg$FAILED) {
                                              peg$savedPos = s0;
                                              s1 = peg$c462();
                                              s0 = s1;
                                            } else {
                                              peg$currPos = s0;
                                              s0 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_table_attach() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseALTER();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseTABLE();
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parse__();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseIF_EXISTS();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              if (s6 !== peg$FAILED) {
                s7 = peg$parsetable_name();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parse__();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseATTACH();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parse__();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parsePARTITION();
                        if (s11 !== peg$FAILED) {
                          s12 = [];
                          s13 = peg$parsecmt();
                          if (s13 === peg$FAILED) {
                            s13 = peg$currPos;
                            s14 = peg$currPos;
                            peg$silentFails++;
                            s15 = peg$parsesemicolon();
                            peg$silentFails--;
                            if (s15 === peg$FAILED) {
                              s14 = void 0;
                            } else {
                              peg$currPos = s14;
                              s14 = peg$FAILED;
                            }
                            if (s14 !== peg$FAILED) {
                              if (input.length > peg$currPos) {
                                s15 = input.charAt(peg$currPos);
                                peg$currPos++;
                              } else {
                                s15 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c245); }
                              }
                              if (s15 !== peg$FAILED) {
                                s14 = [s14, s15];
                                s13 = s14;
                              } else {
                                peg$currPos = s13;
                                s13 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s13;
                              s13 = peg$FAILED;
                            }
                          }
                          while (s13 !== peg$FAILED) {
                            s12.push(s13);
                            s13 = peg$parsecmt();
                            if (s13 === peg$FAILED) {
                              s13 = peg$currPos;
                              s14 = peg$currPos;
                              peg$silentFails++;
                              s15 = peg$parsesemicolon();
                              peg$silentFails--;
                              if (s15 === peg$FAILED) {
                                s14 = void 0;
                              } else {
                                peg$currPos = s14;
                                s14 = peg$FAILED;
                              }
                              if (s14 !== peg$FAILED) {
                                if (input.length > peg$currPos) {
                                  s15 = input.charAt(peg$currPos);
                                  peg$currPos++;
                                } else {
                                  s15 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c245); }
                                }
                                if (s15 !== peg$FAILED) {
                                  s14 = [s14, s15];
                                  s13 = s14;
                                } else {
                                  peg$currPos = s13;
                                  s13 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s13;
                                s13 = peg$FAILED;
                              }
                            }
                          }
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parse_();
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parsesemicolon();
                              if (s14 !== peg$FAILED) {
                                s15 = peg$parse_();
                                if (s15 !== peg$FAILED) {
                                  peg$savedPos = s0;
                                  s1 = peg$c463();
                                  s0 = s1;
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_table_detach() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseALTER();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseTABLE();
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parse__();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseIF_EXISTS();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              if (s6 !== peg$FAILED) {
                s7 = peg$parsetable_name();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parse__();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseDETACH();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parse__();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parsePARTITION();
                        if (s11 !== peg$FAILED) {
                          s12 = [];
                          s13 = peg$parsecmt();
                          if (s13 === peg$FAILED) {
                            s13 = peg$currPos;
                            s14 = peg$currPos;
                            peg$silentFails++;
                            s15 = peg$parsesemicolon();
                            peg$silentFails--;
                            if (s15 === peg$FAILED) {
                              s14 = void 0;
                            } else {
                              peg$currPos = s14;
                              s14 = peg$FAILED;
                            }
                            if (s14 !== peg$FAILED) {
                              if (input.length > peg$currPos) {
                                s15 = input.charAt(peg$currPos);
                                peg$currPos++;
                              } else {
                                s15 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c245); }
                              }
                              if (s15 !== peg$FAILED) {
                                s14 = [s14, s15];
                                s13 = s14;
                              } else {
                                peg$currPos = s13;
                                s13 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s13;
                              s13 = peg$FAILED;
                            }
                          }
                          while (s13 !== peg$FAILED) {
                            s12.push(s13);
                            s13 = peg$parsecmt();
                            if (s13 === peg$FAILED) {
                              s13 = peg$currPos;
                              s14 = peg$currPos;
                              peg$silentFails++;
                              s15 = peg$parsesemicolon();
                              peg$silentFails--;
                              if (s15 === peg$FAILED) {
                                s14 = void 0;
                              } else {
                                peg$currPos = s14;
                                s14 = peg$FAILED;
                              }
                              if (s14 !== peg$FAILED) {
                                if (input.length > peg$currPos) {
                                  s15 = input.charAt(peg$currPos);
                                  peg$currPos++;
                                } else {
                                  s15 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c245); }
                                }
                                if (s15 !== peg$FAILED) {
                                  s14 = [s14, s15];
                                  s13 = s14;
                                } else {
                                  peg$currPos = s13;
                                  s13 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s13;
                                s13 = peg$FAILED;
                              }
                            }
                          }
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parse_();
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parsesemicolon();
                              if (s14 !== peg$FAILED) {
                                s15 = peg$parse_();
                                if (s15 !== peg$FAILED) {
                                  peg$savedPos = s0;
                                  s1 = peg$c464();
                                  s0 = s1;
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_table_action() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseALTER();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseTABLE();
          if (s4 !== peg$FAILED) {
            s5 = peg$currPos;
            s6 = peg$parse__();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseIF_EXISTS();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseONLY();
                if (s8 !== peg$FAILED) {
                  s7 = [s7, s8];
                  s6 = s7;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
              if (s6 === peg$FAILED) {
                s6 = null;
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parse__();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parsetable_name();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$currPos;
                    s10 = peg$parse_();
                    if (s10 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 42) {
                        s11 = peg$c458;
                        peg$currPos++;
                      } else {
                        s11 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c459); }
                      }
                      if (s11 !== peg$FAILED) {
                        s10 = [s10, s11];
                        s9 = s10;
                      } else {
                        peg$currPos = s9;
                        s9 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                    if (s9 === peg$FAILED) {
                      s9 = null;
                    }
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parse__();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parseactions();
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parse_();
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parsesemicolon();
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parse_();
                              if (s14 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c465(s8, s11);
                                s0 = s1;
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseactions() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseaction();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseaction();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseaction();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseaction() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

    s0 = peg$currPos;
    s1 = peg$parseADD();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsetable_constraint();
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          s5 = peg$parse__();
          if (s5 !== peg$FAILED) {
            s6 = peg$parseNOT();
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseVALID();
                if (s8 !== peg$FAILED) {
                  s5 = [s5, s6, s7, s8];
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c466(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseALTER();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parseCOLUMN();
          if (s4 !== peg$FAILED) {
            s5 = peg$parse__();
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsecolumn_name();
            if (s4 !== peg$FAILED) {
              s5 = peg$parse__();
              if (s5 !== peg$FAILED) {
                s6 = peg$currPos;
                s7 = peg$parseSET();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parse__();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseDATA();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parse__();
                      if (s10 !== peg$FAILED) {
                        s7 = [s7, s8, s9, s10];
                        s6 = s7;
                      } else {
                        peg$currPos = s6;
                        s6 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s6;
                      s6 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
                if (s6 === peg$FAILED) {
                  s6 = null;
                }
                if (s6 !== peg$FAILED) {
                  s7 = peg$parseTYPE();
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parse__();
                    if (s8 !== peg$FAILED) {
                      s9 = peg$parsedata_type();
                      if (s9 !== peg$FAILED) {
                        s10 = peg$currPos;
                        s11 = peg$parse__();
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parseCOLLATE();
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parseidentifier();
                            if (s13 !== peg$FAILED) {
                              s11 = [s11, s12, s13];
                              s10 = s11;
                            } else {
                              peg$currPos = s10;
                              s10 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s10;
                            s10 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s10;
                          s10 = peg$FAILED;
                        }
                        if (s10 === peg$FAILED) {
                          s10 = null;
                        }
                        if (s10 !== peg$FAILED) {
                          s11 = peg$currPos;
                          s12 = peg$parse__();
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parseUSING();
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parsealter_expression();
                              if (s14 !== peg$FAILED) {
                                peg$savedPos = s11;
                                s12 = peg$c467(s4, s9, s14);
                                s11 = s12;
                              } else {
                                peg$currPos = s11;
                                s11 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s11;
                              s11 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s11;
                            s11 = peg$FAILED;
                          }
                          if (s11 === peg$FAILED) {
                            s11 = null;
                          }
                          if (s11 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c468(s4, s9, s11);
                            s0 = s1;
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseALTER();
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          if (s2 !== peg$FAILED) {
            s3 = peg$currPos;
            s4 = peg$parseCOLUMN();
            if (s4 !== peg$FAILED) {
              s5 = peg$parse__();
              if (s5 !== peg$FAILED) {
                s4 = [s4, s5];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 === peg$FAILED) {
              s3 = null;
            }
            if (s3 !== peg$FAILED) {
              s4 = peg$parsecolumn_name();
              if (s4 !== peg$FAILED) {
                s5 = peg$parse__();
                if (s5 !== peg$FAILED) {
                  s6 = peg$parseSET();
                  if (s6 !== peg$FAILED) {
                    s7 = peg$parse__();
                    if (s7 !== peg$FAILED) {
                      s8 = peg$parseDEFAULT();
                      if (s8 !== peg$FAILED) {
                        s9 = peg$parse__();
                        if (s9 !== peg$FAILED) {
                          s10 = peg$parsealter_expression();
                          if (s10 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c469(s4, s10);
                            s0 = s1;
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parseALTER();
          if (s1 !== peg$FAILED) {
            s2 = peg$parse__();
            if (s2 !== peg$FAILED) {
              s3 = peg$currPos;
              s4 = peg$parseCOLUMN();
              if (s4 !== peg$FAILED) {
                s5 = peg$parse__();
                if (s5 !== peg$FAILED) {
                  s4 = [s4, s5];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
              if (s3 === peg$FAILED) {
                s3 = null;
              }
              if (s3 !== peg$FAILED) {
                s4 = peg$parsecolumn_name();
                if (s4 !== peg$FAILED) {
                  s5 = peg$parse__();
                  if (s5 !== peg$FAILED) {
                    s6 = peg$parseDROP();
                    if (s6 !== peg$FAILED) {
                      s7 = peg$parse__();
                      if (s7 !== peg$FAILED) {
                        s8 = peg$parseDEFAULT();
                        if (s8 !== peg$FAILED) {
                          peg$savedPos = s0;
                          s1 = peg$c470(s4);
                          s0 = s1;
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseALTER();
            if (s1 !== peg$FAILED) {
              s2 = peg$parse__();
              if (s2 !== peg$FAILED) {
                s3 = peg$currPos;
                s4 = peg$parseCOLUMN();
                if (s4 !== peg$FAILED) {
                  s5 = peg$parse__();
                  if (s5 !== peg$FAILED) {
                    s4 = [s4, s5];
                    s3 = s4;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
                if (s3 === peg$FAILED) {
                  s3 = null;
                }
                if (s3 !== peg$FAILED) {
                  s4 = peg$parsecolumn_name();
                  if (s4 !== peg$FAILED) {
                    s5 = peg$parse__();
                    if (s5 !== peg$FAILED) {
                      s6 = peg$parseSET();
                      if (s6 === peg$FAILED) {
                        s6 = peg$parseDROP();
                      }
                      if (s6 !== peg$FAILED) {
                        s7 = peg$parse__();
                        if (s7 !== peg$FAILED) {
                          s8 = peg$parseNOT();
                          if (s8 !== peg$FAILED) {
                            s9 = peg$parse__();
                            if (s9 !== peg$FAILED) {
                              s10 = peg$parseNULL();
                              if (s10 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c471(s4, s6);
                                s0 = s1;
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parseALTER();
              if (s1 !== peg$FAILED) {
                s2 = peg$parse__();
                if (s2 !== peg$FAILED) {
                  s3 = peg$currPos;
                  s4 = peg$parseCOLUMN();
                  if (s4 !== peg$FAILED) {
                    s5 = peg$parse__();
                    if (s5 !== peg$FAILED) {
                      s4 = [s4, s5];
                      s3 = s4;
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                  if (s3 === peg$FAILED) {
                    s3 = null;
                  }
                  if (s3 !== peg$FAILED) {
                    s4 = peg$parsecolumn_name();
                    if (s4 !== peg$FAILED) {
                      s5 = peg$parse__();
                      if (s5 !== peg$FAILED) {
                        s6 = peg$parseSET();
                        if (s6 !== peg$FAILED) {
                          s7 = peg$parse__();
                          if (s7 !== peg$FAILED) {
                            s8 = peg$parseSTATISTICS();
                            if (s8 !== peg$FAILED) {
                              s9 = peg$parsenumeric_constant();
                              if (s9 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c472(s4, s9);
                                s0 = s1;
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = peg$parseALTER();
                if (s1 !== peg$FAILED) {
                  s2 = peg$parse__();
                  if (s2 !== peg$FAILED) {
                    s3 = peg$currPos;
                    s4 = peg$parseCOLUMN();
                    if (s4 !== peg$FAILED) {
                      s5 = peg$parse__();
                      if (s5 !== peg$FAILED) {
                        s4 = [s4, s5];
                        s3 = s4;
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                    if (s3 === peg$FAILED) {
                      s3 = null;
                    }
                    if (s3 !== peg$FAILED) {
                      s4 = peg$parsecolumn_name();
                      if (s4 !== peg$FAILED) {
                        s5 = peg$parse__();
                        if (s5 !== peg$FAILED) {
                          s6 = peg$parseSET();
                          if (s6 !== peg$FAILED) {
                            s7 = peg$parse_();
                            if (s7 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 40) {
                                s8 = peg$c237;
                                peg$currPos++;
                              } else {
                                s8 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c238); }
                              }
                              if (s8 !== peg$FAILED) {
                                s9 = peg$parse_();
                                if (s9 !== peg$FAILED) {
                                  s10 = peg$parseset_attribute_options();
                                  if (s10 !== peg$FAILED) {
                                    s11 = peg$parse_();
                                    if (s11 !== peg$FAILED) {
                                      if (input.charCodeAt(peg$currPos) === 41) {
                                        s12 = peg$c239;
                                        peg$currPos++;
                                      } else {
                                        s12 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                      }
                                      if (s12 !== peg$FAILED) {
                                        peg$savedPos = s0;
                                        s1 = peg$c473(s4);
                                        s0 = s1;
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
                if (s0 === peg$FAILED) {
                  s0 = peg$currPos;
                  s1 = peg$parseALTER();
                  if (s1 !== peg$FAILED) {
                    s2 = peg$parse__();
                    if (s2 !== peg$FAILED) {
                      s3 = peg$currPos;
                      s4 = peg$parseCOLUMN();
                      if (s4 !== peg$FAILED) {
                        s5 = peg$parse__();
                        if (s5 !== peg$FAILED) {
                          s4 = [s4, s5];
                          s3 = s4;
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                      if (s3 === peg$FAILED) {
                        s3 = null;
                      }
                      if (s3 !== peg$FAILED) {
                        s4 = peg$parsecolumn_name();
                        if (s4 !== peg$FAILED) {
                          s5 = peg$parse__();
                          if (s5 !== peg$FAILED) {
                            s6 = peg$parseRESET();
                            if (s6 !== peg$FAILED) {
                              s7 = peg$parse_();
                              if (s7 !== peg$FAILED) {
                                if (input.charCodeAt(peg$currPos) === 40) {
                                  s8 = peg$c237;
                                  peg$currPos++;
                                } else {
                                  s8 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                }
                                if (s8 !== peg$FAILED) {
                                  s9 = peg$parse_();
                                  if (s9 !== peg$FAILED) {
                                    s10 = peg$parsereset_attribute_options();
                                    if (s10 !== peg$FAILED) {
                                      s11 = peg$parse_();
                                      if (s11 !== peg$FAILED) {
                                        if (input.charCodeAt(peg$currPos) === 41) {
                                          s12 = peg$c239;
                                          peg$currPos++;
                                        } else {
                                          s12 = peg$FAILED;
                                          if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                        }
                                        if (s12 !== peg$FAILED) {
                                          peg$savedPos = s0;
                                          s1 = peg$c474(s4);
                                          s0 = s1;
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                  if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    s1 = peg$parseALTER();
                    if (s1 !== peg$FAILED) {
                      s2 = peg$parse__();
                      if (s2 !== peg$FAILED) {
                        s3 = peg$currPos;
                        s4 = peg$parseCOLUMN();
                        if (s4 !== peg$FAILED) {
                          s5 = peg$parse__();
                          if (s5 !== peg$FAILED) {
                            s4 = [s4, s5];
                            s3 = s4;
                          } else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                        if (s3 === peg$FAILED) {
                          s3 = null;
                        }
                        if (s3 !== peg$FAILED) {
                          s4 = peg$parsecolumn_name();
                          if (s4 !== peg$FAILED) {
                            s5 = peg$parse__();
                            if (s5 !== peg$FAILED) {
                              s6 = peg$parseSET();
                              if (s6 !== peg$FAILED) {
                                s7 = peg$parse__();
                                if (s7 !== peg$FAILED) {
                                  s8 = peg$parseSTORAGE();
                                  if (s8 !== peg$FAILED) {
                                    s9 = peg$parse__();
                                    if (s9 !== peg$FAILED) {
                                      s10 = peg$parsePLAIN();
                                      if (s10 === peg$FAILED) {
                                        s10 = peg$parseEXTERNAL();
                                        if (s10 === peg$FAILED) {
                                          s10 = peg$parseEXTENDED();
                                          if (s10 === peg$FAILED) {
                                            s10 = peg$parseMAIN();
                                          }
                                        }
                                      }
                                      if (s10 !== peg$FAILED) {
                                        peg$savedPos = s0;
                                        s1 = peg$c475(s4, s10);
                                        s0 = s1;
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                    if (s0 === peg$FAILED) {
                      s0 = peg$currPos;
                      s1 = [];
                      s2 = peg$parsecmt();
                      if (s2 === peg$FAILED) {
                        s2 = peg$currPos;
                        s3 = peg$currPos;
                        peg$silentFails++;
                        s4 = peg$parsesemicolon();
                        peg$silentFails--;
                        if (s4 === peg$FAILED) {
                          s3 = void 0;
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                        if (s3 !== peg$FAILED) {
                          if (input.length > peg$currPos) {
                            s4 = input.charAt(peg$currPos);
                            peg$currPos++;
                          } else {
                            s4 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c245); }
                          }
                          if (s4 !== peg$FAILED) {
                            s3 = [s3, s4];
                            s2 = s3;
                          } else {
                            peg$currPos = s2;
                            s2 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      }
                      while (s2 !== peg$FAILED) {
                        s1.push(s2);
                        s2 = peg$parsecmt();
                        if (s2 === peg$FAILED) {
                          s2 = peg$currPos;
                          s3 = peg$currPos;
                          peg$silentFails++;
                          s4 = peg$parsesemicolon();
                          peg$silentFails--;
                          if (s4 === peg$FAILED) {
                            s3 = void 0;
                          } else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                          }
                          if (s3 !== peg$FAILED) {
                            if (input.length > peg$currPos) {
                              s4 = input.charAt(peg$currPos);
                              peg$currPos++;
                            } else {
                              s4 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c245); }
                            }
                            if (s4 !== peg$FAILED) {
                              s3 = [s3, s4];
                              s2 = s3;
                            } else {
                              peg$currPos = s2;
                              s2 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s2;
                            s2 = peg$FAILED;
                          }
                        }
                      }
                      if (s1 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c476();
                      }
                      s0 = s1;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseset_attribute_options() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseset_attribute_option();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseset_attribute_option();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseset_attribute_option();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseset_attribute_option() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseidentifier();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse_();
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 61) {
          s3 = peg$c346;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c347); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseexpression();
            if (s5 !== peg$FAILED) {
              s1 = [s1, s2, s3, s4, s5];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsereset_attribute_options() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parseidentifier();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parse_();
      if (s3 !== peg$FAILED) {
        s4 = peg$parsecomma();
        if (s4 !== peg$FAILED) {
          s5 = peg$parse_();
          if (s5 !== peg$FAILED) {
            s6 = peg$parseidentifier();
            if (s6 !== peg$FAILED) {
              s3 = [s3, s4, s5, s6];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_expression() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    if (peg$c477.test(input.charAt(peg$currPos))) {
      s2 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c478); }
    }
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        if (peg$c477.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c478); }
        }
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c479(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsecreate_index() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22, s23, s24, s25, s26, s27, s28, s29;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseCREATE();
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        s4 = peg$parse__();
        if (s4 !== peg$FAILED) {
          s5 = peg$parseUNIQUE();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseINDEX();
            if (s5 !== peg$FAILED) {
              s6 = peg$currPos;
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseCONCURRENTLY();
                if (s8 !== peg$FAILED) {
                  s7 = [s7, s8];
                  s6 = s7;
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;
                s6 = peg$FAILED;
              }
              if (s6 === peg$FAILED) {
                s6 = null;
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$currPos;
                s8 = peg$parse__();
                if (s8 !== peg$FAILED) {
                  s9 = peg$parseON();
                  if (s9 !== peg$FAILED) {
                    peg$savedPos = s7;
                    s8 = peg$c480(s3);
                    s7 = s8;
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
                if (s7 === peg$FAILED) {
                  s7 = peg$currPos;
                  s8 = peg$currPos;
                  s9 = peg$parse__();
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parseIF_NOT_EXISTS();
                    if (s10 !== peg$FAILED) {
                      s9 = [s9, s10];
                      s8 = s9;
                    } else {
                      peg$currPos = s8;
                      s8 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s8;
                    s8 = peg$FAILED;
                  }
                  if (s8 === peg$FAILED) {
                    s8 = null;
                  }
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parse__();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parseidentifier();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parse__();
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parseON();
                          if (s12 !== peg$FAILED) {
                            peg$savedPos = s7;
                            s8 = peg$c481(s3, s10);
                            s7 = s8;
                          } else {
                            peg$currPos = s7;
                            s7 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s7;
                          s7 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s7;
                        s7 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s7;
                      s7 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$currPos;
                  s9 = peg$parse__();
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parseONLY();
                    if (s10 !== peg$FAILED) {
                      s9 = [s9, s10];
                      s8 = s9;
                    } else {
                      peg$currPos = s8;
                      s8 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s8;
                    s8 = peg$FAILED;
                  }
                  if (s8 === peg$FAILED) {
                    s8 = null;
                  }
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parse__();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parsetable_name();
                      if (s10 !== peg$FAILED) {
                        s11 = peg$currPos;
                        s12 = peg$parse__();
                        if (s12 !== peg$FAILED) {
                          s13 = peg$parseUSING();
                          if (s13 !== peg$FAILED) {
                            s14 = peg$parse__();
                            if (s14 !== peg$FAILED) {
                              s15 = peg$parseindex_method();
                              if (s15 !== peg$FAILED) {
                                peg$savedPos = s11;
                                s12 = peg$c482(s3, s7, s10, s15);
                                s11 = s12;
                              } else {
                                peg$currPos = s11;
                                s11 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s11;
                              s11 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s11;
                            s11 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s11;
                          s11 = peg$FAILED;
                        }
                        if (s11 === peg$FAILED) {
                          s11 = null;
                        }
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parse_();
                          if (s12 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 40) {
                              s13 = peg$c237;
                              peg$currPos++;
                            } else {
                              s13 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c238); }
                            }
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parse_();
                              if (s14 !== peg$FAILED) {
                                s15 = peg$parseindex_properties();
                                if (s15 !== peg$FAILED) {
                                  s16 = peg$parse_();
                                  if (s16 !== peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 41) {
                                      s17 = peg$c239;
                                      peg$currPos++;
                                    } else {
                                      s17 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                    }
                                    if (s17 !== peg$FAILED) {
                                      s18 = peg$currPos;
                                      s19 = peg$parse__();
                                      if (s19 !== peg$FAILED) {
                                        s20 = peg$parseINCLUDE();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parse_();
                                          if (s21 !== peg$FAILED) {
                                            if (input.charCodeAt(peg$currPos) === 40) {
                                              s22 = peg$c237;
                                              peg$currPos++;
                                            } else {
                                              s22 = peg$FAILED;
                                              if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                            }
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parse_();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parsecolumn_names();
                                                if (s24 !== peg$FAILED) {
                                                  s25 = peg$parse_();
                                                  if (s25 !== peg$FAILED) {
                                                    if (input.charCodeAt(peg$currPos) === 41) {
                                                      s26 = peg$c239;
                                                      peg$currPos++;
                                                    } else {
                                                      s26 = peg$FAILED;
                                                      if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                    }
                                                    if (s26 !== peg$FAILED) {
                                                      s19 = [s19, s20, s21, s22, s23, s24, s25, s26];
                                                      s18 = s19;
                                                    } else {
                                                      peg$currPos = s18;
                                                      s18 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s18;
                                                    s18 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s18;
                                                  s18 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s18;
                                                s18 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s18;
                                              s18 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s18;
                                            s18 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s18;
                                          s18 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s18;
                                        s18 = peg$FAILED;
                                      }
                                      if (s18 === peg$FAILED) {
                                        s18 = null;
                                      }
                                      if (s18 !== peg$FAILED) {
                                        s19 = peg$currPos;
                                        s20 = peg$parse__();
                                        if (s20 !== peg$FAILED) {
                                          s21 = peg$parseWITH();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parse_();
                                            if (s22 !== peg$FAILED) {
                                              if (input.charCodeAt(peg$currPos) === 40) {
                                                s23 = peg$c237;
                                                peg$currPos++;
                                              } else {
                                                s23 = peg$FAILED;
                                                if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                              }
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parse_();
                                                if (s24 !== peg$FAILED) {
                                                  s25 = peg$parseindex_storage_parameters();
                                                  if (s25 !== peg$FAILED) {
                                                    s26 = peg$parse_();
                                                    if (s26 !== peg$FAILED) {
                                                      if (input.charCodeAt(peg$currPos) === 41) {
                                                        s27 = peg$c239;
                                                        peg$currPos++;
                                                      } else {
                                                        s27 = peg$FAILED;
                                                        if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                      }
                                                      if (s27 !== peg$FAILED) {
                                                        s20 = [s20, s21, s22, s23, s24, s25, s26, s27];
                                                        s19 = s20;
                                                      } else {
                                                        peg$currPos = s19;
                                                        s19 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s19;
                                                      s19 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s19;
                                                    s19 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s19;
                                                  s19 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s19;
                                                s19 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s19;
                                              s19 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s19;
                                            s19 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s19;
                                          s19 = peg$FAILED;
                                        }
                                        if (s19 === peg$FAILED) {
                                          s19 = null;
                                        }
                                        if (s19 !== peg$FAILED) {
                                          s20 = peg$currPos;
                                          s21 = peg$parse__();
                                          if (s21 !== peg$FAILED) {
                                            s22 = peg$parseTABLESPACE();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parse__();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parseidentifier();
                                                if (s24 !== peg$FAILED) {
                                                  s21 = [s21, s22, s23, s24];
                                                  s20 = s21;
                                                } else {
                                                  peg$currPos = s20;
                                                  s20 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s20;
                                                s20 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s20;
                                              s20 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s20;
                                            s20 = peg$FAILED;
                                          }
                                          if (s20 === peg$FAILED) {
                                            s20 = null;
                                          }
                                          if (s20 !== peg$FAILED) {
                                            s21 = peg$currPos;
                                            s22 = peg$parse__();
                                            if (s22 !== peg$FAILED) {
                                              s23 = peg$parseWHERE();
                                              if (s23 !== peg$FAILED) {
                                                s24 = peg$parse_();
                                                if (s24 !== peg$FAILED) {
                                                  if (input.charCodeAt(peg$currPos) === 40) {
                                                    s25 = peg$c237;
                                                    peg$currPos++;
                                                  } else {
                                                    s25 = peg$FAILED;
                                                    if (peg$silentFails === 0) { peg$fail(peg$c238); }
                                                  }
                                                  if (s25 !== peg$FAILED) {
                                                    s26 = peg$parse_();
                                                    if (s26 !== peg$FAILED) {
                                                      s27 = peg$parseexpression();
                                                      if (s27 !== peg$FAILED) {
                                                        s28 = peg$parse_();
                                                        if (s28 !== peg$FAILED) {
                                                          if (input.charCodeAt(peg$currPos) === 41) {
                                                            s29 = peg$c239;
                                                            peg$currPos++;
                                                          } else {
                                                            s29 = peg$FAILED;
                                                            if (peg$silentFails === 0) { peg$fail(peg$c240); }
                                                          }
                                                          if (s29 !== peg$FAILED) {
                                                            s22 = [s22, s23, s24, s25, s26, s27, s28, s29];
                                                            s21 = s22;
                                                          } else {
                                                            peg$currPos = s21;
                                                            s21 = peg$FAILED;
                                                          }
                                                        } else {
                                                          peg$currPos = s21;
                                                          s21 = peg$FAILED;
                                                        }
                                                      } else {
                                                        peg$currPos = s21;
                                                        s21 = peg$FAILED;
                                                      }
                                                    } else {
                                                      peg$currPos = s21;
                                                      s21 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s21;
                                                    s21 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s21;
                                                  s21 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s21;
                                                s21 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s21;
                                              s21 = peg$FAILED;
                                            }
                                            if (s21 === peg$FAILED) {
                                              s21 = null;
                                            }
                                            if (s21 !== peg$FAILED) {
                                              s22 = peg$parse_();
                                              if (s22 !== peg$FAILED) {
                                                s23 = peg$parsesemicolon();
                                                if (s23 !== peg$FAILED) {
                                                  s24 = peg$parse_();
                                                  if (s24 !== peg$FAILED) {
                                                    peg$savedPos = s0;
                                                    s1 = peg$c483(s3, s7, s10, s11, s15);
                                                    s0 = s1;
                                                  } else {
                                                    peg$currPos = s0;
                                                    s0 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s0;
                                                  s0 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s0;
                                                s0 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s0;
                                              s0 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseindex_properties() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseindex_property();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseindex_property();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseindex_property();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c349(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseindex_property() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parsecolumn_name();
    if (s2 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 40) {
        s3 = peg$c237;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c238); }
      }
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$parsecolumn_name();
        if (s5 === peg$FAILED) {
          s5 = peg$parse__();
          if (s5 === peg$FAILED) {
            s5 = peg$parsecomma();
          }
        }
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parsecolumn_name();
          if (s5 === peg$FAILED) {
            s5 = peg$parse__();
            if (s5 === peg$FAILED) {
              s5 = peg$parsecomma();
            }
          }
        }
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 41) {
            s5 = peg$c239;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c240); }
          }
          if (s5 !== peg$FAILED) {
            peg$savedPos = s1;
            s2 = peg$c484(s2, s4);
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      s2 = peg$parsecolumn_name();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s1;
        s2 = peg$c485(s2);
      }
      s1 = s2;
      if (s1 === peg$FAILED) {
        s1 = peg$currPos;
        s2 = peg$parseexpression();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s1;
          s2 = peg$c486(s2);
        }
        s1 = s2;
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parse__();
      if (s3 !== peg$FAILED) {
        if (input.substr(peg$currPos, 7) === peg$c487) {
          s4 = peg$c487;
          peg$currPos += 7;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c488); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          if (s5 !== peg$FAILED) {
            s6 = peg$parseidentifier();
            if (s6 !== peg$FAILED) {
              s3 = [s3, s4, s5, s6];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        s4 = peg$parse__();
        if (s4 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c489) {
            s5 = peg$c489;
            peg$currPos += 3;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c490); }
          }
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parse__();
          if (s4 !== peg$FAILED) {
            if (input.substr(peg$currPos, 4) === peg$c491) {
              s5 = peg$c491;
              peg$currPos += 4;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c492); }
            }
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$currPos;
          s5 = peg$parse__();
          if (s5 !== peg$FAILED) {
            if (input.substr(peg$currPos, 5) === peg$c493) {
              s6 = peg$c493;
              peg$currPos += 5;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c494); }
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parse__();
              if (s7 !== peg$FAILED) {
                if (input.substr(peg$currPos, 5) === peg$c495) {
                  s8 = peg$c495;
                  peg$currPos += 5;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c496); }
                }
                if (s8 === peg$FAILED) {
                  if (input.substr(peg$currPos, 4) === peg$c497) {
                    s8 = peg$c497;
                    peg$currPos += 4;
                  } else {
                    s8 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c498); }
                  }
                }
                if (s8 !== peg$FAILED) {
                  s5 = [s5, s6, s7, s8];
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c499(s1);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseindex_storage_parameters() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseindex_storage_parameter();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse_();
      if (s3 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 61) {
          s4 = peg$c346;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c347); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parse_();
          if (s5 !== peg$FAILED) {
            s6 = peg$parseexpression();
            if (s6 !== peg$FAILED) {
              s2 = [s2, s3, s4, s5, s6];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse_();
      if (s4 !== peg$FAILED) {
        s5 = peg$parsecomma();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse_();
          if (s6 !== peg$FAILED) {
            s7 = peg$parseindex_storage_parameter();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse_();
              if (s8 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 61) {
                  s9 = peg$c346;
                  peg$currPos++;
                } else {
                  s9 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c347); }
                }
                if (s9 !== peg$FAILED) {
                  s10 = peg$parseexpression();
                  if (s10 !== peg$FAILED) {
                    s4 = [s4, s5, s6, s7, s8, s9, s10];
                    s3 = s4;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse_();
        if (s4 !== peg$FAILED) {
          s5 = peg$parsecomma();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse_();
            if (s6 !== peg$FAILED) {
              s7 = peg$parseindex_storage_parameter();
              if (s7 !== peg$FAILED) {
                s8 = peg$parse_();
                if (s8 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 61) {
                    s9 = peg$c346;
                    peg$currPos++;
                  } else {
                    s9 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c347); }
                  }
                  if (s9 !== peg$FAILED) {
                    s10 = peg$parseexpression();
                    if (s10 !== peg$FAILED) {
                      s4 = [s4, s5, s6, s7, s8, s9, s10];
                      s3 = s4;
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseindex_storage_parameter() {
    var s0;

    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c388) {
      s0 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c389); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 33).toLowerCase() === peg$c500) {
        s0 = input.substr(peg$currPos, 33);
        peg$currPos += 33;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c501); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 9).toLowerCase() === peg$c502) {
          s0 = input.substr(peg$currPos, 9);
          peg$currPos += 9;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c503); }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 10).toLowerCase() === peg$c504) {
            s0 = input.substr(peg$currPos, 10);
            peg$currPos += 10;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c505); }
          }
          if (s0 === peg$FAILED) {
            if (input.substr(peg$currPos, 22).toLowerCase() === peg$c506) {
              s0 = input.substr(peg$currPos, 22);
              peg$currPos += 22;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c507); }
            }
            if (s0 === peg$FAILED) {
              if (input.substr(peg$currPos, 15).toLowerCase() === peg$c508) {
                s0 = input.substr(peg$currPos, 15);
                peg$currPos += 15;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c509); }
              }
              if (s0 === peg$FAILED) {
                if (input.substr(peg$currPos, 13).toLowerCase() === peg$c510) {
                  s0 = input.substr(peg$currPos, 13);
                  peg$currPos += 13;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c511); }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecomment() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseCOMMENT();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseON();
          if (s4 !== peg$FAILED) {
            s5 = peg$parse__();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsecomment_option();
              if (s6 !== peg$FAILED) {
                s7 = peg$parse__();
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseIS();
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parse__();
                    if (s9 !== peg$FAILED) {
                      s10 = peg$parsestring_constant();
                      if (s10 === peg$FAILED) {
                        s10 = peg$parseNULL();
                      }
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parse_();
                        if (s11 !== peg$FAILED) {
                          s12 = peg$parsesemicolon();
                          if (s12 !== peg$FAILED) {
                            s13 = peg$parse_();
                            if (s13 !== peg$FAILED) {
                              peg$savedPos = s0;
                              s1 = peg$c512(s6, s10);
                              s0 = s1;
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecomment_option() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parseCOLUMN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$currPos;
        s5 = peg$parseidentifier();
        if (s5 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 46) {
            s6 = peg$c252;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c253); }
          }
          if (s6 !== peg$FAILED) {
            s5 = [s5, s6];
            s4 = s5;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$currPos;
            s5 = peg$parseidentifier();
            if (s5 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 46) {
                s6 = peg$c252;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c253); }
              }
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
        } else {
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsecolumn_name();
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c513(s3, s4);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseTABLE();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        if (s2 !== peg$FAILED) {
          s3 = peg$parsetable_name();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c514(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseignore_syntax() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parseINSERT();
      if (s3 !== peg$FAILED) {
        s4 = [];
        if (peg$c515.test(input.charAt(peg$currPos))) {
          s5 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c516); }
        }
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          if (peg$c515.test(input.charAt(peg$currPos))) {
            s5 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c516); }
          }
        }
        if (s4 !== peg$FAILED) {
          peg$savedPos = s2;
          s3 = peg$c517();
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 === peg$FAILED) {
        s2 = peg$currPos;
        s3 = peg$parseSET();
        if (s3 !== peg$FAILED) {
          s4 = [];
          if (peg$c515.test(input.charAt(peg$currPos))) {
            s5 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c516); }
          }
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            if (peg$c515.test(input.charAt(peg$currPos))) {
              s5 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c516); }
            }
          }
          if (s4 !== peg$FAILED) {
            peg$savedPos = s2;
            s3 = peg$c518();
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          s3 = peg$parseRESET();
          if (s3 !== peg$FAILED) {
            s4 = [];
            if (peg$c515.test(input.charAt(peg$currPos))) {
              s5 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c516); }
            }
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              if (peg$c515.test(input.charAt(peg$currPos))) {
                s5 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c516); }
              }
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s2;
              s3 = peg$c519();
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = peg$currPos;
            s3 = peg$parseSELECT();
            if (s3 !== peg$FAILED) {
              s4 = [];
              if (peg$c515.test(input.charAt(peg$currPos))) {
                s5 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c516); }
              }
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                if (peg$c515.test(input.charAt(peg$currPos))) {
                  s5 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c516); }
                }
              }
              if (s4 !== peg$FAILED) {
                peg$savedPos = s2;
                s3 = peg$c520();
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
            if (s2 === peg$FAILED) {
              s2 = peg$currPos;
              s3 = peg$parseDROP();
              if (s3 !== peg$FAILED) {
                s4 = [];
                if (peg$c515.test(input.charAt(peg$currPos))) {
                  s5 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c516); }
                }
                while (s5 !== peg$FAILED) {
                  s4.push(s5);
                  if (peg$c515.test(input.charAt(peg$currPos))) {
                    s5 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c516); }
                  }
                }
                if (s4 !== peg$FAILED) {
                  peg$savedPos = s2;
                  s3 = peg$c521();
                  s2 = s3;
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
              if (s2 === peg$FAILED) {
                s2 = peg$currPos;
                s3 = peg$parseUSE();
                if (s3 !== peg$FAILED) {
                  s4 = [];
                  if (peg$c515.test(input.charAt(peg$currPos))) {
                    s5 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c516); }
                  }
                  while (s5 !== peg$FAILED) {
                    s4.push(s5);
                    if (peg$c515.test(input.charAt(peg$currPos))) {
                      s5 = input.charAt(peg$currPos);
                      peg$currPos++;
                    } else {
                      s5 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c516); }
                    }
                  }
                  if (s4 !== peg$FAILED) {
                    peg$savedPos = s2;
                    s3 = peg$c522();
                    s2 = s3;
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
                if (s2 === peg$FAILED) {
                  s2 = peg$currPos;
                  s3 = peg$parseCREATE();
                  if (s3 !== peg$FAILED) {
                    s4 = peg$parse__();
                    if (s4 !== peg$FAILED) {
                      s5 = peg$parseSEQUENCE();
                      if (s5 !== peg$FAILED) {
                        s6 = [];
                        if (peg$c515.test(input.charAt(peg$currPos))) {
                          s7 = input.charAt(peg$currPos);
                          peg$currPos++;
                        } else {
                          s7 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c516); }
                        }
                        while (s7 !== peg$FAILED) {
                          s6.push(s7);
                          if (peg$c515.test(input.charAt(peg$currPos))) {
                            s7 = input.charAt(peg$currPos);
                            peg$currPos++;
                          } else {
                            s7 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c516); }
                          }
                        }
                        if (s6 !== peg$FAILED) {
                          peg$savedPos = s2;
                          s3 = peg$c523();
                          s2 = s3;
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                  if (s2 === peg$FAILED) {
                    s2 = peg$currPos;
                    s3 = peg$parseCREATE();
                    if (s3 !== peg$FAILED) {
                      s4 = peg$parse__();
                      if (s4 !== peg$FAILED) {
                        s5 = peg$parseSCHEMA();
                        if (s5 !== peg$FAILED) {
                          s6 = [];
                          if (peg$c515.test(input.charAt(peg$currPos))) {
                            s7 = input.charAt(peg$currPos);
                            peg$currPos++;
                          } else {
                            s7 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c516); }
                          }
                          while (s7 !== peg$FAILED) {
                            s6.push(s7);
                            if (peg$c515.test(input.charAt(peg$currPos))) {
                              s7 = input.charAt(peg$currPos);
                              peg$currPos++;
                            } else {
                              s7 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c516); }
                            }
                          }
                          if (s6 !== peg$FAILED) {
                            peg$savedPos = s2;
                            s3 = peg$c524();
                            s2 = s3;
                          } else {
                            peg$currPos = s2;
                            s2 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                    if (s2 === peg$FAILED) {
                      s2 = peg$currPos;
                      s3 = peg$parseCREATE();
                      if (s3 !== peg$FAILED) {
                        s4 = peg$parse__();
                        if (s4 !== peg$FAILED) {
                          s5 = peg$parseVIEW();
                          if (s5 !== peg$FAILED) {
                            s6 = [];
                            if (peg$c515.test(input.charAt(peg$currPos))) {
                              s7 = input.charAt(peg$currPos);
                              peg$currPos++;
                            } else {
                              s7 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c516); }
                            }
                            while (s7 !== peg$FAILED) {
                              s6.push(s7);
                              if (peg$c515.test(input.charAt(peg$currPos))) {
                                s7 = input.charAt(peg$currPos);
                                peg$currPos++;
                              } else {
                                s7 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c516); }
                              }
                            }
                            if (s6 !== peg$FAILED) {
                              peg$savedPos = s2;
                              s3 = peg$c525();
                              s2 = s3;
                            } else {
                              peg$currPos = s2;
                              s2 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s2;
                            s2 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s2;
                        s2 = peg$FAILED;
                      }
                      if (s2 === peg$FAILED) {
                        s2 = peg$currPos;
                        s3 = peg$parseALTER();
                        if (s3 !== peg$FAILED) {
                          s4 = peg$parse__();
                          if (s4 !== peg$FAILED) {
                            s5 = [];
                            s6 = peg$parsecmt();
                            if (s6 === peg$FAILED) {
                              s6 = peg$currPos;
                              s7 = peg$currPos;
                              peg$silentFails++;
                              s8 = peg$parsesemicolon();
                              peg$silentFails--;
                              if (s8 === peg$FAILED) {
                                s7 = void 0;
                              } else {
                                peg$currPos = s7;
                                s7 = peg$FAILED;
                              }
                              if (s7 !== peg$FAILED) {
                                if (input.length > peg$currPos) {
                                  s8 = input.charAt(peg$currPos);
                                  peg$currPos++;
                                } else {
                                  s8 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c245); }
                                }
                                if (s8 !== peg$FAILED) {
                                  s7 = [s7, s8];
                                  s6 = s7;
                                } else {
                                  peg$currPos = s6;
                                  s6 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s6;
                                s6 = peg$FAILED;
                              }
                            }
                            while (s6 !== peg$FAILED) {
                              s5.push(s6);
                              s6 = peg$parsecmt();
                              if (s6 === peg$FAILED) {
                                s6 = peg$currPos;
                                s7 = peg$currPos;
                                peg$silentFails++;
                                s8 = peg$parsesemicolon();
                                peg$silentFails--;
                                if (s8 === peg$FAILED) {
                                  s7 = void 0;
                                } else {
                                  peg$currPos = s7;
                                  s7 = peg$FAILED;
                                }
                                if (s7 !== peg$FAILED) {
                                  if (input.length > peg$currPos) {
                                    s8 = input.charAt(peg$currPos);
                                    peg$currPos++;
                                  } else {
                                    s8 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c245); }
                                  }
                                  if (s8 !== peg$FAILED) {
                                    s7 = [s7, s8];
                                    s6 = s7;
                                  } else {
                                    peg$currPos = s6;
                                    s6 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s6;
                                  s6 = peg$FAILED;
                                }
                              }
                            }
                            if (s5 !== peg$FAILED) {
                              peg$savedPos = s2;
                              s3 = peg$c526();
                              s2 = s3;
                            } else {
                              peg$currPos = s2;
                              s2 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s2;
                            s2 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s2;
                          s2 = peg$FAILED;
                        }
                        if (s2 === peg$FAILED) {
                          s2 = peg$currPos;
                          s3 = peg$parse__();
                          if (s3 !== peg$FAILED) {
                            peg$savedPos = s2;
                            s3 = peg$c527();
                          }
                          s2 = s3;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsesemicolon();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c528(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecommand() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsecreate_table();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c529(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsecreate_type();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c530(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsealter_table();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c531(s1);
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parsecreate_index();
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c532(s1);
          }
          s0 = s1;
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parsecomment();
            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c533(s1);
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parseignore_syntax();
              if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c534(s1);
              }
              s0 = s1;
            }
          }
        }
      }
    }

    return s0;
  }



  	const tables = [];
  	const refs = [];
  	const enums = [];
  	const warnings = [];


    // intput:
    // `
    //      'created'
    //                   ,
    //         'pending',          'done'
    //  `
    //  => `'created', 'pending', 'done'`
    const removeReduntdantSpNewline = (str) => {
      const arr = str.split(/[\s\r\n]*,[\s\r\n]*/);
      // need to trim spaces and newlines of the first and last element
      const arrAfterTrim = arr.map(ele => {
        return ele.replace(/^[\s]+|[\s]+$|[\r\n]|\s(?=\s)/g, '');
      });
      return arrAfterTrim.join(', ');
    }

    // TODO: support configurable default schema name other than 'public'
    const findTable = (schemaName, tableName) => {
      const realSchemaName = schemaName || 'public';
      const table = tables.find(table => {
        const targetSchemaName = table.schemaName || 'public';
        return targetSchemaName === realSchemaName && table.name === tableName;
      });
      return table;
    };

    const findField = (table, fieldName) => table.fields.find(field => field.name === fieldName);



  peg$result = peg$startRuleFunction();

  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
    );
  }
}

module.exports = {
  SyntaxError: peg$SyntaxError,
  parse:       peg$parse
};
