/*
 * Generated by PEG.js 0.10.0.
 *
 * http://pegjs.org/
 */

"use strict";

var _ = require("lodash"), pluralize = require("pluralize");

function peg$subclass(child, parent) {
  function ctor() { this.constructor = child; }
  ctor.prototype = parent.prototype;
  child.prototype = new ctor();
}

function peg$SyntaxError(message, expected, found, location) {
  this.message  = message;
  this.expected = expected;
  this.found    = found;
  this.location = location;
  this.name     = "SyntaxError";

  if (typeof Error.captureStackTrace === "function") {
    Error.captureStackTrace(this, peg$SyntaxError);
  }
}

peg$subclass(peg$SyntaxError, Error);

peg$SyntaxError.buildMessage = function(expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
        literal: function(expectation) {
          return "\"" + literalEscape(expectation.text) + "\"";
        },

        "class": function(expectation) {
          var escapedParts = "",
              i;

          for (i = 0; i < expectation.parts.length; i++) {
            escapedParts += expectation.parts[i] instanceof Array
              ? classEscape(expectation.parts[i][0]) + "-" + classEscape(expectation.parts[i][1])
              : classEscape(expectation.parts[i]);
          }

          return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
        },

        any: function(expectation) {
          return "any character";
        },

        end: function(expectation) {
          return "end of input";
        },

        other: function(expectation) {
          return expectation.description;
        }
      };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s
      .replace(/\\/g, '\\\\')
      .replace(/"/g,  '\\"')
      .replace(/\0/g, '\\0')
      .replace(/\t/g, '\\t')
      .replace(/\n/g, '\\n')
      .replace(/\r/g, '\\r')
      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
  }

  function classEscape(s) {
    return s
      .replace(/\\/g, '\\\\')
      .replace(/\]/g, '\\]')
      .replace(/\^/g, '\\^')
      .replace(/-/g,  '\\-')
      .replace(/\0/g, '\\0')
      .replace(/\t/g, '\\t')
      .replace(/\n/g, '\\n')
      .replace(/\r/g, '\\r')
      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = new Array(expected.length),
        i, j;

    for (i = 0; i < expected.length; i++) {
      descriptions[i] = describeExpectation(expected[i]);
    }

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + " or " + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(", ")
          + ", or "
          + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
  }

  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$parse(input, options) {
  options = options !== void 0 ? options : {};

  var peg$FAILED = {},

      peg$startRuleFunctions = { schema: peg$parseschema },
      peg$startRuleFunction  = peg$parseschema,

      peg$c0 = function() {
        return implicityRef(data)
      },
      peg$c1 = function(tableData) {
        const { table, refs } = tableData;
        pushTable(table);
        pushRefs(refs)
      },
      peg$c2 = function(r) {
          pushRef(r);
        },
      peg$c3 = ",",
      peg$c4 = peg$literalExpectation(",", false),
      peg$c5 = function(fromTable, toTable, props) {
          const foreign = refactorForeign(createForeign(fromTable, toTable, props));
          return foreign;
        },
      peg$c6 = ":",
      peg$c7 = peg$literalExpectation(":", false),
      peg$c8 = function(columnName) { return ({ columnName }) },
      peg$c9 = function(primaryKey) { return ({ primaryKey }) },
      peg$c10 = function(r, value) {
        switch (r.toLowerCase()) {
          case 'on_delete':
            return {
              onDelete: value.split('_').join(' ')
            }
          case 'on_update':
            return {
              onUpdate: value.split('_').join(' ')
            }
        }
       },
      peg$c11 = function(name, body) {
          const table = ({
            name,
            fields: addPrimaryKey(body.fields),
            // index: _.union(...body.index)
          })
          return {
            table,
            refs: createRefFromTableWithReference(table, body.references)
          };
        },
      peg$c12 = function(fields) {
          return ({
            fields: fields.filter(field => field.isField).map(field => field.field),
            index: fields.filter(field => field.isIndex).map(field => field.index),
            references: fields.filter(field => field.isReferences).map(field => field.reference),
          });
        },
      peg$c13 = function(field) { return field },
      peg$c14 = function(reference) { return ({ reference, isReferences: true })},
      peg$c15 = function(field) { return ({ field, isField: true }) },
      peg$c16 = function(reference) {
          return reference;
        },
      peg$c17 = function(type, name) {
          return ({
            name: name,
            type: {type_name: type},
          })
        },
      peg$c18 = function(reference) { return reference },
      peg$c19 = "on_delete",
      peg$c20 = peg$literalExpectation("on_delete", true),
      peg$c21 = "on_update",
      peg$c22 = peg$literalExpectation("on_update", true),
      peg$c23 = peg$otherExpectation("add index"),
      peg$c24 = "add_index",
      peg$c25 = peg$literalExpectation("add_index", false),
      peg$c26 = peg$otherExpectation("schema define"),
      peg$c27 = "ActiveRecord::Schema.define",
      peg$c28 = peg$literalExpectation("ActiveRecord::Schema.define", false),
      peg$c29 = peg$otherExpectation("create table"),
      peg$c30 = "create_table",
      peg$c31 = peg$literalExpectation("create_table", true),
      peg$c32 = peg$otherExpectation("do |t|"),
      peg$c33 = peg$otherExpectation("index"),
      peg$c34 = ".index",
      peg$c35 = peg$literalExpectation(".index", false),
      peg$c36 = peg$otherExpectation("references"),
      peg$c37 = ".references",
      peg$c38 = peg$literalExpectation(".references", false),
      peg$c39 = peg$otherExpectation("add foreign key"),
      peg$c40 = "add_foreign_key",
      peg$c41 = peg$literalExpectation("add_foreign_key", true),
      peg$c42 = peg$otherExpectation("column"),
      peg$c43 = "column",
      peg$c44 = peg$literalExpectation("column", false),
      peg$c45 = peg$otherExpectation("primary key"),
      peg$c46 = "primary_key",
      peg$c47 = peg$literalExpectation("primary_key", false),
      peg$c48 = "version",
      peg$c49 = peg$literalExpectation("version", false),
      peg$c50 = "do",
      peg$c51 = peg$literalExpectation("do", false),
      peg$c52 = "end",
      peg$c53 = peg$literalExpectation("end", false),
      peg$c54 = peg$otherExpectation("lambda function"),
      peg$c55 = "=>",
      peg$c56 = peg$literalExpectation("=>", false),
      peg$c57 = "->",
      peg$c58 = peg$literalExpectation("->", false),
      peg$c59 = /^[^"\n]/,
      peg$c60 = peg$classExpectation(["\"", "\n"], true, false),
      peg$c61 = function(c) { return c.join("") },
      peg$c62 = /^[^'\n]/,
      peg$c63 = peg$classExpectation(["'", "\n"], true, false),
      peg$c64 = ".",
      peg$c65 = peg$literalExpectation(".", false),
      peg$c66 = peg$anyExpectation(),
      peg$c67 = function() {return text()},
      peg$c68 = /^[0-9]/i,
      peg$c69 = peg$classExpectation([["0", "9"]], false, true),
      peg$c70 = peg$otherExpectation("letter, number or underscore"),
      peg$c71 = /^[a-z0-9_.]/i,
      peg$c72 = peg$classExpectation([["a", "z"], ["0", "9"], "_", "."], false, true),
      peg$c73 = peg$otherExpectation("comment line"),
      peg$c74 = "#",
      peg$c75 = peg$literalExpectation("#", false),
      peg$c76 = peg$otherExpectation("whatever"),
      peg$c77 = /^[^\t\r\n]/,
      peg$c78 = peg$classExpectation(["\t", "\r", "\n"], true, false),
      peg$c79 = "'",
      peg$c80 = peg$literalExpectation("'", false),
      peg$c81 = "\"",
      peg$c82 = peg$literalExpectation("\"", false),
      peg$c83 = "|",
      peg$c84 = peg$literalExpectation("|", false),
      peg$c85 = peg$otherExpectation("comment"),
      peg$c86 = "//",
      peg$c87 = peg$literalExpectation("//", false),
      peg$c88 = /^[^\n]/,
      peg$c89 = peg$classExpectation(["\n"], true, false),
      peg$c90 = peg$otherExpectation("newline"),
      peg$c91 = "\r\n",
      peg$c92 = peg$literalExpectation("\r\n", false),
      peg$c93 = "\n",
      peg$c94 = peg$literalExpectation("\n", false),
      peg$c95 = peg$otherExpectation("whitespace"),
      peg$c96 = /^[ \t\r\n\r]/,
      peg$c97 = peg$classExpectation([" ", "\t", "\r", "\n", "\r"], false, false),
      peg$c98 = " ",
      peg$c99 = peg$literalExpectation(" ", false),

      peg$currPos          = 0,
      peg$savedPos         = 0,
      peg$posDetailsCache  = [{ line: 1, column: 1 }],
      peg$maxFailPos       = 0,
      peg$maxFailExpected  = [],
      peg$silentFails      = 0,

      peg$result;

  if ("startRule" in options) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location
    );
  }

  function error(message, location) {
    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)

    throw peg$buildSimpleError(message, location);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$anyExpectation() {
    return { type: "any" };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos], p;

    if (details) {
      return details;
    } else {
      p = pos - 1;
      while (!peg$posDetailsCache[p]) {
        p--;
      }

      details = peg$posDetailsCache[p];
      details = {
        line:   details.line,
        column: details.column
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;
      return details;
    }
  }

  function peg$computeLocation(startPos, endPos) {
    var startPosDetails = peg$computePosDetails(startPos),
        endPosDetails   = peg$computePosDetails(endPos);

    return {
      start: {
        offset: startPos,
        line:   startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line:   endPosDetails.line,
        column: endPosDetails.column
      }
    };
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) { return; }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(
      peg$SyntaxError.buildMessage(expected, found),
      expected,
      found,
      location
    );
  }

  function peg$parseschema() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseline_rule();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parseline_rule();
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c0();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseline_rule() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsewhitespace();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsewhitespace();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parserule();
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsecomment_line();
      if (s0 === peg$FAILED) {
        s0 = peg$parseend_line();
        if (s0 === peg$FAILED) {
          s0 = peg$parse__();
        }
      }
    }

    return s0;
  }

  function peg$parserule() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsecreate_table_syntax();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c1(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseadd_foreign_key_syntax();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c2(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$parseother_class_prop();
      }
    }

    return s0;
  }

  function peg$parseadd_foreign_key_syntax() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsesp();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsesp();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseadd_foreign_key();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parsesp();
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parsesp();
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsename();
          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 44) {
              s5 = peg$c3;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c4); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parsesp();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parsesp();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parsename();
                if (s7 !== peg$FAILED) {
                  s8 = [];
                  s9 = peg$parseadd_foreign_key_props_syntax();
                  while (s9 !== peg$FAILED) {
                    s8.push(s9);
                    s9 = peg$parseadd_foreign_key_props_syntax();
                  }
                  if (s8 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c5(s4, s7, s8);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseadd_foreign_key_props_syntax() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 44) {
      s1 = peg$c3;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c4); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsesp();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsesp();
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsecolumn();
        if (s3 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s4 = peg$c6;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c7); }
          }
          if (s4 !== peg$FAILED) {
            s5 = [];
            s6 = peg$parsesp();
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$parsesp();
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parsename();
              if (s6 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c8(s6);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 44) {
        s1 = peg$c3;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c4); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parsesp();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsesp();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseprimary_key();
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 58) {
              s4 = peg$c6;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c7); }
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parsesp();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parsesp();
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parsename();
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c9(s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 44) {
          s1 = peg$c3;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c4); }
        }
        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parsesp();
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parsesp();
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parsereferential_actions();
            if (s3 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 58) {
                s4 = peg$c6;
                peg$currPos++;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c7); }
              }
              if (s4 !== peg$FAILED) {
                s5 = [];
                s6 = peg$parsesp();
                while (s6 !== peg$FAILED) {
                  s5.push(s6);
                  s6 = peg$parsesp();
                }
                if (s5 !== peg$FAILED) {
                  s6 = peg$parsesymbol();
                  if (s6 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c10(s3, s6);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsecreate_table_syntax() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecreate_table();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsesp();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsesp();
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsename();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsewhateters();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseendline();
            if (s5 !== peg$FAILED) {
              s6 = peg$parsetable_body();
              if (s6 !== peg$FAILED) {
                s7 = peg$parseend_line();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c11(s3, s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_body() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsefield();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsefield();
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c12(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsefield() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsewhitespace();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsewhitespace();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsetable_field_syntax();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parsewhatever();
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parsewhatever();
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseendline();
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c13(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_field_syntax() {
    var s0, s1;

    s0 = peg$parsefield_index_syntax();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsefield_reference_syntax();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c14(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsefield_type_syntax();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c15(s1);
        }
        s0 = s1;
      }
    }

    return s0;
  }

  function peg$parsefield_index_syntax() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseindex();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsesp();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsesp();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsewhateters();
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefield_reference_syntax() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsereferences();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsesp();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsesp();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsereference_value();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c16(s3);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefield_type_syntax() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsefield_type();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsesp();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsesp();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsename();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c17(s1, s3);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsereference_value() {
    var s0, s1, s2;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 58) {
      s1 = peg$c6;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c7); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsevariable();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c18(s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsename();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c18(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsereferential_actions() {
    var s0;

    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c19) {
      s0 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c20); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 9).toLowerCase() === peg$c21) {
        s0 = input.substr(peg$currPos, 9);
        peg$currPos += 9;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c22); }
      }
    }

    return s0;
  }

  function peg$parseadd_index() {
    var s0, s1;

    peg$silentFails++;
    if (input.substr(peg$currPos, 9) === peg$c24) {
      s0 = peg$c24;
      peg$currPos += 9;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c25); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c23); }
    }

    return s0;
  }

  function peg$parseschema_define() {
    var s0, s1;

    peg$silentFails++;
    if (input.substr(peg$currPos, 27) === peg$c27) {
      s0 = peg$c27;
      peg$currPos += 27;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c28); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c26); }
    }

    return s0;
  }

  function peg$parsecreate_table() {
    var s0, s1;

    peg$silentFails++;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c30) {
      s0 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c31); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c29); }
    }

    return s0;
  }

  function peg$parseend_create_table() {
    var s0, s1, s2, s3, s4, s5, s6;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parsedo();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsesp();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsesp();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseabs();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsecharacter();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseabs();
            if (s5 !== peg$FAILED) {
              s6 = peg$parseendline();
              if (s6 !== peg$FAILED) {
                s1 = [s1, s2, s3, s4, s5, s6];
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c32); }
    }

    return s0;
  }

  function peg$parseindex() {
    var s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parsecharacter();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 6) === peg$c34) {
        s2 = peg$c34;
        peg$currPos += 6;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c35); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c33); }
    }

    return s0;
  }

  function peg$parsereferences() {
    var s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parsecharacter();
    if (s1 !== peg$FAILED) {
      if (input.substr(peg$currPos, 11) === peg$c37) {
        s2 = peg$c37;
        peg$currPos += 11;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c38); }
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c36); }
    }

    return s0;
  }

  function peg$parseadd_foreign_key() {
    var s0, s1;

    peg$silentFails++;
    if (input.substr(peg$currPos, 15).toLowerCase() === peg$c40) {
      s0 = input.substr(peg$currPos, 15);
      peg$currPos += 15;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c41); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c39); }
    }

    return s0;
  }

  function peg$parsecolumn() {
    var s0, s1;

    peg$silentFails++;
    if (input.substr(peg$currPos, 6) === peg$c43) {
      s0 = peg$c43;
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c44); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c42); }
    }

    return s0;
  }

  function peg$parseprimary_key() {
    var s0, s1;

    peg$silentFails++;
    if (input.substr(peg$currPos, 11) === peg$c46) {
      s0 = peg$c46;
      peg$currPos += 11;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c47); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c45); }
    }

    return s0;
  }

  function peg$parseversion() {
    var s0;

    if (input.substr(peg$currPos, 7) === peg$c48) {
      s0 = peg$c48;
      peg$currPos += 7;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c49); }
    }

    return s0;
  }

  function peg$parsedo() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c50) {
      s0 = peg$c50;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c51); }
    }

    return s0;
  }

  function peg$parseend() {
    var s0;

    if (input.substr(peg$currPos, 3) === peg$c52) {
      s0 = peg$c52;
      peg$currPos += 3;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c53); }
    }

    return s0;
  }

  function peg$parselambda_function() {
    var s0, s1;

    peg$silentFails++;
    if (input.substr(peg$currPos, 2) === peg$c55) {
      s0 = peg$c55;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c56); }
    }
    if (s0 === peg$FAILED) {
      if (input.substr(peg$currPos, 2) === peg$c57) {
        s0 = peg$c57;
        peg$currPos += 2;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c58); }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c54); }
    }

    return s0;
  }

  function peg$parseother_class_prop() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsevariable();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsewhateters();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseendline();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsename() {
    var s0;

    s0 = peg$parsedouble_quote_name();
    if (s0 === peg$FAILED) {
      s0 = peg$parsesingle_quote_name();
    }

    return s0;
  }

  function peg$parsedouble_quote_name() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsedouble_quote();
    if (s1 !== peg$FAILED) {
      s2 = [];
      if (peg$c59.test(input.charAt(peg$currPos))) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c60); }
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        if (peg$c59.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c60); }
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsedouble_quote();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c61(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesingle_quote_name() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsesingle_quote();
    if (s1 !== peg$FAILED) {
      s2 = [];
      if (peg$c62.test(input.charAt(peg$currPos))) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c63); }
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        if (peg$c62.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c63); }
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsesingle_quote();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c61(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesymbol() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 58) {
      s1 = peg$c6;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c7); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsecharacter();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsecharacter();
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c61(s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsevariable() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsecharacter();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parsecharacter();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c61(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsefield_type() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parsecharacter();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 46) {
        s2 = peg$c64;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c65); }
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parsecharacter();
        if (s4 !== peg$FAILED) {
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parsecharacter();
          }
        } else {
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c61(s3);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsenot_whitespace() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$currPos;
    peg$silentFails++;
    s2 = peg$parsewhitespace();
    peg$silentFails--;
    if (s2 === peg$FAILED) {
      s1 = void 0;
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      if (input.length > peg$currPos) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c66); }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c67();
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsenumber() {
    var s0;

    if (peg$c68.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c69); }
    }

    return s0;
  }

  function peg$parsecharacter() {
    var s0, s1;

    peg$silentFails++;
    if (peg$c71.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c72); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c70); }
    }

    return s0;
  }

  function peg$parseend_line() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsewhitespace();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsewhitespace();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseend();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseendline();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewhatever_line() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsewhitespace();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsewhitespace();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      s3 = peg$parsewhateters();
      if (s3 !== peg$FAILED) {
        s4 = peg$currPos;
        peg$silentFails++;
        s5 = peg$parseend();
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = void 0;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s3 = [s3, s4];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseendline();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecomment_line() {
    var s0, s1, s2, s3, s4;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsewhitespace();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsewhitespace();
    }
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 35) {
        s2 = peg$c74;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c75); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parsewhateters();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseendline();
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            s1 = [s1, s2, s3, s4];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c73); }
    }

    return s0;
  }

  function peg$parsewhateters() {
    var s0, s1;

    peg$silentFails++;
    s0 = [];
    if (peg$c77.test(input.charAt(peg$currPos))) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c78); }
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      if (peg$c77.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c78); }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c76); }
    }

    return s0;
  }

  function peg$parsewhatever() {
    var s0;

    if (peg$c77.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c78); }
    }

    return s0;
  }

  function peg$parsesingle_quote() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 39) {
      s0 = peg$c79;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c80); }
    }

    return s0;
  }

  function peg$parsedouble_quote() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 34) {
      s0 = peg$c81;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c82); }
    }

    return s0;
  }

  function peg$parse_() {
    var s0, s1;

    s0 = [];
    s1 = peg$parsecomment();
    if (s1 === peg$FAILED) {
      s1 = peg$parsewhitespace();
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = peg$parsecomment();
      if (s1 === peg$FAILED) {
        s1 = peg$parsewhitespace();
      }
    }

    return s0;
  }

  function peg$parse__() {
    var s0, s1;

    s0 = [];
    s1 = peg$parsecomment();
    if (s1 === peg$FAILED) {
      s1 = peg$parsewhitespace();
    }
    if (s1 !== peg$FAILED) {
      while (s1 !== peg$FAILED) {
        s0.push(s1);
        s1 = peg$parsecomment();
        if (s1 === peg$FAILED) {
          s1 = peg$parsewhitespace();
        }
      }
    } else {
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseabs() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 124) {
      s0 = peg$c83;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c84); }
    }

    return s0;
  }

  function peg$parseendline() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsesp();
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$parsesp();
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsenewline();
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecomment() {
    var s0, s1, s2;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c86) {
      s1 = peg$c86;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c87); }
    }
    if (s1 !== peg$FAILED) {
      if (peg$c88.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c89); }
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c85); }
    }

    return s0;
  }

  function peg$parsenewline() {
    var s0, s1;

    peg$silentFails++;
    if (input.substr(peg$currPos, 2) === peg$c91) {
      s0 = peg$c91;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c92); }
    }
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 10) {
        s0 = peg$c93;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c94); }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c90); }
    }

    return s0;
  }

  function peg$parsewhitespace() {
    var s0, s1;

    peg$silentFails++;
    if (peg$c96.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c97); }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c95); }
    }

    return s0;
  }

  function peg$parsesp() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 32) {
      s0 = peg$c98;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c99); }
    }

    return s0;
  }



    var pluralize = require('pluralize');
    var lodash = require('lodash');

    let data = {
      tables: [],
      refs: []
    }

    function pushTable(table) {
      if (data.tables.find(t => t.name == table.name)) {
        error("Duplicated table name");
      } else {
        const idField = table.fields.find(field => field.name === "id");
        if (!idField) {
          table.fields.unshift({
            name: "id",
            type: { type_name: "varchar" }
          });
        }
        data.tables.push(table);
      }
    }

    function addPrimaryKey(fields = [], props = []) {
      const primaryKey = props.find(prop => prop.name === 'primary_key');
      if (!primaryKey) return fields;
      if (fields.find(key => key.name === primaryKey.value)) {
        return fields.map(({ name, type}) => ({
          name, type,
          PK: primaryKey.value === field.name,
        }))
      }
      const newFields = [{
        name: primaryKey.value,
        type: { type_name: "varchar" },
        PK: true,
      }];
      return newFields.concat(fields);
    }

    function findTableByNameOrAlias(name) {
      const table = data.tables.find(t => t.name == name || t.alias == name);
      if (table === undefined) {
         error("Table " + name +" not found");
      }
      return table;
    }

    function isSameEndpoints (endpoint1, endpoint2) {
      return endpoint1.tableName == endpoint2.tableName && 
        lodash.isEqual(lodash.sortBy(endpoint1.fieldNames), lodash.sortBy(endpoint2.fieldNames))
    }

    function isSameEndpointsPairs (endpointsPair1, endpointsPair2) {
      return isSameEndpoints(endpointsPair1[0], endpointsPair2[0])
        && isSameEndpoints(endpointsPair1[1], endpointsPair2[1])
    }

    function isSameEndpointsRefs(ref1, ref2) {
       return isSameEndpointsPairs (ref1.endpoints, ref2.endpoints)
         || isSameEndpointsPairs(ref1.endpoints, ref2.endpoints.slice().reverse())
    }

    function pushRef(ref) {
      if (!ref) return;
      if (data.refs.find(p => isSameEndpointsRefs(p, ref))) {
        error("Duplicated references");
      }
      data.refs.push(ref);
    }
    function pushRefs(refs = []) {
      if (!refs || refs.length === 0) return
      for(let i = 0; i < refs.length; i += 1) {
        pushRef(refs[i]);
      }
    }
    function refactorForeign(ref) {
      // add relation
      const { tables } = data;
      const { endpoints } = ref;
      const fromTable = tables.find(table => table.name === endpoints[0].tableName)
      if (!fromTable) {
        // TODO: handle error
        // throw {
        //   message: `Table ${endpoints[0].table} not found`
        // }
        // return ref;
        return null;
      }
      const toTable = tables.find(table => table.name === endpoints[1].tableName)
      if (!toTable) {
        // TODO: handle error
        // throw {
        //   message: `Table ${endpoints[1].table} not found`
        // }
        // return ref;
        return null;
      }
      if (!endpoints[0].fieldNames) {
        const singleNameOfPrimaryTable = pluralize.singular(endpoints[1].tableName)
        const columnName = `${singleNameOfPrimaryTable}_id`;
        endpoints[0].fieldNames = [columnName];
        const columnField = fromTable.fields.find(field => field.name === columnName);
        if (!columnField) {
          // TODO: handle erro
          // throw {
          //   message: `Field ${columnName} not found in table ${endpoints[0].table}`
          // }
          // return ref;
          return null;
        }
        endpoints[0].fieldNames = [columnName];
      }
      if (!endpoints[1].fieldNames) {
        const primaryKey = 'id';
        endpoints[1].fieldNames = [primaryKey];
      }
      return ref;
    }

    function createForeign(fromTable, toTable, props) {
      const endpoints = ([{
        tableName: fromTable,
        relation: '1',
      },
      {
        tableName: toTable,
        relation: '1',
      }]);
      let refProp = {};
      for (let i = 0; i < props.length; i += 1) {
        const currentProp = props[i];
        if (currentProp.columnName) {
          endpoints[0].fieldNames = [currentProp.columnName];
        }
        if (currentProp.primaryKey) {
          endpoints[1].fieldNames = [currentProp.primaryKey];
        }
        if (currentProp.onDelete) {
          refProp = {
            ...refProp,
            onDelete: currentProp.onDelete
          }
        }
        if (currentProp.onUpdate) {
          refProp = {
            ...refProp,
            onUpdate: currentProp.onUpdate
          }
        }
      }
      return {
        name: `fk_rails_${fromTable}_${toTable}`,
        endpoints,
        ...refProp
      };
    }

    function createRefFromTableWithReference(table, references) {
      if (!references || references.length === 0) {
        return [];
      }
      const refs = [];
      for (let i = 0; i < references.length; i += 1) {
        const reference = references[i];
        const referenceTable = pluralize.plural(reference);
        const { tables } = data;

        const toTable = tables.find(table => table.name === referenceTable)

        if (!toTable) {
          continue;
        }
        // add field to table if not exists (`${reference}_id`)
        // auto add type of new field to be varchar if primaryKey not found
        const columnName = `${reference}_id`;
        const primaryKeyName = 'id';
        const column = table.fields.find(field => field.name === columnName);
        const primaryKey = toTable.fields.find(field => field.name === primaryKeyName);
        if (!column) {
          table.fields.push({
            name: columnName,
            type: { type_name: primaryKey ? primaryKey.type.type_name : 'varchar'},
          })
        }

        refs.push({
          name: `fk_rails_${table.name}_${referenceTable}`,
          endpoints: [
            {
              tableName: table.name,
              fieldNames: [columnName],
              relation: '1',
            },
            {
              tableName: referenceTable,
              fieldNames: [primaryKeyName],
              relation: '1',
            }
          ]
        })
      }
      return refs;
    }
    function implicityRef(data) {
      const { tables, refs } = data;
      const tableWithFieldName = tables.map(table => {
        const { name } = table;
        const singularName = pluralize.singular(name);
        return ({
          name,
          field: `${singularName}_id`
        });
      })
      for (let i = 0; i < tables.length; i += 1) {
        const table = tables[i];
        const { fields } = table;
        for (let j = 0; j < fields.length; j += 1) {
          const field = fields[j];
          const refWithTable = tableWithFieldName.find(table => table.field === field.name);
          if (refWithTable) {
            const newRef = ({
              name: `fk_rails_${table.name}_${refWithTable.name}`,
              endpoints: [
                {
                  tableName: table.name,
                  fieldNames: [field.name],
                  relation: '1',
                },
                {
                  tableName: refWithTable.name,
                  fieldNames: ['id'],
                  relation: '1',
                }
              ]
            });
            const duplicateRef = refs.find(ref => isSameEndpointsRefs(ref, newRef));
            if (!duplicateRef) {
              refs.push(newRef)
            }
          }
        }
      }
      return data;
    }



  peg$result = peg$startRuleFunction();

  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
    );
  }
}

module.exports = {
  SyntaxError: peg$SyntaxError,
  parse:       peg$parse
};
