1. Run `./gencrt.sh` or if you have your own certifications, move them to the main directory, the name is ca.pem, server.pem, server.key, client.pem and client.key.

    The server.pem and client.pem was generated by the same ca.pem in gencrt.sh.

    Server side needs ca.pem(to verify client.pem), server.pem, server.key

    Client side needs ca.pem(to verify server.pem), client.pem, client.key

    If you have two ca.pem to generate server.pem and client.pem respectively, client1.pem is generate by ca1.pem and client1.key, server2.pem is generate by ca2.pem and server2.key:

    Client side needs ca2.pem, client1.pem, client1.key.

    Server side needs ca1.pem, server2.pem, server2.key.

    Rename ca1.pem server2.pem server2.key to ca.pem server.pem server.key.

    Use ca2.pem in openssl s_client -CAfile option.

2. Compile and download
    - run `make menuconfig`
        - Modify SSID and PASSWORD under menu "Example Configuration".
        Make sure that the computer and ESP8266 are in the same local area network.
    - run `make flash monitor`

3. Find server ip address in ESP8266 UART log, such as:`ip:192.168.3.6,mask:255.255.255.0,gw:192.168.3.1`.

4. Run `openssl s_client -CAfile ca.pem -cert client.pem -key client.key -verify 1 -tls1_2 -host 192.168.3.6 -port 443` in ./main directory to start client on your PC and connect to ESP8266 server.

**ATTENTION**

**1. Make sure the free heap size larger than 30K.**

**2. Make sure the private key length larger than 2048.**

**3. Make sure the fragment size range is between 2048 and 16384.**
