# -*- coding: utf-8 -*-
# chatter/chatter/views.py

# HttpResponse pozwala zwracac proste wiadomości tekstowe
from django.http import HttpResponse
# render pozwala zwracac szablony
from django.shortcuts import render
# dodajemy nowe importy
from django.shortcuts import render, redirect
from django.contrib.auth import forms, authenticate, login, logout
from django.contrib.auth.models import User
from django.core.urlresolvers import reverse
# dodajemy nowe importy
from chatter.models import Message
from django.utils import timezone
from django.contrib.auth.decorators import login_required

def index(request):
    """Strona glowna aplikacji."""
    # tworzymy zmienną (słownik), zawierającą informacje o użytkowniku
    context = {'user': request.user}
    # zmienna context przekaujemy do szablonu index.html
    return render(request, 'chatter/index.html', context)

def my_login(request):
    """Logowanie uzytkownika w sytemie."""
    form = forms.AuthenticationForm() # ustawiamy formularz logowania

    if request.method == 'POST': # sprawdzamy, czy ktos probuje sie zalogowac
        # przypisujemy nadeslane dane do formularza logowania
        form = forms.AuthenticationForm(request, request.POST)
        # sprawdzamy poprawnosc formularza lub zwracamy informacje o bledzie
        if form.is_valid(): # jezeli wszystko jest ok – logujemy uzytkownika
            user = form.get_user()
            login(request, user)
            return redirect(reverse('index')) # przekierowujemy uzytkownika na strone glowna

    context = {'form': form} # ustawiamy zmienne przekazywane do templatki
    # renderujemy templatke logowania
    return render(request, 'chatter/login.html', context)

# pozostale widoki

# dekorator, ktory "chroni" nasz widok przed dostepem przez osoby niezalogowane, jezeli uzytkownik niezalogowany
# bedzie probowal odwiedzic ten widok, to zostanie przekierowany na strone logowania
@login_required(login_url='/login')
def messages(request):
    """Widok wiadomosci."""
    error = None

    # zadanie POST oznacza, ze ktos probuje dodac nowa wiadomosc w systemie
    if request.method == 'POST':
        text = request.POST.get('text', '') # pobieramy tresc przeslanej wiadomosci
        # sprawdzamy, czy nie jest ona dluzsza od 250 znakow:
        # – jezeli jest dluzsza, to zwracamy blad, jezeli jest krotsza lub rowna, to zapisujemy ja w systemie
        if not 0 < len(text) <= 250:
            error = u'Wiadomość nie może być pusta i musi mieć co najwyżej 250 znaków'
        else:
            # ustawiamy dane dla modelu Message
            msg = Message(text=text, pub_date=timezone.now(), user=request.user)
            msg.save() # zapisujemy nowa widomosc
            return redirect(reverse('messages')) # przekierowujemy na strone wiadomosci

    user = request.user # informacje o aktualnie zalogowanym uzytkowniku
    messages = Message.objects.all() # pobieramy wszystkie wiadomosci
    # ustawiamy zmienne przekazywane do szablonu
    context = {'user': user, 'messages': messages, 'error': error}
    # renderujemy templatke wiadomosci
    return render(request, 'chatter/messages.html', context)

