# Python Connector for Oracle #

Python Connector for Oracle is a connectivity solution for accessing Oracle
databases from Python applications. It fully implements the Python DB API 2.0
specification. The connector is distributed as a wheel package for Windows,
macOS, and Linux.

Direct connection

The connector enables you to establish a direct connection to Oracle from
a Python application via TCP/IP, eliminating the need for the database client
libraries. A direct connection increases the speed of data transmission
between the application and Oracle database server and streamlines
the deployment process since you don't have to distribute any client
libraries with the application.

Secure communication

## Connecting ##

To establish a connection to an Oracle database, import the connector and use
the `connect()` method with your connection parameters.

### Import the connector ###

First, import the Oracle connector module:

```
import devart.oracle as oracle
```

### Establish a connection ###

Call the `connect()` method and obtain a `connection` object.

```
my_connection = oracle.connect(
    Direct=True,    Host="your_server",    ServiceName="your_service_name",    UserName="your_username",    Password="your_password"
)
```

Replace the example values with your actual connection values.

## Querying data ##

Once connected to Oracle, you can execute SQL queries to retrieve data from
your Oracle database.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the `execute()` method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/oracle/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/oracle/activate-a-license.htm

## What's new ##

Python Connector for Oracle 1.3

- Added support for Python 3.14
- Added support for auto-login wallets
- Added support for the BOOLEAN data type in Oracle 23 and later
- Added support for passwords longer than 30 characters in the Direct mode for Oracle 23 and later
- Added support for the Bearer Token authentication when using an HTTP tunnel
- Improved query performance for obtaining a primary key
- Improved detection of the MERGE statement type in the Direct mode
