# Python Connector for SQL Server #

Python Connector for SQL Server is a connectivity solution for accessing SQL
Server databases from Python applications. It fully implements the Python DB
API 2.0 specification. The connector is distributed as a wheel package
for Windows, macOS, and Linux.

Direct connection

The connector enables you to establish a direct connection to SQL Server from
a Python application via TCP/IP, eliminating the need for the database client
library. A direct connection increases the speed of data transmission between
the application and SQL Server database server. It also streamlines
the deployment process since you don't have to distribute any client
libraries with the application.

Secure communication

## Connecting ##

To establish a connection to a SQL Server database, import the connector and
use the `connect()` method with your connection parameters.

### Import the connector ###

First, import the SQL Server connector module:

```
import devart.sqlserver
```

### Establish a connection ###

Connect to a database using the `connect()` module method and obtain a `connection` object.

You can connect using either mixed mode authentication and Windows authentication.

#### Mixed mode authentication ####

For mixed mode authentication, provide your server name, database, user ID, and password:

```
my_connection = devart.sqlserver.connect("Authentication=Windows;Server=your_server;Database=your_database")
```

Replace the example values with your actual server name, database, and database credentials.

#### Windows authentication ####

For Windows authentication, provide your server and database names. The connector will use your Windows account credentials:

```
my_connection = devart.sqlserver.connect("Authentication=Windows;Server=your_server;Database=your_database")
```

Replace the example values with your actual server and database names.

## Querying data ##

Once connected to SQL Server, you can execute SQL queries to retrieve data
from your SQL Server database.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the 

`execute()`

 method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/sqlserver/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/sqlserver/activate-a-license.htm

## What's new ##

Python Connector for SQL Server 1.3

- Added support for Python 3.14
- Added support for the Bearer Token authentication when using an HTTP tunnel
- Improved compatibility with Microsoft SQL Server 2000
