	
        .inesprg    1
        .ineschr    1
        .inesmir    1
        .inesmap    0

	.org $8000
	.bank 0

Start:
	
	
	lda #$70  ; The folowing instructions store some data in the
	sta $6000 ; RAM.
	lda #$CF
	sta $6001
	lda #$00
	sta $6005
	
	lda #%00001000
	sta $2000
	lda #%00011110
	sta $2001 

	lda #$3f
	sta $2006
	lda #$00
	sta $2006
	ldx #$00

loadpal:

	lda pallete, x ; loads pallete value into the Acummulator
	sta $2007	; writes the valeu to the pallete	
	inx
	cpx #$20	
	bne loadpal


text:               
	lda #$20
	sta $2006
	lda #$20
	sta $2006
	ldx #$20	

text2:               ; Draws the text part of the background
	lda map, x 
	sta $2007
	inx
	cpx #$3a
	bne text2
	ldx #$00

	lda #$20
	sta $2006
	lda #$43
	sta $2006
	ldx #$3c	

text3:		    ; Draws the text part of the background
	lda map, x
	sta $2007
	inx
	cpx #$4c
	bne text3
	ldx #$00


	lda #$23
	sta $2006
	lda #$60
	sta $2006
	ldx #$00	

background:      ; Draws the upper part of the floor

	lda map, x
	sta $2007
	inx
	cpx #$20
	bne background
	ldx #$00
	
background2:     ; Draws the lower part of the floor

	ldy map, x
	iny
	iny
	sty $2007		
	inx
	cpx #$20
	bne background2


	



do:     ; start of main loop 
	
	
	ldx #$00  ; loads the x register with zero for the delay routine
	jsr delay ; goto the delay sub routine

	jsr drawsprite ; goto to the drawsprite routine

	jsr resetjoy ; goto to the routine wich resets the joypad #1 status

	lda $4016 ; checks if "a" button is pressed
	bne jumpch2 ; goto jump routine if "a" is pressed

	lda $4016 ;	
	lda $4016 ;
	lda $4016 ;
	lda $4016 ;
	lda $4016 ;
	lda $4016 ; checks if left is pressed
	bne lft	  ; if left is pressed goto the routine for moving the sprite to the left
		
	lda $4016 ; checks if right is pressed
	bne rt    ; if right is pressed goto the routine for moving the sprite to the right

	jsr jumpch ; checks if sprite is jumping

	jmp do ; Jump to the begin of the main loop

resetjoy:
	
	lda #$01  ; Writing #$01 to $4016 (=joypad1) folowd by writing #$00 
	sta $4016 ; to $4016 resets status of joypad 1
	lda #$00
	sta $4016
	rts

jumpch2:          ; starts the jump of the sprite 
	ldx $6005
	cpx #$00
	beq jump1	
	cpx #$05
	beq jump1

jumpch:
	ldx $6005
	cpx #$10
	beq jump2
	ldx $6001
	cpx #$CF
	bne jump2
	rts
nnd:
	jmp do



jump1:
	ldx #$05
	stx $6005
	dec $6001
	ldx $6001
	cpx #$80
	beq set1
	jmp do	

jump2:
	inc $6001
	ldx $6001
	cpx #$CF
	beq set2
	jmp do	


set1:
	lda #$10
	sta $6005
	jmp do

set2:
	lda #$00
	sta $6005
	jmp do


	

lft:

	dec $6000 ; decrease $6000. $6000 holds the x coordinate of the sprite
	jsr jumpch ; check if sprite is jumping
	jmp do ; goto main loop
	
rt:


	inc $6000 ; increase $6000
	jsr jumpch ; check if sprite is jumping
	jmp do ; goto main loop

delay:
	nop ; This delay routine reapeats a serie of NOP's
	nop 
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	inx
	cpx #$FF 
	bne delay
	rts


drawsprite:
	
	lda #$00 
	sta $2003
	lda #$00
	sta $2003

	lda $6001 ; Y
	sta $2004
	lda #$04 ; tile nummer
	sta $2004	
	lda $%0000010 ; collor + artibytees
	sta $2004
	lda $6000 ; X
	sta $2004
	rts





pallete:		 
	 .db $32,$01,$06,$2A,$32,$03,$10,$00
	 .db $32,$38,$33,$3C,$32,$21,$26,$02
	 .db $32,$16,$12,$14,$32,$07,$17,$27
	 .db $32,$0B,$07,$2D,$32,$3A,$35,$31

map:
	.db $26,$27,$26,$27,$26,$27,$26,$27,$26,$27     ;Floor
	.db $26,$27,$26,$27,$26,$27,$26,$27,$26,$27
	.db $26,$27,$26,$27,$26,$27,$26,$27,$26,$27
	.db $26,$27,$00
	.db $00,$1d,$11,$12,$1c,$00,$12,$1c,$00,$0a    	;Text
	.db $00,$13,$1e,$16,$19,$12,$17,$10,$00,$1c
	.db $19,$1b,$12,$1d,$0e,$00,$00
	.db $0b,$22,$00,$2b,$2c,$2d,$2e,$00,$04,$2a,$07
	.db $2a,$02,$24,$24,$02

	.bank 1
	.org	$FFFA
	.dw		0 ;(NMI_Routine)
	.dw		Start ;(Reset_Routine)
	.dw		0 ;(IRQ_Routine)

	.bank 2
	.org	$0000
	.incbin "jumpy.chr"



               



